%% Figure that shows the assigned colour to each participant
clear,clc,close all

%% Variables initialization
FS = 16;
MS = 12;


%% Figure
figure('PaperSize',[10 20]),hold on,box off
% Kelly's 22 colours of maximum constrast
cmap = ['#F2F3F4';'#222222';'#F3C300';'#875692';'#F38400';'#A1CAF1';...
    '#BE0032';'#C2B280';'#848482';'#008856';'#E68FAC';'#0067A5';...
    '#F99379';'#604E97';'#F6A600';'#B3446C';'#DCD300';'#882D17';...
    '#8DB600';'#654522';'#E25822';'#2B3D26'];
cmap = cmap([2:16 18:22],:);    % Selection of 20 adequate colours

for k=1:20
    plot(0.5,21-k,'o','MarkerSize',MS,'MarkerFaceColor',cmap(k,:),...
        'MarkerEdgeColor','w')
    text(0.8,21-k,sprintf('Participant %d',k),'FontSize',FS)
end
axis([0 2.5 0 21])
set(gca,'visible','off')

orient tall
print('-dpng','-r200','Figure_A7')
close all