%% Script that generates Figure 1 - Audiogram
clear,clc,close all

%% Variables initialization
T = readtable('../Metadata.xlsx');
MD.Audiometry = [T.LA250 T.LA500 T.LA1000 T.LA2000 T.LA3000 T.LA4000 ...
    T.LA6000 T.LA8000 T.RA250 T.RA500 T.RA1000 T.RA2000 T.RA3000 T.RA4000 ...
    T.RA6000 T.RA8000];
f = [250,500,1000,2000,3000,4000,6000,8000]*1e-3;
FS = 12;

%% Stats
Age_mean = mean(T.Age);
Age_std = std(T.Age);
fprintf(sprintf('Mean age = %1.1f. STD age = %1.1f.\n\n',Age_mean,Age_std))

%% Figure generation
figure('PaperSize',[20 8])

subplot('Position',[0.05 0.16 0.42 0.76])
boxplot(MD.Audiometry(:,1:8),f,'plotstyle','compact','whisker',100,'labelorientation',...
    'horizontal','positions',f,'color','k')
box on,grid on,hold on
set(gca,'xscale','log')
set(gca,'Ydir','reverse')
set(gca,'ytick',0:20:100,'FontSize',FS-1)
set(gca,'xtick',[0:0.1:0.9 1:9 10 20],'xticklabel',{'','','0.2','','','0.5',...
    '','','','','1','2','','4','','','','8','','','20'},'xticklabelrotation',0)
axis([0.15 10 0 100])
xlabel('Frequency (kHz)','FontSize',FS)
ylabel('Hearing threshold (dB)','FontSize',FS)
title('Left ear','FontSize',FS)

subplot('Position',[0.56 0.16 0.42 0.76]),box on,grid on,hold on
boxplot(MD.Audiometry(:,9:16),f,'plotstyle','compact','whisker',100,'labelorientation',...
    'horizontal','positions',f,'color','k')
box on,grid on,hold on
set(gca,'xscale','log')
set(gca,'Ydir','reverse')
set(gca,'ytick',0:20:100,'FontSize',FS-1)
set(gca,'xtick',[0:0.1:0.9 1:9 10 20],'xticklabel',{'','','0.2','','','0.5',...
    '','','','','1','2','','4','','','','8','','','20'},'xticklabelrotation',0)
axis([0.15 10 0 100])
xlabel('Frequency (kHz)','FontSize',FS)
title('Right ear','FontSize',FS)

orient tall
print('-dpng','-r600','Figure1')
print('-depsc','Figure1')
close all