import re
import subprocess
import os
import timeit


def get_solver_dir_path():
    return (r'C:\Users\Éles András OFF\AppData\Local\Apps\2.0\X7DC8DP5.DV7\PE01P6DT.1K0'
            r'\p-gr..tion_0000000000000000_0005.0002_1962c93fb345a71a\Solver\PNS')


def get_solver_executable_name():
    return r'pgraph_solver.exe'


def run_solver(problem,
               in_file='Graph.in',
               out_file='Graph.out',
               algorithm='INSIDEOUT',
               solution_count=1,
               discard_stdout=False,
               discard_stderr=False):
    cwd = os.getcwd()
    temp_path = os.path.join(cwd, 'temp')
    assert os.path.isdir(temp_path), f'no temp directory'
    in_path = os.path.join(temp_path, in_file)
    out_path = os.path.join(temp_path, out_file)
    assert problem, f'missing problem'
    in_file_text = problem.get_problem_text()
    with open(in_path, "wt") as file:
        file.write(in_file_text)
    allowed_algorithms = ['MSG', 'SSG', 'SSGLP', 'INSIDEOUT', 'CBC', 'GLPK']
    assert algorithm in allowed_algorithms, f'algorithm not supported'
    assert isinstance(solution_count, int), f'solution_count is not an int'
    assert solution_count >= 1, f'solution_count must be positive'
    solver_dir_path = get_solver_dir_path()
    solver_executable_name = get_solver_executable_name()
    solver_path = os.path.join(solver_dir_path, solver_executable_name)
    other_args = {
        'cwd': solver_dir_path,
    }
    if discard_stdout:
        other_args['stdout'] = subprocess.DEVNULL
    if discard_stderr:
        other_args['stderr'] = subprocess.DEVNULL
    time_start = timeit.default_timer()
    subprocess.call([solver_path, algorithm, in_path, out_path, str(solution_count)], **other_args)
    time_end = timeit.default_timer()
    time_elapsed = time_end - time_start
    with open(out_path, 'rt') as file:
        out_file_text = file.read()
    money_unit = problem.get('money_unit')
    time_unit = problem.get('time_unit')
    objective_regex = r'Total\s+annual\s+cost\s*=\s+(\S+)\s+' + str(money_unit) + '/' + str(time_unit)
    m = re.search(objective_regex, out_file_text)
    objective = m.group(1) if m else None
    return {
        'in_file_text': in_file_text,
        'out_file_text': out_file_text,
        'objective': objective,
        'time_elapsed': time_elapsed,
    }
