import pns


def get_problem_a():
    # graph in many pieces, for testing basic functionality, obj=-14376.5
    problem = pns.Problem()
    problem.set('file_name', 'Sample_Problem_A')

    problem.add_raw('material_1', price=10)
    problem.add_raw('material_2', flow_rate_upper_bound=2000)
    problem.add_product('material_3', flow_rate_lower_bound=10)
    problem.add_product('material_4', price=300, flow_rate_lower_bound=10)
    problem.add_product('material_5', price=1, flow_rate_lower_bound=1700)
    problem.add_inter('material_6')
    problem.add_product('material_7', price=2, flow_rate_lower_bound=13)
    problem.add_product('material_8', flow_rate_lower_bound=13)
    problem.add_raw('material_9')
    problem.add_op_unit('operatingunit_1', capacity_upper_bound=3456789, fix_cost=3.1, proportional_cost=4.2)
    problem.add_op_unit('operatingunit_2')
    problem.add_op_unit('operatingunit_3')
    problem.add_op_unit('operatingunit_4')
    problem.add_op_unit('operatingunit_5', proportional_cost=222)
    problem.add_op_unit('operatingunit_6')
    problem.add_op_unit('operatingunit_7')
    problem.add_in('material_1', 'operatingunit_1', 23)
    problem.add_in('material_2', 'operatingunit_1', 40)
    problem.add_out('operatingunit_1', 'material_3', 7)
    problem.add_out('operatingunit_1', 'material_4', 8)
    problem.add_in('material_2', 'operatingunit_2')
    problem.add_out('operatingunit_2', 'material_5')
    problem.add_in('material_2', 'operatingunit_3')
    problem.add_out('operatingunit_3', 'material_6')
    problem.add_in('material_6', 'operatingunit_4', 77)
    problem.add_out('operatingunit_4', 'material_7', 77)
    problem.add_out('operatingunit_5', 'material_8')
    problem.add_in('material_9', 'operatingunit_6')
    return problem


def get_problem_b():
    # graph with many solution structures, obj=-8267
    problem = pns.Problem()
    problem.set('file_name', 'Sample_Problem_B')
    problem.add_raw('material_1', price=50, flow_rate_upper_bound=300)
    problem.add_inter('material_2')
    problem.add_inter('material_3', flow_rate_lower_bound=20)
    problem.add_inter('material_4')
    problem.add_inter('material_5')
    problem.add_product('material_6', price=100)
    problem.add_raw('material_7', price=3, flow_rate_upper_bound=120)
    problem.add_product('material_8', price=1, flow_rate_lower_bound=100)
    problem.add_op_unit('operatingunit_1', fix_cost=31, proportional_cost=42,
                        capacity_lower_bound=1, capacity_upper_bound=30)
    problem.add_op_unit('operatingunit_2', fix_cost=31, proportional_cost=42)
    problem.add_op_unit('operatingunit_3', proportional_cost=1)
    problem.add_op_unit('operatingunit_4', proportional_cost=1)
    problem.add_op_unit('operatingunit_5', fix_cost=1)
    problem.add_op_unit('operatingunit_6')
    problem.add_op_unit('operatingunit_7', proportional_cost=5)
    problem.add_op_unit('operatingunit_8', proportional_cost=6)
    problem.add_in('material_1', 'operatingunit_1')
    problem.add_in('material_1', 'operatingunit_2')
    problem.add_out('operatingunit_1', 'material_2')
    problem.add_out('operatingunit_1', 'material_3')
    problem.add_out('operatingunit_2', 'material_3')
    problem.add_out('operatingunit_2', 'material_4')
    problem.add_in('material_2', 'operatingunit_3')
    problem.add_in('material_3', 'operatingunit_4')
    problem.add_in('material_4', 'operatingunit_5')
    problem.add_out('operatingunit_3', 'material_5')
    problem.add_out('operatingunit_4', 'material_5')
    problem.add_out('operatingunit_5', 'material_5', flow=3)
    problem.add_in('material_5', 'operatingunit_6')
    problem.add_out('operatingunit_6', 'material_6')
    problem.add_in('material_7', 'operatingunit_7')
    problem.add_in('material_7', 'operatingunit_8')
    problem.add_in('material_7', 'operatingunit_5')  # connects the two parts
    problem.add_out('operatingunit_7', 'material_8')
    problem.add_out('operatingunit_8', 'material_8')
    return problem
