import re

import problem_sample
import problem_badzell
import runner


def perform_test(problem, in_file, out_file, algorithm):
    problem_name = problem.get('file_name')
    print(f'Call for "{problem_name}", with algorithm "{algorithm}".')
    problem.check_structure()
    problem.print_stats('stats', 'issues')
    results = runner.run_solver(problem,
                                in_file=in_file,
                                out_file=out_file,
                                algorithm=algorithm,
                                solution_count=1,
                                discard_stdout=True)
    print('Algorithm: {}'.format(algorithm))
    print('Objective: {}'.format(results['objective']))
    print('Elapsed: {} seconds'.format(round(results['time_elapsed'], 4)))
    return results


def do_tests():
    problem_set = {
        'SA': problem_sample.get_problem_a(),
        'SB': problem_sample.get_problem_b(),
        'BadZell': problem_badzell.get_problem(),
    }
    for problem_name in problem_set:
        problem = problem_set[problem_name]
        in_file = 'Graph_{}.in'.format(problem_name)
        out_file = 'Graph_{}.out'.format(problem_name)
        results = perform_test(problem, in_file, out_file, 'INSIDEOUT')
        if problem_name == 'BadZell':
            def sum_it(regex_iterator, group_id=1):
                return sum([float(x.group(group_id)) for x in regex_iterator])
            out_file_text = results['out_file_text']
            # sum of raw material costs:
            substrate_cost = sum_it(re.finditer(r'substrate_available_FM_\S+\s\((\S+)\sEUR/y\):', out_file_text))
            print(f'Substrate cost: {substrate_cost}')
            # sum of operating unit costs:
            transport_cost = sum_it(re.finditer(r'\*op_transport_substrates_\S+\s\((\S+)\sEUR/y\):', out_file_text))
            print(f'Transport cost: {transport_cost}')
        print()


if __name__ == '__main__':
    do_tests()
