# Set of raw materials

set raw_materials := {"material_1", "material_7"

};



# Set of intermediates

set intermediates := {"material_2", "material_3", "material_4", "material_5"

};



# Set of required or potential products

set products := {"material_6", "material_8"

};



# Set of all materials

set materials := raw_materials union intermediates union products;



# Lower bounds of materials flow rates

param flow_rate_lower_bound[raw_materials union products] := 

   <"material_8"> 100
   default 0;



#  Upper bounds of materials flow rates

param flow_rate_upper_bound[materials] := 

   <"material_1"> 300, 

   <"material_2"> 1e+009, 

   <"material_3"> 1e+009, 

   <"material_4"> 1e+009, 

   <"material_5"> 1e+009,

   <"material_6"> 1e+009, 

   <"material_7"> 120, 

   <"material_8"> 1e+009
   default 0;



# Prices of raw materials and products

param price[raw_materials union products] := 

   <"material_1"> 50, 

   <"material_6"> 100, 

   <"material_7"> 3, 

   <"material_8"> 1
   default 0;



# Set of operating units

set operating_units := {"operatingunit_1", "operatingunit_2", "operatingunit_3", "operatingunit_4", "operatingunit_5",

   "operatingunit_6", "operatingunit_7", "operatingunit_8"

};



# Set of operating units in solution#1



# Lower bounds of operating units capacities

param capacity_lower_bound[operating_units] := 

   <"operatingunit_1"> 1, 

   <"operatingunit_2"> 0, 

   <"operatingunit_3"> 0, 

   <"operatingunit_4"> 0, 

   <"operatingunit_5"> 0,

   <"operatingunit_6"> 0, 

   <"operatingunit_7"> 0, 

   <"operatingunit_8"> 0
   default 0;



# Upper bounds of operating units capacities

param capacity_upper_bound[operating_units] := 

   <"operatingunit_1"> 30, 

   <"operatingunit_2"> 1e+009, 

   <"operatingunit_3"> 1e+009, 

   <"operatingunit_4"> 1e+009, 

   <"operatingunit_5"> 1e+009,

   <"operatingunit_6"> 1e+009, 

   <"operatingunit_7"> 1e+009, 

   <"operatingunit_8"> 1e+009
   default 0;



# Fix costs of operating units

param fix_cost[operating_units] := 

   <"operatingunit_1"> 31, 

   <"operatingunit_2"> 31, 

   <"operatingunit_3"> 0, 

   <"operatingunit_4"> 0, 

   <"operatingunit_5"> 1,

   <"operatingunit_6"> 0, 

   <"operatingunit_7"> 0, 

   <"operatingunit_8"> 0
   default 0;



# Proportional costs of operating units

param proportional_cost[operating_units] := 

   <"operatingunit_1"> 42, 

   <"operatingunit_2"> 42, 

   <"operatingunit_3"> 1, 

   <"operatingunit_4"> 1, 

   <"operatingunit_5"> 0,

   <"operatingunit_6"> 0, 

   <"operatingunit_7"> 5, 

   <"operatingunit_8"> 6
   default 0;



# Input and output flow rates of materials to operating units

param material_to_operating_unit_flow_rates[materials*operating_units] := 



 # operatingunit_1:

    <"material_1", "operatingunit_1"> -1,

    <"material_2", "operatingunit_1"> 1,

    <"material_3", "operatingunit_1"> 1,

 # operatingunit_2:

    <"material_1", "operatingunit_2"> -1,

    <"material_3", "operatingunit_2"> 1,

    <"material_4", "operatingunit_2"> 1,

 # operatingunit_3:

    <"material_2", "operatingunit_3"> -1,

    <"material_5", "operatingunit_3"> 1,

 # operatingunit_4:

    <"material_3", "operatingunit_4"> -1,

    <"material_5", "operatingunit_4"> 1,

 # operatingunit_5:

    <"material_4", "operatingunit_5"> -1,

    <"material_5", "operatingunit_5"> 3,

    <"material_7", "operatingunit_5"> -1,

 # operatingunit_6:

    <"material_5", "operatingunit_6"> -1,

    <"material_6", "operatingunit_6"> 1,

 # operatingunit_7:

    <"material_7", "operatingunit_7"> -1,

    <"material_8", "operatingunit_7"> 1,

 # operatingunit_8:

    <"material_7", "operatingunit_8"> -1,

    <"material_8", "operatingunit_8"> 1

    default 0;



var exist[operating_units] binary;

var size[<o> in operating_units] real >= 0 <= capacity_upper_bound[o];

minimize cost:

   (sum<o> in operating_units: size[o]*

      (proportional_cost[o] -

       sum<m> in (raw_materials union products):

          price[m]*material_to_operating_unit_flow_rates[m, o]

      )

   ) +

   (sum<o> in operating_units:

      exist[o] * fix_cost[o]);

subto size_ub:

   forall <o> in operating_units do

      size[o] <= exist[o] * capacity_upper_bound[o];

subto size_lb:

   forall <o> in operating_units do

      size[o] >= exist[o] * capacity_lower_bound[o];

subto raw_lb:

   forall <r> in raw_materials do

      sum<o> in operating_units: -1 * material_to_operating_unit_flow_rates[r, o] * size[o] >= flow_rate_lower_bound[r];

subto inter_lb:

   forall <i> in intermediates do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[i, o] * size[o] >= 0;

subto prod_lb:

   forall <p> in products do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[p, o] * size[o] >= flow_rate_lower_bound[p];

subto raw_ub:

   forall <r> in raw_materials do

      sum<o> in operating_units: -1 * material_to_operating_unit_flow_rates[r, o] * size[o] <= flow_rate_upper_bound[r];

subto inter_ub:

   forall <i> in intermediates do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[i, o] * size[o] <= flow_rate_upper_bound[i];

subto prod_ub:

   forall <p> in products do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[p, o] * size[o] <= flow_rate_upper_bound[p];

