# Set of raw materials

set raw_materials := {"heat_purchase", "substrate_available_FM_L1_Corn", "substrate_available_FM_L1_Grass", "substrate_available_FM_L1_Inter", "substrate_available_FM_L1_Manure",

   "substrate_available_FM_L2_Corn", "substrate_available_FM_L2_Grass", "substrate_available_FM_L2_Inter", "substrate_available_FM_L2_Manure", "substrate_available_FM_L3_Corn",

   "substrate_available_FM_L3_Grass", "substrate_available_FM_L3_Inter", "substrate_available_FM_L3_Manure", "substrate_available_FM_L4_Corn", "substrate_available_FM_L4_Grass",

   "substrate_available_FM_L4_Inter", "substrate_available_FM_L4_Manure", "substrate_available_FM_L5_Corn", "substrate_available_FM_L5_Grass", "substrate_available_FM_L5_Inter",

   "substrate_available_FM_L5_Manure", "substrate_available_FM_L6_Corn", "substrate_available_FM_L6_Grass", "substrate_available_FM_L6_Inter", "substrate_available_FM_L6_Manure",

   "substrate_available_FM_L7_Corn", "substrate_available_FM_L7_Grass", "substrate_available_FM_L7_Inter", "substrate_available_FM_L7_Manure", "substrate_available_FM_L8_Corn",

   "substrate_available_FM_L8_Grass", "substrate_available_FM_L8_Inter", "substrate_available_FM_L8_Manure"

};



# Set of intermediates

set intermediates := {"biogas_CENTER", "biogas_Loc1", "biogas_Loc2", "biogas_Loc3", "biogas_pipe_availability_material_Pipe1",

   "biogas_pipe_availability_material_Pipe2", "biogas_pipe_availability_material_Pipe3to1", "capacity_in_Loc1_K160_No0", "capacity_in_Loc1_K160_No1", "capacity_in_Loc1_K250_No0",

   "capacity_in_Loc1_K250_No1", "capacity_in_Loc1_K500_No0", "capacity_in_Loc1_K500_No1", "capacity_in_Loc1_K80_No0", "capacity_in_Loc1_K80_No1",

   "capacity_in_Loc2_K160_No0", "capacity_in_Loc2_K160_No1", "capacity_in_Loc2_K250_No0", "capacity_in_Loc2_K250_No1", "capacity_in_Loc2_K500_No0",

   "capacity_in_Loc2_K500_No1", "capacity_in_Loc2_K80_No0", "capacity_in_Loc2_K80_No1", "capacity_in_Loc3_K160_No0", "capacity_in_Loc3_K160_No1",

   "capacity_in_Loc3_K250_No0", "capacity_in_Loc3_K250_No1", "capacity_in_Loc3_K500_No0", "capacity_in_Loc3_K500_No1", "capacity_in_Loc3_K80_No0",

   "capacity_in_Loc3_K80_No1", "capacity_out_Loc1_K160_No0", "capacity_out_Loc1_K160_No1", "capacity_out_Loc1_K250_No0", "capacity_out_Loc1_K250_No1",

   "capacity_out_Loc1_K500_No0", "capacity_out_Loc1_K500_No1", "capacity_out_Loc1_K80_No0", "capacity_out_Loc1_K80_No1", "capacity_out_Loc2_K160_No0",

   "capacity_out_Loc2_K160_No1", "capacity_out_Loc2_K250_No0", "capacity_out_Loc2_K250_No1", "capacity_out_Loc2_K500_No0", "capacity_out_Loc2_K500_No1",

   "capacity_out_Loc2_K80_No0", "capacity_out_Loc2_K80_No1", "capacity_out_Loc3_K160_No0", "capacity_out_Loc3_K160_No1", "capacity_out_Loc3_K250_No0",

   "capacity_out_Loc3_K250_No1", "capacity_out_Loc3_K500_No0", "capacity_out_Loc3_K500_No1", "capacity_out_Loc3_K80_No0", "capacity_out_Loc3_K80_No1",

   "collected_heat_loss_Pipe1", "collected_heat_loss_Pipe2", "collected_heat_loss_Pipe3to1", "electricity_K160", "electricity_K250",

   "electricity_K500", "electricity_K80", "heat_balance_CENTER", "heat_balance_Loc1", "heat_balance_Loc2",

   "heat_balance_Loc3", "heat_pipe_availability_material_Loc1_Pipe1", "heat_pipe_availability_material_Loc2_Pipe2", "heat_pipe_availability_material_Loc3_Pipe1", "heat_pipe_availability_material_Loc3_Pipe3to1",

   "heat_sent_Loc1", "heat_sent_Loc2", "heat_sent_Loc3", "min_ratio_Loc1_K160_No0_Manure", "min_ratio_Loc1_K160_No1_Manure",

   "min_ratio_Loc1_K250_No0_Manure", "min_ratio_Loc1_K250_No1_Manure", "min_ratio_Loc1_K500_No0_Manure", "min_ratio_Loc1_K500_No1_Manure", "min_ratio_Loc1_K80_No0_Manure",

   "min_ratio_Loc1_K80_No1_Manure", "min_ratio_Loc2_K160_No0_Manure", "min_ratio_Loc2_K160_No1_Manure", "min_ratio_Loc2_K250_No0_Manure", "min_ratio_Loc2_K250_No1_Manure",

   "min_ratio_Loc2_K500_No0_Manure", "min_ratio_Loc2_K500_No1_Manure", "min_ratio_Loc2_K80_No0_Manure", "min_ratio_Loc2_K80_No1_Manure", "min_ratio_Loc3_K160_No0_Manure",

   "min_ratio_Loc3_K160_No1_Manure", "min_ratio_Loc3_K250_No0_Manure", "min_ratio_Loc3_K250_No1_Manure", "min_ratio_Loc3_K500_No0_Manure", "min_ratio_Loc3_K500_No1_Manure",

   "min_ratio_Loc3_K80_No0_Manure", "min_ratio_Loc3_K80_No1_Manure", "silo_plate_availability_material_Loc1", "silo_plate_availability_material_Loc2", "silo_plate_availability_material_Loc3",

   "substrate_feed_Loc1_Corn", "substrate_feed_Loc1_Grass", "substrate_feed_Loc1_Inter", "substrate_feed_Loc1_Manure", "substrate_feed_Loc2_Corn",

   "substrate_feed_Loc2_Grass", "substrate_feed_Loc2_Inter", "substrate_feed_Loc2_Manure", "substrate_feed_Loc3_Corn", "substrate_feed_Loc3_Grass",

   "substrate_feed_Loc3_Inter", "substrate_feed_Loc3_Manure", "transformer_availability_material"

};



# Set of required or potential products

set products := {"revenue"

};



# Set of all materials

set materials := raw_materials union intermediates union products;



# Lower bounds of materials flow rates

param flow_rate_lower_bound[raw_materials union products] := 

   <"revenue"> 0 
   default 0;



#  Upper bounds of materials flow rates

param flow_rate_upper_bound[materials] := 

   <"biogas_CENTER"> 1e+009, 

   <"biogas_Loc1"> 1e+009, 

   <"biogas_Loc2"> 1e+009, 

   <"biogas_Loc3"> 1e+009, 

   <"biogas_pipe_availability_material_Pipe1"> 1e+009,

   <"biogas_pipe_availability_material_Pipe2"> 1e+009, 

   <"biogas_pipe_availability_material_Pipe3to1"> 1e+009, 

   <"capacity_in_Loc1_K160_No0"> 1e+009, 

   <"capacity_in_Loc1_K160_No1"> 1e+009, 

   <"capacity_in_Loc1_K250_No0"> 1e+009,

   <"capacity_in_Loc1_K250_No1"> 1e+009, 

   <"capacity_in_Loc1_K500_No0"> 1e+009, 

   <"capacity_in_Loc1_K500_No1"> 1e+009, 

   <"capacity_in_Loc1_K80_No0"> 1e+009, 

   <"capacity_in_Loc1_K80_No1"> 1e+009,

   <"capacity_in_Loc2_K160_No0"> 1e+009, 

   <"capacity_in_Loc2_K160_No1"> 1e+009, 

   <"capacity_in_Loc2_K250_No0"> 1e+009, 

   <"capacity_in_Loc2_K250_No1"> 1e+009, 

   <"capacity_in_Loc2_K500_No0"> 1e+009,

   <"capacity_in_Loc2_K500_No1"> 1e+009, 

   <"capacity_in_Loc2_K80_No0"> 1e+009, 

   <"capacity_in_Loc2_K80_No1"> 1e+009, 

   <"capacity_in_Loc3_K160_No0"> 1e+009, 

   <"capacity_in_Loc3_K160_No1"> 1e+009,

   <"capacity_in_Loc3_K250_No0"> 1e+009, 

   <"capacity_in_Loc3_K250_No1"> 1e+009, 

   <"capacity_in_Loc3_K500_No0"> 1e+009, 

   <"capacity_in_Loc3_K500_No1"> 1e+009, 

   <"capacity_in_Loc3_K80_No0"> 1e+009,

   <"capacity_in_Loc3_K80_No1"> 1e+009, 

   <"capacity_out_Loc1_K160_No0"> 1e+009, 

   <"capacity_out_Loc1_K160_No1"> 1e+009, 

   <"capacity_out_Loc1_K250_No0"> 1e+009, 

   <"capacity_out_Loc1_K250_No1"> 1e+009,

   <"capacity_out_Loc1_K500_No0"> 1e+009, 

   <"capacity_out_Loc1_K500_No1"> 1e+009, 

   <"capacity_out_Loc1_K80_No0"> 1e+009, 

   <"capacity_out_Loc1_K80_No1"> 1e+009, 

   <"capacity_out_Loc2_K160_No0"> 1e+009,

   <"capacity_out_Loc2_K160_No1"> 1e+009, 

   <"capacity_out_Loc2_K250_No0"> 1e+009, 

   <"capacity_out_Loc2_K250_No1"> 1e+009, 

   <"capacity_out_Loc2_K500_No0"> 1e+009, 

   <"capacity_out_Loc2_K500_No1"> 1e+009,

   <"capacity_out_Loc2_K80_No0"> 1e+009, 

   <"capacity_out_Loc2_K80_No1"> 1e+009, 

   <"capacity_out_Loc3_K160_No0"> 1e+009, 

   <"capacity_out_Loc3_K160_No1"> 1e+009, 

   <"capacity_out_Loc3_K250_No0"> 1e+009,

   <"capacity_out_Loc3_K250_No1"> 1e+009, 

   <"capacity_out_Loc3_K500_No0"> 1e+009, 

   <"capacity_out_Loc3_K500_No1"> 1e+009, 

   <"capacity_out_Loc3_K80_No0"> 1e+009, 

   <"capacity_out_Loc3_K80_No1"> 1e+009,

   <"collected_heat_loss_Pipe1"> 1e+009, 

   <"collected_heat_loss_Pipe2"> 1e+009, 

   <"collected_heat_loss_Pipe3to1"> 1e+009, 

   <"electricity_K160"> 1e+009, 

   <"electricity_K250"> 1e+009,

   <"electricity_K500"> 1e+009, 

   <"electricity_K80"> 1e+009, 

   <"heat_balance_CENTER"> 1e+009, 

   <"heat_balance_Loc1"> 1e+009, 

   <"heat_balance_Loc2"> 1e+009,

   <"heat_balance_Loc3"> 1e+009, 

   <"heat_pipe_availability_material_Loc1_Pipe1"> 1e+009, 

   <"heat_pipe_availability_material_Loc2_Pipe2"> 1e+009, 

   <"heat_pipe_availability_material_Loc3_Pipe1"> 1e+009, 

   <"heat_pipe_availability_material_Loc3_Pipe3to1"> 1e+009,

   <"heat_purchase"> 1e+009, 

   <"heat_sent_Loc1"> 1e+009, 

   <"heat_sent_Loc2"> 1e+009, 

   <"heat_sent_Loc3"> 1e+009, 

   <"min_ratio_Loc1_K160_No0_Manure"> 1e+009,

   <"min_ratio_Loc1_K160_No1_Manure"> 1e+009, 

   <"min_ratio_Loc1_K250_No0_Manure"> 1e+009, 

   <"min_ratio_Loc1_K250_No1_Manure"> 1e+009, 

   <"min_ratio_Loc1_K500_No0_Manure"> 1e+009, 

   <"min_ratio_Loc1_K500_No1_Manure"> 1e+009,

   <"min_ratio_Loc1_K80_No0_Manure"> 1e+009, 

   <"min_ratio_Loc1_K80_No1_Manure"> 1e+009, 

   <"min_ratio_Loc2_K160_No0_Manure"> 1e+009, 

   <"min_ratio_Loc2_K160_No1_Manure"> 1e+009, 

   <"min_ratio_Loc2_K250_No0_Manure"> 1e+009,

   <"min_ratio_Loc2_K250_No1_Manure"> 1e+009, 

   <"min_ratio_Loc2_K500_No0_Manure"> 1e+009, 

   <"min_ratio_Loc2_K500_No1_Manure"> 1e+009, 

   <"min_ratio_Loc2_K80_No0_Manure"> 1e+009, 

   <"min_ratio_Loc2_K80_No1_Manure"> 1e+009,

   <"min_ratio_Loc3_K160_No0_Manure"> 1e+009, 

   <"min_ratio_Loc3_K160_No1_Manure"> 1e+009, 

   <"min_ratio_Loc3_K250_No0_Manure"> 1e+009, 

   <"min_ratio_Loc3_K250_No1_Manure"> 1e+009, 

   <"min_ratio_Loc3_K500_No0_Manure"> 1e+009,

   <"min_ratio_Loc3_K500_No1_Manure"> 1e+009, 

   <"min_ratio_Loc3_K80_No0_Manure"> 1e+009, 

   <"min_ratio_Loc3_K80_No1_Manure"> 1e+009, 

   <"revenue"> 1e+009, 

   <"silo_plate_availability_material_Loc1"> 1e+009,

   <"silo_plate_availability_material_Loc2"> 1e+009, 

   <"silo_plate_availability_material_Loc3"> 1e+009, 

   <"substrate_available_FM_L1_Corn"> 703.03, 

   <"substrate_available_FM_L1_Grass"> 820, 

   <"substrate_available_FM_L1_Inter"> 1541.67,

   <"substrate_available_FM_L1_Manure"> 4511, 

   <"substrate_available_FM_L2_Corn"> 172.727, 

   <"substrate_available_FM_L2_Grass"> 200, 

   <"substrate_available_FM_L2_Inter"> 375, 

   <"substrate_available_FM_L2_Manure"> 1100,

   <"substrate_available_FM_L3_Corn"> 324.242, 

   <"substrate_available_FM_L3_Grass"> 380, 

   <"substrate_available_FM_L3_Inter"> 716.667, 

   <"substrate_available_FM_L3_Manure"> 2089, 

   <"substrate_available_FM_L4_Corn"> 290.909,

   <"substrate_available_FM_L4_Grass"> 340, 

   <"substrate_available_FM_L4_Inter"> 641.667, 

   <"substrate_available_FM_L4_Manure"> 1867, 

   <"substrate_available_FM_L5_Corn"> 136.364, 

   <"substrate_available_FM_L5_Grass"> 160,

   <"substrate_available_FM_L5_Inter"> 300, 

   <"substrate_available_FM_L5_Manure"> 878, 

   <"substrate_available_FM_L6_Corn"> 172.727, 

   <"substrate_available_FM_L6_Grass"> 200, 

   <"substrate_available_FM_L6_Inter"> 375,

   <"substrate_available_FM_L6_Manure"> 1100, 

   <"substrate_available_FM_L7_Corn"> 275.758, 

   <"substrate_available_FM_L7_Grass"> 320, 

   <"substrate_available_FM_L7_Inter"> 600, 

   <"substrate_available_FM_L7_Manure"> 1756,

   <"substrate_available_FM_L8_Corn"> 342.424, 

   <"substrate_available_FM_L8_Grass"> 400, 

   <"substrate_available_FM_L8_Inter"> 750, 

   <"substrate_available_FM_L8_Manure"> 2200, 

   <"substrate_feed_Loc1_Corn"> 1e+009,

   <"substrate_feed_Loc1_Grass"> 1e+009, 

   <"substrate_feed_Loc1_Inter"> 1e+009, 

   <"substrate_feed_Loc1_Manure"> 1e+009, 

   <"substrate_feed_Loc2_Corn"> 1e+009, 

   <"substrate_feed_Loc2_Grass"> 1e+009,

   <"substrate_feed_Loc2_Inter"> 1e+009, 

   <"substrate_feed_Loc2_Manure"> 1e+009, 

   <"substrate_feed_Loc3_Corn"> 1e+009, 

   <"substrate_feed_Loc3_Grass"> 1e+009, 

   <"substrate_feed_Loc3_Inter"> 1e+009,

   <"substrate_feed_Loc3_Manure"> 1e+009, 

   <"transformer_availability_material"> 1e+009
   default 0;



# Prices of raw materials and products

param price[raw_materials union products] := 

   <"heat_purchase"> 50, 

   <"revenue"> 1, 

   <"substrate_available_FM_L1_Corn"> 36.3, 

   <"substrate_available_FM_L1_Grass"> 24, 

   <"substrate_available_FM_L1_Inter"> 19.2,

   <"substrate_available_FM_L1_Manure"> 0.9, 

   <"substrate_available_FM_L2_Corn"> 36.3, 

   <"substrate_available_FM_L2_Grass"> 24, 

   <"substrate_available_FM_L2_Inter"> 19.2, 

   <"substrate_available_FM_L2_Manure"> 0.9,

   <"substrate_available_FM_L3_Corn"> 36.3, 

   <"substrate_available_FM_L3_Grass"> 24, 

   <"substrate_available_FM_L3_Inter"> 19.2, 

   <"substrate_available_FM_L3_Manure"> 0.9, 

   <"substrate_available_FM_L4_Corn"> 36.3,

   <"substrate_available_FM_L4_Grass"> 24, 

   <"substrate_available_FM_L4_Inter"> 19.2, 

   <"substrate_available_FM_L4_Manure"> 0.9, 

   <"substrate_available_FM_L5_Corn"> 36.3, 

   <"substrate_available_FM_L5_Grass"> 24,

   <"substrate_available_FM_L5_Inter"> 19.2, 

   <"substrate_available_FM_L5_Manure"> 0.9, 

   <"substrate_available_FM_L6_Corn"> 36.3, 

   <"substrate_available_FM_L6_Grass"> 24, 

   <"substrate_available_FM_L6_Inter"> 19.2,

   <"substrate_available_FM_L6_Manure"> 0.9, 

   <"substrate_available_FM_L7_Corn"> 36.3, 

   <"substrate_available_FM_L7_Grass"> 24, 

   <"substrate_available_FM_L7_Inter"> 19.2, 

   <"substrate_available_FM_L7_Manure"> 0.9,

   <"substrate_available_FM_L8_Corn"> 36.3, 

   <"substrate_available_FM_L8_Grass"> 24, 

   <"substrate_available_FM_L8_Inter"> 19.2, 

   <"substrate_available_FM_L8_Manure"> 0.9
   default 0;



# Set of operating units

set operating_units := {"biogas_pipe_Pipe1", "biogas_pipe_Pipe2", "biogas_pipe_Pipe3to1", "chp_CENTER_K160_No0", "chp_CENTER_K160_No1",

   "chp_CENTER_K160_No2", "chp_CENTER_K250_No0", "chp_CENTER_K250_No1", "chp_CENTER_K250_No2", "chp_CENTER_K500_No0",

   "chp_CENTER_K500_No1", "chp_CENTER_K500_No2", "chp_CENTER_K80_No0", "chp_CENTER_K80_No1", "chp_CENTER_K80_No2",

   "chp_Loc1_K160_No0", "chp_Loc1_K160_No1", "chp_Loc1_K160_No2", "chp_Loc1_K250_No0", "chp_Loc1_K250_No1",

   "chp_Loc1_K250_No2", "chp_Loc1_K500_No0", "chp_Loc1_K500_No1", "chp_Loc1_K500_No2", "chp_Loc1_K80_No0",

   "chp_Loc1_K80_No1", "chp_Loc1_K80_No2", "chp_Loc2_K160_No0", "chp_Loc2_K160_No1", "chp_Loc2_K160_No2",

   "chp_Loc2_K250_No0", "chp_Loc2_K250_No1", "chp_Loc2_K250_No2", "chp_Loc2_K500_No0", "chp_Loc2_K500_No1",

   "chp_Loc2_K500_No2", "chp_Loc2_K80_No0", "chp_Loc2_K80_No1", "chp_Loc2_K80_No2", "chp_Loc3_K160_No0",

   "chp_Loc3_K160_No1", "chp_Loc3_K160_No2", "chp_Loc3_K250_No0", "chp_Loc3_K250_No1", "chp_Loc3_K250_No2",

   "chp_Loc3_K500_No0", "chp_Loc3_K500_No1", "chp_Loc3_K500_No2", "chp_Loc3_K80_No0", "chp_Loc3_K80_No1",

   "chp_Loc3_K80_No2", "collect_heat_loss_op_unit_Loc1_Pipe1", "collect_heat_loss_op_unit_Loc2_Pipe2", "collect_heat_loss_op_unit_Loc3_Pipe1", "collect_heat_loss_op_unit_Loc3_Pipe3to1",

   "heat_pipe_provide_availability_Pipe1", "heat_pipe_provide_availability_Pipe2", "heat_pipe_provide_availability_Pipe3to1", "invest_fermenter_Loc1_K160_No0", "invest_fermenter_Loc1_K160_No1",

   "invest_fermenter_Loc1_K250_No0", "invest_fermenter_Loc1_K250_No1", "invest_fermenter_Loc1_K500_No0", "invest_fermenter_Loc1_K500_No1", "invest_fermenter_Loc1_K80_No0",

   "invest_fermenter_Loc1_K80_No1", "invest_fermenter_Loc2_K160_No0", "invest_fermenter_Loc2_K160_No1", "invest_fermenter_Loc2_K250_No0", "invest_fermenter_Loc2_K250_No1",

   "invest_fermenter_Loc2_K500_No0", "invest_fermenter_Loc2_K500_No1", "invest_fermenter_Loc2_K80_No0", "invest_fermenter_Loc2_K80_No1", "invest_fermenter_Loc3_K160_No0",

   "invest_fermenter_Loc3_K160_No1", "invest_fermenter_Loc3_K250_No0", "invest_fermenter_Loc3_K250_No1", "invest_fermenter_Loc3_K500_No0", "invest_fermenter_Loc3_K500_No1",

   "invest_fermenter_Loc3_K80_No0", "invest_fermenter_Loc3_K80_No1", "op_transport_substrates_L1_Loc1_Corn", "op_transport_substrates_L1_Loc1_Grass", "op_transport_substrates_L1_Loc1_Inter",

   "op_transport_substrates_L1_Loc1_Manure", "op_transport_substrates_L1_Loc2_Corn", "op_transport_substrates_L1_Loc2_Grass", "op_transport_substrates_L1_Loc2_Inter", "op_transport_substrates_L1_Loc2_Manure",

   "op_transport_substrates_L1_Loc3_Corn", "op_transport_substrates_L1_Loc3_Grass", "op_transport_substrates_L1_Loc3_Inter", "op_transport_substrates_L1_Loc3_Manure", "op_transport_substrates_L2_Loc1_Corn",

   "op_transport_substrates_L2_Loc1_Grass", "op_transport_substrates_L2_Loc1_Inter", "op_transport_substrates_L2_Loc1_Manure", "op_transport_substrates_L2_Loc2_Corn", "op_transport_substrates_L2_Loc2_Grass",

   "op_transport_substrates_L2_Loc2_Inter", "op_transport_substrates_L2_Loc2_Manure", "op_transport_substrates_L2_Loc3_Corn", "op_transport_substrates_L2_Loc3_Grass", "op_transport_substrates_L2_Loc3_Inter",

   "op_transport_substrates_L2_Loc3_Manure", "op_transport_substrates_L3_Loc1_Corn", "op_transport_substrates_L3_Loc1_Grass", "op_transport_substrates_L3_Loc1_Inter", "op_transport_substrates_L3_Loc1_Manure",

   "op_transport_substrates_L3_Loc2_Corn", "op_transport_substrates_L3_Loc2_Grass", "op_transport_substrates_L3_Loc2_Inter", "op_transport_substrates_L3_Loc2_Manure", "op_transport_substrates_L3_Loc3_Corn",

   "op_transport_substrates_L3_Loc3_Grass", "op_transport_substrates_L3_Loc3_Inter", "op_transport_substrates_L3_Loc3_Manure", "op_transport_substrates_L4_Loc1_Corn", "op_transport_substrates_L4_Loc1_Grass",

   "op_transport_substrates_L4_Loc1_Inter", "op_transport_substrates_L4_Loc1_Manure", "op_transport_substrates_L4_Loc2_Corn", "op_transport_substrates_L4_Loc2_Grass", "op_transport_substrates_L4_Loc2_Inter",

   "op_transport_substrates_L4_Loc2_Manure", "op_transport_substrates_L4_Loc3_Corn", "op_transport_substrates_L4_Loc3_Grass", "op_transport_substrates_L4_Loc3_Inter", "op_transport_substrates_L4_Loc3_Manure",

   "op_transport_substrates_L5_Loc1_Corn", "op_transport_substrates_L5_Loc1_Grass", "op_transport_substrates_L5_Loc1_Inter", "op_transport_substrates_L5_Loc1_Manure", "op_transport_substrates_L5_Loc2_Corn",

   "op_transport_substrates_L5_Loc2_Grass", "op_transport_substrates_L5_Loc2_Inter", "op_transport_substrates_L5_Loc2_Manure", "op_transport_substrates_L5_Loc3_Corn", "op_transport_substrates_L5_Loc3_Grass",

   "op_transport_substrates_L5_Loc3_Inter", "op_transport_substrates_L5_Loc3_Manure", "op_transport_substrates_L6_Loc1_Corn", "op_transport_substrates_L6_Loc1_Grass", "op_transport_substrates_L6_Loc1_Inter",

   "op_transport_substrates_L6_Loc1_Manure", "op_transport_substrates_L6_Loc2_Corn", "op_transport_substrates_L6_Loc2_Grass", "op_transport_substrates_L6_Loc2_Inter", "op_transport_substrates_L6_Loc2_Manure",

   "op_transport_substrates_L6_Loc3_Corn", "op_transport_substrates_L6_Loc3_Grass", "op_transport_substrates_L6_Loc3_Inter", "op_transport_substrates_L6_Loc3_Manure", "op_transport_substrates_L7_Loc1_Corn",

   "op_transport_substrates_L7_Loc1_Grass", "op_transport_substrates_L7_Loc1_Inter", "op_transport_substrates_L7_Loc1_Manure", "op_transport_substrates_L7_Loc2_Corn", "op_transport_substrates_L7_Loc2_Grass",

   "op_transport_substrates_L7_Loc2_Inter", "op_transport_substrates_L7_Loc2_Manure", "op_transport_substrates_L7_Loc3_Corn", "op_transport_substrates_L7_Loc3_Grass", "op_transport_substrates_L7_Loc3_Inter",

   "op_transport_substrates_L7_Loc3_Manure", "op_transport_substrates_L8_Loc1_Corn", "op_transport_substrates_L8_Loc1_Grass", "op_transport_substrates_L8_Loc1_Inter", "op_transport_substrates_L8_Loc1_Manure",

   "op_transport_substrates_L8_Loc2_Corn", "op_transport_substrates_L8_Loc2_Grass", "op_transport_substrates_L8_Loc2_Inter", "op_transport_substrates_L8_Loc2_Manure", "op_transport_substrates_L8_Loc3_Corn",

   "op_transport_substrates_L8_Loc3_Grass", "op_transport_substrates_L8_Loc3_Inter", "op_transport_substrates_L8_Loc3_Manure", "process_Loc1_K160_No0_Corn", "process_Loc1_K160_No0_Grass",

   "process_Loc1_K160_No0_Inter", "process_Loc1_K160_No0_Manure", "process_Loc1_K160_No0_slack", "process_Loc1_K160_No1_Corn", "process_Loc1_K160_No1_Grass",

   "process_Loc1_K160_No1_Inter", "process_Loc1_K160_No1_Manure", "process_Loc1_K160_No1_slack", "process_Loc1_K250_No0_Corn", "process_Loc1_K250_No0_Grass",

   "process_Loc1_K250_No0_Inter", "process_Loc1_K250_No0_Manure", "process_Loc1_K250_No0_slack", "process_Loc1_K250_No1_Corn", "process_Loc1_K250_No1_Grass",

   "process_Loc1_K250_No1_Inter", "process_Loc1_K250_No1_Manure", "process_Loc1_K250_No1_slack", "process_Loc1_K500_No0_Corn", "process_Loc1_K500_No0_Grass",

   "process_Loc1_K500_No0_Inter", "process_Loc1_K500_No0_Manure", "process_Loc1_K500_No0_slack", "process_Loc1_K500_No1_Corn", "process_Loc1_K500_No1_Grass",

   "process_Loc1_K500_No1_Inter", "process_Loc1_K500_No1_Manure", "process_Loc1_K500_No1_slack", "process_Loc1_K80_No0_Corn", "process_Loc1_K80_No0_Grass",

   "process_Loc1_K80_No0_Inter", "process_Loc1_K80_No0_Manure", "process_Loc1_K80_No0_slack", "process_Loc1_K80_No1_Corn", "process_Loc1_K80_No1_Grass",

   "process_Loc1_K80_No1_Inter", "process_Loc1_K80_No1_Manure", "process_Loc1_K80_No1_slack", "process_Loc2_K160_No0_Corn", "process_Loc2_K160_No0_Grass",

   "process_Loc2_K160_No0_Inter", "process_Loc2_K160_No0_Manure", "process_Loc2_K160_No0_slack", "process_Loc2_K160_No1_Corn", "process_Loc2_K160_No1_Grass",

   "process_Loc2_K160_No1_Inter", "process_Loc2_K160_No1_Manure", "process_Loc2_K160_No1_slack", "process_Loc2_K250_No0_Corn", "process_Loc2_K250_No0_Grass",

   "process_Loc2_K250_No0_Inter", "process_Loc2_K250_No0_Manure", "process_Loc2_K250_No0_slack", "process_Loc2_K250_No1_Corn", "process_Loc2_K250_No1_Grass",

   "process_Loc2_K250_No1_Inter", "process_Loc2_K250_No1_Manure", "process_Loc2_K250_No1_slack", "process_Loc2_K500_No0_Corn", "process_Loc2_K500_No0_Grass",

   "process_Loc2_K500_No0_Inter", "process_Loc2_K500_No0_Manure", "process_Loc2_K500_No0_slack", "process_Loc2_K500_No1_Corn", "process_Loc2_K500_No1_Grass",

   "process_Loc2_K500_No1_Inter", "process_Loc2_K500_No1_Manure", "process_Loc2_K500_No1_slack", "process_Loc2_K80_No0_Corn", "process_Loc2_K80_No0_Grass",

   "process_Loc2_K80_No0_Inter", "process_Loc2_K80_No0_Manure", "process_Loc2_K80_No0_slack", "process_Loc2_K80_No1_Corn", "process_Loc2_K80_No1_Grass",

   "process_Loc2_K80_No1_Inter", "process_Loc2_K80_No1_Manure", "process_Loc2_K80_No1_slack", "process_Loc3_K160_No0_Corn", "process_Loc3_K160_No0_Grass",

   "process_Loc3_K160_No0_Inter", "process_Loc3_K160_No0_Manure", "process_Loc3_K160_No0_slack", "process_Loc3_K160_No1_Corn", "process_Loc3_K160_No1_Grass",

   "process_Loc3_K160_No1_Inter", "process_Loc3_K160_No1_Manure", "process_Loc3_K160_No1_slack", "process_Loc3_K250_No0_Corn", "process_Loc3_K250_No0_Grass",

   "process_Loc3_K250_No0_Inter", "process_Loc3_K250_No0_Manure", "process_Loc3_K250_No0_slack", "process_Loc3_K250_No1_Corn", "process_Loc3_K250_No1_Grass",

   "process_Loc3_K250_No1_Inter", "process_Loc3_K250_No1_Manure", "process_Loc3_K250_No1_slack", "process_Loc3_K500_No0_Corn", "process_Loc3_K500_No0_Grass",

   "process_Loc3_K500_No0_Inter", "process_Loc3_K500_No0_Manure", "process_Loc3_K500_No0_slack", "process_Loc3_K500_No1_Corn", "process_Loc3_K500_No1_Grass",

   "process_Loc3_K500_No1_Inter", "process_Loc3_K500_No1_Manure", "process_Loc3_K500_No1_slack", "process_Loc3_K80_No0_Corn", "process_Loc3_K80_No0_Grass",

   "process_Loc3_K80_No0_Inter", "process_Loc3_K80_No0_Manure", "process_Loc3_K80_No0_slack", "process_Loc3_K80_No1_Corn", "process_Loc3_K80_No1_Grass",

   "process_Loc3_K80_No1_Inter", "process_Loc3_K80_No1_Manure", "process_Loc3_K80_No1_slack", "purchase_heat_Loc1", "purchase_heat_Loc2",

   "purchase_heat_Loc3", "save_heat_Loc1", "save_heat_Loc2", "save_heat_Loc3", "sell_electricity_K160",

   "sell_electricity_K250", "sell_electricity_K500", "sell_electricity_K80", "sell_heat", "silo_plate_Loc1",

   "silo_plate_Loc2", "silo_plate_Loc3", "transfer_biogas_Loc1", "transfer_biogas_Loc2", "transfer_biogas_Loc3",

   "transfer_heat_Loc1", "transfer_heat_Loc2", "transfer_heat_Loc3", "transformer_op_unit"

};



# Set of operating units in solution#1



# Lower bounds of operating units capacities

param capacity_lower_bound[operating_units] := 

   <"biogas_pipe_Pipe1"> 0, 

   <"biogas_pipe_Pipe2"> 0, 

   <"biogas_pipe_Pipe3to1"> 0, 

   <"chp_CENTER_K160_No0"> 0, 

   <"chp_CENTER_K160_No1"> 0,

   <"chp_CENTER_K160_No2"> 0, 

   <"chp_CENTER_K250_No0"> 0, 

   <"chp_CENTER_K250_No1"> 0, 

   <"chp_CENTER_K250_No2"> 0, 

   <"chp_CENTER_K500_No0"> 0,

   <"chp_CENTER_K500_No1"> 0, 

   <"chp_CENTER_K500_No2"> 0, 

   <"chp_CENTER_K80_No0"> 0, 

   <"chp_CENTER_K80_No1"> 0, 

   <"chp_CENTER_K80_No2"> 0,

   <"chp_Loc1_K160_No0"> 0, 

   <"chp_Loc1_K160_No1"> 0, 

   <"chp_Loc1_K160_No2"> 0, 

   <"chp_Loc1_K250_No0"> 0, 

   <"chp_Loc1_K250_No1"> 0,

   <"chp_Loc1_K250_No2"> 0, 

   <"chp_Loc1_K500_No0"> 0, 

   <"chp_Loc1_K500_No1"> 0, 

   <"chp_Loc1_K500_No2"> 0, 

   <"chp_Loc1_K80_No0"> 0,

   <"chp_Loc1_K80_No1"> 0, 

   <"chp_Loc1_K80_No2"> 0, 

   <"chp_Loc2_K160_No0"> 0, 

   <"chp_Loc2_K160_No1"> 0, 

   <"chp_Loc2_K160_No2"> 0,

   <"chp_Loc2_K250_No0"> 0, 

   <"chp_Loc2_K250_No1"> 0, 

   <"chp_Loc2_K250_No2"> 0, 

   <"chp_Loc2_K500_No0"> 0, 

   <"chp_Loc2_K500_No1"> 0,

   <"chp_Loc2_K500_No2"> 0, 

   <"chp_Loc2_K80_No0"> 0, 

   <"chp_Loc2_K80_No1"> 0, 

   <"chp_Loc2_K80_No2"> 0, 

   <"chp_Loc3_K160_No0"> 0,

   <"chp_Loc3_K160_No1"> 0, 

   <"chp_Loc3_K160_No2"> 0, 

   <"chp_Loc3_K250_No0"> 0, 

   <"chp_Loc3_K250_No1"> 0, 

   <"chp_Loc3_K250_No2"> 0,

   <"chp_Loc3_K500_No0"> 0, 

   <"chp_Loc3_K500_No1"> 0, 

   <"chp_Loc3_K500_No2"> 0, 

   <"chp_Loc3_K80_No0"> 0, 

   <"chp_Loc3_K80_No1"> 0,

   <"chp_Loc3_K80_No2"> 0, 

   <"collect_heat_loss_op_unit_Loc1_Pipe1"> 0, 

   <"collect_heat_loss_op_unit_Loc2_Pipe2"> 0, 

   <"collect_heat_loss_op_unit_Loc3_Pipe1"> 0, 

   <"collect_heat_loss_op_unit_Loc3_Pipe3to1"> 0,

   <"heat_pipe_provide_availability_Pipe1"> 115.5, 

   <"heat_pipe_provide_availability_Pipe2"> 105, 

   <"heat_pipe_provide_availability_Pipe3to1"> 136.5, 

   <"invest_fermenter_Loc1_K160_No0"> 7800, 

   <"invest_fermenter_Loc1_K160_No1"> 7800,

   <"invest_fermenter_Loc1_K250_No0"> 7800, 

   <"invest_fermenter_Loc1_K250_No1"> 7800, 

   <"invest_fermenter_Loc1_K500_No0"> 7800, 

   <"invest_fermenter_Loc1_K500_No1"> 7800, 

   <"invest_fermenter_Loc1_K80_No0"> 7800,

   <"invest_fermenter_Loc1_K80_No1"> 7800, 

   <"invest_fermenter_Loc2_K160_No0"> 7800, 

   <"invest_fermenter_Loc2_K160_No1"> 7800, 

   <"invest_fermenter_Loc2_K250_No0"> 7800, 

   <"invest_fermenter_Loc2_K250_No1"> 7800,

   <"invest_fermenter_Loc2_K500_No0"> 7800, 

   <"invest_fermenter_Loc2_K500_No1"> 7800, 

   <"invest_fermenter_Loc2_K80_No0"> 7800, 

   <"invest_fermenter_Loc2_K80_No1"> 7800, 

   <"invest_fermenter_Loc3_K160_No0"> 7800,

   <"invest_fermenter_Loc3_K160_No1"> 7800, 

   <"invest_fermenter_Loc3_K250_No0"> 7800, 

   <"invest_fermenter_Loc3_K250_No1"> 7800, 

   <"invest_fermenter_Loc3_K500_No0"> 7800, 

   <"invest_fermenter_Loc3_K500_No1"> 7800,

   <"invest_fermenter_Loc3_K80_No0"> 7800, 

   <"invest_fermenter_Loc3_K80_No1"> 7800, 

   <"op_transport_substrates_L1_Loc1_Corn"> 0, 

   <"op_transport_substrates_L1_Loc1_Grass"> 0, 

   <"op_transport_substrates_L1_Loc1_Inter"> 0,

   <"op_transport_substrates_L1_Loc1_Manure"> 0, 

   <"op_transport_substrates_L1_Loc2_Corn"> 0, 

   <"op_transport_substrates_L1_Loc2_Grass"> 0, 

   <"op_transport_substrates_L1_Loc2_Inter"> 0, 

   <"op_transport_substrates_L1_Loc2_Manure"> 0,

   <"op_transport_substrates_L1_Loc3_Corn"> 0, 

   <"op_transport_substrates_L1_Loc3_Grass"> 0, 

   <"op_transport_substrates_L1_Loc3_Inter"> 0, 

   <"op_transport_substrates_L1_Loc3_Manure"> 0, 

   <"op_transport_substrates_L2_Loc1_Corn"> 0,

   <"op_transport_substrates_L2_Loc1_Grass"> 0, 

   <"op_transport_substrates_L2_Loc1_Inter"> 0, 

   <"op_transport_substrates_L2_Loc1_Manure"> 0, 

   <"op_transport_substrates_L2_Loc2_Corn"> 0, 

   <"op_transport_substrates_L2_Loc2_Grass"> 0,

   <"op_transport_substrates_L2_Loc2_Inter"> 0, 

   <"op_transport_substrates_L2_Loc2_Manure"> 0, 

   <"op_transport_substrates_L2_Loc3_Corn"> 0, 

   <"op_transport_substrates_L2_Loc3_Grass"> 0, 

   <"op_transport_substrates_L2_Loc3_Inter"> 0,

   <"op_transport_substrates_L2_Loc3_Manure"> 0, 

   <"op_transport_substrates_L3_Loc1_Corn"> 0, 

   <"op_transport_substrates_L3_Loc1_Grass"> 0, 

   <"op_transport_substrates_L3_Loc1_Inter"> 0, 

   <"op_transport_substrates_L3_Loc1_Manure"> 0,

   <"op_transport_substrates_L3_Loc2_Corn"> 0, 

   <"op_transport_substrates_L3_Loc2_Grass"> 0, 

   <"op_transport_substrates_L3_Loc2_Inter"> 0, 

   <"op_transport_substrates_L3_Loc2_Manure"> 0, 

   <"op_transport_substrates_L3_Loc3_Corn"> 0,

   <"op_transport_substrates_L3_Loc3_Grass"> 0, 

   <"op_transport_substrates_L3_Loc3_Inter"> 0, 

   <"op_transport_substrates_L3_Loc3_Manure"> 0, 

   <"op_transport_substrates_L4_Loc1_Corn"> 0, 

   <"op_transport_substrates_L4_Loc1_Grass"> 0,

   <"op_transport_substrates_L4_Loc1_Inter"> 0, 

   <"op_transport_substrates_L4_Loc1_Manure"> 0, 

   <"op_transport_substrates_L4_Loc2_Corn"> 0, 

   <"op_transport_substrates_L4_Loc2_Grass"> 0, 

   <"op_transport_substrates_L4_Loc2_Inter"> 0,

   <"op_transport_substrates_L4_Loc2_Manure"> 0, 

   <"op_transport_substrates_L4_Loc3_Corn"> 0, 

   <"op_transport_substrates_L4_Loc3_Grass"> 0, 

   <"op_transport_substrates_L4_Loc3_Inter"> 0, 

   <"op_transport_substrates_L4_Loc3_Manure"> 0,

   <"op_transport_substrates_L5_Loc1_Corn"> 0, 

   <"op_transport_substrates_L5_Loc1_Grass"> 0, 

   <"op_transport_substrates_L5_Loc1_Inter"> 0, 

   <"op_transport_substrates_L5_Loc1_Manure"> 0, 

   <"op_transport_substrates_L5_Loc2_Corn"> 0,

   <"op_transport_substrates_L5_Loc2_Grass"> 0, 

   <"op_transport_substrates_L5_Loc2_Inter"> 0, 

   <"op_transport_substrates_L5_Loc2_Manure"> 0, 

   <"op_transport_substrates_L5_Loc3_Corn"> 0, 

   <"op_transport_substrates_L5_Loc3_Grass"> 0,

   <"op_transport_substrates_L5_Loc3_Inter"> 0, 

   <"op_transport_substrates_L5_Loc3_Manure"> 0, 

   <"op_transport_substrates_L6_Loc1_Corn"> 0, 

   <"op_transport_substrates_L6_Loc1_Grass"> 0, 

   <"op_transport_substrates_L6_Loc1_Inter"> 0,

   <"op_transport_substrates_L6_Loc1_Manure"> 0, 

   <"op_transport_substrates_L6_Loc2_Corn"> 0, 

   <"op_transport_substrates_L6_Loc2_Grass"> 0, 

   <"op_transport_substrates_L6_Loc2_Inter"> 0, 

   <"op_transport_substrates_L6_Loc2_Manure"> 0,

   <"op_transport_substrates_L6_Loc3_Corn"> 0, 

   <"op_transport_substrates_L6_Loc3_Grass"> 0, 

   <"op_transport_substrates_L6_Loc3_Inter"> 0, 

   <"op_transport_substrates_L6_Loc3_Manure"> 0, 

   <"op_transport_substrates_L7_Loc1_Corn"> 0,

   <"op_transport_substrates_L7_Loc1_Grass"> 0, 

   <"op_transport_substrates_L7_Loc1_Inter"> 0, 

   <"op_transport_substrates_L7_Loc1_Manure"> 0, 

   <"op_transport_substrates_L7_Loc2_Corn"> 0, 

   <"op_transport_substrates_L7_Loc2_Grass"> 0,

   <"op_transport_substrates_L7_Loc2_Inter"> 0, 

   <"op_transport_substrates_L7_Loc2_Manure"> 0, 

   <"op_transport_substrates_L7_Loc3_Corn"> 0, 

   <"op_transport_substrates_L7_Loc3_Grass"> 0, 

   <"op_transport_substrates_L7_Loc3_Inter"> 0,

   <"op_transport_substrates_L7_Loc3_Manure"> 0, 

   <"op_transport_substrates_L8_Loc1_Corn"> 0, 

   <"op_transport_substrates_L8_Loc1_Grass"> 0, 

   <"op_transport_substrates_L8_Loc1_Inter"> 0, 

   <"op_transport_substrates_L8_Loc1_Manure"> 0,

   <"op_transport_substrates_L8_Loc2_Corn"> 0, 

   <"op_transport_substrates_L8_Loc2_Grass"> 0, 

   <"op_transport_substrates_L8_Loc2_Inter"> 0, 

   <"op_transport_substrates_L8_Loc2_Manure"> 0, 

   <"op_transport_substrates_L8_Loc3_Corn"> 0,

   <"op_transport_substrates_L8_Loc3_Grass"> 0, 

   <"op_transport_substrates_L8_Loc3_Inter"> 0, 

   <"op_transport_substrates_L8_Loc3_Manure"> 0, 

   <"process_Loc1_K160_No0_Corn"> 0, 

   <"process_Loc1_K160_No0_Grass"> 0,

   <"process_Loc1_K160_No0_Inter"> 0, 

   <"process_Loc1_K160_No0_Manure"> 0, 

   <"process_Loc1_K160_No0_slack"> 0, 

   <"process_Loc1_K160_No1_Corn"> 0, 

   <"process_Loc1_K160_No1_Grass"> 0,

   <"process_Loc1_K160_No1_Inter"> 0, 

   <"process_Loc1_K160_No1_Manure"> 0, 

   <"process_Loc1_K160_No1_slack"> 0, 

   <"process_Loc1_K250_No0_Corn"> 0, 

   <"process_Loc1_K250_No0_Grass"> 0,

   <"process_Loc1_K250_No0_Inter"> 0, 

   <"process_Loc1_K250_No0_Manure"> 0, 

   <"process_Loc1_K250_No0_slack"> 0, 

   <"process_Loc1_K250_No1_Corn"> 0, 

   <"process_Loc1_K250_No1_Grass"> 0,

   <"process_Loc1_K250_No1_Inter"> 0, 

   <"process_Loc1_K250_No1_Manure"> 0, 

   <"process_Loc1_K250_No1_slack"> 0, 

   <"process_Loc1_K500_No0_Corn"> 0, 

   <"process_Loc1_K500_No0_Grass"> 0,

   <"process_Loc1_K500_No0_Inter"> 0, 

   <"process_Loc1_K500_No0_Manure"> 0, 

   <"process_Loc1_K500_No0_slack"> 0, 

   <"process_Loc1_K500_No1_Corn"> 0, 

   <"process_Loc1_K500_No1_Grass"> 0,

   <"process_Loc1_K500_No1_Inter"> 0, 

   <"process_Loc1_K500_No1_Manure"> 0, 

   <"process_Loc1_K500_No1_slack"> 0, 

   <"process_Loc1_K80_No0_Corn"> 0, 

   <"process_Loc1_K80_No0_Grass"> 0,

   <"process_Loc1_K80_No0_Inter"> 0, 

   <"process_Loc1_K80_No0_Manure"> 0, 

   <"process_Loc1_K80_No0_slack"> 0, 

   <"process_Loc1_K80_No1_Corn"> 0, 

   <"process_Loc1_K80_No1_Grass"> 0,

   <"process_Loc1_K80_No1_Inter"> 0, 

   <"process_Loc1_K80_No1_Manure"> 0, 

   <"process_Loc1_K80_No1_slack"> 0, 

   <"process_Loc2_K160_No0_Corn"> 0, 

   <"process_Loc2_K160_No0_Grass"> 0,

   <"process_Loc2_K160_No0_Inter"> 0, 

   <"process_Loc2_K160_No0_Manure"> 0, 

   <"process_Loc2_K160_No0_slack"> 0, 

   <"process_Loc2_K160_No1_Corn"> 0, 

   <"process_Loc2_K160_No1_Grass"> 0,

   <"process_Loc2_K160_No1_Inter"> 0, 

   <"process_Loc2_K160_No1_Manure"> 0, 

   <"process_Loc2_K160_No1_slack"> 0, 

   <"process_Loc2_K250_No0_Corn"> 0, 

   <"process_Loc2_K250_No0_Grass"> 0,

   <"process_Loc2_K250_No0_Inter"> 0, 

   <"process_Loc2_K250_No0_Manure"> 0, 

   <"process_Loc2_K250_No0_slack"> 0, 

   <"process_Loc2_K250_No1_Corn"> 0, 

   <"process_Loc2_K250_No1_Grass"> 0,

   <"process_Loc2_K250_No1_Inter"> 0, 

   <"process_Loc2_K250_No1_Manure"> 0, 

   <"process_Loc2_K250_No1_slack"> 0, 

   <"process_Loc2_K500_No0_Corn"> 0, 

   <"process_Loc2_K500_No0_Grass"> 0,

   <"process_Loc2_K500_No0_Inter"> 0, 

   <"process_Loc2_K500_No0_Manure"> 0, 

   <"process_Loc2_K500_No0_slack"> 0, 

   <"process_Loc2_K500_No1_Corn"> 0, 

   <"process_Loc2_K500_No1_Grass"> 0,

   <"process_Loc2_K500_No1_Inter"> 0, 

   <"process_Loc2_K500_No1_Manure"> 0, 

   <"process_Loc2_K500_No1_slack"> 0, 

   <"process_Loc2_K80_No0_Corn"> 0, 

   <"process_Loc2_K80_No0_Grass"> 0,

   <"process_Loc2_K80_No0_Inter"> 0, 

   <"process_Loc2_K80_No0_Manure"> 0, 

   <"process_Loc2_K80_No0_slack"> 0, 

   <"process_Loc2_K80_No1_Corn"> 0, 

   <"process_Loc2_K80_No1_Grass"> 0,

   <"process_Loc2_K80_No1_Inter"> 0, 

   <"process_Loc2_K80_No1_Manure"> 0, 

   <"process_Loc2_K80_No1_slack"> 0, 

   <"process_Loc3_K160_No0_Corn"> 0, 

   <"process_Loc3_K160_No0_Grass"> 0,

   <"process_Loc3_K160_No0_Inter"> 0, 

   <"process_Loc3_K160_No0_Manure"> 0, 

   <"process_Loc3_K160_No0_slack"> 0, 

   <"process_Loc3_K160_No1_Corn"> 0, 

   <"process_Loc3_K160_No1_Grass"> 0,

   <"process_Loc3_K160_No1_Inter"> 0, 

   <"process_Loc3_K160_No1_Manure"> 0, 

   <"process_Loc3_K160_No1_slack"> 0, 

   <"process_Loc3_K250_No0_Corn"> 0, 

   <"process_Loc3_K250_No0_Grass"> 0,

   <"process_Loc3_K250_No0_Inter"> 0, 

   <"process_Loc3_K250_No0_Manure"> 0, 

   <"process_Loc3_K250_No0_slack"> 0, 

   <"process_Loc3_K250_No1_Corn"> 0, 

   <"process_Loc3_K250_No1_Grass"> 0,

   <"process_Loc3_K250_No1_Inter"> 0, 

   <"process_Loc3_K250_No1_Manure"> 0, 

   <"process_Loc3_K250_No1_slack"> 0, 

   <"process_Loc3_K500_No0_Corn"> 0, 

   <"process_Loc3_K500_No0_Grass"> 0,

   <"process_Loc3_K500_No0_Inter"> 0, 

   <"process_Loc3_K500_No0_Manure"> 0, 

   <"process_Loc3_K500_No0_slack"> 0, 

   <"process_Loc3_K500_No1_Corn"> 0, 

   <"process_Loc3_K500_No1_Grass"> 0,

   <"process_Loc3_K500_No1_Inter"> 0, 

   <"process_Loc3_K500_No1_Manure"> 0, 

   <"process_Loc3_K500_No1_slack"> 0, 

   <"process_Loc3_K80_No0_Corn"> 0, 

   <"process_Loc3_K80_No0_Grass"> 0,

   <"process_Loc3_K80_No0_Inter"> 0, 

   <"process_Loc3_K80_No0_Manure"> 0, 

   <"process_Loc3_K80_No0_slack"> 0, 

   <"process_Loc3_K80_No1_Corn"> 0, 

   <"process_Loc3_K80_No1_Grass"> 0,

   <"process_Loc3_K80_No1_Inter"> 0, 

   <"process_Loc3_K80_No1_Manure"> 0, 

   <"process_Loc3_K80_No1_slack"> 0, 

   <"purchase_heat_Loc1"> 0, 

   <"purchase_heat_Loc2"> 0,

   <"purchase_heat_Loc3"> 0, 

   <"save_heat_Loc1"> 0, 

   <"save_heat_Loc2"> 0, 

   <"save_heat_Loc3"> 0, 

   <"sell_electricity_K160"> 0,

   <"sell_electricity_K250"> 0, 

   <"sell_electricity_K500"> 0, 

   <"sell_electricity_K80"> 0, 

   <"sell_heat"> 0, 

   <"silo_plate_Loc1"> 0,

   <"silo_plate_Loc2"> 0, 

   <"silo_plate_Loc3"> 0, 

   <"transfer_biogas_Loc1"> 0, 

   <"transfer_biogas_Loc2"> 0, 

   <"transfer_biogas_Loc3"> 0,

   <"transfer_heat_Loc1"> 0, 

   <"transfer_heat_Loc2"> 0, 

   <"transfer_heat_Loc3"> 0, 

   <"transformer_op_unit"> 0
   default 0;



# Upper bounds of operating units capacities

param capacity_upper_bound[operating_units] := 

   <"biogas_pipe_Pipe1"> 1e+009, 

   <"biogas_pipe_Pipe2"> 1e+009, 

   <"biogas_pipe_Pipe3to1"> 1e+009, 

   <"chp_CENTER_K160_No0"> 7800, 

   <"chp_CENTER_K160_No1"> 7800,

   <"chp_CENTER_K160_No2"> 7800, 

   <"chp_CENTER_K250_No0"> 7800, 

   <"chp_CENTER_K250_No1"> 7800, 

   <"chp_CENTER_K250_No2"> 7800, 

   <"chp_CENTER_K500_No0"> 7800,

   <"chp_CENTER_K500_No1"> 7800, 

   <"chp_CENTER_K500_No2"> 7800, 

   <"chp_CENTER_K80_No0"> 7800, 

   <"chp_CENTER_K80_No1"> 7800, 

   <"chp_CENTER_K80_No2"> 7800,

   <"chp_Loc1_K160_No0"> 7800, 

   <"chp_Loc1_K160_No1"> 7800, 

   <"chp_Loc1_K160_No2"> 7800, 

   <"chp_Loc1_K250_No0"> 7800, 

   <"chp_Loc1_K250_No1"> 7800,

   <"chp_Loc1_K250_No2"> 7800, 

   <"chp_Loc1_K500_No0"> 7800, 

   <"chp_Loc1_K500_No1"> 7800, 

   <"chp_Loc1_K500_No2"> 7800, 

   <"chp_Loc1_K80_No0"> 7800,

   <"chp_Loc1_K80_No1"> 7800, 

   <"chp_Loc1_K80_No2"> 7800, 

   <"chp_Loc2_K160_No0"> 7800, 

   <"chp_Loc2_K160_No1"> 7800, 

   <"chp_Loc2_K160_No2"> 7800,

   <"chp_Loc2_K250_No0"> 7800, 

   <"chp_Loc2_K250_No1"> 7800, 

   <"chp_Loc2_K250_No2"> 7800, 

   <"chp_Loc2_K500_No0"> 7800, 

   <"chp_Loc2_K500_No1"> 7800,

   <"chp_Loc2_K500_No2"> 7800, 

   <"chp_Loc2_K80_No0"> 7800, 

   <"chp_Loc2_K80_No1"> 7800, 

   <"chp_Loc2_K80_No2"> 7800, 

   <"chp_Loc3_K160_No0"> 7800,

   <"chp_Loc3_K160_No1"> 7800, 

   <"chp_Loc3_K160_No2"> 7800, 

   <"chp_Loc3_K250_No0"> 7800, 

   <"chp_Loc3_K250_No1"> 7800, 

   <"chp_Loc3_K250_No2"> 7800,

   <"chp_Loc3_K500_No0"> 7800, 

   <"chp_Loc3_K500_No1"> 7800, 

   <"chp_Loc3_K500_No2"> 7800, 

   <"chp_Loc3_K80_No0"> 7800, 

   <"chp_Loc3_K80_No1"> 7800,

   <"chp_Loc3_K80_No2"> 7800, 

   <"collect_heat_loss_op_unit_Loc1_Pipe1"> 1e+009, 

   <"collect_heat_loss_op_unit_Loc2_Pipe2"> 1e+009, 

   <"collect_heat_loss_op_unit_Loc3_Pipe1"> 1e+009, 

   <"collect_heat_loss_op_unit_Loc3_Pipe3to1"> 1e+009,

   <"heat_pipe_provide_availability_Pipe1"> 1e+009, 

   <"heat_pipe_provide_availability_Pipe2"> 1e+009, 

   <"heat_pipe_provide_availability_Pipe3to1"> 1e+009, 

   <"invest_fermenter_Loc1_K160_No0"> 7800, 

   <"invest_fermenter_Loc1_K160_No1"> 7800,

   <"invest_fermenter_Loc1_K250_No0"> 7800, 

   <"invest_fermenter_Loc1_K250_No1"> 7800, 

   <"invest_fermenter_Loc1_K500_No0"> 7800, 

   <"invest_fermenter_Loc1_K500_No1"> 7800, 

   <"invest_fermenter_Loc1_K80_No0"> 7800,

   <"invest_fermenter_Loc1_K80_No1"> 7800, 

   <"invest_fermenter_Loc2_K160_No0"> 7800, 

   <"invest_fermenter_Loc2_K160_No1"> 7800, 

   <"invest_fermenter_Loc2_K250_No0"> 7800, 

   <"invest_fermenter_Loc2_K250_No1"> 7800,

   <"invest_fermenter_Loc2_K500_No0"> 7800, 

   <"invest_fermenter_Loc2_K500_No1"> 7800, 

   <"invest_fermenter_Loc2_K80_No0"> 7800, 

   <"invest_fermenter_Loc2_K80_No1"> 7800, 

   <"invest_fermenter_Loc3_K160_No0"> 7800,

   <"invest_fermenter_Loc3_K160_No1"> 7800, 

   <"invest_fermenter_Loc3_K250_No0"> 7800, 

   <"invest_fermenter_Loc3_K250_No1"> 7800, 

   <"invest_fermenter_Loc3_K500_No0"> 7800, 

   <"invest_fermenter_Loc3_K500_No1"> 7800,

   <"invest_fermenter_Loc3_K80_No0"> 7800, 

   <"invest_fermenter_Loc3_K80_No1"> 7800, 

   <"op_transport_substrates_L1_Loc1_Corn"> 1e+009, 

   <"op_transport_substrates_L1_Loc1_Grass"> 1e+009, 

   <"op_transport_substrates_L1_Loc1_Inter"> 1e+009,

   <"op_transport_substrates_L1_Loc1_Manure"> 1e+009, 

   <"op_transport_substrates_L1_Loc2_Corn"> 1e+009, 

   <"op_transport_substrates_L1_Loc2_Grass"> 1e+009, 

   <"op_transport_substrates_L1_Loc2_Inter"> 1e+009, 

   <"op_transport_substrates_L1_Loc2_Manure"> 1e+009,

   <"op_transport_substrates_L1_Loc3_Corn"> 1e+009, 

   <"op_transport_substrates_L1_Loc3_Grass"> 1e+009, 

   <"op_transport_substrates_L1_Loc3_Inter"> 1e+009, 

   <"op_transport_substrates_L1_Loc3_Manure"> 1e+009, 

   <"op_transport_substrates_L2_Loc1_Corn"> 1e+009,

   <"op_transport_substrates_L2_Loc1_Grass"> 1e+009, 

   <"op_transport_substrates_L2_Loc1_Inter"> 1e+009, 

   <"op_transport_substrates_L2_Loc1_Manure"> 1e+009, 

   <"op_transport_substrates_L2_Loc2_Corn"> 1e+009, 

   <"op_transport_substrates_L2_Loc2_Grass"> 1e+009,

   <"op_transport_substrates_L2_Loc2_Inter"> 1e+009, 

   <"op_transport_substrates_L2_Loc2_Manure"> 1e+009, 

   <"op_transport_substrates_L2_Loc3_Corn"> 1e+009, 

   <"op_transport_substrates_L2_Loc3_Grass"> 1e+009, 

   <"op_transport_substrates_L2_Loc3_Inter"> 1e+009,

   <"op_transport_substrates_L2_Loc3_Manure"> 1e+009, 

   <"op_transport_substrates_L3_Loc1_Corn"> 1e+009, 

   <"op_transport_substrates_L3_Loc1_Grass"> 1e+009, 

   <"op_transport_substrates_L3_Loc1_Inter"> 1e+009, 

   <"op_transport_substrates_L3_Loc1_Manure"> 1e+009,

   <"op_transport_substrates_L3_Loc2_Corn"> 1e+009, 

   <"op_transport_substrates_L3_Loc2_Grass"> 1e+009, 

   <"op_transport_substrates_L3_Loc2_Inter"> 1e+009, 

   <"op_transport_substrates_L3_Loc2_Manure"> 1e+009, 

   <"op_transport_substrates_L3_Loc3_Corn"> 1e+009,

   <"op_transport_substrates_L3_Loc3_Grass"> 1e+009, 

   <"op_transport_substrates_L3_Loc3_Inter"> 1e+009, 

   <"op_transport_substrates_L3_Loc3_Manure"> 1e+009, 

   <"op_transport_substrates_L4_Loc1_Corn"> 1e+009, 

   <"op_transport_substrates_L4_Loc1_Grass"> 1e+009,

   <"op_transport_substrates_L4_Loc1_Inter"> 1e+009, 

   <"op_transport_substrates_L4_Loc1_Manure"> 1e+009, 

   <"op_transport_substrates_L4_Loc2_Corn"> 1e+009, 

   <"op_transport_substrates_L4_Loc2_Grass"> 1e+009, 

   <"op_transport_substrates_L4_Loc2_Inter"> 1e+009,

   <"op_transport_substrates_L4_Loc2_Manure"> 1e+009, 

   <"op_transport_substrates_L4_Loc3_Corn"> 1e+009, 

   <"op_transport_substrates_L4_Loc3_Grass"> 1e+009, 

   <"op_transport_substrates_L4_Loc3_Inter"> 1e+009, 

   <"op_transport_substrates_L4_Loc3_Manure"> 1e+009,

   <"op_transport_substrates_L5_Loc1_Corn"> 1e+009, 

   <"op_transport_substrates_L5_Loc1_Grass"> 1e+009, 

   <"op_transport_substrates_L5_Loc1_Inter"> 1e+009, 

   <"op_transport_substrates_L5_Loc1_Manure"> 1e+009, 

   <"op_transport_substrates_L5_Loc2_Corn"> 1e+009,

   <"op_transport_substrates_L5_Loc2_Grass"> 1e+009, 

   <"op_transport_substrates_L5_Loc2_Inter"> 1e+009, 

   <"op_transport_substrates_L5_Loc2_Manure"> 1e+009, 

   <"op_transport_substrates_L5_Loc3_Corn"> 1e+009, 

   <"op_transport_substrates_L5_Loc3_Grass"> 1e+009,

   <"op_transport_substrates_L5_Loc3_Inter"> 1e+009, 

   <"op_transport_substrates_L5_Loc3_Manure"> 1e+009, 

   <"op_transport_substrates_L6_Loc1_Corn"> 1e+009, 

   <"op_transport_substrates_L6_Loc1_Grass"> 1e+009, 

   <"op_transport_substrates_L6_Loc1_Inter"> 1e+009,

   <"op_transport_substrates_L6_Loc1_Manure"> 1e+009, 

   <"op_transport_substrates_L6_Loc2_Corn"> 1e+009, 

   <"op_transport_substrates_L6_Loc2_Grass"> 1e+009, 

   <"op_transport_substrates_L6_Loc2_Inter"> 1e+009, 

   <"op_transport_substrates_L6_Loc2_Manure"> 1e+009,

   <"op_transport_substrates_L6_Loc3_Corn"> 1e+009, 

   <"op_transport_substrates_L6_Loc3_Grass"> 1e+009, 

   <"op_transport_substrates_L6_Loc3_Inter"> 1e+009, 

   <"op_transport_substrates_L6_Loc3_Manure"> 1e+009, 

   <"op_transport_substrates_L7_Loc1_Corn"> 1e+009,

   <"op_transport_substrates_L7_Loc1_Grass"> 1e+009, 

   <"op_transport_substrates_L7_Loc1_Inter"> 1e+009, 

   <"op_transport_substrates_L7_Loc1_Manure"> 1e+009, 

   <"op_transport_substrates_L7_Loc2_Corn"> 1e+009, 

   <"op_transport_substrates_L7_Loc2_Grass"> 1e+009,

   <"op_transport_substrates_L7_Loc2_Inter"> 1e+009, 

   <"op_transport_substrates_L7_Loc2_Manure"> 1e+009, 

   <"op_transport_substrates_L7_Loc3_Corn"> 1e+009, 

   <"op_transport_substrates_L7_Loc3_Grass"> 1e+009, 

   <"op_transport_substrates_L7_Loc3_Inter"> 1e+009,

   <"op_transport_substrates_L7_Loc3_Manure"> 1e+009, 

   <"op_transport_substrates_L8_Loc1_Corn"> 1e+009, 

   <"op_transport_substrates_L8_Loc1_Grass"> 1e+009, 

   <"op_transport_substrates_L8_Loc1_Inter"> 1e+009, 

   <"op_transport_substrates_L8_Loc1_Manure"> 1e+009,

   <"op_transport_substrates_L8_Loc2_Corn"> 1e+009, 

   <"op_transport_substrates_L8_Loc2_Grass"> 1e+009, 

   <"op_transport_substrates_L8_Loc2_Inter"> 1e+009, 

   <"op_transport_substrates_L8_Loc2_Manure"> 1e+009, 

   <"op_transport_substrates_L8_Loc3_Corn"> 1e+009,

   <"op_transport_substrates_L8_Loc3_Grass"> 1e+009, 

   <"op_transport_substrates_L8_Loc3_Inter"> 1e+009, 

   <"op_transport_substrates_L8_Loc3_Manure"> 1e+009, 

   <"process_Loc1_K160_No0_Corn"> 1e+009, 

   <"process_Loc1_K160_No0_Grass"> 1e+009,

   <"process_Loc1_K160_No0_Inter"> 1e+009, 

   <"process_Loc1_K160_No0_Manure"> 1e+009, 

   <"process_Loc1_K160_No0_slack"> 1e+009, 

   <"process_Loc1_K160_No1_Corn"> 1e+009, 

   <"process_Loc1_K160_No1_Grass"> 1e+009,

   <"process_Loc1_K160_No1_Inter"> 1e+009, 

   <"process_Loc1_K160_No1_Manure"> 1e+009, 

   <"process_Loc1_K160_No1_slack"> 1e+009, 

   <"process_Loc1_K250_No0_Corn"> 1e+009, 

   <"process_Loc1_K250_No0_Grass"> 1e+009,

   <"process_Loc1_K250_No0_Inter"> 1e+009, 

   <"process_Loc1_K250_No0_Manure"> 1e+009, 

   <"process_Loc1_K250_No0_slack"> 1e+009, 

   <"process_Loc1_K250_No1_Corn"> 1e+009, 

   <"process_Loc1_K250_No1_Grass"> 1e+009,

   <"process_Loc1_K250_No1_Inter"> 1e+009, 

   <"process_Loc1_K250_No1_Manure"> 1e+009, 

   <"process_Loc1_K250_No1_slack"> 1e+009, 

   <"process_Loc1_K500_No0_Corn"> 1e+009, 

   <"process_Loc1_K500_No0_Grass"> 1e+009,

   <"process_Loc1_K500_No0_Inter"> 1e+009, 

   <"process_Loc1_K500_No0_Manure"> 1e+009, 

   <"process_Loc1_K500_No0_slack"> 1e+009, 

   <"process_Loc1_K500_No1_Corn"> 1e+009, 

   <"process_Loc1_K500_No1_Grass"> 1e+009,

   <"process_Loc1_K500_No1_Inter"> 1e+009, 

   <"process_Loc1_K500_No1_Manure"> 1e+009, 

   <"process_Loc1_K500_No1_slack"> 1e+009, 

   <"process_Loc1_K80_No0_Corn"> 1e+009, 

   <"process_Loc1_K80_No0_Grass"> 1e+009,

   <"process_Loc1_K80_No0_Inter"> 1e+009, 

   <"process_Loc1_K80_No0_Manure"> 1e+009, 

   <"process_Loc1_K80_No0_slack"> 1e+009, 

   <"process_Loc1_K80_No1_Corn"> 1e+009, 

   <"process_Loc1_K80_No1_Grass"> 1e+009,

   <"process_Loc1_K80_No1_Inter"> 1e+009, 

   <"process_Loc1_K80_No1_Manure"> 1e+009, 

   <"process_Loc1_K80_No1_slack"> 1e+009, 

   <"process_Loc2_K160_No0_Corn"> 1e+009, 

   <"process_Loc2_K160_No0_Grass"> 1e+009,

   <"process_Loc2_K160_No0_Inter"> 1e+009, 

   <"process_Loc2_K160_No0_Manure"> 1e+009, 

   <"process_Loc2_K160_No0_slack"> 1e+009, 

   <"process_Loc2_K160_No1_Corn"> 1e+009, 

   <"process_Loc2_K160_No1_Grass"> 1e+009,

   <"process_Loc2_K160_No1_Inter"> 1e+009, 

   <"process_Loc2_K160_No1_Manure"> 1e+009, 

   <"process_Loc2_K160_No1_slack"> 1e+009, 

   <"process_Loc2_K250_No0_Corn"> 1e+009, 

   <"process_Loc2_K250_No0_Grass"> 1e+009,

   <"process_Loc2_K250_No0_Inter"> 1e+009, 

   <"process_Loc2_K250_No0_Manure"> 1e+009, 

   <"process_Loc2_K250_No0_slack"> 1e+009, 

   <"process_Loc2_K250_No1_Corn"> 1e+009, 

   <"process_Loc2_K250_No1_Grass"> 1e+009,

   <"process_Loc2_K250_No1_Inter"> 1e+009, 

   <"process_Loc2_K250_No1_Manure"> 1e+009, 

   <"process_Loc2_K250_No1_slack"> 1e+009, 

   <"process_Loc2_K500_No0_Corn"> 1e+009, 

   <"process_Loc2_K500_No0_Grass"> 1e+009,

   <"process_Loc2_K500_No0_Inter"> 1e+009, 

   <"process_Loc2_K500_No0_Manure"> 1e+009, 

   <"process_Loc2_K500_No0_slack"> 1e+009, 

   <"process_Loc2_K500_No1_Corn"> 1e+009, 

   <"process_Loc2_K500_No1_Grass"> 1e+009,

   <"process_Loc2_K500_No1_Inter"> 1e+009, 

   <"process_Loc2_K500_No1_Manure"> 1e+009, 

   <"process_Loc2_K500_No1_slack"> 1e+009, 

   <"process_Loc2_K80_No0_Corn"> 1e+009, 

   <"process_Loc2_K80_No0_Grass"> 1e+009,

   <"process_Loc2_K80_No0_Inter"> 1e+009, 

   <"process_Loc2_K80_No0_Manure"> 1e+009, 

   <"process_Loc2_K80_No0_slack"> 1e+009, 

   <"process_Loc2_K80_No1_Corn"> 1e+009, 

   <"process_Loc2_K80_No1_Grass"> 1e+009,

   <"process_Loc2_K80_No1_Inter"> 1e+009, 

   <"process_Loc2_K80_No1_Manure"> 1e+009, 

   <"process_Loc2_K80_No1_slack"> 1e+009, 

   <"process_Loc3_K160_No0_Corn"> 1e+009, 

   <"process_Loc3_K160_No0_Grass"> 1e+009,

   <"process_Loc3_K160_No0_Inter"> 1e+009, 

   <"process_Loc3_K160_No0_Manure"> 1e+009, 

   <"process_Loc3_K160_No0_slack"> 1e+009, 

   <"process_Loc3_K160_No1_Corn"> 1e+009, 

   <"process_Loc3_K160_No1_Grass"> 1e+009,

   <"process_Loc3_K160_No1_Inter"> 1e+009, 

   <"process_Loc3_K160_No1_Manure"> 1e+009, 

   <"process_Loc3_K160_No1_slack"> 1e+009, 

   <"process_Loc3_K250_No0_Corn"> 1e+009, 

   <"process_Loc3_K250_No0_Grass"> 1e+009,

   <"process_Loc3_K250_No0_Inter"> 1e+009, 

   <"process_Loc3_K250_No0_Manure"> 1e+009, 

   <"process_Loc3_K250_No0_slack"> 1e+009, 

   <"process_Loc3_K250_No1_Corn"> 1e+009, 

   <"process_Loc3_K250_No1_Grass"> 1e+009,

   <"process_Loc3_K250_No1_Inter"> 1e+009, 

   <"process_Loc3_K250_No1_Manure"> 1e+009, 

   <"process_Loc3_K250_No1_slack"> 1e+009, 

   <"process_Loc3_K500_No0_Corn"> 1e+009, 

   <"process_Loc3_K500_No0_Grass"> 1e+009,

   <"process_Loc3_K500_No0_Inter"> 1e+009, 

   <"process_Loc3_K500_No0_Manure"> 1e+009, 

   <"process_Loc3_K500_No0_slack"> 1e+009, 

   <"process_Loc3_K500_No1_Corn"> 1e+009, 

   <"process_Loc3_K500_No1_Grass"> 1e+009,

   <"process_Loc3_K500_No1_Inter"> 1e+009, 

   <"process_Loc3_K500_No1_Manure"> 1e+009, 

   <"process_Loc3_K500_No1_slack"> 1e+009, 

   <"process_Loc3_K80_No0_Corn"> 1e+009, 

   <"process_Loc3_K80_No0_Grass"> 1e+009,

   <"process_Loc3_K80_No0_Inter"> 1e+009, 

   <"process_Loc3_K80_No0_Manure"> 1e+009, 

   <"process_Loc3_K80_No0_slack"> 1e+009, 

   <"process_Loc3_K80_No1_Corn"> 1e+009, 

   <"process_Loc3_K80_No1_Grass"> 1e+009,

   <"process_Loc3_K80_No1_Inter"> 1e+009, 

   <"process_Loc3_K80_No1_Manure"> 1e+009, 

   <"process_Loc3_K80_No1_slack"> 1e+009, 

   <"purchase_heat_Loc1"> 1e+009, 

   <"purchase_heat_Loc2"> 1e+009,

   <"purchase_heat_Loc3"> 1e+009, 

   <"save_heat_Loc1"> 1e+009, 

   <"save_heat_Loc2"> 1e+009, 

   <"save_heat_Loc3"> 1e+009, 

   <"sell_electricity_K160"> 1e+009,

   <"sell_electricity_K250"> 1e+009, 

   <"sell_electricity_K500"> 1e+009, 

   <"sell_electricity_K80"> 1e+009, 

   <"sell_heat"> 1e+009, 

   <"silo_plate_Loc1"> 1e+009,

   <"silo_plate_Loc2"> 1e+009, 

   <"silo_plate_Loc3"> 1e+009, 

   <"transfer_biogas_Loc1"> 1e+009, 

   <"transfer_biogas_Loc2"> 1e+009, 

   <"transfer_biogas_Loc3"> 1e+009,

   <"transfer_heat_Loc1"> 1e+009, 

   <"transfer_heat_Loc2"> 1e+009, 

   <"transfer_heat_Loc3"> 1e+009, 

   <"transformer_op_unit"> 1e+009
   default 0;



# Fix costs of operating units

param fix_cost[operating_units] := 

   <"biogas_pipe_Pipe1"> 2954, 

   <"biogas_pipe_Pipe2"> 2806.67, 

   <"biogas_pipe_Pipe3to1"> 5915.33, 

   <"chp_CENTER_K160_No0"> 46431.3, 

   <"chp_CENTER_K160_No1"> 46431.3,

   <"chp_CENTER_K160_No2"> 46431.3, 

   <"chp_CENTER_K250_No0"> 54444.7, 

   <"chp_CENTER_K250_No1"> 54444.7, 

   <"chp_CENTER_K250_No2"> 54444.7, 

   <"chp_CENTER_K500_No0"> 80012.7,

   <"chp_CENTER_K500_No1"> 80012.7, 

   <"chp_CENTER_K500_No2"> 80012.7, 

   <"chp_CENTER_K80_No0"> 34471.3, 

   <"chp_CENTER_K80_No1"> 34471.3, 

   <"chp_CENTER_K80_No2"> 34471.3,

   <"chp_Loc1_K160_No0"> 46431.3, 

   <"chp_Loc1_K160_No1"> 46431.3, 

   <"chp_Loc1_K160_No2"> 46431.3, 

   <"chp_Loc1_K250_No0"> 54444.7, 

   <"chp_Loc1_K250_No1"> 54444.7,

   <"chp_Loc1_K250_No2"> 54444.7, 

   <"chp_Loc1_K500_No0"> 80012.7, 

   <"chp_Loc1_K500_No1"> 80012.7, 

   <"chp_Loc1_K500_No2"> 80012.7, 

   <"chp_Loc1_K80_No0"> 34471.3,

   <"chp_Loc1_K80_No1"> 34471.3, 

   <"chp_Loc1_K80_No2"> 34471.3, 

   <"chp_Loc2_K160_No0"> 46431.3, 

   <"chp_Loc2_K160_No1"> 46431.3, 

   <"chp_Loc2_K160_No2"> 46431.3,

   <"chp_Loc2_K250_No0"> 54444.7, 

   <"chp_Loc2_K250_No1"> 54444.7, 

   <"chp_Loc2_K250_No2"> 54444.7, 

   <"chp_Loc2_K500_No0"> 80012.7, 

   <"chp_Loc2_K500_No1"> 80012.7,

   <"chp_Loc2_K500_No2"> 80012.7, 

   <"chp_Loc2_K80_No0"> 34471.3, 

   <"chp_Loc2_K80_No1"> 34471.3, 

   <"chp_Loc2_K80_No2"> 34471.3, 

   <"chp_Loc3_K160_No0"> 46431.3,

   <"chp_Loc3_K160_No1"> 46431.3, 

   <"chp_Loc3_K160_No2"> 46431.3, 

   <"chp_Loc3_K250_No0"> 54444.7, 

   <"chp_Loc3_K250_No1"> 54444.7, 

   <"chp_Loc3_K250_No2"> 54444.7,

   <"chp_Loc3_K500_No0"> 80012.7, 

   <"chp_Loc3_K500_No1"> 80012.7, 

   <"chp_Loc3_K500_No2"> 80012.7, 

   <"chp_Loc3_K80_No0"> 34471.3, 

   <"chp_Loc3_K80_No1"> 34471.3,

   <"chp_Loc3_K80_No2"> 34471.3, 

   <"collect_heat_loss_op_unit_Loc1_Pipe1"> 0, 

   <"collect_heat_loss_op_unit_Loc2_Pipe2"> 0, 

   <"collect_heat_loss_op_unit_Loc3_Pipe1"> 0, 

   <"collect_heat_loss_op_unit_Loc3_Pipe3to1"> 0,

   <"heat_pipe_provide_availability_Pipe1"> 22000, 

   <"heat_pipe_provide_availability_Pipe2"> 20000, 

   <"heat_pipe_provide_availability_Pipe3to1"> 26000, 

   <"invest_fermenter_Loc1_K160_No0"> 23300, 

   <"invest_fermenter_Loc1_K160_No1"> 23300,

   <"invest_fermenter_Loc1_K250_No0"> 29213, 

   <"invest_fermenter_Loc1_K250_No1"> 29213, 

   <"invest_fermenter_Loc1_K500_No0"> 46706, 

   <"invest_fermenter_Loc1_K500_No1"> 46706, 

   <"invest_fermenter_Loc1_K80_No0"> 18888,

   <"invest_fermenter_Loc1_K80_No1"> 18888, 

   <"invest_fermenter_Loc2_K160_No0"> 23300, 

   <"invest_fermenter_Loc2_K160_No1"> 23300, 

   <"invest_fermenter_Loc2_K250_No0"> 29213, 

   <"invest_fermenter_Loc2_K250_No1"> 29213,

   <"invest_fermenter_Loc2_K500_No0"> 46706, 

   <"invest_fermenter_Loc2_K500_No1"> 46706, 

   <"invest_fermenter_Loc2_K80_No0"> 18888, 

   <"invest_fermenter_Loc2_K80_No1"> 18888, 

   <"invest_fermenter_Loc3_K160_No0"> 23300,

   <"invest_fermenter_Loc3_K160_No1"> 23300, 

   <"invest_fermenter_Loc3_K250_No0"> 29213, 

   <"invest_fermenter_Loc3_K250_No1"> 29213, 

   <"invest_fermenter_Loc3_K500_No0"> 46706, 

   <"invest_fermenter_Loc3_K500_No1"> 46706,

   <"invest_fermenter_Loc3_K80_No0"> 18888, 

   <"invest_fermenter_Loc3_K80_No1"> 18888, 

   <"op_transport_substrates_L1_Loc1_Corn"> 0, 

   <"op_transport_substrates_L1_Loc1_Grass"> 0, 

   <"op_transport_substrates_L1_Loc1_Inter"> 0,

   <"op_transport_substrates_L1_Loc1_Manure"> 0, 

   <"op_transport_substrates_L1_Loc2_Corn"> 0, 

   <"op_transport_substrates_L1_Loc2_Grass"> 0, 

   <"op_transport_substrates_L1_Loc2_Inter"> 0, 

   <"op_transport_substrates_L1_Loc2_Manure"> 0,

   <"op_transport_substrates_L1_Loc3_Corn"> 0, 

   <"op_transport_substrates_L1_Loc3_Grass"> 0, 

   <"op_transport_substrates_L1_Loc3_Inter"> 0, 

   <"op_transport_substrates_L1_Loc3_Manure"> 0, 

   <"op_transport_substrates_L2_Loc1_Corn"> 0,

   <"op_transport_substrates_L2_Loc1_Grass"> 0, 

   <"op_transport_substrates_L2_Loc1_Inter"> 0, 

   <"op_transport_substrates_L2_Loc1_Manure"> 0, 

   <"op_transport_substrates_L2_Loc2_Corn"> 0, 

   <"op_transport_substrates_L2_Loc2_Grass"> 0,

   <"op_transport_substrates_L2_Loc2_Inter"> 0, 

   <"op_transport_substrates_L2_Loc2_Manure"> 0, 

   <"op_transport_substrates_L2_Loc3_Corn"> 0, 

   <"op_transport_substrates_L2_Loc3_Grass"> 0, 

   <"op_transport_substrates_L2_Loc3_Inter"> 0,

   <"op_transport_substrates_L2_Loc3_Manure"> 0, 

   <"op_transport_substrates_L3_Loc1_Corn"> 0, 

   <"op_transport_substrates_L3_Loc1_Grass"> 0, 

   <"op_transport_substrates_L3_Loc1_Inter"> 0, 

   <"op_transport_substrates_L3_Loc1_Manure"> 0,

   <"op_transport_substrates_L3_Loc2_Corn"> 0, 

   <"op_transport_substrates_L3_Loc2_Grass"> 0, 

   <"op_transport_substrates_L3_Loc2_Inter"> 0, 

   <"op_transport_substrates_L3_Loc2_Manure"> 0, 

   <"op_transport_substrates_L3_Loc3_Corn"> 0,

   <"op_transport_substrates_L3_Loc3_Grass"> 0, 

   <"op_transport_substrates_L3_Loc3_Inter"> 0, 

   <"op_transport_substrates_L3_Loc3_Manure"> 0, 

   <"op_transport_substrates_L4_Loc1_Corn"> 0, 

   <"op_transport_substrates_L4_Loc1_Grass"> 0,

   <"op_transport_substrates_L4_Loc1_Inter"> 0, 

   <"op_transport_substrates_L4_Loc1_Manure"> 0, 

   <"op_transport_substrates_L4_Loc2_Corn"> 0, 

   <"op_transport_substrates_L4_Loc2_Grass"> 0, 

   <"op_transport_substrates_L4_Loc2_Inter"> 0,

   <"op_transport_substrates_L4_Loc2_Manure"> 0, 

   <"op_transport_substrates_L4_Loc3_Corn"> 0, 

   <"op_transport_substrates_L4_Loc3_Grass"> 0, 

   <"op_transport_substrates_L4_Loc3_Inter"> 0, 

   <"op_transport_substrates_L4_Loc3_Manure"> 0,

   <"op_transport_substrates_L5_Loc1_Corn"> 0, 

   <"op_transport_substrates_L5_Loc1_Grass"> 0, 

   <"op_transport_substrates_L5_Loc1_Inter"> 0, 

   <"op_transport_substrates_L5_Loc1_Manure"> 0, 

   <"op_transport_substrates_L5_Loc2_Corn"> 0,

   <"op_transport_substrates_L5_Loc2_Grass"> 0, 

   <"op_transport_substrates_L5_Loc2_Inter"> 0, 

   <"op_transport_substrates_L5_Loc2_Manure"> 0, 

   <"op_transport_substrates_L5_Loc3_Corn"> 0, 

   <"op_transport_substrates_L5_Loc3_Grass"> 0,

   <"op_transport_substrates_L5_Loc3_Inter"> 0, 

   <"op_transport_substrates_L5_Loc3_Manure"> 0, 

   <"op_transport_substrates_L6_Loc1_Corn"> 0, 

   <"op_transport_substrates_L6_Loc1_Grass"> 0, 

   <"op_transport_substrates_L6_Loc1_Inter"> 0,

   <"op_transport_substrates_L6_Loc1_Manure"> 0, 

   <"op_transport_substrates_L6_Loc2_Corn"> 0, 

   <"op_transport_substrates_L6_Loc2_Grass"> 0, 

   <"op_transport_substrates_L6_Loc2_Inter"> 0, 

   <"op_transport_substrates_L6_Loc2_Manure"> 0,

   <"op_transport_substrates_L6_Loc3_Corn"> 0, 

   <"op_transport_substrates_L6_Loc3_Grass"> 0, 

   <"op_transport_substrates_L6_Loc3_Inter"> 0, 

   <"op_transport_substrates_L6_Loc3_Manure"> 0, 

   <"op_transport_substrates_L7_Loc1_Corn"> 0,

   <"op_transport_substrates_L7_Loc1_Grass"> 0, 

   <"op_transport_substrates_L7_Loc1_Inter"> 0, 

   <"op_transport_substrates_L7_Loc1_Manure"> 0, 

   <"op_transport_substrates_L7_Loc2_Corn"> 0, 

   <"op_transport_substrates_L7_Loc2_Grass"> 0,

   <"op_transport_substrates_L7_Loc2_Inter"> 0, 

   <"op_transport_substrates_L7_Loc2_Manure"> 0, 

   <"op_transport_substrates_L7_Loc3_Corn"> 0, 

   <"op_transport_substrates_L7_Loc3_Grass"> 0, 

   <"op_transport_substrates_L7_Loc3_Inter"> 0,

   <"op_transport_substrates_L7_Loc3_Manure"> 0, 

   <"op_transport_substrates_L8_Loc1_Corn"> 0, 

   <"op_transport_substrates_L8_Loc1_Grass"> 0, 

   <"op_transport_substrates_L8_Loc1_Inter"> 0, 

   <"op_transport_substrates_L8_Loc1_Manure"> 0,

   <"op_transport_substrates_L8_Loc2_Corn"> 0, 

   <"op_transport_substrates_L8_Loc2_Grass"> 0, 

   <"op_transport_substrates_L8_Loc2_Inter"> 0, 

   <"op_transport_substrates_L8_Loc2_Manure"> 0, 

   <"op_transport_substrates_L8_Loc3_Corn"> 0,

   <"op_transport_substrates_L8_Loc3_Grass"> 0, 

   <"op_transport_substrates_L8_Loc3_Inter"> 0, 

   <"op_transport_substrates_L8_Loc3_Manure"> 0, 

   <"process_Loc1_K160_No0_Corn"> 0, 

   <"process_Loc1_K160_No0_Grass"> 0,

   <"process_Loc1_K160_No0_Inter"> 0, 

   <"process_Loc1_K160_No0_Manure"> 0, 

   <"process_Loc1_K160_No0_slack"> 0, 

   <"process_Loc1_K160_No1_Corn"> 0, 

   <"process_Loc1_K160_No1_Grass"> 0,

   <"process_Loc1_K160_No1_Inter"> 0, 

   <"process_Loc1_K160_No1_Manure"> 0, 

   <"process_Loc1_K160_No1_slack"> 0, 

   <"process_Loc1_K250_No0_Corn"> 0, 

   <"process_Loc1_K250_No0_Grass"> 0,

   <"process_Loc1_K250_No0_Inter"> 0, 

   <"process_Loc1_K250_No0_Manure"> 0, 

   <"process_Loc1_K250_No0_slack"> 0, 

   <"process_Loc1_K250_No1_Corn"> 0, 

   <"process_Loc1_K250_No1_Grass"> 0,

   <"process_Loc1_K250_No1_Inter"> 0, 

   <"process_Loc1_K250_No1_Manure"> 0, 

   <"process_Loc1_K250_No1_slack"> 0, 

   <"process_Loc1_K500_No0_Corn"> 0, 

   <"process_Loc1_K500_No0_Grass"> 0,

   <"process_Loc1_K500_No0_Inter"> 0, 

   <"process_Loc1_K500_No0_Manure"> 0, 

   <"process_Loc1_K500_No0_slack"> 0, 

   <"process_Loc1_K500_No1_Corn"> 0, 

   <"process_Loc1_K500_No1_Grass"> 0,

   <"process_Loc1_K500_No1_Inter"> 0, 

   <"process_Loc1_K500_No1_Manure"> 0, 

   <"process_Loc1_K500_No1_slack"> 0, 

   <"process_Loc1_K80_No0_Corn"> 0, 

   <"process_Loc1_K80_No0_Grass"> 0,

   <"process_Loc1_K80_No0_Inter"> 0, 

   <"process_Loc1_K80_No0_Manure"> 0, 

   <"process_Loc1_K80_No0_slack"> 0, 

   <"process_Loc1_K80_No1_Corn"> 0, 

   <"process_Loc1_K80_No1_Grass"> 0,

   <"process_Loc1_K80_No1_Inter"> 0, 

   <"process_Loc1_K80_No1_Manure"> 0, 

   <"process_Loc1_K80_No1_slack"> 0, 

   <"process_Loc2_K160_No0_Corn"> 0, 

   <"process_Loc2_K160_No0_Grass"> 0,

   <"process_Loc2_K160_No0_Inter"> 0, 

   <"process_Loc2_K160_No0_Manure"> 0, 

   <"process_Loc2_K160_No0_slack"> 0, 

   <"process_Loc2_K160_No1_Corn"> 0, 

   <"process_Loc2_K160_No1_Grass"> 0,

   <"process_Loc2_K160_No1_Inter"> 0, 

   <"process_Loc2_K160_No1_Manure"> 0, 

   <"process_Loc2_K160_No1_slack"> 0, 

   <"process_Loc2_K250_No0_Corn"> 0, 

   <"process_Loc2_K250_No0_Grass"> 0,

   <"process_Loc2_K250_No0_Inter"> 0, 

   <"process_Loc2_K250_No0_Manure"> 0, 

   <"process_Loc2_K250_No0_slack"> 0, 

   <"process_Loc2_K250_No1_Corn"> 0, 

   <"process_Loc2_K250_No1_Grass"> 0,

   <"process_Loc2_K250_No1_Inter"> 0, 

   <"process_Loc2_K250_No1_Manure"> 0, 

   <"process_Loc2_K250_No1_slack"> 0, 

   <"process_Loc2_K500_No0_Corn"> 0, 

   <"process_Loc2_K500_No0_Grass"> 0,

   <"process_Loc2_K500_No0_Inter"> 0, 

   <"process_Loc2_K500_No0_Manure"> 0, 

   <"process_Loc2_K500_No0_slack"> 0, 

   <"process_Loc2_K500_No1_Corn"> 0, 

   <"process_Loc2_K500_No1_Grass"> 0,

   <"process_Loc2_K500_No1_Inter"> 0, 

   <"process_Loc2_K500_No1_Manure"> 0, 

   <"process_Loc2_K500_No1_slack"> 0, 

   <"process_Loc2_K80_No0_Corn"> 0, 

   <"process_Loc2_K80_No0_Grass"> 0,

   <"process_Loc2_K80_No0_Inter"> 0, 

   <"process_Loc2_K80_No0_Manure"> 0, 

   <"process_Loc2_K80_No0_slack"> 0, 

   <"process_Loc2_K80_No1_Corn"> 0, 

   <"process_Loc2_K80_No1_Grass"> 0,

   <"process_Loc2_K80_No1_Inter"> 0, 

   <"process_Loc2_K80_No1_Manure"> 0, 

   <"process_Loc2_K80_No1_slack"> 0, 

   <"process_Loc3_K160_No0_Corn"> 0, 

   <"process_Loc3_K160_No0_Grass"> 0,

   <"process_Loc3_K160_No0_Inter"> 0, 

   <"process_Loc3_K160_No0_Manure"> 0, 

   <"process_Loc3_K160_No0_slack"> 0, 

   <"process_Loc3_K160_No1_Corn"> 0, 

   <"process_Loc3_K160_No1_Grass"> 0,

   <"process_Loc3_K160_No1_Inter"> 0, 

   <"process_Loc3_K160_No1_Manure"> 0, 

   <"process_Loc3_K160_No1_slack"> 0, 

   <"process_Loc3_K250_No0_Corn"> 0, 

   <"process_Loc3_K250_No0_Grass"> 0,

   <"process_Loc3_K250_No0_Inter"> 0, 

   <"process_Loc3_K250_No0_Manure"> 0, 

   <"process_Loc3_K250_No0_slack"> 0, 

   <"process_Loc3_K250_No1_Corn"> 0, 

   <"process_Loc3_K250_No1_Grass"> 0,

   <"process_Loc3_K250_No1_Inter"> 0, 

   <"process_Loc3_K250_No1_Manure"> 0, 

   <"process_Loc3_K250_No1_slack"> 0, 

   <"process_Loc3_K500_No0_Corn"> 0, 

   <"process_Loc3_K500_No0_Grass"> 0,

   <"process_Loc3_K500_No0_Inter"> 0, 

   <"process_Loc3_K500_No0_Manure"> 0, 

   <"process_Loc3_K500_No0_slack"> 0, 

   <"process_Loc3_K500_No1_Corn"> 0, 

   <"process_Loc3_K500_No1_Grass"> 0,

   <"process_Loc3_K500_No1_Inter"> 0, 

   <"process_Loc3_K500_No1_Manure"> 0, 

   <"process_Loc3_K500_No1_slack"> 0, 

   <"process_Loc3_K80_No0_Corn"> 0, 

   <"process_Loc3_K80_No0_Grass"> 0,

   <"process_Loc3_K80_No0_Inter"> 0, 

   <"process_Loc3_K80_No0_Manure"> 0, 

   <"process_Loc3_K80_No0_slack"> 0, 

   <"process_Loc3_K80_No1_Corn"> 0, 

   <"process_Loc3_K80_No1_Grass"> 0,

   <"process_Loc3_K80_No1_Inter"> 0, 

   <"process_Loc3_K80_No1_Manure"> 0, 

   <"process_Loc3_K80_No1_slack"> 0, 

   <"purchase_heat_Loc1"> 0, 

   <"purchase_heat_Loc2"> 0,

   <"purchase_heat_Loc3"> 0, 

   <"save_heat_Loc1"> 0, 

   <"save_heat_Loc2"> 0, 

   <"save_heat_Loc3"> 0, 

   <"sell_electricity_K160"> 0,

   <"sell_electricity_K250"> 0, 

   <"sell_electricity_K500"> 0, 

   <"sell_electricity_K80"> 0, 

   <"sell_heat"> 0, 

   <"silo_plate_Loc1"> 15850,

   <"silo_plate_Loc2"> 15850, 

   <"silo_plate_Loc3"> 15850, 

   <"transfer_biogas_Loc1"> 0, 

   <"transfer_biogas_Loc2"> 0, 

   <"transfer_biogas_Loc3"> 0,

   <"transfer_heat_Loc1"> 0, 

   <"transfer_heat_Loc2"> 0, 

   <"transfer_heat_Loc3"> 0, 

   <"transformer_op_unit"> 2333.33
   default 0;



# Proportional costs of operating units

param proportional_cost[operating_units] := 

   <"biogas_pipe_Pipe1"> 0, 

   <"biogas_pipe_Pipe2"> 0, 

   <"biogas_pipe_Pipe3to1"> 0, 

   <"chp_CENTER_K160_No0"> 1.44, 

   <"chp_CENTER_K160_No1"> 1.44,

   <"chp_CENTER_K160_No2"> 1.44, 

   <"chp_CENTER_K250_No0"> 2.25, 

   <"chp_CENTER_K250_No1"> 2.25, 

   <"chp_CENTER_K250_No2"> 2.25, 

   <"chp_CENTER_K500_No0"> 4.5,

   <"chp_CENTER_K500_No1"> 4.5, 

   <"chp_CENTER_K500_No2"> 4.5, 

   <"chp_CENTER_K80_No0"> 0.72, 

   <"chp_CENTER_K80_No1"> 0.72, 

   <"chp_CENTER_K80_No2"> 0.72,

   <"chp_Loc1_K160_No0"> 1.44, 

   <"chp_Loc1_K160_No1"> 1.44, 

   <"chp_Loc1_K160_No2"> 1.44, 

   <"chp_Loc1_K250_No0"> 2.25, 

   <"chp_Loc1_K250_No1"> 2.25,

   <"chp_Loc1_K250_No2"> 2.25, 

   <"chp_Loc1_K500_No0"> 4.5, 

   <"chp_Loc1_K500_No1"> 4.5, 

   <"chp_Loc1_K500_No2"> 4.5, 

   <"chp_Loc1_K80_No0"> 0.72,

   <"chp_Loc1_K80_No1"> 0.72, 

   <"chp_Loc1_K80_No2"> 0.72, 

   <"chp_Loc2_K160_No0"> 1.44, 

   <"chp_Loc2_K160_No1"> 1.44, 

   <"chp_Loc2_K160_No2"> 1.44,

   <"chp_Loc2_K250_No0"> 2.25, 

   <"chp_Loc2_K250_No1"> 2.25, 

   <"chp_Loc2_K250_No2"> 2.25, 

   <"chp_Loc2_K500_No0"> 4.5, 

   <"chp_Loc2_K500_No1"> 4.5,

   <"chp_Loc2_K500_No2"> 4.5, 

   <"chp_Loc2_K80_No0"> 0.72, 

   <"chp_Loc2_K80_No1"> 0.72, 

   <"chp_Loc2_K80_No2"> 0.72, 

   <"chp_Loc3_K160_No0"> 1.44,

   <"chp_Loc3_K160_No1"> 1.44, 

   <"chp_Loc3_K160_No2"> 1.44, 

   <"chp_Loc3_K250_No0"> 2.25, 

   <"chp_Loc3_K250_No1"> 2.25, 

   <"chp_Loc3_K250_No2"> 2.25,

   <"chp_Loc3_K500_No0"> 4.5, 

   <"chp_Loc3_K500_No1"> 4.5, 

   <"chp_Loc3_K500_No2"> 4.5, 

   <"chp_Loc3_K80_No0"> 0.72, 

   <"chp_Loc3_K80_No1"> 0.72,

   <"chp_Loc3_K80_No2"> 0.72, 

   <"collect_heat_loss_op_unit_Loc1_Pipe1"> 0, 

   <"collect_heat_loss_op_unit_Loc2_Pipe2"> 0, 

   <"collect_heat_loss_op_unit_Loc3_Pipe1"> 0, 

   <"collect_heat_loss_op_unit_Loc3_Pipe3to1"> 0,

   <"heat_pipe_provide_availability_Pipe1"> 0, 

   <"heat_pipe_provide_availability_Pipe2"> 0, 

   <"heat_pipe_provide_availability_Pipe3to1"> 0, 

   <"invest_fermenter_Loc1_K160_No0"> 0, 

   <"invest_fermenter_Loc1_K160_No1"> 0,

   <"invest_fermenter_Loc1_K250_No0"> 0, 

   <"invest_fermenter_Loc1_K250_No1"> 0, 

   <"invest_fermenter_Loc1_K500_No0"> 0, 

   <"invest_fermenter_Loc1_K500_No1"> 0, 

   <"invest_fermenter_Loc1_K80_No0"> 0,

   <"invest_fermenter_Loc1_K80_No1"> 0, 

   <"invest_fermenter_Loc2_K160_No0"> 0, 

   <"invest_fermenter_Loc2_K160_No1"> 0, 

   <"invest_fermenter_Loc2_K250_No0"> 0, 

   <"invest_fermenter_Loc2_K250_No1"> 0,

   <"invest_fermenter_Loc2_K500_No0"> 0, 

   <"invest_fermenter_Loc2_K500_No1"> 0, 

   <"invest_fermenter_Loc2_K80_No0"> 0, 

   <"invest_fermenter_Loc2_K80_No1"> 0, 

   <"invest_fermenter_Loc3_K160_No0"> 0,

   <"invest_fermenter_Loc3_K160_No1"> 0, 

   <"invest_fermenter_Loc3_K250_No0"> 0, 

   <"invest_fermenter_Loc3_K250_No1"> 0, 

   <"invest_fermenter_Loc3_K500_No0"> 0, 

   <"invest_fermenter_Loc3_K500_No1"> 0,

   <"invest_fermenter_Loc3_K80_No0"> 0, 

   <"invest_fermenter_Loc3_K80_No1"> 0, 

   <"op_transport_substrates_L1_Loc1_Corn"> 2.784, 

   <"op_transport_substrates_L1_Loc1_Grass"> 2.784, 

   <"op_transport_substrates_L1_Loc1_Inter"> 2.784,

   <"op_transport_substrates_L1_Loc1_Manure"> 1.4, 

   <"op_transport_substrates_L1_Loc2_Corn"> 3.666, 

   <"op_transport_substrates_L1_Loc2_Grass"> 3.666, 

   <"op_transport_substrates_L1_Loc2_Inter"> 3.666, 

   <"op_transport_substrates_L1_Loc2_Manure"> 1.85,

   <"op_transport_substrates_L1_Loc3_Corn"> 2, 

   <"op_transport_substrates_L1_Loc3_Grass"> 2, 

   <"op_transport_substrates_L1_Loc3_Inter"> 2, 

   <"op_transport_substrates_L1_Loc3_Manure"> 1, 

   <"op_transport_substrates_L2_Loc1_Corn"> 3.617,

   <"op_transport_substrates_L2_Loc1_Grass"> 3.617, 

   <"op_transport_substrates_L2_Loc1_Inter"> 3.617, 

   <"op_transport_substrates_L2_Loc1_Manure"> 1.825, 

   <"op_transport_substrates_L2_Loc2_Corn"> 4.303, 

   <"op_transport_substrates_L2_Loc2_Grass"> 4.303,

   <"op_transport_substrates_L2_Loc2_Inter"> 4.303, 

   <"op_transport_substrates_L2_Loc2_Manure"> 2.175, 

   <"op_transport_substrates_L2_Loc3_Corn"> 3.96, 

   <"op_transport_substrates_L2_Loc3_Grass"> 3.96, 

   <"op_transport_substrates_L2_Loc3_Inter"> 3.96,

   <"op_transport_substrates_L2_Loc3_Manure"> 2, 

   <"op_transport_substrates_L3_Loc1_Corn"> 3.323, 

   <"op_transport_substrates_L3_Loc1_Grass"> 3.323, 

   <"op_transport_substrates_L3_Loc1_Inter"> 3.323, 

   <"op_transport_substrates_L3_Loc1_Manure"> 1.675,

   <"op_transport_substrates_L3_Loc2_Corn"> 4.254, 

   <"op_transport_substrates_L3_Loc2_Grass"> 4.254, 

   <"op_transport_substrates_L3_Loc2_Inter"> 4.254, 

   <"op_transport_substrates_L3_Loc2_Manure"> 2.15, 

   <"op_transport_substrates_L3_Loc3_Corn"> 2.588,

   <"op_transport_substrates_L3_Loc3_Grass"> 2.588, 

   <"op_transport_substrates_L3_Loc3_Inter"> 2.588, 

   <"op_transport_substrates_L3_Loc3_Manure"> 1.3, 

   <"op_transport_substrates_L4_Loc1_Corn"> 2.931, 

   <"op_transport_substrates_L4_Loc1_Grass"> 2.931,

   <"op_transport_substrates_L4_Loc1_Inter"> 2.931, 

   <"op_transport_substrates_L4_Loc1_Manure"> 1.475, 

   <"op_transport_substrates_L4_Loc2_Corn"> 2.686, 

   <"op_transport_substrates_L4_Loc2_Grass"> 2.686, 

   <"op_transport_substrates_L4_Loc2_Inter"> 2.686,

   <"op_transport_substrates_L4_Loc2_Manure"> 1.35, 

   <"op_transport_substrates_L4_Loc3_Corn"> 3.617, 

   <"op_transport_substrates_L4_Loc3_Grass"> 3.617, 

   <"op_transport_substrates_L4_Loc3_Inter"> 3.617, 

   <"op_transport_substrates_L4_Loc3_Manure"> 1.825,

   <"op_transport_substrates_L5_Loc1_Corn"> 2.147, 

   <"op_transport_substrates_L5_Loc1_Grass"> 2.147, 

   <"op_transport_substrates_L5_Loc1_Inter"> 2.147, 

   <"op_transport_substrates_L5_Loc1_Manure"> 1.075, 

   <"op_transport_substrates_L5_Loc2_Corn"> 3.029,

   <"op_transport_substrates_L5_Loc2_Grass"> 3.029, 

   <"op_transport_substrates_L5_Loc2_Inter"> 3.029, 

   <"op_transport_substrates_L5_Loc2_Manure"> 1.525, 

   <"op_transport_substrates_L5_Loc3_Corn"> 3.029, 

   <"op_transport_substrates_L5_Loc3_Grass"> 3.029,

   <"op_transport_substrates_L5_Loc3_Inter"> 3.029, 

   <"op_transport_substrates_L5_Loc3_Manure"> 1.525, 

   <"op_transport_substrates_L6_Loc1_Corn"> 2.735, 

   <"op_transport_substrates_L6_Loc1_Grass"> 2.735, 

   <"op_transport_substrates_L6_Loc1_Inter"> 2.735,

   <"op_transport_substrates_L6_Loc1_Manure"> 1.375, 

   <"op_transport_substrates_L6_Loc2_Corn"> 3.421, 

   <"op_transport_substrates_L6_Loc2_Grass"> 3.421, 

   <"op_transport_substrates_L6_Loc2_Inter"> 3.421, 

   <"op_transport_substrates_L6_Loc2_Manure"> 1.725,

   <"op_transport_substrates_L6_Loc3_Corn"> 3.47, 

   <"op_transport_substrates_L6_Loc3_Grass"> 3.47, 

   <"op_transport_substrates_L6_Loc3_Inter"> 3.47, 

   <"op_transport_substrates_L6_Loc3_Manure"> 1.75, 

   <"op_transport_substrates_L7_Loc1_Corn"> 3.519,

   <"op_transport_substrates_L7_Loc1_Grass"> 3.519, 

   <"op_transport_substrates_L7_Loc1_Inter"> 3.519, 

   <"op_transport_substrates_L7_Loc1_Manure"> 1.775, 

   <"op_transport_substrates_L7_Loc2_Corn"> 3.47, 

   <"op_transport_substrates_L7_Loc2_Grass"> 3.47,

   <"op_transport_substrates_L7_Loc2_Inter"> 3.47, 

   <"op_transport_substrates_L7_Loc2_Manure"> 1.75, 

   <"op_transport_substrates_L7_Loc3_Corn"> 3.176, 

   <"op_transport_substrates_L7_Loc3_Grass"> 3.176, 

   <"op_transport_substrates_L7_Loc3_Inter"> 3.176,

   <"op_transport_substrates_L7_Loc3_Manure"> 1.6, 

   <"op_transport_substrates_L8_Loc1_Corn"> 3.862, 

   <"op_transport_substrates_L8_Loc1_Grass"> 3.862, 

   <"op_transport_substrates_L8_Loc1_Inter"> 3.862, 

   <"op_transport_substrates_L8_Loc1_Manure"> 1.95,

   <"op_transport_substrates_L8_Loc2_Corn"> 2.931, 

   <"op_transport_substrates_L8_Loc2_Grass"> 2.931, 

   <"op_transport_substrates_L8_Loc2_Inter"> 2.931, 

   <"op_transport_substrates_L8_Loc2_Manure"> 1.475, 

   <"op_transport_substrates_L8_Loc3_Corn"> 3.813,

   <"op_transport_substrates_L8_Loc3_Grass"> 3.813, 

   <"op_transport_substrates_L8_Loc3_Inter"> 3.813, 

   <"op_transport_substrates_L8_Loc3_Manure"> 1.925, 

   <"process_Loc1_K160_No0_Corn"> 14.0361, 

   <"process_Loc1_K160_No0_Grass"> 13.1321,

   <"process_Loc1_K160_No0_Inter"> 10.1352, 

   <"process_Loc1_K160_No0_Manure"> 3.72988, 

   <"process_Loc1_K160_No0_slack"> 55.9483, 

   <"process_Loc1_K160_No1_Corn"> 14.0361, 

   <"process_Loc1_K160_No1_Grass"> 13.1321,

   <"process_Loc1_K160_No1_Inter"> 10.1352, 

   <"process_Loc1_K160_No1_Manure"> 3.72988, 

   <"process_Loc1_K160_No1_slack"> 55.9483, 

   <"process_Loc1_K250_No0_Corn"> 11.9184, 

   <"process_Loc1_K250_No0_Grass"> 10.2319,

   <"process_Loc1_K250_No0_Inter"> 8.13914, 

   <"process_Loc1_K250_No0_Manure"> 3.17777, 

   <"process_Loc1_K250_No0_slack"> 47.6665, 

   <"process_Loc1_K250_No1_Corn"> 11.9184, 

   <"process_Loc1_K250_No1_Grass"> 10.2319,

   <"process_Loc1_K250_No1_Inter"> 8.13914, 

   <"process_Loc1_K250_No1_Manure"> 3.17777, 

   <"process_Loc1_K250_No1_slack"> 47.6665, 

   <"process_Loc1_K500_No0_Corn"> 8.99154, 

   <"process_Loc1_K500_No0_Grass"> 5.90581,

   <"process_Loc1_K500_No0_Inter"> 6.87805, 

   <"process_Loc1_K500_No0_Manure"> 3.14599, 

   <"process_Loc1_K500_No0_slack"> 47.1898, 

   <"process_Loc1_K500_No1_Corn"> 8.99154, 

   <"process_Loc1_K500_No1_Grass"> 5.90581,

   <"process_Loc1_K500_No1_Inter"> 6.87805, 

   <"process_Loc1_K500_No1_Manure"> 3.14599, 

   <"process_Loc1_K500_No1_slack"> 47.1898, 

   <"process_Loc1_K80_No0_Corn"> 17.8313, 

   <"process_Loc1_K80_No0_Grass"> 16.456,

   <"process_Loc1_K80_No0_Inter"> 12.4745, 

   <"process_Loc1_K80_No0_Manure"> 3.9529, 

   <"process_Loc1_K80_No0_slack"> 59.2935, 

   <"process_Loc1_K80_No1_Corn"> 17.8313, 

   <"process_Loc1_K80_No1_Grass"> 16.456,

   <"process_Loc1_K80_No1_Inter"> 12.4745, 

   <"process_Loc1_K80_No1_Manure"> 3.9529, 

   <"process_Loc1_K80_No1_slack"> 59.2935, 

   <"process_Loc2_K160_No0_Corn"> 14.0361, 

   <"process_Loc2_K160_No0_Grass"> 13.1321,

   <"process_Loc2_K160_No0_Inter"> 10.1352, 

   <"process_Loc2_K160_No0_Manure"> 3.72988, 

   <"process_Loc2_K160_No0_slack"> 55.9483, 

   <"process_Loc2_K160_No1_Corn"> 14.0361, 

   <"process_Loc2_K160_No1_Grass"> 13.1321,

   <"process_Loc2_K160_No1_Inter"> 10.1352, 

   <"process_Loc2_K160_No1_Manure"> 3.72988, 

   <"process_Loc2_K160_No1_slack"> 55.9483, 

   <"process_Loc2_K250_No0_Corn"> 11.9184, 

   <"process_Loc2_K250_No0_Grass"> 10.2319,

   <"process_Loc2_K250_No0_Inter"> 8.13914, 

   <"process_Loc2_K250_No0_Manure"> 3.17777, 

   <"process_Loc2_K250_No0_slack"> 47.6665, 

   <"process_Loc2_K250_No1_Corn"> 11.9184, 

   <"process_Loc2_K250_No1_Grass"> 10.2319,

   <"process_Loc2_K250_No1_Inter"> 8.13914, 

   <"process_Loc2_K250_No1_Manure"> 3.17777, 

   <"process_Loc2_K250_No1_slack"> 47.6665, 

   <"process_Loc2_K500_No0_Corn"> 8.99154, 

   <"process_Loc2_K500_No0_Grass"> 5.90581,

   <"process_Loc2_K500_No0_Inter"> 6.87805, 

   <"process_Loc2_K500_No0_Manure"> 3.14599, 

   <"process_Loc2_K500_No0_slack"> 47.1898, 

   <"process_Loc2_K500_No1_Corn"> 8.99154, 

   <"process_Loc2_K500_No1_Grass"> 5.90581,

   <"process_Loc2_K500_No1_Inter"> 6.87805, 

   <"process_Loc2_K500_No1_Manure"> 3.14599, 

   <"process_Loc2_K500_No1_slack"> 47.1898, 

   <"process_Loc2_K80_No0_Corn"> 17.8313, 

   <"process_Loc2_K80_No0_Grass"> 16.456,

   <"process_Loc2_K80_No0_Inter"> 12.4745, 

   <"process_Loc2_K80_No0_Manure"> 3.9529, 

   <"process_Loc2_K80_No0_slack"> 59.2935, 

   <"process_Loc2_K80_No1_Corn"> 17.8313, 

   <"process_Loc2_K80_No1_Grass"> 16.456,

   <"process_Loc2_K80_No1_Inter"> 12.4745, 

   <"process_Loc2_K80_No1_Manure"> 3.9529, 

   <"process_Loc2_K80_No1_slack"> 59.2935, 

   <"process_Loc3_K160_No0_Corn"> 14.0361, 

   <"process_Loc3_K160_No0_Grass"> 13.1321,

   <"process_Loc3_K160_No0_Inter"> 10.1352, 

   <"process_Loc3_K160_No0_Manure"> 3.72988, 

   <"process_Loc3_K160_No0_slack"> 55.9483, 

   <"process_Loc3_K160_No1_Corn"> 14.0361, 

   <"process_Loc3_K160_No1_Grass"> 13.1321,

   <"process_Loc3_K160_No1_Inter"> 10.1352, 

   <"process_Loc3_K160_No1_Manure"> 3.72988, 

   <"process_Loc3_K160_No1_slack"> 55.9483, 

   <"process_Loc3_K250_No0_Corn"> 11.9184, 

   <"process_Loc3_K250_No0_Grass"> 10.2319,

   <"process_Loc3_K250_No0_Inter"> 8.13914, 

   <"process_Loc3_K250_No0_Manure"> 3.17777, 

   <"process_Loc3_K250_No0_slack"> 47.6665, 

   <"process_Loc3_K250_No1_Corn"> 11.9184, 

   <"process_Loc3_K250_No1_Grass"> 10.2319,

   <"process_Loc3_K250_No1_Inter"> 8.13914, 

   <"process_Loc3_K250_No1_Manure"> 3.17777, 

   <"process_Loc3_K250_No1_slack"> 47.6665, 

   <"process_Loc3_K500_No0_Corn"> 8.99154, 

   <"process_Loc3_K500_No0_Grass"> 5.90581,

   <"process_Loc3_K500_No0_Inter"> 6.87805, 

   <"process_Loc3_K500_No0_Manure"> 3.14599, 

   <"process_Loc3_K500_No0_slack"> 47.1898, 

   <"process_Loc3_K500_No1_Corn"> 8.99154, 

   <"process_Loc3_K500_No1_Grass"> 5.90581,

   <"process_Loc3_K500_No1_Inter"> 6.87805, 

   <"process_Loc3_K500_No1_Manure"> 3.14599, 

   <"process_Loc3_K500_No1_slack"> 47.1898, 

   <"process_Loc3_K80_No0_Corn"> 17.8313, 

   <"process_Loc3_K80_No0_Grass"> 16.456,

   <"process_Loc3_K80_No0_Inter"> 12.4745, 

   <"process_Loc3_K80_No0_Manure"> 3.9529, 

   <"process_Loc3_K80_No0_slack"> 59.2935, 

   <"process_Loc3_K80_No1_Corn"> 17.8313, 

   <"process_Loc3_K80_No1_Grass"> 16.456,

   <"process_Loc3_K80_No1_Inter"> 12.4745, 

   <"process_Loc3_K80_No1_Manure"> 3.9529, 

   <"process_Loc3_K80_No1_slack"> 59.2935, 

   <"purchase_heat_Loc1"> 0, 

   <"purchase_heat_Loc2"> 0,

   <"purchase_heat_Loc3"> 0, 

   <"save_heat_Loc1"> 0, 

   <"save_heat_Loc2"> 0, 

   <"save_heat_Loc3"> 0, 

   <"sell_electricity_K160"> 0,

   <"sell_electricity_K250"> 0, 

   <"sell_electricity_K500"> 0, 

   <"sell_electricity_K80"> 0, 

   <"sell_heat"> 0, 

   <"silo_plate_Loc1"> 0,

   <"silo_plate_Loc2"> 0, 

   <"silo_plate_Loc3"> 0, 

   <"transfer_biogas_Loc1"> 0, 

   <"transfer_biogas_Loc2"> 0, 

   <"transfer_biogas_Loc3"> 0,

   <"transfer_heat_Loc1"> 0.75, 

   <"transfer_heat_Loc2"> 0.75, 

   <"transfer_heat_Loc3"> 0.75, 

   <"transformer_op_unit"> 0
   default 0;



# Input and output flow rates of materials to operating units

param material_to_operating_unit_flow_rates[materials*operating_units] := 



 # biogas_pipe_Pipe1:

    <"biogas_pipe_availability_material_Pipe1", "biogas_pipe_Pipe1"> 1,

 # biogas_pipe_Pipe2:

    <"biogas_pipe_availability_material_Pipe2", "biogas_pipe_Pipe2"> 1,

 # biogas_pipe_Pipe3to1:

    <"biogas_pipe_availability_material_Pipe3to1", "biogas_pipe_Pipe3to1"> 1,

 # chp_CENTER_K160_No0:

    <"biogas_CENTER", "chp_CENTER_K160_No0"> -41.0256,

    <"electricity_K160", "chp_CENTER_K160_No0"> 0.16,

    <"heat_balance_CENTER", "chp_CENTER_K160_No0"> 0.23,

    <"transformer_availability_material", "chp_CENTER_K160_No0"> -1,

 # chp_CENTER_K160_No1:

    <"biogas_CENTER", "chp_CENTER_K160_No1"> -41.0256,

    <"electricity_K160", "chp_CENTER_K160_No1"> 0.16,

    <"heat_balance_CENTER", "chp_CENTER_K160_No1"> 0.23,

    <"transformer_availability_material", "chp_CENTER_K160_No1"> -1,

 # chp_CENTER_K160_No2:

    <"biogas_CENTER", "chp_CENTER_K160_No2"> -41.0256,

    <"electricity_K160", "chp_CENTER_K160_No2"> 0.16,

    <"heat_balance_CENTER", "chp_CENTER_K160_No2"> 0.23,

    <"transformer_availability_material", "chp_CENTER_K160_No2"> -1,

 # chp_CENTER_K250_No0:

    <"biogas_CENTER", "chp_CENTER_K250_No0"> -64.1026,

    <"electricity_K250", "chp_CENTER_K250_No0"> 0.25,

    <"heat_balance_CENTER", "chp_CENTER_K250_No0"> 0.3,

    <"transformer_availability_material", "chp_CENTER_K250_No0"> -1,

 # chp_CENTER_K250_No1:

    <"biogas_CENTER", "chp_CENTER_K250_No1"> -64.1026,

    <"electricity_K250", "chp_CENTER_K250_No1"> 0.25,

    <"heat_balance_CENTER", "chp_CENTER_K250_No1"> 0.3,

    <"transformer_availability_material", "chp_CENTER_K250_No1"> -1,

 # chp_CENTER_K250_No2:

    <"biogas_CENTER", "chp_CENTER_K250_No2"> -64.1026,

    <"electricity_K250", "chp_CENTER_K250_No2"> 0.25,

    <"heat_balance_CENTER", "chp_CENTER_K250_No2"> 0.3,

    <"transformer_availability_material", "chp_CENTER_K250_No2"> -1,

 # chp_CENTER_K500_No0:

    <"biogas_CENTER", "chp_CENTER_K500_No0"> -128.205,

    <"electricity_K500", "chp_CENTER_K500_No0"> 0.5,

    <"heat_balance_CENTER", "chp_CENTER_K500_No0"> 0.56,

    <"transformer_availability_material", "chp_CENTER_K500_No0"> -1,

 # chp_CENTER_K500_No1:

    <"biogas_CENTER", "chp_CENTER_K500_No1"> -128.205,

    <"electricity_K500", "chp_CENTER_K500_No1"> 0.5,

    <"heat_balance_CENTER", "chp_CENTER_K500_No1"> 0.56,

    <"transformer_availability_material", "chp_CENTER_K500_No1"> -1,

 # chp_CENTER_K500_No2:

    <"biogas_CENTER", "chp_CENTER_K500_No2"> -128.205,

    <"electricity_K500", "chp_CENTER_K500_No2"> 0.5,

    <"heat_balance_CENTER", "chp_CENTER_K500_No2"> 0.56,

    <"transformer_availability_material", "chp_CENTER_K500_No2"> -1,

 # chp_CENTER_K80_No0:

    <"biogas_CENTER", "chp_CENTER_K80_No0"> -20.5128,

    <"electricity_K80", "chp_CENTER_K80_No0"> 0.08,

    <"heat_balance_CENTER", "chp_CENTER_K80_No0"> 0.105,

    <"transformer_availability_material", "chp_CENTER_K80_No0"> -1,

 # chp_CENTER_K80_No1:

    <"biogas_CENTER", "chp_CENTER_K80_No1"> -20.5128,

    <"electricity_K80", "chp_CENTER_K80_No1"> 0.08,

    <"heat_balance_CENTER", "chp_CENTER_K80_No1"> 0.105,

    <"transformer_availability_material", "chp_CENTER_K80_No1"> -1,

 # chp_CENTER_K80_No2:

    <"biogas_CENTER", "chp_CENTER_K80_No2"> -20.5128,

    <"electricity_K80", "chp_CENTER_K80_No2"> 0.08,

    <"heat_balance_CENTER", "chp_CENTER_K80_No2"> 0.105,

    <"transformer_availability_material", "chp_CENTER_K80_No2"> -1,

 # chp_Loc1_K160_No0:

    <"biogas_Loc1", "chp_Loc1_K160_No0"> -41.0256,

    <"electricity_K160", "chp_Loc1_K160_No0"> 0.16,

    <"heat_balance_Loc1", "chp_Loc1_K160_No0"> 0.23,

    <"transformer_availability_material", "chp_Loc1_K160_No0"> -1,

 # chp_Loc1_K160_No1:

    <"biogas_Loc1", "chp_Loc1_K160_No1"> -41.0256,

    <"electricity_K160", "chp_Loc1_K160_No1"> 0.16,

    <"heat_balance_Loc1", "chp_Loc1_K160_No1"> 0.23,

    <"transformer_availability_material", "chp_Loc1_K160_No1"> -1,

 # chp_Loc1_K160_No2:

    <"biogas_Loc1", "chp_Loc1_K160_No2"> -41.0256,

    <"electricity_K160", "chp_Loc1_K160_No2"> 0.16,

    <"heat_balance_Loc1", "chp_Loc1_K160_No2"> 0.23,

    <"transformer_availability_material", "chp_Loc1_K160_No2"> -1,

 # chp_Loc1_K250_No0:

    <"biogas_Loc1", "chp_Loc1_K250_No0"> -64.1026,

    <"electricity_K250", "chp_Loc1_K250_No0"> 0.25,

    <"heat_balance_Loc1", "chp_Loc1_K250_No0"> 0.3,

    <"transformer_availability_material", "chp_Loc1_K250_No0"> -1,

 # chp_Loc1_K250_No1:

    <"biogas_Loc1", "chp_Loc1_K250_No1"> -64.1026,

    <"electricity_K250", "chp_Loc1_K250_No1"> 0.25,

    <"heat_balance_Loc1", "chp_Loc1_K250_No1"> 0.3,

    <"transformer_availability_material", "chp_Loc1_K250_No1"> -1,

 # chp_Loc1_K250_No2:

    <"biogas_Loc1", "chp_Loc1_K250_No2"> -64.1026,

    <"electricity_K250", "chp_Loc1_K250_No2"> 0.25,

    <"heat_balance_Loc1", "chp_Loc1_K250_No2"> 0.3,

    <"transformer_availability_material", "chp_Loc1_K250_No2"> -1,

 # chp_Loc1_K500_No0:

    <"biogas_Loc1", "chp_Loc1_K500_No0"> -128.205,

    <"electricity_K500", "chp_Loc1_K500_No0"> 0.5,

    <"heat_balance_Loc1", "chp_Loc1_K500_No0"> 0.56,

    <"transformer_availability_material", "chp_Loc1_K500_No0"> -1,

 # chp_Loc1_K500_No1:

    <"biogas_Loc1", "chp_Loc1_K500_No1"> -128.205,

    <"electricity_K500", "chp_Loc1_K500_No1"> 0.5,

    <"heat_balance_Loc1", "chp_Loc1_K500_No1"> 0.56,

    <"transformer_availability_material", "chp_Loc1_K500_No1"> -1,

 # chp_Loc1_K500_No2:

    <"biogas_Loc1", "chp_Loc1_K500_No2"> -128.205,

    <"electricity_K500", "chp_Loc1_K500_No2"> 0.5,

    <"heat_balance_Loc1", "chp_Loc1_K500_No2"> 0.56,

    <"transformer_availability_material", "chp_Loc1_K500_No2"> -1,

 # chp_Loc1_K80_No0:

    <"biogas_Loc1", "chp_Loc1_K80_No0"> -20.5128,

    <"electricity_K80", "chp_Loc1_K80_No0"> 0.08,

    <"heat_balance_Loc1", "chp_Loc1_K80_No0"> 0.105,

    <"transformer_availability_material", "chp_Loc1_K80_No0"> -1,

 # chp_Loc1_K80_No1:

    <"biogas_Loc1", "chp_Loc1_K80_No1"> -20.5128,

    <"electricity_K80", "chp_Loc1_K80_No1"> 0.08,

    <"heat_balance_Loc1", "chp_Loc1_K80_No1"> 0.105,

    <"transformer_availability_material", "chp_Loc1_K80_No1"> -1,

 # chp_Loc1_K80_No2:

    <"biogas_Loc1", "chp_Loc1_K80_No2"> -20.5128,

    <"electricity_K80", "chp_Loc1_K80_No2"> 0.08,

    <"heat_balance_Loc1", "chp_Loc1_K80_No2"> 0.105,

    <"transformer_availability_material", "chp_Loc1_K80_No2"> -1,

 # chp_Loc2_K160_No0:

    <"biogas_Loc2", "chp_Loc2_K160_No0"> -41.0256,

    <"electricity_K160", "chp_Loc2_K160_No0"> 0.16,

    <"heat_balance_Loc2", "chp_Loc2_K160_No0"> 0.23,

    <"transformer_availability_material", "chp_Loc2_K160_No0"> -1,

 # chp_Loc2_K160_No1:

    <"biogas_Loc2", "chp_Loc2_K160_No1"> -41.0256,

    <"electricity_K160", "chp_Loc2_K160_No1"> 0.16,

    <"heat_balance_Loc2", "chp_Loc2_K160_No1"> 0.23,

    <"transformer_availability_material", "chp_Loc2_K160_No1"> -1,

 # chp_Loc2_K160_No2:

    <"biogas_Loc2", "chp_Loc2_K160_No2"> -41.0256,

    <"electricity_K160", "chp_Loc2_K160_No2"> 0.16,

    <"heat_balance_Loc2", "chp_Loc2_K160_No2"> 0.23,

    <"transformer_availability_material", "chp_Loc2_K160_No2"> -1,

 # chp_Loc2_K250_No0:

    <"biogas_Loc2", "chp_Loc2_K250_No0"> -64.1026,

    <"electricity_K250", "chp_Loc2_K250_No0"> 0.25,

    <"heat_balance_Loc2", "chp_Loc2_K250_No0"> 0.3,

    <"transformer_availability_material", "chp_Loc2_K250_No0"> -1,

 # chp_Loc2_K250_No1:

    <"biogas_Loc2", "chp_Loc2_K250_No1"> -64.1026,

    <"electricity_K250", "chp_Loc2_K250_No1"> 0.25,

    <"heat_balance_Loc2", "chp_Loc2_K250_No1"> 0.3,

    <"transformer_availability_material", "chp_Loc2_K250_No1"> -1,

 # chp_Loc2_K250_No2:

    <"biogas_Loc2", "chp_Loc2_K250_No2"> -64.1026,

    <"electricity_K250", "chp_Loc2_K250_No2"> 0.25,

    <"heat_balance_Loc2", "chp_Loc2_K250_No2"> 0.3,

    <"transformer_availability_material", "chp_Loc2_K250_No2"> -1,

 # chp_Loc2_K500_No0:

    <"biogas_Loc2", "chp_Loc2_K500_No0"> -128.205,

    <"electricity_K500", "chp_Loc2_K500_No0"> 0.5,

    <"heat_balance_Loc2", "chp_Loc2_K500_No0"> 0.56,

    <"transformer_availability_material", "chp_Loc2_K500_No0"> -1,

 # chp_Loc2_K500_No1:

    <"biogas_Loc2", "chp_Loc2_K500_No1"> -128.205,

    <"electricity_K500", "chp_Loc2_K500_No1"> 0.5,

    <"heat_balance_Loc2", "chp_Loc2_K500_No1"> 0.56,

    <"transformer_availability_material", "chp_Loc2_K500_No1"> -1,

 # chp_Loc2_K500_No2:

    <"biogas_Loc2", "chp_Loc2_K500_No2"> -128.205,

    <"electricity_K500", "chp_Loc2_K500_No2"> 0.5,

    <"heat_balance_Loc2", "chp_Loc2_K500_No2"> 0.56,

    <"transformer_availability_material", "chp_Loc2_K500_No2"> -1,

 # chp_Loc2_K80_No0:

    <"biogas_Loc2", "chp_Loc2_K80_No0"> -20.5128,

    <"electricity_K80", "chp_Loc2_K80_No0"> 0.08,

    <"heat_balance_Loc2", "chp_Loc2_K80_No0"> 0.105,

    <"transformer_availability_material", "chp_Loc2_K80_No0"> -1,

 # chp_Loc2_K80_No1:

    <"biogas_Loc2", "chp_Loc2_K80_No1"> -20.5128,

    <"electricity_K80", "chp_Loc2_K80_No1"> 0.08,

    <"heat_balance_Loc2", "chp_Loc2_K80_No1"> 0.105,

    <"transformer_availability_material", "chp_Loc2_K80_No1"> -1,

 # chp_Loc2_K80_No2:

    <"biogas_Loc2", "chp_Loc2_K80_No2"> -20.5128,

    <"electricity_K80", "chp_Loc2_K80_No2"> 0.08,

    <"heat_balance_Loc2", "chp_Loc2_K80_No2"> 0.105,

    <"transformer_availability_material", "chp_Loc2_K80_No2"> -1,

 # chp_Loc3_K160_No0:

    <"biogas_Loc3", "chp_Loc3_K160_No0"> -41.0256,

    <"electricity_K160", "chp_Loc3_K160_No0"> 0.16,

    <"heat_balance_Loc3", "chp_Loc3_K160_No0"> 0.23,

    <"transformer_availability_material", "chp_Loc3_K160_No0"> -1,

 # chp_Loc3_K160_No1:

    <"biogas_Loc3", "chp_Loc3_K160_No1"> -41.0256,

    <"electricity_K160", "chp_Loc3_K160_No1"> 0.16,

    <"heat_balance_Loc3", "chp_Loc3_K160_No1"> 0.23,

    <"transformer_availability_material", "chp_Loc3_K160_No1"> -1,

 # chp_Loc3_K160_No2:

    <"biogas_Loc3", "chp_Loc3_K160_No2"> -41.0256,

    <"electricity_K160", "chp_Loc3_K160_No2"> 0.16,

    <"heat_balance_Loc3", "chp_Loc3_K160_No2"> 0.23,

    <"transformer_availability_material", "chp_Loc3_K160_No2"> -1,

 # chp_Loc3_K250_No0:

    <"biogas_Loc3", "chp_Loc3_K250_No0"> -64.1026,

    <"electricity_K250", "chp_Loc3_K250_No0"> 0.25,

    <"heat_balance_Loc3", "chp_Loc3_K250_No0"> 0.3,

    <"transformer_availability_material", "chp_Loc3_K250_No0"> -1,

 # chp_Loc3_K250_No1:

    <"biogas_Loc3", "chp_Loc3_K250_No1"> -64.1026,

    <"electricity_K250", "chp_Loc3_K250_No1"> 0.25,

    <"heat_balance_Loc3", "chp_Loc3_K250_No1"> 0.3,

    <"transformer_availability_material", "chp_Loc3_K250_No1"> -1,

 # chp_Loc3_K250_No2:

    <"biogas_Loc3", "chp_Loc3_K250_No2"> -64.1026,

    <"electricity_K250", "chp_Loc3_K250_No2"> 0.25,

    <"heat_balance_Loc3", "chp_Loc3_K250_No2"> 0.3,

    <"transformer_availability_material", "chp_Loc3_K250_No2"> -1,

 # chp_Loc3_K500_No0:

    <"biogas_Loc3", "chp_Loc3_K500_No0"> -128.205,

    <"electricity_K500", "chp_Loc3_K500_No0"> 0.5,

    <"heat_balance_Loc3", "chp_Loc3_K500_No0"> 0.56,

    <"transformer_availability_material", "chp_Loc3_K500_No0"> -1,

 # chp_Loc3_K500_No1:

    <"biogas_Loc3", "chp_Loc3_K500_No1"> -128.205,

    <"electricity_K500", "chp_Loc3_K500_No1"> 0.5,

    <"heat_balance_Loc3", "chp_Loc3_K500_No1"> 0.56,

    <"transformer_availability_material", "chp_Loc3_K500_No1"> -1,

 # chp_Loc3_K500_No2:

    <"biogas_Loc3", "chp_Loc3_K500_No2"> -128.205,

    <"electricity_K500", "chp_Loc3_K500_No2"> 0.5,

    <"heat_balance_Loc3", "chp_Loc3_K500_No2"> 0.56,

    <"transformer_availability_material", "chp_Loc3_K500_No2"> -1,

 # chp_Loc3_K80_No0:

    <"biogas_Loc3", "chp_Loc3_K80_No0"> -20.5128,

    <"electricity_K80", "chp_Loc3_K80_No0"> 0.08,

    <"heat_balance_Loc3", "chp_Loc3_K80_No0"> 0.105,

    <"transformer_availability_material", "chp_Loc3_K80_No0"> -1,

 # chp_Loc3_K80_No1:

    <"biogas_Loc3", "chp_Loc3_K80_No1"> -20.5128,

    <"electricity_K80", "chp_Loc3_K80_No1"> 0.08,

    <"heat_balance_Loc3", "chp_Loc3_K80_No1"> 0.105,

    <"transformer_availability_material", "chp_Loc3_K80_No1"> -1,

 # chp_Loc3_K80_No2:

    <"biogas_Loc3", "chp_Loc3_K80_No2"> -20.5128,

    <"electricity_K80", "chp_Loc3_K80_No2"> 0.08,

    <"heat_balance_Loc3", "chp_Loc3_K80_No2"> 0.105,

    <"transformer_availability_material", "chp_Loc3_K80_No2"> -1,

 # collect_heat_loss_op_unit_Loc1_Pipe1:

    <"collected_heat_loss_Pipe1", "collect_heat_loss_op_unit_Loc1_Pipe1"> 1,

    <"heat_sent_Loc1", "collect_heat_loss_op_unit_Loc1_Pipe1"> -1,

 # collect_heat_loss_op_unit_Loc2_Pipe2:

    <"collected_heat_loss_Pipe2", "collect_heat_loss_op_unit_Loc2_Pipe2"> 1,

    <"heat_sent_Loc2", "collect_heat_loss_op_unit_Loc2_Pipe2"> -1,

 # collect_heat_loss_op_unit_Loc3_Pipe1:

    <"collected_heat_loss_Pipe1", "collect_heat_loss_op_unit_Loc3_Pipe1"> 1,

    <"heat_sent_Loc3", "collect_heat_loss_op_unit_Loc3_Pipe1"> -1,

 # collect_heat_loss_op_unit_Loc3_Pipe3to1:

    <"collected_heat_loss_Pipe3to1", "collect_heat_loss_op_unit_Loc3_Pipe3to1"> 1,

    <"heat_sent_Loc3", "collect_heat_loss_op_unit_Loc3_Pipe3to1"> -1,

 # heat_pipe_provide_availability_Pipe1:

    <"collected_heat_loss_Pipe1", "heat_pipe_provide_availability_Pipe1"> -1,

    <"heat_pipe_availability_material_Loc1_Pipe1", "heat_pipe_provide_availability_Pipe1"> 1e+006,

    <"heat_pipe_availability_material_Loc3_Pipe1", "heat_pipe_provide_availability_Pipe1"> 1e+006,

 # heat_pipe_provide_availability_Pipe2:

    <"collected_heat_loss_Pipe2", "heat_pipe_provide_availability_Pipe2"> -1,

    <"heat_pipe_availability_material_Loc2_Pipe2", "heat_pipe_provide_availability_Pipe2"> 1e+006,

 # heat_pipe_provide_availability_Pipe3to1:

    <"collected_heat_loss_Pipe3to1", "heat_pipe_provide_availability_Pipe3to1"> -1,

    <"heat_pipe_availability_material_Loc3_Pipe3to1", "heat_pipe_provide_availability_Pipe3to1"> 1e+006,

 # invest_fermenter_Loc1_K160_No0:

    <"capacity_in_Loc1_K160_No0", "invest_fermenter_Loc1_K160_No0"> 1,

    <"capacity_out_Loc1_K160_No0", "invest_fermenter_Loc1_K160_No0"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K160_No0"> -1,

 # invest_fermenter_Loc1_K160_No1:

    <"capacity_in_Loc1_K160_No1", "invest_fermenter_Loc1_K160_No1"> 1,

    <"capacity_out_Loc1_K160_No1", "invest_fermenter_Loc1_K160_No1"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K160_No1"> -1,

 # invest_fermenter_Loc1_K250_No0:

    <"capacity_in_Loc1_K250_No0", "invest_fermenter_Loc1_K250_No0"> 1,

    <"capacity_out_Loc1_K250_No0", "invest_fermenter_Loc1_K250_No0"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K250_No0"> -1,

 # invest_fermenter_Loc1_K250_No1:

    <"capacity_in_Loc1_K250_No1", "invest_fermenter_Loc1_K250_No1"> 1,

    <"capacity_out_Loc1_K250_No1", "invest_fermenter_Loc1_K250_No1"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K250_No1"> -1,

 # invest_fermenter_Loc1_K500_No0:

    <"capacity_in_Loc1_K500_No0", "invest_fermenter_Loc1_K500_No0"> 1,

    <"capacity_out_Loc1_K500_No0", "invest_fermenter_Loc1_K500_No0"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K500_No0"> -1,

 # invest_fermenter_Loc1_K500_No1:

    <"capacity_in_Loc1_K500_No1", "invest_fermenter_Loc1_K500_No1"> 1,

    <"capacity_out_Loc1_K500_No1", "invest_fermenter_Loc1_K500_No1"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K500_No1"> -1,

 # invest_fermenter_Loc1_K80_No0:

    <"capacity_in_Loc1_K80_No0", "invest_fermenter_Loc1_K80_No0"> 1,

    <"capacity_out_Loc1_K80_No0", "invest_fermenter_Loc1_K80_No0"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K80_No0"> -1,

 # invest_fermenter_Loc1_K80_No1:

    <"capacity_in_Loc1_K80_No1", "invest_fermenter_Loc1_K80_No1"> 1,

    <"capacity_out_Loc1_K80_No1", "invest_fermenter_Loc1_K80_No1"> -1,

    <"silo_plate_availability_material_Loc1", "invest_fermenter_Loc1_K80_No1"> -1,

 # invest_fermenter_Loc2_K160_No0:

    <"capacity_in_Loc2_K160_No0", "invest_fermenter_Loc2_K160_No0"> 1,

    <"capacity_out_Loc2_K160_No0", "invest_fermenter_Loc2_K160_No0"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K160_No0"> -1,

 # invest_fermenter_Loc2_K160_No1:

    <"capacity_in_Loc2_K160_No1", "invest_fermenter_Loc2_K160_No1"> 1,

    <"capacity_out_Loc2_K160_No1", "invest_fermenter_Loc2_K160_No1"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K160_No1"> -1,

 # invest_fermenter_Loc2_K250_No0:

    <"capacity_in_Loc2_K250_No0", "invest_fermenter_Loc2_K250_No0"> 1,

    <"capacity_out_Loc2_K250_No0", "invest_fermenter_Loc2_K250_No0"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K250_No0"> -1,

 # invest_fermenter_Loc2_K250_No1:

    <"capacity_in_Loc2_K250_No1", "invest_fermenter_Loc2_K250_No1"> 1,

    <"capacity_out_Loc2_K250_No1", "invest_fermenter_Loc2_K250_No1"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K250_No1"> -1,

 # invest_fermenter_Loc2_K500_No0:

    <"capacity_in_Loc2_K500_No0", "invest_fermenter_Loc2_K500_No0"> 1,

    <"capacity_out_Loc2_K500_No0", "invest_fermenter_Loc2_K500_No0"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K500_No0"> -1,

 # invest_fermenter_Loc2_K500_No1:

    <"capacity_in_Loc2_K500_No1", "invest_fermenter_Loc2_K500_No1"> 1,

    <"capacity_out_Loc2_K500_No1", "invest_fermenter_Loc2_K500_No1"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K500_No1"> -1,

 # invest_fermenter_Loc2_K80_No0:

    <"capacity_in_Loc2_K80_No0", "invest_fermenter_Loc2_K80_No0"> 1,

    <"capacity_out_Loc2_K80_No0", "invest_fermenter_Loc2_K80_No0"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K80_No0"> -1,

 # invest_fermenter_Loc2_K80_No1:

    <"capacity_in_Loc2_K80_No1", "invest_fermenter_Loc2_K80_No1"> 1,

    <"capacity_out_Loc2_K80_No1", "invest_fermenter_Loc2_K80_No1"> -1,

    <"silo_plate_availability_material_Loc2", "invest_fermenter_Loc2_K80_No1"> -1,

 # invest_fermenter_Loc3_K160_No0:

    <"capacity_in_Loc3_K160_No0", "invest_fermenter_Loc3_K160_No0"> 1,

    <"capacity_out_Loc3_K160_No0", "invest_fermenter_Loc3_K160_No0"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K160_No0"> -1,

 # invest_fermenter_Loc3_K160_No1:

    <"capacity_in_Loc3_K160_No1", "invest_fermenter_Loc3_K160_No1"> 1,

    <"capacity_out_Loc3_K160_No1", "invest_fermenter_Loc3_K160_No1"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K160_No1"> -1,

 # invest_fermenter_Loc3_K250_No0:

    <"capacity_in_Loc3_K250_No0", "invest_fermenter_Loc3_K250_No0"> 1,

    <"capacity_out_Loc3_K250_No0", "invest_fermenter_Loc3_K250_No0"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K250_No0"> -1,

 # invest_fermenter_Loc3_K250_No1:

    <"capacity_in_Loc3_K250_No1", "invest_fermenter_Loc3_K250_No1"> 1,

    <"capacity_out_Loc3_K250_No1", "invest_fermenter_Loc3_K250_No1"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K250_No1"> -1,

 # invest_fermenter_Loc3_K500_No0:

    <"capacity_in_Loc3_K500_No0", "invest_fermenter_Loc3_K500_No0"> 1,

    <"capacity_out_Loc3_K500_No0", "invest_fermenter_Loc3_K500_No0"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K500_No0"> -1,

 # invest_fermenter_Loc3_K500_No1:

    <"capacity_in_Loc3_K500_No1", "invest_fermenter_Loc3_K500_No1"> 1,

    <"capacity_out_Loc3_K500_No1", "invest_fermenter_Loc3_K500_No1"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K500_No1"> -1,

 # invest_fermenter_Loc3_K80_No0:

    <"capacity_in_Loc3_K80_No0", "invest_fermenter_Loc3_K80_No0"> 1,

    <"capacity_out_Loc3_K80_No0", "invest_fermenter_Loc3_K80_No0"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K80_No0"> -1,

 # invest_fermenter_Loc3_K80_No1:

    <"capacity_in_Loc3_K80_No1", "invest_fermenter_Loc3_K80_No1"> 1,

    <"capacity_out_Loc3_K80_No1", "invest_fermenter_Loc3_K80_No1"> -1,

    <"silo_plate_availability_material_Loc3", "invest_fermenter_Loc3_K80_No1"> -1,

 # op_transport_substrates_L1_Loc1_Corn:

    <"substrate_available_FM_L1_Corn", "op_transport_substrates_L1_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L1_Loc1_Corn"> 1,

 # op_transport_substrates_L1_Loc1_Grass:

    <"substrate_available_FM_L1_Grass", "op_transport_substrates_L1_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L1_Loc1_Grass"> 1,

 # op_transport_substrates_L1_Loc1_Inter:

    <"substrate_available_FM_L1_Inter", "op_transport_substrates_L1_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L1_Loc1_Inter"> 1,

 # op_transport_substrates_L1_Loc1_Manure:

    <"substrate_available_FM_L1_Manure", "op_transport_substrates_L1_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L1_Loc1_Manure"> 1,

 # op_transport_substrates_L1_Loc2_Corn:

    <"substrate_available_FM_L1_Corn", "op_transport_substrates_L1_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L1_Loc2_Corn"> 1,

 # op_transport_substrates_L1_Loc2_Grass:

    <"substrate_available_FM_L1_Grass", "op_transport_substrates_L1_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L1_Loc2_Grass"> 1,

 # op_transport_substrates_L1_Loc2_Inter:

    <"substrate_available_FM_L1_Inter", "op_transport_substrates_L1_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L1_Loc2_Inter"> 1,

 # op_transport_substrates_L1_Loc2_Manure:

    <"substrate_available_FM_L1_Manure", "op_transport_substrates_L1_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L1_Loc2_Manure"> 1,

 # op_transport_substrates_L1_Loc3_Corn:

    <"substrate_available_FM_L1_Corn", "op_transport_substrates_L1_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L1_Loc3_Corn"> 1,

 # op_transport_substrates_L1_Loc3_Grass:

    <"substrate_available_FM_L1_Grass", "op_transport_substrates_L1_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L1_Loc3_Grass"> 1,

 # op_transport_substrates_L1_Loc3_Inter:

    <"substrate_available_FM_L1_Inter", "op_transport_substrates_L1_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L1_Loc3_Inter"> 1,

 # op_transport_substrates_L1_Loc3_Manure:

    <"substrate_available_FM_L1_Manure", "op_transport_substrates_L1_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L1_Loc3_Manure"> 1,

 # op_transport_substrates_L2_Loc1_Corn:

    <"substrate_available_FM_L2_Corn", "op_transport_substrates_L2_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L2_Loc1_Corn"> 1,

 # op_transport_substrates_L2_Loc1_Grass:

    <"substrate_available_FM_L2_Grass", "op_transport_substrates_L2_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L2_Loc1_Grass"> 1,

 # op_transport_substrates_L2_Loc1_Inter:

    <"substrate_available_FM_L2_Inter", "op_transport_substrates_L2_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L2_Loc1_Inter"> 1,

 # op_transport_substrates_L2_Loc1_Manure:

    <"substrate_available_FM_L2_Manure", "op_transport_substrates_L2_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L2_Loc1_Manure"> 1,

 # op_transport_substrates_L2_Loc2_Corn:

    <"substrate_available_FM_L2_Corn", "op_transport_substrates_L2_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L2_Loc2_Corn"> 1,

 # op_transport_substrates_L2_Loc2_Grass:

    <"substrate_available_FM_L2_Grass", "op_transport_substrates_L2_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L2_Loc2_Grass"> 1,

 # op_transport_substrates_L2_Loc2_Inter:

    <"substrate_available_FM_L2_Inter", "op_transport_substrates_L2_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L2_Loc2_Inter"> 1,

 # op_transport_substrates_L2_Loc2_Manure:

    <"substrate_available_FM_L2_Manure", "op_transport_substrates_L2_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L2_Loc2_Manure"> 1,

 # op_transport_substrates_L2_Loc3_Corn:

    <"substrate_available_FM_L2_Corn", "op_transport_substrates_L2_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L2_Loc3_Corn"> 1,

 # op_transport_substrates_L2_Loc3_Grass:

    <"substrate_available_FM_L2_Grass", "op_transport_substrates_L2_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L2_Loc3_Grass"> 1,

 # op_transport_substrates_L2_Loc3_Inter:

    <"substrate_available_FM_L2_Inter", "op_transport_substrates_L2_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L2_Loc3_Inter"> 1,

 # op_transport_substrates_L2_Loc3_Manure:

    <"substrate_available_FM_L2_Manure", "op_transport_substrates_L2_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L2_Loc3_Manure"> 1,

 # op_transport_substrates_L3_Loc1_Corn:

    <"substrate_available_FM_L3_Corn", "op_transport_substrates_L3_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L3_Loc1_Corn"> 1,

 # op_transport_substrates_L3_Loc1_Grass:

    <"substrate_available_FM_L3_Grass", "op_transport_substrates_L3_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L3_Loc1_Grass"> 1,

 # op_transport_substrates_L3_Loc1_Inter:

    <"substrate_available_FM_L3_Inter", "op_transport_substrates_L3_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L3_Loc1_Inter"> 1,

 # op_transport_substrates_L3_Loc1_Manure:

    <"substrate_available_FM_L3_Manure", "op_transport_substrates_L3_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L3_Loc1_Manure"> 1,

 # op_transport_substrates_L3_Loc2_Corn:

    <"substrate_available_FM_L3_Corn", "op_transport_substrates_L3_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L3_Loc2_Corn"> 1,

 # op_transport_substrates_L3_Loc2_Grass:

    <"substrate_available_FM_L3_Grass", "op_transport_substrates_L3_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L3_Loc2_Grass"> 1,

 # op_transport_substrates_L3_Loc2_Inter:

    <"substrate_available_FM_L3_Inter", "op_transport_substrates_L3_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L3_Loc2_Inter"> 1,

 # op_transport_substrates_L3_Loc2_Manure:

    <"substrate_available_FM_L3_Manure", "op_transport_substrates_L3_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L3_Loc2_Manure"> 1,

 # op_transport_substrates_L3_Loc3_Corn:

    <"substrate_available_FM_L3_Corn", "op_transport_substrates_L3_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L3_Loc3_Corn"> 1,

 # op_transport_substrates_L3_Loc3_Grass:

    <"substrate_available_FM_L3_Grass", "op_transport_substrates_L3_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L3_Loc3_Grass"> 1,

 # op_transport_substrates_L3_Loc3_Inter:

    <"substrate_available_FM_L3_Inter", "op_transport_substrates_L3_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L3_Loc3_Inter"> 1,

 # op_transport_substrates_L3_Loc3_Manure:

    <"substrate_available_FM_L3_Manure", "op_transport_substrates_L3_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L3_Loc3_Manure"> 1,

 # op_transport_substrates_L4_Loc1_Corn:

    <"substrate_available_FM_L4_Corn", "op_transport_substrates_L4_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L4_Loc1_Corn"> 1,

 # op_transport_substrates_L4_Loc1_Grass:

    <"substrate_available_FM_L4_Grass", "op_transport_substrates_L4_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L4_Loc1_Grass"> 1,

 # op_transport_substrates_L4_Loc1_Inter:

    <"substrate_available_FM_L4_Inter", "op_transport_substrates_L4_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L4_Loc1_Inter"> 1,

 # op_transport_substrates_L4_Loc1_Manure:

    <"substrate_available_FM_L4_Manure", "op_transport_substrates_L4_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L4_Loc1_Manure"> 1,

 # op_transport_substrates_L4_Loc2_Corn:

    <"substrate_available_FM_L4_Corn", "op_transport_substrates_L4_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L4_Loc2_Corn"> 1,

 # op_transport_substrates_L4_Loc2_Grass:

    <"substrate_available_FM_L4_Grass", "op_transport_substrates_L4_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L4_Loc2_Grass"> 1,

 # op_transport_substrates_L4_Loc2_Inter:

    <"substrate_available_FM_L4_Inter", "op_transport_substrates_L4_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L4_Loc2_Inter"> 1,

 # op_transport_substrates_L4_Loc2_Manure:

    <"substrate_available_FM_L4_Manure", "op_transport_substrates_L4_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L4_Loc2_Manure"> 1,

 # op_transport_substrates_L4_Loc3_Corn:

    <"substrate_available_FM_L4_Corn", "op_transport_substrates_L4_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L4_Loc3_Corn"> 1,

 # op_transport_substrates_L4_Loc3_Grass:

    <"substrate_available_FM_L4_Grass", "op_transport_substrates_L4_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L4_Loc3_Grass"> 1,

 # op_transport_substrates_L4_Loc3_Inter:

    <"substrate_available_FM_L4_Inter", "op_transport_substrates_L4_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L4_Loc3_Inter"> 1,

 # op_transport_substrates_L4_Loc3_Manure:

    <"substrate_available_FM_L4_Manure", "op_transport_substrates_L4_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L4_Loc3_Manure"> 1,

 # op_transport_substrates_L5_Loc1_Corn:

    <"substrate_available_FM_L5_Corn", "op_transport_substrates_L5_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L5_Loc1_Corn"> 1,

 # op_transport_substrates_L5_Loc1_Grass:

    <"substrate_available_FM_L5_Grass", "op_transport_substrates_L5_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L5_Loc1_Grass"> 1,

 # op_transport_substrates_L5_Loc1_Inter:

    <"substrate_available_FM_L5_Inter", "op_transport_substrates_L5_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L5_Loc1_Inter"> 1,

 # op_transport_substrates_L5_Loc1_Manure:

    <"substrate_available_FM_L5_Manure", "op_transport_substrates_L5_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L5_Loc1_Manure"> 1,

 # op_transport_substrates_L5_Loc2_Corn:

    <"substrate_available_FM_L5_Corn", "op_transport_substrates_L5_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L5_Loc2_Corn"> 1,

 # op_transport_substrates_L5_Loc2_Grass:

    <"substrate_available_FM_L5_Grass", "op_transport_substrates_L5_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L5_Loc2_Grass"> 1,

 # op_transport_substrates_L5_Loc2_Inter:

    <"substrate_available_FM_L5_Inter", "op_transport_substrates_L5_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L5_Loc2_Inter"> 1,

 # op_transport_substrates_L5_Loc2_Manure:

    <"substrate_available_FM_L5_Manure", "op_transport_substrates_L5_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L5_Loc2_Manure"> 1,

 # op_transport_substrates_L5_Loc3_Corn:

    <"substrate_available_FM_L5_Corn", "op_transport_substrates_L5_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L5_Loc3_Corn"> 1,

 # op_transport_substrates_L5_Loc3_Grass:

    <"substrate_available_FM_L5_Grass", "op_transport_substrates_L5_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L5_Loc3_Grass"> 1,

 # op_transport_substrates_L5_Loc3_Inter:

    <"substrate_available_FM_L5_Inter", "op_transport_substrates_L5_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L5_Loc3_Inter"> 1,

 # op_transport_substrates_L5_Loc3_Manure:

    <"substrate_available_FM_L5_Manure", "op_transport_substrates_L5_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L5_Loc3_Manure"> 1,

 # op_transport_substrates_L6_Loc1_Corn:

    <"substrate_available_FM_L6_Corn", "op_transport_substrates_L6_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L6_Loc1_Corn"> 1,

 # op_transport_substrates_L6_Loc1_Grass:

    <"substrate_available_FM_L6_Grass", "op_transport_substrates_L6_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L6_Loc1_Grass"> 1,

 # op_transport_substrates_L6_Loc1_Inter:

    <"substrate_available_FM_L6_Inter", "op_transport_substrates_L6_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L6_Loc1_Inter"> 1,

 # op_transport_substrates_L6_Loc1_Manure:

    <"substrate_available_FM_L6_Manure", "op_transport_substrates_L6_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L6_Loc1_Manure"> 1,

 # op_transport_substrates_L6_Loc2_Corn:

    <"substrate_available_FM_L6_Corn", "op_transport_substrates_L6_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L6_Loc2_Corn"> 1,

 # op_transport_substrates_L6_Loc2_Grass:

    <"substrate_available_FM_L6_Grass", "op_transport_substrates_L6_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L6_Loc2_Grass"> 1,

 # op_transport_substrates_L6_Loc2_Inter:

    <"substrate_available_FM_L6_Inter", "op_transport_substrates_L6_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L6_Loc2_Inter"> 1,

 # op_transport_substrates_L6_Loc2_Manure:

    <"substrate_available_FM_L6_Manure", "op_transport_substrates_L6_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L6_Loc2_Manure"> 1,

 # op_transport_substrates_L6_Loc3_Corn:

    <"substrate_available_FM_L6_Corn", "op_transport_substrates_L6_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L6_Loc3_Corn"> 1,

 # op_transport_substrates_L6_Loc3_Grass:

    <"substrate_available_FM_L6_Grass", "op_transport_substrates_L6_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L6_Loc3_Grass"> 1,

 # op_transport_substrates_L6_Loc3_Inter:

    <"substrate_available_FM_L6_Inter", "op_transport_substrates_L6_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L6_Loc3_Inter"> 1,

 # op_transport_substrates_L6_Loc3_Manure:

    <"substrate_available_FM_L6_Manure", "op_transport_substrates_L6_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L6_Loc3_Manure"> 1,

 # op_transport_substrates_L7_Loc1_Corn:

    <"substrate_available_FM_L7_Corn", "op_transport_substrates_L7_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L7_Loc1_Corn"> 1,

 # op_transport_substrates_L7_Loc1_Grass:

    <"substrate_available_FM_L7_Grass", "op_transport_substrates_L7_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L7_Loc1_Grass"> 1,

 # op_transport_substrates_L7_Loc1_Inter:

    <"substrate_available_FM_L7_Inter", "op_transport_substrates_L7_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L7_Loc1_Inter"> 1,

 # op_transport_substrates_L7_Loc1_Manure:

    <"substrate_available_FM_L7_Manure", "op_transport_substrates_L7_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L7_Loc1_Manure"> 1,

 # op_transport_substrates_L7_Loc2_Corn:

    <"substrate_available_FM_L7_Corn", "op_transport_substrates_L7_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L7_Loc2_Corn"> 1,

 # op_transport_substrates_L7_Loc2_Grass:

    <"substrate_available_FM_L7_Grass", "op_transport_substrates_L7_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L7_Loc2_Grass"> 1,

 # op_transport_substrates_L7_Loc2_Inter:

    <"substrate_available_FM_L7_Inter", "op_transport_substrates_L7_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L7_Loc2_Inter"> 1,

 # op_transport_substrates_L7_Loc2_Manure:

    <"substrate_available_FM_L7_Manure", "op_transport_substrates_L7_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L7_Loc2_Manure"> 1,

 # op_transport_substrates_L7_Loc3_Corn:

    <"substrate_available_FM_L7_Corn", "op_transport_substrates_L7_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L7_Loc3_Corn"> 1,

 # op_transport_substrates_L7_Loc3_Grass:

    <"substrate_available_FM_L7_Grass", "op_transport_substrates_L7_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L7_Loc3_Grass"> 1,

 # op_transport_substrates_L7_Loc3_Inter:

    <"substrate_available_FM_L7_Inter", "op_transport_substrates_L7_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L7_Loc3_Inter"> 1,

 # op_transport_substrates_L7_Loc3_Manure:

    <"substrate_available_FM_L7_Manure", "op_transport_substrates_L7_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L7_Loc3_Manure"> 1,

 # op_transport_substrates_L8_Loc1_Corn:

    <"substrate_available_FM_L8_Corn", "op_transport_substrates_L8_Loc1_Corn"> -1,

    <"substrate_feed_Loc1_Corn", "op_transport_substrates_L8_Loc1_Corn"> 1,

 # op_transport_substrates_L8_Loc1_Grass:

    <"substrate_available_FM_L8_Grass", "op_transport_substrates_L8_Loc1_Grass"> -1,

    <"substrate_feed_Loc1_Grass", "op_transport_substrates_L8_Loc1_Grass"> 1,

 # op_transport_substrates_L8_Loc1_Inter:

    <"substrate_available_FM_L8_Inter", "op_transport_substrates_L8_Loc1_Inter"> -1,

    <"substrate_feed_Loc1_Inter", "op_transport_substrates_L8_Loc1_Inter"> 1,

 # op_transport_substrates_L8_Loc1_Manure:

    <"substrate_available_FM_L8_Manure", "op_transport_substrates_L8_Loc1_Manure"> -1,

    <"substrate_feed_Loc1_Manure", "op_transport_substrates_L8_Loc1_Manure"> 1,

 # op_transport_substrates_L8_Loc2_Corn:

    <"substrate_available_FM_L8_Corn", "op_transport_substrates_L8_Loc2_Corn"> -1,

    <"substrate_feed_Loc2_Corn", "op_transport_substrates_L8_Loc2_Corn"> 1,

 # op_transport_substrates_L8_Loc2_Grass:

    <"substrate_available_FM_L8_Grass", "op_transport_substrates_L8_Loc2_Grass"> -1,

    <"substrate_feed_Loc2_Grass", "op_transport_substrates_L8_Loc2_Grass"> 1,

 # op_transport_substrates_L8_Loc2_Inter:

    <"substrate_available_FM_L8_Inter", "op_transport_substrates_L8_Loc2_Inter"> -1,

    <"substrate_feed_Loc2_Inter", "op_transport_substrates_L8_Loc2_Inter"> 1,

 # op_transport_substrates_L8_Loc2_Manure:

    <"substrate_available_FM_L8_Manure", "op_transport_substrates_L8_Loc2_Manure"> -1,

    <"substrate_feed_Loc2_Manure", "op_transport_substrates_L8_Loc2_Manure"> 1,

 # op_transport_substrates_L8_Loc3_Corn:

    <"substrate_available_FM_L8_Corn", "op_transport_substrates_L8_Loc3_Corn"> -1,

    <"substrate_feed_Loc3_Corn", "op_transport_substrates_L8_Loc3_Corn"> 1,

 # op_transport_substrates_L8_Loc3_Grass:

    <"substrate_available_FM_L8_Grass", "op_transport_substrates_L8_Loc3_Grass"> -1,

    <"substrate_feed_Loc3_Grass", "op_transport_substrates_L8_Loc3_Grass"> 1,

 # op_transport_substrates_L8_Loc3_Inter:

    <"substrate_available_FM_L8_Inter", "op_transport_substrates_L8_Loc3_Inter"> -1,

    <"substrate_feed_Loc3_Inter", "op_transport_substrates_L8_Loc3_Inter"> 1,

 # op_transport_substrates_L8_Loc3_Manure:

    <"substrate_available_FM_L8_Manure", "op_transport_substrates_L8_Loc3_Manure"> -1,

    <"substrate_feed_Loc3_Manure", "op_transport_substrates_L8_Loc3_Manure"> 1,

 # process_Loc1_K160_No0_Corn:

    <"biogas_Loc1", "process_Loc1_K160_No0_Corn"> 112.2,

    <"capacity_in_Loc1_K160_No0", "process_Loc1_K160_No0_Corn"> -2.73487,

    <"capacity_out_Loc1_K160_No0", "process_Loc1_K160_No0_Corn"> 2.73487,

    <"heat_balance_Loc1", "process_Loc1_K160_No0_Corn"> -0.0415894,

    <"min_ratio_Loc1_K160_No0_Manure", "process_Loc1_K160_No0_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K160_No0_Corn"> -1,

 # process_Loc1_K160_No0_Grass:

    <"biogas_Loc1", "process_Loc1_K160_No0_Grass"> 90,

    <"capacity_in_Loc1_K160_No0", "process_Loc1_K160_No0_Grass"> -2.19375,

    <"capacity_out_Loc1_K160_No0", "process_Loc1_K160_No0_Grass"> 2.19375,

    <"heat_balance_Loc1", "process_Loc1_K160_No0_Grass"> -0.015782,

    <"min_ratio_Loc1_K160_No0_Manure", "process_Loc1_K160_No0_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K160_No0_Grass"> -1,

 # process_Loc1_K160_No0_Inter:

    <"biogas_Loc1", "process_Loc1_K160_No0_Inter"> 72,

    <"capacity_in_Loc1_K160_No0", "process_Loc1_K160_No0_Inter"> -1.755,

    <"capacity_out_Loc1_K160_No0", "process_Loc1_K160_No0_Inter"> 1.755,

    <"heat_balance_Loc1", "process_Loc1_K160_No0_Inter"> -0.0353441,

    <"min_ratio_Loc1_K160_No0_Manure", "process_Loc1_K160_No0_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K160_No0_Inter"> -1,

 # process_Loc1_K160_No0_Manure:

    <"biogas_Loc1", "process_Loc1_K160_No0_Manure"> 18,

    <"capacity_in_Loc1_K160_No0", "process_Loc1_K160_No0_Manure"> -0.43875,

    <"capacity_out_Loc1_K160_No0", "process_Loc1_K160_No0_Manure"> 0.43875,

    <"heat_balance_Loc1", "process_Loc1_K160_No0_Manure"> -0.0411573,

    <"min_ratio_Loc1_K160_No0_Manure", "process_Loc1_K160_No0_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K160_No0_Manure"> -1,

 # process_Loc1_K160_No0_slack:

    <"capacity_in_Loc1_K160_No0", "process_Loc1_K160_No0_slack"> -0.43875,

    <"capacity_out_Loc1_K160_No0", "process_Loc1_K160_No0_slack"> 0.43875,

 # process_Loc1_K160_No1_Corn:

    <"biogas_Loc1", "process_Loc1_K160_No1_Corn"> 112.2,

    <"capacity_in_Loc1_K160_No1", "process_Loc1_K160_No1_Corn"> -2.73487,

    <"capacity_out_Loc1_K160_No1", "process_Loc1_K160_No1_Corn"> 2.73487,

    <"heat_balance_Loc1", "process_Loc1_K160_No1_Corn"> -0.0415894,

    <"min_ratio_Loc1_K160_No1_Manure", "process_Loc1_K160_No1_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K160_No1_Corn"> -1,

 # process_Loc1_K160_No1_Grass:

    <"biogas_Loc1", "process_Loc1_K160_No1_Grass"> 90,

    <"capacity_in_Loc1_K160_No1", "process_Loc1_K160_No1_Grass"> -2.19375,

    <"capacity_out_Loc1_K160_No1", "process_Loc1_K160_No1_Grass"> 2.19375,

    <"heat_balance_Loc1", "process_Loc1_K160_No1_Grass"> -0.015782,

    <"min_ratio_Loc1_K160_No1_Manure", "process_Loc1_K160_No1_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K160_No1_Grass"> -1,

 # process_Loc1_K160_No1_Inter:

    <"biogas_Loc1", "process_Loc1_K160_No1_Inter"> 72,

    <"capacity_in_Loc1_K160_No1", "process_Loc1_K160_No1_Inter"> -1.755,

    <"capacity_out_Loc1_K160_No1", "process_Loc1_K160_No1_Inter"> 1.755,

    <"heat_balance_Loc1", "process_Loc1_K160_No1_Inter"> -0.0353441,

    <"min_ratio_Loc1_K160_No1_Manure", "process_Loc1_K160_No1_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K160_No1_Inter"> -1,

 # process_Loc1_K160_No1_Manure:

    <"biogas_Loc1", "process_Loc1_K160_No1_Manure"> 18,

    <"capacity_in_Loc1_K160_No1", "process_Loc1_K160_No1_Manure"> -0.43875,

    <"capacity_out_Loc1_K160_No1", "process_Loc1_K160_No1_Manure"> 0.43875,

    <"heat_balance_Loc1", "process_Loc1_K160_No1_Manure"> -0.0411573,

    <"min_ratio_Loc1_K160_No1_Manure", "process_Loc1_K160_No1_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K160_No1_Manure"> -1,

 # process_Loc1_K160_No1_slack:

    <"capacity_in_Loc1_K160_No1", "process_Loc1_K160_No1_slack"> -0.43875,

    <"capacity_out_Loc1_K160_No1", "process_Loc1_K160_No1_slack"> 0.43875,

 # process_Loc1_K250_No0_Corn:

    <"biogas_Loc1", "process_Loc1_K250_No0_Corn"> 112.2,

    <"capacity_in_Loc1_K250_No0", "process_Loc1_K250_No0_Corn"> -1.75032,

    <"capacity_out_Loc1_K250_No0", "process_Loc1_K250_No0_Corn"> 1.75032,

    <"heat_balance_Loc1", "process_Loc1_K250_No0_Corn"> -0.0415894,

    <"min_ratio_Loc1_K250_No0_Manure", "process_Loc1_K250_No0_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K250_No0_Corn"> -1,

 # process_Loc1_K250_No0_Grass:

    <"biogas_Loc1", "process_Loc1_K250_No0_Grass"> 90,

    <"capacity_in_Loc1_K250_No0", "process_Loc1_K250_No0_Grass"> -1.404,

    <"capacity_out_Loc1_K250_No0", "process_Loc1_K250_No0_Grass"> 1.404,

    <"heat_balance_Loc1", "process_Loc1_K250_No0_Grass"> -0.015782,

    <"min_ratio_Loc1_K250_No0_Manure", "process_Loc1_K250_No0_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K250_No0_Grass"> -1,

 # process_Loc1_K250_No0_Inter:

    <"biogas_Loc1", "process_Loc1_K250_No0_Inter"> 72,

    <"capacity_in_Loc1_K250_No0", "process_Loc1_K250_No0_Inter"> -1.1232,

    <"capacity_out_Loc1_K250_No0", "process_Loc1_K250_No0_Inter"> 1.1232,

    <"heat_balance_Loc1", "process_Loc1_K250_No0_Inter"> -0.0353441,

    <"min_ratio_Loc1_K250_No0_Manure", "process_Loc1_K250_No0_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K250_No0_Inter"> -1,

 # process_Loc1_K250_No0_Manure:

    <"biogas_Loc1", "process_Loc1_K250_No0_Manure"> 18,

    <"capacity_in_Loc1_K250_No0", "process_Loc1_K250_No0_Manure"> -0.2808,

    <"capacity_out_Loc1_K250_No0", "process_Loc1_K250_No0_Manure"> 0.2808,

    <"heat_balance_Loc1", "process_Loc1_K250_No0_Manure"> -0.0411573,

    <"min_ratio_Loc1_K250_No0_Manure", "process_Loc1_K250_No0_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K250_No0_Manure"> -1,

 # process_Loc1_K250_No0_slack:

    <"capacity_in_Loc1_K250_No0", "process_Loc1_K250_No0_slack"> -0.2808,

    <"capacity_out_Loc1_K250_No0", "process_Loc1_K250_No0_slack"> 0.2808,

 # process_Loc1_K250_No1_Corn:

    <"biogas_Loc1", "process_Loc1_K250_No1_Corn"> 112.2,

    <"capacity_in_Loc1_K250_No1", "process_Loc1_K250_No1_Corn"> -1.75032,

    <"capacity_out_Loc1_K250_No1", "process_Loc1_K250_No1_Corn"> 1.75032,

    <"heat_balance_Loc1", "process_Loc1_K250_No1_Corn"> -0.0415894,

    <"min_ratio_Loc1_K250_No1_Manure", "process_Loc1_K250_No1_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K250_No1_Corn"> -1,

 # process_Loc1_K250_No1_Grass:

    <"biogas_Loc1", "process_Loc1_K250_No1_Grass"> 90,

    <"capacity_in_Loc1_K250_No1", "process_Loc1_K250_No1_Grass"> -1.404,

    <"capacity_out_Loc1_K250_No1", "process_Loc1_K250_No1_Grass"> 1.404,

    <"heat_balance_Loc1", "process_Loc1_K250_No1_Grass"> -0.015782,

    <"min_ratio_Loc1_K250_No1_Manure", "process_Loc1_K250_No1_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K250_No1_Grass"> -1,

 # process_Loc1_K250_No1_Inter:

    <"biogas_Loc1", "process_Loc1_K250_No1_Inter"> 72,

    <"capacity_in_Loc1_K250_No1", "process_Loc1_K250_No1_Inter"> -1.1232,

    <"capacity_out_Loc1_K250_No1", "process_Loc1_K250_No1_Inter"> 1.1232,

    <"heat_balance_Loc1", "process_Loc1_K250_No1_Inter"> -0.0353441,

    <"min_ratio_Loc1_K250_No1_Manure", "process_Loc1_K250_No1_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K250_No1_Inter"> -1,

 # process_Loc1_K250_No1_Manure:

    <"biogas_Loc1", "process_Loc1_K250_No1_Manure"> 18,

    <"capacity_in_Loc1_K250_No1", "process_Loc1_K250_No1_Manure"> -0.2808,

    <"capacity_out_Loc1_K250_No1", "process_Loc1_K250_No1_Manure"> 0.2808,

    <"heat_balance_Loc1", "process_Loc1_K250_No1_Manure"> -0.0411573,

    <"min_ratio_Loc1_K250_No1_Manure", "process_Loc1_K250_No1_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K250_No1_Manure"> -1,

 # process_Loc1_K250_No1_slack:

    <"capacity_in_Loc1_K250_No1", "process_Loc1_K250_No1_slack"> -0.2808,

    <"capacity_out_Loc1_K250_No1", "process_Loc1_K250_No1_slack"> 0.2808,

 # process_Loc1_K500_No0_Corn:

    <"biogas_Loc1", "process_Loc1_K500_No0_Corn"> 112.2,

    <"capacity_in_Loc1_K500_No0", "process_Loc1_K500_No0_Corn"> -0.87516,

    <"capacity_out_Loc1_K500_No0", "process_Loc1_K500_No0_Corn"> 0.87516,

    <"heat_balance_Loc1", "process_Loc1_K500_No0_Corn"> -0.0415894,

    <"min_ratio_Loc1_K500_No0_Manure", "process_Loc1_K500_No0_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K500_No0_Corn"> -1,

 # process_Loc1_K500_No0_Grass:

    <"biogas_Loc1", "process_Loc1_K500_No0_Grass"> 90,

    <"capacity_in_Loc1_K500_No0", "process_Loc1_K500_No0_Grass"> -0.702,

    <"capacity_out_Loc1_K500_No0", "process_Loc1_K500_No0_Grass"> 0.702,

    <"heat_balance_Loc1", "process_Loc1_K500_No0_Grass"> -0.015782,

    <"min_ratio_Loc1_K500_No0_Manure", "process_Loc1_K500_No0_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K500_No0_Grass"> -1,

 # process_Loc1_K500_No0_Inter:

    <"biogas_Loc1", "process_Loc1_K500_No0_Inter"> 72,

    <"capacity_in_Loc1_K500_No0", "process_Loc1_K500_No0_Inter"> -0.5616,

    <"capacity_out_Loc1_K500_No0", "process_Loc1_K500_No0_Inter"> 0.5616,

    <"heat_balance_Loc1", "process_Loc1_K500_No0_Inter"> -0.0353441,

    <"min_ratio_Loc1_K500_No0_Manure", "process_Loc1_K500_No0_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K500_No0_Inter"> -1,

 # process_Loc1_K500_No0_Manure:

    <"biogas_Loc1", "process_Loc1_K500_No0_Manure"> 18,

    <"capacity_in_Loc1_K500_No0", "process_Loc1_K500_No0_Manure"> -0.1404,

    <"capacity_out_Loc1_K500_No0", "process_Loc1_K500_No0_Manure"> 0.1404,

    <"heat_balance_Loc1", "process_Loc1_K500_No0_Manure"> -0.0411573,

    <"min_ratio_Loc1_K500_No0_Manure", "process_Loc1_K500_No0_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K500_No0_Manure"> -1,

 # process_Loc1_K500_No0_slack:

    <"capacity_in_Loc1_K500_No0", "process_Loc1_K500_No0_slack"> -0.1404,

    <"capacity_out_Loc1_K500_No0", "process_Loc1_K500_No0_slack"> 0.1404,

 # process_Loc1_K500_No1_Corn:

    <"biogas_Loc1", "process_Loc1_K500_No1_Corn"> 112.2,

    <"capacity_in_Loc1_K500_No1", "process_Loc1_K500_No1_Corn"> -0.87516,

    <"capacity_out_Loc1_K500_No1", "process_Loc1_K500_No1_Corn"> 0.87516,

    <"heat_balance_Loc1", "process_Loc1_K500_No1_Corn"> -0.0415894,

    <"min_ratio_Loc1_K500_No1_Manure", "process_Loc1_K500_No1_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K500_No1_Corn"> -1,

 # process_Loc1_K500_No1_Grass:

    <"biogas_Loc1", "process_Loc1_K500_No1_Grass"> 90,

    <"capacity_in_Loc1_K500_No1", "process_Loc1_K500_No1_Grass"> -0.702,

    <"capacity_out_Loc1_K500_No1", "process_Loc1_K500_No1_Grass"> 0.702,

    <"heat_balance_Loc1", "process_Loc1_K500_No1_Grass"> -0.015782,

    <"min_ratio_Loc1_K500_No1_Manure", "process_Loc1_K500_No1_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K500_No1_Grass"> -1,

 # process_Loc1_K500_No1_Inter:

    <"biogas_Loc1", "process_Loc1_K500_No1_Inter"> 72,

    <"capacity_in_Loc1_K500_No1", "process_Loc1_K500_No1_Inter"> -0.5616,

    <"capacity_out_Loc1_K500_No1", "process_Loc1_K500_No1_Inter"> 0.5616,

    <"heat_balance_Loc1", "process_Loc1_K500_No1_Inter"> -0.0353441,

    <"min_ratio_Loc1_K500_No1_Manure", "process_Loc1_K500_No1_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K500_No1_Inter"> -1,

 # process_Loc1_K500_No1_Manure:

    <"biogas_Loc1", "process_Loc1_K500_No1_Manure"> 18,

    <"capacity_in_Loc1_K500_No1", "process_Loc1_K500_No1_Manure"> -0.1404,

    <"capacity_out_Loc1_K500_No1", "process_Loc1_K500_No1_Manure"> 0.1404,

    <"heat_balance_Loc1", "process_Loc1_K500_No1_Manure"> -0.0411573,

    <"min_ratio_Loc1_K500_No1_Manure", "process_Loc1_K500_No1_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K500_No1_Manure"> -1,

 # process_Loc1_K500_No1_slack:

    <"capacity_in_Loc1_K500_No1", "process_Loc1_K500_No1_slack"> -0.1404,

    <"capacity_out_Loc1_K500_No1", "process_Loc1_K500_No1_slack"> 0.1404,

 # process_Loc1_K80_No0_Corn:

    <"biogas_Loc1", "process_Loc1_K80_No0_Corn"> 112.2,

    <"capacity_in_Loc1_K80_No0", "process_Loc1_K80_No0_Corn"> -5.46975,

    <"capacity_out_Loc1_K80_No0", "process_Loc1_K80_No0_Corn"> 5.46975,

    <"heat_balance_Loc1", "process_Loc1_K80_No0_Corn"> -0.0415894,

    <"min_ratio_Loc1_K80_No0_Manure", "process_Loc1_K80_No0_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K80_No0_Corn"> -1,

 # process_Loc1_K80_No0_Grass:

    <"biogas_Loc1", "process_Loc1_K80_No0_Grass"> 90,

    <"capacity_in_Loc1_K80_No0", "process_Loc1_K80_No0_Grass"> -4.3875,

    <"capacity_out_Loc1_K80_No0", "process_Loc1_K80_No0_Grass"> 4.3875,

    <"heat_balance_Loc1", "process_Loc1_K80_No0_Grass"> -0.015782,

    <"min_ratio_Loc1_K80_No0_Manure", "process_Loc1_K80_No0_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K80_No0_Grass"> -1,

 # process_Loc1_K80_No0_Inter:

    <"biogas_Loc1", "process_Loc1_K80_No0_Inter"> 72,

    <"capacity_in_Loc1_K80_No0", "process_Loc1_K80_No0_Inter"> -3.51,

    <"capacity_out_Loc1_K80_No0", "process_Loc1_K80_No0_Inter"> 3.51,

    <"heat_balance_Loc1", "process_Loc1_K80_No0_Inter"> -0.0353441,

    <"min_ratio_Loc1_K80_No0_Manure", "process_Loc1_K80_No0_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K80_No0_Inter"> -1,

 # process_Loc1_K80_No0_Manure:

    <"biogas_Loc1", "process_Loc1_K80_No0_Manure"> 18,

    <"capacity_in_Loc1_K80_No0", "process_Loc1_K80_No0_Manure"> -0.8775,

    <"capacity_out_Loc1_K80_No0", "process_Loc1_K80_No0_Manure"> 0.8775,

    <"heat_balance_Loc1", "process_Loc1_K80_No0_Manure"> -0.0411573,

    <"min_ratio_Loc1_K80_No0_Manure", "process_Loc1_K80_No0_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K80_No0_Manure"> -1,

 # process_Loc1_K80_No0_slack:

    <"capacity_in_Loc1_K80_No0", "process_Loc1_K80_No0_slack"> -0.8775,

    <"capacity_out_Loc1_K80_No0", "process_Loc1_K80_No0_slack"> 0.8775,

 # process_Loc1_K80_No1_Corn:

    <"biogas_Loc1", "process_Loc1_K80_No1_Corn"> 112.2,

    <"capacity_in_Loc1_K80_No1", "process_Loc1_K80_No1_Corn"> -5.46975,

    <"capacity_out_Loc1_K80_No1", "process_Loc1_K80_No1_Corn"> 5.46975,

    <"heat_balance_Loc1", "process_Loc1_K80_No1_Corn"> -0.0415894,

    <"min_ratio_Loc1_K80_No1_Manure", "process_Loc1_K80_No1_Corn"> -0.3,

    <"substrate_feed_Loc1_Corn", "process_Loc1_K80_No1_Corn"> -1,

 # process_Loc1_K80_No1_Grass:

    <"biogas_Loc1", "process_Loc1_K80_No1_Grass"> 90,

    <"capacity_in_Loc1_K80_No1", "process_Loc1_K80_No1_Grass"> -4.3875,

    <"capacity_out_Loc1_K80_No1", "process_Loc1_K80_No1_Grass"> 4.3875,

    <"heat_balance_Loc1", "process_Loc1_K80_No1_Grass"> -0.015782,

    <"min_ratio_Loc1_K80_No1_Manure", "process_Loc1_K80_No1_Grass"> -0.3,

    <"substrate_feed_Loc1_Grass", "process_Loc1_K80_No1_Grass"> -1,

 # process_Loc1_K80_No1_Inter:

    <"biogas_Loc1", "process_Loc1_K80_No1_Inter"> 72,

    <"capacity_in_Loc1_K80_No1", "process_Loc1_K80_No1_Inter"> -3.51,

    <"capacity_out_Loc1_K80_No1", "process_Loc1_K80_No1_Inter"> 3.51,

    <"heat_balance_Loc1", "process_Loc1_K80_No1_Inter"> -0.0353441,

    <"min_ratio_Loc1_K80_No1_Manure", "process_Loc1_K80_No1_Inter"> -0.3,

    <"substrate_feed_Loc1_Inter", "process_Loc1_K80_No1_Inter"> -1,

 # process_Loc1_K80_No1_Manure:

    <"biogas_Loc1", "process_Loc1_K80_No1_Manure"> 18,

    <"capacity_in_Loc1_K80_No1", "process_Loc1_K80_No1_Manure"> -0.8775,

    <"capacity_out_Loc1_K80_No1", "process_Loc1_K80_No1_Manure"> 0.8775,

    <"heat_balance_Loc1", "process_Loc1_K80_No1_Manure"> -0.0411573,

    <"min_ratio_Loc1_K80_No1_Manure", "process_Loc1_K80_No1_Manure"> 0.7,

    <"substrate_feed_Loc1_Manure", "process_Loc1_K80_No1_Manure"> -1,

 # process_Loc1_K80_No1_slack:

    <"capacity_in_Loc1_K80_No1", "process_Loc1_K80_No1_slack"> -0.8775,

    <"capacity_out_Loc1_K80_No1", "process_Loc1_K80_No1_slack"> 0.8775,

 # process_Loc2_K160_No0_Corn:

    <"biogas_Loc2", "process_Loc2_K160_No0_Corn"> 112.2,

    <"capacity_in_Loc2_K160_No0", "process_Loc2_K160_No0_Corn"> -2.73487,

    <"capacity_out_Loc2_K160_No0", "process_Loc2_K160_No0_Corn"> 2.73487,

    <"heat_balance_Loc2", "process_Loc2_K160_No0_Corn"> -0.0415894,

    <"min_ratio_Loc2_K160_No0_Manure", "process_Loc2_K160_No0_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K160_No0_Corn"> -1,

 # process_Loc2_K160_No0_Grass:

    <"biogas_Loc2", "process_Loc2_K160_No0_Grass"> 90,

    <"capacity_in_Loc2_K160_No0", "process_Loc2_K160_No0_Grass"> -2.19375,

    <"capacity_out_Loc2_K160_No0", "process_Loc2_K160_No0_Grass"> 2.19375,

    <"heat_balance_Loc2", "process_Loc2_K160_No0_Grass"> -0.015782,

    <"min_ratio_Loc2_K160_No0_Manure", "process_Loc2_K160_No0_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K160_No0_Grass"> -1,

 # process_Loc2_K160_No0_Inter:

    <"biogas_Loc2", "process_Loc2_K160_No0_Inter"> 72,

    <"capacity_in_Loc2_K160_No0", "process_Loc2_K160_No0_Inter"> -1.755,

    <"capacity_out_Loc2_K160_No0", "process_Loc2_K160_No0_Inter"> 1.755,

    <"heat_balance_Loc2", "process_Loc2_K160_No0_Inter"> -0.0353441,

    <"min_ratio_Loc2_K160_No0_Manure", "process_Loc2_K160_No0_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K160_No0_Inter"> -1,

 # process_Loc2_K160_No0_Manure:

    <"biogas_Loc2", "process_Loc2_K160_No0_Manure"> 18,

    <"capacity_in_Loc2_K160_No0", "process_Loc2_K160_No0_Manure"> -0.43875,

    <"capacity_out_Loc2_K160_No0", "process_Loc2_K160_No0_Manure"> 0.43875,

    <"heat_balance_Loc2", "process_Loc2_K160_No0_Manure"> -0.0411573,

    <"min_ratio_Loc2_K160_No0_Manure", "process_Loc2_K160_No0_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K160_No0_Manure"> -1,

 # process_Loc2_K160_No0_slack:

    <"capacity_in_Loc2_K160_No0", "process_Loc2_K160_No0_slack"> -0.43875,

    <"capacity_out_Loc2_K160_No0", "process_Loc2_K160_No0_slack"> 0.43875,

 # process_Loc2_K160_No1_Corn:

    <"biogas_Loc2", "process_Loc2_K160_No1_Corn"> 112.2,

    <"capacity_in_Loc2_K160_No1", "process_Loc2_K160_No1_Corn"> -2.73487,

    <"capacity_out_Loc2_K160_No1", "process_Loc2_K160_No1_Corn"> 2.73487,

    <"heat_balance_Loc2", "process_Loc2_K160_No1_Corn"> -0.0415894,

    <"min_ratio_Loc2_K160_No1_Manure", "process_Loc2_K160_No1_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K160_No1_Corn"> -1,

 # process_Loc2_K160_No1_Grass:

    <"biogas_Loc2", "process_Loc2_K160_No1_Grass"> 90,

    <"capacity_in_Loc2_K160_No1", "process_Loc2_K160_No1_Grass"> -2.19375,

    <"capacity_out_Loc2_K160_No1", "process_Loc2_K160_No1_Grass"> 2.19375,

    <"heat_balance_Loc2", "process_Loc2_K160_No1_Grass"> -0.015782,

    <"min_ratio_Loc2_K160_No1_Manure", "process_Loc2_K160_No1_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K160_No1_Grass"> -1,

 # process_Loc2_K160_No1_Inter:

    <"biogas_Loc2", "process_Loc2_K160_No1_Inter"> 72,

    <"capacity_in_Loc2_K160_No1", "process_Loc2_K160_No1_Inter"> -1.755,

    <"capacity_out_Loc2_K160_No1", "process_Loc2_K160_No1_Inter"> 1.755,

    <"heat_balance_Loc2", "process_Loc2_K160_No1_Inter"> -0.0353441,

    <"min_ratio_Loc2_K160_No1_Manure", "process_Loc2_K160_No1_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K160_No1_Inter"> -1,

 # process_Loc2_K160_No1_Manure:

    <"biogas_Loc2", "process_Loc2_K160_No1_Manure"> 18,

    <"capacity_in_Loc2_K160_No1", "process_Loc2_K160_No1_Manure"> -0.43875,

    <"capacity_out_Loc2_K160_No1", "process_Loc2_K160_No1_Manure"> 0.43875,

    <"heat_balance_Loc2", "process_Loc2_K160_No1_Manure"> -0.0411573,

    <"min_ratio_Loc2_K160_No1_Manure", "process_Loc2_K160_No1_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K160_No1_Manure"> -1,

 # process_Loc2_K160_No1_slack:

    <"capacity_in_Loc2_K160_No1", "process_Loc2_K160_No1_slack"> -0.43875,

    <"capacity_out_Loc2_K160_No1", "process_Loc2_K160_No1_slack"> 0.43875,

 # process_Loc2_K250_No0_Corn:

    <"biogas_Loc2", "process_Loc2_K250_No0_Corn"> 112.2,

    <"capacity_in_Loc2_K250_No0", "process_Loc2_K250_No0_Corn"> -1.75032,

    <"capacity_out_Loc2_K250_No0", "process_Loc2_K250_No0_Corn"> 1.75032,

    <"heat_balance_Loc2", "process_Loc2_K250_No0_Corn"> -0.0415894,

    <"min_ratio_Loc2_K250_No0_Manure", "process_Loc2_K250_No0_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K250_No0_Corn"> -1,

 # process_Loc2_K250_No0_Grass:

    <"biogas_Loc2", "process_Loc2_K250_No0_Grass"> 90,

    <"capacity_in_Loc2_K250_No0", "process_Loc2_K250_No0_Grass"> -1.404,

    <"capacity_out_Loc2_K250_No0", "process_Loc2_K250_No0_Grass"> 1.404,

    <"heat_balance_Loc2", "process_Loc2_K250_No0_Grass"> -0.015782,

    <"min_ratio_Loc2_K250_No0_Manure", "process_Loc2_K250_No0_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K250_No0_Grass"> -1,

 # process_Loc2_K250_No0_Inter:

    <"biogas_Loc2", "process_Loc2_K250_No0_Inter"> 72,

    <"capacity_in_Loc2_K250_No0", "process_Loc2_K250_No0_Inter"> -1.1232,

    <"capacity_out_Loc2_K250_No0", "process_Loc2_K250_No0_Inter"> 1.1232,

    <"heat_balance_Loc2", "process_Loc2_K250_No0_Inter"> -0.0353441,

    <"min_ratio_Loc2_K250_No0_Manure", "process_Loc2_K250_No0_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K250_No0_Inter"> -1,

 # process_Loc2_K250_No0_Manure:

    <"biogas_Loc2", "process_Loc2_K250_No0_Manure"> 18,

    <"capacity_in_Loc2_K250_No0", "process_Loc2_K250_No0_Manure"> -0.2808,

    <"capacity_out_Loc2_K250_No0", "process_Loc2_K250_No0_Manure"> 0.2808,

    <"heat_balance_Loc2", "process_Loc2_K250_No0_Manure"> -0.0411573,

    <"min_ratio_Loc2_K250_No0_Manure", "process_Loc2_K250_No0_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K250_No0_Manure"> -1,

 # process_Loc2_K250_No0_slack:

    <"capacity_in_Loc2_K250_No0", "process_Loc2_K250_No0_slack"> -0.2808,

    <"capacity_out_Loc2_K250_No0", "process_Loc2_K250_No0_slack"> 0.2808,

 # process_Loc2_K250_No1_Corn:

    <"biogas_Loc2", "process_Loc2_K250_No1_Corn"> 112.2,

    <"capacity_in_Loc2_K250_No1", "process_Loc2_K250_No1_Corn"> -1.75032,

    <"capacity_out_Loc2_K250_No1", "process_Loc2_K250_No1_Corn"> 1.75032,

    <"heat_balance_Loc2", "process_Loc2_K250_No1_Corn"> -0.0415894,

    <"min_ratio_Loc2_K250_No1_Manure", "process_Loc2_K250_No1_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K250_No1_Corn"> -1,

 # process_Loc2_K250_No1_Grass:

    <"biogas_Loc2", "process_Loc2_K250_No1_Grass"> 90,

    <"capacity_in_Loc2_K250_No1", "process_Loc2_K250_No1_Grass"> -1.404,

    <"capacity_out_Loc2_K250_No1", "process_Loc2_K250_No1_Grass"> 1.404,

    <"heat_balance_Loc2", "process_Loc2_K250_No1_Grass"> -0.015782,

    <"min_ratio_Loc2_K250_No1_Manure", "process_Loc2_K250_No1_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K250_No1_Grass"> -1,

 # process_Loc2_K250_No1_Inter:

    <"biogas_Loc2", "process_Loc2_K250_No1_Inter"> 72,

    <"capacity_in_Loc2_K250_No1", "process_Loc2_K250_No1_Inter"> -1.1232,

    <"capacity_out_Loc2_K250_No1", "process_Loc2_K250_No1_Inter"> 1.1232,

    <"heat_balance_Loc2", "process_Loc2_K250_No1_Inter"> -0.0353441,

    <"min_ratio_Loc2_K250_No1_Manure", "process_Loc2_K250_No1_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K250_No1_Inter"> -1,

 # process_Loc2_K250_No1_Manure:

    <"biogas_Loc2", "process_Loc2_K250_No1_Manure"> 18,

    <"capacity_in_Loc2_K250_No1", "process_Loc2_K250_No1_Manure"> -0.2808,

    <"capacity_out_Loc2_K250_No1", "process_Loc2_K250_No1_Manure"> 0.2808,

    <"heat_balance_Loc2", "process_Loc2_K250_No1_Manure"> -0.0411573,

    <"min_ratio_Loc2_K250_No1_Manure", "process_Loc2_K250_No1_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K250_No1_Manure"> -1,

 # process_Loc2_K250_No1_slack:

    <"capacity_in_Loc2_K250_No1", "process_Loc2_K250_No1_slack"> -0.2808,

    <"capacity_out_Loc2_K250_No1", "process_Loc2_K250_No1_slack"> 0.2808,

 # process_Loc2_K500_No0_Corn:

    <"biogas_Loc2", "process_Loc2_K500_No0_Corn"> 112.2,

    <"capacity_in_Loc2_K500_No0", "process_Loc2_K500_No0_Corn"> -0.87516,

    <"capacity_out_Loc2_K500_No0", "process_Loc2_K500_No0_Corn"> 0.87516,

    <"heat_balance_Loc2", "process_Loc2_K500_No0_Corn"> -0.0415894,

    <"min_ratio_Loc2_K500_No0_Manure", "process_Loc2_K500_No0_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K500_No0_Corn"> -1,

 # process_Loc2_K500_No0_Grass:

    <"biogas_Loc2", "process_Loc2_K500_No0_Grass"> 90,

    <"capacity_in_Loc2_K500_No0", "process_Loc2_K500_No0_Grass"> -0.702,

    <"capacity_out_Loc2_K500_No0", "process_Loc2_K500_No0_Grass"> 0.702,

    <"heat_balance_Loc2", "process_Loc2_K500_No0_Grass"> -0.015782,

    <"min_ratio_Loc2_K500_No0_Manure", "process_Loc2_K500_No0_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K500_No0_Grass"> -1,

 # process_Loc2_K500_No0_Inter:

    <"biogas_Loc2", "process_Loc2_K500_No0_Inter"> 72,

    <"capacity_in_Loc2_K500_No0", "process_Loc2_K500_No0_Inter"> -0.5616,

    <"capacity_out_Loc2_K500_No0", "process_Loc2_K500_No0_Inter"> 0.5616,

    <"heat_balance_Loc2", "process_Loc2_K500_No0_Inter"> -0.0353441,

    <"min_ratio_Loc2_K500_No0_Manure", "process_Loc2_K500_No0_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K500_No0_Inter"> -1,

 # process_Loc2_K500_No0_Manure:

    <"biogas_Loc2", "process_Loc2_K500_No0_Manure"> 18,

    <"capacity_in_Loc2_K500_No0", "process_Loc2_K500_No0_Manure"> -0.1404,

    <"capacity_out_Loc2_K500_No0", "process_Loc2_K500_No0_Manure"> 0.1404,

    <"heat_balance_Loc2", "process_Loc2_K500_No0_Manure"> -0.0411573,

    <"min_ratio_Loc2_K500_No0_Manure", "process_Loc2_K500_No0_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K500_No0_Manure"> -1,

 # process_Loc2_K500_No0_slack:

    <"capacity_in_Loc2_K500_No0", "process_Loc2_K500_No0_slack"> -0.1404,

    <"capacity_out_Loc2_K500_No0", "process_Loc2_K500_No0_slack"> 0.1404,

 # process_Loc2_K500_No1_Corn:

    <"biogas_Loc2", "process_Loc2_K500_No1_Corn"> 112.2,

    <"capacity_in_Loc2_K500_No1", "process_Loc2_K500_No1_Corn"> -0.87516,

    <"capacity_out_Loc2_K500_No1", "process_Loc2_K500_No1_Corn"> 0.87516,

    <"heat_balance_Loc2", "process_Loc2_K500_No1_Corn"> -0.0415894,

    <"min_ratio_Loc2_K500_No1_Manure", "process_Loc2_K500_No1_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K500_No1_Corn"> -1,

 # process_Loc2_K500_No1_Grass:

    <"biogas_Loc2", "process_Loc2_K500_No1_Grass"> 90,

    <"capacity_in_Loc2_K500_No1", "process_Loc2_K500_No1_Grass"> -0.702,

    <"capacity_out_Loc2_K500_No1", "process_Loc2_K500_No1_Grass"> 0.702,

    <"heat_balance_Loc2", "process_Loc2_K500_No1_Grass"> -0.015782,

    <"min_ratio_Loc2_K500_No1_Manure", "process_Loc2_K500_No1_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K500_No1_Grass"> -1,

 # process_Loc2_K500_No1_Inter:

    <"biogas_Loc2", "process_Loc2_K500_No1_Inter"> 72,

    <"capacity_in_Loc2_K500_No1", "process_Loc2_K500_No1_Inter"> -0.5616,

    <"capacity_out_Loc2_K500_No1", "process_Loc2_K500_No1_Inter"> 0.5616,

    <"heat_balance_Loc2", "process_Loc2_K500_No1_Inter"> -0.0353441,

    <"min_ratio_Loc2_K500_No1_Manure", "process_Loc2_K500_No1_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K500_No1_Inter"> -1,

 # process_Loc2_K500_No1_Manure:

    <"biogas_Loc2", "process_Loc2_K500_No1_Manure"> 18,

    <"capacity_in_Loc2_K500_No1", "process_Loc2_K500_No1_Manure"> -0.1404,

    <"capacity_out_Loc2_K500_No1", "process_Loc2_K500_No1_Manure"> 0.1404,

    <"heat_balance_Loc2", "process_Loc2_K500_No1_Manure"> -0.0411573,

    <"min_ratio_Loc2_K500_No1_Manure", "process_Loc2_K500_No1_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K500_No1_Manure"> -1,

 # process_Loc2_K500_No1_slack:

    <"capacity_in_Loc2_K500_No1", "process_Loc2_K500_No1_slack"> -0.1404,

    <"capacity_out_Loc2_K500_No1", "process_Loc2_K500_No1_slack"> 0.1404,

 # process_Loc2_K80_No0_Corn:

    <"biogas_Loc2", "process_Loc2_K80_No0_Corn"> 112.2,

    <"capacity_in_Loc2_K80_No0", "process_Loc2_K80_No0_Corn"> -5.46975,

    <"capacity_out_Loc2_K80_No0", "process_Loc2_K80_No0_Corn"> 5.46975,

    <"heat_balance_Loc2", "process_Loc2_K80_No0_Corn"> -0.0415894,

    <"min_ratio_Loc2_K80_No0_Manure", "process_Loc2_K80_No0_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K80_No0_Corn"> -1,

 # process_Loc2_K80_No0_Grass:

    <"biogas_Loc2", "process_Loc2_K80_No0_Grass"> 90,

    <"capacity_in_Loc2_K80_No0", "process_Loc2_K80_No0_Grass"> -4.3875,

    <"capacity_out_Loc2_K80_No0", "process_Loc2_K80_No0_Grass"> 4.3875,

    <"heat_balance_Loc2", "process_Loc2_K80_No0_Grass"> -0.015782,

    <"min_ratio_Loc2_K80_No0_Manure", "process_Loc2_K80_No0_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K80_No0_Grass"> -1,

 # process_Loc2_K80_No0_Inter:

    <"biogas_Loc2", "process_Loc2_K80_No0_Inter"> 72,

    <"capacity_in_Loc2_K80_No0", "process_Loc2_K80_No0_Inter"> -3.51,

    <"capacity_out_Loc2_K80_No0", "process_Loc2_K80_No0_Inter"> 3.51,

    <"heat_balance_Loc2", "process_Loc2_K80_No0_Inter"> -0.0353441,

    <"min_ratio_Loc2_K80_No0_Manure", "process_Loc2_K80_No0_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K80_No0_Inter"> -1,

 # process_Loc2_K80_No0_Manure:

    <"biogas_Loc2", "process_Loc2_K80_No0_Manure"> 18,

    <"capacity_in_Loc2_K80_No0", "process_Loc2_K80_No0_Manure"> -0.8775,

    <"capacity_out_Loc2_K80_No0", "process_Loc2_K80_No0_Manure"> 0.8775,

    <"heat_balance_Loc2", "process_Loc2_K80_No0_Manure"> -0.0411573,

    <"min_ratio_Loc2_K80_No0_Manure", "process_Loc2_K80_No0_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K80_No0_Manure"> -1,

 # process_Loc2_K80_No0_slack:

    <"capacity_in_Loc2_K80_No0", "process_Loc2_K80_No0_slack"> -0.8775,

    <"capacity_out_Loc2_K80_No0", "process_Loc2_K80_No0_slack"> 0.8775,

 # process_Loc2_K80_No1_Corn:

    <"biogas_Loc2", "process_Loc2_K80_No1_Corn"> 112.2,

    <"capacity_in_Loc2_K80_No1", "process_Loc2_K80_No1_Corn"> -5.46975,

    <"capacity_out_Loc2_K80_No1", "process_Loc2_K80_No1_Corn"> 5.46975,

    <"heat_balance_Loc2", "process_Loc2_K80_No1_Corn"> -0.0415894,

    <"min_ratio_Loc2_K80_No1_Manure", "process_Loc2_K80_No1_Corn"> -0.3,

    <"substrate_feed_Loc2_Corn", "process_Loc2_K80_No1_Corn"> -1,

 # process_Loc2_K80_No1_Grass:

    <"biogas_Loc2", "process_Loc2_K80_No1_Grass"> 90,

    <"capacity_in_Loc2_K80_No1", "process_Loc2_K80_No1_Grass"> -4.3875,

    <"capacity_out_Loc2_K80_No1", "process_Loc2_K80_No1_Grass"> 4.3875,

    <"heat_balance_Loc2", "process_Loc2_K80_No1_Grass"> -0.015782,

    <"min_ratio_Loc2_K80_No1_Manure", "process_Loc2_K80_No1_Grass"> -0.3,

    <"substrate_feed_Loc2_Grass", "process_Loc2_K80_No1_Grass"> -1,

 # process_Loc2_K80_No1_Inter:

    <"biogas_Loc2", "process_Loc2_K80_No1_Inter"> 72,

    <"capacity_in_Loc2_K80_No1", "process_Loc2_K80_No1_Inter"> -3.51,

    <"capacity_out_Loc2_K80_No1", "process_Loc2_K80_No1_Inter"> 3.51,

    <"heat_balance_Loc2", "process_Loc2_K80_No1_Inter"> -0.0353441,

    <"min_ratio_Loc2_K80_No1_Manure", "process_Loc2_K80_No1_Inter"> -0.3,

    <"substrate_feed_Loc2_Inter", "process_Loc2_K80_No1_Inter"> -1,

 # process_Loc2_K80_No1_Manure:

    <"biogas_Loc2", "process_Loc2_K80_No1_Manure"> 18,

    <"capacity_in_Loc2_K80_No1", "process_Loc2_K80_No1_Manure"> -0.8775,

    <"capacity_out_Loc2_K80_No1", "process_Loc2_K80_No1_Manure"> 0.8775,

    <"heat_balance_Loc2", "process_Loc2_K80_No1_Manure"> -0.0411573,

    <"min_ratio_Loc2_K80_No1_Manure", "process_Loc2_K80_No1_Manure"> 0.7,

    <"substrate_feed_Loc2_Manure", "process_Loc2_K80_No1_Manure"> -1,

 # process_Loc2_K80_No1_slack:

    <"capacity_in_Loc2_K80_No1", "process_Loc2_K80_No1_slack"> -0.8775,

    <"capacity_out_Loc2_K80_No1", "process_Loc2_K80_No1_slack"> 0.8775,

 # process_Loc3_K160_No0_Corn:

    <"biogas_Loc3", "process_Loc3_K160_No0_Corn"> 112.2,

    <"capacity_in_Loc3_K160_No0", "process_Loc3_K160_No0_Corn"> -2.73487,

    <"capacity_out_Loc3_K160_No0", "process_Loc3_K160_No0_Corn"> 2.73487,

    <"heat_balance_Loc3", "process_Loc3_K160_No0_Corn"> -0.0415894,

    <"min_ratio_Loc3_K160_No0_Manure", "process_Loc3_K160_No0_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K160_No0_Corn"> -1,

 # process_Loc3_K160_No0_Grass:

    <"biogas_Loc3", "process_Loc3_K160_No0_Grass"> 90,

    <"capacity_in_Loc3_K160_No0", "process_Loc3_K160_No0_Grass"> -2.19375,

    <"capacity_out_Loc3_K160_No0", "process_Loc3_K160_No0_Grass"> 2.19375,

    <"heat_balance_Loc3", "process_Loc3_K160_No0_Grass"> -0.015782,

    <"min_ratio_Loc3_K160_No0_Manure", "process_Loc3_K160_No0_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K160_No0_Grass"> -1,

 # process_Loc3_K160_No0_Inter:

    <"biogas_Loc3", "process_Loc3_K160_No0_Inter"> 72,

    <"capacity_in_Loc3_K160_No0", "process_Loc3_K160_No0_Inter"> -1.755,

    <"capacity_out_Loc3_K160_No0", "process_Loc3_K160_No0_Inter"> 1.755,

    <"heat_balance_Loc3", "process_Loc3_K160_No0_Inter"> -0.0353441,

    <"min_ratio_Loc3_K160_No0_Manure", "process_Loc3_K160_No0_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K160_No0_Inter"> -1,

 # process_Loc3_K160_No0_Manure:

    <"biogas_Loc3", "process_Loc3_K160_No0_Manure"> 18,

    <"capacity_in_Loc3_K160_No0", "process_Loc3_K160_No0_Manure"> -0.43875,

    <"capacity_out_Loc3_K160_No0", "process_Loc3_K160_No0_Manure"> 0.43875,

    <"heat_balance_Loc3", "process_Loc3_K160_No0_Manure"> -0.0411573,

    <"min_ratio_Loc3_K160_No0_Manure", "process_Loc3_K160_No0_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K160_No0_Manure"> -1,

 # process_Loc3_K160_No0_slack:

    <"capacity_in_Loc3_K160_No0", "process_Loc3_K160_No0_slack"> -0.43875,

    <"capacity_out_Loc3_K160_No0", "process_Loc3_K160_No0_slack"> 0.43875,

 # process_Loc3_K160_No1_Corn:

    <"biogas_Loc3", "process_Loc3_K160_No1_Corn"> 112.2,

    <"capacity_in_Loc3_K160_No1", "process_Loc3_K160_No1_Corn"> -2.73487,

    <"capacity_out_Loc3_K160_No1", "process_Loc3_K160_No1_Corn"> 2.73487,

    <"heat_balance_Loc3", "process_Loc3_K160_No1_Corn"> -0.0415894,

    <"min_ratio_Loc3_K160_No1_Manure", "process_Loc3_K160_No1_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K160_No1_Corn"> -1,

 # process_Loc3_K160_No1_Grass:

    <"biogas_Loc3", "process_Loc3_K160_No1_Grass"> 90,

    <"capacity_in_Loc3_K160_No1", "process_Loc3_K160_No1_Grass"> -2.19375,

    <"capacity_out_Loc3_K160_No1", "process_Loc3_K160_No1_Grass"> 2.19375,

    <"heat_balance_Loc3", "process_Loc3_K160_No1_Grass"> -0.015782,

    <"min_ratio_Loc3_K160_No1_Manure", "process_Loc3_K160_No1_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K160_No1_Grass"> -1,

 # process_Loc3_K160_No1_Inter:

    <"biogas_Loc3", "process_Loc3_K160_No1_Inter"> 72,

    <"capacity_in_Loc3_K160_No1", "process_Loc3_K160_No1_Inter"> -1.755,

    <"capacity_out_Loc3_K160_No1", "process_Loc3_K160_No1_Inter"> 1.755,

    <"heat_balance_Loc3", "process_Loc3_K160_No1_Inter"> -0.0353441,

    <"min_ratio_Loc3_K160_No1_Manure", "process_Loc3_K160_No1_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K160_No1_Inter"> -1,

 # process_Loc3_K160_No1_Manure:

    <"biogas_Loc3", "process_Loc3_K160_No1_Manure"> 18,

    <"capacity_in_Loc3_K160_No1", "process_Loc3_K160_No1_Manure"> -0.43875,

    <"capacity_out_Loc3_K160_No1", "process_Loc3_K160_No1_Manure"> 0.43875,

    <"heat_balance_Loc3", "process_Loc3_K160_No1_Manure"> -0.0411573,

    <"min_ratio_Loc3_K160_No1_Manure", "process_Loc3_K160_No1_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K160_No1_Manure"> -1,

 # process_Loc3_K160_No1_slack:

    <"capacity_in_Loc3_K160_No1", "process_Loc3_K160_No1_slack"> -0.43875,

    <"capacity_out_Loc3_K160_No1", "process_Loc3_K160_No1_slack"> 0.43875,

 # process_Loc3_K250_No0_Corn:

    <"biogas_Loc3", "process_Loc3_K250_No0_Corn"> 112.2,

    <"capacity_in_Loc3_K250_No0", "process_Loc3_K250_No0_Corn"> -1.75032,

    <"capacity_out_Loc3_K250_No0", "process_Loc3_K250_No0_Corn"> 1.75032,

    <"heat_balance_Loc3", "process_Loc3_K250_No0_Corn"> -0.0415894,

    <"min_ratio_Loc3_K250_No0_Manure", "process_Loc3_K250_No0_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K250_No0_Corn"> -1,

 # process_Loc3_K250_No0_Grass:

    <"biogas_Loc3", "process_Loc3_K250_No0_Grass"> 90,

    <"capacity_in_Loc3_K250_No0", "process_Loc3_K250_No0_Grass"> -1.404,

    <"capacity_out_Loc3_K250_No0", "process_Loc3_K250_No0_Grass"> 1.404,

    <"heat_balance_Loc3", "process_Loc3_K250_No0_Grass"> -0.015782,

    <"min_ratio_Loc3_K250_No0_Manure", "process_Loc3_K250_No0_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K250_No0_Grass"> -1,

 # process_Loc3_K250_No0_Inter:

    <"biogas_Loc3", "process_Loc3_K250_No0_Inter"> 72,

    <"capacity_in_Loc3_K250_No0", "process_Loc3_K250_No0_Inter"> -1.1232,

    <"capacity_out_Loc3_K250_No0", "process_Loc3_K250_No0_Inter"> 1.1232,

    <"heat_balance_Loc3", "process_Loc3_K250_No0_Inter"> -0.0353441,

    <"min_ratio_Loc3_K250_No0_Manure", "process_Loc3_K250_No0_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K250_No0_Inter"> -1,

 # process_Loc3_K250_No0_Manure:

    <"biogas_Loc3", "process_Loc3_K250_No0_Manure"> 18,

    <"capacity_in_Loc3_K250_No0", "process_Loc3_K250_No0_Manure"> -0.2808,

    <"capacity_out_Loc3_K250_No0", "process_Loc3_K250_No0_Manure"> 0.2808,

    <"heat_balance_Loc3", "process_Loc3_K250_No0_Manure"> -0.0411573,

    <"min_ratio_Loc3_K250_No0_Manure", "process_Loc3_K250_No0_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K250_No0_Manure"> -1,

 # process_Loc3_K250_No0_slack:

    <"capacity_in_Loc3_K250_No0", "process_Loc3_K250_No0_slack"> -0.2808,

    <"capacity_out_Loc3_K250_No0", "process_Loc3_K250_No0_slack"> 0.2808,

 # process_Loc3_K250_No1_Corn:

    <"biogas_Loc3", "process_Loc3_K250_No1_Corn"> 112.2,

    <"capacity_in_Loc3_K250_No1", "process_Loc3_K250_No1_Corn"> -1.75032,

    <"capacity_out_Loc3_K250_No1", "process_Loc3_K250_No1_Corn"> 1.75032,

    <"heat_balance_Loc3", "process_Loc3_K250_No1_Corn"> -0.0415894,

    <"min_ratio_Loc3_K250_No1_Manure", "process_Loc3_K250_No1_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K250_No1_Corn"> -1,

 # process_Loc3_K250_No1_Grass:

    <"biogas_Loc3", "process_Loc3_K250_No1_Grass"> 90,

    <"capacity_in_Loc3_K250_No1", "process_Loc3_K250_No1_Grass"> -1.404,

    <"capacity_out_Loc3_K250_No1", "process_Loc3_K250_No1_Grass"> 1.404,

    <"heat_balance_Loc3", "process_Loc3_K250_No1_Grass"> -0.015782,

    <"min_ratio_Loc3_K250_No1_Manure", "process_Loc3_K250_No1_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K250_No1_Grass"> -1,

 # process_Loc3_K250_No1_Inter:

    <"biogas_Loc3", "process_Loc3_K250_No1_Inter"> 72,

    <"capacity_in_Loc3_K250_No1", "process_Loc3_K250_No1_Inter"> -1.1232,

    <"capacity_out_Loc3_K250_No1", "process_Loc3_K250_No1_Inter"> 1.1232,

    <"heat_balance_Loc3", "process_Loc3_K250_No1_Inter"> -0.0353441,

    <"min_ratio_Loc3_K250_No1_Manure", "process_Loc3_K250_No1_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K250_No1_Inter"> -1,

 # process_Loc3_K250_No1_Manure:

    <"biogas_Loc3", "process_Loc3_K250_No1_Manure"> 18,

    <"capacity_in_Loc3_K250_No1", "process_Loc3_K250_No1_Manure"> -0.2808,

    <"capacity_out_Loc3_K250_No1", "process_Loc3_K250_No1_Manure"> 0.2808,

    <"heat_balance_Loc3", "process_Loc3_K250_No1_Manure"> -0.0411573,

    <"min_ratio_Loc3_K250_No1_Manure", "process_Loc3_K250_No1_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K250_No1_Manure"> -1,

 # process_Loc3_K250_No1_slack:

    <"capacity_in_Loc3_K250_No1", "process_Loc3_K250_No1_slack"> -0.2808,

    <"capacity_out_Loc3_K250_No1", "process_Loc3_K250_No1_slack"> 0.2808,

 # process_Loc3_K500_No0_Corn:

    <"biogas_Loc3", "process_Loc3_K500_No0_Corn"> 112.2,

    <"capacity_in_Loc3_K500_No0", "process_Loc3_K500_No0_Corn"> -0.87516,

    <"capacity_out_Loc3_K500_No0", "process_Loc3_K500_No0_Corn"> 0.87516,

    <"heat_balance_Loc3", "process_Loc3_K500_No0_Corn"> -0.0415894,

    <"min_ratio_Loc3_K500_No0_Manure", "process_Loc3_K500_No0_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K500_No0_Corn"> -1,

 # process_Loc3_K500_No0_Grass:

    <"biogas_Loc3", "process_Loc3_K500_No0_Grass"> 90,

    <"capacity_in_Loc3_K500_No0", "process_Loc3_K500_No0_Grass"> -0.702,

    <"capacity_out_Loc3_K500_No0", "process_Loc3_K500_No0_Grass"> 0.702,

    <"heat_balance_Loc3", "process_Loc3_K500_No0_Grass"> -0.015782,

    <"min_ratio_Loc3_K500_No0_Manure", "process_Loc3_K500_No0_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K500_No0_Grass"> -1,

 # process_Loc3_K500_No0_Inter:

    <"biogas_Loc3", "process_Loc3_K500_No0_Inter"> 72,

    <"capacity_in_Loc3_K500_No0", "process_Loc3_K500_No0_Inter"> -0.5616,

    <"capacity_out_Loc3_K500_No0", "process_Loc3_K500_No0_Inter"> 0.5616,

    <"heat_balance_Loc3", "process_Loc3_K500_No0_Inter"> -0.0353441,

    <"min_ratio_Loc3_K500_No0_Manure", "process_Loc3_K500_No0_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K500_No0_Inter"> -1,

 # process_Loc3_K500_No0_Manure:

    <"biogas_Loc3", "process_Loc3_K500_No0_Manure"> 18,

    <"capacity_in_Loc3_K500_No0", "process_Loc3_K500_No0_Manure"> -0.1404,

    <"capacity_out_Loc3_K500_No0", "process_Loc3_K500_No0_Manure"> 0.1404,

    <"heat_balance_Loc3", "process_Loc3_K500_No0_Manure"> -0.0411573,

    <"min_ratio_Loc3_K500_No0_Manure", "process_Loc3_K500_No0_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K500_No0_Manure"> -1,

 # process_Loc3_K500_No0_slack:

    <"capacity_in_Loc3_K500_No0", "process_Loc3_K500_No0_slack"> -0.1404,

    <"capacity_out_Loc3_K500_No0", "process_Loc3_K500_No0_slack"> 0.1404,

 # process_Loc3_K500_No1_Corn:

    <"biogas_Loc3", "process_Loc3_K500_No1_Corn"> 112.2,

    <"capacity_in_Loc3_K500_No1", "process_Loc3_K500_No1_Corn"> -0.87516,

    <"capacity_out_Loc3_K500_No1", "process_Loc3_K500_No1_Corn"> 0.87516,

    <"heat_balance_Loc3", "process_Loc3_K500_No1_Corn"> -0.0415894,

    <"min_ratio_Loc3_K500_No1_Manure", "process_Loc3_K500_No1_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K500_No1_Corn"> -1,

 # process_Loc3_K500_No1_Grass:

    <"biogas_Loc3", "process_Loc3_K500_No1_Grass"> 90,

    <"capacity_in_Loc3_K500_No1", "process_Loc3_K500_No1_Grass"> -0.702,

    <"capacity_out_Loc3_K500_No1", "process_Loc3_K500_No1_Grass"> 0.702,

    <"heat_balance_Loc3", "process_Loc3_K500_No1_Grass"> -0.015782,

    <"min_ratio_Loc3_K500_No1_Manure", "process_Loc3_K500_No1_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K500_No1_Grass"> -1,

 # process_Loc3_K500_No1_Inter:

    <"biogas_Loc3", "process_Loc3_K500_No1_Inter"> 72,

    <"capacity_in_Loc3_K500_No1", "process_Loc3_K500_No1_Inter"> -0.5616,

    <"capacity_out_Loc3_K500_No1", "process_Loc3_K500_No1_Inter"> 0.5616,

    <"heat_balance_Loc3", "process_Loc3_K500_No1_Inter"> -0.0353441,

    <"min_ratio_Loc3_K500_No1_Manure", "process_Loc3_K500_No1_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K500_No1_Inter"> -1,

 # process_Loc3_K500_No1_Manure:

    <"biogas_Loc3", "process_Loc3_K500_No1_Manure"> 18,

    <"capacity_in_Loc3_K500_No1", "process_Loc3_K500_No1_Manure"> -0.1404,

    <"capacity_out_Loc3_K500_No1", "process_Loc3_K500_No1_Manure"> 0.1404,

    <"heat_balance_Loc3", "process_Loc3_K500_No1_Manure"> -0.0411573,

    <"min_ratio_Loc3_K500_No1_Manure", "process_Loc3_K500_No1_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K500_No1_Manure"> -1,

 # process_Loc3_K500_No1_slack:

    <"capacity_in_Loc3_K500_No1", "process_Loc3_K500_No1_slack"> -0.1404,

    <"capacity_out_Loc3_K500_No1", "process_Loc3_K500_No1_slack"> 0.1404,

 # process_Loc3_K80_No0_Corn:

    <"biogas_Loc3", "process_Loc3_K80_No0_Corn"> 112.2,

    <"capacity_in_Loc3_K80_No0", "process_Loc3_K80_No0_Corn"> -5.46975,

    <"capacity_out_Loc3_K80_No0", "process_Loc3_K80_No0_Corn"> 5.46975,

    <"heat_balance_Loc3", "process_Loc3_K80_No0_Corn"> -0.0415894,

    <"min_ratio_Loc3_K80_No0_Manure", "process_Loc3_K80_No0_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K80_No0_Corn"> -1,

 # process_Loc3_K80_No0_Grass:

    <"biogas_Loc3", "process_Loc3_K80_No0_Grass"> 90,

    <"capacity_in_Loc3_K80_No0", "process_Loc3_K80_No0_Grass"> -4.3875,

    <"capacity_out_Loc3_K80_No0", "process_Loc3_K80_No0_Grass"> 4.3875,

    <"heat_balance_Loc3", "process_Loc3_K80_No0_Grass"> -0.015782,

    <"min_ratio_Loc3_K80_No0_Manure", "process_Loc3_K80_No0_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K80_No0_Grass"> -1,

 # process_Loc3_K80_No0_Inter:

    <"biogas_Loc3", "process_Loc3_K80_No0_Inter"> 72,

    <"capacity_in_Loc3_K80_No0", "process_Loc3_K80_No0_Inter"> -3.51,

    <"capacity_out_Loc3_K80_No0", "process_Loc3_K80_No0_Inter"> 3.51,

    <"heat_balance_Loc3", "process_Loc3_K80_No0_Inter"> -0.0353441,

    <"min_ratio_Loc3_K80_No0_Manure", "process_Loc3_K80_No0_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K80_No0_Inter"> -1,

 # process_Loc3_K80_No0_Manure:

    <"biogas_Loc3", "process_Loc3_K80_No0_Manure"> 18,

    <"capacity_in_Loc3_K80_No0", "process_Loc3_K80_No0_Manure"> -0.8775,

    <"capacity_out_Loc3_K80_No0", "process_Loc3_K80_No0_Manure"> 0.8775,

    <"heat_balance_Loc3", "process_Loc3_K80_No0_Manure"> -0.0411573,

    <"min_ratio_Loc3_K80_No0_Manure", "process_Loc3_K80_No0_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K80_No0_Manure"> -1,

 # process_Loc3_K80_No0_slack:

    <"capacity_in_Loc3_K80_No0", "process_Loc3_K80_No0_slack"> -0.8775,

    <"capacity_out_Loc3_K80_No0", "process_Loc3_K80_No0_slack"> 0.8775,

 # process_Loc3_K80_No1_Corn:

    <"biogas_Loc3", "process_Loc3_K80_No1_Corn"> 112.2,

    <"capacity_in_Loc3_K80_No1", "process_Loc3_K80_No1_Corn"> -5.46975,

    <"capacity_out_Loc3_K80_No1", "process_Loc3_K80_No1_Corn"> 5.46975,

    <"heat_balance_Loc3", "process_Loc3_K80_No1_Corn"> -0.0415894,

    <"min_ratio_Loc3_K80_No1_Manure", "process_Loc3_K80_No1_Corn"> -0.3,

    <"substrate_feed_Loc3_Corn", "process_Loc3_K80_No1_Corn"> -1,

 # process_Loc3_K80_No1_Grass:

    <"biogas_Loc3", "process_Loc3_K80_No1_Grass"> 90,

    <"capacity_in_Loc3_K80_No1", "process_Loc3_K80_No1_Grass"> -4.3875,

    <"capacity_out_Loc3_K80_No1", "process_Loc3_K80_No1_Grass"> 4.3875,

    <"heat_balance_Loc3", "process_Loc3_K80_No1_Grass"> -0.015782,

    <"min_ratio_Loc3_K80_No1_Manure", "process_Loc3_K80_No1_Grass"> -0.3,

    <"substrate_feed_Loc3_Grass", "process_Loc3_K80_No1_Grass"> -1,

 # process_Loc3_K80_No1_Inter:

    <"biogas_Loc3", "process_Loc3_K80_No1_Inter"> 72,

    <"capacity_in_Loc3_K80_No1", "process_Loc3_K80_No1_Inter"> -3.51,

    <"capacity_out_Loc3_K80_No1", "process_Loc3_K80_No1_Inter"> 3.51,

    <"heat_balance_Loc3", "process_Loc3_K80_No1_Inter"> -0.0353441,

    <"min_ratio_Loc3_K80_No1_Manure", "process_Loc3_K80_No1_Inter"> -0.3,

    <"substrate_feed_Loc3_Inter", "process_Loc3_K80_No1_Inter"> -1,

 # process_Loc3_K80_No1_Manure:

    <"biogas_Loc3", "process_Loc3_K80_No1_Manure"> 18,

    <"capacity_in_Loc3_K80_No1", "process_Loc3_K80_No1_Manure"> -0.8775,

    <"capacity_out_Loc3_K80_No1", "process_Loc3_K80_No1_Manure"> 0.8775,

    <"heat_balance_Loc3", "process_Loc3_K80_No1_Manure"> -0.0411573,

    <"min_ratio_Loc3_K80_No1_Manure", "process_Loc3_K80_No1_Manure"> 0.7,

    <"substrate_feed_Loc3_Manure", "process_Loc3_K80_No1_Manure"> -1,

 # process_Loc3_K80_No1_slack:

    <"capacity_in_Loc3_K80_No1", "process_Loc3_K80_No1_slack"> -0.8775,

    <"capacity_out_Loc3_K80_No1", "process_Loc3_K80_No1_slack"> 0.8775,

 # purchase_heat_Loc1:

    <"heat_balance_Loc1", "purchase_heat_Loc1"> 1,

    <"heat_purchase", "purchase_heat_Loc1"> -1,

 # purchase_heat_Loc2:

    <"heat_balance_Loc2", "purchase_heat_Loc2"> 1,

    <"heat_purchase", "purchase_heat_Loc2"> -1,

 # purchase_heat_Loc3:

    <"heat_balance_Loc3", "purchase_heat_Loc3"> 1,

    <"heat_purchase", "purchase_heat_Loc3"> -1,

 # save_heat_Loc1:

    <"heat_balance_CENTER", "save_heat_Loc1"> 1,

    <"heat_sent_Loc1", "save_heat_Loc1"> -1,

 # save_heat_Loc2:

    <"heat_balance_CENTER", "save_heat_Loc2"> 1,

    <"heat_sent_Loc2", "save_heat_Loc2"> -1,

 # save_heat_Loc3:

    <"heat_balance_CENTER", "save_heat_Loc3"> 1,

    <"heat_sent_Loc3", "save_heat_Loc3"> -1,

 # sell_electricity_K160:

    <"electricity_K160", "sell_electricity_K160"> -1,

    <"revenue", "sell_electricity_K160"> 205,

 # sell_electricity_K250:

    <"electricity_K250", "sell_electricity_K250"> -1,

    <"revenue", "sell_electricity_K250"> 205,

 # sell_electricity_K500:

    <"electricity_K500", "sell_electricity_K500"> -1,

    <"revenue", "sell_electricity_K500"> 185,

 # sell_electricity_K80:

    <"electricity_K80", "sell_electricity_K80"> -1,

    <"revenue", "sell_electricity_K80"> 205,

 # sell_heat:

    <"heat_balance_CENTER", "sell_heat"> -1,

    <"revenue", "sell_heat"> 22.5,

 # silo_plate_Loc1:

    <"silo_plate_availability_material_Loc1", "silo_plate_Loc1"> 1,

 # silo_plate_Loc2:

    <"silo_plate_availability_material_Loc2", "silo_plate_Loc2"> 1,

 # silo_plate_Loc3:

    <"silo_plate_availability_material_Loc3", "silo_plate_Loc3"> 1,

 # transfer_biogas_Loc1:

    <"biogas_CENTER", "transfer_biogas_Loc1"> 1,

    <"biogas_Loc1", "transfer_biogas_Loc1"> -1,

    <"biogas_pipe_availability_material_Pipe1", "transfer_biogas_Loc1"> -1,

 # transfer_biogas_Loc2:

    <"biogas_CENTER", "transfer_biogas_Loc2"> 1,

    <"biogas_Loc2", "transfer_biogas_Loc2"> -1,

    <"biogas_pipe_availability_material_Pipe2", "transfer_biogas_Loc2"> -1,

 # transfer_biogas_Loc3:

    <"biogas_CENTER", "transfer_biogas_Loc3"> 1,

    <"biogas_Loc3", "transfer_biogas_Loc3"> -1,

    <"biogas_pipe_availability_material_Pipe1", "transfer_biogas_Loc3"> -1,

    <"biogas_pipe_availability_material_Pipe3to1", "transfer_biogas_Loc3"> -1,

 # transfer_heat_Loc1:

    <"heat_balance_Loc1", "transfer_heat_Loc1"> -1,

    <"heat_pipe_availability_material_Loc1_Pipe1", "transfer_heat_Loc1"> -0.001,

    <"heat_sent_Loc1", "transfer_heat_Loc1"> 1,

 # transfer_heat_Loc2:

    <"heat_balance_Loc2", "transfer_heat_Loc2"> -1,

    <"heat_pipe_availability_material_Loc2_Pipe2", "transfer_heat_Loc2"> -0.001,

    <"heat_sent_Loc2", "transfer_heat_Loc2"> 1,

 # transfer_heat_Loc3:

    <"heat_balance_Loc3", "transfer_heat_Loc3"> -1,

    <"heat_pipe_availability_material_Loc3_Pipe1", "transfer_heat_Loc3"> -0.001,

    <"heat_pipe_availability_material_Loc3_Pipe3to1", "transfer_heat_Loc3"> -0.001,

    <"heat_sent_Loc3", "transfer_heat_Loc3"> 1,

 # transformer_op_unit:

    <"transformer_availability_material", "transformer_op_unit"> 1

    default 0;



var exist[operating_units] binary;

var size[<o> in operating_units] real >= 0 <= capacity_upper_bound[o];

minimize cost:

   (sum<o> in operating_units: size[o]*

      (proportional_cost[o] -

       sum<m> in (raw_materials union products):

          price[m]*material_to_operating_unit_flow_rates[m, o]

      )

   ) +

   (sum<o> in operating_units:

      exist[o] * fix_cost[o]);

subto size_ub:

   forall <o> in operating_units do

      size[o] <= exist[o] * capacity_upper_bound[o];

subto size_lb:

   forall <o> in operating_units do

      size[o] >= exist[o] * capacity_lower_bound[o];

subto raw_lb:

   forall <r> in raw_materials do

      sum<o> in operating_units: -1 * material_to_operating_unit_flow_rates[r, o] * size[o] >= flow_rate_lower_bound[r];

subto inter_lb:

   forall <i> in intermediates do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[i, o] * size[o] >= 0;

subto prod_lb:

   forall <p> in products do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[p, o] * size[o] >= flow_rate_lower_bound[p];

subto raw_ub:

   forall <r> in raw_materials do

      sum<o> in operating_units: -1 * material_to_operating_unit_flow_rates[r, o] * size[o] <= flow_rate_upper_bound[r];

subto inter_ub:

   forall <i> in intermediates do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[i, o] * size[o] <= flow_rate_upper_bound[i];

subto prod_ub:

   forall <p> in products do

      sum<o> in operating_units: material_to_operating_unit_flow_rates[p, o] * size[o] <= flow_rate_upper_bound[p];

