import pns


def get_problem():
    problem = pns.Problem()
    problem.set('file_name', 'Sample_Problem')

    problem.add_raw('material_1', price=10)
    problem.add_raw('material_2', flow_rate_upper_bound=2000)
    problem.add_product('material_3', flow_rate_lower_bound=10)
    problem.add_product('material_4', price=300, flow_rate_lower_bound=10)
    problem.add_product('material_5', price=1, flow_rate_lower_bound=1700)
    problem.add_inter('material_6')
    problem.add_product('material_7', price=2, flow_rate_lower_bound=13)
    problem.add_product('material_8', flow_rate_lower_bound=13)
    problem.add_raw('material_9')
    problem.add_op_unit('operatingunit_1', capacity_upper_bound=3456789, fix_cost=3.1, proportional_cost=4.2)
    problem.add_op_unit('operatingunit_2')
    problem.add_op_unit('operatingunit_3')
    problem.add_op_unit('operatingunit_4')
    problem.add_op_unit('operatingunit_5', proportional_cost=222)
    problem.add_op_unit('operatingunit_6')
    problem.add_op_unit('operatingunit_7')
    problem.add_in('material_1', 'operatingunit_1', 23)
    problem.add_in('material_2', 'operatingunit_1', 40)
    problem.add_out('operatingunit_1', 'material_3', 7)
    problem.add_out('operatingunit_1', 'material_4', 8)
    problem.add_in('material_2', 'operatingunit_2')
    problem.add_out('operatingunit_2', 'material_5')
    problem.add_in('material_2', 'operatingunit_3')
    problem.add_out('operatingunit_3', 'material_6')
    problem.add_in('material_6', 'operatingunit_4', 77)
    problem.add_out('operatingunit_4', 'material_7', 77)
    problem.add_out('operatingunit_5', 'material_8')
    problem.add_in('material_9', 'operatingunit_6')
    return problem
