import re
import subprocess
import timeit

import problem_sample
import problem_badzell


def solve_problem(problem):
    problem_name = problem.get('file_name')
    print(f'Started solving problem "{problem_name}" ...')
    in_file_text = problem.get_problem_text()
    file = open('Graph.in', 'wt')
    file.write(in_file_text)
    file.close()
    file = open('Graph.out', 'wt')
    file.write('')
    file.close()
    solver_path = (r'C:\Users\Éles András OFF\AppData\Local\Apps\2.0\X7DC8DP5.DV7\PE01P6DT.1K0'
                   r'\p-gr..tion_0000000000000000_0005.0002_1962c93fb345a71a\Solver\PNS\pgraph_solver.exe')
    time_start = timeit.default_timer()
    subprocess.call([solver_path, 'INSIDEOUT', 'Graph.in', 'Graph.out', '1'],
                    stdout=subprocess.DEVNULL)
    time_end = timeit.default_timer()
    time_elapsed = time_end - time_start
    print(f'Done solving problem "{problem_name}".')
    print(f'Time elapsed: {time_elapsed} seconds.')
    file = open('Graph.out', 'rt')
    out_file_text = file.read()
    file.close()
    money_unit = problem.get('money_unit')
    time_unit = problem.get('time_unit')
    objective_regex = r'Total\s+annual\s+cost\s*=\s+(\S+)\s+' + str(money_unit) + '/' + str(time_unit)
    m = re.search(objective_regex, out_file_text)
    objective = m.group(1) if m else None
    print('Objective = {}'.format(objective))
    return {
        'in_file_text': in_file_text,
        'out_file_text': out_file_text,
        'objective': objective,
        'time_elapsed': time_elapsed,
    }


def execute_problem_sample():
    problem = problem_sample.get_problem()
    print('Problem "{}"\n'.format(problem.get('file_name')))
    problem.check_structure()
    problem.print_stats('stats', 'issues')
    solve_problem(problem)
    print()


def execute_problem_badzell(**kwargs):
    problem = problem_badzell.get_problem()
    print('Problem "{}"\n'.format(problem.get('file_name')))
    problem.check_structure()
    problem.print_stats('stats', 'issues')
    results = solve_problem(problem)
    if kwargs.get('debug_extra'):
        def sum_it(regex_iterator, group_id=1):
            return sum([float(x.group(group_id)) for x in regex_iterator])
        out_file_text = results['out_file_text']
        # sum of raw material costs:
        substrate_cost = sum_it(re.finditer(r'substrate_available_FM_\S+\s\((\S+)\sEUR/y\):', out_file_text))
        print(f'Substrate cost: {substrate_cost}')
        # sum of operating unit costs:
        transport_cost = sum_it(re.finditer(r'\*op_transport_substrates_\S+\s\((\S+)\sEUR/y\):', out_file_text))
        print(f'Transport cost: {transport_cost}')
    print()


if __name__ == '__main__':
    execute_problem_sample()
    execute_problem_badzell(debug_extra=True)
