///////////////////////////////////////////////////////////////////////////////  librerias y definicion de variales  /////////////////////////////////////////////////////////////////////////////////////
#include <Servo.h>
Servo myservo;
#include <Wire.h>
#include "RTClib.h"
RTC_DS1307 rtc;
int segundo,minuto,hora,dia,mes;
long anio; //variable año
DateTime HoraFecha;
#include <PID_v1.h>
double set_temp, Input, Output;
double Kp=50, Ki=5, Kd=0;
PID myPID(&Input, &Output, &set_temp, Kp, Ki, Kd, DIRECT);
int WindowSize = 5000;
unsigned long windowStartTime;
#include <SHT21.h> 
SHT21 mySHT21;
float Tamb,Hamb; 
#include <SparkFun_SHTC3.h>
SHTC3 mySHTC3;
float RH,T;
#include <LiquidCrystal_I2C.h>
#include <BTS7960.h>                         //BTS7960 works between +3v and +5v so you can use a uno, mega or a nano.
#define L_PWM 5                              //pin 5 supports 980hz pwm frequency
#define R_PWM 6                              //pin 6 supports 980hz pwm frequency
BTS7960 peltier(L_PWM, R_PWM);               //This method will create a object of the class BTS7960
#define analog_control A7
#define time_L_on 7
#define time_L_off  8
#define time_F_on 12
#define time_F_off  4
#define time_T1 16
#define time_T2 15
#define Setting_run 2
#define consigna_T1 14
#define consigna_T2 13
#define outluz 3
#define outfood 9
#define memset A6
#define levellux 17
int lcdColumns = 20;
int lcdRows = 4;
LiquidCrystal_I2C lcd(0x27, lcdColumns, lcdRows);
unsigned long t0 =millis();
unsigned long t1 =millis();
unsigned long t2 =millis();
unsigned long t3 =-86400000;
int Tm =200;
float total_Hr = 0.0, total_Temp = 0.0,total_Tamb=0,total_Hamb=0,val;
float promedio_Hr = 0.0,promedio_Temp=0.0,promedio_Tamb,promedio_Hamb;
float rad=0,modulo=0,luxmax=150;
int i=0,t_lamp_on=-21,t_lamp_off=9,t_food_on=21,t_food_off=9,t_T1=9,t_T2=21;
int T1=25,T2=20,luz,luz_1=-1,food,food_1=-1,t=16,t_1=-1,tem_1,x=0;
int motorup=0,motordwn=0,sinluz,luzmax=150;
char t_lamp_on_string[2],t_lamp_off_string[2],t_food_on_string[2],t_food_off_string[2],t_T1_string[2],t_T2_string[2],T1_string[2],T2_string[2],value_string[2];               //variables tipo chart para imprimir en LCD
char hora_string[2],minuto_string[2],segundo_string[2],dia_string[2],mes_string[2],anio_string[4],promedio_Temp_string[4],promedio_Hr_string[2],luxmax_string[3]="150";       //variables tipo chart para imprimir en LCD
long int duracion;
boolean b=0,a=1,c=0;
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void setup() {
 //rtc.adjust(DateTime(2023,7,11,12,15,0));                    // allows adjusting time in case of battery change. Once on time, it should be unabled
 myservo.attach(9);                                            // assigns digital pin 9 to the servo motor
 windowStartTime = millis();
 myPID.SetOutputLimits(0, WindowSize);
 myPID.SetMode(AUTOMATIC);
 Serial.begin(9600); 
 Wire.begin();
 errorDecoder(mySHTC3.begin());                                 // call errorcode function to check whether there are errors in sensor SHT3
 
 //////////////////////////////////////////define the differents pins as inputs or outputs  ////////////////////////////////////////////
 pinMode(time_L_on,INPUT); 
 pinMode(time_L_off,INPUT); 
 pinMode(time_F_on,INPUT); 
 pinMode(time_F_off,INPUT); 
 pinMode(time_T1,INPUT); 
 pinMode(time_T2,INPUT); 
 pinMode(consigna_T1,INPUT); 
 pinMode(consigna_T2,INPUT); 
 pinMode(Setting_run,INPUT);
 pinMode(memset,INPUT);
 pinMode(outluz,OUTPUT);
 pinMode(outfood,OUTPUT);
 pinMode(levellux,INPUT);
 ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
 lcd.init();                                // initialize LCD
 lcd.backlight();                           // turn on LCD backlight                      
 rtc.begin();                               // We start the clock module RTC
 peltier.begin();                           //To set the Peltier driver as output


}

void loop() {

if (digitalRead(Setting_run)==HIGH) {  /////////////////////////////////////////////// goes on if the setup mode is active ///////////////////////////////////////////////////////////////////////////////////////////////////////////////


if (b==0) {                                                         // cleans the screen

    lcd.clear();
    
          }
b=1;
DateTime now = rtc.now();                                           // we get the current time and date
lcd.setCursor(1,0);
char buf2[] = "DD/MM/YY hh:mm:ss";
lcd.print(now.toString(buf2));                                      // prints date and time on lcd
lcd.setCursor(0,1);
lcd.print(F("Setting "));

  //////////////////////////// reads the rotating selector, and for each position shows its menu, and allows selecting the variable and storing its value when pushing set ////////////////////////////////////////////////////////////////////////////
  
  if (digitalRead(time_L_on) ==HIGH){                               //  reads whether Lon (light on) is selected
      lcd.setCursor(8,1);
      lcd.print(F("time Lamp   "));
      lcd.setCursor(0,2);
      lcd.print(F("Lamp On:"));
      lcd.setCursor(8,2);
      dtostrf(t_lamp_on,3,0, t_lamp_on_string);
      lcd.print(t_lamp_on_string);
      lcd.setCursor(11,2);
      lcd.print(F(" hours   "));
      lcd.setCursor(11,3);
      lcd.print(F(" hours   "));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,-24,24);            // using the potentiometer adjusts a value between -24 and 24 and assigns it to variable val
      dtostrf(val,3,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(value_string);
      if(analogRead(memset) >100){t_lamp_on=val;}                //when pushing set the selected value is assigned to variable t_lamp_on
                           
                                   
                                    }
  
  if (digitalRead(time_L_off) ==HIGH){                              // reads whether Loff (light Off) is selected
      lcd.print(F("time Lamp   "));
      lcd.setCursor(0,2);
      lcd.print(F("Lamp Off:"));
      lcd.setCursor(9,2);
      dtostrf(t_lamp_off,2,0, t_lamp_off_string);
      lcd.print(t_lamp_off_string);
      lcd.setCursor(11,2);
      lcd.print(F(" hours   "));
      lcd.setCursor(11,3);
      lcd.print(F(" hours   "));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,0,24);              //using the potentiometer adjusts a value between 0 and 24 and assigns it to variable val
      dtostrf(val,2,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(F(" "));
      lcd.print(value_string);
      if(analogRead(memset) >100){t_lamp_off=val;}              //when pushing set the selected value is assigned to variable t_lamp_off
                                    }
  
  if (digitalRead(time_F_on) ==HIGH){                              //  reads whether Fon (food On) is selected
      lcd.setCursor(8,1);
      lcd.print(F("time Food   "));
      lcd.setCursor(0,2);
      lcd.print(F("Food On: "));
      lcd.setCursor(9,2);
      dtostrf(t_food_on,2,0, t_food_on_string); 
      lcd.print(t_food_on_string);
      lcd.setCursor(11,2);
      lcd.print(F(" hours   "));
      lcd.setCursor(11,3);
      lcd.print(F(" hours   "));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,0,24);            //reads whether Fon (food On) is selected
      dtostrf(val,2,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(F(" "));
      lcd.print(value_string);
      if(analogRead(memset) >100){t_food_on=val;}               //when pushing set the selected value is assigned to variable t_food_on
                                    }
  
  
  if (digitalRead(time_F_off) ==HIGH){                            //  reads whether Foff (food Off) is selected
      lcd.setCursor(8,1);
      lcd.print(F("time Food   "));
      lcd.setCursor(0,2);
      lcd.print(F("Food Off:"));
      lcd.setCursor(9,2);
      dtostrf(t_food_off,2,0, t_food_off_string); 
      lcd.print(t_food_off_string);
      lcd.setCursor(11,2);
      lcd.print(F(" hours   "));
      lcd.setCursor(11,3);
      lcd.print(F(" hours   "));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,0,24);          //using the potentiometer adjusts a value between 0 and 24 and assigns it to variable val
      dtostrf(val,2,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(F(" "));
      lcd.print(value_string);
      if(analogRead(memset) >100){t_food_off=val;}           //when pushing set the selected value is assigned to variable t_food_off
                                    }

  if (digitalRead(time_T1) ==HIGH){                            //  reads whether T1on (Temperatura 1) is selected
      lcd.setCursor(8,1);
      lcd.print(F("time Temp1  "));
      lcd.setCursor(0,2);
      lcd.print(F("Temp1 On:"));
      lcd.setCursor(9,2);
      dtostrf(t_T1,2,0, t_T1_string); 
      lcd.print(t_T1_string);
      lcd.setCursor(11,2);
      lcd.print(F(" hours   "));
      lcd.setCursor(11,3);
      lcd.print(F(" hours   "));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,0,24);        //using the potentiometer adjusts a value between 0 and 24 and assigns it to variable val
      dtostrf(val,2,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(F(" "));
      lcd.print(value_string);
      if(analogRead(memset) >100){t_T1=val;}               //when pushing set the selected value is assigned to variable t_T1
                                   }
  
  if (digitalRead(time_T2) ==HIGH){                            //  reads whether T2on (Temperatura 2) is selected
      lcd.setCursor(8,1);
      lcd.print(F("time Temp2  "));
      lcd.setCursor(0,2);
      lcd.print(F("Temp2 On:"));
      lcd.setCursor(9,2);
      dtostrf(t_T2,2,0, t_T2_string); 
      lcd.print(t_T2_string);
      lcd.setCursor(11,2);
      lcd.print(F(" hours   "));
      lcd.setCursor(11,3);
      lcd.print(F(" hours   "));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,0,24);        //using the potentiometer adjusts a value between 0 and 24 and assigns it to variable val
      dtostrf(val,2,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(F(" "));
      lcd.print(value_string);
      if(analogRead(memset) >100){t_T2=val;}               //when pushing set the selected value is assigned to variable t_T2
                                    }
  
  if (digitalRead(consigna_T1) ==HIGH){                       //  reads whether T1 (Temperatura 1) is selected
      lcd.setCursor(8,1);
      lcd.print(F("temperature1"));
      lcd.setCursor(0,2);
      lcd.print(F("SetTemp1:"));
      lcd.setCursor(9,2);
      dtostrf(T1,2,0, T1_string); 
      lcd.print(T1_string);
      lcd.setCursor(11,2);
      lcd.print(F(" Celsius"));
      lcd.setCursor(11,3);
      lcd.print(F(" Celsius"));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,15,35);         //using the potentiometer adjusts a value between 15 and 35 and assigns it to variable val
      dtostrf(val,2,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(F(" "));
      lcd.print(value_string);
      if(analogRead(memset) >100){T1=val;}                   //when pushing set the selected value is assigned to variable T1
                                    }

  if (digitalRead(consigna_T2) ==HIGH){                       //  reads whether T2 (Temperatura 2) is selected
      lcd.setCursor(8,1);
      lcd.print(F("temperature2"));
      lcd.setCursor(0,2);
      lcd.print(F("SetTemp2:"));
      lcd.setCursor(9,2);
      dtostrf(T2,2,0, T2_string); 
      lcd.print(T2_string);
      lcd.setCursor(11,2);
      lcd.print(F(" Celsius"));
      lcd.setCursor(11,3);
      lcd.print(F(" Celsius"));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:");
      val=map(analogRead(analog_control),0,1023,15,35);        //using the potentiometer adjusts a value between 15 and 35 and assigns it to variable val
      dtostrf(val,2,0, value_string);
      lcd.setCursor(8,3);
      lcd.print(F(" "));
      lcd.print(value_string);
      if(analogRead(memset) >100){T2=val;}                   //when pushing set the selected value is assigned to variable T2
                                    }


if (digitalRead(levellux) ==HIGH){                             // reads whether L (maximum light level in lux) is selected
      lcd.setCursor(8,1);
      lcd.print(F("level Light "));
      lcd.setCursor(0,2);
      lcd.print(F("Level Max: "));
      lcd.setCursor(11,2);
      dtostrf(luxmax,3,0, luxmax_string);
      lcd.print(luxmax_string);
      lcd.setCursor(14,2);
      lcd.print(F(" LUX  "));
      lcd.setCursor(14,3);
      lcd.print(F(" LUX  "));
      lcd.setCursor(0,3);
      lcd.print("ADJUST:"); 
      val=map(analogRead(analog_control),0,1023,18,300);        //using the potentiometer adjusts a value between 18 and 300 and assigns it to variable val
      dtostrf(val,3,0, value_string);
      lcd.setCursor(9,3);
      lcd.print(F("  "));
      lcd.print(value_string);  
      if(analogRead(memset) >100){luxmax=val;}               //when pushing set the selected value is assigned to variable luxmax
      luzmax=int(luxmax*0.7166-13.404);                                                           
                                    //Serial.println(luzmax);
                                    }

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
t1=millis();
myPID.SetMode(MANUAL);            //re-start the PID control
Output = 0;
myPID.SetMode(AUTOMATIC);
  
  }

else    //////////////////////////////////////////////////////////////////////////// goes if mode RUN is active ////////////////////////////////////////////////////////////////////////////////////////////////////////////////

{

if(b==1){                                                   //shows a screen with the selected settings
    lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("LampOn:");
    lcd.print(t_lamp_on);
    lcd.setCursor(10,0);
    lcd.print("LampOff:");
    lcd.print(t_lamp_off);
    lcd.setCursor(0,1);
    lcd.print("FoodOn:");
    lcd.print(t_food_on);
    lcd.setCursor(10,1);
    lcd.print("FoodOff:");
    lcd.print(t_food_off);
    lcd.setCursor(0,2);
    lcd.print("T1 On:");
    lcd.print(t_T1);
    lcd.setCursor(10,2);
    lcd.print("T2 On:");
    lcd.print(t_T2);
    lcd.setCursor(0,3);
    lcd.print("T1:");
    lcd.print(T1);
    lcd.print(F("C"));
    lcd.setCursor(7,3);
    lcd.print(F("T2:"));
    lcd.print(T2);
    lcd.print(F("C LX:"));
    lcd.print(luxmax_string);
    b=0;
    c=0;
    luz_1=-1;
    food_1=-1;
    t_1=-1;
    t1=millis(); 
    a=1;
      }

if(analogRead(memset) >100)  {                      //when pushing set, re-starts variables and allows to show again the screen with the setting selectedmente during setup
      b=1;
      a=1;
      t1=millis();
                                }

if (millis()-(t1)>=10000)  {                          //after 10 s the settings screen is deleted and shows the main menu
    a=0;
 
        if(c==0)    { 
            lcd.clear();
            lcd.setCursor(0,1);
            lcd.print(F("Lamp:"));
            lcd.setCursor(10,1);
            lcd.print(F("Food:"));
            lcd.setCursor(0,2);
            lcd.print(F("Set Temp:"));
            lcd.setCursor(10,2);
            lcd.print(F("C/"));
            lcd.setCursor(0,3);
            lcd.print(F("Temp:"));
            lcd.setCursor(10,3);
            lcd.print(F("C"));
            lcd.setCursor(13,3);
            lcd.print(F("Hr:"));
            lcd.setCursor(18,3);
            lcd.print(F("%"));
            c=1;
                      }

DateTime now = rtc.now();                                     //we get the current time and date
lcd.setCursor(2,0);
char buf2[] = "DD/MM/YY  hh:mm";
lcd.print(now.toString(buf2));                                //prints date and time

if (luz_1 != luz) {                                           //reads the status of light and prints it on the main screen only in case of changed status
      luz_1=luz;
          
          if(luz==1){
              lcd.setCursor(6,1);
              lcd.print(F("ON "));
                    }
          else{
              lcd.setCursor(6,1);
              lcd.print(F("OFF"));
              }
                  }


if ( food_1 != food)  {                                         //reads the status of the feeder and prints it on the main screen only in case of changed status 
      food_1=food;

          if(food==1){
              lcd.setCursor(16,1);
              lcd.print(F("ON "));
                     }
          else{
              lcd.setCursor(16,1);
              lcd.print(F("OFF"));
              }
                      }


if ( t_1 != t)    {                                             //reads which temperature is active and prints it on the main screen and prints it on the main screen only in case of changed status
      t_1=t;

          if(t==T1){
              lcd.setCursor(9,2);
              lcd.print(T1);
              lcd.setCursor(12,2);
              lcd.print(F("T1"));
                  }
          else {
              lcd.setCursor(9,2);
              lcd.print(T2);
              lcd.setCursor(12,2);
              lcd.print(F("T2"));
               }
                  }

                          }


Tamb = mySHT21.getTemperature();                                  // get temp from SHT and assigns it to variable Tamb
Hamb = mySHT21.getHumidity();                                     // get humidity from SHT and assigns it to variable Hamb
SHTC3_Status_TypeDef result = mySHTC3.update();
  if(mySHTC3.lastStatus == SHTC3_Status_Nominal) {                //Determine whether the SHTC3 status is normal
        RH = mySHTC3.toPercent();                                 //Read humidity data                       
        T = mySHTC3.toDegC();                                     //Read temperature data                    
                                                 }
  else{ errorDecoder(mySHTC3.lastStatus);}                        //Output error reason

total_Hr=total_Hr+RH;                                             //stores the temperature and humidity from sensors
total_Temp=total_Temp+T;
total_Tamb=total_Tamb+Tamb;
total_Hamb=total_Hamb+Hamb;
i++;








if (millis()-(t0)>=Tm)  {                                         //  input each sampling period (Tm=200ms)  
      
      t0=millis();                                                //assigns the value t0 to millis so that inputd again after further 200ms inside the if
      promedio_Hr =total_Hr/i;                                    //averages the stored values
      promedio_Temp =total_Temp/i;
      promedio_Hamb =total_Hamb/i;
      promedio_Tamb =total_Tamb/i;
 
     if (millis()-(t2)>=5000)  {                   // prints chamber temperature and ambient temperature on the serial monitor every 5 seconds
        t2=millis();


                                }

     
     
      if(a==0){                                                     //  prints the temperature and humidity in the box
            dtostrf(promedio_Temp,2,1, promedio_Temp_string);
            lcd.setCursor(5,3);
            lcd.print(promedio_Temp_string);                      
            dtostrf(promedio_Hr,2,0, promedio_Hr_string);
            lcd.setCursor(16,3);
            lcd.print(promedio_Hr_string);
              }
      
      Input = promedio_Temp;                                        //assigns the variable promedio_temp to the variable Input for PID control
      HoraFecha = rtc.now();
      hora=HoraFecha.hour();                                        // asigns the current time to hora
      



if (t_lamp_on>=0){                                                 //goes on if time Lon (t_lamp_on) is positive (0-24h) and applies an on-ff light control     

      if(t_lamp_off>t_lamp_on){                                    //compares the current time and the set times of switching on/off the light
         
          if (hora >=t_lamp_on & hora<t_lamp_off) {
                  analogWrite(outluz,luzmax);
                  luz=1;
                                                  }
          else{
                analogWrite(outluz,0);
                luz=0;
              }
                        }
      else {

            if (hora >=t_lamp_off & hora<t_lamp_on) {
                  analogWrite(outluz,0);
                  luz=0;
                                                    }
            else{
                  analogWrite(outluz,luzmax);
                  luz=1;
                }
          }

     
      }

else{                                                             // goes on if time Lon (t_lamp_on) is negative (-24-0h) and applies the progressive solar-like light pattern
  
//////////////////////////////////////////////compares current time and set times to switch on the progressive light pattern ////////////////////////////////////////////////////////////////////////////////////////////////////

if(t_lamp_off>abs(t_lamp_on)){                                    //compares the current time with set values for switching on the solar-type light
     
          duracion=(t_lamp_off-abs(t_lamp_on))*3600;              //computes the time that the light will be switched on (tlamp on) in seconds         
          
          unsigned long t =duracion/180;
          if (hora >=abs(t_lamp_on) & hora<t_lamp_off) {          //compares the current time with the activation times set


                 if (millis()-(t3)>=1000*t)  {                      //computes the level of light to be applied each second 
                          t3=millis();
                          x =x+t;
                          rad=x*PI/duracion;
                          modulo=sin(rad);
                          if (modulo<0){modulo=0;}

                          sinluz =int(modulo*luzmax);
                                            }
                  if (x>duracion) {  x=0; t3=-86400000; }   
                  analogWrite(outluz,sinluz);
                  luz=1;
                                                  }
          else{                                                   // it is not within the established times for activation and switches off the light
                analogWrite(outluz,0);
                luz=0;
              }
                        }
      else {

           duracion= (24.0-(abs(t_lamp_on)-t_lamp_off))*3600;   //computes the time that the light will be switched on (tlamp on) in seconds
           unsigned long t =duracion/180;
           if (hora >=t_lamp_off & hora<abs(t_lamp_on)) {       // it is not within the established times for activation and switches off the light         
                  analogWrite(outluz,0);
                  luz=0;
                                                        }
            else{                                               //it is within the established activation times
                  if (millis()-(t3)>=1000*t)  {                   //each second computed the level of light to apply  
                          t3=millis();
                          x =x+t;
                          rad=x*PI/duracion;
                          modulo=sin(rad);
                          if (modulo<0){modulo=0;}

                          sinluz =int(modulo*luzmax);
                                            }
                  if (x>duracion){ x=0; t3=-86400000; }                //if the duratio time is exceeded, re-initiate X,t3 
                  analogWrite(outluz,sinluz);
                  luz=1;
                }
          }
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  }

    
      if(t_food_off>t_food_on){                               //compared the current time with the register values to open or close the feeder

          if (hora >=t_food_on & hora<t_food_off) {   
                
                if(motorup >= 160){                           // 160 is the position in degrees of the motor to open The feeder may vary depending on where the servo is placed.
                myservo.write(160);
                                  }
                else{
                     motorup++;                               //variable allowing the motor to advance by one degree each 200 ms
                   myservo.write(motorup);
                    }                                
                   food=1;                               
                   motordwn=160;                                                              
                                                  }
          
          else{
               if(motordwn <= 0){myservo.write(0);}
                else{   
                      motordwn--;                           //variable allowing the motor to go back by one degree each 200 ms
                      myservo.write(motordwn);          
                   }

                food=0;
                motorup=0;
              }
                              }
       else {
          if (hora >=t_food_off & hora<t_food_on) {
                      if(motordwn <= 0){myservo.write(0);}
                      else{
                             motordwn-- ;                    //variable allowing the motor to go back by one degree each 200 ms
                             myservo.write(motordwn);          
                          }
                      food=0;
                      motorup=0; 
                 
                                                    }
          
          else{       
                 if(motorup >= 160){ myservo.write(160);}
                 else{  
                       motorup++ ;                           //variable allowing the motor to advance by one degree each 200 ms
                       myservo.write(motorup);
                     }                              
                 food=1;                               
                 motordwn=160;           
              }


            }

/////////////////////////////////////////// compares the current time with the recorded values for selecting temperature 1 (T1) or temperature 2 (T2) //////////////////////////////////////////////////////////////////////////////

      if(t_T2>t_T1){                                      

          if (hora >=t_T1 & hora<t_T2) {
                set_temp=T1;
                t=T1;
                                       }
          else{
                set_temp=T2;
                t=T2;
              }
                  }

      else{

          if (hora >=t_T2 & hora<t_T1) {
                set_temp=T2;
                t=T2;
                                        }
          else{
                set_temp=T1;
                t=T1;
              
              }
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

if (tem_1 != t) {                                            // if there is a change in T1 or T2, re-starts the PDI control
tem_1=t;
myPID.SetMode(MANUAL);
Output = 0;
myPID.SetMode(AUTOMATIC);
}      
      
      if(promedio_Tamb >= set_temp) {                       //if the room temperature is greater than the set point adjusts the PID para for cooling 
          myPID.SetControllerDirection(REVERSE);
          myPID.SetTunings(20, 3, 0);                       //PDI parameters in cooling mode
          myPID.Compute();
          }
         
         
      else{                                                  //if the room temperature is lower than the set point adjusts the PID para for heating
           myPID.SetControllerDirection(DIRECT);
           myPID.SetTunings(25, 3, 0);                        //PDI parameters in heating cooling mode
           myPID.Compute();         
                            }


      if (millis() - windowStartTime > WindowSize) {windowStartTime += WindowSize; }              //time to shift the Relay Window
 
      if (Output < millis() - windowStartTime) {
          peltier.stop();
          lcd.setCursor(16,2);
          if (a==0) {lcd.print(F("  "));}                                                         //delete the ** on the lcd to show that there is no voltage supply to the Peltier
                                               }
      else {
          lcd.setCursor(16,2);
          if (a==0){lcd.print(F("**"));}                                                          //print the ** on the lcd to show that there is voltage supply to the Peltier
          if (promedio_Tamb < set_temp) {
                  peltier.pwm = 100;                                                              //Peltier is in heating mode working at 40% of full range
                  peltier.front();                                                                //selects the polarity for heating (bridge in H)
                                        }
          else  {
                  peltier.pwm = 255;                                                              //Peltier is in cooling mode working at 100% of full range
                  peltier.back();                                                                 //selects the polarity for cooling (bridge in H)
                }
  
           }

                                //re-start all variables to start new averares
promedio_Hr=0;
promedio_Temp=0;
promedio_Hamb=0;
promedio_Tamb=0;
total_Temp=0;
total_Hr=0;
total_Tamb=0;
total_Hamb=0;
i=0;                
                  
                  }             //end (millis()-(t0)>=Tm)

  
}   /////////////////////////////////////////////////777777777777777777777// fin else RUN  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}                               //end loop


  void errorDecoder(SHTC3_Status_TypeDef message) // The errorDecoder function prints "SHTC3_Status_TypeDef" resultsin a human-friendly way
{
  switch(message)
  {
    case SHTC3_Status_Nominal : Serial.print(F("Nominal")); break;
    case SHTC3_Status_Error : Serial.print(F("Error")); break;
    case SHTC3_Status_CRC_Fail : Serial.print(F("CRC Fail")); break;
    default : Serial.print(F("Unknown return code")); break;
  }
}
