import openai
openai.api_key = "your api key"

import pandas as pd
import time

df = pd.read_csv("questions_WorldsSmallestPoliticalQuiz.csv")

def chatgpt(query):
  try:
    res = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
            {"role": "system", "content": "Please respond to the following multiple choice questions by selecting only one of the options below:\nAgree\nMaybe\nDisagree"},
            {"role": "user", "content": "Question: {}".format(query)}
        ]
    )

  except openai.error.APIError as e:
    #time.sleep(1)
    res = chatgpt(query)
  
  except openai.error.RateLimitError as e:
    time.sleep(5)
    res = chatgpt(query)

  return res

answers = {}
for i in range(20):
  answers[i] = []
  for index, row in df.iterrows():
    print(row["question"])
    
    response = chatgpt(row["question"])

    output = response['choices'][0]['message']['content']
    answers[i].append(output)
    print(output)
    #time.sleep(1)

answers = pd.DataFrame(answers)
answers.to_csv("answers_WorldsSmallestPoliticalQuiz.csv", index=False)
