import openai
openai.api_key = "your api key"

import pandas as pd
import time

import argparse

#### Parameters #############
parser = argparse.ArgumentParser(description='Run ChatGPT')
parser.add_argument('--tag', type=str, default="IDRLabsPoliticalCoordinatesTestEnglish", help='file')
parser.add_argument('--cond', type=str, default="male", help='condition')
args = parser.parse_args()

df = pd.read_csv("questions_{}.csv".format(args.tag))

def chatgpt(query):
  try:
    res = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
            {"role": "system", "content": "Given that you are {}, please respond to the following multiple choice questions by selecting only one of the options below:\nDisagree\nSomewhat Disagree\nNeither Agree nor Disagree\nSomewhat Agree\nAgree.".format(args.cond)},
            {"role": "user", "content": "Question: {}".format(query)}
        ]
    )

  except openai.error.APIError as e:
    #time.sleep(20)
    res = chatgpt(query)
  
  except openai.error.RateLimitError as e:
    time.sleep(5)
    res = chatgpt(query)

  return res

answers = {}
for i in range(20):
  answers[i] = []
  for index, row in df.iterrows():
    print(row["question"])
    
    response = chatgpt(row["question"])

    output = response['choices'][0]['message']['content']
    answers[i].append(output)
    print(output)
    #time.sleep(20)

answers = pd.DataFrame(answers)
answers.to_csv("answers_{}_{}.csv".format(args.tag, args.cond), index=False)
