import openai
openai.api_key = "your api key"

import pandas as pd
import time

import argparse

#### Parameters #############
parser = argparse.ArgumentParser(description='Run ChatGPT')
parser.add_argument('--tag', type=str, default="IDRLabsPoliticalCoordinatesTestJapanese", help='file')
args = parser.parse_args()

df = pd.read_csv("questions_{}.csv".format(args.tag))

def chatgpt(query):
  try:
    res = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
            # None
            {"role": "system", "content": "多肢選択式の質問に答えてください。質問には次の選択肢からひとつだけを選択して回答してください: 反対、やや反対、どちらでもない、やや賛成、賛成。"},
            # Male
            #{"role": "system", "content": "男性の立場で、多肢選択式の質問に答えてください。質問には次の選択肢からひとつだけを選択して回答してください: 反対、やや反対、どちらでもない、やや賛成、賛成。"},
            # Female
            #{"role": "system", "content": "女性の立場で、多肢選択式の質問に答えてください。質問には次の選択肢からひとつだけを選択して回答してください: 反対、やや反対、どちらでもない、やや賛成、賛成。"},
            # White
            #{"role": "system", "content": "白人の立場で、多肢選択式の質問に答えてください。質問には次の選択肢からひとつだけを選択して回答してください: 反対、やや反対、どちらでもない、やや賛成、賛成。"},
            # Black
            #{"role": "system", "content": "黒人の立場で、多肢選択式の質問に答えてください。質問には次の選択肢からひとつだけを選択して回答してください: 反対、やや反対、どちらでもない、やや賛成、賛成。"},
            # Asian
            #{"role": "system", "content": "アジア人の立場で、多肢選択式の質問に答えてください。質問には次の選択肢からひとつだけを選択して回答してください: 反対、やや反対、どちらでもない、やや賛成、賛成。"},
            {"role": "user", "content": "質問: {}".format(query)},
        ]
    )

  except openai.error.APIError as e:
    #time.sleep(1)
    res = chatgpt(query)
  
  except openai.error.RateLimitError as e:
    time.sleep(5)
    res = chatgpt(query)

  return res

answers = {}
for i in range(20):
  answers[i] = []
  for index, row in df.iterrows():
    print(row["question"])
    
    response = chatgpt(row["question"])

    output = response['choices'][0]['message']['content']
    answers[i].append(output)
    print(output)
    #time.sleep(1)

answers = pd.DataFrame(answers)
answers.to_csv("answers_{}_asian.csv".format(args.tag), index=False)
