function [X,Y,u,lm] = complex_diffusion(L,N,D,alpha,beta,A,t)
[kx,ky] = meshgrid((1:N)*pi/L);                    % 2D wavenumbers
lm = kx.^2+ky.^2;                              % Standard Laplacian
lm = lm.^(alpha/2).*(1+A*sin(beta/2*log(lm)));        % Eigenvalues
dx = L/(N+1); mp = (N-1)/2+1;            % Domain mid-point (N odd)
us = zeros(N); us(mp,mp) = 1/(dx*dx);           % Initial condition
us = idst2(exp(-D*lm*t).*dst2(us));             % Spectral solution
[X,Y] = meshgrid([0 (1:N)*dx L]);            % Mesh (with boundary)
u = zeros(N+2); u(2:end-1,2:end-1) = us;        % Solution (padded)
