sireProportion <- function(pafCalves,pafDams,gSires) {

  require(quadprog)

# Arguments:
# pafCalves = B allele frequency for calves; Values range from 0 to 1.
#             Is a vector with one element per SNP.
# gSires = Copies of B allele for sires divided by 2.  
#          Values are 0, 0.5 and 1.0. There is a row for each SNP and a 
#          column for each sire
# pafDams = B allele frequency for dams. Values range from 0 to 1.
#           Is a vector with one element per SNP.

#First, estimate sire contributions without adjusting for dam pooling
#allele frequency

  x <- gSires
  y <- pafCalves

  xpx <- t(x) %*% x
  ypx <- as.vector(t(y) %*% x)
  nSires <- ncol(gSires)
  A <- cbind(1,diag(nSires))
  b0 <- c(0.5,rep(0,nSires))                            
  fm <- solve.QP(Dmat=2*xpx,dvec=2*ypx,Amat=A,bvec=b0,meq=1)
  b <- fm$solution #Sire contributions sum to 0.5 and are 
                   #greater than or equal to 0
   
#Second, estimate sire contributions while adjusting for dam pooling
# allele frequency.  Reuse x, y and fm.

  x <- cbind(gSires,pafDams)
  xpx <- t(x) %*% x
  ypx <- as.vector(t(y) %*% x)
  A <- rbind(cbind(1,0,diag(nSires)),0)
  A[nsires+1,2] <- 1
  b0 <- c(rep(0.5,2),rep(0,nsires))
  fm <- solve.QP(Dmat=2*xpx,dvec=2*ypx,Amat=A,bvec=b0,meq=2)

  bDam <- fm$solution
  bDam <- bDam[-length(bDam)]

  #Returns sire proportions without adjusting for dam B allele frequency
  #and adjusting for dam B allele frequency

  return(list(NotAdjusted4Dam=b,Adjusted4Dam=bDam))
}