<?php
/*
	Simulates isotope decay using variable half-life.
	Returns real age and age calculated with the assumption of constant decay rate (UNCOMPRESSED AGE).

	t_hf = half-life of parent isotope
	lambda = ln(2) / t_hf = decay constant of parent isotope
	P = number of atoms of parent isotope at time of measurement
	D = number of atoms of daughter product at time of measurement
	t = age of the rock or mineral specimen
*/

define('FIXED_HALF_LIFE', 1.512 * pow(10, 6));		// Be-10 half-life (1987)
define('HALF_LIFE_CO2', 341.83707500861);			// CO2 (ppm) when half-life was equal to FIXED_HALF_LIFE

//define('REAL_AGE_TARGET', 66+215*365.25);			// Use when looking for uncompressed age of specific real age (days)
define('REAL_AGE_MAXIMUM', 234*365.25);
define('UNCOMPRESSED_AGE_TARGET', 1000000);			// Use when looking for real age of specific uncompressed age (years)

$C = 300;
$begin = 1905;
$step = 55; // years

$real_age_maximum = (defined('REAL_AGE_TARGET')?REAL_AGE_TARGET:REAL_AGE_MAXIMUM);

$D = 0; $P_START = 1000000;							// P_START = initial number of atoms of parent isotope
for ($j=1, $P=$P_START; $j<=$real_age_maximum; $j++) {
	$i = $j / 365.25;
	$year = 1850 + $i;
	$x = ($year - $begin) / (10 * $step);
	$y = $C * pow(1.2*pow(2,$x*5*$x*9), $x);		// CO2
	
	$pre_hf = 2 * FIXED_HALF_LIFE - (FIXED_HALF_LIFE / HALF_LIFE_CO2) * $y;
	if ($pre_hf <= 0) break;
	$t_hf = $pre_hf;
	//if ($j % 365.25 == 0) echo $year.': '.$t_hf.PHP_EOL;
	$lambda = log(2) / $t_hf;						// log(2) = log(2, M_E) = ln(2)
	$t = $i;
	$D = floor($P * (pow(M_E, $t * $lambda) - 1));
	$P = $P_START - $D;

	$lambda = log(2) / FIXED_HALF_LIFE;
	$t = (1 / $lambda) * log(1 + $D / $P);
	if (defined('UNCOMPRESSED_AGE_TARGET') && $t >= UNCOMPRESSED_AGE_TARGET) break;
}

echo $year.': '.$t_hf.PHP_EOL;

echo "P = $P, D = $D, REAL AGE = $i, UNCOMPRESSED AGE = $t".PHP_EOL;
