function tree = mlf_train_new (X,L,MaxBoxSize)
% create boxes of mlf
% with out considering compenstory area

nbox = 0 ;
nsamples = size(X,1)  ;
nfeatures = size(X,2) ;
gama = 1/4; %MaxBoxSize coefficient for next layer;

%%%%%%%%%%%%%%%%%%%%%%%%%%% HBS construction %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for ks = 1: nsamples
    inside = 0 ;
    for n =1:nbox
        if h_boxes(n).class == L(ks)
            testMin = X(ks,:) >= h_boxes(n).mins  ;
            testMax = X(ks,:) <= h_boxes(n).maxs  ;
            inside = nfeatures  == sum(uint8(testMin & testMax))  ;
            if inside == 1
                %No further training !
               
                %h_boxes(n).samCount = h_boxes(n).samCount + 1;
                %h_boxes(n).samples(h_boxes(n).samCount) = X(ks,:) ;
                break  ;
            end
        end
    end
    % box inside_search terminated
    
    % init extention_search:
    if inside == 0
        selectedBox = -1 ;
        for n =1:nbox
            if h_boxes(n).class == L(ks)
                candMin  = min ( X(ks,:) ,h_boxes(n).mins ) ;
                candMax  = max ( X(ks,:) ,h_boxes(n).maxs ) ;
                candVol  = candMax - candMin ;
                if max(candVol) <= MaxBoxSize
                    %best box found, now extend it:
                    selectedBox = n ;
                    h_boxes (selectedBox).mins = candMin ;
                    h_boxes (selectedBox).maxs = candMax ;
                    %h_boxes (selectedBox).samCount = h_boxes(n).samCount + 1;
                    %h_boxes (selectedBox).samples(h_boxes(n).samCount) = X(ks,:) ;
                    break ;
                end
            end
        end
        %best box not found, creat a new box:
        if selectedBox == -1
            nbox = nbox + 1 ;
            selectedBox = nbox ;
            h_boxes (nbox).class = L(ks) ;
            h_boxes (nbox).mins = X(ks,:) ;
            h_boxes (nbox).maxs  = X(ks,:) ;
            %h_boxes (nbox).samCount = 1;
            %h_boxes (nbox).samples(1) = X(ks,:);
        end
        
        %contraction:
        %for n =1:nbox
        %   bo = overlapcontract(h_boxes(selectedBox),h_boxes(n));
        %   h_boxes(selectedBox)= bo(1);
        %   h_boxes(n) = bo(2);
        %   plot_boxes(X,L,h_boxes);
        %end
    end
   % plot_boxes(X,L,h_boxes);
end
tree.hboxes = h_boxes;

%%%%%%%%%%%%%%%%%%%%%%%%%%% OLS construction %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ol_boxes = [];
s_Nets = cell(0);
child = cell(0);
nob = 0;
for n = 1 : nbox
    for m = n+1 : nbox
        %cheching having overlap
        maxofmins = max(h_boxes(n).mins,h_boxes(m).mins);
        minofmaxs = min(h_boxes(n).maxs,h_boxes(m).maxs);
        no_overlap = sum(minofmaxs > maxofmins);
        if(no_overlap ~= 0 && h_boxes(n).class ~= h_boxes(m).class )% if having ovelap
            %constract new network with samples that exeist in this overlap area
            ol_v = maxofmins;
            ol_w = minofmaxs;
            smp_counter = 0;
            sod = -1;
            for i = 1 : nsamples
                % sum of dimension which are not in OL area;
                sod = sum(ol_v > X(i,:)) +sum(ol_w < X(i,:)) ;
                if(sod == 0)
                    smp_counter = smp_counter + 1;
                    x(smp_counter,:) = X(i,:);
                    l(smp_counter,1) = L(i);
                end
            end
            if(smp_counter > 0)
                new_olb.mins = ol_v;
                new_olb.maxs = ol_w;
                child = mlf_train_new(x,l,MaxBoxSize*gama);
                nob = nob + child.nob;
                s_Nets = cat(2,s_Nets,child);
                ol_boxes = cat(2,ol_boxes,new_olb);
                
                l=[];
                x=[];
            end
        end
    end
end
tree.olboxes = ol_boxes;
tree.s_nets = s_Nets;

tree.nob = size(h_boxes,2) + size(ol_boxes,2) + nob;
end





