# Overview

This folder contains automatically generated plots for the different analyses
presented in the publication. Not all coordinates or muscles could be presented
in the manuscript. Therefore, we included these as supplementary materials.

- `supplementary_filtering.pdf`: presents a comparison of the proposed and
  spatial filters with respect to OpenSim's kinematics analysis (ground truth)
  for all model coordinates.
- `supplementary_inverse_kinematics.pdf`: a validity check that the inverse
  kinematics module performs identically to the OpenSim's implementation.
- `supplementary_inverse_dynamics.pdf`: presents a comparison of generalized
  forces of the real-time method using the proposed or the spatial filter and
  the offline OpenSim inverse dynamics module.
- `supplementary_muscle_optimization.pdf`: presents the comparison of muscle
  forces for the real-time muscle optimization and OpenSim's offline static
  optimization.
- `supplementary_joint_reactions.pdf`: presents the comparison of joint reaction
  loads between the real-time method (uses muscle forces obtained from the
  real-time optimization) and the OpenSim's joint reaction analysis.
- `real_time_framework_video.webm`: a demo video.


SimTK: https://simtk.org/projects/real_time

GitHub: https://github.com/mitkof6/OpenSimRT

