function [Overal_Function]=Obj_Fun(x)

rbf=evalin('base','rbf');
Beta=evalin('base','Beta');
NTrans=evalin('base','NTrans');
% cmax = 0.4355;
dmax = 313.9555;
UC=(Beta*(dmax/NTrans)); % Upper limit to check feasibility of constraint (allow distances between transmitters)

%% Decision (design) Variables
switch NTrans
    
    case 2
        
        X1 = x(1,1);
        Y1 = x(1,2);
        X2 = x(1,3);
        Y2 = x(1,4);    
        F1=rbf([X1,Y1]'); 
        F2=rbf([X2,Y2]');
        D12=sqrt(((X1-X2)^2)+((Y1-Y2)^2));        
        if D12>=UC;
            Overal_Function=(F1+F2);
        else
            Overal_Function=0;  
        end   
        
    case 3
        
        X1 = x(1,1);
        Y1 = x(1,2);
        X2 = x(1,3);
        Y2 = x(1,4);
        X3 = x(1,5);
        Y3 = x(1,6);
        F1=rbf([X1,Y1]'); 
        F2=rbf([X2,Y2]'); 
        F3=rbf([X3,Y3]'); 
        D12=sqrt(((X1-X2)^2)+((Y1-Y2)^2));
        D13=sqrt(((X1-X3)^2)+((Y1-Y3)^2));
        D23=sqrt(((X2-X3)^2)+((Y2-Y3)^2)); 
        if (D12>=UC)&&(D13>=UC)&&(D23>=UC);
            Overal_Function=(F1+F2+F3);
        else
            Overal_Function=0;  
        end  
                
    case 4
        
        X1 = x(1,1);
        Y1 = x(1,2);
        X2 = x(1,3);
        Y2 = x(1,4);
        X3 = x(1,5);
        Y3 = x(1,6);
        X4 = x(1,7);
        Y4 = x(1,8);
        F1=rbf([X1,Y1]');
        F2=rbf([X2,Y2]');
        F3=rbf([X3,Y3]');
        F4=rbf([X4,Y4]');
        D12=sqrt(((X1-X2)^2)+((Y1-Y2)^2));
        D13=sqrt(((X1-X3)^2)+((Y1-Y3)^2));
        D14=sqrt(((X1-X4)^2)+((Y1-Y4)^2));
        D23=sqrt(((X2-X3)^2)+((Y2-Y3)^2));
        D24=sqrt(((X2-X4)^2)+((Y2-Y4)^2));
        D34=sqrt(((X3-X4)^2)+((Y3-Y4)^2));
        if (D12>=UC)&&(D13>=UC)&&(D14>=UC)&&(D23>=UC)&&(D24>=UC)&&(D34>=UC);
            Overal_Function=(F1+F2+F3+F4);
        else
            Overal_Function=0;  
        end  

    case 5
        
        X1 = x(1,1);
        Y1 = x(1,2);
        X2 = x(1,3);
        Y2 = x(1,4);
        X3 = x(1,5);
        Y3 = x(1,6);
        X4 = x(1,7);
        Y4 = x(1,8);
        X5 = x(1,9);
        Y5 = x(1,10);
        F1=rbf([X1,Y1]'); 
        F2=rbf([X2,Y2]');
        F3=rbf([X3,Y3]');
        F4=rbf([X4,Y4]');
        F5=rbf([X5,Y5]');
        D12=sqrt(((X1-X2)^2)+((Y1-Y2)^2));
        D13=sqrt(((X1-X3)^2)+((Y1-Y3)^2));
        D14=sqrt(((X1-X4)^2)+((Y1-Y4)^2));
        D15=sqrt(((X1-X5)^2)+((Y1-Y5)^2));
        D23=sqrt(((X2-X3)^2)+((Y2-Y3)^2));
        D24=sqrt(((X2-X4)^2)+((Y2-Y4)^2));
        D25=sqrt(((X2-X5)^2)+((Y2-Y5)^2));
        D34=sqrt(((X3-X4)^2)+((Y3-Y4)^2));
        D35=sqrt(((X3-X5)^2)+((Y3-Y5)^2));
        D45=sqrt(((X4-X5)^2)+((Y4-Y5)^2));
        if (D12>=UC)&&(D13>=UC)&&(D14>=UC)&&(D15>=UC)&&(D23>=UC)&&(D24>=UC)&&(D25>=UC)&&(D34>=UC)&&(D35>=UC)&&(D45>=UC);
            Overal_Function=(F1+F2+F3+F4+F5);
        else
            Overal_Function=0;  
        end 
        
    otherwise
        disp ('PLZ enetr the number of transmitters correctly')   
end

end 

