
clc

Beta    = input('How much is Beta value?--');
NTrans  = input('How many transmitters are in the model?--');


assignin('base','Beta',Beta);
assignin('base','NTrans',NTrans);
%% RBF construction
% rbf=newrbe(In',Out');
% assignin('base','rbf',rbf);
%% Optimization's parameters
% Particle Swarm Optimization with Inertial Weight Adjustment.
% Inertia_weight=At the beginning of the search procedure, diversification is heavily weighted, while intensification is heavily weighted at the end of the search procedure.
% The design range
switch NTrans
    case 2
        MinMaxRange=[0 222;0 222;0 222;0 222]; 
    case 3
        MinMaxRange=[0 222;0 222;0 222;0 222;0 222;0 222]; 
    case 4
        MinMaxRange=[0 222;0 222;0 222;0 222;0 222;0 222;0 222;0 222];         
    case 5
        MinMaxRange=[0 222;0 222;0 222;0 222;0 222;0 222;0 222;0 222;0 222;0 222];     
    otherwise
        disp ('PLZ enetr the number of transmitters correctly')   
end

nVar = NTrans*2;
Inpop=50;
Maxiter=200;
WImin=0.4;         % Min_Inertia_weight=min of inertia weight (normally 0.4)
WImax=0.9;        % Max_Inertia_weight=max of inertia weight (normally 0.9)
VelCla = 2;   % Velocity clamping factor
ConCon = 2;       % Congitive Conststant (c1)
SocCon = 2;       %Social Constant (c2)      ==> c1+c2 >=4

[OptVar]= Particle_Swarm_Optimization(Inpop,nVar,MinMaxRange,@Obj_Fun,'max',VelCla,ConCon,SocCon,WImin,WImax,Maxiter);

% Close Script Commands
res = 25000;len = 0.5 * res;hz = 280;sound( cos( hz*(5*pi*(0:len)/res) ), res);
Optimal_Result = [OptVar]; 
clearvars -except Optimal_Result rbf
