(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[  12375001,     213230]
NotebookOptionsPosition[  12310969,     212161]
NotebookOutlinePosition[  12311526,     212182]
CellTagsIndexPosition[  12311483,     212179]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Calculations for Two Nested Limit Cycles in Two-Species Reactions with \
Wolfram Mathematica\
\>", "Title",
 CellChangeTimes->{{3.7754641812121987`*^9, 3.7754642012906675`*^9}, {
  3.805626211464999*^9, 
  3.8056262334497204`*^9}},ExpressionUUID->"2b84d0df-31d1-47b1-8ec6-\
ef16cbb492ae"],

Cell["\<\
Created by Ilona Nagy, Valery Romanovski and J\[AAcute]nos T\[OAcute]th
Last modified: 24 August, 2020\
\>", "Text",
 CellChangeTimes->{{3.7754642190096283`*^9, 3.775464230947347*^9}, {
   3.805283920201375*^9, 3.805283932717166*^9}, 3.805626535965827*^9, 
   3.805699030814085*^9, {3.806654356346588*^9, 3.806654356565341*^9}, {
   3.8072459498419237`*^9, 
   3.80724595042006*^9}},ExpressionUUID->"fb756725-784a-4f40-ad4c-\
f340c51defe2"],

Cell[CellGroupData[{

Cell["\<\
Model 1  with a stable outer and an unstable inner limit cycle\
\>", "Chapter",
 CellChangeTimes->{{3.8056262475592823`*^9, 3.805626249403057*^9}, {
  3.8056426127685385`*^9, 
  3.8056426223311276`*^9}},ExpressionUUID->"d690ad15-982a-42c7-83ca-\
146ea1e94ba8"],

Cell[CellGroupData[{

Cell["Preparations", "Section",
 CellChangeTimes->{{3.8056262902629747`*^9, 
  3.805626297372444*^9}},ExpressionUUID->"99706d34-a1cf-4492-8d17-\
e2ed4376a31f"],

Cell[CellGroupData[{

Cell["System (3)", "Subsection",
 CellChangeTimes->{{3.8052841864236603`*^9, 3.805284194845647*^9}, {
  3.8052843714104924`*^9, 
  3.8052843736292725`*^9}},ExpressionUUID->"95d69c39-79ae-48a9-9980-\
1f1d25e829cb"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"x", "'"}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"d1", " ", "x"}], "+", 
    RowBox[{"e1", " ", "y"}], "+", "f1"}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"y", "'"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "y"}], "-", 
     RowBox[{"x", " ", "y"}], "+", 
     RowBox[{"c1", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"d2", " ", "x"}], "-", 
     RowBox[{"e2", " ", "y"}], "+", "f2"}]}], "\[IndentingNewLine]"}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"c1", ",", "d1", ",", "d2", ",", "e1", ",", "e2", ",", "f1", ",", 
   RowBox[{"f2", "\[GreaterEqual]", "0"}]}], 
  TraditionalForm]}],ExpressionUUID->"bd200e1c-7ce7-44cc-8f98-e83472e0af7b"]],\
 "Text",
 CellChangeTimes->{
  3.775464131514166*^9, {3.804868157411567*^9, 
   3.8048681842869225`*^9}},ExpressionUUID->"bcb25a3e-3a24-4618-aca2-\
b1a1087e053d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The ReactionKinetics program package", "Subsection",
 CellChangeTimes->{{3.8044976339227715`*^9, 3.8044976384818983`*^9}, {
  3.805626308834866*^9, 3.8056263396165247`*^9}, {3.807245986696969*^9, 
  3.8072459871813507`*^9}},ExpressionUUID->"10530f5c-1200-4a6d-93a2-\
ae17ebc8f35d"],

Cell["\<\
The ReactionKinetics program package is available at \
http://extras.springer.com (ISBN: 978-1-4939-8643-9).
It can be used if either ReactionKinetics.m is put in the same folder as this \
notebook or ReactionKinetics.wl is added in the packages in the applications.\
\>", "Text",
 CellChangeTimes->{{3.8056856180942464`*^9, 3.805685709517392*^9}, {
  3.8072459015444355`*^9, 
  3.807245914778954*^9}},ExpressionUUID->"a8aad386-db67-4fc9-899c-\
456e2b0bb633"],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.8056266269016128`*^9, 3.8056266276203737`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"62c1b44e-0fae-495e-8e3f-4c1688642af6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"#", ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "Automatic", "]"}]}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "ContourPlot", ",", "DateListPlot", ",", "Plot", ",", "ListLinePlot", ",",
      "ListPlot", ",", "ListLogPlot", ",", "LogLinearPlot", ",", "LogPlot", 
     ",", "ParametricPlot", ",", "Plot3D", ",", "RegionPlot"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LaunchKernels", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Needs", "[", "\"\<ReactionKinetics`\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.7096113381654005`*^9, 3.709611352884179*^9}, {
   3.7096131714313145`*^9, 3.709613178073697*^9}, 3.709614117048169*^9, 
   3.709614151673237*^9, {3.709870614208662*^9, 3.709870633739951*^9}, {
   3.7098757014626827`*^9, 3.7098757053839064`*^9}, {3.7105100271712503`*^9, 
   3.7105100337493863`*^9}, {3.7105725823472457`*^9, 
   3.7105726092222986`*^9}, {3.7105745595183525`*^9, 3.710574564424613*^9}, {
   3.7109077434521756`*^9, 3.7109077495125213`*^9}, {3.7284719908149543`*^9, 
   3.728472050315071*^9}, {3.730003212672229*^9, 3.730003222062872*^9}, {
   3.7301179952225857`*^9, 3.7301180159882536`*^9}, {3.73011808287901*^9, 
   3.7301180833946342`*^9}, 3.7301862686686907`*^9, 3.802531457269861*^9, {
   3.8044961901324277`*^9, 3.8044961910490217`*^9}, {3.8044978975718856`*^9, 
   3.804497898783645*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"40f7467f-5a3c-4dac-b50e-c4f76aa826fb"],

Cell[BoxData[
 TemplateBox[{
  "LaunchKernels", "nodef", 
   "\"Some subkernels are already running. Not launching default kernels \
again.\"", 2, 7, 1, 20772232881047506714, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8056988190359683`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"7c3802eb-5b8e-456f-a9dc-8bf7e9d802f1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Figure 1: Creating the reaction graph with the help of the ReactionKinetics \
package\
\>", "Subsection",
 CellChangeTimes->{{3.8048682454283605`*^9, 3.804868285350765*^9}, {
  3.805284490537077*^9, 
  3.8052845120217376`*^9}},ExpressionUUID->"b3f3f227-7f49-46fd-b57b-\
85fb9618d7ed"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "model1", "]"}], ";", 
  RowBox[{"model1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "X"}], "+", "Y"}], "\[Rule]", 
      RowBox[{"3", "X"}]}], ",", 
     RowBox[{"X", "\[Rule]", "0"}], ",", 
     RowBox[{
      RowBox[{"2", "X"}], "\[Rule]", 
      RowBox[{
       RowBox[{"X", "+", "Y"}], "\[Rule]", 
       RowBox[{"2", "X"}]}]}], ",", 
     RowBox[{"0", "\[Rule]", 
      RowBox[{"X", "\[Rule]", 
       RowBox[{"X", "+", "Y"}]}]}], ",", 
     RowBox[{"0", "\[Rule]", 
      RowBox[{"Y", "\[Rule]", 
       RowBox[{"X", "+", "Y"}]}]}], ",", 
     RowBox[{"Y", "\[Rule]", " ", "0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"RightHandSide", "[", 
  RowBox[{
   RowBox[{"{", "model1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "d1", ",", "c1", ",", "1", ",", "f1", ",", "d2", ",", "f2", ",",
      "e1", ",", "e2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"model1fig", "=", 
  RowBox[{"ShowFHJGraph", "[", 
   RowBox[{"model1", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      SubscriptBox["d", "1"], ",", 
      SubscriptBox["c", "1"], ",", "1", ",", 
      SubscriptBox["f", "1"], ",", 
      SubscriptBox["d", "2"], ",", 
      SubscriptBox["f", "2"], ",", 
      SubscriptBox["e", "1"], ",", 
      SubscriptBox["e", "2"]}], "}"}], ",", 
    RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", " ", 
    "\[IndentingNewLine]", " ", 
    RowBox[{"VertexLabels", "->", "Automatic"}], ",", " ", 
    RowBox[{"EdgeLabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Italic", ",", "16"}], "]"}]}], ",", 
    RowBox[{"VertexLabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Blue", ",", "16"}], "]"}]}], ",", 
    RowBox[{"GraphLayout", "->", "\"\<TutteEmbedding\>\""}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.8043233675495124`*^9, 3.804323456864064*^9}, {
   3.8043235197721186`*^9, 3.8043235496715126`*^9}, {3.804323732943586*^9, 
   3.804323742925371*^9}, {3.804326410195191*^9, 3.8043264304587593`*^9}, {
   3.804333527745142*^9, 3.804333528675456*^9}, {3.80433364760139*^9, 
   3.8043336496746244`*^9}, 3.8044977886315355`*^9, {3.8048683174918175`*^9, 
   3.8048683176636953`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"6c990a33-513f-49eb-9f54-d3998d6cd669"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f1", "-", 
    RowBox[{"d1", " ", "x"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"e1", " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}]}], ",", 
   RowBox[{"f2", "+", 
    RowBox[{"d2", " ", "x"}], "+", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"e2", " ", "y"}], "-", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.8048683185074043`*^9, 3.8048684594473457`*^9, 
  3.8049233655675364`*^9, 3.80564313910291*^9, 3.805643824875045*^9, 
  3.805685026260908*^9, 3.8056862944942665`*^9, 3.805698822561142*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"688fb97d-802e-45ed-ab93-867d921a9f45"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
    Medium], {
     ArrowBox[{{0.29445562668532843`, -2.6923838744309334`}, {
      1.2944556266853284`, -2.6923838744309334`}}, 0.025760410332299408`], 
     InsetBox[
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {0.7944556266853284, -2.6923838744309334},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[BezierCurveBox[{{1.2455121429804816`, -0.29445562668532865`}, {
      0.8836096465687237, -0.7963395736508023}, {
      0.2944556266853282, -0.9854386323103814}}], 0.025760410332299408`], 
     InsetBox[
      StyleBox[
       SubscriptBox["d", "1"],
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {0.8183526952266587, -0.7065210856385159},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[{{1.2455121429804816`, -0.29445562668532865`}, {
      1.833297395272955, -2.103472621060276}}, 0.025760410332299408`], 
     InsetBox[
      StyleBox[
       SubscriptBox["d", "2"],
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {1.5394047691267183, -1.1989641238728024},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[BezierCurveBox[{{0.2944556266853282, -0.9854386323103814}, {
      0.6563581230970876, -0.4835546853449074}, {
      1.2455121429804816`, -0.29445562668532865`}}], 0.025760410332299408`], 
     InsetBox[
      StyleBox[
       SubscriptBox["f", "1"],
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {0.7216150744391514, -0.5733731733571943},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[BezierCurveBox[{{0.2944556266853282, -0.9854386323103814}, {
      0.6599416031728179, -1.4847190286025664`}, {
      0.6577268906880088, -2.103472621060276}}], 0.025760410332299408`], 
     InsetBox[
      StyleBox[
       SubscriptBox["f", "2"],
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {0.5543536378991613, -1.5190266382051412},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[BezierCurveBox[{{2.1965686592756355`, -0.9854386323103812}, {
      2.198783371760454, -1.604192224768067}, {
      1.833297395272955, -2.103472621060276}}], 0.025760410332299408`], 
     InsetBox[
      StyleBox[
       SubscriptBox["c", "1"],
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {2.093195406486788, -1.5698846151655164},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[BezierCurveBox[{{1.833297395272955, -2.103472621060276}, {
      1.8310826827881328`, -1.484719028602591}, {
      2.1965686592756355`, -0.9854386323103812}}], 0.025760410332299408`], 
     InsetBox[
      StyleBox["1",
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {1.9366706480618028, -1.519026638205141},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[BezierCurveBox[{{0.6577268906880088, -2.103472621060276}, {
      0.2922409142005196, -1.6041922247680986`}, {
      0.2944556266853282, -0.9854386323103814}}], 0.025760410332299408`], 
     InsetBox[
      StyleBox[
       SubscriptBox["e", "2"],
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {0.3978288794741759, -1.5698846151655164},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}, {
     ArrowBox[{{0.6577268906880088, -2.103472621060276}, {
      1.833297395272955, -2.103472621060276}}, 0.025760410332299408`], 
     InsetBox[
      StyleBox[
       SubscriptBox["e", "1"],
       StripOnInput->False,
       LineColor->RGBColor[1, 0, 0],
       FrontFaceColor->RGBColor[1, 0, 0],
       BackFaceColor->RGBColor[1, 0, 0],
       GraphicsColor->RGBColor[1, 0, 0],
       FontSize->16,
       FontSlant->Italic,
       FontColor->RGBColor[1, 0, 0]], {1.2455121429804819, -2.103472621060276},
       ImageScaled[{0.5, 0.5}],
      BaseStyle->"Graphics"]}}, 
   {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
    0.7]}], {DiskBox[{0.29445562668532843, -2.6923838744309334}, 
      0.025760410332299408], InsetBox[
      StyleBox[
       RowBox[{
        RowBox[{"2", " ", "X"}], "+", "Y"}],
       StripOnInput->False,
       LineColor->RGBColor[0, 0, 1],
       FrontFaceColor->RGBColor[0, 0, 1],
       BackFaceColor->RGBColor[0, 0, 1],
       GraphicsColor->RGBColor[0, 0, 1],
       FontSize->16,
       FontColor->RGBColor[0, 0, 1]], 
      Offset[{2, 2}, {0.32021603701762785, -2.666623464098634}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{1.2944556266853284, -2.6923838744309334}, 0.025760410332299408],
      InsetBox[
      StyleBox[
       RowBox[{"3", " ", "X"}],
       StripOnInput->False,
       LineColor->RGBColor[0, 0, 1],
       FrontFaceColor->RGBColor[0, 0, 1],
       BackFaceColor->RGBColor[0, 0, 1],
       GraphicsColor->RGBColor[0, 0, 1],
       FontSize->16,
       FontColor->RGBColor[0, 0, 1]], 
      Offset[{2, 2}, {1.320216037017628, -2.666623464098634}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{1.2455121429804816, -0.29445562668532865}, 
      0.025760410332299408], InsetBox[
      StyleBox["X",
       StripOnInput->False,
       LineColor->RGBColor[0, 0, 1],
       FrontFaceColor->RGBColor[0, 0, 1],
       BackFaceColor->RGBColor[0, 0, 1],
       GraphicsColor->RGBColor[0, 0, 1],
       FontSize->16,
       FontColor->RGBColor[0, 0, 1]], 
      Offset[{2, 2}, {1.271272553312781, -0.26869521635302923}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.2944556266853282, -0.9854386323103814}, 0.025760410332299408],
      InsetBox[
      StyleBox["\<\"0\"\>",
       StripOnInput->False,
       LineColor->RGBColor[0, 0, 1],
       FrontFaceColor->RGBColor[0, 0, 1],
       BackFaceColor->RGBColor[0, 0, 1],
       GraphicsColor->RGBColor[0, 0, 1],
       FontSize->16,
       FontColor->RGBColor[0, 0, 1]], 
      Offset[{2, 2}, {0.32021603701762763, -0.9596782219780821}], 
      ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{2.1965686592756355, -0.9854386323103812}, 0.025760410332299408],
      InsetBox[
      StyleBox[
       RowBox[{"2", " ", "X"}],
       StripOnInput->False,
       LineColor->RGBColor[0, 0, 1],
       FrontFaceColor->RGBColor[0, 0, 1],
       BackFaceColor->RGBColor[0, 0, 1],
       GraphicsColor->RGBColor[0, 0, 1],
       FontSize->16,
       FontColor->RGBColor[0, 0, 1]], 
      Offset[{2, 2}, {2.2223290696079347, -0.9596782219780818}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{1.833297395272955, -2.103472621060276}, 0.025760410332299408], 
     InsetBox[
      StyleBox[
       RowBox[{"X", "+", "Y"}],
       StripOnInput->False,
       LineColor->RGBColor[0, 0, 1],
       FrontFaceColor->RGBColor[0, 0, 1],
       BackFaceColor->RGBColor[0, 0, 1],
       GraphicsColor->RGBColor[0, 0, 1],
       FontSize->16,
       FontColor->RGBColor[0, 0, 1]], 
      Offset[{2, 2}, {1.8590578056052545, -2.077712210727977}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}, {
     DiskBox[{0.6577268906880088, -2.103472621060276}, 0.025760410332299408], 
     InsetBox[
      StyleBox["Y",
       StripOnInput->False,
       LineColor->RGBColor[0, 0, 1],
       FrontFaceColor->RGBColor[0, 0, 1],
       BackFaceColor->RGBColor[0, 0, 1],
       GraphicsColor->RGBColor[0, 0, 1],
       FontSize->16,
       FontColor->RGBColor[0, 0, 1]], 
      Offset[{2, 2}, {0.6834873010203082, -2.077712210727977}], ImageScaled[{0, 0}],
      BaseStyle->"Graphics"]}}},
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{3.8048683185074043`*^9, 3.8048684594473457`*^9, 
  3.8049233655675364`*^9, 3.80564313910291*^9, 3.805643824875045*^9, 
  3.805685026260908*^9, 3.8056862944942665`*^9, 3.8056988227955165`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"35e3863c-6733-438b-964a-bb2e0baf9634"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Fig-1-Model1.pdf\>\"", ",", "model1fig"}], "]"}]], "Input",
 CellChangeTimes->{{3.8043244208456354`*^9, 3.804324439505769*^9}, {
  3.8043264735294375`*^9, 3.8043264787580194`*^9}, {3.80569886926491*^9, 
  3.805698871921215*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"3131c282-1d51-4408-98d4-ad678b6e5ffe"],

Cell[BoxData["\<\"Fig-1-Model1.pdf\"\>"], "Output",
 CellChangeTimes->{3.804868470369362*^9, 3.8056267236873226`*^9, 
  3.805686297244306*^9, 3.8056988802963142`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"be654f0b-4625-422f-8c1b-499a4c52b7c8"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The singular point is shifted into the origin", "Section",
 CellChangeTimes->{{3.7754643379957733`*^9, 3.7754643425427155`*^9}, {
  3.775464403106039*^9, 3.7754644054655013`*^9}, {3.775464594072363*^9, 
  3.775464628197858*^9}},ExpressionUUID->"cfcb6d3e-2fe4-4c4c-bb61-\
d218e77252b8"],

Cell[CellGroupData[{

Cell[TextData[{
 "Equations (4)-(5): Singular points if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x0", "=", "1"}], TraditionalForm]],ExpressionUUID->
  "87964ac5-1ea4-487e-aa82-0d9d71bea1ad"]
}], "Subsection",
 CellChangeTimes->{{3.775464638088626*^9, 3.7754646479637156`*^9}, {
  3.805284592647807*^9, 3.8052846011791697`*^9}, {3.805285305147967*^9, 
  3.805285306554235*^9}},ExpressionUUID->"56c2b7ec-180a-4c9a-b6f3-\
3aee0f541505"],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.7383135164637613`*^9, 3.738313516916939*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"96f90d1a-86e6-4da6-bedd-f42642346b10"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "xd", ",", "yd", ",", "x", ",", "y", ",", "c1", ",", "d1", ",", "d2", ",", 
    "e1", ",", "e2", ",", "f1", ",", "f2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xd", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"d1", " ", "x"}], "+", 
    RowBox[{"e1", " ", "y"}], "+", "f1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yd", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "y"}], "-", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d2", " ", "x"}], "-", 
    RowBox[{"e2", " ", "y"}], "+", "f2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"xd", "\[Equal]", "0"}], ",", 
       RowBox[{"yd", "\[Equal]", "0"}]}], "}"}], "/.", 
     RowBox[{"x", "\[Rule]", "1"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d1", ",", "y"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.7257707091953645`*^9, 3.7257707162891498`*^9}, {
   3.725772137746993*^9, 3.725772142559555*^9}, 3.725777525298565*^9, {
   3.7257917916342297`*^9, 3.7257918102931213`*^9}, {3.725947938051674*^9, 
   3.7259479497861977`*^9}, {3.726904429617963*^9, 3.726904450418042*^9}, {
   3.7528179032933197`*^9, 3.7528180175337687`*^9}, {3.7528376322556887`*^9, 
   3.752837653115301*^9}, {3.7528377225426364`*^9, 3.7528377226207232`*^9}, {
   3.752838355250634*^9, 3.7528383553443685`*^9}, {3.7582631840818596`*^9, 
   3.758263188491659*^9}, {3.7582632499392595`*^9, 3.7582632538070593`*^9}, {
   3.7582643827950153`*^9, 3.758264406374401*^9}, {3.7582662120702934`*^9, 
   3.7582662121804886`*^9}, {3.7583456930531874`*^9, 3.758345707764188*^9}, {
   3.7583465382383804`*^9, 3.758346582758832*^9}, {3.758346694192974*^9, 
   3.7583467532748823`*^9}, {3.758347779341894*^9, 3.7583477795399137`*^9}, {
   3.758348093032896*^9, 3.758348093173298*^9}, {3.775464447887991*^9, 
   3.7754644483567495`*^9}, 3.7759949842913733`*^9, {3.804868492947804*^9, 
   3.8048684959790754`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"9b13d64d-e3cf-4168-8abf-e64853ad7682"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"d1", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"d2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e1"}], ")"}]}], "+", 
       RowBox[{"c1", " ", 
        RowBox[{"(", 
         RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}], " ", "f1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "e1"}], ")"}], " ", "f2"}]}], 
      RowBox[{"2", "+", "e2"}]]}], ",", 
    RowBox[{"y", "\[Rule]", 
     FractionBox[
      RowBox[{"c1", "+", "d2", "+", "f2"}], 
      RowBox[{"2", "+", "e2"}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.781335019481611*^9, 3.8048685310784407`*^9, 
  3.8049108890652733`*^9, 3.8049161122663517`*^9, 3.804916592172249*^9, 
  3.8049234254877357`*^9, 3.8049266224907713`*^9, 3.8049273278628864`*^9, 
  3.804930517118146*^9, 3.804930807742999*^9, 3.8056267413594155`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"a3ffbbb5-b753-468a-a9a8-3953a73430ff"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Equation (6): The singular point (if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x0", "=", "1"}], TraditionalForm]],ExpressionUUID->
  "0b117fd0-d7c6-4efa-906f-ed3257560c43"],
 ") is shifted into ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "0"}], ")"}], TraditionalForm]],ExpressionUUID->
  "d533d9fb-d0a1-4ad5-9571-d3e06e917394"]
}], "Subsection",
 CellChangeTimes->{{3.725773415931628*^9, 3.7257734748149195`*^9}, {
  3.7257775450793324`*^9, 3.725777551938794*^9}, {3.725791972576687*^9, 
  3.7257919875612464`*^9}, {3.7383137534123864`*^9, 3.7383137542561483`*^9}, {
  3.738313810788183*^9, 3.7383138153819957`*^9}, {3.7528180793782673`*^9, 
  3.7528180844721365`*^9}, {3.8052846636487246`*^9, 
  3.8052846661956563`*^9}},ExpressionUUID->"d579fd6c-35df-4b0a-b052-\
797a84c9465e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "xd", ",", "yd", ",", "x", ",", "y", ",", "c1", ",", "d1", ",", "d2", ",", 
    "e1", ",", "e2", ",", "f1", ",", "f2", ",", "x0", ",", "y0", ",", "x1d", 
    ",", "y1d", ",", "xx1", ",", "yy1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xd", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"d1", " ", "x"}], "+", 
    RowBox[{"e1", " ", "y"}], "+", "f1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yd", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "y"}], "-", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d2", " ", "x"}], "-", 
    RowBox[{"e2", " ", "y"}], "+", "f2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x0", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"d2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}]}], "+", 
     RowBox[{"c1", " ", 
      RowBox[{"(", 
       RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", "f1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", "f2"}]}], 
    RowBox[{"2", "+", "e2"}]]}], ";", 
  RowBox[{"y0", "=", 
   FractionBox[
    RowBox[{"c1", "+", "d2", "+", "f2"}], 
    RowBox[{"2", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xx1", "=", 
   RowBox[{"x", "-", "x0"}]}], ";", 
  RowBox[{"yy1", "=", 
   RowBox[{"y", "-", "y0"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"x1d", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"xx1", ",", "x"}], "]"}], "xd"}], "+", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"xx1", ",", "y"}], "]"}], "yd"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"x1", "+", "x0"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"y1", "+", "y0"}]}]}], "}"}]}], "//", 
   "Factor"}]}], "\[IndentingNewLine]", 
 RowBox[{"y1d", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"yy1", ",", "x"}], "]"}], "xd"}], "+", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"yy1", ",", "y"}], "]"}], "yd"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       RowBox[{"x1", "+", "x0"}]}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"y1", "+", "y0"}]}]}], "}"}]}], "//", "Factor"}]}]}], "Input",
 CellChangeTimes->{{3.7257719955848103`*^9, 3.7257720245397253`*^9}, {
   3.7257722483895826`*^9, 3.7257722790618196`*^9}, {3.72577800997818*^9, 
   3.7257780348534946`*^9}, {3.7257783014724874`*^9, 
   3.7257783210821104`*^9}, {3.7257785665760975`*^9, 3.725778566685512*^9}, {
   3.725791006860224*^9, 3.7257910092352285`*^9}, {3.72586370411722*^9, 
   3.7258637260237484`*^9}, {3.7258638800417747`*^9, 
   3.7258638816980467`*^9}, {3.7258639680536475`*^9, 3.725864011738179*^9}, {
   3.725864067562937*^9, 3.7258640677972603`*^9}, {3.725864137732902*^9, 
   3.725864138076682*^9}, {3.725864241353422*^9, 3.7258642735882316`*^9}, {
   3.7258643301385627`*^9, 3.72586433027919*^9}, {3.725864618212826*^9, 
   3.7258646411506166`*^9}, {3.725948244015664*^9, 3.7259482736689587`*^9}, {
   3.7269044852595263`*^9, 3.726904522148215*^9}, {3.726915514868428*^9, 
   3.726915534567398*^9}, {3.7269156146474056`*^9, 3.7269156200609465`*^9}, 
   3.752818101206723*^9, {3.752818148086341*^9, 3.7528181894618645`*^9}, {
   3.752818342780716*^9, 3.7528183504995637`*^9}, {3.752818393500163*^9, 
   3.7528184182035465`*^9}, {3.752818538756342*^9, 3.7528185673348856`*^9}, {
   3.752819096447754*^9, 3.7528191136042604`*^9}, {3.7583468387358427`*^9, 
   3.758346842229192*^9}, {3.7583469105440226`*^9, 3.758346926006569*^9}, {
   3.758346970896057*^9, 3.7583469918881564`*^9}, 3.758348224514571*^9, {
   3.7754646661632805`*^9, 3.775464666975808*^9}, {3.775994997857089*^9, 
   3.775995007497837*^9}, {3.776001399085601*^9, 3.776001404820051*^9}, {
   3.804868552559241*^9, 3.80486857130947*^9}, {3.804910896484945*^9, 
   3.804910900283434*^9}, {3.804916601095792*^9, 3.804916606032017*^9}, {
   3.8049234938982043`*^9, 3.804923512558442*^9}, {3.8049305256782293`*^9, 
   3.804930528877507*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"7c8619a1-2b1f-4a7b-a16b-59d568077665"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "+", "e2"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c1", " ", "x1"}], "-", 
     RowBox[{"d2", " ", "x1"}], "+", 
     RowBox[{"c1", " ", "e1", " ", "x1"}], "+", 
     RowBox[{"d2", " ", "e1", " ", "x1"}], "+", 
     RowBox[{"c1", " ", "e2", " ", "x1"}], "+", 
     RowBox[{"2", " ", "f1", " ", "x1"}], "+", 
     RowBox[{"e2", " ", "f1", " ", "x1"}], "-", 
     RowBox[{"f2", " ", "x1"}], "+", 
     RowBox[{"e1", " ", "f2", " ", "x1"}], "+", 
     RowBox[{"c1", " ", 
      SuperscriptBox["x1", "2"]}], "-", 
     RowBox[{"d2", " ", 
      SuperscriptBox["x1", "2"]}], "+", 
     RowBox[{"c1", " ", "e2", " ", 
      SuperscriptBox["x1", "2"]}], "-", 
     RowBox[{"f2", " ", 
      SuperscriptBox["x1", "2"]}], "-", 
     RowBox[{"4", " ", "y1"}], "-", 
     RowBox[{"2", " ", "e1", " ", "y1"}], "-", 
     RowBox[{"2", " ", "e2", " ", "y1"}], "-", 
     RowBox[{"e1", " ", "e2", " ", "y1"}], "-", 
     RowBox[{"6", " ", "x1", " ", "y1"}], "-", 
     RowBox[{"3", " ", "e2", " ", "x1", " ", "y1"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["x1", "2"], " ", "y1"}], "-", 
     RowBox[{"e2", " ", 
      SuperscriptBox["x1", "2"], " ", "y1"}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.781335019638611*^9, 3.8048685733876247`*^9, 3.80491092836036*^9, 
   3.8049161180789614`*^9, 3.8049166078458047`*^9, 3.804923432867998*^9, {
   3.8049234952321205`*^9, 3.804923513344994*^9}, 3.804926627397274*^9, 
   3.8049273302948604`*^9, 3.804930531137108*^9, 3.804930811837504*^9, 
   3.8056267521854706`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"34b7a0d8-b9e5-48c8-8b8e-60a1433cda61"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "+", "e2"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "c1"}], " ", "x1"}], "+", 
     RowBox[{"d2", " ", "x1"}], "-", 
     RowBox[{"2", " ", "c1", " ", "e2", " ", "x1"}], "-", 
     RowBox[{"d2", " ", "e2", " ", "x1"}], "+", 
     RowBox[{"3", " ", "f2", " ", "x1"}], "-", 
     RowBox[{"c1", " ", 
      SuperscriptBox["x1", "2"]}], "+", 
     RowBox[{"d2", " ", 
      SuperscriptBox["x1", "2"]}], "-", 
     RowBox[{"c1", " ", "e2", " ", 
      SuperscriptBox["x1", "2"]}], "+", 
     RowBox[{"f2", " ", 
      SuperscriptBox["x1", "2"]}], "+", 
     RowBox[{"4", " ", "y1"}], "+", 
     RowBox[{"4", " ", "e2", " ", "y1"}], "+", 
     RowBox[{
      SuperscriptBox["e2", "2"], " ", "y1"}], "+", 
     RowBox[{"6", " ", "x1", " ", "y1"}], "+", 
     RowBox[{"3", " ", "e2", " ", "x1", " ", "y1"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x1", "2"], " ", "y1"}], "+", 
     RowBox[{"e2", " ", 
      SuperscriptBox["x1", "2"], " ", "y1"}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.781335019638611*^9, 3.8048685733876247`*^9, 3.80491092836036*^9, 
   3.8049161180789614`*^9, 3.8049166078458047`*^9, 3.804923432867998*^9, {
   3.8049234952321205`*^9, 3.804923513344994*^9}, 3.804926627397274*^9, 
   3.8049273302948604`*^9, 3.804930531137108*^9, 3.804930811837504*^9, 
   3.8056267521854706`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"4e77c12c-4d15-4d20-b7c1-9e636bfd669b"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The Jacobian at the origin ", "Section",
 CellChangeTimes->{{3.7754648771507635`*^9, 
  3.775464882478919*^9}},ExpressionUUID->"af180d0e-ad51-4875-8104-\
3c050faa7c09"],

Cell[CellGroupData[{

Cell["Equations (7)-(8)", "Subsection",
 CellChangeTimes->{{3.805285291397784*^9, 
  3.805285299554143*^9}},ExpressionUUID->"4c382a4e-6fdc-4c2b-ba99-\
d6ad7f21f1f4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Jac", "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x1d", ",", "y1d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x1", ",", "y1"}], "}"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"JacOrigin", "=", 
  RowBox[{
   RowBox[{"Jac", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x1", "\[Rule]", "0"}], ",", 
      RowBox[{"y1", "\[Rule]", "0"}]}], "}"}]}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.725773292930098*^9, 3.7257733056452265`*^9}, {
   3.7257738912984505`*^9, 3.725773913344802*^9}, 3.7257740455951633`*^9, {
   3.7257788082045965`*^9, 3.725778817782844*^9}, 3.7257794031373653`*^9, {
   3.7257794372821784`*^9, 3.7257794385790696`*^9}, {3.725791063764971*^9, 
   3.7257910787495074`*^9}, 3.725864815140272*^9, {3.7258650515882063`*^9, 
   3.725865054576826*^9}, 3.725865191632064*^9, {3.725948350943815*^9, 
   3.7259483718034286`*^9}, {3.7269045583798375`*^9, 
   3.7269045612691264`*^9}, {3.7528187459975257`*^9, 
   3.7528187834198723`*^9}, {3.7528191499484177`*^9, 3.752819160089225*^9}, 
   3.7582640589396873`*^9, {3.758264112847957*^9, 3.7582641478288507`*^9}, {
   3.7583473574977136`*^9, 3.758347367017666*^9}, {3.7754703920551786`*^9, 
   3.775470397383381*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"a45fff16-fbee-458b-9509-87c2c535f2b3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"d2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "e1"}], ")"}]}], "+", 
        RowBox[{"c1", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}], "+", 
        RowBox[{"2", " ", "f1"}], "+", 
        RowBox[{"e2", " ", "f1"}], "-", "f2", "+", 
        RowBox[{"e1", " ", "f2"}]}], 
       RowBox[{"2", "+", "e2"}]]}], ",", 
     RowBox[{"2", "+", "e1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"c1", "+", 
       RowBox[{"d2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "e2"}], ")"}]}], "+", 
       RowBox[{"2", " ", "c1", " ", "e2"}], "-", 
       RowBox[{"3", " ", "f2"}]}], 
      RowBox[{"2", "+", "e2"}]], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "-", "e2"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7813350209426107`*^9, 3.804868622732031*^9, 
  3.804910931552909*^9, 3.804916185627141*^9, 3.804923554371151*^9, 
  3.804927025343079*^9, 3.804927334511857*^9, 3.8049305353450994`*^9, 
  3.8049308145449777`*^9, 3.805626760576189*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"c29ccbb1-7105-41a4-b436-a20be37bfd03"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"trace", "=", 
  RowBox[{
   RowBox[{"Tr", "[", "JacOrigin", "]"}], "//", 
   "Factor"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"trace", "\[Equal]", "0"}], ",", "c1"}], "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.7257738982985144`*^9, 3.7257739922899*^9}, 
   3.7257740496733418`*^9, {3.725774085689976*^9, 3.7257740895848866`*^9}, {
   3.7257788867615614`*^9, 3.7257788871990967`*^9}, {3.725858125073209*^9, 
   3.725858125323213*^9}, {3.7258677882794285`*^9, 3.7258677884512515`*^9}, {
   3.725948359990805*^9, 3.725948384020666*^9}, {3.726904569027902*^9, 
   3.726904570996099*^9}, {3.752818901972415*^9, 3.7528189029255524`*^9}, {
   3.7528385211641603`*^9, 3.752838532429929*^9}, {3.7583466578393393`*^9, 
   3.7583466618877444`*^9}, {3.758347034242391*^9, 3.7583470348644533`*^9}, 
   3.775995025107464*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"4d0b288f-af80-48f0-af7e-2d5668eda30e"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", "+", "c1", "-", "d2", "+", 
    RowBox[{"c1", " ", "e1"}], "+", 
    RowBox[{"d2", " ", "e1"}], "+", 
    RowBox[{"4", " ", "e2"}], "+", 
    RowBox[{"c1", " ", "e2"}], "+", 
    SuperscriptBox["e2", "2"], "+", 
    RowBox[{"2", " ", "f1"}], "+", 
    RowBox[{"e2", " ", "f1"}], "-", "f2", "+", 
    RowBox[{"e1", " ", "f2"}]}], 
   RowBox[{"2", "+", "e2"}]]}]], "Output",
 CellChangeTimes->{3.781335022280611*^9, 3.804868627216464*^9, 
  3.804910933307794*^9, 3.804916188266219*^9, 3.8049235555209703`*^9, 
  3.8049270342434072`*^9, 3.804927337734164*^9, 3.8049305370393133`*^9, 
  3.804930817576399*^9, 3.8056267619043493`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"762f9460-f4af-4d57-a08d-45260095a4bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"c1", "\[Rule]", 
    FractionBox[
     RowBox[{"d2", "-", 
      RowBox[{"d2", " ", "e1"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", "e2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "-", 
      RowBox[{"e1", " ", "f2"}]}], 
     RowBox[{"1", "+", "e1", "+", "e2"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.781335022280611*^9, 3.804868627216464*^9, 
  3.804910933307794*^9, 3.804916188266219*^9, 3.8049235555209703`*^9, 
  3.8049270342434072`*^9, 3.804927337734164*^9, 3.8049305370393133`*^9, 
  3.804930817576399*^9, 3.805626762029337*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"ce652a8a-4ede-4456-8248-db83e3014a70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c1", "=", 
   FractionBox[
    RowBox[{"d2", "-", 
     RowBox[{"d2", " ", "e1"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "-", 
     RowBox[{"e1", " ", "f2"}]}], 
    RowBox[{"1", "+", "e1", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"evalues", "=", 
  RowBox[{
   RowBox[{"Eigenvalues", "[", "JacOrigin", "]"}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.7754805178543043`*^9, 3.775480518901194*^9}, {
   3.7758958252118235`*^9, 3.7758958272118263`*^9}, {3.775995029857503*^9, 
   3.775995034685691*^9}, 3.7760014301328983`*^9, 3.804868636107207*^9, 
   3.8049109388973575`*^9, 3.804927040423797*^9, {3.8049305413293524`*^9, 
   3.804930549939475*^9}, 3.8049308251607957`*^9, 3.8056267676700897`*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"7ac62d07-ec15-4e5f-b624-74ca3fd33f81"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"1", "+", "e1", "+", "e2"}]]], 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "e2"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "d2"}], "+", "e2", "+", 
            SuperscriptBox["e2", "2"], "-", 
            RowBox[{"4", " ", "f1"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"e2", "+", "f1", "+", "f2"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["e1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"d2", "+", 
            RowBox[{"2", " ", "f2"}]}], ")"}]}], "+", 
         RowBox[{"e1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", 
            RowBox[{"d2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "e2"}], ")"}]}], "+", "e2", "+", 
            SuperscriptBox["e2", "2"], "+", "f1", "+", 
            RowBox[{"2", " ", "e2", " ", "f1"}], "+", 
            RowBox[{"5", " ", "f2"}]}], ")"}]}]}], ")"}]}]}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "+", "e1", "+", "e2"}]]], 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "e2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "d2"}], "+", "e2", "+", 
           SuperscriptBox["e2", "2"], "-", 
           RowBox[{"4", " ", "f1"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"e2", "+", "f1", "+", "f2"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["e1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"d2", "+", 
           RowBox[{"2", " ", "f2"}]}], ")"}]}], "+", 
        RowBox[{"e1", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "-", 
           RowBox[{"d2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "e2"}], ")"}]}], "+", "e2", "+", 
           SuperscriptBox["e2", "2"], "+", "f1", "+", 
           RowBox[{"2", " ", "e2", " ", "f1"}], "+", 
           RowBox[{"5", " ", "f2"}]}], ")"}]}]}], ")"}]}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7813350250556107`*^9, 3.8048686387791176`*^9, 
  3.804910941285915*^9, 3.8049235581558404`*^9, 3.8049270430286493`*^9, 
  3.8049273455056696`*^9, 3.8049305521600504`*^9, 3.8049308275785246`*^9, 
  3.805626769966938*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"1ae43d3d-edad-4f43-a56a-686a2c1119e9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equation (9)", "Subsection",
 CellChangeTimes->{{3.8052858635284514`*^9, 
  3.80528586565351*^9}},ExpressionUUID->"e85d2bf3-3bc1-40b3-b285-\
2808d5629464"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"beta", "=", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{
     "evalues", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
     "2"]}], "//", "Factor"}]}]], "Input",
 CellChangeTimes->{{3.775480522088688*^9, 3.775480522963752*^9}, {
   3.7758958306337757`*^9, 3.7758958320712976`*^9}, {3.7759012350310936`*^9, 
   3.775901238531114*^9}, 3.775901275344203*^9, 3.7759013098602743`*^9, {
   3.7759014582440205`*^9, 3.7759014613690405`*^9}, {3.77590176604533*^9, 
   3.7759017689203715`*^9}, {3.804923823417368*^9, 3.804923841930522*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"42c343bc-bbc1-4f98-80b0-8aab0727de05"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "+", "e1", "+", "e2"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "e1"}], "+", 
    RowBox[{"2", " ", "d2", " ", "e1"}], "+", 
    RowBox[{"d2", " ", 
     SuperscriptBox["e1", "2"]}], "+", 
    RowBox[{"2", " ", "e2"}], "-", 
    RowBox[{"2", " ", "d2", " ", "e2"}], "+", 
    RowBox[{"e1", " ", "e2"}], "-", 
    RowBox[{"d2", " ", "e1", " ", "e2"}], "-", 
    SuperscriptBox["e2", "2"], "+", 
    RowBox[{"e1", " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    SuperscriptBox["e2", "3"], "+", 
    RowBox[{"2", " ", "f1"}], "+", 
    RowBox[{"e1", " ", "f1"}], "+", 
    RowBox[{"4", " ", "e2", " ", "f1"}], "+", 
    RowBox[{"2", " ", "e1", " ", "e2", " ", "f1"}], "+", 
    RowBox[{"2", " ", "f2"}], "+", 
    RowBox[{"5", " ", "e1", " ", "f2"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["e1", "2"], " ", "f2"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.781335027636611*^9, 3.804868641654157*^9, 3.8049109438291063`*^9, 
   3.804923581307294*^9, {3.804923827063958*^9, 3.80492384233681*^9}, 
   3.804927045764611*^9, 3.8049273485558558`*^9, 3.8049305547779284`*^9, 
   3.804930830199369*^9, 3.805626774170124*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"a7aa2a8e-e992-4277-bd29-c442546ef364"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["System (10)", "Subsection",
 CellChangeTimes->{{3.8052847573218684`*^9, 3.8052847595562487`*^9}, {
  3.805285847668921*^9, 3.805285847715771*^9}, {3.8057006574333096`*^9, 
  3.805700658214587*^9}},ExpressionUUID->"3ef8ecc0-1859-466d-bbf4-\
10356ebee860"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"pp", "=", 
  RowBox[{
   RowBox[{"x1d", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x1", "\[Rule]", "x"}], ",", 
      RowBox[{"y1", "\[Rule]", "y"}]}], "}"}]}], "//", 
   "Factor"}]}], "\[IndentingNewLine]", 
 RowBox[{"qq", "=", 
  RowBox[{
   RowBox[{"y1d", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x1", "\[Rule]", "x"}], ",", 
      RowBox[{"y1", "\[Rule]", "y"}]}], "}"}]}], "//", "Factor"}]}]}], "Input",
 CellChangeTimes->{{3.775889304422966*^9, 3.775889318891921*^9}, 
   3.7758895041758857`*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"f14e893e-b513-4e7a-a949-821840ec4f9e"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "+", "e1", "+", "e2"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"2", " ", "e1", " ", "x"}], "+", 
    RowBox[{"3", " ", "e2", " ", "x"}], "+", 
    RowBox[{"e1", " ", "e2", " ", "x"}], "+", 
    RowBox[{
     SuperscriptBox["e2", "2"], " ", "x"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d2", " ", "e1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"3", " ", "e2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["e2", "2"], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"f1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"e2", " ", "f1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"e1", " ", "f2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", "y"}], "+", 
    RowBox[{"3", " ", "e1", " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["e1", "2"], " ", "y"}], "+", 
    RowBox[{"2", " ", "e2", " ", "y"}], "+", 
    RowBox[{"e1", " ", "e2", " ", "y"}], "+", 
    RowBox[{"3", " ", "x", " ", "y"}], "+", 
    RowBox[{"3", " ", "e1", " ", "x", " ", "y"}], "+", 
    RowBox[{"3", " ", "e2", " ", "x", " ", "y"}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"e1", " ", 
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"e2", " ", 
     SuperscriptBox["x", "2"], " ", "y"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.781335028766611*^9, 3.8048686447479486`*^9, 
  3.804910945669615*^9, 3.8049235980622063`*^9, 3.8049240466950493`*^9, 
  3.804927048346428*^9, 3.804927350334119*^9, 3.8049306650532837`*^9, 
  3.804930832205814*^9, 3.805626778326429*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"d0370b8c-1784-48f4-a56f-00b0941963ed"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", "e1", "+", "e2"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "x"}], "+", 
     RowBox[{"d2", " ", "e1", " ", "x"}], "+", 
     RowBox[{"5", " ", "e2", " ", "x"}], "-", 
     RowBox[{"d2", " ", "e2", " ", "x"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["e2", "2"], " ", "x"}], "+", 
     RowBox[{"f1", " ", "x"}], "+", 
     RowBox[{"2", " ", "e2", " ", "f1", " ", "x"}], "+", 
     RowBox[{"f2", " ", "x"}], "+", 
     RowBox[{"2", " ", "e1", " ", "f2", " ", "x"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"d2", " ", "e1", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"3", " ", "e2", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["e2", "2"], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"f1", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"e2", " ", "f1", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"e1", " ", "f2", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"2", " ", "y"}], "+", 
     RowBox[{"2", " ", "e1", " ", "y"}], "+", 
     RowBox[{"3", " ", "e2", " ", "y"}], "+", 
     RowBox[{"e1", " ", "e2", " ", "y"}], "+", 
     RowBox[{
      SuperscriptBox["e2", "2"], " ", "y"}], "+", 
     RowBox[{"3", " ", "x", " ", "y"}], "+", 
     RowBox[{"3", " ", "e1", " ", "x", " ", "y"}], "+", 
     RowBox[{"3", " ", "e2", " ", "x", " ", "y"}], "+", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", "y"}], "+", 
     RowBox[{"e1", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "+", 
     RowBox[{"e2", " ", 
      SuperscriptBox["x", "2"], " ", "y"}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.781335028766611*^9, 3.8048686447479486`*^9, 
  3.804910945669615*^9, 3.8049235980622063`*^9, 3.8049240466950493`*^9, 
  3.804927048346428*^9, 3.804927350334119*^9, 3.8049306650532837`*^9, 
  3.804930832205814*^9, 3.805626778342055*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"66e21db5-753d-46ed-88d0-5ac37d4a6fd4"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lyapunov\[CloseCurlyQuote]s theorem", "Section",
 CellChangeTimes->{{3.7754648771507635`*^9, 3.775464882478919*^9}, {
  3.7758929895059705`*^9, 
  3.7758929944122915`*^9}},ExpressionUUID->"68e87935-ff79-4250-926c-\
be50b9c23238"],

Cell[CellGroupData[{

Cell["System (10)", "Subsection",
 CellChangeTimes->{{3.7759010272117643`*^9, 3.7759010309774456`*^9}, {
  3.7759070706552906`*^9, 3.775907071374051*^9}, {3.805700648120682*^9, 
  3.805700649011335*^9}},ExpressionUUID->"383c0400-aa39-4f90-a71d-\
b5d38099da9f"],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.753680611453865*^9, 3.753680613052865*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"858056b9-d9dc-4ec2-bfcf-13fbc69b41dd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pp", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", "e1", "+", "e2"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"2", " ", "e1", " ", "x"}], "+", 
      RowBox[{"3", " ", "e2", " ", "x"}], "+", 
      RowBox[{"e1", " ", "e2", " ", "x"}], "+", 
      RowBox[{
       SuperscriptBox["e2", "2"], " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"d2", " ", "e1", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"3", " ", "e2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["e2", "2"], " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"f1", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e2", " ", "f1", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e1", " ", "f2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"2", " ", "y"}], "+", 
      RowBox[{"3", " ", "e1", " ", "y"}], "+", 
      RowBox[{
       SuperscriptBox["e1", "2"], " ", "y"}], "+", 
      RowBox[{"2", " ", "e2", " ", "y"}], "+", 
      RowBox[{"e1", " ", "e2", " ", "y"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"3", " ", "e1", " ", "x", " ", "y"}], "+", 
      RowBox[{"3", " ", "e2", " ", "x", " ", "y"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"e1", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"e2", " ", 
       SuperscriptBox["x", "2"], " ", "y"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"qq", "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"1", "+", "e1", "+", "e2"}]]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "x"}], "+", 
      RowBox[{"d2", " ", "e1", " ", "x"}], "+", 
      RowBox[{"5", " ", "e2", " ", "x"}], "-", 
      RowBox[{"d2", " ", "e2", " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e2", "2"], " ", "x"}], "+", 
      RowBox[{"f1", " ", "x"}], "+", 
      RowBox[{"2", " ", "e2", " ", "f1", " ", "x"}], "+", 
      RowBox[{"f2", " ", "x"}], "+", 
      RowBox[{"2", " ", "e1", " ", "f2", " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"d2", " ", "e1", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"3", " ", "e2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["e2", "2"], " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"f1", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e2", " ", "f1", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e1", " ", "f2", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"2", " ", "y"}], "+", 
      RowBox[{"2", " ", "e1", " ", "y"}], "+", 
      RowBox[{"3", " ", "e2", " ", "y"}], "+", 
      RowBox[{"e1", " ", "e2", " ", "y"}], "+", 
      RowBox[{
       SuperscriptBox["e2", "2"], " ", "y"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"3", " ", "e1", " ", "x", " ", "y"}], "+", 
      RowBox[{"3", " ", "e2", " ", "x", " ", "y"}], "+", 
      RowBox[{
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"e1", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"e2", " ", 
       SuperscriptBox["x", "2"], " ", "y"}]}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.753681587697193*^9, 3.7536816030167246`*^9}, {
  3.775893020707721*^9, 3.77589302659838*^9}, {3.7759950629673195`*^9, 
  3.7759950724518404`*^9}, {3.776001450383155*^9, 3.776001456664462*^9}, {
  3.8048687928905706`*^9, 3.804868824672245*^9}, {3.8049109910507565`*^9, 
  3.8049109977044096`*^9}, {3.8049270606641855`*^9, 3.8049270688129745`*^9}, {
  3.804930704267395*^9, 3.804930710515836*^9}, {3.80562681878012*^9, 
  3.8056268317501497`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"ec66136f-ae5a-4843-95f3-a6d486039ff0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Program", "Subsection",
 CellChangeTimes->{{3.775907080570363*^9, 
  3.775907081226637*^9}},ExpressionUUID->"c518e3ff-e9f2-4463-9850-\
acfdd769ecca"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Ser", "[", "s_", "]"}], ":=", 
   RowBox[{"Plus", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "i"], 
       SuperscriptBox["y", 
        RowBox[{"s", "-", "i"}]], 
       RowBox[{"p", "[", 
        RowBox[{"i", ",", 
         RowBox[{"s", "-", "i"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "s"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Hom", "[", "s_", "]"}], ":=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{
       RowBox[{"s", "-", "i"}], ",", "i"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "s"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"hh", "=", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"Ser", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "6"}], "}"}]}], "]"}]}], ";"}], 
  RowBox[{"(*", "9", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Lie", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"hh", ",", "x"}], "]"}], " ", "pp"}], "+", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"hh", ",", "y"}], "]"}], " ", "qq"}]}], "//", "Expand"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RHS", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], "2"]}], "+", 
     RowBox[{"g2", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], "3"]}], "+", 
     RowBox[{"g3", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], ")"}], "4"]}]}], "//", "Expand"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vv", "=", 
   RowBox[{
    RowBox[{"Lie", "-", "RHS"}], "//", "Expand"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CoefPol", "[", 
    RowBox[{"f_", ",", "s_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "lis", ",", "t"}], "}"}], ",", 
     RowBox[{
      RowBox[{"lis", "=", 
       RowBox[{"{", "}"}]}], ";", " ", 
      RowBox[{"m", "=", 
       RowBox[{"Expand", "[", "f", "]"}]}], ";", "  ", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"i", "+", "j"}], "==", "s"}], ",", 
            RowBox[{"lis", "=", 
             RowBox[{"AppendTo", "[", 
              RowBox[{"lis", ",", 
               RowBox[{
                RowBox[{"Coefficient", "[", 
                 RowBox[{"m", ",", 
                  RowBox[{
                   RowBox[{"x", "^", "i"}], " ", 
                   RowBox[{"y", "^", "j"}]}]}], " ", "]"}], "/.", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"x", "\[Rule]", "0"}], ",", 
                  RowBox[{"y", "\[Rule]", "0"}], ",", 
                  RowBox[{"z", "\[Rule]", "0"}]}], "}"}]}]}], "]"}]}]}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "s"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", "s"}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ls", "[", "s", "]"}], "=", "lis"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"CoefPol", "[", 
     RowBox[{"vv", ",", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "9"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.7589623187116213`*^9, 3.758962333834133*^9}, {
   3.758962462667015*^9, 3.758962471691918*^9}, {3.771902392474348*^9, 
   3.771902392818103*^9}, {3.77192479309186*^9, 3.7719248228228874`*^9}, {
   3.7719248806305785`*^9, 3.771924880927401*^9}, {3.7719294277444873`*^9, 
   3.771929428853932*^9}, {3.781258862229906*^9, 3.7812588623549223`*^9}, 
   3.781259250683115*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"fa6590d8-d700-4832-8dc1-4e7029112f1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Degree 1, 2", "Subsection",
 CellChangeTimes->{{3.7582777421989403`*^9, 3.758277744662566*^9}, 
   3.7589627988186274`*^9, {3.758966012589991*^9, 3.758966014998232*^9}, {
   3.758974541112791*^9, 3.7589745416578455`*^9}, {3.77182171875251*^9, 
   3.771821718924388*^9}, 3.775908383999316*^9, 
   3.804936293903381*^9},ExpressionUUID->"721f3fea-4dc3-46e8-bb90-\
5a0ea414bb56"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ls", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ls", "[", "2", "]"}], "//", "Factor"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol2", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ls", "[", "2", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"Hom", "[", "2", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"2", ",", "0"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"0", ",", "2"}], "]"}]}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "[", 
       RowBox[{"2", ",", "0"}], "]"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"1", ",", "1"}], "]"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"0", ",", "2"}], "]"}]}], "}"}], "/.", 
    RowBox[{
    "sol2", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ls", "[", "2", "]"}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.7582775870515313`*^9, 3.758277590323131*^9}, {
   3.7582776345737314`*^9, 3.758277637912731*^9}, {3.758277726220766*^9, 
   3.758277726283167*^9}, {3.758962755922338*^9, 3.7589627561453605`*^9}, {
   3.7589699505177536`*^9, 3.7589699506237645`*^9}, {3.7589729578084764`*^9, 
   3.7589729627499704`*^9}, {3.7589745384755273`*^9, 3.7589745392036*^9}, {
   3.7718217277057667`*^9, 3.7718217281745214`*^9}, {3.7719248517707834`*^9, 
   3.7719248546145744`*^9}, {3.7759083891243896`*^9, 3.7759083896712723`*^9}, 
   3.7813350436946106`*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"b0b09f39-4c30-4439-af9e-b0f81879c035"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.7813350451006107`*^9, 3.7813351068076105`*^9, 
  3.804871193060645*^9, 3.804911031268903*^9, 3.804924068908146*^9, 
  3.8049285839588957`*^9, 3.804930730378014*^9, 3.804930898259843*^9, 
  3.805285951441327*^9, 3.80562684176587*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"d14ff849-585e-4791-91e0-b41ba116b5a3"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    13, 1, 20771761113813511231, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7813350452796106`*^9, 3.7813351070386105`*^9, 
  3.80487119310752*^9, 3.8049110313782797`*^9, 3.8049240689962044`*^9, 
  3.804928584020938*^9, 3.80493073042605*^9, 3.804930898378975*^9, 
  3.805285951527388*^9, 3.8056268418127317`*^9},
 CellLabel->
  "During evaluation of \
In[11]:=",ExpressionUUID->"9d0ab080-9761-4968-83e4-5cff9c140fdf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.7813350451006107`*^9, 3.7813351068076105`*^9, 
  3.804871193060645*^9, 3.804911031268903*^9, 3.804924068908146*^9, 
  3.8049285839588957`*^9, 3.804930730378014*^9, 3.804930898259843*^9, 
  3.805285951441327*^9, 3.805626841844*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"1b97ff50-83fc-4325-b25d-fd8f074f05f2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quadratic form", "Subsection",
 CellChangeTimes->{{3.758348042551506*^9, 3.758348044728738*^9}, 
   3.775908420015462*^9, 
   3.8049362891289997`*^9},ExpressionUUID->"564b006c-5f52-462b-b543-\
9349a93befcf"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"qv", ",", "mat", ",", "a11", ",", "det", ",", "eg"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"qv", "=", 
  RowBox[{
   RowBox[{"Ser", "[", "2", "]"}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    RowBox[{"D", "[", 
     RowBox[{"qv", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"mat", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{"a11", "=", 
  RowBox[{"mat", "\[LeftDoubleBracket]", 
   RowBox[{"1", ",", "1"}], 
   "\[RightDoubleBracket]"}]}], "\[IndentingNewLine]", 
 RowBox[{"det", "=", 
  RowBox[{
   RowBox[{"Det", "[", "mat", "]"}], "//", 
   "Factor"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eg", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Eigenvalues", "[", "mat", "]"}], "//", "Simplify"}], "//", 
    "Factor"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.7583485433798947`*^9, 3.7583485959071465`*^9}, {
   3.7583486353260884`*^9, 3.7583486450860643`*^9}, {3.7583488522381887`*^9, 
   3.7583488523601885`*^9}, {3.758348889309189*^9, 3.7583489702261887`*^9}, {
   3.7758989543465443`*^9, 3.7758989673311152`*^9}, 3.775901066681061*^9, {
   3.8049285996890736`*^9, 3.8049286115865474`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"a1c1d0c6-5e31-4191-8f55-58ce5cc7946c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d2", " ", 
         RowBox[{"(", 
          RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "e2"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "+", 
        RowBox[{"2", " ", "e1", " ", "f2"}]}], ")"}], " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]], "+", 
    RowBox[{"2", " ", "x", " ", "y"}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"2", "+", "e2"}]]}], ")"}], " ", 
  RowBox[{"p", "[", 
   RowBox[{"1", ",", "1"}], "]"}]}]], "Output",
 CellChangeTimes->{
  3.781335048605611*^9, 3.7813351110976105`*^9, 3.8048712029982786`*^9, 
   3.804911034278362*^9, 3.804924070783474*^9, {3.804928603173554*^9, 
   3.804928612939491*^9}, 3.8049286442167377`*^9, 3.80493073468808*^9, 
   3.80493090091928*^9, 3.8052859665128794`*^9, 3.8056268440158815`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"58730d54-c796-4832-8b74-ff9992aa3dba"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d2", " ", 
           RowBox[{"(", 
            RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", "e2"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "+", 
          RowBox[{"2", " ", "e1", " ", "f2"}]}], ")"}], " ", 
        RowBox[{"p", "[", 
         RowBox[{"1", ",", "1"}], "]"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"p", "[", 
        RowBox[{"1", ",", "1"}], "]"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"p", "[", 
        RowBox[{"1", ",", "1"}], "]"}]}], 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "e1"}], ")"}], " ", 
        RowBox[{"p", "[", 
         RowBox[{"1", ",", "1"}], "]"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}]}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.781335048605611*^9, 3.7813351110976105`*^9, 3.8048712029982786`*^9, 
   3.804911034278362*^9, 3.804924070783474*^9, {3.804928603173554*^9, 
   3.804928612939491*^9}, 3.8049286442167377`*^9, 3.80493073468808*^9, 
   3.80493090091928*^9, 3.8052859665128794`*^9, 3.805626844078382*^9},
 CellLabel->
  "Out[19]//MatrixForm=",ExpressionUUID->"f9943203-2edb-4d62-9bcc-\
7007e33a716e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"d2", " ", 
      RowBox[{"(", 
       RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "e2"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "+", 
     RowBox[{"2", " ", "e1", " ", "f2"}]}], ")"}], " ", 
   RowBox[{"p", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "e2"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.781335048605611*^9, 3.7813351110976105`*^9, 3.8048712029982786`*^9, 
   3.804911034278362*^9, 3.804924070783474*^9, {3.804928603173554*^9, 
   3.804928612939491*^9}, 3.8049286442167377`*^9, 3.80493073468808*^9, 
   3.80493090091928*^9, 3.8052859665128794`*^9, 3.805626844078382*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"d7419095-2847-4be5-83e8-28dcdccf309f"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "e1"}], "-", 
      RowBox[{"2", " ", "d2", " ", "e1"}], "-", 
      RowBox[{"d2", " ", 
       SuperscriptBox["e1", "2"]}], "-", 
      RowBox[{"2", " ", "e2"}], "+", 
      RowBox[{"2", " ", "d2", " ", "e2"}], "-", 
      RowBox[{"e1", " ", "e2"}], "+", 
      RowBox[{"d2", " ", "e1", " ", "e2"}], "+", 
      SuperscriptBox["e2", "2"], "-", 
      RowBox[{"e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      SuperscriptBox["e2", "3"], "-", 
      RowBox[{"2", " ", "f1"}], "-", 
      RowBox[{"e1", " ", "f1"}], "-", 
      RowBox[{"4", " ", "e2", " ", "f1"}], "-", 
      RowBox[{"2", " ", "e1", " ", "e2", " ", "f1"}], "-", 
      RowBox[{"2", " ", "f2"}], "-", 
      RowBox[{"5", " ", "e1", " ", "f2"}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["e1", "2"], " ", "f2"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "1"}], "]"}], "2"]}]}]}]], "Output",
 CellChangeTimes->{
  3.781335048605611*^9, 3.7813351110976105`*^9, 3.8048712029982786`*^9, 
   3.804911034278362*^9, 3.804924070783474*^9, {3.804928603173554*^9, 
   3.804928612939491*^9}, 3.8049286442167377`*^9, 3.80493073468808*^9, 
   3.80493090091928*^9, 3.8052859665128794`*^9, 3.8056268440940075`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"688743b5-ae92-40ba-92e6-c9ff1281bce4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equation (13)", "Subsection",
 CellChangeTimes->{{3.8052859816381173`*^9, 
  3.8052859847944098`*^9}},ExpressionUUID->"c643b525-8424-444b-acb4-\
ddd87d45c43b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "=", "1"}], 
  ";"}], "\[IndentingNewLine]", "qv", "\[IndentingNewLine]", 
 RowBox[{"mat", "//", 
  "MatrixForm"}], "\[IndentingNewLine]", "a11", "\[IndentingNewLine]", \
"det"}], "Input",
 CellChangeTimes->{{3.8049291791959524`*^9, 3.8049292116399918`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"f9d2c9e9-5211-4bf6-8b3f-090b881b5137"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d2", " ", 
         RowBox[{"(", 
          RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "e2"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "+", 
        RowBox[{"2", " ", "e1", " ", "f2"}]}], ")"}], " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]], "+", 
    RowBox[{"2", " ", "x", " ", "y"}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"2", "+", "e2"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8049291934520655`*^9, 3.8049292120963345`*^9}, 
   3.8049307375461273`*^9, 3.8049309034651594`*^9, 3.8052860352950425`*^9, 
   3.805626846906563*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"be97722b-85cd-44f4-973d-5eeba577684a"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox[
       RowBox[{
        RowBox[{"d2", " ", 
         RowBox[{"(", 
          RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "e2"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "+", 
        RowBox[{"2", " ", "e1", " ", "f2"}]}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]], 
      FractionBox["1", "2"]},
     {
      FractionBox["1", "2"], 
      FractionBox[
       RowBox[{"2", "+", "e1"}], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}]}]]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8049291934520655`*^9, 3.8049292120963345`*^9}, 
   3.8049307375461273`*^9, 3.8049309034651594`*^9, 3.8052860352950425`*^9, 
   3.805626846906563*^9},
 CellLabel->
  "Out[25]//MatrixForm=",ExpressionUUID->"9efbf4af-361a-479f-8141-\
d3a2f048314f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"d2", " ", 
    RowBox[{"(", 
     RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "e2"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "+", 
   RowBox[{"2", " ", "e1", " ", "f2"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "e2"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.8049291934520655`*^9, 3.8049292120963345`*^9}, 
   3.8049307375461273`*^9, 3.8049309034651594`*^9, 3.8052860352950425`*^9, 
   3.805626846906563*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"1981b7ed-8822-4044-8918-a79e1d503b59"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "e1", "+", "e2"}], ")"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "e1"}], "-", 
     RowBox[{"2", " ", "d2", " ", "e1"}], "-", 
     RowBox[{"d2", " ", 
      SuperscriptBox["e1", "2"]}], "-", 
     RowBox[{"2", " ", "e2"}], "+", 
     RowBox[{"2", " ", "d2", " ", "e2"}], "-", 
     RowBox[{"e1", " ", "e2"}], "+", 
     RowBox[{"d2", " ", "e1", " ", "e2"}], "+", 
     SuperscriptBox["e2", "2"], "-", 
     RowBox[{"e1", " ", 
      SuperscriptBox["e2", "2"]}], "+", 
     SuperscriptBox["e2", "3"], "-", 
     RowBox[{"2", " ", "f1"}], "-", 
     RowBox[{"e1", " ", "f1"}], "-", 
     RowBox[{"4", " ", "e2", " ", "f1"}], "-", 
     RowBox[{"2", " ", "e1", " ", "e2", " ", "f1"}], "-", 
     RowBox[{"2", " ", "f2"}], "-", 
     RowBox[{"5", " ", "e1", " ", "f2"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["e1", "2"], " ", "f2"}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.8049291934520655`*^9, 3.8049292120963345`*^9}, 
   3.8049307375461273`*^9, 3.8049309034651594`*^9, 3.8052860352950425`*^9, 
   3.8056268469221735`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"aba760cd-a81a-452d-b68e-e65ee7f2e41a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conditions for a positive definite quadratic form", "Subsection",
 CellChangeTimes->{{3.7759011170663643`*^9, 3.775901128879036*^9}, 
   3.775908452328379*^9, 
   3.804871327437459*^9},ExpressionUUID->"c98fc134-0c7c-42d0-b7b4-\
c74684e9bf75"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d1", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"d2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}]}], "+", 
     RowBox[{"c1", " ", 
      RowBox[{"(", 
       RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", "f1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", "f2"}]}], 
    RowBox[{"2", "+", "e2"}]]}], ";", 
  RowBox[{"y0", "=", 
   FractionBox[
    RowBox[{"c1", "+", "d2", "+", "f2"}], 
    RowBox[{"2", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c1", "=", 
   FractionBox[
    RowBox[{"d2", "-", 
     RowBox[{"d2", " ", "e1"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "-", 
     RowBox[{"e1", " ", "f2"}]}], 
    RowBox[{"1", "+", "e1", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"beta", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", "e1", "+", "e2"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "e1"}], "+", 
      RowBox[{"2", " ", "d2", " ", "e1"}], "+", 
      RowBox[{"d2", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"2", " ", "e2"}], "-", 
      RowBox[{"2", " ", "d2", " ", "e2"}], "+", 
      RowBox[{"e1", " ", "e2"}], "-", 
      RowBox[{"d2", " ", "e1", " ", "e2"}], "-", 
      SuperscriptBox["e2", "2"], "+", 
      RowBox[{"e1", " ", 
       SuperscriptBox["e2", "2"]}], "-", 
      SuperscriptBox["e2", "3"], "+", 
      RowBox[{"2", " ", "f1"}], "+", 
      RowBox[{"e1", " ", "f1"}], "+", 
      RowBox[{"4", " ", "e2", " ", "f1"}], "+", 
      RowBox[{"2", " ", "e1", " ", "e2", " ", "f1"}], "+", 
      RowBox[{"2", " ", "f2"}], "+", 
      RowBox[{"5", " ", "e1", " ", "f2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e1", "2"], " ", "f2"}]}], ")"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8056267946079473`*^9, 3.8056268059518476`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"b4795396-7c94-42ce-9726-61a6658c2792"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}], "&&", 
     RowBox[{"f1", ">", "0"}], " ", "&&", 
     RowBox[{"f2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e1", ",", "e2", ",", "f1", ",", "f2"}], "}"}]}], " ",
    "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7522588869152946`*^9, 3.7522589092589407`*^9}, {
  3.752344128021044*^9, 3.7523441334434032`*^9}, {3.752344196070758*^9, 
  3.75234422928652*^9}, {3.752344272013405*^9, 3.7523442793106003`*^9}, {
  3.7523444559734364`*^9, 3.752344459032919*^9}, {3.7523445978488703`*^9, 
  3.752344649539791*^9}, {3.75826596047843*^9, 3.758265964710492*^9}, {
  3.7759015419995365`*^9, 3.775901584797058*^9}, {3.7759016400947328`*^9, 
  3.775901681485958*^9}, {3.7759017813268013`*^9, 3.775901781623681*^9}, {
  3.7759018297181273`*^9, 3.775901861468588*^9}, {3.804871225998637*^9, 
  3.804871252186487*^9}, {3.8049309208174925`*^9, 3.804930924421055*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"6055a911-4c06-4bec-94e0-29d4910a02f4"],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.781335056615611*^9, 3.804871308109047*^9, 
  3.804931087316807*^9, 3.805286055014057*^9, 3.8056268721725054`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"35d90608-06aa-42dc-bc8d-65477c334d48"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting f1 and f2: Equation (14)", "Subsection",
 CellChangeTimes->{{3.775908460219133*^9, 3.7759084686724176`*^9}, 
   3.804936275759486*^9, 3.8052860581235085`*^9, {3.8056294298639956`*^9, 
   3.805629454754951*^9}},ExpressionUUID->"2b6f9372-0df5-4b89-8de2-\
a3cdb63dbd29"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"f1", ",", "f2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f1", "=", "1"}], ";", 
  RowBox[{"f2", "=", "2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.775902086912055*^9, 3.7759020999622154`*^9}, {
  3.8049311586745214`*^9, 3.8049311709632573`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"81cf8e51-12a2-4b15-a276-a596b2852a9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e1", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.7522588869152946`*^9, 3.7522589092589407`*^9}, {
  3.752344128021044*^9, 3.7523441334434032`*^9}, {3.752344196070758*^9, 
  3.75234422928652*^9}, {3.752344272013405*^9, 3.7523442793106003`*^9}, {
  3.7523444559734364`*^9, 3.752344459032919*^9}, {3.7523445978488703`*^9, 
  3.752344649539791*^9}, {3.75826596047843*^9, 3.758265964710492*^9}, {
  3.7759015419995365`*^9, 3.775901584797058*^9}, {3.7759016400947328`*^9, 
  3.775901681485958*^9}, {3.7759017813268013`*^9, 3.775901781623681*^9}, {
  3.7759018297181273`*^9, 3.775901861468588*^9}, {3.7759021080717087`*^9, 
  3.7759021155092907`*^9}, {3.8048714385170603`*^9, 3.8048714842520285`*^9}, {
  3.8049110619289236`*^9, 3.804911064878293*^9}, {3.804931181202532*^9, 
  3.8049311827666616`*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"e9340da9-0434-4227-a718-7c71f81fd95d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"e2", ">", "0"}], "&&", 
    RowBox[{
     SqrtBox[
      RowBox[{"9", "+", 
       RowBox[{"4", " ", "d2"}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "d2"}], ")"}], " ", "e1"}]}]], ">", 
     RowBox[{"5", "+", 
      RowBox[{"2", " ", "e2"}]}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"e1", ">", "0"}], "&&", 
        RowBox[{"d2", ">", "4"}], "&&", 
        RowBox[{
         RowBox[{"9", " ", "d2"}], "\[LessEqual]", 
         RowBox[{"26", "+", 
          RowBox[{"7", " ", 
           SqrtBox["34"]}]}]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"9", " ", "d2"}], ">", 
         RowBox[{"26", "+", 
          RowBox[{"7", " ", 
           SqrtBox["34"]}]}]}], "&&", 
        RowBox[{
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"110", "+", 
             RowBox[{"52", " ", "d2"}], "-", 
             RowBox[{"9", " ", 
              SuperscriptBox["d2", "2"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"69", "+", 
                RowBox[{"64", " ", "d2"}], "+", 
                RowBox[{"9", " ", 
                 SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "12"}], "-", 
                RowBox[{"8", " ", "d2"}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
         "\[LessEqual]", "e1", "<", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", "d2"}], 
          RowBox[{"2", "+", "d2"}]]}]}], ")"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "e1", "<", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"110", "+", 
         RowBox[{"52", " ", "d2"}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["d2", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"69", "+", 
            RowBox[{"64", " ", "d2"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "-", 
            RowBox[{"8", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{"0", "<", "e2", "<", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "6"}], "-", 
         RowBox[{"9", " ", "e1"}], "-", 
         RowBox[{"2", " ", "d2", " ", "e1"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["e1", "2"]}], "-", 
         RowBox[{"d2", " ", 
          SuperscriptBox["e1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "+", 
            RowBox[{"2", " ", "d2"}], "-", 
            RowBox[{"3", " ", "e1"}], "+", 
            RowBox[{"d2", " ", "e1"}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "e1"}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{
     RowBox[{"9", " ", "d2"}], ">", 
     RowBox[{"26", "+", 
      RowBox[{"7", " ", 
       SqrtBox["34"]}]}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.7813350705486107`*^9, 3.7813351303376107`*^9, {3.804871460861094*^9, 
   3.8048714903365307`*^9}, {3.8048718667408123`*^9, 3.804871890022369*^9}, 
   3.804911160923834*^9, 3.8049312127139463`*^9, 3.8052860875144863`*^9, 
   3.8056268846883135`*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"7117bf22-806f-48b4-b2fc-db187181ff45"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Degree 3", "Subsection",
 CellChangeTimes->{{3.7759085369702816`*^9, 3.775908538392175*^9}, 
   3.8049362703716564`*^9},ExpressionUUID->"f74daba7-1645-469b-90a1-\
8250d51ca8b7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ls", "[", "3", "]"}], "//", "Factor"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol3", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ls", "[", "3", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"Hom", "[", "3", "]"}]}], "]"}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"3", ",", "0"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"0", ",", "3"}], "]"}]}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"3", ",", "0"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"2", ",", "1"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"1", ",", "2"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"0", ",", "3"}], "]"}]}], "}"}], "/.", 
     RowBox[{"sol3", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
     "//", "Factor"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ls", "[", "3", "]"}], "//", "Simplify"}]}], "Input",
 CellLabel->"In[35]:=",ExpressionUUID->"3691fa4d-502f-4182-be2a-9ad530d556e3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.7813350754756107`*^9, 3.7813351344376106`*^9, 
  3.804871898381854*^9, 3.8049112203614397`*^9, 3.804931239382882*^9, 
  3.805286106530363*^9, 3.8056268881258593`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"67d106d8-35d4-4f42-9623-a6174fe2d420"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Degree 4: Equation (15)", "Subsection",
 CellChangeTimes->{{3.775908601205589*^9, 3.775908602221202*^9}, 
   3.80493626922184*^9, {3.8052861762969537`*^9, 
   3.8052861825314107`*^9}},ExpressionUUID->"817f5d50-d5be-455c-a84e-\
0975256b214f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ls", "[", "4", "]"}], "//", "Factor"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol4", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ls", "[", "4", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{"AppendTo", "[", 
      RowBox[{
       RowBox[{"Hom", "[", "4", "]"}], ",", "g1"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"g1", ",", 
     RowBox[{"p", "[", 
      RowBox[{"4", ",", "0"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"2", ",", "2"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "3"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"0", ",", "4"}], "]"}]}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"g1", ",", 
      RowBox[{"p", "[", 
       RowBox[{"4", ",", "0"}], "]"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"3", ",", "1"}], "]"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"2", ",", "2"}], "]"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"1", ",", "3"}], "]"}], ",", 
      RowBox[{"p", "[", 
       RowBox[{"0", ",", "4"}], "]"}]}], "}"}], "/.", 
    RowBox[{
    "sol4", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"g1", "//", "Factor"}]}], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"c6f6eb22-3f85-4159-a9d9-d321140a9020"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    40, 2, 20771761113813511231, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.781335140039611*^9, 3.8048719081007514`*^9, 
  3.80491122481417*^9, 3.804931245815454*^9, 3.805286198937841*^9, 
  3.8056268918446455`*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"3e0043ea-3f34-41ad-a982-b2efdc553cfc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "36"}], "-", 
    RowBox[{"105", " ", "e1"}], "-", 
    RowBox[{"30", " ", "d2", " ", "e1"}], "-", 
    RowBox[{"120", " ", 
     SuperscriptBox["e1", "2"]}], "-", 
    RowBox[{"50", " ", "d2", " ", 
     SuperscriptBox["e1", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"]}], "-", 
    RowBox[{"56", " ", 
     SuperscriptBox["e1", "3"]}], "-", 
    RowBox[{"28", " ", "d2", " ", 
     SuperscriptBox["e1", "3"]}], "-", 
    RowBox[{"7", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["e1", "4"]}], "-", 
    RowBox[{"6", " ", "d2", " ", 
     SuperscriptBox["e1", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"]}], "-", 
    RowBox[{"75", " ", "e2"}], "+", 
    RowBox[{"12", " ", "d2", " ", "e2"}], "-", 
    RowBox[{"159", " ", "e1", " ", "e2"}], "-", 
    RowBox[{"8", " ", "d2", " ", "e1", " ", "e2"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", "e2"}], "-", 
    RowBox[{"113", " ", 
     SuperscriptBox["e1", "2"], " ", "e2"}], "-", 
    RowBox[{"9", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", "e2"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", "e2"}], "-", 
    RowBox[{"18", " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "-", 
    RowBox[{"d2", " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "-", 
    RowBox[{"36", " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"13", " ", "d2", " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"65", " ", "e1", " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"18", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"30", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"4", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"d2", " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"6", " ", "e1", " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"7", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"4", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"7", " ", "e1", " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"2", " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", "e2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"123", "+", 
      RowBox[{"234", " ", "e1"}], "+", 
      RowBox[{"34", " ", "d2", " ", "e1"}], "+", 
      RowBox[{"137", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"30", " ", "d2", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["d2", "2"], " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["e1", "3"]}], "+", 
      RowBox[{"2", " ", "d2", " ", 
       SuperscriptBox["e1", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["e1", "4"]}], "+", 
      RowBox[{"330", " ", "e2"}], "-", 
      RowBox[{"34", " ", "d2", " ", "e2"}], "+", 
      RowBox[{"348", " ", "e1", " ", "e2"}], "+", 
      RowBox[{"16", " ", "d2", " ", "e1", " ", "e2"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["d2", "2"], " ", "e1", " ", "e2"}], "+", 
      RowBox[{"68", " ", 
       SuperscriptBox["e1", "2"], " ", "e2"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["e1", "3"], " ", "e2"}], "+", 
      RowBox[{"307", " ", 
       SuperscriptBox["e2", "2"]}], "-", 
      RowBox[{"46", " ", "d2", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["d2", "2"], " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"126", " ", "e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"10", " ", "d2", " ", "e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["e1", "2"], " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"116", " ", 
       SuperscriptBox["e2", "3"]}], "-", 
      RowBox[{"12", " ", "d2", " ", 
       SuperscriptBox["e2", "3"]}], "+", 
      RowBox[{"12", " ", "e1", " ", 
       SuperscriptBox["e2", "3"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["e2", "4"]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7813351400646105`*^9, 3.804871908132003*^9, 
  3.8049112248454027`*^9, 3.8049312458514814`*^9, 3.8052861989690742`*^9, 
  3.8056268918602705`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"4b5930fe-a0ab-4d16-9b7f-3207a6663ab0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", "g1", "]"}]], "Input",
 CellChangeTimes->{{3.7759087563484354`*^9, 3.7759087590515814`*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"a9560953-87b8-4362-92d6-afc7b2f1ecfb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e2", ",", "e1", ",", "d2"}], "}"}]], "Output",
 CellChangeTimes->{3.781335142346611*^9, 3.804871912460184*^9, 
  3.8049112283446703`*^9, 3.804931254086335*^9, 3.805286199625333*^9, 
  3.805626893985298*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"85ea1fad-81d0-4194-b291-ec508168ecfe"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Degree 5", "Subsection",
 CellChangeTimes->{{3.7759090335555773`*^9, 3.7759090379774895`*^9}, 
   3.8049362640441723`*^9},ExpressionUUID->"7e64bf41-90a1-46df-8c3b-\
9ba4d2f509c8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ls", "[", "5", "]"}], "//", "Factor"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol5", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ls", "[", "5", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{"Hom", "[", "5", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"5", ",", "0"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"4", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"3", ",", "2"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "4"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"0", ",", "5"}], "]"}]}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"5", ",", "0"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"4", ",", "1"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"3", ",", "2"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"2", ",", "3"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"1", ",", "4"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"0", ",", "5"}], "]"}]}], "}"}], "/.", 
     RowBox[{"sol5", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
     "//", "Factor"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ls", "[", "5", "]"}], "//", "Factor"}]}], "Input",
 CellChangeTimes->{{3.7582796554290504`*^9, 3.758279663734398*^9}, {
   3.758962948031547*^9, 3.758962948550599*^9}, 3.758964989094252*^9, {
   3.7589683639912434`*^9, 3.7589683788242435`*^9}, {3.7589684498412433`*^9, 
   3.758968490303243*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"56be19eb-48a7-449e-b0f0-e6571364efea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.781335184843611*^9, 3.80487194028868*^9, 
  3.8049112570174*^9, 3.8049356846127353`*^9, 3.8052862484853764`*^9, 
  3.805626919579403*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"ac76ef14-bda9-418f-b488-74ee21243e95"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Degree 6", "Subsection",
 CellChangeTimes->{{3.7759090794468403`*^9, 3.775909080446906*^9}, 
   3.804936259991291*^9, {3.8052863411306534`*^9, 3.8052863473963623`*^9}, {
   3.8056295370216684`*^9, 
   3.8056295371466703`*^9}},ExpressionUUID->"a5bdbe8e-c48d-4383-914c-\
c6c4c70444c2"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ls", "[", "6", "]"}], "//", "Factor"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol6", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ls", "[", "6", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{"AppendTo", "[", 
      RowBox[{
       RowBox[{"Hom", "[", "6", "]"}], ",", "g2"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"6", ",", "0"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"5", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"4", ",", "2"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"3", ",", "3"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"2", ",", "4"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "5"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"0", ",", "6"}], "]"}], ",", "g2"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"p", "[", 
        RowBox[{"6", ",", "0"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"5", ",", "1"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"4", ",", "2"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"3", ",", "3"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"2", ",", "4"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"1", ",", "5"}], "]"}], ",", 
       RowBox[{"p", "[", 
        RowBox[{"0", ",", "6"}], "]"}], ",", "g2"}], "}"}], "/.", 
     RowBox[{"sol6", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}],
     "//", "Factor"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.775909093150191*^9, 3.7759091178693247`*^9}, {
   3.7759091575886116`*^9, 3.775909159135548*^9}, 3.7759698900086846`*^9, 
   3.7759952826101217`*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"7b95c8ab-ed47-4987-813d-200fb19efae8"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    49, 3, 20771761113813511231, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.78133524049574*^9, 3.804871993921272*^9, 
  3.804911283166521*^9, 3.8049357090060716`*^9, 3.805286381334258*^9, 
  3.8056269449307814`*^9},
 CellLabel->
  "During evaluation of \
In[48]:=",ExpressionUUID->"0237f0a1-d3c4-47c2-bc0c-842ab2271bed"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"g2", "\[IndentingNewLine]", 
 RowBox[{"Variables", "[", "g2", "]"}]}], "Input",
 CellChangeTimes->{{3.804872168201151*^9, 3.804872190420196*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"cb88706c-1ad9-4d9f-bb23-f8559139619b"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "8713008"}], "-", 
            RowBox[{"80227908", " ", "e1"}], "-", 
            RowBox[{"18633240", " ", "d2", " ", "e1"}], "-", 
            RowBox[{"337874976", " ", 
             SuperscriptBox["e1", "2"]}], "-", 
            RowBox[{"157906260", " ", "d2", " ", 
             SuperscriptBox["e1", "2"]}], "+", 
            TemplateBox[{"3685"},
             "OutputSizeLimit`Skeleton"], "+", 
            RowBox[{"288", " ", "d2", " ", "e1", " ", 
             SuperscriptBox["e2", "19"], " ", 
             RowBox[{"p", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "+", 
            RowBox[{"864", " ", 
             SuperscriptBox["e1", "2"], " ", 
             SuperscriptBox["e2", "19"], " ", 
             RowBox[{"p", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "-", 
            RowBox[{"384", " ", "e1", " ", 
             SuperscriptBox["e2", "20"], " ", 
             RowBox[{"p", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"3", " ", 
            TemplateBox[{"5"},
             "OutputSizeLimit`Skeleton"], " ", 
            RowBox[{"(", 
             RowBox[{"173", "+", 
              RowBox[{"310", " ", "e1"}], "+", 
              RowBox[{"46", " ", "d2", " ", "e1"}], "+", 
              RowBox[{"159", " ", 
               SuperscriptBox["e1", "2"]}], "+", 
              RowBox[{"34", " ", "d2", " ", 
               SuperscriptBox["e1", "2"]}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["d2", "2"], " ", 
               SuperscriptBox["e1", "2"]}], "+", 
              RowBox[{"22", " ", 
               SuperscriptBox["e1", "3"]}], "-", 
              RowBox[{"2", " ", "d2", " ", 
               SuperscriptBox["e1", "3"]}], "+", 
              TemplateBox[{"14"},
               "OutputSizeLimit`Skeleton"], "+", 
              RowBox[{"194", " ", "e1", " ", 
               SuperscriptBox["e2", "2"]}], "+", 
              RowBox[{"22", " ", "d2", " ", "e1", " ", 
               SuperscriptBox["e2", "2"]}], "+", 
              RowBox[{"13", " ", 
               SuperscriptBox["e1", "2"], " ", 
               SuperscriptBox["e2", "2"]}], "+", 
              RowBox[{"204", " ", 
               SuperscriptBox["e2", "3"]}], "-", 
              RowBox[{"20", " ", "d2", " ", 
               SuperscriptBox["e2", "3"]}], "+", 
              RowBox[{"20", " ", "e1", " ", 
               SuperscriptBox["e2", "3"]}], "+", 
              RowBox[{"32", " ", 
               SuperscriptBox["e2", "4"]}]}], ")"}]}], ")"}]}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{47.16, {3., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{38.28, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 51, 20771761113813511231, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{44.879999999999995`, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 51, 20771761113813511231, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{33., {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 51, 20771761113813511231, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{57.36, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[20771761113813511231 === $SessionID, 
   Out[51], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{{3.8048721701699286`*^9, 3.8048721955296426`*^9}, 
   3.804911502625533*^9, 3.8049358869761553`*^9, 3.8052864670541477`*^9, 
   3.805627151794461*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"deb4b4fb-acc3-425f-9688-ecaa4d21bd13"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e2", ",", "e1", ",", "d2", ",", 
   RowBox[{"p", "[", 
    RowBox[{"2", ",", "2"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8048721701699286`*^9, 3.8048721955296426`*^9}, 
   3.804911502625533*^9, 3.8049358869761553`*^9, 3.8052864670541477`*^9, 
   3.8056271518100863`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"3f700fa9-808d-4859-ab89-11829876ebc1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"2", ",", "2"}], "]"}], "=", "0"}], 
  ";"}], "\[IndentingNewLine]", "g2"}], "Input",
 CellChangeTimes->{3.7759202811574726`*^9, 3.775967529296018*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"b5cbacc5-2aad-4254-95b2-da1d003e49ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "8713008"}], "-", 
    RowBox[{"80227908", " ", "e1"}], "-", 
    RowBox[{"18633240", " ", "d2", " ", "e1"}], "-", 
    RowBox[{"337874976", " ", 
     SuperscriptBox["e1", "2"]}], "-", 
    RowBox[{"157906260", " ", "d2", " ", 
     SuperscriptBox["e1", "2"]}], "+", 
    RowBox[{"10405584", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"]}], "-", 
    RowBox[{"858336669", " ", 
     SuperscriptBox["e1", "3"]}], "-", 
    RowBox[{"589383162", " ", "d2", " ", 
     SuperscriptBox["e1", "3"]}], "+", 
    RowBox[{"81932364", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"]}], "+", 
    RowBox[{"35785800", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"]}], "-", 
    RowBox[{"1455557742", " ", 
     SuperscriptBox["e1", "4"]}], "-", 
    RowBox[{"1270911195", " ", "d2", " ", 
     SuperscriptBox["e1", "4"]}], "+", 
    RowBox[{"338227632", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"]}], "+", 
    RowBox[{"238457340", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"]}], "+", 
    RowBox[{"26009424", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"]}], "-", 
    RowBox[{"1714693617", " ", 
     SuperscriptBox["e1", "5"]}], "-", 
    RowBox[{"1717841574", " ", "d2", " ", 
     SuperscriptBox["e1", "5"]}], "+", 
    RowBox[{"904365423", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"]}], "+", 
    RowBox[{"745432494", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"]}], "+", 
    RowBox[{"150039924", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"]}], "+", 
    RowBox[{"8948856", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"]}], "-", 
    RowBox[{"1403037225", " ", 
     SuperscriptBox["e1", "6"]}], "-", 
    RowBox[{"1430020437", " ", "d2", " ", 
     SuperscriptBox["e1", "6"]}], "+", 
    RowBox[{"1658108088", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"]}], "+", 
    RowBox[{"1429256853", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"]}], "+", 
    RowBox[{"394437648", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"]}], "+", 
    RowBox[{"44281668", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"]}], "+", 
    RowBox[{"1629936", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"]}], "-", 
    RowBox[{"753154923", " ", 
     SuperscriptBox["e1", "7"]}], "-", 
    RowBox[{"571000407", " ", "d2", " ", 
     SuperscriptBox["e1", "7"]}], "+", 
    RowBox[{"2138076514", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"]}], "+", 
    RowBox[{"1847954158", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"]}], "+", 
    RowBox[{"619008217", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"]}], "+", 
    RowBox[{"97449906", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"]}], "+", 
    RowBox[{"6784644", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"]}], "+", 
    RowBox[{"151896", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"]}], "-", 
    RowBox[{"201488607", " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"176674539", " ", "d2", " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"1964402861", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"1675435460", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"637982800", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"124624471", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"12217264", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"516884", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"5664", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "8"]}], "+", 
    RowBox[{"45046070", " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"410515867", " ", "d2", " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"1291006512", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"1078650079", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"448156039", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"101413810", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"12361701", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"734362", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"15104", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "9"]}], "+", 
    RowBox[{"73953039", " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"290416646", " ", "d2", " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"605333406", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"491519448", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"216082317", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"54029895", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"7614724", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"559151", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"16048", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "10"]}], "+", 
    RowBox[{"39444242", " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"124911469", " ", "d2", " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"202103664", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"156681114", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"70584675", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"18688281", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"2880292", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"241766", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"8496", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "11"]}], "+", 
    RowBox[{"13797268", " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"37546770", " ", "d2", " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"48855466", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"34754854", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"15245395", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"4031419", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"637195", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"56978", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"2242", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "12"]}], "+", 
    RowBox[{"3612332", " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"8545648", " ", "d2", " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"9068950", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"5576280", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"2166702", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"509183", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"72324", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"6043", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"236", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "13"]}], "+", 
    RowBox[{"683128", " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"1465890", " ", "d2", " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"1361350", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"717156", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"224683", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"38432", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"3266", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"110", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "14"]}], "+", 
    RowBox[{"75592", " ", 
     SuperscriptBox["e1", "15"]}], "+", 
    RowBox[{"159856", " ", "d2", " ", 
     SuperscriptBox["e1", "15"]}], "+", 
    RowBox[{"144656", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "15"]}], "+", 
    RowBox[{"71084", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "15"]}], "+", 
    RowBox[{"19220", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "15"]}], "+", 
    RowBox[{"2527", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "15"]}], "+", 
    RowBox[{"120", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "15"]}], "+", 
    RowBox[{"3360", " ", 
     SuperscriptBox["e1", "16"]}], "+", 
    RowBox[{"7560", " ", "d2", " ", 
     SuperscriptBox["e1", "16"]}], "+", 
    RowBox[{"7000", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "16"]}], "+", 
    RowBox[{"3290", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "16"]}], "+", 
    RowBox[{"770", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "16"]}], "+", 
    RowBox[{"70", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "16"]}], "-", 
    RowBox[{"88993404", " ", "e2"}], "+", 
    RowBox[{"13996800", " ", "d2", " ", "e2"}], "-", 
    RowBox[{"752016960", " ", "e1", " ", "e2"}], "-", 
    RowBox[{"38543688", " ", "d2", " ", "e1", " ", "e2"}], "+", 
    RowBox[{"27026784", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", "e2"}], "-", 
    RowBox[{"2879856747", " ", 
     SuperscriptBox["e1", "2"], " ", "e2"}], "-", 
    RowBox[{"710317836", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", "e2"}], "+", 
    RowBox[{"294699708", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", "e2"}], "-", 
    RowBox[{"9078480", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", "e2"}], "-", 
    RowBox[{"6560854011", " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "-", 
    RowBox[{"2690010594", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "+", 
    RowBox[{"1362536496", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "+", 
    RowBox[{"170160336", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "-", 
    RowBox[{"32737824", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", "e2"}], "-", 
    RowBox[{"9773607069", " ", 
     SuperscriptBox["e1", "4"], " ", "e2"}], "-", 
    RowBox[{"5096266209", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", "e2"}], "+", 
    RowBox[{"3886383267", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", "e2"}], "+", 
    RowBox[{"1154539896", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", "e2"}], "-", 
    RowBox[{"54369156", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", "e2"}], "-", 
    RowBox[{"19467744", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", "e2"}], "-", 
    RowBox[{"9794939382", " ", 
     SuperscriptBox["e1", "5"], " ", "e2"}], "-", 
    RowBox[{"5333357403", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", "e2"}], "+", 
    RowBox[{"7619896587", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", "e2"}], "+", 
    RowBox[{"3266720088", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", "e2"}], "+", 
    RowBox[{"168392016", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", "e2"}], "-", 
    RowBox[{"61122504", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", "e2"}], "-", 
    RowBox[{"5049888", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", "e2"}], "-", 
    RowBox[{"6441412836", " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "-", 
    RowBox[{"2449443015", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "+", 
    RowBox[{"10571887718", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "+", 
    RowBox[{"5438835483", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "+", 
    RowBox[{"695706763", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "-", 
    RowBox[{"66594060", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "-", 
    RowBox[{"16669884", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "-", 
    RowBox[{"613584", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "6"], " ", "e2"}], "-", 
    RowBox[{"2414718978", " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "+", 
    RowBox[{"1016061140", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "+", 
    RowBox[{"10416164334", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "+", 
    RowBox[{"5901303257", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "+", 
    RowBox[{"1107789093", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "-", 
    RowBox[{"9732938", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "-", 
    RowBox[{"23271568", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "-", 
    RowBox[{"1881280", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "-", 
    RowBox[{"28320", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "7"], " ", "e2"}], "-", 
    RowBox[{"110539434", " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "+", 
    RowBox[{"2330972212", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "+", 
    RowBox[{"7229319646", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "+", 
    RowBox[{"4318013999", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "+", 
    RowBox[{"1012688955", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "+", 
    RowBox[{"44466269", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "-", 
    RowBox[{"17803635", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "-", 
    RowBox[{"2428832", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "-", 
    RowBox[{"75520", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "8"], " ", "e2"}], "+", 
    RowBox[{"405218849", " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "+", 
    RowBox[{"1664150341", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "+", 
    RowBox[{"3470424720", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "+", 
    RowBox[{"2130918642", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "+", 
    RowBox[{"576913058", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "+", 
    RowBox[{"46399843", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "-", 
    RowBox[{"8101763", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "-", 
    RowBox[{"1701260", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "-", 
    RowBox[{"80240", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "9"], " ", "e2"}], "+", 
    RowBox[{"239910826", " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "+", 
    RowBox[{"679422209", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "+", 
    RowBox[{"1120948905", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "+", 
    RowBox[{"691162347", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "+", 
    RowBox[{"205066302", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "+", 
    RowBox[{"21531455", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "-", 
    RowBox[{"2268800", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "-", 
    RowBox[{"689151", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "-", 
    RowBox[{"42480", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "10"], " ", "e2"}], "+", 
    RowBox[{"79358760", " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "+", 
    RowBox[{"181806640", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "+", 
    RowBox[{"238215342", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "+", 
    RowBox[{"140305887", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "+", 
    RowBox[{"42995125", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "+", 
    RowBox[{"4941564", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "-", 
    RowBox[{"421838", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "-", 
    RowBox[{"156841", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "-", 
    RowBox[{"11210", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "11"], " ", "e2"}], "+", 
    RowBox[{"20337633", " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "+", 
    RowBox[{"37875499", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "+", 
    RowBox[{"35310184", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "+", 
    RowBox[{"17163580", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "+", 
    RowBox[{"4657433", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "+", 
    RowBox[{"410185", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "-", 
    RowBox[{"64852", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "-", 
    RowBox[{"17227", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "-", 
    RowBox[{"1180", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "12"], " ", "e2"}], "+", 
    RowBox[{"4332374", " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "+", 
    RowBox[{"7037529", " ", "d2", " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "+", 
    RowBox[{"4730223", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "+", 
    RowBox[{"1571858", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "+", 
    RowBox[{"228117", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "-", 
    RowBox[{"21692", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "-", 
    RowBox[{"8259", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "-", 
    RowBox[{"518", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "13"], " ", "e2"}], "+", 
    RowBox[{"576808", " ", 
     SuperscriptBox["e1", "14"], " ", "e2"}], "+", 
    RowBox[{"922040", " ", "d2", " ", 
     SuperscriptBox["e1", "14"], " ", "e2"}], "+", 
    RowBox[{"583383", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "14"], " ", "e2"}], "+", 
    RowBox[{"174173", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "14"], " ", "e2"}], "+", 
    RowBox[{"17658", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "14"], " ", "e2"}], "-", 
    RowBox[{"2617", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "14"], " ", "e2"}], "-", 
    RowBox[{"400", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "14"], " ", "e2"}], "+", 
    RowBox[{"30360", " ", 
     SuperscriptBox["e1", "15"], " ", "e2"}], "+", 
    RowBox[{"51680", " ", "d2", " ", 
     SuperscriptBox["e1", "15"], " ", "e2"}], "+", 
    RowBox[{"34130", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "15"], " ", "e2"}], "+", 
    RowBox[{"10095", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "15"], " ", "e2"}], "+", 
    RowBox[{"945", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "15"], " ", "e2"}], "-", 
    RowBox[{"70", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "15"], " ", "e2"}], "-", 
    RowBox[{"412722864", " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"123249600", " ", "d2", " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"8785584", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"3193953444", " ", "e1", " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"362974608", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"129544596", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"14999256", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"11082897738", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"440355204", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"1409779944", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"166705236", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"3173472", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"22502444436", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"3175160004", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"5737565025", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"84757098", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"152017464", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"11645328", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"29122036605", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"4682685285", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"13993017060", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"1519403265", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"515540064", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"18695784", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"5347536", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"24291178713", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"639947649", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"23007150192", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"5012633502", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"604978154", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"136057620", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"8856804", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"935304", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"12139457193", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"6406695085", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"26349269788", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"8016293046", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"87975162", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"221448010", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"1015576", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"2352828", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"56640", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"2370149963", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"9372684057", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"21068515940", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"7814370907", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"528600834", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"165858512", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"11708611", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"2413710", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"151040", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"1051299548", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"6721450264", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"11599420704", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"4931946196", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"651850653", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"50395731", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"9667904", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"1351309", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"160480", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"896150928", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"2829857255", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"4280870807", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"2031202343", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"387936500", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"10114987", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"2516702", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"502730", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"84960", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"302293030", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"736640746", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"1023719107", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"534306796", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"133327559", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"13377761", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"528804", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"152286", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"22420", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"72143105", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"136252541", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"158772321", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"86875594", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"26532888", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"4284456", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"423047", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"35465", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"2360", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"17008885", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"25234466", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"19640206", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"9201488", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"2906217", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"566276", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"70578", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"4018", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"3136806", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"4466176", " ", "d2", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"2741463", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"946719", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"201599", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"24275", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"1660", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"298712", " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"468192", " ", "d2", " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"303467", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"101066", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"16728", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"1010", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"10080", " ", 
     SuperscriptBox["e1", "15"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"19040", " ", "d2", " ", 
     SuperscriptBox["e1", "15"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"13860", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "15"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"4550", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "15"], " ", 
     SuperscriptBox["e2", "2"]}], "+", 
    RowBox[{"560", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "15"], " ", 
     SuperscriptBox["e2", "2"]}], "-", 
    RowBox[{"1144849464", " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"485208576", " ", "d2", " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"65642940", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"2685312", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"8101716174", " ", "e1", " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"2123568468", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"168190416", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"74001528", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"3953664", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"25367896629", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"3886286364", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"2852738037", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"690025740", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"40845432", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"659424", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"45496626822", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"5540735145", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"11128954755", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"1597976790", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"209276256", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"42032160", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"2042496", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"50231049501", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"11170622970", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"24590006218", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"941938709", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"961778338", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"66614592", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"5543268", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"643296", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"33413543811", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"21148376595", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"35638124420", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"2205631443", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"1503271576", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"35871356", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"20078096", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"936264", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"56640", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"10853237767", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"26089127342", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"35244071070", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"5309307093", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"1126914199", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"160511646", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"18379341", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"51140", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"151040", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"1086089395", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"20029778950", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"23855046334", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"5452022105", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"310744390", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"156265469", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"3458859", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"423366", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"160480", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"2470883453", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"9550268886", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"10848472197", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"3254598558", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"129794755", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"71969042", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"4662926", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"35447", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"84960", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"971252899", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"2770207966", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"3184987040", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"1176631613", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"133147188", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"15562794", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"3532924", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"190219", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"22420", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"203381328", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"479768387", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"563429608", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"244410565", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"41524515", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"1034435", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"1036656", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"94329", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"2360", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"38885299", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"59301566", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"55659294", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"24570935", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"4751976", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"29054", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"130974", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"13634", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"8765501", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"9485440", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"4296459", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"840936", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"35046", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"41844", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"4376", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"1254424", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"1458845", " ", "d2", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"612518", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"83017", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"11902", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"2810", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"67520", " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"90460", " ", "d2", " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"41880", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "3"]}], "+", 
    RowBox[{"6405", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"140", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "3"]}], "-", 
    RowBox[{"2100745152", " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1121159016", " ", "d2", " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"214757208", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"16605792", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"398736", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"13589760366", " ", "e1", " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"5366329956", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"232507908", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"138893856", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"17459076", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"490440", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"38180767320", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"12730356918", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"2468141142", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"1290054768", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"135656640", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"4811100", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"92112", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"59584719675", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"23006383233", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"10875298703", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"3562135500", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"26508365", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"51884226", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"4841172", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"175464", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"54118574043", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"36471358790", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"23337857097", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"4744620090", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"674408402", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"137562399", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"4736632", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"248564", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"28320", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"25591758519", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"45645609664", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"31456890457", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"2804899887", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"1357469961", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"105520098", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"7536587", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"1058570", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"75520", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"1386397268", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"39904259538", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"28208550416", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"436395134", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"1213491636", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"9912521", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"13891126", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"751639", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"80240", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"5198353098", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"22899549508", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"16896930914", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1868018813", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"542504677", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"58712367", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"8019423", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"152122", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"42480", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"2786160565", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"8245032955", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"6586948619", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1317318936", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"81971709", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"32373291", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"2011999", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"380606", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"11210", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"636883413", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1747413368", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1575993758", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"459347674", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"27429781", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"5362718", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"323945", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"155701", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1180", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"82334202", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"203843601", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"208425680", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"82424183", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"13512466", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"829164", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"109048", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"20866", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"15071967", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"18355269", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"14254838", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"6745199", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1831588", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"297741", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"22248", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"3384107", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"3261253", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1314285", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"337986", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"61602", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"7510", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"353806", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"413122", " ", "d2", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"186843", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"39332", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"3040", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"12040", " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"17850", " ", "d2", " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"9030", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "4"]}], "+", 
    RowBox[{"1540", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "14"], " ", 
     SuperscriptBox["e2", "4"]}], "-", 
    RowBox[{"2648886462", " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"1673056584", " ", "d2", " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"401483124", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"43717152", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"1957812", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"23424", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"15696931212", " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"8080116048", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"1070701608", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"99679608", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"30257760", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"1768632", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"22944", " ", 
     SuperscriptBox["d2", "6"], " ", "e1", " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"39212794476", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"19804767780", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"474337263", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"1226306304", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"205424855", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"10996548", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"266604", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"5712", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"51687930204", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"34876374655", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"3417062590", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"3778491386", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"356347243", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"17870202", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"3591824", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"199632", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"5664", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"35175489398", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"48375718752", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"10133461643", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"5784281566", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"41909977", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"96282925", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"8358117", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"356328", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"15104", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"6293796748", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"49980422456", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"14977002639", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"4811960342", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"505152571", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"115163105", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"4189529", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"21640", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"16048", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"8039761628", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"35633107158", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"13598392328", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"1959548659", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"618561935", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"50563209", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"2455415", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"436169", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"8496", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"6409952668", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"16574503925", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"7794708129", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"36709185", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"322019479", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"2204660", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"2554643", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"367287", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"2242", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"1988126868", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"4732495629", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"2749258420", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"315932143", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"72215247", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"9538885", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"281564", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"124277", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"236", " ", 
     SuperscriptBox["d2", "8"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"280814011", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"751828946", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"549876352", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"124642574", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"1608400", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"3157773", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"255918", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"15514", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"22296304", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"56626836", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"50081953", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"16441811", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"1157772", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"383549", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"61868", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"4529898", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"3158698", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"904912", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"48989", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"70573", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"13558", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"885497", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"677512", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"122358", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"26058", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"8260", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"56330", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"53475", " ", "d2", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"13545", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "5"]}], "+", 
    RowBox[{"140", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "5"]}], "-", 
    RowBox[{"2278597572", " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"1659663948", " ", "d2", " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"467208624", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"63336336", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"3927744", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"84192", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"144", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"12476274114", " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"7856388600", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"1639442432", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"42607564", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"24210756", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"2414832", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"60012", " ", 
     SuperscriptBox["d2", "6"], " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"72", " ", 
     SuperscriptBox["d2", "7"], " ", "e1", " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"27243529668", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"18490548384", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"3303764566", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"463098356", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"160373982", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"11603564", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"267480", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"3164", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"28179973729", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"30083340206", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"4083412569", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"2016112895", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"401100958", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"14732644", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"560721", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"31522", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"9431710073", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"37191623420", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"2173030250", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"3571456016", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"388107068", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"18332051", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"3424824", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"141691", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"8413770717", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"33519841159", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"1473150969", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"3323556243", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"66044008", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"47103901", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"4118408", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"203078", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"10471448776", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"20601744266", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"3268069975", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"1656169192", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"143535113", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"31226409", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"1342302", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"134402", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"4669860531", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"8122881354", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"2309177758", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"354030082", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"107648822", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"6704308", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"554385", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"42503", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"981899102", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"1894618909", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"815690958", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"28633879", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"26511367", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"307316", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"441530", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"5214", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"87800511", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"223618845", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"138978980", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"26138472", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"156251", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"24917", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"75372", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"4145657", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"9352367", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"8371824", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"3267386", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"654354", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"61746", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"1226221", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"663325", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"183944", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"66878", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"16080", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"180739", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"147368", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"42898", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"4460", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"7280", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"7490", " ", "d2", " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "6"]}], "+", 
    RowBox[{"1960", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "13"], " ", 
     SuperscriptBox["e2", "6"]}], "-", 
    RowBox[{"1224910236", " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"1063808904", " ", "d2", " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"341374900", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"54047328", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"4102464", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"114336", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"276", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"6413400546", " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"4918401098", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"1396449636", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"139791304", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"5491862", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"1473436", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"52880", " ", 
     SuperscriptBox["d2", "6"], " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"72", " ", 
     SuperscriptBox["d2", "7"], " ", "e1", " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"11760334248", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"10442159698", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"3493829423", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"198203182", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"57760509", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"6307700", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"136255", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"2620", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"7065289808", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"15005151979", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"5778671059", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"225776643", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"202849939", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"15757271", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"362785", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"978", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"5329863694", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"16759354355", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"5718155507", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"1029381736", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"275933687", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"12096892", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"59024", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"9823", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"11088483002", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"13930932742", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"2888266974", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"1249475247", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"150041040", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"4089182", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"659522", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"9925", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"7224251507", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"7888350173", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"306922740", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"712891641", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"10457524", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"8427801", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"713944", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"3879", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"2288367860", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"2785148940", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"383539372", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"181309388", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"19760923", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"2606393", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"283414", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"542", " ", 
     SuperscriptBox["d2", "7"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"346911826", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"546267681", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"179602966", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"6315399", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"6582150", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"246033", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"39728", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"19184561", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"45698824", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"25522850", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"3618987", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"579206", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"151834", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"457962", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"204779", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"140758", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"32287", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"20700", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"239167", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"66297", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"32932", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"12940", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"21690", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"11655", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "7"]}], "+", 
    RowBox[{"560", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "7"]}], "-", 
    RowBox[{"235793970", " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"371650222", " ", "d2", " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"143622308", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"26225756", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"2329840", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"72232", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"120", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"1567306334", " ", "e1", " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"1755251334", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"682438114", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"116049372", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"5177866", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"293840", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"17188", " ", 
     SuperscriptBox["d2", "6"], " ", "e1", " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"2004978970", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"2799561546", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"1815108030", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"313706680", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"2082314", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"1673582", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"55150", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"1940410803", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"2872640305", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"3345047142", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"398309651", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"37000702", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"5208314", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"140643", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"6910993415", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"3038104617", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"3619956843", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"91234602", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"86253762", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"7160176", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"203248", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"6795072399", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"2982595778", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"2123897730", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"212108330", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"67497961", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"3501729", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"145259", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"3235533145", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"1917464915", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"562769640", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"184838711", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"17133351", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"337492", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"49146", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"790558372", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"685264759", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"6002977", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"53041614", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"1562015", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"720084", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"6328", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"88252415", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"116333753", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"30540269", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"2477624", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"669074", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"146276", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"2163785", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"5559764", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"3393965", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"844681", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"99540", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"71076", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "8"]}], "-", 
    RowBox[{"31834", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"24782", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"18570", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"42371", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"22077", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"3440", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"2240", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"1190", " ", "d2", " ", 
     SuperscriptBox["e1", "12"], " ", 
     SuperscriptBox["e2", "8"]}], "+", 
    RowBox[{"213616968", " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"8555114", " ", "d2", " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"19634652", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"5404984", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"655246", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"21240", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"411272812", " ", "e1", " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"112771036", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"141493118", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"45270186", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"4287652", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"76968", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"1376", " ", 
     SuperscriptBox["d2", "6"], " ", "e1", " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"820798223", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"503548190", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"369172071", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"150922308", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"10166861", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"52514", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"12039", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"2252837221", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"1466936279", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"913566433", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"272058634", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"9696640", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"457432", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"20697", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"3385829685", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"1239926680", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"1197877340", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"197951905", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"6138138", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"1027732", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"14928", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"2532817956", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"205031637", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"781216093", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"27110078", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"13742333", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"940639", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"4997", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"992722818", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"234857072", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"230917196", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"27730456", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"5720848", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"358178", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"644", " ", 
     SuperscriptBox["d2", "6"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"198306126", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"125983724", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"13154823", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"9891826", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"88351", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"46484", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"15556623", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"18683201", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"4627144", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"488629", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"225320", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"87314", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"102825", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"32022", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"16610", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"9298", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"22213", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "9"]}], "-", 
    RowBox[{"11360", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"3570", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"490", " ", "d2", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "9"]}], "+", 
    RowBox[{"220395800", " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"81011786", " ", "d2", " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"11474018", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"950654", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"44472", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"2712", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"529213030", " ", "e1", " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"204316256", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"34967616", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"4870010", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"1145392", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"37160", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"506580732", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"709797624", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"115557478", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"29246484", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"3744382", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"88870", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"589453032", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"1313119141", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"33926285", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"76608600", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"6105520", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"112756", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"775397460", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"1096177445", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"168660570", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"76686447", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"3639264", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"52416", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"567186775", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"384224285", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"173161781", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"25304403", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"303876", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"3422", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"214174061", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"13523323", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"56636125", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"1704380", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"840698", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"5156", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"37350372", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"19138976", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"3355383", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"1362099", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"166120", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"1536105", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"1914688", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"653562", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"98246", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"40959", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "10"]}], "-", 
    RowBox[{"6441", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"11740", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"4310", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"1330", " ", "d2", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"280", " ", 
     SuperscriptBox["e1", "11"], " ", 
     SuperscriptBox["e2", "10"]}], "+", 
    RowBox[{"98277928", " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"42938790", " ", "d2", " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"6205880", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"781194", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"18236", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"136", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"214149656", " ", "e1", " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"89673894", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"29675672", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"2665606", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"46402", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"3148", " ", 
     SuperscriptBox["d2", "5"], " ", "e1", " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"6365735", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"216149806", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"99480656", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"2701788", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"460513", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"16810", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"161681450", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"440836758", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"121030146", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"6245289", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"1018175", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"26301", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"42616305", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"388888601", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"30052773", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"13461545", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"921612", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"15933", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"54466581", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"142699165", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"22004082", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"6684134", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"297072", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"3300", " ", 
     SuperscriptBox["d2", "5"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"34449276", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"11222967", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"9539784", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"367764", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"14080", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"5260371", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"2784573", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"223298", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"209190", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"24410", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"38279", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"6448", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"6054", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "11"]}], "-", 
    RowBox[{"5290", " ", "d2", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"140", " ", 
     SuperscriptBox["e1", "10"], " ", 
     SuperscriptBox["e2", "11"]}], "+", 
    RowBox[{"20612180", " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"12096046", " ", "d2", " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"896046", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"150672", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"3656", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"43691716", " ", "e1", " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"8107028", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"5980466", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"1024840", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"25010", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"94580062", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"12219450", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"27150306", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"2491100", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"36634", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"176695759", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"50470700", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"44015419", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"2000997", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"6097", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"93323840", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"79009718", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"20638510", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"482924", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"48278", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"7890913", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"31902664", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"717032", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"796227", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"21020", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"4871974", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"1909282", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"1274754", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"111010", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"450473", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"282959", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"59008", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"4938", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"3730", " ", "d2", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "12"]}], "+", 
    RowBox[{"200", " ", 
     SuperscriptBox["e1", "9"], " ", 
     SuperscriptBox["e2", "12"]}], "-", 
    RowBox[{"1881158", " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"2361130", " ", "d2", " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"115988", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"6236", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"150", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"4795958", " ", "e1", " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"4386350", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"467310", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"101810", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"2352", " ", 
     SuperscriptBox["d2", "4"], " ", "e1", " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"34298364", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"30187590", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"2121758", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"418432", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"10610", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"64011254", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"17050610", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"7308215", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"559210", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"12657", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"34180034", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"8476445", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"4755710", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"185233", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"4180", " ", 
     SuperscriptBox["d2", "4"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"3387740", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"5065874", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"284597", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"24790", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"654442", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"45043", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"119244", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "13"]}], "+", 
    RowBox[{"10958", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"706", " ", "d2", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"1020", " ", 
     SuperscriptBox["e1", "8"], " ", 
     SuperscriptBox["e2", "13"]}], "-", 
    RowBox[{"3001468", " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"503730", " ", "d2", " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"44354", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"802", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"1172848", " ", "e1", " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"1062144", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"367880", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"4622", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"193274", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"10242172", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"607628", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"5512", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"12381179", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"9062043", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"301747", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"34977", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"7446542", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"86768", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"564344", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"22370", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"412177", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"590953", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"40596", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"52930", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"19958", " ", "d2", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "14"]}], "+", 
    RowBox[{"440", " ", 
     SuperscriptBox["e1", "7"], " ", 
     SuperscriptBox["e2", "14"]}], "-", 
    RowBox[{"1196996", " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"122570", " ", "d2", " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"1968", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"14", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"408488", " ", "e1", " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"149824", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"45256", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"678", " ", 
     SuperscriptBox["d2", "3"], " ", "e1", " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"4332412", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"1529376", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"155710", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"3446", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"1137008", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"1991522", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"85894", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"2354", " ", 
     SuperscriptBox["d2", "3"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"1113724", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"84586", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"30216", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"970", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"38238", " ", "d2", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "15"]}], "+", 
    RowBox[{"132", " ", 
     SuperscriptBox["e1", "6"], " ", 
     SuperscriptBox["e2", "15"]}], "-", 
    RowBox[{"304354", " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"19088", " ", "d2", " ", 
     SuperscriptBox["e2", "16"]}], "+", 
    RowBox[{"334", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"46940", " ", "e1", " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"83862", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"312", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "16"]}], "+", 
    RowBox[{"1773576", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "16"]}], "+", 
    RowBox[{"24514", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"7990", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "16"]}], "+", 
    RowBox[{"428", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "16"]}], "+", 
    RowBox[{"241012", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"11016", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"109966", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "16"]}], "+", 
    RowBox[{"6312", " ", "d2", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "16"]}], "+", 
    RowBox[{"2936", " ", 
     SuperscriptBox["e1", "5"], " ", 
     SuperscriptBox["e2", "16"]}], "-", 
    RowBox[{"53048", " ", 
     SuperscriptBox["e2", "17"]}], "-", 
    RowBox[{"1100", " ", "d2", " ", 
     SuperscriptBox["e2", "17"]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e2", "17"]}], "-", 
    RowBox[{"70782", " ", "e1", " ", 
     SuperscriptBox["e2", "17"]}], "-", 
    RowBox[{"9378", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "17"]}], "+", 
    RowBox[{"88", " ", 
     SuperscriptBox["d2", "2"], " ", "e1", " ", 
     SuperscriptBox["e2", "17"]}], "+", 
    RowBox[{"376188", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "17"]}], "-", 
    RowBox[{"23392", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "17"]}], "+", 
    RowBox[{"548", " ", 
     SuperscriptBox["d2", "2"], " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "17"]}], "+", 
    RowBox[{"6168", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "17"]}], "+", 
    RowBox[{"13512", " ", "d2", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "17"]}], "-", 
    RowBox[{"5284", " ", 
     SuperscriptBox["e1", "4"], " ", 
     SuperscriptBox["e2", "17"]}], "-", 
    RowBox[{"5752", " ", 
     SuperscriptBox["e2", "18"]}], "+", 
    RowBox[{"24", " ", "d2", " ", 
     SuperscriptBox["e2", "18"]}], "-", 
    RowBox[{"19432", " ", "e1", " ", 
     SuperscriptBox["e2", "18"]}], "-", 
    RowBox[{"16", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "18"]}], "+", 
    RowBox[{"44032", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "18"]}], "-", 
    RowBox[{"2312", " ", "d2", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "18"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["e1", "3"], " ", 
     SuperscriptBox["e2", "18"]}], "-", 
    RowBox[{"288", " ", 
     SuperscriptBox["e2", "19"]}], "-", 
    RowBox[{"2280", " ", "e1", " ", 
     SuperscriptBox["e2", "19"]}], "+", 
    RowBox[{"24", " ", "d2", " ", "e1", " ", 
     SuperscriptBox["e2", "19"]}], "+", 
    RowBox[{"2256", " ", 
     SuperscriptBox["e1", "2"], " ", 
     SuperscriptBox["e2", "19"]}], "-", 
    RowBox[{"96", " ", "e1", " ", 
     SuperscriptBox["e2", "20"]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "e2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"7", "+", 
      RowBox[{"7", " ", "e1"}], "+", 
      RowBox[{"d2", " ", "e1"}], "+", 
      SuperscriptBox["e1", "2"], "+", 
      RowBox[{"9", " ", "e2"}], "-", 
      RowBox[{"d2", " ", "e2"}], "+", 
      RowBox[{"e1", " ", "e2"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e2", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"6", "+", 
       RowBox[{"9", " ", "e1"}], "+", 
       RowBox[{"2", " ", "d2", " ", "e1"}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["e1", "2"]}], "+", 
       RowBox[{"d2", " ", 
        SuperscriptBox["e1", "2"]}], "+", 
       RowBox[{"6", " ", "e2"}], "-", 
       RowBox[{"2", " ", "d2", " ", "e2"}], "+", 
       RowBox[{"3", " ", "e1", " ", "e2"}], "-", 
       RowBox[{"d2", " ", "e1", " ", "e2"}], "-", 
       SuperscriptBox["e2", "2"], "+", 
       RowBox[{"e1", " ", 
        SuperscriptBox["e2", "2"]}], "-", 
       SuperscriptBox["e2", "3"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"18", "+", 
      RowBox[{"21", " ", "e1"}], "+", 
      RowBox[{"2", " ", "d2", " ", "e1"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"d2", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"30", " ", "e2"}], "-", 
      RowBox[{"2", " ", "d2", " ", "e2"}], "+", 
      RowBox[{"15", " ", "e1", " ", "e2"}], "-", 
      RowBox[{"d2", " ", "e1", " ", "e2"}], "+", 
      RowBox[{"14", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"4", " ", "e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["e2", "3"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"123", "+", 
      RowBox[{"234", " ", "e1"}], "+", 
      RowBox[{"34", " ", "d2", " ", "e1"}], "+", 
      RowBox[{"137", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"30", " ", "d2", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["d2", "2"], " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"26", " ", 
       SuperscriptBox["e1", "3"]}], "+", 
      RowBox[{"2", " ", "d2", " ", 
       SuperscriptBox["e1", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["e1", "4"]}], "+", 
      RowBox[{"330", " ", "e2"}], "-", 
      RowBox[{"34", " ", "d2", " ", "e2"}], "+", 
      RowBox[{"348", " ", "e1", " ", "e2"}], "+", 
      RowBox[{"16", " ", "d2", " ", "e1", " ", "e2"}], "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["d2", "2"], " ", "e1", " ", "e2"}], "+", 
      RowBox[{"68", " ", 
       SuperscriptBox["e1", "2"], " ", "e2"}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["e1", "3"], " ", "e2"}], "+", 
      RowBox[{"307", " ", 
       SuperscriptBox["e2", "2"]}], "-", 
      RowBox[{"46", " ", "d2", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["d2", "2"], " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"126", " ", "e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"10", " ", "d2", " ", "e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["e1", "2"], " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"116", " ", 
       SuperscriptBox["e2", "3"]}], "-", 
      RowBox[{"12", " ", "d2", " ", 
       SuperscriptBox["e2", "3"]}], "+", 
      RowBox[{"12", " ", "e1", " ", 
       SuperscriptBox["e2", "3"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["e2", "4"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"173", "+", 
      RowBox[{"310", " ", "e1"}], "+", 
      RowBox[{"46", " ", "d2", " ", "e1"}], "+", 
      RowBox[{"159", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"34", " ", "d2", " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["d2", "2"], " ", 
       SuperscriptBox["e1", "2"]}], "+", 
      RowBox[{"22", " ", 
       SuperscriptBox["e1", "3"]}], "-", 
      RowBox[{"2", " ", "d2", " ", 
       SuperscriptBox["e1", "3"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["e1", "4"]}], "+", 
      RowBox[{"486", " ", "e2"}], "-", 
      RowBox[{"46", " ", "d2", " ", "e2"}], "+", 
      RowBox[{"484", " ", "e1", " ", "e2"}], "+", 
      RowBox[{"32", " ", "d2", " ", "e1", " ", "e2"}], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["d2", "2"], " ", "e1", " ", "e2"}], "+", 
      RowBox[{"76", " ", 
       SuperscriptBox["e1", "2"], " ", "e2"}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["e1", "3"], " ", "e2"}], "+", 
      RowBox[{"485", " ", 
       SuperscriptBox["e2", "2"]}], "-", 
      RowBox[{"66", " ", "d2", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["d2", "2"], " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"194", " ", "e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"22", " ", "d2", " ", "e1", " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"13", " ", 
       SuperscriptBox["e1", "2"], " ", 
       SuperscriptBox["e2", "2"]}], "+", 
      RowBox[{"204", " ", 
       SuperscriptBox["e2", "3"]}], "-", 
      RowBox[{"20", " ", "d2", " ", 
       SuperscriptBox["e2", "3"]}], "+", 
      RowBox[{"20", " ", "e1", " ", 
       SuperscriptBox["e2", "3"]}], "+", 
      RowBox[{"32", " ", 
       SuperscriptBox["e2", "4"]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7813353591085997`*^9, 3.804872199123437*^9, 
  3.80491150582834*^9, 3.8049358903765736`*^9, 3.8052864674135246`*^9, 
  3.8056271543726196`*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"6c6f029b-78e5-4c8b-8db5-5f7ef0f34a2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variables", "[", "g2", "]"}]], "Input",
 CellChangeTimes->{{3.7812648651164722`*^9, 3.78126486821025*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"5019ae05-cd24-4c9e-a2eb-23436ea7cb5f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e2", ",", "e1", ",", "d2"}], "}"}]], "Output",
 CellChangeTimes->{3.7813353640710955`*^9, 3.8048722090923233`*^9, 
  3.804911514110392*^9, 3.8049358999693937`*^9, 3.805627162122727*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"8b54e0af-95ff-4f99-a59e-62f9523293e8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Finding possible values of ",
 Cell[BoxData[
  FormBox["e1", TraditionalForm]],ExpressionUUID->
  "f1064842-1e84-4a1c-b322-c895a04936a0"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g1", "=", "0"}], TraditionalForm]],ExpressionUUID->
  "d4679b19-9efb-47e9-841c-9d068bcc7952"]
}], "Subsection",
 CellChangeTimes->{{3.7813318780587096`*^9, 3.781331919981142*^9}, {
  3.8048723167058363`*^9, 3.8048723185027924`*^9}, {3.804912162580185*^9, 
  3.8049121672368393`*^9}, {3.8049359911732407`*^9, 3.804936000507846*^9}, {
  3.804936030712341*^9, 3.8049360649656734`*^9}, {3.805627208654647*^9, 
  3.8056272093109055`*^9}, {3.8056274230793695`*^9, 
  3.8056274245012093`*^9}},ExpressionUUID->"4f751f13-d14d-4e0c-a594-\
015bf0406703"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["1", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, {
   3.8048723468625436`*^9, 3.804872413425928*^9}, {3.8049116500635347`*^9, 
   3.8049116883136578`*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"10303035-46af-45bc-964e-8cbe58be715f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      TemplateBox[{"Root", 
        TemplateBox[{"\"8.81\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        TagBox[
         RowBox[{"Root", "[", 
           RowBox[{
             RowBox[{
               RowBox[{"125256641", "+", 
                 RowBox[{"45563670", " ", "#1"}], "-", 
                 RowBox[{"8058225", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 RowBox[{"144000", " ", 
                   SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}], 
         Short[#, 7]& ], 8.805092594369697},
       "NumericalApproximation"],
      Root[125256641 + 45563670 # - 8058225 #^2 + 144000 #^3& , 2, 0]], "<", 
     "d2", "\[LessEqual]", 
     InterpretationBox[
      TemplateBox[{"Root", 
        TemplateBox[{"\"49.3\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        TagBox[
         RowBox[{"Root", "[", 
           RowBox[{
             RowBox[{
               RowBox[{"4982842450240284585787159", "-", 
                 RowBox[{"17614631061160103578910656", " ", "#1"}], "+", 
                 RowBox[{"3812548806193381022695468", " ", 
                   SuperscriptBox["#1", "2"]}], "-", 
                 RowBox[{"296098287212647589894650", " ", 
                   SuperscriptBox["#1", "3"]}], "-", 
                 RowBox[{"33537320681598938367800", " ", 
                   SuperscriptBox["#1", "4"]}], "+", 
                 RowBox[{"1046247904097936603000", " ", 
                   SuperscriptBox["#1", "5"]}], "+", 
                 RowBox[{"29287880721994720000", " ", 
                   SuperscriptBox["#1", "6"]}], "-", 
                 RowBox[{"1183554846342400000", " ", 
                   SuperscriptBox["#1", "7"]}], "+", 
                 RowBox[{"9678548992000000", " ", 
                   SuperscriptBox["#1", "8"]}]}], "&"}], ",", "4"}], "]"}], 
         Short[#, 7]& ], 49.33424709809357},
       "NumericalApproximation"],
      Root[
      4982842450240284585787159 - 17614631061160103578910656 # + 
       3812548806193381022695468 #^2 - 296098287212647589894650 #^3 - 
       33537320681598938367800 #^4 + 1046247904097936603000 #^5 + 
       29287880721994720000 #^6 - 1183554846342400000 #^7 + 
       9678548992000000 #^8& , 4, 0]]}], "&&", 
    RowBox[{"e2", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "238783"}], "-", 
         RowBox[{"17643", " ", "d2"}], "-", 
         RowBox[{"336", " ", 
          SuperscriptBox["d2", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "460240"}], "+", 
            RowBox[{"55545", " ", "d2"}], "+", 
            RowBox[{"3360", " ", 
             SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "214030"}], "+", 
            RowBox[{"73980", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"41950", "+", 
            RowBox[{"8700", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"33400", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{"1000", " ", 
          SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"d2", "+", 
      InterpretationBox[
       TemplateBox[{"Root", 
         TemplateBox[{"\"-49.3\"", 
           DynamicBox[
            FEPrivate`FrontEndResource[
            "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
         TagBox[
          RowBox[{"Root", "[", 
            RowBox[{
              RowBox[{
                RowBox[{"4982842450240284585787159", "+", 
                  RowBox[{"17614631061160103578910656", " ", "#1"}], "+", 
                  RowBox[{"3812548806193381022695468", " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                  RowBox[{"296098287212647589894650", " ", 
                    SuperscriptBox["#1", "3"]}], "-", 
                  RowBox[{"33537320681598938367800", " ", 
                    SuperscriptBox["#1", "4"]}], "-", 
                  RowBox[{"1046247904097936603000", " ", 
                    SuperscriptBox["#1", "5"]}], "+", 
                  RowBox[{"29287880721994720000", " ", 
                    SuperscriptBox["#1", "6"]}], "+", 
                  RowBox[{"1183554846342400000", " ", 
                    SuperscriptBox["#1", "7"]}], "+", 
                  RowBox[{"9678548992000000", " ", 
                    SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], 
          Short[#, 7]& ], -49.33424709809357},
        "NumericalApproximation"],
       Root[
       4982842450240284585787159 + 17614631061160103578910656 # + 
        3812548806193381022695468 #^2 + 296098287212647589894650 #^3 - 
        33537320681598938367800 #^4 - 1046247904097936603000 #^5 + 
        29287880721994720000 #^6 + 1183554846342400000 #^7 + 
        9678548992000000 #^8& , 1, 0]]}], ">", "0"}], "&&", 
    RowBox[{"e2", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "238783"}], "-", 
         RowBox[{"17643", " ", "d2"}], "-", 
         RowBox[{"336", " ", 
          SuperscriptBox["d2", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "460240"}], "+", 
            RowBox[{"55545", " ", "d2"}], "+", 
            RowBox[{"3360", " ", 
             SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "214030"}], "+", 
            RowBox[{"73980", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"41950", "+", 
            RowBox[{"8700", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"33400", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{"1000", " ", 
          SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.8048722330855436`*^9, 3.8048724173634233`*^9, 
  3.8048729307147956`*^9, 3.8049118188602266`*^9, 3.804936100618994*^9, 
  3.8056271950762863`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"c24df6b2-590b-4aed-952d-e0ddbeb241f7"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.8048722330855436`*^9, 3.8048724173634233`*^9, 
  3.8048729307147956`*^9, 3.8049118188602266`*^9, 3.804936100618994*^9, 
  3.8056271997325974`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"d0c33242-eeae-43cd-968a-a29524978d45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["2", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652425746355`*^9}, {
   3.8048728659483657`*^9, 3.8048728735109653`*^9}, 3.8049117108599324`*^9},
 CellLabel->"In[59]:=",ExpressionUUID->"4f3bdb42-cac6-4c82-ac5d-9ff63996d8a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     InterpretationBox[
      TemplateBox[{"Root", 
        TemplateBox[{"\"10.4\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        TagBox[
         RowBox[{"Root", "[", 
           RowBox[{
             RowBox[{
               RowBox[{"70383186", "+", 
                 RowBox[{"24341235", " ", "#1"}], "-", 
                 RowBox[{"4861900", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 RowBox[{"180500", " ", 
                   SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}], 
         Short[#, 7]& ], 10.438866236225156`},
       "NumericalApproximation"],
      Root[70383186 + 24341235 # - 4861900 #^2 + 180500 #^3& , 2, 0]], "<", 
     "d2", "\[LessEqual]", 
     InterpretationBox[
      TemplateBox[{"Root", 
        TemplateBox[{"\"18.7\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        TagBox[
         RowBox[{"Root", "[", 
           RowBox[{
             RowBox[{
               RowBox[{"136525260905307224889457", "-", 
                 RowBox[{"1832517367038425591266178", " ", "#1"}], "+", 
                 RowBox[{"258909788859566727747779", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 RowBox[{"16004089149124783964500", " ", 
                   SuperscriptBox["#1", "3"]}], "-", 
                 RowBox[{"10806198697117414607225", " ", 
                   SuperscriptBox["#1", "4"]}], "+", 
                 RowBox[{"484697854007415116750", " ", 
                   SuperscriptBox["#1", "5"]}], "+", 
                 RowBox[{"31254236174476913125", " ", 
                   SuperscriptBox["#1", "6"]}], "-", 
                 RowBox[{"2267351158397600000", " ", 
                   SuperscriptBox["#1", "7"]}], "+", 
                 RowBox[{"35364009824000000", " ", 
                   SuperscriptBox["#1", "8"]}]}], "&"}], ",", "4"}], "]"}], 
         Short[#, 7]& ], 18.684932313874544`},
       "NumericalApproximation"],
      Root[
      136525260905307224889457 - 1832517367038425591266178 # + 
       258909788859566727747779 #^2 + 16004089149124783964500 #^3 - 
       10806198697117414607225 #^4 + 484697854007415116750 #^5 + 
       31254236174476913125 #^6 - 2267351158397600000 #^7 + 
       35364009824000000 #^8& , 4, 0]]}], "&&", 
    RowBox[{"e2", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "38911"}], "-", 
         RowBox[{"5146", " ", "d2"}], "-", 
         RowBox[{"187", " ", 
          SuperscriptBox["d2", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "69665"}], "+", 
            RowBox[{"6270", " ", "d2"}], "+", 
            RowBox[{"935", " ", 
             SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "31405"}], "+", 
            RowBox[{"10355", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4850", "+", 
            RowBox[{"1600", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"4575", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{"250", " ", 
          SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"d2", ">", 
     InterpretationBox[
      TemplateBox[{"Root", 
        TemplateBox[{"\"18.7\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        TagBox[
         RowBox[{"Root", "[", 
           RowBox[{
             RowBox[{
               RowBox[{"136525260905307224889457", "-", 
                 RowBox[{"1832517367038425591266178", " ", "#1"}], "+", 
                 RowBox[{"258909788859566727747779", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 RowBox[{"16004089149124783964500", " ", 
                   SuperscriptBox["#1", "3"]}], "-", 
                 RowBox[{"10806198697117414607225", " ", 
                   SuperscriptBox["#1", "4"]}], "+", 
                 RowBox[{"484697854007415116750", " ", 
                   SuperscriptBox["#1", "5"]}], "+", 
                 RowBox[{"31254236174476913125", " ", 
                   SuperscriptBox["#1", "6"]}], "-", 
                 RowBox[{"2267351158397600000", " ", 
                   SuperscriptBox["#1", "7"]}], "+", 
                 RowBox[{"35364009824000000", " ", 
                   SuperscriptBox["#1", "8"]}]}], "&"}], ",", "4"}], "]"}], 
         Short[#, 7]& ], 18.684932313874544`},
       "NumericalApproximation"],
      Root[
      136525260905307224889457 - 1832517367038425591266178 # + 
       258909788859566727747779 #^2 + 16004089149124783964500 #^3 - 
       10806198697117414607225 #^4 + 484697854007415116750 #^5 + 
       31254236174476913125 #^6 - 2267351158397600000 #^7 + 
       35364009824000000 #^8& , 4, 0]]}], "&&", 
    RowBox[{"e2", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "38911"}], "-", 
         RowBox[{"5146", " ", "d2"}], "-", 
         RowBox[{"187", " ", 
          SuperscriptBox["d2", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "69665"}], "+", 
            RowBox[{"6270", " ", "d2"}], "+", 
            RowBox[{"935", " ", 
             SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "31405"}], "+", 
            RowBox[{"10355", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4850", "+", 
            RowBox[{"1600", " ", "d2"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"4575", " ", 
          SuperscriptBox["#1", "4"]}], "+", 
         RowBox[{"250", " ", 
          SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.80487225038059*^9, 3.8048729364179945`*^9, 
  3.8049118242035246`*^9, 3.8049361107401896`*^9, 3.805627232873664*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"75896418-d505-4063-8397-167affafca9a"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.80487225038059*^9, 3.8048729364179945`*^9, 
  3.8049118242035246`*^9, 3.8049361107401896`*^9, 3.8056272365924654`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"47567895-eff5-485a-99c4-3bc8da58527a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["3", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, {
   3.7812652577154617`*^9, 3.78126525905923*^9}, {3.80487287627658*^9, 
   3.804872880464127*^9}, 3.8049117141099157`*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"7ca2aa72-71db-4b26-9e5c-76067a91bade"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d2", ">", 
   InterpretationBox[
    TemplateBox[{"Root", 
      TemplateBox[{"\"12.5\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"1072415181", "+", 
               RowBox[{"324061390", " ", "#1"}], "-", 
               RowBox[{"91939025", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"4732000", " ", 
                 SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ], 12.500420929697782`},
     "NumericalApproximation"],
    Root[1072415181 + 324061390 # - 91939025 #^2 + 4732000 #^3& , 3, 0]]}], "&&", 
  RowBox[{"e2", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "399303"}], "-", 
       RowBox[{"71523", " ", "d2"}], "-", 
       RowBox[{"3726", " ", 
        SuperscriptBox["d2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "666780"}], "+", 
          RowBox[{"43815", " ", "d2"}], "+", 
          RowBox[{"12420", " ", 
           SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "291810"}], "+", 
          RowBox[{"91460", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"35550", "+", 
          RowBox[{"17300", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"39600", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"3000", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.80487225406507*^9, 3.804872944621229*^9, 
  3.8049118301567926`*^9, 3.804936121650942*^9, 3.80562725753024*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"7ec0742c-432c-47e5-933d-fbb8c9a3cab6"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.80487225406507*^9, 3.804872944621229*^9, 
  3.8049118301567926`*^9, 3.804936121650942*^9, 3.805627262405305*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"cd83c9f4-7191-437a-b26d-212cc556e526"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["4", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.781265272793733*^9, {3.8048728838704777`*^9, 3.8048728862142324`*^9}, 
   3.804911717511865*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"59d0fc0b-dbe6-4c4b-81c9-99e6618c91b1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"165", " ", "d2"}], ">", 
   InterpretationBox[
    TemplateBox[{"Root", 
      TemplateBox[{"\"2.51\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]], 
        "\"\[ThinSpace]\[Times]\[ThinSpace]\"", 
        TemplateBox[{"\"10\"", "\"3\""}, "Superscript", SyntaxForm -> 
         SuperscriptBox]}, "RowDefault"], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"661135464", "+", 
               RowBox[{"866688", " ", "#1"}], "-", 
               RowBox[{"2964", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ], 2514.831783072492},
     "NumericalApproximation"],
    Root[661135464 + 866688 # - 2964 #^2 + #^3& , 3, 0]]}], "&&", 
  RowBox[{"e2", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "63086"}], "-", 
       RowBox[{"13716", " ", "d2"}], "-", 
       RowBox[{"912", " ", 
        SuperscriptBox["d2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "98645"}], "+", 
          RowBox[{"4560", " ", "d2"}], "+", 
          RowBox[{"2280", " ", 
           SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "41990"}], "+", 
          RowBox[{"12465", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4025", "+", 
          RowBox[{"2775", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"5300", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"500", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.804872256813608*^9, 3.804872948877612*^9, 
  3.804911834312674*^9, 3.8049361314218855`*^9, 3.805627270452287*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"56bb876a-edd3-4d4b-aeb6-d0a750af75b7"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.804872256813608*^9, 3.804872948877612*^9, 
  3.804911834312674*^9, 3.8049361314218855`*^9, 3.8056272740148373`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"a69dcf39-6f9e-4a82-b8fa-a40f99cbd2ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["5", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.7812652837001815`*^9, {3.804872890354889*^9, 3.8048728919799128`*^9}, 
   3.8049117200942554`*^9},
 CellLabel->"In[68]:=",ExpressionUUID->"22f1aaa9-8d16-436e-a8a7-995bac5790c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d2", ">", 
   InterpretationBox[
    TemplateBox[{"Root", 
      TemplateBox[{"\"19.1\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"50481", "+", 
               RowBox[{"2214", " ", "#1"}], "-", 
               RowBox[{"10033", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"512", " ", 
                 SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ], 19.09899810477205},
     "NumericalApproximation"],
    Root[50481 + 2214 # - 10033 #^2 + 512 #^3& , 3, 0]]}], "&&", 
  RowBox[{"e2", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1007"}], "-", 
       RowBox[{"251", " ", "d2"}], "-", 
       RowBox[{"20", " ", 
        SuperscriptBox["d2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1480"}], "+", 
          RowBox[{"45", " ", "d2"}], "+", 
          RowBox[{"40", " ", 
           SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "614"}], "+", 
          RowBox[{"172", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"46", "+", 
          RowBox[{"44", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"72", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.804872259701099*^9, 3.8048729537683015`*^9, 
  3.804911838845481*^9, 3.8049361384208612`*^9, 3.805627279436782*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"ebd3d766-e9ba-4824-9005-38612c8efa6b"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.804872259701099*^9, 3.8048729537683015`*^9, 
  3.804911838845481*^9, 3.8049361384208612`*^9, 3.805627281952443*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"1c31150d-8221-4808-9415-ee6c8c7e4b3d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["6", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.781265293653393*^9, {3.804872894933071*^9, 3.8048728973237324`*^9}, 
   3.8049117228777523`*^9},
 CellLabel->"In[71]:=",ExpressionUUID->"454fb556-ff88-45f6-bd8b-a6da0b8d3108"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d2", ">", 
   InterpretationBox[
    TemplateBox[{"Root", 
      TemplateBox[{"\"24.9\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"34251054", "-", 
               RowBox[{"12734045", " ", "#1"}], "-", 
               RowBox[{"13315400", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"552250", " ", 
                 SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ], 24.93614034699538},
     "NumericalApproximation"],
    Root[34251054 - 12734045 # - 13315400 #^2 + 552250 #^3& , 3, 0]]}], "&&", 
  RowBox[{"e2", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "96921"}], "-", 
       RowBox[{"26766", " ", "d2"}], "-", 
       RowBox[{"2457", " ", 
        SuperscriptBox["d2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "134355"}], "+", 
          RowBox[{"2340", " ", "d2"}], "+", 
          RowBox[{"4095", " ", 
           SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "54435"}], "+", 
          RowBox[{"14335", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3150", "+", 
          RowBox[{"4150", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"5925", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"750", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.804872263662269*^9, 3.8048729574402227`*^9, 
  3.804911844329419*^9, 3.804936146724761*^9, 3.8056272902963037`*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"baea507e-e78c-4013-b8ea-49d2b5d4e726"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.804872263662269*^9, 3.8048729574402227`*^9, 
  3.804911844329419*^9, 3.804936146724761*^9, 3.8056272940776005`*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"df56f088-96b6-4e9e-8032-49d50dc1940b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["7", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.781265303184762*^9, {3.8048729002143927`*^9, 3.804872903401988*^9}, 
   3.80491172609457*^9},
 CellLabel->"In[74]:=",ExpressionUUID->"dc00f300-5dbe-46e7-a167-b4e7a40ac24c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"d2", ">", 
   InterpretationBox[
    TemplateBox[{"Root", 
      TemplateBox[{"\"34.8\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"2875261", "-", 
               RowBox[{"6364290", " ", "#1"}], "-", 
               RowBox[{"3573025", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"108000", " ", 
                 SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}], 
       Short[#, 7]& ], 34.75697405287909},
     "NumericalApproximation"],
    Root[2875261 - 6364290 # - 3573025 #^2 + 108000 #^3& , 3, 0]]}], "&&", 
  RowBox[{"e2", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "944743"}], "-", 
       RowBox[{"282723", " ", "d2"}], "-", 
       RowBox[{"29106", " ", 
        SuperscriptBox["d2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1239220"}], "+", 
          RowBox[{"8235", " ", "d2"}], "+", 
          RowBox[{"41580", " ", 
           SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "491290"}], "+", 
          RowBox[{"121140", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"21550", "+", 
          RowBox[{"39300", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"49600", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"7000", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.804872266300892*^9, 3.804872961268399*^9, 
  3.804911848516036*^9, 3.8049361563335905`*^9, 3.805627301280839*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"9d07c086-452c-4fde-a9d5-b5e8409e08cd"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.804872266300892*^9, 3.804872961268399*^9, 
  3.804911848516036*^9, 3.8049361563335905`*^9, 3.805627306124635*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"03d4f273-e21d-4826-b006-a57440a4a3ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["8", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.7812653172475023`*^9, {3.8048729081207976`*^9, 3.8048729102927046`*^9}, 
   3.804911729610015*^9},
 CellLabel->"In[77]:=",ExpressionUUID->"cc481053-f35f-4d3a-a13d-8acbe1f900f3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d2", "+", 
    InterpretationBox[
     TemplateBox[{"Root", 
       TemplateBox[{"\"-54.6\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"10248624", "-", 
                RowBox[{"56885460", " ", "#1"}], "+", 
                RowBox[{"24333400", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"465125", " ", 
                  SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
        Short[#, 7]& ], -54.56463479870367},
      "NumericalApproximation"],
     Root[10248624 - 56885460 # + 24333400 #^2 + 465125 #^3& , 1, 0]]}], ">", 
   "0"}], "&&", 
  RowBox[{"e2", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "142456"}], "-", 
       RowBox[{"45496", " ", "d2"}], "-", 
       RowBox[{"5152", " ", 
        SuperscriptBox["d2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "177335"}], "-", 
          RowBox[{"420", " ", "d2"}], "+", 
          RowBox[{"6440", " ", 
           SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "68920"}], "+", 
          RowBox[{"15845", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2225", "+", 
          RowBox[{"5725", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"6450", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"1000", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.8048722697978992`*^9, 3.804872964893447*^9, 
  3.804911853470592*^9, 3.8049361637008257`*^9, 3.805627312468474*^9},
 CellLabel->"Out[78]=",ExpressionUUID->"7d389c83-e61f-424c-bc75-0254b6d84d9a"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.8048722697978992`*^9, 3.804872964893447*^9, 
  3.804911853470592*^9, 3.8049361637008257`*^9, 3.805627313390357*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"8f1b9547-45fc-4afb-9677-a060d2936795"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["9", "10"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.781265331044507*^9, {3.804872912839611*^9, 3.80487291744905*^9}, 
   3.804911733221925*^9},
 CellLabel->"In[80]:=",ExpressionUUID->"f7c51b99-863d-46be-a8c8-3373c8b9937c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"d2", "+", 
    InterpretationBox[
     TemplateBox[{"Root", 
       TemplateBox[{"\"-114.\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
       TagBox[
        RowBox[{"Root", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"650963511", "-", 
                RowBox[{"1398223130", " ", "#1"}], "+", 
                RowBox[{"516532025", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{"4624000", " ", 
                  SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
        Short[#, 7]& ], -114.36161986031021`},
      "NumericalApproximation"],
     Root[650963511 - 1398223130 # + 516532025 #^2 + 4624000 #^3& , 1, 0]]}], 
   ">", "0"}], "&&", 
  RowBox[{"e2", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1362303"}], "-", 
       RowBox[{"459243", " ", "d2"}], "-", 
       RowBox[{"56376", " ", 
        SuperscriptBox["d2", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1613760"}], "-", 
          RowBox[{"16095", " ", "d2"}], "+", 
          RowBox[{"62640", " ", 
           SuperscriptBox["d2", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "615870"}], "+", 
          RowBox[{"131420", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"13950", "+", 
          RowBox[{"52700", " ", "d2"}]}], ")"}], " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"53400", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"9000", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}]}]}]], "Output",
 CellChangeTimes->{3.804872273751627*^9, 3.8048729686122494`*^9, 
  3.804911858439605*^9, 3.8049361670622153`*^9, 3.805627318562301*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"ea14adb2-8c74-4878-aea1-4359e6289664"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.804872273751627*^9, 3.8048729686122494`*^9, 
  3.804911858439605*^9, 3.8049361670622153`*^9, 3.805627319546707*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"bdcbb60a-4abb-4017-97e6-9f3427e8b1fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"d2", ">", "0"}], "&&", 
     RowBox[{"e1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"d2", ",", "e2"}], "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.7812653390758715`*^9, {3.8048729206834154`*^9, 3.80487292360538*^9}, 
   3.804911738032022*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"6d6d2497-f734-4092-bfc0-9e9097116095"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.8048722753048277`*^9, 3.804872971518536*^9, 
  3.8049118610504417`*^9, 3.804936168499237*^9, 3.8056273232342386`*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"16a75e19-8aa6-40aa-9336-6a67006ae3cc"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.8048722753048277`*^9, 3.804872971518536*^9, 
  3.8049118610504417`*^9, 3.804936168499237*^9, 3.8056273236092434`*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"1401dd71-774e-494a-8087-a7f888da80a8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Setting the value of e1, d2: Equations (16)-(18)", "Subsection",
 CellChangeTimes->{{3.781331857824067*^9, 3.7813318655897675`*^9}, 
   3.8049362482079277`*^9, {3.8052884246417*^9, 3.8052884299386444`*^9}, {
   3.8056295832878695`*^9, 3.805629617522681*^9}, {3.805629691461166*^9, 
   3.8056296958830967`*^9}},ExpressionUUID->"a7829f64-468f-4ab2-91ed-\
d34e64ed321d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"d2", ",", "e1", ",", "e2"}], "]"}], ";", 
  RowBox[{"e1", "=", 
   FractionBox["5", "10"]}], ";", 
  RowBox[{"d2", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", "<", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", "e2", "}"}]}], " ", "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Reduce", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "\[Equal]", "0"}], "&&", 
     RowBox[{"g2", ">", "0"}], "&&", 
     RowBox[{"a11", ">", "0"}], " ", "&&", " ", 
     RowBox[{"det", ">", "0"}], "&&", 
     RowBox[{"beta", ">", "0"}], "&&", 
     RowBox[{"y0", ">", "0"}], "&&", " ", 
     RowBox[{"c1", ">", "0"}], "&&", 
     RowBox[{"d1", ">", "0"}], "&&", 
     RowBox[{"e2", ">", "0"}]}], ",", 
    RowBox[{"{", "e2", "}"}]}], " ", "]"}], "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{
  3.7812650126965284`*^9, {3.7812652112148438`*^9, 3.7812652191367984`*^9}, 
   3.7812652837001815`*^9, {3.78126536299811*^9, 3.7812653754670258`*^9}, {
   3.8049123537046814`*^9, 3.8049123733770056`*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"e2e63b21-fce7-4e5f-a2b6-1cf5a866064d"],

Cell[BoxData[
 RowBox[{"e2", "\[Equal]", 
  InterpretationBox[
   TemplateBox[{"Root", 
     TemplateBox[{"\"0.771\"", 
       DynamicBox[
        FEPrivate`FrontEndResource[
        "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
     TagBox[
      RowBox[{"Root", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{"-", "14027"}], "+", 
              RowBox[{"15420", " ", "#1"}], "+", 
              RowBox[{"2826", " ", 
                SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{"926", " ", 
                SuperscriptBox["#1", "3"]}], "+", 
              RowBox[{"72", " ", 
                SuperscriptBox["#1", "4"]}], "+", 
              RowBox[{"8", " ", 
                SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
      Short[#, 7]& ], 0.7712905683142337},
    "NumericalApproximation"],
   Root[-14027 + 15420 # + 2826 #^2 + 926 #^3 + 72 #^4 + 8 #^5& , 1, 
    0]]}]], "Output",
 CellChangeTimes->{3.7813353681104994`*^9, 3.80491238143705*^9, 
  3.804936229620676*^9, 3.8056274374076304`*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"1cf493ae-de2e-455f-9ce5-6b19d8e069d6"],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{3.7813353681104994`*^9, 3.80491238143705*^9, 
  3.804936229620676*^9, 3.80562743747013*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"eb2ec384-07c9-4b39-843f-c33a03abb990"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g1", "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.805627447689047*^9, 3.805627450267232*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"a7f5aaf4-c047-4511-ad17-01dc8f7d6cfd"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "14027"}], "+", 
     RowBox[{"15420", " ", "e2"}], "+", 
     RowBox[{"2826", " ", 
      SuperscriptBox["e2", "2"]}], "+", 
     RowBox[{"926", " ", 
      SuperscriptBox["e2", "3"]}], "+", 
     RowBox[{"72", " ", 
      SuperscriptBox["e2", "4"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["e2", "5"]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "+", "e2"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"17163", "-", 
     RowBox[{"19172", " ", "e2"}], "+", 
     RowBox[{"12044", " ", 
      SuperscriptBox["e2", "2"]}], "-", 
     RowBox[{"1888", " ", 
      SuperscriptBox["e2", "3"]}], "+", 
     RowBox[{"256", " ", 
      SuperscriptBox["e2", "4"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.805627451470319*^9, 3.805627477814433*^9}},
 CellLabel->
  "Out[103]=",ExpressionUUID->"9a668015-f3a7-469a-9bb8-dac3f7078220"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g2", "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.7812655509224277`*^9, 3.781265572375865*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"87854f41-6252-4c12-ac77-3ec74429f4b0"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "126512084933352295"}], "+", 
        RowBox[{"478399692835658985", " ", "e2"}], "-", 
        RowBox[{"762458375238510816", " ", 
         SuperscriptBox["e2", "2"]}], "+", 
        RowBox[{"730329622432012315", " ", 
         SuperscriptBox["e2", "3"]}], "-", 
        RowBox[{"466875108129002500", " ", 
         SuperscriptBox["e2", "4"]}], "+", 
        RowBox[{"180057388265535584", " ", 
         SuperscriptBox["e2", "5"]}], "-", 
        RowBox[{"42412278548678749", " ", 
         SuperscriptBox["e2", "6"]}], "+", 
        RowBox[{"7565318705371668", " ", 
         SuperscriptBox["e2", "7"]}], "-", 
        RowBox[{"1899913140260206", " ", 
         SuperscriptBox["e2", "8"]}], "+", 
        RowBox[{"200501244715092", " ", 
         SuperscriptBox["e2", "9"]}], "+", 
        RowBox[{"44607817747872", " ", 
         SuperscriptBox["e2", "10"]}], "+", 
        RowBox[{"18408318367872", " ", 
         SuperscriptBox["e2", "11"]}], "+", 
        RowBox[{"8352995841088", " ", 
         SuperscriptBox["e2", "12"]}], "+", 
        RowBox[{"1190085589888", " ", 
         SuperscriptBox["e2", "13"]}], "+", 
        RowBox[{"348608893184", " ", 
         SuperscriptBox["e2", "14"]}], "+", 
        RowBox[{"33760183296", " ", 
         SuperscriptBox["e2", "15"]}], "+", 
        RowBox[{"6787676672", " ", 
         SuperscriptBox["e2", "16"]}], "+", 
        RowBox[{"473953280", " ", 
         SuperscriptBox["e2", "17"]}], "+", 
        RowBox[{"64299008", " ", 
         SuperscriptBox["e2", "18"]}], "+", 
        RowBox[{"2555904", " ", 
         SuperscriptBox["e2", "19"]}], "+", 
        RowBox[{"196608", " ", 
         SuperscriptBox["e2", "20"]}]}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"83", "-", 
        RowBox[{"42", " ", "e2"}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["e2", "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "73"}], "+", 
         RowBox[{"85", " ", "e2"}], "+", 
         SuperscriptBox["e2", "2"], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["e2", "3"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"109", "-", 
        RowBox[{"25", " ", "e2"}], "+", 
        RowBox[{"32", " ", 
         SuperscriptBox["e2", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["e2", "3"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"17163", "-", 
        RowBox[{"19172", " ", "e2"}], "+", 
        RowBox[{"12044", " ", 
         SuperscriptBox["e2", "2"]}], "-", 
        RowBox[{"1888", " ", 
         SuperscriptBox["e2", "3"]}], "+", 
        RowBox[{"256", " ", 
         SuperscriptBox["e2", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"23933", "-", 
        RowBox[{"29628", " ", "e2"}], "+", 
        RowBox[{"23764", " ", 
         SuperscriptBox["e2", "2"]}], "-", 
        RowBox[{"2976", " ", 
         SuperscriptBox["e2", "3"]}], "+", 
        RowBox[{"512", " ", 
         SuperscriptBox["e2", "4"]}]}], ")"}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.7813353714908376`*^9, 3.8049124971916027`*^9, 
  3.804936322694827*^9, 3.8056274408764257`*^9, 3.80562747934569*^9},
 CellLabel->
  "Out[104]=",ExpressionUUID->"22684da9-3968-43fe-a9fc-70abc33b170d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"e2", "=", 
   InterpretationBox[
    TemplateBox[{"Root", 
      TemplateBox[{"\"0.771\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "14027"}], "+", 
               RowBox[{"15420", " ", "#1"}], "+", 
               RowBox[{"2826", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"926", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{"72", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"8", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
       Short[#, 7]& ], 0.7712905683142337},
     "NumericalApproximation"],
    Root[-14027 + 15420 # + 2826 #^2 + 926 #^3 + 72 #^4 + 8 #^5& , 1, 0]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"e2", "//", "N"}]}], "Input",
 CellChangeTimes->{{3.804937768489185*^9, 3.804937783833089*^9}, 
   3.8056274677830906`*^9},
 CellLabel->
  "In[105]:=",ExpressionUUID->"fc169562-9bf5-43ad-b665-0ceb798f8d03"],

Cell[BoxData["0.7712905683142337`"], "Output",
 CellChangeTimes->{{3.804937779905285*^9, 3.8049377849738693`*^9}, 
   3.8056274876426764`*^9},
 CellLabel->
  "Out[106]=",ExpressionUUID->"ce03d44f-8378-4b06-ace5-ba31922cf800"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Perturbation", "Section",
 CellChangeTimes->{{3.775921636445956*^9, 
  3.77592163896164*^9}},ExpressionUUID->"83d9d58b-8b54-4a5b-b281-\
31c0931388d3"],

Cell[CellGroupData[{

Cell[TextData[{
 "Setting e2 such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g1", "=", "0"}], ",", 
    RowBox[{"g2", "<", "0"}], ",", " ", 
    RowBox[{
     RowBox[{"trace", "(", "J", ")"}], "=", "0"}]}], TraditionalForm]],
  ExpressionUUID->"26c65d11-bd22-4503-91b6-c20d58ae6c5d"],
 " (no perturbation)"
}], "Subsection",
 CellChangeTimes->{{3.7759680771521792`*^9, 3.775968091980483*^9}, {
   3.7759693094048333`*^9, 3.775969312623622*^9}, 3.8052885555184374`*^9, {
   3.8056305154431877`*^9, 
   3.805630519161988*^9}},ExpressionUUID->"17a2478a-f91b-4ea2-9572-\
c879be186659"],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.7759676330942*^9, 3.7759676336723337`*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"2539d579-2f07-4c67-86b9-775426b31cfd"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "xd", ",", "yd", ",", "c1", ",", "d1", ",", "d2", ",", "e1", ",", "e2", 
    ",", "f1", ",", "f2", ",", "g1", ",", "g2", ",", "sol"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xd", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"d1", " ", "x"}], "+", 
    RowBox[{"e1", " ", "y"}], "+", "f1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yd", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "y"}], "-", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d2", " ", "x"}], "-", 
    RowBox[{"e2", " ", "y"}], "+", "f2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f1", "=", "1"}], ";", 
  RowBox[{"f2", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e1", "=", 
   FractionBox["5", "10"]}], ";", 
  RowBox[{"d2", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"d2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}]}], "+", 
     RowBox[{"c1", " ", 
      RowBox[{"(", 
       RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", "f1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", "f2"}]}], 
    RowBox[{"2", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c1", "=", 
   FractionBox[
    RowBox[{"d2", "-", 
     RowBox[{"d2", " ", "e1"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "-", 
     RowBox[{"e1", " ", "f2"}]}], 
    RowBox[{"1", "+", "e1", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e2", "=", 
   InterpretationBox[
    TemplateBox[{"Root", 
      TemplateBox[{"\"0.771\"", 
        DynamicBox[
         FEPrivate`FrontEndResource[
         "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{
               RowBox[{"-", "14027"}], "+", 
               RowBox[{"15420", " ", "#1"}], "+", 
               RowBox[{"2826", " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
               RowBox[{"926", " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{"72", " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
               RowBox[{"8", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
       Short[#, 7]& ], 0.7712905683142337},
     "NumericalApproximation"],
    Root[-14027 + 15420 # + 2826 #^2 + 926 #^3 + 72 #^4 + 8 #^5& , 1, 0]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "14027"}], "+", 
       RowBox[{"15420", " ", "e2"}], "+", 
       RowBox[{"2826", " ", 
        SuperscriptBox["e2", "2"]}], "+", 
       RowBox[{"926", " ", 
        SuperscriptBox["e2", "3"]}], "+", 
       RowBox[{"72", " ", 
        SuperscriptBox["e2", "4"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["e2", "5"]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", "e2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"17163", "-", 
       RowBox[{"19172", " ", "e2"}], "+", 
       RowBox[{"12044", " ", 
        SuperscriptBox["e2", "2"]}], "-", 
       RowBox[{"1888", " ", 
        SuperscriptBox["e2", "3"]}], "+", 
       RowBox[{"256", " ", 
        SuperscriptBox["e2", "4"]}]}], ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "126512084933352295"}], "+", 
          RowBox[{"478399692835658985", " ", "e2"}], "-", 
          RowBox[{"762458375238510816", " ", 
           SuperscriptBox["e2", "2"]}], "+", 
          RowBox[{"730329622432012315", " ", 
           SuperscriptBox["e2", "3"]}], "-", 
          RowBox[{"466875108129002500", " ", 
           SuperscriptBox["e2", "4"]}], "+", 
          RowBox[{"180057388265535584", " ", 
           SuperscriptBox["e2", "5"]}], "-", 
          RowBox[{"42412278548678749", " ", 
           SuperscriptBox["e2", "6"]}], "+", 
          RowBox[{"7565318705371668", " ", 
           SuperscriptBox["e2", "7"]}], "-", 
          RowBox[{"1899913140260206", " ", 
           SuperscriptBox["e2", "8"]}], "+", 
          RowBox[{"200501244715092", " ", 
           SuperscriptBox["e2", "9"]}], "+", 
          RowBox[{"44607817747872", " ", 
           SuperscriptBox["e2", "10"]}], "+", 
          RowBox[{"18408318367872", " ", 
           SuperscriptBox["e2", "11"]}], "+", 
          RowBox[{"8352995841088", " ", 
           SuperscriptBox["e2", "12"]}], "+", 
          RowBox[{"1190085589888", " ", 
           SuperscriptBox["e2", "13"]}], "+", 
          RowBox[{"348608893184", " ", 
           SuperscriptBox["e2", "14"]}], "+", 
          RowBox[{"33760183296", " ", 
           SuperscriptBox["e2", "15"]}], "+", 
          RowBox[{"6787676672", " ", 
           SuperscriptBox["e2", "16"]}], "+", 
          RowBox[{"473953280", " ", 
           SuperscriptBox["e2", "17"]}], "+", 
          RowBox[{"64299008", " ", 
           SuperscriptBox["e2", "18"]}], "+", 
          RowBox[{"2555904", " ", 
           SuperscriptBox["e2", "19"]}], "+", 
          RowBox[{"196608", " ", 
           SuperscriptBox["e2", "20"]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"83", "-", 
          RowBox[{"42", " ", "e2"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["e2", "2"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "73"}], "+", 
           RowBox[{"85", " ", "e2"}], "+", 
           SuperscriptBox["e2", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["e2", "3"]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"109", "-", 
          RowBox[{"25", " ", "e2"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["e2", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["e2", "3"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"17163", "-", 
          RowBox[{"19172", " ", "e2"}], "+", 
          RowBox[{"12044", " ", 
           SuperscriptBox["e2", "2"]}], "-", 
          RowBox[{"1888", " ", 
           SuperscriptBox["e2", "3"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["e2", "4"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"23933", "-", 
          RowBox[{"29628", " ", "e2"}], "+", 
          RowBox[{"23764", " ", 
           SuperscriptBox["e2", "2"]}], "-", 
          RowBox[{"2976", " ", 
           SuperscriptBox["e2", "3"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["e2", "4"]}]}], ")"}]}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.775967680844734*^9, 3.7759677093763723`*^9}, {
   3.775967750001811*^9, 3.7759677732208934`*^9}, {3.775967950269906*^9, 
   3.7759679558949776`*^9}, {3.7759680228233485`*^9, 
   3.7759680514330764`*^9}, {3.7759681081837482`*^9, 
   3.7759681395903797`*^9}, {3.7759684268282304`*^9, 
   3.7759684271720304`*^9}, {3.7759953186261516`*^9, 
   3.7759953935333595`*^9}, {3.776001637547542*^9, 3.776001686720023*^9}, 
   3.776001737720682*^9, 3.8049125713003263`*^9, {3.8049126124390144`*^9, 
   3.8049126449554157`*^9}, {3.804912700125772*^9, 3.804912711795249*^9}, 
   3.8051050941896725`*^9, 3.805105153763839*^9, {3.8056275505497885`*^9, 
   3.8056275825658207`*^9}, {3.8056276832859507`*^9, 3.805627695536089*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"1193ff1a-2d8f-49b3-b7b3-0adcf347a43b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.6803360677531344`*^-18", ",", 
   RowBox[{"-", "0.02788961641892002`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.781335391779866*^9, 3.8049127661256905`*^9, 
  3.805105216795925*^9, 3.8056277298802667`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"196199c3-9a0b-4feb-b67f-f8ad1d30af72"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "sol", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xd", "\[Equal]", "0"}], ",", 
        RowBox[{"yd", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], 
    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "//", 
   "N"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xd", ",", "yd"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "sol"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xd", ",", "yd"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "sol"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.775968291389095*^9, 3.7759683265301905`*^9}, {
   3.775968358061821*^9, 3.775968392218483*^9}, 3.775968938806552*^9, {
   3.805627748450382*^9, 3.8056277538254004`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"c69ef5e7-fb1e-4551-b42d-f8c697d0a5ae"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.`"}], ",", 
   RowBox[{"y", "\[Rule]", "8.025705599268715`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.781335392948983*^9, 3.804912784094549*^9, 
  3.8051052209834824`*^9, 3.805627758997342*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"dcf54698-a760-4a2e-a0a3-b3051c75dbc1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.0685896612017132`*^-15", "+", 
    RowBox[{"1.142335075136586`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.0685896612017132`*^-15", "-", 
    RowBox[{"1.142335075136586`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.781335392948983*^9, 3.804912784094549*^9, 
  3.8051052209834824`*^9, 3.805627759044218*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"47969827-4579-4751-b073-e398592248fa"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "3.2.1. Perturbing e2 such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g1", ">", "0"}], ",", 
    RowBox[{"g2", "<", "0"}]}], TraditionalForm]],ExpressionUUID->
  "a6a2f7d1-7d96-4bd3-a4ae-055eaf32ea69"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"trace", "(", "J", ")"}], "=", "0"}], TraditionalForm]],
  ExpressionUUID->"55f8e633-1b80-42f5-88b2-207be1cdf54b"]
}], "Subsection",
 CellChangeTimes->{{3.7759680771521792`*^9, 3.775968091980483*^9}, {
  3.775968475813244*^9, 3.775968475813244*^9}, {3.775968887250041*^9, 
  3.775968889187513*^9}, {3.775969216919341*^9, 3.7759692312007637`*^9}, {
  3.775969994362713*^9, 3.775969994581465*^9}, {3.805288557768467*^9, 
  3.8052885619403973`*^9}},ExpressionUUID->"7e428a82-41a0-4b73-ba22-\
1d17dbb93904"],

Cell[BoxData["Quit"], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"bbf987c8-5edc-4de7-b911-38208d12070e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "xd", ",", "yd", ",", "c1", ",", "d1", ",", "d2", ",", "e1", ",", "e2", 
    ",", "f1", ",", "f2", ",", "g1", ",", "g2", ",", "sol"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xd", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"d1", " ", "x"}], "+", 
    RowBox[{"e1", " ", "y"}], "+", "f1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yd", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "y"}], "-", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d2", " ", "x"}], "-", 
    RowBox[{"e2", " ", "y"}], "+", "f2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f1", "=", "1"}], ";", 
  RowBox[{"f2", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e1", "=", 
   FractionBox["5", "10"]}], ";", 
  RowBox[{"d2", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"d2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}]}], "+", 
     RowBox[{"c1", " ", 
      RowBox[{"(", 
       RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", "f1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", "f2"}]}], 
    RowBox[{"2", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c1", "=", 
   FractionBox[
    RowBox[{"d2", "-", 
     RowBox[{"d2", " ", "e1"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "-", 
     RowBox[{"e1", " ", "f2"}]}], 
    RowBox[{"1", "+", "e1", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e2", "=", 
    FractionBox["78", "100"]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"perturbed", " ", "parameter", " ", "for", " ", "g1"}], ">", 
    "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "14027"}], "+", 
       RowBox[{"15420", " ", "e2"}], "+", 
       RowBox[{"2826", " ", 
        SuperscriptBox["e2", "2"]}], "+", 
       RowBox[{"926", " ", 
        SuperscriptBox["e2", "3"]}], "+", 
       RowBox[{"72", " ", 
        SuperscriptBox["e2", "4"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["e2", "5"]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", "e2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"17163", "-", 
       RowBox[{"19172", " ", "e2"}], "+", 
       RowBox[{"12044", " ", 
        SuperscriptBox["e2", "2"]}], "-", 
       RowBox[{"1888", " ", 
        SuperscriptBox["e2", "3"]}], "+", 
       RowBox[{"256", " ", 
        SuperscriptBox["e2", "4"]}]}], ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "126512084933352295"}], "+", 
          RowBox[{"478399692835658985", " ", "e2"}], "-", 
          RowBox[{"762458375238510816", " ", 
           SuperscriptBox["e2", "2"]}], "+", 
          RowBox[{"730329622432012315", " ", 
           SuperscriptBox["e2", "3"]}], "-", 
          RowBox[{"466875108129002500", " ", 
           SuperscriptBox["e2", "4"]}], "+", 
          RowBox[{"180057388265535584", " ", 
           SuperscriptBox["e2", "5"]}], "-", 
          RowBox[{"42412278548678749", " ", 
           SuperscriptBox["e2", "6"]}], "+", 
          RowBox[{"7565318705371668", " ", 
           SuperscriptBox["e2", "7"]}], "-", 
          RowBox[{"1899913140260206", " ", 
           SuperscriptBox["e2", "8"]}], "+", 
          RowBox[{"200501244715092", " ", 
           SuperscriptBox["e2", "9"]}], "+", 
          RowBox[{"44607817747872", " ", 
           SuperscriptBox["e2", "10"]}], "+", 
          RowBox[{"18408318367872", " ", 
           SuperscriptBox["e2", "11"]}], "+", 
          RowBox[{"8352995841088", " ", 
           SuperscriptBox["e2", "12"]}], "+", 
          RowBox[{"1190085589888", " ", 
           SuperscriptBox["e2", "13"]}], "+", 
          RowBox[{"348608893184", " ", 
           SuperscriptBox["e2", "14"]}], "+", 
          RowBox[{"33760183296", " ", 
           SuperscriptBox["e2", "15"]}], "+", 
          RowBox[{"6787676672", " ", 
           SuperscriptBox["e2", "16"]}], "+", 
          RowBox[{"473953280", " ", 
           SuperscriptBox["e2", "17"]}], "+", 
          RowBox[{"64299008", " ", 
           SuperscriptBox["e2", "18"]}], "+", 
          RowBox[{"2555904", " ", 
           SuperscriptBox["e2", "19"]}], "+", 
          RowBox[{"196608", " ", 
           SuperscriptBox["e2", "20"]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"83", "-", 
          RowBox[{"42", " ", "e2"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["e2", "2"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "73"}], "+", 
           RowBox[{"85", " ", "e2"}], "+", 
           SuperscriptBox["e2", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["e2", "3"]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"109", "-", 
          RowBox[{"25", " ", "e2"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["e2", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["e2", "3"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"17163", "-", 
          RowBox[{"19172", " ", "e2"}], "+", 
          RowBox[{"12044", " ", 
           SuperscriptBox["e2", "2"]}], "-", 
          RowBox[{"1888", " ", 
           SuperscriptBox["e2", "3"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["e2", "4"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"23933", "-", 
          RowBox[{"29628", " ", "e2"}], "+", 
          RowBox[{"23764", " ", 
           SuperscriptBox["e2", "2"]}], "-", 
          RowBox[{"2976", " ", 
           SuperscriptBox["e2", "3"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["e2", "4"]}]}], ")"}]}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"c1", ",", "d1"}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"c1", ",", "d1"}], "}"}], "//", "N"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.775967680844734*^9, 3.7759677093763723`*^9}, {
   3.775967750001811*^9, 3.7759677732208934`*^9}, {3.775967950269906*^9, 
   3.7759679558949776`*^9}, {3.7759680228233485`*^9, 
   3.7759680514330764`*^9}, {3.7759681081837482`*^9, 
   3.7759681395903797`*^9}, {3.7759688805624075`*^9, 
   3.7759688809062138`*^9}, {3.775968952869278*^9, 3.7759689579005404`*^9}, {
   3.7759689901040506`*^9, 3.7759689929322076`*^9}, {3.7759691893095875`*^9, 
   3.775969189622137*^9}, 3.77599542427824*^9, {3.7760027210032587`*^9, 
   3.776002751644271*^9}, {3.8049128240166464`*^9, 3.8049128668603973`*^9}, {
   3.8049133942975254`*^9, 3.8049134083133907`*^9}, {3.804913598204112*^9, 
   3.8049136156100626`*^9}, 3.8051051044397936`*^9, 3.80510516002955*^9, {
   3.805627824576355*^9, 3.8056278376233883`*^9}, {3.8056279543500023`*^9, 
   3.8056279695845594`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"2488b02a-8b3b-47b7-b0ca-2dacc1306484"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1229", "5700"], ",", 
   FractionBox["59173", "2850"]}], "}"}]], "Output",
 CellChangeTimes->{3.7813354014468327`*^9, 3.781434208181713*^9, 
  3.8049128887971687`*^9, 3.8049134276884165`*^9, 3.804913630909785*^9, 
  3.8051058385214505`*^9, 3.805627990084836*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"43cf6d81-c8d0-471c-97c7-9507e5aa3be8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.21561403508771929`", ",", "20.762456140350878`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7813354014468327`*^9, 3.781434208181713*^9, 
  3.8049128887971687`*^9, 3.8049134276884165`*^9, 3.804913630909785*^9, 
  3.8051058385214505`*^9, 3.805627990100459*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"91de1226-b43c-463b-b076-0caabd1a2160"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.015511031746642832`", ",", 
   RowBox[{"-", "0.6669990011669192`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7813354014468327`*^9, 3.781434208181713*^9, 
  3.8049128887971687`*^9, 3.8049134276884165`*^9, 3.804913630909785*^9, 
  3.8051058385214505`*^9, 3.805627990100459*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"c58a481c-13ff-49dc-933f-789e73ba961f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "sol", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xd", "\[Equal]", "0"}], ",", 
        RowBox[{"yd", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], 
    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "//", 
   "N"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xd", ",", "yd"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "sol"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eigenvalues", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xd", ",", "yd"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "sol"}], "]"}], 
  "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.781434212022097*^9, 3.781434226594554*^9}, {
  3.805106455473857*^9, 3.805106473536643*^9}, {3.805627995934882*^9, 
  3.8056280300497303`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"57726548-65bc-4c0c-8c00-b125e26cecbd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.`"}], ",", 
   RowBox[{"y", "\[Rule]", "7.991228070175438`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.781335402895978*^9, {3.781434213130208*^9, 3.7814342283107257`*^9}, 
   3.8049128969216657`*^9, 3.8049136367978096`*^9, 3.8051058522002144`*^9, {
   3.8051064568019905`*^9, 3.805106474692872*^9}, {3.8056280072212515`*^9, 
   3.8056280311590676`*^9}},
 CellLabel->"Out[23]=",ExpressionUUID->"501af609-b9c7-4e02-87dc-bd360917e162"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1.6237011735142914`*^-15"}], "+", 
    RowBox[{"1.0619511998567517`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.6237011735142914`*^-15"}], "-", 
    RowBox[{"1.0619511998567517`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.781335402895978*^9, {3.781434213130208*^9, 3.7814342283107257`*^9}, 
   3.8049128969216657`*^9, 3.8049136367978096`*^9, 3.8051058522002144`*^9, {
   3.8051064568019905`*^9, 3.805106474692872*^9}, {3.8056280072212515`*^9, 
   3.8056280311590676`*^9}},
 CellLabel->"Out[25]=",ExpressionUUID->"2def3da7-0b1d-4219-84b9-12f72d553b3b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "3.2.2. Perturbing c1 and e2 such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g1", ">", "0"}], ",", 
    RowBox[{"g2", "<", "0"}]}], TraditionalForm]],ExpressionUUID->
  "0cc3d827-1d8d-4ea3-b48d-631d85670e23"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"trace", "(", "J", ")"}], "<", "0"}], TraditionalForm]],
  ExpressionUUID->"26025a8f-7221-4886-90f3-3f548323bcbe"]
}], "Subsection",
 CellChangeTimes->{{3.7759680771521792`*^9, 3.775968091980483*^9}, {
  3.775968475813244*^9, 3.775968475813244*^9}, {3.775968887250041*^9, 
  3.775968889187513*^9}, {3.775969216919341*^9, 3.7759692312007637`*^9}, {
  3.775969994362713*^9, 3.775969994581465*^9}, {3.7759700728964963`*^9, 
  3.7759700808965983`*^9}, {3.8052885592841125`*^9, 
  3.8052885667217107`*^9}},ExpressionUUID->"f7ebb2ff-cf9d-44bb-9581-\
f4f73812172e"],

Cell[BoxData["Quit"], "Input",
 CellChangeTimes->{{3.7759904385081515`*^9, 3.7759904390706177`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"aed9b43c-5b6e-4847-b9d9-6139fe929b68"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "xd", ",", "yd", ",", "c1", ",", "d1", ",", "d2", ",", "e1", ",", "e2", 
    ",", "f1", ",", "f2", ",", "g1", ",", "g2", ",", "sol"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xd", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"d1", " ", "x"}], "+", 
    RowBox[{"e1", " ", "y"}], "+", "f1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"yd", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "y"}], "-", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d2", " ", "x"}], "-", 
    RowBox[{"e2", " ", "y"}], "+", "f2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f1", "=", "1"}], ";", 
  RowBox[{"f2", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e1", "=", 
   FractionBox["5", "10"]}], ";", 
  RowBox[{"d2", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"d2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}]}], "+", 
     RowBox[{"c1", " ", 
      RowBox[{"(", 
       RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", "f1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", "f2"}]}], 
    RowBox[{"2", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"c1", "=", 
    FractionBox["22", "100"]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"perturbed", " ", "parameter", " ", "for", " ", "trace", 
     RowBox[{"(", "J", ")"}]}], "<", "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e2", "=", 
    FractionBox["78", "100"]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"perturbed", " ", "parameter", " ", "for", " ", "g1"}], ">", 
    "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g1", "=", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "14027"}], "+", 
       RowBox[{"15420", " ", "e2"}], "+", 
       RowBox[{"2826", " ", 
        SuperscriptBox["e2", "2"]}], "+", 
       RowBox[{"926", " ", 
        SuperscriptBox["e2", "3"]}], "+", 
       RowBox[{"72", " ", 
        SuperscriptBox["e2", "4"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["e2", "5"]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", "e2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"17163", "-", 
       RowBox[{"19172", " ", "e2"}], "+", 
       RowBox[{"12044", " ", 
        SuperscriptBox["e2", "2"]}], "-", 
       RowBox[{"1888", " ", 
        SuperscriptBox["e2", "3"]}], "+", 
       RowBox[{"256", " ", 
        SuperscriptBox["e2", "4"]}]}], ")"}]}]]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g2", "=", 
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "126512084933352295"}], "+", 
          RowBox[{"478399692835658985", " ", "e2"}], "-", 
          RowBox[{"762458375238510816", " ", 
           SuperscriptBox["e2", "2"]}], "+", 
          RowBox[{"730329622432012315", " ", 
           SuperscriptBox["e2", "3"]}], "-", 
          RowBox[{"466875108129002500", " ", 
           SuperscriptBox["e2", "4"]}], "+", 
          RowBox[{"180057388265535584", " ", 
           SuperscriptBox["e2", "5"]}], "-", 
          RowBox[{"42412278548678749", " ", 
           SuperscriptBox["e2", "6"]}], "+", 
          RowBox[{"7565318705371668", " ", 
           SuperscriptBox["e2", "7"]}], "-", 
          RowBox[{"1899913140260206", " ", 
           SuperscriptBox["e2", "8"]}], "+", 
          RowBox[{"200501244715092", " ", 
           SuperscriptBox["e2", "9"]}], "+", 
          RowBox[{"44607817747872", " ", 
           SuperscriptBox["e2", "10"]}], "+", 
          RowBox[{"18408318367872", " ", 
           SuperscriptBox["e2", "11"]}], "+", 
          RowBox[{"8352995841088", " ", 
           SuperscriptBox["e2", "12"]}], "+", 
          RowBox[{"1190085589888", " ", 
           SuperscriptBox["e2", "13"]}], "+", 
          RowBox[{"348608893184", " ", 
           SuperscriptBox["e2", "14"]}], "+", 
          RowBox[{"33760183296", " ", 
           SuperscriptBox["e2", "15"]}], "+", 
          RowBox[{"6787676672", " ", 
           SuperscriptBox["e2", "16"]}], "+", 
          RowBox[{"473953280", " ", 
           SuperscriptBox["e2", "17"]}], "+", 
          RowBox[{"64299008", " ", 
           SuperscriptBox["e2", "18"]}], "+", 
          RowBox[{"2555904", " ", 
           SuperscriptBox["e2", "19"]}], "+", 
          RowBox[{"196608", " ", 
           SuperscriptBox["e2", "20"]}]}], ")"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "e2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"83", "-", 
          RowBox[{"42", " ", "e2"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["e2", "2"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "73"}], "+", 
           RowBox[{"85", " ", "e2"}], "+", 
           SuperscriptBox["e2", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["e2", "3"]}]}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"109", "-", 
          RowBox[{"25", " ", "e2"}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["e2", "2"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["e2", "3"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"17163", "-", 
          RowBox[{"19172", " ", "e2"}], "+", 
          RowBox[{"12044", " ", 
           SuperscriptBox["e2", "2"]}], "-", 
          RowBox[{"1888", " ", 
           SuperscriptBox["e2", "3"]}], "+", 
          RowBox[{"256", " ", 
           SuperscriptBox["e2", "4"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"23933", "-", 
          RowBox[{"29628", " ", "e2"}], "+", 
          RowBox[{"23764", " ", 
           SuperscriptBox["e2", "2"]}], "-", 
          RowBox[{"2976", " ", 
           SuperscriptBox["e2", "3"]}], "+", 
          RowBox[{"512", " ", 
           SuperscriptBox["e2", "4"]}]}], ")"}]}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{"c1", ",", "d1"}], "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"c1", ",", "d1"}], "}"}], "//", "N"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.775967680844734*^9, 3.7759677093763723`*^9}, {
   3.775967750001811*^9, 3.7759677732208934`*^9}, {3.775967950269906*^9, 
   3.7759679558949776`*^9}, {3.7759680228233485`*^9, 
   3.7759680514330764`*^9}, {3.7759681081837482`*^9, 
   3.7759681395903797`*^9}, {3.7759688805624075`*^9, 
   3.7759688809062138`*^9}, {3.775968952869278*^9, 3.7759689579005404`*^9}, {
   3.7759689901040506`*^9, 3.7759689929322076`*^9}, {3.7759691893095875`*^9, 
   3.775969189622137*^9}, {3.775970161897625*^9, 3.7759701676164474`*^9}, {
   3.7759706506044664`*^9, 3.775970701995743*^9}, {3.7759904462269745`*^9, 
   3.775990446805132*^9}, 3.775990478317497*^9, 3.7759954740913506`*^9, {
   3.8049136893154297`*^9, 3.8049137477355146`*^9}, 3.8051051109242516`*^9, 
   3.805105167264019*^9, {3.805110901213399*^9, 3.8051109020884085`*^9}, {
   3.805628050346822*^9, 3.8056281133320627`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"59530686-01c7-44a8-88f8-1b8ce1e40192"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["11", "50"], ",", 
   FractionBox["72148", "3475"]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7813354112938175`*^9, 3.8049137724976273`*^9, {3.805110898650863*^9, 
   3.8051109095416346`*^9}, 3.8056281563794756`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"f280a736-d482-4c72-98c1-a887f693c7cb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.22`", ",", "20.76201438848921`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7813354112938175`*^9, 3.8049137724976273`*^9, {3.805110898650863*^9, 
   3.8051109095416346`*^9}, 3.805628156395102*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"9922eda5-c8fd-4445-9f85-026cd3822512"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.015511031746642832`", ",", 
   RowBox[{"-", "0.6669990011669192`"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.7813354112938175`*^9, 3.8049137724976273`*^9, {3.805110898650863*^9, 
   3.8051109095416346`*^9}, 3.805628156395102*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"a006a62a-27bc-4046-af99-c39d45ed0527"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "sol", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"xd", "\[Equal]", "0"}], ",", 
        RowBox[{"yd", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}], 
    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "//", 
   "N"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xd", ",", "yd"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "sol"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Eigenvalues", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xd", ",", "yd"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "sol"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.805628134004236*^9, 3.8056281386449213`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"2da9e74d-d32d-40b0-8c08-e00479951a4a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.`"}], ",", 
   RowBox[{"y", "\[Rule]", "7.9928057553956835`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.7813354145811462`*^9, 3.804913807003463*^9, 
  3.8051110299495*^9, 3.805628160301405*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"2b1f8ddd-d010-4b1d-816e-ec025be9f05a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.0017985611510798125`"}], "+", 
    RowBox[{"1.061903917803025`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.0017985611510798125`"}], "-", 
    RowBox[{"1.061903917803025`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.7813354145811462`*^9, 3.804913807003463*^9, 
  3.8051110299495*^9, 3.805628160317029*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"2c5d71b4-7952-4845-a017-842f929256c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0017985611510798125`"}], "*", "2"}]], "Input",
 CellChangeTimes->{{3.8051108032714214`*^9, 3.8051108041152315`*^9}, 
   3.805628165937022*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"d01bfaf4-7527-46ad-bc89-767b2cf4ef5f"],

Cell[BoxData[
 RowBox[{"-", "0.003597122302159625`"}]], "Output",
 CellChangeTimes->{3.8051108044120593`*^9, 3.8056281674838905`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"29db46ca-82f9-4425-8caf-84168be6b694"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "3.2.1. Plotting the limit cycles when  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g1", ">", "0"}], ",", 
    RowBox[{"g2", "<", "0"}]}], TraditionalForm]],ExpressionUUID->
  "05f2a36f-06e9-45bd-a557-8c58c39a8ace"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"trace", "(", "J", ")"}], "=", "0"}], TraditionalForm]],
  ExpressionUUID->"ddca64ec-27ad-4e05-9090-48ed6b9c45e5"]
}], "Section",
 CellChangeTimes->{{3.77600407377901*^9, 3.7760040779822335`*^9}, {
  3.781332138499669*^9, 3.7813321483122745`*^9}, {3.80510663822633*^9, 
  3.805106641507624*^9}},ExpressionUUID->"f4eade05-3ef8-4a0e-8d74-\
1fa653048eee"],

Cell[CellGroupData[{

Cell["Preparations", "Subsection",
 CellChangeTimes->{{3.738333200804104*^9, 
  3.7383332031166353`*^9}},ExpressionUUID->"2656d628-8833-48b0-a957-\
9122769a4663"],

Cell[BoxData["Quit"], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"d9f953f4-a283-4441-9e3f-53d362296bbf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"#", ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "Automatic", "]"}]}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "Plot", ",", "ParametricPlot", ",", "ListPlot", ",", "ListLinePlot"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"#", ",", 
      RowBox[{"AxesStyle", "\[Rule]", 
       RowBox[{"Arrowheads", "[", "Automatic", "]"}]}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "Plot", ",", "ListPlot", ",", "ListLinePlot", ",", "ListLogLogPlot", ",", 
     "ParametricPlot", ",", "DateListPlot", ",", "DiscretePlot"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LaunchKernels", "[", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.732363377880574*^9, 3.732363481280627*^9}, {
  3.758447045696415*^9, 3.7584470493367786`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"6f417cb5-16cc-43ed-8a8b-92ce54c91376"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The function creating the plots", "Subsection",
 CellChangeTimes->{{3.758446633857683*^9, 3.7584466395406833`*^9}, 
   3.7584470060104465`*^9},ExpressionUUID->"088bad54-ba69-4fb4-89e1-\
95535516f4ef"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{
   "p", ",", "q", ",", "x", ",", "y", ",", "c1", ",", "d1", ",", "d2", ",", 
    "e1", ",", "e2", ",", "f1", ",", "f2"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"d1", " ", "x"}], "+", 
    RowBox[{"e1", " ", "y"}], "+", "f1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"q", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "y"}], "-", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"c1", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"d2", " ", "x"}], "-", 
    RowBox[{"e2", " ", "y"}], "+", "f2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f1", "=", "1"}], ";", 
  RowBox[{"f2", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e1", "=", 
   FractionBox["5", "10"]}], ";", 
  RowBox[{"d2", "=", "20"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   FractionBox[
    RowBox[{
     RowBox[{"d2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}]}], "+", 
     RowBox[{"c1", " ", 
      RowBox[{"(", 
       RowBox[{"e1", "-", "e2"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", "f1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e1"}], ")"}], " ", "f2"}]}], 
    RowBox[{"2", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c1", "=", 
   FractionBox[
    RowBox[{"d2", "-", 
     RowBox[{"d2", " ", "e1"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "e2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "e2", "+", "f1"}], ")"}]}], "+", "f2", "-", 
     RowBox[{"e1", " ", "f2"}]}], 
    RowBox[{"1", "+", "e1", "+", "e2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e2", "=", 
    FractionBox["78", "100"]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"perturbed", " ", "parameter", " ", "for", " ", "g1"}], ">", 
    "0"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
  "e2", ",", "e1", ",", "d2", ",", "d1", ",", "f1", ",", "f2", ",", "c1"}], 
  "}"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "e2", ",", "e1", ",", "d2", ",", "d1", ",", "f1", ",", "f2", ",", "c1"}], 
   "}"}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.758446675825683*^9, 3.758446701958683*^9}, {
   3.758446740227683*^9, 3.7584467687376833`*^9}, {3.7584469444047976`*^9, 
   3.7584469891867642`*^9}, {3.758447108026647*^9, 3.7584471093057747`*^9}, {
   3.7584517758926*^9, 3.7584518062686377`*^9}, {3.7584519391039195`*^9, 
   3.758451939199929*^9}, {3.7584521386498723`*^9, 3.7584521397849855`*^9}, {
   3.7584522356115675`*^9, 3.7584522362516317`*^9}, {3.758452478841888*^9, 
   3.7584524791049147`*^9}, {3.7584527924372444`*^9, 
   3.7584527925082517`*^9}, {3.7584552459545813`*^9, 3.7584553652705116`*^9}, 
   3.7584560436473427`*^9, {3.758456397369711*^9, 3.758456411920166*^9}, 
   3.758456542403213*^9, {3.7584566385308247`*^9, 3.758456642633235*^9}, {
   3.758456672659237*^9, 3.7584566786668377`*^9}, 3.7584568993967447`*^9, {
   3.7584569379617443`*^9, 3.758456996708744*^9}, {3.7591484217512836`*^9, 
   3.759148426221284*^9}, {3.759149039837343*^9, 3.759149081781537*^9}, {
   3.7591494774971046`*^9, 3.759149487033058*^9}, {3.7591497519005423`*^9, 
   3.7591497636907215`*^9}, {3.759149814151767*^9, 3.759149817204072*^9}, {
   3.759211899024141*^9, 3.759211909990237*^9}, 3.75921203113035*^9, {
   3.7592122646086955`*^9, 3.7592122649747324`*^9}, 3.7592124799092236`*^9, {
   3.759212714009631*^9, 3.759212722810511*^9}, {3.7594734259057403`*^9, 
   3.759473432265196*^9}, {3.759473797834549*^9, 3.7594738041940503`*^9}, {
   3.7594859773902955`*^9, 3.7594859875779247`*^9}, {3.776004331274248*^9, 
   3.7760043427431493`*^9}, {3.7760043911499853`*^9, 
   3.7760043934937325`*^9}, {3.781332576947485*^9, 3.781332612020694*^9}, {
   3.8049139090817976`*^9, 3.804913926485091*^9}, {3.8049139945077257`*^9, 
   3.8049140075160837`*^9}, 3.8056283723772554`*^9},
 CellLabel->"In[5]:=",ExpressionUUID->"1ae26929-a45d-41df-b4ed-c29a6f3487d5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["39", "50"], ",", 
   FractionBox["1", "2"], ",", "20", ",", 
   FractionBox["59173", "2850"], ",", "1", ",", "2", ",", 
   FractionBox["1229", "5700"]}], "}"}]], "Output",
 CellChangeTimes->{3.7813359209547787`*^9, 3.7813371842991004`*^9, 
  3.781431595084545*^9, 3.7814316412199316`*^9, 3.78143191246498*^9, 
  3.8049139380480256`*^9, 3.8049140257212276`*^9, 3.8051072259980726`*^9, 
  3.805288619436673*^9, 3.805291198016679*^9, 3.8052926240189466`*^9, 
  3.805628400509802*^9, 3.8056400944533825`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"6ff5a32e-a2cb-4c3b-8774-d525b7b3cd27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.78`", ",", "0.5`", ",", "20.`", ",", "20.762456140350878`", ",", "1.`", 
   ",", "2.`", ",", "0.21561403508771929`"}], "}"}]], "Output",
 CellChangeTimes->{3.7813359209547787`*^9, 3.7813371842991004`*^9, 
  3.781431595084545*^9, 3.7814316412199316`*^9, 3.78143191246498*^9, 
  3.8049139380480256`*^9, 3.8049140257212276`*^9, 3.8051072259980726`*^9, 
  3.805288619436673*^9, 3.805291198016679*^9, 3.8052926240189466`*^9, 
  3.805628400509802*^9, 3.805640094469011*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"bfd657a5-48b4-425b-94f5-896a6e8bc0fb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"nsol", ",", "ev", ",", "plotter"}], "]"}], ";", 
  RowBox[{"nsol", "=", 
   RowBox[{"First", "@", 
    RowBox[{"NSolve", "[", 
     RowBox[{
      RowBox[{"Join", "@@", 
       RowBox[{"Thread", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"p", "[", 
              RowBox[{"x", ",", "y"}], "]"}], ",", 
             RowBox[{"q", "[", 
              RowBox[{"x", ",", "y"}], "]"}]}], "}"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], ">", "0"}]}], "}"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "20"}], 
     "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ev", "=", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{"q", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "nsol"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotter", "[", 
   RowBox[{"\[Tau]_", ",", "shift_", ",", 
    RowBox[{"ag_", ":", "Automatic"}], ",", 
    RowBox[{"pg_", ":", "Automatic"}], ",", 
    RowBox[{"pp_", ":", "1000"}], ",", 
    RowBox[{"ar_", ":", "Automatic"}], ",", "opts___"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"startingpoint", ",", "sys", ",", "solution", ",", "plot1"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"startingpoint", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "/.", "nsol"}], ")"}], "+", 
       "shift"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sys", ":=", 
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"u", "'"}], "[", "t", "]"}], "\[Equal]", 
             RowBox[{"p", "[", 
              RowBox[{
               RowBox[{"u", "[", "t", "]"}], ",", 
               RowBox[{"v", "[", "t", "]"}]}], "]"}]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"v", "'"}], "[", "t", "]"}], "\[Equal]", 
             RowBox[{"q", "[", 
              RowBox[{
               RowBox[{"u", "[", "t", "]"}], ",", 
               RowBox[{"v", "[", "t", "]"}]}], "]"}]}]}], "}"}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"u", "[", "0", "]"}], ",", 
              RowBox[{"v", "[", "0", "]"}]}], "}"}], "\[Equal]", 
            "startingpoint"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"u", ",", "v"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "\[Tau]"}], "}"}], ",", 
        RowBox[{"AccuracyGoal", "\[Rule]", "ag"}], ",", 
        RowBox[{"PrecisionGoal", "\[Rule]", "pg"}], ",", "opts"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"solution", "[", "t_", "]"}], ":=", 
      RowBox[{"Through", "[", 
       RowBox[{"sys", "[", "t", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"solution", "[", "t", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
         RowBox[{"Epilog", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
            RowBox[{"Point", "[", "startingpoint", "]"}], ",", 
            "\[IndentingNewLine]", "Orange", ",", 
            RowBox[{"Point", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}], "/.", "nsol"}], "]"}]}], 
           "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "ar"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "14", "]"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"solution", "[", "t", "]"}], "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "x"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "12", "]"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"solution", "[", "t", "]"}], "\[LeftDoubleBracket]", "2", 
           "\[RightDoubleBracket]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "12", "]"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.725951018471774*^9, 3.7259510541579056`*^9}, {
   3.72595109882512*^9, 3.725951098934497*^9}, {3.7259512465966597`*^9, 
   3.725951267937873*^9}, {3.7259513199145203`*^9, 3.7259513207895527`*^9}, 
   3.7259516253536515`*^9, {3.72595165560401*^9, 3.725951710986269*^9}, {
   3.725951755516325*^9, 3.7259517878284864`*^9}, {3.7259519298496003`*^9, 
   3.7259519515686255`*^9}, {3.725952009739704*^9, 3.7259520188178945`*^9}, {
   3.725952387233214*^9, 3.725952387295699*^9}, {3.7259524746256666`*^9, 
   3.725952499766569*^9}, {3.7259525782519217`*^9, 3.725952578345711*^9}, {
   3.7259526611909723`*^9, 3.7259526807693987`*^9}, {3.725952954573557*^9, 
   3.7259529547141294`*^9}, {3.7259530027223206`*^9, 3.725953046264673*^9}, {
   3.725953195929447*^9, 3.7259532795223675`*^9}, {3.725953499818108*^9, 
   3.725953499880659*^9}, {3.725953679289856*^9, 3.725953696560947*^9}, {
   3.725954151730567*^9, 3.7259541797309713`*^9}, {3.725954211971033*^9, 
   3.7259542452666683`*^9}, {3.7259543178820467`*^9, 
   3.7259543200227003`*^9}, {3.7259544348999004`*^9, 
   3.7259544719487567`*^9}, {3.7259545189279666`*^9, 3.7259545212092433`*^9}, 
   3.725956341949399*^9, {3.7259563921987023`*^9, 3.725956429596108*^9}, 
   3.7259620148169007`*^9, {3.725962158451107*^9, 3.725962173201294*^9}, {
   3.7259625195251427`*^9, 3.7259625632427163`*^9}, {3.7259625984692855`*^9, 
   3.7259626687459073`*^9}, {3.7259627067860503`*^9, 
   3.7259627197236595`*^9}, {3.725962750118211*^9, 3.725962763884011*^9}, {
   3.725963124220377*^9, 3.7259631273610964`*^9}, {3.7259635697076955`*^9, 
   3.7259636329179497`*^9}, 3.731821057801586*^9, {3.73182180734424*^9, 
   3.731821807453618*^9}, {3.7318218713137856`*^9, 3.731821874845133*^9}, {
   3.731823085125312*^9, 3.7318230869222355`*^9}, {3.731823151469929*^9, 
   3.731823151532412*^9}, {3.731823237819357*^9, 3.7318232379287853`*^9}, {
   3.731823472110609*^9, 3.731823472235705*^9}, {3.731823506006684*^9, 
   3.7318235064400153`*^9}, {3.7318235515819197`*^9, 
   3.7318235516189194`*^9}, {3.7318235842210674`*^9, 3.731823584325148*^9}, {
   3.7318236205138464`*^9, 3.7318236212013354`*^9}, {3.7318236636254573`*^9, 
   3.7318236646031485`*^9}, 3.7323401636643972`*^9, {3.732340893728324*^9, 
   3.732341225603973*^9}, {3.73234128054158*^9, 3.732341693042387*^9}, {
   3.7323417384174757`*^9, 3.732341765198777*^9}, {3.732341796401965*^9, 
   3.732341798605096*^9}, {3.7323418316364093`*^9, 3.7323418346364136`*^9}, {
   3.73234188087088*^9, 3.732342060293106*^9}, {3.7323423410905313`*^9, 
   3.7323423830124865`*^9}, {3.7323424251688185`*^9, 3.732342426996949*^9}, {
   3.7323424652938967`*^9, 3.7323426540648303`*^9}, 3.7323426981117935`*^9, {
   3.732342733174362*^9, 3.732342768783806*^9}, {3.73234283567456*^9, 
   3.7323428473777084`*^9}, {3.7323429383778877`*^9, 
   3.7323429427372704`*^9}, {3.732343011190529*^9, 3.7323430467062235`*^9}, {
   3.7323455294142046`*^9, 3.732345532148585*^9}, {3.7323455727736635`*^9, 
   3.7323456769769917`*^9}, {3.732345741961494*^9, 3.7323460470245914`*^9}, {
   3.732363556880739*^9, 3.7323636160451765`*^9}, {3.732363805103446*^9, 
   3.732363867256549*^9}, {3.7323639826193886`*^9, 3.7323640285753202`*^9}, {
   3.7323641069627542`*^9, 3.7323641199134026`*^9}, {3.732364219876972*^9, 
   3.732364234853303*^9}, {3.7323642665670757`*^9, 3.732364284743009*^9}, {
   3.732364753882926*^9, 3.732364769089088*^9}, {3.732364885227192*^9, 
   3.732364910422799*^9}, {3.732364941705613*^9, 3.7323649468826475`*^9}, {
   3.732365192707981*^9, 3.732365241192793*^9}, 3.732365299801591*^9, {
   3.732602326433159*^9, 3.732602328250841*^9}, {3.7326023589883137`*^9, 
   3.732602363297821*^9}, {3.7326024252932262`*^9, 3.732602521808545*^9}, {
   3.732602556231493*^9, 3.7326025646870914`*^9}, {3.732602881319995*^9, 
   3.7326029143714466`*^9}, {3.7326029515344915`*^9, 3.732602995225852*^9}, {
   3.7326030452990475`*^9, 3.7326030478485413`*^9}, {3.7326031073219404`*^9, 
   3.7326031106812224`*^9}, {3.7326031473425283`*^9, 3.732603161171672*^9}, {
   3.733117113983551*^9, 3.7331171154644623`*^9}, {3.733634774750707*^9, 
   3.733634808367937*^9}, {3.733634882331922*^9, 3.73363491962148*^9}, {
   3.733634993972982*^9, 3.733635108494333*^9}, 3.733635277726185*^9, {
   3.7336353984841557`*^9, 3.7336355625254707`*^9}, {3.733635618018591*^9, 
   3.733635620823292*^9}, {3.7336357205642424`*^9, 3.7336358072937584`*^9}, {
   3.733636058077145*^9, 3.7336362222985344`*^9}, {3.7336362556659946`*^9, 
   3.7336362568660736`*^9}, {3.733636293109639*^9, 3.733636294156809*^9}, {
   3.733636325055462*^9, 3.733636397156248*^9}, {3.733636496630499*^9, 
   3.7336365780224695`*^9}, {3.7336366157901125`*^9, 
   3.7336366487819033`*^9}, {3.7336367129504795`*^9, 
   3.7336367514921193`*^9}, {3.733636785919958*^9, 3.7336369086893215`*^9}, {
   3.7336389315010867`*^9, 3.7336390431339564`*^9}, {3.7336392347292876`*^9, 
   3.7336392409860563`*^9}, {3.733639280395208*^9, 3.733639430600999*^9}, {
   3.733639511352738*^9, 3.733639512905551*^9}, {3.733639997442957*^9, 
   3.7336400896779613`*^9}, {3.7336423450229273`*^9, 
   3.7336423956002827`*^9}, {3.733642481516223*^9, 3.7336424824121094`*^9}, {
   3.7336425348084745`*^9, 3.7336425886537223`*^9}, {3.733721453587452*^9, 
   3.73372155286427*^9}, {3.7337218539704432`*^9, 3.733721858736964*^9}, {
   3.7337219052476096`*^9, 3.7337219062049437`*^9}, {3.7337219376212125`*^9, 
   3.733721941931053*^9}, {3.7337219833912907`*^9, 3.733721988391245*^9}, {
   3.733722029510027*^9, 3.733722030405091*^9}, {3.7337223049077415`*^9, 
   3.7337223083615785`*^9}, {3.733722485907642*^9, 3.733722492298682*^9}, {
   3.733722571126662*^9, 3.733722644359404*^9}, {3.7337229334986696`*^9, 
   3.7337229559795713`*^9}, {3.7337231048663197`*^9, 3.73372312136259*^9}, {
   3.7337253721166253`*^9, 3.7337253730136027`*^9}, {3.7337254079974194`*^9, 
   3.7337254875307727`*^9}, {3.7337255241497054`*^9, 3.733725542324357*^9}, {
   3.7337255756189156`*^9, 3.7337257446837835`*^9}, {3.7337257781950903`*^9, 
   3.733725780307133*^9}, {3.7337259813733635`*^9, 3.7337259849601326`*^9}, 
   3.733726036460616*^9, {3.733726075855137*^9, 3.733726097234729*^9}, {
   3.7383333156689425`*^9, 3.738333320403438*^9}, {3.7389086144165344`*^9, 
   3.73890861822908*^9}, {3.738908795563837*^9, 3.7389088028763995`*^9}, {
   3.738911491562016*^9, 3.738911496577676*^9}, {3.738911530046855*^9, 
   3.738911533499996*^9}, {3.738911565333056*^9, 3.738911566676869*^9}, {
   3.7389115970366106`*^9, 3.7389115973178406`*^9}, 3.738911931719096*^9, {
   3.7390774462762594`*^9, 3.7390774550732403`*^9}, {3.73907792326539*^9, 
   3.7390779324061728`*^9}, {3.739081559868747*^9, 3.7390815806815467`*^9}, {
   3.739081823270604*^9, 3.7390818838650923`*^9}, {3.739081935100133*^9, 
   3.7390819380845423`*^9}, {3.7390820219334316`*^9, 
   3.7390820579807415`*^9}, {3.739082098059351*^9, 3.739082107528164*^9}, {
   3.73908216397058*^9, 3.739082168173757*^9}, {3.739082433915371*^9, 
   3.7390824509624434`*^9}, {3.739082558499016*^9, 3.739082558545885*^9}, {
   3.739083623799018*^9, 3.739083625080233*^9}, {3.751700765550156*^9, 
   3.75170079062833*^9}, {3.7517035295265045`*^9, 3.7517035305046024`*^9}, {
   3.751703655929144*^9, 3.7517036563431845`*^9}, {3.751703698857436*^9, 
   3.7517037034238925`*^9}, {3.751703819892538*^9, 3.751703840779627*^9}, {
   3.75170390311786*^9, 3.7517039035729055`*^9}, {3.751703942077756*^9, 
   3.751704081483695*^9}, {3.751704172397785*^9, 3.751704172756821*^9}, 
   3.7517042500195465`*^9, {3.7519660575948877`*^9, 3.751966062184888*^9}, {
   3.7519662860448875`*^9, 3.7519662892188873`*^9}, 3.7591498004493966`*^9, 
   3.7592115996612077`*^9, {3.759473841647604*^9, 3.7594738473195524`*^9}, {
   3.7813327073656855`*^9, 3.7813327089750805`*^9}, {3.78133308033939*^9, 
   3.7813330910739083`*^9}, {3.7813331444808655`*^9, 3.7813331465746436`*^9}, 
   3.7813365743311095`*^9, {3.7814315789861555`*^9, 3.7814315794451094`*^9}, {
   3.781431625204533*^9, 3.7814316262994237`*^9}, {3.7814318734729805`*^9, 
   3.7814318739539804`*^9}, {3.7814319397639804`*^9, 
   3.7814320091639805`*^9}, {3.8051071993645535`*^9, 
   3.8051072025677214`*^9}, {3.8051072923471003`*^9, 3.805107293143959*^9}, {
   3.805628251078804*^9, 3.805628314001488*^9}, {3.805628453347945*^9, 
   3.805628457723028*^9}, {3.805628572958909*^9, 3.805628590052866*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"2afe0d64-74c0-47a7-b639-4859356686b8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "x", "\[Rule]", 
    "1.00000000000000000000086575870511146426`19.69897000433602"}], ",", 
   RowBox[{"y", "\[Rule]", "7.99122807017543859648887055931552980972`20."}]}],
   "}"}]], "Output",
 CellChangeTimes->{3.781335928800563*^9, 3.781337186249295*^9, 
  3.7814315973073235`*^9, 3.7814316435606976`*^9, 3.7814320151169806`*^9, 
  3.804913963004177*^9, 3.804914029316103*^9, 3.8051072288711157`*^9, 
  3.8051072938627152`*^9, 3.805288642779748*^9, 3.8052912086574426`*^9, 
  3.8052926305462227`*^9, 3.805628403425376*^9, 3.8056284846452227`*^9, 
  3.8056285927091436`*^9, 3.805640109187971*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"b76e96f4-d013-42ae-b99d-29140d368a9e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "1.8969011909336949593199830536245089528`18.689688411829415*^-21", "+", 
    RowBox[{
    "1.06195119985675094224471466554796622987`18.689688411829415", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "1.8969011909336949593199830536245089528`18.689688411829415*^-21", "-", 
    RowBox[{
    "1.06195119985675094224471466554796622987`18.689688411829415", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.781335928800563*^9, 3.781337186249295*^9, 
  3.7814315973073235`*^9, 3.7814316435606976`*^9, 3.7814320151169806`*^9, 
  3.804913963004177*^9, 3.804914029316103*^9, 3.8051072288711157`*^9, 
  3.8051072938627152`*^9, 3.805288642779748*^9, 3.8052912086574426`*^9, 
  3.8052926305462227`*^9, 3.805628403425376*^9, 3.8056284846452227`*^9, 
  3.8056285927091436`*^9, 3.805640109187971*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"bbdbcc2b-a794-46f9-8057-9dd0320b1117"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plotter with arrow", "Subsection",
 CellChangeTimes->{{3.8052886621862526`*^9, 3.8052886889366074`*^9}, {
  3.805291130328466*^9, 
  3.805291132922252*^9}},ExpressionUUID->"19700e36-7ae7-4bd5-9cc7-\
5c27a9a5e30a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", 
   RowBox[{"nsol", ",", "ev", ",", "plotterarrow"}], "]"}], ";", 
  RowBox[{"nsol", "=", 
   RowBox[{"First", "@", 
    RowBox[{"NSolve", "[", 
     RowBox[{
      RowBox[{"Join", "@@", 
       RowBox[{"Thread", "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"p", "[", 
              RowBox[{"x", ",", "y"}], "]"}], ",", 
             RowBox[{"q", "[", 
              RowBox[{"x", ",", "y"}], "]"}]}], "}"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], ">", "0"}]}], "}"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", "20"}], 
     "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ev", "=", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", 
        RowBox[{"q", "[", 
         RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], "/.", "nsol"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotterarrow", "[", 
   RowBox[{"\[Tau]_", ",", "shift_", ",", 
    RowBox[{"ag_", ":", "Automatic"}], ",", 
    RowBox[{"pg_", ":", "Automatic"}], ",", 
    RowBox[{"pp_", ":", "1000"}], ",", 
    RowBox[{"ar_", ":", "Automatic"}], ",", "arrow_", ",", "opts___"}], "]"}],
   ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"startingpoint", ",", "sys", ",", "solution", ",", "plot1"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"startingpoint", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "/.", "nsol"}], ")"}], "+", 
       "shift"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sys", ":=", 
      RowBox[{"NDSolveValue", "[", 
       RowBox[{
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"u", "'"}], "[", "t", "]"}], "\[Equal]", 
             RowBox[{"p", "[", 
              RowBox[{
               RowBox[{"u", "[", "t", "]"}], ",", 
               RowBox[{"v", "[", "t", "]"}]}], "]"}]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"v", "'"}], "[", "t", "]"}], "\[Equal]", 
             RowBox[{"q", "[", 
              RowBox[{
               RowBox[{"u", "[", "t", "]"}], ",", 
               RowBox[{"v", "[", "t", "]"}]}], "]"}]}]}], "}"}], ",", 
          RowBox[{"Thread", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"u", "[", "0", "]"}], ",", 
              RowBox[{"v", "[", "0", "]"}]}], "}"}], "\[Equal]", 
            "startingpoint"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"u", ",", "v"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "\[Tau]"}], "}"}], ",", 
        RowBox[{"AccuracyGoal", "\[Rule]", "ag"}], ",", 
        RowBox[{"PrecisionGoal", "\[Rule]", "pg"}], ",", "opts"}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"solution", "[", "t_", "]"}], ":=", 
      RowBox[{"Through", "[", 
       RowBox[{"sys", "[", "t", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{"solution", "[", "t", "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
         RowBox[{"Epilog", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Black", ",", 
            RowBox[{"Arrowheads", "\[Rule]", "0.07"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{"startingpoint", ",", "arrow"}], "}"}], "]"}], ",", 
            "Red", ",", 
            RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
            RowBox[{"Point", "[", "startingpoint", "]"}], ",", "Orange", ",", 
            "\[IndentingNewLine]", " ", 
            RowBox[{"Point", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}], "/.", "nsol"}], "]"}]}], 
           "\[IndentingNewLine]", "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "ar"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "14", "]"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"solution", "[", "t", "]"}], "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "x"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "12", "]"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Evaluate", "[", 
          RowBox[{
           RowBox[{"solution", "[", "t", "]"}], "\[LeftDoubleBracket]", "2", 
           "\[RightDoubleBracket]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Tau]"}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"t", ",", "y"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "12", "]"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "200"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.725951018471774*^9, 3.7259510541579056`*^9}, {
   3.72595109882512*^9, 3.725951098934497*^9}, {3.7259512465966597`*^9, 
   3.725951267937873*^9}, {3.7259513199145203`*^9, 3.7259513207895527`*^9}, 
   3.7259516253536515`*^9, {3.72595165560401*^9, 3.725951710986269*^9}, {
   3.725951755516325*^9, 3.7259517878284864`*^9}, {3.7259519298496003`*^9, 
   3.7259519515686255`*^9}, {3.725952009739704*^9, 3.7259520188178945`*^9}, {
   3.725952387233214*^9, 3.725952387295699*^9}, {3.7259524746256666`*^9, 
   3.725952499766569*^9}, {3.7259525782519217`*^9, 3.725952578345711*^9}, {
   3.7259526611909723`*^9, 3.7259526807693987`*^9}, {3.725952954573557*^9, 
   3.7259529547141294`*^9}, {3.7259530027223206`*^9, 3.725953046264673*^9}, {
   3.725953195929447*^9, 3.7259532795223675`*^9}, {3.725953499818108*^9, 
   3.725953499880659*^9}, {3.725953679289856*^9, 3.725953696560947*^9}, {
   3.725954151730567*^9, 3.7259541797309713`*^9}, {3.725954211971033*^9, 
   3.7259542452666683`*^9}, {3.7259543178820467`*^9, 
   3.7259543200227003`*^9}, {3.7259544348999004`*^9, 
   3.7259544719487567`*^9}, {3.7259545189279666`*^9, 3.7259545212092433`*^9}, 
   3.725956341949399*^9, {3.7259563921987023`*^9, 3.725956429596108*^9}, 
   3.7259620148169007`*^9, {3.725962158451107*^9, 3.725962173201294*^9}, {
   3.7259625195251427`*^9, 3.7259625632427163`*^9}, {3.7259625984692855`*^9, 
   3.7259626687459073`*^9}, {3.7259627067860503`*^9, 
   3.7259627197236595`*^9}, {3.725962750118211*^9, 3.725962763884011*^9}, {
   3.725963124220377*^9, 3.7259631273610964`*^9}, {3.7259635697076955`*^9, 
   3.7259636329179497`*^9}, 3.731821057801586*^9, {3.73182180734424*^9, 
   3.731821807453618*^9}, {3.7318218713137856`*^9, 3.731821874845133*^9}, {
   3.731823085125312*^9, 3.7318230869222355`*^9}, {3.731823151469929*^9, 
   3.731823151532412*^9}, {3.731823237819357*^9, 3.7318232379287853`*^9}, {
   3.731823472110609*^9, 3.731823472235705*^9}, {3.731823506006684*^9, 
   3.7318235064400153`*^9}, {3.7318235515819197`*^9, 
   3.7318235516189194`*^9}, {3.7318235842210674`*^9, 3.731823584325148*^9}, {
   3.7318236205138464`*^9, 3.7318236212013354`*^9}, {3.7318236636254573`*^9, 
   3.7318236646031485`*^9}, 3.7323401636643972`*^9, {3.732340893728324*^9, 
   3.732341225603973*^9}, {3.73234128054158*^9, 3.732341693042387*^9}, {
   3.7323417384174757`*^9, 3.732341765198777*^9}, {3.732341796401965*^9, 
   3.732341798605096*^9}, {3.7323418316364093`*^9, 3.7323418346364136`*^9}, {
   3.73234188087088*^9, 3.732342060293106*^9}, {3.7323423410905313`*^9, 
   3.7323423830124865`*^9}, {3.7323424251688185`*^9, 3.732342426996949*^9}, {
   3.7323424652938967`*^9, 3.7323426540648303`*^9}, 3.7323426981117935`*^9, {
   3.732342733174362*^9, 3.732342768783806*^9}, {3.73234283567456*^9, 
   3.7323428473777084`*^9}, {3.7323429383778877`*^9, 
   3.7323429427372704`*^9}, {3.732343011190529*^9, 3.7323430467062235`*^9}, {
   3.7323455294142046`*^9, 3.732345532148585*^9}, {3.7323455727736635`*^9, 
   3.7323456769769917`*^9}, {3.732345741961494*^9, 3.7323460470245914`*^9}, {
   3.732363556880739*^9, 3.7323636160451765`*^9}, {3.732363805103446*^9, 
   3.732363867256549*^9}, {3.7323639826193886`*^9, 3.7323640285753202`*^9}, {
   3.7323641069627542`*^9, 3.7323641199134026`*^9}, {3.732364219876972*^9, 
   3.732364234853303*^9}, {3.7323642665670757`*^9, 3.732364284743009*^9}, {
   3.732364753882926*^9, 3.732364769089088*^9}, {3.732364885227192*^9, 
   3.732364910422799*^9}, {3.732364941705613*^9, 3.7323649468826475`*^9}, {
   3.732365192707981*^9, 3.732365241192793*^9}, 3.732365299801591*^9, {
   3.732602326433159*^9, 3.732602328250841*^9}, {3.7326023589883137`*^9, 
   3.732602363297821*^9}, {3.7326024252932262`*^9, 3.732602521808545*^9}, {
   3.732602556231493*^9, 3.7326025646870914`*^9}, {3.732602881319995*^9, 
   3.7326029143714466`*^9}, {3.7326029515344915`*^9, 3.732602995225852*^9}, {
   3.7326030452990475`*^9, 3.7326030478485413`*^9}, {3.7326031073219404`*^9, 
   3.7326031106812224`*^9}, {3.7326031473425283`*^9, 3.732603161171672*^9}, {
   3.733117113983551*^9, 3.7331171154644623`*^9}, {3.733634774750707*^9, 
   3.733634808367937*^9}, {3.733634882331922*^9, 3.73363491962148*^9}, {
   3.733634993972982*^9, 3.733635108494333*^9}, 3.733635277726185*^9, {
   3.7336353984841557`*^9, 3.7336355625254707`*^9}, {3.733635618018591*^9, 
   3.733635620823292*^9}, {3.7336357205642424`*^9, 3.7336358072937584`*^9}, {
   3.733636058077145*^9, 3.7336362222985344`*^9}, {3.7336362556659946`*^9, 
   3.7336362568660736`*^9}, {3.733636293109639*^9, 3.733636294156809*^9}, {
   3.733636325055462*^9, 3.733636397156248*^9}, {3.733636496630499*^9, 
   3.7336365780224695`*^9}, {3.7336366157901125`*^9, 
   3.7336366487819033`*^9}, {3.7336367129504795`*^9, 
   3.7336367514921193`*^9}, {3.733636785919958*^9, 3.7336369086893215`*^9}, {
   3.7336389315010867`*^9, 3.7336390431339564`*^9}, {3.7336392347292876`*^9, 
   3.7336392409860563`*^9}, {3.733639280395208*^9, 3.733639430600999*^9}, {
   3.733639511352738*^9, 3.733639512905551*^9}, {3.733639997442957*^9, 
   3.7336400896779613`*^9}, {3.7336423450229273`*^9, 
   3.7336423956002827`*^9}, {3.733642481516223*^9, 3.7336424824121094`*^9}, {
   3.7336425348084745`*^9, 3.7336425886537223`*^9}, {3.733721453587452*^9, 
   3.73372155286427*^9}, {3.7337218539704432`*^9, 3.733721858736964*^9}, {
   3.7337219052476096`*^9, 3.7337219062049437`*^9}, {3.7337219376212125`*^9, 
   3.733721941931053*^9}, {3.7337219833912907`*^9, 3.733721988391245*^9}, {
   3.733722029510027*^9, 3.733722030405091*^9}, {3.7337223049077415`*^9, 
   3.7337223083615785`*^9}, {3.733722485907642*^9, 3.733722492298682*^9}, {
   3.733722571126662*^9, 3.733722644359404*^9}, {3.7337229334986696`*^9, 
   3.7337229559795713`*^9}, {3.7337231048663197`*^9, 3.73372312136259*^9}, {
   3.7337253721166253`*^9, 3.7337253730136027`*^9}, {3.7337254079974194`*^9, 
   3.7337254875307727`*^9}, {3.7337255241497054`*^9, 3.733725542324357*^9}, {
   3.7337255756189156`*^9, 3.7337257446837835`*^9}, {3.7337257781950903`*^9, 
   3.733725780307133*^9}, {3.7337259813733635`*^9, 3.7337259849601326`*^9}, 
   3.733726036460616*^9, {3.733726075855137*^9, 3.733726097234729*^9}, {
   3.7383333156689425`*^9, 3.738333320403438*^9}, {3.7389086144165344`*^9, 
   3.73890861822908*^9}, {3.738908795563837*^9, 3.7389088028763995`*^9}, {
   3.738911491562016*^9, 3.738911496577676*^9}, {3.738911530046855*^9, 
   3.738911533499996*^9}, {3.738911565333056*^9, 3.738911566676869*^9}, {
   3.7389115970366106`*^9, 3.7389115973178406`*^9}, 3.738911931719096*^9, {
   3.7390774462762594`*^9, 3.7390774550732403`*^9}, {3.73907792326539*^9, 
   3.7390779324061728`*^9}, {3.739081559868747*^9, 3.7390815806815467`*^9}, {
   3.739081823270604*^9, 3.7390818838650923`*^9}, {3.739081935100133*^9, 
   3.7390819380845423`*^9}, {3.7390820219334316`*^9, 
   3.7390820579807415`*^9}, {3.739082098059351*^9, 3.739082107528164*^9}, {
   3.73908216397058*^9, 3.739082168173757*^9}, {3.739082433915371*^9, 
   3.7390824509624434`*^9}, {3.739082558499016*^9, 3.739082558545885*^9}, {
   3.739083623799018*^9, 3.739083625080233*^9}, {3.751700765550156*^9, 
   3.75170079062833*^9}, {3.7517035295265045`*^9, 3.7517035305046024`*^9}, {
   3.751703655929144*^9, 3.7517036563431845`*^9}, {3.751703698857436*^9, 
   3.7517037034238925`*^9}, {3.751703819892538*^9, 3.751703840779627*^9}, {
   3.75170390311786*^9, 3.7517039035729055`*^9}, {3.751703942077756*^9, 
   3.751704081483695*^9}, {3.751704172397785*^9, 3.751704172756821*^9}, 
   3.7517042500195465`*^9, {3.7519660575948877`*^9, 3.751966062184888*^9}, {
   3.7519662860448875`*^9, 3.7519662892188873`*^9}, 3.7591498004493966`*^9, 
   3.7592115996612077`*^9, {3.759473841647604*^9, 3.7594738473195524`*^9}, {
   3.7813327073656855`*^9, 3.7813327089750805`*^9}, {3.78133308033939*^9, 
   3.7813330910739083`*^9}, {3.7813331444808655`*^9, 3.7813331465746436`*^9}, 
   3.7813365743311095`*^9, {3.7814315789861555`*^9, 3.7814315794451094`*^9}, {
   3.781431625204533*^9, 3.7814316262994237`*^9}, {3.7814318734729805`*^9, 
   3.7814318739539804`*^9}, {3.7814319397639804`*^9, 
   3.7814320091639805`*^9}, {3.8051071993645535`*^9, 
   3.8051072025677214`*^9}, {3.8051072923471003`*^9, 3.805107293143959*^9}, {
   3.8052886750926785`*^9, 3.805288684780306*^9}, {3.8052889383149524`*^9, 
   3.8052889390336804`*^9}, {3.805289071254197*^9, 3.8052890930826564`*^9}, {
   3.8052909113567553`*^9, 3.805290912731773*^9}, {3.805290993060965*^9, 
   3.805291031327127*^9}, {3.8052910677651353`*^9, 3.8052910792809134`*^9}, {
   3.8052911385160303`*^9, 3.8052911485318336`*^9}, {3.8052913302840877`*^9, 
   3.8052913471436863`*^9}, {3.8052915377555723`*^9, 3.80529154391195*^9}, {
   3.8052915867562437`*^9, 3.805291644256979*^9}, {3.805628411909895*^9, 
   3.8056284344101934`*^9}, {3.805628605349963*^9, 3.8056286071937385`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"9e2583d7-fce0-4760-ac14-28158955154a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "x", "\[Rule]", 
    "1.00000000000000000000086575870511146426`19.69897000433602"}], ",", 
   RowBox[{"y", "\[Rule]", "7.99122807017543859648887055931552980972`20."}]}],
   "}"}]], "Output",
 CellChangeTimes->{
  3.8052889404243283`*^9, 3.8052890944888706`*^9, 3.805290914341172*^9, 
   3.8052910812496357`*^9, 3.8052912220169983`*^9, 3.8052913505655775`*^9, 
   3.8052915455369196`*^9, {3.8052915973344812`*^9, 3.805291644475732*^9}, 
   3.805292633265008*^9, 3.805628491707799*^9, 3.805628613803173*^9, 
   3.8056401004690876`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"ec4139de-014d-4006-8d2d-0d41b9ada5f5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "1.8969011909336949593199830536245089528`18.689688411829415*^-21", "+", 
    RowBox[{
    "1.06195119985675094224471466554796622987`18.689688411829415", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "1.8969011909336949593199830536245089528`18.689688411829415*^-21", "-", 
    RowBox[{
    "1.06195119985675094224471466554796622987`18.689688411829415", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8052889404243283`*^9, 3.8052890944888706`*^9, 3.805290914341172*^9, 
   3.8052910812496357`*^9, 3.8052912220169983`*^9, 3.8052913505655775`*^9, 
   3.8052915455369196`*^9, {3.8052915973344812`*^9, 3.805291644475732*^9}, 
   3.805292633265008*^9, 3.805628491707799*^9, 3.805628613803173*^9, 
   3.8056401004690876`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"486ac606-573a-4220-8d3c-6c96150f2793"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 2", "Subsection",
 CellChangeTimes->{{3.7813364697196493`*^9, 3.7813364917938566`*^9}, {
  3.7814370421640973`*^9, 3.7814370450673876`*^9}, {3.8052926958464046`*^9, 
  3.80529269592453*^9}},ExpressionUUID->"2e96fdfc-02ad-4460-b5c5-\
fe249efd79bc"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plotter", "[", 
  RowBox[{"100", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", "Automatic", ",", "100", ",", 
   "1000", ",", "Automatic", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<BDF\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"plotterarrow", "[", 
  RowBox[{"100", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}], ",", "Automatic", ",", "100", ",", 
   "1000", ",", "Automatic", ",", 
   RowBox[{"{", 
    RowBox[{"3.586", ",", "15.36"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<BDF\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{
  3.781333987813089*^9, {3.805291573537343*^9, 3.80529157367797*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"5f59341a-75e4-42c6-aafa-4ab55137bf3c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwk2nc8Vf//AHAqQsaxUnKuq+xkFCrU+yUZWSUJhQiJSCgUFSFCpVKShlGK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         "]]},
       Annotation[#, "Charting`Private`Tag$5366#1"]& ]}, {}},
    Axes->{True, True},
    AxesLabel->{
      FormBox["x", TraditionalForm], 
      FormBox["y", TraditionalForm]},
    AxesOrigin->{0.4877672231892922, 1.3077234652170997`},
    AxesStyle->Arrowheads[Automatic],
    DisplayFunction->Identity,
    Epilog->{
      RGBColor[1, 0, 0], 
      PointSize[0.05], 
      PointBox[{1., 17.99122807017544}], 
      RGBColor[1, 0.5, 0], 
      PointBox[{1., 7.991228070175438}]},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->200,
    LabelStyle->Directive[14],
    Method->{
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwU2nc8le8bB3B7HhxCVvY4zrHHQeu+ElIiW1IqSUQkI0RJRihKS8heGSXJ
LF8VpagQKY1zzOzsPX73769e79c553GPz3U9z/16knHxsT7NxMDA8FeAgeH/
/wpURNz7+idkN8/TtxlMDFOIwzNRgDH/MJp9U+ea+WgKMcOwbUueO6opfuva
ajiNwosEA8vygpDhkHN9fP4Mavg38FPoy2W0x/1gbJnbLApP6cncFRqB9JKY
b97QnEP/0YrYcvKuo+nfexUqx+aRM9OdGrvaeMRh1/bs2u8FtCF/yYvjSwKS
OXJ9vyBtEX3JeZb4e/oWYhafLpScWUJSLxRGqKFJiMQ/fShZZAV5v3toeIvt
LiJP3n/UYLuK6rt50kZu3UOwzzZU7fEacl6Zt0jLS0Y6LocINgWb6An32cJ5
9RTE2TBVe6CEATYk/jAeqk1FMdwVeyqTGcFCzdqp0OgR8t5uvrculQkeoXcV
jF/S0cG9gcml1cwQSNoWU6qSidL20anXZllAUrNbu2c6E/m+rmFftmSDdwa3
6WxVWehiZW17wzd28DY0u6kdmo0+x7wyrI3nBGEz1u0n9uSgac3A7QZB3FBv
89/QDbZc5NT1lM0pnwfcjgbfqWnJRdIuEo66/ETgPa0NQ7fyUIznFdvCMH6o
PDcxLmCfj16ZXnweLrMFnAMLHiLxApRa96LHjV0I2K6cNPGiF6BOHjHF4h1b
4UmM+GxyXiH6zBn/r6tFFOxvdWU0nX2MFkyP6JxpkoCN5MSDM+pF6KHTx4b7
otKQn7V/WXK+CDW63MrcR5AFiyLmfLPaYlTL2b3DTlceFspfWQddKUHci9vD
QyIVIb3u4mauUSmq/n1Ih/E3CUwaNUvaOZ8g6R0FWg6iFJhoHTu88fkJyuoX
1n4sqAp3u/JYKXefoid88odEKtVA8p/6j2KVMlTVkm8XuaAOF2ZvqBsmliHz
bxsOW3w04N3iSNT36TJUW7yU2lCvAWJrJr+8bZ+h+vXiKw6zGuDNkKvFWvUM
0bT5PRoENeENC2Nsqmg5io/X+SasrAnCnM40zdBylPvmUNVLHU04y1On2/yn
HB1WZj3/fLsm1POL3HDe8xzVujZOre7UBAHhgL65nOdoZjNt1xC2m1iHfjxb
BRJ7/VDo4A5NqJVUT5TxqECTJqSCGn1N4JW7MVjVUoH+BGd/v66rCS5KIzss
1F6gpZkJzVlNTaikmCQN3HqBjL8ohWxT0wQujZzhkNkX6HnxP00psiY46zAg
fvtKNLGR4syuqAlsu2rHdolXIUYrH64n2zTB3kLN+EFeNZqyNJZ+Q9AEow6p
qCBiDQpfp6Yrc2iClj1/k+OlGlQUFJ5ymxmPx3nOSMKqFrX/kNnjuoLX71yt
UdZaHRqpMvi6dVgDdG+aGBXb/Id2O+k31b/VAC63p1k0hrdIYVrMnDdUA4Zz
32fOPvmAtj1U2WnQqw5Jq0q07YJfUWXnm9c7Z1WBKNga/ljzB3oeo5v5Sk0F
VBWr6959paFci8nsVlcyGPOTrpky9aPjenocS10k2EsQmWc5NoS+wFVTL0Ml
mNq4qCFSOIJuU1lb59sU4NVQ6ezV2nEU7/3gilmCPJQOvr2axT6Ftj70afQ1
kYP4jlTz0nvTaMNr5oiHkizsqaNcHhCfRXb8rWIekjJwPJvHbt/bOWSoKvDn
OZ808ET2+NhZLCBZpTGi4F5JkHVd1khcWUT7v2QqWjpJAB+02c+lL6MTaHUp
5r4Y3BBOamBRWkWN86o6/Kyi4DuW1wZta2iG2bSw8PRWGKrNlScd20Cdv+q6
tWeE4GRjSOIjVgZoGlGUuOAtCDuUN+tffmeAbJbOeLt1ATjGHXzr2SNG6LWJ
bRkt5ofn4+K6O/2YIOJrSITMHiJYmVVcStvODJV07cOE7zzws6DQX2CDGewY
TjNLkbnhIfM7kOxggS2spkFtEhyQ8ev7k80HrND2udH3IQ8r/KgQnAr0ZgOG
xeeiPRcYYTOupJ95DztURxkZGLuuooMNTN5CRuyw7arqPy3TVZQyf3hJcR87
bDHhfCyvsoqoJ1h5Dpizg83Bo0JCcyvIS9eZesuRHV7GX/XUiFxBPTS+WIkL
7DBVNPY3Om8ZVer4qenmsMN5uuxiwOQiYjn7odoknx1aMiR3OX9dRNYZUnsP
P2YHzdsMj6yrF9EEZ6vDpafssMLv9upExCKSp8lffV3HDkdJ/ixiWxdRUuy3
r+ad7MBUZty6c+8COvfHINiNlQPOPHIHqcI5VF3160gtBwc8+evWMn1jDjHd
vrKTl8AB/ZfLA375zqHkvU2bLwQ4oKj5qMfqjjn0ptAymlUar5NCpb17+ywS
9jtzJ3c7B7DT2lSAcRbVs98r7fPhgLsR8bffB04jjl69RKofB0SHtAaTjk8j
m9qe83GBHDDee//N433TaNhLWkcrjAOYqi9p8YpOI4GO4tqrcRwgrtlz8tSr
KeSW9ua9dB4HxJPUjVwIU4hXc6rXuYcDOicERDhjJ5AFXUws5DcHOHOfT19y
nUA3E42t79E5AGT8whX3TCDCZMqbliEOMD7FH75rZRxxFxvn6M9ywLYf+3oO
+4wjDoVUVwECJ0zKnQ01PD2GTDub0lT5OIHrAFRsNR5DMdemOk0F8H3kccUU
WWEMsfUZG18R4YQ+8+Py3EOjiDVjSmFcnhMGS80Kn54dRUyiJn+bdnFC7BCL
vveVEWTYfF6qFzihJMZyr/CpEXT1YqrD2l5OSD3XuHfFZAQxfJt6r3WAE9aj
v7gG8I2gzaTUwgx7Tjgpfa1HK2cYrRGmPYJ9OOHcwAZ/WtdftMiQNq6SxQnX
BpjXQlyHkJr0rUv6uZywkvj40qNDQ8gNRXIZFXCC8R8B8ZntQ6gzzIvkVMoJ
JEGjVA2BIVS+stM1toYTsov9s1feDCKvud8/B9s5YdP9tEqE6iDK3dJxdrqT
Ez6uluvkig+in1rvlte6OYFufqlylnMQHfB9slXwD/6+sdM/0b8DSGnyso3h
KCd0qj16G5IzgPr+SrWkM3EBM8/P2f3yA0iUXfBIESsXzLUbqUoJDSBLRY6R
FxxckHjennkb2wD6z3WK7RMvF9hMtZrfHu5Hab0NhqtiXLBdpLTT5mk/cvh5
stZBmwtiRvb8W9vbjxJW7PafonLB76WUZD29fvRO9MB3bwMuMD91lvs+uR/p
HNZaiEJccK41VPoVfz8S6GLSqjDjgmM7gjuLe/tQ6+ecx0RXLjg6GeL3MaYP
MSQNJDqf4QLuVZ4veqF9SMdOIbDkLBe8Md/668P5PpT2M9/Q1JcLNg+R048c
6UPnhh//vHKZC8y+7ZiRV+9DvExlPP+SuWBaj6BApPUiw6ap2Z1pXKBsHyaV
0dWLAq9r9sRlcMH3c3NHzVt70R/e5/mK+VyQx73Tka22Fz0Vr0TOz7lgIP23
T+/9XmSp+9L30ycuGOcnay/a9aLIpTUH8XYuICs+4Laz6EXVdbt2e3RyQetL
2X2fTHqRtOF/XKw/ucBJLr6ZW78XTVu8ydk5zAVGc01SNeK9KMm9uauYiRvs
wiYCkv/S0TsK58tlVm6Yq/z84lIvHa1M7s/ex8kNZv2cWwJ+0tGpgBbvfj5u
MLrArPT4Cx3pRHxmF9/GDUqqqct8NXTUldppEKfHDR/MSM05iXS0ofMoMGM7
NzgFP6dJxtMR6fPp5xW7uOHTAWHWomg6CmFYVKHt5YZvX1ff/wujI+nTotI6
ltygliJ2RuccHZ1Vc2b7484N+3bPFoZZ0NGd94p7Zz25wbFgtWHwAB29PPHv
CocPNxgmztg47aMjvjvhy1oB3FCTlWzpDXRUsZg9HnOVG2a+KGeoa+PxNPzt
0EzhBv4yFg8GcTpSOlLGt+8RN4yoJxioi9CR5WzQwaOZ3ND44r6VhxAd5Shw
vYvO5waTM0vfN/joyDROpeZnOTcc+8ZEL2alI1+5+fmpF9xAGfYJ12Smo5SX
r7TYarjhe6iVz2sGOpqYtCjR+I8bHDxUb2wu0lCSjW9GVAs3TBnqXxoapKG6
cYNfKZ+54avz7NlbvTQ0EMUkWtbODfJdOzTNf9OQXvWdpJ5ubvhYxemy0UlD
vyQqo9QHuKEkqOuxQRMNKQ6teP5Y4wb1H+aOfwtp6KAckUGTgQD5bnqaJ/No
6MIJhbvXmQkw5Xrp0kQWDdX3HHqpx0UA88KHYTtTacj+Sy7h/lYC+F4e7y1N
oKFQQm3mhBgBRPiEmF7E01D2/i86xpIEOK53qav1Og1Nvl0+OidPgNd+DxtV
r9FQTLVFqbUWAXSjurifBtHQk/lTe4p0CbCyd5cgNZCGOrWCuxgNCMA2qGjQ
6kdD0qU562WIAJxF8xIKPjRUnbVkzmdOAC+jWkqkGw39+cPT52ZJgMwa36XL
rjTEIiEXWG9DgNVdxPMxLjRked88/dwRArw/a1Ld4ExDw3HZky1nCECoOiXc
5kBDvM1VEXKeBAhTVMjVtqchHdZPwpe8CdAxvHgzx5aGwq8s7iYHEGDt9NDv
Aisayn9J+Ho1iABP+rcs77CkodZlmTM/LhFgXa3xx08LGhL1P5h4PYIAW0U/
2O0+SEPw7KQcPYoAWqWUfAYzGnKbDKzSiyXAjWUVxc/7aajcPYs2lEiAkMt+
cnH7aOjAsQV140cECH0YcypiLw2dT+FuTMskwNXrMR4phjR0v1v68FwOARyN
GBJf7qGhPiuz8JwiArgl1pZLAg1xJJ4QXC0l4PrvPO+MaEitNaDQ+hkBFKuX
PxfspqEQk8w2xmoCcMktztrvoqHMay9cHevwfkSIXHm5k4beNXxcKqvHZuvW
omCPr9NucLwhQLuuw3T2DhoS2DEvfaKJAK0PXqXJYesHcb2oaibAp559W0u3
05DzC6n9fK0E2O4raYywI2d0frt9IUD0p1LuHgMaKlY/4Fvfgef7ys4yDPud
4V+n310E2Ps9/qAadp9dpMnadwJ8DIq5NqRPQ+vuMprivwggPZ9Cy8MWCa0X
304jgE2OiJkXtnaiE5tjHwECfliXGWBbZC9NXRwkwP2J1GUebI8X937eHyYA
z5P3/CN6eDzNWu9ejBGg+Ibr4EfsjJ9fyjonCSAnLXvyOXbtpFfq7DQBji2W
+mZjf2PkihaYJ4Bh1gvmZOxpwYLzmksEqCsZYr6LTSAZOVmuEqC8cNL5PjZp
R6+xzwYBiPKXGDOw91pc1khg5IFXpQbfS7GdT4qLl7LwQL7W9y9vsIP9q1lb
2XnglH1X12/suzF2U6NcPPD6++b3DeyylJkeTl4eaEuQblbA82kpTWwi8fNA
pjlDkjX2UINK2T5BHjAcPaMQhc3U+SHFbSsPPsdK+77C3vbXLSpKjAd28c+c
WsXWX2E+n7uNB6qN88d34/W24ck68laaB0xKWFdisL2ldxv3yfGA8I3ekG/Y
eSZBYtJkHogN83lwDe9ng6MQK1LlAWmJSME+7F9e5f+OafDAl0mW98b/z8ed
8cZUKg+wXJ1LkMD5Uc2PfVprwAPtw1VRidimNYopP3biv9d1y58d5+8K7YTP
1r08ILJ1/zorzuc4pUv0ziEeyMs4qrIT55kdXWApt+aBWYtYiy5sWWu+f212
PCDRPr94Aef/cND+Rt6jPOAqMfm4DtdHU+Mr7zh3Hshy3bLlqjEN0buPOD72
5IGOmssrO01oaG10cW+zNw/05XMxrWNr8WuJsgXwQHE2HWJNaSj9WP7bq1d5
oCDYX7kd12vQQoJIcAoP3PrztVzQhobig+cdrz/C86eJG3Lg/pC+5pT6IJMH
6sMjxDexG5mUJSvzecAZXbq+gPsJH99budlyHnhQ0XKQ2wn3D6VFtXMtPCBk
U1nYeAr3u8PHjU+u8cCPoSN1uy7S0N+fTdHnN3ng8v0DKnG4P644qzRfYeIF
PYbLw9+DcT88vXwgnYMXvn3kVg4LpSFP3zuWPwV5waPOeCv9Kt7/uPdOdqq8
8D3WFrhu0pBmnfqF/c684DsxdKc5F/ejvj6u1JO88FUoO8E/H/dHzvs54668
YPLquZcsvh+cd1jrTPTkhSAr8strxbg/zzbrfQvihQb2O5xHy2lIRcVl3eUO
L9zOeZbn3IDz/uju9dBmXijUsv8Ti+8/kleW059q8cFoSNTljzx0ZNNQfW5s
iQ9kNFiI8gfpyDm8LebPGSJYdLJGX7hDR9czZjSt24lgur/2UCB+XrAP4yst
0+aHtrOnv5dK9eL7TwP/kXR+iOp4uXzqbC/6uOC1b5JRAAauffQoKutFrfz7
7G+eEoDQyM7xpfle5F7ywuLiJwFgOyObeX9PHypklRI5qLEFKIcua8dc70MR
fyRaPFO3wNYX/OmdXX3IutLU4T6LILge+3leThY//x30qSh2E4Th7dyfnnr0
o04X8ip3uyAsClfwv6jqR9F6dAEHHSFILjLJm2IYQB3xZMGJDCEYP6AXX285
gARp2ZM3OYVhB//g8u2MAbQyJZQi6iUM6rtbGuJHBlBIxDb1qW/C0LVyYsfO
7YMovUPq3rPtW6G9n1OXED2IqmUsO8PStkKH4+Tm1zb8PD0luH6XTQSffwQe
BssOocawzoX7HiJwOMO4T9VnCFXGkXr6O0Xg2klWcu+bIfToftH9HbtFwWs1
0Cxf6C8inVSSv5wpCixS3BlnTv1F5sX6qdzcYkCJKrzqUP0XCVcY9V/zFgOX
Mq/eHRzDqKvuMgt7mxiUHTpYJOswjNT2mvN1GYiD8d89iZ6lw4gSKzx2M00c
6KFB7Pc2htEbC/+y2+wSkNMY8+igwwha72g1CfeUgENjkaW/ikaQmr1NZfAn
CdB4OLF5aX0ELR/25qvX2wZCyz2hww6jyF0s0mAiZRtkNQfHby0dRb5OauZn
2CTh0JzT7H6uMXQ+lW37uI8kWP7waKpxG0NbUn4sOnVIwmA2g3bnqzFkKbIn
Q3iXFMDSttOG28aRpl3O1peZUnD9URW7zcVx3O8f6lAZpeGDFmPprbZxtFNR
pUObKg2DLx7YhWpNIJP+Hd/zz0iDvpv8t+mECbSNLmSDHkkD06jBYde5CeTz
K3r773ZpKJUgKxx0nERb9APipphkIG3881JO9SSK/Kp6SFlfBqqPvPl7QeYf
2vf5VGi3hwzY66iQSyP/oahmDeH4FBkIDVd3svn7D91iapZ3/SIDS3Nulgzk
KTSR+iu1nEEW6prdN64em0JbA+piFKmy8KLEodv0/hS6U7r1F5+7LDQVWFnu
ap1CcYNcjzaSZeE1S4aAINM0sjjW3CHwWRZaFgMC0nZNI1cdZt+0TVkINuFX
sMLn5X1mHJFmunKgUDDzXurFNMo7mcvMcFYO8lmFr5jOTSO77ldjyqlyoBu8
t6tIYwZ13MgyDW6Tg7SVmJpRvxmUlcXEu5tJHj4tSnjdrJhBYy9WEIe2PGTf
mZj5PT+DmLheDS2ekQdnlR+gi2aR56u1+aMP5cHqE23SPHoWZZWxhfz9LA/T
RK7//vs2i6xzCs5eZFaA5D2R1W+U55DdfNPbUB0F4PLqvH750hxSiHlyu8BD
AVw6IxN//5hD+4IEm/elKsCFpajO2/rziPrYyI+nXQE2Y+RtzArnUeYP7vjv
rIrg6exy6ofMAjrqYcktqqcISqGR/MpZC2hQ/zjDFS9FYGuToCegRZTp0XXO
5JwiLPW0pfEZLqKjKWY/ebwVoXGf2eRto0XUsapXmeajCBOs1xxS9y+ihnqi
V+0FRRh+WxTy2mYRpRm96Z4PUoTyKz9+HXVfRNaWCk+9ohTBVf1NOC0Jf//M
2LEj6YqQ239iJHViEYXMbendlqEIXTo+wlFTi0j76k7XXuz/vE1Pnp9dRPkp
N8+6ZynCz++RTubLiyj+k/rFwFxFyGg6pinDuoTstf1vJRUpgq2qGUF72xIa
21h787FSEdgf7w8SOrSEhO/zknZ8UQRa8kDpg9ol9NmMaw9fmyIEPjM47VO/
hGIY2Y70Y1tWpxQceLOElrzW4+M7FMH7y6EB7o9LqGfv+L+fXYqwv0fjd82P
JZQx/aEq9Jci3NWmTjQvLyGSedS++hFFMC48kkDbuYzoTFdPJI0qQss/+WCd
PcvoYXVosNuYIuzQvlJ703gZccn7F/NOKMKL4H/O5hbLaHzFhe/4FB4PP4mJ
6cQyKiuE7s0FRfiqbWS1L3IZGbCsue1hUYIpi8prIW3LyPvpQzt2ViU49qSb
TahrGeUe0TP6hH3RwJda8WMZEZ9dkHFkVwJbtp5qhv5lNHxs5Od5LiX4IxUs
+XV+Gd2v+maZSVQC4cWfl1wlVtDc2WfbNyWUoO1tQYr/uRVEFj6k3LRNCVau
2D6suLCCTrwe3xovqQSDFt0OKxdXUMtW0rywtBII9dK2P4hYQdmN6U/V5JSA
qTi4aGvyCrKSvCHvrKwEzp+27drZuIKetLvxvtJVgqPnL1mckFlF/XndSXeo
SnDA/ufPSaVVJBJiuvWsnhLkNmq0RqmtoghZsvRWAyVICf0n+GnHKrL3m9D0
3akEoMzL+9Z+FW0I+tsp7FWCw58+ZTglrKJDh6+m3bRUgtfhRhfrWdZQpMqM
tKsVno9f281LhDVUy3Aqb7u1EnTyqh7eK7iG5B8bPflrowTi49nHZ+XW0NIy
e8MeByWg2DqVdu9dQ5mpCf3zx5Qgb1yR0BS1hqb+pJKdPfHnxWIqvwXWkRzf
f40aXkrAp/qUOiu+juxRnzPzOSXYOCV+W1hhHb3MIN0p9FaCF/8F5EbpraPr
J16szvgqwYUuHguOY+tIqu9za0yQEsgaGxVXF60ji0FGn2dRSrCzKtT/kdUG
uiqkwBkZrQSn7lsdfXB0A1UYm+bYxyjBjlmxa9lnNpBYfkL36nV8/ZZwyYmw
DTTkJg4mN/D8BbWiHYo30OVhHf6fSUrQznmtKptzE5WOnXnOkqkEbvpyXRpd
m8iZX1XuA/Z+MYOzVb2biFdvJulmlhLUlr2OsprcRN4RoReEc5TA/OZOfzoz
A6iJ3tYk5SuBWr+BRfM2BigzqX1qVoLzF0mtirdhgIosQklStRL8co1gu/ie
AVzft4s71CgB2x5rfvEvDCA4cT9evFYJmD8r3mv5xgAB+jKeuXVKwGAR4249
xADUL7rkynoluD7DObzMygjVa86FPxqVwEjnku67fYzw0uFZrnS7Ehwxpyxz
fmMEr/z9RfPYPfRC0+10RhCf7336sUMJxl7ZSoaNMkJIkkCdfyde3w8Zo9s3
GUH/k197czfOX1/eRIoyEzw3pG6c/6ME1WDKSYhggiLVOofXY0rQKySmVWrI
DEdCbY7dH1eCj4/3+vodYgbOljEXzwm8PjzrGZZHmcHdXcJb6J8SyFzIO2gZ
yAyKOWGRHjNKcGhk46h7MTNkicAz/mUliN6vUSAkxgLJzE1cLmwkKK9L4BTm
YoWmfZuDJHYSmG7LU6WLsMJMvMHrf9iBhLfNDUqsYCb45GIYJwl25zUHNxmz
wob8g4FkAgkKWBm3/Y5gBVcTj/ovAiTIZr8ytpeRDdRjeS7skiLByO5bu5J5
2eEdr/0PEX0SZAbctXR34YSpJ4Yff2KLPwrquBXACeKH1OvSDUhQ5BTx4M11
TjifyPFIfgcJljk859BT/Dmx7oTGbhKo6GYP31nDn/NLD+8zIoF9ReeoUjIX
iAmOLgRakuD2vSPXGz9zg1HFt78GViRg7Z68sNzLDT62b7+vYc9ddZqTm+eG
xrtptRE2JHD9JPDTXpwAPkKHLifYkwB0uiekzhCgUbiCNf8oCSRkGKtS8TnR
R/SyYJc7CXh0uTfUt/BCct+u1EIPEtz9mewqqsALb4rXZULPkoDvt4bwLyov
CO8OU5fzIsGiFB8adeSFepfQA74+JHi9+L1PMJ0XCCUh4TyBJLhM/X6UW5IP
qAHb2Xux7e4s2uiq8sGJ3Ss3Ky6SoPOfubLaTj6oaAtOdQom4fNAdWScIx84
zQdVPg7Ffz/0+cne23xQtPviuPE1EhSKPxupwM/tnex6fqKRJEhklE6zYCLC
RtvC8jh2vtDbMCUOIlifCmS/G02CrR+LZWO2EGE5JkC2L5YE/Ae3WK6RiCBr
pfv4RRwJzl6USRVUI8JBsXn12HgSkK6q7+XXJkJmif8ujZskXG8nH1ftxOeA
dr/Dl2+R4LFd/L4aCyJcSNGmWd0mQWh618CcNRHSTs2eVkgiwdO+BhEhByL8
m7/g13qHBNq5b2OYjxNB5D+tlYy7JLiiJzje7kIEw+sz4X73SOD0wVc3yo0I
98UuJIg9IIGS+dTvlHNEaOjXFJrEXs4/77d+ngijJdOpr5NJkGAg4mTsT4Td
yPexewoJXBzms6NCiDB46nxj5SMShA3Y0luiiHBDtkM6NJ0Eh1IT0zWvE0Gn
VztsTwYJPtaESl+NI0KE86JuayYeX17W0u8EIihvc0y6nUWCybxv98duEaHt
Z+2kfTYJ3MW+xPQnEUHS8XJBbw4JGvseLiXdJ0LTVjpzQS6uh4E/7w4kE8Hr
254TXnkkaLXRuTbxkAi1Nqyii/kkqC4kus+lEeGkwJmAlwV4/885DRxOJwJH
e3P71UISBL1/NFeYQQQHixtxhCKc15LYEEI23k/C5FA79ruKxH3SOUTIbzm0
90ExCR5+lLSXziWCedyzjKMlJKDl2HYQ8ogwZ7plTaaUBKfy/IYHsVPZAw7/
xVZ9091UnI/X+923ipIneD69Sw+cC4gwEqnPf+EpCR7ZwI0N7Ft7U87plZEg
d9vutvhCIugxrX1Ywya8kUpie0yEPw3HFN88I8GlIgEGH+yoK/9FxJSTYDZu
j2kTtspuGdrB5/j3GcwPOYuI8HUtYodABQlscueld2KH1A086MYerU/jPYYt
G2Iyl/aCBAtJl295YX/QL7R0qSRB+GmbrrPY5xc5S5WqSGD28DX3YWyRSk/O
CeyYv4dcdLD/8/90uryaBOq3YtkZsN201d9crCHh60qT6/B4eGZuSe6qxfXO
eH7pNHZF2UwIUx0JGn7VZDJgO/nYdr/HLtfeb/X/+TKpVWrffEmC+jOn9Nmw
H49vvWX9igQX/nRd88XrY1kcPL61ngRVN06c/ITXc9Hjp+lv7G+7Pm2IYqeT
duVl/0cCh62PYh3w+hv/TWd0b8D96EuPWjTer/E8BmfV1yRgod0Qz8f7uUOu
Ubj6DQkm5nov12YRoa9XwS/sLe5H2yQsnmYSIS4z5othI+4fC1HC93E+vm8z
u/6pCef3s5nh9kdEuPKrZCDpHb6e1eLqYioRFFN59xx+j/N/TPdoYQoR/EU6
lvuaSWB+uaW29wERxLu17Qs/kMB49zTBE+f3zb175ec+koAhQPzJ37tEIG5x
9FxqIcGGoX5E3W0ilPLQf/F8weuBTvxux/ViOy/4pR9b6LPpWDuup5Vf+1/X
tJHgXqNtfGM0EUxKnued7sD53/TaGxFBBPqBGO9XXSRIvnfqg2swEQSuqzGc
+4X762cdwqQrEap9Ts0Y/iZBxrL3qAruB8cdkgdE/pBgz5SK4kncL0oUmT40
0nC9XJR3KHLE69nUdVuinwTKBz/8eWtOhCCmMLnWERIorDq809bB9Tn6TCh7
lAT7T4xJ92gQobF9iD1ojASvhL6JBakSgT/LclxuAtdb02fPVEUiFCH5F5em
SLB+1+J3hAgRfoe2mFAWSUBleh31a54PDBdFz8axKIMsbc6yM4AP3DqnNK1Z
lYF+/NNTBm8+iH32flmUTRnc96f9lnPjgzbPgNjH7Mpg4WQvecieD47T2wqb
uZTBJmrDdSeVD0I/xPxl41eGC7dFv8bO8UJl6rzrtW3KYCrDeeuBJy8oQ/vx
UKoyUAq6NSL28UDcdak3fmeUQSDhdtxcFxdUE/Uf3kpTBk152qvacXbQX/r0
XfazMlw6lW87Ps0CUVJqN3uYyZB9srp9ixsjmJsoPHmgTwZ3Ctf0c+dV5CZi
FnTUgAw/cl7r/jJcRZdHzxvKbCfDqZC7fBz4efhJwstvRTvIwOTr7Ov5bwUR
u202X+0mw5Bg8pUz4Suo80yE5YARGT5+M489m7OMjsTSZjSsyCBiWujk/G8R
XXBifTWP3an3hezXic9LqpSYWmsy7NdTz75Ts4hetgeKG9mSoXoe0pauLaJt
YrxGDg5k6Djoh46ILiJ60c57YcfI8G1Q+WS1yQI60/pQ76MHGX41Pz37snQO
XX6f9CDjLBlUVmKWy5Lm0P038Yv+nmSA4kHZVxfn0LvqsCqpc2TgCM+P2WY4
h+TzTuoFnCdDz/wrZfbvs4gepqwnfZEM0S1SfA0cs+iIeg01MBLPv87xefGV
aXSBXH7fLIoMtx2eDkq6T6NYheIF6Wh8vXoJ5nLLaVQt/qiyJYYM6/YF7/Rl
p9FWjqtUmXgyiF6LPPnp3RTqpJtSW2+TYfboeA9VeApZJH3Xlc0gw3sPpdzm
RxOoP8LPcwS7184s83XwBAry480qyySD1wkPzyW7CZRta0RA2WSYP935QIpv
As0Ll/U55ZFBsJWBxy5yHKWlxiTeKyZDlc+jY04hY0jzhmzT0RIyTJYwSWod
GUPvQl+tyJWS4ZVquq/J9jE0dWz2dPkTMqSUu8UqrY6ivdLHd355RgY15eMr
zVdG0WgudYSjmgxG3FyuPndH0JV77ZJt2NN/v/wSCBpBgtFetg9qyOAzeXB+
2mkE7T6T/Z9CHRkuHIk+4iI/gm4r8943rMd5ispsYqseRvpPBg1DG8kwlUAk
aI7+RTFVd9P+tZEheClzu0fQEBJj6ftb3k6GpIJro1dODaESS3XtwA4yaPdG
JTdbDKGOkQ8f1r6SwYzO0zWpMIQkJTYXOLvx/l8K4on5Nogqwj2s5H+TYWUm
MDkfBtG+T5Vpf7Fv1qWa1akNoh5RluGiP2TgPE5yX5cYRJvl6Zc16WRw+W1b
zLEygA4Mfi3e3U/Gz4Pf1rQqB1Dv/t1sjiNkONYTEH6HOoD878dbSYySobj+
SssRpQHE1v89jYYt5cpVdkBkAKmE+mm7jZNh65enxJyVfhT0pPCE3z8y8DS3
1qq+7ke8W7bU3ZwnwyhFIOSMXT/KOn6CzWqBDD892w/cNe1HOiWlVoKLeP9+
7xob2NGPHI1Nh1OWyLDvt+j5Kdl+lHsxTKhwlQwhCYtHC2f60I5ff33eMFKA
x1hMxym5D3224rC6z0SBN89ns2tv9KET70laZ5kpcG+R5fPuq30ostxjjp+V
Ah9D/Ceen+1DrdfHgk5yUKA5lfPhPtSHjur+u8rAh31LTa55shdNFvGd6sTW
mfzEd2CwF4VLaxgVEimwS4ZkOfazF+Vy+7JZClCgzqrratyHXjTeOxOXIUSB
Wn/pLq38XhSasHBntwQFcrOyA4ZcexEvy9YAgW0UkKWPHNM/1osyg/Xsh7C/
79Wsz7XrRY2uQSIJUhQod/J722LSiwg7VtJ+y1Igh9eP3Yzci9L+rueFKlOA
+UvuQvs8Hakdk4yxJFNgeO/2iKJ/dNTQsdtdnkIBt+ke9HCEjgZeXSG3qlCA
NafErvo3HancZXwqrkGB4iTfrQvv6OglsFbXUimgsXL99o5HdNRS/N47XI8C
T7Vcy0uT6ahHOE7BRJ8CtOj0afW7dLQ8znun3YACyjMfxF3j6Yj6UMR7eCcF
Vv9I+0aH0NGzaYq88F4KXMvXvJDghMdzdLLnJ/bKj9qnkw501Pa+7HaWEQXM
AzmCj9rS0eQj3U0VEwqQextFT5jj8R1APXv3UyD4nlc4M9BRfrb1Ld9DFFDQ
unk7VYmOXvAI7dOzpAA9cSDprTwdNQZ1r69hu7ftmliQoaN+i6Oe160pwPvs
GeWKBB1Jr542ybCjwKyK2CEBATpSdyOtu9pTIIHL7tFtPjra3T76nOyAvx8x
ZibOQ0fHCnxkKg/j/baMsTHnoKMUm+C1VicKpPCXZlpt0NDj+h3Pk45SoP70
n6//lmmoWnnD4/AxCrC4X1zLnKeh7s2I7n5nCiQiCYcdEzQkWHKjfOUkBczu
9Fgf+E1DiSyZ7iR3/H1L+8O5DTSUnqz7YgM7jJwdueUVDZWotDB2eVAgLtxq
+70aGvpgu5By1ZMCnke2nPhSTkPMeQc/9XhToK1/xyWRfBoSMOgTfeZDASa9
mx1COTQk/emiW8x5CnhkkebkMmlo13z2pvYFCmwk2L71TaGhi8bLmjcD8Hyc
dxI/J9JQ9I+Ey6cCKZDeGi178CYN3T0n32JwkQIWZy95/IijoWf3DrkOBeHf
t91qk46mobHBvPsolALTmcrMzmE0tBK8o18oDOcnsyLN8hINcfC2q49jq8tf
WrEMpiEF6lpz8hUK6OkmWoQE0NDxaOvV6QgKaA/veHPWm4a8xYb3NV+jgP86
tf2dFw2FPgm7mx6J8xPPZK/uSUMPvxWqmkVToKoHSSq401Dh2d0hMjEUuGsk
IFDuRkOVG1/fLWIn36j8c+A0DX1V3DyeG0sB3UK58xkuNNRXe7ckJI4CrnNv
x46cpKEpC/KyZTwF+vgGS2VO0BDPRbuk9Rs4H3mH/dqO0dC+98WN9rfw+NSd
5Z460pC90x5+1dsUMB1Om2s4TEOu/74dY06iwPOggOVfDjR0dSvT4tM7FIgm
JYr9//37reIHe6PvUsCrddu8lx3eX6R66+g9CpzcHx1eZktDdWcOK3M+oEBl
96yWrQ0NfVydCKBhn9vBKlVhTUPfE6+9eZFMgfzIp8bbsIfkRPluPKSAAX9Q
bKIVDc1XPXFySaHA5u6BVi5sloNGhfqpFPjqGTyTYInzQP8xx5uGPy9s+CWO
Le3vs2cQW8jkhs+zQzSkzsGaUPeIAmz7XG8dwt65dHDqZjoFRA59fb5oQUOm
w3etT2RQgCP0Wn8Btu33XxVambif2ZxnO4F9oll+K2sWBQSP3mOWxvaq9gru
xl4Vm3z915yGggsrfj7OpoCDcCCpCjs6eW1XaA4FxEq2SyZgJ103yrTIpcDn
+bfxXtjpQTeYZPIo0CpafMQau9i903UWe1Mpwh9hVx+WeN+Uj/uFxs832tiN
pq7KyQUUyDI0VVfHbtMviT9biPfT2ylHE/s3aW5i52PcbxrzOXZgj4rstOQr
wvVi+9LUDHuBI7K8F/tsvY25CzbTcotgRTGu/wtljOHYfCNbLkaXUIA49J9V
LrbED6cfh0txffx3RvkLNulDzg7KEwqM5dz0Z8Dz16kZe7SOTdLfKqWPDY+1
GdqeUiBKZlQwEPvgw0su2WW4n7CO76nFdox92+j/DPfn60xJLHj93YK5lfaV
UyBkyGbaFvuCh02s6HOcF43r5sXYcfv7zesrcD8pSKnwwPt534BSdusFBfwk
L6S2Y+co+wmcqsT5nZDTQzgPLzmZu9mrKcBA5jSm4Pw0Lx8w6MFWpuveeYzd
NZKUWlKD6+fibQtVnL/JD7InrOoocOjXUIsRzqd0nOFISj0FXhfBtnKcZ5WQ
OLNz/+F64lInHsF5NzjbUYoaKBDLI/iPDdeD9QGXCwOvKRAoe1HbB9fLNa6I
VdUmCvxRqNkTdBTXw8qHYwzvKGA8dmHRGNdX2ih/Qwc29wdbeRFnGqr4mBV5
sRn3D6sLRR+O47zHveZ53UIBxzSpxeOnaOgAN6O0bQcFjmzLs7XA/aBzatRB
5CuuN/XB9QO4Xzh/60z8hT1jm99z4BwN+WYVbrp2UUBJhcBp60NDyXqWtIDv
FGh4eVw/3o+GBk9lpD/4g+/v2b5+UaE0FP5y17afoxR4y6G34HuLhriylewy
xvDvoZ2n6fb//z8D/81T47gfh30+IXaHhgqsB9fGJnA/0n+U3nKPhj4P3/i1
NoX7M3n8475UnBehX6mSi3h9eus+ZOH+XHUuRMyFWQU8XaLJlfU4H6F6w1QW
FZiZkrpyBvf/5ri5F9ysKvC+WqxI7A0N9RR4W71gU4EcpUXP6CYa2uh1uc7B
pQL3qhc4/VppyMTebOEJUQUkeSgaaT14PXZLdKxuU4GrV/PnCEs0NM1XH3tP
XwV2k/vajMXpKIz/ysndZ1Xg0U0JsVlHOvpmzfWEkKkChVmqDNFZdFR0R+UM
vVMFnggK2zfh54U27dbrymyq8ImLg01HrRe93UKVSt6hCjnoB5NscC/isNkm
GXpOFdTXrbZk/NeLmm+nxp5OVwWpkj47edY+ZEcc8PD/qgp8d7o4Vy37kM7k
4/IlFjXwv6opII+fz+jc289nb1eDZ1nD4SWDfYhd+WSKlY8a/GEXnqZq9aPw
PFbVwEw1UBANPLkR3I/enfTXaehSgyuPxx7sae5HzmEncq+wq8O3zLK7tfwD
yDe5P9xIXx2yKs8/UzwygKxmNTrUzqkDP9u+UPXHA+ha6Wp8Qro6KC3+uew8
O4AiCm7VbulUBx3KP2cTo0F02fIP+RCLBlT91PhAvTuIBtbKVb5IaICGS2bB
Ttog0vgwPnxSTwMWTZ9fkdMcQgrGpx3VLTVgWCUsWeTyEGLsNYzk89SA4/Ui
ZGLHEEpZ8zx9IUoDtrvbJIkp/EW/3n9d4UvXgPcupU+k/f4i1ueZBxqqNSD7
QJ2lY/Nf1G1eYlHcrgF6xa3/okSGkZs7M6foKL5edNfKizPD6Ff2f2EPWTTh
32vX1IP1w2j1Rm2+7TZNOKy2a99bvhHE8EAsTlZfE15FEjk+uY+gt9Lv5Pys
NWFxOKFho2EEqR8p8904qwmzb77Hr2wZRVefbwanRWmC6v4jLh+9R1Hoy5vU
gHRNaHgVN+rUOIp0jc88bqvUhPud/g9ZRMdQ50Tet93tmvBF6hDnh4AxJGEi
V/13RBPKuEg/9D6NIbN6VtscFi2ICpU/waA6juSGFHMfbtMCoRBzDc+YcVR9
806RAFUL9nabz7H0jiMdu9Oe6ZZakBcr9tFm7wRybA2gu3pogdrZ4GMqmRPI
9dQY3+5ILSgUruHkYptEqiEl8w/TtQAdrZU54TmJMqAkUaNKC+5efWmm2DKJ
FhX5B360awHdYe3COZ1/aOllxfirUS04GBd4UDr5H6rqyCmWZ9aGsoD/8HH+
HzrKsSSfvk0ben6B506dKVQ0EWdtTdUG7/9Iw0zuU4g2E7Fd1EobTuYMzgll
TaH2i+++u3hqg4daLU2hZwp5lZhS/l7TBifPqkNHiNNokkFD/3K6NjTs5bp4
8OA0EmW1Xz5UpQ16bRqDXlHTiKzc66/ToQ3NO0WLKxun0XJrVX7quDYo+t63
PcUyg3ylP93YxaoDCQ5/V833zKAvd/apzkjpwM6AvydUo2bQt0qGiF59HWBp
Lr168d0MSnFkvWljpQOB3HlXr+DzubGEj/V3Tx3IqrIJqLCeRQ8TtrY+iNSB
xF5mp5cps+irtALD2QwdEDxW8MRhfBa1aF0era/RAaP9N9xfwBzymhOKtejQ
gZOsaikLd+bQbJdA39S4DpCeVvnZzM0huTMW/z6x6kJuJOsHR7t5xB/UVa4q
qQsT7VUMn1/Oo8HC1xqZ+rrgdsYzgctgAbnEjruYW+mCjuM25+K6BfQuNvQQ
j5cuIGPnvhHnRRTduGngi510P5En/OQiMtmMkO/CDg3XGNnquoje+8cup53T
hXc1N2oPeiyi5uP3c1R8dCGBGZhb/BbRB92yRbMLupA5xyonEbuIWnv7M+KC
dAGe0fxlXiyirwZmU+xRumBrqah9cMsSSsouGPTAXu63eGctvISsuVl+tmDf
GfqS4SS6hNp+vWxKjMbjY7bS8pdaQq1X1FK3XteFXoXrKq8pS+hdE7+JUrwu
/HlnafbJaAlVW31PNbmtCweY5U++C1pCF2t1bhdibwyy7JQIXUJUudvRXEm6
4G95r9X/yhKqmNvv+xn7IcfcNrXoJfTsQZ2J/V1d6Aqdm3l9ZwkV/U6fPv1A
F2xsGNd9ny6hRx6n90U90gWlo/fO8Y8soV9uxTH/sHmYm28LTywhMdfp947p
uuDRVRgnNb2Ekp3DTNUydCH5TPKWXctL6K7Nvf3dmbpQo6qkVcC5jOJ2NZkp
5+rC909f9u2iLKNAfgXLT0W60HrthEeW7zJ6wet5S69YF34bOamoBS6jOe5n
bVnYrywf5v4Xsox82XZZBZbowuqYyLepa8vIa9XWWuqJLuw+Jat08/4ychmM
tPV9hsc39aKr4uUysqgZOCxUjfdvUH1yg7CCDj5bvRaEzav24kAP/wra/1jg
6U/sl9Nr9bXCK8joIbBm1+iCvlkTX7z0CjIITnumVofHm6JjclZnBckb2HKZ
1uvCQIH/V/KxFbRa/bYupFEXanuP6CyUr6Clsp6h39gKAUoHo6tX0ELhNP+e
Jl3YG8n/RKJ+BU0lS7mzv9PFzwe/Qo5+WEFDQZcE777H49lQC1Cmr6AOfe1z
pR91Ifyf0CIT3yoqrM6WpLfpgi75kiHnhVXc73PumrXrwvbV1Cbm4FWU3Z7D
VYX96pHkZfbwVfw8k7tws0MXzjdMfiMnrKJbEgWfd3TqQuBz0OsvWkVB4cWX
H3Tj+nmQZ0MZWkWmphV/LP7owrbAsOIC1zXU1FlhW4tNWfmx+5/XGjI8+eKj
Ak0X4iMdsw0D1tDOkMrKNezMJtudPNFrSKOkOqGoVxeqivZ46xSuIRHiq91s
g7ow9aN0jD65hoa7m9JfjenCjls1X3yj15FrUoaU0rguPO5sUde/tY7oB4Mz
b2EXfLS15ElZR99fq2SfmsD73/Pp4EDpOmouvpPH+Q+vhyPhpum3dVR45WSJ
3Qz2i8QHbOQNdEZpvWZiSRdivCUXDvzZQH2937Y7LOuCZnuJDXl0AzmnldU1
YCvS//ZILGwge37XV3dWdOFepQ/rTt5NZLL6scFgTRcqz5dbnkGbSPFL8vuo
TV3Qkx2/8yBvEw0F6nRtY6OCRQqrxqE9DCCtQoNwbKGBnDuSpgzg1Btb0oc9
8Sf465IFA7SZ0a4VsFPhvxpn9PkoA9RJx2lpclLhxVsO1c0gBrj1kZZoRKDC
l6hjwzeeM8B2yfgDngJU6H/u9npNkxH8v+pWfsIuU796wHY7Izy9TpfR2EIF
laCsohpDRpCf1V2ew5YRDjv8xIYR+JrpBZeFqHAh8r2ZYSAjDPhSWZNEqBB0
1kpSpZ4Rbjb1/lctSYV5qarsZkcmMOULDJSTokK4feKOSVcmYHLkUk3A3juU
SCGdZ4LAca2UU9JUoD0yz/oRzQTOWyL9eWWpcJJ2vZv6ggk0TioquypQwTPH
p3JZiBk6184m8alQQZjJouD2MDMkmGyahmDzPnsVEbXADKa37mwOYM/ICf26
zcICr+ReetWqUoF0Z9xvTpoF8g/w7DutToUTA/7j/UdY4GLy09VaLSrul8PE
K19ZQExnztXNgAr3Nx2fsH1nhTtBjmwfDf6/fkuq7MOsQHhVX6C6nQqzB+Wk
JJdYYcM4dnQOm/EQEylRhA16HSTPX9uJ51d3fFvoETYovGR6KRNR4dyDrYbe
fWyg+zbtdo8xFV5nZSuXM3KApbVxvYU1FT6NvhsbOscFzY3XzpZhi4wwPfO8
ygWg90ZYwIYKWTdoejN3uUBdAvl0YZ+XSdnC9JILeIf0pY/aUWH9bb2FOBc3
fApWifA4TIWUWAHZzDxuOJC1xSTSmQp1p3JmuboI8GaL9cwg9j+7pG8X/xJg
e/St9H3HqRBxjLKtbZkAyp48i1wnqOA24DaGJHmAQ5e98PZJKtj9kD/O4cYD
75tXODNcqaD+Vpc/Y4oHdu8wqGQ4TYWLzTJq5xh5obL0oosLNvXnsxRxAV7I
T5qrVXDD+anfNSqszQvRRyc9S85Q4UhClV2gHy8YTfV+qjlLhd8bg7sdJ3hh
5yJnk5wnFeYC5Y1k1nlBe0Pz5U1spWOLeTUEPpAlRBSd9MLra0ewdKTw4XOy
bAynN16/6pn3xm58sKB24LIftpprt26EPx9M6l4I+I39jpEmHh/BB7/2vjn1
zIcK2ndJVQzpfFB73AUcfamgL343zLeDD8rd4vTeYv8Ydq1lp/HB43PlaqoX
qHCc0eD7mTE+SL7EtI3Rjwo+RZ3ebxiJEPgge7nQnwpR7/ov3Rchgnf6xymB
ACosGl29ySZJhNN5M39Dsbu7/s4ckSOC7XPDb5aBVJBc35dcpkoEzS995UsX
qcBCP8vAt4cIpG9cRS5BVHicQT+YZUwE6d9aWa3YQmK5E1sPEIF3LCIxMxjn
323KodyaCONscl6ml6jQxPY+/JELEQZ4zE6VYyv1DxFs3YjwU9DviEQoFaZZ
j1/650GEj7JvTaewg9lDvLrOE6Fw9ymF5MtUYFCZHTkRRoRM43gJpis4n53u
n/aEE+HBwedbvLD7t9y9x3GNCNFHmJkgHI+/W97H9DoRwk5Slh9j9+45//V1
HBH83W2mtlzF9XEg7T+Zm0Q4FZjz5y+2cZ1Q773bRDgS1tJlFUGFM3ksF4ru
EME6cra1DrsvR2hP/j0iQNLeusRrVPBzGT5q+5AI+g89y5ex2UImuNlTiaCe
eefxqUgqPNGX/y8rjQiST/of6EVR4Zr+YaZbGUTofPorOAXbbEvLyqf/vx99
1uW0jr1yRLlxMQtf//nnXSeiqTDW0B3Hk0OEhYr3Um+xOzgMLvHlEqGksoFR
MQbv98LT1+vYLtU1/dexU+Pr4r7nEUGktrxpDPvEz3/MmflE+FxXXGBxnQrN
d/mcbAuIEPkqN/YZ9vr5llfz2Nv/e+QpGEuFuPo5x8hCIkw13De/iP3Sbu3Y
/98v579JVO/B9vN2XPLAPtp4nX9XHO6XwVccXmMLvLs6m4EdUs5ZxFZEhOb3
IV1M8bi/P/wjuR37yge/qtPYBzdaB5ywqS1eD5ux90blkP//vny89fQlyg0q
KLiclPLEzv7sfCwBu8hrefr/78sPtzmgaWzthh3tuti8HZYytjepcFV1bYwR
u/HrfuYq7KkEqu8rPJ6QLsNB0QQq3CAkJbpja3TveB+K7W73MIAZe+i7zmMa
9pXPNKsEPN+0HtV4w0Qq/KQuWHNiW/9SPJeHHdI4m++P14fjj9QhjltUCEum
X2rD61lPE9H0xGYP+rwpge3fy7/lMzZNOfbEEbz+9AHm7ju3qaAR9fhcId6/
+0Nr1QvYedol/jXZRDg4PJ/imIS/b6vG8xLvd/XYX2epO1QAK73c/78f956g
QwT2jXTvVe90Isj/+yE7iL3L8u1dg0dEuDXTMlR0F+dRfXF7fgoRTOYam3nu
UUGqWSfdFOdxbf5V0XnsZlP/f78fEMF9+ak39T4VEg/as/TdxfliuLvw+gEV
Pq40htsm4Hwx3vwun4zn9yHnT9INnC/m6NoYbEcb0oUmXC8i7EGXzR9SYfNJ
Zjd7DM4Hz1G2Hym4fxE62lmvECFLXF546hEVvtG+DbKdI8K3Z2x7ndKp8J4t
s+70WSIQTEd83mHHMuw/U3OGCEH+Tz6kZeD72XLWMML9wOKTftj+LCrY2zOy
fbbH479sPpCdi++v0UM3ibuJoCWkwc+bh++PD5/s+bKdCGeKBXYHY4fT2MlR
ekTo6O5+cCifCrdZ+aW6NYjwWMPFbK2ACkcn46W24n5m3xdYbldMBesgGXlZ
NiLcCHKkNWCj5NiXLkxEeM27k6BS8v/+Ndeqv84HKjsY3ZhKqaA47V60MMEH
zHfjRZ8+wf1xIbW88zMflBlnhnOU47yFSf0xTOAD7scfLOqqqSAq/86AnZUP
4FxUtHwNFU6zNZ4zW+MFf8099Texf/lGC8bM8sKfmmrVE7X49xJhpMFeXij7
WED4H8X2HU9lFwcAXPZ2kxEpKUVFirjX6vyMixBCJZKRjKzI3pskGVEJlZEK
LSGSJCkrIyRe7rVlZa+M9/Tn93M945zfOOf5PB6GCjkQZRE4gyo5wXgysl7v
I+5H3cqSoZ6ckCmlqjHwRQ6UxP2sW/o4QLqkXJnlhxxIu/o95nnEDrTXx6mJ
E3JQcnOBXVuIFcr0g09KMhJB6uPAXx1hJhD4z9CATpgISbSFLExc9CA35rbz
IpEICycmLFK/4f0Wz1La1zNEaJhw3e4tuIaeCbfKHDYkwnHXY1frNlfRziMF
jXHYBu9vH943uIoWVaw3zxgR4aZu5+Bo/ip65frd6j9jImQWnTNrUF5FBxqe
iM+eJ4Ii3BSXuLyCCGHnSwQvEYGPc2pTqmQJBd+S1g/EXgm5TWl5sISm73GM
UbD77KYyQ0KXUMPLzwK5FkRIO3e4ieP0EorqlQqUsiJCtmOY48jQIlonMaur
2+Dfx15wNvIvotE/71qdrxLBMyDk+Ym4edR5O7C4C7uDM1PnqPs8qpFSva/m
SATTQzv7VU3m0SPXBksBJyIw3rJiqhSdR6Z/ev/UOBMhFq2w0H+cQ43TtJxC
bkQguDj0Mq/OoldTutr13kR4RrC6fjNiBmXe2n5U1ocI1jsU1MxcZlCcZOf2
R9hXWPlndU1mkIOzxS9PXyK8OLR5NVViBu2bcrMX8SfC1xrmjNjCPyhlMjXK
J4gIp/e5SRpfnkZ+E9Tqg5FEqGh9eZKBfhKJRXklxmLbdBqnfB2YQO172S2n
sVc+F298/TSBjp4jbhRH4d91ArrDQibQQNUtIjmGCFl+76f6aCbQqVSFgss3
iXDt0jjdbo5xtHSsxe8rtrT0zwOlf36jrIYrp47EESEo6FPzrbbfaJ0mcWQO
+xPX330z936jV46je8PiiVCS53kwQvw32qlyJ+VRIo53OMtcleEY+tJzyIY+
iQg0/51N4pQfQ+5eH6XtsUNHyotThMdQY/54s1QyEZo2S1L0p0ZRCJ8K68c7
OH6xrnSON0fR6MRUUO9dnG9JU8DcNoJKUjXtBTOJcOf7ZPF01DCytihRCcBe
3UZe0fIYRpziB3b1YcsU6S62Wg0j2zLa748fEmGscHrGRXkY8f73QebQYyKI
vG5/1Lg0hDxETmwRc4iQd4Ga+sNtCO0dz+q6jx3SE/xk0WoINb7Z/uYv9tX0
549VDIeQqPofm4+5RJCv+iVyTmYItds+r9fIw/XhRqizXx5EMgV7U88+J8J2
bs/3M1GDqM/jtmspdsx7Lt5bvoP4+X1TSyCfCOSu9TA9p0E08L3n73/YzbXz
DshwECXNplrZFBJxf3LjahUeRHNyHJLXXxFB1r9uy+3TAMrc8mfswA459kpZ
qWQAaX8bp8i9JkL8UOjgwfwBlHXhW9IattbpV5oXUwbQmYDwldAiIuys+HIP
OQ6gV59WPyeU4PqSTf3wXGgA/bfHcGwNmzZIMDyRewAxBTxnv1KK8+eClcp9
5gF0Sc7srPw7Igy8eX+GdbEfsedXjPSXEcGBg5Tl0NyP7O8Es8h8IIKuappL
x41+dGf2p2QGNufTUZ7c0H70Ue+YIVMlEfiv1z1J8O1HfCz9aT3YA91yZuUO
/agmUFUioooIp0Zv9Ovr9KO9dgz6HZ+JwNUzwKO+ox/p1phfRzVE8JJb2/OK
vR95i5TcfYb90u1EhgxjP/reY0sN/ILz6WXnRPAqFQUYfHM7+JUI1ZbB+Qf7
qahL/uYd73oifPCdee/5loro7w6+68dO0k8TUXxJRVILir06DURAscKCPM+p
KOrF5IG9jUQgpoT3bz2kohP79Uq/NRGhW9zu4bs4Kkpg394t0IrrWXDP22AH
KvKzUfgdgJ03qKf9/AoV2VRcXqFgSzrMsA1aURHJqYTvSRu+Ps+3a0GmVNTf
YGYk3U6E9pjEKBNdKmrcH2mdgr1xv1N2RouKSvxfuK1ga17c6L1DpqLYI9sS
KjtwfcVFRtAjKpK++aRR+ycRHpnq6/lKU5HQYHNPIbbke99fHlJUxKi4Ok7o
IoJ/srpqgAQVdY/rsPzE3q7OKPbiIBWFa8+SL3cT4Vis5Yu0XVTUzqL00b8X
9zfdjR4/JiqqtLryvQ9bsbFN6QADFT0ti+9V6SOCY6d+9C9aPL8O/X+ZKERY
9uFtrFynoAN1UaQ7VCJU5RGflE9QEEHkleYydvFtt8W8UQpa8/l1zrSfCIWu
wdZ5gxT0XVzCc+8AzgcBrcqeHgryiml9XTBIhOQF3wmeJgqypK5VcQ0R4cvj
pahbdRSkTRJtccd2Qs8K+WopSHjMa5o0jPvLtou/LnykoG+aQke+jBDhY+Pl
a5lvKEiAyS6n9zcRjhppZq4+oKCwed9NrXEiPGTWqzp6n4ImKXEmb7G/ZnKz
eaRSUNW7N+w3J4hgVRZvcDSRguyubnqQpvD1nVt5LkZTUMu57c3Z2Nzdluvs
kRSkoCZ6iGuaCAWbmuGNYRTEKaTdO4w9ZMdY5hVEQcVNKeTkGSK0LX6oc/ei
oD3lTx9uYr+REXmb7EFBMU/erzrMEuHByM+uT+4UdDG4vxDmiDDaFShJdqWg
WscFpgLspaNxbGnOFHTMhMmafx7Xm5hEyF9HCqI7Lsk3jd0qYXFj0J6CnHbD
tQsLRDiheLPRwY6COlmM6muwYxfOMK5foaDnAz5BDxaJ4HMoqV7tMgWduVMz
orVMBHqPT7cvXqKg8pCf8BZ76/Gn0JPmFCTqPJ4mvEKEJ4Uq5CMXKWiFTNBf
ws4W21UhakpB1tL7n1mtEkHgpJXk8QsU1LhHjq4JW4emc0LThIIeLpuVZq8R
QbRLtDH5HAUxD7ls5/pLhMmUifxvZynIvSXU0Q/b3vyHMRO2xrM84TPrRNi3
42z0YyMKepVS7luBLZiR17FuSEGCYU0/xDaIcN5F3NMKe8p0PnoTW/6S0HGN
MxR0TpNxwGGTCM9Jaty1BjieMgJKHdirrVtNetiH90qkwhbOt0VuTao+Bd1h
RzP52OdX7K39sDdXzmjz05CAN8CFYTe2/bBNThj209KbvN/0KKit1XtzCtt+
QNzHH1uxMtbkwjYSvJB5wU3Eznme8aYGu3kgvH7tNM6Hu6/Yj9GS4IAYd2Qt
tk/4Z9sH2PfzPomlYQ+4dlYx0pGAg/nPPU9s3Yu/Bd2x293fVJlgl2ite/Ri
h5ieiFbD3ivL1axFT4Lc4xntstg3RPYdeovdcZU38d/78jlFzvjdDCTIPEK4
fQzb9NzaXBS2SmDdDRL252sj52ewfxS8vqqJLXGzreICIwm6R8m7zLHv5FaK
fMbeL6gf5Yu98fF5lAQTCVIyH9xNx7btTp1Iwc5vnVP4N57vC2EGW9h9XEIX
l7CJXK7F9swkeFbcNyKB5+PRITPBNuxoYdqvDtjM6prBiiwkmH12eqwA2+2S
zFAOtjV+qFzC7vYRPsXJSgIanrQMMp5/1WS2F97YP983sj7A5vk26K3NRoKN
RpmX53E8Awea/yvC5pQ6Ul2JPbL+XmU3OwkWv7YmHcH5UHr8DtsM9rfbb0T5
cL7s1Q25doGDBD6lLz8lY8fYOnVUY7PGCbXz4XwzfaD+MIWTBLU+gfySxni+
io/Rb2G3uW2JVWFLtAg52HORIJvywckE5+sG/aK0IoEEUe60hvdwfj9yya2l
bsfxu//rqxGuB5YbiUe0uUmg9+ZdGSeuF/fswIQi7NvZZy5/x1brOmsatYME
36djss1wfY2oME4f4cXzs+arUmBBQUd47Xi9d5LA4q08vSCu5ztSRn5U7MoM
4QkBXO/rpxDllADOz599b3Y74HgE8T8TEiTBkLRayTHcH66NfVWq3kUCOiSg
EY77Scl7cRsOYRKwvLZ+3eJDQX0tw0Wu2BJmhooLvhTEMJJF14b9coQSJ+hP
QcaE3dmpe0kgM85j6xpIQbM22weE95Fgl3fwHnnc7yQ41yykD5BAjOvnPo04
Cnps2WB2/ggJNP3jA/mycD/2jMkvw/aMuyEZmU1BM7Hkv7skcP6FcX9fzKGg
k8Uf06jYUYq6Df/lUdB/LG9/ORwlwd0U0oFPhRTEV5R+PuA4CYbFQ9r6yigo
jsHF6DERx4NDlvH0DwqSeckzzUYiQQ1PVdmODpw/Ju9jvLAz6vMZ/+ukIPEC
5kodeRIEJzhfcOumoBrDbPElBRIYpAXZvOinoL8Puza0T5JAOldO2GWGgq4q
qD1dUCfB5In50ut4/TvlunND0xDX2+28HaFiVPQyZpvZIUcSXAhW2S5uR0Vt
InKut8JJkOSu9evyUyr6r7tZmT6TBF6U1w6/Z6jottrTquISEqxWnB5JkO1H
4o3DG76tJKDIZOUXhfSj4HaX2aoJPL+Poz3pG7Dj5O6r0svD0ELWaCVhAF2x
ufy3c488POr9ldFwcQAtTHzf/oQoD+LsHumHcgbQ1eSHA9GG8nCjNqJ6bHYA
ZZS/d5h0kod1QQ6V5ycHkW8iX+7NSHy+ldN6T/H+UzGmM035kTxev9/aiXYM
oidHO9QPl/07X91Yx54h1GwsnHu/VR6URM9t97cbQn1p3z/umpQH1u+7Qj+W
DKHUhIr4LnoFIIWJ1h7aNoxkn3DtfCqsAO4PGD7pGw6jRMUX59fkFSBiaRdn
cNYwSg25qRNtqADGCcqWn6eGUdhw0+pBZwXIELuBn05GEP+a3sVtUQrgqFEg
t+/WCHKI3+V5KVMB/vvceN3o1wjKUj2t9f2dAjS943G5IzGKIp58aPZpVQBv
5krJVr9RpHs4ebvcpALIbWa+VW0ZRR/M85iOMiiCOmOX7tO9Y2iSwPT26W5F
YDs+JsJ9bQxtG2oQlCMpAkdtjvhw7Rj6aNssu2mgCO3jITr3dv5GNiwktl+O
ihCudedav9tvVHtkMlUuShFOXM15Y1T/G7Vu9HV+z1SE/zLU+RN2j6PPf+Ra
fcsUwdl2ZTbbZxxdSmwKtmhTBIvKW6m+38dRyZuXQ1/HFSFrzT7Dbv8EWpxf
olNjUAJPw+v2nvj5q3co4OfKbiXIc+Z/Ldk1gfIX7a58IimBYfkuZXXSJCJG
ZT5jN1ICgwiW8md3J5FT7Y6sJEcl2KDN9n40O4miD04bH4lSgv6BYg8j4ymk
I8dUsZmpBFtf7fgTXk+hpSuRvUNlStCwWMPRzT+NLvHqF59uV4JzH2VyHwZO
I1eP8yqzk0pwQvKrZUfvNLKbr4nOY1KGB06CEqmafxDzPrewe3uVwSVJaMfn
/D/ItsVehl1eGZp7YuteM82g/MwvmUlGyuC80sqadHIG3ReyqjRyUoaYVAbt
TPcZ5FxudU8sWhkcxnwLNvNn0NbPQvGgx8rgz/Yo3mJ4Binkkpy5ypVh3fkS
y8iuWWSWJO5U1I7PH8/mcsJkFh2QOi+cNKUMxnv/cBQlzqJCndaYeYaTcLBa
/qNmwyzaFfOqwG7vSaBxo6NDbHNI2uN7BJ/8SYhtyDngrTWHjoWc4e8yOgkM
SzGnXsbNoQm2vZZCLieh2mxxsrp1DulrSpo/iDoJpLsbwno88+h+1kMeyccn
Qb9JlrzXYh7FFRqErJadhJ4TVcZtefPItsv2SVf7SdgxHbKA1ubRRti3MIU/
J+Gx+8v+JP0FpNxrv+MnEwKRgC6PsewFZHPe5VLUPgR9LlyHXjAsohOhb8yv
KSJgiOGeNrVfRJ8Oq+7oNULgmcx1pqt1EckuyIVfdEFA/KKZMm6whAydr+bx
RSPQejQTuf3nEippHuoOxTbkj9QK/rWEBKUtOKewE9TWI6Z7ltDAkpHn5xgE
tSnL7q3UJeQeoqx2LRaBe6aj2bPxJZScTKDU3ULAMuRzMHtzCbWXlfAF3kHg
oEPRaBJbRmcZ6aIGHyNQ6ft7NzB4Gb1LPVejm4XgBJR3nQ5bRkJiz2lLsNls
s3fujVxGA5pngmOyEZzz0n9cH7uMXG489JHMxfe7GnKAlLqMotiVHL2fIrgi
le3tXbiMSrg9DdheIgj4kJWW3ruM+IRHBWUqEKDUIJOT5BVEes6mnoLNu9v4
l5PWCroge8x5GVvGzawrQ2cFpev4fnz/AUFqavMlJsMVtN+HzUb9IwJ1B6Y/
K5dW0LFWqcKz1QgGQgIvXvBdQTrhPsjnG4LHomNOh1+tICfODPtu7Ij2C1sv
i1ZQ/P1PiUp1CL4OKtwila6gtpesQzT1CASyLxUaVq4gk//SY240ILhIKg7M
b1xBtrKfWtO+I0j3SDw3/3sFhYyy2HxoR6B3cbR44+AqEmHa2SXWgaD5WyiT
ypFVVH3woG4S9qv4R3dipFYRg63qCbtOBHUbkoGipFUUO+RHv70LgVcnp07C
qVV0p38ix6YHwfK7PZdOOq+ipz1Nw2wDCAgF7xWOvFtFp/72XPDCHnxkUUH/
YRWNC443UbHdueZ8Bj+tIklTxpLiQQQ/+Oa/vmpYRW+6TkZZDCOIXO2uuklZ
RRUdLw8WjSHgdxe5rMO8hlqaE+1M/yAQK+FtJV1aQ8fGr9V+wDa6fiXH+fIa
SqA3OCAyg2BBVEXsqf0aMpDnHBzFlqdNsD56fQ01Z8Ve8pxD0KYuWxUSs4a+
e4afTVhEcGqNc5L8dg017fJUq/2LgEaLOzyD8BdJyBlnHVpH8EjUIyGd7y+K
M5DZdgs7yDOvIEvoL9KNnK002sDmrFCrEf+LGqedFfo3EegkqOleUvmLRiyL
dm7SAKR8cFRZvf4XDcsUcAnQAyyl3q+RoPxFPCYxNaew/Xh/vKEf+YvUA2x8
/bCReIfw8ORflFUjNNiDfZKmoOjj2l9kefZWSSYDgGa1mlsv3zr6z8vFXJQJ
wOuJjV2dwTpqKzuWL8UKcL3n3JuehnVE28duaYntyarZPPhjHR2n/c2TiP29
miF9qWcdJWg/DprDtvpISlGaXEd6PdsNi9kAxKwqSbocG6hufW5FgQNA5bx+
UdyZDVSFijU0CAAWnoVfpAY3kNRRRhF/bLFcf9eYqQ2UKXT+70tscbsertnl
DRS4uvJSYDuAUItn+Rz7JlIoUhKYwp5wvHT5PXETvT1YM5G8A98P9etKSMIm
esrxI6GfD0CqLbl+WH8L8a/vd+TjB+jzaiZGXNxCUeMeZB3sna+XnIgOW+jK
V761t9g033R6/wvbQvtCTS/H7ATgpi0qES/dQukL/bJSgvh4k+01S9tp4HbP
THfAbgBvt9qTn6Np4JLm88MvsCup15OZbtOARNFlPwr23Wb7V+dTaaA+tlNA
dQ9AqqXPo125NECvUGHCJAywmiY4euIzDfjci+5M3Avg5E8Sqt62DSzP7ml7
sh/A4fwXy+WYbXD000+RLuxTHIXeQ4nbYEMi0Y1FFMC4QCqcmrYN0ujptzth
Txn0jjAUboP2ot/6xw8AtBUJTzC3bYNT3MVN7w8C8PKk2DIL04J0s05dyyGA
j/2tm0VfaAEY/E4yHgaYbNrgzGmlBX3Fp0WK2LtDWXuf9dKCUx595hNsoXNs
sLxIC7nBH9wDjgCU9Z1ZTRejg53HpITEJQG+RhhJSN+mg40EbtfgYwDvItbN
La7RA/tXGHqLrRR4eJocTA+CGy4XxrEbQstnyfH0IOfQoHb2OMCH1/lpSQX0
cE0lYucRaQC7vb+ULcfpYWB28VOnDEAw+4rYz6sM8M3wF89RIgC98r06UjAj
yDFe27LAXrx5qn9/AiPklDGOJ2J75nWXiT5mhOC9Jz7ix3/o5ZWStfuM/346
3uEDCYDxxGTYBDMTZN9Qr9RVAAhpMbNtvMsEQVUv7RyVAWg9RMJ0PjODzNGo
8qdqALIv2Pa5KrLBI58bz39hD+rXfpvRYwPOz3FprOoA9vv4jZyt2WDsfLKf
E/Yv7ylN4xtskB76SOEYGY+nQ2fxSycbMHaUl5dqANwTKP+c6soOXf5/ymtP
4TAkL019S+YAcu3c82XsUrP8vZDLAW8IS2ni2gCPTzXzPijhgLjcdb9Y7FOT
3omrXRyg0syiqKcDoH6+Uk9DiBOe7xN936EL0NR4+0hSOifwO4vlM57G81e5
MriSzwkRpYcfELGpe+oz5N9zgoXucf/72G98Rek0f3ECj9dJRXM9fL55jh0R
O7ggsM7k/ZA+wLkwOpeDIVxwuK+lRcAAIMv3JwdbPBd0zmmN6GG7eFfLv3/A
BceE5LeXYYfoWncElHDBkIuA3a0zAPl3zQ0CfnNBYnhiQDW2UXpy6NtFLjh5
jyVpGdtMcnijm4YA9z6tVlgZ4vnMu0Mby04AXZ5ubjkjABFRe6X0fQRYFTcU
d8QmpO641CNGgCfK9cqPsGuvGTzblCAAjV25PasxwP1WwbezcgR4W5ZW2Yc9
Fr7/641TBLD6zt2+4yzOB7s00/HTBOAcjP2thZ1PeKwsZUgAe3Z/niJsErOX
pK0pAYQszK5GnwMgWmQ1xToQoO76j+AK7PJl3mEuZwJ4xeikzGIHcB9a8b1G
gJbXilVm53F/pXTc2PAiQGBtUUcC9s0zu7T5/QhwuOfIxBds7u76KL5AAkTQ
C/EdMwF4zf2CtTaMAMcF7hy5gs2sTsj0iiRAnyS7Shq2Bc2wJkcMAUjn1x3p
LwAcs1WOmYojwLCjR6g89qcBdk/ibQIkhUymumDn948ctE8kwMSz/z51YWtf
+Z0UlILnt9L4J4cp7jfkHwU2dwmg/qNxUhU7pXdVW/o+AWZH1Wl9sJ+UtWSO
phEgc72CvxD73OXInoh0Auhsl5UcwH6k4SzLmkmAlQOFqvxmALtuD1C9HxLA
UD/DORQ7IoO09e979q3LvOEl2A2TuX0nsglQ4HPr3gS2nGnQKDmHABduMbzY
exH3h4jXBpBLAMaswM9nL/57vZt6RvQJAYpKFrtisQcV2/fNYVs2OE9/xOat
Xl9/lkcADuow3SK2CdPjnbpPCVC+YC5w2Bwg99Toiy7s2qiTOWbYI36ZBVrP
CNC2U1jqFvaNs7a6T/593/58q6wSuyWI5cMs9oQSVX0Gm0/oheSR53h836ua
RS4BsJ53bzLEprd6bGqEXSft0mCPTZgPHY7AJuu2nXPGFoq0vlaCXXBoNtMS
W5xf7e8odu/CSJsq9oln+6MELAA6/ZpEeLBBkX67DjanZX95O77+6aahBwHY
spuyTRHYphZfDr7Avm34MFoU23Y29zUFW71ybudbPD738Cil7Za4/tJ2v5LB
DuK1+6qKPcWQ7p+N5yc2T9PQA/vE/cpndNip8uK9udgCnt32xng+sxqY7X9a
/ss3qdEUPP8vzX/PMVvh85nbG37D8an4UxeogK1/S7BrAsfvW+hzZifspDJK
Lg02NddxTzO26uye75uPCDBJ1H1GY437290/oWM4H1bqJE5IY/sK8Byvwfmy
fXrqVAp2zMPtxw1xPqnKXfM0uwzQeuCid1MqAfS+GdDcwm7stavVwflqanr8
ZiW2xesZ+w/JBLgeNPdIxAbAsEXktH8CAXJqPRpHsQ+lNDLa3iDAK5Oz5wWu
4PX/Zf+V8Gh8/+OyA9rY9wLETFNwPXVwLi8XYjMe5X1wNxTn23nf/R62APO3
8jIF/n2v/vvCi1zsx2EjtRRcv3v8FeR/Yr8v0C584EEA4sO/egp2AApxciqL
rrhfjAb60dgDSL5u1JGxJUCDd1hrnAOAjklg2bIBAXa2/wytxv4oUrY8ifuN
zTFJ6RXsi1cl47q0CbA+9jPp8lVczxkC2snqBJAwlTRWcAQoEihheEAkQJxS
V+eoE4B138YwQQjPz7aj/6leA0gXaeZrqeSCNPPwOB/sOINU+Qbcb0fKupRe
YPP43DMuf8EFQe7hGQJuuN8fqhD2zOSCF4Ndl2awjyjuzLcK5AKu2vD+jOu4
PpwUCfLyXNAS+2tkxQvA9bOMUtszThAKepAu6Q1wmteH/eMjTrBzMze0xn7t
l66Tc5cTNs/3f2jAfvPQw90kkhMkDvy+k+mD94NK9rUOlpxw4+OKqrofjo9M
i7wqLyeoLvA/vB2I8zG3WELdjwOKzM+dPxiB93MjRC3jE+zgGDMn4paA9z/q
KS19OSzAp/bp1JcMXJ/W1kTPNEZIPfuyQe45Xk9dDtbm+9PBgtjnpw4lANG3
70meF6cBjViWwdzPeP3Ob1mV+LmCjoqYnfqJXd3z1KDx/Qrif1fwkrnm3/oZ
L+z5aAWNDesHOGJXbd8uO+Swgm6qpPIe/wKQd2KmGm0so5aVfVoVtbh/3bjY
JH5wGV2wUypsqwPo9lPKfBq2iFQ3b+2grwdYuPCpYh0/3x5OofjKYs/fKPtj
rb+I1qvDNO5h87q2pNsKLaLMPXUU8wacDzv/GBmWLqCBjrPcvxsB1uD1q/mZ
eeSk7uq91QyQY/rgJxN+0LiTK0sn24Lj6aWVdOTiHPrAuB5/FVvB7Zyas9oc
4qyLedKB7bm9wUuHew69PJ3Vkd8KYBkTF+v7ehbNneuQMfkBkHj5F1vj4gzy
cVCcedWJ1+csrSkmqT/oUf22gBHsyCPvKmIZ/qC6I9+YhH7i/r2rddrov2kk
OG0sHI3NsxbOUx47jd67u+iZd+H+ULX72K/xKbTp/7iApRtAd/Yavfe7SRQZ
z+Rg3YvjkzQmoXtjHBVEKaylYitnv57QdRhH7UHONxuwrxzIdU88NY5EXX8U
nujD13u4jzTMOo5q9B/OMVLwennZkbco4Tei204MyKfi+hs5+PLD0zF0mOUq
BxU7sElXaThuDBluy8jk6QeIunnZ6rTbGMqapf0UiP39j9K1PoUxpNr2ncFg
AODopW799ZZRFJpse3thEODlgd7qUeZR9PTm/b2HhgC4HK/8XJ4ZQS3hja/N
/3nTZkzt1wja6yHdXosdwer4Ov75CKoy3tx5fxg/H+kmPRvWH0FbvKlZyqO4
Xgrqb+rmDqPAe1+Ko8bx80TNZUKAzxCi57SqKMV2pWGXirAfQnHh69Vj2LkP
hKJKTIZQmotMi/YEALT/l3VPfgiVqD8e55zE4x8WYtLeGEQzMwHCd6cAfnYt
79gdN4i8bXce/IbtdTyeIydoEG32FEmsYt90YbY0cBtEHF/H5c2m8X78wVQP
//lBdDjDxFj4D15vdrypvyA6iGxOnbiRN4P3l4OGenZfBtBEZfPtLuzV4AMn
9pYPIPcTjqkss7ifhNh8WH0xgEKFs7IdsYXebtzjuD+AMhe5KqXmcL4Ec8S/
chlAPx9PzJXO43yM/aWXKzyALvFHr45hWyK1TQ2+ATQSt49GcAHv1/PbJ+g5
BtCC9wWOAOyETgP39rV+RND7KgaLeD+XVzFb/rMfaa9lXfy2BPAq/xqNc2o/
2q5QFLOB3Xi3r4Ujvh91+X5+K70MwNKlKNQQ2Y9sVwfZM7D3jBX9ue/Zj8JW
RD+4rQBc06w6FnKuH5UvPdm9aw3X+5ptydHd/ShUrvSUAfbnwGiyB18/0vL6
6hmJffXI7epWrn7UuTja9AebITzJ7wdtP5pbEA+q+YuvF6Z9b/w3FR2ef97n
vIH7BVOep1QFFc1Kv2fNxnZbafbpKKGid+4Ncl3Ya82ZHrdfU5HG3ES86ibe
fxd7up3MoyLrWQnEv4XnlzlOMyyZig4dV3bUxSaqjHR+iqeimWun74ZiM7+0
yNgRS0VBM85/JrDN58rXJkOoKO3Pi4dVNCogmrj/kJsrFVlJfWxYxM4YX36m
5EhF4q7Ny4e3qUBxakz1TjsqKpn+o5+C/eVmz/w2CypqmzpGc5VWBYR+da4n
6VMR6+Qbyx30KnAwUnMjSoaKjj07QkvGPsG58CPgGBWds83J9sJObSh4FCRJ
RdnUlJFf2BdtPybnilGRUoeP0yMGFWCj9dcOFMLjS5rlaMPm+usi1SxARTf0
r76kY1SBjjfPaCX4qaizzmzOFvtJ/6tVBm4qcq086SPJpAK7K1T7icxUlOpf
KmCBfSE6Z7yXgYoqSMfeJ2C3vzKfvUVHRcxFIpvz2EVfHtLyb1JQVh59RDmz
Cl7ABM/NT1JQe0L9bU1WFbjO5sbI+52C1k6rHffFtldW3htdT0F72SranmP3
dkoPsXylIOfIQl5ONhXwSuJ+AlUUxOiX8KAdm8lAqs65iIIkiCzKjOwqcEfH
ft7iFQUZLYT2EbFVRJChVeG/91/XRR5g37S1WE/IoyD5y+fyrDhUgN/fW+Jh
OgVZ7m3WSsbOseKUZEyjoKhezfEa7IpzIWz+dymo7by8pDinCtRnc1TfSqIg
J12homlsXr7gEsMbFJTEkmK8l0sFuL9d1BKNpqB3tRxLZ7CPZY0E0kZSEIPK
FqkYe+4Yu/pQCAVlyg5U+hNUYNNuXVfel4LoPzRHvsbWLX7DouFNQVfVP+iO
Yp/patay9KQgOaN73YbbVcA6SfFphRsFpXdHPo7BzrST9tp0pSBa6+v2ldgG
p11FTrtQUPM1vaVD3CrAepPNkeCIj19R/GCBfZtuR2mEAz4++FBECravVpUi
gz0F2cfTc2/boQJf3d4ZH75CQTQF5ZJd2AHtP9/RWFKQrczTBQ4eFaiqOfKy
7RIFNZanvFfDZjRmePvSnILu1V079RJbL0n3QqwZBW0aXCIMY5977F4SbUpB
Nl06PwV5cX7/Wr13+wIFHR89eCUK+zoz2aHyPD7ehUeiAjv4YQrP8Dl8/OK2
+VnsO48tq3ix6+l7Q8z5VOBDaXDKHWMKOhZXr5mMneH5KGTAiIJSd7zjrMMe
sdmYlse23pecfoJfBQqnDvbR//se+VnI5avYh7nP7Pc5Q0FHj7scfoTNGuTu
sWBAQXfemc12YDctlRX5Yq+hU+/YdqqARrHDZyZsy69ywSrYFz18ozP1KahW
T1TDG9udfGxYGVuicztHIfbJ0uZPw3oUlGy+9WMA29fkPm0q9trQZNpOARXo
Lv0ep/fve3anbis97F02r8lc2LXzX8UjsOcmwri7/r3/9i/+U4bN3xfR9fTf
9+u02SV/sK9IGgWGYq/cSAg8IKgCe9PCxqywL20PUjfDLorfTav973v1e45s
idh3fxx6I3/63/8XXGirxdY4Xkj99/49IU/j/jq2wrVCz3/v55eOnrCU3qUC
kybHLvx7f3+xRETMHrurSPG6Kna1Mtd0Bva94o78c/++R/+y/vYHdlDy8IQb
drzuuD+LEL6+zMDuO9iLP36qIuwaRj2JD//OZ/aFxRNbMTB/29S/8w28aXmO
nc0UGLMfj1/86qO7VOwbfOT8f9/7x8/eusS3WwV8BKOMc7AXfPwP6GKvhVe7
TGOb0jhMhmKbfkocOonn/yCXut8Utuu9W8lz2HGSmRr79qjAQ4nieiMcv1md
Fe7z2PTM/F3l2BUxBflV2C2HciTScD7sy2P0WcQeKb+oz/3v/fsXS/XDwrhe
xK9u3cY2ouXtTcZ+X9BS9QDn17u9rs++Yd/fOPH6EM7HPajOcwP78Y/HExXY
4/6BnHZ7VWA/UXNj7iwFhSwOIwURFXj6aK3+gQkFjewAdlfsipxmdUNcDzrS
aV3Z2BvBZTc4cL3wueq5cexTgV8upxWScD0VjJVkUbEl9tNm/Ku/Xz3RDNGi
uN8EHjq235aCTq71t77Hzt2SqhC2o6CcnUqZM9hL23RJe3F9Xzs7I2d6QAV2
PplolbiK+2ezib3kQRUwkzJTvY77hXT1oYYfYrhfXZjeno/7T9zThoS9R/D8
PDnJEBRHQWfU49vOYO8oFbnTcAvfH9WAJxy7oUPSe9dt3F/5O+8OY88+4heu
TqSgt1HUzOcSKpBnVa14GPfPHpvFghNHVUA26hTJMgvno4hwndZxFdjXLHJe
sZyCvt533+ZGxP1AVen5o2ncX7ae2T/B7tB8di1ohoJarvQ392CfuJF823yO
grqPG2RqkPB6tvWnVniJgibrJBWF5FXghatCQdEGBXGvjXl8VVABD9NwmpuM
VHTJ1GJs90kViJ2zDz7HR0WLgrrN9eq4ni4YW6gSqWhlXn1Z5YwKfMzeYl32
pqJfcZf9/MxVwPiUGLm9jIpeFL81rbiqAuUXC9Oa8H7jvNyBlF3eeL17v+1u
nWY/mtf4JhERoQJv6PsdiMn9yIU/UfhFogp82lISaeztR5XI12kxQwUkc0Zm
vuwfQNtWkvk08lXA30nLZMe1AbST+bvg21J8Pwux8q9KBxBnl6Tf4GcV+GHu
ewg2B9AysUpOqFUF/nh5L5N0BlHxH7fT7r04HiKOQ87Jg8iWeO5T6zie30of
if0Dg2ii88JtvWUVyOc8EsghMYT05cLfxdGpApXNcGvCYwg9OUA52U5QBbFT
sVedaoZQm5OpsPxuVegP+63JzTWMZtWYzfMOq4KWdE6Fl+Uw+tPds9hJVIWl
ei794VfD6FPd97H96qrg4xHiZb8+jKK1Fkh+Z1QhIOA01w+9ESQiLD84Za4K
NhQRVp30EZRWnD2276oqqAj8Lq0cG0GM/4GOlbcqsIZpt5CVRpGm6QbTh3B8
PpHWo99iR5G//aTIvkRVmHbYbhVOHUXxctvuamWqQvzJjb0msmPI86Ksbdxz
VbjbbkjiiRxD+tzpSb9KVWHi6l0B9N8Y2hTeJ6BeowoZ3mYKp47+Ro8+dK+X
tqpCp8/Nm3+ifyORXWWKU32qcNss/0UV9TfyailpRxOqYOAtymx2Yhx95B2t
f7CiCgO0/dM/bo+j/97I7eJlUAPXx+HvOEbGURdXQa3+djXYcvMuslKcQF/X
jZqT96jBcidzRu+9Cfx8ukt68bAaeNTICtLNTiBVPt45C5Ia3HhQRp9wZhJ1
PT/BEUdWA1GK1UeX15NI9e71sI4zauD5fKmxl20KPdwxbCxuoQbxYx0zO1yn
UOuoZ+g9RzUQVApcaGucQgP+Eiz13mrQNZI+0X5oGo085J2mj1QDYxFLJbaE
aVS5a4+keaIa2Eos1r+emUaxYhfqKjPV4PfsrRdTpn/Qifmyqv58NTjOdFuz
ruYPKuJT4N73Tg1imM/5BPHMoAP1k1WOX9Qg33dV9pXODHLqqKxra8XjPWN1
mTNkBj259llKjaIGJn1ixPqyGfSxYWrGY1INngVtrMfOz6CCICJ7zQq+v5nQ
WPfDsyjuU1GEEKM67JL923bUbhapXNQ/n8StDjuu/szb/XgWdZQQIuv2qMMU
bDt1qGcWXXxMT2CVUIe6k4/rn+2aQ6WD/It2JHV4tSm259qFOcRYYk5sJqsD
zTdtPf3MOSSjVde+bKgOvz+HlwoOzSFZaeNGZQv8e1x+ib3YPDpcsF3klpM6
CL+9mCN2fR7NB043r/qog13hVn13xTx6wDX7SyxSHdhpc62smReQ3PGDKhZJ
6uAHHClFlxbQk+d+tG8z1SHs64tC8bcLiOXtNhHuAnWQWUkysuNfRCq8T+/f
eqcOg1O6u5r9F3F/8HCur1GHPXrXrdxGF5HVqHsmoU0duI0KP4Q7LCE0k3DI
o08dKjpLNK/OL6EsaeneZ9i1p4bKxxeXEKPnjwQKtgnnoyqnlSXUuMq7ok1R
By+n2ZueG0vIlO5BrQgVz9/5ALM0pmXkwZd7ublfHYb+9n+VFlpGT5XKMg4P
qwPp6Xr9C41lRLjRv71/Qh0sdfu8LB8vo+vWf+p5J9Uh+NhynHbOMupU3AjX
xu6jla6Vy1tGD6Z3LhVh6z949YK3cBkdNDbojppSh4Vr8q+m3i0jJeGPWRJ/
1MF64COJpXUZ2Reny/jMqcOxti+xDHQrqKr//FmuVXUQZ3BwHXBZQWGk7+GA
bXP+dL2M+wpSv63+xg17pcKkI9pzBX1TOs7Vjn1Ug4+NFLCCWu6y1t1bUwcf
iodl2Y0V1H/6g9K+dXXQdatSU8tdQbTl+0Rlt9Thzfvxx4l9K6iGcN/QFntH
ki+jysAKirLjCr2LLVM9lzM/vIJYedd7V7Ed/FOyradW0I5rHXcrachQeVlW
xn59BYkejGHToiVDuWDaOu+uVUROmpozZSDDDdeQGBGzVaRR1KWRgP1t/tiN
BxarSKv9c9oXbE7RURFBm1Wky5emeoyRDLkCOxUOOK8i4zSNJAYmMkTpN/Ze
D15Fl7MeHn/FTAYVaalDazmrKPTNmWsM7GRgT+BJHZ1fRWE/lGoUsKeun5ui
X11FEQtiO6/9+72pcllscxXFyG1+7MbOeNeiF8y8hhLKn3O94iCD0s/0/R67
19DDarqXplxk+C/XvSBYaw19aCueeslNhixluQzn7DW0x42ltB9bmTi8PPt0
DYVwmYfs2EEG0wmGuIAXa0hVl36HN/aSOelmTtkaqv1iSDrJQ4aiPd+5VVrW
UMu7P2GNvGQg3rqoXrK5hgYzD+38vROP58gHq2HLv0hdObBfUADfT4NZsqbd
X/Skp+W5LraOC2v0a+e/yH6nj/Ir7M681xPpfn/RZGKttbcgGYzspGR+3PmL
liIuFzIIkcGrVflTff1fxOKYobpPGI+fdjTJSHkdXX1kvt0I+2ZqRF+u+jqq
79hNDcfmOvwwdpvuOoqDzMBh7JpCqmaH6Tri5Hv47uleMqyGXlee8VlHPJ8e
HZXaR4YrcwkH6UvX0R7+HEGlA2SIfyEtdERxAwXr2vx2wmZuduhrUttA1FDR
dxnY5yP2+gTobqDHkzlnt7Bl7exjN8w3kGh1bkL1QTI8DS3MTQzdQIec8xhP
iZMhc1arlK9hA534/Hzu7BEyuPYpj6jbb6L2aspILDabQvOA+/VN5FnN0/MR
u7pjPv1N0CYq+RT0+ZAEGaQazXvtUjYRqcrwzgZ2YJVYaeHnTaT0YU029ygZ
9kXe7arbv4XUSrV9F46TYXRr92Gn+S00VBLsfEga/x706GMCDQ1ElLy1uoRt
07mw5sVEAzXFe7S/YaeIXYyy5aUBjbdzgukyZPhh6F7ZfpwGtF+nVajJkmFl
59/L9M40YJg/vpVEIsPB/U7z16awxWMcarAJjcmPLRaxcw/8WMTmPl/gYLZB
A2ceWj4xkcf3OzFW6MexDQySO3X3KJBhwOFbm+nRbaDvX33/mSIZOFbk3N65
bwNdnTSZqpNkMB4+kvmEkRZ0vxEzZrGrlcREnAjY5A7G/YgMW/F0B1QFaUEH
EbojsV049+/be5QWtGWiQnSADLThwJt3jha0drk3daqQweHgbca157RAnjhl
N6VOBsvD3bT+VnQQIX1xaR+ZDIWHLkbcdKGDGl+XSBPsn5NOUUX+dKDOnJz9
GfvdF6Z47VQ6UD3wH+W+Bj6f8Vn+e410cNLCxURDiwweljwF9cr0QPqRdOqh
Ds5/7cLXJ2QY8HNKblc7tghR/46dGgOUWpXaseqSwVNJK+2tEQPIzfREemLT
xt/kyfBgAFmOA9U6p8nwYfHyq7xSBpDWLFVY0cPn15j7nq7KCEfe9xw5Y0gG
w7A5HytHJrh637QqEnttPv2UeRATPPf+ZVyOfXCk/6VLIhOIn/gZuN+IDFCV
f6S1lAlEC9uaF7EzKuMM4hiYQehh3fW0s2Soii7NuZXDDJzhpe8HTcjw/dSd
tIwpFjhtJWew8wIZmi8bmkTSskIcKh7SxU4yrg69zs8KrOtvOEqwtdJCdC1V
WIHR84VFjCkZKoKf3rRLYYUt21w6yYtkkEufuBiqzAYz2sk6XhZkmOuNITLF
sEP8E7+zediOo9z2HWnsIElrbdGFnZx+py+xkB2ulh27rmCJ6+PyUFZbGzsM
in1P28R+fjnq2yUhDuikZxmPsiaDvmvjwsZzDhyHmflS7NjpG0kmFRywo+Ln
xhh26I/wyZQmDjC4/mS7zmUyLN7MOFLyhwPq+tXkuWzw/Zvn2/pJc0JFZVDM
3StkoGQwOkW/5gRTQdukb9h9HJKk6ipOWPU8nb6KLfDx7cHOZk6QkxR6ZWaL
619il3f0FCe8fFD2U9gO9/f9j0tpxbggy2fh4FN7Mphc6/m2mcgF0N5z7Bf2
xbfr3+9mcgFF6rMCqwMZ1CvTS+jyuUBoNFHPCVs12UfA6DMXpJ6V8jp2FefH
3UvNdbNccEP66pd3jmTQZn5hurKPAPYmtQtT2Mpi3cIkcQJoBO0T3e+E+882
+nkzSQLQ1neH3cKeVtx4r08kgJ+VDlg74/gIvmceO0UAk+g817vYJjc/2Gvp
EUCukO5hI/Yn38jNOEMCzK+835BzIQPjfT6mz6YEcEqQeM/mivvhrbUXQw4E
0C6JGQfswUOijfbOBBD/b0jAC1s1+HxT6zUCDItl+FCxkwQSlgy9CVBzejWP
9xoZFJs+WTr6ESDr+tmf2tjmVeePOwQS4NJHDrli7JvNiem84QRQGna4Mo5d
QFwOr4kkgCBb7R1hN7y+Gtk5X4ghwM9zQfM3sI3KmmdkbxGgJKB730fsc6mL
/YG3CXAnS85wAXvNjBhZkEgAg+npV5fcyeCEktMrUwhwlEeHmow9fMTaLesu
AdgV8rjqsEnlW++c7xNg3IIObWJXnlXN3fuAAHWRFi4y13H/PD3p8D6dAE/z
32fYYys/zFY8mUmAqFb+pgxsvyNc+s8eEkB1d8sRZg/cP8ycuOSzCLBXTcJM
GXt3e/ehS9kE2LSPiXXHVrnhaeGUQ4D/4ofK8rCPZgaMXs4lQPlb+P0fdiB/
46r6EwLc607fye1JBgZ/p2auPAJ40axqamLzcZ98XINtfPCsdwB2xbjE08tP
CSCj+/rJa+x7XO27p7C53Tk6R7DhK0HJ6hkBZu46MAh5kSHdvlipCvv7hy8n
zmCfKq6+wPqcAAWDIjZR2MGnUpsQdixLUPJ77BJFj7Z/78ftpbqrZ7BvLOVm
/Xt/rnFWbu6AN+4nhiU+ttii/kkiZti7PbfidbBpH08bJGDT7PgqvBubWqsd
8gX7j/i1Kz34+pWTT16uYSfcOpUWhZ3BTUeR8iFDu7f6yh7sAJIF5xVsHVbj
shw8HtNL75XTsCUhgH8nNimC37kZ20BNStcXzwff8+vp9L5keNNTlvANz5/x
aZKKHPb7r5/Td2AnzqwP22F/fCBsr4/n+3vyp9j72AqHC/cG4HiwE6OkGrBb
u7UW7uN4aXdrt69jr7A1E57heEYHcvke9cPHB4ZnP3uMx1dzrzoR+/uYBCUY
xx/szO0+Y9Of6O8/i/MjkHUf+yI21diHY08GAVYM8s+a+JNBQj4nPjKNANO9
H8b2BOD43YxaLL5DAInQsFsG2J8E8tZFkgngIKopHYZNv7A7PBTn89DVFv9h
bO8e0aJd8QToXh7gLAgkQ32BAPunKALsfJBX1IsdcignsCmCAGdPOplwBZHh
AIHrxfcwArRELD52/2fNn0MvgwhQu51ZVj4Y9w+Zrx9mPQlAX9z46yq2/ZAJ
enqdAComiUHp2MdEtZ8YuxGgIlPw2xZ2xb6mV7edCPDmiKRZbQgZXpavuyZZ
EyCTbBhqFEaG3zX6PKO6OL/H+A5GYjuU3Hdj0yaAQFxPfQn2gS7pIjFNXK9t
NjyC4WQYCe89p6WC883CO4+KzUUIEJOUJYC3b3qTcyTeP+iHjj/YRYCFkY67
2dg/Og4t0O0kgLsxl/Uv7PO6XhY2PLhfSYUtqUfhfh5V1sTJQQDrYTthoWi8
fkb2igmuc4HuGRm3+hi8v2yaRnEfuEDkUD2PWBzeX+75nZZK5IKGrmUzahLe
D55oPctE4ASt3owjvMl4vOKXXgYwckJNv9rfU9i2dVwlE+scUDl+O60Ie7em
L0fpbw54sy72K+oOrv/rQ8n0nzng3l6Tc5KpZHiiuP9BtAcH2Ni/M/C7j/dr
I5+6w36ww+ayD5nnEV5fXEL2SYSzAaOrwI0rBWSoXTtjOtPPDNu8Jg9VlZGB
/DP+AapmgJb2PlFSLRl29dG9E7pFC0HzS35ubWQoPtzW4X1mEwlnqRx9S8HX
U38xxDm8hEja3i+GsW+6MOr51S8hw7mCo/xUMrxe+aKw8HIJRanulPLDTnvM
Xszjv4SmB6aloJ8M8+aRDVzcS6hif/rxxgEySL9nnz+stohMc5dODA2TwUKG
yb2+aB55nJYo5h3B82klEHvjwTyKX7SS1cS+90ve0iJ8HlWTm2SfYz98wnvY
wGgeHRrJlrs2Soag51pOugtzaOXgGdL6GBlSuQbiKApzKOVpviLPJK6v6OcT
1T0zaFrwXP8pbHmRtrW1mhmkdYsmOhg79u/NO8YvZtC629m2ceyLm0Z0zqEz
yFpxy/7TFN5v1JBn5A7NoGPfDVNd/uD1rmE/KXVzGsXChmIO9qBaiuv5jmk0
+Cav/xd2pPaIn0XBNEq9uy5BniGDkIf1E3WzabRh+eTzrlncD3eMZtpWTKH6
+dWZb3NkmOy0mRSMm0Sitjmpm9hu2RG1xnaTKLBLT+nEPI7XjSchnaqT6NiH
7OiH2LwzCl6v1ybQ3ajTe7wWyJBHzthV4zyBbAQe6+xfwusZ1TdN22ocbZ7U
ehK4SoYd64V7ugPG0HktizNvsK+KKEmaWo2hV2e81kf+/b4nokBQYwxZ2+QY
Gqzhfix7dMmMMIa+3qDZ2veXDDm/xdZ+5o2ihPZ357+t4/XRNfGRx8AI+t3b
TLuBPRzzJedX/QhSHR0pPL5Bhr2aihf8ikbQwioP/QPsO9SYMOfIEXRB2O2V
8yYZTjdft94uMYL2XT3EsoNGAyxXrmptixhG/tfhrSb22/eMO1Zch1F7wHmL
AOyUrVczoheHUdTtyOJhbJmbbY7CssNo4m2/1bttGvDoizjNrd9D6O3W/XJz
Og2wLf0Ut2Q2hDhYXl9Jwua2DCkX0RlCttzfCF+xf0aMrwQoDKGdB5Zsj9Fr
wMeGxf3VAkMoUNtwBx0Dvr5TZGpA9yDSSGF1esqoAWZhV/TMbQbR5q7YuF/Y
xUqHJ3XOD6LSLJZCViYNUFZN2m+hPYjEXzFPO2Hb0HJKzB0bRKwNjNeOM2vA
2ft8+tVbA6iJhs6jnEUD6DffNH/LHkBR0WF3JrDVb8zE9t4bQCc5aYuFWDXg
pLD4ce74AfRi17alIGyyY8Gubp8BlCC35a3GpgFc8d9v/6c/gIyd/vo3smsA
NUTC34VuALHP+6VvYG+btXxludaPvviuVRzl0IDUquseLrP9SC56dSMBW4jp
9eMeSj/ambUcfJZTAxz88i0WP/Sjnp/z4X1cGvDm8zmf6aB+dOfS9RwuggZ8
Pr9i7e/dj3SH52oA+7h0+qjwtX5UMTfLkI39UgA1v7DqR5kcM9F22zWATSWh
rJfcj6zVJm/OcGtA6fNt2/S4+5HpHWrrgR0aUGMutauUrR8ZDrfzm2GPeZk1
ERn6kVr0h+wv2H/nbCaDVqhItCH+fRqPBojFkPqEqFQkJBS+rQVb7sqjIMVu
KuJx9tZk4NUAx8nQQtd2KmLgsvzhiv3NqLWSv46KRgyPT6jzaYB5xls2yyIq
6ss+cNwPu/jkuLvoCyrqXBDwfol9Z1Azev0pFX1NpaUT5Mfzk/isbSSTip52
/xD8g/1LPbUs4yYVXbX20r4voAFduQeVr9hTkXXR1YTv2NML0WnaNlRkSm/R
SSeoAWXorg5YUpHOE01rF+xSW/t+MxMqkhjf6ae2C8fjVOpTvVN4fIocVT7Y
eRv3LV6T8fjitjG+wKYIP5zep0pFHEfHE3cKaUBjgf3AcUUqmnZ7/2wKm2fo
5aU1STy+6pd/9u3WgLQnkqzNh/H4duTImmA/c9WReS1GRc3FcZ+qseO14i9m
iFDRq1XzX3f3aMDhe68yCXxU5B5Kw6K6VwNiCoV4VLZRUb2+ec117HfrU1eY
NilIZE95cC729/L7TI9WKail/PoSs4gG3DfmSWedpaCjCyODzdhsARqcH6kU
FFWt9nDbPg2w/u517dd/FNSb8MhUBvv++K1whl//3p+ZtqZiu7GipcRWCpqw
bao0368Bs5o3cr0+U5Cq7GG/29hJvOUHBKooKI0uWvYTtl6ZdENDBQVpP4IC
UVE83p9zXy1LKOjpr6L7E9hBn8Wy1Z9TkI1umofvQQ0Y5Fk/2HSHgioEl6Xy
sQuH+LabJ1HQjt9GE/9h27yddVy7TUHVkRzWIKYBsiX0Py7epKC9H0P0mcQ1
4N7/FN13PFVvGABwe4+bKKkUkZFVRkW8r829uJfIzG4Qkj0LFULIlhWpFFER
GZHyoyGpjIa618zOqGx+jz+/n+vec877Ps9znvN5nXOM+nY1RFFR0PUfHEfB
ogxzepURVPTBVrXVHfxNk/dJ9UUqurg4f6wDvO9PfF1/CBzvwTPS6VJ6uN7x
dXGLLxUp0bUMt4LFHptN7/CB4+/YW7gILnJvcQ7xpqJj575tt5PWw6pRwkQ7
TypKO3r483XwP/5foT/OwfiwpiU2gXeGWJ5wc4fxKDZm3ncAtu+jfPnWGSqa
83nwwhzMEaaRSTpNRYaarGHR4Piohl66U1S0+OPF3BiY/w6n2zVnKjqxXYn2
SEYPL/Hezua1p6KHYWu3+sHFUn1z3CepiGmg1YlPVg8n/2FUErCjoidl1oO+
4LkTWzg1bKiInW9fcTH4fq3veQdrKnIMnHTtBg+11Ftds6IiHq1LIypyevjs
uX8nNt+3fOqewb0z4NmPp1SPghu4+M5mgS8FVqErFlTk3ls8tgTOJ7NRDplT
UfMxrwfS8hDvKWpy6cepUJ8On7MF93H0ftowo6I2j7eTDeD/As5umzSlIuFP
qQ+nwErWv2M9wQGHT3oJK+jhEmM6t38UKnqfu1+eDL7wzuVWNFiMYeb3JTAt
bFhQGBx6pvbRI/BbB/PnDWQq+tQedaEffIT6MtgZLHXI6BDfQT1cVq6tyguO
yBSY1wKXRI6NvzShot7Vn5W+4ArOtsBwsJxziV8xWJvud7sG+GrbBeVu8Aif
Xw8LuE9G7R/zIagvC2cjuo2pSDGFqUYFfMqRVv0AHLfwPvAMmGlQ9HQ0uN8u
80gWuOjR79Cz4CMvHZdeg13eeo1QwEkS0nVL4LmMl6mbz5cfSZgPkVbUw2th
3D5KYPW5BjVbsNzghfOb6/FpltGr8eBDCnwhm+v1Ew3k5w3g6reEiMNgLdEd
F6fAp3Ykn9cBZ8cMaAgr6WEKsVLFEjwzWbphAg56YdVyHqxv5v/iEljsThjb
5vPw82s0Ih+B7zfunH+8uV6/i02rH2z/+ZDf9837/aM+MvApQz243xjKAeNx
+9fNV1rgR6wNS5vjtWzkesUXvFwp8TMIbPpEVrcY/M5vXfAZuGT7AnM3OISg
fnMVvBH2opVZRQ/7HKc304P5OTFwLUYF3Hkh5WA6mOnhLvYscLnAOzktmG9b
vpE3r8FbT7+QvwV+ElgRtwS2+yW2hxHix1FLi8v2MPQPfL1JvZv309/jfB8P
Zo/x+WMA8cfD3X29AZzTJsjTBG7oPcMrfATiW1tCuhbidYfndb5+MOWMbd4g
xPej3HeLAkf1sKbmokQ0xL9eOzuVCN6QaW+WtaQivwPRpVXg9N2P+uMhfzrH
LurEqurhLc2GUlG2VHRmx3Pp52DHE6QwEuTjusEKYQ78Z2fMqR2QrwdKAn/Y
qkF/U/Kl6SXkc/Rp7wD5Y3p4ar6Skwj5vjuj3M4V/OiATLSKCxVV/TeplQ1O
vGUkJeFKRQNibryM6hC/2d1V/FA/1AedSnrAj/keBO+BevPH4fi3cATzqedM
HoP6FZ9048UT8LN/F5P5/KhItOnD3V/g1g5tdeRPRRRhI19TrIcLdtZVFAVS
UWmfDpe4ph5W4FT+lBxGRc7WKhrtWnr4489IL/oYqKdmO4qE9PSwNT2N8jeP
ilo3mtZI4F7X7qcOBTC+Zaetw8H2gsV722/B/LNUEWhglV7OmQe3IR/rTC7d
0YfzQWp596X7VHRI9IqdgqEe5hkN3hH1FOJ9dnqbnhHkxy6f7/91UJFNckv8
BTM9bDheG/GIgYa+nCz69NFBD/ccvGO3S4eGpC8X+JI99LDAcMePjKs0ZHv2
5fnEID18RfFB+EwbDV36sf1Nz1U9zHY/Ilh/Sz8KepAQdixFDxN0LUvjT/Qj
V1al66UFkA+X791UK+pH8mL0S9/L4PxjrnCXe6ofdWRNNUrVQn/GOHVTU3EA
OeVxDUS0Qr+ywhH19tLA5vsNHP5+gn6zWC+vsG0A8WyrOHyACuejGsfhczyD
SP+lrqf7pB5+wBGZXWg7iMxbV1ZbF6Efu72tia94EFnYDI3JsOjj+89lJFjn
B5FS+dxB8636+EPU56/reAiNWu/tytqjjwW0P02IxA2hpPSIzyMy+lifX/7z
+NchxClFJ2t2VB8Lu4iZfBEbRqfC7vRf1NXHt7UnPeu9hlGlQ/h8lZk+jhY4
dN+taRh13/RzYHPQx+YF/OwynCNo/FS+5CkPfbztrPX+rydHUFfsLxI1CL5v
9V0ptXQE5Z078Vboqj7unc55ZbgI1wM/F+44pOjjaRffwO1Gv9BYybPvzfn6
mOFj0iz15i/kyVjmJVumj2tkrKyHZ36hD7v/s7Op1ccBOrvDmeF6hSV5rbj4
P32ccNf7DFfGKFJIOUtc/KSPeazvtkdPjSL5yTlDN6o+jikbHaCiMcTFcrs4
Z0IfF3RfSNW+MYZ+VFy1612E/St9o3NifAxFPY7xUmA2wCs7xo8e0hhHQtoN
P1L4DLAU7ZbhTPY4upG2raR6jwGWPyXWP/hnHP1QT25fOGCAp7r2qFwjTqBd
gcdMtI4a4HrDYGa7kgkkz8Ym/UDXAK9HU2S/0E0iFSkWl53HDXDlUzu2l06T
aCeH9IKxowGuKvT5s9E8ibq1PIfzPAzwcp/VxvtdUyiKc1BhIdgAd1vn33SP
mEJMMkE9ntEGuP1MNWvyzynkyqXYeyfFACtzSf9bVptGz8L2Kv8qMMDn5eU1
bxdNI5qO7JRumQGmyRWO1zP+Riu5HgzltQbYzs/K2c/rN/pb9dGnt9UAl3J/
nOz88hu1iJ1QF/5sgC12czK/Ep5B0WLcp7xoBjikQnr7sRMzaFfY4Mj3SQP8
UG237EDcDLqRSn3FsWSADzHLddg2zaAlVZ51LRZDrPZUtNJ8aQapqNqlZPEZ
YsYmlmv+CrPo9Ju+ywt7DHF8oqb8Bc9ZdO5R2AdfGUO8WyNBovDeLDKx1Ap4
fMQQh2/vz5/tn0Xiiaohi7qGWCrn1scm0TnUucvsi52ZIS64EMvV6ziHvNRy
U986GOJG512UrXfn0MQOrgdLHob435+a+zqTc+gYJUdIL9gQnzxfIrghP48i
t50czYk2xMPOkb4obB7dVNIg8KYaYoeHTBcvtc6jFD7dVO0CQ5y1GrPlHt8f
FB5x0TeyzBDbuB6teuH2B6nr9T7se2aIz6Y/5dzx4g+ayXHW1Ww1xHLGTaUR
Yn8hfrYeOfPZEHvcOvK+PukvGhUeuvKAaogbrO6+vbX2F2nu+iW3MGmISSPy
67Sof+j8BXZFpyVDvIY00v8jLCCm/xLpMsGPirrWrLcuoCxB/o52MD977tYZ
gQX0sknY7ciyIW568o4ssnMB8fMoFfCuGGJZJV5ilvgCevbAnrNx1RDLEK4a
f1NdQHRDlYNCdERc/Glttun0Ako+YZ/WxULELlYbdKUtC0hMk3KGnZWII5K+
f33UBt8/oKWqATadaFh79nYB0ej20+6BH580UOzsXEAKpVMHQtmI+J5IZJXQ
jwXUuRH2SoSDiDuFd+7b928BEe7nzHlxE7FtUgXTTulFlLzyhcLOT8RXXAxf
XLu5iC67KGarguWvxXXS5S+igHfX+8+B2dZZXocULqKTOVo+HWBjolt4YMki
klYrS00VIOIBrm+BadWL6L+QSz27txNxqldhluPnRbS8JG53SIiIOe676jnz
LqEpp4hiF/Cjswpb0dYlRHvzbTIN/B/zFoc925dQW3ZS+AI4eXJH3LjwEvTb
S/kNO4l4dOlaW6ncEpIPbu/X203EGrudqn+aLCHXRZ8ztnuJOLGuvVQ+ZQll
Smt1J4M/cMjrDGcsobd2W7RbwZMPbL4X5CwhheYK4YMiRGwYyC0pdmcJrV2b
7GYRJeLv4gnS7s+WUMbO0zpP9hFxPlti9zx1Cb3WsBZhlyBiI+8HRzQVl9GK
t2SSBrhCg7m95Mgykru9sOoLFt+oy9qmsYzSWDO+/Nz8/Mc7DmbDZeTU+Smp
SpKIQ33rEuQcltGyk9G6gzQRWy4LBDYmLCOZq+h7tSzsv6+ogfTUMmpUCmwc
Bd+T7uFmmV9GpkPlhUJyRBy0f+ru6OIyCtAWPnsRjFn0ol4yraAX9Gt/dOWJ
eFxSSe3trhV0/GIdT7cCEX9rfvxFyWQFhQQqa80rEjG/0wBPd/UK4pLwFBdX
IuLV81yPi5+voIKeYjZL8Idt3D/DWlZQizL/hzpwclL6Nv1PK4jnz5xtlDIR
8xxKeK8zvYIKvR/5bzlMxOnTMp3zEqvotduB+/KqMP+krvicolVk8+jDDUew
zpcj4f4PVtHkP9+QG2DieF679ZNVRLjSQJoHO3gNf9Z8uYqs8o2nq9WIOHxm
9/MbA6vo16fzihrqsL83n3/WEl9DLMeqnhthIo4OyQ+NqlxDWVFWd8PBw/4W
lh8b1pD0m9XEcnD8Rx5L2dY1ZHJC15GgScRjSsuS3F/XULp3D0MX2K5efd1r
Yw2J3VnUt9Um4uy2Zy2fTNaRNo/6Jzc9It5lcud1/+I64t9zgpYPHqysHF5j
2kAj8uenP4ODjrE2yW7ZQHGmhRwa+kScdJPZ9I3UBupMY9bmMyDiuKTUV39s
N5D9zo7KOkMinm9yKtdu2UAhkg7pnMYwntFPa1mO02Gjo0G3IXmwRVc4MdyG
DgsTbzz2B59jf9VI50yHm8+9ek8Fr/691CR3gQ6zVUiwVJkQ8ZrN2n7pZDqc
oTwTYEeB7fNeqavppMOPtSKtHh4n4iO3yeb0J+nxQCdD30/whYBHDOWn6DG/
wxUHgjkR3/m9rObmRY8DQmNO+4IdmLY+54ygx6pV1/2OWhDx+zDKMmMxPX4p
fjP5vxNEfOiSycev0/T4E1vl6x/WROz9hSF0IJkBM2YqGfHaEPG2B5K7M3MY
sJJ49QcM1tvT/eXkXQacoVnbcxs8tKuDR7SBAduENA252RJxjvK7tNhRBjw4
8Y7unx0RN+ga5Y3oMOI/HUNHeByJmOvwe8lCLiZ8SuJ7vzY4pkp+elSICfdc
+hgXDC5ymG0wlGLCzxQa+4bA+2QUv57QY8KhKZkR9U5ErL+QnVsYyYQZThBf
n3Uh4q+Rslc51pgw748Ky1enifgnQ2ePHysLjlC+S7cEto2TSF0SZMEz13Pv
y50hYhP1rTJZ0iz4k8a1lWwwt9fTTFETFpxxy7nA+ywRt3zMveyWwYJ3uQr8
2u1OxH59OU63DrBi6YmQgCBPIv4X+DRl3xk2fPPbD7GHYPNDM3MSoWyY4y3+
3A9WtrIMUU9iwxMlLAokLyK+mv4C3axhw2WnU8Z2nydiq1XZU9zs7Fh+4L7d
K28iXnSRUThVzo6Vvn7R4vEjYmlhu53h6xy4+LXarBY4yfyn4LWtnFjgWX5B
IPjN9IfkG5Kc+F+G6yoNbMoSlZBmxolrzGeeVvqDfa7cIt7lxKqdrFLWgVBv
Udi9RyQujNpUeItDiLi3i/HZRgw35lFiUOwGJ3z4vpqTzY1/3np/giWUiPvj
k9CuUm58McQ1/yw45NOjv/+958YNsimysmGQv82njEq38GDVtClSdTiMZ1ta
s2wqD+agrz3/C3xAjjumvogHf/W8kip4kYiXbimS9z3hwUH6O7+HgLUDDdsu
dvLgmmUDd3SJiClH752y5OTFSk7Fsa8jiLippzP8QDAvZuo4X7YETvubVSIS
zYs/q6p1SkfC/u3EvBMpvNiH/9P26+CdWeae/0p58eO2jbumUUR8Fh0WGf3O
iyOU3r2NAqtp+/Z4/+LFlMKM6Upw+C+3vrdzvHgmRFZl22UiblZS3RnMRMBy
crb/fQMrejzae3UHAa/f3D/GeQX213v1XYIwAb9nneNSB98SbyoJ20fAHv2x
5gXg/96a9/HLEnBpWvWgy1U4fwdwj+1HBBxCH8WaDtZ4M/P2vDYBE72MD7SC
u9Sc+m7pE/C4/pCPZDQRo6uaD+rJBCy5soVhCkwIZlXotifgI4fMSKIxRFzy
yk65zJmA9d1S0izBgee0q86cJuDTvXwSL8G3PjvGJGze/85z3HsBjEIltv7z
JuCruqm1MrFE/NR6JkbHj4CLK7caZYK52eMfJ4cQcNX48fR2MA+ye5AYTsCv
RNJ+0l8jYk0z7e0+EQQ8kMR/wQO8Xebcr7GrBDzbal5XCD6vrpVzMZaA6dbT
GHvBi6P0p5biCHiPh0CGZhwRx3bSjRYmwXjetqAGgOX43qx+uEHAGt/SJcvA
zw3z+4ZSCdjOYFv9tnginlK/0PgqE8bz0gkmIzDFmEksMZuAQ6szjCPBlfwH
hXAOAd8U206bAL/eNXLNNp+AH9haSokkEHEZ+wnP/woIuDYl0+cEWGtfYtX2
QgJ+/aa3Ph5c9w5lmBUR8Bc6QeZm8K979MSA2wQ8etjK5B+467Er6+ViAl7w
yso8cJ2INzaWmIM373+/+4XmCDap4b9odZeAt/0QlM4AH2ol3Be5R8D7+a19
34F7KCIvusDKpOwGukQi9iVcX71QQsA6UV+ZVcBrxRZZS2Dz2h3kc+Cq/Afv
z90nYNcZ66xbYJXfT3peg30lbvZ3g31yPk4RHhBwlP03ac4k2L+zz4x1wCnp
Qn4YXLWD7qDL5vPm222e+4MFnpI+ba7XP2bMYSkFf+wO93AFv1D9TqaBXxcj
VX1w54Wd2QLJRLwuJBOwDUwtsR0ggkV4GG0/wfanqTkHIsDO6Vb7QsHr2/r8
noJ/rnuzb9l8n7vJrsZxcEtJpn5ayeb99Xase28QcW6DkCAzWKYhl2IBZrWv
rHKB8VCb78uOAwfIMFg+gvEjSu8ebALfePjkyASMr43TSZm/4NLUiRR+sFtW
nr90ChHviXTNl4H5iGURZksHj3O1lUrB/GWp25u+BQePUnfzwvze88u/uQEW
inwsMgTz3zogLOueCuNvO1B/Mo+Ae3Y4BBSAd4yqNjHkEvAwpaCpCxxnziKf
dZOAmZr2mKE0In7W6iOdDvHn6/uacAF8uD2nUjAD4l/iwoci8IFAd4ekNAJu
Sn5pxJIO9f/1lrYTEM8hzqf034Pv2b+xM4P4H9vGw7IB/qqqdNkX8sPqXXWL
QgYRUwPvb70WDfGhxKaVBhbZscydEkXAM8ylx2wziZiBtyt7D+SjQ93xlQTw
R777mqOBBNzhtVrbCD5c0Rh51x/qS6/xYdEsIm5nVrBmugD5f3/m4Bj4ukr1
McMzBNxnpCIReBP6qeHo/QJmBEyipw6XbJp9n74+1Je6pzHF38BlH/bzXDAi
4EzhryIaOUQ8J9bBWKZHwGYzobuYc6E/jGGueqkK+ZPavCU1j4iVhkKG4kQI
+Ok3o9XyW1DPeY5fde7ixWL7nV9QwS9MnOaPvOfFKRcCrxAKiVjs0nZO5lZe
7MVWxOUD/s5g3nyxhhdLqCzsUi6CfPS1nF7J5sXZNwrV628TseOkXOORk7w4
3ODfxba7RFydrjp78QcP1q0uoKeVQT3fn5u0/oYbvxYRdxWqg+unOc+H3w5x
4j3Db/b6tEL9FnxY8COWDbsfKVT9/Bn6OZZ4em97ZpxKyq/4SyPimsahG/dm
6fGN6rqLylNE/AS3iWSyrsH1IXvpxWXo5427rKIf/kXv3ffpPgKPTqwsFKb+
RYJi6tR+cOfFMqcPwX9ReYb3Vt0VIjaY+njbUe8v+h7aG8q5Cufn/c0arrQ/
SEnvjlHWGszHi/v3pAT/oOFvePoxHQk77mqXds6aQwppNrGD4DMtnR8ORc6h
MGM/UQF6Eh7ruvpll/sc4ntx70QQ+ErheL/6sTmkcYenSYOBhE8LP2avhevv
jPN9Se8YSfi95bJU/cFZZMAUdHCYhYRF7qWszL//jT7HsMwKsZLwyRf6v3Vv
/0b2nOmPKGCXAe3dP4N+Iz++J/INYGadmwv9Yr9Rwd5J2VQ2Er6Pe8OPRUyj
f8ccpTU5SFjqemawjc4UinwxPRYAbjQM/CoiPIW4dMLvl4EPHnppcXBxEomS
bkoKcpLwwoGftZIPJ5Gxddf+3+BzPjMqwUKTqNjfYF8eNwmLnqwqzmaYQPJL
PQOfwCc6TY1ptHFUF3aqiI2HhJfEe028msZR5+UoET/wtMJot0P4OFq50bCH
xEvCmh0/ltNWx5BZucKuJQIJBzvvltjLNobofwkKWPCTcMxDmabdZr9QAj3/
t2vgEm/rHoejv9C2XbwFjeDnZk/MqXt/IWlTZilJATi+aHX99JkRZF4/e2wF
XCfz7uvnlBF0L+mta+F2EmZB3DqUgWF06MF/Uj3gbK/Fv/j9MGpoeTHNIUjC
N2rsc9yeDaPOpeogP3CY17SJU9IwWna5naC/g4R3st3cQkPDyPhIWNWUEAlv
SFaktz0YQl/MAoNFd5JwewVBmDN7CDl7+mhYgltsS25FxAyhgKKzr1+AU3gW
eOhODaFbXBZ9qbtgvOrtBnRFh9A8TZZJVRjm19F3OfPOILq4IvnGC/zkaY/n
+4xBxLZNLPE2+JeN3H9ysYNoF0lIkHsPCeemrhT4nhtEek9ZZGhgzdGw2BXF
QZR9jXo8WgTmK+Ki0uP2ARQlop1YAy6Lu7nHsHkAedTefT0KjqiXFWWoHkB4
zFOdJErCd+T26fcUDKARg9X9hH0kfMxFlLDhN4CU2HYsZ4uR8NuLT6K2ig8g
4VthSu/A9XvH52/uHEBsR2heq2AdaMYR3wD6fubeoL04CRctX1j+vtGPotqU
3+/bT8JmNTotTn396EO02a2HEiS89oyg73KzHz0Trv72EyxSHVuQntKPiqp3
CBAkSdiySO8qLa4fBYzQrvmABTN2MjWF9qNdeud9D0uRsF0YTTzLvh+5Myfo
NUuT8CTyPxcj2Y/M835HzIGtdeMr9ov2Iw3l4/X7DpBwj3Tu9287+9GWU0IK
0eCa3y1bInlh+y0lO0gyJEzSzRFvWqAh5iv/TXbJkvC3mLGzXe9oSG4kz4hD
Dua3zmlVtZWGrAwCyhC4usDXtvoFDT3gkvB4AO7bfzB2/CkNUdJjJy7JkzDd
QZmdWoU0FLLgSHoKnux7dNUgl4ZuWx8tHd/8XPz7sFMmDf3bPe5uoUDCWfEV
xe3XaSj3Lmlc+iAJB9oVKISF0lArmxjRERzvKqLPH0hDv91X76eDzxSiwuc+
NKQl/9CN7hAJP+vVO6HtTkOjNTxj3WDt04VaAjY0pPTm468IJdj+Y4PkkmM0
ZH/ggX412D//IVX9KA3FXI+6NwE2KFgK7FemoW+mimdOKJPwlwHDLjN5Gor4
ljZyQIWEgzzd476KwvEe89RzAv9zbrvQt4eGPufr3s0AF/wVMJvcRUP7Xf6d
oj9Mwt8DG20Obaeh9gnL4R7wb4MvlONccLzGCrpcR0h4TyxPbS07De15xHZH
E5w2fufXAVYa8vGrdS0DN/tmMygy0JDgmtBQ5FESJigcTE2epSJXnp8DMmok
bGEas33wAxVNTQk/swf3t7wgGLZTUcB7h+vJ4KC0zN9Nr6koJqH/8B9w0c8D
mdRmKnrAMZxQf4yEjdojDvRXUZHiuLjzFPis5NXF14+pqOHN6cN71KFez1fK
vSinoo7Y0f4osIXOqmhfCRXNskyqEDXg+xxt2v/lUVHIiAxXGHhYJSRoXw4V
MbR69j8EO0ycq03KoiL+q7/jtyAS/hMl03gjlYqOMM7TvoBrk7hPH46jouYB
xWoOTMK6l3WS6WOpiPjSL/4YWKKUO+bLVSqyjfynfAtsef62QVkkFV3cWIo7
owk+8H3Pr2AqYqWqOmaD+01Kn2wNoqLkxlDld+AKk/ZpUgAVFYavUeW0SJjB
k9D304eKWlbolP+BQ3Y5/Y3zoCLj75ocktokPMtqrbTlHBX11EVRrcFJ00ig
yI2KRoOZ4p6D35rLqw2epiLORVbqFR0Snr+f0EF1oqK0XoOqavDRp3LNNY5U
tKvm2rVRcNXIV9dsByqSC+BUMtKF43kQaxh8kopqLIzYL4IPpatQAu2oCCtf
/1kB9o9xSr9oS0Vmf3iubdUj4YYKnwsl1lT0/TPZXheskRL0+e3m+9QrkxUD
wWYXjnH8s6Qifx++n9/A8hfVE05v3n9uerySS5+Efa1uFpVaUFH0wbRYDTBz
uZDYkjkVZc0IKBaBTRMPsD48TkV7z7zi/gx28WyT3nxed8kP71FGAxJeEZLm
iDGjIgVz4VdK4O/pi4kbplRU+/Zd3ilwc19v0SWwlmZwUAbYZ9pDnhX8tmb/
8TZw5Rs74QwKFX0rjmSTMoR4VLv79g2Zipx3yg9ag8fcyPZe4Ikbfc/jwOob
qnRCYD+2uKx6sPNP29x2EypavXjYdxKsPV4sHA2+8nfIeDcR6hEzu68emMsj
RdIEPLY19Co3OG0AMV4CX1mY0txcD95tPfWjAhyfap5WAb774eYzGnh/4suz
cWA5PYPULSQ4XzI/LDu3+Xz4hr+eWuAldxGT42ANxdsGvuDAfHE1TXDrfcq+
YvDriCanzfvNyXvX17rAl+b+VGyuf3/JKP3CbATz0fVu6+b6tyO3daUK2JOF
GKoCHr3MkngG3O7m37V5f7r3cuXZLDD153Fui837472dtN+AL3BE8nuCI3/x
CC+Dj0v1ft3cXw77hkVpYxIWv3DUuHzz/vout8+24Ijt8fa9YCHS9vIE8Kpp
xRozjEdRc0vsc7DSiWtCqmDpIz4u0+Am69ViX/CT8j0ae0xIWCVlIuEJWFX8
vSAFrKis+nLz+fGvckLmI8CLjgNKGObHiE+y4zHY/ftSdyK4K7a7ZACcECuY
OQAe8lew1yFDf+BVirJh/j0mfxzxB9sXIY5V8B/n+K13wfGrQvUuEC/MlJHX
rBT4vR2/0jUh3vZL5yq+Ay/clSpWhngtv2XIswr+kO2xvRGssn1hVMaUhPPn
hhhJEN/6TGb5iWDpa7X8PhD/Z3+yspuZQX3xmiibh3yZMX86GAX+7SN2OR/y
Kfidc2MluLi3y8vYhorinj33FTgO8d+gY1UD+Vea4vvzCzju9YZcnT3E4+f0
n9zmsH9s216lQz4f43/2Uwt8spFY6w/53p6++rMMzHaOL1PLmYoms65SIyxI
OCpR4g4P1AuZgkyapCUJdzqxfXb1guOn1tJOgkPV+C5FnId6u7ePlgJOlVpr
KfCG8S3a278KPiruNjcK9crzzv3+Tis435MSS4sDYTxK6weCbEg4nEn2wjOo
hwGTPwYegi8z3ulkuwzxKks3OAC280yXsLsC9btcZ9DIFuozk3MGZwwV/X78
fnCvHQkna0cHJSRAfj+jDr0+ScKR/jsXeKBeP25h/CXoBPE5EXSF9gjiOSrR
jgh2ED95xPUJFdFp7vgUCpZZK3o4VklFJs/lnv8ES5LsXy9Vw/E/tU4tdiZh
vtCLanLPqUjyXgVScIX+S4/KMPSGivKv2Wbpn4H4+9IvfWqIiuJNKg0DPEk4
05LtXzAPDVmfTWf/EULCjOF24iqm0I9o5Ykxx5Lwvfk5l94MGor2bckmpkG/
snVStuYrDS0rCXtkF5JwIY9RpO++fqRtkpnFXA7XFwJf3zO7QX8kobJXsY6E
8Ts144aH/ehqMiuzexv0X7nzmf8t9iM/00Xtxs8k/Oj08Qo5NIBOFO2k7ewn
4S3sof+m4gcQN8m+J2MKxuMMY8Hy5wF0u7JV4vMSCb866P5gWWgQyZQ59Qiy
GuGW5n9qZ88OomurO6mhW43wg8WmT4THg+hrH5vu6F4jvPVSLBeiG0Js4TtZ
tskZYdbsboULJkOIy99YxEnVCP9hViJ3ZA4hxrXH2U/1jXAwfrT4+dcQ6uhT
9pAwN8KLQlof1w4No6AwaraNoxEmHPGc3R0+jATK6sUyPY1weYqhKlfHMIpR
rGGfDTbCvpE7DvMIjaBJ4jDJPMYIZ3lHGqx7jCAF0aNjQWlG+EgA/8W1xhFk
YFpGq7tlhJ19dUzXOX8hc4KZMku5EY57azIs5PgLKUlsH/KqM8IsGb2BByt+
IdYOnhlamxHu7+pkimMeRbVKMpb83Ua47Z/+nXWbUYTnzwqe6jfCx4JLZKxL
R1Gd5heVpmkjbBJcOCvDOIbYRk9XqKwYYVpufvxPizGkbLLz8nlWYzz53GtH
7r0xZKHDUPWY3xhHvpNX5aUfR8QUNrRFxBgfv0EpJ1qMo0PemhIhcsb49ZHq
a+cfj6Ml7lvuxWrG2O/nDqZ2rgmUxijMNqlvjNlt8vFX5wm071oHg7qFMdYs
q3Xb1TyBok/nW5Y6GeP7sm5rrHA995oxjfW7pzGuCFi6KuQzidYUGvj5Q41x
76Rs/LNPk4i1mjHMPcYY80X4ho3ITiGmd+H4bZoxzC9b1viNKdR9eLuDfqEx
/ntvPjxwZgpdde35cvWhMXb8+iHSyGQaSYq8rnhfZ4ydBHR4zz6dRreUv9IO
tRnjnouq+/5s+404v+06X9hljCkX6auko34jC41oq4/9xjirivCJfeo38l3m
yRWeNsZWvUIcIlIz6Kre22P+K8ZYcffH8wOOM+jcePHhMVYTnJmaFfQxfQYp
mNy5LsxvghOeiq9mvJ1Bo5pf8EkRE5w8np4xxDSL/K9Lm9TKmuDbQVsv2B6b
RX/PVjwTVjPBqwe+Sz8LnkXmTDYXdQ1MsP3jw07mNbMoZmFf/jVzE3y/Ssx8
79wsehiyd2evkwnuaEqKCFecQyUWx+Y0veD7r3KNpHzmUNRMuJhXiAl2U76u
f/zxHCLvnKu8HWOCK5v/6XMszqGZvKt5/1JNcMlUI9fxY/PoyiPSkFmhCY4I
UvVC1+bRlNDBq+0PTbDihQZZta55pKx7LJK1zgQ3Xa0SPCryB3lvBH8jtZng
iadxZ5yD/6BLW3qvP/xsgq3vxn/83fkHRVWezhfsN8GHX7sk/1b5i1wEdnHo
Tpvgu/a+o/uL/6IdH2Y+JC6bYEFVsRov/n/opeDiXD8rGQeIN2rz5P1DuE7Y
24yfjJ/ljHQpyS+g1olLhy+DRXobK/IOLiDS7v71SjDJK5yeTWkBnYi4fV1A
gIxfLQpt6T+ygDz0JEu/gPtDuvjvaC2gzE8HR+y3k7FvcY9JwIkFND2uY3dO
iIzzrLRsSJcWUO7OcwZX9pKxXPaoxNGeBeS0XVO5FvzWNWbM+OsC2r91u+g0
WO0eG9epvgX0mOPViqUIGZNlv0feHID9WxKqOCBKxn7RfamivxfQTO9bgc/7
yDjt3UPPB2yLSCdNelBEgowVHr0uqVRfRJNc4+FNsmSsmvld4eajRUSIlqTN
gI/TpdeIVy0i5Y3TWqJyZHznZId2Vc0iujg7yHIVfKRO+tK3Rvj7nh9JRHky
NnL2YjB6D39f8LGwW4GMB0wf6LWNw98frP1vQpGMl3s8dTQll1DRgwWJ3Upk
3GPc3qkis4Ta9qnEmYCbrh5mVFBYQoRtlSaPwQd3OHrLHoG/Xy7rDVAmYydo
tC0M4O9f3RqjP0zGbF2c9nZu8PcnYrkFVcn484SlUmD5EvLLVks3BjvSB5gZ
Vy5BvZ3edRks60pXIvkMfs/FQmYabP2Je8/v5iWkeEGU1KJGxiHZf3UaupfQ
iYSGWG91Mj7DV/fcYX0J5b6cYXyDyXjx3PlGPvNlRMdSHL8ObgsS4rxtvYxO
GVpuVdIkYx0P+r6jDstIrvO5aAH4PO9RtVD3ZdT0I07TX4uMP0YZ6phELqOB
RbFLIjpkfHt9wBU/WkYS8tbLwfpkbPeZ6+GTrSsojj04physdU3xOI/QCpoe
zOIfBG9zezByYe8Kqs76ImdkQMbmrX8JprIrSI/BykXYEOZ76s/WC/oryLX7
RPtLIhn/Ebidphu+gopCzfM5TSD+HJbrn/5eQSwn/A5gcLVCRqTcwgpyV0h7
5ge2zztp+Xh9BR0a/vzpB/hNcnFEN/cqajY5zvqITMbSHzwWsmVWEU3EzNvc
FMbzqHeXuMcq2v2arJVnTsY/2WInh+bh8z1fdDrAn/aXV8qvrqLiQEf9DXBv
0tHHV5nWkLTEBSMnCzJuTwu5fVxgDalEp5wQP0HG0ayRn4MPryGKTrf7Q0sy
xp3WGwwX11DUC5vU5zZkrMH562wF/zrSFRxMnwY/Hz3Jmii8jti8z2XtsSVj
C0nekRDJdZS0JywvEmx1j+7TpWPrKPdi3j1dOzJ2d1q8cfTUOnp6jFb//iQZ
NzbFmkbXrqPRZ6eGfjhCfGaJ+tp7baCJb85cW53I+Mf5o4xaoRtoetVByQDc
6lPKoBa7gf5gmytPwGo6X5m9ijYQ3RsTsRhnMnars3X40buBBL8edlVwJeNO
9r2DV/fRYf0l9qGoM2BrnuesuXSYuJOV6xl4//rQNvpiOmykzqQ0BRb+uu7F
VkaHzSLXL1ueJeMypslEzQY6bM8+v0/GjYx/fR/qcfxBhwN29Ll0u8PnqvRR
XqL0+O7R8kEJL4i/5brKe8/oMdvXrZHW4CiObWfmm+mxe1CwcDxYfk/eJ5N3
9Fi+Rsd6Gnx+rExb+Sc9fqb0vaPqPIznWsiTV0wM+K08W53mBcjn52psdBYM
+Le4c7KtHxlnSn7raGZgxGb/tcleB/s07go8xsOIq1xl3zWC3XRCvd/uYMRB
txeZRf2hXpIFWvYeZMQMIkmho+BrZ06P1DoyYv5dDaf9A8m4oduJ9+krRnyE
b5t6UggZE9VFWfyymfC30JmNFvDF1rqi6hImHDb89uUyOMv4kOzWZ0z4xbNL
BqdDybhEdbeJUC8TNnQYO64eRsZMQv1yztuYsU1Zg/tEOBnTcZbWULOZcaie
S5Z+JBl7/zuR6F/FghtDHs1vxEA9ZVByuinPjh1DF+qVYmF+9Vwvq+uwY/ow
jStuYAl+iZFJK3asE97O/xksnEHa6RXFjt9eGlW+e42MvwtWHR7rZse9V/YG
GcWTcWp1no7cRQ48k5i8mpVIxl9N1RvKOzhxSlJvy3vwwldyQuggJ1ZMFr7O
kETGV/yOCBxb5MQBN8p2e4B9qgLvp4lw4dXU1xoomYyfyu/nifPlwuzZdJHD
N8g4grNCsHorNxa97c18KJ2MKYOmB6o1ePA+kb3aLuCW+bI2TjIPFiv4EJEG
bmKgV9dw4MH7c+RW/4Hr0Wnbw5d4sFTq5Fx9Bhk/5lk84/6cBytcPkvTzYL5
GGEbsD/Eiw/SCwoHgkvrPuZrYl586FKbbcmm5cpUl4x5sVLo/l6ObIifSttr
w2d58WHfofcfwA/+2EyW5PJiDRfHeuscMuZI62TMWeHFqJ93KQ48MUUMOs64
+SKGJpUGMNWq9L9mNgLWshV+IpwL9dQyQMpyKwHrHu8rGQTzBJQ2uUgQsN7H
+BH+PDLm0/jNf0AGTFYT0wMr5jH4fVMgYAPSzYIScDKngcnsUQI20rbK8Mwn
47kO9soNIgEbN7N25YN3qdSmspIJ2ATVbOkE77zhULxgRsAUtW3XDxWQ8eFU
uqvJNgRsrth1eQGcK6H59+5ZArZ4fLlZ8hYZd3Ac/Dd7joBPyCtuWIMvTZAf
iZ8nYKsDKSENYIJhUZm+PwHb7qNciCyEeCtUuxcUQcC55/y6qsGMog/+07pM
wH2VWYcnwatx9glzVwnYXqd/7UQR7J9NcT1jPAHnJzA7JYAzboSGnLpOwNQu
qZZmsLiJUNLDJAJ2POUTJ3Mb6o/eUf/ZVAIufJgx5QRWrn1xZyqdgAf+1lEy
wc75fyc6MwlYVINa2Q4uy2UMyckmYJdoxu0MxTDeJ89HGecQcHGHRMhhcKJt
29FfuQQ8tM3ohwc46J1R99l8Aj59L+12L7ikhyNRbHM98vczFu47EJ+/Grc7
FG2uL/9w0wJf2aLrEHWbgCUj6N8HgiP9LuUmFhOw22txhYdggVEK65U7BPyA
QEwdAPu98vnifJeAx628/m2/S8avA1IND9wj4AOFKdbG4FMVR9N+gD3Gqhui
wAJdTHPBJQRcdvD7nmdgq4vmeZvvP58K3oiaAkv3lnZeAMu93Dcieo+M73+K
bn0P9uIwMLQC79C5W7v5/PMKM4+y6+D2Vt5hPfDMzWTeV2Dyw8eXN9eTFQar
fBbBjF9iOjfXmy8c+NotWwLxO/+WZXM9+onv2hEXsElUgNPmevVcvUhuFvjj
1tCdfGBFJr2N9+Ak8fnz7bB9PyN3Z8b7ZOy643m2L7gqLfG/I+CT230+s4L/
9j2R9AJ/OPLU8hocn4p4b/xt8NT9vU6Lm/fLe65MfwGz09dLWYBrnu4x43kA
8c4SPFEA47e4pv1UG+ztbk3bfL/8Eb2zgsHgq+dfadKBgxMTQsvBUSMvDLbB
fNT1PPo5CNbncpTbCfO1LNytuaOUjP8VOx3ghfkMq9jNdgV8DxuRNv/f4PmC
5rlacMyP8R8xEA/r6HTHNHioJ/G0ah4BX+osT7MuI+OUiwuK3jcJ+IXg54VE
8LM7FsPzWQRM57Rg0wLOKJ12PQvxGDWLROQfwvn3ZVWRWBoBvzzqesUVbN/5
4I1HCgEzRsX+ygaLF60m3U0m4Ct8Hx8ylUM/Ipjc9juBgGMUnVW/gR/xp1n9
vALxtjTNx1UB9eaTTsePKAJ+3Rg6oQ4mi40RPkH+sRHTcwvBrZIqGdlhBBzr
+Hr97CMylqTKPN28Pzz2utyrhcdQD8sSCkYc4PeO1+dIPSHjYx0Ws9on4fcE
DfxswSKp+dpZUB/Yip3Em8Dz7xdO77eA79elxURXwvnNqpm9zxD8a5kk8BTy
SSjLuvUg/N7DGDF9cIOUX2mhHPyeD/9aENgi7NNr/wPwe+uy5X3gu+bl7Wzi
8H1+J0JxNfTfD4+X9G0Ha7Z1HXpGxoJbFcVvLfLi2JzUk5R6iH+puZvTkbxY
cjFBLRJM12oTbx7Ci9vMo3c8ASsyuEc+9uHFLDzB3VsboL44Wc1QXHjxlQh7
415wLj//mKQOL444JaVu3wjXL08kNc2ZeHGQfNMuj2bIj7DOXFU4X5x5Nf49
pg22zxJ0RsGFG6uG+tW87oLPaRx5Ho0cuD9u99T+fojXzhS202xsOFR66VLi
NMzPlgMv2D4w4T/Xlj1rVmC8pwRJf83oceEt7u/rjBQcbPh5xb1+BSnoW4Xs
YKLgQoMTA+p5K6hxqmiHEpj7LVGE/9IK6lM9YuUGdr0V8vad1gra1u3c/Rks
73Hxx/m3y9AvP/tQwkzBLeWT7B3flpCPj3OLGSsF78xM2buNYRHR7Xjo4glO
7SAvTQwtoKSmBYZYsKKlisGHtgVUxnVd8zk4RLekuOn6Ahq5W9MowUbB5Q9C
+ihCC8jmO1ftKtgkDYVGqvxDWjo1D+9yULCgR/jxgPA/KEKqOqYJ/CnSYr+7
6x/UyPPU6QuYb+v53z6kP0jt6xMBDk4K9I/7nVt2/EFKXuXhnuDnH29nedbM
I/GsO8ZKXBS8uuWVBs/CHGKbTJ1q5qbggoH0UM5rs0jvY0rbN7Dl4A5nbt9Z
dKX6RuE8+LBY75j0yVlEF5lkIc5DwUHH5CNrD86iJYH457HgxvHTo5J9M2gc
RV0n81Lw8bzUEC+VGfQ+1Vv2BwG+z/e0OJ9hGsW1iMf9BdPO76yt+TmFDP5+
G+HeQsEv74p85qyfQi0ndG9pgJM/uFic8ptCDTuEtt4CbxOfuvdzbBKVFbxa
dOajYP7YPR7T1Ank3hlkEQpe3dsyU9c0gSTp5Z6kgiNnb2W+LJhAxc5Z51rA
cf9YBC47TqAccc+f4lspuK+q6Hfr0DiKK93WMgpOib3+Xm9xDBn0vdtLz0/B
HXz7puq/jyEW7sjwHeAcxqj77k1jKMprQoUIDvP65OAXM4ZCDr64XwqeZU87
pyQ0htxq3JK8BChYuNg6BhNHkcGrBps/2yh4yi7s1c7PI2i/tcxbnu0UXHmz
PTe5fgQx/c45KgVmPHjXVbN4BDUJhQrag29dvuVuETCCVHyO9rSB768XF6vv
HkHiItWmOYIUPN2rHdfkP4wYasSbn4JdBLHlG6dhRDNKV+gE52aPn2Q3GUa5
QX68zDtg/Bau35SWGEb8nYfee4GvKzjoQY+PGC5VGGgJQfyWiR/7YzKEaPx7
ntmB1SYuH1PSGEKNDxIlAsHXLvo7FssOoeAeT5YycP6+d3FbuYfQjKxMi8BO
Cg7UzS8T7RhE1L4SNAYWTHhxp9xqEDX4CFYw7qLg0e+/2F4RB9FNtlhhYXDn
kcxgevVBdELpzJoZuH6jiXVFZBB1xIvXN4C/DewJ6JkaQA2qRSrJuynY/4ve
i76EAUTkbaWVgHm2jLtJRQ2g3sGxuGbwS1x/Nz1wAM0lHKTOgY/Zij575zyA
JKkvYiyEKfje46Czd1UHUNpl6hehPRScqNpj/eV3PxK1YrysCA7J0WZZG+lH
FTISskZg6+x348d+9qO33V6R4WDWbntT7vf9iE5yXYoGbqvJcB8r7Ufn2neF
3tkL8RwRyWHp1Y8Wb2HxRnAaw0PGLWf6UbS/64ce8M8mDa0Bh350S7hsH5sI
BYd2Gxe/Me1HPd5q7e7gqjOlN+6o9CMtAZvdCqIU3Dt/3duRqR91joW3GYAf
bJQN+q7T0MnGwgtOYN5r34VyFmko6MzYfylgO6F4RrEpGiqvDfL6C/ZeOyQr
1EtDQvaZTXX7KNiX4GrmUU5DrzP9w7rBHl3ZJzXu05D/x+NHZ8BPv8czixXT
UKcOoVJcDPJHR1lH6iYNXT1w7W4y+IZBm7pADA0dOnXGpRR8LYnzb3gUDdHy
dfe2grNzJq8thtOQKh/DzRVwuzy/n6g/Dc0shlw/LU7BumXC2dquNJR/yJoY
CX6S2RyhvHn/uMdh1lzwfzcnSw7b0dBd6nzER3Bw2/rfc+Y0ZNvq4XdsPwW6
A7oTSbo01Jpqb8snQcGvlHTfZEnTkN/7Y4KyYOk7X78GSdCQCOvObn3wj+F7
J06L0VBYSK9JONifhGbPCtPQQSeK1ih4zvORMttWGvp5U26DQZKC92cJqZIJ
NJTQxdWwGzzHy+BVxE1DI/pvlI+DLfdxdniw0VCunJZUI7ihjbdcaI2KiGf3
jnwB3+XcH++ySEULhetF82B9pfCol/NUZCZQv0tKioIrtv+taB6nItZVRUIa
WMxhOvP5VyryeSO+4CZNwQct+S1966nog+az6Shw5c8O6aPPqEimjjiSAy75
ktDF85SKRh6c734PphM8/Xe0nIpsEmorDx6gYMKFT6HHb1NRDZNRKRFsJvmb
J/UWFfGH/yxyAZ+2lyb051FRhydjSjr4sLRN7b0sKtIiG3svgZ9X3jr0PZGK
CtqoZ/hkKDj2xcCLawlUtIp8HA6AmxKJgbpxVFStkGlyEtwRSG0cvEpF0nz9
Ms3gUY6UxzXhVBQT5yv2DUz6d8X5XSgVDTGw7JoHs5To8U0EU1H+vDSnuCzE
w/HW78YBVLS1228sFlzl5W6Wd56KvI1Z+wvBbMY2UtxesL//ZX+pAyt/o03H
eFBRbHVj2ySYZ+Rrc54bFQ3LmTYxy0H+ZrheP3IWjufeYLUw+LAZ338/TsP+
Z7LdpYD/tO5j0HelImtCTp4bOJ6O2M7hAscTK5seBbZMYk744gTbDza7UgVu
ftjsf8MB9t8m11lQHurxUmitvy0VaX6WszkIlqhRW7tqA8dDajYlgnWbV8wK
rKnI6tgIDgPLjW17O2lJRU+rgo6kg6d2o+q9YD5ZToVysPR7euLJE1TUvlth
Dw1csVNk/bc5FUllvNy2BL7BFjqhC47mseDhU4D5V1gRKj5ORXgjeE0bPIXm
aEFmVJQXyPXXDtwjW6r/25SKln/nT/qDz7ny3Ni8X7yK9ur7PTBPraVHJIWK
bhRznXgBVstb/iQI9jpr0fkFrPG40beGDPEsk0+cBb+4EKx6EiwxM9LCfpCC
0z+s8XFs3m9cJY9EwUX1wmPPTaiIFhhUqwpu3V9Rsnk/83O1ZsXj4G/0Ueqb
6703N9jLz4FfqLunMoADX5lJXgGfeKea8dGYisxjcopywaE5rQfvgRVIQ7ue
guVHDphdBnPzyma+ByuncQ2fAo9/8t8yAu7ItfhisrkentEYvw4OPDazQwN8
24aVZfsh6Kcq/stUBEcIUyLkwTOHmtDm+vjJgaxlfXAjQ+vG5vq46t1+P0dw
qu2r/zbfp77NXfp3EHgq+NYlPfC8rK/bDTCXBWmnDbhztn7wPtjBpiDGF1z2
lMn+JTis8FxVyub724ONv3wDu1YF36jZfL+6eobZPJh/dyrPAFibntrOqQjx
dypyJx+Mx97/JPTFwP9t5ynRB6/FejcfA796zlActfn+dKNaNQtwZL/kxub9
+DUEhmpP8DoX8T7b5vvuu4gK0WC7Ga+U42Bjuz6xGjAlbuuvRfLm8+vFCz6A
5R/HKm8+z51lyHPHKLjStTr2CfjFuQ3uHUrQv7jsYYyAeMmTN4g9CH5RYsQ9
DQ6ZT2Yggt09tg04QrwphYouhICZZg8/MYd43ILOXUgFx9O6UrrB0wxVE6Xg
uqZ2VluI33txurQ+sG5qY4ivBRUJ3Tz7RkOZgr+HaAt+hXxYOPlY2xIsTn9V
PtyKirpElp+fBx8QP+8nDvl0/X78k1vglid3rKIg3+hqy3MYVCjYbVJZx+Mk
1MPeP56t4PWzlx7+g3wepFtcpoEFI2PjJyDfaVIrMSvgA7svRA2doqKvofRF
CocpmGrEED1wBvJvD0/PTXBrgHAiN9SXx2ckNM4foeBTTUXaAv5UVJ4s/e4a
WFziA5Me1KsHtbJWxWChsCyxkEAqKuZU8vkK7hIOsZiE+pZRge9qH6Xgm3yf
LBcuUlHYgjWPoCr0pycNAguuUVHQ3pM5h8CvWEsD6eOpyN/QUdIYPEZ3Q/00
1FuvnNNaUeDEwYuLh5OoyAn5BkyC60I5NFfSqEgvJuHnCzWIv/BT25ehvm/Z
3lTupg7xWc2tf7eOihovBgREgef11x8oN1CR+4isRg6Y07W+svU5Fb18mvu+
Hbz/Se2tqRdU5GceMimvQcH2iXdOmbRRUc8NZel/4PKn73stu6gol6vsThSm
YEkf+lNev6EeMGTn5mjD+K6VfwrgpyEVZa6jZkS4XrmcxvPDkoaUDfguj1Eg
/usmuUfyaEiYVTKE1xLOj89iZrj7aYiOp3dP3UkKHnkjqcV6oB+9f5HuM+9C
wW8qYj07vPvRteO/fLjdKdiKQ/xu9dN+hOQ+iZR5w/XEln9us3QDiFrVHv41
APrhabXncfoDKPiyY2x8OAVv6bUjhqYNIIZDMVj4CsTrQEaLF20A+Sc8v4Pi
KDi63O1DscQgGpC7XjucDP1gVs1lov8gOhruESKUScFR/UyfpBsHUdzW4bHP
eRScJ35BJhX627fXZli8iuF8OlTLT2c3hP6Ucn7MeEDBHyUnkzPvDCHBbS8M
dR5TcIAeneW3v0Nov8yV8xE1FLzswv4Law6jfaLftfKeQ/zWbbjkxw8jIcd3
LRotUH8SBve+7xtGK4bv5r3eUvDDEpG9vFIjqCfU9eO+j3D+SNyaqRU2gm5d
T7ar7YV+PuGDaHTHCLIgtaf9+EHBv0KF373d+QsxmhaGRg9RsArvEw55718o
hyGat3Gcgq/4zL9OaPqF9qWtUXpm4HOVIvsJ7lFU7Mmj6bsA/cZ8uFeOyygi
zMv9zF+j4B1jqV4Hq0aR/4tRKTKTKWZcyQ3V5hpD/x19IprIYYrFwzi8FB3G
EFMqz5uHBFO8J2OLqcLjMaSuxCRstt0Ufyi5wj3CMY4cI9n3Xt1tih8Vm0u5
OoyjsG0lncfETLEz3x+bD/XjKDb+q1y3tCkOvHA8x3f7BLpYJqS6qmCKVV6r
l772nEBeAn/n7x02xVfZ6uis2ieQgTTVZkDdFN98pfQjSXwSbdljd35N2xS7
Fx/QmgmfRF22PofyiKZYiHeN1P9zEkXqZBW9o5jiKmE2D2fVKSTpb9l80dIU
F71xymvKn0KNV+9f57M3xdK8MXevwfWohhYnq7KrKR5n8xx64ziNnumxyPe5
m2K2wSFGm9fTaNcCgYnvgilWWmb6ZiP9G3nHlEdLBpriYYJYzPP43+i5w3DN
q3BTzKt7tWDh32/0d/BAxtRlU0xvVrWmKzeD9j/i3JcbZ4pz79dpHT09gzQl
V+y+Jpvi2b0mf21yZpBRRLjOQoYp1pw4sduicwZR9mZ/y84zxQ0tV737OGYR
8mjZ/e62Kd5rwaqTqDWLJOiu8UY+MMVP7eJOyUTMog1fWvn2x6Y4u2HbFHfj
LGpO1V85VmOKB4SzTokszaLwFf1/I89N8YLE09wPqnPof4ruPByqLgwAuH2P
UZE2VCSihJDKOaEsSYwZU5R9qSxJ+FB2KckSIlIoO6lsUVIJWUqUEDJj37Mz
9u/15++5o3vuOe/7nnOf0713H9+FZyKVBrghI52x0XMalTAtzyjXGWB7nb26
5NJppKmqRG9pNMDaMdJ/3Blm0CfxwCzmVhg/p2jDI6dnkDz5CmfRXwNcEfpy
X3rUDHpkTRPU7DPAtWdHAw/1zKBukStNdiMGuO3PUxMu2VkksS9EZdOUAbZo
pC6fC5lFlJ+l+qcWDPDb+x4vd/fMIv/aQIGlVQMcw7zwq0Z7DiUk0+5GsxDx
xcHBCsHSOfR037mM91xE3HuUba334DxK+Ed0u8JPxCql2+4Jlcwjf5srky+2
EXFJRwhXvd4C6mTjtigDr3mfLtAyWEDKmS+bmsHTt9+MfTXc2P+ezmcVIuIj
cm3b6y8soEvO3m524G16nHF9lgtI8VbUktR2InbvwSM2/y2gscgylvwdRFx3
wWXkdcoCulBG2P5pNxFHVp34Nra8gH5VOCa2g3eaH8gUXV9AerV1InNgtnjT
zRQmOjrdErRfSpiID7y6nVLPQUdyk3T5GHCwiuT2ZgE64hHr1rsiQsTnthT1
2sjS0afQN0GEPUR8sj9iLcuOjg6YECfNxYhYLOJKVymVjgyTrfI8wcXV4ruc
e+nIp9/VIQp8nZKaJDlIR83X44a+gE90HX2Q/o+OfIM6afvFoT/nO0NqVumo
5aVt0xj4R41a+Jtdi+gOw618Dwkipr/eTzt5eRG9Pv3A+SF45pbNfjuLRdR+
/+mhbHBh06hVjM0ikhX4lN0BnuSi/F1yXESdkqwvVA8Q8YTgXXe6zyJSMIyI
ZpEk4mcfd7CXpSyinrQXrpFS0H7sMBczsohk9K+fzgG/d1Q1eTWxiDyWVASr
wQylDC4/ZhfRpvM/3y6DY+paOkTXF5EynWHZ9iARH6rT/8K5dQlF6Jj6n5Qm
Ymn1G3tWVZfQiQmh8BEZIr7Uzfi6NH4J3Y3vM2U9RMSPg34mJiUtoZ/qrw+L
gk/VVL98kLaE7B5rNpHBW7Qv37j9ZglFnXLf+hn8/Xr+bEHtEhqO/pUQd5iI
HV2fKkQsL6FY5fAMjSNEzBVrcsPMZhmZHyIsm4IvRlTlizsso4NiUXqeYC3v
wy9nXZbRJ77YuZdgVgNZ3pd+y2hk4Kn6NjkiJv5nYhKSuIzQo5fUYXDisUeZ
67+X0dDUt20RCkQsvi7wzFZ/BeUP6tlngbc9lb9kd2EFef9tLP8CPivgq3zT
fAVtrm22oYPJXnJpuc4r6ERyZ4HFUSK22zHSmvlwBUXqjZ1XUCTi5n+PeDt+
r6BjOdz3/igR8eXXoaotdquokHpKcBp8LW9XVqXzKjq01SOVSxnGzw7f/ei5
ivZ69306Dj736Q1DR+gq4jr/YfEp+HAvJT7n9SrqnHaytzxGxEXP/dRqV1aR
n8pPvVEVIr5xcmkhP2kNLTlx/GU+TsQ2mWNBltlryPWFqv0ucK311uk9RWvo
Kk/O3XPgDwvk8ca6NUTsCvz0CjwfQhuenl9DYgFH5VxPQPxadnpbEdfR19rH
Aqsnifj0rq3LbtwM2NIqpHibKuTzE+9+j80MeGXFkyIHZj6pVnl3OwOWlTWJ
twP/mjT+WivBgB/H7t79E3x08MzHbg0GfMXquVgGIuLYqZFlD38GzLWaI29w
iohN3lUZ87Ay4tTYxGZ7sLKzee6XTYxYVTbMLRhMSzwdeV+QEbtYOb19D148
xR6heYARd9TKHt+vBtf34+iqvy4jzo0tUlsGC+3uqRV4zIj1ZD8apGkQcejJ
bofsE0z4MYe1TDl4z1FzqY4zTLiHxsHZCh4ZOnN8twETdntI/MRxGvLfOvPb
bxsmnDjdf8gB7Lw2TNsZyYRHCnl45M9A/Yn5pC8wxITvHjOu/qRJxOwzH0SD
0plxI/96yh/wo//ulQgWMOMdIy+8p8Gkt9w7yz8y47yEcQUxLSIWPVOefPYP
M25Z9ntxF6zJkS5rvYkFi5Vn+OlpE3HgiYLKp54s+JPanEqnDhGnniIKplqy
4vu2+vGz4PjzeY1pN1ix4f2cBZ6zRJwsXnXkgx8rHmiyKDwJHsuP6ZNOYsU8
Fg0ySeCLie/C+f6y4gu+GaKWukTcPZor2n6JDU++v8g2dI6Ik8IGL83Zs0O/
lDfN6BPx0HCQr8cHTsxV/kuN1wDq05eCTMefnHj2zHDBAbCcMHP3tUFOXH1h
a+xlcBF58IsXPxd2uH3N+CtY9HVVaqcNFy75ItibQCTi9lFJOwY+bqxHvD57
igTxL0Q7unCJByt3BNlcAstcWyuyvcGD91gntLiD/W5s9ftyhwfPulWV5IDN
ZtOOnsrjwQnxO70FyESsGuLLJr/Gg/tpX1mHwcOOPTl74jfh29dFt0VSID+/
/OHaUsSLBZRGKjLBpRmkpkuVvDhvrcDpM3iXVI+I7y9eTAvTrJ4GB4RtNTk7
xYs1cp3cyBfg/JLHZ2al+PCm4bJfOy4ScXqM0MyhWD6c/jrYVx7MfE6n/ttz
Pow99A/qgm128XadeMWHXdj7ArzBn6f/S4n6yodbxLnlaOD32Ywk3nk+/Mzy
YmSaMRHbRmlcJIgTsJLUvhPl4Fv426t+SQJunBobbAEXOYYtPD9EwEz+fojD
hIijvkxRfisRsF1Sxr9rYEkOgeDt2hvfI7+REAimRik/PHSOgBMOHT+TCGbb
1/XyoAEBf/vQ8PQ7mH93lk7XBQKW7ZzTlb0E87nQ4bz9dgRc++IjXQu8n1rS
6n2NgC3tQ1ItNo4bHXj8wZGAY5Z2rUSBzXsFlRduErBMxUBGDpjrFLvOlDsB
V4e8NqwED2uOkJs9CZgupJEzB06P46wj+xLwQ9omCu9lInYpNHaa9SdgqcxW
JgnwT4cjAbeDCPiSkr3xBXAqT42ndggBz60psN0Aby81SwkPJeDw6rU3IeAh
qkP5hzAC/kyO4nwPFjW4ca1943nVAMGa3+DvCddrJqMJWO5VQvAkeJ6YPbWx
P57K8YJ5vykRHx/Ze/1pPAFfPipRgcHRemkH9J8QsKBljp8J+OXZBs+RRAK+
975gNRL84L/zpS1JBHxqSKksB+z3bnyzZAoBL20t86oGy+i7dFo9J+CCU/hY
NzgsWVDv7gsCdnCqXFgGXzjFmxydSsDiT7SKBc2IePNcGFdIGgF3ff3megTc
lppdbZdOwHGz+vK64GebbHllMwhYf8/vKVsw09uEnT1gTr2Lr/3Bb0ZVD/hk
EnCF11+nRHBHO/d1liwCvpVhIfMWLKD6R8oNrNDcP9oElvLyiG3c2C9nuJY9
BkaNLOMbz0eny/y7wm6+sX5ru6oFNjN2kdgLVnJS1rIBC92d7z8B7l/+78vG
fnhTgVcqBew6Kb7NcuP96rQ1Sxfw+L+HPhvfG1ffFLgnDOz8lOkoH3jlGDst
A1xyftRt4/nvItvQZxXgC5Met5029uej+S7/BdfyJwQygiU+Re+kg/eJaVf7
w/XRxra1b7aAepTk5DsB1x+/PfGxDDiq1GJYB0w8I0rRAr/+Yq8aA/3HfTNV
wAq862pXST30b2XSgWZv8HMfu6gp6H/vb7lRj8FKk1YsbGDFRVmDAjBDylEt
ThivTOKxhiHw3uL0A3+TCdjC98MDZksizhguOZoH478j99RZYfDAT6V5p2cE
/IBVp8YQbLww6vgJ4ue0XEOwE5g2XRNlkEDAa6bE0yHgbWwqZ349JmDnEuOK
crDl9IlDWRCPkv1dfn/AYedOf1+FeO3ht0Kz4MDarw3qUQRMsrcvk7SC9YZj
3dfUcAJWFr5dHAOOVWoQ+RRMwFM6DG6vwD8jdS3TIH+y/wuSrwPvkcyI8w4g
4F1ND16vgx8IXUlg9yHg9cCn2des4XoEl7fedSXgKxO/XwSCs8YF0+RdoN4Y
8z5NBOuGGvG3XCfg50d8IxrA97uDuFehHmhQzV3lbKB/CFNareYw/ipiqkvg
k05VeX90CHg67ZLSFluIX1/m3BlNAjbhfyQrDa5/YhzCepqApYdY95mCOXtW
L/AjAv7xaJC9Apzep0b+JkfAW6eym0LsYP5KyP43IETAty/11j0Hf44QSggV
IOD+rzsr34ObzKorJTcTcPGzB8XjYI2IgBkiNwFf1HV6YnAF2l9/CxUvQX3N
OGKz/SoRKxT3tmd94sMHTEvomdeg/ggTmGgafJggkOH6Gdz0zfvj6gk+vFj/
aPIPmHNoK3HLUT5cd+zmEJc9Ea+fu2i6X5wP2wscanMAP/9WXf6PhQ/nfXvx
VtYB8i8grXnXF16scDzCvcQR6gtfvvJtFV6MhWxnvzpDf5uMXs4T2oSJO14+
s/8P6nFm2A/xa1xYr4Z5/qk3EfviBcJ8NjvWKJ9ZJgUR8R2ulb+ytixYMsb9
1dh9It7NsOzb38WA6QKchC0PYb1Ty2tRX7eERKpOl8mAO00uuuTnLqEzrgFX
tMC+T4cUk8KXUMzP5U/e4JGGPVtCiUvoSMS/G0Ng8SSzX4Xti+gaR/OvD1Ew
Xi1BsXFjdNS59CzuSgzMXxGnlIeFFhBzdod6IPjoZzdhiZV5JHVRaPIpOLuy
VNONOo883j7U+gV20j1SoZ4+jwRcgxZPPoL7Ba6TPfkK80hv/KrJllioH3ds
isXJc+gzVUGkPA7W88TTbdnpM+jxd3G2VvDZufSz+uEzyOm94PgEWO/e/j4e
9xm0K47+bs9jaF+umMM3uN/10CszugNmVvOQsR+YRoc+qIfrxhPx2ztsVRTp
aZSQQFxtT4D5cuRyoNq3SXTjnnrfDLj60mVT2beTSMtdoZ7nCZw/55ji8eeT
aM5AMF4VnHyX82KmB9zvc7YrPAe7EJlf9+6fROweFg5XE4nYf7W5c5h/ArmS
nTsWnsL9zMHHHatfx1Bd+LbThGdEHJJl6rA9fQztqSnPOwDmKhi44xw0hhpU
NgVcBHvzapGaTo2hA6LZB96Dj5371njp4yjqHOl180mC+tP13OVh1QiSEwul
xoK3+PDftsgYQSGX5bRfgX+8HznqEDKCFBv9dtHAPm2apCN6IyiyaPeXU8lw
/3rUqsu9fRid9qMQWFOIWFtD7HDj6hBKLF3z3A3u2WmVcLx3CE1Pp/UeBa9c
VbOk1gyhZJvZYlswB8cO3R8xQ2hJ5+HlGrCCueKMzuEhlCdQnx36nIhHU0TE
A5wGkWCO6unNqXD/+Vj31+mtA+iBdvJnaXDHklnC07V+xDzEqKoJvnc0+8mh
4X40KValeBvsP8DVulTej+qenT0wAN7lsWX6iGM/8o66wP0uDfpDRV7w668+
NCv77m4z+Om7qPU7n/vQtR87WSbAPXWnxDxe9SEjHurKvnSYT9o1YmZD+5Bs
sM2/MLCl8JimumYf6vN0abLIIOKbDOsPu6t7kbFQ87nb4JAvs2Npb3tRU/HR
uljwRaYnF+Mye1H5DL2iHsykUNm1fr8XPXb0LTyaCfV6Qme206AXnbV4EMeZ
Bf/euafNLoM9qGJ9fIsYOJbAOtDe3oOUn52PVAVn6TZzXmvoQWIdm0NugnO5
0zavFPWgNVK811+wVjFxa39wD8rXSr/8Jhvqu7Rkxq3DPahNvGxrHXhdXvP1
H3H4PdPP+h5wH+OLbtKuHqTzYfXY1hy43m2f01M4e1DvEbLgf+Crc2cOh/V3
o607WX6cyCXiI3Gvo28870Yq9O3BZPD46lbLgIRuZP778EknsHTCPtncqG6U
G2GSkwSO4I36pR3YjTRYCu4yvYT1VuUV13SbbuQ2boFrwCJdU/+9PtSNEuv+
W6CBV3letSoc6EYVGWF5i2Ds1evXsKcb8VqW7jqYB/Uy5U8DFuhG6S2ExTDw
7Z1ZV3au0lDLx49vDF/B8YQaOa9GGlpJ/H3FAfwjdolDpZ6G9nqNitwB71D/
3ctdTUNOCtvCi8FX26L6+97TEHuW07Xtr4nYYcG/zTaThpSjdu+jgvUXb2sH
BNGQT/P42CK47KrGr2lfGqoULC/e+gbu91p8ZNxu0ZD+E1MdHbBnW5xXngsN
XUlNulEEbhvRbxy3oKG8gevHG8E273/sG7xMQ7MHMOsomKHhQfbkRRrye0l7
LJoP/76dSaQ8kYYeF+/5FJq/kc+moTfVaaiLPhWSDv7Z3o2G0cb71SsMP4MV
0c08xxM09Pqj5eA8WCu+guP5URqqqXnBa1lAxNefxf4tOEBD9Hbxy8qFsJ5e
9tlN4ach1d3z+w3BUsZOdqm8NBRkVj3pCE78rvp7lZuGCH22QS/AGSHX7jSz
0dCB8Ywc3iLo705/1R1LVOR02MNNEmwYyzTuNEdFhTe0kAaYrF2R9GeSivD8
0E9PMLXIk2FykIourEsu9YE/yz9R2d5KRc9OLX1ZB7epKjwX/EVFfYF1YTuK
ifjJRbdViR9U5Mxhv0cfTHcojLvzlYru8edqvQefmhFKEC+lopJ9h+IeviVi
u6V376qSqMjnTWFvDvil3uHamUQq0kDHZavBF7Olnx5JoKIfxlq1S+AwHsfW
jhgqGnhouWxVAvEemmfef5+KckWGNX3Aqccu2D24R0UuL6/HPAZL1Om8OxVM
Ras1t2W+g4dIxfEt/lS0lSHOTLGUiGXrz0SkelJRe9juXH0wv+dfrdL/qCh5
Zyr9Gliy7y693Y2KDiq9eZgEdshVearhQkWTlUpdpeClcZXTD5ypqJhYLtUM
PuBzTovmREVqTvVfON7B/dD7qKpceyriWDEg7AMLML2bFrtGRQ0hbZdOgjVq
OmmZV6joYlr/3A3wU9UM+1820H+d6xId4C/59k6vzKlI8Vqw6xz4jbDaZ38z
KlpZ4PnM956Ip34GlZmaUtHdLTuMNcC6ikN7lS9RkW5KcropOObZsXMKJlS0
+bDEjAc4sujmU5WN/W8dhQcvwXGBWvI2G8+Ht71r+7pxPKhYJYRCRVK2p8R7
wKI1BaPFRlRU5K9XLli2Mb7sDYfIVOTF95vrCNguIb7CgwTx8tSEchZMUpke
qjekom8lVyZ9wX2OpiZhRCqKOjNxIgGcOpZ2fdkA4qnZLaQQXJ2884zLxvvS
LVd+N4D/+P6pmNKnot6JgL3D4Ou+i7Ub3yfP9Oa8zvwB6rtZOuLa2P/mjny/
G3xwPInzxXkqUogX5FAGd1T082qAl/Y/JRHBD9duKI7rUdGnwn0pDuDxD6p2
zzbef66WPR4MjhQ+c48C1mmUVUkBC6oG+AmBCaZvg9+DhVXGFbvPUVHL6Mlf
v8Fasv5RG+8PT/SsFJncON/Zy14hYEv2sw5c5UQ8w6zXuvE+dIlHTSVi4CCB
sajzG7+34MEnwcLi+VEb+92bD2l+JYNFWMZ/b+x3313y13MCx0pf1dnY716p
LvsdDI4Qmvm7sd/tEr1wKQm8TY3is7HfPWgm1/cWrLLPcvvGfvclaUf7RvAc
Q1/iRfBPesb00MbfV0YvuIC1qno8GT/CeqlHfPvGfveHh7sZd4AtdutMFYPl
TC/ckwPPK7++vnG9mVLRfGfBJ+nsQfzQH8IL32OtwNbCjMIb+93RXziEb4Nj
nc7KbOx3c0Sqp8WAmXNjUzb2u30u+Ui/BHfFR13b2O+ePVBaUAVWapfx2Njv
vjo3o9IFjgyNfb8xfqTwq9p8n4hY85pl1sZ+d61xaqMEmMUsRLEArCpBpWCw
RifHx20QL5KfSLY3wELrj+9u/P+JZw8ixkPA3A6O2ZYQb1sv1rk+Bys+2h/e
Dl6bQoG/wAI/ay3aID6b9x1MPvoZ6vFxm3ouiG+dSRsJPfCzyT7/5+CPZcl5
tuAF59YIVciHbLLghziwtM0/70DIF9+7jO2LG79/r66PIL9mDU9YbK4g4mvb
GK/SwddE/xuSAtde/uhRBPlIKh2bNwFffWmodxzyVWq0dUs5mLClJcrVAurN
281PWsAm/sHiupZUJBB0bu8EeMd+DoqEFRUx7P4iK/oF1lMFng5D1hCPennn
AsB2hk9OxED98M8PunumkoiVz/+bDoF6JNjnuccCLJ9flfzyBtRHgevvb4GL
OK60N0P9avG4OPEaXOKgWS0D9U0aHaLsrCJit+1sZA4vOF7fun8S3PubWYUS
BO3tl6qO/wrzncB63Y4n0D+CouaF4EIj+bVEqNckLYGlBrBFYeTjPc+gf3LW
ZVhqoF5as/UfSYH+vtH8yAnc+W19k1MGHF/ztlGvJeI6q1fZeoVwfFsTy3gd
3C9WZ2nfgflj+z2vP6z1sF7pep4s2URFpvR9ecLgX1f7rH/8pKKhNneKPjhb
K0hMpAXyJX5XdgH4gfk7wo9OKtq368p5r29EPBZsYOM4Avkjuh7P3gDxUCbQ
c5qZhvglZQ7vbYL52dtZs0WUhrQC9nJ0thKxK9etsxdtYH3xPjvcvYuITT+d
zGHOpSHfZLWKpD7IX/NjllETNBTy/WbquVEi/q9giLHrWDfySS+Uvz9FxMWO
E/8N+XYjS7N7zhkLRLzG4UbgrepG2HzORHuNiAeLApPuEHoQxyaXWU8WQ7zb
/qDSRUoPqmW8d/wwtyF2bnQrv5Pag7xaZGWr+A2xigWrYtFkDxKgDDcNbzPE
H2i9VvuVe1G2yPG90cKGOODyy3HO4F4kGZMoUi9miLuqfK9K/OhFcUORdb1S
hng7U2uo0rY+tB4kLOZ/xBDfjTxU9semDxl8fy/1UskQVw5dN0qH9fLTy9PU
y6qG+N1vUVNRhn7U9v292oSGITZWuJiTcr4frQ7HEPnOGmJz//6eEwn9aJce
O3+hgSFODGm5lTvaj8RNQ24PUgzx3IRT3yHlAXSgODU2ydQQVwy1yqeHDqAd
/4imyjaG+Ii734NDXQNovonwy8zeEMuJvPN9e3AQfVu1m+d2McT2a0vjVn6D
6MHvhuozHobYjfuFMWfjIDoRVqNh6WOIdXawRL0WHkL9D0xuMN2B67m95fVL
1yHkqbymcyTUEEt57pGJrBpCbNIqv/oeGsL954e4md3DKHCdg9PzsSF+ILBz
7pbbMBrxGRx98swQL6upiTZ/HUY6Z8y81dMMsQvjy/7RPSPoUenAe88cQ9ye
u7qj3n0E/eBhzIx8Y4itvxQ+LK8bQcyZhWrSJYa4Wnoutnj/KNoz8d99o3JD
zEGjCpt5j6JjPs1+rFWG+BCnRpVm5yg6XorF1OsNsZXSibdtR8eQdDNys2gy
xFo3A7hjwsfQNqU2V5Y2GF+X/sGBiTE0dtpvj2IXjG9DXU7t2XH0PvHz7bE+
Q/yffD4l8vU48vz16E7gqCFWU6n4Wb31H9pT7Hk8a8oQP3Yzc7t58x/6QptP
MqQbwnpi3duz4x86/zbwzYM1QzxVK+Q+eXIC1Tu+cE5nIeFdxvfrvyVNIOxw
qUuDm4Q5TN5KVrNOoiRB8cUb/CSc9irc6pfyJKJz3K3YJ0TCdJttJYQbkwh3
3DpWLEzC+mwTcjhrEt286He5VYyEGawz42O64O9FhGW9D5LwhYHKa/7bp1Dx
w/pXb46Q8M6A71oJBlOo+uzmrmvKJLzuWB77MgLcP1rKgkhYyNmQnadhCr0+
+FtN5jQJ1+sJDSRxTqPoUopX+1kSPvFnXr337DSymBk2FSSSMNFa7IBv6DQS
3sQ3JXeBhKdaZPxf1k+j307fjzSbkrBnYePJ+C0zyP32ExEWGxLWbo38dvDi
DCL8ZCorsSdhv+97V7MyZlAC+yqrngsJtwWspFjRZxDvMNvqDQ8S7i2yqHuo
OYtub85+vsOXhPV2shmHPJ9FzYOX5gzukLCs3di+c6uzaOfT53NXQ0nYuUjc
hP/yHLqU4J/KFkXCJd8cFKIa5tBddWcGucdwPCVAgUtjHuUq0Ll6npHwYi+9
a1PzPHrfFFEhmkbCS/+psz+9voDybonhY+AeJdF1WZcF9Fy89IMBOCzjcGq1
6wK679lTEgBu05Vfm/dcQMZ7jr7qA5+2fXTYIWgBLTm3P8lMJ+Edoh13s+MX
kApB3E02k4TdBWfs7lYtoFK9dxI4h4T5X0W+JO6jo2+XOUuMwdQjMUKZ++mI
5nBByw0cFWWswSBFRxyh81eywcrLav9KZOnowle57K25JCydy8Wqq0pHCyhH
ehicZym/dfUiHR09kngkKo+EvUIyyrKj6UgLj37OBbdlT0yax9HRpfMqxK/g
DL7UWzue0FGQY5vLCpjtj1pW3HM6as7aWmj7ioRt0tjp797Q0c29YYrHX5Nw
shBNIbuRjt5s8Tne94aEzz0YYiPxLyJXC3+2VfC3k9NvlAUWkfKroCaBfBI+
ybgwLLp9EX3SCbXTBNemWW1bEV1EDf6Po7PBlI8DLF2yi2hkIn/UuQDOp/10
B9lgEe39NvhktZCETWfK3FQeLaKB7aO2gkUkrGEvejAxfhFl2f07chhsuuOg
HNOzRSTLPPfVHPz5npV+R/oiUlVhmv0CZjriHlZRsoiMM3fp3i8m4aqxUHf7
v4soOshgRbCEhCOnpt9fklpC7kp87UfAb3LCRz8fXkLGI9/e6oJdrLeQZI4u
IVF9qBRgI+rhVUG8hPJ2opFxcLcwcVzRaAnV5Uu3VZaS8MHLvlkFgUuIsZu9
0OU9XL+OkPFi7xLqi656GAY2ObZ6++TIEqo5E3g9E5xx4qV7yOQSCs9dk+oC
l/58f+DY6hLa5TGXol0G+YOCZBYFl5EyX2+E6AcSjieNRHPqLqPrJ8vtG8pJ
ePZbo0Z32TL6eVzu2xA42Haz8e7KZaSoki7N/BHaz1/HY1W/jFYUw8eVwBZ7
HOK425fRPVnT6ylgvmF5618Ly+j5vjUX10/QvwtjAuePrqBmTlWvHRXQnkkP
odCSFaTEkd+uABa0PVe/9/MKSmDbf/z8hhfPNlbXriALZt6VQLAHS52iQscK
+rfy13scfCyoA2WsrSD2SW//T19IONPouxSr1ipSaflwz7aKhAv+xF237V9F
57YM7PMFa/eHG3BPrCJzfd6PceCvvu94y+mrKLjOdK4GLMm9FHyOZw01la9b
HKwm4WuPsm22KayhKxmnjk+CQxnKP10PXkOPPKrGPWtI+MztT7zsSusos2j8
XhRY63i3ZrLaOno3LSCWA5a7HKh0Vm8d8s3WuBPsW0KvbrFZR9IW7F9Va0n4
8nEGv5pH66hCWzuZuQ7yzYDvheLiOprc8Z0YVk/CWfKnyjLsGPC+D68YMsF/
bnmInbvOgI3MovIqwAYmjj3r7gz4/QsKFx1sem/hR1gwAw6W7vls+Q3qpf7N
NL10BrxLdUFW+TsJmxHKNX2GGLCWxR6+3gboTxKjjbMHI77FzPJhFSwa+PjD
sj8jzksbuCb0g4TL87TNH4cy4i0jOdXnwHNhfpvYkhhxl4uiTwnYyHFTZ3E1
I3YNOjse1kjCm7J2q4ZtZ8JJGW71yj9JuMGPP5ujgQkH3OMpNAB/HHzFo/iH
CVtffZF4Dcz05IK1ex8TPnCwyTERHC3kZy27zITz86QJDL9IWPHCwpcHksy4
uqiX9BXscUdEfj2EGY99Megi/4bf60kXexuz4IbUoWon8Gcur6ITV1jwmzu+
r+6CtfaxFPC7s2B3zZd+peDj4lOjqw9Z8Hodx77dLSTc1f9rnFbHgjf//GjX
B/Z133O+A7NiZZrMlEsbCb9YkSWUnWTDCTy3LoWCr639XZ89x4ZXlGu+vgBb
dQbvVTdlw58eWj5rBjNXPs8Q9mXD2upxZxX/kPBuQ//pH5/ZsHE6Q/oiWJq8
0Lquw45vO/wy9uuA9hbI2p2z58Cf6R6VYV0wfzKSUHETF9a476eWCa6oceEY
GODC1TvvfaoAq3nZs21d4cJ1qnFlCxt2j9ey28+NfwYVFVpQSZh9tq77pxc3
7iFMpx6lwXxQu/pkYQ8PZpK0v/O3G/Jt5c95BqtNOOidCzMd7LO4PU3ZfRNm
0/Xy39xDwtv10nmIIZsw1/UQb03w83jTMLFXm/Dmogy3N+B7LS3bZRc34b2n
+mzu9JJw7MsSXclgXpz6c7Q3CVx9VSOWN44X77eesXgH5u2Nkq7J4MVSd5lM
J8DGg6pRRTW8WO67qNHFPhLmDj7pasfBh9UvXj4j0w/tD46/leXDh10lt6+f
BldG2bOlhPLh9MXmt6Zgh/qO3faP+TBXgq5kJHiUZfKX2xs+3Nh+nGcGTBng
FzDt5sNMOQuV3APQP40zH3vGNp5XL/AWA1eSErco0/lw3M6DE2Qwd/4Vdil2
Aja9tONnCfi+hHTj/l0EHCndcr9pw7UpPZJ7CLhi5aH6CFih6Wbr1v0ELP6U
s2jnIKwXRj6ef36YgMf+0uN8wHOn3l98coqAhfMK9ePA2DND/e9pAtb3ceZ8
DbYY5xRg1yHgAuEhr27wiV1zDzcTCdjLrPWyxhAJW+cpn+eyIODcw9GCl8Hq
pq6fHlgTcNe63g83MG/31ZAFOwI+lVyNM8Di3Vu8gp0I2MU5YPEjuFXIrCH7
BgGnYtX8NvCLsMbfb10JmKO7aB/XMAn3R3258sCLgFXe3OjcC97knyBF8iZg
e3+ZR8fBpJbfvKx+BNywJ43NERxLoZTuvUPAjyxjhn+AT0q8kzIIJ+BqOf3n
Q+Dmoz8e2EQSMJ2Jx4RxhIQT/zaLWkcR8KUXgd/kwPbl59xEYwk4/Ca6cxbM
KnI4qCuOgD+qL5+0Buv8fmp+N56A9/a5vHoELkpmE0tIJGBS4aEreWDaxLwp
y8b3yYNGRL+CK4rqNxknEXAJKf0PFfzZ95fxk2QCHhazjKKDt01L3qhJIeAd
c7vP8o+S8K88Ke/u5wSsW/WHWQrcmnUsZ+AFAfs8elSmBp5oeSfRlkrAr20M
3EzA0Ym7RYrTCFCXvmJ3cObFA38j0wnYsPEkz0MwR5D7ro3nr1NZC1tzwEw/
FLcxZxLwvIrUi2rwssIP9idgLedkp25wHutVyd1ZBJyQJqiyAmbhlXkbAh5r
f8C6bQzWbyxnxmjgkwTmpiPgCTHMsi8b+uu0Z6Lu2Eb/V6nob3xv3GvCzg7M
x+dcfwUs99pGPgA8NkKfcgAH9XesJYLHmVVHLoFbdhDr3oJJjl0TymAJ/ZpH
P8Hef71UGcEed1QtxsGBqJu/GM5f965QmmOchD8seKRRwLsmpeh7wUPkYIUB
uB5H8ZQvJ8GatRZLFuBy420RF8COR/bL1UN/ECLDjG+Cn3x3FdwLtqxi3h8O
Pn39X7ct9F/BkudUJljkx/4f8dC/Rja297rAM/c2z9dt7LcndBougi/JSr2o
hfFa/EEU2foP4j/e5MJbGM9EFVSsDd5dKPbBHMb/3/Uif2twZ0jY310QHzjt
4DlfcF5O6UANxE8vn1BfIdjGvDtiCuJL4XT4qx/g7U/PPHV6DPHkxXJrBCy5
HOfYCfEp1T/JLzpBwlsUN8uERhOw87taFAr+d2WdpvIA8n8CcaeDg4xSKtXv
E/AW8eKWT+DmZXVOdI+AiyOeO86Df0rp39oURMAr1reeWEzC+jU5XpPvFgHr
JUzZ3gavXlT1ee1BwEk/7OTiwP6u36NOuxPgPo9U+w38iUji0IX8DeGTWVCa
ImHzwKGZBlsCFnzXReSdhvulJGTVdJ6Ah1S4Uw6A99CXP/3UJeDS90oTauC5
8yO9ddqQfx8iQ/8DrwhvYU5WJ+CUT2qVNLDg1SGDbkUClv6afrRghoTTi49V
deyEetLsJHRhDs53OPrEyCc+vJn8xNYFfL3tRyt/KR/u+/218AH4qNHQHxmo
t8Gtogafwe4H5IvUU/jwt/afIVLzMD/ExR0Y9ePDRt2Kyytg4lx9vrYqH3b4
t/Y3hQ5+IZQglc+Lx19Sbd+BactM+eVZvNjJ8dPETzBLuI2Ebgovdh7zZ2RZ
hPn1wxdXw0he7DrCIm4LJlHr4wScePHtAS4HqSVYv4Xy5Lof4MUPugSX8pfh
fium4frm+E04t+GQYOUarF9SdSIEHHjwwPzCyjVWMj5puv6tNosTc9U3RiZz
kzGj3dGndq1seLfviZ/F/GA5Fmn3RmYsdetUhYEQGeuNcrypUmHAe/YZmd0S
JuM+hz0DVt6LiNYeJBQLviHxJCTMbBElRxU0vQZfIj5w/HRqEYky8WsMgDm9
UjTV2cDd9QcMRMh4Pt39SXUEHQknnZreL0rG02FHj/ClLaAdO2Xu/NxDxmLW
SfqbOuZQ+08T1XFw05TvCtvHOZRw//4C+14yrlRTq9v6Yg5tXxq8ehL8PlpL
zMl+Dgn9ea6XCc6YKRfcA/ergnFCQj77yNjH+kZlo9gs2ryFJUdSnIyrPixo
3r47jQI4B5+pgZlS2LWPO0+jqfXaKBPwgO7ivq0Xp1HjWIRXGNi3JV9u68Fp
FF69U2cKPNUQMkxsnEKcXvLDJfvJ+APrM5dpkSnE0G0poXWAjK9dbz0SkjWB
nFtP77QAd3SOJ+wOmEDU7wf4vMC7iFfz/xlPoPJ3/+ZzwD3+OhGamybQrRiv
aj5JMt4e9/F5q+s/NK8ZZdMKlt1ccP3e+XE0nvf5he1BMpYO5hC+LT+KOieN
d/iCNWYZp65sHUXf5GYj48CtllFcD+dGUHbxfp8a8L/gI4VRJSPItjz0gpQ0
Gd/UpQtcPDWCaN/Jm/6Bt7x6RWq9PIx+8E0EssmQ8Vn/WiZ7tWFUbnBvSRh8
wrl/TEliGCX+fjd4Hkwusvxwe2oIXfwrUvEGfOPMvPzLe0Po59iwu9shMhbM
L5i6/XkQfT4UOB4GnlIiCodlDaLXzrus08Ec33RO/Xo4iMJn9QxawTPbKm4y
WA2isysFB48dJmP958S0VvZBVMntQ1sBX2JZVsYmA+it1GadoCNwPRrrrPwS
/ai6yebXMzBRRnwvdUs/avEovVQKJhsLmfYw9KPZavPr/8BGw3G5wR19SNbq
VcwFOTKeDFPqPh7dhzKf6FKl5cn4FZfuHCNPH3qrlnxFEzxIe/RxZrkXVQ/P
TFmAJR6KeG4d60V9Sk9Y4sDpSv0y3d96kWjzsCSjAhlbh9/8mRjZi+J57rr+
Bn9eqhHTFO1FmQXtqxPg+LCHjYube1GJ8aG7XEfh3zsqafCbtRe1ZP6OR+CD
4YJE1rEetPm02McscMyxLjb0rgfd9/7M6aNIxnkHVlu/Xu5B8WIC0Y/BRgeH
1zuIPSiz/squAvDlbqVjW7R6UPV2wuEhsEmy2e1huR7EVGxKIirB+X8zfTnI
1YNu/Vt+tl+ZjBXiWWrLyruRSjOzFQIv8FglOxd3I3opt8QF8J1fXDdU87qR
+52dr0LAfsuBS/ufdSPnXcc/joG/lk6/EvPtRrY6XtT8Y2TMevyPY+LpbiQu
G/CiHuyx7nbzp2o36hO4b9cHfrf++Imwcjey6I6fEFCBeB7Y70yX6kaXPErX
PcDLut7zOfzdiJhOF0HHyXizhYB3Tw8N8T9g6KOAFRSKisz/0lDjDY5MZ7DZ
B7e8qVYaOndSSPY5OO9SoMDZ7zSk1ayEWU9Ae751mbaU0JAq03/m9WDq2x2M
4tE0tDroI9YHlvKIelgSTkNl34OHVsA7bHdNmtynoWPxsc6HTpLxd281+yZ/
GlKQLfZ7CCZ9X013uUFDkqZzyRRVMt7XUit9zZCGOLLe/ucCvtUXb5d4noYG
Zjz1wsDrp0MVus7SUGrI2nIFOL/hS1WEBg0JF7FTDiEyzrLRz01TpKGV9VoZ
bXDNtKvpeXka6tB5wGINbrR7osAuS0OPaYT8ePASn3ZisiQNbeHZsYkVk7HM
F4UKt900NG3U2SsC/rz92FjoDuiflGfvVMAN/GvDedtoKFxp3xVncPHY8pcd
m6G9VtJfOsAmhsu1d9ihP0pVPfNPkXEJ4ycqYZiKOlkY9b+DtxGZ/Ar7qOjd
+S/7h8Ch7d+UHWlU5NGv2bxbjYxfhHL272qjommCweEQ8Mt8NzWnGipqNNnC
lgouTutOKKikolfpvzvLwUwSzPw8n6nI4YTx/VmwZWOE6VwpFQ3aWfWbqUM+
DYSKv8iloup88TIvMB5PpntlUVHq6mDUI/AHFnYoHFRkGe2A68HPySY3ryZD
e8vdnihqkLGOh9N9lUfQXk5lFwOwpZjQamwUFcWTlrQcwBYxkbuYI6nIaMRn
PgVMpyfHcYZSUZPAPYNNp2H+2XFTpM6fimRzGXIkwKJfWJ9m+lJRuJonixpY
68jo1xhvKtK5fu2tO1iQftHzkScVVdbo7qaBTY+6pMu7UNFesyr3JXDy+ODU
xvfF/eZONm49A+dL43/R4ERFJ/ceDtQGK+sGP0mwp6LiW/zD+eCyJsW8TzZU
tHXzfbXv4LdiXHRbayq6mcmUOAjm06J6C1lB+37P6O3ShHxO1c5PNIf22Ttk
KoIFZU/svG5GRWOM/YwG4AjZUQVdUyrKOtRSeAdsOXd7UvwSFXFU6fEmg49l
2RvsNaEiW5Ovdu/AR4m8tAPG0P57JTsmwDM7TTlJFzaeTz7iyqlFxmP3Amw8
KFRELcz6vg98LVDbJd2IihK7E/wugHuOloiKkKlo6b8t7S7gkRKfO1dJVHSR
94F8GJhh5s3eD4ZUVJLKEpYBzoxS69wOFjzuPfAZbHdmT6wvkYpcm+ZQJ7iw
TFVh4/nen3ZO8fNg7tTQBBtwRIyZ7kFtyE9f9/NO+lT0T6ot7TTYAm+1Xd94
//Zn/XWzjeOX01oeg7MptRe8wGkP2O6pgDn+ncqPAWf28Vj06cH1B73jfgWO
9g7TigVX7ZC3qQWLX78srg8We5NT3gsWbTLo2tgfDtAUE1oDa7xHxhvvT6f9
TbwhpEPG50+v+OaCkatAvRyYsiVB8c7G97i5wsXOgT1il2w3ng9fSWbzsQP/
+RW9pAs2VvJt9Qe7mf5uPw4u+b4gmwg+U3to6sjG897WzveLwZoZfBIb++Vu
S0O9jeCboYM2G/vpzZEWJ0fBlRz74zb22+Uk2mNZz8J45qukbnyfPPIDcVIE
bF604n4V/M+wXlsFLM4/t3Rv43vgI+ovSGDO5bGdG+9/z/ErW3EC35HIqdq4
Pq5tR41CwLxn53t54fqvvHz56gV4245Hllpg94B29TJw954vbwI33j9PYW9r
BjfYqdpXgqOkFRzGwULfE302ns9PZrRgYNMl44nq0g4yOK8lLEYY/DQv/2Y6
uCzn3QElsIT0b6UVcBt5q8EVMDX/M+dbGO8BqVP9fuAte/Ys7YR4mF139IwH
y040d9wBE7K/ptSBldysla9APGmteU1Ln4P15jNCtQ3Eo9GvjODTYOEW6fxJ
sHVm8w5TcMRx5j1+EL9+xEPqEeDNdEliLsR3SXp39BR4bX9ctPJFqE+3eA9w
6UF9s78mOQBu1j9ethf8hNLfGQf5M7kU02cIrnub6MgO+XbgvNbRYrDT5bRR
AchPRTG32gZwrqSIeC9YYzHl8iDY0/qfSCHks/mL5TtC5yGfdpw+bGFJRY8X
8lq8wOuqHQ8GoD5wJAt4IH2I51dO2o8cIT7c1HgugL/y9FfGQ30R07me7Ayu
Msi2SLlORXi2piYF/JvC1F56A+q31u3tLAZknCMd38LrTkXDkz3vasAnSOdS
T0G9EzxYZ9ELFn5WIRPuB+2zecOxBraYulz7F+pj8h9fI3kiGdvf6CUEB1HR
hYpd00/B94zaWhZDqKgm2kjypiEZZz83DbSFepyuWBe3mwzzS8jHwZ150N+3
37i6XCBj1QfuLL79VKQ2p2sUCmZ3+Vd1dJCKRJyGlFLB7u8sKseHqKjdTGT5
N5jVufqqxRgV6auH+R+7CPlXWbRsNAP1lOtqOIMxrC+X8o6WMdCQ4GPRzHAT
MjbY8rsG8dFQbUFER7YpzF+ZXXIhMjD/1jNMfrEm4zAFxsDTDjTkIMVdYGFP
xgfoR36cK6ChtKPi+8JvQPw8foRFF2io9V7bKeRBxs57RdPST3WjxffCvE0+
ZJwac9I2ILQbsT5xvTsVBPMTp+J+amM34qqwehUbSsYfzQxqwnb1oKUYy6C6
h5BfVqbVsVY9qPfVEnvgY+jv4p3yS697UFm2+LFdSbDerbAoMV/tQb4G5ts0
0mB9wWptx3G6Fx3HCqmTOWRMq8nIFovuRT3t27oO5kP/93W7e3X2QtPCqzRL
yDjOzPfqF7E+xCH0zGSonIwdxTcvJ9/sQwHBH55tqyLjK7V6EZkf+tD8CffI
+noyDgrmtjDn7UcXf30+bP6TjAPaXFVETftRusDu24FtZMx/ti50MbMfjSfx
/3eQSsb1JlevZS/1I+EWARHLfvh7velUR80BpDqW6+o5SsaKRlq5UtED6ILO
Xw+BaTjfYb6g4f4BdIm0WwrTyVjdoIAhS34QGafPh0yswfh/r1UKvzeI1FKp
sTKsRhi9uXTLoW0Q7QgwMdDlNsKfSKmG5ySG0GiG87sJfiNc9vVtTrD3EEr3
fNS4R8gIP+JXc0hrGEIm0YaP2oSNcP+dywxacH+y/iCV3VncCDcxVKYTfIdR
uByrROxBIxy7N0w4q2kYCYquz2I5I2wW+yiGRXoEhZRyOHspG2H/2J33JPxH
0Khc2uMYVSOsRysaNfs9gjRn26/LnzbCCrWCrclHRlGYheis+VkjvBq91SDq
HtxvCa7v30I0wjn1oldqBkfRco4ze/oFI8w4GjWgeWYMbR2fivlqaoTFDT+t
myaNIQl3niZHGyPM5BuRspVxHInlKL57bm+Eq+0rGYwvj6OdB5YMLrkYYf29
pTi0Yhwx3tGPm/cwws++eFAOS/xDTWHFISK+RrjvZluYdvA/9KSrSOr7HSNc
wazcVf3vHzrfUenB+cAIC524Yl5kMIGm39q67o8ywgU3S7t4CidQRGeKcM1j
I5xVL1AvSZhEgi/H3OjPjHDGsxG6l/okiqtqvPUyzQgnRdx3Yr49idjLNQ+r
5xphrVHBy/6Fk8jSsiHCLt8ISx524BMfmUTFev+eEUphPLL2vLomPoVmB3ab
aH00wjc/oYm/l6dgPUSrNK8ywhyfZ+ONYqeQtsiJv6v1RvhjFT/ravMUMgnN
eC750wiX8C7qdhCmkS3KFWxvM8JH9t7Rv2k4jSx+qSvbUyEepLYJl8VOozNb
RtlC+6H/BCMeWrdOI7EnB4MOjxnhsV2m27tFZtB4w608y2mIh/j9Pby2M+iV
js3dHYtG2J1c6KxTNIMs0rs3FazD9W8dXvjLNotWXzqeamelYG8VW5c1o1kU
vRq1L5iHgncrMkvLFMyiLYtf8z9tpmC/pxJXKXxzKKA5YqJDiIKV1TtMGpzn
0OjCZPstEQqeeX8/NrlvDql+tbiZLU7BZ+9sLRq9NI9Cu+zfXZamYPEwyZzV
yXn09TfHqyk5Cn7ayjNTlLCASPcijnHJU/Ads6kRu6cLiKYiWLkXvM9zuXhn
8gJaStr3xxB8+VdV8720BSR9TZW5GHybddzB8/UCily7SfFSoOAtjhw6xdUL
yFiCus6kSMETwi8WXs8uoHGPIv2txyj4rk+mjC6FjhIi58cPgS9U2BF+GNPR
mUylUG0wzgpdJJnSUVJraZUPeIeqxvRVGzoyUCxXGQZzRuqylN6ko6KZarFy
FQrW+yA3OBFJR95ObXS7ExTM3Oz8u+87HUkFb48NAN/0LT33s4mOWp4ayz8F
t9976/rlNx0d/t7p+BP8nrm3//VfOuo+2N1z4iQFf9++uloyTkenh4e/8atS
cMf71pBA3kW0yXo5+T2i4KpTMbtlDRfRtXeTHs3g9pW4gyTKIqomDOiPgz20
5aRumywinw+NDCKYgq1b1/nbrBbRP8F08wCwQOCvY59cF1Fjrb6o9ikKfm0V
EUqJW0RRh9OTWtQoOL5RweUnFX5/58l/E+BpedZA/75FpNMZeZ5DnYLFMoSt
jg4vIqaQW+vHwMHjm9/kTC+imz36Zk/BOnm59r9YlxDp0bKwtQYFr5S5xQvK
LKFty/rPpk5TcKlRo0GW7xKaTlyhc56h4Lkj54YGg5ZQg2qm4V6w58SorPT9
JRQcsM5hCL6uf2m9KmYJzXPm3SwEF2mpZaLsJdQixK39nyYFb3tLGDdsWUIx
ilUzK1oUrMRY2qYjv4yc25z1BLQp+FsBD83w2DLS9dqVJQNOt0ubtULLiKX8
pqkpOOeB23/xZ5fRzdN7az+Cz5cH65pYLyMiyfdZgA4Fl2zmvnc6bhnxuxzT
5tCl4AfW375uZV5BPJ5JxXvBUnxuw/lcK4jDj1XsJDilKNveZPMKYghvWrsB
vjEZ2Fe/ZwVNZl0t7ADrjeszyJxaQQ3d8SKvzlGwquaxaqaAFXTfYGmOfJ6C
F4do4894VlHwBXMrZ3DexOSfQoFVFGBW3XgfXHFTZneb8CrydIzK+Qje1GGx
XfPIKroSImUhqU/BGbeOLNUarSLNz8bfVsD8SeZet1NXEcuR989fECl4e9GB
VMeza+i1+2+dMrDa+QNtOeQ1ZFI2Md0MvqovuX3RbA3la4qpsxlS8K0LKsc+
u64hc9Ow3ivgzGUhee6kNfQ+1EzsEAnib0pGK2V+DbkMMKeXkCE/bzbolOev
I2FpYb0msNbxXd67Pq6j2hvK88NgWe7u2bD6dSS66nBmpxH0b+eMXk7fOmrY
0jLgDV51Pzk9zM2ApU5lSqhTKFij7XzTOmbA3U90s75foOBmNkF/twIGnHtm
j/UQ+AXv3ekX7xmwx9ScMPNFyP94nx7aFwbMq5kUowx+KJL4LriZAZ+YnvJ9
AS65GFZ4Z54Bx2rFGXkaU7BwUVCRw0lGrDvXzSx+iYLfGZwTrmllxELJxeUI
bEH0SWXtYcS9OqGexuD1nkcd5DFG7JWsMBEB9nHxGzvEyIQzzt5tXwJrq3eG
fj3IhJmeS79pvEzBoQJCoflBTLhE7z/T22YUHFniMu9whhnLKzOQHoEDta6N
2hOZcd6eEO088NPjtZt8TZlx6myCAg38Rplfo8edGUcmlHNpmFNw0jZ7UlIm
M74ywPqW2wLyW9irnJPAgoV8YvieWEJ9irnjozDBgqPtdrMWgmWkhab6Vlkw
r0H60jcw8X7vWg4PK2YRK+lfA5/3dGT1kWLFk7Ud7y2tKPjTicCzcnasuEZg
3xUpa4gPmxsqnX2s2PPlm0+lNhA/y5lrE5Ns2LVnUvknONOTsJefiR07bZN9
MwI+wdugc2YLO7b2z0vZaUvBEpW8LGNH2bE+OSfAG/y1zOmw6G12vH81VeOU
HQX/KHvEv8LNgX/qPq6puQLx4Rfd/ECJE3/3b8Xd4MBjphcKdDhxTbFg6SL4
P7XPJ/ouc+IPoo+ypK5S8C9Vu3NWQZw4c/bh/QfgheCo4ZomTuyTGKqrfw36
g7juV+bIhaXGfBpb7Sm4u4AgtzudG2sEe5hMg7+b3Vre/Z4bm4m6DPA4UHBr
EE10ayM3jiHZrJwClwSsN3YucuP1srMHcsGdu30Lq3R5cHOYkJ+fIwXHPjRp
3DvBgyckNnM/AY/fchfmZN6EuSq4Y4vAVhnR1b8FN2E0v5YzAhZg6r0urLoJ
Z5v2t5KcKHgkQdHdMHQT9j2cf1jyOgXT965evSPCixNqc96pg3fmyX+3OcKL
C63STpuC5e+tvBBW58UjcY9NosHB7XVhgra8mMTge3cVfHm/TClXNi+WajpL
bXKG6xkvx46SfFjD/vS1MbBhLq+svzIfNmNFc2w3oB7+Hla10uTDMcfkuE+A
16yCfkRY8+H1FCGldPDJ+mkPn0Q+3OzSH+7lQsGEnVqjsowE/OxsNCkaHPSS
Sn/NRsBXxE7tyAWbG9tybOch4NXfiWl/wV7GZ+eSBQl4/zFSGb5JwZbsjdXh
UgQ8yc8UcBEsqhiceu4wAb8feaXpAm6YWUaz8gSsn8j96wX4b/H1V/QTBOy5
XjHM5krBjzVE2rvOEaAuOL8SAX+4IrHeYUDAvG+E3ZTB1d7H+T+TCfi5pRfD
NfC1lceyG+9r/lZ1ZNt3cK75FxVJewKOfUbt7Aer/zsZaedEwOb/hT1fA3+6
5WAbfoOA5w4My8i6UfAT/qGlR/8RsPCDZI1o8MzMh68RAQQ8ZK3HlQvmXNIW
FbhDwAUnV35UgtVoIt2BdwlYa4JiMg/2/6giLvyAgDfXsO7hc4d8q54Y1w4n
4M7kggEJ8DOHhhyzSAK+QeRzuQiWr97yVDuGgE8c/KDkAo5DtF3CsQTMxmK/
eh/sGVBz8G8cAScUVd8rAwt+CInb+YSArcNd9X6D+a8knXmSSMCH7fZu/Qfu
NyqWZHtGwJVCPkki/1Fwubuk4rNkAg6fOmijDH4o4VVUn0LAF+r+SBmAk2um
BfqfE/6v6M7joWq/AIC3IgoVRYq0WCpZUyLnFoleW5K5SBL1exWVJVkjW6VQ
dpUQyhLZytJi34mXShF3BsOQoRqSJX7Hn9/PGHd5zjnPcz7P594htqXc+mGP
9t57KHAkRRDjet9rf/RbueVy31IX99v7vR6h6xNmNUrTBAl/uQeHC9FT3l2M
wGeChD4XcLegpx8W6Gk8FyQ2UKPNTHTVsN9TOppe9DBiHq20zHiTc7ogkXVf
l9zoTiMc/m2ifqDd7H9vUUAbfi2StMoQJIgjqf266P8OdfAXoXnFTDJs0Asx
U5/m0R85C5c90QMip56pZGJ8NmerRKL37uJ+SaLt0yxnstC/90hLXEKb9le1
16KHW01cFq0puSeLgdZL439AQ8tYRwXMobmWGhbKo9clzFlu9MDzlxEQncDj
zXXZqSihN6dfmU1FD4q0rDZAjw+LxR5Bt5ntY/4PfdAwR7oFr6c0KuGdP1rv
RzdLG53avjImAc1//odwJt6PMMHLl4vR5cze4Tm8f+6Gn3U60NOuyYmH0Lb3
NCXG0Esrljo74P02bHw2xeOJ8aS08dEdHI8DPAJt29H+40zTaByv1YGUnzl6
9eCQjQeO7++KY+au6Pfeu6RNcPzpCy8Vwxe9lf/cpkRB4pWXX181Wl/YS9QT
4yephFVKodPz/65Yh/EVMmUcOYNecp7SfhgvSJxxkdRW8KIRqdqZD70xPnXz
7mz+Bx3MstncifGrNP5z4jzaMWykYVukIMF9qTLtEXqyI9IjLFyQyD1ny83t
jfPRqV9tbzFfHiY1UZJo0bFIs2eYT4G9ysUaaIuZlif+AYKEucUKe2d0bymo
CfkKEstM0hp70NWvMiuTruF4Hh4KLfTB9ZnSiTfBZ3E8fY0utKKlpzWn8zD/
Zd4VaY6go2VjytstsD4duD0ucQPzX/Hm7UlTQeKZguyJu+jiGxkq1bqCxJTE
JaFzvrheHRLuStuL9SHjzhVvtHBUjtg/uwWJRqX0xhi0QC3DgSWN8XaU6deE
llC1LuSTFCR0LlmzVfzw+PnPJ6fWYb15fbKW+yaN2K1RVPp3RIBQNdBwz/bH
9V399i3dlwSIa55rvv0JwvluQCC5ypifCDtCd1objPlbJZLBp8tPpPMWcO9C
P6xqazQAfuLbQ1LZEj0WvCmuXI6fOPImJeQd+mKd3x8bXn5CYE5Nzf8W1i9b
wdzEyjVEhs+FGL47NOKxU768ufwaosevzFj8Hn6uVnvl2SwfodnK61ofgfnR
mt18Y88qIqThvPbSeKxHJ4K9evW5iJqUk5WbErH+jsrby+5fTszUdI0Vp2F9
/jAeqyKzAKJRTvXMLKwPvvtYs4p/wNk0ImzJC5wvHeWbHwj9gUahAlMxdJB7
93uVqSnwjJ6gG6OntBnyKW+n4FvM9ek36NfbZ8Z2605BUrzProhsXI9lW1sf
PPcbpBLv3NN8if2H7S7l/NQJuGGdaWKOZtrn7426MwGdEk0irmhW8l3+sMsT
cDtpdVoGWpOrqrzxwAQMJ4e/E8qlETJWkqFXP3DgRWr02AjaiYcRnjv/C5Qy
k41j83F+zGgKZLn+BN7X7vF5aF9lwTMV2L/3VRj1NaHrDN7ol+j8hIivf12W
FOB8a+22g1v0J3B4LGLt0WKqF+0lyn5A4f/W9aoX0gjavL2Z3dofoLoz4BL9
FZ6fUJOX2BM28CtaFM6gmzT9TITd2TCoofhX6DX2ixGPuE1N2BBjSoXpoeO2
hB1K4mbDVIB6fj5ajV8ny/XaKBT3cf4EFtGI7MKCWL4z3+Fgkl2wbAnO50Yl
RY7nhqFyZHzVEXSQ2XmbYZ1hOL7PK9QCzXtrOOTJ7mEwb3wQdRd90Ho2rXCS
Be4T75+y0fw/NLtC7rHgta5oWV4prn/tUmPzq4dAMzL1SCPa4270aM6LIajt
ka/tQ7fMfXBnRA3BJ2edlvVvaMSF6HiCdX4IJh67dF9D2+vHJFzjHQLlny1T
am8xn+1+aJlZDUKpurmXCXpDwLvCWN1BOBI8MH8RzfuvrxKfyiCYiM2ufIz2
Dbi2/xbfIDgflRGaRx/eGeTU9JYJufH+CpXvaMRstWKAlgwT9hzZb3+8DPNv
vVJw19YB+PjTe8EOLbmxLe+W4AB4J1dG+6I9MgM87ZYMQNMSw8pCdPvbUpMs
ej9cLLMTkyjH+A9Zdcg2pR+ea0S0cNAXxB7Z7lTsB8PRTlv+Chy/bXxDCdv7
4fejLTMy6F3PYinY0A86s+lSZ9DiZQ+y52f7YKCkzLceLZcb849VQx9s289W
TKikEf2PREz0L/VB46BSfRE67EpDh/zZPnCOcT/TjlbZMz+peqoPKiaX3+Wu
ohEUi3qVA31wtnDTgBP6ryLL5eCGPkhQ1I3Rqcb14ntDt+sNDNBmhO6xQV/g
1pV3KGfA6P2OSi/04P6zir5FDND4cWY8F71HOal1Po0BXTnXdMVqsP9d9rXU
MpABIntSZsbRzCfGX3R1GHB1U0ITTy3mo/eXHR7AgDqe2MeSaJ+MB7llBxjg
xgzRPIl+PjyUFLabAR1PnP1fo79+2PBcbh0DwtYe4fWpw/oaIjAN/XRgLqh3
R6Pfb1HZWNpDB42xfS9y0Nf57VYf+0KH742yhnT0yUN3X8Yt7l8Hro3QqqcR
DeHlrsIldFg+RRflbcD5oeFa5/FIOlgwu0a2oeVWjUR1h9Ehv+PjG3X0OPdJ
Je8QOpzNrbdyRGu6tVmP3qTDe/vc5Da050HZpgAnOgiTmc7D6HPXfdrDHOng
oJOqtawR6z2j90K6PR3EtscxldFWrewornN0cP/mKxuLPhMimby4393W6DHz
Ev3xz+9cphEdpEtcmurRjqze9Zf16fA5+n+OM+grNj3qz47SQdnIKM+qCc9f
5T1X7gE6jFWIq+1ophHcesGFvJJ0OC/csRnQiR+PVAqI0+Hbv7eWWKDTOESf
pBgdmgR+1IUvfs5zpcBBmA7pVhVms+iZBTmLOF46SORdO7ihhUaMZvSlLeWh
Q8yKXeKKaJa9XbPbSjoEZUUwL6BvXk9aG7iEDuembV3b0X4uW/YajFHwVV+E
ZKPd532DPg1TYJzUrM7zAfM/8bOFC5MCOLZvuSaaGvlwcewbBZujuSIy0Au+
nqNdzRR8Vsh46ddKI+grcj6Z5VJgEGgV+Qit9/LMUtFsCqo7115/jV5QuPVh
NIOCghuemqNoS0bIpfoUCu43/9NCa8P79bQ1WS+OAu6tS/Kc0Y42nPaIaApu
uBRGhaKJL+T09wgKHDdtOV2F3tnjZtESuvh+97GRvf9hfyda/F0nkIKKN08/
6KGTP/sb8vpTcECAlm+HPrn6heQ3XwqkX5d5PEQ3nJi0yfSiYMWKBzxc7ZgP
wjkGoy4UeNGOjm5F93YtA3FnCn5lTreqow8/6wWrqxQwTpyLdULXrLnetNSR
gveJylI9aIGSlBD6BQpeaT65N4VuqW2f9j5PwYseHs7aDhoxd/FI8w47Ch6K
9ZbpLPpqG3+MDQUPSnWlbNBjRswD1mcpuG1ecM8L/bBM+qCyNQVusbfNc9Ei
tgqqs6fx+lU5ZY3ozrm20TFLCuw+WUkxOxbHb54zakGByXpljuhH7Ke2qrlx
m1Ogl59groLW2Hc2fztJAXGCp9wQPRd3vEKPRsHe8J57AejefYlf809RsHOv
LicB3a1pmDppiuPdkm9ejI6UNq49jObluy3FRscP30icNKFgaeave9yfsP8h
Dopbof/oWnEk0VphDgEtJygYDFYqN0Ov5Dt5v96Ygp6dCVJO6G1F0Qsm6I/V
3KF30fIHKgeYRhQ02Tpz0tAmHcukbqIrl/WYl6Ojc1Zn7kCXJB8r70LrFYXT
2gwpyCXypSbRVV3qwoHo59TmUIHPON5cFQ2AfnLjFkcWrS/darkcHb3ll7k2
esnuDfkfDCi49/Z0+Rl05fzRgmR0gGWdlAfahp2o4432nFEMjUSrbzx86gza
Kf4xJxudUe1efwz97wFui3r0FdXoO4vPa1t3OpX3oY2yB24uPs9t5vZN6i96
zcVXDxf3rw2Ej4Vu7KQRl7NPvVv8fXDtwjyOIlqleH3H4u99q5/cbKGP9tXR
rDFb3M/+FVx+Ae166a+PE1r2wU+pm+i6uR+sxee7tyqcDn2E9viv4mcpemNr
LecVOqRcJHAYzX9Z0aINPZ305K44Xv/KNY/LRxa/rzfHMV/8/fQsLumVX2jE
xIOu9EdoznGnUAm0r3FfdD96ZLibo4b+eb7qmSLef8ZtHQtTNBdo1Qct7k9L
55VfRv+akGNR6NrzwaEpaH/f011pOL7vVvzkvEND3J7baxffd59iafEFvXKD
33d/9FOGgvSarxh/9Q133DB+fKy6y93Qy3v+qCZivO1Qn7EJR2f7rjfZg/HZ
KCK6PB2dumbL+Du0yEezo1/RItSEx5gZBfnH2xvUu3B+sDK0DcD4N5f5edEU
HSqrJqm8+H5yLsHVjmhF7j+zg2iDCgPDJ+gvDU5fLDC/WPsb2pd004giLSGG
E+ZfmDDLRRQt2txw8DDm5z4Ol7ASOlHqr6kQ5q9/jjbNFr3slElSzTkKtuws
765B974Y/vck1gOTdUUDId+wH7j+pW7dZcyP8U9BKWjhnQ9MRK9QkNgyIfUW
zfNE9+82rC+jt5Xs2ejEysNhgPXn1kI226gH608lV+5jNwrejqb+FuqlEaSu
UziF9UyqLoInkcL5/o7mvRNR+P1VDm9L0NFz4i0NWD8L9I9e/Yh+MLXpsTYu
WYj2qc5VdBphd/FC7eGHFFj0nH7uir7HzPUwT6IgnCOlc5yB60+5YmrqBZ6v
xJuAyT6cD8WW9VTUUdDg3j//zyCNeKX1/KzsUjqYfdZ6emsU69H9mom6Q3To
WL+fk/IL8186VjXIhw568VW/tKdphM5XuSrlGjpkNFonui5g/x/1JsNpFQOW
a0fPyHCRBLd7w79GpgzQT7Ba/n41Saw8IclyfcIAv6f7ShjrSEL08GD6+gEG
ZI8/2xIiShI5fqMmKxT6oIYlLV8hQRKM50JZ+tf7oLlCfezLTpLQmdBquPOu
D1r6WJbX9pCE9fa7cdK8/VD8Ms0tSYkkHgsIruIy6YfH1bNgrEYSpnJmRpZJ
/XApyOZ1GKC/TL0aHu4HWSmLruyjJGHZYFtzSWkAGPyjL07ok0SIQsSaoJsD
EJASuifQhCT6bNN/1DUNgLhfvYW6OUn4zjWMvNvMhAyNGNUOa5KoyDqd99aB
CeJpLmXT50milb/G+2MRE0JPjfxOdSCJrI2nVtetGoTBvKvdvc4kcWLt+oAm
s0HYO3bHcdqdJNRI/ZDGp4Nw1VkjJ86XJFZ4yy1vnRyEx0/nH9UGkQTHzi2h
Q2sIKjdZHPC4RxLm3X/ZS+OHoNNZ1391JPpPeOox9hB8dtPx2BuPx09tYXpo
sKC1skf8UyL+v98zEryRLMgvDXTifUYS++/7D94YYEH4TLVz9QuSuO93/ZbP
oWGw3BQnaV1AEi+sxQdSoodh3aCnz+0SklASctgSz8L+Y/r3LdVyktBUCiJI
rRE4XeIPLrUkQc4d/tMTNwKDZHLq/WaSqIqM+s+TPQL2hHmxUgf+/YonCjLH
v0Nnx1YP268kobpj69ag5O+g+fImS4ROEnx9ZfHyS0ch+uK1lS8HSSKVclCV
OjsKn/9zb+0YJYm/Ma0OBSWjsPamsK4PhyQ6bxumD4uxQfVbheOraZLYcbSp
KQf7rS9Sq+I+oM9dF7SV8WSDp5Nx5RDaoEpr9VMvNrznojZsmsHj9dyMir7B
Bh3FubIbaLOQYm+fQDacClZdpztLEklWnBzj+2xwVch63TWH1+fyJm9FOhs2
eP2ic9D17rKhfhlsKK5R41vzlyR+a457zmWyYc6i3hrQzkfCQyey2RAYxORJ
RYvG+YQzC9gQ2SVh6ThPEpECUzxNZWxQ2fm/oGD0xZOOfLoVbPh8JedlIjp+
99WtNZVs2LTy0Ip2dF6LjH9ZDRueyltkqy6QxJJ/Kne8amKDtmdypxHaPGX6
jVIL9pvVrKX26PLpzvO5H9iwy+K62SN0zKeYn1n/saE59b1fIdpt0qdDtoMN
l8dXZrWgdXRF659/ZIPgQYNPg2hNMYfWnZ/ZkB8YtbCAjn3jMZzSyYb/A7MN
1Bs=
         "]]},
       Annotation[#, "Charting`Private`Tag$5468#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox[
       TagBox["t", HoldForm], TraditionalForm], 
      FormBox["x", TraditionalForm]},
    AxesOrigin->{0, 0.48776722317661453`},
    AxesStyle->Arrowheads[Automatic],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->200,
    LabelStyle->Directive[12],
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwc2nc8ld8fAHDJJi6Zd5v32i7utd0PIaUUilJpUMkqZYUmsjJCsrJJRka2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         "]]},
       Annotation[#, "Charting`Private`Tag$5566#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox[
       TagBox["t", HoldForm], TraditionalForm], 
      FormBox["y", TraditionalForm]},
    AxesOrigin->{0, 1.3077234717724089`},
    AxesStyle->Arrowheads[Automatic],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->200,
    LabelStyle->Directive[12],
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8052912414703827`*^9, {3.805291574849823*^9, 3.8052916476789007`*^9}, 
   3.8052926361556735`*^9, 3.8056284953484755`*^9, 3.8056286254908257`*^9, 
   3.8056401160161686`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"ace59df5-9c5b-4b73-bc8c-1e777ce81de8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwk2nc8Vf//AHAqQsaxUnKuq+xkFCrU+yUZWSUJhQiJSCgUFSFCpVKShlGK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         "]]},
       Annotation[#, "Charting`Private`Tag$5628#1"]& ]}, {}},
    Axes->{True, True},
    AxesLabel->{
      FormBox["x", TraditionalForm], 
      FormBox["y", TraditionalForm]},
    AxesOrigin->{0.4877672231892922, 1.3077234652170997`},
    AxesStyle->Arrowheads[Automatic],
    DisplayFunction->Identity,
    Epilog->{
      GrayLevel[0], Arrowheads -> 0.07, 
      ArrowBox[{{1., 17.99122807017544}, {3.586, 15.36}}], 
      RGBColor[1, 0, 0], 
      PointSize[0.05], 
      PointBox[{1., 17.99122807017544}], 
      RGBColor[1, 0.5, 0], 
      PointBox[{1., 7.991228070175438}]},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->200,
    LabelStyle->Directive[14],
    Method->{
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwU2nc8le8bB3B7HhxCVvY4zrHHQeu+ElIiW1IqSUQkI0RJRihKS8heGSXJ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         "]]},
       Annotation[#, "Charting`Private`Tag$5672#1"]& ]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->{True, True},
    AxesLabel->{
      FormBox[
       TagBox["t", HoldForm], TraditionalForm], 
      FormBox["x", TraditionalForm]},
    AxesOrigin->{0, 0.48776722317661453`},
    AxesStyle->Arrowheads[Automatic],
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->200,
    LabelStyle->Directive[12],
    Method->{
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{{{}, {}, 
      TagBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        Opacity[1.], LineBox[CompressedData["
1:eJwc2nc8ld8fAHDJJi6Zd5v32i7utd0PIaUUilJpUMkqZYUmsjJCsrJJRka2
aCAUhShFg0r5mimZ8Tv391e9X4/7POc553PO+ZzX85E+cdb2JDsbG9sDMTY2
1r8i1ddvv/kUaMw0eTL35B8NeNzjRDYVHmAe476s3j9Pg83wc9/LAlfmHsLn
TtcfNLhaLOpXURDAdD+zNLr8igZPZr8Ni72+zFSNLBIbfoqup33INgq+zsyX
qr0vWE2Dx5+LufIKIpjErzWllGQaOLEnNuxvjGbK9917/S2MButyQR48r2OZ
cyvjq7k+NHidVxn38Vc8s6coJ8niBA1INfITjOAEJtw5zl9hTQOv56mm8VxJ
zK3l4apNejRoebclYyL+NnP7/B1LY1l0/5UF64yCFGbAnbSyr3Ma8IDfrWhB
PY2Z/1982M0BDVjHf9q0pzGd2aQ6/Ke2RgOs1WwPFZndZarIKqXyJGnAXebz
6k2vM5lFVYKu4mc1wI9KCC9TyWZq0+b/HbPQACLtndaHX9lMXLLUxh4pDXiu
d+sLV10O8+22yOIDr9TBy9QqRis4l1mYYY/RdFIHcStO/WMmecx6teYh0S9q
0GL3ePwmVz6T7mn/zc9GDU4dvpjY8DKfWZ2+QTItVwXBk1owHl/A1P3teqV+
QQVqPaenROwLmUpaT9UPkFXAye9eKhN3j2nKjz3RoagMXFeOW3h8ucdsrBUz
eMevBA/Ccb9TCoqYpPXtpU2PqWAfP5jV7nafaRhy6laJMQXWU+J2zasXM+V1
tR3oIfJQmLNjmbhQzHSYTulMi5YF6+LNhVaNJcxgG1410yPS8Leq2TbgSikz
X6+i8TWGCJlN/hv5ZmVM5y5P7iA7KbBoo5X28T5g3pzVXyvrEYXp7skD668e
MEWGy5+TuzCQNFjAqZxUzqRsbZU5MssHxFn19yUqFUxXIX9Vv9eccP73TXXT
uAqm3cy7qSlhdni+OBE29KuCmadcdmhqYp2JXbMY8dpXydQRC95x/9gq04st
X5OzrpKZeqin/BXvMvMZx6bIdKkqpqMxXmsgZJEpzuv0mRZcxdx+svpFY8Rf
ptuWJnrnpypmWNuSzbWfC8wWYcmbTiYPmU7v31xUCFlgioj7jv3Je8ict9Qe
rtq2wDyF7deN5qpmbnscrxWPX2A2EtXjpM9UM+22jBttcCwwBWVvfq97Wc2M
44v77rz4h3mCMmFgrVbDTNE8Jk+Z+8OsVbZI+BZfw9xxviLw39QfJp9G3s/A
3zXM3tv+588iO2mzMYXta5mhhr/EYqb/MKt0j9y+V1/LfP9jfOnR7B8ml1Hj
pBGujqlpOb6QMf+H6WgiYTpwqY45JU3XmVn4w3xg7pPi9qWOqVJiFhyx/Idp
b61mfqegnil7ES+hv2mBadZPCgvANDDPPWevu8m5wNS0F24/GNTAbCvVt5/h
Re13+mOGt2lk8s4s7n4pssB87tlolrPWxAwaJpZUyS0w6TEWZiV2j5kRLdyB
7ZYLTL5T5Tmf2VqZcfPvxvJuLTB/5ndk/37QxUy5y8emp/CXmbBK+awv+ob5
POqKJp/FIhMj2n31Pu09s1o9US/Xc4mpqlDf9PzNZ+bdaSuTruZlprkwNcSS
/SvTbiOvOpxrlblNQHKB48g4sz0uOuxR0Bpzbt1fQ7Jognn3Y+j7r6v/mM3j
Zb+vNU4x0/evNT04v8Es+956LYd7juls0J/+NYYNovvTd5fd/sWMeEs3uHhk
E5g0KV/+hvvNlNWwNFyhscPR3C37t7f+YV6kZDerym6GLaEfzu63/ssc27Gu
+1aQA2RcljXiVhaZ5vh1pQdYThCCXvs/mctMDO/EY311LrgpnvCEg7LKjOao
aPc35gbvyYJe6F1jvkksIrz14YHxxnw56pF1ppJ0zrfSe7xwvC0w7i4nG9g0
a1JaePnBQHGj5dEQG6xf4U6RvSIAR/gvxlfe3QSPT8pPWC5ugYdTOLrhBXbo
V8pbLK4WAhur6qAM/c0wvBrGjHuCgeF7RT4i65vBjycjS79ZGFI3PwdiPwcc
y1L0z/0rAlkjQw827nDCJYvcddxOUXhfLTrn58UF/v3Sba0LYrARVfp1swk3
NP7auQ3bIwGen/QunuLkgRcx3E7LEVJQXzfi2MjDA8L/DG4rxEsB+60rhoIC
PDD2LlFszx0pSNnWvlEjwgNRbH/SbxVIwbOivTc4yTzwft8D3w9PpUD8wunE
fH0eaPQNvntmWQpauG+XjZ3lgZeao99WnLHAM6oTx7jAA3qDo3Xubliwa/xw
LsqPB85x77k1eA4LPz3I2pqXeEC5QlM66RIWRPpLGq9F8UA0T97upmQsnMp4
1kEu4IGPM10X7nVgQZA2N+r0gQeMdeiuNbI4sP6CxQZ+5IEdKmnXB6k4iIkz
t739hQecz3fcmVHFgcBM2rOX4zzwJUX3Hr8uDvhLzPN0f/PA68E86V9WOOCR
T3cREeAFhR+cQa7nccAuZfGj3YgXHjju9xFoxIFp5znSKPDCZN2N3VYtOLjm
n+6wto0XnD0rjEKe4YDt7VyH5k5ecG3Z7PvpBQ42EtKLsux5wZ4a/8R0GAdr
Ar/OXDzLC4Jedo4dKzhYZMuYUsnhBR37Pt8pbTyokeODdPN5IZZpR7DUxcMp
ZiifGYqjsp9nxu8a4GHgkgf1UBkvDKRYremY4qFqxdAlsoEXunWVxSl78ODx
5+Pw9z5euDU7KLp0Gg9jP0gvM9n5gFvou3H2bTxIcYs6FnPywX9lseJ7U/Cw
V4FnooaHDwQ76wiraXh47DLH1SPIB+3OBR9Ns/GQMfrEdBXLB7qyrti0Yjw4
DB9vdNDiA4eiec2zLXjofpV3H+PCB1vIWYFzY3hgS/gW53SaD5rb8jrNv+NB
e7+8X6kbH0xExZcn/0D3Gy40tfTmg6GyKW/lKTx4/rw/fOUyH8SeN5yQXsCD
IHvFltkUPjj5udHHiosAe+mPvHt6+MAlNefagDwBQpfWHHB9fOCo85ytgkKA
+iYj4zMDfEBXIu6IUCQA2fQxH+cwHxSdK7dXVyXAL+tneYY/+eA85cXuA9oE
SHDtHCxh5wctB9FavCkBBtMH9KJ0+GHX5V6N/EMEWNe+65elzw+L861rW44Q
gPrq5MNqI35QPGf6wteJAIFsiyqft/GDYUnMZeZx9LyTUmTtvfxwY2L5Q9Mp
AripOXF9cuUHr8mGnMPe6H5PfvTT0tD1yiuyTmEEoDhWCG2/yw8pAQcMbt1A
7/c7YNfhbH7QHvD/+iycAHnyfM9vFPJD9X6P39JRBLCMUmkYruKHoaIR/9ex
qP123llhL/nhhfWK2uQdAiiMr7i/X+OHrHf+Rob3CbBLFsNGYxOAQOvRU07F
BDh/TD4pYrMA+BcKHbxSQoCWD3se6fAJAMPQo6C5jAD2r/MFkiUEoICw20il
igDh9dZltpoCcNqoRXWgkQA/o3JnXp4WALujcNb5JQFK1Hd6t/QLwLHUVyPc
/xEg4G+s5MW0LbBm/vY6J4EItCb18zucBOHX3UPXZ3cQgXhlObNcUwi6t7VK
//Ujgt2Tes/JJSF4W/ba5UwmEZyu9oZ/Oo0Bs88cSh+eEyEia55m24cBO+nz
dReniGB/SaisQksYLl11cB/aQkLtfyLsmCkMFfNpzYYaJHjx12P7zCYRKDp5
KafBmgTdwtvtY5xF4OiHB3vl3EngWlpj7d8jAtMb1l1OESQo4iRJ7tLYCq6P
3X6q5pLg+if8S/f0rZADpxVTH5HAttbSIZlDFHhEOFY3BkjwfNfZ6pJTovB1
7s6q+38kGDihtMrfJwq5DO8WAhsZbuh8EXHQFoM9U9OV+bxk6I9WEp3OEoO4
0LiX5lvJIPo5dyaGVxx0W5qK+PBkWJkTS5PyEAe24ZW1LFkyBF4nqM+9FYcF
1b8ldGUyZPaTblfqS0BD8OHFahoZ6qX3DlzKkIA3Oi9do3TI4DEn+i+JSxJ2
joVpWxqRoe3SwN/kM5JQ/CX5lZQpGWqjqB++DkiC0b2uwMcWZLibXJxsYCwF
NafOpzXvJAP1OEXucrYUvJIo913cTYa9hZsdqblS4B2LceWwJsPFyc9x/XlS
4FeTZCOM/MI3ZVXhnhQISfPwKSN7RPG+eV0mBSfbKzBOyJUPJ69JN0mB4fJD
32fI+lwVn9sGpSA+4n5e6B4y7C7RTefnx8LBk/i6mb1kODd8IDhVAAvVHbSn
S8hJ/BePUASxMHy/ppXdhgwf3BtI24SxEGnIXyWOfEpFPz9QAgvQ9k/LGPlq
mUHZhCwWpPOv9UQjV5UbP+4wxELtR8FD0rZkEK82+xrihYXJgjg2hh0Z6Bld
s7xoX+npa9lkjLwv1HotzhuL1pWXq+bICfsOiGX4YEHt3qUP+5EFF9y3Vwdi
QdXWwdQXmYuRWPLtBhbE8q0fVSH/rRu9YJ6FhVtqA4ep+8ggln3q6stsLPxn
kB+ojqwdMXnTJhcLDdnHbzGQzx9YKDhSgIUan8L7ZsgzSzxDviVY4DhxKuwY
8riehmFhHRaGNDT+S0YebLrMwd2LBZfk8x7ryPML9w0f9GFhe+MBDc79ZMBo
DPrsf4MFa/X1SX7knfnK3/PeoudnRe6UQn5yc6gdPmLBIqc6Xwu59IhmeOB/
WPhjN9lzCvn6xnfeGQ4cbPtzeOk5craesOltLhxwXvOo6UZuvmAYaMiDg5XF
PW79yEs/Ev6L4sdBhs7tpo/Inr3MlxQRHJRvVl77jXwgJ/XmcRIO1n2F/hLt
yaC2bbfQoB4OwtnHe72QLVwfzR81wMHItmXdC8hOMcpv/zPEQcH8Rqo/cuw7
3rtsgAPFGxMWV5Fn3J8rqVjgQIPDYNct5LIkpkWILQ4q92/jrEJua3igKLgP
B+oWHWs1yCOfCFtS9+Mg1NFiugFZQHHtzYMDONg7otPwFNmjuf74Bycc3G1d
WOtFVhmnXaK54+AGdof2DLIZf86xRx448CU3NP1CPqyBMdvuhYMcNhXDBeSb
gTN8R7xxsN0IT11DnhIsSYnwR++roF3K64D6V0eu+nMIDu7UlJ2URVaOFJ+M
ycCBXzQlxwbZlE1lRS8TB3ZXHl/fh3zA34R3PAuH8jOtww7IoSc9KMZ5OLjQ
WvH3MPInk2fOM/dRnlAk+uI0cvyK54h1HQ5kS3gng5ALvUMmV+pxkH6taOdl
5OafKSuFKC/Zvq6SexX5v7etkhvNKK9wmtANQ972UGp/eRsOes4CZyzyX/f2
HqF+1N8j36UykQW+fhhpeoP664HcUhayrOPc5OlBHHyzsn2Vg7zXEsf3ZAjl
NYrBJwqQ78t5W5z7jIOXVKxSKfKT9Bv78aM4wIl+7ihDfiuS4dI5hgPtnXeO
lCOzb+q4Th7Hwbm3X89VIR/+iH/cO4WDNyr/GPXI5/dpvgqeQeOt4pHUgBz5
cvtH6hwOqhb6JxqRaxvOr179jYN3ClHBzchCyZ06NJQ3HX38wOQZssKWTxYf
V3FQ1jPp1IpsGPp7f+Q/1L/y8j5tyK7niT6jbHiw+RV74znyM2ufilvceIiv
s7Z6gfymosdNmhcPpMtS2JfI30Qo8pV8eKjnmxxlmevd+9TeLXjo35l/uAdZ
Qk9r3zEhPNT+vCn0CpmaflNwDoMHd+nLTSzvPMoMERLFg7Bu8Ppr5ENPU4yy
xPDgwhZ1uxfZQ3Z+UU0C5V26ufJ9yLE/8j2ssXioeflbox85a8e6wiccHm4J
q5WyXFHiMOpJQHlWug/5DXLfWT77GDIe5Gypf1ge63PGEGTwkOeabDeAPK/V
/KJUFg/bU0RKWd6cLB5mKI8HU/u7/1gWXTrL7FbAQ5uEjuUgsrxj1/IhKsrb
bL9Es8x4JFM9qYgHSmBqJ8vbicFeQcp4cON0Xmf5wNVBKr8qHtZcjVTfIp8Z
U/uapobyNqzifpYDzSLuKmngoS9GwY/l6MJRh0YaHvz1GPEsZ/AYiOzUwoNm
woE8lsvckrrfo7xXe0tsOcst3dM3zjDwUEZ6V83ya7XtJss6eOg11n7I8pf4
7NUIPTz0fC4oZvnX/HKNJMqLh/xV0llm3293rsgQD9LBnaEsb60rVdI1xsP7
44GnWZaT4vrewUTPyzTdxjI96GiWgwkejhdKS7Js8bH+4A+UVyfOSoyz3tee
KSLqb4aH1Rn5MpZP57i/4rLAw0upXZ4sB2xuj0jejgf69ygFliNOErcp7ED9
9XxsiNXfqR3+/2p24iFdc18oy8WKfXXmu9D9Mj9TWW6KVjo/uBsPTVfDnrPG
s3s6ROUkyuMFdlscYXmmkpETaosHxUCsHyseNrbGHxLdh4cD7WpLrPjB+E2I
5e/Hw+fXRy+wrKmfEdV6AA+PFqX2s+JtW8aCmZ0jHnw28ppY8bhv3Xpj7BAe
rNJ34Vj2e7bJh/0oOhe4rLaz4jtc7pBawjE8+AaxC7OccqP6p/QJFJ+rivu7
kRt3nj5ichIP9/lHOlnz519/t8VVdzTe+u+PdCDzTUep8Hii+bIv248138S5
d4jEe+FBN/J1RDuyhkH7xyxvNJ69p1NZ89Ulr9nnsT+aD31R7o+RvZuDHLdf
RPevvLunBfnyOz14HYj6pwenypr/d/hr+T9fwsP0jkMDrPXhxYUHuesheHhg
Of+mBvldjEfEjTA8LK2dCalmzed7Sl6C4XhoEdyr8pDV3uFCPWIUHlKHXd0q
WO0xy+o1ikfzGTN0pxg5WTR+PTgDD9mpHPV3kfPUrL9xZOLhG+nWejprPloK
vLiZhebf9gTjNOSu4IjbGbl4COL9U5yMvPbtqsqjIjzk2wE9DvlEjbfjajUa
7wd2mCvIZ1+rQ0gtHvYxD84EIwdPTMvz1+NBpfp9eyDybYLbL2wTHnRGdh33
Q+4MOxGh/xQPIzjunZ7IavZ2tRd78HCFT/brQWS9Z3UdMq/xAINV0qz9xEwN
//5lLx603DMPsPabQ1zfVwkDeKAtRZVbs+Kz1s/k2Qc8mCR2bNqGPCqe1s33
Ew/6D411lZCnrq9/fDiBh3cyHWsKyEszJ2YPT+LhyaGHDaz9TbBDWaR8Bg8b
1AY8AVnfv9nBDp3bPqtGhAshJ737MpbOToB7z/Pm5tF+mbXN/I8ZBwGGH+Ub
zCIXl9/nnOEkgF+g8JVJ5Cfh56nASwBPK43Zr8jTOhxe34QIwGtyy2eAlT+k
UJZVCAR4/2aPaDXy8gEvoRYdAuT+Win2RF4vF+/eqUcA1z+LdmeQObgfR7zT
J0B11em/LsiYGiH2X0YE6HqbTTmMrCBc+UfWjABxsyEGO5H3df1+H7mXAOeW
nBTlkSv0LubvP4POjYILpLcov6mNlz4+5obaS1lf7EV+9KOLcNaDAEJ5YV0v
kTtuY+9EnEW/1xU++BT506+myCZfAtwQlFcqRRYoXveSvk6AhbX4pKvIrthQ
vek0AuyI4oqRQ/Zo7ZdOzyDAY+d4MSLyOQ9pvh2ZBDirHposgRzQ0vIhPwf1
R0DJNT7kyBPLQYeLCNDXwflvFuWHxcVeLS9rCLBT3SaiAXlK/+C24l5koeA/
Fsjeh9R2n+ZC56hrw/pWKH8992j02BYeItwQc+TZxjLhts9DXiKcx+a90mf5
82r6hgARnrInmyux7Nz1352tRNiQ4fvIw7K7S0QnmQhKe69XtaF8+1xQWqui
ARGKXp1eYbCczqU/dZYIMT+qtnKh/Hxr2vvFQ/1EiDy2A66h88FeSZMscSMS
fF+I8XKwIgNtf57Eo2wS7BpTiljbjvKhzlRtxiYymB8yELAzQ/u5gkq/FoMM
vOlEtjkmioevBkOFp8nwOWXM2NeADIQvYnbMu2hdNl3dp47+7uzIDf2PfWSw
0laxTtZAz9f1jZpjl4aJL6Xd/5TQ/d+o7lHUlYZbj+ltIXJof3vlHPzujDRQ
/U/9FCOSIaxTQzw6TRpcFQ5Yekig/Iu9U87ltTSomgw+6hJC8Zk+kl7FJgMD
zi9oljwoH/BtCldgyMAuufiz5zdIkFgmMSLkKgPyT3ie3p8hQdR3vrvrKTIw
9FxU5fxHElgf6ewXeSUDXKluYeNdJHDR3uydsSEDNUF71vprSbDdiifUii4L
uw0n5HVySFBwPH8zm5ssHMyWyeaMJsH+d82TiumyIJc6o37GlwT9N3MsL/bK
QmTNeNDcYRLk5LALGrPLQfvgow2MOQkma1aYPFpyMEc+3pqnQgJ2vubxxdNy
sDzquv0nhgTuzWsLh1Pl4JrdqGzHAhFyKrgCf7ySg0d2Em0f3xLBNu+em/9m
eeg/rsfTV0uE/QvtrcHa8jBmFVOgeYcI8uEPbt07Iw9pSaK/6s8TYXuAaOf2
dHkwMQpZ3WZNBMZ9swtb+uRh6XqGcLIsEbLf80cPcSpAVe3J3uoFAhw+s5df
SkcBblGm3516ToDvukfZrngoQIlvyrGGmwR4cnryiGOmAixq/4gbtSZA4J+t
o4QsBZhM+aQ9spsAWtcMXUaRpWkCum93EaAwLcbNNUcBrq/83N+5kwDRPer+
fvkKYEv3fZ9vQQB7LZ/4hGIFePiG3cTYmACT62vPXtQqQFTpivuUCgHEkwWp
Bq8VYPgax/AGNwFeWfGZCPUqwPrdoyEVXAQI38Tl+BVZ3R8rcwytY0se/6Kj
+xVAK8Le8BFa9z5sm5odHlSAD7qBdaf/4SHrV1dd8IgCBMSdORQ1jwfq7rDt
LRMKkDBOIs4P40GPY+2UCQcFGs7E9H0sxoNXeep+bk4KdHJy2h+8j/YRRx2z
HuQDSwHX39zDA6byvPRBbgr8HZR62ZqPh59HJobP8VEgmrvqSyLap5Lr3u7N
xlCAMyVKae4WHv64Vepv4CkwM2M9GYH2WSXxPYrtBAps5YvkG/TFw7GnUxLR
RAqsXOwLI/mgvEaCuiBOpkDs+d9h5efwkNuWWa4mS4E8aa3jTWdQHk28Keek
SIFEXV2uqyiPeNB3SrCZToHt0j2EIiM8fC14l5DIQM/v3ZoVj/IyyUBLCTcd
Cuy+rvrED+Vt12WUyBJ6FFh7c63XgI4H+wvTNG9DCvjOtJcWqeBhXdRnv/w2
ChD6HzJ4UR6858C1jJi9FCg20ax9toDOeSrzZBcbClAqugb2o3NBI5tzgb4t
BboX++a+o3OD3H2zBz/sKBDh4cD7bxIHS8vcT0wcKFA7m4rhQueS7PTYrwtH
KCCuMSt0uQcHc5/SlZzcKbAR47n7XQ46Zwk9btPwoMDRpXMzfOicZs8cc9rs
SYEQub3v9NG57lEWNbHIiwLzBsdOxCXjIOJYzeq8NwWuPVqL5IvGAWnsVXd4
AAV0c+T3mF7AgfX3TWcrwyjgpLJjNBidc6+JyfOG3qDAw8OG9YpGOKg2t8yz
D0ftIze39aFzM7Yw9t1qBOp/owX7rVo4GD+FA4ubFGBsdbA6JI+Dyz+1hYcT
KBAW52y9gM7pZZOnH3JkU6BS5t63zd1YcBJWle1CHqQlV23vxIKgznxCTA4F
hJweYG+0YcHrevB58TwKWIjMxs0/woKa1C0atZACdorPxiPKsFBh0VhuVUoB
rzOe8TkxWKjOEShNqEfxZWZ3jLYDCy4dfTiHBgo4Xwm6XGWGBdHp5GhcIwU+
HsQ3qwAWfHWl3fObKJBEkDotoIMFxmu6Um0LBdTK6Ct+clioX3Mqet9GgVTh
bZTpf1LwyKEyn9xHgWN7jmutFEuBR+GO4gXku4ZH1rYUSAFuYbT8RT8F7NWt
kiSypCAwQaTJZ4ACcdRnY/yJUqDbc6Gv8x0FZuNHBvwCpeChKWP93CcK9KpZ
PDLbLgXFqk0OTycpoEP0b6YPSYJjsN2R5CkKnKKuK3zslQTel5Mn3KcpgFMQ
mPLvkgRXV7yX2Cyy0DNmeKMkKORdCj0zTwEPnq8i/BmSkCMJlcLLKN7+E9yV
clgSUja3853gosKgv93OY28koH37xncqNxVEnl2emnkhAfPRek9nkR2W7gp4
P5MAK9EH/pd4qVC7vP5wT6UErMvd+ZYiQIUhSU0jv1gJcLE40/JahArfQ68x
T1tIgHrklvNGJCrE/jRWXSwVh+eC9u8lddH9lcpXvx8Qg7kHpi+GkT3U7Oun
dosBbo96U6YeFWL+5jGmTcXgXBzPXTkDKhSOCHmPqKDrmKZjGsZUOKW/NBjI
hq4Lk39uN6PC3epxn9+FooAV/e+v314qPN1Il5+f3wpm1W9/6NlQ0Xrr3tPy
Yyuc3dc6tIZs1ndUJG5kK7QlZTRet0Pvt1Lx0+A5ui6253KsPRUuuWRg+lLR
dfFqzsLDVGgmT58wNEXXpS6LDrpSIZhH2r44TQRSxozSi85QwTTots/zOBF4
VvJPOtiNCmVHx47+CRUBceNL6rIeVLAI/6cfflYEWk4E7/Q+S4Xxgq0jieYi
IFAaeHWLHxV2qf1rTVkQBoavPvcocvpm6ut/k8JwzHglptqfCrSjTxUCx4Sh
uvdi+qGLVPD8l9rW8FoYDi0E1N4PpoLbvqeph0qEodjYf8o8hAovfgY9dDgt
DAPcOhekQqnQebLyqdVRYVjv/bs8hbzkfVnB0UEYbJ39uJNuUCHrfZTD8+3C
sBzuKzMWicYn3jf5k6IwyNjQ79dEUeFf6dX8ezLCsAu7oB4ZTYXPu+UTo3HC
kF3qY6QRQwU/6zDF/C3CYNl34cDleCpw0jKOSP7GwPk0rc82t6gg+SYtt34K
AxnOv0/KJ1BBy4DSdGEcA7ML5y90J1LRODbq6X/AQDL2fCz2DhV2Hukp5mrF
wHfnc221d6mwN/h1dmQqBm7K9JODM1F/PK8gEm9jQHtU65JJFhUezZVnd8Zj
4LrTIr07mwoBX8/qHo3AAPHg5XujeVQIT6tXigvAQLvEl8338tHzJ0t39Ppg
wOOtyTGPAnR/h9YTCt4YaLTjlFospAL1LvcvjBsGHKxvRgkUU6EgnmozfBgD
6wIz433ImSfaiU8OYqDw5Z5td0qoMJrlUVlvj4E/llvXpMuocPn415BvezEQ
vy3NU6eCCleOednJWGBAh32taw2ZkXWkPXsbBj49OaLwrJIKQbdFH9BMMKBi
LP1510PUXtMo3ShDDHTpFu09UUsFOi3bX1gbA+cWecsodVQg2F75SdTEgGSt
O+808tYJgp+RBgZOaak/82+gQnL6Q70yFQxsmY8nGjWi+SFeLrmuhIHqivlA
9iYq7ElqOnVUEQPsarVaMY+oEBH/ONdWAQP3pyTibZvRkWbEXf+bHAb2llyc
kmihAqauKClMFgOZVKOC3MdUsNxh/v0vGQPmPzI3uT6hApOccuM5CQNTBWxO
qk+pwGOrAQVEDBjItonXP6NC0t0jdnF4DIyNyl+41EqF3/ZJB9NwGIjKDn9t
2kaFnz+Gex9iMSjOJ5R52qlAXH8UNyyFgSGCVUQP8lkLT09h5Csjpd8SnlMh
bPWwyX5JDCikC5oc6KBC1O2VsUIJDPQcPHeX0EmFfu9xRS5kH8n+5TFk/YaQ
mfPiGMC907Iv6qJCS60977QYBp7dvl3l+QKNr+aYrQ/ymX2LglovUXwkYfJ5
kDFbD7ovITOzw97eF8VAXV9jR3M3FToWfrc6IDvF4+VCeqjwKk3EQgSZa8/l
q5avqJB7RF/n/VYMlG35MrLlNYrnl4fPlyLvWxB9/RW5w5cjJxJ5ZWTH04Ze
NF5ftoz7IGe3XX4Y14fWY+2bW72QLUofFpzsp8L+ebY11vWpxJ93DN6g+XJy
1pv1+8QgQpTwAFqf9oZYliDrO9sG/0BucZqw+4D8ZWe4V/MgFXQ+HXcVR+27
ofnoWOJb1J/iBx2PIqtgf9meeUeFhC6XjWrk/k0K5swhtB7W3FSVQO9/ccJR
R+w9Fdp3DzeGIZP74hQnkdUq+S6zof58Xt+Ge/oBjefeD9bhyCIRamyeI1Rw
mXkbUI/6v/6s87zpRyosOGuFnEDjddQh5ZvkJyqUlPX/k0DjWarA3tX2mQq4
XaIl+Wj8bQV1mtK+UGGx70hiEIqPpQX3snOjVHhMumt/BMWPefvgLfxXKpgH
1o0Aiq+pUr7QeeT82o8HTVH8JSQx/Tq/UaF1AOStUXx+cr7v6DNOhRpVd0Ko
DAYC2C/Jdk9QQehx3dJJClof/qsUy/2PCv7HCRa1VAy09Y1zB0yi+NL58EkI
zRfhnL1TstNUuFp05eInNJ+KmXI1QXNo/8n4T2Yczb+9lIP3bH6h8e2RTr6E
5ueiYGwqZZ4K2vHrZwkMDJh9Wrz05jcVpJe4pn31MPAx+KWF8iIVbtbYQThg
INSFTW/TEhXqb9MljppiQGkXXfkdsodNfLSxGQb8cFlCIStU4Ar/PrfVEsVj
4/mhD//Q+rbloZ44Wl9MF6XcojgU4cZYzelTx9H8H5ij2XIqgnD+XrVwZwxE
VnYsS3Epwnm8Q3DZSQz0uvtG3udWBA73BF8+tL4d/dJb1MmnCL/fLx/guICB
4K7wH1zCiqDHXZQyFYaB2vQFlxCCIhgnpBUyyzHwIaBbxYqoCLZB9z8vV2Lg
3/68PyIkRciWtGTWV6P3xdiE5pIV4ZLQdxuTRgy8CS3NeyqrCO26u36FtGNg
ztN5bENREfqiTIfbRjCA/nc0mKEIQTUPYvkEhWHnRUcj0FEE2uWuJhVhYfCo
+orl0FUET3YrDVtRYaiQ+zsYracIAf0hXwqxaL/kxe1KN1QEm86nf/0owmDa
76LbaKoIX3ZlE8tNhMHRZQmzZK0Ivgm/vT0ChCEqgvTswmlF4CfnTDTOCEPJ
f0F0S1dF2Mv7yOjXvDB07xoqwp9RhA3iy19Ki8KwRfhWXLubIgSSFQKLNoQh
PpX9iISXImh//ybYjRGB5OLvi40+iuDdEJhQoyUCOd0lquzXFeFV+/U08WAR
qMfopsZnKMLHvnWancRW0F3qGZJ5pQgOIsZ0wnFRCCOpxXzYrAR/169eC+IU
h90W8g/u6CrBaIl2QMM7CTjdnarz4owS9I9ZiSTGS8HljoQ7WW5KEPKZmFt7
RwqSn0Uv+rgrQcHuQ+mDmVJoPl6qI3kqAdaB6MNZJgVyBcd1fM8pwfuVuQtK
XVLw5ZKiDtlfCUr5iof92bDgqN7A8AtVAume/2oz3LBwXqkq2SpMCV6rNrZw
e2MhUr7kL/mGEuSIi//n7o/yX9zd2pfhSiBnVnqeFIoFCZ5rDOloJZBUKf9I
u4uFgS+WjO5bSiC23BKz3IMF64QhukyWEowEpSn0KeLg6/UL7hPIByINFmbU
cBBwQTCnIlsJWkIjezm1cZC7z0yAmasENqe/5BCNcbAgXjF2qEAJrMZ4PdZs
cJCRHh53uwS1V1/P9XQADv7LZ0zw1CvBM/I30r/HOLhyu4/Yi5xyQDbYoA0H
ojc89t1pUIKhpsSV8504MD6d+1i+CfVvR4RnTy8ObikKJpu2KEGN6Lb7GqM4
0H3w3TS4TQntiy/fV7PhIbwuKWO2Vwlu1uk8+KSPByzH2I+qPiUwKHn9Xt8Y
D6V71bX8+pXAPP6F8i0TPPRPdHWtvVGC8Ounj6tY4oGI3/jL+04JvFpj/yPs
x0P11TM2ch+VIFlJ9twfTzyM7jDmOjihBCIWXefvp+PBJznaBv+fEqSyvZNz
ROdhrq9DGZ+R+d/ac3Pl4EEl+ILWqSkl2KJw7uqeQjwEPCg6dmFWCRzNzXWK
K/AguHVrU8yCEkSqzdrcaMODwciPs882KYOE2CZnsQk8vLLhsUlmVwaHmUtX
3SfR+bmDqum2WRmuHtzKaJ7GQ2jVmT/CnMpwOVQ90Q6d97sjJgOO8yhDec4X
zd2reDhMn73GJqQMe4dG+4MFCBAc+zfRGK8Mbnn5bzAqBBDkkPAVISjD06sX
56dUCZB9Ucd+HFm7xHGoXZ0AbS4BkrEkZeAX3MB6aRFAwGAl46OMMjAvl7ik
6hMg48e/gmBFZYh1+rXlhCUBHgFnfSNDGcI6/pybO06AlyUdXld10O9LrmY5
OhPgg3iUvIWuMrD1dPc8cyHA8pRgYp+eMjTTJI1jThOAkSrp9dNQGTpI+GU+
TwJU/lKWE9+mDFll9aQH/gQozLWN996jDNOvDixURROgZovYdp29yiDXzK81
fhO1N+DdvzXk6M3CGxKxBPhqfdg9wlYZ6qw1bPzjCUBePWmRtV8ZuB3uWsjf
JkCa3cW17kPKMKGz7aZJJgHiOLJdqa7KsEmw8kZCOQEyU+g168gTN18nVVcQ
oFTl5abBM8qwJc/TbbCSAF37/qZdc1eGGrLrxa3VBNhcsKvng5cyjITPX7tW
TwB/82VajK8yPDc4IkB9SoCjN2xXf11XBs9Doj4P+wigzsMZ23RXGXQOVd7a
NUeAnfybyPv6leHnt7auTHki1HkGYk9sVgF2g5jHGrZE+CXUEnlbVwXqZvwS
xi4T4ZLwlePGbirATTTI31JIhLe2fA8EslVgZrOxP+0VEYoTVU5/GVCBd7dy
rof/JkKvVneEIpcqJGP0m/NESdC6lUFKMVCFcwFGOx8zSMBjRyAGe6pCwMmV
H8v7SNB5Kz3yZKYqOM52HpbzJsF+zLczPm9U4WjAw7MoMEB75n7VEoca4NZi
ze/dI8EXfv1zufpq8Np51KL7KQm4FY+n2ZxVg6PkU5Mz70lwtYBT1S9bDQxK
7W7iZ0nw/LiP9pNBNQisOLZqx04Gp0vH8q9wq0OM1eXaJn4yeKd8vWqmqw71
7T0XDomSwea3Rr+apzrElk79ECKQIaRsNTo2Ux02LnDxJcuR4fq9+MatA+rQ
eu1oK1aFDJf3flLaw6EBr2IH5z5okuHbWpXKa7wGXNYeeJ2qSwaNrqmfx3U0
wC6d+6uxMRnkzU8eVN+rgeL1etqyKRk2jZqGCrlrQLP3ux03tpMhbc395Pkw
DUjevvuXuxUZRjrerAhlakBcxRPxOGsyRKyKPApEtrAVK0xHpqvbXvqOPFV9
U6UIOTa5d6MxSwNU88aJT5FNTvZwnMrRgLdeh1LnkQvZOwQf5WuAOGHyu90e
MpwzapRxLdGA3ns1Y0J7ycD5MHvnk3oN8OCLTfS0QddHK/7KNmjAfEKwiT/y
iNDT3HDkfcfe/7jKqlfxGF2xbtSABvkvhCTkYwoyJR+bNODgZ031RuTG1Dz+
1RYN8Nfw/sFhSwavq4Xd9HYNuCLuUZWE/P5BbUAq8uQd87N3kc0+Ppf7h9zX
kSVXiIzT/xHc9lwDUk4MBdQhd/6mqNp1asBM75mO98gyp+/HnHupAZ6L4f/w
dmR4t7vUuqRPAzJyQvvuIpsW3+bc0q8BVUcdAgqQS7muPPJC5mVySZYhX31s
o6T5Bl0/t2LyCJlKW+RsGNCAYD4r+IAcKGra/PydBpzxYPshuo8MxOF3ymMf
NcAyxv5LKHKEztOxbZ80gONNaV40q74lsTi1ALnr4ezRBOSOXZe4z3zWgLz9
Rq1ZyOdaZL7OftEApTAueiPysxzPtH9fNWD5R2v7NPIp1828Uv9pgPGxsKw9
+8mw9+BbvhDknuKfbPbI+jvvC0wj217ndzyMLKiyB/N0UgNOXUz47YpcM5sm
cWZaA77O1rVeQ+bw11RomNMA/aNzQ5XIOWHHtx1c1IDCQweG+e3JEOWnbd6K
rMfxjS6M7HOae7vqkgbsXDaNEEe23FG2c9MyGh/tS6LSyHMCyzb3VzTAafz3
CzqycVL8seV/GpD7xrviCKt+JffxpVQOGnh8mzp+Dzk01tltDXmcTdarBFk1
kNvhKCcNfGKsLpQjX7bZoyHPRYP7M76udchkts9jFdw0iEwxWn+O7HJkfXsn
Hw2annENfWPVw+zI1Vbmp4H/VOaFn8g12hbSsciPT9J4ppC5BGJX7ARo0G+8
Hf8buaiRUPZ5Cw1Ebc3m2FjfAyWMRBYxNMilz2/Hsb7vbR5dPyhMA4qL2wUi
stFs6OQj5Mqn3+5Is+oZnne3XRehQdWmsZcU1vdV38P+gqI08D0s8EUL2ac/
aEReggYZNbENO5HxLaSuCOQLX1x8dyO332+tmUTukDJX2sv6fnyNP65SkgZt
5fJX9iPXq6ebGGFpkK3mO3gUefVmY+E+Ag1Uy2q0L7C+72+x/PQY2cXIq8oX
eVfMoJgykQavD7JTA1j1BzFzoZtINBC4/niF9f3VMFbB+QGZBtHpd41vsL5H
C1anSUnT4H2KaVAE8s1Yk/5Q5P/qOsqjkEdiD5sckqGBVKEPG+v7bnBcAolH
jgZy1mfgDnK+ENnhAvKSC8kwlfU9P64s9hMyXqtRnfX9GB/f+a9angY4yF5n
1d80x68PH6eg8acaGxQir99yS2lSosHbGBMN1vdqBZGl1wrKNNgYCS9mfc+2
TgjjTkC+LfgIX4ucmZDt56pCg5fOcz9Z9TTGiW/3ianRYGA0hcz6fn5qq8vN
q8iv9jg5sr6vxyb+ap1EbqWL33yC/ClRQOuZOg2OVh99x6qnuZJkKnyWRoPh
8DNbWN/zi0R7LT8giz3t5+pE7k06ctVcE7WPW2uJZfLtgFmcFg1qeYafseoB
LMW4KOHIej9lM1j1M+duJzrNI/ORT3my6gee3H7Q06lNA6evQ4us+oKfYoac
2nQamCfxVbLqZzDJXYZZyKY/dU6w6hOOJX8r8WUgt4WXsuoZIsTPf/2CXOxd
Ys6qd6hI3sDu0qHBtEDPW5bZ7mCjZHRp0OcgMMqql6CYX+uORtZy4T7Aqqew
/v1DcAEZHu/qYNk3x9rGSQ/F2+8RNVY9RsaemsQO5KSb9bEst/7DvdXQp4Gf
6Jdxlv8ruS6Zhqwvvk+HVe8h7DjhuNmABhV4sass6/LsveuBXFAl+5Tlo7W1
nweRf5y4usLyDReCDNOQBtvqlVX+X/8iEupShBxppGDP8sCT/wqFjWhw49K5
AJZXvWwmApF5NvMnsixDqFf+hvzxwN8Clne+JHrtNkbjzatVybL3xbCKWuSG
7Kf/r59JoUzNk5g0OFyUW8Hyk0FbeiRyVMnbfJZ/hDT4zyML051usSyoSW48
BDR48lrv//U79C831tqQXbjc7Fg+HDttrGbCirdZKsshhvuu3UFuO//iL+v9
iv9rbGUzRfHesvqI5b4UaS435NzekCCWlywiLN8gy9KdNVkmLcxEGW6jgZdf
2iirfy3y9vcUIO8lKUWy7GnzSEjIjAYpjSKKLCdtyNgGIG99s+/p/+ufDs29
3WmO+qPwxwfWePPyOUhVI3f46x1mWaO++RDBggaEX+ODrPi4LBr9ZRZZZdi+
ihVPBc9+yRzcTgNPE6wYy93nDpx8hpxpbnCOFX/YHvn/kixpoEFK+X+9l0nQ
TZV1ZLO5ATtW/Loq/vY6vQPFo713PCu+a8Oe/NbbSYPeDy/mWfPB1vjQv09W
NNANFTzMmk8Xp54yLXfRIKF1vzOrPiY7jXq9EpkznM2ZVR8z83eBK3Q3mt+3
rlux6mOiyuMxintoIH7R4ilrPlceWbRNQP6eURfNqocZ4ne6vYp8Syve+hFr
vXBVxr7ai/aPiovNrHq6VvJz2Qu2NNAuNwDW+lHU9W/vIPKQHeEHqx4v9jz9
so4dmp8PT4VXIju25Q+tIsfoaVY/QJ47HRITup8GzIS6liJkYjks3j5Ag5qX
A3dY6xnHgQC5JeSRv8cHWevdf2wVNo4HaeBsfEQgBbnGllRKdKTBpqasU0ms
9fjvv2P3DqH94fbR7pus/jBqelHvRAMbJbkjrPXYaXx+EXsUtWf5GY1VD2MW
pyR/CXne/O2GP2t9GE29YnIMje/8oQjWel8YGqD94jgNyltndrqx5s9Leuaw
C+qf9Ohke2R1xwrvdTcaWP/y2Mmqb0m60zfh6k4Dyz/RW1j708rA/PE3yBvX
uLtY9S1te+i2RR40uGMhrsiqb3E0b9S09aLBlofZMaz6llCNtt8F3jRY2DL8
k1XfMsQ15Ls7gAbV0raTD5GNzJan65DDSxYbWft17jXsKZmLNPCW5g1h7eee
a4ftF5HN873XcpHZ50cZOUE0EOw6mcSqd1X5OLn45zINdhXBQVZ9y7WHGxcz
wmhw6cYvPRJy/uSvkQ3kAyXpZ7HInbLfmM430PP/1GWKsepdkjo5lcJpkHjO
coKVr2T73LpVF4H2X6836kus+mC67P3+aBqwxX27/hp5vc5iiCcBzZ+26G0X
kWXmdA08kJePaBZdQLagKme+Rm5dsufyQo5NEXJJTqQBezmu/AQy8eLQrOxt
GtRduVtlhWyk78bNTKEBvWXwGh45+FEMwzeTBvZCldtY9SlZMgfz3yKXdhks
V7HyuQg5Ed0stP+0xxeVIvPsb5peQZZ8lPaHlf8lTv/Mv5pDg2vmOqY3WPUu
RLOtN/PRft387qEN8tDVldncYho4Tn+c/8qq9zY/fb+3FuU/uYa/FlC+O8TE
n9Cvo0HEdNe5aeRA/T5sPjL9FnHiG3KLusFN/3oa/PEltb1BtsQKnSU20uBq
fZRsJfLh2Vptj2YaHDE6GuGGHJrK9YS7De03Mk+n3qF8fWC64K1xH1pvF3UY
d9F5AG8hW/9jAs3nd5FvOdH5waqFc18ehyZoVnx81bGTDLLjCvmpBE34uqvl
4UF0fqmPSSwWYWhCg7Iz/u42MmjvP+meuVcT5PLnDeWZZDjY7fvF5YwmZCjc
z0rWR/mJ86SQcagmZH7NEzGgs/LD0oXUTE0YMdrtflMd9S+UxmnUacKqrJr2
Z0UyLCoIf3vfpwlBDlK3rGXR+vuoeqr5P01odhZeeYEnQ11/XoncZi2Q36cY
xS+O3pdnSS6ToAXrAyl4G0HU39NRtrYMLdgYvhFUz0WGz/PX9aVstKB/NXA/
eY0Eff7Ph064a4FZzuwO0/9I4FFqqfwjRAskzr699GqIBDNsGrqXM7XA7V68
MVs7CaQ47Zf31GkB7ZhoSUklCZQUR320+7XA8h/nqY50Eix31xWmT2mh87ue
mVUYCbzJPTeNOLVB74b6X5ezJHiduF11nqQNM2KBGSn2JHhby3Z9VFcbdDlc
8SeNSZB2kDPGzkYbJDrTPLPkSWCOP2s75K4NAw33NC7xkiA1VqL7Tqg27CFG
8sxPE+ENWZ7NLUsbNu1/cjAKnc9fal7+r6VBG1Kf7xb4VUYEjz9ikdb92hA9
XxHZFEOE34MiY3NT2kCOYrcIdSWC7Gnr2R5OOvBbj5sbbCOCcMBglSqRDpWc
Ad+7cUT4XvRUI1uXDnv+4E9xTxPgROTUid02dLi5q3z53iMCPI8M3rPFgw5P
F4Ol/K8R4I2e1Rx3GLqfUo1AlQkBEnLvfT+DTPze+D4PCGDLzzH8EjmceWs5
iUmA3pFH7XE36FAgoqXma0SA7itq6RIRdLj/e9RWVQ/dv13YghJNh1/V7I+D
NAhQbzOUbnGLDiaud45FEQlw98zJ7WF36fBa+IS+1hIeRk6VhM8if1nMCHn7
Fw9Yl18dBzPpUC1W8SBgAQ8pTpcs1bLoYNV0Iq9hHg9Jdrd3vMumw45Nom9V
p/EQZdRupZhPh7E00dcfR/HgJyy/t6eYDl0zqretX+ChRtA9XqeEDpvzlIJe
dOLhD39lbw5yF+Uhh3kHHry5jGz8SulwWYGxTG/Dg8fqPlvSAzoIB5lTuFvw
cOJ76D7vSjoMyx6Nd6nEg3XDtwNi9XS4sEt690oyHnZVroYEIBO9RKScb+Nh
x32R8mHkf452Z18k4sEsFThzG+jQHlBWmRSPB72LGZVqTXSoz720UyIKD3J6
+/gsW+hgWUgu7A/Gw2p9a1NgGx0+qv74IXQcD0sVH8Y/IvMcY5MyP4qHv0W/
hE3aUXuMtlwNOIKHuRSSK/dzOjT+2PHt/UE8jAcEiSZ10GF3tNGDG7Z46NfV
8ix7QYfxsJmwsG14KKrPJX7ppUOuW+8Emxwe5M3zkqz66KCp/fnZC2k85Pbl
8dUhD9aubEog4SHjv/y/Mf10cPxRkymJw0M8/t4rgwE0Pi9bn3KK4CHgasnl
O+/o8CfpEvnQBg4sLas/WX+iQ2jOWfrLdzhoH6je14i8Lx5jrTOIA9PjNS/k
P9Nhy66D4tn9ODAMrK1dQy5d+5t2ugcHGqX1scWjdIjbvFDX8wwHkphmY67v
dHhRpsaYK8XBz3ftmc2TdHA3zONwvIwDl4QsEmWKDquJn3cfDsLBl10Xs+OR
DYlnAh0DcDD0VCXXeZoOx04rHN55HgedJYkFvLN0WMzNObB4EgdFV46X7p+n
A03hn//lXTg4TfnXML1EB179fac3xHAwNvpW32GZDuzBPh4eIjhwyqhoeoLs
mB4uPSCIA3thl+bEFTpgTbadS+TGgcXqiyd6a3TIr8Gc7F3CgsLrlI6wDTqk
/z14Qu8DFsb9tAcJXAyontjz9FwKFsgqn+Eq8tvuWfbTSVg4NBpZOoZsZ/nE
3CEeC71Wn0PucTOgdefOLPkILDSRozRpvAwQ2H1yX4A/FuJffI4zE2DA8cDD
cpP7sKBPjN7pLsKAAW3vG6V8WPB5Q6/tQR7quJP9ghML5RFfpDW2MsC6Sgk/
yoYFud/05T/I1wOD1v/+lQKhzi/3LosxwJ/3y0jbmBR882ZwJkgyYIeZD2Gk
Xgpi2kcf1xMZUBaa0xDrJAWWQn5+siQGLFFWT+EOSAH7QT7VWORL0sJfM2yk
wG9KM82ZjNpTHb54yUwKnLaG+gjKMMDha82xWkUp0DiuoOgiz4B0emfPzC9J
GFhzSxBSYcAD5gJ+MUASYi02LAORYybe/F48JwmW8Ykb35Dfnf9hMukqCc2y
jzwaVRlQkPyQ4/4BSSjcuWX7SXUGtHDuiLyiIwn+KeWrjZoMEIzQ+nNzXgKw
2n9cTukx4G/sF9rPIxKQGHCQ6wXyzR9/rbr2SYBAc8s9VX0G8Bn+eXHXSgLW
zSP/+4NslfCRS1pPAkYdiOdCDBnwM+YY7tZWCSgKsgzKZjJA4mNYDem5ONBb
M259MGfAxX9iaW4y4rDX1rzF2ha9X/q/jV2PRaGzLcStAvmwZbyjYLUogM4z
cRE7Bmzi3kLrKRIFdTzz7CByRteFGLMEURAc1yUf3o9+P7o4JnNSFHouqlw/
c4ABNGcOzZ98orAzZ6tFqBMDepmf7wgd3ArPttrOf0ee+EF5rGi9FfRvxGdu
P4r6j5FRuWvbVlB037LId4wBT/n3+z5Q3Qo8dO6iW8cZ0N59pmeSfSt0dK7w
Zrkw4Fnr2+rMchF07hjtaXBDf+9YgmOKioDhIm+7rDsDOsLHDA7wiYDWOu1R
DPL8qbChcDYRkBG4XnzcgwGGmneqlKeFYYMiE87rxQBlnEpVTIcwNB49AQe9
GSD1+dS+uavCUHUqSqcV+elEnldcgDDc96xSUz3PAH688R3Lc8KQEsRO2HSB
AZGaB5J5jwmD353c5SIfBozN/rnQBcJAez1WteSPxr9HaocNtzBQ3/IVnwhg
wOzExNN0NmEgf9TM6UbuWJ813rSCAcHJ63HZFxnQHCmrQZjGwBSXrIdlEAOm
B9++vzOAgW9brJyrkIOM+C80vMLAsOgFR3wwA66QOh4sdGLghUyr5RwyfiS4
trkZA0XGzvIplxnQFHLPLrIIA9nm0Xj2K6j9BtN2l/IwcGfXw60eyBn6O0jR
mRi44biZHa4yYN2YfOt3Egac/fI+/biGxkuu6N3v6xhwvPRy0OY6Ax5nhuhV
XcaAbejv7ibkrPJ5emQgBiBhW1NcCAP+7Ru3vnoeA8QHX+/ohDHgYJSISKwz
BgbKRy6mIfPc7MzZfgwDUZWDh/4hK0pEHhU7goG/1R2k1hsMkLY68WzKHgOv
mkruWUcw4H3Pm5IbVhgIbc6PrETGS8aqf7TEgP7ju+6ikQy4cePFbQsLDBQ+
i1P/gDz7pfuIjQkGrnRdqDsZjdYDtcuyproYYLz0SO1E/vWliF2Zgfq3+2SQ
8k0GnEvLPSOvjYEDvQ7MX8hnT/0lWWug8ejfK70vhgEzffMSwWoYaHuzY3Md
cgP+4c9GFQxovDPoCI5F473Ae8pNEQPjQ9r3PyMTPUOaPlAwkPFBNdo0jgHj
9ccMDilggOcTaQ9PPAPyE/y33JTFQMtnSZo7coaXHa+hDAZ8RoW3vkLeePg/
ju48HKouDAB4C6KksW8zDCFL9mUw5DWMJYpEmy2Rrahk14ZCoiwRytJCilJI
EiUkIUvZSoVIyhIiytL33u/P3zPcufec92zPeefcxYgFKgn6h1Z3Jydif1jm
xcwXI0Hq8GL5b/S7L2t0UigksByZzdibhO37csaKRDIJVv2YOFGJFm1x8Lsq
SoLy0W9O4sn4/c/Pu5WKkMB3vB8i0DVnPe8R+TBSP99LfkV/4pjYSOTDJEw3
Dd+9rAUV7wt/5wqSwGSmrmF9Cl5PM3AlK3pxturuUXTSquYrxwRIUDxXFvcO
rec+kzjKTwLPP0W+Wqla0M6n0eCHFlvIt05Ht1zV5V2D7li8rraIPqp71DKf
D+t/OYPP+YoWONtYbNuFhhWXf79AWwWZ/iShf6+M75FK0wLjDdGcPbwkKFwd
VRGNLuCoOU3kpxxgPX3tB1pKt3TjBbTQmuBT29Ixfq4pvwtEt7Af2/8Abab2
2YvIfzm71pvBm6EFGsrttceI/BZOV6lAdFe/cNUZ9OR6B7b36LUW/1SvovM2
2I3Qr2J79Cz/V4124N7emIV+ff3x6mk0D69p4cpr2N9vPyKqhPfbwAcX3dBB
vo+lAtCnBHSOvkKryW1brkdrCKnZyGdqgWLV2uiNWB4/hBU04tG2G1syY9HX
RaUEJtEf2LglF9FdD9mM7LO0oPOo7psILG9Os+9H6tFT64u8+bE+GJ+brqlm
4/VLVN+WoIP977++hn509d5HRyES3F+b+HtNjhZQ52JdebF+B3OObzyONk3D
NQB6+xvtk+bXtUD5gaFbEMbLWVfRu6XolzO/XfZiPFX8WeoSv4Htl3OVhAnG
m7RMrcpvNE271c5AHOPh1LahG7ewPMSDOgoxntX4Vbi5crVA1rSTd0CKBB4F
PFtC0Ko/rFnFMf7fdndfscrTgpLc+6cey5LgjsoBi8XbOB6RQvx2Y/v6XG8c
7JGP3z86N9CpTAI+x025b9HSl+J5HFVJcOb82HL+HS1gkzAzOYftddeXwGK7
Ai04o9bHoksnQVzw3r5q9DMHvcgFPRK84NLj3FyoBZ8vm0zUbSHBZvpK91X3
sD1FyModYZBg9eULwkX3sf96vitdbCsJHjBzzrAXY3+77vN05z5sz70R946j
hdKTk9dh/0T2O/jhM1r2hH69qTMJorPkNR6VYH98yyn1HfZvTnOl31weYX1s
vvRTy4cE6+683v60XAvc03ePUMIxvn3ORUk90QIdanVgfiS2d1XDZ/Hod8sp
ztpR+PxPyhX3V2hB+rIdp+cFvJ/G25yslVg/E6p+rKkksB0717j9uRbYtStv
USokQZYyw+TLSy1YP7l/+1Qvln9ZhT7HO+x/XVf7XDPlBukA0/2H0JdA7NH8
Vm4Q0uiIeIOu3nCJtGc7jn8Px18ldmB7Pnp8XtyOG5rvUW1EurA/OO67reMA
N7jnRrkrvMf64dxg+eYUN2Rctrm0rQ/bwy2fwdlyblh1/Ed/4qgW8FboCMxp
8kBA/f7ti+g1Kbd9PXR5YES4+6n7GLanag7V3i080FJdm0of14LmnOTfzaY8
kM6Vafl1QgsG1m7Jer+XB1TuWpVrT2N9nqUap53iAaeB0kt981owk6L5sqSR
B55Ynd6iyEYDzwvpZ5778ILwRxvr1eI00LVsuJv6ig+0Ro4JOdBoMKK0eJRl
hwDo8v3OeLWDBl4iaeJX5YTgjni7urwNDeKiIx7mqAiBkEJhcxz6ifmdn7k4
H5s1PLC8YycN6kuPKBUxheDBkRaXj7Y0+Gf3va/CRQikm/Jkp3bT4PwmXqX8
dCEgRewuE3GiAYv8r0RndmH49rO83cebBoZ/zXP3fBKGrksnH/WgR7ZHy5kP
CUOdMiPd6BANJCT81TRGhSHnSNN+4cP4fV8en/0zLwz7fn76WedDg9nENVwG
fCLQPLGKi3yMBrf5Dr7NNReBB+OWWxuDaCA74798tEgEsuK5lTSDaVC4bmZN
4iMRiFPs4s5Bkzc25955KgJePs7vA0JokP9HKrDulQhIjh/zlAijwZUN5D3Z
fSKQMpYaFXyKBmF7Koq+rBeF0NH+GplzNFg90F0d4CYKm6ICE2PRTTntp428
RKGDyrl/Aj0RWKu61lcUlHbRlh5F0YA5dNEnIgjXI9XxNGYM3v/pMluxWFEw
T9UtdL1Ag1eeagss93G9ZHg5JSeRBinSq5SvT+L6q1fOjSWJBhwiYQaJM6Lg
F/hczRN9mXdLbui8KDQX/GhVTqbBpB3neZ0VZDgjYLj2+WUaKAjXuXhuIMO3
0fFTn65g/e07pZywmQxlqaaeIlk0sGAJLNM7gOtj5zLDE+gBj2BXu4Nk4JKV
Fv2M3hiSn+jpSQb3J6tarmfTQMtjNumULxn4P1apy12nwQKPAp93KBn8JTT+
0W7RYK/3xwsmiWRQL6Sm2t3F54vwoNo8JcNn/0tHHqOdDM6kNVUR6/1lM+EC
LM/jxXlQTYYvLb0LH9ELx4TzKS/JkDSV6uJ2jwY+ysdVb7WQYVprveLxB/i8
G316f/ST4cGLP7UJZTQgPSrlSl9FgY9iNiN/0bYsDVeqWSiw5sRdzoOPaaBR
H7RpiI0CTlr2djrlNFB1IEeIr6MAZ0Hl8MATGvziKlH15KWA5+XTHOpVNJCz
U6o030gBqgerVWctDcbN3lHigAKWdY7HDepoMN8ZvcWEQYEgibIrd9AiOrmn
l4wo0NLr3n/yJQ3mLq2OcDWlwAnrhmMyr2jAmzBuz7WdAj06Fy4HNdJg316P
hq/7KJDAyf1BuJ0Gn65zmjf5USDUTff7CXRh29pxMX8KuFW6zvehTdu7Go8G
UED7cJlA3lsaKJmlm2wIpsBAk/1OtQ4acJ6XqKKdpIDahbzmrd1Y/0I6/rrR
FOjg0Hse9okGgjpG+zdmUEB4jcetT99pID/OusGkkgIRv0KWzX7Q4IfRuLd9
FQXG+uL2lKJllkYeHnlGgeryYs4Lo3h9rSXOlGoKeHgv+2uP0+COyPWt7+oo
8OhNCjN5kgb856V2U99QYMflumGzORr4xby5wvWJAuclJOVKWbSBGezlXfKX
AmVPZd3Wi2vDdbMtJl1KYhDH6rvzOk0bInO+ND7fJwbmR4SWTG204bNAEn06
SgzXtyvt5Q5pA+3bhoAX98TgrYTWkfhIbVg3fLPhY7sYfPzQqs+SpQ3/In7t
5ZsTg0tG+dWPyrSh7raTqICQOMg2f10KadeGEJHu+7y64nC6w3eqelQbVhZv
ni3Zi47TSmew6EBkxda0BwHicNDNdaFLTAeU3aaHjyWJw8xoC3ceTQfKbq1z
elsgDt7J2V+ibXRA/tVbat1LcciseOo1dlgHPJp03pR+EoeQRIHcC+d0MC5i
c0qnxYEe05Whn6MD9+Y217KxUCFPqdNY/okO9HDxmuxeT4VWW/Hc9HYduKMZ
tLufnwqfM1qei47pQMZfr54wMSqkJlRe7GHRhfqUT0s/pKmgmbdBKF9cF1Z8
fBCxS5EKifT7u//q6ELtbsn1y+r492cuWETb6MJWhyiFPB0qRHx980fGRxdi
qq13qxlQQfDvdoeVUbqgvkr2X6cRFbwuigY4ZemC44Bf0qApFW4wtpm1lOsC
XfWJ3zMLKpzNq2oNbtcFG7Zrbt3bqZC8WFc3iM4bSasfRN+waX6y/a0ulG0q
FZ9EVy9/uCn1Thci88wes1tRYWnXfFBbhy4IkpbDdNCBa9Spsj26cPqTvkM6
2tMz/2j3Z134U6Jw0saaCpbyydxaY7rQNpTkdXcHFUTCDk2lo89whI+VoEea
jNqX0HS79x5V6EifmYSX47qQ/qLRtI3If3lgR7L7qQu+cS8KZ9GyNKEN/tO6
sOFz5DoDGyqwGGdyFs/rQkCNG7UZ/fZywBj/H11IlSx/2IHO+bqtOQQ9+C2a
/glNj16+YPhXF5Y6srQn0H6NzuvaF3RhW9aTng07qdBvLbl2clkXfvCLPdyB
rnK8vUaJlQ7hn8LqW9GxH/dMX0KzuakxutG77Nd+mkKXDVSXfUZP7vEpfsRG
B/FOj9hxtKStuqM+Ox1+U8Z61xL5LlufF1uuo4ObCUOWOP/FltbteIibDu0e
L70eoiXKYszeoNNbw1aWE+fDaOiqK/PQYbxGJOkZOlotk/0X+rUTX1YTukLR
tSSUjw5S4ywuX9FUqZ/ssYJ0EDhulUz8XniMtKY0n0KH0+ny9wLR2lI3vvOI
0eHiEZ/PJ9BnafriJ9EP3x9aE4mmOB2P3SFOhyC2LLiE3l7Qt/8vlQ6yJSNW
t9EPmeXrLaXokJeQ/aUTHRjq5fFTng57n3Z93LyLCjXxLJl7FegwnfiUTQ29
4Xr221q0wrkjsjQin+RVp37aZjrIqJruNES/52PwGSrR4UlhvYkdWq9I5EWS
Kh20sy7mhqFXDjWJaGnT4dvrcyY1RP7KNI2ejl7ptShF5LcIrLhlv4i+4uOy
+JrYLyOfuFajQwfdG/Mp7eg9tpvFrOh08Ev18u8nfs9dFyfhuYUOpsl1n4nz
W56+nTdsQgfPOFgS+S31/W4HlAzooHp7tHg1kd+xqHdzBq23OO69Fs2uOS4V
bkiHRsPLUYJEPkLuNtkMYzo4b+w6rII+VPLEbAltv2aDN5HfEvhC2ms/kw7f
ZU32axH5I5+W7siY0KFa/CFNj8hf4b+vUGJKh8NPopNMif3MKC7l5q10sD2X
N0+c/yJ6OdRK2QLvt2D5HJHfInNj+EgS+sQPB84DRL7Ks2cP9ljSwfe0Igtx
Poznb1+1r9vo0PJQIeco+rl7q+ayNR22FKyMjSDyAzikr3vtoMMRvbmOs8T+
aEEoZyf6tVSdYDSxXzspPVhgQweq+fDZC2i+sBMJe23pELbaYSmZyC+hvF2o
Q/McI68hzjeQq97koWJHB+m35ezE/u4W1nf6a3bRYaQy+hexH+x5SW60dDcd
Vu+56HETPa16ehd1Dx0yzm5RIc6POdnR8eICeqVh6ySR75IkfCbtwF46HHx8
eS9x/kLVzS4myZ4O+VXPXxPnM5iZbH4Yhu69cHYHsV/9diSc/A2tHKXUTuTH
jCgq/qpyoIPnNo1yIh+Gpzwy55ATHQzMBaWJ/fBr+96v60bnXeU/TOyXb1pS
CmI40yGybOkusZ+ux/iwTXg/HeqT40kviHgYUn5yFs04qUUj8mF2RJ+TmkQ7
nmyyI/bj3ZtVFupdsL1uqAwl9usnfaPc1Q7QobVBKJzYzw/j/tieSXjY9TSx
35+wKzrf35UOO7Jfub5GP+3/ZCd5kA7npTubiHwBk0j1F/FoOdlHiUQ+QZv0
+c1/0MMKMVZEvsGwt8bqNnc6fDzLUULkIxxdH+tL98D2tfLJHiJfYaGo730e
+nmz42/CpNnYByc96TCYfV6YyH/IuNIv+h0d3cKdTVhaVyva1gvrIyORTORP
PPh4Yfo5Ov8KRxJh3dMDjgredNDZG/qPcJ0E7XUq+r3fkBuRf2FVF6ex6hDG
Q7BZDeEP7l+yfdC+i3mCRD6HG4f2uvfokOQVBwlPvHcPZxymg+IjqTuEg+6m
zBWgabKXvhJeEVbnw+9DB81gECHySWItfg2eQter6JgS5iNL7htBx3wKOUw4
c8y6bYcvHUTWro4lLFN12uQpWpTRmU34Qfz9SqkjWD7cU/cI6zp9UruI/rZq
9//5MLVKnHfm0BM31vx/nozlP11xl6N06D+x+v/zZLpavVIa0Q5ki3TC+3PS
1mkco8M/zr4zhL8ffRWeifb68Hw/YT/D33NsflhepAltwovc0r5H0et1vTkI
R33ZOfQefXZQ4y3xvBtKIvYZHcf2mbY9mXBa5MO2QnTP4GNLwpK2/SYC/nT4
tePYMlG+hVIbqk6jFXzD8glrzuqrf0dL1nVtJWyWelW8MoAOLywig4n6euve
mCIdiPV5uXM1YXvan3WX0A3MsGii/n17ds27BNHBcm1tEJEPM59/zrcJfZjs
PkTET0RI6ZBGMLbvbCdzwikiPO1rQuhQNbljkYhHsVEwPYZ+XbltK+H8p0eq
PqBf/cpJIOK30uHNnXuhOP5ds2L7P74VF8UFw+iwk7NQk8gHa12STz2DXux3
cSTyY75kxUTsPEGHuNLeFCKf7PCRx/OV6OwHOXlE+5k1GPaVOUmHPZwvioj2
xT5gZP8Hzf+Jv4A430lp4z/17NPYfiopJkQ+W/kvxbvsZ7C/iG8SJvLdDOsc
qH7o4ZKer0T7tz1YwckMx/Y8x+PxFB16O+Drjwg6mGvwcxH9R73CWKpWFB1y
zJ9P3EFzzY3OpaFtjDUOEvkvu2pG9yygs75xdhL917c9oyLV0XRYV/sjh+jv
2KN+ZJmfx/52rdv3a2jz/pE8hzg6zNfl6RPnbyUVjKx5jpb1j9pK5L98CBzx
lIinA5d2mzWRX+i9fkR+GL02/aY5kY8Yq/vt/pFLGK+LtmMn0c2Xv5ZFJNGB
VUvv9yGifez/KvgVHWc/nu6FdlD4GmyajPG+cgONGB/GXgzpcl7G+jyc60iM
H+t/Dj5LSaHD1C85hz3o7eZf6vPTcH5SMSpGnAfTvvS5qyWLDg+OSDzjJeLT
sSFCJxvjpafJgkS0h6qHSrfQvu9a2jmJ/u/E2aiQHIzn+P56VqL/WZTTkrqB
5X3A0G4Ox9vtf/1TQnLpkJziufo9uvH3WlupQhyvJ2LzU9FJu2b+XUQzxrUY
Seh9ZZ8K/qAH07Z2xKO/BzxY3XqPDu5NdwfOotln7UpCiuhw/bj9dT/ifJhf
OTytxTgfiBgqtUTX/tRqD3lCh8ebmpQXiPPxtk55fEKninup/Ua33SpYhgqM
T5kApSn0x73UzexP6UD/0sPzDf27liM6tRLb34n3ccT5d/JpH/VKntNBqIPH
JB+dABH5Yy/pUJKwqm072inxzWnnt3T4Yly6KwbnY0PCLhIv0O260u/D0V43
Zmok39HhjaaDXRjav0SUbRi9KZhC90Wf7/SKO9xJh829s093okuF2dJDevB5
zhglU9Brb2wpTv5Mh5qQkxmFOL8sKy4aevUD47/wJbkc57NPWze3q47S4eoL
EbcidPXYnaqr6EO/1G4R+eCNMrdSj4zRgdfwPleKDbE+STMTnMD5YFpv3DE0
W2R4ofsUzh96vJTk0Lt27vRnncfnvSnMkYzz79lfv1cbseoB36Wdajtwfv9p
6ET3PEUP1rlb6Bduo0LBrMfBF9p60K5x0sZ5KxVoUVl3OHfqQcyN+dhiE2zP
9bw3kg7pQd8RKPzCwPmszIStQpQeVA5eaLTbQgULrTWVy1l6kHs8fGMJrnd+
Hzz3aeiJHqhfcK8x1MDy5bd6tK1DDx78PGV2UokKR/x3G06N6YGslpX8U1kq
ePyqi769Rh/W+jaW8UpifEgei0ij6sPW5z+VQkVxvG7zVOfU0YeezJXlt/jw
frNeZiXt1If3hzUV3nJSIZ3s8mznYX3IMTmmJclKBZ8Kl7RN0fpwE3YlVc+L
w7/ue7KnruuDl3Vkyv1hcdDN1fbZUKEPM4eEVdg7xcE+SfZwSYc+NAh5z618
IQ7SyrvFk8b1YZOnt3/gPXG4Z9Ee84t1C3gNZbCFpYuDaMyDQg/qFghfefNF
T4Q4qPm3nBXQ2QLfdDLZmw+Lg8qZHYI9O7dAyRPtgx07xWF0HXU/2XcLOBUe
8FHE9a+VqaLj1agtICf9w01eQhzSb2TzKV7fAmwyPzlesIhD3D3rM3+ebAH3
iJi50RExcO9xz+vpwOsV3Hbd/FoMliIaInR/boGd6X1fVPLFQP+TJ2/3GgN4
YmcomhgtBm67fZ2iJA3gakRUboeLGGiEFzsepRtAQFV00SxdDF7IM3g/7TSA
5lWH2zp4xUBzRivSwdcADs+yXRIfooCNj/dtgWgDMJrVtc4upoAd2+qowesG
sNp9dfnbAAoIiH8TUa/E6/1pTLZVoYD23XXGKejBll4/XWUK7NVU8ZlD/7nN
lyKuRIFrFiHPn1YZgISxZPY3BQpsDF7nZvzcAFpKne/7bqKASrvyPbsaAyA1
6LXvFqMADoMGwQ0GoDlIyrm4jgJnvnG4VXUYQPzIcoDFIBkk1gj1bOo0gEr2
iLiPA2SokZGxTEL/7jD0PNxPBlZ3hoZHlwFEH6r1iPlEhtihUBbuHgN4MXfR
+mE3GS4PjN5y6zWAujVDf+uayJDf++brui8GcO6Cb/hQMRnMF3r3BqIzOV3l
tj4kww+RH2/60cPevVb3i8iguI+t7NGgAZz5JMzlV0iG4p4tUc5fDYB+lMz+
LZcMlZ1FMiUjBnCZHnrnbBoZ2loTPfb9NAA5wZLx0BNkUPlxtL4K7a4WxNYY
SoYEFmtpiUkDmFjOOy0YQgZrHa7Bb2gu8YSYewFkaL0R6xQwbQAHYgPuvPQl
Q0tApF3CLJaXadiTm/vJ8EY0wKh+wQCkJ95YrzIiw2Yt2xtyi1g/p6q+CBqS
Ic5afWU8umgxxl/BgAyW56ae7VwyAB2V0fOWdDI0T/joDiwbQJWBvWigOhmG
95cILa8AuGb2rdh1Ixm+qhduEGYBMDC50BW/kgx8e2LqzNEccz5GHv9EwfiE
W0go+ogSi+WWJVG4UUce7EVnFoeIf50Xhf128WVZrADe78r38k+KwsdAX0ep
NQDm4336i59E4e0TlQLltQAxfaMfah6LwqrPnPv3ow+HZHwzeSQKqqu+8yWi
H6WV/X5VLAoJW6+fmkav2m/F9uKeKGzv5bZ5tA6Acixtx8WbovB6cXpedz1A
aWpkYsJFUag2eERss4JWW1kn+wFRUFZikwhDXx/q0P/iJApZ5N0LRcQ23lyx
xmN7UTj5Z75ImBuASZa7u9NOFHRL9ITH0Y+El0rszEShVKZuNJkX4Pe8XleA
oijkr3+XMCAA0NqZuuvzLxEQXNx4SEAQ4LHbLjOBSRGI+uHPtECv220cYjYm
AgdfCfwtRZfqmXpdHRIByfB9rjFCACEJTKW/HSJwbWZAU1kEQHivC39CqQhc
6p38cIICUKbT+u+Zrwg4md6Vv4+2z+dI8fcWgc0lrqF96IiDH+9udBeBxtgu
YYYYQKJJqLSvowiw6FbuWSMO8IMWMF1sIQLBadFdiVSAWzyyfpMyIlg/Ym/z
NgL0FRkMfegWBqUX3RI96BNsEJX3VhiWNice45DC62UcGfd6IwwZLCzch9Hn
3DJaumuEoaPku5WqNID+h2jV7feEwZzn0ZunMni/fNFr0s4Ig1qrxes2OYAp
/nhfNaowAGvoFjZ5gJyhnnNWwsJgRc8voaMprLW39vMIw+HbLFl56LrA6LtO
LMKQe7rK74QCQL0spejVNyEQUlEmyyoCCIrF1+gVCsFSAs+R0yoAFd97Lmgq
CAHnKxgqRU8FZP4ukhQCkSXfvT/Q9dHGJmQRIdDyajKyUwWwelLj3sguBEcN
zwopqAEEXn4WGfZVEL5Mzb7oUgdgaGt9krsmCA027/mUaADHS2/su7ksAFps
R/85o+s6gH/FrADcesL2IxGdWr4cZD0qAKepGs9n0Y9XXvJu7sa/n7joVaWN
7eEZ/xO1BwJw87zxM0tdgFpn3pnXTgJwqrrI45A+gNigvsX3En5QV4qqyDcC
aNlrHJFkxgc5wefvvke7v9jtZqTPB1y1cRlrjQGO9q1Qn1Xlg5HdyaGH0Y46
hssOonxwLTxHV4WJ9UfqNTSd4AW2zoqKxyYAzyIydXsu80JP2M+KenMA0e33
ks5/4wFm/fTdObTk/lherk88UEz6nSG7FcuDRcws+y0PxOUuhsaiOW+mqn2v
4gHDVg76dguAy286sqRSeOCupNTTTksArr8sExEmPHDy9Z6nQ1YAKj4LKR/L
uEH+c1ubsDXAW4lrsh/ucUPXtNnwdvR85oH2yVvcoELW4X6Cdhk0V/BO5oYh
X2GP+B0AH/RF/yUe4wZLvg88Wjvx+v96JzvUuOGPrI3sIfS7qmdrAxW4IU+/
UT8H/cXSUkVNihtWeFR4rrUF2C51rGqBnxtKn2Q8+4wOOMll0/GXBGRne+/o
XQAF/mzuV16T4PXxd6cr0Qr3roWP1JIgMMYiZQp9X9hGxfYZCdoe0qvtdwP0
FmoNhZaQ4CwLWUBlD0BahET8qmwSqApfVjiIvqCUrSOdQYLPipyGGejZn7Ln
XVJIoL178RDLXoAzZ1+ckIkjweidjy960GmRar6fQkmQ9sy2e/0+AHaj9J8N
gSQwftc8xkBfk25safYjQdZipeA9NOvtm9PkQySwscr0CbcH4OWLu/XegQT/
XPkjy9CZpi5zEXtJUBgcnzaKfn+zUtZoFwnYbpystXMAuD0h7LjGmgQVM47C
8o4AGV3WLunGJKiP2nLLHq1W9OsClUGCt0LiyvHoZzrVOhUGeL96/caT6Hfc
v45K0Ukw31LdKuEEcPNl5Y0ZbRKwuFzftxO9gfV7fpcWlu+5A0fL0LTh5IhW
NRLIChotfENz861Y/qpCAo07G6OEnQH8SIOZ65VJsO3N0NUTaNu2yoxLCiQ4
xe/xirEfwOKoVuVeaRLE3ja18UfzGnTFz2wkQaqO7Kdc9CQ0SWdLkqDI8fs0
uwt+fi9hQZJKgsqfr0/qoj3IeYMLYiRoCL/LfhjdxuAdHqSQoD/3kFgrWklP
NqFflARjNMs7Kw4ALLg8HZwRwed7vVlDDb3uy0y+IJrFYf1zV7TfjR1lZsIk
4J4YN09Bd8hXf4kWIoHYmZaOenRJggprpyAJ5HmKnOfROu05M8porVuXfsi5
Auz/3BSTJkAChtbRAHu03Z4n6Vzo7Q3WK+LR37qP/EvkJ8G+faoXnqF7nssl
SaLdx7gFJtE+87/lq/lIcPzUdI6EG8YTcN/0Rp8hvVPYiba9+fCdBDruRknZ
WfT3MydTv/JifGlcNixDBz0ffPkIfavev/kbOiLpoF4S+sEeu93CB7G9Xzzf
EYqu/KH5ZSt6pdFpryPohhMCPifQtbIi3YQ7uebm7qHvaqr/CUN/yemO6EO/
bysvSEZPqJWv53YHOH/Wv6mMON+lLi2NgT7YcF2TuB+23SEb/dGPrp14JYb3
y/N97/1c9LY5fydXtFiYrk43OuP0z55itPx60Tp2D4CaXUn867E8aNkL23XR
s7mrfx1DG6t+fH8IveXcNusBtHVtpVsmOmXEdb09lq/nt5OhKzyxP+Y12+RD
nIcT4sSqhlYm9RmzYv2FrzNIcEVbFF42vo3OUF6RV49+dvvIUXas/7wX/Srz
aGuNM/tfoYt3vngq5wVg3MT69BLGT1NQRHsc+rIXD10P40uoozu8Bh2yXvmm
Osafm4qi2jz6aPHfRE0i/2SkO8nVG69vnxq8R4IEm/cp2uoeAjD7RXsgIEOC
4LIIlqPoX8riKU6bSFDH01Oai466f+F3kSwJHJoi+LkPAzi55JX6YnuJ0+vp
+oZOW+nUsUeVBD1pitEUHwD1RJrdd2x/UrMRtJ3oAa8OjwgNrN97imnP0Cs0
2zvf0EgwLha5N8UX42nVoen6LRiPK5U+Mo5i+a0Mjd68HcvDMTIuGL3evJip
i/3H8JMevfvoRyf7eKxssL36RWYKH8P6Y98UE4/9zf3BHqdJ9GlqbIG9Mwk2
1EcOZB7H+YKJacBm7M/aYt8PzwdifQ6sv654DfuLU1evKQYBHMhuVZ3IIoHH
MUebA+iLCSN5JddJsLx7oKoJbal6m2fbbSwv6e+Xs4IBRoaoreXFJDj/fJ5h
HAqQPjIdfqgR29eMYPalkwAsgncDWZZIUOK4a7fMWQC2O/Gnyn24wanlTMRu
dBGfi6c2ji/sBgX3YtCslcM7nvrj59QVLKNoMJGiNIZxw9rBOw+KzgHoGhsf
WhfLDS6eSxw60dieV/RViN7mhg3Hb1VaxAL8kflz+/AgNxyKmZY4lgCwQ1DP
9oUbD+yqTfTLQ6sNcF7a7cUDsKxS24t+tZlhOOXDAwL+R9xMEvH7K4pJykE8
UO08lieaBKAK8yc7zuPntGGF+mScT0nerXtVhJ9/fa8pegXbU+GJv/uW8XOj
F+YvM3H85OEWvprHC6l2RU1adwF+hsq/El3HDzObavO9ynB+kdOtfSVLAExi
OQZzawEmYvk/TIYJgZKEvXk3et/GrSLTEUIgWF5YxF4H8DCJZcv0eSEY+Wp1
4hCa9Wzr94krQnDBMJVf9SXAsVtO/d0lQtA2L2lWWY/z2SDVrD2jQrDXQ+/e
29cYX8ljWal7hIGxHM/L0ggw+I56ZoezMMin9IVoomOcWFk53IVhsSbCJA2d
Oh9U4nNcGLLEXvc5NgF0L0o+XndRGL502vF8b8b+eVfAjgs43zxsfCToXyuO
jx7PY2RkReByruZqzTacLy9Vq39QEoEqtsWL3ui4rwNJ0ZoiwPU6Jq8Tnf/Y
UKGVIQJF2250FrQDuHX6L2zA+fH0rk71Pe8ACs9zFG1NwPmxF33yQRfAor1P
pPmUCOQ0rjwxjM7Jr70sNCcCrxUa1pC7AaSNRd72LYqAyISteDS6wZWtbBe7
KDz1893u2APwNfaU/1cxUVgOu17I8QHnL9d/pkRsFYVzF9d4HfgEEO3cVnL3
qigURun+TUUXWu6ec8kRhY5TPhea0K5DzwO5c0VB6si7exqfATy7dmjtvS8K
dVbZ02x9uP54sk44rloUVnPTThT0A1wxkqNFDopCeLL7pZlB7M9+533tw/Vb
/oV0qtwQzscMWRPyN+F6NLL5oSPaZ+mcrrcCGaj+ah316OBd10p61MhQbbss
lP4VoLFQSc0V14//+FNv6H/D+V+o8R0tRzKcTHv5KOoH9rcHN72nJJCBhcul
8jH6QEE/ZTgJ15uRizUjaJuOftc7KWTI8FVv2zoKQMpjEZS4SoYy4+s/uMYA
pFyOk7pwvTw5eUL8yjiWRwAfm1MFGdzMNc7fnsT7KbC12Ijr+dFnrZd60LGN
tY8cvpDBT+NQKscUQHNLMS1piAzh4jduHkL3VivfnBohQ9bshmfK0zh/M7Vb
ETlFhu7ro9OPfwFUBinM/F5Jga1/bzg0/Mb4yvLL20elALduScwSesUaH7Vt
khToCaktVZvD+Ha9YK4nRQH3P4OcmeiMnZ16JFkKRMxLVR2bx/Ed+pQSlClQ
8TuPIvoX5yMfdpfN6VNA/tfdzz5LuD5WPXg2cw8FptSerr2JFvsyEqy6jwLl
fk1aPeh3S7azNfYUMJkevchYBnCgn8/57ESBA1ObDQT/AYxGdIb8caNAxs/7
2dUrDCH8U0NXzVEKrB0r3s/LYghqkuu630RRQOWOwiom+ja3ny17DAV2ud+6
GYj22Hdpm+F5CtzsTxl+j74qP1hz/wIF9DqDD+ewGsLjx6bSwQkUOPJsS7Di
GkOgNe/laUinQEdC4yXTtYaQLLnwxr+AAlmaX56FkQxBp2Hth9tNFGCpaj33
EB1+g4+rqJkC3sZVlt/QC6u+2z56QwGtnWkfbLgN4UNCqdTzVgq0Ht3+W47H
EEp3ZJIa3lFgRWGFYg+vIWjub9v8sBefVzL5moagIUy99Qr/+YMCMhuMQ8cp
htCn94IvfI0YxOU3JVAVDOHVK2aeqa4YvEr3W3mMZggWCj41ngfFYFbEsrXR
2BByDz0+vpwgBvO/jOcMdxiCtGPO0p7HYvA+zjU01NEQHn7b67WhVwzuPyrd
V+ltCCfrQ0v6/onBbi3pFNEgQ3C21fKKoorDL5OGzWfP4vWvx5dIMsTBVzBR
/H6iIbiwVL8+6CIOzwxCDs9mGoKjx5v+9SfFYeV8soBJgSGcphVfOJ4uDkLs
LSKlj/H+n/YfO1MsDlw9iqGDtYYwELuj48lrcZijVWuR2/H/r37mCR4Qh0c/
j23z+2QIB2qc7pj/Fgd32q4X7T8MwTjpS/NjViqMdu29tH3OEBSbt36Z5KKC
lVZkedxqBvj2q/C5ClIhT7pvSweJAb8v1/l8FafC28P7xHUoDDhSLHBQfxMV
pozYHW/L498v6kVeUqLCzw+9s100BpjrftUR06TCi9ctIxuNGfDghJ1XkS4V
os1mtEN3MLC8a05JAhUkxHUGxx0ZUNSt9+O+MRUyHt0ckfRmgEZKxbNcMyqw
fQQLlyAGnC3ZXe9hSYV/b9QrktCdC4LP/dHzz2Xk6tCvFDY+CEf/uMm5ZlMw
A46VkcOuolsO9dSMoVfduFfagk5dOKIbHMqAowptZerbqCAjmi136SQDzvu6
LRDvOzLdt7SmKpIBiR/H87ysqHBG4OC1abSS+N5bAejyt80qsmcZcPjHl7Rw
tLzFtb3J6GgOOw8i34VLj17gdY4BW6depTegOygh2wWiGRCaHWcnbU0Fl4GZ
y0diGeCpW6LYgw7zHJOQTGRA+PnI8xttqFD6tPrpLnSCYbaMog3xPpkUuwto
Dra9T4nz0x0e6Z+fQe8IvdNkjt6y6tJkfRIDSM5t0UfQK66pPj90mQEZ9176
PiF+j9oa6PDoCgMm+98smOykQqWkxe/v6N9xY/FW6JkA8QSxNAZkjVYJ7kEf
JDfURqM7bcJ4vNAmXsIK+9IZ8K3e71YsmmN15Z/lDAb0aA7pNqMvaq28YpbF
gKUH1lrmtliea7bkhaCLz9lvsUZXdYc+uouuPWpgsJs4fz545h1nNgPeZuO6
Fm3x9BupHZ36N+L+GeL3vdASu/c6A2y9hxzL0BHmV09532JA0pH97sTvhUVE
euKvohVyE2IlifyTH3yZzeix7Lu3ZdH9Fy4+VcrF7/ub2ayBNmgJn59Gl39O
eGGJXrTx9Au7jeW3ibwnDB3goOked5cBT0T30t+hLeeGM16gtyhp/+xBSyWl
tf5G827vyPiMfvtqQdulAMtD1uT9d7SKes06rUKMv2MSv/4R+TUcVg/77jGg
5KzBVfldVDjw2HNR7SEDVti4vghB69qIqHqipz7x+p5Cc483HcxEz5JSeCKJ
9x1IKreuKWbA8b51RnFoysXZ6x/RzcYfDbOI35O7RZhGlTLA6mDi42q0Fc+1
pPePGWCZkxr9Dx0lX6a3rpwBDowzU6uI/VZG27Ae+q7eXls2tPxxFnoOWky7
l2U9mqXj8KD7E7yeviK3CLoiRV9jpoIB64VCutXQU/d2f5Z+yoAW1sttmmjZ
+mMxu9FWxnk12sT+7+/cjxXosofFiVuI/IPdXOfCKxkwByG95sT+u3BfJ9cz
BjS+2ixG5Ks4qv45DeiHofN5LujL5rzyfmgP+1pZN/TKUNNTnej+4D2CxH7l
xw9FMteeY30Nx+X4Efuj184Eyb1gQF7mWVciX+V1aYaEPXqhN+QEsR+64k1p
Uxz6SlLAReJ8Fp+lEfFJtD49IpPYTzVz2tFQVsOAZL0lD+K8gWVxSWHjOgYM
cfffv4H2X/VwJAQ9W3437BZ6dMigvAit83kbEPu5PXccd4u+ZMCnGfGHxP5v
sXp6yjR6c/xqVSIfRVZA9qBsPfYP+29UEuclZM+XaTihh2zFgMhHiavqePca
zfqrSInYT3Y3JfFcf8WA9C1b7xL7zR/lsge60Dq7vswQ+Sk7OZUecjYwQFjN
gUbko0C7hXUwWjRm7iaxn11W8kH8PvqfvEgLkZ+imOr1cxCdO0idJPJTROyj
L1q9ZsCzbx9FiXyUBH0Bp3PoKftkaWK/fA01V/Ep+hBNZROxnz4zVNMs08iA
0gBxHiIfpdV3ee0yWnnrUNT/+/U74j+oNzFATv2z1f/7+erku17oIzK1JGK/
/+68jnkn2vWkdSiRj0LtbRBa18yAdxx/JYl8gStVu0cAzTOdUEv4bERAdCE6
YtP5MSLf4K8by+4vaP/MUX8iH+GYabKM0Btsn9X6s4RH5CR/b0M/lD7jQ+Qv
OHE+fBmJfra/5BPhjgmDlCdoA7YeJpH/YNHe4vYTnXp3IpdwTYmjhnQLA6S+
zP3/viPt1LHV9mhzw5ltRH7F/eCwdwloD4ehlP/ff2S/9mY9+tOrhk7C1/TT
/RZbiPZxYz2Rv8FDlWWotTJgz8BRfcIxqx5ze6LFyjUPEv43xBzIRFerTP3/
vqHAVx0P3qGz+25eIzx2x/UMRxvW597thYQPxE1bGaBTVaf+zz957xsuHoA+
thT3v613kH7eRa/bIVlAuF49+1k/ur76YQZhPQGliwLtDFg9QI8gXDJf6WiJ
ljR54UJYvtdCMQJ97ixDh3BO1YfFx+gLKtXshAVoXe1jaMX9tu3E88Y9aM+T
eMuAvvUqSYRXyb8J24XeUL/T4v/3G91ssL6AluevXiTKc4JcJ12NzowOyCPs
lvr87wy6+46/GWHr82W3nN4xYKeyTQBRX/WrikOS0ccKVFcQ1jtxb3sDei2H
YyRR37JHbs2rdjDg/uV0PyI+skay37ij+WsKPhPxw3fg6o2r6OLedUaEV9gl
WbJ24vjS9niGiMfAlngJXfSfuywMwmOm53/7ojN9r0cT8dujeyanB329qHmB
yD/ZXhoWsL4L24+CgzzhOsWgrQz04Yv6O4h8lAdU35kCdBzrfDSRjyKT4fW6
Hx0j9PYK0X6u8R7M4u9mwMUNK3KI9hXD5mB2Gr3y9t50Ih9l/5j5NZse7N89
uVWI9tt1kHksGl0ak7aKyEex7AOTSnR8dNAbIh9F+y1tUvo9A6zFDCyJ/oFU
Lm38B82euWqCeJ9RlKqEsNIHBixn7fr/fUaLd8kTB9AioWzc/+e/ZfKmNaPX
PwnjJ/qn6siVY9m9DHhj0lhD9F9aS4vVHeiR5bWiRP5KYeB8CsdHBjyOLThE
9HdpXj8NjqOfiHD9JvrHo1afkk0+MYDB4VFE5PNJiD6hj3/G8TC6u5TID/zN
TYkS62NAr5h4+XkiH4U9vM0KvXp/YymRTxj42+xgMfr0qW0ZkcTn7T0Xg/oZ
QAvjFiDeXxcYMz+w8gsDxkd/tHkS5XHaYbM6+kBmprc78X2B1YFu6L1HKpZc
if93jVn3Cr2fR4NEjC8SBkKacYP4/TfVhon3GzXP0mIEvmL8HX68ywB9fezq
W1P040y9aCLfMnDwHzkE7XFQ7aEO8f/trx72opt3HZv6P1+zcHdvzjDWD8ls
oyzxuWuQksIIA0z2llgS570EtpV1GIwyQMvI5kkPjr8XEi8ZB6C3XTFtJN5P
lGPjWXoX7f4l5R3xfsHGDuHL/GMMqNM0aG1Ai78/sXMUvbmi3bucOK9lgPE2
dQLH03BHdSL/ReRXS+v4FAO6LLauJ/JXlEtvG2ycZsCMqpG8KfF+woAzRXvQ
Om03DRho3znVS7Vo5/VZO7WJfJeFy9vTfzFA8HgkVYp43yGL/RvjWRwPNUK2
/8X5ynP+b41X5xlw6c3W5Ry0hq3sgzfoi2VWcVfR+UleKf/Q33bX8KYS+S0b
xpxd/zBgjfE01wX0AY6pGfm/DAgxji7zR7Mt/RWrWGCA9N/3jSZEvvAQ1/Ge
ZQbE9tSsHcb53MdiLVF+ViMQPMG3SEJbxwyxmqBLnFg5iXzoOsekyUB0qeZT
/tXoQvaJlz3ojSuCBGZxvnnCKffoNTYjsHtBe9ODFl3LV7+R3Qj0GjeSstH7
XKaOqq0zgpDsjnEZdM+GwnorbiP4eoNLRArnw3FFLV1n0XVLzK8iaLCaGn6C
ZvllcIcbffui1hopHiOQMT4p+m8H1u/6F6bz6F25snfeo/nWdTXk8BnBq6ir
XvFoa7YVTVOCeH2Lh+E/cT7/anFna7KYEUxJ+0pm4fz/gqGo2qy8ET6/GvtH
XH8wBPinnbWNINLuQtwRc7y/uxrr45hGcIo9P/smEz+/cjyic4cRdNnLeJcZ
4vyB96utrLMRHP/W/5BDnwrt3wLC0w4ZQZZB3LSZNhW+hG3maAwygtOD8VZG
6lQYzuafYDlnBHwB6W2eilR4Jiqm6JhoBFtd3dITcb0Wu2nv62dZRnBSeUDs
HRXr+9eT6oECI0hVrBd4LYzjhYAuj2S5EXC4Fpzr4cHxr3Gs+tBLIzBvbd02
shbjp/PZ67ftRvCggPFKdDWuD4/WKhv1GcHC29hZ/xlxeN40Puk/ZgSqFwtP
bfwiDoWnaJx180YQNpsXZtAmDnEvSs6S2YzBeU/ymtmn4mDoYLU7iccY9Dew
PpPJF4fOMtK512LG8PB1+dJwsjg4XGchrd1sDAYfRgXnT4jD40HBWQ9tY7h9
ZL1Ntrs4sJU50lqZxpD3dnjnjm3ioG72umPOxhh8z4+5WKmLg6aabbO+szEs
jnrxTgqLg3wht0T8YWPYG01dFFkSg18nJ1r/BBvDU0qOWFe/GFzdMPV+0zlj
2Fynv/FxrRhoqcoYOicZQ2m1Y/SuG2KQdzd0VWmWMag2n1w0CxcDjtKVEjyF
xiDdN+u2yl4MDPnz0+PLjcGbqWAcrUGs//19GuuM4aD4qzsF68TA5ZtfFumt
MQxye+r//UABg8kEOf/PxiAnW3DBLJ8CpPMD3AOjxrAp537dSy8KHD/ws5F/
DMune6t8lScFuuhLkVvRpBmW0RIPClydEPpdgp49YhKafZACMrbWH6LGsfwW
5B/7ulBAT/z5jc0/jeHG/Y+DY3so4PnomnrwNH6/+oMYF1MKVA/sttvwxxis
77vOTklQIEK7JRLQ748aHX9DpYDxJePiY+jK29uweijQoKe6oQPdIHJrkz2F
Am1X1r5O+2sM8XHeIY+FKDCwrUpPctEYYicH95ltoMCqCkkpzX/GsO8YR2vN
AhmYSePT+1iZMB949n1bOxlMSnpMEtBzvboLO9rIYNZRm/ESnX8/tKG9hQyW
AhkMFTYmLDfxOb5pIoNthkkS6xomCI41qJW+JIPrjWzVB+xMmP3ImbjlCRnC
i3ccZeVkgo/YO3PNbDJEvNOr00Vz5l3dHZ1JhrMzm4SOom1Tb9V0XyVDjNby
8w9oaw7N3ONpZEiouLvhwXom7F84se1KIhmya1YX7dvAhBV8zGsXIslQ9fbR
eBEP/r3/VxsedzKIHeN4PIB2l3a+udWNDGc2OJ7h5WXCgC9DKfwAGRiWLLxB
6OBX8d9GnMhQ/9JGewsfE94J2Kbc2E2GtvKfEc38TFiv1C1WaUaGwSw5oe9C
THj/0rHpqBwZjPVPDogIM2EkI0fZexMZ8nrb7lqiu0LOHnCRJoOnULD+A7S+
EZ+0uQQZxhLrDwSJMGGl+9WHS0Jk+H3W9R4rmQmT0ey759aQgeNQJkNSnAn9
6RGNXEOi4J3jyL0TLdw2XPRyQBQaOyn9kWg1V41fIX2iEAdZJ7+iZfN5wj98
EAUugezyfCoTdK+81QhrFwW+FzlKypJMUBSdTNN6JgpigrdE9KSZ8G1Zzfdo
iiictnT7fhhtddWZ+jpJFPrDpcoz0WIVcFYsQRTH41t2/9D3qjjMn8eKglRN
bkKNDBNS/14Q7jktCnI+t9nMZZmgPJ1AcfESBY3au9N2Cky408h9JUdHFDpq
+oZj0cpN9he3aIlCQA1f73O0zFX/tG41USh7capWbjMTxHf8rvyrIAra1TaX
l9AFgcnSLGKioFf1VzNXiQk8ruRx4ZWiYPR4a8iMKhMcRRYrVtSKwFDZaR85
NSZc2RHlMvpMBM6Wlbo4ob2SYm62VohA3SOxrQ3o4aL9dWeLRcCkdFrkmjqW
h+bF6ezrIrD1YUalkSYT7G1q8uNPiYBNwY9/SdpMcGYEPP2khpaN8apDl7+y
N9FUQudKv5tFn+GsST8nJwI7svfn7dFhQv0vswMkqghYJ3dZiuky4cCpkF/N
nCJgFVaTfofOhIf0V6mdQ8JgaZGhXr2FCd7kIumqi+gGWuYUOnMwKY77PJrZ
ybbRgAmmXFx9DpHCYGFA+nAOnal5ZU1PkDBsVY86YwH4+bhyodN+YTAT9XvT
ZciE5KtTDtnKwsAcNfcYN8bybzJvPV0vBGfVHH5LMrF9jR3pXnomBHUhvuf2
oDPNer/7PhYCY/bkm7Voqe13BuXyhYAh/bEv3YQJ2QKNmivPC8EWZ989JmZM
kKvRjpQxEwLtd0nm2RZMiEqpff7tqSAEi+T2dKDDvHoO3CkWhMcujz3WWjLh
dMFLP4c7gqA12XsuAM3vpfAmNVUQNNdL11hsY4KqIF3F4aggqJk+1p3fjvG3
zndYXkIQFJ72KuywYULPYN+scLAAeKfvqz6HPjk2nm3mIwB3g97bVqD/9d2v
9T4gALIa3Sc37mSCidaOP+ctBUDq3tvWWbQnVU9VmyoA5OzXxzPs8Pm9j0qF
vOQHrsjHTwf3MOGwJX8iDwc/bHPRshbaywRW7f3vSEt8EGfwaMgSPabFvsAx
xQdrF4vXl6HVj910mujhA7aA+84x+5iwY8etC+fz+eCfe+5qRQcmMAvK1ZxN
+WBya7JFoDMTolce6AmJ4oWLeaF2t9FTQ8KjHmG8oLjqgHMPOpeRZel4lBe8
n6gc192P5fWq4ozzPl4Y3NSSsYxmzRZiNivxQhcLx4+oA0y4vdtvOeM9D/jv
n/z1GD29T+KPfCsP8FZ2L42gPxl93txQxwPWx/O4LVzxeZsEchQe8MDrASOd
DW5MaObbZpgTzQOVz07FXDnIhJDPRoExOjywT8Q9qQE98fKaKa8KD/wJ2Hbt
D1pu/9DOBzI8oKVIfmDvzoTtnUwZST4eKLr6pFvcgwnHwwNKR39yw43gGZl8
TybsrNLyNivgBujoVXmPjrDbUs5zkxv6lGt113ox4bmX0I3pDG4gf0vcfhi9
9X77l1+x3JBqpxyo4s2ENlpt9b9D3HBezftl+SHs3xxEvu9U4wbPPfUz4+iC
diGzX/LcYHJKUmrjYex/js2+ubeRG1Y1foiIRzeHuh725+eGUBcLOOCD48GU
hKvZXxLsib595Ao6eN7b58UvEmjdW53djN4voHXLbpwEv+afLmn5MuGDxma/
1n4SHE7Y/HTdESbYTFznWPOaBFvLYn4AuthxgHVPLQlkPw4JB6KD3WYKa6tI
8HVTZnA/ukDxeeqPYhI4PV+v9egoExKPc5QfzyKB3levgz/QU0tX51PTSSCy
rv6y+DEsz5y5yXeXSdC969Sv8+jR6qDjGRdIYD0x8cDJjwnbnL8ctgslgRKf
RX8yuvvMJzFGIAk4dW9veI0+IZ0Opn4keH3O2Vf9OMZLWB0lw5sEDEqbArs/
xmd8GrujAwmoRpvt9dFFXs9J7HtJsOwZE+uHdtdyYmu0I0FFKXz/iL67UD6R
aEUCdcuHeQ8DmHCT9euSgjEJePzWdw2jg5801sUYkmDyihcrOZAJDSMynX+3
kKBwUMItCr0Qce8vRZcEsRynkp+izXZ43GyhkcBT+UPNJPr+PrmqZE0SSIUl
SdgHYf3GVnvtUyXBqusT1glo+vNXl+yVSdBfv/XMS3Rq++ptRxVJkMmzuk85
mAlcpXtK3smR4IS2M9dBdNdPtkkJWRLsc3qqn4H2Ybv9I0KGBAJ3j19jCcHr
LfgwTmwkge02bUMttLtsSpaCJAkSJxe/eqDlbIdTf1CxPGlRyk1o7Y83i1LF
sL4/bO1YRPtu7wuJpJAg+uSGEKVQJkhqHdA4TZxXU5dWk4j2kSG33xAhAXg4
etSiTwR1OjUKk+DkWknOWbTQ20saK9AV94YfyIQxcf32V9ZYiATz1gV2e9C9
8bU8qUR+0MyRv+fRax98bJgVIMHxKxrZT9ExpXOSrugHun+MxtF7j32a/8RP
golPVSNiJ5iw6eEuSXf05vCIeGv0wYEHQQt8JPCSMlWLQNtP97dnovNeresu
QbNVDHJsQw95t4V9RTeur5lnR0typVAFT+J46WsS3M5LAueHe1+aoS+xlR3I
Q1+zFfMORR8Q3p0Ujf4w94WrEH2sOXWAeB+T0NXbJZ/Qs+bNCsR5NXZbDu/Z
cIoJ8OyK5XF00oDKEqA9R9LEz6Lbzs5e90Nfrn15JgfNJVthcgvNePzPsgFt
0XRqtBOtrGvpsoCO8TVKWHMa+4fF4gwdvN96bnZNHXTh1eauCDTLo+b33ujS
H4u/utCGexJPXUOP5D9q08TyObVgt7EFTaUGWGSjK7NEGv6hK9ZGGPFi+f41
7DusegbnD+EVaYlo2teb3K7o6W//5EWwfooVFO3r0YNBD6LNsf4mW6b+zaFV
+Zz5JtGKfmW35MKZkJBT4pKD9Z1fbjARh3ZILnhJESXBsD1L8jO0zsLV6z/Q
G/810CbRxUbtr6oxnrKYNuE7I5jwgo9yJgbj7+OIgMw5dPm+1b0h4iQQjutt
LENf4j9G8sd4vfzWjU8kEuv3m1hmBMZzrHPQ7X708fbvDqybSNCwSs+S5yzW
B6Xnli62D9a8FVNGaI68xbkgbD9nxs7r3kbv0jFwXruZBEEh1974nGMCy/q1
mRewPc4Md165ic53nl2gqJPAz3bDgfdoV9P9U+Ua2D8qR/w2jsL5JvcVNXZt
Ehz46iFOjsbyGe+T4zAggeUO9WONMRjPjqNqp7dj//TsMH3FeZzvLq0jXbIm
gcnmPFYttA377X+5Nlhfa4QzrqPZHn6tHdmF7aFquSY4lglVl9gLnzuTQEKu
kW9THPavhzUSbhD5kKmr+xzQAdI9CSIBJCCz6N9JQnO4/jyVFoTtv69Ifxlt
3Z0+nHsC23dKintnPPb37i7/cXTn8VB9UQDAW5HE2JeZYchS9rJG6ViHmWGE
iBZLSIVSktAm0ULJUpElWdqEEEJIhLJFobJGlKXQIhG/835/fj+mN++9e+59
9/bO3AMrI0jwe4lrybmrprB196WfDUkkeN01s7M/xhRipNN0RRtJYN6TrCQc
awraVR3Wci0kqBkwnrNAH3eMLdFpI0HF6NXEAjTXoq3D/i6Mj3mF9+FxGH81
oZyLQyS4Sdthr3Id++fsN8a3BRK4e5VYByWYQoXx2qxCLX5YmAk0FbqN3++7
qnRlDj98OBFxyRS9K3qVe/ljfiiai28JQCs0n5k79oQffBfzHd+jT7hXf58q
x+cpx4RPShp6Nq+bp5EfqoRdr69LN4WW5Z1ezaP8EKphMbI5C+O7fZXfaUUB
4DgkftEj2xRGO98L5OULgExZ0o9E9MnW2P7QYgEw4KTtaUXPVWWDY7kABKTK
a+g/MoVE7xMVpJcCMNyi0UPKwfmVZ3LfA5x/1KpbbSjPNYW+77KMqKWCEDYd
+l6gAON3HXOVmJ0gLA0YX1/1FJ8XjMjewhVC0Pq2V1b3JY63faU60yeE4dSP
30F+bTh/VQiZqCGLgtQdQ9XCPlxfOndJac/j/JJxPOcz2vu9xVbycnGwmc5W
Fe3H543vnx//VolDuJGYWhD6QKTo2zJRcfj26ZsaDJjCHRg8JKohDuVrkzY0
fsLxUu/qRoP94uCU+Vtz6DOun8J0S5vaxMHfUvmJ8LApGAxv7zd6Lw5Xfrlq
0dFVH7l9CvrEodq0SesB+l3bpZDwcXFYP5yufXgE5y+qvDXTKyXgj/w23fkv
pnA4v3GkQ0cC4u891Bcax/GobWveoRsS8E3CfsACnTfaIJKfLAHmUUsiTqPn
8zPUJtIlYN5ve9soui+aj2GZJwFu+otezydMIcyt9HNBvQSoN9tc9/2O8+/p
YX6BPxLw6sfsZP20KTT92dfYa43rL8+M6wvoqTUnZuTtyXCyy2qz5g9TaFg9
veC5kwzqz9IjUtGXdBmpzR5kuBFuKRnwE9evb4+Jbw4ig7t4GnPtb5xfs33P
RKeRYcHAPOvkLJ4PQ9584ygZHMydt+WjvTqm/Dy+kSFvW8D8MNqglUPu2jQZ
3NwzbKz/4njUBYZtf8lQd3HJosycKfRWeZPnuXF9/rbEoX4e12vL7pJ+4fr4
a0/Lsn/o4kfOVoUquN4eGX604Z8pxDvUxnpvoMDPWaEVt9DZ10Mc63Up4Cjl
l+ezgPOPowVvVegUkDmwfpXgEjPYy6e+9Cmu14OPQiEdfa1rj+oaXN+/DXFw
DkHD+aOLTvspEH71/JPPaMbh30WDhygwVjjgWrLUDPKM9dMehFCgcDGhdPdy
M/j3gO+ZaDwFzOK5ve9xmIHk9SK+sucUWCBfinyPPhr7+IFSDQWK76x6xM1p
BrW2Jl9vvKTAujyub95opoGy/97XFOB+zXF4A5cZuJ8dLqh7S4GmJcv9S1eZ
wW13bvfGYQrYec8FN/KYweeq+4pLuajA8yMo6R/ab6vCnd+rqFB74m+56hoz
WKvm9PLLaipoR8z+i0anbjTUeMFHBbE7M6e385pBYMr2o9tEqfCx88e5Xj4z
4CBzLvsgRwU34/HLkwJm8K5+JqwRqOAU1/9GTtAMHq/8OhJhRAWbz29Fd6K1
BJo9wYQKxhHP0mvRjjeKO+/RqSD7+kpZopAZ1Avd2rXDigrDNhvGTETMwNlu
zlN3JxUOuAUwEsTNwG7gfLHyUfy+ggPRzehfdhe8Evzx+1Y4dyyXMIM1xry8
KwKowMyiu/miuVRHLNsDqaA8KhZkTDaDhNItm51OUeGbX9n9CYoZ2K9Ki+C9
SIUjZ5esMqKZgfcn/0SNZCq8Yu+uOYoe07noZJdCBWnJ0tOZ6H4hwQ9HU6nQ
Wnr0N5e0GTi9spfNTaOC6s/hwRa0zojFVtEsKox5NlXsXmsGpwcP0PNyqODO
SvQ/IW8Gv8UpEeKVVLAX1ezPUzYDxd+FR617qPAo5N/tAbTP2d0nN/RSYcWn
l64CKmZw5qH8Z/4+KuRnOw4eRd8Jnnzb2k8FXqPTw9qqZrDxruYe+hAV6rxf
jZerYfsOdewQG6OCbrXLbP1GM/h4DURs/1BB3CdKYEDXDPSf9LXu55eEFhvx
OxJmGD9R1he2GEuCU3TNZT8bM/j0XJbc6iMJXbvvtL1xxutjGVn8uCkJiudS
j7K9zWBXE115pkISdnpVH7oSiO0xXFzg+kkSTveINnScN4Ph9isbBzmkIPBB
ZMjmGDMYmbmjaqIgBe6cmlEPU83gQk4OxJtLgZrs0tmP2dhevN2LV/dJQfPN
iYr1T/F+b3rr/DtUClyTeT6deWkGVYtUhlCqFNTPMpx/tZnBaL3Jo75iKeAV
ydVR6jODji2yF983SwG92tTnwLgZkLqHdtsMS4Hdy7n5l38wvnN69g/9lYLt
TkNflTnocKrsbdQnThpo5kxvsBOkg3Vfe68vPw2+ONLe3pSiQ13wTa9ScRpc
jT/TPqxMhzO9y4YEZGiwev0SFZtNdPiysdzbZD0NPEIyB06Z0iEvwjC3Vo0G
Bc4nfxTa0OHz/Seu+to0eJfo78zlTIfLp1f7P9GnwahHyjoPbzp08LiZ8BnS
4O2FEWZfIB0S8/+YhZnSIPmg/SuJ83QYsli3wd2CBo69M5nOMXTg08vRWGNJ
g7CBZtVraF+ziBZxdM5QZnE1ejXl4V559LIx2wa5WDqUJb7z30r8nnYmd3wM
raRcp+eH/kfy0giMp8MeiXvb29Fpxl1V0TfpsCIp6vU1Kxp8vVfy8XkKHaSF
d3XNsGlgF7Di0gw6Qyz88HJrGs4brHVVUungMN68yIuO6R2Ju4k2n6lcLo/W
ExK1OnSbDvqgmWaLvnT6WBXlDh2Cark1HqGV7DdmHs+kA0fHzWLHbTTwWZ7t
q5JNh732wT43bWjQsc9dxg39+v7Ou2nE+5ZGSsd1tHzP+64HaKH4qC1LHtHh
/Il8mWfoUvlDPO3oK2nD2waI3x8zNj4IzKUDxX9Mcp0tDVKiSz6/yMf7ZTlx
PNeW+L334YQ/6PNqr7KK0X6O6y1VCujAeduxqRJtIpNYeB1NrY5Z2ooeLQg+
t7+QDrprz3BMorU7DaT5iuhwWLIrVNWOBi3U2l1OT/F61y5nZKJvLn4+fxk9
11b46yHaZYAjtxytILA1kahPMJ1hvlSqlA5TDn1NlWgR5cbMQfTex7v73qN3
6bV/8y6nQz6l7iHPdvx++4EzpyvpcLX7z4Q3ukB32YM8dOX9qidHiHoIEmvb
B9DpLX4BgUQ9ql53OZMqjEeDmE/EfjwbPL40cD2ng8Doe49EdODR7wIx1XTY
cHpS7CXx/i36X0ZGLf7dOklTzJ7IR4v98R5tHzd1jooW/bLOiO8lHR5eXP5a
Br0O7PpOoB0XnEEFzZx8IM6uo4Mnm6ee2I8n2nrHldl6OuyKKmfuRyfMT3Sr
NmB/aJYX9SXqV9w7p+SOLkly+ED83r5gSW59M3q1HZ95CLojb+XyjFdovy9V
V9Bk/oLjVo10iHB9vS4fLfvM/OU5dJ/tl8NFxH49+3uFnqJLH73LKyXqYT1f
lb+2iQ4NvLJiL9Aufi7jf9DDtbfD2tFZb9a4prfQYevKjHdEvQ31GC/Gnza8
H4+ldykR76/LPHkV2+kgHG/gpUrkB3x2b9uJPqXF8NmAbtVxdapEiz1Sc9Mh
3m/3OB4If0uHLWcMZ4yI9/3rmJeEOvB+zE82E/shiNlYWJmhBZu1DuxEnwmm
CwSizVz9FnYT+Q3Nxokf0esfNPMT76cnj25+cKeTDicPqQ55o9UrVV6pv6cD
T9BXndPE+X1RuuKG5nZ543aWOD8BRZs49PldxeHE+/FWd/kPM+iDvqefEu/P
D3NLjVZ8wP7ZyPOaqC/VpUHNmUSf3Dz97BqRH7SbfETmIx1kfN/fJ/bnIeWJ
/j2P1hjL8SbqT+VtJ3FbdmO8yZxLIepLiZ3mbT6FrvA/53ibuJ57PDF5aCmN
i2uI9/3Wc1wSQj14v15luRD780zeXqr4Eb1MT6fgIVptfNpifx8dbjcLchej
r2fvFkxE/8hSYRP1pha867tfocMiE6KIejONE8mHlPvpkLtp/28in+HAd/P4
7+idmj+PE/kQbbkFe2gDdGi68iCCyGfadFhy3TY05WBRNJHPxDX1ozQfnbW3
9QqRT5E1ndJ/7BMdYrzF9Yl8DN6CVQ+y0LLfIoSJ/KVjR/2PdqK1PNlfCZv8
tODYNEgH2s/RECK/I7uwsGU/WnakcjOR3yR4TCohEf370vdfhD/9+qk0j7ZL
dbEj8kcYRc6/lIfosGrizizhxwGvKnajezINbxL5TmdmUrdVotUErz8n8lG+
FHOTJ9EdGSwWkb/CDjw2RPtMh/Gdrq2EJWcZx0PRBT+zaoh8l/CnT6AAHVXQ
pUnkw0ycoHEPoeVsDqQQttO73C40TAfS1l1LiXya8r+/kkzRn77k7CYsW+bi
GYBWq3ArIHw5+LXaXfRllcBlRL7OtL72bCf6YuZ3BmGn+dvVXCPY/nENkYSr
y1dHbkJX7ueoJ7z+ZMD2A2jJ2Kx5wtFbBiRvoQ+ffqBI5Av9+cf88hptkSxg
Q9i5oujxPNpgZ9+R//OTTkkHq3yhw4ACfxRh1a2RJnvQ9X73bhOOX/y95ir6
/N3M//fjma907axE5+is+n8/Hvczjbcn0R3R7f/nP70GnQPSX7G9pVf+//mN
S+9o2KD9d6T8v79P4nOef6FogYzUy4SXhh5/WYBePLLKj7CX0aerQ+hWjW42
4dZllo7Co9j/t4v9X69K90WxjBn6oGnFLHG9qedkxgPQe4421xDmMIl6chd9
3tLiImHfFX9OdaGPGqnRCXfUuJmvGqNDedWZ//fn2XK+iV8P/UvbIJcwD0d6
xi10RO3CPNGeBdGhsa3oykjmNcJOZLfQleN0SP39kUr4vrq0yyE0c6RBiogP
67Il7Az03/Pr4v/fn8e0f8t79Phw4zLCZjtTycYTdNg29uUlEY8Tn09xB6L7
rrhSCccd3jObjd73Q9qbiN/B89ROkW90uLEYPE3E+5m8WzGj6N9y6XeI/qKg
H3xW6jsdXrbtKyP6V3Ot02E79BwENhL5TtSP4lYV6DrXU51EfmHpypurYibp
4FKkco3ov67Rx/+8RL8+tMeb6N9cZIeROfTKsd6tRL6Tg7pIrccU9m+FNy1E
vuNPp7gzm6bpYFt8IZYYT259PnrIF513xnQDkS9pdNh2TzranMe+jsh3unZe
YPOaH/h8OuDfTeRbquZFz/Sjo40LHxDj0zu9w8PCP/F5T6OuJvYPC6llv2Og
wyt79hL5Tq8/8BYUos3NvBaIfE+vlVG+F37RoftYXmcymi/ae/cztML+z3+J
fKciCRZrGh0mFSCSiF6pvlpx12+cT73L1ib2P7vjdPGz2gwd/nidJBP7+fTk
nt/V+YcO93TIx4n6VUPFTVVcszifs403J+pXjVYKy+mhVdceEiTqD/5pyZxI
QtuFGMcT9asEJmtPuf3F/hsYZEHUrzJT50ibmKNDV2qIP1G/iqVrtVJqHvvT
E5luW7QtXN9vjb61qLplG9rFWn5jAZqvJXiMiQ4+bPYi8B8d+Cum/gDxPMgL
/7x8kQ5PBu93rieur6TZQgv9fG7wnTz6WZVIjidau/5SE1H/6lVrVkAD+rgk
7T5R/2po8iXn1SXmYCJ9jJ8fLb6BU1FimTlsjlh79zc+j0MfR/iqrzQH0wqb
r+VEftM5kz8e6F23974g8p347JeG3kI3Q0N8ITrpb1A8B4c5JN2IW5tN1KM0
9i3vRufe1B1MRH95Z8d9kcscVOqoPwL+3z9IOmtgtTmkN9zasR4d19irJspj
DlsCFA2IfKePKbeestBdxRQKUR/Ly1i4qRg98lbluRBRPyuS62fUGnPQPsKX
R+RvF0p+N9TjMwcRMV3pt0S+uXF5T4yAOfxZscfuONol+7N3Hfr+z3t7/dBZ
wnzzc2juXdkHD6I3fnGV8BA0BznbXg9ntEUUp4OOkDlEKs0toxPztU6b1o/C
5pD/OqhfCN1x8Gu1rLg5FF1NVyLml9fiRO4VSZkD560b4tXE/DT4XvYI+hZN
pb8U3e2q91iMZg51p8NuF6Dl1faUBqFleIJ4iXqspQ2ZjQbS5uApdzE1Aj20
oDn1UsYcwlNOXmeidfbb6nXKmcO/pqn3zTi/7tkS3TijZA7mujfrq3H+Xv3t
+m9lZXMILWkyforOSk2muaEvj1YX5xL1a5c+9G9Ed/+buJiEXlFbS0lTMYet
Ijadx9DKrDlvhpo5GP9+IKKADnHyXJO80RwWE6UUw4j6V8c3WxltMoe3kS7F
63A9osbFpfjA1ByC1Cqu2rLwetdz7CXbYvub9tu1mRP5XYozli7mIKRdWDNl
gv3ZyOdzsrc5RCQ9mZgEjK/Vg+ozJ8yhSmVLm+pmPB/lwA6fcHNQtvK476iD
zw8ejc7MGIyv7O33tm6kQUkITWskFe9Xt8eUlTIN+k1UJkyzzYFc2+nrJk+D
uSTvZTlPzUEt3rIoUooGvwrfHOl8iddnE2l/UIwGNbL2WyTbzeH6PzsLd1xf
hsuu8fDtN4clg62Hdq7C6wsZHP44bg7xHQb8x5die8b2veCeNYedopr1RdNS
MKvHu2DEYQERiS5SZv1SoK23K+amgAWMq3muM8b1rmdD97kZKQv4OR4T3PFU
Cg7mhbQcVbaAovBPXMOZUmDlYBTwWNcCeF4MT4RekwK5K3pBf0wtYO2c4iXv
IClopdh07bKxgJf3Ln8d2ysFvvpJsa+cLcCyz234MEMKxsR5Hsx6W8DybZqK
W9WlYLP1LQmzExZgb+X3LEdECs6K7P5yK9wCsiknHt+elYRETQMSX6wFjG5o
FaH1SEKMgGmscSoez+NSYmWlJJw8c+ro2WwLWGiZGeRLkYQtZp2PukssoN+r
lDs7RBImb7mZGr60gLyiZ8tnt0vieCCou6/dAjS3jth/U5aEL5JDYQ/6LKD4
Yrsie7kkGFJGVGfG8Xp29WvHvaHCIb9VGq6zFrAYd3V1ajIVou33xL3lYEDX
8LC+xW4qyBpa71vFyYCPTyI0dXdRoUTJSM8ALfeJ86T8Tir0L5Hvv4uevyv4
d4kjFdQfTigFczFgxrXw4iM7KrQuhryQ5mbAAVmmzBCTCqT7t6Z91zDg3/i8
VNUm/L65LutVQgxYuLvQ8UOACuf2aiTooSsvKcjX8FMh4HXUwEF0bJDQrVgS
FXbfMjrSjB5bETOlxksFRf3s2FhhBqQ+36S+h/j/uKDTHVRRBuyxPNp9dZEC
f2fldm2UYECLmfM7gzEKuP85sm8njQHVBqckgiopcEPR6F00OiH38Nevzyjw
ahe/8Ut0yrKD9B3lFFB/niu5QZoBGkv47qo/pcC/i+PvOGQY4Ha2Nr8lnwLX
yZ4m+WsZEO96sLYmkwL1Bo7SqxQYUPP7u1bgJQrMHV531QAt+I09WHiBAqrp
M/NH0bX3uuu/h1MgjvN6Vy/6fPJGdZdzFHBtbbtauI4B4mWTYkoheP6urAVn
RQa8e85/1NOHAsrnt34sUmHAl6yMGScrClRoHq/4gj56z9ImiEWBbUM5aRKq
DODcvvTZDQYFAowlvU6h29RTnzSaUaBq6b+fpmoM2BTyvF1yKwVsT5XyvlNn
QC7b+omLGgWCjmsZ/dBgwI9Zlw2GvBTgUfCRk9NkgNrUYgyZhwKpHRlcDuj+
EZXIH6soUKMl1FKKXh+0WTNpJQV4f07vDNVigMVxh56WeTKkHc47xq/DgG3r
a5PKR8lQv1/pvpoexsfnJKFLNWRwymu55oL22POoWaKaDOO/jwZdQzvobU+7
V0kGUlg58wd6o9JiUFkpGXakWH4r0sf79STa/VkeGUbaDmkYbGHAo8xvG1SS
yMCxufAZCxiQeVtTPvYwGW6G7sg6iY5JXf60zIcMig3zV3LQids67/QfIIOV
vakLyZABv0oynaU8yBB/uGPZW/Tltb4FhxzJIJv5h77TGOPtu9z+7YZkMObd
0rbfjAFvjVQ/Lawhg5CUfX8KevTgtUwnbjIMqx361o6usSibzOMgw6VtadwG
dAZUnP/3nbUoAa1xK40FzBnw9flHI8NJCdhDbi4otWCAc92qR6Q3EhC0zjl+
tSXGX+0Km8koCWBtCkwHtFpDXnHYRQmQZFx7fAy9OfXgEoHzEvD84IumPnTC
0u2LIiESwJWrwFFoxQCd7fy8Dfsl4LrWZMAuawbQza4/rTSWgMdGZ3c8smUA
7YyzQNiUOHxqXdbdizaopHcdGRcHIecwZ5IdA35qU5IdR8QhIDjC8yh6u1HI
CG+POOgVRvlv2s6AqHDrDyL14lAtlxhda8+A5A+97VeSxKGNq6C+x5EBKw5k
+T42EIflNzRZfE7Y36ZFyKG64qApV9QC6E3+296YbxSH64ZPO9LRl8YKySVy
4uAUVDm0fycDuORIByk84jA49nrJ7114vze91/nWIQY/m4d0eV0YMOeUrWPp
LgYeCh8HjNEZ10aMpHaJQcfpN5dOoG02Nh4btBWDEvWK7iH0fEOhqJGxGATH
3DhT5sqA6JTvVfbSYrDMnlHvtZcBB7d6fGv7IAp8PbkOLzwZMJG7YWm/kSic
0cpaMov2L5hyG9IVhcmopPuq+/B8O3w1P6iKQpvBxbkEtEHeNCNRQhSu33ZL
PezFgN0rTb19pkSA4i48Qj3AgClKnLhPkggojgUFBPrgePg+TvLSF2FI/NAj
+wgtplrfRekRBu5X0D6ALqooV8p8Iwxj9zjUmb4MSHfzO3ajVBiyPWO+Ug8x
oJVzgn9VpDCofbq/68VhBriQQ7sdVYRB832XEa8/A/yup+/7eFAIMur1p4zQ
tAITwRxnIRAuSUk9jp6ab7h1xlYIfl93n+9Hx9oPzMjrC0Gx3eSTgmMYP/6V
c2HcQqDXyrne8TgDyv6xAkfvC8LWOm2+jCAGxNXJCyR+EwBezWUa79DP/4TJ
rR4SgN7bTfYcwQxg7hN6deG9AJwKck/xQms4bdJ+WCMA5SoxKiohDJB22+R4
/ZYA6MVNMItO4vd9EA2yZgkA99Knh0bQJ/bxGRQYCcB7n7BYsVM43r53qFHY
JACBdPLHILQSKVObLi8AxX/ND2w9jf9eL1Jo31IB0HTNuFB/hgENl5jCLmX8
sKL5UPYsmnMo+/F8Pj+06+m3Kp5lwFZe34KcB/xwRKhNNArd5J500TaRHx7X
LWZtC2WA1neV1IwgflBV3Vn74RwDlmwSeH9qKz8sJMp/XR3GAO2RVKmzuvzQ
xDnNswW9w9/nVOIGfvAeuGCXir40y/tYQJYfHsYVDe49j/H48v0DcW5+WDfH
v2winAE+EUyT0A8k0N1ow5SJYMDeV39Lz7wlAX1/TJwD2iNOXDuxmQSenQIK
1eiVIcwR6gsSZBQIsm5cwPi445vm8YgEhaO28Y1oK67duZvukeCFdFzv0osM
yE8Q+aGQToJPV4X8vNFLvTbdsEkggZS38HXDSzgeJWs6d4eT8Hm0vS8Ardpr
qHkqlAQGH+LXZaPHKhb5N50iwS5zkTKRywwQ5m3Qmz1GgkRZ0f4x9IcVpy1T
PEnwYKfDeulIvF/JRieX7yXB05gbR+zRb844mJxxJkHXErGVz9EUh9SWyh0k
EOkRU7wexQCjFaHG21gkkBdyPPoaLdzyNcHHggRazITyJVfwfEcujKaakcDu
qTj7IHpGIjrd1JAE7pOON2+jtYyUbpcYkOCoQuLAO3Shv0clbCZBTLyEP1xl
wIbF85ev6pDgTqPTs2NoG2O319u1SPB4+S2Oh+isAE9bdQ0StPqRE4SjGRDh
zu0qrUaCvns7PzHQj6/LndBRIcG3vltKZ9Ch7m4LLkokWGNFqRhFd97dEDCh
QOyXtIuTdo0BeQdT5tjyJFAuT7Lejl746CFUK0sChiJ1sBLdx9euMCxNAifX
3cq/0AlcBUXXaCTYfzP5mGIMA8z73i1lS5HgAockVzy6grt75h+FBDe37Nn2
Cv3wpdam72QS3PVPSVxED+7M3zslQYKih72DmrEMkLzPZbwC/fKTpMoBNN/n
pHQFcRJ0iDsHpKLnzOxtdoqR4LN1auVbdKYumZIqSoKfEX1c3HEMeFom3jwt
QoIVlVI2W9H+rw9r2xP5TEfrSX7oykaHVW3CGE8Kfi130DeCRzftJPbr6Ra/
8hZt58e+PSVEgsroahZHPAOaDYyE49GqpgdX66Ldo0P9TNFJs4Kv9qNd2ENR
y9Crc8ov3ELLbuYzaRQkQZCbB70J/Xg7r+8d9FcRXo5FdIHH+Gci/2jH66Ia
9esM+PNv4jyRn/TytPM5N3TACdP1RP6SliaXURy6/p/jQyK/KeNL3pKX6GdN
MSPhRP2sZMfKGXSRyKunGeiz25adWn+DAYYZxQtNRD2ulQ8370QniyjGEufn
XGo7F4l+6//b1gjd7Dv/tALd631HMgq9eW1m4CT6INP9zSf0w05LHZmb2J80
TzCM8f5IRP7+ZYv++U3LKwd9AVILz6PvzbxZJYv31/P+5Iav6KpMVwdVbI93
uxMmJRIw3n6MVVejTQSMclnoTw1BG12x/aSDY5Xz0LeuKd0pI+qnqW0eG0DH
0Obdj2P7LwwO3RdMxO+TF87fjPHSzdJWOI5+HLvj2CDGE3Np3+d76H9Bf/Jq
qCQofRKR8QG9KkZmea4kCW5Ivpc2uIXxmnYqJAXj02YymLIyCeO7aUPtZ4zn
5xmyH7XR8QUypTwY7+qOTQle6GCx8u/62B/WVEuKNqLZ86yn+etJUB/7nD82
mQE5x9KkFlVJoGN+oLUGzfdtuZ+HOgmy5gWu/kanuASbtG8gwTkPdx6nFJwv
7mGK1WrieKTDySmdiuPvORXxRT0SPPnAms+5je211vpeqTkJZOXdqvrQJNMx
vnAG9n+/42GkNAY4VfiEOOD44st1h+cIWl42XYbHmgQK2jMUrTt4f2WZX0od
SJBwLW1LWTo+/+b9LKW9SHDS/PepuiwGcFd3cT6JJMF47GrjP+j3fsodclex
//bRONffZYC++s81t66RQDuAefUS+ufG7tiY6yT4nn471fIezrevN/wsvE0C
10VGVft9HC/Yfy5VPiGBaVHq0v5sBpx+9OZW8Sfsf6/Xjwk9wvl7kcK/z59x
vBooeGuB1rc8f1LsK7YnT/3dAvTpIe7qi9+xv++dtIzIYYCIuPKDpHkcP/kN
E1XzGHDO4vjPU6L8wOH9aePJAgbM1lhICFnzQ720nLtEKT4vKd4iLa/5oaNQ
9AUTvV8tZSylhR8G6dwyJ9HrSz5l+7Xj883ne18f+vdZxWmpj/ygUfp0Z2YZ
jo/G3KGpo/yQYmNlq/4Mn89hOqmK3ALgf+64kVkVA677MiWOMAVA6nMD7chL
nP87j/eNdgiAt9GGzLvohIHo5g8fBaA09eb6HnTQk0nn5n4BsHPat9G8jgGB
J6WPVI0KwIWWFSaS9QzYpxkR0bogANNPt+571cCAJ3905e4oCELNlSePZJpw
PIqukBIPEYQDuml67e0YL3Xz47XqQhDLTMn91Y/PS9v5vbIvhOFaUekprQkG
RPouoQT4iOL6eNXDU38ZsG7MtnWXpTg0HVhrmofuvVqhIWsnDmKyW/oG0IJt
rtu+OIlDzvXDgqZzOP9Yf+eop5c4fAzuDF49j+vhszKuuudwPmuWybr5jwEl
fmdD15aIw+cP8O3xEibsYGQ1p0lKgHqc04VBtCZ9uX+frASEWPrLCC9lQsKS
3npRJQkQqLprH4j+5XLXPFBHAgwyeSsNljHBXFpYdYaN8/dD3VdfL2eCyMSV
0IHTEmC+InDDZw4mtGXoZJM/SkB7BMeUBCcTauyTi9YM4HpidXyeNXpLr/Dc
zLAE+Avkq5WjuRaKSU+mJSCVNq4Sy8WEuwV2Ka2ryPB7s4uiITcTrIaV+iO0
yZBxzHxt8homSA//jOm5SAa12Y5PbeiOhCNBTVfIUBricYeLlwn7/Ov1nsSS
ofVcqLQ/+u9BQ7Z3MhnmrpVLMfmYoNJbzn8C12c2OeqUWRITcu9yMUjvyPhc
FxPeLsSE6s5cu11iFIhcKvThIvppZtf8FgoFRCh8qRXo4JKQk2I0CihuW7l+
nTATzkc2rS9RoIBd2dTmObT4d8116doUuHv1lXuaKBPePg5qV7OlwMYHtes7
0Jqedqbp9hQor6n6xi3GhAvJg3IkJwq0zhYF+qNFa2J3drjg+npveiRdnAnr
NC6VCvtSwFI3pHBCggk/pK6d2R9BgS6b4ydkyEww/TBVTazn3XyOGDig01M9
qaFRuL6+41VfhT5oL2t2LpYCt3m2d8dSmPBbbkcCpFLgR7/KCj1JJrhUZA3m
PaFAwsU+23BpJnxuP367sJcCodLGV4rR+6K+f53up4D306z6L2hSAWxRGaQA
fPXZwpRhwp955bXXRygwbD4vT1qL13ewvmPTJAU0ucT/Jshie+WqSrQuoUJL
uM3tRwp4fL2DLYekqFAiWfShF33FdmHpVmkq3CkSFyatY8Luz783rV5LhYDh
/otH0IGjezoS5alAMTt0VGc9E37+YIffUKHCgZWRZs8VmbBLWb2MR58KK8Nq
x9+qMOFV7Jp7gnZUUB1OZnGrMmF8ZK993nYq7DAPyN6KPjXXdJThQIUHPAre
D9AliWZix52oYB1/Yey0GhOiZBIb8l2okJTFHFXcwASKX1TqU28qaDa8GTmj
yYTYetMD6ueosEfpAb0IXb8s9EBEGBUiokLvjqEd9yondZ+nwodtGvvstZhw
0sTg3tkLVDjzIW5YSZsJ7JU134uiqNA45vC5Q4cJPRc9PdtuUMGdt/eTsj4T
vrhqPB57QIWJCcmSPegl851mCw/xfjQ5R0Wj4y/rPud7hN8XOaDzE73VqOOQ
Wi5eD/fnyLLNTKgU3rbSrYAKUxzj2gwDJjS85vO+XkaFU4uzl/YZMqHc8UyW
5Wsq3JwU1rhDZ8Lwiwdh3l+o8DDmaG+XLROeC+kekydLwuOa5SNirky45jHg
SWFJwmWrAosAHybM9O7dsz5AEhy94lf1BDFB9XmmR+9tSVhplCy78gITZNrl
63zqJSH8aE0CI44JSWoweWxMEv5qSnonpGF831Y0uMYnBcZWN26uzMF4PrXa
8YaaFBxQ0KZplDJBy8llTaClFJyP5lx5oI4JkitsubZ6S4H/tj/GFe1M8PBz
YwdESIH9HXI/eQCPv3ZirUu6FKxh7um4PoHxOHb001yZFKQXvFRon8X226/P
rmuTAuVs1w4xThb4nwnv5BmVgovz5L5gQRaYXNrWfmhBCt53c5l+obGgpDdo
95VVNOA6SeYQUWVB9nej/UsFacBzzFLaVY8FfIklT7TINFj+73HCEzoLdvA1
P/RfS4Pmbi1vBTsWrDiyK/uKIg0CQ/oSnFxYUCgyMPlHnQbC2WWyN3xY8EZf
8dB2HRpEaBSvmjrBgiS/YO2SzTQYZ3xm2kWw4EuCfuwfQxqoy2z6GhjHgsMd
PE8vm9HAfFt2f+ltFtxZ9oZkxaCBHclGiyOHBetO7f3XYUmDPNk1XTro3sc6
MoPo1Zvqg/aj5W7t2PodXe1qUNWI3jwY6sZphccvUGTG5rIg5NZFlg6ax365
K+0xCy7qf8qNR9fcKozUK2TBxsK3xSw2DTQVRId8S1kQ6OQ2kW5Ng5aV9OwM
9M6ayBW56ANDAf4f0LczugRK0WlpHSvMylgQW9kp1IrmpVyXo5azYEL6Qs4c
+itJeN/rZyyYynHYtG0bDVL+CowqPGeBacqnx0R9r03vjfJ3o6NuPswhfo/9
tvhIUCza4sWjO6ts8PqOtXEvovemuRymogO/X1PqqMb7ZxR/xwRtM0TyCath
Qd2eD27X0JzNvJP9dSzgYWQ4yNrS4I7xw2fC9SyY9IwVVEFvfkq/zECPGsjU
aaGPZJyRL0Q/fyotTEf3Bk3vimhgwW7eUhaxP1KhQkeDymt084AiUX/B5Wxy
elAzxkdo4l0lOxrM/d7kl4t2Pfhihwb6uneHwRD6dfftpfro1w58HyxbWHBp
KliPgdZWPUuSbmWBkEituRea56P7ybo3LPAe1uy6g36qqewg9I4FZSGidfzE
+yqFDYmm6Ncw/4+o75Ujod0TgL7yuVRFEn1nCex9j86ZqDuuiL7UaHsopYMF
jyvViozQTu7BEeu6WFCemd1NvM+aj31VvPkjnv/bf+2viHoX4S1/fdDtt2gK
rejJE2+3pKLbolWOEvW+hpx7XyztZoHdT87ffegmpemWl+j1Bo1ZP9EpL8S/
WPeygPZisZBiTwP44SXmMcCCyOoTEfvQQXmfziSiL3Nt3uGNLvTZ9bUFPZpW
TvMj8pO+sEv1PrFgg8XczSDifWGP9i7SIJ5/9Wl5ov5H78sVt8uGWMCxTr0o
Dy0WdoprCk2bl17+BG1j+Oew/GcWaK/ppj9FvywbM7yGrnJ5WPIcnZPXNug5
zAIJ+XqdNvTJxNsKAl9YcHwyLHsKXeQgEU1H+42bBPxCTwrF/QlBr+Dr1JlF
u1+NaBhB7zbyv0PUC2OF+R589pUFD0rThYn9ISi+m3O9xliwtcTVX5F4P27Y
pV35jQWV5DxRIn/INqRUaAq9P1o6h8gfGi9Kmpb5zoKF3tAtLmgpZdeccPTf
VhG6BzpMZFTOapIFyd+jVx5CW43NCfVMseDpAS11In9oRK53mneaBTGnPm4n
8ofOuFS1Ajq/LtD/PJFv8C4sMgNNbUtMIvbnEKtas8L7BwuW51+8SeQPDcRJ
/fj7kwUqUye2EvlAQS1L3yj/YsGjglc/09BC3EM5e9BveCTSiXo2ZqfvHahG
795ZNErsF/Jg/4ZPF3+z4KvttNwjtHGGYFUZeuKJSXoOurv3V/IE2tQ5QZzY
j4TPrtRx2wzahTlF1O/yNzB+I/YH++/KPhaRP7TmhFwuAz0SaR1D5A9lFXBG
haC/rq5vLUW/X9do3o82f/VKl9gvxUBwe9XdWRZ0b1R+QuQf4HI35T2a5f6h
msgfOnxBPGT1Xxb4GsQ0EPW60v/16BxCi9fSqon8Ba4vnrnacywI4HjpTOQ/
pD19ErMPfZYjewOx/4ve5RUBN9GuZ4fmCR9UvbP5L7ogw+o0kT+xYsmUlNI8
3i+ls9rE/jJJb7Yu34W+Mso5QrjZv6fhGVqkSVCTyMfwNFN+9A1Nb0loJbwo
Ghwt9Q/H+5fHPIn8IfUyMYez6ArrDaeI/I6GyH16+Wjvav4lRD6I254i6iBa
btgimHDsUrshkwUc75a82E3kjyi336k7htbrWFH7f72ujKkHWegGidtyRD7K
7gC40ol+uiX+NOHf9Kt+XIssYOcMtRG+It5rtwnd/PGKFJHfojCmrHsAHawV
93/9rqryYPIt9C3FXxmEd1x5tfAafUQxv4fwlLP4p3m0ScZrvv/rd23wqlVZ
YgkOnEb6hGWWF9/bg56oFv6/XlbZ25WRV9GWZvRThO2y7A5VoUuXdMb/v1/S
8XSbKfQJ19oswuctprVkllpCS6fAY8KSZENxW/RiW+X/+UPF41fnz6Gtqhv/
/7t1RW9fIXqpsN49wl+uqrz4jN6px3WT8FnXkCyRZZaQnqZzlrCExuuLdDS5
tH4v4fwVEj6B6FU/yrYSZnZ4Wd9HPy7jFyY8dLdY4wPa4dyrQeL6T57gEF29
3BLg6fBDwiLM7X/10XmNnj7/7zdFyejxRo8rM9cRpn+brkpG61rEdRP3v7/S
MKMZ/T7a6BLhwGvREYtowaP2Gwg/0FS1cl1hCe41eQeJ9jXmOLkhBr1c4M8C
EQ/dna+FXqCtirMuE14TvP+j7EpLEH6hf42IpyxWScV2tMEvGW7CBpKcd8LR
v6lHQ4j4O/w8w+sLOmGYbUnEJ1fsD6Y4hyXQrXseEvlDae5Gagw0t8m75YTb
OPt/PUQ77Oa4TfQHLSvyuUOclvDEOfAi0Z94R3svZ6B9y77fJvKJhs/fiXuP
fr3zYR6