
clear all
clc
addpath('OS_ELM','RBM')
rand('state',3)
%% Prepare data
x= imread('cameraman.tif');
x=imresize(x,[250 250]);
x=scaledata(double(x),0,1);
xtr=x;
%% commun options 
Nneurons =50;


%% Training Options (Contrastive Divergence)
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
Options.N_gs=5;                         % number of gibbs samplling steps
Options.eps=0.01;                       % learning rate
Options.Sz_mb=10;                       % size if mini-batch of data

%% Training  
c=0;
for i=1:5:100+1
    
    
    c=c+1
    max_itera=i;
    Options.max_itera=max_itera;            % maximum number of learning itterations

net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);
tim(c)=net.tr_time;
tim2(c)=net2.tr_time;
ite(c)=i;
end

%% plot (1)
load('results_ite.mat')
f=1;
plot(ite,smooth(tim,f),'b',...
     ite,smooth(tim2,f),'r',...
     'LineWidth',2)
xlabel('iterations')
ylabel('training time,s')
legend('CD','OSELM')
%title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
title(['iterations:' num2str(max_itera)])

grid
