
clear all
clc
addpath('OS_ELM','RBM')
rand('state',3)
%% Prepare data
x= imread('cameraman.tif');
x=imresize(x,[250 250]);
x=scaledata(double(x),0,1);
xtr=x;
%% commun options 
Nneurons =50;
max_itera=100;

%% Training Options (Contrastive Divergence)
Options.max_itera=max_itera;            % maximum number of learning itterations
Options.N_gs=5;                         % number of gibbs samplling steps
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
Options.eps=0.01;                       % learning rate
Options.Sz_mb=30;                       % size if mini-batch of data

%% Training  
net=RBM_TB(xtr,Options);% training
%%
net2 = OSELM(xtr,Nneurons,max_itera);

%% plot 
figure(1)
subplot(131)
imagesc(x);colormap(gray)
title('original data')
subplot(132)
imagesc(net.regen);colormap(gray)
title('CD reconstruction')
subplot(133)
imagesc(net2.ytr_hat);colormap(gray)
title('OSELM reconstruction')
%%
figure(2)
plot(1:max_itera,net.e,'b',...
     1:max_itera,net2.e,'r',...
     'LineWidth',2)
xlabel('number of iterations')
ylabel('RMSE of training')
legend('CD','OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])

grid