function [net] = OSELM(P,Neurons,ite)
% RBM trained with OSELM :
% P: input data
% Neurons: number of neurons
% ActivationFunction: activation function
% ite: maximum number of iteration
start_time_train=cputime;
%%%%%%%%%%% step 1 Initialization Phase
W = rand(Neurons,size(P,2))*2-1;
M=randn(Neurons,Neurons);
%%%%%%%%%%%%% step 2 Sequential Learning Phase
for n = 1: ite

H = Normal(P,W);   % hidden layer
K=(eye(size(P,1)) + H * M * H')^(-1) * H * M;% gain matrix
M = M - (M *H')*K; % covariance matrix
e=(P - H * W);     %  prediction error
W = W + M * H' *e ;% update weights
error(n)=sqrt(mse(e));

end
end_time_train=cputime;
TrainingTime=end_time_train-start_time_train   ;     
clear  H M;
HTrain = Normal(P,W);
Y=HTrain * W;
clear HTrain;
%%%Calculate RMSE 
TrainingAccuracy=sqrt(mse(P - Y)) ;              
%%%
net.tr_time=TrainingTime;
net.tr_acc=TrainingAccuracy;
net.ytr_hat=Y;
net.e=error;
end