
clear all
clc
addpath('OS_ELM','RBM')
rand('state',3)
%% Prepare data
x= imread('cameraman.tif');
x=imresize(x,[250 250]);
x=scaledata(double(x),0,1);
xtr=x;
%% commun options 
Nneurons =20;
max_itera=100;

%% Training Options (Contrastive Divergence)
Options.max_itera=max_itera;            % maximum number of learning itterations
Options.N_gs=5;                         % number of gibbs samplling steps
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
Options.eps=0.01;                       % learning rate
Options.Sz_mb=10;                       % size if mini-batch of data

%% Training  
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

%% plot (1)
subplot(321);
plot(1:max_itera,net.e,'b',...
     1:max_itera,net2.e,'r',...
     'LineWidth',2)
xlabel('number of iterations')
ylabel('rmse')
legend('CD','OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
grid
%% plot (2)
Nneurons =50;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
subplot(322);
% Training  
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

plot(1:max_itera,net.e,'b',...
     1:max_itera,net2.e,'r',...
     'LineWidth',2)
xlabel('number of iterations')
ylabel('rmse')
legend('CD','OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
grid
%% plot (3)
Nneurons =100;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
subplot(323);
% Training  
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

plot(1:max_itera,net.e,'b',...
     1:max_itera,net2.e,'r',...
     'LineWidth',2)
xlabel('number of iterations')
ylabel('rmse')
legend('CD','OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
grid
%% plot (4)
Nneurons =20;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=20;
Options.max_itera=max_itera;            % maximum number of learning itterations
subplot(324);
% Training  
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

plot(1:max_itera,net.e,'b',...
     1:max_itera,net2.e,'r',...
     'LineWidth',2)
xlabel('number of iterations')
ylabel('rmse')
legend('CD','OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
grid
%% plot (5)
Nneurons =20;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=50;
Options.max_itera=max_itera;            % maximum number of learning itterations
subplot(325);
% Training  
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

plot(1:max_itera,net.e,'b',...
     1:max_itera,net2.e,'r',...
     'LineWidth',2)
xlabel('number of iterations')
ylabel('rmse')
legend('CD','OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
grid
%% plot (6)
Nneurons =20;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=100;
Options.max_itera=max_itera;            % maximum number of learning itterations
subplot(326);
% Training  
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

plot(1:max_itera,net.e,'b',...
     1:max_itera,net2.e,'r',...
     'LineWidth',2)
xlabel('number of iterations')
ylabel('rmse')
legend('CD','OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
grid