
clear all
clc
addpath('OS_ELM','RBM')
rand('state',3)
%% Prepare data
x= imread('cameraman.tif');
x=imresize(x,[250 250]);
x=scaledata(double(x),0,1);
xtr=x;
%% commun options 
Nneurons =20;
max_itera=100;

%% Training Options (Contrastive Divergence)
Options.max_itera=max_itera;            % maximum number of learning itterations
Options.N_gs=5;                         % number of gibbs samplling steps
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
Options.eps=0.01;                       % learning rate
Options.Sz_mb=10;                       % size if mini-batch of data

%% Training  
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

%% plot (1)
subplot(3,4,1);
imagesc(net.regen);colormap(gray)
xlabel('CD reconstruction')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
subplot(3,4,2);
imagesc(net2.ytr_hat);colormap(gray)
xlabel('OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
%% plot (2)
Nneurons =50;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=100;
Options.max_itera=max_itera;            % maximum number of learning itterations

net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

subplot(3,4,3);
imagesc(net.regen);colormap(gray)
xlabel('CD reconstruction')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
subplot(3,4,4);
imagesc(net2.ytr_hat);colormap(gray)
xlabel('OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])

%% plot (3)

Nneurons =100;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=100;
Options.max_itera=max_itera;            % maximum number of learning itterations


net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);


subplot(3,4,5);
imagesc(net.regen);colormap(gray)
xlabel('CD reconstruction')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
subplot(3,4,6);
imagesc(net2.ytr_hat);colormap(gray)
xlabel('OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
%% plot (4)

Nneurons =20;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=20;
Options.max_itera=max_itera;            % maximum number of learning itterations


net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);





subplot(3,4,7);
imagesc(net.regen);colormap(gray)
xlabel('CD reconstruction')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
subplot(3,4,8);
imagesc(net2.ytr_hat);colormap(gray)
xlabel('OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
%% plot (5)
Nneurons =20;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=50;
Options.max_itera=max_itera;            % maximum number of learning itterations
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);


subplot(3,4,9);
imagesc(net.regen);colormap(gray)
xlabel('CD reconstruction')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
subplot(3,4,10);
imagesc(net2.ytr_hat);colormap(gray)
xlabel('OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
%% plot (6)
Nneurons =20;
Options.Nneurons=Nneurons;              % number of neurons in the hidden layer
max_itera=100;
Options.max_itera=max_itera;            % maximum number of learning itterations
net=RBM_TB(xtr,Options);% training
net2 = OSELM(xtr,Nneurons,max_itera);

subplot(3,4,11);
imagesc(net.regen);colormap(gray)
xlabel('CD reconstruction')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])
subplot(3,4,12);
imagesc(net2.ytr_hat);colormap(gray)
xlabel('OSELM')
title(['neurons:' num2str(Nneurons) ' ,iterations:' num2str(max_itera)])






