'''
#Wei Li, March 13, 2019, Nantong
#Date = September 25, 2019
#Search Parameter:
#Text Search for: membrane protein
#




Total=9666

Refinements


ORGANISM
Homo sapiens (3074)
Escherichia coli (968)
Mus musculus (724)
Rattus norvegicus (595)
Saccharomyces cerevisiae (271)
Bos taurus (207)
Pseudomonas aeruginosa (155)
Other (4057)


UNIPROT MOLECULE NAME
Beta-secretase 1 (374)
Uncharacterized protein (206)
Glutamate receptor 2 (184)
Genome polyprotein (125)
Bacteriorhodopsin (121)
Reaction center protein M Chain (100)
Reaction center protein L Chain (100)
Refine Query



TAXONOMY
Eukaryota (5798)
Bacteria (3168)
Viruses (913)
Archaea (348)
Other (119)
Unassigned (36)



EXPERIMENTAL METHOD
X-ray (7872)
Solution NMR (965)
Electron Microscopy (731)
Solid-State NMR (38)
Electron Crystallography (28)
Fiber Diffraction (19)
Hybrid (9)
Other (2)
Solution Scattering (2)


X-RAY RESOLUTION
less than 1.5  (329)
1.5 - 2.0  (1858)
2.0 - 2.5  (2167)
2.5 - 3.0  (1899)
3.0 and more  (1620)
Refine Query



RELEASE DATE
before 2000 (294)
2000 - 2005 (727)
2005 - 2010 (2603)
2010 - 2015 (3058)
2015 - today (2984)
this year (615)
this month (57)
Refine Query



POLYMER TYPE
Protein (9612)
Mixed (53)
DNA (1)



ENZYME CLASSIFICATION
3: Hydrolases (1215)
2: Transferases (742)
1: Oxidoreductases (518)
7: Translocases (307)
5: Isomerases (89)
4: Lyases (70)
6: Ligases (10)



'''
import os
from urllib2 import Request
from urllib2 import urlopen
import sys

def getPDBfile(ID):
	completeURL = 'http://files.rcsb.org/download/%s.pdb' %(ID)
	q = Request(completeURL)
	a = urlopen(q).read()
	PDBfile=open('%s.pdb'%(ID),'w')
	for line in a:
		PDBfile.write(line)
	PDBfile.close()
	


def getPDBfileCif(ID):
	completeURL = 'https://files.rcsb.org/download/%s-assembly1.cif'%(ID)
	q = Request(completeURL)
	a = urlopen(q).read()
	PDBfile=open('%s.pdb'%(ID),'w')
	for line in a:
		PDBfile.write(line)
	PDBfile.close()
	


totalList=[]

w1=open('PDB1.kiwi').readlines()

for l in w1:
	totalList.append(l[:4])
	






for ID in totalList:
	if not ID + '.pdb' in os.listdir('.'):
		try:
			print ID
			getPDBfile(ID)
			
		except:# HTTPError,e:
			try:
				getPDBfileCif(ID)
				print ID
			except:
				continue
			continue

print 'kiwi'