function mk_plots(LBF,Data,range,Plims)

Pd=Data.PV(:,1);
rhod=Data.PV(:,2).^-1;
Pk=Data.K(:,1);
Kk=Data.K(:,2);
Kpk=Data.K(:,3);

rms=LBF.Data.rms;
txt=sprintf(' rms= %6.4f GPa',rms);

% get 1 bar values of K and derivatives
out0=fn_F_val(LBF,LBF.rho0*[1.001  1]);

txt=sprintf(' rms= %6.2f GPa \n K=%4.1f  Kp=%3.1f  Kpp=%4.2f',rms(1),out0.K(1),out0.Kp(1),diff(out0.Kp)/diff(out0.P));
if length(rms)>1
txt2=sprintf(' rms= %6.1f GPa ',rms(2));
end
% % figure out a reasonable range of plots;
% if nargin==2  % just use range of knots for display
%  fc=linspace(sp.knots(1)+1e-3,sp.knots(end),400);
% else % use a third argument to set the highest density
%  fmax=.5*((rhomax/sp.rho0).^(2/3)-1);
%  fc=linspace(sp.knots(1)+1e-3,fmax,400);
% end
% 
% Vc=(sp.rho0.^-1*(2*fc+1).^(-3/2));
% rc=Vc.^-1;
range=sort(range);
rc=linspace(range(1),range(2),400);
Vc=rc.^1;
outc=fn_F_val(LBF,rc);

figure(1)
s1=subplot(3,1,1);

plot(outc.P,rc','k-','LineWidth',2)
hold on
plot(Pd,rhod,'ko','MarkerFaceColor','k')
hold off
%axis([-5 500 1.5 8])
xlim(Plims);
xlabel('Pressure (GPa)','FontSize',16)
ylabel('Density g/cc','FontSize',16)
text(50,2.3,txt,'FontSize',16)
set(s1,'FontSize',16);
%title('6th order spline for F(f); 4th derivative regularization')
% 
% 
s2= subplot(3,1,2);
plot(outc.P,outc.K,'k-','LineWidth',2)
 hold on
 plot(Pk,Kk,'ko','MarkerFaceColor','k')
 hold off
ylim([3 7])
xlabel('Pressure (GPa)','FontSize',16)
ylabel('Bulk Modulus (GPa)','FontSize',16)
axis([-5 500 0 300])
xlim(Plims);
if length(rms)>1
text(50,100,txt2,'FontSize',16)
end
set(s2,'FontSize',16);


s3=subplot(3,1,3);
 plot(outc.P,outc.Kp,'k-','LineWidth',2)
 hold on
 plot(Pk,Kpk,'ko','MarkerFaceColor','k')
 hold off
 ylim([0 10])
 axis([-20 500 0 9])
 xlim(Plims);
 xlabel('Pressure (GPa)','FontSize',16)
ylabel('dK/dP ','FontSize',16)
set(s3,'FontSize',16);