# -*- coding: utf-8 -*-

#################################################################################
#                                                                               #
#                       Array Evaluator   V1                                    #
#                       last time modifyed: 30.10.2019                          #
#                                                                               #
#                                                                               #
#                                                                               #
#       Autor : Martin Paul                                                     #
#################################################################################


################################################################################
# 0. import packages                                                           #
################################################################################

import sys
import numpy as np
import os
import skimage.io
from matplotlib import pyplot as plt

###############################################################################
# Read me:       manual input for the presented data                          #
###############################################################################



'''
for the supplied file the following parameters were used :
    
    a = 8  # number of rows in the "x" dimension of the array (horizontal)
    b = 12 # number of rows in the "y" dimension of the array (vertical)
    c = 15 # halfewidth of the rectengular ROI, values above > 5 are recommendet to calcualte a trimmed mean of 98 % ! 
    d = 98 # percentage of the trimmed pixels for weighted mean

    deltaX = 100 # spot to spot distance set in the spotting procedure, 1 pixel = 10 um
    deltaY = 100 # spot to spot distance set in the spotting procedure, 1 pixel = 10 um
    
    
measured coordinates  for the first spot in the competitive file:
    
    cordX_comp = 42 #starting cordinates, when array is positioned 12 x 8 of spot A1 from A1 to H1
    cordY_comp = 60 #starting cordinates, when array is positioned 12 x 8 of spot A1 from A1 to A12
    
    
measured coordinates  for the first spot in the non-competitive file :
    
    cordX_noncomp = 42 #starting cordinates, when array is positioned 12 x 8 of spot A1 from A1 to H1
    cordY_noncomp = 60 #starting cordinates, when array is positioned 12 x 8 of spot A1 from A1 to A12

'''




###############################################################################
# 0. Set dir and import Data                                                  #
###############################################################################
 
   
# sets the source directory, files will be imported and exported in this dir, it must contain the sourcefiles as .tif files as an stack of two channels   
source_dir = "C:\\Users\\Linda\\Desktop\\devel\\paper\\"

print("Please provide the following inputs to apply the correct parameters for your array!")
print("\n")


# Set the name of the "noncomp"-file, enter the full name with e.g. noncomp.tif  
filenameNoncomp = input("What is the name of non-competitive file? e.g. noncomp.tif: ")
if not os.path.isdir(source_dir):
	raise NotADirectoryError(source_dir)
   
    
# Set the name of the "comp"-file, enter the full name with e.g. comp.tif      
filenameComp = input("What is the name of competitive file? e.g. comp.tif: ")
if not os.path.isdir(source_dir):
	raise NotADirectoryError(source_dir)


# Imports the data of the given files as array type: 2,X,Y   
data_noncomp = skimage.io.imread(filenameNoncomp) 
data_comp = skimage.io.imread(filenameComp)

# of the 2N,X,Y array the X,Y of the red channel os used 
data635_comp=data_comp[0,::,::]
data635_noncomp=data_noncomp[0,::,::]

###############################################################################
# 1.user input to specify the array                                             #
###############################################################################       

# values after e.g. were used for the calculation in the paper


a = int(input("Please enter the number of columns in x-direction. e.g. 8: "))
print("\n")
b = int(input("Please enter the number of rows in y-direction. e.g. 12: "))
print("\n")
deltaX = int(input("Please enter the spot to spot distance in x-direction (pixels). e.g. 100:"))
print("\n")
if deltaX * (a-1) >=data635_noncomp.shape[1] or deltaX * (a-1) >=data635_comp.shape[1]:
    print("The x-dimension of the input scan is to small to support " + str(a) + " spots with an spot to spot distance of " + str(deltaX) + " pixels, the script abborts!")
    sys.exit()
deltaY = int(input("Please enter the spot to spot distance in y-direction (pixels). e.g. 100:"))
print("\n")
if deltaY * (b-1) >=data635_noncomp.shape[0] or deltaY * (b-1) >=data635_comp.shape[0]:
    print("The x-dimension of the input scan is to small to support " + str(b) + " spots with an spot to spot distance of " + str(deltaY) + " pixels, the script abborts!")
    sys.exit()
    
cordX_noncomp = int(input("Please enter the x-center coordinate (x0) of the first spot of the non-competitive array. e.g. 42: "))
print("\n")
cordY_noncomp = int(input("Please enter the y-center coordinate (y0) of the first spot of the non-competitive array. e.g. 60: "))
print("\n")
cordX_comp = int(input("Please enter the x-center coordinate (x0) of the first spot of the competitive array. e.g. 43: "))
print("\n")
cordY_comp = int(input("Please enter the y-center coordinate (y0) of the first spot of the competitive array. e.g. 58: "))
print("\n")
c = int(input("Please enter the rectangular halfwidth of the ROI, values above 5 pixels are recomendet! e.g. 15: "))
print("\n")
if c <5:
    print("Please enter a Value above 5, " + str(c) + " is to small, the script will abbort! ")
    sys.exit()
    
d = int(input("Please enter the trim value (2-98 %) e.g. 98: "))
print("\n")
if d <2 or d>98 :
    print("Please enter a Value above between 2 and 98  " + str(c) + " is out of range, the script will abbort! ")
    sys.exit()
print("\n")
print("\n")
print("\n")
print("Thank you! The script will proceed!")
print("\n")
print("\n")

###############################################################################
# 2. functions:                                                               #
###############################################################################


# evaluates a single spot
def evaluatorFun(yCenter,xCenter,radius,weight): 
    singleSpotResult = np.zeros(3)#creates an empty array in which the results are broadcasted
    
    meanWeighted = 0; # resets the "results" to "0"
    x1 = (xCenter-radius)
    x2 = (xCenter+radius)
    y1 = (yCenter-radius)
    y2 = (yCenter+radius)
   
     #creates a square waround the given point "r" to include one spot
    roi = dataNm[x1:x2, y1:y2]
    if (2*radius)**2 < 100: 
        print("Attention less than 100 pixels are evaluated!")
        
    roiSorted =  np.sort(np.ravel(roi)) # sorts all pixel in the roi
    weighted = int((len(roiSorted)/100)*(weight/2)) # calculates the lowest pixel for the mean
    meanWeighted = np.mean(roiSorted[weighted:(len(roiSorted)-weighted)]) # calculates the mean of the "weighted-pixels" 
    
    singleSpotResult[0] = xCenter; singleSpotResult[1] = yCenter; singleSpotResult[2] = meanWeighted;
    
    return singleSpotResult


# goes over all spots on the array
def gridWalkerFun(xStart,yStart,xDelta,yDelta,xWidth,yWidth,dim,rad,median): # evaluates all spots in the chip by sending the "elevatorFun" to the corresponding coordinates
    
    xCounter = 0 # the row which is active
    yCounter = 0# the column which is active
    
    gridResult = np.zeros(xWidth*yWidth).reshape((xWidth,yWidth)) # creats an empty array for the results
    
    while yCounter < yWidth:
        x = xStart + (xDelta*xCounter)
        y = yStart + (yDelta*yCounter)
        xCounter = xCounter +1
        gridResult[(xCounter-1),yCounter] = evaluatorFun(x,y,rad,median)[dim]
        
        if xCounter >=xWidth:
            xCounter = 0
            yCounter = yCounter +1
            
    
    return gridResult

###############################################################################


allDims = np.array([])     # creats an empty array "allDims"
dimsX = (np.arange(a*b)+1) # creats a spot counter from1  to 96
allDimsX = np.transpose(np.zeros(a*b*4).reshape((4,a*b))) # fills the empty array "allDims" with a matching maxtrix of 0 based on the input grid parameters
allDimsX[::,0] = dimsX # adds the spotcounter to allDimsX 


allDims_noncomp_red = np.array([]) # create empty array
allDims_comp_red = np.array([])    # create empty array


# every array requires its own empty array, otherwise the source array will be always overwritten and replaced with the newest data

allDimsX_noncomp_red = np.transpose(np.zeros(a*b*4).reshape((4,a*b)))
allDimsX_noncomp_red[::,0] = dimsX
allDimsX_comp_red = np.transpose(np.zeros(a*b*4).reshape((4,a*b)))
allDimsX_comp_red[::,0] = dimsX




# noncomp chip

    # the non-competitive array is chosen
dataNm = data635_noncomp
   
for i in range(3):
    allDims_noncomp_red = np.append(allDims_noncomp_red, gridWalkerFun(cordX_noncomp,cordY_noncomp,100,100,a,b,i,c,d))
    
allDims_noncomp_red = np.transpose(allDims_noncomp_red.reshape((3,a*b)))
allDimsX_noncomp_red[::,1::] = allDims_noncomp_red



# comp chip

    # the competitive array is chosen 
dataNm = data635_comp

allDims = np.array([])   
for i in range(3):
    allDims_comp_red = np.append(allDims_comp_red, gridWalkerFun(cordX_comp,cordY_comp,100,100,a,b,i,c,d))
    
allDims_comp_red = np.transpose(allDims_comp_red.reshape((3,a*b)))
allDimsX_comp_red[::,1::] = allDims_comp_red


# results and ranking
allResults = np.transpose(np.zeros(a*b*4).reshape((4,a*b)))
allResults[::,0] = allDimsX_noncomp_red[::,0]
allResults[::,1] = np.round(allDimsX_noncomp_red[::,3]/allDimsX_comp_red[::,3],3)
allResults[::,2] = allDimsX_noncomp_red[::,1]
allResults[::,3] = allDimsX_noncomp_red[::,2]

 
###############################################################################
# 4. Interrim Data export                                                     #
###############################################################################   

fmt = "\t".join(["%s"] + ["%10.3e"] * (allDimsX_noncomp_red.shape[1]-1))
np.savetxt("non-competitive_spots.txt", allDimsX_noncomp_red, fmt=fmt, header=
"source directory of the raw data: " +"\n"+
"\n"+
"     " +     source_dir + "\n" +
"\n"+
"\n"+
"array parameters: "  "\n" +
"\n"+
"     rows in x-direction = " + str(a) + "\n"+
"     columns y-direction = " + str(b) + "\n"+
"     spot to spot distance in x-direction = " + str(deltaX) + "\n"+
"     spot to spot distance in y-direction = " + str(deltaY) + "\n"+
"\n"+
"\n"+
"array specific data: "  "\n" +
"\n"+
"     rectangular halfwidth of the ROI = " + str(c) + "\n"+
"     percentage of trimmed pixels for the mean = " + str(d) + "\n"+
"\n"+
"\n"+
"file specific data: "  "\n" +
"\n"+
"     name of the imported non-competitive data file = " + str(filenameNoncomp) + "\n"+
"     x0 of the non-comp array= " + str(cordX_noncomp) + "\n"+
"     y0 of the non-comp array= " + str(cordY_noncomp) + "\n"+
"\n"+
"     name of the imported competitive data file = " + str(filenameComp) + "\n"+
"     x0 of the comp array = " + str(cordX_comp) + "\n"+
"     y0 of the comp array= " + str(cordY_comp) + "\n"+
"\n"+
"\n"+
"Columns: "  "\n" +
"     1: spot number " + "\n" +
"     2: y-coordinate of the spot center (pixels)" "\n" +
"     3: x-coordinate of the spot center (pixels)" "\n" +
"     4: intenisty of the spot " "\n" 
           , comments='')


fmt = "\t".join(["%s"] + ["%10.3e"] * (allDimsX_comp_red.shape[1]-1))
np.savetxt("competitive_spots.txt", allDimsX_comp_red, fmt=fmt, header=
"source directory of the raw data: " +"\n"+
"source directory of the raw data: " +"\n"+
"\n"+
"     " +     source_dir + "\n" +
"\n"+
"\n"+
"array parameters: "  "\n" +
"\n"+
"     rows in x-direction = " + str(a) + "\n"+
"     columns y-direction = " + str(b) + "\n"+
"     spot to spot distance in x-direction = " + str(deltaX) + "\n"+
"     spot to spot distance in y-direction = " + str(deltaY) + "\n"+
"\n"+
"\n"+
"array specific data: "  "\n" +
"\n"+
"     rectangular halfwidth of the ROI = " + str(c) + "\n"+
"     percentage of trimmed pixels for the mean = " + str(d) + "\n"+
"\n"+
"\n"+
"file specific data: "  "\n" +
"\n"+
"     name of the imported non-competitive data file = " + str(filenameNoncomp) + "\n"+
"     x0 of the non-comp array= " + str(cordX_noncomp) + "\n"+
"     y0 of the non-comp array= " + str(cordY_noncomp) + "\n"+
"\n"+
"     name of the imported competitive data file = " + str(filenameComp) + "\n"+
"     x0 of the comp array = " + str(cordX_comp) + "\n"+
"     y0 of the comp array= " + str(cordY_comp) + "\n"+
"\n"+
"\n"+
"Columns: "  "\n" +
"     1: spot number " + "\n" +
"     2: y-coordinate of the spot center (pixels) " "\n" +
"     3: x-coordinate of the spot center (pixels)" "\n" +
"     4: intenisty of the spot " "\n" 
           , comments='')




# results
fmt = "\t".join(["%s"] + ["%10.3e"] * (allResults.shape[1]-1))
np.savetxt("results_and_position.txt", allResults, fmt=fmt, header=
"source directory of the raw data: " +"\n"+
"\n"+
"     " +     source_dir + "\n" +
"\n"+
"\n"+
"array parameters: "  "\n" +
"\n"+
"     rows in x-direction = " + str(a) + "\n"+
"     columns y-direction = " + str(b) + "\n"+
"     spot to spot distance in x-direction = " + str(deltaX) + "\n"+
"     spot to spot distance in y-direction = " + str(deltaY) + "\n"+
"\n"+
"\n"+
"array specific data: "  "\n" +
"\n"+
"     rectangular halfwidth of the ROI = " + str(c) + "\n"+
"     percentage of trimmed pixels for the mean = " + str(d) + "\n"+
"\n"+
"\n"+
"file specific data: "  "\n" +
"\n"+
"     name of the imported non-competitive data file = " + str(filenameNoncomp) + "\n"+
"     x0 of the non-comp array= " + str(cordX_noncomp) + "\n"+
"     y0 of the non-comp array= " + str(cordY_noncomp) + "\n"+
"\n"+
"     name of the imported competitive data file = " + str(filenameComp) + "\n"+
"     x0 of the comp array = " + str(cordX_comp) + "\n"+
"     y0 of the comp array= " + str(cordY_comp) + "\n"+
"\n"+
"\n"+
"columns: "  "\n" +
"     1: spot number " + "\n" +
"     2: intensity quotient of the spot " "\n" +
"     3: y-coordinate of the spot center (pixels)" "\n" +
"     4: x-coordinate of the spot center (pixels)" "\n" 
           , comments='')





print("The evaluation of the non-competitive screening was saved as competitive_spots.txt, the evaluation of the competitive screening was saved as competitive_spots.txt and the overall results were saved as results_and_position.txt in the " + source_dir + " folder.")
print("\n")
print("Thank you for choosing our script :)")

# for Q and A martin.paul@bam.de
