%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Project name: 
%
% Simulation of a septic tank with a sidestream slag filter
% mixing of a septic tank effluent with a slag filter effluent at a fixed
% recirculation ratio
% launch file
%
% Code written by Dominique Claveau-Mallet
% Creation: 2018-11-19
% Updated: 2019-10-25
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Experimental data, sample point Inf S, t = 266 d

pH = 7.52;
oPO4 = 2.52; % Ortho-phosphates (mg P/L)
Ca = 193; % Calcium (mg/L)
DIC = 96; % Dissolved inorganic carbon (mg/L)

% numerical
parm.database_path = 'C:\Program Files (x86)\USGS\Phreeqc Interactive 3.3.8-11728\database\phreeqc.dat';

% influent properties
parm.inf = {'KH2PO4' 0.001*0.5*oPO4/31;'K2HPO4' 0.001*0.5*oPO4/31; ...
    'CaCl2' 0.001*Ca/40; 'NaHCO3' 0.001*DIC/12; ...
    'HCl' 0.00034; 'NaOH' 0}; % a small amount of HCl or NaOH is used for pH calibration 
parm.inf_equ = {'Calcite' 0 0; 'Hydroxyapatite' 0 0};

% solubility products
model.KspCAL = -7.144;
model.KspHAP_HO = -46;

% septic tank 
model.CO2 = 0;

% slag filter
model.CaO = 0.0053; % simplified slag dissolution reaction
parm.rec = 0.75; % recirculation ratio

%%% Simulation of the septic tank

[F,output] = PHREEQCfct_septictankwithslag(parm,model);
