#define check_err(ierr) if(ierr.lt.0) print *,"Bad return value in ",__FILE__," line ",__LINE__," ierr = ",ierr

subroutine h5_prelim(xh,xf,yh,yf,zh,zf,pi0,th0,prs0,rho0,qv0,u0,v0)
    use ISO_C_BINDING !Why again??
    implicit none

    real, dimension(ib:ie),   intent(in) :: xh
    real, dimension(ib:ie+1), intent(in) :: xf
    real, dimension(jb:je),   intent(in) :: yh
    real, dimension(jb:je+1), intent(in) :: yf
    real, dimension(ib:ie,jb:je,kb:ke), intent(in) :: zh,pi0,prs0,rho0,th0,qv0
    real, dimension(ib:ie+1,jb:je,kb:ke), intent(in) :: u0
    real, dimension(ib:ie,jb:je+1,kb:ke), intent(in) :: v0
    real, dimension(ib:ie,jb:je,kb:ke+1) :: zf

    integer itime
    character(len=padtimeint), save :: fileindexname,totalindexname
    character(len=floatstringlen) :: floatindexname
    logical backing_store
    logical wr3d_once !ORF IWRITE3D
    integer(HID_T) plist_id,fcpl_id
    integer(HSIZE_T), DIMENSION(1) :: dims,count
    integer(HSSIZE_T), DIMENSION(1) :: offset

    integer info

    character(LEN=4),  parameter :: grid_group_name = 'grid' !for 3D files
    character(LEN=4),  parameter :: mesh_group_name = 'mesh' !for 3D files
    character(LEN=9),  parameter :: basestate_group_name = 'basestate' !for 3D files
    character(LEN=11), parameter :: threed_basestate_group_name = '3Dbasestate' !for 3D files
    character(LEN=2),  parameter :: twod_group_name = '2D'         !for 3D files
    character(LEN=5),  parameter :: twod_swath_group_name = 'swath'         !for 3D files
    character(LEN=6),  parameter :: twod_static_group_name = 'static'         !for 3D files
    character(LEN=6),  parameter :: twodfull_group_name = '2Dfull' !for 2D files
    character(LEN=2),  parameter :: threed_group_name = '3D'       !for 3D files

! ORF 6/2/12 for now ignore extra stagger point
    real, dimension(1:myMCMni) :: xhMCM
    real, dimension(1:myMCMni) :: xfMCM !+1
    real, dimension(1:myMCMnj) :: yhMCM
    real, dimension(1:myMCMnj) :: yfMCM !+1

!   if(dowr) then 
!       write(outfile,*) "  Beginning history file output cycle..."
!       call FFLUSH(outfile)
!   endif

102 format(i5.5)
103 format(f0.7)

! Sticking with floating point and hoping for the best

! We write our file when file is closed
    backing_store = .true.

!   blocksize is set above to 512 MB 

1720 format("Flushing LOFS data to disk at t = ",f9.3)
1729 format("New (empty) LOFS files created on disk at t = ",f9.3)
1730 format("Done flushing LOFS data to disk at t = ",f9.3)

!print *,myid,"PRELIM: iamio = ",iamio,"wr3d = ",wr3d,"iwrite3d = ",iwrite3d, "firstvisit = ",firstvisit, "newcycle = ",newcycle

    iamwriting3d: if (iamio.and.wr3d.and.iwrite3d) then
        firstvis: if (firstvisit) then
            i3d_time_index = 0
!           wr3dindex = 0
! not for restarts!
            threedbytes = 0

            write(fileindexname,102)i3d_time_index
!           write(totalindexname,102)wr3dindex
            write(floatindexname,103)iotime
            call h5_file_op(op_mk3dfilename,iotime)
            CALL h5pcreate_f(H5P_FILE_ACCESS_F, plist_id, ierr); check_err(ierr)
            CALL h5pset_fclose_degree_f(plist_id, H5F_CLOSE_SEMI_F, ierr); check_err(ierr)
            CALL h5pset_fapl_core_f(plist_id, blocksize, backing_store, ierr); check_err(ierr)

            call h5pcreate_f(H5P_FILE_CREATE_F,fcpl_id,ierr);check_err(ierr)
            call h5Pset_userblock_f(fcpl_id,userblock_size,ierr);check_err(ierr) !ORF we will stick namelist.input and other useful things here

            call h5fcreate_f(trim(filename),H5F_ACC_TRUNC_F,file_3d_id,ierr,creation_prp=fcpl_id,access_prp=plist_id);check_err(ierr)
            CALL h5pclose_f(fcpl_id, ierr); check_err(ierr)
            CALL h5pclose_f(plist_id, ierr); check_err(ierr)
            if(iprintinfo) write(6,1729) iotime
            if(iprintinfo) call FFLUSH(6)
    
            call h5gcreate_f(file_3d_id,grid_group_name,grid_group_id,ierr); check_err(ierr)
            if(ierr.lt.0) then
                  if(myid.eq.0)print *, file_3d_id,grid_group_name,grid_group_id
                  call stopcm1
            endif
            call h5gcreate_f(file_3d_id,mesh_group_name,mesh_group_id,ierr); check_err(ierr)
            call h5gcreate_f(file_3d_id,basestate_group_name,basestate_group_id,ierr); check_err(ierr)
            call h5gcreate_f(file_3d_id,threed_basestate_group_name,threed_basestate_group_id,ierr); check_err(ierr)
        
            call h5gcreate_f(file_3d_id,fileindexname,fileindex_group_id,ierr) !Our 2d and 3d fields are inside the index group now
            call h5gcreate_f(fileindex_group_id,twod_group_name,twod_group_id,ierr); check_err(ierr)
            call h5gcreate_f(twod_group_id,twod_swath_group_name,twod_swath_group_id,ierr); check_err(ierr) !added swaths
            call h5gcreate_f(twod_group_id,twod_static_group_name,twod_static_group_id,ierr); check_err(ierr) !added static 2d
            call h5gcreate_f(fileindex_group_id,threed_group_name,threed_group_id,ierr) ; check_err(ierr)
            call h5lcreate_soft_f(fileindexname,file_3d_id,trim(floatindexname),ierr);check_err(ierr)
        else if (newcycle) then
            call h5gclose_f(grid_group_id,ierr); check_err(ierr)
            call h5gclose_f(mesh_group_id,ierr); check_err(ierr)
            call h5gclose_f(basestate_group_id,ierr); check_err(ierr)
            call h5gclose_f(threed_basestate_group_id,ierr); check_err(ierr)
            call h5gclose_f(twod_static_group_id,ierr); check_err(ierr)
            call h5gclose_f(twod_swath_group_id,ierr); check_err(ierr)
            call h5gclose_f(twod_group_id,ierr); check_err(ierr)
            call h5gclose_f(threed_group_id,ierr); check_err(ierr)
            call h5gclose_f(fileindex_group_id,ierr); check_err(ierr)
            if(iprintinfo) write(*,1720)iotime
            if(iprintinfo) call FFLUSH(6)
            call h5fclose_f(file_3d_id,ierr); check_err(ierr) !Everything should get flushed to disk here
            if(iprintinfo) write(*,1730)iotime
            if(iprintinfo) call FFLUSH(6)

            i3d_time_index = 0
            wr3dindex = wr3dindex + 1
            write(fileindexname,102)i3d_time_index
!           write(totalindexname,102)wr3dindex
            write(floatindexname,103)iotime
            call h5_file_op(op_mk3dfilename,iotime)
            CALL h5pcreate_f(H5P_FILE_ACCESS_F, plist_id, ierr); check_err(ierr)
            call h5pcreate_f(H5P_FILE_CREATE_F,fcpl_id,ierr);check_err(ierr)
            call h5Pset_userblock_f(fcpl_id,userblock_size,ierr);check_err(ierr) !ORF we will stick namelist.input and other useful things here
            CALL h5pset_fclose_degree_f(plist_id, H5F_CLOSE_SEMI_F, ierr); check_err(ierr)
            CALL h5pset_fapl_core_f(plist_id, blocksize, backing_store, ierr); check_err(ierr)
            if(iprintinfo) write(6,1729) iotime
            if(iprintinfo) call FFLUSH(6)

            call h5fcreate_f(trim(filename),H5F_ACC_TRUNC_F,file_3d_id,ierr,creation_prp=fcpl_id,access_prp=plist_id);check_err(ierr)
            CALL h5pclose_f(fcpl_id, ierr); check_err(ierr)
            CALL h5pclose_f(plist_id, ierr); check_err(ierr)
            threedbytes = 0

            call h5gcreate_f(file_3d_id,grid_group_name,grid_group_id,ierr); check_err(ierr)
            call h5gcreate_f(file_3d_id,mesh_group_name,mesh_group_id,ierr); check_err(ierr)
            call h5gcreate_f(file_3d_id,basestate_group_name,basestate_group_id,ierr); check_err(ierr)
            call h5gcreate_f(file_3d_id,threed_basestate_group_name,threed_basestate_group_id,ierr); check_err(ierr)
            call h5gcreate_f(file_3d_id,fileindexname,fileindex_group_id,ierr);check_err(ierr)
!           if(fileindexname.ne.totalindexname) then
!               call h5lcreate_soft_f(fileindexname,file_3d_id,totalindexname,ierr);check_err(ierr)
!           endif
            call h5lcreate_soft_f(fileindexname,file_3d_id,trim(floatindexname),ierr);check_err(ierr)
            call h5gcreate_f(fileindex_group_id,twod_group_name,twod_group_id,ierr);check_err(ierr)
            call h5gcreate_f(twod_group_id,twod_swath_group_name,twod_swath_group_id,ierr); check_err(ierr) !added swaths
            call h5gcreate_f(twod_group_id,twod_static_group_name,twod_static_group_id,ierr); check_err(ierr) !added static 2d
            call h5gcreate_f(fileindex_group_id,threed_group_name,threed_group_id,ierr); check_err(ierr)
        else !Close current time group, open next one
            call h5gclose_f(twod_static_group_id,ierr); check_err(ierr)
            call h5gclose_f(twod_swath_group_id,ierr); check_err(ierr)
            call h5gclose_f(twod_group_id,ierr); check_err(ierr)
            call h5gclose_f(threed_group_id,ierr); check_err(ierr)
            call h5gclose_f(fileindex_group_id,ierr); check_err(ierr)
            i3d_time_index = i3d_time_index + 1
            wr3dindex = wr3dindex + 1
            write(fileindexname,102)i3d_time_index
!           write(totalindexname,102)wr3dindex
            write(floatindexname,103)iotime
            call h5gcreate_f(file_3d_id,fileindexname,fileindex_group_id,ierr); check_err(ierr)
!           if(fileindexname.ne.totalindexname) then
!               call h5lcreate_soft_f(fileindexname,file_3d_id,totalindexname,ierr);check_err(ierr)
!           endif
            call h5lcreate_soft_f(fileindexname,file_3d_id,trim(floatindexname),ierr);check_err(ierr)
            call h5gcreate_f(fileindex_group_id,twod_group_name,twod_group_id,ierr); check_err(ierr)
            call h5gcreate_f(twod_group_id,twod_swath_group_name,twod_swath_group_id,ierr); check_err(ierr) !added swaths
            call h5gcreate_f(twod_group_id,twod_static_group_name,twod_static_group_id,ierr); check_err(ierr) !added static 2d
            call h5gcreate_f(fileindex_group_id,threed_group_name,threed_group_id,ierr); check_err(ierr)
        endif firstvis

!       call writetimeindex_unlimited(file_3d_id,i3d_time_index,itime)
        call writetimeindex_unlimited(file_3d_id,i3d_time_index,iotime)
! ORF not sure where the different name came from
!       call writetime_unlimited(file_3d_id,i3d_time_index,itime)

    endif iamwriting3d


!ORF probably a good idea because some nodes will take a lot longer to flush, we have to sync eventually
    if (newcycle) then
          call mpi_barrier(MPI_COMM_CM1,ierr)
          check_err(ierr)
    endif

! ORF IWRITE3D 
! declare new boolean: wr3d_once = (iamio.and.wr3d.and.iwrite3d.and.(firstvisit.or.newcycle))

    wr3d_once=(iamio.and.wr3d.and.iwrite3d.and.(firstvisit.or.newcycle))

    varname='dx'
    description='grid spacing in the x direction. If E/W grid stretching, this should be somehwat representative'
    units='meters'
    if (wr3d_once) call h5_write_val_iamio(mesh_group_id,floatval=dx)

    varname='dy'
    description='grid spacing in the y direction. If N/S grid stretching, this should be somehwat representative'
    units='meters'
    if (wr3d_once) call h5_write_val_iamio(mesh_group_id,floatval=dy)

    varname='dz'
    description='grid spacing in the z direction. If grid stretching, this should be somehwat representative'
    units='meters'
    if (wr3d_once) call h5_write_val_iamio(mesh_group_id,floatval=dz)


    varname='nx'
    description='number of gridpoints spanning the east/west direction of full the model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=nx)

    varname='ny'
    description='number of gridpoints spanning the north/south direction of full the model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=ny)

    varname='nz'
    description='number of gridpoints spanning the vertical extent of the full the model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=nz)

    varname='x0'
    description='index of westmost point of 3d field in this hdf5 file with respect to full model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=myMCMx0)

    varname='x1'
    description='index of eastmost point of 3d field in this hdf5 file with respect to full model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=myMCMx1)

    varname='y0'
    description='index of southmost point of 3d field in this hdf5 file with respect to full model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=myMCMy0)

    varname='y1'
    description='index of northmost point of 3d field in this hdf5 file with respect to full model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=myMCMy1)

    varname='nkwrite_val'
    description='In cases where we do not save the full vertical domain, this is the top index'
    units='index'
    if (wr3d_once.and..not.save_full_vertical_extent) call h5_write_val_iamio  (grid_group_id,intval=nkwrite_val)

!ORF TODO save z0 and z1 here. This should match what is actually saved.
! At least saved z1.... or nkwrite_val... whatever you want to call it...
! We can probably safely assume that under normal circumstances we do want to
! save from z0=0 - but maybe someday we want to save only cloud tops or
! whatever?

    varname='umove'
    description='box motion in x direction (subtracted off the sounding)'
    units='meters per second'
    if (wr3d_once) call h5_write_val_iamio(mesh_group_id,floatval=umove)

    varname='vmove'
    description='box motion in y direction (subtracted off the sounding)'
    units='meters per second'
    if (wr3d_once) call h5_write_val_iamio(mesh_group_id,floatval=vmove)

    varname='myi'
    description='east/west index of hdf5 file in 2d decomposition. (1 < myi <= nodex)'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=MCMi)

    varname='myj'
    description='north/south index of hdf5 file in 2d decomposition. (1 < myj <= nodej)'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=MCMj)

    varname='ni'
    description='number of gridpoints in east/west direction in this hdf5 file for 2d and 3d data'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=myMCMni)

    varname='nj'
    description='number of gridpoints in north/south direction in this hdf5 file for 2d and 3d data'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=myMCMnj)

    varname='nodex'
    description='number of hdf5 files spanning the full east/west extent of the model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=MCMnx)

    varname='nodey'
    description='number of hdf5 files spanning the full north/south extent of the model domain'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=MCMny)

    varname='corex'
    description='number of cores in the x direction on a node'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=corex)

    varname='corey'
    description='number of cores in the y direction on a node'
    units='index'
    if (wr3d_once) call h5_write_val_iamio  (grid_group_id,intval=corey)

! ORF Note: base state 1d arrays assume no terrain such that any vertical column anywhere in domain could be used

    varname='u0'
    description='U (E/W wind) base state, (i.e., from sounding)'
    units='m/s'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(basestate_group_id,u0(1,1,1:nz),nz,dims,count,offset)

    varname='v0'
    description='V (N/S wind) base state, (i.e., from sounding)'
    units='m/s'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(basestate_group_id,v0(1,1,1:nz),nz,dims,count,offset)

    varname='pres0'
    description='Pressure base state, (i.e., from sounding)'
    units='dimensionless'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(basestate_group_id,prs0(1,1,1:nz),nz,dims,count,offset)

    varname='pi0'
    description='Exner base state, (i.e., from sounding)'
    units='dimensionless'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(basestate_group_id,pi0(1,1,1:nz),nz,dims,count,offset)
    
    varname='th0'
    description='potential temperature base state, (i.e., from sounding)'
    units='K'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(basestate_group_id,th0(1,1,1:nz),nz,dims,count,offset)

    varname='rh0'
    description='density base state, (i.e., from sounding)'
    units='kg/m^3'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(basestate_group_id,rho0(1,1,1:nz),nz,dims,count,offset)

    varname='qv0'
    description='mixing ratio base state, (i.e., from sounding)'
    units='kg/kg'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(basestate_group_id,qv0(1,1,1:nz),nz,dims,count,offset)

    varname='zh'
    description='height AGL of scalars'
    units='m'
    dims(1)=nz;count(1)=nz;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(mesh_group_id,zh(1,1,1:nz),nz,dims,count,offset)

    varname='zf'
    description='height AGL of w (on staggered C grid)'
    units='m'
    dims(1)=nz+1;count(1)=nz+1;offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(mesh_group_id,zf(1,1,1:nz+1),nz+1,dims,count,offset)

!ORF iwrite3d just added here (these are different; 3d files containing global
!1d arrays)
    varname='yh'
    description='N/S location of scalar points (model uses Arakawa C grid)'
    units='meters'
    if (wr3d.and.(newcycle.or.firstvisit)) then
        if (myMCMlyrank.ne.MPI_UNDEFINED) then;call MPI_Gather (yh(1:nj),nj,MPI_REAL,yhMCM,nj,MPI_REAL,0,myMCMlycomm,ierr);check_err(ierr);endif
        dims(1)=myMCMnj; count(1)=myMCMnj; offset(1)=0
        if(iamio.and.iwrite3d)call h5_write_1d_float_iamio(mesh_group_id,   yhMCM,myMCMnj,dims,count,offset)
    endif

! ORF 6/2/12 for now ignore extra point in arrays with u, v extra staggered point

    varname='yf'
    description='N/S location of V points (model uses Arakawa C grid)'
    units='meters'
    if (wr3d.and.(newcycle.or.firstvisit)) then
        if (myMCMlyrank.ne.MPI_UNDEFINED) then;call MPI_Gather (yf(1:nj),nj,MPI_REAL,yfMCM,nj,MPI_REAL,0,myMCMlycomm,ierr);check_err(ierr);endif
        dims(1)=myMCMnj; count(1)=myMCMnj; offset(1)=0
        if(iamio.and.iwrite3d)call h5_write_1d_float_iamio(mesh_group_id,   yfMCM,myMCMnj,dims,count,offset)
    endif


    varname='xh'
    description='E/W location of scalar points (model uses Arakawa C grid)'
    units='meters'
    if (wr3d.and.(newcycle.or.firstvisit)) then
        if (myMCMbxrank.ne.MPI_UNDEFINED) then;call MPI_Gather (xh(1:ni),ni,MPI_REAL,xhMCM,ni,MPI_REAL,0,myMCMbxcomm,ierr);check_err(ierr);endif
        dims(1)=myMCMni; count(1)=myMCMni; offset(1)=0
        if(iamio.and.iwrite3d)call h5_write_1d_float_iamio(mesh_group_id,   xhMCM,myMCMni,dims,count,offset)
    endif

    varname='xf'
    description='E/W location of U points (model uses Arakawa C grid)'
    units='meters'
    if (wr3d.and.(newcycle.or.firstvisit)) then
        if (myMCMbxrank.ne.MPI_UNDEFINED) then;call MPI_Gather (xf(1:ni),ni,MPI_REAL,xfMCM,ni,MPI_REAL,0,myMCMbxcomm,ierr);check_err(ierr);endif
        dims(1)=myMCMni; count(1)=myMCMni; offset(1)=0
        if(iamio.and.iwrite3d)call h5_write_1d_float_iamio(mesh_group_id,   xfMCM,myMCMni,dims,count,offset)
    endif

! ORF write full mesh to 3d files for VisIt

    varname='yhfull'
    description='N/S location of scalar points for full domain (model uses Arakawa C grid)'
    units='meters'
    dims(1)=ny; count(1)=ny; offset(1)=0

    if (wr3d_once) call h5_write_1d_float_iamio(mesh_group_id,yhfull(1:ny),ny,dims,count,offset)

    varname='xhfull'
    description='E/W location of scalar points for full domain (model uses Arakawa C grid)'
    units='meters'
    dims(1)=nx; count(1)=nx; offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(mesh_group_id,xhfull(1:nx),nx,dims,count,offset)

    varname='yffull'
    description='N/S location of v points for full domain (model uses Arakawa C grid)'
    units='meters'
    dims(1)=ny+1; count(1)=ny+1; offset(1)=0

    if (wr3d_once) call h5_write_1d_float_iamio(mesh_group_id,yffull(1:ny+1),ny+1,dims,count,offset)

    varname='xffull'
    description='E/W location of u points for full domain (model uses Arakawa C grid)'
    units='meters'
    dims(1)=nx+1; count(1)=nx+1; offset(1)=0
    if (wr3d_once) call h5_write_1d_float_iamio(mesh_group_id,xffull(1:nx+1),nx+1,dims,count,offset)

end subroutine h5_prelim
