/*****************************************************************************
*
* Copyright (c) 2000 - 2012, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                            avtcm1visitFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_CM1VISIT_FILE_FORMAT_H
#define AVT_CM1VISIT_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <vector>

#ifdef PARALLEL
#include <mpi.h>
#include <avtParallel.h>
#endif

// ****************************************************************************
//  Class: avtcm1visitFileFormat
//
//  Purpose:
//      Reads in a cm1visit file as a plugin to VisIt.
//      This file is generated by the makevisit tool, which is part of
//      cm1tools, which is a directory in this directory. The .cm1visit
//      file is a small hdf5 file which contains all of the necessary
//      metadata and mesh data that is found in the actual .cm1hdf5
//      files written by CM1, and accessed via the cm1tools API (see
//      GetVar).
//
//  Programmer: Leigh Orf and Roberto Sisneros -- generated by xml2avt
//  Creation:   Mon Aug 13 14:27:50 PST 2012
//
// ****************************************************************************

class avtcm1visitFileFormat : public avtMTMDFileFormat
{
  public:
                       avtcm1visitFileFormat(const char *);
    virtual           ~avtcm1visitFileFormat() {;};

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, int timestep, 
    //                                     int domain, const char *type, void *args, 
    //                                     DestructorFunction &);
    //

    //
    // If you know the times and cycle numbers, overload this function.
    // Otherwise, VisIt will make up some reasonable ones for you.
    //
    virtual void        GetCycles(std::vector<int> &);
    virtual bool        ReturnsValidTime() const { return true; }
    virtual void        GetTimes(std::vector<double> &);
    //

    virtual int            GetNTimesteps(void);

    virtual const char    *GetType(void)   { return "cm1visit"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

  protected:
    // DATA MEMBERS
    std::string                             td;
    char *firstfilename;
    char topdir[512];
    int dn; 
    char **timedir; 
    char **nodedir;
// ORF: 2017-1-25 these are now double
//  int *dirtimes,*alltimes
    double *dirtimes,*alltimes;
    int ntottimes;
    char varname[100][40]; // 100 vars 40 chars long
    int nvars;
    int ntimedirs;
    int nx,ny,nz,nodex,nodey,nodex_cm1,nodey_cm1;
    int sizex, sizey, sizez;
    int snx0, snx1, sny0, sny1, snz0, snz1;
    float *xhfull,*yhfull, *zh;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
};


#endif
