#!/usr/bin/perl -w
# The above path of perl program must be correct.

########################################################################################################
# Copyright Notice and Disclaimer 
#
# Copyright (c) 2018, Ottawa Research and Development Centre, Agriculture and Agri-Food Canada.
#
# Authors: Dr. Frank M. You
# E mail:  frank.you@canada.ca

########################################################################################################
# This is a pipeline to check the uniqness of paired primers and mapp PCR primers to the specified 
# genome sequence.
# Input:  (1) primer sequences with four columns sperated by a tab
#         (2) genome hash file: this is a hash file generated by 'famap' and 'fahash' commands which are 
#             implemented in the pipeline ProgramS1_prepare_rePCR_data.pl
#	  (3) number of mismatches (exact match: 0)
#         (4) number of gaps: (exact match:0)

########################################################################################################

use warnings;
use strict;
use Getopt::Std;

use vars qw ($opt_p $opt_d $opt_m $opt_g $opt_t $opt_c);
getopts ('p:d:m:g:t:c:');

my $primer_file    = $opt_p;
my $genome_hash    = $opt_d;
my $mismatches     = $opt_m ? $opt_m : 0;
my $gaps	   = $opt_g ? $opt_g : 0;

if (!$primer_file || !$genome_hash ) {
    print "Usage: \n";
    print "perl $0 \n";
    print "     -p primer file (required)\n";   
    print "     -d reference genome hash file (required, generated from ProgramS1_prepare_rePCR_data.pl, both *.famap and *.hash must be available)\n";
    print "     -m number of mismatches (default: 0)\n";
    print "     -g number of gaps (default: 0)\n";
    
    exit;
}


########################################################################################################
# You may need to modify the following variables to correct installation of re-PCR.
# 
my $REPCR_EXE =  './re-PCR';     

&process_reverse_ePCR($primer_file, $genome_hash, $mismatches, $gaps);


###################### the end of the main program ##########################

# process user input and pick primers for all types of primers
sub process_reverse_ePCR {
    my ($primer_file, $genome_hash, $mismatches, $gaps) = @_;
    my $start_time = time();

    #Perform ePCR
    my $result_file = $primer_file . "_primer_rePCR_results.txt";
    
    &run_rePCR($genome_hash, $mismatches, $gaps, $primer_file, $result_file);

}
    

sub run_rePCR{
    my ($genome_hash_file, $mismatches, $gaps, $primer_sts_file, $result_file) = @_;
    print "Perform reverse ePCR...\n";
    my $cmd = "re-PCR -S $genome_hash_file -n$mismatches -g$gaps -o $result_file $primer_sts_file";
    print "$cmd\n";
    system $cmd;
}


