package cht.iot.mobilelogger.info;

import android.Manifest;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.telephony.CellIdentityCdma;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoWcdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.NeighboringCellInfo;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.widget.Toast;

import java.util.List;

import cht.iot.mobilelogger.MainActivity;
import cht.iot.mobilelogger.io.ReadWriteFile;

public class LteCellInfo {
	private Context context;

	private TelephonyManager telephonyManager;
	private ReadWriteFile readWriteFile;

	public GsmCellLocation cellLocation;
	public List<NeighboringCellInfo> NeighboringList;

	private int count;
	private String dateTime;
	public String networkOperator = "", mcc = "-1", mnc = "-1";
	public int cid = 0, lac = 0, rssi = 0;

	private static final int LOCATION_PERMISSIONS_REQUEST = 100;

	public LteCellInfo(Context context, TelephonyManager telephonyManager, ReadWriteFile readWriteFile) {
		this.context = context;
		this.telephonyManager = telephonyManager;
		this.readWriteFile = readWriteFile;

		String content = "Index\tDateTime\tLAC\tCellID\tRSSI\n";
		this.readWriteFile.writeFile(content);

		try {
			networkOperator = telephonyManager.getNetworkOperator();
			mcc = networkOperator.substring(0, 3);
			mnc = networkOperator.substring(3);
		} catch (Exception e) {
			networkOperator = "";
			mcc = "-1";
			mnc = "-1";
		}
	}

	public void getCellInfo(int count, String dateTime) {
		checkPermission();
		List<CellInfo> infos = this.telephonyManager.getAllCellInfo();

		for (int i = 0; i<infos.size(); ++i) {
			try {
				CellInfo info = infos.get(i);
				if (info instanceof CellInfoGsm){
					CellSignalStrengthGsm gsm = ((CellInfoGsm) info).getCellSignalStrength();
					CellIdentityGsm identityGsm = ((CellInfoGsm) info).getCellIdentity();

					cid = identityGsm.getCid();
					lac = identityGsm.getLac();
					rssi = gsm.getDbm();
				}
				else if (info instanceof CellInfoLte) {
					CellSignalStrengthLte lte = ((CellInfoLte) info).getCellSignalStrength();
					CellIdentityLte identityLte = ((CellInfoLte) info).getCellIdentity();

					cid = identityLte.getCi();
					lac = identityLte.getTac();
					rssi = lte.getDbm();
				}
				else if (info instanceof CellInfoCdma) {
					CellSignalStrengthCdma lte = ((CellInfoCdma) info).getCellSignalStrength();
					CellIdentityCdma identityLte = ((CellInfoCdma) info).getCellIdentity();

					cid = identityLte.getBasestationId();
					lac = identityLte.getNetworkId();
					rssi = lte.getDbm();
				}
				else if (info instanceof CellInfoWcdma) {
					CellSignalStrengthWcdma lte = ((CellInfoWcdma) info).getCellSignalStrength();
					CellIdentityWcdma identityLte = ((CellInfoWcdma) info).getCellIdentity();

					cid = identityLte.getCid();
					lac = identityLte.getPsc();
					rssi = lte.getDbm();
				}
			} catch (Exception ex) {

			}

			String content = count+"\t"+dateTime+"\t"+lac+"\t"+cid+"\t"+rssi+"\n";
			readWriteFile.writeFile(content);
		}
	}

	private void checkPermission(){
		if(ContextCompat.checkSelfPermission(context, android.Manifest.permission.ACCESS_FINE_LOCATION ) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(context, android.Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(context, android.Manifest.permission.ACCESS_WIFI_STATE) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(context, android.Manifest.permission.CHANGE_WIFI_STATE) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(context, android.Manifest.permission.INTERNET) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(context, android.Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(context, android.Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED){

			;
		}
	}
}
