package cht.iot.mobilelogger;

import java.util.Date;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.SensorManager;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import cht.iot.mobilelogger.info.CellInfo;
import cht.iot.mobilelogger.info.GpsInfo;
import cht.iot.mobilelogger.info.LteCellInfo;
import cht.iot.mobilelogger.info.SensorInfo;
import cht.iot.mobilelogger.info.WifiInfo;
import cht.iot.mobilelogger.io.ReadWriteFile;

public class MainActivity extends Activity {
	private GpsInfo gpsInfo;
	private LteCellInfo cellInfo;
	private WifiInfo wifiInfo;
	private SensorInfo sensorInfo;
	
	private ReadWriteFile gpsInfoFile, cellInfoFile, wifiInfoFile, sensorInfoFile;
	
	private TextView mobilInfo;
	private Button startButton, stopButton;
	
	private int count = 0;
	private long sleepCycleTime = 1000;
	private boolean loop = true;

	private static final int LOCATION_PERMISSIONS_REQUEST = 100;

	final Handler UiHandler = new Handler();

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		checkPermission();
		initUI();
	}
	
	@Override
	public void onDestroy(){
		stopMainProgram();
		
		super.onDestroy();
	}
	
	private void initUI(){
		mobilInfo = (TextView) findViewById(R.id.mobilInfo);
		startButton = (Button) findViewById(R.id.startButton);
		stopButton = (Button) findViewById(R.id.stopButton);
		
		startButton.setOnClickListener(new Button.OnClickListener(){ 
			@Override
			public void onClick(View arg0) {
				startMainProgram();
			}
		}); 
		stopButton.setOnClickListener(new Button.OnClickListener(){ 
			@Override
			public void onClick(View arg0) {
				stopMainProgram();
			}
		});
	}
	
	private void initManager(){
		LocationManager locationManager = (LocationManager) getSystemService(Context.LOCATION_SERVICE);
		TelephonyManager telephonyManager = (TelephonyManager) getSystemService(Context.TELEPHONY_SERVICE);
		WifiManager wifiManager = (WifiManager) getApplicationContext().getSystemService(Context.WIFI_SERVICE);
		SensorManager sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
		
		gpsInfo = new GpsInfo(locationManager, gpsInfoFile);
		cellInfo = new LteCellInfo(this, telephonyManager, cellInfoFile);
		wifiInfo = new WifiInfo(wifiManager, wifiInfoFile);
		sensorInfo = new SensorInfo(sensorManager, sensorInfoFile);
	}
	
	private void startMainProgram(){
		String fileName = getDateTime();
		gpsInfoFile = new ReadWriteFile("mobileInfo/"+fileName, "gpsInfo");
		cellInfoFile = new ReadWriteFile("mobileInfo/"+fileName, "cellInfo");
		wifiInfoFile = new ReadWriteFile("mobileInfo/"+fileName, "wifiInfo");
		sensorInfoFile = new ReadWriteFile("mobileInfo/"+fileName, "sensorInfo");
		
		initManager();
		
		loop = true;
		MobileInfoUpdateThread mobileInfoUpdateThread = new MobileInfoUpdateThread();
		mobileInfoUpdateThread.start();
	}
	
	private void stopMainProgram(){
		mobilInfo.setText("已停止收集行動資料");
		
		try{
			loop = false;
			gpsInfo.removeUpdates();
			sensorInfo.removeUpdates();
		}
		catch(Exception e){
		}
	}
	
	private String getDateTime(){
		Date now = new java.util.Date();
		return new java.text.SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(now);
	}
	
	final Runnable MobileInfoUpdateResults = new Runnable() {
		public void run() {
			count++;
			Log.d("MobileInfoCounter", ""+count);
			
			String dateTime = getDateTime();
			gpsInfo.getLocationInfo(count, dateTime);
			cellInfo.getCellInfo(count, dateTime);
			wifiInfo.getWifiInfo(count, dateTime);
			sensorInfo.getSensorInfo(count, dateTime);
			
			mobilInfo.setText("正在收集行動資料\nLat: "+gpsInfo.lat+", Lon: "+gpsInfo.lon+", Speed: "+gpsInfo.speed+", Cell Id: "+cellInfo.cid+", RSSI: "+cellInfo.rssi);
		}
	};
	
	class MobileInfoUpdateThread extends Thread{
		
		public MobileInfoUpdateThread(){
		}
		public void run(){
			while(loop){
	    		try {
	    			UiHandler.post(MobileInfoUpdateResults);
					Thread.sleep(sleepCycleTime);
				} catch (Exception e) {
					Log.e("Exception", e.getMessage());
				}
	    	}
		}
	}

	private void checkPermission(){
		if(ContextCompat.checkSelfPermission(this, android.Manifest.permission.ACCESS_FINE_LOCATION ) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(this, android.Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(this, android.Manifest.permission.ACCESS_WIFI_STATE) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(this, android.Manifest.permission.CHANGE_WIFI_STATE) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(this, android.Manifest.permission.INTERNET) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(this, android.Manifest.permission.READ_PHONE_STATE) != PackageManager.PERMISSION_GRANTED &&
				ContextCompat.checkSelfPermission(this, android.Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED){

			ActivityCompat.requestPermissions(
					this,
					new String[] {
							Manifest.permission.ACCESS_WIFI_STATE,
							Manifest.permission.CHANGE_WIFI_STATE,
							Manifest.permission.INTERNET,
							Manifest.permission.READ_PHONE_STATE,
							Manifest.permission.WRITE_EXTERNAL_STORAGE,
							Manifest.permission.ACCESS_FINE_LOCATION,
							Manifest.permission.ACCESS_COARSE_LOCATION},
					LOCATION_PERMISSIONS_REQUEST
			);
		}
	}

	@Override
	public void onRequestPermissionsResult(int requestCode, String permissions[], int[] grantResults) {
		switch (requestCode) {
			case LOCATION_PERMISSIONS_REQUEST: {

			}
		}
	}
}
