x1 = [1, 2, 3];  y1 = [2,3,4];
x2 = [20,30,40]; y2 = [3,4,5];
x3 = [2, 3, 4];  y3 = [600,700,800];
x4 = [4000,5000,6000]; y4 = [7000,8000,9000];
 
% build structs describing the plot traces and assigning data to axes
trace1 = struct('x',x1, 'y',y1);
trace2 = struct('x',x2, 'y',y2, 'xaxis','x2', 'yaxis','y');  % new x-axis but same y-axis as trace1; 'x2' is shorthand for 'xaxis2' below
trace3 = struct('x',x3, 'y',y3, 'xaxis','x',  'yaxis','y3'); % same x-axis as trace 1 but a new y-axis
trace4 = struct('x',x4, 'y',y4, 'xaxis','x4', 'yaxis','y4'); % new x-axis and new y-axis
 
% build a layout struct describing the layout of the different axes
xaxis =  struct('domain', [0, 0.45]); % let the first x-axis span the first 45% of the plot width
yaxis =  struct('domain', [0, 0.45]); % and let the first y-axis span the first 45% of the plot height
xaxis2 = struct('domain', [0.55, 1]); % and let the second axis span the latter 45% of the plot width
yaxis3 = struct('domain', [0.55,1]);
xaxis4 = struct('domain', [0.55, 1], 'anchor','y4'); % anchor axis vertical position to start of yaxis4
yaxis4 = struct('domain', [0.55, 1], 'anchor','x4'); % anchor axis horizontal position to start of xaxis4
layout = struct('xaxis',xaxis, 'yaxis',yaxis, 'xaxis2',xaxis2, 'yaxis3',yaxis3, 'xaxis4',xaxis4, 'yaxis4',yaxis4);
layout.width = 800; % required
layout.height = 650; % required
p = plotlyfig;
p.data = {trace1,trace2,trace3,trace4};
p.layout = layout;
p.PlotOptions.FileName = 'StupidTest';
html_file = plotlyoffline(p);
