function occupyCoeff = genOccupyCoeff(scheduleOccupy,div)
    FIVEMINOFFSET = 0;  % We start at 00:05:00 in EP (5 min after midnight), so there should be one LESS coefficient for this interval.
    occupyCoeff = zeros(24*div,1);          % Should have 24 hrs * 'n' points/hr coefficients.
    divCount = 1;                           % Marker to begin writing in new coefficients into master vector
    for i = 2:size(scheduleOccupy,2)        % Use 2 to avoid referencing index 0
        untilDiv = ones((scheduleOccupy(1,i)-scheduleOccupy(1,i-1))*div-FIVEMINOFFSET,1); % Hourly Time Displacement * points/hr 
        occupyCoeff(divCount:divCount+length(untilDiv)-1) = kron(scheduleOccupy(2,i),untilDiv);
        % Use kron to replicate coefficient length(untilDiv) times, then
        % merge with previous coefficients using the assignment marker
        divCount = divCount + length(untilDiv);  % Marker should be updated AFTER calculation. 
        FIVEMINOFFSET = 0;  % After the very first interval (00:00:00), resume having 12 divs per hour.
    end 
        %hourValues = 1/12:1/12:24;     % For debug testing, make sure times line up.
        %occupyCoeff = [hourValues',occupyCoeff];
end 