% Does plotting for the remaining output variables.
function [NSEWZoneFrames, CoreZoneFrames,AvgReturnFrames,CoilCoolingFrames] ...
        = plotRemainingOutputs(dayLog,thisDay,tbegin,tend,frameNum, ...
        NSEWZoneFrames, CoreZoneFrames,AvgReturnFrames,CoilCoolingFrames,Tset)
    
global hideFigures
hideFigures = 0;
if frameNum > 1
    clf(10),clf(11),clf(12),clf(13)
end 
    
% Local variables (cropped table)

% According to SetpointManager:SingleZone, the return temp 5 zone listings are the same (core, south, east, north, west)
% The Inside facing temperatures are listed in order by the four
% walls: north, south, east, west. 
        
    AvgReturnAirTemp = convtemp(dayLog.(thisDay)(:,11:15),'C','F');    
    Zone1InsideFaceTemp = convtemp(dayLog.(thisDay)(:,16:19),'C','F'); % Zone 1: South
    Zone2InsideFaceTemp = convtemp(dayLog.(thisDay)(:,20:23),'C','F'); % Zone 2: East
    Zone3InsideFaceTemp = convtemp(dayLog.(thisDay)(:,24:27),'C','F'); % Zone 3: North
    Zone4InsideFaceTemp = convtemp(dayLog.(thisDay)(:,28:31),'C','F'); % Zone 4: West
    ZoneCoreInsideFaceTemp = convtemp(dayLog.(thisDay)(:,32:35),'C','F'); % Zone Core
    DXCoilCoolingPower = dayLog.(thisDay)(:,36:40); % Zone Core
    Zone1InsideAdjAirTemp = convtemp(dayLog.(thisDay)(:,41:44),'C','F'); % Zone 1: South
    Zone2InsideAdjAirTemp = convtemp(dayLog.(thisDay)(:,45:48),'C','F'); % Zone 2: East
    Zone3InsideAdjAirTemp = convtemp(dayLog.(thisDay)(:,49:52),'C','F'); % Zone 3: North
    Zone4InsideAdjAirTemp = convtemp(dayLog.(thisDay)(:,53:56),'C','F'); % Zone 4: West
    ZoneCoreInsideAdjAirTemp = convtemp(dayLog.(thisDay)(:,57:60),'C','F'); % Zone Core
    
% Air / Wall Temperatures

    n = 60; interval = [1 1 1 n]; 
    zoneLabels = cellstr(['ZoneSouth';'ZoneEast ';'ZoneNorth';'ZoneWest ';'ZoneCore ']);
    for zoneNum = 1:5
        if zoneNum == 1
            currentFaceZone = Zone1InsideFaceTemp;
            currentAdjAirZone = Zone1InsideAdjAirTemp;
        elseif zoneNum == 2
            currentFaceZone = Zone2InsideFaceTemp;
            currentAdjAirZone = Zone2InsideAdjAirTemp;
        elseif zoneNum == 3
            currentFaceZone = Zone3InsideFaceTemp;
            currentAdjAirZone = Zone3InsideAdjAirTemp;
        elseif zoneNum == 4
            currentFaceZone = Zone4InsideFaceTemp;
            currentAdjAirZone = Zone4InsideAdjAirTemp;
        else
            currentFaceZone = ZoneCoreInsideFaceTemp;
            currentAdjAirZone = ZoneCoreInsideAdjAirTemp;
        end 
        
        figure(10)
        if zoneNum < 5
            subplot(2,2,zoneNum)
        else
            figure(11)  
        end 
        ylim([60,85])
        hold all
        plotDate(currentFaceZone,tbegin,tend,interval,'.-'); ylabel('Degrees F')
        hline = findobj(gcf, 'type', 'line');
        set(hline,'LineWidth',2)
        plotDate(currentAdjAirZone,tbegin,tend,interval,'-.'); ylabel('Degrees F')
        xlabel('Time (5 min sampling)'), %grid on,
       % rotateticklabel(gca);
        title([zoneLabels{zoneNum} ' for ', num2str(Tset),'F']);
        legend('North Wall','South Wall','East Wall','West Wall')
        
        if zoneNum == 4
            drawnow
            set(gcf,'units','normalized','outerposition',[0 0 1 1])
            NSEWZoneFrames(frameNum) = getframe(gcf);
        elseif zoneNum == 5
            drawnow
            set(gcf,'units','normalized','outerposition',[0 0 1 1])
            CoreZoneFrames(frameNum) = getframe(gcf);
        end 
    end 
 
% Avg Return Air Temperatures

    figure(12)
    plotDate(AvgReturnAirTemp(:,1:5),tbegin,tend,interval,'-*'); ylabel('Degrees F')
    xlabel('Time (5 min sampling)'), grid on,
    ylim([60,90])
    rotateticklabel(gca);
    hline = findobj(gcf, 'type', 'line');
    set(hline,'LineWidth',2)
    title(['Average Air Return Temperatures for ', num2str(Tset),'F'])
    legend('Core','South','East','North','West')
    drawnow
    set(gcf,'units','normalized','outerposition',[0 0 1 1])
    AvgReturnFrames(frameNum) = getframe(gcf);
    
% Coil Cooling Power

    figure(13)
    plotDate(DXCoilCoolingPower(:,1:5),tbegin,tend,interval,'-*'); ylabel('Watts')
    ylim([0,14000])
    xlabel('Time (5 min sampling)'), grid on,
    rotateticklabel(gca);
    hline = findobj(gcf, 'type', 'line');
    set(hline,'LineWidth',2)
    title(['Coil Cooling Power for ', num2str(Tset),'F'])
    legend('Core','South','East','North','West')
    
    drawnow
    set(gcf,'units','normalized','outerposition',[0 0 1 1])
    CoilCoolingFrames(frameNum) = getframe(gcf);    
end 


