
function [] = plot5DayTempScript(dayLog)
    global hideFigures
    hideFigures = 0; 
    dontPlot = 0;
    day = 22; 
    logfields = fieldnames(dayLog);
    dayLogCell = struct2cell(dayLog);
    set(0,'DefaultFigureVisible','on')
    figure(5)
    for i = 1:1:length(dayLogCell)
        if length(dayLogCell) == 6
            subplot(3,2,i)
        elseif length(dayLogCell) == 4
            subplot(2,2,i)
        else
            dontPlot = 1;
        end
        tbegin = [num2str(day),'-Jun-2013 00:00:00'];    
        tend = [num2str(day),'-Jun-2013 23:55:00']; 

%         Tamb = dayLogCell{i}(:,4);
%         Tzone = dayLogCell{i}(:,5:9);
%         PHVAC = dayLogCell{i}(:,10);
%         TsetList = dayLogCell{i}(:,1);   % For plotting purposes only
%         TsetList = convtemp(TsetList,'C','F');  Tamb = convtemp(Tamb,'C','F'); 
%         Tzone = convtemp(Tzone,'C','F');
%         CoolingPumpAvailSched = dayLogCell{i}(:,3);
%         
   Tamb = dayLogCell{i}(:,11+1);
                Tzone = dayLogCell{i}(:,11+2:11+6);%end-1);
%                 Tset = [26.158 27.352 30.997 24.373 27.109 21.948 24.233 20.87 33.523 21.712 31.388 28.248 31.082 28.93 23.669 28.548 27.766 23.821 27.442 32.018 26.398 26.805 26.827 24.388 26.027 26.083 24.747 31.206 26.016 27.845 29.375 30.646 28.681 21.959 29.62 30.208 25.112 28.251 22.687 23.785 26.465 22.715 26.452 26.155 26.021 26.859 19.699 20.118 28.615 24.46 24.533 29.61 25.029 25.37 29.93 22.474 33.756 24.12 31.891 28.016 27.849 24.998 23.691 30.395 29.327 27.93 22.052 24.932 27.877 21.629 27.347 29.062 28.077 25.59 25.301 24.603 23.918 27.161 23.632 27.369 23.047 27.304 23.265 25.535 33.93 29.058 22.724 23.007 27.25 23.891 27.014 30.826 25.472 29.249 22.612 22.163 24.82 27.225 24.711 24.76 28.36 21.473 29.676 20.869 27.594 22.341 24.677 28.1 24.634 29.364 25.833 27.998 27.918 28.49 28.062 24.071 24.803 28.461 29.24 24.444]
%                 Tset = reshape(Tset,24,5);
%                 Tzone = kron(Tset,ones(12,1)); 
                
                
                
                PHVAC = dayLogCell{i}(:,11+7);
                TsetList = dayLogCell{i}(:,1);   % For plotting purposes only
                TsetList = convtemp(TsetList,'C','F');  Tamb = convtemp(Tamb,'C','F'); 
                Tzone = convtemp(Tzone,'C','F');
                CoolingPumpAvailSched = dayLogCell{i}(:,11);        
        

        if i == 3 && length(dayLogCell) == 6 || i == 7 && length(dayLogCell) == 20                % With 2 buffer days, the test day, and 3 follow up days (6 total)
            TzoneTESTDAY = Tzone;
        elseif i == 1 && length(dayLogCell) == 4            % Without buffer days: the test day, and 3 follow up days (4 total)
            TzoneTESTDAY = Tzone;
        elseif i == length(dayLogCell)
            TzoneLASTDAY = Tzone;
        end 
        if dontPlot == 0
            plotTemperature(Tamb,TsetList,Tzone,tbegin,tend,hideFigures,CoolingPumpAvailSched); 
        end
        day = day+1;
        title([logfields(i),'Zone Temperatures'])
    end 
    xlim auto
    ylim auto

    % The first day of TzoneTESTDAY corresponds to what TzoneLASTDAY should achieve
    % on its last step. 

    TzoneStart = TzoneTESTDAY(1,:)
    TzoneEnd = TzoneLASTDAY(end,:)
    TzoneDiff = TzoneEnd-TzoneStart

    hideFigures = 1; 
end