function [tvec,t] = plotDate(arr,strsrt,strend,step,plotstr,mode)     % plotstr is just the modifier for custom plots
    global hideFigures
    
    start = datenum(strsrt);  last = datenum(strend);
    t = linspace(start,last,length(arr));
    
    if nargin == 6 && strcmp(mode,'until')      % Special mode handle
        t = linspace(start,last,length(arr)/2);
        t = kron(t,ones(1,2));
        t = [t(2:end), t(end)];
    end 
    
    tvec = datelist(start, last, 1:step(1):12, 1:step(2):31,1:step(3):24,0:step(4):60);
    
    if hideFigures == 1                         % Don't waste time plotting.
        return
    end 
    
    if nargin == 5
        plot(t, arr, plotstr,'LineWidth',2)
    else
        plot(t, arr,'LineWidth',2)
    end
    
        set(gca, 'xlim', [start last], 'xtick', tvec)
        datetick('keepticks', 'keeplimits'), grid on;
end 



