function incrementEPfile(dateObj,numHistDays,dateFormat,IDFname,IDFdir,baseIDF)

% Provided a given date, this function replaces tokens in a template IDF
% file with updated days. 

% In Energyplus, the initial dates would represent what the first
% simulation should look like. Here, we pre-condition using week 7/25-7/31,
% optimize from 8/1-8/8, and terminate using 7/25-7/31 again. These dates
% should be written below instead.
    formerDir = pwd; 
    cd(IDFdir)
    templateIDF = [baseIDF,'_TEMPLATE.idf'];
    actualIDF = [IDFname,'.idf'];
    %=============================
    [~,IDFweekday] = weekday(dateObj,'long');
    %currentYear = str2double(datestr(dateObj,'yyyy'));  % If using RunPeriodCustom EP Object
    startObj = addtodate(dateObj,-numHistDays,'day');
    endObj = addtodate(dateObj,numHistDays-1,'day');

    IDFstartMonth = datestr(startObj,'mm');
    IDFstartDay = datestr(startObj,'dd');
    IDFendMonth = datestr(endObj,'mm');
    IDFendDay = datestr(endObj,'dd');
    IDFreplace = {IDFstartMonth,IDFstartDay,IDFendMonth,IDFendDay,IDFweekday};
    IDFtokens  = {'%IDFstartMonth%','%IDFstartDay%','%IDFendMonth%','%IDFendDay%','%IDFweekday%'};
    templateFID = fopen(templateIDF,'r');
    actualFID   = fopen(actualIDF,'w');
    thisLine = fgets(templateFID);

    replacements = 0;
    successStr = ['Token replacements successful in ' actualIDF '.\n' ...
                 'Start/End: ' datestr(startObj,dateFormat) ' to ' datestr(endObj,dateFormat),'\n' ...
                 'Intended planning day: ' datestr(dateObj) ' (' IDFweekday ') ','\n'];
    while ischar(thisLine)
       thisLine = fgets(templateFID);

       if replacements < length(IDFreplace)
           for i = 1:length(IDFreplace)          
               newLine = strrep(char(thisLine),IDFtokens{i},IDFreplace{i});
               if strcmp(newLine,char(thisLine)) == 0  % If there's a mismatch, we replaced something
                   thisLine = newLine;
                   replacements = replacements+1;
                   if replacements == length(IDFreplace), fprintf(successStr), end
               end
           end
       end
       
       fprintf(actualFID,'%s',thisLine);
    end

    fclose(templateFID);  fclose(actualFID);
    cd(formerDir)
end