function [TEnviron,Tzone, TotalHVACPwr] = importEP()

%% Import data from text file.
% Script for importing data from the following text file:
%
%    C:\EnergyPlusV7-2-0\My EnergyPlus\5RoomHawaii_2\5ZoneAirCooled.csv
%
% To extend the code to different selected data or a different text file,
% generate a function instead of a script.

% Auto-generated by MATLAB on 2014/11/11 17:58:28

%% Initialize variables.
filename = 'C:\EnergyPlusV7-2-0\My EnergyPlus\5RoomHawaii_2\5ZoneAirCooled.csv';
delimiter = ',';
startRow = 2;

%% Format string for each line of text:
%   column2: double (%f)
%	column3: double (%f)
%   column4: double (%f)
%	column5: double (%f)
%   column6: double (%f)
%	column7: double (%f)
%   column8: double (%f)
%	column9: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%*s%f%f%f%f%f%f%f%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Allocate imported array to column variable names
    TEnviron = dataArray{:, 1};
    Tzone11 = dataArray{:, 3};
    Tzone21 = dataArray{:, 4};
    Tzone31 = dataArray{:, 5};
    Tzone41 = dataArray{:, 6};
    Tzone51 = dataArray{:, 7};
    Tzone = [Tzone11, Tzone21, Tzone31, Tzone41, Tzone51];
    TotalHVACPwr = dataArray{:, 8};

%% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

end 