function [TsetHistory] = readTsetHistory(searchname,numHistDays)
% Based on the number of historical days required, this function takes the
% last n days required. It assumes that there is always enough data
% available for those historical days; a new CSV file is written per run
% using createTsetHistory.m, which is only called once per run. 

% These log files aren't particularly long, so we'll read the whole thing
% every time, and forget about using fseek(), although we should know the
% position of the log's entries.

% Sample CSV:
% Date,Tset(1) ... Tset(i), Pelec,Pdisc,Pelec+Pdisc (Netcost)

% If numHistDays is not consistent with createTsetHistory, an error will be
% thrown.
   
    TsetperDay = 14; 
    historyLog = csvread(searchname,1,1);
    numRows = size(historyLog,1);
    TsetHistory = historyLog(numRows-numHistDays+1:numRows,1:TsetperDay);
end