#!/bin/bash

# Script to take boundary conditions for a variety of wave parameters and run Delft-3D simulations for each case. 
# Boundary conditions are stored in directory 'boundary_conditions'. Each directory name in 'boundary_conditions' 
# reflects a wave case. 
# The directory 'template_dir' contains a sample run. 
# Each model runs occur in 'run_dir', and output files are stored in run_dir/output. At the end of the run, a
# three-digit run_number is attached as a suffix.i
# The file 'run_order.csv' contains the run number and run case. 
# After all runs are done, 'ncecat' concatenates all runs along record dimension 'run_number'.
# Kaus 08/16/2017

 
rm -f run_order_nowecs.csv
rm -f run_dir_nowecs/*
rm -f run_dir_nowecs/output/*

template_dir=jpd_template

counter=0

for d in boundary_files/nowecs/*/; do
   counter=$((counter+1))
   echo "In $d"

   # Use hard coded the below to extract filename if basename doesn't work
   #f=${d:15:16}
   f=`basename $d`

   echo $f
   echo "$counter, $f" >> run_order_nowecs.csv
   
   cp -f $template_dir/* run_dir_nowecs
   cp -f $d/* run_dir_nowecs
   cd run_dir_nowecs

   # run Delft3D model script
   ./run_flow2d3d.obs.sh > stdout.log

   echo "Finished run"
   
   # Create directory 'output' if it doesn't exist   
   if [ ! -d "output" ]; then
      mkdir output
   fi

 #  mv tri* *mdw *mdf stdout.log POWER_ABS.OUT output
 #  cd output

   # Add run_number suffix to the trih and trim NetCDF filenames 
   for file in ./tri*; do
      echo $file
      base=`basename ${file} ".nc"`
      newfile="$(printf "%03d" "$counter")"
      newfile="${base}_${newfile}.nc" 
      echo $newfile
      #newfile="${f}_${file}"
      mv $file output/$newfile
   done
   
   # Add run number to file POWER_ABS.OUT
   newfile="$(printf "%03d" "$counter")"
   newfile="POWER_ABS_${newfile}.OUT"
   mv POWER_ABS.OUT output/$newfile

   rm -f *
   cd ..

done

if [ -d "run_dir_nowecs/output" ]; then
   
   # Concatenate trih and trim files using ncecat
   ncecat -n $counter,3,1 -O -u run_number run_dir_nowecs/output/trih-nets_lesscoast_wecrem_001.nc run_dir_nowecs/output/trih_allruns.nc
   ncecat -n $counter,3,1 -O -u run_number run_dir_nowecs/output/trim-nets_lesscoast_wecrem_001.nc run_dir_nowecs/output/trim_allruns.nc
   
   # Tar and zip POWER_ABS.OUT files
   tar -czvf run_dir_nowecs/output/POWER_ABS_allruns.tar.gz run_dir_nowecs/output/POWER_ABS_*.OUT

fi
