#!/bin/bash
    #
    # This script is an example for running Delft3D-FLOW
    # Adapt and use it for your own purpose
    #
    # adri.mourits@deltares.nl
    # 01 Mar 2011
    # 
    #
    # This script starts a single-domain Delft3D-FLOW computation online with Delft3D-WAVE on Linux
    #


    #
    # Set the config file and mdw file
    # 
argfile=config_flow2d3d.xml
mdwfile=100_100.mdw

rm TMP* NEST* SWAN* WNDNOW OBCASE swan.inp swn* tri* wavm* *sp2 *tab com* *out *err WAVE2* FLOW2*


    #
    # Set the directory containing delftflow.exe
    #
export ARCH=lnx64
curdir=`pwd`
#export D3D_HOME=$curdir/../../bin
export D3D_HOME=/usr/local/delft3d_test/bin

#export NHOSTS=4
#export NSLOTS=4

flowexedir=$D3D_HOME/$ARCH/flow2d3d/bin
waveexedir=$D3D_HOME/$ARCH/wave/bin
swanexedir=$D3D_HOME/$ARCH/swan/bin
swanbatdir=$D3D_HOME/$ARCH/swan/scripts
#swanbatdir=./
    #
    # No adaptions needed below
    #

    # Set some (environment) parameters

    # Run
export LD_LIBRARY_PATH=$flowexedir:$LD_LIBRARY_PATH 
export PATH=$flowexedir:$PATH 
$flowexedir/d_hydro.exe $argfile &

export LD_LIBRARY_PATH=$swanbatdir:$swanexedir:$waveexedir:$LD_LIBRARY_PATH 
export PATH=$swanbatdir:$PATH 
$waveexedir/wave.exe $mdwfile 1

