/***************************************************************************
*
* Time: 2013-06-27
* Project: ң㷨ʾ
* Purpose: ң㷨ʾ
* Author:  ¼
* Copyright (c) 2013, liminlu0314@163.com
* Describe: ң㷨ʾ
*
****************************************************************************/
#ifndef GDALAIRCORE_H 
#define GDALAIRCORE_H

#include <limits>
#include <string>
#include <vector>
#include <complex>
using namespace std;

#include "gdal_priv.h"
#include "gdal_alg_priv.h"
#include "gdalwarper.h"
#include "ogrsf_frmts.h"

/**
* @brief Ŷ
*/
#ifdef GDALALG_EXPORTS
#define GDALALG_API __declspec(dllexport)
#else
#define GDALALG_API __declspec(dllimport)
#endif

/*!ɹִ*/
const int RE_SUCCESS = 0;
/*!ļ*/
const int RE_FILENOTEXIST = 1;
/*!ļʽ֧*/
const int RE_FILENOTSUPPORT = 2;
/*!ͼͲȷ*/
const int RE_FILETYPEERROR = 3;
/*!ͼʧ*/
const int RE_CREATEFAILED = 4;
/*!*/
const int RE_PARAMERROR = 5;
/*!*/
const int RE_FAILED = 6;
/*!ͼ񲻴ڹ*/
const int RE_NOSAMEEXTENT = 7;
/*!ûȡ*/
const int RE_USERCANCEL = 8;
/*!ļѾʹ*/
const int RE_FILEISUESED = 9;
/*!ֵ֧*/
const int RE_DEPTHNOTSUPPORT = 10;
/*!Ҫ*/
const int RE_BANDCOUNTERROR = 11;
/*!ļͶӰ*/
const int RE_NOPROJECTION = 12;
/*!ͶӰһ*/
const int RE_PROJECTIONDIFF = 13;
const int RE_FILENOTSUPPORT_MOD2 = 14;
const int RE_FILENOTSUPPORT_MOD3 = 15;

// õͶ壺
/*!byte*/
typedef unsigned char	byte;
/*!8U*/
typedef unsigned char	DT_8U;
/*!16U*/
typedef unsigned short	DT_16U;
/*!16S*/
typedef short			DT_16S;
/*!32U*/
typedef unsigned int	DT_32U;
/*!32S*/
typedef int				DT_32S;
/*!32F*/
typedef float			DT_32F;
/*!64F*/
typedef double			DT_64F;
/*!32CF*/
typedef complex<float>	DT_32CF;
/*!64CF*/
typedef complex<double>	DT_64CF;


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////

//õĺ궨壺
/**
*@briefͷ
*/
#define RELEASE(x)	if(x!=NULL){delete[]x;x=NULL;}

/**
*@briefPI=3.141592653...ԼȺͻת
*/
//#ifndef M_PI
/*!ԲPI*/
#define M_PI	3.1415926535897932384626433832795
/*!Բ2*PI*/
#define M_PI2	6.283185307179586476925286766559
/*!ת*/
#define DEG_PER_RAD	((double)(180.0/M_PI))
/*!ת*/
#define RAD_PER_DEG	((double)(M_PI/180.0))
//#endif

#define   MIN_VALUE  0.000001
/**
*@briefƽ
*/
#ifndef M_SQUARE
#define M_SQUARE(x)	(x)*(x)
#endif

/**
*@brief
*/
#ifndef M_CUBE
#define M_CUBE(x)	(x)*(x)*(x)
#endif

/*!жϸǷNaNֵ*/
inline bool isnan (const float&v)	{ return _isnan (v) ? true : false; }
/*!жdoubleǷNaNֵ*/
inline bool isnan (const double&v)	{ return _isnan (v) ? true : false; }
/*!ȡdoubleNaNֵ*/
inline double nan ()	{ return numeric_limits<double>::quiet_NaN (); }

/**
*@brieffloat͵ļֵ
*/
#ifndef FLT_EQUALS
/*!Ƿ*/
#define FLT_EQUALS(x,y)		(fabs((double)x-y)<FLT_EPSILON)
/*!Ƿ(ָȽֵ)*/
#define FLT_EQUALS_N(x,y,z)	(fabs((double)x-y)<z)
#endif

#ifndef FLT_ZERO
/*!ǷΪ0*/
#define FLT_ZERO(x)			(fabs(x)<FLT_EPSILON)
#endif

/**
*@brief
*
*ṩӿڣӳǰ㷨Ľֵ
*/
class GDALALG_API CProcessBase
{
public:
	/**
	*@brief캯
	*/
	CProcessBase ()
	{
		m_dPosition = 0.0;
		m_iStepCount = 100;
		m_iCurStep = 0;
		m_bIsContinue = true;
	}

	/**
	*@brief
	*/
	virtual~CProcessBase (){}

	/**
	*@briefýϢ
	*@parampszMsg			Ϣ
	*/
	virtual void SetMessage (const char *pszMsg) = 0;

	/**
	*@briefýֵ
	*@paramdPosition		ֵ
	*@return Ƿȡ״̬trueΪȡfalseΪȡ
	*/
	virtual bool SetPosition (double dPosition) = 0;

	/**
	*@briefǰһtrueʾfalseʾȡ
	*@return Ƿȡ״̬trueΪȡfalseΪȡ
	*/
	virtual bool StepIt () = 0;

	/**
	*@briefýȸ
	*@paramiStepCount		ȸ
	*/
	virtual void SetStepCount (int iStepCount)
	{
		ReSetProcess ();
		m_iStepCount = iStepCount;
	}

	/**
	*@briefȡϢ
	*@return صǰϢ
	*/
	string GetMessage ()
	{
		return m_strMessage;
	}

	/**
	*@briefȡֵ
	*@return صǰֵ
	*/
	double GetPosition ()
	{
		return m_dPosition;
	}

	/**
	*@briefý
	*/
	void ReSetProcess ()
	{
		m_dPosition = 0.0;
		m_iStepCount = 100;
		m_iCurStep = 0;
		m_bIsContinue = true;
	}

	/*!Ϣ*/
	string m_strMessage;
	/*!ֵ*/
	double m_dPosition;
	/*!ȸ*/
	int m_iStepCount;
	/*!ȵǰ*/
	int m_iCurStep;
	/*!ǷȡֵΪfalseʱʾȡ*/
	bool m_bIsContinue;
};

/**
*@brief̨
*
*ṩ̨Ľӿڣӳǰ㷨Ľֵ
*/
class CConsoleProcess : public CProcessBase
{
public:
	/**
	*@brief캯
	*/
	CConsoleProcess ()
	{
		m_dPosition = 0.0;
		m_iStepCount = 100;
		m_iCurStep = 0;
	};

	/**
	*@brief
	*/
	~CConsoleProcess ()
	{
		//remove(m_pszFile);
	};

	/**
	*@briefýϢ
	*@parampszMsg			Ϣ
	*/
	void SetMessage (const char* pszMsg)
	{
		m_strMessage = pszMsg;
		printf ("%s\n", pszMsg);
	}

	/**
	*@briefýֵ
	*@paramdPosition		ֵ
	*@returnǷȡ״̬trueΪȡfalseΪȡ
	*/
	bool SetPosition (double dPosition)
	{
		m_dPosition = dPosition;
		TermProgress (m_dPosition);
		m_bIsContinue = true;
		return true;
	}

	/**
	*@briefǰһ
	*@returnǷȡ״̬trueΪȡfalseΪȡ
	*/
	bool StepIt ()
	{
		m_iCurStep++;
		m_dPosition = m_iCurStep*1.0 / m_iStepCount;

		TermProgress (m_dPosition);
		m_bIsContinue = true;
		return true;
	}

private:
	void TermProgress (double dfComplete)
	{
		static int nLastTick = -1;
		int nThisTick = (int)(dfComplete*40.0);

		nThisTick = MIN (40, MAX (0, nThisTick));

		if (nThisTick < nLastTick && nLastTick >= 39)
			nLastTick = -1;

		if (nThisTick <= nLastTick)
			return;

		while (nThisTick > nLastTick)
		{
			nLastTick++;
			if (nLastTick % 4 == 0)
				fprintf (stdout, "%d", (nLastTick / 4) * 10);
			else
				fprintf (stdout, ".");
		}

		if (nThisTick == 40)
			fprintf (stdout, "-done.\n");
		else
			fflush (stdout);
	}
};

/**
*@briefŶ
*/
#ifndef STD_API
#define STD_API __stdcall
#endif

/**
*\briefGDALӿ
*
*úڽGDAL㷨еĽϢCProcessBaseУʾ
*
*@paramdfComplete	ɽֵȡֵΪ0.01.0֮
*@parampszMessage	Ϣ
*@parampProgressArgCProcessBaseָ
*
*@returnTRUEʾ㣬Ϊȡ
*/
int STD_API ALGTermProgress (double dfComplete, const char* pszMessage, void* pProgressArg)
{
	if (pProgressArg != NULL)
	{
		CProcessBase*pProcess = (CProcessBase*)pProgressArg;
		pProcess->m_bIsContinue = pProcess->SetPosition (dfComplete);

		if (pProcess->m_bIsContinue)
			return TRUE;
		else
			return FALSE;
	}
	else
		return TRUE;
}

#endif /*GDALAIRCORE_H*/