/***************************************************************************
*
* Time: 2013-06-27
* Project: ң㷨ʾ
* Purpose: ң㷨ʾ
* Author:  ¼
* Copyright (c) 2013, liminlu0314@163.com
* Describe: ң㷨ʾе㷨У
*           ûж·ԼļǷڽм飬
*           ĬΪеǺ
*
****************************************************************************/

#define _CRT_SECURE_NO_WARNINGS
#include "GDALAir.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include<algorithm>
#include "omp.h"
#include "gdal_alg.h"
#include <queue>
using namespace std;
#pragma region ͼǶ

/**
* @brief ͼУתṹ
*/
struct TransformChain
{
	/*! GDALתָ */
	GDALTransformerFunc GDALTransformer;
	/*! GDALת */
	void *              GDALTransformerArg;
	/*! ͼ6 */
	double              adfGeotransform[6];
	/*! ͼ6 */
	double              adfInvGeotransform[6];
};

/**
* @brief һת
*
* úڴһͼͶӰתͼк
* @sa DestroyGeoToPixelTransform
* @returns GDALתصĲ \ref GeoToPixelTransform
*/
void *CreateGeoToPixelTransform (GDALTransformerFunc GDALTransformer, void *GDALTransformerArg, double *padfGeotransform)
{
	TransformChain *pChain = new TransformChain;
	pChain->GDALTransformer = GDALTransformer;
	pChain->GDALTransformerArg = GDALTransformerArg;
	memcpy (pChain->adfGeotransform, padfGeotransform, sizeof(double)* 6);

	if (!GDALInvGeoTransform (pChain->adfGeotransform, pChain->adfInvGeotransform))
	{
		// ͼܼܽб任
		delete pChain;
		return NULL;
	}
	return (void*)pChain;
}

/**
* @brief ת
*/
void DestroyGeoToPixelTransform (void *GeoToPixelTransfomArg)
{
	delete static_cast<TransformChain *>(GeoToPixelTransfomArg);
}

/**
* @brief ת
* @sa CreateGeoToPixelTransform
*/
int GeoToPixelTransform (void *pTransformerArg, int bDstToSrc, int nPointCount,
	double *x, double *y, double *z, int *panSuccess)
{
	TransformChain *pChain = static_cast<TransformChain*>(pTransformerArg);
	if (pChain == NULL)
		return FALSE;

	if (!bDstToSrc)	//任
	{
		// ȵGDALеתתΪͼͶӰ
		if (!pChain->GDALTransformer (pChain->GDALTransformerArg, bDstToSrc, nPointCount, x, y, z, panSuccess))
			return FALSE;

		// ٴͼͶӰϵתͼк
#pragma omp parallel for
		for (int i = 0; i < nPointCount; ++i)
		{
			if (!panSuccess[i])
				continue;

			double xP = x[i];
			double yP = y[i];
			GDALApplyGeoTransform (pChain->adfInvGeotransform, xP, yP, &x[i], &y[i]);
		}
	}
	else	//任
	{
		// ȴͼкתͼͶӰϵ
#pragma omp parallel for
		for (int i = 0; i < nPointCount; ++i)
		{
			double P = x[i];
			double L = y[i];
			GDALApplyGeoTransform (pChain->adfGeotransform, P, L, &x[i], &y[i]);
		}
		// ٵGDALתͼͶӰתԭʼ
		if (!pChain->GDALTransformer (pChain->GDALTransformerArg, bDstToSrc, nPointCount, x, y, z, panSuccess))
			return FALSE;
	}

	return TRUE;
}
int ImageWarpByGeoLoc(const char * pszSrcFile, const char * pszDstFile, char **papszGeoLocOptions,
	GDALResampleAlg eResampleMethod, const char * pszFormat)
{
	// ǰҪļ·жϣﲻжֱӴ
	if (pszSrcFile == NULL || pszDstFile == NULL || papszGeoLocOptions == NULL || pszFormat == NULL)
	{
		return RE_PARAMERROR;
	}
	GDALAllRegister();

	// ԭʼͼ񲢼ͼϢ
	GDALDatasetH hSrcDS = GDALOpen(pszSrcFile, GA_ReadOnly);
	GDALDataType eDT = GDALGetRasterDataType(GDALGetRasterBand(hSrcDS, 1));	//ȡ
	int iBandCount = GDALGetRasterCount(hSrcDS);

	// Geolocתϵ
	void *hTransformArg = GDALCreateGeoLocTransformer(hSrcDS, papszGeoLocOptions, FALSE);
	if (hTransformArg == NULL)
	{
		GDALClose(hSrcDS);
		return RE_PARAMERROR;
	}

	// ʹSuggestedWarpOutputͼΧСϢ
	double adfGeoTransform[6];
	double adfExtent[4];
	int    nPixels, nLines;

	if (GDALSuggestedWarpOutput2(hSrcDS, GDALGeoLocTransform, hTransformArg,
		adfGeoTransform, &nPixels, &nLines, adfExtent, 0) != CE_None)
	{
		GDALClose(hSrcDS);
		return RE_PARAMERROR;
	}

	// ͼ
	GDALDriverH hDriver = GDALGetDriverByName(pszFormat);
	GDALDatasetH hDstDS = GDALCreate(hDriver, pszDstFile, nPixels, nLines, iBandCount, eDT, NULL);
	GDALSetProjection(hDstDS, SRS_WKT_WGS84);	//GeoLocУWGS84γϵͳ
	GDALSetGeoTransform(hDstDS, adfGeoTransform);

	// GDALWarpı任ѡ
	GDALWarpOptions *psWO = GDALCreateWarpOptions();

	psWO->papszWarpOptions = CSLDuplicate(NULL);
	psWO->eWorkingDataType = eDT;
	psWO->eResampleAlg = GRA_NearestNeighbour;

	psWO->hSrcDS = hSrcDS;
	psWO->hDstDS = hDstDS;

	psWO->pfnTransformer = GeoToPixelTransform;
	psWO->pTransformerArg = CreateGeoToPixelTransform(GDALGeoLocTransform, hTransformArg, adfGeoTransform);

	//psWO->pfnProgress = ALGTermProgress;
	//psWO->pProgressArg = pProcess;

	psWO->nBandCount = iBandCount;
	psWO->panSrcBands = (int *)CPLMalloc(psWO->nBandCount*sizeof(int));
	psWO->panDstBands = (int *)CPLMalloc(psWO->nBandCount*sizeof(int));
	/*psWO->panSrcBands = new int[psWO->nBandCount];
	psWO->panDstBands = new int[psWO->nBandCount];*/
	for (int i = 0; i < iBandCount; i++)
	{
		psWO->panSrcBands[i] = i + 1;
		psWO->panDstBands[i] = i + 1;
	}

	// GDALWarpִж󣬲ʹGDALWarpOptionsгʼ
	GDALWarpOperation oWO;
	oWO.Initialize(psWO);

	// ִд
	oWO.ChunkAndWarpImage(0, 0, nPixels, nLines);

	// ͷԴ͹رļ
	////delete []psWO->panSrcBands;
	///delete[] psWO->panDstBands;
	//delete[] psWO->panSrcBands;
	//delete[] psWO->panDstBands;
	//CPLFree(psWO->panSrcBands);
	//CPLFree(psWO->panDstBands);
	DestroyGeoToPixelTransform(psWO->pTransformerArg);
	GDALDestroyWarpOptions(psWO);
	GDALDestroyGeoLocTransformer(hTransformArg);
	GDALClose(hSrcDS);
	GDALClose(hDstDS);
	return RE_SUCCESS;
}

int RGBTrueColorSynthesisconst (const char* pszSrcFile2, const char* pszSrcFile3, const char* pszDstFile, int deleteFile)
{
	//modis3ݣȡgeolocϢ
	const char* pszFormat = "GTiff";
	//ƴĿļ·ļ
	string strfile = string (CPLGetFilename (pszSrcFile2));
	strfile = strfile.substr (0, strfile.find_last_of ("hdf") - 21);
	strfile = string (CPLGetPath (pszDstFile)) + "\\" + strfile;
	string tmpThreeMidFile = strfile + "_threemidFile.tif";
	string tmpGeolocFile = strfile + "_geolocFile.tif";
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *pSrcDataset3 = (GDALDataset*)GDALOpen (pszSrcFile3, GA_ReadOnly);
	if (pSrcDataset3 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD3;
	}
	char **papszSubDatasets3 = GDALGetMetadata ((GDALDatasetH)pSrcDataset3, "SUBDATASETS");
	string tmpstr = string (papszSubDatasets3[0]);
	tmpstr = tmpstr.substr (tmpstr.find_first_of ("=") + 1);
	const char * pszSrcFile3_1 = tmpstr.c_str ();

	string tmplat = string (papszSubDatasets3[24]);
	tmplat = tmplat.substr (tmplat.find_first_of ("=") + 1);
	const char * pszlat = tmplat.c_str ();

	string tmplon = string (papszSubDatasets3[26]);
	tmplon = tmplon.substr (tmplon.find_first_of ("=") + 1);
	const char * pszlon = tmplon.c_str ();

	GDALDataset *pSrcDS3_1 = (GDALDataset*)GDALOpen (pszSrcFile3_1, GA_ReadOnly);
	if (pSrcDS3_1 == NULL)
	{
		GDALClose ((GDALDatasetH)pSrcDataset3);
		return RE_FILENOTSUPPORT_MOD3;
	}
	//ȡdodis3Ԫgeolocation
	char **papszGeoLocOptions3 = pSrcDS3_1->GetMetadata ("GEOLOCATION");
	//GDALClose(GDALDatasetH(pSrcDataset3));

	char **papszGeoLocOptions = NULL;

	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
	if (papszGeoLocOptions3 == NULL)
	{
		//char **papszGeoLocOptions = NULL;
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_OFFSET", "0");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_OFFSET", "0");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "X_BAND", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "Y_BAND", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "X_DATASET", pszlon);
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "Y_DATASET", pszlat);
	}
	else
	{
		papszGeoLocOptions = papszGeoLocOptions3;
		//papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "PIXEL_OFFSET", "2");
		//papszGeoLocOptions= CSLSetNameValue(papszGeoLocOptions3, "LINE_OFFSET", "2");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_STEP", "1");
		/*papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "X_DATASET", pszlon);
		papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "Y_DATASET",pszlat );*/
		//HDF4_SDS:UNKNOWN:"E:\GDAL\GDALTEST\rgb\modisrgb\data\1430335\MOD03.A2015143.0235.006.2015143091841.hdf":0

	}



	GDALDataset *pSrcDataset2 = (GDALDataset*)GDALOpen (pszSrcFile2, GA_ReadOnly);
	if (pSrcDataset2 == NULL)
	{
		GDALClose (GDALDatasetH (pSrcDataset3));
		GDALClose (GDALDatasetH (pSrcDS3_1));
		return RE_FILENOTSUPPORT_MOD2;
	}
	//洢ݵ·Ϣ
	char **papszSubDatasets2 = GDALGetMetadata ((GDALDatasetH)pSrcDataset2, "SUBDATASETS");
	//GDALClose(pSrcDataset2);
	// string temp2_1 = string(vSubDSName2[28]);
	string tmpstr2 = string (papszSubDatasets2[8]);
	tmpstr2 = tmpstr2.substr (tmpstr2.find_first_of ("=") + 1);
	const char *pszSrcFile2_1 = tmpstr2.c_str ();

	string tmpstr3 = string (papszSubDatasets2[14]);
	tmpstr3 = tmpstr3.substr (tmpstr3.find_first_of ("=") + 1);
	const char *pszSrcFile2_2 = tmpstr3.c_str ();
	//ݼȡָ3Ρ

	///////////////////////////////////////////////////

	// ԭʼͼָݼͼϢ//ʱļ3εģ
	GDALDataset *pSrcDS2_1 = (GDALDataset*)GDALOpen (pszSrcFile2_1, GA_ReadOnly);
	GDALDataset *pSrcDS2_2 = (GDALDataset*)GDALOpen (pszSrcFile2_2, GA_ReadOnly);
	double adfGeoTransform2_1[6] = { 0 };
	double adfGeoTransform2_2[6] = { 0 };
	pSrcDS2_1->GetGeoTransform (adfGeoTransform2_1);
	pSrcDS2_2->GetGeoTransform (adfGeoTransform2_2);

	//modisTime =atoi(tmpstr.c_str());
	//const char* pszTempFile ="E:\\GDAL\\GDALTEST\\rgb\\modisrgb\\data\\rgbtemp.tif";
	//E:\GDAL\GDALTEST\rgb\modisrgb\data\rgb.tif
	GDALDriver *pDriver = (GDALDriver*)GDALGetDriverByName (pszFormat);
	int nPixels = pSrcDS2_1->GetRasterXSize ();
	int nLines = pSrcDS2_1->GetRasterYSize ();
	GDALDataType eDT = pSrcDS2_1->GetRasterBand (1)->GetRasterDataType ();	//ȡ
	GDALDataset *pTempDS = pDriver->Create (tmpThreeMidFile.c_str (), nPixels, nLines, 3, eDT, NULL);//3
	pTempDS->SetProjection (pSrcDS2_1->GetProjectionRef ());
	pTempDS->SetGeoTransform (adfGeoTransform2_1);
	//delete []adfGeoTransform2_1;
	//delete []adfGeoTransform2_2;
	//д
	if (eDT == GDT_UInt16)
	{
		DT_16U *pBuf = new DT_16U[nPixels*nLines];
		GDALRasterBand *pBand1 = pTempDS->GetRasterBand (1);
		GDALRasterBand *pBand2 = pTempDS->GetRasterBand (2);
		GDALRasterBand *pBand3 = pTempDS->GetRasterBand (3);
		pSrcDS2_1->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand1->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д1

		pSrcDS2_2->GetRasterBand (2)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand2->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д2

		pSrcDS2_2->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand3->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д3
		delete[]pBuf;
	}

	int iResult;
	//pszTempFile ="E:\\GDAL\\GDALTEST\\rgb\\modisrgb\\data\\rgbtemp.tif";
	GDALClose ((GDALDatasetH)pSrcDS2_2);
	GDALClose ((GDALDatasetH)pSrcDS2_1);
	GDALClose ((GDALDatasetH)pTempDS);
	GDALClose ((GDALDatasetH)pSrcDataset3);
	GDALClose ((GDALDatasetH)pSrcDataset2);
	iResult = ImageWarpByGeoLoc (tmpThreeMidFile.c_str (), pszDstFile, papszGeoLocOptions, GRA_NearestNeighbour, "GTiff");
	GDALClose (GDALDatasetH (pSrcDS3_1));
	papszGeoLocOptions3 = NULL;


	if (deleteFile == 0)
	{
		remove (tmpThreeMidFile.c_str ());//ļɾ
	}
	return iResult;

}






//ȫֱ ͼΧ
static double	       dfMinX = 0.0, dfMinY = 0.0, dfMaxX = 0.0, dfMaxY = 0.0;
//ȫֱ ͼֱ
static double	       dfXRes = 0.01000, dfYRes = 0.01000;
//ȫֱ ͼ
static int             nForcePixels = 0, nForceLines = 0;
//ȫֱ ָ
//CProcessBase* m_pProcess = NULL;		

/**
* @brief ļ
* @param papszSrcFiles			ļб
* @param pszFilename			ļ·
* @param pszFormat				ļʽ
* @param eDT					ļ
* @param iRst					صĴʹ
* @return ļľ
*/
static GDALDatasetH GDALWarpCreateOutput (char **papszSrcFiles, int count, const char *pszFilename,
	const char *pszFormat, GDALDataType eDT, int &iRst)
{
	GDALAllRegister ();
	GDALDriverH hDriver;
	GDALDatasetH hDstDS;
	GDALColorTableH hCT = NULL;
	double dfWrkMinX = 0, dfWrkMaxX = 0, dfWrkMinY = 0, dfWrkMaxY = 0;
	double dfWrkResX = 0, dfWrkResY = 0;
	int nDstBandCount = 0;
	const char *pszThisTargetSRS = NULL;
	string strThisTargetSRS;

	iRst = RE_SUCCESS;

	//ȡļ
	hDriver = GDALGetDriverByName (pszFormat);
	//GDALDriver *pDriver =GDALDriverManager().GetDriverByName(pszFormat);
	//
	//printf(" driver short name is %s\n",GDALGetDriverShortName(hDriver));
	//printf(" driver long name is %s\n",GDALGetDriverLongName(hDriver));
	if (hDriver == NULL)
	{
		iRst = RE_FILENOTSUPPORT;
		return NULL;
	}

	for (int iSrc = 0; iSrc<count; iSrc++)
	{
		GDALDatasetH hSrcDS;
		hSrcDS = GDALOpen (papszSrcFiles[iSrc], GA_ReadOnly);
		if (hSrcDS == NULL)
		{
			iRst = RE_FILENOTEXIST;
			return NULL;
		}

		//鵱ǰļǷڲ 
		if (GDALGetRasterCount (hSrcDS) == 0)
		{
			iRst = RE_FILETYPEERROR;
			return NULL;
		}

		if (eDT == GDT_Unknown)
			eDT = GDALGetRasterDataType (GDALGetRasterBand (hSrcDS, 1));

		if (pszThisTargetSRS == NULL)
		{
			pszThisTargetSRS = GDALGetProjectionRef (hSrcDS);
			strThisTargetSRS = (string)((char*)pszThisTargetSRS);
		}

		//ǵһͼôͼϢһͼ񱣳һ
		if (iSrc == 0)
		{
			nDstBandCount = GDALGetRasterCount (hSrcDS);
			hCT = GDALGetRasterColorTable (GDALGetRasterBand (hSrcDS, 1));
			if (hCT != NULL)
				hCT = GDALCloneColorTable (hCT);
		}

		double adfThisGeoTransform[6] = { 0 };
		double adfExtent[4] = { 0 };
		int    nThisPixels, nThisLines;

		nThisPixels = GDALGetRasterXSize (hSrcDS);
		nThisLines = GDALGetRasterYSize (hSrcDS);

		// 㵱ǰͼΧ
		GDALGetGeoTransform (hSrcDS, adfThisGeoTransform);
		GDALApplyGeoTransform (adfThisGeoTransform, 0, 0, adfExtent, adfExtent + 1);
		GDALApplyGeoTransform (adfThisGeoTransform, nThisPixels, nThisLines, adfExtent + 2, adfExtent + 3);

		// Χ
		if (dfWrkMaxX == 0.0 && dfWrkMinX == 0.0)
		{
			dfWrkMinX = adfExtent[0];
			dfWrkMaxX = adfExtent[2];
			dfWrkMaxY = adfExtent[1];
			dfWrkMinY = adfExtent[3];
			dfWrkResX = adfThisGeoTransform[1];
			dfWrkResY = ABS (adfThisGeoTransform[5]);
		}
		else
		{
			dfWrkMinX = MIN (dfWrkMinX, adfExtent[0]);
			dfWrkMaxX = MAX (dfWrkMaxX, adfExtent[2]);
			dfWrkMaxY = MAX (dfWrkMaxY, adfExtent[1]);
			dfWrkMinY = MIN (dfWrkMinY, adfExtent[3]);
			dfWrkResX = MIN (dfWrkResX, adfThisGeoTransform[1]);
			dfWrkResY = MIN (dfWrkResY, ABS (adfThisGeoTransform[5]));
		}

		GDALClose (hSrcDS);
	}

	// ͼΧʹС
	double adfDstGeoTransform[6];
	int nPixels, nLines;

	adfDstGeoTransform[0] = dfWrkMinX;
	adfDstGeoTransform[1] = dfWrkResX;
	adfDstGeoTransform[2] = 0.0;
	adfDstGeoTransform[3] = dfWrkMaxY;
	adfDstGeoTransform[4] = 0.0;
	adfDstGeoTransform[5] = -1 * dfWrkResY;

	nPixels = (int)((dfWrkMaxX - dfWrkMinX) / dfWrkResX + 0.5);
	nLines = (int)((dfWrkMaxY - dfWrkMinY) / dfWrkResY + 0.5);

	// ûֱָʱٶͼСе
	if (dfXRes != 0.0 && dfYRes != 0.0)
	{
		if (dfMinX == 0.0 && dfMinY == 0.0 && dfMaxX == 0.0 && dfMaxY == 0.0)
		{
			dfMinX = adfDstGeoTransform[0];
			dfMaxX = adfDstGeoTransform[0] + adfDstGeoTransform[1] * nPixels;
			dfMaxY = adfDstGeoTransform[3];
			dfMinY = adfDstGeoTransform[3] + adfDstGeoTransform[5] * nLines;
		}

		nPixels = (int)((dfMaxX - dfMinX + (dfXRes / 2.0)) / dfXRes);
		nLines = (int)((dfMaxY - dfMinY + (dfYRes / 2.0)) / dfYRes);
		adfDstGeoTransform[0] = dfMinX;
		adfDstGeoTransform[3] = dfMaxY;
		adfDstGeoTransform[1] = dfXRes;
		adfDstGeoTransform[5] = -dfYRes;
	}

	// ͼ
	hDstDS = GDALCreate (hDriver, pszFilename, nPixels, nLines, nDstBandCount, eDT, NULL);
	//hDstDS = GDALCreate( GDALDriverH(pDriver), pszFilename, nPixels, nLines, nDstBandCount, eDT, NULL );
	if (hDstDS == NULL)
		return NULL;

	// дͶӰϢϢ
	GDALSetProjection (hDstDS, strThisTargetSRS.c_str ());
	GDALSetGeoTransform (hDstDS, adfDstGeoTransform);

	return hDstDS;
}
/**
* @brief ͼǶ
* <B>עô˺֮ǰȶӰмξͬһͶӰϵͳ£ֱʿԲͬ
* ͶӰϢԼĸݵĲθһ£ֲǶ
* ͼķֱʻᰴӰĵһӰȡͶӰϢ</B>
* @param papszSrcFiles		ļԼǶ·飬ĬϵһΪοӰ񣬵һͼ²㣬
* @param pszDstFilename		ļ·
* @param eResampleMethod	زʽĬΪRM_Bilinear
* @param dResX				ӰXֱʣĬΪ0ʾյһӰΪ׼
* @param dResY				ӰYֱʣĬΪ0ʾյһӰΪ׼
* @param pszFormat			ļʽϸοGDAL֧
* @param pProcess			ָ
* @return ֵʾгֵĸִϢ
*/
int ImageMosaicing (char* papszSrcFiles_1, const char* pszDstFilename)
{


	//Ԥַתchar**
	const char* comma = ",";
	int commaCount = 0;
	for (int i = 0; papszSrcFiles_1[i] != NULL; i++)
	{
		if (papszSrcFiles_1[i] == ',')
		{
			commaCount++;

		}
	}
	char** papszSrcFiles = new char *[commaCount + 1];
	for (int i = 0; i<commaCount + 1; i++)
	{
		if (i == 0)
		{
			papszSrcFiles[i] = strtok (papszSrcFiles_1, comma);
		}
		else
		{
			papszSrcFiles[i] = strtok (NULL, comma);
		}

	}


	int eResampleMethod = GRA_Bilinear;
	double dResX = 0;
	double dResY = 0;
	const char* pszFormat = "GTiff";
	/*if(pProcess != NULL)
	pProcess->SetMessage("ִǶ...");
	*/
	//ת
	void               *hTransformArg, *hGenImgProjArg = NULL, *hApproxArg = NULL;
	double              dfErrorThreshold = 0.0;
	GDALTransformerFunc pfnTransformer = NULL;

	GDALDataType        eOutputType = GDT_Unknown, eWorkingType = GDT_Unknown;
	GDALResampleAlg     eResampleAlg = (GDALResampleAlg)eResampleMethod;

	//NODATA
	const char         *pszSrcNodata = "0 0 0";
	const char         *pszDstNodata = "0 0 0";

	GDALAllRegister ();

	dfXRes = dResX;	//÷ֱ
	dfYRes = dResY;

	//ļ
	int iResult = RE_SUCCESS;
	GDALDatasetH		hDstDS;
	hDstDS = GDALWarpCreateOutput (papszSrcFiles, commaCount + 1, pszDstFilename, pszFormat, eOutputType, iResult);

	if (iResult != RE_SUCCESS || hDstDS == NULL)
		return iResult;

	//еļдļ
	int iRev = RE_SUCCESS;
	for (int iSrc = 0; iSrc<commaCount + 1; iSrc++)
	{
		GDALDatasetH hSrcDS;
		hSrcDS = GDALOpen (papszSrcFiles[iSrc], GA_ReadOnly);

		//////////////////////////////////////////////////////////////////////////
		// printf("%s\n\n",GDALGetProjectionRef(hSrcDS));
		//printf("%s\n",GDALGetProjectionRef(hDstDS));
		//////////////////////////////////////////////////////////////////////////
		if (hSrcDS == NULL)
		{
			iRev = RE_FILENOTEXIST;
			goto CLEAN;
		}

		// ļǷ񲻴ڲ 
		if (GDALGetRasterCount (hSrcDS) == 0)
		{
			//CPLDebug ("ImageMergeCutline", "ļ %s ڲΡ\n", papszSrcFiles[iSrc]);
			iRev = RE_FILENOTSUPPORT;
			goto CLEAN;
		}

		//תԴ굽Ŀϵ
		hTransformArg = hGenImgProjArg = GDALCreateGenImgProjTransformer2 (hSrcDS, hDstDS, NULL);
		if (hTransformArg == NULL)
		{
			iRev = RE_PARAMERROR;
			goto CLEAN;
		}

		pfnTransformer = GDALGenImgProjTransform;

		if (dfErrorThreshold != 0.0)
		{
			hTransformArg = hApproxArg =
				GDALCreateApproxTransformer (GDALGenImgProjTransform, hGenImgProjArg, dfErrorThreshold);
			pfnTransformer = GDALApproxTransform;
		}

		//warpѡ
		GDALWarpOptions *psWO = GDALCreateWarpOptions ();
		psWO->eWorkingDataType = eWorkingType;
		psWO->eResampleAlg = eResampleAlg;

		psWO->hSrcDS = hSrcDS;
		psWO->hDstDS = hDstDS;

		psWO->pfnTransformer = pfnTransformer;
		psWO->pTransformerArg = hTransformArg;

		psWO->pfnProgress = ALGTermProgress;
		/*psWO->pProgressArg = pProcess;*/
		//
		psWO->nDstAlphaBand = GDALGetRasterCount (hDstDS);
		psWO->nSrcAlphaBand = GDALGetRasterCount (hSrcDS);
		//ӳϵ
		psWO->nBandCount = GDALGetRasterCount (hSrcDS);

		psWO->panSrcBands = (int *)CPLMalloc (psWO->nBandCount*sizeof(int));
		psWO->panDstBands = (int *)CPLMalloc (psWO->nBandCount*sizeof(int));

		for (int i = 0; i < psWO->nBandCount; i++)
		{
			psWO->panSrcBands[i] = i + 1;
			psWO->panDstBands[i] = i + 1;
		}

		//ʼִwarp
		GDALWarpOperation oWO;
		CPLErr CE = CE_None;
		if (oWO.Initialize (psWO) == CE_None)
			CE = oWO.ChunkAndWarpImage (0, 0, GDALGetRasterXSize (hDstDS), GDALGetRasterYSize (hDstDS));

		//Դ
		if (hApproxArg != NULL)
			GDALDestroyApproxTransformer (hApproxArg);

		if (hGenImgProjArg != NULL)
			GDALDestroyGenImgProjTransformer (hGenImgProjArg);

		GDALDestroyWarpOptions (psWO);
		GDALClose (hSrcDS);

		if (CE != CE_None)
		{
			GDALClose (hDstDS);
			CSLDestroy (papszSrcFiles);

			/*if(pProcess != NULL)
			{
			if (!pProcess->m_bIsContinue)
			{
			pProcess->SetMessage("ȡ㣡");
			return RE_USERCANCEL;
			}
			else
			{
			pProcess->SetMessage("ִʧܣ");
			return RE_FAILED;
			}
			}*/

			return RE_FAILED;
		}

		/*if(pProcess != NULL)
		pProcess->ReSetProcess();*/
	}

	//ƺ
CLEAN:

	GDALClose (hDstDS);
	//CSLDestroy( papszSrcFiles );
	for (int i = 0; i<commaCount + 1; i++)
	{
		papszSrcFiles[i] = NULL;
	}

	/*if(pProcess != NULL)
	pProcess->SetMessage("Ƕ...");
	*/
	return RE_SUCCESS;
}

#pragma endregion ͼǶ
int SieveFilter (const char* pszSrcFile, const char* pszDstFile, int nSizeThresholld, int nConnectedness, const char* pszFormat)
{
	if (pszSrcFile == NULL || pszDstFile == NULL)
	{
		return RE_PARAMERROR;
	}
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *SrcDS = (GDALDataset*)GDALOpen (pszSrcFile, GA_ReadOnly);
	if (SrcDS == NULL)
	{
		return RE_FILENOTEXIST;
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (pszFormat);
	if (Driver == NULL)
	{
		GDALClose ((GDALDatasetH)SrcDS);
		return RE_FILENOTSUPPORT;
	}
	//ȡͼϢ
	int srcBandCount = SrcDS->GetRasterCount ();
	int XSize = SrcDS->GetRasterXSize ();
	int YSize = SrcDS->GetRasterYSize ();
	GDALDataType dataType = SrcDS->GetRasterBand (1)->GetRasterDataType ();
	//ͼ
	GDALDataset *DstDS = Driver->Create (pszDstFile, XSize, YSize, srcBandCount, dataType, NULL);
	double geoTransform[6] = { 0 };
	SrcDS->GetGeoTransform (geoTransform);
	DstDS->SetGeoTransform (geoTransform);
	DstDS->SetProjection (SrcDS->GetProjectionRef ());

	for (int i = 0; i<srcBandCount; i++)
	{
		GDALRasterBandH SrcBand = (GDALRasterBandH)SrcDS->GetRasterBand (i + 1);
		GDALRasterBandH DstBand = (GDALRasterBandH)DstDS->GetRasterBand (i + 1);
		//GDALSetRasterColorTable(DstBand,GDALGetRasterColorTable(SrcBand));
		GDALSetRasterNoDataValue (DstBand, 0.0);
		if (GDALSieveFilter (SrcBand, NULL, DstBand, nSizeThresholld, nConnectedness, NULL, NULL, NULL) != CE_None)
		{
			if (DstDS != NULL)
			{
				GDALClose ((GDALDatasetH)DstDS);
				GDALClose ((GDALDatasetH)SrcDS);
			}
			return RE_PARAMERROR;
		}

		GDALClose ((GDALDatasetH)DstDS);
		GDALClose ((GDALDatasetH)SrcDS);
		return RE_SUCCESS;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

enum test_result
{
	unknow = 0,
	yun = 1,
	shui = 3,
	qianhuodian = 4,
	jueduihuodian = 5,
	nofire = 6,
	zandinghuodian = 7,
	zhenhuodian = 8,
	beijinghuodian = 9,
	beijinghuodian2 = 14,
	beijing = 10,
	buquding = 11,
	chenggongtiqu = 12,
	xujiahuodian = 13,
	youxiaobeijingxiangyuan = 15,
	anxiangyuan = 16
};
static  float maxwindowsize = 21;//󴰿ڴС
static int modisTime =0;//modisʱ
static int seasonDay=0;//modis

static int width;//
static int height;//߶admin
// float sizeofclass =width*height;
float** band_1 = NULL;
float** band_2 = NULL;
float** band_3 = NULL;
float** band_5 = NULL;
float** band_7 = NULL;
float** band_21 = NULL;
float** band_22 = NULL;
float** band_31 = NULL;
float** band_32 = NULL;
//string tmpstrSensorZenith,tmpstrSensorAzimuth,tmpstrSolarZenith,tmpstrSolarAzimuth;
float** sensorzenith = NULL;
float** sensorazimuth = NULL;
float** solarzenith = NULL;
float** solarazimuth = NULL;
float** relativeangel = NULL;
float** lansea = NULL;
test_result** testresult = NULL;
float** confidence = NULL;
float** longitute = NULL;
float** latitute = NULL;
float** temp = NULL;
float** aodndvi = NULL;
float** suf_band_1;
float** suf_band_3 = NULL;
float** aodOptimal = NULL;

#pragma region Ʋ
//Ƽ⼰ˮԪʶ޳
const float th1 = 0.9;
const float th2 = 0.7;
const float th3 = 265;
const float th4 = 285;
const float th5 = 0.15;
//Ǳڻб
const float thr = 0.3;
const float thdt4 = 310;
const float thnt4 = 305;
//ǱڻֵԲ
const float thdat4 = 340;
const float thnat4 = 320;
//Ǳڻ㱳ֵԲ
const float thdb4 = 325;
const float thdbtt = 20;
const float thnb4 = 310;
const float thnbtt = 10;

const float tht1 = 3.5;
const float tht2 = 6;
const float tht3 = 3;
const float tht4 = 4;
const float tht5 = 5;
const float thtt = 10;
//ٻȥ
const float tha1 = 2;
const float tha2 = 8;
const float tha3 = 12;
const float thar = 0.1;
const float than = 0.2;
const float thap = 0.12;
//ɳĮԵٻȥ
const float ths1 = 0.1;
const float ths2 = 4;
const float ths3 = 0.15;
const float ths4 = 345;
const float ths5 = 3;
const float ths6 = 6;
//ոѷջŶȹ㷽
const float thc1 = 310;
const float thc2 = 340;
const float thc3 = 305;
const float thc4 = 320;
const float thc5 = 3;
const float thc6 = 2.5;
const float thc7 = 6;
#pragma endregion


#pragma region  ұ
const int searchTabColCount = 7;   //ұ
const int intervalCount = 5;           //ұֵ
const int solZenCount = 7;         //̫춥Ǹ
const int senZenCount = 7;		   //춥Ǹ
const int solAziCount = 9;		   //λǸʵԷλǸ
const int aod550Count = 9;		   //aod
double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//̫춥
double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
double aod550[aod550Count] = { 0.0001, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6,0.7,0.8};//550nmܽѧ
#pragma endregion 
/////////////////////////////////////////////////////////////////////////////

void CopyIntToFloat (DT_16S * pBuf_16, DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = (double)pBuf_16[i];
	}
}
void CopyUIntToFloat (DT_16U * pBuf_16, DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = (double)pBuf_16[i];
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void JiSuanFanshelv (DT_32F * pBuf, double dScale, double dOffset, int iCount, int iType)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf[i] = (pBuf[i] - dOffset)*dScale;
	}
	double k1, k2;
	double ik1_21 = 3634.171501, ik1_22 = 3634.171501, ik1_31 = 1304.413871, ik1_32 = 1196.978785;
	double ik2_21 = 122461.658403, ik2_22 = 122461.658403, ik2_31 = 729.541636, ik2_32 = 474.684780;
	switch (iType)
	{
	case 21: k1 = ik1_21; k2 = ik2_21; break;
	case 22: k1 = ik1_22; k2 = ik2_22; break;
	case 31: k1 = ik1_31; k2 = ik2_31; break;
	case 32: k1 = ik1_32; k2 = ik2_32; break;
	}
	if (iType == 21 || iType == 31 || iType == 22 || iType == 32)
	{
		for (int i = 0; i<iCount; i++)
		{
			pBuf[i] = k1 / (log(abs((k2 / (pBuf[i] + MIN_VALUE) + 1) + MIN_VALUE)));
		}
	}
}
void JiSuanJiaoDu (DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = pBuf_32[i] * 0.01;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////

int  AODCreateData (const char* charSrcFile2, const char* charSrcFile3, const char* charDstFile)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS2 = (GDALDataset*)GDALOpen (charSrcFile2, GA_ReadOnly);
	if (DS2 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD2;
	}
	char** subdatasets = DS2->GetMetadata ("SUBDATASETS");
#pragma endregion
#pragma region ȡָݼ
	string sub250, sub500, sub1000;
	sub1000 = string (subdatasets[4]); //1000    //3*2-2
	sub1000 = sub1000.substr (sub1000.find_first_of ('=') + 1);
	const char* SrcFile2_1000 = sub1000.c_str ();
	sub250 = string (subdatasets[8]);//250         //5*2-2
	sub250 = sub250.substr (sub250.find_first_of ('=') + 1);
	const char* SrcFile2_250 = sub250.c_str ();
	sub500 = string (subdatasets[14]);//500        //8*2-2
	sub500 = sub500.substr (sub500.find_first_of ('=') + 1);
	const char* SrcFile2_500 = sub500.c_str ();
#pragma endregion
#pragma region ݼȡϢ
	GDALDataset *DS250 = (GDALDataset*)GDALOpen (SrcFile2_250, GA_ReadOnly);
	GDALDataset *DS500 = (GDALDataset*)GDALOpen (SrcFile2_500, GA_ReadOnly);
	GDALDataset *DS1000 = (GDALDataset*)GDALOpen (SrcFile2_1000, GA_ReadOnly);
	int xSize = DS250->GetRasterXSize ();
	int ySize = DS250->GetRasterYSize ();
	GDALDataType datatype = DS250->GetRasterBand (1)->GetRasterDataType ();
	double geoTransform[6] = { 0 };
	DS250->GetGeoTransform (geoTransform);
#pragma endregion 
#pragma region Ŀݼ
	const char* fileFormat = "GTiff";
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (fileFormat);
	//printf("%s\n",Driver->GetDescription());
	GDALDataset *DSDst = Driver->Create (charDstFile, xSize, ySize, 6, GDT_Float32, NULL);
	DSDst->SetProjection (DS250->GetProjectionRef ());
	DSDst->SetGeoTransform (geoTransform);
#pragma endregion 
#pragma region ȡȡoffsetscale
#pragma region ȡԪ
	char** subdatasets250 = DS250->GetMetadata ();
	char** subdatasets500 = DS500->GetMetadata ();
	char** subdatasets1000 = DS1000->GetMetadata ();
#pragma endregion		
#pragma region 
	double douTemp250Offset_1, douTemp250Offset_2, douTemp500Offset_3, douTemp500Offset_5, douTemp500Offset_7, douTemp1000Offset_32;//offset 
	double douTemp250Scale_1, douTemp250Scale_2, douTemp500Scale_3, douTemp500Scale_5, douTemp500Scale_7, douTemp1000Scale_32;//scale
	string strTemp250Offset, strTemp500Offset, strTemp1000Offset;//offset
	string strTemp250Scale, strTemp500Scale, strTemp1000Scale;//scale
	char *charTemp250Offset, *charTemp500Offset, *charTemp1000Offset;
	char *charTemp250Scale, *charTemp500Scale, *charTemp1000Scale;
	const char* commas = ",";
#pragma endregion	
#pragma region 250-offset-scale
	strTemp250Offset = (string)(subdatasets250[118]);
	strTemp250Offset = strTemp250Offset.substr (strTemp250Offset.find_first_of ("=") + 1);
	charTemp250Offset = strtok ((char*)strTemp250Offset.c_str (), commas);
	douTemp250Offset_1 = CPLScanDouble (charTemp250Offset, 20);
	charTemp250Offset = strtok (NULL, commas);
	douTemp250Offset_2 = CPLScanDouble (charTemp250Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp250Scale = (string)(subdatasets250[119]);
	strTemp250Scale = strTemp250Scale.substr (strTemp250Scale.find_first_of ("=") + 1);
	charTemp250Scale = strtok ((char*)strTemp250Scale.c_str (), commas);
	douTemp250Scale_1 = CPLScanDouble (charTemp250Scale, 20);
	charTemp250Scale = strtok (NULL, commas);
	douTemp250Scale_2 = CPLScanDouble (charTemp250Scale, 20);
#pragma endregion
#pragma region 500-offset-scale
	strTemp500Offset = (string)(subdatasets500[118]);
	strTemp500Offset = strTemp500Offset.substr (strTemp500Offset.find_first_of ("=") + 1);
	charTemp500Offset = strtok ((char*)strTemp500Offset.c_str (), commas);
	douTemp500Offset_3 = CPLScanDouble (charTemp500Offset, 20);
	charTemp500Offset = strtok (NULL, commas);
	charTemp500Offset = strtok (NULL, commas);
	douTemp500Offset_5 = CPLScanDouble (charTemp500Offset, 20);
	charTemp500Offset = strtok (NULL, commas);
	charTemp500Offset = strtok (NULL, commas);
	douTemp500Offset_7 = CPLScanDouble (charTemp500Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp500Scale = (string)(subdatasets500[119]);
	strTemp500Scale = strTemp500Scale.substr (strTemp500Scale.find_first_of ("=") + 1);
	charTemp500Scale = strtok ((char*)strTemp500Scale.c_str (), commas);
	douTemp500Scale_3 = CPLScanDouble (charTemp500Scale, 20);
	charTemp500Scale = strtok (NULL, commas);
	charTemp500Scale = strtok (NULL, commas);
	douTemp500Scale_5 = CPLScanDouble (charTemp500Scale, 20);
	charTemp500Scale = strtok (NULL, commas);
	charTemp500Scale = strtok (NULL, commas);
	douTemp500Scale_7 = CPLScanDouble (charTemp500Scale, 20);


#pragma endregion
#pragma region 1000-offset-scale
	strTemp1000Offset = (string)(subdatasets1000[108]);
	strTemp1000Offset = strTemp1000Offset.substr (strTemp1000Offset.find_first_of ("=") + 1);
	charTemp1000Offset = strtok ((char*)strTemp1000Offset.c_str (), commas);
	for (int i = 0; i<11; i++)
	{
		charTemp1000Offset = strtok (NULL, commas);
	}
	douTemp1000Offset_32 = CPLScanDouble (charTemp1000Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp1000Scale = (string)(subdatasets1000[109]);
	strTemp1000Scale = strTemp1000Scale.substr (strTemp1000Scale.find_first_of ("=") + 1);
	charTemp1000Scale = strtok ((char*)strTemp1000Scale.c_str (), commas);
	for (int i = 0; i<11; i++)
	{
		charTemp1000Scale = strtok (NULL, commas);
	}
	douTemp1000Scale_32 = CPLScanDouble (charTemp1000Scale, 20);
#pragma endregion
#pragma endregion 		
#pragma region д6οѧ رݼ
	if (datatype == GDT_UInt16)
	{
		DT_32F *pBuf_32 = new DT_32F[xSize*ySize];
		DT_16U *pBuf_16 = new DT_16U[xSize*ySize];
		GDALRasterBand *band1 = DSDst->GetRasterBand (1);
		GDALRasterBand *band2 = DSDst->GetRasterBand (2);
		GDALRasterBand *band3 = DSDst->GetRasterBand (3);
		GDALRasterBand *band4 = DSDst->GetRasterBand (4);
		GDALRasterBand *band5 = DSDst->GetRasterBand (5);
		GDALRasterBand *band6 = DSDst->GetRasterBand (6);
		DS250->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp250Scale_1, douTemp250Offset_1, xSize*ySize, 1);
		band1->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д1(band1-0.66)
		DS250->GetRasterBand (2)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp250Scale_2, douTemp250Offset_2, xSize*ySize, 2);
		band2->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д2(band2-0.86)
		DS500->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//2
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_3, douTemp500Offset_3, xSize*ySize, 3);
		band3->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д3(band3-0.47)
		DS500->GetRasterBand (3)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//3
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_5, douTemp500Offset_5, xSize*ySize, 5);
		band4->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д4(band5-1.24)
		DS500->GetRasterBand (5)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//4
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_7, douTemp500Offset_7, xSize*ySize, 7);
		band5->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д5(band7-2.1)
		DS1000->GetRasterBand (12)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//5
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp1000Scale_32, douTemp1000Offset_32, xSize*ySize, 32);
		band6->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д6(band32-12)
		delete[]pBuf_16;
		delete[]pBuf_32;
	}
	GDALClose (GDALDatasetH (DS250));
	GDALClose (GDALDatasetH (DS500));
	GDALClose (GDALDatasetH (DS1000));
	GDALClose (GDALDatasetH (DSDst));
	GDALClose (GDALDatasetH (DS2));
	return RE_SUCCESS;
#pragma endregion 
}
int AODCreateAngel (const char* SrcFile2, const char* SrcFile3, const char* DstFile)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS3 = (GDALDataset*)GDALOpen (SrcFile3, GA_ReadOnly);
	if (DS3 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD3;
	}
	char** subdatasets = DS3->GetMetadata ("SUBDATASETS");
#pragma endregion
#pragma region ȡָݼ
	string strSensorZenith, strSensorAzimuth, strSolarZenith, strSolarAzimuth, strLanSea;
	strSensorZenith = string (subdatasets[8]);
	strSensorZenith = strSensorZenith.substr (strSensorZenith.find_first_of ('=') + 1);
	const char* charSensorZenith = strSensorZenith.c_str ();

	strSensorAzimuth = string (subdatasets[10]);
	strSensorAzimuth = strSensorAzimuth.substr (strSensorAzimuth.find_first_of ('=') + 1);
	const char* charSensorAzimuth = strSensorAzimuth.c_str ();

	strSolarZenith = string (subdatasets[14]);
	strSolarZenith = strSolarZenith.substr (strSolarZenith.find_first_of ('=') + 1);
	const char* charSolarZenith = strSolarZenith.c_str ();

	strSolarAzimuth = string (subdatasets[16]);
	strSolarAzimuth = strSolarAzimuth.substr (strSolarAzimuth.find_first_of ('=') + 1);
	const char* charSolarAzimuth = strSolarAzimuth.c_str ();

	strLanSea = string (subdatasets[18]);
	strLanSea = strLanSea.substr (strLanSea.find_first_of ('=') + 1);
	const char* charLanSea = strLanSea.c_str ();
#pragma endregion
#pragma region ݼȡϢ
	GDALDataset *DSSensorZenith = (GDALDataset*)GDALOpen (charSensorZenith, GA_ReadOnly);
	GDALDataset *DSSensorAzimuth = (GDALDataset*)GDALOpen (charSensorAzimuth, GA_ReadOnly);
	GDALDataset *DSSolarZenith = (GDALDataset*)GDALOpen (charSolarZenith, GA_ReadOnly);
	GDALDataset *DSSolarAzimuth = (GDALDataset*)GDALOpen (charSolarAzimuth, GA_ReadOnly);
	GDALDataset *DSLanSea = (GDALDataset*)GDALOpen (charLanSea, GA_ReadOnly);
	int xSize = DSSensorZenith->GetRasterXSize ();
	int ySize = DSSensorZenith->GetRasterYSize ();
	GDALDataType datatype = DSSensorZenith->GetRasterBand (1)->GetRasterDataType ();
	double geoTransform[6] = { 0 };
	DSSensorZenith->GetGeoTransform (geoTransform);
#pragma endregion 
#pragma region Ŀݼ
	const char* fileFormat = "GTiff";
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (fileFormat);
	GDALDataset *DSDst = Driver->Create (DstFile, xSize, ySize, 5, GDT_Float32, NULL);
	DSDst->SetProjection (DSSensorZenith->GetProjectionRef ());
	DSDst->SetGeoTransform (geoTransform);
#pragma endregion 	
#pragma region д4νǶ رݼ


	if (datatype == GDT_Int16)
	{
		DT_32F *pBuf_32 = new DT_32F[xSize*ySize];
		DT_16S *pBuf_16 = new DT_16S[xSize*ySize];
		GDALRasterBand *band1 = DSDst->GetRasterBand (1);
		GDALRasterBand *band2 = DSDst->GetRasterBand (2);
		GDALRasterBand *band3 = DSDst->GetRasterBand (3);
		GDALRasterBand *band4 = DSDst->GetRasterBand (4);
		GDALRasterBand *band5 = DSDst->GetRasterBand (5);
		DSSensorZenith->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band1->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д1
		DSSensorAzimuth->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//2
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band2->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д2
		DSSolarZenith->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//3
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band3->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д3
		DSSolarAzimuth->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//4
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band4->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д4


		DSLanSea->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		band5->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0);  //д

		delete[]pBuf_16;
		delete[]pBuf_32;
	}
	GDALClose (GDALDatasetH (DSSensorZenith));
	GDALClose (GDALDatasetH (DSSensorAzimuth));
	GDALClose (GDALDatasetH (DSSolarZenith));
	GDALClose (GDALDatasetH (DSSolarAzimuth));
	GDALClose (GDALDatasetH (DSDst));
	GDALClose (GDALDatasetH (DS3));
	GDALClose (GDALDatasetH (DSLanSea));
	return RE_SUCCESS;
#pragma endregion 
}
//int AODGetGeolocOfModis3 (const char* SrcFile3, char ***geoloc)
//{
//#pragma region עݼ
//	GDALAllRegister ();
//	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
//	GDALDataset *DS3 = (GDALDataset*)GDALOpen (SrcFile3, GA_ReadOnly);
//	char **subdatasets = GDALGetMetadata ((GDALDatasetH)DS3, "SUBDATASETS");
//#pragma endregion
//#pragma region ȡγݼ͵һݼ
//	string strSubDataset_1 = string (subdatasets[0]);//һݼ
//	strSubDataset_1 = strSubDataset_1.substr (strSubDataset_1.find_first_of ("=") + 1);
//	const char* SrcFile3_1 = strSubDataset_1.c_str ();
//
//	string strLat = string (subdatasets[24]);//lat
//	strLat = strLat.substr (strLat.find_first_of ("=") + 1);
//	const char* charLat = strLat.c_str ();
//
//	string strLon = string (subdatasets[26]);//lon
//	strLon = strLon.substr (strLon.find_first_of ("=") + 1);
//	const char* charLon = strLon.c_str ();
//#pragma endregion 
//#pragma region ȡһݼgeoloc
//	GDALDataset *DS3_1 = (GDALDataset*)GDALOpen (SrcFile3_1, GA_ReadOnly);
//	char **geolocOptions3 = DS3_1->GetMetadata ("GEOLOCATION");
//	char **geolocOptions = geolocOptions3;
//	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
//	if (geolocOptions3 == NULL)
//	{
//
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_OFFSET", "0");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_OFFSET", "0");
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "X_BAND", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "Y_BAND", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "X_DATASET", charLon);
//		geolocOptions = CSLSetNameValue (geolocOptions, "Y_DATASET", charLat);
//	}
//	else
//	{
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
//	}
//	for (int i = 0; i<8; i++)
//	{
//		strcpy ((*geoloc)[i], geolocOptions[i]);
//		/*if (geolocOptions[i]!=NULL)
//		{
//		delete []geolocOptions[i];
//		}*/
//	}
//	/*if (geolocOptions!=NULL)
//	{
//	delete []geolocOptions;
//	}*/
//	GDALClose (GDALDatasetH (DS3_1));
//	GDALClose (GDALDatasetH (DS3));
//	/*char** geoloc =new char *[8] ;
//	for (int i=0;i<8;i++)
//	{
//	geoloc[i]=(char*)(strarrgeoloc[i].c_str());
//	}*/
//	return RE_SUCCESS;
//#pragma endregion 	
//}
void AODInitialize (const char* charGeolocData, const char* charGeolocAngel)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DSData = (GDALDataset*)GDALOpen (charGeolocData, GA_ReadOnly);
	GDALDataset *DSAngel = (GDALDataset*)GDALOpen (charGeolocAngel, GA_ReadOnly);
	int dataBandCount = DSData->GetRasterCount ();
	int angelBandCount = DSAngel->GetRasterCount ();
	GDALDataType dataType = DSData->GetRasterBand (1)->GetRasterDataType ();
	width = DSData->GetRasterXSize ();
	height = DSData->GetRasterYSize ();
#pragma endregion	
#pragma region  ̬Ķ
	band_1 = new float*[height];
	band_2 = new float*[height];
	band_3 = new float*[height];
	band_5 = new float*[height];
	band_7 = new float*[height];
	band_32 = new float*[height];
	aodndvi = new float*[height];//ndvi
	sensorzenith = new float*[height];//ĸǶ+ 1Էλ
	sensorazimuth = new float*[height];
	solarzenith = new float*[height];
	solarazimuth = new float*[height];
	relativeangel = new float*[height];
	lansea = new float*[height]; // ½
	suf_band_1 = new float*[height]; //ر
	suf_band_3 = new float*[height];
	aodOptimal = new float*[height]; //aod
	testresult = new test_result*[height];
	for (int i = 0; i<height; i++)
	{
		band_1[i] = new float[width];
		band_2[i] = new float[width];
		band_3[i] = new float[width];
		band_5[i] = new float[width];
		band_7[i] = new float[width];
		band_32[i] = new float[width];

		aodndvi[i] = new float[width];

		sensorzenith[i] = new float[width];
		sensorazimuth[i] = new float[width];
		solarzenith[i] = new float[width];
		solarazimuth[i] = new float[width];
		relativeangel[i] = new float[width];
		lansea[i] = new float[width];

		suf_band_1[i] = new float[width];
		suf_band_3[i] = new float[width];
		aodOptimal[i] = new float[width];
		testresult[i] = new test_result[width];
	}
#pragma endregion
#pragma region ̬ĳʼ
	//DT_64F *pBuf = (DT_64F*)malloc(sizeof(DT_64F)*width*height);
	DT_32F *pBuf = new DT_32F[width*height];
	int p = 0;
#pragma region ݲεĳʼ
	for (int i = 0; i<dataBandCount; i++)
	{
		if (dataType == GDT_Float32)
		{

			DSData->GetRasterBand (i + 1)->RasterIO (GF_Read, 0, 0, width, height, pBuf, width, height, dataType, 0, 0);
			p = 0;
			for (int j = 0; j<height; j++)
			{
				for (int k = 0; k<width; k++)
				{
					switch (i + 1)
					{
					case 1:band_1[j][k] = pBuf[p++];
						break;
					case 2:band_2[j][k] = pBuf[p++];
						break;
					case 3:band_3[j][k] = pBuf[p++];
						break;
					case 4:band_5[j][k] = pBuf[p++];
						break;
					case 5:band_7[j][k] = pBuf[p++];
						break;
					case 6:band_32[j][k] = pBuf[p++];
						break;
					}
				}
			}
		}
	}
#pragma endregion 
#pragma region ǶȲεĳʼ
	//ʼ4Ƕ
	for (int i = 0; i<angelBandCount; i++)
	{
		//DT_64F *pBuf = new DT_64F[width*height];int p=0;
		DSAngel->GetRasterBand (i + 1)->RasterIO (GF_Read, 0, 0, width, height, pBuf, width, height, dataType, 0, 0);
		int p = 0;
		for (int j = 0; j<height; j++)
		{
			for (int k = 0; k<width; k++)
			{
				switch (i + 1)
				{
				case 1:sensorzenith[j][k] = pBuf[p++];
					break;
				case 2:sensorazimuth[j][k] = pBuf[p++];
					break;
				case 3:solarzenith[j][k] = pBuf[p++];
					break;
				case 4:solarazimuth[j][k] = pBuf[p++];
					break;
				case 5:lansea[j][k] = pBuf[p++];
					break;
				}
			}
		}
	}
#pragma endregion 
	delete[]pBuf;
#pragma region ̬ĳʼ
	double senZen, senAzi, solZen, solAzi, relAng;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			testresult[i][j] = unknow;//
			aodndvi[i][j] = (band_5[i][j] - band_7[i][j]) / (band_5[i][j] + band_7[i][j]);//ndviĳʼ
			suf_band_1[i][j] = 0;
			suf_band_3[i][j] = 0;
			aodOptimal[i][j] = 0;
			//ԽǶȵĳʼ
			senZen = RAD_PER_DEG*sensorzenith[i][j];
			senAzi = RAD_PER_DEG*sensorazimuth[i][j];
			solZen = RAD_PER_DEG*solarzenith[i][j];
			solAzi = RAD_PER_DEG*solarazimuth[i][j];
			relAng = solAzi - senAzi;
			if (relAng<M_PI*(-1))
			{
				relAng += 2 * M_PI;
			}
			else if (relAng>M_PI)
			{
				relAng -= 2 * M_PI;
			}
			relAng += M_PI;//-pi~piת 0~2pi;
			//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * sin(senZen) * cos(relAng));
			//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * cos(relAng));
			relativeangel[i][j] = relAng;
		}
	}
#pragma endregion 
	GDALClose (GDALDatasetH (DSData));
	GDALClose (GDALDatasetH (DSAngel));

#pragma endregion	
}
void AODGetSeason (const char* SrcFile2)
{
	//"E:\\fire2\\firetest\\MOD279\\0220\\MOD021KM.A2014279.0220.006.2014283045932.hdf";
	string tempFileName = string (CPLGetFilename (SrcFile2));
	tempFileName = tempFileName.substr (tempFileName.find_last_of ("hdf") - 29, 3);
	seasonDay = (int)CPLScanDouble (tempFileName.c_str (), 20);
}
void AODDestroy ()
{
	for (int i = 0; i<height; i++)
	{
		RELEASE (band_1[i]);
		RELEASE (band_2[i]);
		RELEASE (band_3[i]);
		RELEASE (band_5[i]);
		RELEASE (band_7[i]);
		RELEASE (band_32[i]);
		RELEASE (aodndvi[i]);
		RELEASE (sensorzenith[i]);
		RELEASE (sensorazimuth[i]);
		RELEASE (solarzenith[i]);
		RELEASE (solarazimuth[i]);
		RELEASE (relativeangel[i]);
		RELEASE (lansea[i]);
		RELEASE (suf_band_1[i]);
		RELEASE (suf_band_3[i]);
		RELEASE (aodOptimal[i]);
		RELEASE (testresult[i]);
	}	
	RELEASE (band_1);
	RELEASE (band_2);
	RELEASE (band_3);
	RELEASE (band_5);
	RELEASE (band_7);
	RELEASE (band_32);
	RELEASE (aodndvi);
	RELEASE (sensorzenith);
	RELEASE (sensorazimuth);
	RELEASE (solarzenith);
	RELEASE (solarazimuth);
	RELEASE (relativeangel);
	RELEASE (lansea);
	RELEASE (suf_band_1);
	RELEASE (suf_band_3);
	RELEASE (aodOptimal);
	RELEASE (testresult);
}
void AODIdentifyCloudAndWater ()
{
	//pr:Ԫں첨(0.66)ı۷band1
	//pn:ԪڽⲨ(0.86)ı۷band2
	//t12:ԪȺⲨΣ12um¶band32
	//t2:Ԫ2.12umθı۷band7
	float pr, pn, t12, t2;
	float senZen, solZen;

	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (!(fabs((double)lansea[i][j] - 1.0)<MIN_VALUE) || fabs((double)lansea[i][j] - 2.0)<MIN_VALUE)//ʶˮ
			{
				testresult[i][j] = shui;
			}
		}
	}
	//ʶ
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			pr = band_1[i][j];
			pn = band_2[i][j];
			t12 = band_32[i][j];
			if (testresult[i][j] != shui)
			{
				if ((pr + pn>th1) || (t12<th3) || ((pr + pn)>th2 && t12<th4))
				{
					testresult[i][j] = yun;
				}
			}

		}
	}

	//ʶԪ
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] != yun)
			//if (testresult[i][j] != yun	&& testresult[i][j] != shui)//ˮĻʶԪ
			{
				t2 = band_7[i][j];
				senZen = RAD_PER_DEG*sensorzenith[i][j];
				solZen = RAD_PER_DEG*solarzenith[i][j];
				////if (t2>0.01 && t2<0.125 * (1 / cos (senZen) + 1 / (pow (cos ((double)solZen), 0.5))))//µķ
				////{
				////	testresult[i][j] = anxiangyuan;
				////}
				if (t2>0.01 && t2<0.4)
				{
				testresult[i][j]=anxiangyuan;
				}
			}
		}
	}
}
int AODOutputOther (const char* charSrcFile, const char* charDstFile, test_result res)
{
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILEAME_IS_UTF8", "NO");
	GDALDataset *SrcDS = (GDALDataset*)GDALOpen (charSrcFile, GA_ReadOnly);
	double geoTransform[6] = { 0 };
	SrcDS->GetGeoTransform (geoTransform);
	int xSize = SrcDS->GetRasterXSize ();
	int ySize = SrcDS->GetRasterYSize ();
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	GDALDataset *DstDS = Driver->Create (charDstFile, xSize, ySize, 1, GDT_Int32, NULL);
	DstDS->SetProjection (SrcDS->GetProjectionRef ());
	DstDS->SetGeoTransform (geoTransform);
	//DT_32S *pBuf = (DT_32S*)malloc(sizeof(DT_32S)*width*height);
	DT_32S *pBuf = new DT_32S[width*height];
	int p = 0;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == res)
			{
				pBuf[p] = 1;
			}
			else
			{
				pBuf[p] = 0;
			}
			p++;
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, width, height, pBuf, width, height, GDT_Int32, 0, 0);
	delete[]pBuf;
	GDALClose (GDALDatasetH (SrcDS));
	GDALClose (GDALDatasetH (DstDS));
	return RE_SUCCESS;
}
void AODConfirmSurfaceReflectance ()
{
	//senZen:۲⣨춥
	//senAzi:۲⣨Էλ
	//solZen:̫춥
	//solAzi:̫λ
	//scaAngɢ
	//relAng:Էλ
	float senZen, senAzi, solZen, solAzi, scaAng, relAng;
	float slope_066_212_scale, slope_066_212_offset;
	float slope_ndvi_066_212_scale, slope_ndvi_066_212_offset;
	float slope_047_066_scale = 0.49, slope_047_066_offset = 0.005;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				senZen = RAD_PER_DEG*sensorzenith[i][j];
				senAzi = RAD_PER_DEG*sensorazimuth[i][j];
				solZen = RAD_PER_DEG*solarzenith[i][j];
				solAzi = RAD_PER_DEG*solarazimuth[i][j];
				//relAng=solAzi-senAzi;
				//if (relAng<M_PI*(-1))
				//{
				//	relAng+=2*M_PI;
				//}
				//else if (relAng>M_PI)
				//{
				//	relAng-=2*M_PI;
				//}
				//relAng+=M_PI;//-pi~piת 0~2pi;
				scaAng = acos ((-1) * cos (solZen) * cos (senZen) + sin (solZen) * sin (senZen) * cos (relativeangel[i][j]));
				//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * cos(relAng));
				//v5.2ݷ
				if (band_7[i][j] >= 0.01 && band_7[i][j] <= 0.25)
				{
					if (aodndvi[i][j]<0.25)
					{
						slope_ndvi_066_212_scale = 0.48;
					}
					else if (aodndvi[i][j]>0.75)
					{
						slope_ndvi_066_212_scale = 0.58;
					}
					else
					{
						slope_ndvi_066_212_scale = 0.48 + 0.2*(aodndvi[i][j] - 0.25);
					}
					slope_066_212_scale = slope_ndvi_066_212_scale + 0.002* scaAng - 0.27;
					slope_066_212_offset = 0.00025 * scaAng + 0.033;
					suf_band_1[i][j] = band_7[i][j] * slope_066_212_scale + slope_066_212_offset;
					suf_band_3[i][j] = suf_band_1[i][j] * slope_047_066_scale + slope_047_066_offset;

				}
				else if (band_7[i][j]>0.25)
				{
					suf_band_1[i][j] = band_7[i][j] / 2;
					suf_band_3[i][j] = band_7[i][j] / 4;
				}

				////չԪ
				//	 suf_band_1[i][j]=band_7[i][j]/2;
				//	 suf_band_3[i][j]=band_7[i][j]/4;
				//BRDF
				// AOD ݹѵرΪʲԴ ַ˵رṹķԶԵر
				//Ӱ죮 ǵرԶԵرʵӰ죬 

			}
		}
	}
}
float Mean(double* err, int length, double* aod550)
{




#pragma region old 
	double temp = 1.0;
	double sum = 0.0;
	double k = 0;
	double min1 = 10000;
	int min1pos = -1;
	int min2pos = -1;
	double min2 = 10000;
	//ҵСֵ
	for (int i = 0; i < length; i++)
	{
		if (err[i] <min1)
		{
			min1 = err[i];
			min1pos = i;
		}
	}
	//ҵ2Сֵ
	for (int  i = 0; i < length; i++)
	{
		if ((!(fabs(err[i] - min1) < MIN_VALUE)) && err[i] < min2)
		{
			min2 = err[i];
			min2pos = i;
		}

	}
	//return (min2  *aod550[min1pos] + min1 * aod550[min2pos]) / (min1 +  min2);
	return (min2 *min2 *aod550[min1pos] + min1* min1  * aod550[min2pos]) / (min1*min1 + min2* min2);
#pragma endregion 
	//////////////////////////////////////
	//for (int i = 0; i < length; i++)
	//{
	//	temp *= err[i];
	//}
	//for (int i = 0; i < length; i++)
	//{
	//	sum += temp / err[i] * aod550[i];
	//}
	//for (int i = 0; i < length; i++)
	//{
	//	k += temp / err[i];
	//}
	//return (sum)/k;

}




//ӲұлȡǸŻкŴ0 ʼġ
//void SearchOptimalResultFromOld(int i, int j, int* trueRow)
//{
//	int searchSolZen = 0, searchSenZen = 0, searchRelAzi = 0;
//	int trueSolzen = 0, trueSenZen = 0, trueRelAzi = 0;
//	int trueRow = 0;
//	float minthereflectivity = 0, thereflectivity = 0;
//
//	searchSolZen = solZenCount - 1, searchSenZen = senZenCount - 1, searchRelAzi = solAziCount - 1;//Ĭֵ
//	minthereflectivity = 1000000000;//minvalΪ㹻ֵ
//	float devk1 = 0, devk2 = 0, devk3 = 0;
//	float devkk1 = 0, devkk2, devkk3 = 0;
//
//
//	for (int k = 0; k<solZenCount; k++)
//	{
//		if (solarzenith[i][j]<solZen[k])
//		{
//			searchSolZen = k;
//			break;
//		}
//	}
//	for (int k = 0; k<senZenCount; k++)
//	{
//		if (sensorzenith[i][j]<senZen[k])
//		{
//			searchSenZen = k;
//			break;
//		}
//	}
//	for (int k = 0; k<solAziCount; k++)
//	{
//		if ((relativeangel[i][j])<solAzi[k])
//		{
//			searchRelAzi = k;
//			break;
//		}
//	}
//	devk1 = solZen[searchSolZen] - solZen[searchSolZen - 1];
//	devk2 = senZen[searchSenZen] - senZen[searchSenZen - 1];
//	devk3 = solAzi[searchRelAzi] - solAzi[searchRelAzi - 1];
//	if (solarzenith[i][j]>(solZen[searchSolZen - 1] + solZen[searchSolZen]) / 2)
//	{
//		devkk1 = abs(solarzenith[i][j] - solZen[searchSolZen]);
//		trueSolzen = searchSolZen;
//	}
//	else
//	{
//		devkk1 = abs(solarzenith[i][j] - solZen[searchSolZen - 1]);
//		trueSolzen = searchSolZen - 1;
//	}
//	if (sensorzenith[i][j]>(senZen[searchSenZen - 1] + senZen[searchSenZen]) / 2)
//	{
//		devkk2 = abs(sensorzenith[i][j] - senZen[searchSenZen]);
//		trueSenZen = searchSenZen;
//	}
//	else
//	{
//		devkk2 = abs(sensorzenith[i][j] - senZen[searchSenZen - 1]);
//		trueSenZen = searchSenZen - 1;
//	}
//	if (solarazimuth[i][j]>(solAzi[searchRelAzi - 1] + solAzi[searchRelAzi]) / 2)
//	{
//		devkk3 = abs(solarazimuth[i][j] - solAzi[searchRelAzi]);
//		trueRelAzi = searchRelAzi;
//	}
//	else
//	{
//		devkk3 = abs(solarazimuth[i][j] - solAzi[searchRelAzi - 1]);
//		trueRelAzi = searchRelAzi - 1;
//	}
//	/*
//	const int solZenCount = 8;
//	const int senZenCount = 7;
//	const int solAziCount = 9;
//	const int aod550Count = 6;
//	*/
//	*trueRow = (senZenCount * solAziCount) * trueSolzen + (solAziCount)* trueSenZen + (1) * trueRelAzi;
//}
//
//float CalulateInterpolation(int i, int j, float** inTable , int inTableCol, int  inTableRow)
//{
//	int row = i / intervalCount;
//	int row2 = i % intervalCount;
//	float f0= inTable[row][j];
//	float f1 = inTable[row + 1][j];
//	float x = ((float)row2) / intervalCount;
//	return f0 * (1 - x) + f1 * x;
//
//
//	//int row = i / inTableRow;
//	//int col = j/ inTableCol;
//	//int row2 = i%inTableRow;
//	//int col2 = j%inTableCol;
//	//float f00 = inTable[row][col];
//	//float f10 = inTable[row + 1][col];
//	//float f01 = inTable[row][col + 1];
//	//float f11 = inTable[row + 1][col + 1];
//	//float x =((float) row2 )  / inTableRow;
//	//float y = ((float)col2)  / inTableCol;
//	////f(x, y) = f(0, 0)(1 - x)(1 - y) + f(0, 1)(1 - x)y + f(1, 1)xy + f(1, 0)x(1 - y)
//	//float fxy = f00 * (1 - x)*(1 - y ) + f01 * (1 - x) * y + f11 * x * y + f10 * x * (1 - y);
//	//return   fxy;
//}
//void CreateNewSeachTable(float** inTable, float ** outTable, int inTableCol,int  inTableRow, int outTableCol, int outTableRow)
//{
//
//	//const int searchTabColCount = 7;   //ұ
//	//const int  intervalCount = 5;           //ұֵ
//	//const int solZenCount = 8;         //̫춥Ǹ
//	//const int senZenCount = 7;		   //춥Ǹ
//	//const int solAziCount = 9;		   //λǸʵԷλǸ
//	//const int aod550Count = 6;		   //aod
//	//double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 72, 84 };//̫춥
//	//double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
//	//double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
//	//double aod550[aod550Count] = { 0.0001, 0.25, 0.5, 1.0, 1.5, 1.95 };//550nmܽѧ
//	//for (int  i = 0; i < inTableRow; i++)
//	//{
//	//	for (int  j = 0; j < inTableCol; j++)
//	//	{    
//	//		//outTable
//	//		for (int k1 = 0; k1 <intervalCount; k1++)
//	//		{
//	//			for (int k2 = 0; k2 < intervalCount; k2++)
//	//			{
//	//				outTable[i*intervalCount + k1][j*intervalCount + k2] = calculate(inTable[i][j], inTable[i][], k1, k2);
//	//			}
//	//		}
//	//		//outTable[i*intervalCount +k1]
//	//	}
//	//}
//	//for (int  i = 0; i < outTableRow; i++)
//	//{
//	//	for (int  j = 0; j < outTableCol; j++)
//	//	{
//	//		outTable[i][j] = CalulateInterpolation(i, j, inTable , inTableCol, inTableRow);
//	//	}
//	//}
//
//
//	for (int i = 0; i < outTableRow -1; i++)
//	{
//		for (int  j = 0; j < outTableCol; j++)
//		{
//			outTable[i][j] = CalulateInterpolation(i, j, inTable, inTableCol, inTableRow);
//
//		}
//	}
//
//
//
//}

//float SearchOptimalResultFromNew(int x, int y, float** outTable, int  outTableRow, int  outTableCol)
//{
//
//	for (int i = 0; i < outTableRow; i++)
//	{
//		
//		for (int  i = 0; i < outTableCol; i++)
//		{
//
//
//		}
//
//	}
//	
//}




void AODCalculate ()
{
	
	//const int searchTabColCount = 7;   //ұ
	//const int  intervalCount = 5;           //ұֵ
	//const int solZenCount = 8;         //̫춥Ǹ
	//const int senZenCount = 7;		   //춥Ǹ
	//const int solAziCount = 9;		   //λǸʵԷλǸ
	//const int aod550Count = 6;		   //aod
	//double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 72, 84 };//̫춥
	//double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
	//double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
	//double aod550[aod550Count] = { 0.0001, 0.25, 0.5, 1.0, 1.5, 1.95 };//550nmܽѧ


	
#pragma region ļұ
	float aodSumSearchTable[solZenCount * senZenCount *solAziCount *aod550Count][searchTabColCount] =
	{ { 0.04620, 0.95050, 0.01940, 0, 0, 0, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 24, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 48, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 72, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 96, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 120, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 144, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 168, 0.0001 },
	{ 0.04620, 0.95050, 0.01940, 0, 0, 180, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 0, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 24, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 48, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 72, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 96, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 120, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 144, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 168, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 0, 12, 180, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 0, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 24, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 48, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 72, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 96, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 120, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 144, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 168, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 0, 24, 180, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 0, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 24, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 48, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 72, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 96, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 120, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 144, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 168, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 0, 36, 180, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 0, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 24, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 48, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 72, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 96, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 120, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 144, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 168, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 0, 48, 180, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 0, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 24, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 48, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 72, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 96, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 120, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 144, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 168, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 0, 60, 180, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 0, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 24, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 48, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 72, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 96, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 120, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 144, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 168, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 0, 66, 180, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 0, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 24, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 48, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 72, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 96, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 120, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 144, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 168, 0.0001 },
	{ 0.04620, 0.94997, 0.01941, 12, 0, 180, 0.0001 },
	{ 0.04620, 0.94944, 0.02026, 12, 12, 0, 0.0001 },
	{ 0.04620, 0.94944, 0.02019, 12, 12, 24, 0.0001 },
	{ 0.04620, 0.94944, 0.01998, 12, 12, 48, 0.0001 },
	{ 0.04620, 0.94944, 0.01969, 12, 12, 72, 0.0001 },
	{ 0.04620, 0.94944, 0.01935, 12, 12, 96, 0.0001 },
	{ 0.04620, 0.94944, 0.01904, 12, 12, 120, 0.0001 },
	{ 0.04620, 0.94944, 0.01879, 12, 12, 144, 0.0001 },
	{ 0.04620, 0.94944, 0.01866, 12, 12, 168, 0.0001 },
	{ 0.04620, 0.94944, 0.01864, 12, 12, 180, 0.0001 },
	{ 0.04620, 0.94772, 0.02121, 12, 24, 0, 0.0001 },
	{ 0.04620, 0.94772, 0.02106, 12, 24, 24, 0.0001 },
	{ 0.04620, 0.94772, 0.02065, 12, 24, 48, 0.0001 },
	{ 0.04620, 0.94772, 0.02006, 12, 24, 72, 0.0001 },
	{ 0.04620, 0.94772, 0.01940, 12, 24, 96, 0.0001 },
	{ 0.04620, 0.94772, 0.01879, 12, 24, 120, 0.0001 },
	{ 0.04620, 0.94772, 0.01833, 12, 24, 144, 0.0001 },
	{ 0.04620, 0.94772, 0.01809, 12, 24, 168, 0.0001 },
	{ 0.04620, 0.94772, 0.01806, 12, 24, 180, 0.0001 },
	{ 0.04620, 0.94438, 0.02245, 12, 36, 0, 0.0001 },
	{ 0.04620, 0.94438, 0.02222, 12, 36, 24, 0.0001 },
	{ 0.04620, 0.94438, 0.02160, 12, 36, 48, 0.0001 },
	{ 0.04620, 0.94438, 0.02072, 12, 36, 72, 0.0001 },
	{ 0.04620, 0.94438, 0.01977, 12, 36, 96, 0.0001 },
	{ 0.04620, 0.94438, 0.01891, 12, 36, 120, 0.0001 },
	{ 0.04620, 0.94438, 0.01828, 12, 36, 144, 0.0001 },
	{ 0.04620, 0.94438, 0.01795, 12, 36, 168, 0.0001 },
	{ 0.04620, 0.94438, 0.01790, 12, 36, 180, 0.0001 },
	{ 0.04620, 0.93834, 0.02445, 12, 48, 0, 0.0001 },
	{ 0.04620, 0.93834, 0.02414, 12, 48, 24, 0.0001 },
	{ 0.04620, 0.93834, 0.02332, 12, 48, 48, 0.0001 },
	{ 0.04620, 0.93834, 0.02218, 12, 48, 72, 0.0001 },
	{ 0.04620, 0.93834, 0.02097, 12, 48, 96, 0.0001 },
	{ 0.04620, 0.93834, 0.01992, 12, 48, 120, 0.0001 },
	{ 0.04620, 0.93834, 0.01917, 12, 48, 144, 0.0001 },
	{ 0.04620, 0.93834, 0.01879, 12, 48, 168, 0.0001 },
	{ 0.04620, 0.93834, 0.01874, 12, 48, 180, 0.0001 },
	{ 0.04620, 0.92674, 0.02847, 12, 60, 0, 0.0001 },
	{ 0.04620, 0.92674, 0.02809, 12, 60, 24, 0.0001 },
	{ 0.04620, 0.92674, 0.02706, 12, 60, 48, 0.0001 },
	{ 0.04620, 0.92674, 0.02567, 12, 60, 72, 0.0001 },
	{ 0.04620, 0.92674, 0.02426, 12, 60, 96, 0.0001 },
	{ 0.04620, 0.92674, 0.02311, 12, 60, 120, 0.0001 },
	{ 0.04620, 0.92674, 0.02233, 12, 60, 144, 0.0001 },
	{ 0.04620, 0.92674, 0.02195, 12, 60, 168, 0.0001 },
	{ 0.04620, 0.92674, 0.02191, 12, 60, 180, 0.0001 },
	{ 0.04620, 0.91647, 0.03230, 12, 66, 0, 0.0001 },
	{ 0.04620, 0.91647, 0.03187, 12, 66, 24, 0.0001 },
	{ 0.04620, 0.91647, 0.03073, 12, 66, 48, 0.0001 },
	{ 0.04620, 0.91647, 0.02921, 12, 66, 72, 0.0001 },
	{ 0.04620, 0.91647, 0.02773, 12, 66, 96, 0.0001 },
	{ 0.04620, 0.91647, 0.02656, 12, 66, 120, 0.0001 },
	{ 0.04620, 0.91647, 0.02583, 12, 66, 144, 0.0001 },
	{ 0.04620, 0.91647, 0.02549, 12, 66, 168, 0.0001 },
	{ 0.04620, 0.91647, 0.02545, 12, 66, 180, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 0, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 24, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 48, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 72, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 96, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 120, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 144, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 168, 0.0001 },
	{ 0.04620, 0.94825, 0.01951, 24, 0, 180, 0.0001 },
	{ 0.04620, 0.94772, 0.02121, 24, 12, 0, 0.0001 },
	{ 0.04620, 0.94772, 0.02106, 24, 12, 24, 0.0001 },
	{ 0.04620, 0.94772, 0.02065, 24, 12, 48, 0.0001 },
	{ 0.04620, 0.94772, 0.02006, 24, 12, 72, 0.0001 },
	{ 0.04620, 0.94772, 0.01940, 24, 12, 96, 0.0001 },
	{ 0.04620, 0.94772, 0.01879, 24, 12, 120, 0.0001 },
	{ 0.04620, 0.94772, 0.01833, 24, 12, 144, 0.0001 },
	{ 0.04620, 0.94772, 0.01809, 24, 12, 168, 0.0001 },
	{ 0.04620, 0.94772, 0.01806, 24, 12, 180, 0.0001 },
	{ 0.04620, 0.94601, 0.02317, 24, 24, 0, 0.0001 },
	{ 0.04620, 0.94601, 0.02285, 24, 24, 24, 0.0001 },
	{ 0.04620, 0.94601, 0.02198, 24, 24, 48, 0.0001 },
	{ 0.04620, 0.94601, 0.02077, 24, 24, 72, 0.0001 },
	{ 0.04620, 0.94601, 0.01947, 24, 24, 96, 0.0001 },
	{ 0.04620, 0.94601, 0.01832, 24, 24, 120, 0.0001 },
	{ 0.04620, 0.94601, 0.01749, 24, 24, 144, 0.0001 },
	{ 0.04620, 0.94601, 0.01706, 24, 24, 168, 0.0001 },
	{ 0.04620, 0.94601, 0.01701, 24, 24, 180, 0.0001 },
	{ 0.04620, 0.94267, 0.02555, 24, 36, 0, 0.0001 },
	{ 0.04620, 0.94267, 0.02505, 24, 36, 24, 0.0001 },
	{ 0.04620, 0.94267, 0.02370, 24, 36, 48, 0.0001 },
	{ 0.04620, 0.94267, 0.02185, 24, 36, 72, 0.0001 },
	{ 0.04620, 0.94267, 0.01996, 24, 36, 96, 0.0001 },
	{ 0.04620, 0.94267, 0.01837, 24, 36, 120, 0.0001 },
	{ 0.04620, 0.94267, 0.01728, 24, 36, 144, 0.0001 },
	{ 0.04620, 0.94267, 0.01674, 24, 36, 168, 0.0001 },
	{ 0.04620, 0.94267, 0.01668, 24, 36, 180, 0.0001 },
	{ 0.04620, 0.93664, 0.02888, 24, 48, 0, 0.0001 },
	{ 0.04620, 0.93664, 0.02818, 24, 48, 24, 0.0001 },
	{ 0.04620, 0.93664, 0.02630, 24, 48, 48, 0.0001 },
	{ 0.04620, 0.93664, 0.02382, 24, 48, 72, 0.0001 },
	{ 0.04620, 0.93664, 0.02140, 24, 48, 96, 0.0001 },
	{ 0.04620, 0.93664, 0.01951, 24, 48, 120, 0.0001 },
	{ 0.04620, 0.93664, 0.01834, 24, 48, 144, 0.0001 },
	{ 0.04620, 0.93664, 0.01780, 24, 48, 168, 0.0001 },
	{ 0.04620, 0.93664, 0.01774, 24, 48, 180, 0.0001 },
	{ 0.04620, 0.92507, 0.03462, 24, 60, 0, 0.0001 },
	{ 0.04620, 0.92507, 0.03367, 24, 60, 24, 0.0001 },
	{ 0.04620, 0.92507, 0.03117, 24, 60, 48, 0.0001 },
	{ 0.04620, 0.92507, 0.02801, 24, 60, 72, 0.0001 },
	{ 0.04620, 0.92507, 0.02515, 24, 60, 96, 0.0001 },
	{ 0.04620, 0.92507, 0.02319, 24, 60, 120, 0.0001 },
	{ 0.04620, 0.92507, 0.02219, 24, 60, 144, 0.0001 },
	{ 0.04620, 0.92507, 0.02183, 24, 60, 168, 0.0001 },
	{ 0.04620, 0.92507, 0.02179, 24, 60, 180, 0.0001 },
	{ 0.04620, 0.91482, 0.03962, 24, 66, 0, 0.0001 },
	{ 0.04620, 0.91482, 0.03850, 24, 66, 24, 0.0001 },
	{ 0.04620, 0.91482, 0.03560, 24, 66, 48, 0.0001 },
	{ 0.04620, 0.91482, 0.03205, 24, 66, 72, 0.0001 },
	{ 0.04620, 0.91482, 0.02901, 24, 66, 96, 0.0001 },
	{ 0.04620, 0.91482, 0.02714, 24, 66, 120, 0.0001 },
	{ 0.04620, 0.91482, 0.02639, 24, 66, 144, 0.0001 },
	{ 0.04620, 0.91482, 0.02625, 24, 66, 168, 0.0001 },
	{ 0.04620, 0.91482, 0.02624, 24, 66, 180, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 0, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 24, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 48, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 72, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 96, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 120, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 144, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 168, 0.0001 },
	{ 0.04620, 0.94491, 0.01989, 36, 0, 180, 0.0001 },
	{ 0.04620, 0.94438, 0.02245, 36, 12, 0, 0.0001 },
	{ 0.04620, 0.94438, 0.02222, 36, 12, 24, 0.0001 },
	{ 0.04620, 0.94438, 0.02160, 36, 12, 48, 0.0001 },
	{ 0.04620, 0.94438, 0.02072, 36, 12, 72, 0.0001 },
	{ 0.04620, 0.94438, 0.01977, 36, 12, 96, 0.0001 },
	{ 0.04620, 0.94438, 0.01891, 36, 12, 120, 0.0001 },
	{ 0.04620, 0.94438, 0.01828, 36, 12, 144, 0.0001 },
	{ 0.04620, 0.94438, 0.01795, 36, 12, 168, 0.0001 },
	{ 0.04620, 0.94438, 0.01790, 36, 12, 180, 0.0001 },
	{ 0.04620, 0.94267, 0.02555, 36, 24, 0, 0.0001 },
	{ 0.04620, 0.94267, 0.02505, 36, 24, 24, 0.0001 },
	{ 0.04620, 0.94267, 0.02370, 36, 24, 48, 0.0001 },
	{ 0.04620, 0.94267, 0.02185, 36, 24, 72, 0.0001 },
	{ 0.04620, 0.94267, 0.01996, 36, 24, 96, 0.0001 },
	{ 0.04620, 0.94267, 0.01837, 36, 24, 120, 0.0001 },
	{ 0.04620, 0.94267, 0.01728, 36, 24, 144, 0.0001 },
	{ 0.04620, 0.94267, 0.01674, 36, 24, 168, 0.0001 },
	{ 0.04620, 0.94267, 0.01668, 36, 24, 180, 0.0001 },
	{ 0.04620, 0.93935, 0.02940, 36, 36, 0, 0.0001 },
	{ 0.04620, 0.93935, 0.02858, 36, 36, 24, 0.0001 },
	{ 0.04620, 0.93935, 0.02638, 36, 36, 48, 0.0001 },
	{ 0.04620, 0.93935, 0.02350, 36, 36, 72, 0.0001 },
	{ 0.04620, 0.93935, 0.02072, 36, 36, 96, 0.0001 },
	{ 0.04620, 0.93935, 0.01858, 36, 36, 120, 0.0001 },
	{ 0.04620, 0.93935, 0.01727, 36, 36, 144, 0.0001 },
	{ 0.04620, 0.93935, 0.01669, 36, 36, 168, 0.0001 },
	{ 0.04620, 0.93935, 0.01662, 36, 36, 180, 0.0001 },
	{ 0.04620, 0.93334, 0.03464, 36, 48, 0, 0.0001 },
	{ 0.04620, 0.93334, 0.03342, 36, 48, 24, 0.0001 },
	{ 0.04620, 0.93334, 0.03024, 36, 48, 48, 0.0001 },
	{ 0.04620, 0.93334, 0.02624, 36, 48, 72, 0.0001 },
	{ 0.04620, 0.93334, 0.02265, 36, 48, 96, 0.0001 },
	{ 0.04620, 0.93334, 0.02023, 36, 48, 120, 0.0001 },
	{ 0.04620, 0.93334, 0.01903, 36, 48, 144, 0.0001 },
	{ 0.04620, 0.93334, 0.01863, 36, 48, 168, 0.0001 },
	{ 0.04620, 0.93334, 0.01859, 36, 48, 180, 0.0001 },
	{ 0.04620, 0.92180, 0.04310, 36, 60, 0, 0.0001 },
	{ 0.04620, 0.92180, 0.04137, 36, 60, 24, 0.0001 },
	{ 0.04620, 0.92180, 0.03692, 36, 60, 48, 0.0001 },
	{ 0.04620, 0.92180, 0.03160, 36, 60, 72, 0.0001 },
	{ 0.04620, 0.92180, 0.02730, 36, 60, 96, 0.0001 },
	{ 0.04620, 0.92180, 0.02500, 36, 60, 120, 0.0001 },
	{ 0.04620, 0.92180, 0.02444, 36, 60, 144, 0.0001 },
	{ 0.04620, 0.92180, 0.02459, 36, 60, 168, 0.0001 },
	{ 0.04620, 0.92180, 0.02463, 36, 60, 180, 0.0001 },
	{ 0.04620, 0.91159, 0.05011, 36, 66, 0, 0.0001 },
	{ 0.04620, 0.91159, 0.04801, 36, 66, 24, 0.0001 },
	{ 0.04620, 0.91159, 0.04269, 36, 66, 48, 0.0001 },
	{ 0.04620, 0.91159, 0.03653, 36, 66, 72, 0.0001 },
	{ 0.04620, 0.91159, 0.03190, 36, 66, 96, 0.0001 },
	{ 0.04620, 0.91159, 0.02992, 36, 66, 120, 0.0001 },
	{ 0.04620, 0.91159, 0.03005, 36, 66, 144, 0.0001 },
	{ 0.04620, 0.91159, 0.03073, 36, 66, 168, 0.0001 },
	{ 0.04620, 0.91159, 0.03086, 36, 66, 180, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 0, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 24, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 48, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 72, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 96, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 120, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 144, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 168, 0.0001 },
	{ 0.04620, 0.93886, 0.02106, 48, 0, 180, 0.0001 },
	{ 0.04620, 0.93834, 0.02445, 48, 12, 0, 0.0001 },
	{ 0.04620, 0.93834, 0.02415, 48, 12, 24, 0.0001 },
	{ 0.04620, 0.93834, 0.02332, 48, 12, 48, 0.0001 },
	{ 0.04620, 0.93834, 0.02218, 48, 12, 72, 0.0001 },
	{ 0.04620, 0.93834, 0.02097, 48, 12, 96, 0.0001 },
	{ 0.04620, 0.93834, 0.01992, 48, 12, 120, 0.0001 },
	{ 0.04620, 0.93834, 0.01917, 48, 12, 144, 0.0001 },
	{ 0.04620, 0.93834, 0.01879, 48, 12, 168, 0.0001 },
	{ 0.04620, 0.93834, 0.01874, 48, 12, 180, 0.0001 },
	{ 0.04620, 0.93664, 0.02888, 48, 24, 0, 0.0001 },
	{ 0.04620, 0.93664, 0.02818, 48, 24, 24, 0.0001 },
	{ 0.04620, 0.93664, 0.02630, 48, 24, 48, 0.0001 },
	{ 0.04620, 0.93664, 0.02382, 48, 24, 72, 0.0001 },
	{ 0.04620, 0.93664, 0.02140, 48, 24, 96, 0.0001 },
	{ 0.04620, 0.93664, 0.01952, 48, 24, 120, 0.0001 },
	{ 0.04620, 0.93664, 0.01834, 48, 24, 144, 0.0001 },
	{ 0.04620, 0.93664, 0.01780, 48, 24, 168, 0.0001 },
	{ 0.04620, 0.93664, 0.01774, 48, 24, 180, 0.0001 },
	{ 0.04620, 0.93334, 0.03464, 48, 36, 0, 0.0001 },
	{ 0.04620, 0.93334, 0.03342, 48, 36, 24, 0.0001 },
	{ 0.04620, 0.93334, 0.03024, 48, 36, 48, 0.0001 },
	{ 0.04620, 0.93334, 0.02624, 48, 36, 72, 0.0001 },
	{ 0.04620, 0.93334, 0.02265, 48, 36, 96, 0.0001 },
	{ 0.04620, 0.93334, 0.02023, 48, 36, 120, 0.0001 },
	{ 0.04620, 0.93334, 0.01903, 48, 36, 144, 0.0001 },
	{ 0.04620, 0.93334, 0.01863, 48, 36, 168, 0.0001 },
	{ 0.04620, 0.93334, 0.01859, 48, 36, 180, 0.0001 },
	{ 0.04620, 0.92737, 0.04259, 48, 48, 0, 0.0001 },
	{ 0.04620, 0.92737, 0.04071, 48, 48, 24, 0.0001 },
	{ 0.04620, 0.92737, 0.03590, 48, 48, 48, 0.0001 },
	{ 0.04620, 0.92737, 0.03013, 48, 48, 72, 0.0001 },
	{ 0.04620, 0.92737, 0.02545, 48, 48, 96, 0.0001 },
	{ 0.04620, 0.92737, 0.02292, 48, 48, 120, 0.0001 },
	{ 0.04620, 0.92737, 0.02225, 48, 48, 144, 0.0001 },
	{ 0.04620, 0.92737, 0.02238, 48, 48, 168, 0.0001 },
	{ 0.04620, 0.92737, 0.02242, 48, 48, 180, 0.0001 },
	{ 0.04620, 0.91591, 0.05523, 48, 60, 0, 0.0001 },
	{ 0.04620, 0.91591, 0.05242, 48, 60, 24, 0.0001 },
	{ 0.04620, 0.91591, 0.04538, 48, 60, 48, 0.0001 },
	{ 0.04620, 0.91591, 0.03737, 48, 60, 72, 0.0001 },
	{ 0.04620, 0.91591, 0.03165, 48, 60, 96, 0.0001 },
	{ 0.04620, 0.91591, 0.02966, 48, 60, 120, 0.0001 },
	{ 0.04620, 0.91591, 0.03048, 48, 60, 144, 0.0001 },
	{ 0.04620, 0.91591, 0.03181, 48, 60, 168, 0.0001 },
	{ 0.04620, 0.91591, 0.03203, 48, 60, 180, 0.0001 },
	{ 0.04620, 0.90576, 0.06546, 48, 66, 0, 0.0001 },
	{ 0.04620, 0.90576, 0.06198, 48, 66, 24, 0.0001 },
	{ 0.04620, 0.90576, 0.05333, 48, 66, 48, 0.0001 },
	{ 0.04620, 0.90576, 0.04379, 48, 66, 72, 0.0001 },
	{ 0.04620, 0.90576, 0.03755, 48, 66, 96, 0.0001 },
	{ 0.04620, 0.90576, 0.03628, 48, 66, 120, 0.0001 },
	{ 0.04620, 0.90576, 0.03850, 48, 66, 144, 0.0001 },
	{ 0.04620, 0.90576, 0.04090, 48, 66, 168, 0.0001 },
	{ 0.04620, 0.90576, 0.04127, 48, 66, 180, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 0, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 24, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 48, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 72, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 96, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 120, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 144, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 168, 0.0001 },
	{ 0.04620, 0.92726, 0.02424, 60, 0, 180, 0.0001 },
	{ 0.04620, 0.92674, 0.02847, 60, 12, 0, 0.0001 },
	{ 0.04620, 0.92674, 0.02809, 60, 12, 24, 0.0001 },
	{ 0.04620, 0.92674, 0.02706, 60, 12, 48, 0.0001 },
	{ 0.04620, 0.92674, 0.02567, 60, 12, 72, 0.0001 },
	{ 0.04620, 0.92674, 0.02426, 60, 12, 96, 0.0001 },
	{ 0.04620, 0.92674, 0.02311, 60, 12, 120, 0.0001 },
	{ 0.04620, 0.92674, 0.02233, 60, 12, 144, 0.0001 },
	{ 0.04620, 0.92674, 0.02195, 60, 12, 168, 0.0001 },
	{ 0.04620, 0.92674, 0.02191, 60, 12, 180, 0.0001 },
	{ 0.04620, 0.92507, 0.03462, 60, 24, 0, 0.0001 },
	{ 0.04620, 0.92507, 0.03367, 60, 24, 24, 0.0001 },
	{ 0.04620, 0.92507, 0.03117, 60, 24, 48, 0.0001 },
	{ 0.04620, 0.92507, 0.02801, 60, 24, 72, 0.0001 },
	{ 0.04620, 0.92507, 0.02515, 60, 24, 96, 0.0001 },
	{ 0.04620, 0.92507, 0.02319, 60, 24, 120, 0.0001 },
	{ 0.04620, 0.92507, 0.02219, 60, 24, 144, 0.0001 },
	{ 0.04620, 0.92507, 0.02183, 60, 24, 168, 0.0001 },
	{ 0.04620, 0.92507, 0.02180, 60, 24, 180, 0.0001 },
	{ 0.04620, 0.92180, 0.04310, 60, 36, 0, 0.0001 },
	{ 0.04620, 0.92180, 0.04137, 60, 36, 24, 0.0001 },
	{ 0.04620, 0.92180, 0.03692, 60, 36, 48, 0.0001 },
	{ 0.04620, 0.92180, 0.03160, 60, 36, 72, 0.0001 },
	{ 0.04620, 0.92180, 0.02730, 60, 36, 96, 0.0001 },
	{ 0.04620, 0.92180, 0.02500, 60, 36, 120, 0.0001 },
	{ 0.04620, 0.92180, 0.02444, 60, 36, 144, 0.0001 },
	{ 0.04620, 0.92180, 0.02459, 60, 36, 168, 0.0001 },
	{ 0.04620, 0.92180, 0.02464, 60, 36, 180, 0.0001 },
	{ 0.04620, 0.91591, 0.05522, 60, 48, 0, 0.0001 },
	{ 0.04620, 0.91591, 0.05242, 60, 48, 24, 0.0001 },
	{ 0.04620, 0.91591, 0.04538, 60, 48, 48, 0.0001 },
	{ 0.04620, 0.91591, 0.03737, 60, 48, 72, 0.0001 },
	{ 0.04620, 0.91591, 0.03165, 60, 48, 96, 0.0001 },
	{ 0.04620, 0.91591, 0.02966, 60, 48, 120, 0.0001 },
	{ 0.04620, 0.91591, 0.03048, 60, 48, 144, 0.0001 },
	{ 0.04620, 0.91591, 0.03181, 60, 48, 168, 0.0001 },
	{ 0.04620, 0.91591, 0.03203, 60, 48, 180, 0.0001 },
	{ 0.04620, 0.90459, 0.07471, 60, 60, 0, 0.0001 },
	{ 0.04620, 0.90459, 0.07033, 60, 60, 24, 0.0001 },
	{ 0.04620, 0.90459, 0.05951, 60, 60, 48, 0.0001 },
	{ 0.04620, 0.90459, 0.04782, 60, 60, 72, 0.0001 },
	{ 0.04620, 0.90459, 0.04065, 60, 60, 96, 0.0001 },
	{ 0.04620, 0.90459, 0.04004, 60, 60, 120, 0.0001 },
	{ 0.04620, 0.90459, 0.04382, 60, 60, 144, 0.0001 },
	{ 0.04620, 0.90459, 0.04746, 60, 60, 168, 0.0001 },
	{ 0.04620, 0.90459, 0.04802, 60, 60, 180, 0.0001 },
	{ 0.04620, 0.89457, 0.09043, 60, 66, 0, 0.0001 },
	{ 0.04620, 0.89457, 0.08485, 60, 66, 24, 0.0001 },
	{ 0.04620, 0.89457, 0.07123, 60, 66, 48, 0.0001 },
	{ 0.04620, 0.89457, 0.05692, 60, 66, 72, 0.0001 },
	{ 0.04620, 0.89457, 0.04893, 60, 66, 96, 0.0001 },
	{ 0.04620, 0.89457, 0.04974, 60, 66, 120, 0.0001 },
	{ 0.04620, 0.89457, 0.05612, 60, 66, 144, 0.0001 },
	{ 0.04620, 0.89457, 0.06175, 60, 66, 168, 0.0001 },
	{ 0.04620, 0.89457, 0.06259, 60, 66, 180, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 0, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 24, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 48, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 72, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 96, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 120, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 144, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 168, 0.0001 },
	{ 0.04620, 0.91699, 0.02759, 66, 0, 180, 0.0001 },
	{ 0.04620, 0.91647, 0.03230, 66, 12, 0, 0.0001 },
	{ 0.04620, 0.91647, 0.03187, 66, 12, 24, 0.0001 },
	{ 0.04620, 0.91647, 0.03073, 66, 12, 48, 0.0001 },
	{ 0.04620, 0.91647, 0.02921, 66, 12, 72, 0.0001 },
	{ 0.04620, 0.91647, 0.02773, 66, 12, 96, 0.0001 },
	{ 0.04620, 0.91647, 0.02656, 66, 12, 120, 0.0001 },
	{ 0.04620, 0.91647, 0.02583, 66, 12, 144, 0.0001 },
	{ 0.04620, 0.91647, 0.02549, 66, 12, 168, 0.0001 },
	{ 0.04620, 0.91647, 0.02545, 66, 12, 180, 0.0001 },
	{ 0.04620, 0.91482, 0.03962, 66, 24, 0, 0.0001 },
	{ 0.04620, 0.91482, 0.03850, 66, 24, 24, 0.0001 },
	{ 0.04620, 0.91482, 0.03560, 66, 24, 48, 0.0001 },
	{ 0.04620, 0.91482, 0.03205, 66, 24, 72, 0.0001 },
	{ 0.04620, 0.91482, 0.02901, 66, 24, 96, 0.0001 },
	{ 0.04620, 0.91482, 0.02714, 66, 24, 120, 0.0001 },
	{ 0.04620, 0.91482, 0.02639, 66, 24, 144, 0.0001 },
	{ 0.04620, 0.91482, 0.02625, 66, 24, 168, 0.0001 },
	{ 0.04620, 0.91482, 0.02624, 66, 24, 180, 0.0001 },
	{ 0.04620, 0.91159, 0.05011, 66, 36, 0, 0.0001 },
	{ 0.04620, 0.91159, 0.04801, 66, 36, 24, 0.0001 },
	{ 0.04620, 0.91159, 0.04270, 66, 36, 48, 0.0001 },
	{ 0.04620, 0.91159, 0.03653, 66, 36, 72, 0.0001 },
	{ 0.04620, 0.91159, 0.03190, 66, 36, 96, 0.0001 },
	{ 0.04620, 0.91159, 0.02992, 66, 36, 120, 0.0001 },
	{ 0.04620, 0.91159, 0.03005, 66, 36, 144, 0.0001 },
	{ 0.04620, 0.91159, 0.03073, 66, 36, 168, 0.0001 },
	{ 0.04620, 0.91159, 0.03086, 66, 36, 180, 0.0001 },
	{ 0.04620, 0.90576, 0.06546, 66, 48, 0, 0.0001 },
	{ 0.04620, 0.90576, 0.06198, 66, 48, 24, 0.0001 },
	{ 0.04620, 0.90576, 0.05333, 66, 48, 48, 0.0001 },
	{ 0.04620, 0.90576, 0.04379, 66, 48, 72, 0.0001 },
	{ 0.04620, 0.90576, 0.03754, 66, 48, 96, 0.0001 },
	{ 0.04620, 0.90576, 0.03628, 66, 48, 120, 0.0001 },
	{ 0.04620, 0.90576, 0.03849, 66, 48, 144, 0.0001 },
	{ 0.04620, 0.90576, 0.04090, 66, 48, 168, 0.0001 },
	{ 0.04620, 0.90576, 0.04127, 66, 48, 180, 0.0001 },
	{ 0.04620, 0.89457, 0.09043, 66, 60, 0, 0.0001 },
	{ 0.04620, 0.89457, 0.08485, 66, 60, 24, 0.0001 },
	{ 0.04620, 0.89457, 0.07123, 66, 60, 48, 0.0001 },
	{ 0.04620, 0.89457, 0.05691, 66, 60, 72, 0.0001 },
	{ 0.04620, 0.89457, 0.04892, 66, 60, 96, 0.0001 },
	{ 0.04620, 0.89457, 0.04973, 66, 60, 120, 0.0001 },
	{ 0.04620, 0.89457, 0.05612, 66, 60, 144, 0.0001 },
	{ 0.04620, 0.89457, 0.06175, 66, 60, 168, 0.0001 },
	{ 0.04620, 0.89457, 0.06259, 66, 60, 180, 0.0001 },
	{ 0.04620, 0.88465, 0.11061, 66, 66, 0, 0.0001 },
	{ 0.04620, 0.88465, 0.10345, 66, 66, 24, 0.0001 },
	{ 0.04620, 0.88465, 0.08608, 66, 66, 48, 0.0001 },
	{ 0.04620, 0.88465, 0.06827, 66, 66, 72, 0.0001 },
	{ 0.04620, 0.88465, 0.05924, 66, 66, 96, 0.0001 },
	{ 0.04620, 0.88465, 0.06204, 66, 66, 120, 0.0001 },
	{ 0.04620, 0.88465, 0.07201, 66, 66, 144, 0.0001 },
	{ 0.04620, 0.88465, 0.08035, 66, 66, 168, 0.0001 },
	{ 0.04620, 0.88465, 0.08157, 66, 66, 180, 0.0001 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 0, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 24, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 48, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 72, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 96, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 120, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 144, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 168, 0.1 },
	{ 0.05937, 0.88695, 0.02396, 0, 0, 180, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 0, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 24, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 48, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 72, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 96, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 120, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 144, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 168, 0.1 },
	{ 0.05937, 0.88562, 0.02339, 0, 12, 180, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 0, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 24, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 48, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 72, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 96, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 120, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 144, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 168, 0.1 },
	{ 0.05937, 0.88130, 0.02340, 0, 24, 180, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 0, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 24, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 48, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 72, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 96, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 120, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 144, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 168, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 0, 36, 180, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 0, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 24, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 48, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 72, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 96, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 120, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 144, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 168, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 0, 48, 180, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 0, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 24, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 48, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 72, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 96, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 120, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 144, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 168, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 0, 60, 180, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 0, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 24, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 48, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 72, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 96, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 120, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 144, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 168, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 0, 66, 180, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 0, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 24, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 48, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 72, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 96, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 120, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 144, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 168, 0.1 },
	{ 0.05937, 0.88562, 0.02338, 12, 0, 180, 0.1 },
	{ 0.05937, 0.88429, 0.02502, 12, 12, 0, 0.1 },
	{ 0.05937, 0.88429, 0.02476, 12, 12, 24, 0.1 },
	{ 0.05937, 0.88429, 0.02418, 12, 12, 48, 0.1 },
	{ 0.05937, 0.88429, 0.02364, 12, 12, 72, 0.1 },
	{ 0.05937, 0.88429, 0.02319, 12, 12, 96, 0.1 },
	{ 0.05937, 0.88429, 0.02281, 12, 12, 120, 0.1 },
	{ 0.05937, 0.88429, 0.02252, 12, 12, 144, 0.1 },
	{ 0.05937, 0.88429, 0.02237, 12, 12, 168, 0.1 },
	{ 0.05937, 0.88429, 0.02235, 12, 12, 180, 0.1 },
	{ 0.05937, 0.87998, 0.02557, 12, 24, 0, 0.1 },
	{ 0.05937, 0.87998, 0.02531, 12, 24, 24, 0.1 },
	{ 0.05937, 0.87998, 0.02476, 12, 24, 48, 0.1 },
	{ 0.05937, 0.87998, 0.02405, 12, 24, 72, 0.1 },
	{ 0.05937, 0.87998, 0.02329, 12, 24, 96, 0.1 },
	{ 0.05937, 0.87998, 0.02259, 12, 24, 120, 0.1 },
	{ 0.05937, 0.87998, 0.02208, 12, 24, 144, 0.1 },
	{ 0.05937, 0.87998, 0.02180, 12, 24, 168, 0.1 },
	{ 0.05937, 0.87998, 0.02177, 12, 24, 180, 0.1 },
	{ 0.05937, 0.87150, 0.02695, 12, 36, 0, 0.1 },
	{ 0.05937, 0.87150, 0.02669, 12, 36, 24, 0.1 },
	{ 0.05937, 0.87150, 0.02598, 12, 36, 48, 0.1 },
	{ 0.05937, 0.87150, 0.02498, 12, 36, 72, 0.1 },
	{ 0.05937, 0.87150, 0.02392, 12, 36, 96, 0.1 },
	{ 0.05937, 0.87150, 0.02300, 12, 36, 120, 0.1 },
	{ 0.05937, 0.87150, 0.02233, 12, 36, 144, 0.1 },
	{ 0.05937, 0.87150, 0.02199, 12, 36, 168, 0.1 },
	{ 0.05937, 0.87150, 0.02195, 12, 36, 180, 0.1 },
	{ 0.05937, 0.85598, 0.02953, 12, 48, 0, 0.1 },
	{ 0.05937, 0.85598, 0.02920, 12, 48, 24, 0.1 },
	{ 0.05937, 0.85598, 0.02830, 12, 48, 48, 0.1 },
	{ 0.05937, 0.85598, 0.02708, 12, 48, 72, 0.1 },
	{ 0.05937, 0.85598, 0.02585, 12, 48, 96, 0.1 },
	{ 0.05937, 0.85598, 0.02482, 12, 48, 120, 0.1 },
	{ 0.05937, 0.85598, 0.02413, 12, 48, 144, 0.1 },
	{ 0.05937, 0.85598, 0.02379, 12, 48, 168, 0.1 },
	{ 0.05937, 0.85598, 0.02375, 12, 48, 180, 0.1 },
	{ 0.05937, 0.82609, 0.03489, 12, 60, 0, 0.1 },
	{ 0.05937, 0.82609, 0.03450, 12, 60, 24, 0.1 },
	{ 0.05937, 0.82609, 0.03349, 12, 60, 48, 0.1 },
	{ 0.05937, 0.82609, 0.03216, 12, 60, 72, 0.1 },
	{ 0.05937, 0.82609, 0.03091, 12, 60, 96, 0.1 },
	{ 0.05937, 0.82609, 0.02999, 12, 60, 120, 0.1 },
	{ 0.05937, 0.82609, 0.02946, 12, 60, 144, 0.1 },
	{ 0.05937, 0.82609, 0.02923, 12, 60, 168, 0.1 },
	{ 0.05937, 0.82609, 0.02921, 12, 60, 180, 0.1 },
	{ 0.05937, 0.79998, 0.03996, 12, 66, 0, 0.1 },
	{ 0.05937, 0.79998, 0.03956, 12, 66, 24, 0.1 },
	{ 0.05937, 0.79998, 0.03849, 12, 66, 48, 0.1 },
	{ 0.05937, 0.79998, 0.03718, 12, 66, 72, 0.1 },
	{ 0.05937, 0.79998, 0.03603, 12, 66, 96, 0.1 },
	{ 0.05937, 0.79998, 0.03530, 12, 66, 120, 0.1 },
	{ 0.05937, 0.79998, 0.03500, 12, 66, 144, 0.1 },
	{ 0.05937, 0.79998, 0.03494, 12, 66, 168, 0.1 },
	{ 0.05937, 0.79998, 0.03493, 12, 66, 180, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 0, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 24, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 48, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 72, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 96, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 120, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 144, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 168, 0.1 },
	{ 0.05937, 0.88130, 0.02339, 24, 0, 180, 0.1 },
	{ 0.05937, 0.87998, 0.02557, 24, 12, 0, 0.1 },
	{ 0.05937, 0.87998, 0.02531, 24, 12, 24, 0.1 },
	{ 0.05937, 0.87998, 0.02476, 24, 12, 48, 0.1 },
	{ 0.05937, 0.87998, 0.02405, 24, 12, 72, 0.1 },
	{ 0.05937, 0.87998, 0.02329, 24, 12, 96, 0.1 },
	{ 0.05937, 0.87998, 0.02259, 24, 12, 120, 0.1 },
	{ 0.05937, 0.87998, 0.02208, 24, 12, 144, 0.1 },
	{ 0.05937, 0.87998, 0.02180, 24, 12, 168, 0.1 },
	{ 0.05937, 0.87998, 0.02177, 24, 12, 180, 0.1 },
	{ 0.05937, 0.87568, 0.02864, 24, 24, 0, 0.1 },
	{ 0.05937, 0.87568, 0.02769, 24, 24, 24, 0.1 },
	{ 0.05937, 0.87568, 0.02637, 24, 24, 48, 0.1 },
	{ 0.05937, 0.87568, 0.02495, 24, 24, 72, 0.1 },
	{ 0.05937, 0.87568, 0.02348, 24, 24, 96, 0.1 },
	{ 0.05937, 0.87568, 0.02222, 24, 24, 120, 0.1 },
	{ 0.05937, 0.87568, 0.02133, 24, 24, 144, 0.1 },
	{ 0.05937, 0.87568, 0.02089, 24, 24, 168, 0.1 },
	{ 0.05937, 0.87568, 0.02084, 24, 24, 180, 0.1 },
	{ 0.05937, 0.86725, 0.03085, 24, 36, 0, 0.1 },
	{ 0.05937, 0.86725, 0.03010, 24, 36, 24, 0.1 },
	{ 0.05937, 0.86725, 0.02849, 24, 36, 48, 0.1 },
	{ 0.05937, 0.86725, 0.02639, 24, 36, 72, 0.1 },
	{ 0.05937, 0.86725, 0.02434, 24, 36, 96, 0.1 },
	{ 0.05937, 0.86725, 0.02272, 24, 36, 120, 0.1 },
	{ 0.05937, 0.86725, 0.02168, 24, 36, 144, 0.1 },
	{ 0.05937, 0.86725, 0.02119, 24, 36, 168, 0.1 },
	{ 0.05937, 0.86725, 0.02113, 24, 36, 180, 0.1 },
	{ 0.05937, 0.85180, 0.03475, 24, 48, 0, 0.1 },
	{ 0.05937, 0.85180, 0.03393, 24, 48, 24, 0.1 },
	{ 0.05937, 0.85180, 0.03179, 24, 48, 48, 0.1 },
	{ 0.05937, 0.85180, 0.02911, 24, 48, 72, 0.1 },
	{ 0.05937, 0.85180, 0.02669, 24, 48, 96, 0.1 },
	{ 0.05937, 0.85180, 0.02500, 24, 48, 120, 0.1 },
	{ 0.05937, 0.85180, 0.02410, 24, 48, 144, 0.1 },
	{ 0.05937, 0.85180, 0.02377, 24, 48, 168, 0.1 },
	{ 0.05937, 0.85180, 0.02374, 24, 48, 180, 0.1 },
	{ 0.05937, 0.82206, 0.04183, 24, 60, 0, 0.1 },
	{ 0.05937, 0.82206, 0.04079, 24, 60, 24, 0.1 },
	{ 0.05937, 0.82206, 0.03812, 24, 60, 48, 0.1 },
	{ 0.05937, 0.82206, 0.03499, 24, 60, 72, 0.1 },
	{ 0.05937, 0.82206, 0.03251, 24, 60, 96, 0.1 },
	{ 0.05937, 0.82206, 0.03125, 24, 60, 120, 0.1 },
	{ 0.05937, 0.82206, 0.03108, 24, 60, 144, 0.1 },
	{ 0.05937, 0.82206, 0.03131, 24, 60, 168, 0.1 },
	{ 0.05937, 0.82206, 0.03136, 24, 60, 180, 0.1 },
	{ 0.05937, 0.79608, 0.04800, 24, 66, 0, 0.1 },
	{ 0.05937, 0.79608, 0.04682, 24, 66, 24, 0.1 },
	{ 0.05937, 0.79608, 0.04388, 24, 66, 48, 0.1 },
	{ 0.05937, 0.79608, 0.04057, 24, 66, 72, 0.1 },
	{ 0.05937, 0.79608, 0.03826, 24, 66, 96, 0.1 },
	{ 0.05937, 0.79608, 0.03760, 24, 66, 120, 0.1 },
	{ 0.05937, 0.79608, 0.03823, 24, 66, 144, 0.1 },
	{ 0.05937, 0.79608, 0.03906, 24, 66, 168, 0.1 },
	{ 0.05937, 0.79608, 0.03919, 24, 66, 180, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 0, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 24, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 48, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 72, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 96, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 120, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 144, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 168, 0.1 },
	{ 0.05937, 0.87281, 0.02400, 36, 0, 180, 0.1 },
	{ 0.05937, 0.87150, 0.02695, 36, 12, 0, 0.1 },
	{ 0.05937, 0.87150, 0.02669, 36, 12, 24, 0.1 },
	{ 0.05937, 0.87150, 0.02598, 36, 12, 48, 0.1 },
	{ 0.05937, 0.87150, 0.02498, 36, 12, 72, 0.1 },
	{ 0.05937, 0.87150, 0.02392, 36, 12, 96, 0.1 },
	{ 0.05937, 0.87150, 0.02300, 36, 12, 120, 0.1 },
	{ 0.05937, 0.87150, 0.02233, 36, 12, 144, 0.1 },
	{ 0.05937, 0.87150, 0.02199, 36, 12, 168, 0.1 },
	{ 0.05937, 0.87150, 0.02195, 36, 12, 180, 0.1 },
	{ 0.05937, 0.86725, 0.03085, 36, 24, 0, 0.1 },
	{ 0.05937, 0.86725, 0.03010, 36, 24, 24, 0.1 },
	{ 0.05937, 0.86725, 0.02849, 36, 24, 48, 0.1 },
	{ 0.05937, 0.86725, 0.02639, 36, 24, 72, 0.1 },
	{ 0.05937, 0.86725, 0.02434, 36, 24, 96, 0.1 },
	{ 0.05937, 0.86725, 0.02272, 36, 24, 120, 0.1 },
	{ 0.05937, 0.86725, 0.02168, 36, 24, 144, 0.1 },
	{ 0.05937, 0.86725, 0.02119, 36, 24, 168, 0.1 },
	{ 0.05937, 0.86725, 0.02113, 36, 24, 180, 0.1 },
	{ 0.05937, 0.85889, 0.03641, 36, 36, 0, 0.1 },
	{ 0.05937, 0.85889, 0.03444, 36, 36, 24, 0.1 },
	{ 0.05937, 0.85889, 0.03177, 36, 36, 48, 0.1 },
	{ 0.05937, 0.85889, 0.02855, 36, 36, 72, 0.1 },
	{ 0.05937, 0.85889, 0.02567, 36, 36, 96, 0.1 },
	{ 0.05937, 0.85889, 0.02369, 36, 36, 120, 0.1 },
	{ 0.05937, 0.85889, 0.02266, 36, 36, 144, 0.1 },
	{ 0.05937, 0.85889, 0.02230, 36, 36, 168, 0.1 },
	{ 0.05937, 0.85889, 0.02226, 36, 36, 180, 0.1 },
	{ 0.05937, 0.84360, 0.04193, 36, 48, 0, 0.1 },
	{ 0.05937, 0.84360, 0.04026, 36, 48, 24, 0.1 },
	{ 0.05937, 0.84360, 0.03659, 36, 48, 48, 0.1 },
	{ 0.05937, 0.84360, 0.03226, 36, 48, 72, 0.1 },
	{ 0.05937, 0.84360, 0.02882, 36, 48, 96, 0.1 },
	{ 0.05937, 0.84360, 0.02700, 36, 48, 120, 0.1 },
	{ 0.05937, 0.84360, 0.02663, 36, 48, 144, 0.1 },
	{ 0.05937, 0.84360, 0.02684, 36, 48, 168, 0.1 },
	{ 0.05937, 0.84360, 0.02689, 36, 48, 180, 0.1 },
	{ 0.05937, 0.81414, 0.05191, 36, 60, 0, 0.1 },
	{ 0.05937, 0.81414, 0.04992, 36, 60, 24, 0.1 },
	{ 0.05937, 0.81414, 0.04499, 36, 60, 48, 0.1 },
	{ 0.05937, 0.81414, 0.03961, 36, 60, 72, 0.1 },
	{ 0.05937, 0.81414, 0.03605, 36, 60, 96, 0.1 },
	{ 0.05937, 0.81414, 0.03536, 36, 60, 120, 0.1 },
	{ 0.05937, 0.81414, 0.03693, 36, 60, 144, 0.1 },
	{ 0.05937, 0.81414, 0.03870, 36, 60, 168, 0.1 },
	{ 0.05937, 0.81414, 0.03899, 36, 60, 180, 0.1 },
	{ 0.05937, 0.78840, 0.06030, 36, 66, 0, 0.1 },
	{ 0.05937, 0.78840, 0.05794, 36, 66, 24, 0.1 },
	{ 0.05937, 0.78840, 0.05222, 36, 66, 48, 0.1 },
	{ 0.05937, 0.78840, 0.04628, 36, 66, 72, 0.1 },
	{ 0.05937, 0.78840, 0.04297, 36, 66, 96, 0.1 },
	{ 0.05937, 0.78840, 0.04359, 36, 66, 120, 0.1 },
	{ 0.05937, 0.78840, 0.04717, 36, 66, 144, 0.1 },
	{ 0.05937, 0.78840, 0.05054, 36, 66, 168, 0.1 },
	{ 0.05937, 0.78840, 0.05105, 36, 66, 180, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 0, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 24, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 48, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 72, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 96, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 120, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 144, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 168, 0.1 },
	{ 0.05937, 0.85727, 0.02583, 48, 0, 180, 0.1 },
	{ 0.05937, 0.85598, 0.02953, 48, 12, 0, 0.1 },
	{ 0.05937, 0.85598, 0.02920, 48, 12, 24, 0.1 },
	{ 0.05937, 0.85598, 0.02830, 48, 12, 48, 0.1 },
	{ 0.05937, 0.85598, 0.02708, 48, 12, 72, 0.1 },
	{ 0.05937, 0.85598, 0.02585, 48, 12, 96, 0.1 },
	{ 0.05937, 0.85598, 0.02483, 48, 12, 120, 0.1 },
	{ 0.05937, 0.85598, 0.02413, 48, 12, 144, 0.1 },
	{ 0.05937, 0.85598, 0.02379, 48, 12, 168, 0.1 },
	{ 0.05937, 0.85598, 0.02375, 48, 12, 180, 0.1 },
	{ 0.05937, 0.85180, 0.03475, 48, 24, 0, 0.1 },
	{ 0.05937, 0.85180, 0.03393, 48, 24, 24, 0.1 },
	{ 0.05937, 0.85180, 0.03180, 48, 24, 48, 0.1 },
	{ 0.05937, 0.85180, 0.02911, 48, 24, 72, 0.1 },
	{ 0.05937, 0.85180, 0.02669, 48, 24, 96, 0.1 },
	{ 0.05937, 0.85180, 0.02500, 48, 24, 120, 0.1 },
	{ 0.05937, 0.85180, 0.02410, 48, 24, 144, 0.1 },
	{ 0.05937, 0.85180, 0.02377, 48, 24, 168, 0.1 },
	{ 0.05937, 0.85180, 0.02374, 48, 24, 180, 0.1 },
	{ 0.05937, 0.84360, 0.04193, 48, 36, 0, 0.1 },
	{ 0.05937, 0.84360, 0.04026, 48, 36, 24, 0.1 },
	{ 0.05937, 0.84360, 0.03659, 48, 36, 48, 0.1 },
	{ 0.05937, 0.84360, 0.03227, 48, 36, 72, 0.1 },
	{ 0.05937, 0.84360, 0.02883, 48, 36, 96, 0.1 },
	{ 0.05937, 0.84360, 0.02700, 48, 36, 120, 0.1 },
	{ 0.05937, 0.84360, 0.02663, 48, 36, 144, 0.1 },
	{ 0.05937, 0.84360, 0.02684, 48, 36, 168, 0.1 },
	{ 0.05937, 0.84360, 0.02689, 48, 36, 180, 0.1 },
	{ 0.05937, 0.82857, 0.05284, 48, 48, 0, 0.1 },
	{ 0.05937, 0.82857, 0.04912, 48, 48, 24, 0.1 },
	{ 0.05937, 0.82857, 0.04357, 48, 48, 48, 0.1 },
	{ 0.05937, 0.82857, 0.03748, 48, 48, 72, 0.1 },
	{ 0.05937, 0.82857, 0.03334, 48, 48, 96, 0.1 },
	{ 0.05937, 0.82857, 0.03228, 48, 48, 120, 0.1 },
	{ 0.05937, 0.82857, 0.03365, 48, 48, 144, 0.1 },
	{ 0.05937, 0.82857, 0.03538, 48, 48, 168, 0.1 },
	{ 0.05937, 0.82857, 0.03567, 48, 48, 180, 0.1 },
	{ 0.05937, 0.79964, 0.06693, 48, 60, 0, 0.1 },
	{ 0.05937, 0.79964, 0.06327, 48, 60, 24, 0.1 },
	{ 0.05937, 0.79964, 0.05533, 48, 60, 48, 0.1 },
	{ 0.05937, 0.79964, 0.04724, 48, 60, 72, 0.1 },
	{ 0.05937, 0.79964, 0.04301, 48, 60, 96, 0.1 },
	{ 0.05937, 0.79964, 0.04442, 48, 60, 120, 0.1 },
	{ 0.05937, 0.79964, 0.05023, 48, 60, 144, 0.1 },
	{ 0.05937, 0.79964, 0.05574, 48, 60, 168, 0.1 },
	{ 0.05937, 0.79964, 0.05660, 48, 60, 180, 0.1 },
	{ 0.05937, 0.77437, 0.07874, 48, 66, 0, 0.1 },
	{ 0.05937, 0.77437, 0.07468, 48, 66, 24, 0.1 },
	{ 0.05937, 0.77437, 0.06513, 48, 66, 48, 0.1 },
	{ 0.05937, 0.77437, 0.05582, 48, 66, 72, 0.1 },
	{ 0.05937, 0.77437, 0.05193, 48, 66, 96, 0.1 },
	{ 0.05937, 0.77437, 0.05591, 48, 66, 120, 0.1 },
	{ 0.05937, 0.77437, 0.06610, 48, 66, 144, 0.1 },
	{ 0.05937, 0.77437, 0.07547, 48, 66, 168, 0.1 },
	{ 0.05937, 0.77437, 0.07697, 48, 66, 180, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 0, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 24, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 48, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 72, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 96, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 120, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 144, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 168, 0.1 },
	{ 0.05937, 0.82733, 0.03065, 60, 0, 180, 0.1 },
	{ 0.05937, 0.82609, 0.03490, 60, 12, 0, 0.1 },
	{ 0.05937, 0.82609, 0.03450, 60, 12, 24, 0.1 },
	{ 0.05937, 0.82609, 0.03349, 60, 12, 48, 0.1 },
	{ 0.05937, 0.82609, 0.03216, 60, 12, 72, 0.1 },
	{ 0.05937, 0.82609, 0.03091, 60, 12, 96, 0.1 },
	{ 0.05937, 0.82609, 0.02999, 60, 12, 120, 0.1 },
	{ 0.05937, 0.82609, 0.02946, 60, 12, 144, 0.1 },
	{ 0.05937, 0.82609, 0.02923, 60, 12, 168, 0.1 },
	{ 0.05937, 0.82609, 0.02921, 60, 12, 180, 0.1 },
	{ 0.05937, 0.82206, 0.04183, 60, 24, 0, 0.1 },
	{ 0.05937, 0.82206, 0.04079, 60, 24, 24, 0.1 },
	{ 0.05937, 0.82206, 0.03812, 60, 24, 48, 0.1 },
	{ 0.05937, 0.82206, 0.03499, 60, 24, 72, 0.1 },
	{ 0.05937, 0.82206, 0.03251, 60, 24, 96, 0.1 },
	{ 0.05937, 0.82206, 0.03125, 60, 24, 120, 0.1 },
	{ 0.05937, 0.82206, 0.03108, 60, 24, 144, 0.1 },
	{ 0.05937, 0.82206, 0.03131, 60, 24, 168, 0.1 },
	{ 0.05937, 0.82206, 0.03136, 60, 24, 180, 0.1 },
	{ 0.05937, 0.81414, 0.05191, 60, 36, 0, 0.1 },
	{ 0.05937, 0.81414, 0.04992, 60, 36, 24, 0.1 },
	{ 0.05937, 0.81414, 0.04498, 60, 36, 48, 0.1 },
	{ 0.05937, 0.81414, 0.03961, 60, 36, 72, 0.1 },
	{ 0.05937, 0.81414, 0.03605, 60, 36, 96, 0.1 },
	{ 0.05937, 0.81414, 0.03536, 60, 36, 120, 0.1 },
	{ 0.05937, 0.81414, 0.03692, 60, 36, 144, 0.1 },
	{ 0.05937, 0.81414, 0.03870, 60, 36, 168, 0.1 },
	{ 0.05937, 0.81414, 0.03898, 60, 36, 180, 0.1 },
	{ 0.05937, 0.79964, 0.06693, 60, 48, 0, 0.1 },
	{ 0.05937, 0.79964, 0.06326, 60, 48, 24, 0.1 },
	{ 0.05937, 0.79964, 0.05533, 60, 48, 48, 0.1 },
	{ 0.05937, 0.79964, 0.04724, 60, 48, 72, 0.1 },
	{ 0.05937, 0.79964, 0.04301, 60, 48, 96, 0.1 },
	{ 0.05937, 0.79964, 0.04442, 60, 48, 120, 0.1 },
	{ 0.05937, 0.79964, 0.05023, 60, 48, 144, 0.1 },
	{ 0.05937, 0.79964, 0.05574, 60, 48, 168, 0.1 },
	{ 0.05937, 0.79964, 0.05660, 60, 48, 180, 0.1 },
	{ 0.05937, 0.77171, 0.09258, 60, 60, 0, 0.1 },
	{ 0.05937, 0.77171, 0.08491, 60, 60, 24, 0.1 },
	{ 0.05937, 0.77171, 0.07276, 60, 60, 48, 0.1 },
	{ 0.05937, 0.77171, 0.06123, 60, 60, 72, 0.1 },
	{ 0.05937, 0.77171, 0.05705, 60, 60, 96, 0.1 },
	{ 0.05937, 0.77171, 0.06362, 60, 60, 120, 0.1 },
	{ 0.05937, 0.77171, 0.07916, 60, 60, 144, 0.1 },
	{ 0.05937, 0.77171, 0.09399, 60, 60, 168, 0.1 },
	{ 0.05937, 0.77171, 0.09637, 60, 60, 180, 0.1 },
	{ 0.05937, 0.74732, 0.11076, 60, 66, 0, 0.1 },
	{ 0.05937, 0.74732, 0.10224, 60, 66, 24, 0.1 },
	{ 0.05937, 0.74732, 0.08708, 60, 66, 48, 0.1 },
	{ 0.05937, 0.74732, 0.07325, 60, 66, 72, 0.1 },
	{ 0.05937, 0.74732, 0.06964, 60, 66, 96, 0.1 },
	{ 0.05937, 0.74732, 0.08109, 60, 66, 120, 0.1 },
	{ 0.05937, 0.74732, 0.10597, 60, 66, 144, 0.1 },
	{ 0.05937, 0.74732, 0.13049, 60, 66, 168, 0.1 },
	{ 0.05937, 0.74732, 0.13452, 60, 66, 180, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 0, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 24, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 48, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 72, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 96, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 120, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 144, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 168, 0.1 },
	{ 0.05937, 0.80118, 0.03555, 66, 0, 180, 0.1 },
	{ 0.05937, 0.79998, 0.03996, 66, 12, 0, 0.1 },
	{ 0.05937, 0.79998, 0.03956, 66, 12, 24, 0.1 },
	{ 0.05937, 0.79998, 0.03849, 66, 12, 48, 0.1 },
	{ 0.05937, 0.79998, 0.03718, 66, 12, 72, 0.1 },
	{ 0.05937, 0.79998, 0.03603, 66, 12, 96, 0.1 },
	{ 0.05937, 0.79998, 0.03530, 66, 12, 120, 0.1 },
	{ 0.05937, 0.79998, 0.03500, 66, 12, 144, 0.1 },
	{ 0.05937, 0.79998, 0.03494, 66, 12, 168, 0.1 },
	{ 0.05937, 0.79998, 0.03493, 66, 12, 180, 0.1 },
	{ 0.05937, 0.79608, 0.04800, 66, 24, 0, 0.1 },
	{ 0.05937, 0.79608, 0.04682, 66, 24, 24, 0.1 },
	{ 0.05937, 0.79608, 0.04388, 66, 24, 48, 0.1 },
	{ 0.05937, 0.79608, 0.04057, 66, 24, 72, 0.1 },
	{ 0.05937, 0.79608, 0.03825, 66, 24, 96, 0.1 },
	{ 0.05937, 0.79608, 0.03760, 66, 24, 120, 0.1 },
	{ 0.05937, 0.79608, 0.03823, 66, 24, 144, 0.1 },
	{ 0.05937, 0.79608, 0.03906, 66, 24, 168, 0.1 },
	{ 0.05937, 0.79608, 0.03919, 66, 24, 180, 0.1 },
	{ 0.05937, 0.78840, 0.06030, 66, 36, 0, 0.1 },
	{ 0.05937, 0.78840, 0.05793, 66, 36, 24, 0.1 },
	{ 0.05937, 0.78840, 0.05222, 66, 36, 48, 0.1 },
	{ 0.05937, 0.78840, 0.04628, 66, 36, 72, 0.1 },
	{ 0.05937, 0.78840, 0.04297, 66, 36, 96, 0.1 },
	{ 0.05937, 0.78840, 0.04359, 66, 36, 120, 0.1 },
	{ 0.05937, 0.78840, 0.04716, 66, 36, 144, 0.1 },
	{ 0.05937, 0.78840, 0.05053, 66, 36, 168, 0.1 },
	{ 0.05937, 0.78840, 0.05105, 66, 36, 180, 0.1 },
	{ 0.05937, 0.77437, 0.07874, 66, 48, 0, 0.1 },
	{ 0.05937, 0.77437, 0.07469, 66, 48, 24, 0.1 },
	{ 0.05937, 0.77437, 0.06514, 66, 48, 48, 0.1 },
	{ 0.05937, 0.77437, 0.05583, 66, 48, 72, 0.1 },
	{ 0.05937, 0.77437, 0.05194, 66, 48, 96, 0.1 },
	{ 0.05937, 0.77437, 0.05591, 66, 48, 120, 0.1 },
	{ 0.05937, 0.77437, 0.06610, 66, 48, 144, 0.1 },
	{ 0.05937, 0.77437, 0.07547, 66, 48, 168, 0.1 },
	{ 0.05937, 0.77437, 0.07697, 66, 48, 180, 0.1 },
	{ 0.05937, 0.74732, 0.11076, 66, 60, 0, 0.1 },
	{ 0.05937, 0.74732, 0.10224, 66, 60, 24, 0.1 },
	{ 0.05937, 0.74732, 0.08708, 66, 60, 48, 0.1 },
	{ 0.05937, 0.74732, 0.07325, 66, 60, 72, 0.1 },
	{ 0.05937, 0.74732, 0.06964, 66, 60, 96, 0.1 },
	{ 0.05937, 0.74732, 0.08110, 66, 60, 120, 0.1 },
	{ 0.05937, 0.74732, 0.10597, 66, 60, 144, 0.1 },
	{ 0.05937, 0.74732, 0.13049, 66, 60, 168, 0.1 },
	{ 0.05937, 0.74732, 0.13452, 66, 60, 180, 0.1 },
	{ 0.05937, 0.72370, 0.13625, 66, 66, 0, 0.1 },
	{ 0.05937, 0.72370, 0.12437, 66, 66, 24, 0.1 },
	{ 0.05937, 0.72370, 0.10514, 66, 66, 48, 0.1 },
	{ 0.05937, 0.72370, 0.08818, 66, 66, 72, 0.1 },
	{ 0.05937, 0.72370, 0.08530, 66, 66, 96, 0.1 },
	{ 0.05937, 0.72370, 0.10354, 66, 66, 120, 0.1 },
	{ 0.05937, 0.72370, 0.14241, 66, 66, 144, 0.1 },
	{ 0.05937, 0.72370, 0.18281, 66, 66, 168, 0.1 },
	{ 0.05937, 0.72370, 0.18989, 66, 66, 180, 0.1 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 0, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 24, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 48, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 72, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 96, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 120, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 144, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 168, 0.2 },
	{ 0.06976, 0.82640, 0.02826, 0, 0, 180, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 0, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 24, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 48, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 72, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 96, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 120, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 144, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 168, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 0, 12, 180, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 0, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 24, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 48, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 72, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 96, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 120, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 144, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 168, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 0, 24, 180, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 0, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 24, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 48, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 72, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 96, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 120, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 144, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 168, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 0, 36, 180, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 0, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 24, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 48, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 72, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 96, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 120, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 144, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 168, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 0, 48, 180, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 0, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 24, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 48, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 72, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 96, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 120, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 144, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 168, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 0, 60, 180, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 0, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 24, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 48, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 72, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 96, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 120, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 144, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 168, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 0, 66, 180, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 0, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 24, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 48, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 72, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 96, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 120, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 144, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 168, 0.2 },
	{ 0.06976, 0.82436, 0.02720, 12, 0, 180, 0.2 },
	{ 0.06976, 0.82232, 0.02952, 12, 12, 0, 0.2 },
	{ 0.06976, 0.82232, 0.02909, 12, 12, 24, 0.2 },
	{ 0.06976, 0.82232, 0.02821, 12, 12, 48, 0.2 },
	{ 0.06976, 0.82232, 0.02745, 12, 12, 72, 0.2 },
	{ 0.06976, 0.82232, 0.02690, 12, 12, 96, 0.2 },
	{ 0.06976, 0.82232, 0.02647, 12, 12, 120, 0.2 },
	{ 0.06976, 0.82232, 0.02614, 12, 12, 144, 0.2 },
	{ 0.06976, 0.82232, 0.02598, 12, 12, 168, 0.2 },
	{ 0.06976, 0.82232, 0.02595, 12, 12, 180, 0.2 },
	{ 0.06976, 0.81573, 0.02974, 12, 24, 0, 0.2 },
	{ 0.06976, 0.81573, 0.02940, 12, 24, 24, 0.2 },
	{ 0.06976, 0.81573, 0.02872, 12, 24, 48, 0.2 },
	{ 0.06976, 0.81573, 0.02792, 12, 24, 72, 0.2 },
	{ 0.06976, 0.81573, 0.02707, 12, 24, 96, 0.2 },
	{ 0.06976, 0.81573, 0.02631, 12, 24, 120, 0.2 },
	{ 0.06976, 0.81573, 0.02576, 12, 24, 144, 0.2 },
	{ 0.06976, 0.81573, 0.02546, 12, 24, 168, 0.2 },
	{ 0.06976, 0.81573, 0.02542, 12, 24, 180, 0.2 },
	{ 0.06976, 0.80281, 0.03128, 12, 36, 0, 0.2 },
	{ 0.06976, 0.80281, 0.03100, 12, 36, 24, 0.2 },
	{ 0.06976, 0.80281, 0.03021, 12, 36, 48, 0.2 },
	{ 0.06976, 0.80281, 0.02912, 12, 36, 72, 0.2 },
	{ 0.06976, 0.80281, 0.02799, 12, 36, 96, 0.2 },
	{ 0.06976, 0.80281, 0.02702, 12, 36, 120, 0.2 },
	{ 0.06976, 0.80281, 0.02634, 12, 36, 144, 0.2 },
	{ 0.06976, 0.80281, 0.02600, 12, 36, 168, 0.2 },
	{ 0.06976, 0.80281, 0.02595, 12, 36, 180, 0.2 },
	{ 0.06976, 0.77940, 0.03439, 12, 48, 0, 0.2 },
	{ 0.06976, 0.77940, 0.03404, 12, 48, 24, 0.2 },
	{ 0.06976, 0.77940, 0.03309, 12, 48, 48, 0.2 },
	{ 0.06976, 0.77940, 0.03184, 12, 48, 72, 0.2 },
	{ 0.06976, 0.77940, 0.03061, 12, 48, 96, 0.2 },
	{ 0.06976, 0.77940, 0.02965, 12, 48, 120, 0.2 },
	{ 0.06976, 0.77940, 0.02902, 12, 48, 144, 0.2 },
	{ 0.06976, 0.77940, 0.02873, 12, 48, 168, 0.2 },
	{ 0.06976, 0.77940, 0.02870, 12, 48, 180, 0.2 },
	{ 0.06976, 0.73530, 0.04089, 12, 60, 0, 0.2 },
	{ 0.06976, 0.73530, 0.04050, 12, 60, 24, 0.2 },
	{ 0.06976, 0.73530, 0.03952, 12, 60, 48, 0.2 },
	{ 0.06976, 0.73530, 0.03830, 12, 60, 72, 0.2 },
	{ 0.06976, 0.73530, 0.03724, 12, 60, 96, 0.2 },
	{ 0.06976, 0.73530, 0.03657, 12, 60, 120, 0.2 },
	{ 0.06976, 0.73530, 0.03630, 12, 60, 144, 0.2 },
	{ 0.06976, 0.73530, 0.03622, 12, 60, 168, 0.2 },
	{ 0.06976, 0.73530, 0.03622, 12, 60, 180, 0.2 },
	{ 0.06976, 0.69804, 0.04691, 12, 66, 0, 0.2 },
	{ 0.06976, 0.69804, 0.04653, 12, 66, 24, 0.2 },
	{ 0.06976, 0.69804, 0.04558, 12, 66, 48, 0.2 },
	{ 0.06976, 0.69804, 0.04448, 12, 66, 72, 0.2 },
	{ 0.06976, 0.69804, 0.04368, 12, 66, 96, 0.2 },
	{ 0.06976, 0.69804, 0.04339, 12, 66, 120, 0.2 },
	{ 0.06976, 0.69804, 0.04351, 12, 66, 144, 0.2 },
	{ 0.06976, 0.69804, 0.04371, 12, 66, 168, 0.2 },
	{ 0.06976, 0.69804, 0.04374, 12, 66, 180, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 0, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 24, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 48, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 72, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 96, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 120, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 144, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 168, 0.2 },
	{ 0.06976, 0.81775, 0.02716, 24, 0, 180, 0.2 },
	{ 0.06976, 0.81573, 0.02974, 24, 12, 0, 0.2 },
	{ 0.06976, 0.81573, 0.02940, 24, 12, 24, 0.2 },
	{ 0.06976, 0.81573, 0.02872, 24, 12, 48, 0.2 },
	{ 0.06976, 0.81573, 0.02792, 24, 12, 72, 0.2 },
	{ 0.06976, 0.81573, 0.02707, 24, 12, 96, 0.2 },
	{ 0.06976, 0.81573, 0.02631, 24, 12, 120, 0.2 },
	{ 0.06976, 0.81573, 0.02576, 24, 12, 144, 0.2 },
	{ 0.06976, 0.81573, 0.02546, 24, 12, 168, 0.2 },
	{ 0.06976, 0.81573, 0.02542, 24, 12, 180, 0.2 },
	{ 0.06976, 0.80919, 0.03376, 24, 24, 0, 0.2 },
	{ 0.06976, 0.80919, 0.03228, 24, 24, 24, 0.2 },
	{ 0.06976, 0.80919, 0.03059, 24, 24, 48, 0.2 },
	{ 0.06976, 0.80919, 0.02901, 24, 24, 72, 0.2 },
	{ 0.06976, 0.80919, 0.02740, 24, 24, 96, 0.2 },
	{ 0.06976, 0.80919, 0.02606, 24, 24, 120, 0.2 },
	{ 0.06976, 0.80919, 0.02515, 24, 24, 144, 0.2 },
	{ 0.06976, 0.80919, 0.02472, 24, 24, 168, 0.2 },
	{ 0.06976, 0.80919, 0.02466, 24, 24, 180, 0.2 },
	{ 0.06976, 0.79637, 0.03586, 24, 36, 0, 0.2 },
	{ 0.06976, 0.79637, 0.03490, 24, 36, 24, 0.2 },
	{ 0.06976, 0.79637, 0.03309, 24, 36, 48, 0.2 },
	{ 0.06976, 0.79637, 0.03080, 24, 36, 72, 0.2 },
	{ 0.06976, 0.79637, 0.02864, 24, 36, 96, 0.2 },
	{ 0.06976, 0.79637, 0.02704, 24, 36, 120, 0.2 },
	{ 0.06976, 0.79637, 0.02608, 24, 36, 144, 0.2 },
	{ 0.06976, 0.79637, 0.02566, 24, 36, 168, 0.2 },
	{ 0.06976, 0.79637, 0.02561, 24, 36, 180, 0.2 },
	{ 0.06976, 0.77315, 0.04025, 24, 48, 0, 0.2 },
	{ 0.06976, 0.77315, 0.03934, 24, 48, 24, 0.2 },
	{ 0.06976, 0.77315, 0.03703, 24, 48, 48, 0.2 },
	{ 0.06976, 0.77315, 0.03423, 24, 48, 72, 0.2 },
	{ 0.06976, 0.77315, 0.03187, 24, 48, 96, 0.2 },
	{ 0.06976, 0.77315, 0.03042, 24, 48, 120, 0.2 },
	{ 0.06976, 0.77315, 0.02983, 24, 48, 144, 0.2 },
	{ 0.06976, 0.77315, 0.02972, 24, 48, 168, 0.2 },
	{ 0.06976, 0.77315, 0.02972, 24, 48, 180, 0.2 },
	{ 0.06976, 0.72941, 0.04842, 24, 60, 0, 0.2 },
	{ 0.06976, 0.72941, 0.04733, 24, 60, 24, 0.2 },
	{ 0.06976, 0.72941, 0.04458, 24, 60, 48, 0.2 },
	{ 0.06976, 0.72941, 0.04157, 24, 60, 72, 0.2 },
	{ 0.06976, 0.72941, 0.03952, 24, 60, 96, 0.2 },
	{ 0.06976, 0.72941, 0.03899, 24, 60, 120, 0.2 },
	{ 0.06976, 0.72941, 0.03964, 24, 60, 144, 0.2 },
	{ 0.06976, 0.72941, 0.04044, 24, 60, 168, 0.2 },
	{ 0.06976, 0.72941, 0.04056, 24, 60, 180, 0.2 },
	{ 0.06976, 0.69244, 0.05543, 24, 66, 0, 0.2 },
	{ 0.06976, 0.69244, 0.05422, 24, 66, 24, 0.2 },
	{ 0.06976, 0.69244, 0.05134, 24, 66, 48, 0.2 },
	{ 0.06976, 0.69244, 0.04835, 24, 66, 72, 0.2 },
	{ 0.06976, 0.69244, 0.04679, 24, 66, 96, 0.2 },
	{ 0.06976, 0.69244, 0.04730, 24, 66, 120, 0.2 },
	{ 0.06976, 0.69244, 0.04923, 24, 66, 144, 0.2 },
	{ 0.06976, 0.69244, 0.05095, 24, 66, 168, 0.2 },
	{ 0.06976, 0.69244, 0.05121, 24, 66, 180, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 0, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 24, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 48, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 72, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 96, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 120, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 144, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 168, 0.2 },
	{ 0.06976, 0.80480, 0.02801, 36, 0, 180, 0.2 },
	{ 0.06976, 0.80281, 0.03128, 36, 12, 0, 0.2 },
	{ 0.06976, 0.80281, 0.03100, 36, 12, 24, 0.2 },
	{ 0.06976, 0.80281, 0.03021, 36, 12, 48, 0.2 },
	{ 0.06976, 0.80281, 0.02912, 36, 12, 72, 0.2 },
	{ 0.06976, 0.80281, 0.02799, 36, 12, 96, 0.2 },
	{ 0.06976, 0.80281, 0.02702, 36, 12, 120, 0.2 },
	{ 0.06976, 0.80281, 0.02634, 36, 12, 144, 0.2 },
	{ 0.06976, 0.80281, 0.02600, 36, 12, 168, 0.2 },
	{ 0.06976, 0.80281, 0.02595, 36, 12, 180, 0.2 },
	{ 0.06976, 0.79637, 0.03585, 36, 24, 0, 0.2 },
	{ 0.06976, 0.79637, 0.03490, 36, 24, 24, 0.2 },
	{ 0.06976, 0.79637, 0.03309, 36, 24, 48, 0.2 },
	{ 0.06976, 0.79637, 0.03080, 36, 24, 72, 0.2 },
	{ 0.06976, 0.79637, 0.02864, 36, 24, 96, 0.2 },
	{ 0.06976, 0.79637, 0.02704, 36, 24, 120, 0.2 },
	{ 0.06976, 0.79637, 0.02608, 36, 24, 144, 0.2 },
	{ 0.06976, 0.79637, 0.02566, 36, 24, 168, 0.2 },
	{ 0.06976, 0.79637, 0.02561, 36, 24, 180, 0.2 },
	{ 0.06976, 0.78377, 0.04284, 36, 36, 0, 0.2 },
	{ 0.06976, 0.78377, 0.03995, 36, 36, 24, 0.2 },
	{ 0.06976, 0.78377, 0.03691, 36, 36, 48, 0.2 },
	{ 0.06976, 0.78377, 0.03344, 36, 36, 72, 0.2 },
	{ 0.06976, 0.78377, 0.03055, 36, 36, 96, 0.2 },
	{ 0.06976, 0.78377, 0.02879, 36, 36, 120, 0.2 },
	{ 0.06976, 0.78377, 0.02807, 36, 36, 144, 0.2 },
	{ 0.06976, 0.78377, 0.02794, 36, 36, 168, 0.2 },
	{ 0.06976, 0.78377, 0.02793, 36, 36, 180, 0.2 },
	{ 0.06976, 0.76090, 0.04861, 36, 48, 0, 0.2 },
	{ 0.06976, 0.76090, 0.04658, 36, 48, 24, 0.2 },
	{ 0.06976, 0.76090, 0.04256, 36, 48, 48, 0.2 },
	{ 0.06976, 0.76090, 0.03806, 36, 48, 72, 0.2 },
	{ 0.06976, 0.76090, 0.03487, 36, 48, 96, 0.2 },
	{ 0.06976, 0.76090, 0.03370, 36, 48, 120, 0.2 },
	{ 0.06976, 0.76090, 0.03417, 36, 48, 144, 0.2 },
	{ 0.06976, 0.76090, 0.03500, 36, 48, 168, 0.2 },
	{ 0.06976, 0.76090, 0.03513, 36, 48, 180, 0.2 },
	{ 0.06976, 0.71786, 0.05976, 36, 60, 0, 0.2 },
	{ 0.06976, 0.71786, 0.05760, 36, 60, 24, 0.2 },
	{ 0.06976, 0.71786, 0.05236, 36, 60, 48, 0.2 },
	{ 0.06976, 0.71786, 0.04710, 36, 60, 72, 0.2 },
	{ 0.06976, 0.71786, 0.04438, 36, 60, 96, 0.2 },
	{ 0.06976, 0.71786, 0.04529, 36, 60, 120, 0.2 },
	{ 0.06976, 0.71786, 0.04887, 36, 60, 144, 0.2 },
	{ 0.06976, 0.71786, 0.05215, 36, 60, 168, 0.2 },
	{ 0.06976, 0.71786, 0.05266, 36, 60, 180, 0.2 },
	{ 0.06976, 0.68148, 0.06908, 36, 66, 0, 0.2 },
	{ 0.06976, 0.68148, 0.06656, 36, 66, 24, 0.2 },
	{ 0.06976, 0.68148, 0.06067, 36, 66, 48, 0.2 },
	{ 0.06976, 0.68148, 0.05511, 36, 66, 72, 0.2 },
	{ 0.06976, 0.68148, 0.05316, 36, 66, 96, 0.2 },
	{ 0.06976, 0.68148, 0.05623, 36, 66, 120, 0.2 },
	{ 0.06976, 0.68148, 0.06293, 36, 66, 144, 0.2 },
	{ 0.06976, 0.68148, 0.06868, 36, 66, 168, 0.2 },
	{ 0.06976, 0.68148, 0.06954, 36, 66, 180, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 0, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 24, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 48, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 72, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 96, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 120, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 144, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 168, 0.2 },
	{ 0.06976, 0.78132, 0.03047, 48, 0, 180, 0.2 },
	{ 0.06976, 0.77940, 0.03439, 48, 12, 0, 0.2 },
	{ 0.06976, 0.77940, 0.03404, 48, 12, 24, 0.2 },
	{ 0.06976, 0.77940, 0.03309, 48, 12, 48, 0.2 },
	{ 0.06976, 0.77940, 0.03184, 48, 12, 72, 0.2 },
	{ 0.06976, 0.77940, 0.03062, 48, 12, 96, 0.2 },
	{ 0.06976, 0.77940, 0.02965, 48, 12, 120, 0.2 },
	{ 0.06976, 0.77940, 0.02902, 48, 12, 144, 0.2 },
	{ 0.06976, 0.77940, 0.02873, 48, 12, 168, 0.2 },
	{ 0.06976, 0.77940, 0.02870, 48, 12, 180, 0.2 },
	{ 0.06976, 0.77315, 0.04025, 48, 24, 0, 0.2 },
	{ 0.06976, 0.77315, 0.03934, 48, 24, 24, 0.2 },
	{ 0.06976, 0.77315, 0.03703, 48, 24, 48, 0.2 },
	{ 0.06976, 0.77315, 0.03423, 48, 24, 72, 0.2 },
	{ 0.06976, 0.77315, 0.03187, 48, 24, 96, 0.2 },
	{ 0.06976, 0.77315, 0.03042, 48, 24, 120, 0.2 },
	{ 0.06976, 0.77315, 0.02983, 48, 24, 144, 0.2 },
	{ 0.06976, 0.77315, 0.02972, 48, 24, 168, 0.2 },
	{ 0.06976, 0.77315, 0.02972, 48, 24, 180, 0.2 },
	{ 0.06976, 0.76090, 0.04861, 48, 36, 0, 0.2 },
	{ 0.06976, 0.76090, 0.04658, 48, 36, 24, 0.2 },
	{ 0.06976, 0.76090, 0.04256, 48, 36, 48, 0.2 },
	{ 0.06976, 0.76090, 0.03806, 48, 36, 72, 0.2 },
	{ 0.06976, 0.76090, 0.03487, 48, 36, 96, 0.2 },
	{ 0.06976, 0.76090, 0.03369, 48, 36, 120, 0.2 },
	{ 0.06976, 0.76090, 0.03417, 48, 36, 144, 0.2 },
	{ 0.06976, 0.76090, 0.03500, 48, 36, 168, 0.2 },
	{ 0.06976, 0.76090, 0.03513, 48, 36, 180, 0.2 },
	{ 0.06976, 0.73871, 0.06191, 48, 48, 0, 0.2 },
	{ 0.06976, 0.73871, 0.05675, 48, 48, 24, 0.2 },
	{ 0.06976, 0.73871, 0.05067, 48, 48, 48, 0.2 },
	{ 0.06976, 0.73871, 0.04447, 48, 48, 72, 0.2 },
	{ 0.06976, 0.73871, 0.04099, 48, 48, 96, 0.2 },
	{ 0.06976, 0.73871, 0.04144, 48, 48, 120, 0.2 },
	{ 0.06976, 0.73871, 0.04480, 48, 48, 144, 0.2 },
	{ 0.06976, 0.73871, 0.04806, 48, 48, 168, 0.2 },
	{ 0.06976, 0.73871, 0.04858, 48, 48, 180, 0.2 },
	{ 0.06976, 0.69692, 0.07704, 48, 60, 0, 0.2 },
	{ 0.06976, 0.69692, 0.07275, 48, 60, 24, 0.2 },
	{ 0.06976, 0.69692, 0.06426, 48, 60, 48, 0.2 },
	{ 0.06976, 0.69692, 0.05637, 48, 60, 72, 0.2 },
	{ 0.06976, 0.69692, 0.05371, 48, 60, 96, 0.2 },
	{ 0.06976, 0.69692, 0.05838, 48, 60, 120, 0.2 },
	{ 0.06976, 0.69692, 0.06875, 48, 60, 144, 0.2 },
	{ 0.06976, 0.69692, 0.07800, 48, 60, 168, 0.2 },
	{ 0.06976, 0.69692, 0.07942, 48, 60, 180, 0.2 },
	{ 0.06976, 0.66160, 0.08985, 48, 66, 0, 0.2 },
	{ 0.06976, 0.66160, 0.08542, 48, 66, 24, 0.2 },
	{ 0.06976, 0.66160, 0.07536, 48, 66, 48, 0.2 },
	{ 0.06976, 0.66160, 0.06659, 48, 66, 72, 0.2 },
	{ 0.06976, 0.66160, 0.06506, 48, 66, 96, 0.2 },
	{ 0.06976, 0.66160, 0.07383, 48, 66, 120, 0.2 },
	{ 0.06976, 0.66160, 0.09097, 48, 66, 144, 0.2 },
	{ 0.06976, 0.66160, 0.10628, 48, 66, 168, 0.2 },
	{ 0.06976, 0.66160, 0.10873, 48, 66, 180, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 0, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 24, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 48, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 72, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 96, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 120, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 144, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 168, 0.2 },
	{ 0.06976, 0.73712, 0.03674, 60, 0, 180, 0.2 },
	{ 0.06976, 0.73530, 0.04089, 60, 12, 0, 0.2 },
	{ 0.06976, 0.73530, 0.04050, 60, 12, 24, 0.2 },
	{ 0.06976, 0.73530, 0.03953, 60, 12, 48, 0.2 },
	{ 0.06976, 0.73530, 0.03831, 60, 12, 72, 0.2 },
	{ 0.06976, 0.73530, 0.03724, 60, 12, 96, 0.2 },
	{ 0.06976, 0.73530, 0.03658, 60, 12, 120, 0.2 },
	{ 0.06976, 0.73530, 0.03630, 60, 12, 144, 0.2 },
	{ 0.06976, 0.73530, 0.03623, 60, 12, 168, 0.2 },
	{ 0.06976, 0.73530, 0.03622, 60, 12, 180, 0.2 },
	{ 0.06976, 0.72941, 0.04842, 60, 24, 0, 0.2 },
	{ 0.06976, 0.72941, 0.04733, 60, 24, 24, 0.2 },
	{ 0.06976, 0.72941, 0.04458, 60, 24, 48, 0.2 },
	{ 0.06976, 0.72941, 0.04157, 60, 24, 72, 0.2 },
	{ 0.06976, 0.72941, 0.03952, 60, 24, 96, 0.2 },
	{ 0.06976, 0.72941, 0.03899, 60, 24, 120, 0.2 },
	{ 0.06976, 0.72941, 0.03964, 60, 24, 144, 0.2 },
	{ 0.06976, 0.72941, 0.04044, 60, 24, 168, 0.2 },
	{ 0.06976, 0.72941, 0.04057, 60, 24, 180, 0.2 },
	{ 0.06976, 0.71786, 0.05976, 60, 36, 0, 0.2 },
	{ 0.06976, 0.71786, 0.05760, 60, 36, 24, 0.2 },
	{ 0.06976, 0.71786, 0.05236, 60, 36, 48, 0.2 },
	{ 0.06976, 0.71786, 0.04710, 60, 36, 72, 0.2 },
	{ 0.06976, 0.71786, 0.04438, 60, 36, 96, 0.2 },
	{ 0.06976, 0.71786, 0.04529, 60, 36, 120, 0.2 },
	{ 0.06976, 0.71786, 0.04887, 60, 36, 144, 0.2 },
	{ 0.06976, 0.71786, 0.05215, 60, 36, 168, 0.2 },
	{ 0.06976, 0.71786, 0.05267, 60, 36, 180, 0.2 },
	{ 0.06976, 0.69692, 0.07704, 60, 48, 0, 0.2 },
	{ 0.06976, 0.69692, 0.07275, 60, 48, 24, 0.2 },
	{ 0.06976, 0.69692, 0.06426, 60, 48, 48, 0.2 },
	{ 0.06976, 0.69692, 0.05637, 60, 48, 72, 0.2 },
	{ 0.06976, 0.69692, 0.05372, 60, 48, 96, 0.2 },
	{ 0.06976, 0.69692, 0.05838, 60, 48, 120, 0.2 },
	{ 0.06976, 0.69692, 0.06876, 60, 48, 144, 0.2 },
	{ 0.06976, 0.69692, 0.07800, 60, 48, 168, 0.2 },
	{ 0.06976, 0.69692, 0.07943, 60, 48, 180, 0.2 },
	{ 0.06976, 0.65749, 0.10716, 60, 60, 0, 0.2 },
	{ 0.06976, 0.65749, 0.09714, 60, 60, 24, 0.2 },
	{ 0.06976, 0.65749, 0.08420, 60, 60, 48, 0.2 },
	{ 0.06976, 0.65749, 0.07323, 60, 60, 72, 0.2 },
	{ 0.06976, 0.65749, 0.07205, 60, 60, 96, 0.2 },
	{ 0.06976, 0.65749, 0.08515, 60, 60, 120, 0.2 },
	{ 0.06976, 0.65749, 0.11086, 60, 60, 144, 0.2 },
	{ 0.06976, 0.65749, 0.13510, 60, 60, 168, 0.2 },
	{ 0.06976, 0.65749, 0.13900, 60, 60, 180, 0.2 },
	{ 0.06976, 0.62417, 0.12681, 60, 66, 0, 0.2 },
	{ 0.06976, 0.62417, 0.11628, 60, 66, 24, 0.2 },
	{ 0.06976, 0.62417, 0.10030, 60, 66, 48, 0.2 },
	{ 0.06976, 0.62417, 0.08743, 60, 66, 72, 0.2 },
	{ 0.06976, 0.62417, 0.08800, 60, 66, 96, 0.2 },
	{ 0.06976, 0.62417, 0.10873, 60, 66, 120, 0.2 },
	{ 0.06976, 0.62417, 0.14895, 60, 66, 144, 0.2 },
	{ 0.06976, 0.62417, 0.18861, 60, 66, 168, 0.2 },
	{ 0.06976, 0.62417, 0.19517, 60, 66, 180, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 0, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 24, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 48, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 72, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 96, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 120, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 144, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 168, 0.2 },
	{ 0.06976, 0.69977, 0.04289, 66, 0, 180, 0.2 },
	{ 0.06976, 0.69804, 0.04691, 66, 12, 0, 0.2 },
	{ 0.06976, 0.69804, 0.04654, 66, 12, 24, 0.2 },
	{ 0.06976, 0.69804, 0.04558, 66, 12, 48, 0.2 },
	{ 0.06976, 0.69804, 0.04448, 66, 12, 72, 0.2 },
	{ 0.06976, 0.69804, 0.04369, 66, 12, 96, 0.2 },
	{ 0.06976, 0.69804, 0.04339, 66, 12, 120, 0.2 },
	{ 0.06976, 0.69804, 0.04351, 66, 12, 144, 0.2 },
	{ 0.06976, 0.69804, 0.04371, 66, 12, 168, 0.2 },
	{ 0.06976, 0.69804, 0.04374, 66, 12, 180, 0.2 },
	{ 0.06976, 0.69244, 0.05544, 66, 24, 0, 0.2 },
	{ 0.06976, 0.69244, 0.05423, 66, 24, 24, 0.2 },
	{ 0.06976, 0.69244, 0.05134, 66, 24, 48, 0.2 },
	{ 0.06976, 0.69244, 0.04835, 66, 24, 72, 0.2 },
	{ 0.06976, 0.69244, 0.04679, 66, 24, 96, 0.2 },
	{ 0.06976, 0.69244, 0.04731, 66, 24, 120, 0.2 },
	{ 0.06976, 0.69244, 0.04923, 66, 24, 144, 0.2 },
	{ 0.06976, 0.69244, 0.05095, 66, 24, 168, 0.2 },
	{ 0.06976, 0.69244, 0.05121, 66, 24, 180, 0.2 },
	{ 0.06976, 0.68148, 0.06909, 66, 36, 0, 0.2 },
	{ 0.06976, 0.68148, 0.06656, 66, 36, 24, 0.2 },
	{ 0.06976, 0.68148, 0.06067, 66, 36, 48, 0.2 },
	{ 0.06976, 0.68148, 0.05512, 66, 36, 72, 0.2 },
	{ 0.06976, 0.68148, 0.05316, 66, 36, 96, 0.2 },
	{ 0.06976, 0.68148, 0.05623, 66, 36, 120, 0.2 },
	{ 0.06976, 0.68148, 0.06293, 66, 36, 144, 0.2 },
	{ 0.06976, 0.68148, 0.06868, 66, 36, 168, 0.2 },
	{ 0.06976, 0.68148, 0.06954, 66, 36, 180, 0.2 },
	{ 0.06976, 0.66160, 0.08985, 66, 48, 0, 0.2 },
	{ 0.06976, 0.66160, 0.08543, 66, 48, 24, 0.2 },
	{ 0.06976, 0.66160, 0.07538, 66, 48, 48, 0.2 },
	{ 0.06976, 0.66160, 0.06661, 66, 48, 72, 0.2 },
	{ 0.06976, 0.66160, 0.06507, 66, 48, 96, 0.2 },
	{ 0.06976, 0.66160, 0.07383, 66, 48, 120, 0.2 },
	{ 0.06976, 0.66160, 0.09098, 66, 48, 144, 0.2 },
	{ 0.06976, 0.66160, 0.10629, 66, 48, 168, 0.2 },
	{ 0.06976, 0.66160, 0.10874, 66, 48, 180, 0.2 },
	{ 0.06976, 0.62417, 0.12682, 66, 60, 0, 0.2 },
	{ 0.06976, 0.62417, 0.11628, 66, 60, 24, 0.2 },
	{ 0.06976, 0.62417, 0.10031, 66, 60, 48, 0.2 },
	{ 0.06976, 0.62417, 0.08743, 66, 60, 72, 0.2 },
	{ 0.06976, 0.62417, 0.08801, 66, 60, 96, 0.2 },
	{ 0.06976, 0.62417, 0.10874, 66, 60, 120, 0.2 },
	{ 0.06976, 0.62417, 0.14894, 66, 60, 144, 0.2 },
	{ 0.06976, 0.62417, 0.18861, 66, 60, 168, 0.2 },
	{ 0.06976, 0.62417, 0.19518, 66, 60, 180, 0.2 },
	{ 0.06976, 0.59254, 0.15562, 66, 66, 0, 0.2 },
	{ 0.06976, 0.59254, 0.14061, 66, 66, 24, 0.2 },
	{ 0.06976, 0.59254, 0.12049, 66, 66, 48, 0.2 },
	{ 0.06976, 0.59254, 0.10492, 66, 66, 72, 0.2 },
	{ 0.06976, 0.59254, 0.10770, 66, 66, 96, 0.2 },
	{ 0.06976, 0.59254, 0.13891, 66, 66, 120, 0.2 },
	{ 0.06976, 0.59254, 0.20073, 66, 66, 144, 0.2 },
	{ 0.06976, 0.59254, 0.26570, 66, 66, 168, 0.2 },
	{ 0.06976, 0.59254, 0.27719, 66, 66, 180, 0.2 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 0, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 24, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 48, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 72, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 96, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 120, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 144, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 168, 0.3 },
	{ 0.07817, 0.76886, 0.03233, 0, 0, 180, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 0, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 24, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 48, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 72, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 96, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 120, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 144, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 168, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 0, 12, 180, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 0, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 24, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 48, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 72, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 96, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 120, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 144, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 168, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 0, 24, 180, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 0, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 24, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 48, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 72, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 96, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 120, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 144, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 168, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 0, 36, 180, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 0, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 24, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 48, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 72, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 96, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 120, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 144, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 168, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 0, 48, 180, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 0, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 24, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 48, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 72, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 96, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 120, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 144, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 168, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 0, 60, 180, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 0, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 24, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 48, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 72, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 96, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 120, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 144, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 168, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 0, 66, 180, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 0, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 24, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 48, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 72, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 96, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 120, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 144, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 168, 0.3 },
	{ 0.07817, 0.76621, 0.03086, 12, 0, 180, 0.3 },
	{ 0.07817, 0.76357, 0.03375, 12, 12, 0, 0.3 },
	{ 0.07817, 0.76357, 0.03319, 12, 12, 24, 0.3 },
	{ 0.07817, 0.76357, 0.03204, 12, 12, 48, 0.3 },
	{ 0.07817, 0.76357, 0.03111, 12, 12, 72, 0.3 },
	{ 0.07817, 0.76357, 0.03048, 12, 12, 96, 0.3 },
	{ 0.07817, 0.76357, 0.03001, 12, 12, 120, 0.3 },
	{ 0.07817, 0.76357, 0.02965, 12, 12, 144, 0.3 },
	{ 0.07817, 0.76357, 0.02947, 12, 12, 168, 0.3 },
	{ 0.07817, 0.76357, 0.02944, 12, 12, 180, 0.3 },
	{ 0.07817, 0.75502, 0.03372, 12, 24, 0, 0.3 },
	{ 0.07817, 0.75502, 0.03330, 12, 24, 24, 0.3 },
	{ 0.07817, 0.75502, 0.03252, 12, 24, 48, 0.3 },
	{ 0.07817, 0.75502, 0.03165, 12, 24, 72, 0.3 },
	{ 0.07817, 0.75502, 0.03074, 12, 24, 96, 0.3 },
	{ 0.07817, 0.75502, 0.02992, 12, 24, 120, 0.3 },
	{ 0.07817, 0.75502, 0.02934, 12, 24, 144, 0.3 },
	{ 0.07817, 0.75502, 0.02902, 12, 24, 168, 0.3 },
	{ 0.07817, 0.75502, 0.02898, 12, 24, 180, 0.3 },
	{ 0.07817, 0.73838, 0.03542, 12, 36, 0, 0.3 },
	{ 0.07817, 0.73838, 0.03512, 12, 36, 24, 0.3 },
	{ 0.07817, 0.73838, 0.03427, 12, 36, 48, 0.3 },
	{ 0.07817, 0.73838, 0.03311, 12, 36, 72, 0.3 },
	{ 0.07817, 0.73838, 0.03193, 12, 36, 96, 0.3 },
	{ 0.07817, 0.73838, 0.03094, 12, 36, 120, 0.3 },
	{ 0.07817, 0.73838, 0.03025, 12, 36, 144, 0.3 },
	{ 0.07817, 0.73838, 0.02992, 12, 36, 168, 0.3 },
	{ 0.07817, 0.73838, 0.02988, 12, 36, 180, 0.3 },
	{ 0.07817, 0.70859, 0.03902, 12, 48, 0, 0.3 },
	{ 0.07817, 0.70859, 0.03866, 12, 48, 24, 0.3 },
	{ 0.07817, 0.70859, 0.03767, 12, 48, 48, 0.3 },
	{ 0.07817, 0.70859, 0.03641, 12, 48, 72, 0.3 },
	{ 0.07817, 0.70859, 0.03522, 12, 48, 96, 0.3 },
	{ 0.07817, 0.70859, 0.03432, 12, 48, 120, 0.3 },
	{ 0.07817, 0.70859, 0.03377, 12, 48, 144, 0.3 },
	{ 0.07817, 0.70859, 0.03354, 12, 48, 168, 0.3 },
	{ 0.07817, 0.70859, 0.03351, 12, 48, 180, 0.3 },
	{ 0.07817, 0.65398, 0.04647, 12, 60, 0, 0.3 },
	{ 0.07817, 0.65398, 0.04608, 12, 60, 24, 0.3 },
	{ 0.07817, 0.65398, 0.04516, 12, 60, 48, 0.3 },
	{ 0.07817, 0.65398, 0.04405, 12, 60, 72, 0.3 },
	{ 0.07817, 0.65398, 0.04319, 12, 60, 96, 0.3 },
	{ 0.07817, 0.65398, 0.04277, 12, 60, 120, 0.3 },
	{ 0.07817, 0.65398, 0.04274, 12, 60, 144, 0.3 },
	{ 0.07817, 0.65398, 0.04281, 12, 60, 168, 0.3 },
	{ 0.07817, 0.65398, 0.04283, 12, 60, 180, 0.3 },
	{ 0.07817, 0.60942, 0.05318, 12, 66, 0, 0.3 },
	{ 0.07817, 0.60942, 0.05285, 12, 66, 24, 0.3 },
	{ 0.07817, 0.60942, 0.05200, 12, 66, 48, 0.3 },
	{ 0.07817, 0.60942, 0.05112, 12, 66, 72, 0.3 },
	{ 0.07817, 0.60942, 0.05065, 12, 66, 96, 0.3 },
	{ 0.07817, 0.60942, 0.05076, 12, 66, 120, 0.3 },
	{ 0.07817, 0.60942, 0.05126, 12, 66, 144, 0.3 },
	{ 0.07817, 0.60942, 0.05169, 12, 66, 168, 0.3 },
	{ 0.07817, 0.60942, 0.05176, 12, 66, 180, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 0, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 24, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 48, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 72, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 96, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 120, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 144, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 168, 0.3 },
	{ 0.07817, 0.75763, 0.03080, 24, 0, 180, 0.3 },
	{ 0.07817, 0.75502, 0.03372, 24, 12, 0, 0.3 },
	{ 0.07817, 0.75502, 0.03330, 24, 12, 24, 0.3 },
	{ 0.07817, 0.75502, 0.03252, 24, 12, 48, 0.3 },
	{ 0.07817, 0.75502, 0.03165, 24, 12, 72, 0.3 },
	{ 0.07817, 0.75502, 0.03074, 24, 12, 96, 0.3 },
	{ 0.07817, 0.75502, 0.02992, 24, 12, 120, 0.3 },
	{ 0.07817, 0.75502, 0.02934, 24, 12, 144, 0.3 },
	{ 0.07817, 0.75502, 0.02902, 24, 12, 168, 0.3 },
	{ 0.07817, 0.75502, 0.02898, 24, 12, 180, 0.3 },
	{ 0.07817, 0.74656, 0.03856, 24, 24, 0, 0.3 },
	{ 0.07817, 0.74656, 0.03663, 24, 24, 24, 0.3 },
	{ 0.07817, 0.74656, 0.03463, 24, 24, 48, 0.3 },
	{ 0.07817, 0.74656, 0.03292, 24, 24, 72, 0.3 },
	{ 0.07817, 0.74656, 0.03121, 24, 24, 96, 0.3 },
	{ 0.07817, 0.74656, 0.02982, 24, 24, 120, 0.3 },
	{ 0.07817, 0.74656, 0.02890, 24, 24, 144, 0.3 },
	{ 0.07817, 0.74656, 0.02847, 24, 24, 168, 0.3 },
	{ 0.07817, 0.74656, 0.02842, 24, 24, 180, 0.3 },
	{ 0.07817, 0.73011, 0.04058, 24, 36, 0, 0.3 },
	{ 0.07817, 0.73011, 0.03945, 24, 36, 24, 0.3 },
	{ 0.07817, 0.73011, 0.03748, 24, 36, 48, 0.3 },
	{ 0.07817, 0.73011, 0.03504, 24, 36, 72, 0.3 },
	{ 0.07817, 0.73011, 0.03283, 24, 36, 96, 0.3 },
	{ 0.07817, 0.73011, 0.03128, 24, 36, 120, 0.3 },
	{ 0.07817, 0.73011, 0.03041, 24, 36, 144, 0.3 },
	{ 0.07817, 0.73011, 0.03005, 24, 36, 168, 0.3 },
	{ 0.07817, 0.73011, 0.03002, 24, 36, 180, 0.3 },
	{ 0.07817, 0.70066, 0.04541, 24, 48, 0, 0.3 },
	{ 0.07817, 0.70066, 0.04444, 24, 48, 24, 0.3 },
	{ 0.07817, 0.70066, 0.04200, 24, 48, 48, 0.3 },
	{ 0.07817, 0.70066, 0.03913, 24, 48, 72, 0.3 },
	{ 0.07817, 0.70066, 0.03687, 24, 48, 96, 0.3 },
	{ 0.07817, 0.70066, 0.03568, 24, 48, 120, 0.3 },
	{ 0.07817, 0.70066, 0.03541, 24, 48, 144, 0.3 },
	{ 0.07817, 0.70066, 0.03551, 24, 48, 168, 0.3 },
	{ 0.07817, 0.70066, 0.03553, 24, 48, 180, 0.3 },
	{ 0.07817, 0.64666, 0.05445, 24, 60, 0, 0.3 },
	{ 0.07817, 0.64666, 0.05333, 24, 60, 24, 0.3 },
	{ 0.07817, 0.64666, 0.05056, 24, 60, 48, 0.3 },
	{ 0.07817, 0.64666, 0.04771, 24, 60, 72, 0.3 },
	{ 0.07817, 0.64666, 0.04609, 24, 60, 96, 0.3 },
	{ 0.07817, 0.64666, 0.04626, 24, 60, 120, 0.3 },
	{ 0.07817, 0.64666, 0.04767, 24, 60, 144, 0.3 },
	{ 0.07817, 0.64666, 0.04899, 24, 60, 168, 0.3 },
	{ 0.07817, 0.64666, 0.04918, 24, 60, 180, 0.3 },
	{ 0.07817, 0.60259, 0.06205, 24, 66, 0, 0.3 },
	{ 0.07817, 0.60259, 0.06084, 24, 66, 24, 0.3 },
	{ 0.07817, 0.60259, 0.05805, 24, 66, 48, 0.3 },
	{ 0.07817, 0.60259, 0.05540, 24, 66, 72, 0.3 },
	{ 0.07817, 0.60259, 0.05455, 24, 66, 96, 0.3 },
	{ 0.07817, 0.60259, 0.05612, 24, 66, 120, 0.3 },
	{ 0.07817, 0.60259, 0.05918, 24, 66, 144, 0.3 },
	{ 0.07817, 0.60259, 0.06168, 24, 66, 168, 0.3 },
	{ 0.07817, 0.60259, 0.06205, 24, 66, 180, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 0, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 24, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 48, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 72, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 96, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 120, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 144, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 168, 0.3 },
	{ 0.07817, 0.74093, 0.03189, 36, 0, 180, 0.3 },
	{ 0.07817, 0.73838, 0.03542, 36, 12, 0, 0.3 },
	{ 0.07817, 0.73838, 0.03512, 36, 12, 24, 0.3 },
	{ 0.07817, 0.73838, 0.03427, 36, 12, 48, 0.3 },
	{ 0.07817, 0.73838, 0.03312, 36, 12, 72, 0.3 },
	{ 0.07817, 0.73838, 0.03193, 36, 12, 96, 0.3 },
	{ 0.07817, 0.73838, 0.03094, 36, 12, 120, 0.3 },
	{ 0.07817, 0.73838, 0.03025, 36, 12, 144, 0.3 },
	{ 0.07817, 0.73838, 0.02992, 36, 12, 168, 0.3 },
	{ 0.07817, 0.73838, 0.02988, 36, 12, 180, 0.3 },
	{ 0.07817, 0.73011, 0.04057, 36, 24, 0, 0.3 },
	{ 0.07817, 0.73011, 0.03946, 36, 24, 24, 0.3 },
	{ 0.07817, 0.73011, 0.03748, 36, 24, 48, 0.3 },
	{ 0.07817, 0.73011, 0.03504, 36, 24, 72, 0.3 },
	{ 0.07817, 0.73011, 0.03283, 36, 24, 96, 0.3 },
	{ 0.07817, 0.73011, 0.03128, 36, 24, 120, 0.3 },
	{ 0.07817, 0.73011, 0.03041, 36, 24, 144, 0.3 },
	{ 0.07817, 0.73011, 0.03005, 36, 24, 168, 0.3 },
	{ 0.07817, 0.73011, 0.03002, 36, 24, 180, 0.3 },
	{ 0.07817, 0.71402, 0.04878, 36, 36, 0, 0.3 },
	{ 0.07817, 0.71402, 0.04511, 36, 36, 24, 0.3 },
	{ 0.07817, 0.71402, 0.04179, 36, 36, 48, 0.3 },
	{ 0.07817, 0.71402, 0.03814, 36, 36, 72, 0.3 },
	{ 0.07817, 0.71402, 0.03529, 36, 36, 96, 0.3 },
	{ 0.07817, 0.71402, 0.03377, 36, 36, 120, 0.3 },
	{ 0.07817, 0.71402, 0.03337, 36, 36, 144, 0.3 },
	{ 0.07817, 0.71402, 0.03348, 36, 36, 168, 0.3 },
	{ 0.07817, 0.71402, 0.03350, 36, 36, 180, 0.3 },
	{ 0.07817, 0.68521, 0.05477, 36, 48, 0, 0.3 },
	{ 0.07817, 0.68521, 0.05246, 36, 48, 24, 0.3 },
	{ 0.07817, 0.68521, 0.04817, 36, 48, 48, 0.3 },
	{ 0.07817, 0.68521, 0.04358, 36, 48, 72, 0.3 },
	{ 0.07817, 0.68521, 0.04069, 36, 48, 96, 0.3 },
	{ 0.07817, 0.68521, 0.04017, 36, 48, 120, 0.3 },
	{ 0.07817, 0.68521, 0.04145, 36, 48, 144, 0.3 },
	{ 0.07817, 0.68521, 0.04286, 36, 48, 168, 0.3 },
	{ 0.07817, 0.68521, 0.04307, 36, 48, 180, 0.3 },
	{ 0.07817, 0.63241, 0.06682, 36, 60, 0, 0.3 },
	{ 0.07817, 0.63241, 0.06454, 36, 60, 24, 0.3 },
	{ 0.07817, 0.63241, 0.05912, 36, 60, 48, 0.3 },
	{ 0.07817, 0.63241, 0.05405, 36, 60, 72, 0.3 },
	{ 0.07817, 0.63241, 0.05215, 36, 60, 96, 0.3 },
	{ 0.07817, 0.63241, 0.05454, 36, 60, 120, 0.3 },
	{ 0.07817, 0.63241, 0.05994, 36, 60, 144, 0.3 },
	{ 0.07817, 0.63241, 0.06456, 36, 60, 168, 0.3 },
	{ 0.07817, 0.63241, 0.06527, 36, 60, 180, 0.3 },
	{ 0.07817, 0.58931, 0.07676, 36, 66, 0, 0.3 },
	{ 0.07817, 0.58931, 0.07413, 36, 66, 24, 0.3 },
	{ 0.07817, 0.58931, 0.06818, 36, 66, 48, 0.3 },
	{ 0.07817, 0.58931, 0.06307, 36, 66, 72, 0.3 },
	{ 0.07817, 0.58931, 0.06238, 36, 66, 96, 0.3 },
	{ 0.07817, 0.58931, 0.06761, 36, 66, 120, 0.3 },
	{ 0.07817, 0.58931, 0.07699, 36, 66, 144, 0.3 },
	{ 0.07817, 0.58931, 0.08475, 36, 66, 168, 0.3 },
	{ 0.07817, 0.58931, 0.08590, 36, 66, 180, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 0, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 24, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 48, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 72, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 96, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 120, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 144, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 168, 0.3 },
	{ 0.07817, 0.71104, 0.03495, 48, 0, 180, 0.3 },
	{ 0.07817, 0.70859, 0.03902, 48, 12, 0, 0.3 },
	{ 0.07817, 0.70859, 0.03866, 48, 12, 24, 0.3 },
	{ 0.07817, 0.70859, 0.03767, 48, 12, 48, 0.3 },
	{ 0.07817, 0.70859, 0.03641, 48, 12, 72, 0.3 },
	{ 0.07817, 0.70859, 0.03521, 48, 12, 96, 0.3 },
	{ 0.07817, 0.70859, 0.03431, 48, 12, 120, 0.3 },
	{ 0.07817, 0.70859, 0.03377, 48, 12, 144, 0.3 },
	{ 0.07817, 0.70859, 0.03353, 48, 12, 168, 0.3 },
	{ 0.07817, 0.70859, 0.03351, 48, 12, 180, 0.3 },
	{ 0.07817, 0.70066, 0.04540, 48, 24, 0, 0.3 },
	{ 0.07817, 0.70066, 0.04444, 48, 24, 24, 0.3 },
	{ 0.07817, 0.70066, 0.04199, 48, 24, 48, 0.3 },
	{ 0.07817, 0.70066, 0.03912, 48, 24, 72, 0.3 },
	{ 0.07817, 0.70066, 0.03687, 48, 24, 96, 0.3 },
	{ 0.07817, 0.70066, 0.03567, 48, 24, 120, 0.3 },
	{ 0.07817, 0.70066, 0.03540, 48, 24, 144, 0.3 },
	{ 0.07817, 0.70066, 0.03550, 48, 24, 168, 0.3 },
	{ 0.07817, 0.70066, 0.03553, 48, 24, 180, 0.3 },
	{ 0.07817, 0.68521, 0.05476, 48, 36, 0, 0.3 },
	{ 0.07817, 0.68521, 0.05245, 48, 36, 24, 0.3 },
	{ 0.07817, 0.68521, 0.04817, 48, 36, 48, 0.3 },
	{ 0.07817, 0.68521, 0.04358, 48, 36, 72, 0.3 },
	{ 0.07817, 0.68521, 0.04068, 48, 36, 96, 0.3 },
	{ 0.07817, 0.68521, 0.04016, 48, 36, 120, 0.3 },
	{ 0.07817, 0.68521, 0.04144, 48, 36, 144, 0.3 },
	{ 0.07817, 0.68521, 0.04285, 48, 36, 168, 0.3 },
	{ 0.07817, 0.68521, 0.04306, 48, 36, 180, 0.3 },
	{ 0.07817, 0.65757, 0.06999, 48, 48, 0, 0.3 },
	{ 0.07817, 0.65757, 0.06370, 48, 48, 24, 0.3 },
	{ 0.07817, 0.65757, 0.05725, 48, 48, 48, 0.3 },
	{ 0.07817, 0.65757, 0.05105, 48, 48, 72, 0.3 },
	{ 0.07817, 0.65757, 0.04827, 48, 48, 96, 0.3 },
	{ 0.07817, 0.65757, 0.05014, 48, 48, 120, 0.3 },
	{ 0.07817, 0.65757, 0.05533, 48, 48, 144, 0.3 },
	{ 0.07817, 0.65757, 0.05997, 48, 48, 168, 0.3 },
	{ 0.07817, 0.65757, 0.06069, 48, 48, 180, 0.3 },
	{ 0.07817, 0.60690, 0.08586, 48, 60, 0, 0.3 },
	{ 0.07817, 0.60690, 0.08112, 48, 60, 24, 0.3 },
	{ 0.07817, 0.60690, 0.07228, 48, 60, 48, 0.3 },
	{ 0.07817, 0.60690, 0.06471, 48, 60, 72, 0.3 },
	{ 0.07817, 0.60690, 0.06356, 48, 60, 96, 0.3 },
	{ 0.07817, 0.60690, 0.07114, 48, 60, 120, 0.3 },
	{ 0.07817, 0.60690, 0.08548, 48, 60, 144, 0.3 },
	{ 0.07817, 0.60690, 0.09792, 48, 60, 168, 0.3 },
	{ 0.07817, 0.60690, 0.09983, 48, 60, 180, 0.3 },
	{ 0.07817, 0.56554, 0.09927, 48, 66, 0, 0.3 },
	{ 0.07817, 0.56554, 0.09459, 48, 66, 24, 0.3 },
	{ 0.07817, 0.56554, 0.08429, 48, 66, 48, 0.3 },
	{ 0.07817, 0.56554, 0.07614, 48, 66, 72, 0.3 },
	{ 0.07817, 0.56554, 0.07676, 48, 66, 96, 0.3 },
	{ 0.07817, 0.56554, 0.08964, 48, 66, 120, 0.3 },
	{ 0.07817, 0.56554, 0.11258, 48, 66, 144, 0.3 },
	{ 0.07817, 0.56554, 0.13275, 48, 66, 168, 0.3 },
	{ 0.07817, 0.56554, 0.13596, 48, 66, 180, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 0, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 24, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 48, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 72, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 96, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 120, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 144, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 168, 0.3 },
	{ 0.07817, 0.65625, 0.04246, 60, 0, 180, 0.3 },
	{ 0.07817, 0.65398, 0.04646, 60, 12, 0, 0.3 },
	{ 0.07817, 0.65398, 0.04608, 60, 12, 24, 0.3 },
	{ 0.07817, 0.65398, 0.04516, 60, 12, 48, 0.3 },
	{ 0.07817, 0.65398, 0.04405, 60, 12, 72, 0.3 },
	{ 0.07817, 0.65398, 0.04318, 60, 12, 96, 0.3 },
	{ 0.07817, 0.65398, 0.04276, 60, 12, 120, 0.3 },
	{ 0.07817, 0.65398, 0.04274, 60, 12, 144, 0.3 },
	{ 0.07817, 0.65398, 0.04280, 60, 12, 168, 0.3 },
	{ 0.07817, 0.65398, 0.04282, 60, 12, 180, 0.3 },
	{ 0.07817, 0.64666, 0.05445, 60, 24, 0, 0.3 },
	{ 0.07817, 0.64666, 0.05333, 60, 24, 24, 0.3 },
	{ 0.07817, 0.64666, 0.05056, 60, 24, 48, 0.3 },
	{ 0.07817, 0.64666, 0.04770, 60, 24, 72, 0.3 },
	{ 0.07817, 0.64666, 0.04609, 60, 24, 96, 0.3 },
	{ 0.07817, 0.64666, 0.04625, 60, 24, 120, 0.3 },
	{ 0.07817, 0.64666, 0.04766, 60, 24, 144, 0.3 },
	{ 0.07817, 0.64666, 0.04898, 60, 24, 168, 0.3 },
	{ 0.07817, 0.64666, 0.04918, 60, 24, 180, 0.3 },
	{ 0.07817, 0.63241, 0.06681, 60, 36, 0, 0.3 },
	{ 0.07817, 0.63241, 0.06453, 60, 36, 24, 0.3 },
	{ 0.07817, 0.63241, 0.05911, 60, 36, 48, 0.3 },
	{ 0.07817, 0.63241, 0.05404, 60, 36, 72, 0.3 },
	{ 0.07817, 0.63241, 0.05215, 60, 36, 96, 0.3 },
	{ 0.07817, 0.63241, 0.05453, 60, 36, 120, 0.3 },
	{ 0.07817, 0.63241, 0.05993, 60, 36, 144, 0.3 },
	{ 0.07817, 0.63241, 0.06455, 60, 36, 168, 0.3 },
	{ 0.07817, 0.63241, 0.06526, 60, 36, 180, 0.3 },
	{ 0.07817, 0.60690, 0.08586, 60, 48, 0, 0.3 },
	{ 0.07817, 0.60690, 0.08112, 60, 48, 24, 0.3 },
	{ 0.07817, 0.60690, 0.07228, 60, 48, 48, 0.3 },
	{ 0.07817, 0.60690, 0.06471, 60, 48, 72, 0.3 },
	{ 0.07817, 0.60690, 0.06356, 60, 48, 96, 0.3 },
	{ 0.07817, 0.60690, 0.07114, 60, 48, 120, 0.3 },
	{ 0.07817, 0.60690, 0.08549, 60, 48, 144, 0.3 },
	{ 0.07817, 0.60690, 0.09792, 60, 48, 168, 0.3 },
	{ 0.07817, 0.60690, 0.09983, 60, 48, 180, 0.3 },
	{ 0.07817, 0.56012, 0.11922, 60, 60, 0, 0.3 },
	{ 0.07817, 0.56012, 0.10751, 60, 60, 24, 0.3 },
	{ 0.07817, 0.56012, 0.09414, 60, 60, 48, 0.3 },
	{ 0.07817, 0.56012, 0.08387, 60, 60, 72, 0.3 },
	{ 0.07817, 0.56012, 0.08540, 60, 60, 96, 0.3 },
	{ 0.07817, 0.56012, 0.10408, 60, 60, 120, 0.3 },
	{ 0.07817, 0.56012, 0.13820, 60, 60, 144, 0.3 },
	{ 0.07817, 0.56012, 0.17004, 60, 60, 168, 0.3 },
	{ 0.07817, 0.56012, 0.17515, 60, 60, 180, 0.3 },
	{ 0.07817, 0.52195, 0.13970, 60, 66, 0, 0.3 },
	{ 0.07817, 0.52195, 0.12779, 60, 66, 24, 0.3 },
	{ 0.07817, 0.52195, 0.11142, 60, 66, 48, 0.3 },
	{ 0.07817, 0.52195, 0.09961, 60, 66, 72, 0.3 },
	{ 0.07817, 0.52195, 0.10384, 60, 66, 96, 0.3 },
	{ 0.07817, 0.52195, 0.13220, 60, 66, 120, 0.3 },
	{ 0.07817, 0.52195, 0.18457, 60, 66, 144, 0.3 },
	{ 0.07817, 0.52195, 0.23597, 60, 66, 168, 0.3 },
	{ 0.07817, 0.52195, 0.24448, 60, 66, 180, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 0, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 24, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 48, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 72, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 96, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 120, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 144, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 168, 0.3 },
	{ 0.07817, 0.61153, 0.04957, 66, 0, 180, 0.3 },
	{ 0.07817, 0.60942, 0.05319, 66, 12, 0, 0.3 },
	{ 0.07817, 0.60942, 0.05286, 66, 12, 24, 0.3 },
	{ 0.07817, 0.60942, 0.05201, 66, 12, 48, 0.3 },
	{ 0.07817, 0.60942, 0.05113, 66, 12, 72, 0.3 },
	{ 0.07817, 0.60942, 0.05066, 66, 12, 96, 0.3 },
	{ 0.07817, 0.60942, 0.05077, 66, 12, 120, 0.3 },
	{ 0.07817, 0.60942, 0.05127, 66, 12, 144, 0.3 },
	{ 0.07817, 0.60942, 0.05170, 66, 12, 168, 0.3 },
	{ 0.07817, 0.60942, 0.05176, 66, 12, 180, 0.3 },
	{ 0.07817, 0.60259, 0.06206, 66, 24, 0, 0.3 },
	{ 0.07817, 0.60259, 0.06085, 66, 24, 24, 0.3 },
	{ 0.07817, 0.60259, 0.05805, 66, 24, 48, 0.3 },
	{ 0.07817, 0.60259, 0.05541, 66, 24, 72, 0.3 },
	{ 0.07817, 0.60259, 0.05456, 66, 24, 96, 0.3 },
	{ 0.07817, 0.60259, 0.05612, 66, 24, 120, 0.3 },
	{ 0.07817, 0.60259, 0.05918, 66, 24, 144, 0.3 },
	{ 0.07817, 0.60259, 0.06168, 66, 24, 168, 0.3 },
	{ 0.07817, 0.60259, 0.06205, 66, 24, 180, 0.3 },
	{ 0.07817, 0.58931, 0.07677, 66, 36, 0, 0.3 },
	{ 0.07817, 0.58931, 0.07414, 66, 36, 24, 0.3 },
	{ 0.07817, 0.58931, 0.06819, 66, 36, 48, 0.3 },
	{ 0.07817, 0.58931, 0.06308, 66, 36, 72, 0.3 },
	{ 0.07817, 0.58931, 0.06239, 66, 36, 96, 0.3 },
	{ 0.07817, 0.58931, 0.06762, 66, 36, 120, 0.3 },
	{ 0.07817, 0.58931, 0.07699, 66, 36, 144, 0.3 },
	{ 0.07817, 0.58931, 0.08475, 66, 36, 168, 0.3 },
	{ 0.07817, 0.58931, 0.08591, 66, 36, 180, 0.3 },
	{ 0.07817, 0.56554, 0.09930, 66, 48, 0, 0.3 },
	{ 0.07817, 0.56554, 0.09463, 66, 48, 24, 0.3 },
	{ 0.07817, 0.56554, 0.08433, 66, 48, 48, 0.3 },
	{ 0.07817, 0.56554, 0.07619, 66, 48, 72, 0.3 },
	{ 0.07817, 0.56554, 0.07679, 66, 48, 96, 0.3 },
	{ 0.07817, 0.56554, 0.08966, 66, 48, 120, 0.3 },
	{ 0.07817, 0.56554, 0.11260, 66, 48, 144, 0.3 },
	{ 0.07817, 0.56554, 0.13277, 66, 48, 168, 0.3 },
	{ 0.07817, 0.56554, 0.13598, 66, 48, 180, 0.3 },
	{ 0.07817, 0.52195, 0.13973, 66, 60, 0, 0.3 },
	{ 0.07817, 0.52195, 0.12782, 66, 60, 24, 0.3 },
	{ 0.07817, 0.52195, 0.11145, 66, 60, 48, 0.3 },
	{ 0.07817, 0.52195, 0.09964, 66, 60, 72, 0.3 },
	{ 0.07817, 0.52195, 0.10387, 66, 60, 96, 0.3 },
	{ 0.07817, 0.52195, 0.13223, 66, 60, 120, 0.3 },
	{ 0.07817, 0.52195, 0.18459, 66, 60, 144, 0.3 },
	{ 0.07817, 0.52195, 0.23599, 66, 60, 168, 0.3 },
	{ 0.07817, 0.52195, 0.24451, 66, 60, 180, 0.3 },
	{ 0.07817, 0.48638, 0.17056, 66, 66, 0, 0.3 },
	{ 0.07817, 0.48638, 0.15348, 66, 66, 24, 0.3 },
	{ 0.07817, 0.48638, 0.13300, 66, 66, 48, 0.3 },
	{ 0.07817, 0.48638, 0.11890, 66, 66, 72, 0.3 },
	{ 0.07817, 0.48638, 0.12646, 66, 66, 96, 0.3 },
	{ 0.07817, 0.48638, 0.16794, 66, 66, 120, 0.3 },
	{ 0.07817, 0.48638, 0.24727, 66, 66, 144, 0.3 },
	{ 0.07817, 0.48638, 0.33049, 66, 66, 168, 0.3 },
	{ 0.07817, 0.48638, 0.34521, 66, 66, 180, 0.3 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 0, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 24, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 48, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 72, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 96, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 120, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 144, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 168, 0.4 },
	{ 0.08510, 0.71438, 0.03615, 0, 0, 180, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 0, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 24, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 48, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 72, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 96, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 120, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 144, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 168, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 0, 12, 180, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 0, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 24, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 48, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 72, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 96, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 120, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 144, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 168, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 0, 24, 180, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 0, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 24, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 48, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 72, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 96, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 120, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 144, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 168, 0.4 },
	{ 0.08510, 0.68119, 0.03560, 0, 36, 180, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 0, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 24, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 48, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 72, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 96, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 120, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 144, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 168, 0.4 },
	{ 0.08510, 0.64628, 0.03922, 0, 48, 180, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 0, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 24, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 48, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 72, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 96, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 120, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 144, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 168, 0.4 },
	{ 0.08510, 0.58401, 0.04775, 0, 60, 180, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 0, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 24, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 48, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 72, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 96, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 120, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 144, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 168, 0.4 },
	{ 0.08510, 0.53493, 0.05555, 0, 66, 180, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 0, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 24, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 48, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 72, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 96, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 120, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 144, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 168, 0.4 },
	{ 0.08510, 0.71121, 0.03434, 12, 0, 180, 0.4 },
	{ 0.08510, 0.70805, 0.03773, 12, 12, 0, 0.4 },
	{ 0.08510, 0.70805, 0.03705, 12, 12, 24, 0.4 },
	{ 0.08510, 0.70805, 0.03567, 12, 12, 48, 0.4 },
	{ 0.08510, 0.70805, 0.03460, 12, 12, 72, 0.4 },
	{ 0.08510, 0.70805, 0.03389, 12, 12, 96, 0.4 },
	{ 0.08510, 0.70805, 0.03339, 12, 12, 120, 0.4 },
	{ 0.08510, 0.70805, 0.03300, 12, 12, 144, 0.4 },
	{ 0.08510, 0.70805, 0.03281, 12, 12, 168, 0.4 },
	{ 0.08510, 0.70805, 0.03279, 12, 12, 180, 0.4 },
	{ 0.08510, 0.69786, 0.03748, 12, 24, 0, 0.4 },
	{ 0.08510, 0.69786, 0.03700, 12, 24, 24, 0.4 },
	{ 0.08510, 0.69786, 0.03613, 12, 24, 48, 0.4 },
	{ 0.08510, 0.69786, 0.03520, 12, 24, 72, 0.4 },
	{ 0.08510, 0.69786, 0.03424, 12, 24, 96, 0.4 },
	{ 0.08510, 0.69786, 0.03339, 12, 24, 120, 0.4 },
	{ 0.08510, 0.69786, 0.03278, 12, 24, 144, 0.4 },
	{ 0.08510, 0.69786, 0.03245, 12, 24, 168, 0.4 },
	{ 0.08510, 0.69786, 0.03241, 12, 24, 180, 0.4 },
	{ 0.08510, 0.67816, 0.03934, 12, 36, 0, 0.4 },
	{ 0.08510, 0.67816, 0.03902, 12, 36, 24, 0.4 },
	{ 0.08510, 0.67816, 0.03813, 12, 36, 48, 0.4 },
	{ 0.08510, 0.67816, 0.03693, 12, 36, 72, 0.4 },
	{ 0.08510, 0.67816, 0.03571, 12, 36, 96, 0.4 },
	{ 0.08510, 0.67816, 0.03471, 12, 36, 120, 0.4 },
	{ 0.08510, 0.67816, 0.03403, 12, 36, 144, 0.4 },
	{ 0.08510, 0.67816, 0.03371, 12, 36, 168, 0.4 },
	{ 0.08510, 0.67816, 0.03367, 12, 36, 180, 0.4 },
	{ 0.08510, 0.64341, 0.04338, 12, 48, 0, 0.4 },
	{ 0.08510, 0.64341, 0.04300, 12, 48, 24, 0.4 },
	{ 0.08510, 0.64341, 0.04200, 12, 48, 48, 0.4 },
	{ 0.08510, 0.64341, 0.04074, 12, 48, 72, 0.4 },
	{ 0.08510, 0.64341, 0.03959, 12, 48, 96, 0.4 },
	{ 0.08510, 0.64341, 0.03877, 12, 48, 120, 0.4 },
	{ 0.08510, 0.64341, 0.03831, 12, 48, 144, 0.4 },
	{ 0.08510, 0.64341, 0.03813, 12, 48, 168, 0.4 },
	{ 0.08510, 0.64341, 0.03811, 12, 48, 180, 0.4 },
	{ 0.08510, 0.58142, 0.05157, 12, 60, 0, 0.4 },
	{ 0.08510, 0.58142, 0.05120, 12, 60, 24, 0.4 },
	{ 0.08510, 0.58142, 0.05034, 12, 60, 48, 0.4 },
	{ 0.08510, 0.58142, 0.04935, 12, 60, 72, 0.4 },
	{ 0.08510, 0.58142, 0.04868, 12, 60, 96, 0.4 },
	{ 0.08510, 0.58142, 0.04850, 12, 60, 120, 0.4 },
	{ 0.08510, 0.58142, 0.04870, 12, 60, 144, 0.4 },
	{ 0.08510, 0.58142, 0.04890, 12, 60, 168, 0.4 },
	{ 0.08510, 0.58142, 0.04893, 12, 60, 180, 0.4 },
	{ 0.08510, 0.53256, 0.05877, 12, 66, 0, 0.4 },
	{ 0.08510, 0.53256, 0.05847, 12, 66, 24, 0.4 },
	{ 0.08510, 0.53256, 0.05773, 12, 66, 48, 0.4 },
	{ 0.08510, 0.53256, 0.05706, 12, 66, 72, 0.4 },
	{ 0.08510, 0.53256, 0.05689, 12, 66, 96, 0.4 },
	{ 0.08510, 0.53256, 0.05736, 12, 66, 120, 0.4 },
	{ 0.08510, 0.53256, 0.05819, 12, 66, 144, 0.4 },
	{ 0.08510, 0.53256, 0.05883, 12, 66, 168, 0.4 },
	{ 0.08510, 0.53256, 0.05892, 12, 66, 180, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 0, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 24, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 48, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 72, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 96, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 120, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 144, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 168, 0.4 },
	{ 0.08510, 0.70097, 0.03428, 24, 0, 180, 0.4 },
	{ 0.08510, 0.69786, 0.03748, 24, 12, 0, 0.4 },
	{ 0.08510, 0.69786, 0.03700, 24, 12, 24, 0.4 },
	{ 0.08510, 0.69786, 0.03614, 24, 12, 48, 0.4 },
	{ 0.08510, 0.69786, 0.03521, 24, 12, 72, 0.4 },
	{ 0.08510, 0.69786, 0.03425, 24, 12, 96, 0.4 },
	{ 0.08510, 0.69786, 0.03339, 24, 12, 120, 0.4 },
	{ 0.08510, 0.69786, 0.03278, 24, 12, 144, 0.4 },
	{ 0.08510, 0.69786, 0.03245, 24, 12, 168, 0.4 },
	{ 0.08510, 0.69786, 0.03241, 24, 12, 180, 0.4 },
	{ 0.08510, 0.68781, 0.04302, 24, 24, 0, 0.4 },
	{ 0.08510, 0.68781, 0.04072, 24, 24, 24, 0.4 },
	{ 0.08510, 0.68781, 0.03846, 24, 24, 48, 0.4 },
	{ 0.08510, 0.68781, 0.03665, 24, 24, 72, 0.4 },
	{ 0.08510, 0.68781, 0.03487, 24, 24, 96, 0.4 },
	{ 0.08510, 0.68781, 0.03344, 24, 24, 120, 0.4 },
	{ 0.08510, 0.68781, 0.03253, 24, 24, 144, 0.4 },
	{ 0.08510, 0.68781, 0.03211, 24, 24, 168, 0.4 },
	{ 0.08510, 0.68781, 0.03206, 24, 24, 180, 0.4 },
	{ 0.08510, 0.66840, 0.04499, 24, 36, 0, 0.4 },
	{ 0.08510, 0.66840, 0.04373, 24, 36, 24, 0.4 },
	{ 0.08510, 0.66840, 0.04163, 24, 36, 48, 0.4 },
	{ 0.08510, 0.66840, 0.03909, 24, 36, 72, 0.4 },
	{ 0.08510, 0.66840, 0.03685, 24, 36, 96, 0.4 },
	{ 0.08510, 0.66840, 0.03536, 24, 36, 120, 0.4 },
	{ 0.08510, 0.66840, 0.03459, 24, 36, 144, 0.4 },
	{ 0.08510, 0.66840, 0.03431, 24, 36, 168, 0.4 },
	{ 0.08510, 0.66840, 0.03429, 24, 36, 180, 0.4 },
	{ 0.08510, 0.63415, 0.05020, 24, 48, 0, 0.4 },
	{ 0.08510, 0.63415, 0.04919, 24, 48, 24, 0.4 },
	{ 0.08510, 0.63415, 0.04665, 24, 48, 48, 0.4 },
	{ 0.08510, 0.63415, 0.04376, 24, 48, 72, 0.4 },
	{ 0.08510, 0.63415, 0.04163, 24, 48, 96, 0.4 },
	{ 0.08510, 0.63415, 0.04070, 24, 48, 120, 0.4 },
	{ 0.08510, 0.63415, 0.04073, 24, 48, 144, 0.4 },
	{ 0.08510, 0.63415, 0.04104, 24, 48, 168, 0.4 },
	{ 0.08510, 0.63415, 0.04109, 24, 48, 180, 0.4 },
	{ 0.08510, 0.57305, 0.05991, 24, 60, 0, 0.4 },
	{ 0.08510, 0.57305, 0.05878, 24, 60, 24, 0.4 },
	{ 0.08510, 0.57305, 0.05603, 24, 60, 48, 0.4 },
	{ 0.08510, 0.57305, 0.05335, 24, 60, 72, 0.4 },
	{ 0.08510, 0.57305, 0.05216, 24, 60, 96, 0.4 },
	{ 0.08510, 0.57305, 0.05297, 24, 60, 120, 0.4 },
	{ 0.08510, 0.57305, 0.05506, 24, 60, 144, 0.4 },
	{ 0.08510, 0.57305, 0.05684, 24, 60, 168, 0.4 },
	{ 0.08510, 0.57305, 0.05710, 24, 60, 180, 0.4 },
	{ 0.08510, 0.52489, 0.06788, 24, 66, 0, 0.4 },
	{ 0.08510, 0.52489, 0.06668, 24, 66, 24, 0.4 },
	{ 0.08510, 0.52489, 0.06400, 24, 66, 48, 0.4 },
	{ 0.08510, 0.52489, 0.06169, 24, 66, 72, 0.4 },
	{ 0.08510, 0.52489, 0.06149, 24, 66, 96, 0.4 },
	{ 0.08510, 0.52489, 0.06398, 24, 66, 120, 0.4 },
	{ 0.08510, 0.52489, 0.06802, 24, 66, 144, 0.4 },
	{ 0.08510, 0.52489, 0.07119, 24, 66, 168, 0.4 },
	{ 0.08510, 0.52489, 0.07165, 24, 66, 180, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 0, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 24, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 48, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 72, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 96, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 120, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 144, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 168, 0.4 },
	{ 0.08510, 0.68119, 0.03561, 36, 0, 180, 0.4 },
	{ 0.08510, 0.67816, 0.03934, 36, 12, 0, 0.4 },
	{ 0.08510, 0.67816, 0.03903, 36, 12, 24, 0.4 },
	{ 0.08510, 0.67816, 0.03813, 36, 12, 48, 0.4 },
	{ 0.08510, 0.67816, 0.03693, 36, 12, 72, 0.4 },
	{ 0.08510, 0.67816, 0.03571, 36, 12, 96, 0.4 },
	{ 0.08510, 0.67816, 0.03471, 36, 12, 120, 0.4 },
	{ 0.08510, 0.67816, 0.03403, 36, 12, 144, 0.4 },
	{ 0.08510, 0.67816, 0.03371, 36, 12, 168, 0.4 },
	{ 0.08510, 0.67816, 0.03367, 36, 12, 180, 0.4 },
	{ 0.08510, 0.66840, 0.04499, 36, 24, 0, 0.4 },
	{ 0.08510, 0.66840, 0.04373, 36, 24, 24, 0.4 },
	{ 0.08510, 0.66840, 0.04164, 36, 24, 48, 0.4 },
	{ 0.08510, 0.66840, 0.03909, 36, 24, 72, 0.4 },
	{ 0.08510, 0.66840, 0.03685, 36, 24, 96, 0.4 },
	{ 0.08510, 0.66840, 0.03536, 36, 24, 120, 0.4 },
	{ 0.08510, 0.66840, 0.03459, 36, 24, 144, 0.4 },
	{ 0.08510, 0.66840, 0.03431, 36, 24, 168, 0.4 },
	{ 0.08510, 0.66840, 0.03429, 36, 24, 180, 0.4 },
	{ 0.08510, 0.64954, 0.05421, 36, 36, 0, 0.4 },
	{ 0.08510, 0.64954, 0.04992, 36, 36, 24, 0.4 },
	{ 0.08510, 0.64954, 0.04637, 36, 36, 48, 0.4 },
	{ 0.08510, 0.64954, 0.04261, 36, 36, 72, 0.4 },
	{ 0.08510, 0.64954, 0.03984, 36, 36, 96, 0.4 },
	{ 0.08510, 0.64954, 0.03856, 36, 36, 120, 0.4 },
	{ 0.08510, 0.64954, 0.03848, 36, 36, 144, 0.4 },
	{ 0.08510, 0.64954, 0.03881, 36, 36, 168, 0.4 },
	{ 0.08510, 0.64954, 0.03886, 36, 36, 180, 0.4 },
	{ 0.08510, 0.61625, 0.06039, 36, 48, 0, 0.4 },
	{ 0.08510, 0.61625, 0.05786, 36, 48, 24, 0.4 },
	{ 0.08510, 0.61625, 0.05338, 36, 48, 48, 0.4 },
	{ 0.08510, 0.61625, 0.04878, 36, 48, 72, 0.4 },
	{ 0.08510, 0.61625, 0.04619, 36, 48, 96, 0.4 },
	{ 0.08510, 0.61625, 0.04630, 36, 48, 120, 0.4 },
	{ 0.08510, 0.61625, 0.04834, 36, 48, 144, 0.4 },
	{ 0.08510, 0.61625, 0.05027, 36, 48, 168, 0.4 },
	{ 0.08510, 0.61625, 0.05056, 36, 48, 180, 0.4 },
	{ 0.08510, 0.55688, 0.07310, 36, 60, 0, 0.4 },
	{ 0.08510, 0.55688, 0.07073, 36, 60, 24, 0.4 },
	{ 0.08510, 0.55688, 0.06522, 36, 60, 48, 0.4 },
	{ 0.08510, 0.55688, 0.06039, 36, 60, 72, 0.4 },
	{ 0.08510, 0.55688, 0.05928, 36, 60, 96, 0.4 },
	{ 0.08510, 0.55688, 0.06300, 36, 60, 120, 0.4 },
	{ 0.08510, 0.55688, 0.06999, 36, 60, 144, 0.4 },
	{ 0.08510, 0.55688, 0.07577, 36, 60, 168, 0.4 },
	{ 0.08510, 0.55688, 0.07665, 36, 60, 180, 0.4 },
	{ 0.08510, 0.51008, 0.08338, 36, 66, 0, 0.4 },
	{ 0.08510, 0.51008, 0.08070, 36, 66, 24, 0.4 },
	{ 0.08510, 0.51008, 0.07477, 36, 66, 48, 0.4 },
	{ 0.08510, 0.51008, 0.07012, 36, 66, 72, 0.4 },
	{ 0.08510, 0.51008, 0.07056, 36, 66, 96, 0.4 },
	{ 0.08510, 0.51008, 0.07766, 36, 66, 120, 0.4 },
	{ 0.08510, 0.51008, 0.08929, 36, 66, 144, 0.4 },
	{ 0.08510, 0.51008, 0.09873, 36, 66, 168, 0.4 },
	{ 0.08510, 0.51008, 0.10012, 36, 66, 180, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 0, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 24, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 48, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 72, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 96, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 120, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 144, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 168, 0.4 },
	{ 0.08510, 0.64628, 0.03920, 48, 0, 180, 0.4 },
	{ 0.08510, 0.64341, 0.04337, 48, 12, 0, 0.4 },
	{ 0.08510, 0.64341, 0.04299, 48, 12, 24, 0.4 },
	{ 0.08510, 0.64341, 0.04199, 48, 12, 48, 0.4 },
	{ 0.08510, 0.64341, 0.04073, 48, 12, 72, 0.4 },
	{ 0.08510, 0.64341, 0.03958, 48, 12, 96, 0.4 },
	{ 0.08510, 0.64341, 0.03876, 48, 12, 120, 0.4 },
	{ 0.08510, 0.64341, 0.03830, 48, 12, 144, 0.4 },
	{ 0.08510, 0.64341, 0.03812, 48, 12, 168, 0.4 },
	{ 0.08510, 0.64341, 0.03810, 48, 12, 180, 0.4 },
	{ 0.08510, 0.63415, 0.05019, 48, 24, 0, 0.4 },
	{ 0.08510, 0.63415, 0.04917, 48, 24, 24, 0.4 },
	{ 0.08510, 0.63415, 0.04664, 48, 24, 48, 0.4 },
	{ 0.08510, 0.63415, 0.04374, 48, 24, 72, 0.4 },
	{ 0.08510, 0.63415, 0.04162, 48, 24, 96, 0.4 },
	{ 0.08510, 0.63415, 0.04068, 48, 24, 120, 0.4 },
	{ 0.08510, 0.63415, 0.04071, 48, 24, 144, 0.4 },
	{ 0.08510, 0.63415, 0.04102, 48, 24, 168, 0.4 },
	{ 0.08510, 0.63415, 0.04107, 48, 24, 180, 0.4 },
	{ 0.08510, 0.61625, 0.06037, 48, 36, 0, 0.4 },
	{ 0.08510, 0.61625, 0.05783, 48, 36, 24, 0.4 },
	{ 0.08510, 0.61625, 0.05336, 48, 36, 48, 0.4 },
	{ 0.08510, 0.61625, 0.04876, 48, 36, 72, 0.4 },
	{ 0.08510, 0.61625, 0.04617, 48, 36, 96, 0.4 },
	{ 0.08510, 0.61625, 0.04628, 48, 36, 120, 0.4 },
	{ 0.08510, 0.61625, 0.04831, 48, 36, 144, 0.4 },
	{ 0.08510, 0.61625, 0.05024, 48, 36, 168, 0.4 },
	{ 0.08510, 0.61625, 0.05054, 48, 36, 180, 0.4 },
	{ 0.08510, 0.58467, 0.07714, 48, 48, 0, 0.4 },
	{ 0.08510, 0.58467, 0.06996, 48, 48, 24, 0.4 },
	{ 0.08510, 0.58467, 0.06325, 48, 48, 48, 0.4 },
	{ 0.08510, 0.58467, 0.05714, 48, 48, 72, 0.4 },
	{ 0.08510, 0.58467, 0.05506, 48, 48, 96, 0.4 },
	{ 0.08510, 0.58467, 0.05824, 48, 48, 120, 0.4 },
	{ 0.08510, 0.58467, 0.06506, 48, 48, 144, 0.4 },
	{ 0.08510, 0.58467, 0.07091, 48, 48, 168, 0.4 },
	{ 0.08510, 0.58467, 0.07181, 48, 48, 180, 0.4 },
	{ 0.08510, 0.52834, 0.09349, 48, 60, 0, 0.4 },
	{ 0.08510, 0.52834, 0.08841, 48, 60, 24, 0.4 },
	{ 0.08510, 0.52834, 0.07937, 48, 60, 48, 0.4 },
	{ 0.08510, 0.52834, 0.07220, 48, 60, 72, 0.4 },
	{ 0.08510, 0.52834, 0.07243, 48, 60, 96, 0.4 },
	{ 0.08510, 0.52834, 0.08255, 48, 60, 120, 0.4 },
	{ 0.08510, 0.52834, 0.10027, 48, 60, 144, 0.4 },
	{ 0.08510, 0.52834, 0.11538, 48, 60, 168, 0.4 },
	{ 0.08510, 0.52834, 0.11770, 48, 60, 180, 0.4 },
	{ 0.08510, 0.48394, 0.10718, 48, 66, 0, 0.4 },
	{ 0.08510, 0.48394, 0.10235, 48, 66, 24, 0.4 },
	{ 0.08510, 0.48394, 0.09195, 48, 66, 48, 0.4 },
	{ 0.08510, 0.48394, 0.08447, 48, 66, 72, 0.4 },
	{ 0.08510, 0.48394, 0.08697, 48, 66, 96, 0.4 },
	{ 0.08510, 0.48394, 0.10330, 48, 66, 120, 0.4 },
	{ 0.08510, 0.48394, 0.13098, 48, 66, 144, 0.4 },
	{ 0.08510, 0.48394, 0.15505, 48, 66, 168, 0.4 },
	{ 0.08510, 0.48394, 0.15888, 48, 66, 180, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 0, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 24, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 48, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 72, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 96, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 120, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 144, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 168, 0.4 },
	{ 0.08510, 0.58401, 0.04773, 60, 0, 180, 0.4 },
	{ 0.08510, 0.58142, 0.05157, 60, 12, 0, 0.4 },
	{ 0.08510, 0.58142, 0.05119, 60, 12, 24, 0.4 },
	{ 0.08510, 0.58142, 0.05033, 60, 12, 48, 0.4 },
	{ 0.08510, 0.58142, 0.04935, 60, 12, 72, 0.4 },
	{ 0.08510, 0.58142, 0.04867, 60, 12, 96, 0.4 },
	{ 0.08510, 0.58142, 0.04848, 60, 12, 120, 0.4 },
	{ 0.08510, 0.58142, 0.04869, 60, 12, 144, 0.4 },
	{ 0.08510, 0.58142, 0.04889, 60, 12, 168, 0.4 },
	{ 0.08510, 0.58142, 0.04892, 60, 12, 180, 0.4 },
	{ 0.08510, 0.57305, 0.05990, 60, 24, 0, 0.4 },
	{ 0.08510, 0.57305, 0.05876, 60, 24, 24, 0.4 },
	{ 0.08510, 0.57305, 0.05600, 60, 24, 48, 0.4 },
	{ 0.08510, 0.57305, 0.05333, 60, 24, 72, 0.4 },
	{ 0.08510, 0.57305, 0.05214, 60, 24, 96, 0.4 },
	{ 0.08510, 0.57305, 0.05294, 60, 24, 120, 0.4 },
	{ 0.08510, 0.57305, 0.05503, 60, 24, 144, 0.4 },
	{ 0.08510, 0.57305, 0.05682, 60, 24, 168, 0.4 },
	{ 0.08510, 0.57305, 0.05708, 60, 24, 180, 0.4 },
	{ 0.08510, 0.55688, 0.07307, 60, 36, 0, 0.4 },
	{ 0.08510, 0.55688, 0.07070, 60, 36, 24, 0.4 },
	{ 0.08510, 0.55688, 0.06519, 60, 36, 48, 0.4 },
	{ 0.08510, 0.55688, 0.06037, 60, 36, 72, 0.4 },
	{ 0.08510, 0.55688, 0.05926, 60, 36, 96, 0.4 },
	{ 0.08510, 0.55688, 0.06297, 60, 36, 120, 0.4 },
	{ 0.08510, 0.55688, 0.06996, 60, 36, 144, 0.4 },
	{ 0.08510, 0.55688, 0.07573, 60, 36, 168, 0.4 },
	{ 0.08510, 0.55688, 0.07661, 60, 36, 180, 0.4 },
	{ 0.08510, 0.52834, 0.09349, 60, 48, 0, 0.4 },
	{ 0.08510, 0.52834, 0.08842, 60, 48, 24, 0.4 },
	{ 0.08510, 0.52834, 0.07938, 60, 48, 48, 0.4 },
	{ 0.08510, 0.52834, 0.07221, 60, 48, 72, 0.4 },
	{ 0.08510, 0.52834, 0.07244, 60, 48, 96, 0.4 },
	{ 0.08510, 0.52834, 0.08256, 60, 48, 120, 0.4 },
	{ 0.08510, 0.52834, 0.10028, 60, 48, 144, 0.4 },
	{ 0.08510, 0.52834, 0.11538, 60, 48, 168, 0.4 },
	{ 0.08510, 0.52834, 0.11770, 60, 48, 180, 0.4 },
	{ 0.08510, 0.47743, 0.12914, 60, 60, 0, 0.4 },
	{ 0.08510, 0.47743, 0.11622, 60, 60, 24, 0.4 },
	{ 0.08510, 0.47743, 0.10264, 60, 60, 48, 0.4 },
	{ 0.08510, 0.47743, 0.09312, 60, 60, 72, 0.4 },
	{ 0.08510, 0.47743, 0.09705, 60, 60, 96, 0.4 },
	{ 0.08510, 0.47743, 0.12037, 60, 60, 120, 0.4 },
	{ 0.08510, 0.47743, 0.16130, 60, 60, 144, 0.4 },
	{ 0.08510, 0.47743, 0.19920, 60, 60, 168, 0.4 },
	{ 0.08510, 0.47743, 0.20528, 60, 60, 180, 0.4 },
	{ 0.08510, 0.43731, 0.14996, 60, 66, 0, 0.4 },
	{ 0.08510, 0.43731, 0.13712, 60, 66, 24, 0.4 },
	{ 0.08510, 0.43731, 0.12063, 60, 66, 48, 0.4 },
	{ 0.08510, 0.43731, 0.10989, 60, 66, 72, 0.4 },
	{ 0.08510, 0.43731, 0.11722, 60, 66, 96, 0.4 },
	{ 0.08510, 0.43731, 0.15172, 60, 66, 120, 0.4 },
	{ 0.08510, 0.43731, 0.21357, 60, 66, 144, 0.4 },
	{ 0.08510, 0.43731, 0.27395, 60, 66, 168, 0.4 },
	{ 0.08510, 0.43731, 0.28393, 60, 66, 180, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 0, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 24, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 48, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 72, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 96, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 120, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 144, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 168, 0.4 },
	{ 0.08510, 0.53493, 0.05554, 66, 0, 180, 0.4 },
	{ 0.08510, 0.53256, 0.05877, 66, 12, 0, 0.4 },
	{ 0.08510, 0.53256, 0.05846, 66, 12, 24, 0.4 },
	{ 0.08510, 0.53256, 0.05772, 66, 12, 48, 0.4 },
	{ 0.08510, 0.53256, 0.05705, 66, 12, 72, 0.4 },
	{ 0.08510, 0.53256, 0.05688, 66, 12, 96, 0.4 },
	{ 0.08510, 0.53256, 0.05735, 66, 12, 120, 0.4 },
	{ 0.08510, 0.53256, 0.05818, 66, 12, 144, 0.4 },
	{ 0.08510, 0.53256, 0.05882, 66, 12, 168, 0.4 },
	{ 0.08510, 0.53256, 0.05891, 66, 12, 180, 0.4 },
	{ 0.08510, 0.52489, 0.06787, 66, 24, 0, 0.4 },
	{ 0.08510, 0.52489, 0.06666, 66, 24, 24, 0.4 },
	{ 0.08510, 0.52489, 0.06398, 66, 24, 48, 0.4 },
	{ 0.08510, 0.52489, 0.06167, 66, 24, 72, 0.4 },
	{ 0.08510, 0.52489, 0.06146, 66, 24, 96, 0.4 },
	{ 0.08510, 0.52489, 0.06395, 66, 24, 120, 0.4 },
	{ 0.08510, 0.52489, 0.06800, 66, 24, 144, 0.4 },
	{ 0.08510, 0.52489, 0.07116, 66, 24, 168, 0.4 },
	{ 0.08510, 0.52489, 0.07162, 66, 24, 180, 0.4 },
	{ 0.08510, 0.51008, 0.08336, 66, 36, 0, 0.4 },
	{ 0.08510, 0.51008, 0.08068, 66, 36, 24, 0.4 },
	{ 0.08510, 0.51008, 0.07475, 66, 36, 48, 0.4 },
	{ 0.08510, 0.51008, 0.07010, 66, 36, 72, 0.4 },
	{ 0.08510, 0.51008, 0.07054, 66, 36, 96, 0.4 },
	{ 0.08510, 0.51008, 0.07763, 66, 36, 120, 0.4 },
	{ 0.08510, 0.51008, 0.08926, 66, 36, 144, 0.4 },
	{ 0.08510, 0.51008, 0.09869, 66, 36, 168, 0.4 },
	{ 0.08510, 0.51008, 0.10009, 66, 36, 180, 0.4 },
	{ 0.08510, 0.48394, 0.10720, 66, 48, 0, 0.4 },
	{ 0.08510, 0.48394, 0.10237, 66, 48, 24, 0.4 },
	{ 0.08510, 0.48394, 0.09199, 66, 48, 48, 0.4 },
	{ 0.08510, 0.48394, 0.08450, 66, 48, 72, 0.4 },
	{ 0.08510, 0.48394, 0.08699, 66, 48, 96, 0.4 },
	{ 0.08510, 0.48394, 0.10331, 66, 48, 120, 0.4 },
	{ 0.08510, 0.48394, 0.13098, 66, 48, 144, 0.4 },
	{ 0.08510, 0.48394, 0.15506, 66, 48, 168, 0.4 },
	{ 0.08510, 0.48394, 0.15889, 66, 48, 180, 0.4 },
	{ 0.08510, 0.43731, 0.14998, 66, 60, 0, 0.4 },
	{ 0.08510, 0.43731, 0.13713, 66, 60, 24, 0.4 },
	{ 0.08510, 0.43731, 0.12064, 66, 60, 48, 0.4 },
	{ 0.08510, 0.43731, 0.10990, 66, 60, 72, 0.4 },
	{ 0.08510, 0.43731, 0.11723, 66, 60, 96, 0.4 },
	{ 0.08510, 0.43731, 0.15172, 66, 60, 120, 0.4 },
	{ 0.08510, 0.43731, 0.21357, 66, 60, 144, 0.4 },
	{ 0.08510, 0.43731, 0.27395, 66, 60, 168, 0.4 },
	{ 0.08510, 0.43731, 0.28394, 66, 60, 180, 0.4 },
	{ 0.08510, 0.40056, 0.18192, 66, 66, 0, 0.4 },
	{ 0.08510, 0.40056, 0.16348, 66, 66, 24, 0.4 },
	{ 0.08510, 0.40056, 0.14297, 66, 66, 48, 0.4 },
	{ 0.08510, 0.40056, 0.13029, 66, 66, 72, 0.4 },
	{ 0.08510, 0.40056, 0.14177, 66, 66, 96, 0.4 },
	{ 0.08510, 0.40056, 0.19124, 66, 66, 120, 0.4 },
	{ 0.08510, 0.40056, 0.28373, 66, 66, 144, 0.4 },
	{ 0.08510, 0.40056, 0.38038, 66, 66, 168, 0.4 },
	{ 0.08510, 0.40056, 0.39745, 66, 66, 180, 0.4 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 0, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 24, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 48, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 72, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 96, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 120, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 144, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 168, 0.5 },
	{ 0.09089, 0.66292, 0.03974, 0, 0, 180, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 0, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 24, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 48, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 72, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 96, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 120, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 144, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 168, 0.5 },
	{ 0.09089, 0.65931, 0.03764, 0, 12, 180, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 0, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 24, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 48, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 72, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 96, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 120, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 144, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 168, 0.5 },
	{ 0.09089, 0.64771, 0.03759, 0, 24, 180, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 0, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 24, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 48, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 72, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 96, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 120, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 144, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 168, 0.5 },
	{ 0.09089, 0.62547, 0.03913, 0, 36, 180, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 0, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 24, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 48, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 72, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 96, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 120, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 144, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 168, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 0, 48, 180, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 0, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 24, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 48, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 72, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 96, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 120, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 144, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 168, 0.5 },
	{ 0.09089, 0.51964, 0.05256, 0, 60, 180, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 0, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 24, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 48, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 72, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 96, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 120, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 144, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 168, 0.5 },
	{ 0.09089, 0.46851, 0.06083, 0, 66, 180, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 0, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 24, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 48, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 72, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 96, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 120, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 144, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 168, 0.5 },
	{ 0.09089, 0.65931, 0.03763, 12, 0, 180, 0.5 },
	{ 0.09089, 0.65572, 0.04144, 12, 12, 0, 0.5 },
	{ 0.09089, 0.65572, 0.04067, 12, 12, 24, 0.5 },
	{ 0.09089, 0.65572, 0.03910, 12, 12, 48, 0.5 },
	{ 0.09089, 0.65572, 0.03790, 12, 12, 72, 0.5 },
	{ 0.09089, 0.65572, 0.03713, 12, 12, 96, 0.5 },
	{ 0.09089, 0.65572, 0.03660, 12, 12, 120, 0.5 },
	{ 0.09089, 0.65572, 0.03620, 12, 12, 144, 0.5 },
	{ 0.09089, 0.65572, 0.03600, 12, 12, 168, 0.5 },
	{ 0.09089, 0.65572, 0.03597, 12, 12, 180, 0.5 },
	{ 0.09089, 0.64419, 0.04102, 12, 24, 0, 0.5 },
	{ 0.09089, 0.64419, 0.04049, 12, 24, 24, 0.5 },
	{ 0.09089, 0.64419, 0.03956, 12, 24, 48, 0.5 },
	{ 0.09089, 0.64419, 0.03858, 12, 24, 72, 0.5 },
	{ 0.09089, 0.64419, 0.03758, 12, 24, 96, 0.5 },
	{ 0.09089, 0.64419, 0.03670, 12, 24, 120, 0.5 },
	{ 0.09089, 0.64419, 0.03607, 12, 24, 144, 0.5 },
	{ 0.09089, 0.64419, 0.03573, 12, 24, 168, 0.5 },
	{ 0.09089, 0.64419, 0.03569, 12, 24, 180, 0.5 },
	{ 0.09089, 0.62207, 0.04303, 12, 36, 0, 0.5 },
	{ 0.09089, 0.62207, 0.04270, 12, 36, 24, 0.5 },
	{ 0.09089, 0.62207, 0.04177, 12, 36, 48, 0.5 },
	{ 0.09089, 0.62207, 0.04054, 12, 36, 72, 0.5 },
	{ 0.09089, 0.62207, 0.03930, 12, 36, 96, 0.5 },
	{ 0.09089, 0.62207, 0.03830, 12, 36, 120, 0.5 },
	{ 0.09089, 0.62207, 0.03763, 12, 36, 144, 0.5 },
	{ 0.09089, 0.62207, 0.03732, 12, 36, 168, 0.5 },
	{ 0.09089, 0.62207, 0.03728, 12, 36, 180, 0.5 },
	{ 0.09089, 0.58359, 0.04743, 12, 48, 0, 0.5 },
	{ 0.09089, 0.58359, 0.04705, 12, 48, 24, 0.5 },
	{ 0.09089, 0.58359, 0.04605, 12, 48, 48, 0.5 },
	{ 0.09089, 0.58359, 0.04480, 12, 48, 72, 0.5 },
	{ 0.09089, 0.58359, 0.04370, 12, 48, 96, 0.5 },
	{ 0.09089, 0.58359, 0.04296, 12, 48, 120, 0.5 },
	{ 0.09089, 0.58359, 0.04258, 12, 48, 144, 0.5 },
	{ 0.09089, 0.58359, 0.04245, 12, 48, 168, 0.5 },
	{ 0.09089, 0.58359, 0.04244, 12, 48, 180, 0.5 },
	{ 0.09089, 0.51681, 0.05620, 12, 60, 0, 0.5 },
	{ 0.09089, 0.51681, 0.05584, 12, 60, 24, 0.5 },
	{ 0.09089, 0.51681, 0.05504, 12, 60, 48, 0.5 },
	{ 0.09089, 0.51681, 0.05417, 12, 60, 72, 0.5 },
	{ 0.09089, 0.51681, 0.05367, 12, 60, 96, 0.5 },
	{ 0.09089, 0.51681, 0.05371, 12, 60, 120, 0.5 },
	{ 0.09089, 0.51681, 0.05412, 12, 60, 144, 0.5 },
	{ 0.09089, 0.51681, 0.05444, 12, 60, 168, 0.5 },
	{ 0.09089, 0.51681, 0.05449, 12, 60, 180, 0.5 },
	{ 0.09089, 0.46596, 0.06368, 12, 66, 0, 0.5 },
	{ 0.09089, 0.46596, 0.06341, 12, 66, 24, 0.5 },
	{ 0.09089, 0.46596, 0.06277, 12, 66, 48, 0.5 },
	{ 0.09089, 0.46596, 0.06229, 12, 66, 72, 0.5 },
	{ 0.09089, 0.46596, 0.06239, 12, 66, 96, 0.5 },
	{ 0.09089, 0.46596, 0.06318, 12, 66, 120, 0.5 },
	{ 0.09089, 0.46596, 0.06430, 12, 66, 144, 0.5 },
	{ 0.09089, 0.46596, 0.06511, 12, 66, 168, 0.5 },
	{ 0.09089, 0.46596, 0.06523, 12, 66, 180, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 0, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 24, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 48, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 72, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 96, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 120, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 144, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 168, 0.5 },
	{ 0.09089, 0.64771, 0.03760, 24, 0, 180, 0.5 },
	{ 0.09089, 0.64419, 0.04104, 24, 12, 0, 0.5 },
	{ 0.09089, 0.64419, 0.04051, 24, 12, 24, 0.5 },
	{ 0.09089, 0.64419, 0.03958, 24, 12, 48, 0.5 },
	{ 0.09089, 0.64419, 0.03860, 24, 12, 72, 0.5 },
	{ 0.09089, 0.64419, 0.03760, 24, 12, 96, 0.5 },
	{ 0.09089, 0.64419, 0.03671, 24, 12, 120, 0.5 },
	{ 0.09089, 0.64419, 0.03609, 24, 12, 144, 0.5 },
	{ 0.09089, 0.64419, 0.03575, 24, 12, 168, 0.5 },
	{ 0.09089, 0.64419, 0.03570, 24, 12, 180, 0.5 },
	{ 0.09089, 0.63286, 0.04718, 24, 24, 0, 0.5 },
	{ 0.09089, 0.63286, 0.04456, 24, 24, 24, 0.5 },
	{ 0.09089, 0.63286, 0.04209, 24, 24, 48, 0.5 },
	{ 0.09089, 0.63286, 0.04020, 24, 24, 72, 0.5 },
	{ 0.09089, 0.63286, 0.03837, 24, 24, 96, 0.5 },
	{ 0.09089, 0.63286, 0.03693, 24, 24, 120, 0.5 },
	{ 0.09089, 0.63286, 0.03602, 24, 24, 144, 0.5 },
	{ 0.09089, 0.63286, 0.03562, 24, 24, 168, 0.5 },
	{ 0.09089, 0.63286, 0.03557, 24, 24, 180, 0.5 },
	{ 0.09089, 0.61113, 0.04912, 24, 36, 0, 0.5 },
	{ 0.09089, 0.61113, 0.04775, 24, 36, 24, 0.5 },
	{ 0.09089, 0.61113, 0.04555, 24, 36, 48, 0.5 },
	{ 0.09089, 0.61113, 0.04293, 24, 36, 72, 0.5 },
	{ 0.09089, 0.61113, 0.04069, 24, 36, 96, 0.5 },
	{ 0.09089, 0.61113, 0.03927, 24, 36, 120, 0.5 },
	{ 0.09089, 0.61113, 0.03861, 24, 36, 144, 0.5 },
	{ 0.09089, 0.61113, 0.03840, 24, 36, 168, 0.5 },
	{ 0.09089, 0.61113, 0.03838, 24, 36, 180, 0.5 },
	{ 0.09089, 0.57333, 0.05465, 24, 48, 0, 0.5 },
	{ 0.09089, 0.57333, 0.05360, 24, 48, 24, 0.5 },
	{ 0.09089, 0.57333, 0.05100, 24, 48, 48, 0.5 },
	{ 0.09089, 0.57333, 0.04812, 24, 48, 72, 0.5 },
	{ 0.09089, 0.57333, 0.04613, 24, 48, 96, 0.5 },
	{ 0.09089, 0.57333, 0.04545, 24, 48, 120, 0.5 },
	{ 0.09089, 0.57333, 0.04576, 24, 48, 144, 0.5 },
	{ 0.09089, 0.57333, 0.04626, 24, 48, 168, 0.5 },
	{ 0.09089, 0.57333, 0.04633, 24, 48, 180, 0.5 },
	{ 0.09089, 0.50772, 0.06484, 24, 60, 0, 0.5 },
	{ 0.09089, 0.50772, 0.06371, 24, 60, 24, 0.5 },
	{ 0.09089, 0.50772, 0.06099, 24, 60, 48, 0.5 },
	{ 0.09089, 0.50772, 0.05850, 24, 60, 72, 0.5 },
	{ 0.09089, 0.50772, 0.05771, 24, 60, 96, 0.5 },
	{ 0.09089, 0.50772, 0.05909, 24, 60, 120, 0.5 },
	{ 0.09089, 0.50772, 0.06179, 24, 60, 144, 0.5 },
	{ 0.09089, 0.50772, 0.06398, 24, 60, 168, 0.5 },
	{ 0.09089, 0.50772, 0.06429, 24, 60, 180, 0.5 },
	{ 0.09089, 0.45776, 0.07299, 24, 66, 0, 0.5 },
	{ 0.09089, 0.45776, 0.07181, 24, 66, 24, 0.5 },
	{ 0.09089, 0.45776, 0.06926, 24, 66, 48, 0.5 },
	{ 0.09089, 0.45776, 0.06726, 24, 66, 72, 0.5 },
	{ 0.09089, 0.45776, 0.06763, 24, 66, 96, 0.5 },
	{ 0.09089, 0.45776, 0.07093, 24, 66, 120, 0.5 },
	{ 0.09089, 0.45776, 0.07581, 24, 66, 144, 0.5 },
	{ 0.09089, 0.45776, 0.07953, 24, 66, 168, 0.5 },
	{ 0.09089, 0.45776, 0.08006, 24, 66, 180, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 0, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 24, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 48, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 72, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 96, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 120, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 144, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 168, 0.5 },
	{ 0.09089, 0.62547, 0.03915, 36, 0, 180, 0.5 },
	{ 0.09089, 0.62207, 0.04305, 36, 12, 0, 0.5 },
	{ 0.09089, 0.62207, 0.04272, 36, 12, 24, 0.5 },
	{ 0.09089, 0.62207, 0.04180, 36, 12, 48, 0.5 },
	{ 0.09089, 0.62207, 0.04056, 36, 12, 72, 0.5 },
	{ 0.09089, 0.62207, 0.03932, 36, 12, 96, 0.5 },
	{ 0.09089, 0.62207, 0.03832, 36, 12, 120, 0.5 },
	{ 0.09089, 0.62207, 0.03765, 36, 12, 144, 0.5 },
	{ 0.09089, 0.62207, 0.03735, 36, 12, 168, 0.5 },
	{ 0.09089, 0.62207, 0.03731, 36, 12, 180, 0.5 },
	{ 0.09089, 0.61113, 0.04912, 36, 24, 0, 0.5 },
	{ 0.09089, 0.61113, 0.04775, 36, 24, 24, 0.5 },
	{ 0.09089, 0.61113, 0.04555, 36, 24, 48, 0.5 },
	{ 0.09089, 0.61113, 0.04293, 36, 24, 72, 0.5 },
	{ 0.09089, 0.61113, 0.04069, 36, 24, 96, 0.5 },
	{ 0.09089, 0.61113, 0.03927, 36, 24, 120, 0.5 },
	{ 0.09089, 0.61113, 0.03861, 36, 24, 144, 0.5 },
	{ 0.09089, 0.61113, 0.03840, 36, 24, 168, 0.5 },
	{ 0.09089, 0.61113, 0.03838, 36, 24, 180, 0.5 },
	{ 0.09089, 0.59014, 0.05919, 36, 36, 0, 0.5 },
	{ 0.09089, 0.59014, 0.05439, 36, 36, 24, 0.5 },
	{ 0.09089, 0.59014, 0.05066, 36, 36, 48, 0.5 },
	{ 0.09089, 0.59014, 0.04684, 36, 36, 72, 0.5 },
	{ 0.09089, 0.59014, 0.04416, 36, 36, 96, 0.5 },
	{ 0.09089, 0.59014, 0.04313, 36, 36, 120, 0.5 },
	{ 0.09089, 0.59014, 0.04335, 36, 36, 144, 0.5 },
	{ 0.09089, 0.59014, 0.04388, 36, 36, 168, 0.5 },
	{ 0.09089, 0.59014, 0.04397, 36, 36, 180, 0.5 },
	{ 0.09089, 0.55364, 0.06552, 36, 48, 0, 0.5 },
	{ 0.09089, 0.55364, 0.06281, 36, 48, 24, 0.5 },
	{ 0.09089, 0.55364, 0.05821, 36, 48, 48, 0.5 },
	{ 0.09089, 0.55364, 0.05363, 36, 48, 72, 0.5 },
	{ 0.09089, 0.55364, 0.05136, 36, 48, 96, 0.5 },
	{ 0.09089, 0.55364, 0.05205, 36, 48, 120, 0.5 },
	{ 0.09089, 0.55364, 0.05477, 36, 48, 144, 0.5 },
	{ 0.09089, 0.55364, 0.05718, 36, 48, 168, 0.5 },
	{ 0.09089, 0.55364, 0.05754, 36, 48, 180, 0.5 },
	{ 0.09089, 0.49029, 0.07867, 36, 60, 0, 0.5 },
	{ 0.09089, 0.49029, 0.07625, 36, 60, 24, 0.5 },
	{ 0.09089, 0.49029, 0.07070, 36, 60, 48, 0.5 },
	{ 0.09089, 0.49029, 0.06614, 36, 60, 72, 0.5 },
	{ 0.09089, 0.49029, 0.06575, 36, 60, 96, 0.5 },
	{ 0.09089, 0.49029, 0.07064, 36, 60, 120, 0.5 },
	{ 0.09089, 0.49029, 0.07901, 36, 60, 144, 0.5 },
	{ 0.09089, 0.49029, 0.08577, 36, 60, 168, 0.5 },
	{ 0.09089, 0.49029, 0.08680, 36, 60, 180, 0.5 },
	{ 0.09089, 0.44204, 0.08909, 36, 66, 0, 0.5 },
	{ 0.09089, 0.44204, 0.08639, 36, 66, 24, 0.5 },
	{ 0.09089, 0.44204, 0.08053, 36, 66, 48, 0.5 },
	{ 0.09089, 0.44204, 0.07632, 36, 66, 72, 0.5 },
	{ 0.09089, 0.44204, 0.07776, 36, 66, 96, 0.5 },
	{ 0.09089, 0.44204, 0.08643, 36, 66, 120, 0.5 },
	{ 0.09089, 0.44204, 0.09994, 36, 66, 144, 0.5 },
	{ 0.09089, 0.44204, 0.11076, 36, 66, 168, 0.5 },
	{ 0.09089, 0.44204, 0.11235, 36, 66, 180, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 0, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 24, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 48, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 72, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 96, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 120, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 144, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 168, 0.5 },
	{ 0.09089, 0.58678, 0.04321, 48, 0, 180, 0.5 },
	{ 0.09089, 0.58359, 0.04743, 48, 12, 0, 0.5 },
	{ 0.09089, 0.58359, 0.04705, 48, 12, 24, 0.5 },
	{ 0.09089, 0.58359, 0.04605, 48, 12, 48, 0.5 },
	{ 0.09089, 0.58359, 0.04480, 48, 12, 72, 0.5 },
	{ 0.09089, 0.58359, 0.04370, 48, 12, 96, 0.5 },
	{ 0.09089, 0.58359, 0.04296, 48, 12, 120, 0.5 },
	{ 0.09089, 0.58359, 0.04258, 48, 12, 144, 0.5 },
	{ 0.09089, 0.58359, 0.04245, 48, 12, 168, 0.5 },
	{ 0.09089, 0.58359, 0.04244, 48, 12, 180, 0.5 },
	{ 0.09089, 0.57333, 0.05461, 48, 24, 0, 0.5 },
	{ 0.09089, 0.57333, 0.05356, 48, 24, 24, 0.5 },
	{ 0.09089, 0.57333, 0.05096, 48, 24, 48, 0.5 },
	{ 0.09089, 0.57333, 0.04807, 48, 24, 72, 0.5 },
	{ 0.09089, 0.57333, 0.04608, 48, 24, 96, 0.5 },
	{ 0.09089, 0.57333, 0.04540, 48, 24, 120, 0.5 },
	{ 0.09089, 0.57333, 0.04572, 48, 24, 144, 0.5 },
	{ 0.09089, 0.57333, 0.04621, 48, 24, 168, 0.5 },
	{ 0.09089, 0.57333, 0.04629, 48, 24, 180, 0.5 },
	{ 0.09089, 0.55364, 0.06546, 48, 36, 0, 0.5 },
	{ 0.09089, 0.55364, 0.06275, 48, 36, 24, 0.5 },
	{ 0.09089, 0.55364, 0.05816, 48, 36, 48, 0.5 },
	{ 0.09089, 0.55364, 0.05357, 48, 36, 72, 0.5 },
	{ 0.09089, 0.55364, 0.05131, 48, 36, 96, 0.5 },
	{ 0.09089, 0.55364, 0.05199, 48, 36, 120, 0.5 },
	{ 0.09089, 0.55364, 0.05471, 48, 36, 144, 0.5 },
	{ 0.09089, 0.55364, 0.05712, 48, 36, 168, 0.5 },
	{ 0.09089, 0.55364, 0.05748, 48, 36, 180, 0.5 },
	{ 0.09089, 0.51939, 0.08345, 48, 48, 0, 0.5 },
	{ 0.09089, 0.51939, 0.07559, 48, 48, 24, 0.5 },
	{ 0.09089, 0.51939, 0.06871, 48, 48, 48, 0.5 },
	{ 0.09089, 0.51939, 0.06273, 48, 48, 72, 0.5 },
	{ 0.09089, 0.51939, 0.06130, 48, 48, 96, 0.5 },
	{ 0.09089, 0.51939, 0.06567, 48, 48, 120, 0.5 },
	{ 0.09089, 0.51939, 0.07392, 48, 48, 144, 0.5 },
	{ 0.09089, 0.51939, 0.08083, 48, 48, 168, 0.5 },
	{ 0.09089, 0.51939, 0.08189, 48, 48, 180, 0.5 },
	{ 0.09089, 0.45996, 0.10005, 48, 60, 0, 0.5 },
	{ 0.09089, 0.45996, 0.09474, 48, 60, 24, 0.5 },
	{ 0.09089, 0.45996, 0.08562, 48, 60, 48, 0.5 },
	{ 0.09089, 0.45996, 0.07886, 48, 60, 72, 0.5 },
	{ 0.09089, 0.45996, 0.08033, 48, 60, 96, 0.5 },
	{ 0.09089, 0.45996, 0.09263, 48, 60, 120, 0.5 },
	{ 0.09089, 0.45996, 0.11318, 48, 60, 144, 0.5 },
	{ 0.09089, 0.45996, 0.13050, 48, 60, 168, 0.5 },
	{ 0.09089, 0.45996, 0.13315, 48, 60, 180, 0.5 },
	{ 0.09089, 0.41470, 0.11379, 48, 66, 0, 0.5 },
	{ 0.09089, 0.41470, 0.10887, 48, 66, 24, 0.5 },
	{ 0.09089, 0.41470, 0.09849, 48, 66, 48, 0.5 },
	{ 0.09089, 0.41470, 0.09164, 48, 66, 72, 0.5 },
	{ 0.09089, 0.41470, 0.09577, 48, 66, 96, 0.5 },
	{ 0.09089, 0.41470, 0.11496, 48, 66, 120, 0.5 },
	{ 0.09089, 0.41470, 0.14646, 48, 66, 144, 0.5 },
	{ 0.09089, 0.41470, 0.17364, 48, 66, 168, 0.5 },
	{ 0.09089, 0.41470, 0.17795, 48, 66, 180, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 0, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 24, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 48, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 72, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 96, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 120, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 144, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 168, 0.5 },
	{ 0.09089, 0.51964, 0.05257, 60, 0, 180, 0.5 },
	{ 0.09089, 0.51681, 0.05621, 60, 12, 0, 0.5 },
	{ 0.09089, 0.51681, 0.05586, 60, 12, 24, 0.5 },
	{ 0.09089, 0.51681, 0.05506, 60, 12, 48, 0.5 },
	{ 0.09089, 0.51681, 0.05418, 60, 12, 72, 0.5 },
	{ 0.09089, 0.51681, 0.05368, 60, 12, 96, 0.5 },
	{ 0.09089, 0.51681, 0.05372, 60, 12, 120, 0.5 },
	{ 0.09089, 0.51681, 0.05413, 60, 12, 144, 0.5 },
	{ 0.09089, 0.51681, 0.05445, 60, 12, 168, 0.5 },
	{ 0.09089, 0.51681, 0.05450, 60, 12, 180, 0.5 },
	{ 0.09089, 0.50772, 0.06480, 60, 24, 0, 0.5 },
	{ 0.09089, 0.50772, 0.06366, 60, 24, 24, 0.5 },
	{ 0.09089, 0.50772, 0.06094, 60, 24, 48, 0.5 },
	{ 0.09089, 0.50772, 0.05846, 60, 24, 72, 0.5 },
	{ 0.09089, 0.50772, 0.05766, 60, 24, 96, 0.5 },
	{ 0.09089, 0.50772, 0.05903, 60, 24, 120, 0.5 },
	{ 0.09089, 0.50772, 0.06173, 60, 24, 144, 0.5 },
	{ 0.09089, 0.50772, 0.06392, 60, 24, 168, 0.5 },
	{ 0.09089, 0.50772, 0.06424, 60, 24, 180, 0.5 },
	{ 0.09089, 0.49029, 0.07861, 60, 36, 0, 0.5 },
	{ 0.09089, 0.49029, 0.07619, 60, 36, 24, 0.5 },
	{ 0.09089, 0.49029, 0.07064, 60, 36, 48, 0.5 },
	{ 0.09089, 0.49029, 0.06608, 60, 36, 72, 0.5 },
	{ 0.09089, 0.49029, 0.06569, 60, 36, 96, 0.5 },
	{ 0.09089, 0.49029, 0.07057, 60, 36, 120, 0.5 },
	{ 0.09089, 0.49029, 0.07894, 60, 36, 144, 0.5 },
	{ 0.09089, 0.49029, 0.08570, 60, 36, 168, 0.5 },
	{ 0.09089, 0.49029, 0.08673, 60, 36, 180, 0.5 },
	{ 0.09089, 0.45996, 0.10007, 60, 48, 0, 0.5 },
	{ 0.09089, 0.45996, 0.09476, 60, 48, 24, 0.5 },
	{ 0.09089, 0.45996, 0.08563, 60, 48, 48, 0.5 },
	{ 0.09089, 0.45996, 0.07887, 60, 48, 72, 0.5 },
	{ 0.09089, 0.45996, 0.08035, 60, 48, 96, 0.5 },
	{ 0.09089, 0.45996, 0.09265, 60, 48, 120, 0.5 },
	{ 0.09089, 0.45996, 0.11319, 60, 48, 144, 0.5 },
	{ 0.09089, 0.45996, 0.13051, 60, 48, 168, 0.5 },
	{ 0.09089, 0.45996, 0.13316, 60, 48, 180, 0.5 },
	{ 0.09089, 0.40733, 0.13728, 60, 60, 0, 0.5 },
	{ 0.09089, 0.40733, 0.12351, 60, 60, 24, 0.5 },
	{ 0.09089, 0.40733, 0.10987, 60, 60, 48, 0.5 },
	{ 0.09089, 0.40733, 0.10110, 60, 60, 72, 0.5 },
	{ 0.09089, 0.40733, 0.10707, 60, 60, 96, 0.5 },
	{ 0.09089, 0.40733, 0.13421, 60, 60, 120, 0.5 },
	{ 0.09089, 0.40733, 0.18060, 60, 60, 144, 0.5 },
	{ 0.09089, 0.40733, 0.22327, 60, 60, 168, 0.5 },
	{ 0.09089, 0.40733, 0.23010, 60, 60, 180, 0.5 },
	{ 0.09089, 0.36725, 0.15811, 60, 66, 0, 0.5 },
	{ 0.09089, 0.36725, 0.14464, 60, 66, 24, 0.5 },
	{ 0.09089, 0.36725, 0.12821, 60, 66, 48, 0.5 },
	{ 0.09089, 0.36725, 0.11848, 60, 66, 72, 0.5 },
	{ 0.09089, 0.36725, 0.12839, 60, 66, 96, 0.5 },
	{ 0.09089, 0.36725, 0.16774, 60, 66, 120, 0.5 },
	{ 0.09089, 0.36725, 0.23693, 60, 66, 144, 0.5 },
	{ 0.09089, 0.36725, 0.30412, 60, 66, 168, 0.5 },
	{ 0.09089, 0.36725, 0.31523, 60, 66, 180, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 0, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 24, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 48, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 72, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 96, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 120, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 144, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 168, 0.5 },
	{ 0.09089, 0.46851, 0.06084, 66, 0, 180, 0.5 },
	{ 0.09089, 0.46596, 0.06371, 66, 12, 0, 0.5 },
	{ 0.09089, 0.46596, 0.06344, 66, 12, 24, 0.5 },
	{ 0.09089, 0.46596, 0.06280, 66, 12, 48, 0.5 },
	{ 0.09089, 0.46596, 0.06231, 66, 12, 72, 0.5 },
	{ 0.09089, 0.46596, 0.06241, 66, 12, 96, 0.5 },
	{ 0.09089, 0.46596, 0.06319, 66, 12, 120, 0.5 },
	{ 0.09089, 0.46596, 0.06432, 66, 12, 144, 0.5 },
	{ 0.09089, 0.46596, 0.06513, 66, 12, 168, 0.5 },
	{ 0.09089, 0.46596, 0.06525, 66, 12, 180, 0.5 },
	{ 0.09089, 0.45776, 0.07295, 66, 24, 0, 0.5 },
	{ 0.09089, 0.45776, 0.07177, 66, 24, 24, 0.5 },
	{ 0.09089, 0.45776, 0.06921, 66, 24, 48, 0.5 },
	{ 0.09089, 0.45776, 0.06721, 66, 24, 72, 0.5 },
	{ 0.09089, 0.45776, 0.06758, 66, 24, 96, 0.5 },
	{ 0.09089, 0.45776, 0.07087, 66, 24, 120, 0.5 },
	{ 0.09089, 0.45776, 0.07575, 66, 24, 144, 0.5 },
	{ 0.09089, 0.45776, 0.07947, 66, 24, 168, 0.5 },
	{ 0.09089, 0.45776, 0.08000, 66, 24, 180, 0.5 },
	{ 0.09089, 0.44204, 0.08904, 66, 36, 0, 0.5 },
	{ 0.09089, 0.44204, 0.08633, 66, 36, 24, 0.5 },
	{ 0.09089, 0.44204, 0.08047, 66, 36, 48, 0.5 },
	{ 0.09089, 0.44204, 0.07627, 66, 36, 72, 0.5 },
	{ 0.09089, 0.44204, 0.07770, 66, 36, 96, 0.5 },
	{ 0.09089, 0.44204, 0.08636, 66, 36, 120, 0.5 },
	{ 0.09089, 0.44204, 0.09987, 66, 36, 144, 0.5 },
	{ 0.09089, 0.44204, 0.11068, 66, 36, 168, 0.5 },
	{ 0.09089, 0.44204, 0.11227, 66, 36, 180, 0.5 },
	{ 0.09089, 0.41470, 0.11382, 66, 48, 0, 0.5 },
	{ 0.09089, 0.41470, 0.10891, 66, 48, 24, 0.5 },
	{ 0.09089, 0.41470, 0.09855, 66, 48, 48, 0.5 },
	{ 0.09089, 0.41470, 0.09170, 66, 48, 72, 0.5 },
	{ 0.09089, 0.41470, 0.09581, 66, 48, 96, 0.5 },
	{ 0.09089, 0.41470, 0.11498, 66, 48, 120, 0.5 },
	{ 0.09089, 0.41470, 0.14647, 66, 48, 144, 0.5 },
	{ 0.09089, 0.41470, 0.17366, 66, 48, 168, 0.5 },
	{ 0.09089, 0.41470, 0.17797, 66, 48, 180, 0.5 },
	{ 0.09089, 0.36725, 0.15814, 66, 60, 0, 0.5 },
	{ 0.09089, 0.36725, 0.14467, 66, 60, 24, 0.5 },
	{ 0.09089, 0.36725, 0.12823, 66, 60, 48, 0.5 },
	{ 0.09089, 0.36725, 0.11849, 66, 60, 72, 0.5 },
	{ 0.09089, 0.36725, 0.12840, 66, 60, 96, 0.5 },
	{ 0.09089, 0.36725, 0.16776, 66, 60, 120, 0.5 },
	{ 0.09089, 0.36725, 0.23693, 66, 60, 144, 0.5 },
	{ 0.09089, 0.36725, 0.30413, 66, 60, 168, 0.5 },
	{ 0.09089, 0.36725, 0.31524, 66, 60, 180, 0.5 },
	{ 0.09089, 0.33111, 0.19058, 66, 66, 0, 0.5 },
	{ 0.09089, 0.33111, 0.17126, 66, 66, 24, 0.5 },
	{ 0.09089, 0.33111, 0.15091, 66, 66, 48, 0.5 },
	{ 0.09089, 0.33111, 0.13952, 66, 66, 72, 0.5 },
	{ 0.09089, 0.33111, 0.15418, 66, 66, 96, 0.5 },
	{ 0.09089, 0.33111, 0.20978, 66, 66, 120, 0.5 },
	{ 0.09089, 0.33111, 0.31208, 66, 66, 144, 0.5 },
	{ 0.09089, 0.33111, 0.41858, 66, 66, 168, 0.5 },
	{ 0.09089, 0.33111, 0.43736, 66, 66, 180, 0.5 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 0, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 24, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 48, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 72, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 96, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 120, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 144, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 168, 0.6 },
	{ 0.09581, 0.61443, 0.04316, 0, 0, 180, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 0, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 24, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 48, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 72, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 96, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 120, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 144, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 168, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 0, 12, 180, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 0, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 24, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 48, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 72, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 96, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 120, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 144, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 168, 0.6 },
	{ 0.09581, 0.59778, 0.04078, 0, 24, 180, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 0, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 24, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 48, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 72, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 96, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 120, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 144, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 168, 0.6 },
	{ 0.09581, 0.57365, 0.04252, 0, 36, 180, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 0, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 24, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 48, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 72, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 96, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 120, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 144, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 168, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 0, 48, 180, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 0, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 24, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 48, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 72, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 96, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 120, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 144, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 168, 0.6 },
	{ 0.09581, 0.46238, 0.05700, 0, 60, 180, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 0, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 24, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 48, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 72, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 96, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 120, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 144, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 168, 0.6 },
	{ 0.09581, 0.41091, 0.06556, 0, 66, 180, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 0, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 24, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 48, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 72, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 96, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 120, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 144, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 168, 0.6 },
	{ 0.09581, 0.61047, 0.04080, 12, 0, 180, 0.6 },
	{ 0.09581, 0.60653, 0.04497, 12, 12, 0, 0.6 },
	{ 0.09581, 0.60653, 0.04411, 12, 12, 24, 0.6 },
	{ 0.09581, 0.60653, 0.04239, 12, 12, 48, 0.6 },
	{ 0.09581, 0.60653, 0.04107, 12, 12, 72, 0.6 },
	{ 0.09581, 0.60653, 0.04026, 12, 12, 96, 0.6 },
	{ 0.09581, 0.60653, 0.03971, 12, 12, 120, 0.6 },
	{ 0.09581, 0.60653, 0.03928, 12, 12, 144, 0.6 },
	{ 0.09581, 0.60653, 0.03908, 12, 12, 168, 0.6 },
	{ 0.09581, 0.60653, 0.03905, 12, 12, 180, 0.6 },
	{ 0.09581, 0.59393, 0.04442, 12, 24, 0, 0.6 },
	{ 0.09581, 0.59393, 0.04384, 12, 24, 24, 0.6 },
	{ 0.09581, 0.59393, 0.04285, 12, 24, 48, 0.6 },
	{ 0.09581, 0.59393, 0.04183, 12, 24, 72, 0.6 },
	{ 0.09581, 0.59393, 0.04080, 12, 24, 96, 0.6 },
	{ 0.09581, 0.59393, 0.03989, 12, 24, 120, 0.6 },
	{ 0.09581, 0.59393, 0.03926, 12, 24, 144, 0.6 },
	{ 0.09581, 0.59393, 0.03890, 12, 24, 168, 0.6 },
	{ 0.09581, 0.59393, 0.03886, 12, 24, 180, 0.6 },
	{ 0.09581, 0.56995, 0.04655, 12, 36, 0, 0.6 },
	{ 0.09581, 0.56995, 0.04621, 12, 36, 24, 0.6 },
	{ 0.09581, 0.56995, 0.04526, 12, 36, 48, 0.6 },
	{ 0.09581, 0.56995, 0.04400, 12, 36, 72, 0.6 },
	{ 0.09581, 0.56995, 0.04275, 12, 36, 96, 0.6 },
	{ 0.09581, 0.56995, 0.04175, 12, 36, 120, 0.6 },
	{ 0.09581, 0.56995, 0.04110, 12, 36, 144, 0.6 },
	{ 0.09581, 0.56995, 0.04081, 12, 36, 168, 0.6 },
	{ 0.09581, 0.56995, 0.04077, 12, 36, 180, 0.6 },
	{ 0.09581, 0.52884, 0.05127, 12, 48, 0, 0.6 },
	{ 0.09581, 0.52884, 0.05089, 12, 48, 24, 0.6 },
	{ 0.09581, 0.52884, 0.04988, 12, 48, 48, 0.6 },
	{ 0.09581, 0.52884, 0.04866, 12, 48, 72, 0.6 },
	{ 0.09581, 0.52884, 0.04761, 12, 48, 96, 0.6 },
	{ 0.09581, 0.52884, 0.04694, 12, 48, 120, 0.6 },
	{ 0.09581, 0.52884, 0.04664, 12, 48, 144, 0.6 },
	{ 0.09581, 0.52884, 0.04656, 12, 48, 168, 0.6 },
	{ 0.09581, 0.52884, 0.04656, 12, 48, 180, 0.6 },
	{ 0.09581, 0.45940, 0.06046, 12, 60, 0, 0.6 },
	{ 0.09581, 0.45940, 0.06012, 12, 60, 24, 0.6 },
	{ 0.09581, 0.45940, 0.05938, 12, 60, 48, 0.6 },
	{ 0.09581, 0.45940, 0.05861, 12, 60, 72, 0.6 },
	{ 0.09581, 0.45940, 0.05827, 12, 60, 96, 0.6 },
	{ 0.09581, 0.45940, 0.05851, 12, 60, 120, 0.6 },
	{ 0.09581, 0.45940, 0.05909, 12, 60, 144, 0.6 },
	{ 0.09581, 0.45940, 0.05952, 12, 60, 168, 0.6 },
	{ 0.09581, 0.45940, 0.05959, 12, 60, 180, 0.6 },
	{ 0.09581, 0.40826, 0.06809, 12, 66, 0, 0.6 },
	{ 0.09581, 0.40826, 0.06785, 12, 66, 24, 0.6 },
	{ 0.09581, 0.40826, 0.06730, 12, 66, 48, 0.6 },
	{ 0.09581, 0.40826, 0.06698, 12, 66, 72, 0.6 },
	{ 0.09581, 0.40826, 0.06732, 12, 66, 96, 0.6 },
	{ 0.09581, 0.40826, 0.06837, 12, 66, 120, 0.6 },
	{ 0.09581, 0.40826, 0.06974, 12, 66, 144, 0.6 },
	{ 0.09581, 0.40826, 0.07070, 12, 66, 168, 0.6 },
	{ 0.09581, 0.40826, 0.07084, 12, 66, 180, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 0, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 24, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 48, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 72, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 96, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 120, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 144, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 168, 0.6 },
	{ 0.09581, 0.59778, 0.04081, 24, 0, 180, 0.6 },
	{ 0.09581, 0.59393, 0.04445, 24, 12, 0, 0.6 },
	{ 0.09581, 0.59393, 0.04387, 24, 12, 24, 0.6 },
	{ 0.09581, 0.59393, 0.04288, 24, 12, 48, 0.6 },
	{ 0.09581, 0.59393, 0.04187, 24, 12, 72, 0.6 },
	{ 0.09581, 0.59393, 0.04083, 24, 12, 96, 0.6 },
	{ 0.09581, 0.59393, 0.03993, 24, 12, 120, 0.6 },
	{ 0.09581, 0.59393, 0.03929, 24, 12, 144, 0.6 },
	{ 0.09581, 0.59393, 0.03894, 24, 12, 168, 0.6 },
	{ 0.09581, 0.59393, 0.03890, 24, 12, 180, 0.6 },
	{ 0.09581, 0.58159, 0.05110, 24, 24, 0, 0.6 },
	{ 0.09581, 0.58159, 0.04822, 24, 24, 24, 0.6 },
	{ 0.09581, 0.58159, 0.04557, 24, 24, 48, 0.6 },
	{ 0.09581, 0.58159, 0.04362, 24, 24, 72, 0.6 },
	{ 0.09581, 0.58159, 0.04174, 24, 24, 96, 0.6 },
	{ 0.09581, 0.58159, 0.04029, 24, 24, 120, 0.6 },
	{ 0.09581, 0.58159, 0.03940, 24, 24, 144, 0.6 },
	{ 0.09581, 0.58159, 0.03902, 24, 24, 168, 0.6 },
	{ 0.09581, 0.58159, 0.03897, 24, 24, 180, 0.6 },
	{ 0.09581, 0.55811, 0.05303, 24, 36, 0, 0.6 },
	{ 0.09581, 0.55811, 0.05156, 24, 36, 24, 0.6 },
	{ 0.09581, 0.55811, 0.04928, 24, 36, 48, 0.6 },
	{ 0.09581, 0.55811, 0.04661, 24, 36, 72, 0.6 },
	{ 0.09581, 0.55811, 0.04438, 24, 36, 96, 0.6 },
	{ 0.09581, 0.55811, 0.04303, 24, 36, 120, 0.6 },
	{ 0.09581, 0.55811, 0.04247, 24, 36, 144, 0.6 },
	{ 0.09581, 0.55811, 0.04233, 24, 36, 168, 0.6 },
	{ 0.09581, 0.55811, 0.04233, 24, 36, 180, 0.6 },
	{ 0.09581, 0.51785, 0.05882, 24, 48, 0, 0.6 },
	{ 0.09581, 0.51785, 0.05774, 24, 48, 24, 0.6 },
	{ 0.09581, 0.51785, 0.05510, 24, 48, 48, 0.6 },
	{ 0.09581, 0.51785, 0.05224, 24, 48, 72, 0.6 },
	{ 0.09581, 0.51785, 0.05038, 24, 48, 96, 0.6 },
	{ 0.09581, 0.51785, 0.04994, 24, 48, 120, 0.6 },
	{ 0.09581, 0.51785, 0.05052, 24, 48, 144, 0.6 },
	{ 0.09581, 0.51785, 0.05118, 24, 48, 168, 0.6 },
	{ 0.09581, 0.51785, 0.05128, 24, 48, 180, 0.6 },
	{ 0.09581, 0.44985, 0.06936, 24, 60, 0, 0.6 },
	{ 0.09581, 0.44985, 0.06822, 24, 60, 24, 0.6 },
	{ 0.09581, 0.44985, 0.06555, 24, 60, 48, 0.6 },
	{ 0.09581, 0.44985, 0.06324, 24, 60, 72, 0.6 },
	{ 0.09581, 0.44985, 0.06280, 24, 60, 96, 0.6 },
	{ 0.09581, 0.44985, 0.06468, 24, 60, 120, 0.6 },
	{ 0.09581, 0.44985, 0.06791, 24, 60, 144, 0.6 },
	{ 0.09581, 0.44985, 0.07044, 24, 60, 168, 0.6 },
	{ 0.09581, 0.44985, 0.07080, 24, 60, 180, 0.6 },
	{ 0.09581, 0.39978, 0.07755, 24, 66, 0, 0.6 },
	{ 0.09581, 0.39978, 0.07640, 24, 66, 24, 0.6 },
	{ 0.09581, 0.39978, 0.07396, 24, 66, 48, 0.6 },
	{ 0.09581, 0.39978, 0.07224, 24, 66, 72, 0.6 },
	{ 0.09581, 0.39978, 0.07311, 24, 66, 96, 0.6 },
	{ 0.09581, 0.39978, 0.07707, 24, 66, 120, 0.6 },
	{ 0.09581, 0.39978, 0.08265, 24, 66, 144, 0.6 },
	{ 0.09581, 0.39978, 0.08683, 24, 66, 168, 0.6 },
	{ 0.09581, 0.39978, 0.08743, 24, 66, 180, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 0, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 24, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 48, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 72, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 96, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 120, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 144, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 168, 0.6 },
	{ 0.09581, 0.57365, 0.04257, 36, 0, 180, 0.6 },
	{ 0.09581, 0.56995, 0.04661, 36, 12, 0, 0.6 },
	{ 0.09581, 0.56995, 0.04627, 36, 12, 24, 0.6 },
	{ 0.09581, 0.56995, 0.04532, 36, 12, 48, 0.6 },
	{ 0.09581, 0.56995, 0.04405, 36, 12, 72, 0.6 },
	{ 0.09581, 0.56995, 0.04280, 36, 12, 96, 0.6 },
	{ 0.09581, 0.56995, 0.04181, 36, 12, 120, 0.6 },
	{ 0.09581, 0.56995, 0.04115, 36, 12, 144, 0.6 },
	{ 0.09581, 0.56995, 0.04086, 36, 12, 168, 0.6 },
	{ 0.09581, 0.56995, 0.04082, 36, 12, 180, 0.6 },
	{ 0.09581, 0.55811, 0.05303, 36, 24, 0, 0.6 },
	{ 0.09581, 0.55811, 0.05157, 36, 24, 24, 0.6 },
	{ 0.09581, 0.55811, 0.04929, 36, 24, 48, 0.6 },
	{ 0.09581, 0.55811, 0.04662, 36, 24, 72, 0.6 },
	{ 0.09581, 0.55811, 0.04438, 36, 24, 96, 0.6 },
	{ 0.09581, 0.55811, 0.04304, 36, 24, 120, 0.6 },
	{ 0.09581, 0.55811, 0.04247, 36, 24, 144, 0.6 },
	{ 0.09581, 0.55811, 0.04233, 36, 24, 168, 0.6 },
	{ 0.09581, 0.55811, 0.04233, 36, 24, 180, 0.6 },
	{ 0.09581, 0.53557, 0.06382, 36, 36, 0, 0.6 },
	{ 0.09581, 0.53557, 0.05860, 36, 36, 24, 0.6 },
	{ 0.09581, 0.53557, 0.05473, 36, 36, 48, 0.6 },
	{ 0.09581, 0.53557, 0.05086, 36, 36, 72, 0.6 },
	{ 0.09581, 0.53557, 0.04829, 36, 36, 96, 0.6 },
	{ 0.09581, 0.53557, 0.04749, 36, 36, 120, 0.6 },
	{ 0.09581, 0.53557, 0.04799, 36, 36, 144, 0.6 },
	{ 0.09581, 0.53557, 0.04871, 36, 36, 168, 0.6 },
	{ 0.09581, 0.53557, 0.04882, 36, 36, 180, 0.6 },
	{ 0.09581, 0.49694, 0.07027, 36, 48, 0, 0.6 },
	{ 0.09581, 0.49694, 0.06742, 36, 48, 24, 0.6 },
	{ 0.09581, 0.49694, 0.06273, 36, 48, 48, 0.6 },
	{ 0.09581, 0.49694, 0.05819, 36, 48, 72, 0.6 },
	{ 0.09581, 0.49694, 0.05622, 36, 48, 96, 0.6 },
	{ 0.09581, 0.49694, 0.05744, 36, 48, 120, 0.6 },
	{ 0.09581, 0.49694, 0.06077, 36, 48, 144, 0.6 },
	{ 0.09581, 0.49694, 0.06360, 36, 48, 168, 0.6 },
	{ 0.09581, 0.49694, 0.06402, 36, 48, 180, 0.6 },
	{ 0.09581, 0.43169, 0.08370, 36, 60, 0, 0.6 },
	{ 0.09581, 0.43169, 0.08125, 36, 60, 24, 0.6 },
	{ 0.09581, 0.43169, 0.07570, 36, 60, 48, 0.6 },
	{ 0.09581, 0.43169, 0.07139, 36, 60, 72, 0.6 },
	{ 0.09581, 0.43169, 0.07163, 36, 60, 96, 0.6 },
	{ 0.09581, 0.43169, 0.07753, 36, 60, 120, 0.6 },
	{ 0.09581, 0.43169, 0.08707, 36, 60, 144, 0.6 },
	{ 0.09581, 0.43169, 0.09467, 36, 60, 168, 0.6 },
	{ 0.09581, 0.43169, 0.09581, 36, 60, 180, 0.6 },
	{ 0.09581, 0.38364, 0.09412, 36, 66, 0, 0.6 },
	{ 0.09581, 0.38364, 0.09141, 36, 66, 24, 0.6 },
	{ 0.09581, 0.38364, 0.08564, 36, 66, 48, 0.6 },
	{ 0.09581, 0.38364, 0.08183, 36, 66, 72, 0.6 },
	{ 0.09581, 0.38364, 0.08411, 36, 66, 96, 0.6 },
	{ 0.09581, 0.38364, 0.09409, 36, 66, 120, 0.6 },
	{ 0.09581, 0.38364, 0.10914, 36, 66, 144, 0.6 },
	{ 0.09581, 0.38364, 0.12107, 36, 66, 168, 0.6 },
	{ 0.09581, 0.38364, 0.12282, 36, 66, 180, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 0, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 24, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 48, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 72, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 96, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 120, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 144, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 168, 0.6 },
	{ 0.09581, 0.53227, 0.04702, 48, 0, 180, 0.6 },
	{ 0.09581, 0.52884, 0.05127, 48, 12, 0, 0.6 },
	{ 0.09581, 0.52884, 0.05089, 48, 12, 24, 0.6 },
	{ 0.09581, 0.52884, 0.04988, 48, 12, 48, 0.6 },
	{ 0.09581, 0.52884, 0.04866, 48, 12, 72, 0.6 },
	{ 0.09581, 0.52884, 0.04761, 48, 12, 96, 0.6 },
	{ 0.09581, 0.52884, 0.04694, 48, 12, 120, 0.6 },
	{ 0.09581, 0.52884, 0.04664, 48, 12, 144, 0.6 },
	{ 0.09581, 0.52884, 0.04656, 48, 12, 168, 0.6 },
	{ 0.09581, 0.52884, 0.04656, 48, 12, 180, 0.6 },
	{ 0.09581, 0.51785, 0.05874, 48, 24, 0, 0.6 },
	{ 0.09581, 0.51785, 0.05767, 48, 24, 24, 0.6 },
	{ 0.09581, 0.51785, 0.05503, 48, 24, 48, 0.6 },
	{ 0.09581, 0.51785, 0.05216, 48, 24, 72, 0.6 },
	{ 0.09581, 0.51785, 0.05030, 48, 24, 96, 0.6 },
	{ 0.09581, 0.51785, 0.04986, 48, 24, 120, 0.6 },
	{ 0.09581, 0.51785, 0.05043, 48, 24, 144, 0.6 },
	{ 0.09581, 0.51785, 0.05110, 48, 24, 168, 0.6 },
	{ 0.09581, 0.51785, 0.05120, 48, 24, 180, 0.6 },
	{ 0.09581, 0.49694, 0.07016, 48, 36, 0, 0.6 },
	{ 0.09581, 0.49694, 0.06731, 48, 36, 24, 0.6 },
	{ 0.09581, 0.49694, 0.06262, 48, 36, 48, 0.6 },
	{ 0.09581, 0.49694, 0.05809, 48, 36, 72, 0.6 },
	{ 0.09581, 0.49694, 0.05612, 48, 36, 96, 0.6 },
	{ 0.09581, 0.49694, 0.05733, 48, 36, 120, 0.6 },
	{ 0.09581, 0.49694, 0.06066, 48, 36, 144, 0.6 },
	{ 0.09581, 0.49694, 0.06349, 48, 36, 168, 0.6 },
	{ 0.09581, 0.49694, 0.06391, 48, 36, 180, 0.6 },
	{ 0.09581, 0.46110, 0.08912, 48, 48, 0, 0.6 },
	{ 0.09581, 0.46110, 0.08071, 48, 48, 24, 0.6 },
	{ 0.09581, 0.46110, 0.07371, 48, 48, 48, 0.6 },
	{ 0.09581, 0.46110, 0.06789, 48, 48, 72, 0.6 },
	{ 0.09581, 0.46110, 0.06705, 48, 48, 96, 0.6 },
	{ 0.09581, 0.46110, 0.07245, 48, 48, 120, 0.6 },
	{ 0.09581, 0.46110, 0.08196, 48, 48, 144, 0.6 },
	{ 0.09581, 0.46110, 0.08977, 48, 48, 168, 0.6 },
	{ 0.09581, 0.46110, 0.09097, 48, 48, 180, 0.6 },
	{ 0.09581, 0.40055, 0.10582, 48, 60, 0, 0.6 },
	{ 0.09581, 0.40055, 0.10034, 48, 60, 24, 0.6 },
	{ 0.09581, 0.40055, 0.09119, 48, 60, 48, 0.6 },
	{ 0.09581, 0.40055, 0.08482, 48, 60, 72, 0.6 },
	{ 0.09581, 0.40055, 0.08736, 48, 60, 96, 0.6 },
	{ 0.09581, 0.40055, 0.10150, 48, 60, 120, 0.6 },
	{ 0.09581, 0.40055, 0.12438, 48, 60, 144, 0.6 },
	{ 0.09581, 0.40055, 0.14352, 48, 60, 168, 0.6 },
	{ 0.09581, 0.40055, 0.14644, 48, 60, 180, 0.6 },
	{ 0.09581, 0.35597, 0.11945, 48, 66, 0, 0.6 },
	{ 0.09581, 0.35597, 0.11448, 48, 66, 24, 0.6 },
	{ 0.09581, 0.35597, 0.10417, 48, 66, 48, 0.6 },
	{ 0.09581, 0.35597, 0.09789, 48, 66, 72, 0.6 },
	{ 0.09581, 0.35597, 0.10337, 48, 66, 96, 0.6 },
	{ 0.09581, 0.35597, 0.12488, 48, 66, 120, 0.6 },
	{ 0.09581, 0.35597, 0.15943, 48, 66, 144, 0.6 },
	{ 0.09581, 0.35597, 0.18906, 48, 66, 168, 0.6 },
	{ 0.09581, 0.35597, 0.19376, 48, 66, 180, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 0, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 24, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 48, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 72, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 96, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 120, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 144, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 168, 0.6 },
	{ 0.09581, 0.46238, 0.05701, 60, 0, 180, 0.6 },
	{ 0.09581, 0.45940, 0.06048, 60, 12, 0, 0.6 },
	{ 0.09581, 0.45940, 0.06014, 60, 12, 24, 0.6 },
	{ 0.09581, 0.45940, 0.05940, 60, 12, 48, 0.6 },
	{ 0.09581, 0.45940, 0.05863, 60, 12, 72, 0.6 },
	{ 0.09581, 0.45940, 0.05829, 60, 12, 96, 0.6 },
	{ 0.09581, 0.45940, 0.05852, 60, 12, 120, 0.6 },
	{ 0.09581, 0.45940, 0.05911, 60, 12, 144, 0.6 },
	{ 0.09581, 0.45940, 0.05954, 60, 12, 168, 0.6 },
	{ 0.09581, 0.45940, 0.05960, 60, 12, 180, 0.6 },
	{ 0.09581, 0.44985, 0.06927, 60, 24, 0, 0.6 },
	{ 0.09581, 0.44985, 0.06814, 60, 24, 24, 0.6 },
	{ 0.09581, 0.44985, 0.06546, 60, 24, 48, 0.6 },
	{ 0.09581, 0.44985, 0.06315, 60, 24, 72, 0.6 },
	{ 0.09581, 0.44985, 0.06271, 60, 24, 96, 0.6 },
	{ 0.09581, 0.44985, 0.06458, 60, 24, 120, 0.6 },
	{ 0.09581, 0.44985, 0.06780, 60, 24, 144, 0.6 },
	{ 0.09581, 0.44985, 0.07034, 60, 24, 168, 0.6 },
	{ 0.09581, 0.44985, 0.07071, 60, 24, 180, 0.6 },
	{ 0.09581, 0.43169, 0.08359, 60, 36, 0, 0.6 },
	{ 0.09581, 0.43169, 0.08114, 60, 36, 24, 0.6 },
	{ 0.09581, 0.43169, 0.07558, 60, 36, 48, 0.6 },
	{ 0.09581, 0.43169, 0.07128, 60, 36, 72, 0.6 },
	{ 0.09581, 0.43169, 0.07152, 60, 36, 96, 0.6 },
	{ 0.09581, 0.43169, 0.07740, 60, 36, 120, 0.6 },
	{ 0.09581, 0.43169, 0.08694, 60, 36, 144, 0.6 },
	{ 0.09581, 0.43169, 0.09454, 60, 36, 168, 0.6 },
	{ 0.09581, 0.43169, 0.09569, 60, 36, 180, 0.6 },
	{ 0.09581, 0.40055, 0.10585, 60, 48, 0, 0.6 },
	{ 0.09581, 0.40055, 0.10037, 60, 48, 24, 0.6 },
	{ 0.09581, 0.40055, 0.09121, 60, 48, 48, 0.6 },
	{ 0.09581, 0.40055, 0.08484, 60, 48, 72, 0.6 },
	{ 0.09581, 0.40055, 0.08738, 60, 48, 96, 0.6 },
	{ 0.09581, 0.40055, 0.10152, 60, 48, 120, 0.6 },
	{ 0.09581, 0.40055, 0.12440, 60, 48, 144, 0.6 },
	{ 0.09581, 0.40055, 0.14353, 60, 48, 168, 0.6 },
	{ 0.09581, 0.40055, 0.14645, 60, 48, 180, 0.6 },
	{ 0.09581, 0.34795, 0.14412, 60, 60, 0, 0.6 },
	{ 0.09581, 0.34795, 0.12973, 60, 60, 24, 0.6 },
	{ 0.09581, 0.34795, 0.11611, 60, 60, 48, 0.6 },
	{ 0.09581, 0.34795, 0.10800, 60, 60, 72, 0.6 },
	{ 0.09581, 0.34795, 0.11569, 60, 60, 96, 0.6 },
	{ 0.09581, 0.34795, 0.14591, 60, 60, 120, 0.6 },
	{ 0.09581, 0.34795, 0.19662, 60, 60, 144, 0.6 },
	{ 0.09581, 0.34795, 0.24303, 60, 60, 168, 0.6 },
	{ 0.09581, 0.34795, 0.25045, 60, 60, 180, 0.6 },
	{ 0.09581, 0.30923, 0.16477, 60, 66, 0, 0.6 },
	{ 0.09581, 0.30923, 0.15088, 60, 66, 24, 0.6 },
	{ 0.09581, 0.30923, 0.13456, 60, 66, 48, 0.6 },
	{ 0.09581, 0.30923, 0.12571, 60, 66, 72, 0.6 },
	{ 0.09581, 0.30923, 0.13770, 60, 66, 96, 0.6 },
	{ 0.09581, 0.30923, 0.18087, 60, 66, 120, 0.6 },
	{ 0.09581, 0.30923, 0.25565, 60, 66, 144, 0.6 },
	{ 0.09581, 0.30923, 0.32799, 60, 66, 168, 0.6 },
	{ 0.09581, 0.30923, 0.33992, 60, 66, 180, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 0, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 24, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 48, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 72, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 96, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 120, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 144, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 168, 0.6 },
	{ 0.09581, 0.41091, 0.06559, 66, 0, 180, 0.6 },
	{ 0.09581, 0.40826, 0.06813, 66, 12, 0, 0.6 },
	{ 0.09581, 0.40826, 0.06789, 66, 12, 24, 0.6 },
	{ 0.09581, 0.40826, 0.06734, 66, 12, 48, 0.6 },
	{ 0.09581, 0.40826, 0.06702, 66, 12, 72, 0.6 },
	{ 0.09581, 0.40826, 0.06735, 66, 12, 96, 0.6 },
	{ 0.09581, 0.40826, 0.06840, 66, 12, 120, 0.6 },
	{ 0.09581, 0.40826, 0.06976, 66, 12, 144, 0.6 },
	{ 0.09581, 0.40826, 0.07073, 66, 12, 168, 0.6 },
	{ 0.09581, 0.40826, 0.07087, 66, 12, 180, 0.6 },
	{ 0.09581, 0.39978, 0.07748, 66, 24, 0, 0.6 },
	{ 0.09581, 0.39978, 0.07632, 66, 24, 24, 0.6 },
	{ 0.09581, 0.39978, 0.07387, 66, 24, 48, 0.6 },
	{ 0.09581, 0.39978, 0.07215, 66, 24, 72, 0.6 },
	{ 0.09581, 0.39978, 0.07301, 66, 24, 96, 0.6 },
	{ 0.09581, 0.39978, 0.07697, 66, 24, 120, 0.6 },
	{ 0.09581, 0.39978, 0.08255, 66, 24, 144, 0.6 },
	{ 0.09581, 0.39978, 0.08673, 66, 24, 168, 0.6 },
	{ 0.09581, 0.39978, 0.08733, 66, 24, 180, 0.6 },
	{ 0.09581, 0.38364, 0.09403, 66, 36, 0, 0.6 },
	{ 0.09581, 0.38364, 0.09131, 66, 36, 24, 0.6 },
	{ 0.09581, 0.38364, 0.08553, 66, 36, 48, 0.6 },
	{ 0.09581, 0.38364, 0.08172, 66, 36, 72, 0.6 },
	{ 0.09581, 0.38364, 0.08400, 66, 36, 96, 0.6 },
	{ 0.09581, 0.38364, 0.09397, 66, 36, 120, 0.6 },
	{ 0.09581, 0.38364, 0.10901, 66, 36, 144, 0.6 },
	{ 0.09581, 0.38364, 0.12094, 66, 36, 168, 0.6 },
	{ 0.09581, 0.38364, 0.12269, 66, 36, 180, 0.6 },
	{ 0.09581, 0.35597, 0.11951, 66, 48, 0, 0.6 },
	{ 0.09581, 0.35597, 0.11455, 66, 48, 24, 0.6 },
	{ 0.09581, 0.35597, 0.10425, 66, 48, 48, 0.6 },
	{ 0.09581, 0.35597, 0.09796, 66, 48, 72, 0.6 },
	{ 0.09581, 0.35597, 0.10343, 66, 48, 96, 0.6 },
	{ 0.09581, 0.35597, 0.12492, 66, 48, 120, 0.6 },
	{ 0.09581, 0.35597, 0.15946, 66, 48, 144, 0.6 },
	{ 0.09581, 0.35597, 0.18910, 66, 48, 168, 0.6 },
	{ 0.09581, 0.35597, 0.19380, 66, 48, 180, 0.6 },
	{ 0.09581, 0.30923, 0.16481, 66, 60, 0, 0.6 },
	{ 0.09581, 0.30923, 0.15092, 66, 60, 24, 0.6 },
	{ 0.09581, 0.30923, 0.13460, 66, 60, 48, 0.6 },
	{ 0.09581, 0.30923, 0.12573, 66, 60, 72, 0.6 },
	{ 0.09581, 0.30923, 0.13772, 66, 60, 96, 0.6 },
	{ 0.09581, 0.30923, 0.18089, 66, 60, 120, 0.6 },
	{ 0.09581, 0.30923, 0.25567, 66, 60, 144, 0.6 },
	{ 0.09581, 0.30923, 0.32801, 66, 60, 168, 0.6 },
	{ 0.09581, 0.30923, 0.33995, 66, 60, 180, 0.6 },
	{ 0.09581, 0.27481, 0.19740, 66, 66, 0, 0.6 },
	{ 0.09581, 0.27481, 0.17750, 66, 66, 24, 0.6 },
	{ 0.09581, 0.27481, 0.15738, 66, 66, 48, 0.6 },
	{ 0.09581, 0.27481, 0.14709, 66, 66, 72, 0.6 },
	{ 0.09581, 0.27481, 0.16424, 66, 66, 96, 0.6 },
	{ 0.09581, 0.27481, 0.22449, 66, 66, 120, 0.6 },
	{ 0.09581, 0.27481, 0.33405, 66, 66, 144, 0.6 },
	{ 0.09581, 0.27481, 0.44769, 66, 66, 168, 0.6 },
	{ 0.09581, 0.27481, 0.46772, 66, 66, 180, 0.6 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 0, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 24, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 48, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 72, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 96, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 120, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 144, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 168, 0.7 },
	{ 0.10005, 0.56883, 0.04643, 0, 0, 180, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 0, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 24, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 48, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 72, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 96, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 120, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 144, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 168, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 0, 12, 180, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 0, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 24, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 48, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 72, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 96, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 120, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 144, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 168, 0.7 },
	{ 0.10005, 0.55108, 0.04387, 0, 24, 180, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 0, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 24, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 48, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 72, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 96, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 120, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 144, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 168, 0.7 },
	{ 0.10005, 0.52555, 0.04580, 0, 36, 180, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 0, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 24, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 48, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 72, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 96, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 120, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 144, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 168, 0.7 },
	{ 0.10005, 0.48243, 0.05065, 0, 48, 180, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 0, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 24, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 48, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 72, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 96, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 120, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 144, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 168, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 0, 60, 180, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 0, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 24, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 48, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 72, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 96, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 120, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 144, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 168, 0.7 },
	{ 0.10005, 0.36096, 0.06983, 0, 66, 180, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 0, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 24, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 48, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 72, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 96, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 120, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 144, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 168, 0.7 },
	{ 0.10005, 0.56460, 0.04387, 12, 0, 180, 0.7 },
	{ 0.10005, 0.56039, 0.04835, 12, 12, 0, 0.7 },
	{ 0.10005, 0.56039, 0.04742, 12, 12, 24, 0.7 },
	{ 0.10005, 0.56039, 0.04556, 12, 12, 48, 0.7 },
	{ 0.10005, 0.56039, 0.04416, 12, 12, 72, 0.7 },
	{ 0.10005, 0.56039, 0.04330, 12, 12, 96, 0.7 },
	{ 0.10005, 0.56039, 0.04273, 12, 12, 120, 0.7 },
	{ 0.10005, 0.56039, 0.04229, 12, 12, 144, 0.7 },
	{ 0.10005, 0.56039, 0.04208, 12, 12, 168, 0.7 },
	{ 0.10005, 0.56039, 0.04205, 12, 12, 180, 0.7 },
	{ 0.10005, 0.54698, 0.04769, 12, 24, 0, 0.7 },
	{ 0.10005, 0.54698, 0.04707, 12, 24, 24, 0.7 },
	{ 0.10005, 0.54698, 0.04603, 12, 24, 48, 0.7 },
	{ 0.10005, 0.54698, 0.04498, 12, 24, 72, 0.7 },
	{ 0.10005, 0.54698, 0.04392, 12, 24, 96, 0.7 },
	{ 0.10005, 0.54698, 0.04300, 12, 24, 120, 0.7 },
	{ 0.10005, 0.54698, 0.04235, 12, 24, 144, 0.7 },
	{ 0.10005, 0.54698, 0.04199, 12, 24, 168, 0.7 },
	{ 0.10005, 0.54698, 0.04195, 12, 24, 180, 0.7 },
	{ 0.10005, 0.52164, 0.04994, 12, 36, 0, 0.7 },
	{ 0.10005, 0.52164, 0.04960, 12, 36, 24, 0.7 },
	{ 0.10005, 0.52164, 0.04863, 12, 36, 48, 0.7 },
	{ 0.10005, 0.52164, 0.04734, 12, 36, 72, 0.7 },
	{ 0.10005, 0.52164, 0.04608, 12, 36, 96, 0.7 },
	{ 0.10005, 0.52164, 0.04510, 12, 36, 120, 0.7 },
	{ 0.10005, 0.52164, 0.04445, 12, 36, 144, 0.7 },
	{ 0.10005, 0.52164, 0.04418, 12, 36, 168, 0.7 },
	{ 0.10005, 0.52164, 0.04414, 12, 36, 180, 0.7 },
	{ 0.10005, 0.47883, 0.05492, 12, 48, 0, 0.7 },
	{ 0.10005, 0.47883, 0.05454, 12, 48, 24, 0.7 },
	{ 0.10005, 0.47883, 0.05354, 12, 48, 48, 0.7 },
	{ 0.10005, 0.47883, 0.05233, 12, 48, 72, 0.7 },
	{ 0.10005, 0.47883, 0.05133, 12, 48, 96, 0.7 },
	{ 0.10005, 0.47883, 0.05073, 12, 48, 120, 0.7 },
	{ 0.10005, 0.47883, 0.05050, 12, 48, 144, 0.7 },
	{ 0.10005, 0.47883, 0.05047, 12, 48, 168, 0.7 },
	{ 0.10005, 0.47883, 0.05047, 12, 48, 180, 0.7 },
	{ 0.10005, 0.40843, 0.06442, 12, 60, 0, 0.7 },
	{ 0.10005, 0.40843, 0.06409, 12, 60, 24, 0.7 },
	{ 0.10005, 0.40843, 0.06340, 12, 60, 48, 0.7 },
	{ 0.10005, 0.40843, 0.06273, 12, 60, 72, 0.7 },
	{ 0.10005, 0.40843, 0.06253, 12, 60, 96, 0.7 },
	{ 0.10005, 0.40843, 0.06293, 12, 60, 120, 0.7 },
	{ 0.10005, 0.40843, 0.06367, 12, 60, 144, 0.7 },
	{ 0.10005, 0.40843, 0.06419, 12, 60, 168, 0.7 },
	{ 0.10005, 0.40843, 0.06427, 12, 60, 180, 0.7 },
	{ 0.10005, 0.35827, 0.07209, 12, 66, 0, 0.7 },
	{ 0.10005, 0.35827, 0.07187, 12, 66, 24, 0.7 },
	{ 0.10005, 0.35827, 0.07140, 12, 66, 48, 0.7 },
	{ 0.10005, 0.35827, 0.07122, 12, 66, 72, 0.7 },
	{ 0.10005, 0.35827, 0.07175, 12, 66, 96, 0.7 },
	{ 0.10005, 0.35827, 0.07302, 12, 66, 120, 0.7 },
	{ 0.10005, 0.35827, 0.07459, 12, 66, 144, 0.7 },
	{ 0.10005, 0.35827, 0.07568, 12, 66, 168, 0.7 },
	{ 0.10005, 0.35827, 0.07583, 12, 66, 180, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 0, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 24, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 48, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 72, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 96, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 120, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 144, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 168, 0.7 },
	{ 0.10005, 0.55108, 0.04389, 24, 0, 180, 0.7 },
	{ 0.10005, 0.54698, 0.04771, 24, 12, 0, 0.7 },
	{ 0.10005, 0.54698, 0.04709, 24, 12, 24, 0.7 },
	{ 0.10005, 0.54698, 0.04606, 24, 12, 48, 0.7 },
	{ 0.10005, 0.54698, 0.04501, 24, 12, 72, 0.7 },
	{ 0.10005, 0.54698, 0.04395, 24, 12, 96, 0.7 },
	{ 0.10005, 0.54698, 0.04302, 24, 12, 120, 0.7 },
	{ 0.10005, 0.54698, 0.04238, 24, 12, 144, 0.7 },
	{ 0.10005, 0.54698, 0.04202, 24, 12, 168, 0.7 },
	{ 0.10005, 0.54698, 0.04197, 24, 12, 180, 0.7 },
	{ 0.10005, 0.53388, 0.05479, 24, 24, 0, 0.7 },
	{ 0.10005, 0.53388, 0.05170, 24, 24, 24, 0.7 },
	{ 0.10005, 0.53388, 0.04890, 24, 24, 48, 0.7 },
	{ 0.10005, 0.53388, 0.04689, 24, 24, 72, 0.7 },
	{ 0.10005, 0.53388, 0.04498, 24, 24, 96, 0.7 },
	{ 0.10005, 0.53388, 0.04353, 24, 24, 120, 0.7 },
	{ 0.10005, 0.53388, 0.04265, 24, 24, 144, 0.7 },
	{ 0.10005, 0.53388, 0.04229, 24, 24, 168, 0.7 },
	{ 0.10005, 0.53388, 0.04224, 24, 24, 180, 0.7 },
	{ 0.10005, 0.50915, 0.05671, 24, 36, 0, 0.7 },
	{ 0.10005, 0.50915, 0.05517, 24, 36, 24, 0.7 },
	{ 0.10005, 0.50915, 0.05282, 24, 36, 48, 0.7 },
	{ 0.10005, 0.50915, 0.05011, 24, 36, 72, 0.7 },
	{ 0.10005, 0.50915, 0.04788, 24, 36, 96, 0.7 },
	{ 0.10005, 0.50915, 0.04661, 24, 36, 120, 0.7 },
	{ 0.10005, 0.50915, 0.04614, 24, 36, 144, 0.7 },
	{ 0.10005, 0.50915, 0.04606, 24, 36, 168, 0.7 },
	{ 0.10005, 0.50915, 0.04607, 24, 36, 180, 0.7 },
	{ 0.10005, 0.46737, 0.06270, 24, 48, 0, 0.7 },
	{ 0.10005, 0.46737, 0.06161, 24, 48, 24, 0.7 },
	{ 0.10005, 0.46737, 0.05893, 24, 48, 48, 0.7 },
	{ 0.10005, 0.46737, 0.05609, 24, 48, 72, 0.7 },
	{ 0.10005, 0.46737, 0.05436, 24, 48, 96, 0.7 },
	{ 0.10005, 0.46737, 0.05413, 24, 48, 120, 0.7 },
	{ 0.10005, 0.46737, 0.05493, 24, 48, 144, 0.7 },
	{ 0.10005, 0.46737, 0.05575, 24, 48, 168, 0.7 },
	{ 0.10005, 0.46737, 0.05587, 24, 48, 180, 0.7 },
	{ 0.10005, 0.39865, 0.07344, 24, 60, 0, 0.7 },
	{ 0.10005, 0.39865, 0.07231, 24, 60, 24, 0.7 },
	{ 0.10005, 0.39865, 0.06968, 24, 60, 48, 0.7 },
	{ 0.10005, 0.39865, 0.06752, 24, 60, 72, 0.7 },
	{ 0.10005, 0.39865, 0.06739, 24, 60, 96, 0.7 },
	{ 0.10005, 0.39865, 0.06970, 24, 60, 120, 0.7 },
	{ 0.10005, 0.39865, 0.07337, 24, 60, 144, 0.7 },
	{ 0.10005, 0.39865, 0.07621, 24, 60, 168, 0.7 },
	{ 0.10005, 0.39865, 0.07661, 24, 60, 180, 0.7 },
	{ 0.10005, 0.34969, 0.08159, 24, 66, 0, 0.7 },
	{ 0.10005, 0.34969, 0.08045, 24, 66, 24, 0.7 },
	{ 0.10005, 0.34969, 0.07811, 24, 66, 48, 0.7 },
	{ 0.10005, 0.34969, 0.07662, 24, 66, 72, 0.7 },
	{ 0.10005, 0.34969, 0.07790, 24, 66, 96, 0.7 },
	{ 0.10005, 0.34969, 0.08242, 24, 66, 120, 0.7 },
	{ 0.10005, 0.34969, 0.08857, 24, 66, 144, 0.7 },
	{ 0.10005, 0.34969, 0.09313, 24, 66, 168, 0.7 },
	{ 0.10005, 0.34969, 0.09379, 24, 66, 180, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 0, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 24, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 48, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 72, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 96, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 120, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 144, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 168, 0.7 },
	{ 0.10005, 0.52555, 0.04587, 36, 0, 180, 0.7 },
	{ 0.10005, 0.52164, 0.05003, 36, 12, 0, 0.7 },
	{ 0.10005, 0.52164, 0.04968, 36, 12, 24, 0.7 },
	{ 0.10005, 0.52164, 0.04871, 36, 12, 48, 0.7 },
	{ 0.10005, 0.52164, 0.04743, 36, 12, 72, 0.7 },
	{ 0.10005, 0.52164, 0.04617, 36, 12, 96, 0.7 },
	{ 0.10005, 0.52164, 0.04518, 36, 12, 120, 0.7 },
	{ 0.10005, 0.52164, 0.04454, 36, 12, 144, 0.7 },
	{ 0.10005, 0.52164, 0.04426, 36, 12, 168, 0.7 },
	{ 0.10005, 0.52164, 0.04422, 36, 12, 180, 0.7 },
	{ 0.10005, 0.50915, 0.05677, 36, 24, 0, 0.7 },
	{ 0.10005, 0.50915, 0.05523, 36, 24, 24, 0.7 },
	{ 0.10005, 0.50915, 0.05289, 36, 24, 48, 0.7 },
	{ 0.10005, 0.50915, 0.05017, 36, 24, 72, 0.7 },
	{ 0.10005, 0.50915, 0.04794, 36, 24, 96, 0.7 },
	{ 0.10005, 0.50915, 0.04667, 36, 24, 120, 0.7 },
	{ 0.10005, 0.50915, 0.04619, 36, 24, 144, 0.7 },
	{ 0.10005, 0.50915, 0.04612, 36, 24, 168, 0.7 },
	{ 0.10005, 0.50915, 0.04612, 36, 24, 180, 0.7 },
	{ 0.10005, 0.48557, 0.06817, 36, 36, 0, 0.7 },
	{ 0.10005, 0.48557, 0.06260, 36, 36, 24, 0.7 },
	{ 0.10005, 0.48557, 0.05862, 36, 36, 48, 0.7 },
	{ 0.10005, 0.48557, 0.05472, 36, 36, 72, 0.7 },
	{ 0.10005, 0.48557, 0.05224, 36, 36, 96, 0.7 },
	{ 0.10005, 0.48557, 0.05166, 36, 36, 120, 0.7 },
	{ 0.10005, 0.48557, 0.05239, 36, 36, 144, 0.7 },
	{ 0.10005, 0.48557, 0.05329, 36, 36, 168, 0.7 },
	{ 0.10005, 0.48557, 0.05342, 36, 36, 180, 0.7 },
	{ 0.10005, 0.44572, 0.07472, 36, 48, 0, 0.7 },
	{ 0.10005, 0.44572, 0.07176, 36, 48, 24, 0.7 },
	{ 0.10005, 0.44572, 0.06699, 36, 48, 48, 0.7 },
	{ 0.10005, 0.44572, 0.06249, 36, 48, 72, 0.7 },
	{ 0.10005, 0.44572, 0.06080, 36, 48, 96, 0.7 },
	{ 0.10005, 0.44572, 0.06248, 36, 48, 120, 0.7 },
	{ 0.10005, 0.44572, 0.06634, 36, 48, 144, 0.7 },
	{ 0.10005, 0.44572, 0.06954, 36, 48, 168, 0.7 },
	{ 0.10005, 0.44572, 0.07001, 36, 48, 180, 0.7 },
	{ 0.10005, 0.38019, 0.08831, 36, 60, 0, 0.7 },
	{ 0.10005, 0.38019, 0.08584, 36, 60, 24, 0.7 },
	{ 0.10005, 0.38019, 0.08030, 36, 60, 48, 0.7 },
	{ 0.10005, 0.38019, 0.07620, 36, 60, 72, 0.7 },
	{ 0.10005, 0.38019, 0.07699, 36, 60, 96, 0.7 },
	{ 0.10005, 0.38019, 0.08374, 36, 60, 120, 0.7 },
	{ 0.10005, 0.38019, 0.09426, 36, 60, 144, 0.7 },
	{ 0.10005, 0.38019, 0.10255, 36, 60, 168, 0.7 },
	{ 0.10005, 0.38019, 0.10380, 36, 60, 180, 0.7 },
	{ 0.10005, 0.33349, 0.09864, 36, 66, 0, 0.7 },
	{ 0.10005, 0.33349, 0.09592, 36, 66, 24, 0.7 },
	{ 0.10005, 0.33349, 0.09023, 36, 66, 48, 0.7 },
	{ 0.10005, 0.33349, 0.08675, 36, 66, 72, 0.7 },
	{ 0.10005, 0.33349, 0.08973, 36, 66, 96, 0.7 },
	{ 0.10005, 0.33349, 0.10078, 36, 66, 120, 0.7 },
	{ 0.10005, 0.33349, 0.11707, 36, 66, 144, 0.7 },
	{ 0.10005, 0.33349, 0.12990, 36, 66, 168, 0.7 },
	{ 0.10005, 0.33349, 0.13177, 36, 66, 180, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 0, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 24, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 48, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 72, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 96, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 120, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 144, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 168, 0.7 },
	{ 0.10005, 0.48243, 0.05064, 48, 0, 180, 0.7 },
	{ 0.10005, 0.47883, 0.05492, 48, 12, 0, 0.7 },
	{ 0.10005, 0.47883, 0.05454, 48, 12, 24, 0.7 },
	{ 0.10005, 0.47883, 0.05353, 48, 12, 48, 0.7 },
	{ 0.10005, 0.47883, 0.05233, 48, 12, 72, 0.7 },
	{ 0.10005, 0.47883, 0.05133, 48, 12, 96, 0.7 },
	{ 0.10005, 0.47883, 0.05073, 48, 12, 120, 0.7 },
	{ 0.10005, 0.47883, 0.05050, 48, 12, 144, 0.7 },
	{ 0.10005, 0.47883, 0.05046, 48, 12, 168, 0.7 },
	{ 0.10005, 0.47883, 0.05047, 48, 12, 180, 0.7 },
	{ 0.10005, 0.46737, 0.06265, 48, 24, 0, 0.7 },
	{ 0.10005, 0.46737, 0.06155, 48, 24, 24, 0.7 },
	{ 0.10005, 0.46737, 0.05888, 48, 24, 48, 0.7 },
	{ 0.10005, 0.46737, 0.05603, 48, 24, 72, 0.7 },
	{ 0.10005, 0.46737, 0.05430, 48, 24, 96, 0.7 },
	{ 0.10005, 0.46737, 0.05407, 48, 24, 120, 0.7 },
	{ 0.10005, 0.46737, 0.05487, 48, 24, 144, 0.7 },
	{ 0.10005, 0.46737, 0.05568, 48, 24, 168, 0.7 },
	{ 0.10005, 0.46737, 0.05581, 48, 24, 180, 0.7 },
	{ 0.10005, 0.44572, 0.07454, 48, 36, 0, 0.7 },
	{ 0.10005, 0.44572, 0.07158, 48, 36, 24, 0.7 },
	{ 0.10005, 0.44572, 0.06682, 48, 36, 48, 0.7 },
	{ 0.10005, 0.44572, 0.06233, 48, 36, 72, 0.7 },
	{ 0.10005, 0.44572, 0.06063, 48, 36, 96, 0.7 },
	{ 0.10005, 0.44572, 0.06231, 48, 36, 120, 0.7 },
	{ 0.10005, 0.44572, 0.06617, 48, 36, 144, 0.7 },
	{ 0.10005, 0.44572, 0.06937, 48, 36, 168, 0.7 },
	{ 0.10005, 0.44572, 0.06984, 48, 36, 180, 0.7 },
	{ 0.10005, 0.40915, 0.09427, 48, 48, 0, 0.7 },
	{ 0.10005, 0.40915, 0.08544, 48, 48, 24, 0.7 },
	{ 0.10005, 0.40915, 0.07835, 48, 48, 48, 0.7 },
	{ 0.10005, 0.40915, 0.07267, 48, 48, 72, 0.7 },
	{ 0.10005, 0.40915, 0.07235, 48, 48, 96, 0.7 },
	{ 0.10005, 0.40915, 0.07865, 48, 48, 120, 0.7 },
	{ 0.10005, 0.40915, 0.08921, 48, 48, 144, 0.7 },
	{ 0.10005, 0.40915, 0.09780, 48, 48, 168, 0.7 },
	{ 0.10005, 0.40915, 0.09911, 48, 48, 180, 0.7 },
	{ 0.10005, 0.34899, 0.11099, 48, 60, 0, 0.7 },
	{ 0.10005, 0.34899, 0.10538, 48, 60, 24, 0.7 },
	{ 0.10005, 0.34899, 0.09621, 48, 60, 48, 0.7 },
	{ 0.10005, 0.34899, 0.09018, 48, 60, 72, 0.7 },
	{ 0.10005, 0.34899, 0.09362, 48, 60, 96, 0.7 },
	{ 0.10005, 0.34899, 0.10928, 48, 60, 120, 0.7 },
	{ 0.10005, 0.34899, 0.13408, 48, 60, 144, 0.7 },
	{ 0.10005, 0.34899, 0.15469, 48, 60, 168, 0.7 },
	{ 0.10005, 0.34899, 0.15782, 48, 60, 180, 0.7 },
	{ 0.10005, 0.30613, 0.12443, 48, 66, 0, 0.7 },
	{ 0.10005, 0.30613, 0.11943, 48, 66, 24, 0.7 },
	{ 0.10005, 0.30613, 0.10918, 48, 66, 48, 0.7 },
	{ 0.10005, 0.30613, 0.10338, 48, 66, 72, 0.7 },
	{ 0.10005, 0.30613, 0.10996, 48, 66, 96, 0.7 },
	{ 0.10005, 0.30613, 0.13333, 48, 66, 120, 0.7 },
	{ 0.10005, 0.30613, 0.17028, 48, 66, 144, 0.7 },
	{ 0.10005, 0.30613, 0.20183, 48, 66, 168, 0.7 },
	{ 0.10005, 0.30613, 0.20682, 48, 66, 180, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 0, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 24, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 48, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 72, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 96, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 120, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 144, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 168, 0.7 },
	{ 0.10005, 0.41150, 0.06111, 60, 0, 180, 0.7 },
	{ 0.10005, 0.40843, 0.06443, 60, 12, 0, 0.7 },
	{ 0.10005, 0.40843, 0.06410, 60, 12, 24, 0.7 },
	{ 0.10005, 0.40843, 0.06341, 60, 12, 48, 0.7 },
	{ 0.10005, 0.40843, 0.06274, 60, 12, 72, 0.7 },
	{ 0.10005, 0.40843, 0.06253, 60, 12, 96, 0.7 },
	{ 0.10005, 0.40843, 0.06293, 60, 12, 120, 0.7 },
	{ 0.10005, 0.40843, 0.06367, 60, 12, 144, 0.7 },
	{ 0.10005, 0.40843, 0.06419, 60, 12, 168, 0.7 },
	{ 0.10005, 0.40843, 0.06427, 60, 12, 180, 0.7 },
	{ 0.10005, 0.39865, 0.07339, 60, 24, 0, 0.7 },
	{ 0.10005, 0.39865, 0.07226, 60, 24, 24, 0.7 },
	{ 0.10005, 0.39865, 0.06962, 60, 24, 48, 0.7 },
	{ 0.10005, 0.39865, 0.06746, 60, 24, 72, 0.7 },
	{ 0.10005, 0.39865, 0.06733, 60, 24, 96, 0.7 },
	{ 0.10005, 0.39865, 0.06963, 60, 24, 120, 0.7 },
	{ 0.10005, 0.39865, 0.07330, 60, 24, 144, 0.7 },
	{ 0.10005, 0.39865, 0.07613, 60, 24, 168, 0.7 },
	{ 0.10005, 0.39865, 0.07654, 60, 24, 180, 0.7 },
	{ 0.10005, 0.38019, 0.08813, 60, 36, 0, 0.7 },
	{ 0.10005, 0.38019, 0.08565, 60, 36, 24, 0.7 },
	{ 0.10005, 0.38019, 0.08010, 60, 36, 48, 0.7 },
	{ 0.10005, 0.38019, 0.07601, 60, 36, 72, 0.7 },
	{ 0.10005, 0.38019, 0.07679, 60, 36, 96, 0.7 },
	{ 0.10005, 0.38019, 0.08353, 60, 36, 120, 0.7 },
	{ 0.10005, 0.38019, 0.09405, 60, 36, 144, 0.7 },
	{ 0.10005, 0.38019, 0.10234, 60, 36, 168, 0.7 },
	{ 0.10005, 0.38019, 0.10359, 60, 36, 180, 0.7 },
	{ 0.10005, 0.34899, 0.11101, 60, 48, 0, 0.7 },
	{ 0.10005, 0.34899, 0.10541, 60, 48, 24, 0.7 },
	{ 0.10005, 0.34899, 0.09623, 60, 48, 48, 0.7 },
	{ 0.10005, 0.34899, 0.09020, 60, 48, 72, 0.7 },
	{ 0.10005, 0.34899, 0.09364, 60, 48, 96, 0.7 },
	{ 0.10005, 0.34899, 0.10929, 60, 48, 120, 0.7 },
	{ 0.10005, 0.34899, 0.13409, 60, 48, 144, 0.7 },
	{ 0.10005, 0.34899, 0.15469, 60, 48, 168, 0.7 },
	{ 0.10005, 0.34899, 0.15783, 60, 48, 180, 0.7 },
	{ 0.10005, 0.29768, 0.15000, 60, 60, 0, 0.7 },
	{ 0.10005, 0.29768, 0.13516, 60, 60, 24, 0.7 },
	{ 0.10005, 0.29768, 0.12159, 60, 60, 48, 0.7 },
	{ 0.10005, 0.29768, 0.11404, 60, 60, 72, 0.7 },
	{ 0.10005, 0.29768, 0.12310, 60, 60, 96, 0.7 },
	{ 0.10005, 0.29768, 0.15578, 60, 60, 120, 0.7 },
	{ 0.10005, 0.29768, 0.20988, 60, 60, 144, 0.7 },
	{ 0.10005, 0.29768, 0.25918, 60, 60, 168, 0.7 },
	{ 0.10005, 0.29768, 0.26705, 60, 60, 180, 0.7 },
	{ 0.10005, 0.26112, 0.17038, 60, 66, 0, 0.7 },
	{ 0.10005, 0.26112, 0.15621, 60, 66, 24, 0.7 },
	{ 0.10005, 0.26112, 0.14002, 60, 66, 48, 0.7 },
	{ 0.10005, 0.26112, 0.13187, 60, 66, 72, 0.7 },
	{ 0.10005, 0.26112, 0.14550, 60, 66, 96, 0.7 },
	{ 0.10005, 0.26112, 0.19161, 60, 66, 120, 0.7 },
	{ 0.10005, 0.26112, 0.27063, 60, 66, 144, 0.7 },
	{ 0.10005, 0.26112, 0.34679, 60, 66, 168, 0.7 },
	{ 0.10005, 0.26112, 0.35935, 60, 66, 180, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 0, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 24, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 48, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 72, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 96, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 120, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 144, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 168, 0.7 },
	{ 0.10005, 0.36096, 0.06986, 66, 0, 180, 0.7 },
	{ 0.10005, 0.35827, 0.07214, 66, 12, 0, 0.7 },
	{ 0.10005, 0.35827, 0.07192, 66, 12, 24, 0.7 },
	{ 0.10005, 0.35827, 0.07145, 66, 12, 48, 0.7 },
	{ 0.10005, 0.35827, 0.07126, 66, 12, 72, 0.7 },
	{ 0.10005, 0.35827, 0.07179, 66, 12, 96, 0.7 },
	{ 0.10005, 0.35827, 0.07306, 66, 12, 120, 0.7 },
	{ 0.10005, 0.35827, 0.07463, 66, 12, 144, 0.7 },
	{ 0.10005, 0.35827, 0.07571, 66, 12, 168, 0.7 },
	{ 0.10005, 0.35827, 0.07587, 66, 12, 180, 0.7 },
	{ 0.10005, 0.34969, 0.08158, 66, 24, 0, 0.7 },
	{ 0.10005, 0.34969, 0.08044, 66, 24, 24, 0.7 },
	{ 0.10005, 0.34969, 0.07809, 66, 24, 48, 0.7 },
	{ 0.10005, 0.34969, 0.07660, 66, 24, 72, 0.7 },
	{ 0.10005, 0.34969, 0.07787, 66, 24, 96, 0.7 },
	{ 0.10005, 0.34969, 0.08238, 66, 24, 120, 0.7 },
	{ 0.10005, 0.34969, 0.08853, 66, 24, 144, 0.7 },
	{ 0.10005, 0.34969, 0.09309, 66, 24, 168, 0.7 },
	{ 0.10005, 0.34969, 0.09374, 66, 24, 180, 0.7 },
	{ 0.10005, 0.33349, 0.09849, 66, 36, 0, 0.7 },
	{ 0.10005, 0.33349, 0.09577, 66, 36, 24, 0.7 },
	{ 0.10005, 0.33349, 0.09008, 66, 36, 48, 0.7 },
	{ 0.10005, 0.33349, 0.08660, 66, 36, 72, 0.7 },
	{ 0.10005, 0.33349, 0.08956, 66, 36, 96, 0.7 },
	{ 0.10005, 0.33349, 0.10061, 66, 36, 120, 0.7 },
	{ 0.10005, 0.33349, 0.11689, 66, 36, 144, 0.7 },
	{ 0.10005, 0.33349, 0.12971, 66, 36, 168, 0.7 },
	{ 0.10005, 0.33349, 0.13160, 66, 36, 180, 0.7 },
	{ 0.10005, 0.30613, 0.12452, 66, 48, 0, 0.7 },
	{ 0.10005, 0.30613, 0.11953, 66, 48, 24, 0.7 },
	{ 0.10005, 0.30613, 0.10929, 66, 48, 48, 0.7 },
	{ 0.10005, 0.30613, 0.10348, 66, 48, 72, 0.7 },
	{ 0.10005, 0.30613, 0.11004, 66, 48, 96, 0.7 },
	{ 0.10005, 0.30613, 0.13339, 66, 48, 120, 0.7 },
	{ 0.10005, 0.30613, 0.17034, 66, 48, 144, 0.7 },
	{ 0.10005, 0.30613, 0.20189, 66, 48, 168, 0.7 },
	{ 0.10005, 0.30613, 0.20688, 66, 48, 180, 0.7 },
	{ 0.10005, 0.26112, 0.17047, 66, 60, 0, 0.7 },
	{ 0.10005, 0.26112, 0.15629, 66, 60, 24, 0.7 },
	{ 0.10005, 0.26112, 0.14009, 66, 60, 48, 0.7 },
	{ 0.10005, 0.26112, 0.13193, 66, 60, 72, 0.7 },
	{ 0.10005, 0.26112, 0.14556, 66, 60, 96, 0.7 },
	{ 0.10005, 0.26112, 0.19167, 66, 60, 120, 0.7 },
	{ 0.10005, 0.26112, 0.27068, 66, 60, 144, 0.7 },
	{ 0.10005, 0.26112, 0.34685, 66, 60, 168, 0.7 },
	{ 0.10005, 0.26112, 0.35941, 66, 60, 180, 0.7 },
	{ 0.10005, 0.22905, 0.20301, 66, 66, 0, 0.7 },
	{ 0.10005, 0.22905, 0.18274, 66, 66, 24, 0.7 },
	{ 0.10005, 0.22905, 0.16282, 66, 66, 48, 0.7 },
	{ 0.10005, 0.22905, 0.15340, 66, 66, 72, 0.7 },
	{ 0.10005, 0.22905, 0.17246, 66, 66, 96, 0.7 },
	{ 0.10005, 0.22905, 0.23619, 66, 66, 120, 0.7 },
	{ 0.10005, 0.22905, 0.35106, 66, 66, 144, 0.7 },
	{ 0.10005, 0.22905, 0.46984, 66, 66, 168, 0.7 },
	{ 0.10005, 0.22905, 0.49074, 66, 66, 180, 0.7 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 0, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 24, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 48, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 72, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 96, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 120, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 144, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 168, 0.8 },
	{ 0.10372, 0.52605, 0.04958, 0, 0, 180, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 0, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 24, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 48, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 72, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 96, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 120, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 144, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 168, 0.8 },
	{ 0.10372, 0.52161, 0.04685, 0, 12, 180, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 0, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 24, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 48, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 72, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 96, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 120, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 144, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 168, 0.8 },
	{ 0.10372, 0.50748, 0.04687, 0, 24, 180, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 0, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 24, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 48, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 72, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 96, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 120, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 144, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 168, 0.8 },
	{ 0.10372, 0.48102, 0.04896, 0, 36, 180, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 0, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 24, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 48, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 72, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 96, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 120, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 144, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 168, 0.8 },
	{ 0.10372, 0.43694, 0.05411, 0, 48, 180, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 0, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 24, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 48, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 72, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 96, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 120, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 144, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 168, 0.8 },
	{ 0.10372, 0.36632, 0.06492, 0, 60, 180, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 0, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 24, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 48, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 72, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 96, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 120, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 144, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 168, 0.8 },
	{ 0.10372, 0.31759, 0.07368, 0, 66, 180, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 0, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 24, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 48, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 72, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 96, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 120, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 144, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 168, 0.8 },
	{ 0.10372, 0.52161, 0.04684, 12, 0, 180, 0.8 },
	{ 0.10372, 0.51721, 0.05159, 12, 12, 0, 0.8 },
	{ 0.10372, 0.51721, 0.05060, 12, 12, 24, 0.8 },
	{ 0.10372, 0.51721, 0.04862, 12, 12, 48, 0.8 },
	{ 0.10372, 0.51721, 0.04714, 12, 12, 72, 0.8 },
	{ 0.10372, 0.51721, 0.04625, 12, 12, 96, 0.8 },
	{ 0.10372, 0.51721, 0.04566, 12, 12, 120, 0.8 },
	{ 0.10372, 0.51721, 0.04520, 12, 12, 144, 0.8 },
	{ 0.10372, 0.51721, 0.04499, 12, 12, 168, 0.8 },
	{ 0.10372, 0.51721, 0.04496, 12, 12, 180, 0.8 },
	{ 0.10372, 0.50320, 0.05084, 12, 24, 0, 0.8 },
	{ 0.10372, 0.50320, 0.05019, 12, 24, 24, 0.8 },
	{ 0.10372, 0.50320, 0.04911, 12, 24, 48, 0.8 },
	{ 0.10372, 0.50320, 0.04803, 12, 24, 72, 0.8 },
	{ 0.10372, 0.50320, 0.04694, 12, 24, 96, 0.8 },
	{ 0.10372, 0.50320, 0.04600, 12, 24, 120, 0.8 },
	{ 0.10372, 0.50320, 0.04535, 12, 24, 144, 0.8 },
	{ 0.10372, 0.50320, 0.04499, 12, 24, 168, 0.8 },
	{ 0.10372, 0.50320, 0.04494, 12, 24, 180, 0.8 },
	{ 0.10372, 0.47695, 0.05320, 12, 36, 0, 0.8 },
	{ 0.10372, 0.47695, 0.05285, 12, 36, 24, 0.8 },
	{ 0.10372, 0.47695, 0.05186, 12, 36, 48, 0.8 },
	{ 0.10372, 0.47695, 0.05056, 12, 36, 72, 0.8 },
	{ 0.10372, 0.47695, 0.04929, 12, 36, 96, 0.8 },
	{ 0.10372, 0.47695, 0.04831, 12, 36, 120, 0.8 },
	{ 0.10372, 0.47695, 0.04768, 12, 36, 144, 0.8 },
	{ 0.10372, 0.47695, 0.04742, 12, 36, 168, 0.8 },
	{ 0.10372, 0.47695, 0.04738, 12, 36, 180, 0.8 },
	{ 0.10372, 0.43325, 0.05839, 12, 48, 0, 0.8 },
	{ 0.10372, 0.43325, 0.05801, 12, 48, 24, 0.8 },
	{ 0.10372, 0.43325, 0.05700, 12, 48, 48, 0.8 },
	{ 0.10372, 0.43325, 0.05582, 12, 48, 72, 0.8 },
	{ 0.10372, 0.43325, 0.05486, 12, 48, 96, 0.8 },
	{ 0.10372, 0.43325, 0.05433, 12, 48, 120, 0.8 },
	{ 0.10372, 0.43325, 0.05416, 12, 48, 144, 0.8 },
	{ 0.10372, 0.43325, 0.05416, 12, 48, 168, 0.8 },
	{ 0.10372, 0.43325, 0.05417, 12, 48, 180, 0.8 },
	{ 0.10372, 0.36323, 0.06808, 12, 60, 0, 0.8 },
	{ 0.10372, 0.36323, 0.06776, 12, 60, 24, 0.8 },
	{ 0.10372, 0.36323, 0.06711, 12, 60, 48, 0.8 },
	{ 0.10372, 0.36323, 0.06652, 12, 60, 72, 0.8 },
	{ 0.10372, 0.36323, 0.06644, 12, 60, 96, 0.8 },
	{ 0.10372, 0.36323, 0.06698, 12, 60, 120, 0.8 },
	{ 0.10372, 0.36323, 0.06785, 12, 60, 144, 0.8 },
	{ 0.10372, 0.36323, 0.06845, 12, 60, 168, 0.8 },
	{ 0.10372, 0.36323, 0.06854, 12, 60, 180, 0.8 },
	{ 0.10372, 0.31491, 0.07571, 12, 66, 0, 0.8 },
	{ 0.10372, 0.31491, 0.07552, 12, 66, 24, 0.8 },
	{ 0.10372, 0.31491, 0.07511, 12, 66, 48, 0.8 },
	{ 0.10372, 0.31491, 0.07504, 12, 66, 72, 0.8 },
	{ 0.10372, 0.31491, 0.07572, 12, 66, 96, 0.8 },
	{ 0.10372, 0.31491, 0.07717, 12, 66, 120, 0.8 },
	{ 0.10372, 0.31491, 0.07891, 12, 66, 144, 0.8 },
	{ 0.10372, 0.31491, 0.08010, 12, 66, 168, 0.8 },
	{ 0.10372, 0.31491, 0.08027, 12, 66, 180, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 0, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 24, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 48, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 72, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 96, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 120, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 144, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 168, 0.8 },
	{ 0.10372, 0.50748, 0.04688, 24, 0, 180, 0.8 },
	{ 0.10372, 0.50320, 0.05085, 24, 12, 0, 0.8 },
	{ 0.10372, 0.50320, 0.05020, 24, 12, 24, 0.8 },
	{ 0.10372, 0.50320, 0.04912, 24, 12, 48, 0.8 },
	{ 0.10372, 0.50320, 0.04804, 24, 12, 72, 0.8 },
	{ 0.10372, 0.50320, 0.04696, 24, 12, 96, 0.8 },
	{ 0.10372, 0.50320, 0.04602, 24, 12, 120, 0.8 },
	{ 0.10372, 0.50320, 0.04536, 24, 12, 144, 0.8 },
	{ 0.10372, 0.50320, 0.04500, 24, 12, 168, 0.8 },
	{ 0.10372, 0.50320, 0.04496, 24, 12, 180, 0.8 },
	{ 0.10372, 0.48957, 0.05830, 24, 24, 0, 0.8 },
	{ 0.10372, 0.48957, 0.05502, 24, 24, 24, 0.8 },
	{ 0.10372, 0.48957, 0.05209, 24, 24, 48, 0.8 },
	{ 0.10372, 0.48957, 0.05004, 24, 24, 72, 0.8 },
	{ 0.10372, 0.48957, 0.04810, 24, 24, 96, 0.8 },
	{ 0.10372, 0.48957, 0.04665, 24, 24, 120, 0.8 },
	{ 0.10372, 0.48957, 0.04579, 24, 24, 144, 0.8 },
	{ 0.10372, 0.48957, 0.04544, 24, 24, 168, 0.8 },
	{ 0.10372, 0.48957, 0.04539, 24, 24, 180, 0.8 },
	{ 0.10372, 0.46404, 0.06022, 24, 36, 0, 0.8 },
	{ 0.10372, 0.46404, 0.05861, 24, 36, 24, 0.8 },
	{ 0.10372, 0.46404, 0.05621, 24, 36, 48, 0.8 },
	{ 0.10372, 0.46404, 0.05346, 24, 36, 72, 0.8 },
	{ 0.10372, 0.46404, 0.05124, 24, 36, 96, 0.8 },
	{ 0.10372, 0.46404, 0.05003, 24, 36, 120, 0.8 },
	{ 0.10372, 0.46404, 0.04964, 24, 36, 144, 0.8 },
	{ 0.10372, 0.46404, 0.04962, 24, 36, 168, 0.8 },
	{ 0.10372, 0.46404, 0.04963, 24, 36, 180, 0.8 },
	{ 0.10372, 0.42152, 0.06637, 24, 48, 0, 0.8 },
	{ 0.10372, 0.42152, 0.06525, 24, 48, 24, 0.8 },
	{ 0.10372, 0.42152, 0.06255, 24, 48, 48, 0.8 },
	{ 0.10372, 0.42152, 0.05973, 24, 48, 72, 0.8 },
	{ 0.10372, 0.42152, 0.05811, 24, 48, 96, 0.8 },
	{ 0.10372, 0.42152, 0.05806, 24, 48, 120, 0.8 },
	{ 0.10372, 0.42152, 0.05906, 24, 48, 144, 0.8 },
	{ 0.10372, 0.42152, 0.06001, 24, 48, 168, 0.8 },
	{ 0.10372, 0.42152, 0.06015, 24, 48, 180, 0.8 },
	{ 0.10372, 0.35339, 0.07721, 24, 60, 0, 0.8 },
	{ 0.10372, 0.35339, 0.07609, 24, 60, 24, 0.8 },
	{ 0.10372, 0.35339, 0.07349, 24, 60, 48, 0.8 },
	{ 0.10372, 0.35339, 0.07146, 24, 60, 72, 0.8 },
	{ 0.10372, 0.35339, 0.07158, 24, 60, 96, 0.8 },
	{ 0.10372, 0.35339, 0.07426, 24, 60, 120, 0.8 },
	{ 0.10372, 0.35339, 0.07830, 24, 60, 144, 0.8 },
	{ 0.10372, 0.35339, 0.08139, 24, 60, 168, 0.8 },
	{ 0.10372, 0.35339, 0.08182, 24, 60, 180, 0.8 },
	{ 0.10372, 0.30638, 0.08525, 24, 66, 0, 0.8 },
	{ 0.10372, 0.30638, 0.08413, 24, 66, 24, 0.8 },
	{ 0.10372, 0.30638, 0.08186, 24, 66, 48, 0.8 },
	{ 0.10372, 0.30638, 0.08057, 24, 66, 72, 0.8 },
	{ 0.10372, 0.30638, 0.08218, 24, 66, 96, 0.8 },
	{ 0.10372, 0.30638, 0.08715, 24, 66, 120, 0.8 },
	{ 0.10372, 0.30638, 0.09376, 24, 66, 144, 0.8 },
	{ 0.10372, 0.30638, 0.09863, 24, 66, 168, 0.8 },
	{ 0.10372, 0.30638, 0.09933, 24, 66, 180, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 0, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 24, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 48, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 72, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 96, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 120, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 144, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 168, 0.8 },
	{ 0.10372, 0.48102, 0.04895, 36, 0, 180, 0.8 },
	{ 0.10372, 0.47695, 0.05320, 36, 12, 0, 0.8 },
	{ 0.10372, 0.47695, 0.05285, 36, 12, 24, 0.8 },
	{ 0.10372, 0.47695, 0.05186, 36, 12, 48, 0.8 },
	{ 0.10372, 0.47695, 0.05055, 36, 12, 72, 0.8 },
	{ 0.10372, 0.47695, 0.04929, 36, 12, 96, 0.8 },
	{ 0.10372, 0.47695, 0.04830, 36, 12, 120, 0.8 },
	{ 0.10372, 0.47695, 0.04768, 36, 12, 144, 0.8 },
	{ 0.10372, 0.47695, 0.04741, 36, 12, 168, 0.8 },
	{ 0.10372, 0.47695, 0.04737, 36, 12, 180, 0.8 },
	{ 0.10372, 0.46404, 0.06019, 36, 24, 0, 0.8 },
	{ 0.10372, 0.46404, 0.05859, 36, 24, 24, 0.8 },
	{ 0.10372, 0.46404, 0.05619, 36, 24, 48, 0.8 },
	{ 0.10372, 0.46404, 0.05343, 36, 24, 72, 0.8 },
	{ 0.10372, 0.46404, 0.05121, 36, 24, 96, 0.8 },
	{ 0.10372, 0.46404, 0.05001, 36, 24, 120, 0.8 },
	{ 0.10372, 0.46404, 0.04961, 36, 24, 144, 0.8 },
	{ 0.10372, 0.46404, 0.04959, 36, 24, 168, 0.8 },
	{ 0.10372, 0.46404, 0.04961, 36, 24, 180, 0.8 },
	{ 0.10372, 0.43983, 0.07207, 36, 36, 0, 0.8 },
	{ 0.10372, 0.43983, 0.06622, 36, 36, 24, 0.8 },
	{ 0.10372, 0.43983, 0.06214, 36, 36, 48, 0.8 },
	{ 0.10372, 0.43983, 0.05821, 36, 36, 72, 0.8 },
	{ 0.10372, 0.43983, 0.05581, 36, 36, 96, 0.8 },
	{ 0.10372, 0.43983, 0.05542, 36, 36, 120, 0.8 },
	{ 0.10372, 0.43983, 0.05638, 36, 36, 144, 0.8 },
	{ 0.10372, 0.43983, 0.05742, 36, 36, 168, 0.8 },
	{ 0.10372, 0.43983, 0.05758, 36, 36, 180, 0.8 },
	{ 0.10372, 0.39953, 0.07864, 36, 48, 0, 0.8 },
	{ 0.10372, 0.39953, 0.07559, 36, 48, 24, 0.8 },
	{ 0.10372, 0.39953, 0.07076, 36, 48, 48, 0.8 },
	{ 0.10372, 0.39953, 0.06631, 36, 48, 72, 0.8 },
	{ 0.10372, 0.39953, 0.06485, 36, 48, 96, 0.8 },
	{ 0.10372, 0.39953, 0.06693, 36, 48, 120, 0.8 },
	{ 0.10372, 0.39953, 0.07125, 36, 48, 144, 0.8 },
	{ 0.10372, 0.39953, 0.07477, 36, 48, 168, 0.8 },
	{ 0.10372, 0.39953, 0.07528, 36, 48, 180, 0.8 },
	{ 0.10372, 0.33496, 0.09226, 36, 60, 0, 0.8 },
	{ 0.10372, 0.33496, 0.08977, 36, 60, 24, 0.8 },
	{ 0.10372, 0.33496, 0.08423, 36, 60, 48, 0.8 },
	{ 0.10372, 0.33496, 0.08032, 36, 60, 72, 0.8 },
	{ 0.10372, 0.33496, 0.08156, 36, 60, 96, 0.8 },
	{ 0.10372, 0.33496, 0.08902, 36, 60, 120, 0.8 },
	{ 0.10372, 0.33496, 0.10035, 36, 60, 144, 0.8 },
	{ 0.10372, 0.33496, 0.10922, 36, 60, 168, 0.8 },
	{ 0.10372, 0.33496, 0.11055, 36, 60, 180, 0.8 },
	{ 0.10372, 0.29040, 0.10242, 36, 66, 0, 0.8 },
	{ 0.10372, 0.29040, 0.09970, 36, 66, 24, 0.8 },
	{ 0.10372, 0.29040, 0.09407, 36, 66, 48, 0.8 },
	{ 0.10372, 0.29040, 0.09086, 36, 66, 72, 0.8 },
	{ 0.10372, 0.29040, 0.09440, 36, 66, 96, 0.8 },
	{ 0.10372, 0.29040, 0.10632, 36, 66, 120, 0.8 },
	{ 0.10372, 0.29040, 0.12360, 36, 66, 144, 0.8 },
	{ 0.10372, 0.29040, 0.13714, 36, 66, 168, 0.8 },
	{ 0.10372, 0.29040, 0.13911, 36, 66, 180, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 0, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 24, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 48, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 72, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 96, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 120, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 144, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 168, 0.8 },
	{ 0.10372, 0.43694, 0.05409, 48, 0, 180, 0.8 },
	{ 0.10372, 0.43325, 0.05839, 48, 12, 0, 0.8 },
	{ 0.10372, 0.43325, 0.05801, 48, 12, 24, 0.8 },
	{ 0.10372, 0.43325, 0.05700, 48, 12, 48, 0.8 },
	{ 0.10372, 0.43325, 0.05582, 48, 12, 72, 0.8 },
	{ 0.10372, 0.43325, 0.05486, 48, 12, 96, 0.8 },
	{ 0.10372, 0.43325, 0.05432, 48, 12, 120, 0.8 },
	{ 0.10372, 0.43325, 0.05415, 48, 12, 144, 0.8 },
	{ 0.10372, 0.43325, 0.05416, 48, 12, 168, 0.8 },
	{ 0.10372, 0.43325, 0.05417, 48, 12, 180, 0.8 },
	{ 0.10372, 0.42152, 0.06635, 48, 24, 0, 0.8 },
	{ 0.10372, 0.42152, 0.06523, 48, 24, 24, 0.8 },
	{ 0.10372, 0.42152, 0.06253, 48, 24, 48, 0.8 },
	{ 0.10372, 0.42152, 0.05970, 48, 24, 72, 0.8 },
	{ 0.10372, 0.42152, 0.05808, 48, 24, 96, 0.8 },
	{ 0.10372, 0.42152, 0.05803, 48, 24, 120, 0.8 },
	{ 0.10372, 0.42152, 0.05903, 48, 24, 144, 0.8 },
	{ 0.10372, 0.42152, 0.05998, 48, 24, 168, 0.8 },
	{ 0.10372, 0.42152, 0.06012, 48, 24, 180, 0.8 },
	{ 0.10372, 0.39953, 0.07865, 48, 36, 0, 0.8 },
	{ 0.10372, 0.39953, 0.07559, 48, 36, 24, 0.8 },
	{ 0.10372, 0.39953, 0.07077, 48, 36, 48, 0.8 },
	{ 0.10372, 0.39953, 0.06632, 48, 36, 72, 0.8 },
	{ 0.10372, 0.39953, 0.06485, 48, 36, 96, 0.8 },
	{ 0.10372, 0.39953, 0.06694, 48, 36, 120, 0.8 },
	{ 0.10372, 0.39953, 0.07125, 48, 36, 144, 0.8 },
	{ 0.10372, 0.39953, 0.07477, 48, 36, 168, 0.8 },
	{ 0.10372, 0.39953, 0.07528, 48, 36, 180, 0.8 },
	{ 0.10372, 0.36292, 0.09899, 48, 48, 0, 0.8 },
	{ 0.10372, 0.36292, 0.08982, 48, 48, 24, 0.8 },
	{ 0.10372, 0.36292, 0.08267, 48, 48, 48, 0.8 },
	{ 0.10372, 0.36292, 0.07710, 48, 48, 72, 0.8 },
	{ 0.10372, 0.36292, 0.07723, 48, 48, 96, 0.8 },
	{ 0.10372, 0.36292, 0.08428, 48, 48, 120, 0.8 },
	{ 0.10372, 0.36292, 0.09574, 48, 48, 144, 0.8 },
	{ 0.10372, 0.36292, 0.10498, 48, 48, 168, 0.8 },
	{ 0.10372, 0.36292, 0.10638, 48, 48, 180, 0.8 },
	{ 0.10372, 0.30427, 0.11566, 48, 60, 0, 0.8 },
	{ 0.10372, 0.30427, 0.10996, 48, 60, 24, 0.8 },
	{ 0.10372, 0.30427, 0.10078, 48, 60, 48, 0.8 },
	{ 0.10372, 0.30427, 0.09503, 48, 60, 72, 0.8 },
	{ 0.10372, 0.30427, 0.09920, 48, 60, 96, 0.8 },
	{ 0.10372, 0.30427, 0.11610, 48, 60, 120, 0.8 },
	{ 0.10372, 0.30427, 0.14245, 48, 60, 144, 0.8 },
	{ 0.10372, 0.30427, 0.16424, 48, 60, 168, 0.8 },
	{ 0.10372, 0.30427, 0.16755, 48, 60, 180, 0.8 },
	{ 0.10372, 0.26379, 0.12887, 48, 66, 0, 0.8 },
	{ 0.10372, 0.26379, 0.12385, 48, 66, 24, 0.8 },
	{ 0.10372, 0.26379, 0.11365, 48, 66, 48, 0.8 },
	{ 0.10372, 0.26379, 0.10822, 48, 66, 72, 0.8 },
	{ 0.10372, 0.26379, 0.11569, 48, 66, 96, 0.8 },
	{ 0.10372, 0.26379, 0.14052, 48, 66, 120, 0.8 },
	{ 0.10372, 0.26379, 0.17936, 48, 66, 144, 0.8 },
	{ 0.10372, 0.26379, 0.21239, 48, 66, 168, 0.8 },
	{ 0.10372, 0.26379, 0.21761, 48, 66, 180, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 0, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 24, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 48, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 72, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 96, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 120, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 144, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 168, 0.8 },
	{ 0.10372, 0.36632, 0.06491, 60, 0, 180, 0.8 },
	{ 0.10372, 0.36323, 0.06810, 60, 12, 0, 0.8 },
	{ 0.10372, 0.36323, 0.06778, 60, 12, 24, 0.8 },
	{ 0.10372, 0.36323, 0.06713, 60, 12, 48, 0.8 },
	{ 0.10372, 0.36323, 0.06654, 60, 12, 72, 0.8 },
	{ 0.10372, 0.36323, 0.06645, 60, 12, 96, 0.8 },
	{ 0.10372, 0.36323, 0.06699, 60, 12, 120, 0.8 },
	{ 0.10372, 0.36323, 0.06786, 60, 12, 144, 0.8 },
	{ 0.10372, 0.36323, 0.06846, 60, 12, 168, 0.8 },
	{ 0.10372, 0.36323, 0.06854, 60, 12, 180, 0.8 },
	{ 0.10372, 0.35339, 0.07721, 60, 24, 0, 0.8 },
	{ 0.10372, 0.35339, 0.07608, 60, 24, 24, 0.8 },
	{ 0.10372, 0.35339, 0.07348, 60, 24, 48, 0.8 },
	{ 0.10372, 0.35339, 0.07145, 60, 24, 72, 0.8 },
	{ 0.10372, 0.35339, 0.07157, 60, 24, 96, 0.8 },
	{ 0.10372, 0.35339, 0.07423, 60, 24, 120, 0.8 },
	{ 0.10372, 0.35339, 0.07828, 60, 24, 144, 0.8 },
	{ 0.10372, 0.35339, 0.08136, 60, 24, 168, 0.8 },
	{ 0.10372, 0.35339, 0.08179, 60, 24, 180, 0.8 },
	{ 0.10372, 0.33496, 0.09231, 60, 36, 0, 0.8 },
	{ 0.10372, 0.33496, 0.08981, 60, 36, 24, 0.8 },
	{ 0.10372, 0.33496, 0.08427, 60, 36, 48, 0.8 },
	{ 0.10372, 0.33496, 0.08036, 60, 36, 72, 0.8 },
	{ 0.10372, 0.33496, 0.08159, 60, 36, 96, 0.8 },
	{ 0.10372, 0.33496, 0.08904, 60, 36, 120, 0.8 },
	{ 0.10372, 0.33496, 0.10037, 60, 36, 144, 0.8 },
	{ 0.10372, 0.33496, 0.10923, 60, 36, 168, 0.8 },
	{ 0.10372, 0.33496, 0.11056, 60, 36, 180, 0.8 },
	{ 0.10372, 0.30427, 0.11570, 60, 48, 0, 0.8 },
	{ 0.10372, 0.30427, 0.10999, 60, 48, 24, 0.8 },
	{ 0.10372, 0.30427, 0.10081, 60, 48, 48, 0.8 },
	{ 0.10372, 0.30427, 0.09505, 60, 48, 72, 0.8 },
	{ 0.10372, 0.30427, 0.09923, 60, 48, 96, 0.8 },
	{ 0.10372, 0.30427, 0.11612, 60, 48, 120, 0.8 },
	{ 0.10372, 0.30427, 0.14247, 60, 48, 144, 0.8 },
	{ 0.10372, 0.30427, 0.16425, 60, 48, 168, 0.8 },
	{ 0.10372, 0.30427, 0.16756, 60, 48, 180, 0.8 },
	{ 0.10372, 0.25509, 0.15517, 60, 60, 0, 0.8 },
	{ 0.10372, 0.25509, 0.14001, 60, 60, 24, 0.8 },
	{ 0.10372, 0.25509, 0.12647, 60, 60, 48, 0.8 },
	{ 0.10372, 0.25509, 0.11936, 60, 60, 72, 0.8 },
	{ 0.10372, 0.25509, 0.12952, 60, 60, 96, 0.8 },
	{ 0.10372, 0.25509, 0.16414, 60, 60, 120, 0.8 },
	{ 0.10372, 0.25509, 0.22087, 60, 60, 144, 0.8 },
	{ 0.10372, 0.25509, 0.27238, 60, 60, 168, 0.8 },
	{ 0.10372, 0.25509, 0.28059, 60, 60, 180, 0.8 },
	{ 0.10372, 0.22116, 0.17527, 60, 66, 0, 0.8 },
	{ 0.10372, 0.22116, 0.16090, 60, 66, 24, 0.8 },
	{ 0.10372, 0.22116, 0.14480, 60, 66, 48, 0.8 },
	{ 0.10372, 0.22116, 0.13719, 60, 66, 72, 0.8 },
	{ 0.10372, 0.22116, 0.15208, 60, 66, 96, 0.8 },
	{ 0.10372, 0.22116, 0.20043, 60, 66, 120, 0.8 },
	{ 0.10372, 0.22116, 0.28264, 60, 66, 144, 0.8 },
	{ 0.10372, 0.22116, 0.36163, 60, 66, 168, 0.8 },
	{ 0.10372, 0.22116, 0.37464, 60, 66, 180, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 0, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 24, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 48, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 72, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 96, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 120, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 144, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 168, 0.8 },
	{ 0.10372, 0.31759, 0.07370, 66, 0, 180, 0.8 },
	{ 0.10372, 0.31491, 0.07576, 66, 12, 0, 0.8 },
	{ 0.10372, 0.31491, 0.07557, 66, 12, 24, 0.8 },
	{ 0.10372, 0.31491, 0.07516, 66, 12, 48, 0.8 },
	{ 0.10372, 0.31491, 0.07508, 66, 12, 72, 0.8 },
	{ 0.10372, 0.31491, 0.07576, 66, 12, 96, 0.8 },
	{ 0.10372, 0.31491, 0.07721, 66, 12, 120, 0.8 },
	{ 0.10372, 0.31491, 0.07895, 66, 12, 144, 0.8 },
	{ 0.10372, 0.31491, 0.08013, 66, 12, 168, 0.8 },
	{ 0.10372, 0.31491, 0.08030, 66, 12, 180, 0.8 },
	{ 0.10372, 0.30638, 0.08529, 66, 24, 0, 0.8 },
	{ 0.10372, 0.30638, 0.08416, 66, 24, 24, 0.8 },
	{ 0.10372, 0.30638, 0.08189, 66, 24, 48, 0.8 },
	{ 0.10372, 0.30638, 0.08059, 66, 24, 72, 0.8 },
	{ 0.10372, 0.30638, 0.08219, 66, 24, 96, 0.8 },
	{ 0.10372, 0.30638, 0.08715, 66, 24, 120, 0.8 },
	{ 0.10372, 0.30638, 0.09376, 66, 24, 144, 0.8 },
	{ 0.10372, 0.30638, 0.09863, 66, 24, 168, 0.8 },
	{ 0.10372, 0.30638, 0.09932, 66, 24, 180, 0.8 },
	{ 0.10372, 0.29040, 0.10252, 66, 36, 0, 0.8 },
	{ 0.10372, 0.29040, 0.09979, 66, 36, 24, 0.8 },
	{ 0.10372, 0.29040, 0.09416, 66, 36, 48, 0.8 },
	{ 0.10372, 0.29040, 0.09094, 66, 36, 72, 0.8 },
	{ 0.10372, 0.29040, 0.09447, 66, 36, 96, 0.8 },
	{ 0.10372, 0.29040, 0.10637, 66, 36, 120, 0.8 },
	{ 0.10372, 0.29040, 0.12365, 66, 36, 144, 0.8 },
	{ 0.10372, 0.29040, 0.13718, 66, 36, 168, 0.8 },
	{ 0.10372, 0.29040, 0.13917, 66, 36, 180, 0.8 },
	{ 0.10372, 0.26379, 0.12898, 66, 48, 0, 0.8 },
	{ 0.10372, 0.26379, 0.12396, 66, 48, 24, 0.8 },
	{ 0.10372, 0.26379, 0.11377, 66, 48, 48, 0.8 },
	{ 0.10372, 0.26379, 0.10833, 66, 48, 72, 0.8 },
	{ 0.10372, 0.26379, 0.11577, 66, 48, 96, 0.8 },
	{ 0.10372, 0.26379, 0.14058, 66, 48, 120, 0.8 },
	{ 0.10372, 0.26379, 0.17941, 66, 48, 144, 0.8 },
	{ 0.10372, 0.26379, 0.21245, 66, 48, 168, 0.8 },
	{ 0.10372, 0.26379, 0.21766, 66, 48, 180, 0.8 },
	{ 0.10372, 0.22116, 0.17534, 66, 60, 0, 0.8 },
	{ 0.10372, 0.22116, 0.16097, 66, 60, 24, 0.8 },
	{ 0.10372, 0.22116, 0.14486, 66, 60, 48, 0.8 },
	{ 0.10372, 0.22116, 0.13724, 66, 60, 72, 0.8 },
	{ 0.10372, 0.22116, 0.15213, 66, 60, 96, 0.8 },
	{ 0.10372, 0.22116, 0.20048, 66, 60, 120, 0.8 },
	{ 0.10372, 0.22116, 0.28268, 66, 60, 144, 0.8 },
	{ 0.10372, 0.22116, 0.36168, 66, 60, 168, 0.8 },
	{ 0.10372, 0.22116, 0.37469, 66, 60, 180, 0.8 },
	{ 0.10372, 0.19173, 0.20777, 66, 66, 0, 0.8 },
	{ 0.10372, 0.19173, 0.18724, 66, 66, 24, 0.8 },
	{ 0.10372, 0.19173, 0.16748, 66, 66, 48, 0.8 },
	{ 0.10372, 0.19173, 0.15871, 66, 66, 72, 0.8 },
	{ 0.10372, 0.19173, 0.17919, 66, 66, 96, 0.8 },
	{ 0.10372, 0.19173, 0.24550, 66, 66, 120, 0.8 },
	{ 0.10372, 0.19173, 0.36421, 66, 66, 144, 0.8 },
	{ 0.10372, 0.19173, 0.48664, 66, 66, 168, 0.8 },
	{ 0.10372, 0.19173, 0.50817, 66, 66, 180, 0.8 }};
#pragma endregion 
#pragma region ұ
	float aodWinSearchTable[solZenCount * senZenCount *solAziCount *aod550Count][searchTabColCount] =
	{ { 0.04630, 0.95039, 0.01945, 0, 0, 0, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 24, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 48, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 72, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 96, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 120, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 144, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 168, 0.0001 },
	{ 0.04630, 0.95039, 0.01945, 0, 0, 180, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 0, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 24, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 48, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 72, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 96, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 120, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 144, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 168, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 0, 12, 180, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 0, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 24, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 48, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 72, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 96, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 120, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 144, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 168, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 0, 24, 180, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 0, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 24, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 48, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 72, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 96, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 120, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 144, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 168, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 0, 36, 180, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 0, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 24, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 48, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 72, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 96, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 120, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 144, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 168, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 0, 48, 180, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 0, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 24, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 48, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 72, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 96, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 120, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 144, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 168, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 0, 60, 180, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 0, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 24, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 48, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 72, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 96, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 120, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 144, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 168, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 0, 66, 180, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 0, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 24, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 48, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 72, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 96, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 120, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 144, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 168, 0.0001 },
	{ 0.04630, 0.94986, 0.01946, 12, 0, 180, 0.0001 },
	{ 0.04630, 0.94932, 0.02031, 12, 12, 0, 0.0001 },
	{ 0.04630, 0.94932, 0.02024, 12, 12, 24, 0.0001 },
	{ 0.04630, 0.94932, 0.02003, 12, 12, 48, 0.0001 },
	{ 0.04630, 0.94932, 0.01973, 12, 12, 72, 0.0001 },
	{ 0.04630, 0.94932, 0.01940, 12, 12, 96, 0.0001 },
	{ 0.04630, 0.94932, 0.01908, 12, 12, 120, 0.0001 },
	{ 0.04630, 0.94932, 0.01884, 12, 12, 144, 0.0001 },
	{ 0.04630, 0.94932, 0.01871, 12, 12, 168, 0.0001 },
	{ 0.04630, 0.94932, 0.01869, 12, 12, 180, 0.0001 },
	{ 0.04630, 0.94760, 0.02126, 12, 24, 0, 0.0001 },
	{ 0.04630, 0.94760, 0.02111, 12, 24, 24, 0.0001 },
	{ 0.04630, 0.94760, 0.02070, 12, 24, 48, 0.0001 },
	{ 0.04630, 0.94760, 0.02010, 12, 24, 72, 0.0001 },
	{ 0.04630, 0.94760, 0.01944, 12, 24, 96, 0.0001 },
	{ 0.04630, 0.94760, 0.01884, 12, 24, 120, 0.0001 },
	{ 0.04630, 0.94760, 0.01838, 12, 24, 144, 0.0001 },
	{ 0.04630, 0.94760, 0.01813, 12, 24, 168, 0.0001 },
	{ 0.04630, 0.94760, 0.01810, 12, 24, 180, 0.0001 },
	{ 0.04630, 0.94425, 0.02250, 12, 36, 0, 0.0001 },
	{ 0.04630, 0.94425, 0.02228, 12, 36, 24, 0.0001 },
	{ 0.04630, 0.94425, 0.02165, 12, 36, 48, 0.0001 },
	{ 0.04630, 0.94425, 0.02077, 12, 36, 72, 0.0001 },
	{ 0.04630, 0.94425, 0.01982, 12, 36, 96, 0.0001 },
	{ 0.04630, 0.94425, 0.01896, 12, 36, 120, 0.0001 },
	{ 0.04630, 0.94425, 0.01832, 12, 36, 144, 0.0001 },
	{ 0.04630, 0.94425, 0.01799, 12, 36, 168, 0.0001 },
	{ 0.04630, 0.94425, 0.01795, 12, 36, 180, 0.0001 },
	{ 0.04630, 0.93820, 0.02450, 12, 48, 0, 0.0001 },
	{ 0.04630, 0.93820, 0.02420, 12, 48, 24, 0.0001 },
	{ 0.04630, 0.93820, 0.02338, 12, 48, 48, 0.0001 },
	{ 0.04630, 0.93820, 0.02223, 12, 48, 72, 0.0001 },
	{ 0.04630, 0.93820, 0.02102, 12, 48, 96, 0.0001 },
	{ 0.04630, 0.93820, 0.01997, 12, 48, 120, 0.0001 },
	{ 0.04630, 0.93820, 0.01921, 12, 48, 144, 0.0001 },
	{ 0.04630, 0.93820, 0.01883, 12, 48, 168, 0.0001 },
	{ 0.04630, 0.93820, 0.01878, 12, 48, 180, 0.0001 },
	{ 0.04630, 0.92658, 0.02854, 12, 60, 0, 0.0001 },
	{ 0.04630, 0.92658, 0.02816, 12, 60, 24, 0.0001 },
	{ 0.04630, 0.92658, 0.02712, 12, 60, 48, 0.0001 },
	{ 0.04630, 0.92658, 0.02573, 12, 60, 72, 0.0001 },
	{ 0.04630, 0.92658, 0.02432, 12, 60, 96, 0.0001 },
	{ 0.04630, 0.92658, 0.02316, 12, 60, 120, 0.0001 },
	{ 0.04630, 0.92658, 0.02238, 12, 60, 144, 0.0001 },
	{ 0.04630, 0.92658, 0.02200, 12, 60, 168, 0.0001 },
	{ 0.04630, 0.92658, 0.02196, 12, 60, 180, 0.0001 },
	{ 0.04630, 0.91629, 0.03237, 12, 66, 0, 0.0001 },
	{ 0.04630, 0.91629, 0.03195, 12, 66, 24, 0.0001 },
	{ 0.04630, 0.91629, 0.03080, 12, 66, 48, 0.0001 },
	{ 0.04630, 0.91629, 0.02928, 12, 66, 72, 0.0001 },
	{ 0.04630, 0.91629, 0.02779, 12, 66, 96, 0.0001 },
	{ 0.04630, 0.91629, 0.02663, 12, 66, 120, 0.0001 },
	{ 0.04630, 0.91629, 0.02589, 12, 66, 144, 0.0001 },
	{ 0.04630, 0.91629, 0.02555, 12, 66, 168, 0.0001 },
	{ 0.04630, 0.91629, 0.02551, 12, 66, 180, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 0, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 24, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 48, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 72, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 96, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 120, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 144, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 168, 0.0001 },
	{ 0.04630, 0.94814, 0.01955, 24, 0, 180, 0.0001 },
	{ 0.04630, 0.94760, 0.02126, 24, 12, 0, 0.0001 },
	{ 0.04630, 0.94760, 0.02111, 24, 12, 24, 0.0001 },
	{ 0.04630, 0.94760, 0.02070, 24, 12, 48, 0.0001 },
	{ 0.04630, 0.94760, 0.02010, 24, 12, 72, 0.0001 },
	{ 0.04630, 0.94760, 0.01944, 24, 12, 96, 0.0001 },
	{ 0.04630, 0.94760, 0.01884, 24, 12, 120, 0.0001 },
	{ 0.04630, 0.94760, 0.01838, 24, 12, 144, 0.0001 },
	{ 0.04630, 0.94760, 0.01813, 24, 12, 168, 0.0001 },
	{ 0.04630, 0.94760, 0.01810, 24, 12, 180, 0.0001 },
	{ 0.04630, 0.94589, 0.02322, 24, 24, 0, 0.0001 },
	{ 0.04630, 0.94589, 0.02291, 24, 24, 24, 0.0001 },
	{ 0.04630, 0.94589, 0.02204, 24, 24, 48, 0.0001 },
	{ 0.04630, 0.94589, 0.02082, 24, 24, 72, 0.0001 },
	{ 0.04630, 0.94589, 0.01952, 24, 24, 96, 0.0001 },
	{ 0.04630, 0.94589, 0.01837, 24, 24, 120, 0.0001 },
	{ 0.04630, 0.94589, 0.01753, 24, 24, 144, 0.0001 },
	{ 0.04630, 0.94589, 0.01710, 24, 24, 168, 0.0001 },
	{ 0.04630, 0.94589, 0.01705, 24, 24, 180, 0.0001 },
	{ 0.04630, 0.94254, 0.02561, 24, 36, 0, 0.0001 },
	{ 0.04630, 0.94254, 0.02511, 24, 36, 24, 0.0001 },
	{ 0.04630, 0.94254, 0.02375, 24, 36, 48, 0.0001 },
	{ 0.04630, 0.94254, 0.02190, 24, 36, 72, 0.0001 },
	{ 0.04630, 0.94254, 0.02001, 24, 36, 96, 0.0001 },
	{ 0.04630, 0.94254, 0.01841, 24, 36, 120, 0.0001 },
	{ 0.04630, 0.94254, 0.01732, 24, 36, 144, 0.0001 },
	{ 0.04630, 0.94254, 0.01678, 24, 36, 168, 0.0001 },
	{ 0.04630, 0.94254, 0.01672, 24, 36, 180, 0.0001 },
	{ 0.04630, 0.93650, 0.02895, 24, 48, 0, 0.0001 },
	{ 0.04630, 0.93650, 0.02825, 24, 48, 24, 0.0001 },
	{ 0.04630, 0.93650, 0.02636, 24, 48, 48, 0.0001 },
	{ 0.04630, 0.93650, 0.02387, 24, 48, 72, 0.0001 },
	{ 0.04630, 0.93650, 0.02145, 24, 48, 96, 0.0001 },
	{ 0.04630, 0.93650, 0.01956, 24, 48, 120, 0.0001 },
	{ 0.04630, 0.93650, 0.01838, 24, 48, 144, 0.0001 },
	{ 0.04630, 0.93650, 0.01784, 24, 48, 168, 0.0001 },
	{ 0.04630, 0.93650, 0.01778, 24, 48, 180, 0.0001 },
	{ 0.04630, 0.92490, 0.03470, 24, 60, 0, 0.0001 },
	{ 0.04630, 0.92490, 0.03374, 24, 60, 24, 0.0001 },
	{ 0.04630, 0.92490, 0.03124, 24, 60, 48, 0.0001 },
	{ 0.04630, 0.92490, 0.02807, 24, 60, 72, 0.0001 },
	{ 0.04630, 0.92490, 0.02521, 24, 60, 96, 0.0001 },
	{ 0.04630, 0.92490, 0.02325, 24, 60, 120, 0.0001 },
	{ 0.04630, 0.92490, 0.02224, 24, 60, 144, 0.0001 },
	{ 0.04630, 0.92490, 0.02188, 24, 60, 168, 0.0001 },
	{ 0.04630, 0.92490, 0.02185, 24, 60, 180, 0.0001 },
	{ 0.04630, 0.91463, 0.03971, 24, 66, 0, 0.0001 },
	{ 0.04630, 0.91463, 0.03859, 24, 66, 24, 0.0001 },
	{ 0.04630, 0.91463, 0.03569, 24, 66, 48, 0.0001 },
	{ 0.04630, 0.91463, 0.03212, 24, 66, 72, 0.0001 },
	{ 0.04630, 0.91463, 0.02907, 24, 66, 96, 0.0001 },
	{ 0.04630, 0.91463, 0.02720, 24, 66, 120, 0.0001 },
	{ 0.04630, 0.91463, 0.02646, 24, 66, 144, 0.0001 },
	{ 0.04630, 0.91463, 0.02631, 24, 66, 168, 0.0001 },
	{ 0.04630, 0.91463, 0.02630, 24, 66, 180, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 0, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 24, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 48, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 72, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 96, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 120, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 144, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 168, 0.0001 },
	{ 0.04630, 0.94479, 0.01994, 36, 0, 180, 0.0001 },
	{ 0.04630, 0.94425, 0.02250, 36, 12, 0, 0.0001 },
	{ 0.04630, 0.94425, 0.02228, 36, 12, 24, 0.0001 },
	{ 0.04630, 0.94425, 0.02165, 36, 12, 48, 0.0001 },
	{ 0.04630, 0.94425, 0.02077, 36, 12, 72, 0.0001 },
	{ 0.04630, 0.94425, 0.01982, 36, 12, 96, 0.0001 },
	{ 0.04630, 0.94425, 0.01896, 36, 12, 120, 0.0001 },
	{ 0.04630, 0.94425, 0.01832, 36, 12, 144, 0.0001 },
	{ 0.04630, 0.94425, 0.01799, 36, 12, 168, 0.0001 },
	{ 0.04630, 0.94425, 0.01795, 36, 12, 180, 0.0001 },
	{ 0.04630, 0.94254, 0.02561, 36, 24, 0, 0.0001 },
	{ 0.04630, 0.94254, 0.02511, 36, 24, 24, 0.0001 },
	{ 0.04630, 0.94254, 0.02375, 36, 24, 48, 0.0001 },
	{ 0.04630, 0.94254, 0.02190, 36, 24, 72, 0.0001 },
	{ 0.04630, 0.94254, 0.02001, 36, 24, 96, 0.0001 },
	{ 0.04630, 0.94254, 0.01841, 36, 24, 120, 0.0001 },
	{ 0.04630, 0.94254, 0.01732, 36, 24, 144, 0.0001 },
	{ 0.04630, 0.94254, 0.01678, 36, 24, 168, 0.0001 },
	{ 0.04630, 0.94254, 0.01672, 36, 24, 180, 0.0001 },
	{ 0.04630, 0.93921, 0.02947, 36, 36, 0, 0.0001 },
	{ 0.04630, 0.93921, 0.02864, 36, 36, 24, 0.0001 },
	{ 0.04630, 0.93921, 0.02644, 36, 36, 48, 0.0001 },
	{ 0.04630, 0.93921, 0.02355, 36, 36, 72, 0.0001 },
	{ 0.04630, 0.93921, 0.02077, 36, 36, 96, 0.0001 },
	{ 0.04630, 0.93921, 0.01863, 36, 36, 120, 0.0001 },
	{ 0.04630, 0.93921, 0.01732, 36, 36, 144, 0.0001 },
	{ 0.04630, 0.93921, 0.01673, 36, 36, 168, 0.0001 },
	{ 0.04630, 0.93921, 0.01666, 36, 36, 180, 0.0001 },
	{ 0.04630, 0.93319, 0.03472, 36, 48, 0, 0.0001 },
	{ 0.04630, 0.93319, 0.03350, 36, 48, 24, 0.0001 },
	{ 0.04630, 0.93319, 0.03031, 36, 48, 48, 0.0001 },
	{ 0.04630, 0.93319, 0.02630, 36, 48, 72, 0.0001 },
	{ 0.04630, 0.93319, 0.02271, 36, 48, 96, 0.0001 },
	{ 0.04630, 0.93319, 0.02028, 36, 48, 120, 0.0001 },
	{ 0.04630, 0.93319, 0.01908, 36, 48, 144, 0.0001 },
	{ 0.04630, 0.93319, 0.01867, 36, 48, 168, 0.0001 },
	{ 0.04630, 0.93319, 0.01863, 36, 48, 180, 0.0001 },
	{ 0.04630, 0.92163, 0.04320, 36, 60, 0, 0.0001 },
	{ 0.04630, 0.92163, 0.04146, 36, 60, 24, 0.0001 },
	{ 0.04630, 0.92163, 0.03700, 36, 60, 48, 0.0001 },
	{ 0.04630, 0.92163, 0.03167, 36, 60, 72, 0.0001 },
	{ 0.04630, 0.92163, 0.02736, 36, 60, 96, 0.0001 },
	{ 0.04630, 0.92163, 0.02506, 36, 60, 120, 0.0001 },
	{ 0.04630, 0.92163, 0.02450, 36, 60, 144, 0.0001 },
	{ 0.04630, 0.92163, 0.02465, 36, 60, 168, 0.0001 },
	{ 0.04630, 0.92163, 0.02469, 36, 60, 180, 0.0001 },
	{ 0.04630, 0.91140, 0.05023, 36, 66, 0, 0.0001 },
	{ 0.04630, 0.91140, 0.04812, 36, 66, 24, 0.0001 },
	{ 0.04630, 0.91140, 0.04279, 36, 66, 48, 0.0001 },
	{ 0.04630, 0.91140, 0.03661, 36, 66, 72, 0.0001 },
	{ 0.04630, 0.91140, 0.03197, 36, 66, 96, 0.0001 },
	{ 0.04630, 0.91140, 0.02999, 36, 66, 120, 0.0001 },
	{ 0.04630, 0.91140, 0.03012, 36, 66, 144, 0.0001 },
	{ 0.04630, 0.91140, 0.03081, 36, 66, 168, 0.0001 },
	{ 0.04630, 0.91140, 0.03093, 36, 66, 180, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 0, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 24, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 48, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 72, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 96, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 120, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 144, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 168, 0.0001 },
	{ 0.04630, 0.93873, 0.02111, 48, 0, 180, 0.0001 },
	{ 0.04630, 0.93820, 0.02450, 48, 12, 0, 0.0001 },
	{ 0.04630, 0.93820, 0.02420, 48, 12, 24, 0.0001 },
	{ 0.04630, 0.93820, 0.02338, 48, 12, 48, 0.0001 },
	{ 0.04630, 0.93820, 0.02223, 48, 12, 72, 0.0001 },
	{ 0.04630, 0.93820, 0.02102, 48, 12, 96, 0.0001 },
	{ 0.04630, 0.93820, 0.01997, 48, 12, 120, 0.0001 },
	{ 0.04630, 0.93820, 0.01922, 48, 12, 144, 0.0001 },
	{ 0.04630, 0.93820, 0.01883, 48, 12, 168, 0.0001 },
	{ 0.04630, 0.93820, 0.01878, 48, 12, 180, 0.0001 },
	{ 0.04630, 0.93650, 0.02895, 48, 24, 0, 0.0001 },
	{ 0.04630, 0.93650, 0.02825, 48, 24, 24, 0.0001 },
	{ 0.04630, 0.93650, 0.02636, 48, 24, 48, 0.0001 },
	{ 0.04630, 0.93650, 0.02387, 48, 24, 72, 0.0001 },
	{ 0.04630, 0.93650, 0.02145, 48, 24, 96, 0.0001 },
	{ 0.04630, 0.93650, 0.01956, 48, 24, 120, 0.0001 },
	{ 0.04630, 0.93650, 0.01838, 48, 24, 144, 0.0001 },
	{ 0.04630, 0.93650, 0.01784, 48, 24, 168, 0.0001 },
	{ 0.04630, 0.93650, 0.01778, 48, 24, 180, 0.0001 },
	{ 0.04630, 0.93319, 0.03472, 48, 36, 0, 0.0001 },
	{ 0.04630, 0.93319, 0.03350, 48, 36, 24, 0.0001 },
	{ 0.04630, 0.93319, 0.03031, 48, 36, 48, 0.0001 },
	{ 0.04630, 0.93319, 0.02630, 48, 36, 72, 0.0001 },
	{ 0.04630, 0.93319, 0.02271, 48, 36, 96, 0.0001 },
	{ 0.04630, 0.93319, 0.02028, 48, 36, 120, 0.0001 },
	{ 0.04630, 0.93319, 0.01908, 48, 36, 144, 0.0001 },
	{ 0.04630, 0.93319, 0.01867, 48, 36, 168, 0.0001 },
	{ 0.04630, 0.93319, 0.01863, 48, 36, 180, 0.0001 },
	{ 0.04630, 0.92721, 0.04269, 48, 48, 0, 0.0001 },
	{ 0.04630, 0.92721, 0.04081, 48, 48, 24, 0.0001 },
	{ 0.04630, 0.92721, 0.03599, 48, 48, 48, 0.0001 },
	{ 0.04630, 0.92721, 0.03021, 48, 48, 72, 0.0001 },
	{ 0.04630, 0.92721, 0.02551, 48, 48, 96, 0.0001 },
	{ 0.04630, 0.92721, 0.02297, 48, 48, 120, 0.0001 },
	{ 0.04630, 0.92721, 0.02231, 48, 48, 144, 0.0001 },
	{ 0.04630, 0.92721, 0.02244, 48, 48, 168, 0.0001 },
	{ 0.04630, 0.92721, 0.02248, 48, 48, 180, 0.0001 },
	{ 0.04630, 0.91572, 0.05535, 48, 60, 0, 0.0001 },
	{ 0.04630, 0.91572, 0.05254, 48, 60, 24, 0.0001 },
	{ 0.04630, 0.91572, 0.04548, 48, 60, 48, 0.0001 },
	{ 0.04630, 0.91572, 0.03745, 48, 60, 72, 0.0001 },
	{ 0.04630, 0.91572, 0.03172, 48, 60, 96, 0.0001 },
	{ 0.04630, 0.91572, 0.02973, 48, 60, 120, 0.0001 },
	{ 0.04630, 0.91572, 0.03055, 48, 60, 144, 0.0001 },
	{ 0.04630, 0.91572, 0.03188, 48, 60, 168, 0.0001 },
	{ 0.04630, 0.91572, 0.03210, 48, 60, 180, 0.0001 },
	{ 0.04630, 0.90555, 0.06561, 48, 66, 0, 0.0001 },
	{ 0.04630, 0.90555, 0.06213, 48, 66, 24, 0.0001 },
	{ 0.04630, 0.90555, 0.05346, 48, 66, 48, 0.0001 },
	{ 0.04630, 0.90555, 0.04390, 48, 66, 72, 0.0001 },
	{ 0.04630, 0.90555, 0.03763, 48, 66, 96, 0.0001 },
	{ 0.04630, 0.90555, 0.03637, 48, 66, 120, 0.0001 },
	{ 0.04630, 0.90555, 0.03859, 48, 66, 144, 0.0001 },
	{ 0.04630, 0.90555, 0.04099, 48, 66, 168, 0.0001 },
	{ 0.04630, 0.90555, 0.04137, 48, 66, 180, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 0, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 24, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 48, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 72, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 96, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 120, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 144, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 168, 0.0001 },
	{ 0.04630, 0.92710, 0.02429, 60, 0, 180, 0.0001 },
	{ 0.04630, 0.92658, 0.02854, 60, 12, 0, 0.0001 },
	{ 0.04630, 0.92658, 0.02816, 60, 12, 24, 0.0001 },
	{ 0.04630, 0.92658, 0.02713, 60, 12, 48, 0.0001 },
	{ 0.04630, 0.92658, 0.02573, 60, 12, 72, 0.0001 },
	{ 0.04630, 0.92658, 0.02432, 60, 12, 96, 0.0001 },
	{ 0.04630, 0.92658, 0.02316, 60, 12, 120, 0.0001 },
	{ 0.04630, 0.92658, 0.02238, 60, 12, 144, 0.0001 },
	{ 0.04630, 0.92658, 0.02200, 60, 12, 168, 0.0001 },
	{ 0.04630, 0.92658, 0.02196, 60, 12, 180, 0.0001 },
	{ 0.04630, 0.92490, 0.03470, 60, 24, 0, 0.0001 },
	{ 0.04630, 0.92490, 0.03375, 60, 24, 24, 0.0001 },
	{ 0.04630, 0.92490, 0.03124, 60, 24, 48, 0.0001 },
	{ 0.04630, 0.92490, 0.02807, 60, 24, 72, 0.0001 },
	{ 0.04630, 0.92490, 0.02521, 60, 24, 96, 0.0001 },
	{ 0.04630, 0.92490, 0.02325, 60, 24, 120, 0.0001 },
	{ 0.04630, 0.92490, 0.02224, 60, 24, 144, 0.0001 },
	{ 0.04630, 0.92490, 0.02188, 60, 24, 168, 0.0001 },
	{ 0.04630, 0.92490, 0.02185, 60, 24, 180, 0.0001 },
	{ 0.04630, 0.92163, 0.04320, 60, 36, 0, 0.0001 },
	{ 0.04630, 0.92163, 0.04146, 60, 36, 24, 0.0001 },
	{ 0.04630, 0.92163, 0.03700, 60, 36, 48, 0.0001 },
	{ 0.04630, 0.92163, 0.03167, 60, 36, 72, 0.0001 },
	{ 0.04630, 0.92163, 0.02736, 60, 36, 96, 0.0001 },
	{ 0.04630, 0.92163, 0.02506, 60, 36, 120, 0.0001 },
	{ 0.04630, 0.92163, 0.02450, 60, 36, 144, 0.0001 },
	{ 0.04630, 0.92163, 0.02465, 60, 36, 168, 0.0001 },
	{ 0.04630, 0.92163, 0.02469, 60, 36, 180, 0.0001 },
	{ 0.04630, 0.91572, 0.05535, 60, 48, 0, 0.0001 },
	{ 0.04630, 0.91572, 0.05254, 60, 48, 24, 0.0001 },
	{ 0.04630, 0.91572, 0.04548, 60, 48, 48, 0.0001 },
	{ 0.04630, 0.91572, 0.03745, 60, 48, 72, 0.0001 },
	{ 0.04630, 0.91572, 0.03172, 60, 48, 96, 0.0001 },
	{ 0.04630, 0.91572, 0.02973, 60, 48, 120, 0.0001 },
	{ 0.04630, 0.91572, 0.03055, 60, 48, 144, 0.0001 },
	{ 0.04630, 0.91572, 0.03188, 60, 48, 168, 0.0001 },
	{ 0.04630, 0.91572, 0.03210, 60, 48, 180, 0.0001 },
	{ 0.04630, 0.90438, 0.07488, 60, 60, 0, 0.0001 },
	{ 0.04630, 0.90438, 0.07049, 60, 60, 24, 0.0001 },
	{ 0.04630, 0.90438, 0.05965, 60, 60, 48, 0.0001 },
	{ 0.04630, 0.90438, 0.04793, 60, 60, 72, 0.0001 },
	{ 0.04630, 0.90438, 0.04074, 60, 60, 96, 0.0001 },
	{ 0.04630, 0.90438, 0.04013, 60, 60, 120, 0.0001 },
	{ 0.04630, 0.90438, 0.04392, 60, 60, 144, 0.0001 },
	{ 0.04630, 0.90438, 0.04757, 60, 60, 168, 0.0001 },
	{ 0.04630, 0.90438, 0.04813, 60, 60, 180, 0.0001 },
	{ 0.04630, 0.89434, 0.09063, 60, 66, 0, 0.0001 },
	{ 0.04630, 0.89434, 0.08505, 60, 66, 24, 0.0001 },
	{ 0.04630, 0.89434, 0.07140, 60, 66, 48, 0.0001 },
	{ 0.04630, 0.89434, 0.05705, 60, 66, 72, 0.0001 },
	{ 0.04630, 0.89434, 0.04904, 60, 66, 96, 0.0001 },
	{ 0.04630, 0.89434, 0.04985, 60, 66, 120, 0.0001 },
	{ 0.04630, 0.89434, 0.05625, 60, 66, 144, 0.0001 },
	{ 0.04630, 0.89434, 0.06189, 60, 66, 168, 0.0001 },
	{ 0.04630, 0.89434, 0.06273, 60, 66, 180, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 0, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 24, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 48, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 72, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 96, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 120, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 144, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 168, 0.0001 },
	{ 0.04630, 0.91681, 0.02765, 66, 0, 180, 0.0001 },
	{ 0.04630, 0.91629, 0.03237, 66, 12, 0, 0.0001 },
	{ 0.04630, 0.91629, 0.03195, 66, 12, 24, 0.0001 },
	{ 0.04630, 0.91629, 0.03080, 66, 12, 48, 0.0001 },
	{ 0.04630, 0.91629, 0.02928, 66, 12, 72, 0.0001 },
	{ 0.04630, 0.91629, 0.02779, 66, 12, 96, 0.0001 },
	{ 0.04630, 0.91629, 0.02663, 66, 12, 120, 0.0001 },
	{ 0.04630, 0.91629, 0.02589, 66, 12, 144, 0.0001 },
	{ 0.04630, 0.91629, 0.02555, 66, 12, 168, 0.0001 },
	{ 0.04630, 0.91629, 0.02551, 66, 12, 180, 0.0001 },
	{ 0.04630, 0.91463, 0.03971, 66, 24, 0, 0.0001 },
	{ 0.04630, 0.91463, 0.03859, 66, 24, 24, 0.0001 },
	{ 0.04630, 0.91463, 0.03569, 66, 24, 48, 0.0001 },
	{ 0.04630, 0.91463, 0.03212, 66, 24, 72, 0.0001 },
	{ 0.04630, 0.91463, 0.02907, 66, 24, 96, 0.0001 },
	{ 0.04630, 0.91463, 0.02720, 66, 24, 120, 0.0001 },
	{ 0.04630, 0.91463, 0.02646, 66, 24, 144, 0.0001 },
	{ 0.04630, 0.91463, 0.02631, 66, 24, 168, 0.0001 },
	{ 0.04630, 0.91463, 0.02630, 66, 24, 180, 0.0001 },
	{ 0.04630, 0.91140, 0.05023, 66, 36, 0, 0.0001 },
	{ 0.04630, 0.91140, 0.04812, 66, 36, 24, 0.0001 },
	{ 0.04630, 0.91140, 0.04279, 66, 36, 48, 0.0001 },
	{ 0.04630, 0.91140, 0.03661, 66, 36, 72, 0.0001 },
	{ 0.04630, 0.91140, 0.03197, 66, 36, 96, 0.0001 },
	{ 0.04630, 0.91140, 0.02999, 66, 36, 120, 0.0001 },
	{ 0.04630, 0.91140, 0.03012, 66, 36, 144, 0.0001 },
	{ 0.04630, 0.91140, 0.03081, 66, 36, 168, 0.0001 },
	{ 0.04630, 0.91140, 0.03093, 66, 36, 180, 0.0001 },
	{ 0.04630, 0.90555, 0.06561, 66, 48, 0, 0.0001 },
	{ 0.04630, 0.90555, 0.06212, 66, 48, 24, 0.0001 },
	{ 0.04630, 0.90555, 0.05346, 66, 48, 48, 0.0001 },
	{ 0.04630, 0.90555, 0.04389, 66, 48, 72, 0.0001 },
	{ 0.04630, 0.90555, 0.03763, 66, 48, 96, 0.0001 },
	{ 0.04630, 0.90555, 0.03636, 66, 48, 120, 0.0001 },
	{ 0.04630, 0.90555, 0.03858, 66, 48, 144, 0.0001 },
	{ 0.04630, 0.90555, 0.04099, 66, 48, 168, 0.0001 },
	{ 0.04630, 0.90555, 0.04137, 66, 48, 180, 0.0001 },
	{ 0.04630, 0.89434, 0.09063, 66, 60, 0, 0.0001 },
	{ 0.04630, 0.89434, 0.08505, 66, 60, 24, 0.0001 },
	{ 0.04630, 0.89434, 0.07140, 66, 60, 48, 0.0001 },
	{ 0.04630, 0.89434, 0.05705, 66, 60, 72, 0.0001 },
	{ 0.04630, 0.89434, 0.04904, 66, 60, 96, 0.0001 },
	{ 0.04630, 0.89434, 0.04985, 66, 60, 120, 0.0001 },
	{ 0.04630, 0.89434, 0.05625, 66, 60, 144, 0.0001 },
	{ 0.04630, 0.89434, 0.06189, 66, 60, 168, 0.0001 },
	{ 0.04630, 0.89434, 0.06273, 66, 60, 180, 0.0001 },
	{ 0.04630, 0.88441, 0.11086, 66, 66, 0, 0.0001 },
	{ 0.04630, 0.88441, 0.10368, 66, 66, 24, 0.0001 },
	{ 0.04630, 0.88441, 0.08627, 66, 66, 48, 0.0001 },
	{ 0.04630, 0.88441, 0.06842, 66, 66, 72, 0.0001 },
	{ 0.04630, 0.88441, 0.05938, 66, 66, 96, 0.0001 },
	{ 0.04630, 0.88441, 0.06218, 66, 66, 120, 0.0001 },
	{ 0.04630, 0.88441, 0.07217, 66, 66, 144, 0.0001 },
	{ 0.04630, 0.88441, 0.08053, 66, 66, 168, 0.0001 },
	{ 0.04630, 0.88441, 0.08176, 66, 66, 180, 0.0001 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 0, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 24, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 48, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 72, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 96, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 120, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 144, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 168, 0.1 },
	{ 0.05945, 0.88684, 0.02400, 0, 0, 180, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 0, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 24, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 48, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 72, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 96, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 120, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 144, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 168, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 0, 12, 180, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 0, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 24, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 48, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 72, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 96, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 120, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 144, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 168, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 0, 24, 180, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 0, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 24, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 48, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 72, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 96, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 120, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 144, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 168, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 0, 36, 180, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 0, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 24, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 48, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 72, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 96, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 120, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 144, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 168, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 0, 48, 180, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 0, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 24, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 48, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 72, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 96, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 120, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 144, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 168, 0.1 },
	{ 0.05945, 0.82718, 0.03070, 0, 60, 180, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 0, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 24, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 48, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 72, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 96, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 120, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 144, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 168, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 0, 66, 180, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 0, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 24, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 48, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 72, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 96, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 120, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 144, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 168, 0.1 },
	{ 0.05945, 0.88551, 0.02343, 12, 0, 180, 0.1 },
	{ 0.05945, 0.88418, 0.02507, 12, 12, 0, 0.1 },
	{ 0.05945, 0.88418, 0.02481, 12, 12, 24, 0.1 },
	{ 0.05945, 0.88418, 0.02423, 12, 12, 48, 0.1 },
	{ 0.05945, 0.88418, 0.02369, 12, 12, 72, 0.1 },
	{ 0.05945, 0.88418, 0.02323, 12, 12, 96, 0.1 },
	{ 0.05945, 0.88418, 0.02285, 12, 12, 120, 0.1 },
	{ 0.05945, 0.88418, 0.02256, 12, 12, 144, 0.1 },
	{ 0.05945, 0.88418, 0.02241, 12, 12, 168, 0.1 },
	{ 0.05945, 0.88418, 0.02239, 12, 12, 180, 0.1 },
	{ 0.05945, 0.87986, 0.02562, 12, 24, 0, 0.1 },
	{ 0.05945, 0.87986, 0.02536, 12, 24, 24, 0.1 },
	{ 0.05945, 0.87986, 0.02480, 12, 24, 48, 0.1 },
	{ 0.05945, 0.87986, 0.02410, 12, 24, 72, 0.1 },
	{ 0.05945, 0.87986, 0.02333, 12, 24, 96, 0.1 },
	{ 0.05945, 0.87986, 0.02264, 12, 24, 120, 0.1 },
	{ 0.05945, 0.87986, 0.02212, 12, 24, 144, 0.1 },
	{ 0.05945, 0.87986, 0.02184, 12, 24, 168, 0.1 },
	{ 0.05945, 0.87986, 0.02181, 12, 24, 180, 0.1 },
	{ 0.05945, 0.87138, 0.02700, 12, 36, 0, 0.1 },
	{ 0.05945, 0.87138, 0.02675, 12, 36, 24, 0.1 },
	{ 0.05945, 0.87138, 0.02603, 12, 36, 48, 0.1 },
	{ 0.05945, 0.87138, 0.02503, 12, 36, 72, 0.1 },
	{ 0.05945, 0.87138, 0.02397, 12, 36, 96, 0.1 },
	{ 0.05945, 0.87138, 0.02304, 12, 36, 120, 0.1 },
	{ 0.05945, 0.87138, 0.02237, 12, 36, 144, 0.1 },
	{ 0.05945, 0.87138, 0.02203, 12, 36, 168, 0.1 },
	{ 0.05945, 0.87138, 0.02199, 12, 36, 180, 0.1 },
	{ 0.05945, 0.85585, 0.02959, 12, 48, 0, 0.1 },
	{ 0.05945, 0.85585, 0.02926, 12, 48, 24, 0.1 },
	{ 0.05945, 0.85585, 0.02835, 12, 48, 48, 0.1 },
	{ 0.05945, 0.85585, 0.02713, 12, 48, 72, 0.1 },
	{ 0.05945, 0.85585, 0.02590, 12, 48, 96, 0.1 },
	{ 0.05945, 0.85585, 0.02487, 12, 48, 120, 0.1 },
	{ 0.05945, 0.85585, 0.02417, 12, 48, 144, 0.1 },
	{ 0.05945, 0.85585, 0.02383, 12, 48, 168, 0.1 },
	{ 0.05945, 0.85585, 0.02379, 12, 48, 180, 0.1 },
	{ 0.05945, 0.82594, 0.03496, 12, 60, 0, 0.1 },
	{ 0.05945, 0.82594, 0.03457, 12, 60, 24, 0.1 },
	{ 0.05945, 0.82594, 0.03355, 12, 60, 48, 0.1 },
	{ 0.05945, 0.82594, 0.03222, 12, 60, 72, 0.1 },
	{ 0.05945, 0.82594, 0.03097, 12, 60, 96, 0.1 },
	{ 0.05945, 0.82594, 0.03004, 12, 60, 120, 0.1 },
	{ 0.05945, 0.82594, 0.02951, 12, 60, 144, 0.1 },
	{ 0.05945, 0.82594, 0.02928, 12, 60, 168, 0.1 },
	{ 0.05945, 0.82594, 0.02926, 12, 60, 180, 0.1 },
	{ 0.05945, 0.79982, 0.04004, 12, 66, 0, 0.1 },
	{ 0.05945, 0.79982, 0.03963, 12, 66, 24, 0.1 },
	{ 0.05945, 0.79982, 0.03856, 12, 66, 48, 0.1 },
	{ 0.05945, 0.79982, 0.03724, 12, 66, 72, 0.1 },
	{ 0.05945, 0.79982, 0.03609, 12, 66, 96, 0.1 },
	{ 0.05945, 0.79982, 0.03536, 12, 66, 120, 0.1 },
	{ 0.05945, 0.79982, 0.03506, 12, 66, 144, 0.1 },
	{ 0.05945, 0.79982, 0.03499, 12, 66, 168, 0.1 },
	{ 0.05945, 0.79982, 0.03499, 12, 66, 180, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 0, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 24, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 48, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 72, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 96, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 120, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 144, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 168, 0.1 },
	{ 0.05945, 0.88119, 0.02344, 24, 0, 180, 0.1 },
	{ 0.05945, 0.87986, 0.02562, 24, 12, 0, 0.1 },
	{ 0.05945, 0.87986, 0.02536, 24, 12, 24, 0.1 },
	{ 0.05945, 0.87986, 0.02480, 24, 12, 48, 0.1 },
	{ 0.05945, 0.87986, 0.02410, 24, 12, 72, 0.1 },
	{ 0.05945, 0.87986, 0.02333, 24, 12, 96, 0.1 },
	{ 0.05945, 0.87986, 0.02264, 24, 12, 120, 0.1 },
	{ 0.05945, 0.87986, 0.02212, 24, 12, 144, 0.1 },
	{ 0.05945, 0.87986, 0.02184, 24, 12, 168, 0.1 },
	{ 0.05945, 0.87986, 0.02181, 24, 12, 180, 0.1 },
	{ 0.05945, 0.87557, 0.02869, 24, 24, 0, 0.1 },
	{ 0.05945, 0.87557, 0.02774, 24, 24, 24, 0.1 },
	{ 0.05945, 0.87557, 0.02642, 24, 24, 48, 0.1 },
	{ 0.05945, 0.87557, 0.02500, 24, 24, 72, 0.1 },
	{ 0.05945, 0.87557, 0.02353, 24, 24, 96, 0.1 },
	{ 0.05945, 0.87557, 0.02226, 24, 24, 120, 0.1 },
	{ 0.05945, 0.87557, 0.02138, 24, 24, 144, 0.1 },
	{ 0.05945, 0.87557, 0.02093, 24, 24, 168, 0.1 },
	{ 0.05945, 0.87557, 0.02088, 24, 24, 180, 0.1 },
	{ 0.05945, 0.86712, 0.03091, 24, 36, 0, 0.1 },
	{ 0.05945, 0.86712, 0.03016, 24, 36, 24, 0.1 },
	{ 0.05945, 0.86712, 0.02855, 24, 36, 48, 0.1 },
	{ 0.05945, 0.86712, 0.02644, 24, 36, 72, 0.1 },
	{ 0.05945, 0.86712, 0.02438, 24, 36, 96, 0.1 },
	{ 0.05945, 0.86712, 0.02276, 24, 36, 120, 0.1 },
	{ 0.05945, 0.86712, 0.02172, 24, 36, 144, 0.1 },
	{ 0.05945, 0.86712, 0.02123, 24, 36, 168, 0.1 },
	{ 0.05945, 0.86712, 0.02117, 24, 36, 180, 0.1 },
	{ 0.05945, 0.85167, 0.03481, 24, 48, 0, 0.1 },
	{ 0.05945, 0.85167, 0.03399, 24, 48, 24, 0.1 },
	{ 0.05945, 0.85167, 0.03186, 24, 48, 48, 0.1 },
	{ 0.05945, 0.85167, 0.02917, 24, 48, 72, 0.1 },
	{ 0.05945, 0.85167, 0.02674, 24, 48, 96, 0.1 },
	{ 0.05945, 0.85167, 0.02504, 24, 48, 120, 0.1 },
	{ 0.05945, 0.85167, 0.02415, 24, 48, 144, 0.1 },
	{ 0.05945, 0.85167, 0.02381, 24, 48, 168, 0.1 },
	{ 0.05945, 0.85167, 0.02378, 24, 48, 180, 0.1 },
	{ 0.05945, 0.82191, 0.04191, 24, 60, 0, 0.1 },
	{ 0.05945, 0.82191, 0.04087, 24, 60, 24, 0.1 },
	{ 0.05945, 0.82191, 0.03820, 24, 60, 48, 0.1 },
	{ 0.05945, 0.82191, 0.03506, 24, 60, 72, 0.1 },
	{ 0.05945, 0.82191, 0.03257, 24, 60, 96, 0.1 },
	{ 0.05945, 0.82191, 0.03131, 24, 60, 120, 0.1 },
	{ 0.05945, 0.82191, 0.03113, 24, 60, 144, 0.1 },
	{ 0.05945, 0.82191, 0.03136, 24, 60, 168, 0.1 },
	{ 0.05945, 0.82191, 0.03141, 24, 60, 180, 0.1 },
	{ 0.05945, 0.79591, 0.04809, 24, 66, 0, 0.1 },
	{ 0.05945, 0.79591, 0.04691, 24, 66, 24, 0.1 },
	{ 0.05945, 0.79591, 0.04397, 24, 66, 48, 0.1 },
	{ 0.05945, 0.79591, 0.04064, 24, 66, 72, 0.1 },
	{ 0.05945, 0.79591, 0.03832, 24, 66, 96, 0.1 },
	{ 0.05945, 0.79591, 0.03766, 24, 66, 120, 0.1 },
	{ 0.05945, 0.79591, 0.03829, 24, 66, 144, 0.1 },
	{ 0.05945, 0.79591, 0.03912, 24, 66, 168, 0.1 },
	{ 0.05945, 0.79591, 0.03925, 24, 66, 180, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 0, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 24, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 48, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 72, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 96, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 120, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 144, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 168, 0.1 },
	{ 0.05945, 0.87269, 0.02405, 36, 0, 180, 0.1 },
	{ 0.05945, 0.87138, 0.02701, 36, 12, 0, 0.1 },
	{ 0.05945, 0.87138, 0.02675, 36, 12, 24, 0.1 },
	{ 0.05945, 0.87138, 0.02603, 36, 12, 48, 0.1 },
	{ 0.05945, 0.87138, 0.02503, 36, 12, 72, 0.1 },
	{ 0.05945, 0.87138, 0.02397, 36, 12, 96, 0.1 },
	{ 0.05945, 0.87138, 0.02304, 36, 12, 120, 0.1 },
	{ 0.05945, 0.87138, 0.02237, 36, 12, 144, 0.1 },
	{ 0.05945, 0.87138, 0.02203, 36, 12, 168, 0.1 },
	{ 0.05945, 0.87138, 0.02199, 36, 12, 180, 0.1 },
	{ 0.05945, 0.86712, 0.03091, 36, 24, 0, 0.1 },
	{ 0.05945, 0.86712, 0.03016, 36, 24, 24, 0.1 },
	{ 0.05945, 0.86712, 0.02855, 36, 24, 48, 0.1 },
	{ 0.05945, 0.86712, 0.02644, 36, 24, 72, 0.1 },
	{ 0.05945, 0.86712, 0.02438, 36, 24, 96, 0.1 },
	{ 0.05945, 0.86712, 0.02276, 36, 24, 120, 0.1 },
	{ 0.05945, 0.86712, 0.02172, 36, 24, 144, 0.1 },
	{ 0.05945, 0.86712, 0.02123, 36, 24, 168, 0.1 },
	{ 0.05945, 0.86712, 0.02117, 36, 24, 180, 0.1 },
	{ 0.05945, 0.85876, 0.03648, 36, 36, 0, 0.1 },
	{ 0.05945, 0.85876, 0.03451, 36, 36, 24, 0.1 },
	{ 0.05945, 0.85876, 0.03184, 36, 36, 48, 0.1 },
	{ 0.05945, 0.85876, 0.02860, 36, 36, 72, 0.1 },
	{ 0.05945, 0.85876, 0.02572, 36, 36, 96, 0.1 },
	{ 0.05945, 0.85876, 0.02374, 36, 36, 120, 0.1 },
	{ 0.05945, 0.85876, 0.02270, 36, 36, 144, 0.1 },
	{ 0.05945, 0.85876, 0.02234, 36, 36, 168, 0.1 },
	{ 0.05945, 0.85876, 0.02230, 36, 36, 180, 0.1 },
	{ 0.05945, 0.84346, 0.04201, 36, 48, 0, 0.1 },
	{ 0.05945, 0.84346, 0.04033, 36, 48, 24, 0.1 },
	{ 0.05945, 0.84346, 0.03666, 36, 48, 48, 0.1 },
	{ 0.05945, 0.84346, 0.03233, 36, 48, 72, 0.1 },
	{ 0.05945, 0.84346, 0.02888, 36, 48, 96, 0.1 },
	{ 0.05945, 0.84346, 0.02705, 36, 48, 120, 0.1 },
	{ 0.05945, 0.84346, 0.02667, 36, 48, 144, 0.1 },
	{ 0.05945, 0.84346, 0.02688, 36, 48, 168, 0.1 },
	{ 0.05945, 0.84346, 0.02693, 36, 48, 180, 0.1 },
	{ 0.05945, 0.81398, 0.05201, 36, 60, 0, 0.1 },
	{ 0.05945, 0.81398, 0.05002, 36, 60, 24, 0.1 },
	{ 0.05945, 0.81398, 0.04507, 36, 60, 48, 0.1 },
	{ 0.05945, 0.81398, 0.03968, 36, 60, 72, 0.1 },
	{ 0.05945, 0.81398, 0.03612, 36, 60, 96, 0.1 },
	{ 0.05945, 0.81398, 0.03542, 36, 60, 120, 0.1 },
	{ 0.05945, 0.81398, 0.03698, 36, 60, 144, 0.1 },
	{ 0.05945, 0.81398, 0.03876, 36, 60, 168, 0.1 },
	{ 0.05945, 0.81398, 0.03904, 36, 60, 180, 0.1 },
	{ 0.05945, 0.78824, 0.06041, 36, 66, 0, 0.1 },
	{ 0.05945, 0.78824, 0.05805, 36, 66, 24, 0.1 },
	{ 0.05945, 0.78824, 0.05232, 36, 66, 48, 0.1 },
	{ 0.05945, 0.78824, 0.04636, 36, 66, 72, 0.1 },
	{ 0.05945, 0.78824, 0.04304, 36, 66, 96, 0.1 },
	{ 0.05945, 0.78824, 0.04366, 36, 66, 120, 0.1 },
	{ 0.05945, 0.78824, 0.04723, 36, 66, 144, 0.1 },
	{ 0.05945, 0.78824, 0.05061, 36, 66, 168, 0.1 },
	{ 0.05945, 0.78824, 0.05112, 36, 66, 180, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 0, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 24, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 48, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 72, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 96, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 120, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 144, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 168, 0.1 },
	{ 0.05945, 0.85714, 0.02588, 48, 0, 180, 0.1 },
	{ 0.05945, 0.85585, 0.02959, 48, 12, 0, 0.1 },
	{ 0.05945, 0.85585, 0.02926, 48, 12, 24, 0.1 },
	{ 0.05945, 0.85585, 0.02835, 48, 12, 48, 0.1 },
	{ 0.05945, 0.85585, 0.02714, 48, 12, 72, 0.1 },
	{ 0.05945, 0.85585, 0.02590, 48, 12, 96, 0.1 },
	{ 0.05945, 0.85585, 0.02487, 48, 12, 120, 0.1 },
	{ 0.05945, 0.85585, 0.02418, 48, 12, 144, 0.1 },
	{ 0.05945, 0.85585, 0.02383, 48, 12, 168, 0.1 },
	{ 0.05945, 0.85585, 0.02379, 48, 12, 180, 0.1 },
	{ 0.05945, 0.85167, 0.03482, 48, 24, 0, 0.1 },
	{ 0.05945, 0.85167, 0.03400, 48, 24, 24, 0.1 },
	{ 0.05945, 0.85167, 0.03186, 48, 24, 48, 0.1 },
	{ 0.05945, 0.85167, 0.02917, 48, 24, 72, 0.1 },
	{ 0.05945, 0.85167, 0.02674, 48, 24, 96, 0.1 },
	{ 0.05945, 0.85167, 0.02505, 48, 24, 120, 0.1 },
	{ 0.05945, 0.85167, 0.02415, 48, 24, 144, 0.1 },
	{ 0.05945, 0.85167, 0.02382, 48, 24, 168, 0.1 },
	{ 0.05945, 0.85167, 0.02378, 48, 24, 180, 0.1 },
	{ 0.05945, 0.84346, 0.04201, 48, 36, 0, 0.1 },
	{ 0.05945, 0.84346, 0.04033, 48, 36, 24, 0.1 },
	{ 0.05945, 0.84346, 0.03666, 48, 36, 48, 0.1 },
	{ 0.05945, 0.84346, 0.03233, 48, 36, 72, 0.1 },
	{ 0.05945, 0.84346, 0.02888, 48, 36, 96, 0.1 },
	{ 0.05945, 0.84346, 0.02705, 48, 36, 120, 0.1 },
	{ 0.05945, 0.84346, 0.02667, 48, 36, 144, 0.1 },
	{ 0.05945, 0.84346, 0.02688, 48, 36, 168, 0.1 },
	{ 0.05945, 0.84346, 0.02693, 48, 36, 180, 0.1 },
	{ 0.05945, 0.82843, 0.05294, 48, 48, 0, 0.1 },
	{ 0.05945, 0.82843, 0.04922, 48, 48, 24, 0.1 },
	{ 0.05945, 0.82843, 0.04365, 48, 48, 48, 0.1 },
	{ 0.05945, 0.82843, 0.03755, 48, 48, 72, 0.1 },
	{ 0.05945, 0.82843, 0.03340, 48, 48, 96, 0.1 },
	{ 0.05945, 0.82843, 0.03233, 48, 48, 120, 0.1 },
	{ 0.05945, 0.82843, 0.03371, 48, 48, 144, 0.1 },
	{ 0.05945, 0.82843, 0.03544, 48, 48, 168, 0.1 },
	{ 0.05945, 0.82843, 0.03572, 48, 48, 180, 0.1 },
	{ 0.05945, 0.79948, 0.06706, 48, 60, 0, 0.1 },
	{ 0.05945, 0.79948, 0.06339, 48, 60, 24, 0.1 },
	{ 0.05945, 0.79948, 0.05544, 48, 60, 48, 0.1 },
	{ 0.05945, 0.79948, 0.04733, 48, 60, 72, 0.1 },
	{ 0.05945, 0.79948, 0.04308, 48, 60, 96, 0.1 },
	{ 0.05945, 0.79948, 0.04449, 48, 60, 120, 0.1 },
	{ 0.05945, 0.79948, 0.05030, 48, 60, 144, 0.1 },
	{ 0.05945, 0.79948, 0.05581, 48, 60, 168, 0.1 },
	{ 0.05945, 0.79948, 0.05667, 48, 60, 180, 0.1 },
	{ 0.05945, 0.77419, 0.07888, 48, 66, 0, 0.1 },
	{ 0.05945, 0.77419, 0.07482, 48, 66, 24, 0.1 },
	{ 0.05945, 0.77419, 0.06525, 48, 66, 48, 0.1 },
	{ 0.05945, 0.77419, 0.05593, 48, 66, 72, 0.1 },
	{ 0.05945, 0.77419, 0.05202, 48, 66, 96, 0.1 },
	{ 0.05945, 0.77419, 0.05599, 48, 66, 120, 0.1 },
	{ 0.05945, 0.77419, 0.06618, 48, 66, 144, 0.1 },
	{ 0.05945, 0.77419, 0.07556, 48, 66, 168, 0.1 },
	{ 0.05945, 0.77419, 0.07705, 48, 66, 180, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 0, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 24, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 48, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 72, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 96, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 120, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 144, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 168, 0.1 },
	{ 0.05945, 0.82718, 0.03071, 60, 0, 180, 0.1 },
	{ 0.05945, 0.82594, 0.03496, 60, 12, 0, 0.1 },
	{ 0.05945, 0.82594, 0.03457, 60, 12, 24, 0.1 },
	{ 0.05945, 0.82594, 0.03355, 60, 12, 48, 0.1 },
	{ 0.05945, 0.82594, 0.03222, 60, 12, 72, 0.1 },
	{ 0.05945, 0.82594, 0.03097, 60, 12, 96, 0.1 },
	{ 0.05945, 0.82594, 0.03004, 60, 12, 120, 0.1 },
	{ 0.05945, 0.82594, 0.02951, 60, 12, 144, 0.1 },
	{ 0.05945, 0.82594, 0.02928, 60, 12, 168, 0.1 },
	{ 0.05945, 0.82594, 0.02926, 60, 12, 180, 0.1 },
	{ 0.05945, 0.82191, 0.04191, 60, 24, 0, 0.1 },
	{ 0.05945, 0.82191, 0.04087, 60, 24, 24, 0.1 },
	{ 0.05945, 0.82191, 0.03820, 60, 24, 48, 0.1 },
	{ 0.05945, 0.82191, 0.03506, 60, 24, 72, 0.1 },
	{ 0.05945, 0.82191, 0.03257, 60, 24, 96, 0.1 },
	{ 0.05945, 0.82191, 0.03131, 60, 24, 120, 0.1 },
	{ 0.05945, 0.82191, 0.03113, 60, 24, 144, 0.1 },
	{ 0.05945, 0.82191, 0.03136, 60, 24, 168, 0.1 },
	{ 0.05945, 0.82191, 0.03141, 60, 24, 180, 0.1 },
	{ 0.05945, 0.81398, 0.05201, 60, 36, 0, 0.1 },
	{ 0.05945, 0.81398, 0.05002, 60, 36, 24, 0.1 },
	{ 0.05945, 0.81398, 0.04507, 60, 36, 48, 0.1 },
	{ 0.05945, 0.81398, 0.03968, 60, 36, 72, 0.1 },
	{ 0.05945, 0.81398, 0.03612, 60, 36, 96, 0.1 },
	{ 0.05945, 0.81398, 0.03542, 60, 36, 120, 0.1 },
	{ 0.05945, 0.81398, 0.03698, 60, 36, 144, 0.1 },
	{ 0.05945, 0.81398, 0.03875, 60, 36, 168, 0.1 },
	{ 0.05945, 0.81398, 0.03904, 60, 36, 180, 0.1 },
	{ 0.05945, 0.79948, 0.06705, 60, 48, 0, 0.1 },
	{ 0.05945, 0.79948, 0.06338, 60, 48, 24, 0.1 },
	{ 0.05945, 0.79948, 0.05544, 60, 48, 48, 0.1 },
	{ 0.05945, 0.79948, 0.04733, 60, 48, 72, 0.1 },
	{ 0.05945, 0.79948, 0.04308, 60, 48, 96, 0.1 },
	{ 0.05945, 0.79948, 0.04449, 60, 48, 120, 0.1 },
	{ 0.05945, 0.79948, 0.05030, 60, 48, 144, 0.1 },
	{ 0.05945, 0.79948, 0.05581, 60, 48, 168, 0.1 },
	{ 0.05945, 0.79948, 0.05667, 60, 48, 180, 0.1 },
	{ 0.05945, 0.77154, 0.09274, 60, 60, 0, 0.1 },
	{ 0.05945, 0.77154, 0.08507, 60, 60, 24, 0.1 },
	{ 0.05945, 0.77154, 0.07289, 60, 60, 48, 0.1 },
	{ 0.05945, 0.77154, 0.06134, 60, 60, 72, 0.1 },
	{ 0.05945, 0.77154, 0.05714, 60, 60, 96, 0.1 },
	{ 0.05945, 0.77154, 0.06371, 60, 60, 120, 0.1 },
	{ 0.05945, 0.77154, 0.07925, 60, 60, 144, 0.1 },
	{ 0.05945, 0.77154, 0.09409, 60, 60, 168, 0.1 },
	{ 0.05945, 0.77154, 0.09647, 60, 60, 180, 0.1 },
	{ 0.05945, 0.74714, 0.11096, 60, 66, 0, 0.1 },
	{ 0.05945, 0.74714, 0.10243, 60, 66, 24, 0.1 },
	{ 0.05945, 0.74714, 0.08724, 60, 66, 48, 0.1 },
	{ 0.05945, 0.74714, 0.07338, 60, 66, 72, 0.1 },
	{ 0.05945, 0.74714, 0.06975, 60, 66, 96, 0.1 },
	{ 0.05945, 0.74714, 0.08120, 60, 66, 120, 0.1 },
	{ 0.05945, 0.74714, 0.10609, 60, 66, 144, 0.1 },
	{ 0.05945, 0.74714, 0.13061, 60, 66, 168, 0.1 },
	{ 0.05945, 0.74714, 0.13464, 60, 66, 180, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 0, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 24, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 48, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 72, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 96, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 120, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 144, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 168, 0.1 },
	{ 0.05945, 0.80102, 0.03562, 66, 0, 180, 0.1 },
	{ 0.05945, 0.79982, 0.04004, 66, 12, 0, 0.1 },
	{ 0.05945, 0.79982, 0.03963, 66, 12, 24, 0.1 },
	{ 0.05945, 0.79982, 0.03856, 66, 12, 48, 0.1 },
	{ 0.05945, 0.79982, 0.03724, 66, 12, 72, 0.1 },
	{ 0.05945, 0.79982, 0.03609, 66, 12, 96, 0.1 },
	{ 0.05945, 0.79982, 0.03536, 66, 12, 120, 0.1 },
	{ 0.05945, 0.79982, 0.03506, 66, 12, 144, 0.1 },
	{ 0.05945, 0.79982, 0.03499, 66, 12, 168, 0.1 },
	{ 0.05945, 0.79982, 0.03499, 66, 12, 180, 0.1 },
	{ 0.05945, 0.79591, 0.04809, 66, 24, 0, 0.1 },
	{ 0.05945, 0.79591, 0.04691, 66, 24, 24, 0.1 },
	{ 0.05945, 0.79591, 0.04396, 66, 24, 48, 0.1 },
	{ 0.05945, 0.79591, 0.04064, 66, 24, 72, 0.1 },
	{ 0.05945, 0.79591, 0.03832, 66, 24, 96, 0.1 },
	{ 0.05945, 0.79591, 0.03766, 66, 24, 120, 0.1 },
	{ 0.05945, 0.79591, 0.03829, 66, 24, 144, 0.1 },
	{ 0.05945, 0.79591, 0.03912, 66, 24, 168, 0.1 },
	{ 0.05945, 0.79591, 0.03925, 66, 24, 180, 0.1 },
	{ 0.05945, 0.78824, 0.06041, 66, 36, 0, 0.1 },
	{ 0.05945, 0.78824, 0.05804, 66, 36, 24, 0.1 },
	{ 0.05945, 0.78824, 0.05232, 66, 36, 48, 0.1 },
	{ 0.05945, 0.78824, 0.04636, 66, 36, 72, 0.1 },
	{ 0.05945, 0.78824, 0.04304, 66, 36, 96, 0.1 },
	{ 0.05945, 0.78824, 0.04366, 66, 36, 120, 0.1 },
	{ 0.05945, 0.78824, 0.04723, 66, 36, 144, 0.1 },
	{ 0.05945, 0.78824, 0.05060, 66, 36, 168, 0.1 },
	{ 0.05945, 0.78824, 0.05112, 66, 36, 180, 0.1 },
	{ 0.05945, 0.77419, 0.07888, 66, 48, 0, 0.1 },
	{ 0.05945, 0.77419, 0.07483, 66, 48, 24, 0.1 },
	{ 0.05945, 0.77419, 0.06526, 66, 48, 48, 0.1 },
	{ 0.05945, 0.77419, 0.05593, 66, 48, 72, 0.1 },
	{ 0.05945, 0.77419, 0.05202, 66, 48, 96, 0.1 },
	{ 0.05945, 0.77419, 0.05599, 66, 48, 120, 0.1 },
	{ 0.05945, 0.77419, 0.06618, 66, 48, 144, 0.1 },
	{ 0.05945, 0.77419, 0.07556, 66, 48, 168, 0.1 },
	{ 0.05945, 0.77419, 0.07706, 66, 48, 180, 0.1 },
	{ 0.05945, 0.74714, 0.11096, 66, 60, 0, 0.1 },
	{ 0.05945, 0.74714, 0.10243, 66, 60, 24, 0.1 },
	{ 0.05945, 0.74714, 0.08724, 66, 60, 48, 0.1 },
	{ 0.05945, 0.74714, 0.07338, 66, 60, 72, 0.1 },
	{ 0.05945, 0.74714, 0.06975, 66, 60, 96, 0.1 },
	{ 0.05945, 0.74714, 0.08121, 66, 60, 120, 0.1 },
	{ 0.05945, 0.74714, 0.10609, 66, 60, 144, 0.1 },
	{ 0.05945, 0.74714, 0.13061, 66, 60, 168, 0.1 },
	{ 0.05945, 0.74714, 0.13464, 66, 60, 180, 0.1 },
	{ 0.05945, 0.72351, 0.13649, 66, 66, 0, 0.1 },
	{ 0.05945, 0.72351, 0.12459, 66, 66, 24, 0.1 },
	{ 0.05945, 0.72351, 0.10533, 66, 66, 48, 0.1 },
	{ 0.05945, 0.72351, 0.08834, 66, 66, 72, 0.1 },
	{ 0.05945, 0.72351, 0.08543, 66, 66, 96, 0.1 },
	{ 0.05945, 0.72351, 0.10367, 66, 66, 120, 0.1 },
	{ 0.05945, 0.72351, 0.14255, 66, 66, 144, 0.1 },
	{ 0.05945, 0.72351, 0.18296, 66, 66, 168, 0.1 },
	{ 0.05945, 0.72351, 0.19003, 66, 66, 180, 0.1 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 0, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 24, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 48, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 72, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 96, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 120, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 144, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 168, 0.2 },
	{ 0.06983, 0.82629, 0.02830, 0, 0, 180, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 0, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 24, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 48, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 72, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 96, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 120, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 144, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 168, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 0, 12, 180, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 0, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 24, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 48, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 72, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 96, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 120, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 144, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 168, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 0, 24, 180, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 0, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 24, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 48, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 72, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 96, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 120, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 144, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 168, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 0, 36, 180, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 0, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 24, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 48, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 72, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 96, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 120, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 144, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 168, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 0, 48, 180, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 0, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 24, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 48, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 72, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 96, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 120, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 144, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 168, 0.2 },
	{ 0.06983, 0.73699, 0.03679, 0, 60, 180, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 0, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 24, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 48, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 72, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 96, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 120, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 144, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 168, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 0, 66, 180, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 0, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 24, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 48, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 72, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 96, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 120, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 144, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 168, 0.2 },
	{ 0.06983, 0.82425, 0.02725, 12, 0, 180, 0.2 },
	{ 0.06983, 0.82222, 0.02956, 12, 12, 0, 0.2 },
	{ 0.06983, 0.82222, 0.02914, 12, 12, 24, 0.2 },
	{ 0.06983, 0.82222, 0.02825, 12, 12, 48, 0.2 },
	{ 0.06983, 0.82222, 0.02750, 12, 12, 72, 0.2 },
	{ 0.06983, 0.82222, 0.02694, 12, 12, 96, 0.2 },
	{ 0.06983, 0.82222, 0.02652, 12, 12, 120, 0.2 },
	{ 0.06983, 0.82222, 0.02619, 12, 12, 144, 0.2 },
	{ 0.06983, 0.82222, 0.02602, 12, 12, 168, 0.2 },
	{ 0.06983, 0.82222, 0.02600, 12, 12, 180, 0.2 },
	{ 0.06983, 0.81562, 0.02979, 12, 24, 0, 0.2 },
	{ 0.06983, 0.81562, 0.02944, 12, 24, 24, 0.2 },
	{ 0.06983, 0.81562, 0.02876, 12, 24, 48, 0.2 },
	{ 0.06983, 0.81562, 0.02797, 12, 24, 72, 0.2 },
	{ 0.06983, 0.81562, 0.02712, 12, 24, 96, 0.2 },
	{ 0.06983, 0.81562, 0.02636, 12, 24, 120, 0.2 },
	{ 0.06983, 0.81562, 0.02580, 12, 24, 144, 0.2 },
	{ 0.06983, 0.81562, 0.02550, 12, 24, 168, 0.2 },
	{ 0.06983, 0.81562, 0.02546, 12, 24, 180, 0.2 },
	{ 0.06983, 0.80270, 0.03133, 12, 36, 0, 0.2 },
	{ 0.06983, 0.80270, 0.03105, 12, 36, 24, 0.2 },
	{ 0.06983, 0.80270, 0.03026, 12, 36, 48, 0.2 },
	{ 0.06983, 0.80270, 0.02917, 12, 36, 72, 0.2 },
	{ 0.06983, 0.80270, 0.02803, 12, 36, 96, 0.2 },
	{ 0.06983, 0.80270, 0.02706, 12, 36, 120, 0.2 },
	{ 0.06983, 0.80270, 0.02638, 12, 36, 144, 0.2 },
	{ 0.06983, 0.80270, 0.02604, 12, 36, 168, 0.2 },
	{ 0.06983, 0.80270, 0.02600, 12, 36, 180, 0.2 },
	{ 0.06983, 0.77928, 0.03445, 12, 48, 0, 0.2 },
	{ 0.06983, 0.77928, 0.03410, 12, 48, 24, 0.2 },
	{ 0.06983, 0.77928, 0.03314, 12, 48, 48, 0.2 },
	{ 0.06983, 0.77928, 0.03189, 12, 48, 72, 0.2 },
	{ 0.06983, 0.77928, 0.03066, 12, 48, 96, 0.2 },
	{ 0.06983, 0.77928, 0.02969, 12, 48, 120, 0.2 },
	{ 0.06983, 0.77928, 0.02907, 12, 48, 144, 0.2 },
	{ 0.06983, 0.77928, 0.02877, 12, 48, 168, 0.2 },
	{ 0.06983, 0.77928, 0.02874, 12, 48, 180, 0.2 },
	{ 0.06983, 0.73517, 0.04095, 12, 60, 0, 0.2 },
	{ 0.06983, 0.73517, 0.04056, 12, 60, 24, 0.2 },
	{ 0.06983, 0.73517, 0.03959, 12, 60, 48, 0.2 },
	{ 0.06983, 0.73517, 0.03836, 12, 60, 72, 0.2 },
	{ 0.06983, 0.73517, 0.03730, 12, 60, 96, 0.2 },
	{ 0.06983, 0.73517, 0.03663, 12, 60, 120, 0.2 },
	{ 0.06983, 0.73517, 0.03635, 12, 60, 144, 0.2 },
	{ 0.06983, 0.73517, 0.03627, 12, 60, 168, 0.2 },
	{ 0.06983, 0.73517, 0.03627, 12, 60, 180, 0.2 },
	{ 0.06983, 0.69790, 0.04698, 12, 66, 0, 0.2 },
	{ 0.06983, 0.69790, 0.04661, 12, 66, 24, 0.2 },
	{ 0.06983, 0.69790, 0.04564, 12, 66, 48, 0.2 },
	{ 0.06983, 0.69790, 0.04455, 12, 66, 72, 0.2 },
	{ 0.06983, 0.69790, 0.04374, 12, 66, 96, 0.2 },
	{ 0.06983, 0.69790, 0.04345, 12, 66, 120, 0.2 },
	{ 0.06983, 0.69790, 0.04357, 12, 66, 144, 0.2 },
	{ 0.06983, 0.69790, 0.04376, 12, 66, 168, 0.2 },
	{ 0.06983, 0.69790, 0.04380, 12, 66, 180, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 0, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 24, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 48, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 72, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 96, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 120, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 144, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 168, 0.2 },
	{ 0.06983, 0.81764, 0.02721, 24, 0, 180, 0.2 },
	{ 0.06983, 0.81562, 0.02979, 24, 12, 0, 0.2 },
	{ 0.06983, 0.81562, 0.02944, 24, 12, 24, 0.2 },
	{ 0.06983, 0.81562, 0.02876, 24, 12, 48, 0.2 },
	{ 0.06983, 0.81562, 0.02797, 24, 12, 72, 0.2 },
	{ 0.06983, 0.81562, 0.02712, 24, 12, 96, 0.2 },
	{ 0.06983, 0.81562, 0.02636, 24, 12, 120, 0.2 },
	{ 0.06983, 0.81562, 0.02580, 24, 12, 144, 0.2 },
	{ 0.06983, 0.81562, 0.02550, 24, 12, 168, 0.2 },
	{ 0.06983, 0.81562, 0.02546, 24, 12, 180, 0.2 },
	{ 0.06983, 0.80908, 0.03382, 24, 24, 0, 0.2 },
	{ 0.06983, 0.80908, 0.03234, 24, 24, 24, 0.2 },
	{ 0.06983, 0.80908, 0.03064, 24, 24, 48, 0.2 },
	{ 0.06983, 0.80908, 0.02906, 24, 24, 72, 0.2 },
	{ 0.06983, 0.80908, 0.02745, 24, 24, 96, 0.2 },
	{ 0.06983, 0.80908, 0.02611, 24, 24, 120, 0.2 },
	{ 0.06983, 0.80908, 0.02520, 24, 24, 144, 0.2 },
	{ 0.06983, 0.80908, 0.02476, 24, 24, 168, 0.2 },
	{ 0.06983, 0.80908, 0.02470, 24, 24, 180, 0.2 },
	{ 0.06983, 0.79626, 0.03592, 24, 36, 0, 0.2 },
	{ 0.06983, 0.79626, 0.03496, 24, 36, 24, 0.2 },
	{ 0.06983, 0.79626, 0.03314, 24, 36, 48, 0.2 },
	{ 0.06983, 0.79626, 0.03085, 24, 36, 72, 0.2 },
	{ 0.06983, 0.79626, 0.02869, 24, 36, 96, 0.2 },
	{ 0.06983, 0.79626, 0.02709, 24, 36, 120, 0.2 },
	{ 0.06983, 0.79626, 0.02612, 24, 36, 144, 0.2 },
	{ 0.06983, 0.79626, 0.02570, 24, 36, 168, 0.2 },
	{ 0.06983, 0.79626, 0.02565, 24, 36, 180, 0.2 },
	{ 0.06983, 0.77302, 0.04031, 24, 48, 0, 0.2 },
	{ 0.06983, 0.77302, 0.03941, 24, 48, 24, 0.2 },
	{ 0.06983, 0.77302, 0.03709, 24, 48, 48, 0.2 },
	{ 0.06983, 0.77302, 0.03428, 24, 48, 72, 0.2 },
	{ 0.06983, 0.77302, 0.03192, 24, 48, 96, 0.2 },
	{ 0.06983, 0.77302, 0.03046, 24, 48, 120, 0.2 },
	{ 0.06983, 0.77302, 0.02988, 24, 48, 144, 0.2 },
	{ 0.06983, 0.77302, 0.02976, 24, 48, 168, 0.2 },
	{ 0.06983, 0.77302, 0.02976, 24, 48, 180, 0.2 },
	{ 0.06983, 0.72927, 0.04850, 24, 60, 0, 0.2 },
	{ 0.06983, 0.72927, 0.04740, 24, 60, 24, 0.2 },
	{ 0.06983, 0.72927, 0.04465, 24, 60, 48, 0.2 },
	{ 0.06983, 0.72927, 0.04163, 24, 60, 72, 0.2 },
	{ 0.06983, 0.72927, 0.03957, 24, 60, 96, 0.2 },
	{ 0.06983, 0.72927, 0.03904, 24, 60, 120, 0.2 },
	{ 0.06983, 0.72927, 0.03969, 24, 60, 144, 0.2 },
	{ 0.06983, 0.72927, 0.04049, 24, 60, 168, 0.2 },
	{ 0.06983, 0.72927, 0.04061, 24, 60, 180, 0.2 },
	{ 0.06983, 0.69230, 0.05552, 24, 66, 0, 0.2 },
	{ 0.06983, 0.69230, 0.05431, 24, 66, 24, 0.2 },
	{ 0.06983, 0.69230, 0.05142, 24, 66, 48, 0.2 },
	{ 0.06983, 0.69230, 0.04842, 24, 66, 72, 0.2 },
	{ 0.06983, 0.69230, 0.04686, 24, 66, 96, 0.2 },
	{ 0.06983, 0.69230, 0.04737, 24, 66, 120, 0.2 },
	{ 0.06983, 0.69230, 0.04929, 24, 66, 144, 0.2 },
	{ 0.06983, 0.69230, 0.05101, 24, 66, 168, 0.2 },
	{ 0.06983, 0.69230, 0.05126, 24, 66, 180, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 0, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 24, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 48, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 72, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 96, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 120, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 144, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 168, 0.2 },
	{ 0.06983, 0.80469, 0.02805, 36, 0, 180, 0.2 },
	{ 0.06983, 0.80270, 0.03133, 36, 12, 0, 0.2 },
	{ 0.06983, 0.80270, 0.03105, 36, 12, 24, 0.2 },
	{ 0.06983, 0.80270, 0.03026, 36, 12, 48, 0.2 },
	{ 0.06983, 0.80270, 0.02917, 36, 12, 72, 0.2 },
	{ 0.06983, 0.80270, 0.02803, 36, 12, 96, 0.2 },
	{ 0.06983, 0.80270, 0.02706, 36, 12, 120, 0.2 },
	{ 0.06983, 0.80270, 0.02638, 36, 12, 144, 0.2 },
	{ 0.06983, 0.80270, 0.02604, 36, 12, 168, 0.2 },
	{ 0.06983, 0.80270, 0.02600, 36, 12, 180, 0.2 },
	{ 0.06983, 0.79626, 0.03591, 36, 24, 0, 0.2 },
	{ 0.06983, 0.79626, 0.03496, 36, 24, 24, 0.2 },
	{ 0.06983, 0.79626, 0.03315, 36, 24, 48, 0.2 },
	{ 0.06983, 0.79626, 0.03085, 36, 24, 72, 0.2 },
	{ 0.06983, 0.79626, 0.02869, 36, 24, 96, 0.2 },
	{ 0.06983, 0.79626, 0.02709, 36, 24, 120, 0.2 },
	{ 0.06983, 0.79626, 0.02612, 36, 24, 144, 0.2 },
	{ 0.06983, 0.79626, 0.02570, 36, 24, 168, 0.2 },
	{ 0.06983, 0.79626, 0.02565, 36, 24, 180, 0.2 },
	{ 0.06983, 0.78365, 0.04291, 36, 36, 0, 0.2 },
	{ 0.06983, 0.78365, 0.04001, 36, 36, 24, 0.2 },
	{ 0.06983, 0.78365, 0.03697, 36, 36, 48, 0.2 },
	{ 0.06983, 0.78365, 0.03349, 36, 36, 72, 0.2 },
	{ 0.06983, 0.78365, 0.03060, 36, 36, 96, 0.2 },
	{ 0.06983, 0.78365, 0.02883, 36, 36, 120, 0.2 },
	{ 0.06983, 0.78365, 0.02811, 36, 36, 144, 0.2 },
	{ 0.06983, 0.78365, 0.02798, 36, 36, 168, 0.2 },
	{ 0.06983, 0.78365, 0.02797, 36, 36, 180, 0.2 },
	{ 0.06983, 0.76078, 0.04869, 36, 48, 0, 0.2 },
	{ 0.06983, 0.76078, 0.04666, 36, 48, 24, 0.2 },
	{ 0.06983, 0.76078, 0.04263, 36, 48, 48, 0.2 },
	{ 0.06983, 0.76078, 0.03812, 36, 48, 72, 0.2 },
	{ 0.06983, 0.76078, 0.03492, 36, 48, 96, 0.2 },
	{ 0.06983, 0.76078, 0.03374, 36, 48, 120, 0.2 },
	{ 0.06983, 0.76078, 0.03421, 36, 48, 144, 0.2 },
	{ 0.06983, 0.76078, 0.03504, 36, 48, 168, 0.2 },
	{ 0.06983, 0.76078, 0.03518, 36, 48, 180, 0.2 },
	{ 0.06983, 0.71772, 0.05986, 36, 60, 0, 0.2 },
	{ 0.06983, 0.71772, 0.05769, 36, 60, 24, 0.2 },
	{ 0.06983, 0.71772, 0.05245, 36, 60, 48, 0.2 },
	{ 0.06983, 0.71772, 0.04717, 36, 60, 72, 0.2 },
	{ 0.06983, 0.71772, 0.04444, 36, 60, 96, 0.2 },
	{ 0.06983, 0.71772, 0.04534, 36, 60, 120, 0.2 },
	{ 0.06983, 0.71772, 0.04893, 36, 60, 144, 0.2 },
	{ 0.06983, 0.71772, 0.05221, 36, 60, 168, 0.2 },
	{ 0.06983, 0.71772, 0.05272, 36, 60, 180, 0.2 },
	{ 0.06983, 0.68134, 0.06920, 36, 66, 0, 0.2 },
	{ 0.06983, 0.68134, 0.06667, 36, 66, 24, 0.2 },
	{ 0.06983, 0.68134, 0.06076, 36, 66, 48, 0.2 },
	{ 0.06983, 0.68134, 0.05520, 36, 66, 72, 0.2 },
	{ 0.06983, 0.68134, 0.05323, 36, 66, 96, 0.2 },
	{ 0.06983, 0.68134, 0.05630, 36, 66, 120, 0.2 },
	{ 0.06983, 0.68134, 0.06299, 36, 66, 144, 0.2 },
	{ 0.06983, 0.68134, 0.06874, 36, 66, 168, 0.2 },
	{ 0.06983, 0.68134, 0.06960, 36, 66, 180, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 0, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 24, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 48, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 72, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 96, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 120, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 144, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 168, 0.2 },
	{ 0.06983, 0.78120, 0.03052, 48, 0, 180, 0.2 },
	{ 0.06983, 0.77928, 0.03445, 48, 12, 0, 0.2 },
	{ 0.06983, 0.77928, 0.03410, 48, 12, 24, 0.2 },
	{ 0.06983, 0.77928, 0.03314, 48, 12, 48, 0.2 },
	{ 0.06983, 0.77928, 0.03189, 48, 12, 72, 0.2 },
	{ 0.06983, 0.77928, 0.03066, 48, 12, 96, 0.2 },
	{ 0.06983, 0.77928, 0.02969, 48, 12, 120, 0.2 },
	{ 0.06983, 0.77928, 0.02907, 48, 12, 144, 0.2 },
	{ 0.06983, 0.77928, 0.02878, 48, 12, 168, 0.2 },
	{ 0.06983, 0.77928, 0.02874, 48, 12, 180, 0.2 },
	{ 0.06983, 0.77302, 0.04031, 48, 24, 0, 0.2 },
	{ 0.06983, 0.77302, 0.03941, 48, 24, 24, 0.2 },
	{ 0.06983, 0.77302, 0.03709, 48, 24, 48, 0.2 },
	{ 0.06983, 0.77302, 0.03428, 48, 24, 72, 0.2 },
	{ 0.06983, 0.77302, 0.03192, 48, 24, 96, 0.2 },
	{ 0.06983, 0.77302, 0.03046, 48, 24, 120, 0.2 },
	{ 0.06983, 0.77302, 0.02988, 48, 24, 144, 0.2 },
	{ 0.06983, 0.77302, 0.02976, 48, 24, 168, 0.2 },
	{ 0.06983, 0.77302, 0.02976, 48, 24, 180, 0.2 },
	{ 0.06983, 0.76078, 0.04869, 48, 36, 0, 0.2 },
	{ 0.06983, 0.76078, 0.04665, 48, 36, 24, 0.2 },
	{ 0.06983, 0.76078, 0.04263, 48, 36, 48, 0.2 },
	{ 0.06983, 0.76078, 0.03812, 48, 36, 72, 0.2 },
	{ 0.06983, 0.76078, 0.03492, 48, 36, 96, 0.2 },
	{ 0.06983, 0.76078, 0.03374, 48, 36, 120, 0.2 },
	{ 0.06983, 0.76078, 0.03421, 48, 36, 144, 0.2 },
	{ 0.06983, 0.76078, 0.03504, 48, 36, 168, 0.2 },
	{ 0.06983, 0.76078, 0.03517, 48, 36, 180, 0.2 },
	{ 0.06983, 0.73858, 0.06200, 48, 48, 0, 0.2 },
	{ 0.06983, 0.73858, 0.05684, 48, 48, 24, 0.2 },
	{ 0.06983, 0.73858, 0.05075, 48, 48, 48, 0.2 },
	{ 0.06983, 0.73858, 0.04454, 48, 48, 72, 0.2 },
	{ 0.06983, 0.73858, 0.04105, 48, 48, 96, 0.2 },
	{ 0.06983, 0.73858, 0.04149, 48, 48, 120, 0.2 },
	{ 0.06983, 0.73858, 0.04485, 48, 48, 144, 0.2 },
	{ 0.06983, 0.73858, 0.04811, 48, 48, 168, 0.2 },
	{ 0.06983, 0.73858, 0.04863, 48, 48, 180, 0.2 },
	{ 0.06983, 0.69678, 0.07716, 48, 60, 0, 0.2 },
	{ 0.06983, 0.69678, 0.07287, 48, 60, 24, 0.2 },
	{ 0.06983, 0.69678, 0.06436, 48, 60, 48, 0.2 },
	{ 0.06983, 0.69678, 0.05645, 48, 60, 72, 0.2 },
	{ 0.06983, 0.69678, 0.05378, 48, 60, 96, 0.2 },
	{ 0.06983, 0.69678, 0.05844, 48, 60, 120, 0.2 },
	{ 0.06983, 0.69678, 0.06882, 48, 60, 144, 0.2 },
	{ 0.06983, 0.69678, 0.07806, 48, 60, 168, 0.2 },
	{ 0.06983, 0.69678, 0.07949, 48, 60, 180, 0.2 },
	{ 0.06983, 0.66145, 0.08999, 48, 66, 0, 0.2 },
	{ 0.06983, 0.66145, 0.08555, 48, 66, 24, 0.2 },
	{ 0.06983, 0.66145, 0.07548, 48, 66, 48, 0.2 },
	{ 0.06983, 0.66145, 0.06669, 48, 66, 72, 0.2 },
	{ 0.06983, 0.66145, 0.06514, 48, 66, 96, 0.2 },
	{ 0.06983, 0.66145, 0.07391, 48, 66, 120, 0.2 },
	{ 0.06983, 0.66145, 0.09105, 48, 66, 144, 0.2 },
	{ 0.06983, 0.66145, 0.10636, 48, 66, 168, 0.2 },
	{ 0.06983, 0.66145, 0.10881, 48, 66, 180, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 0, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 24, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 48, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 72, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 96, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 120, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 144, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 168, 0.2 },
	{ 0.06983, 0.73699, 0.03680, 60, 0, 180, 0.2 },
	{ 0.06983, 0.73517, 0.04096, 60, 12, 0, 0.2 },
	{ 0.06983, 0.73517, 0.04057, 60, 12, 24, 0.2 },
	{ 0.06983, 0.73517, 0.03959, 60, 12, 48, 0.2 },
	{ 0.06983, 0.73517, 0.03836, 60, 12, 72, 0.2 },
	{ 0.06983, 0.73517, 0.03730, 60, 12, 96, 0.2 },
	{ 0.06983, 0.73517, 0.03663, 60, 12, 120, 0.2 },
	{ 0.06983, 0.73517, 0.03636, 60, 12, 144, 0.2 },
	{ 0.06983, 0.73517, 0.03628, 60, 12, 168, 0.2 },
	{ 0.06983, 0.73517, 0.03627, 60, 12, 180, 0.2 },
	{ 0.06983, 0.72927, 0.04850, 60, 24, 0, 0.2 },
	{ 0.06983, 0.72927, 0.04741, 60, 24, 24, 0.2 },
	{ 0.06983, 0.72927, 0.04466, 60, 24, 48, 0.2 },
	{ 0.06983, 0.72927, 0.04164, 60, 24, 72, 0.2 },
	{ 0.06983, 0.72927, 0.03958, 60, 24, 96, 0.2 },
	{ 0.06983, 0.72927, 0.03904, 60, 24, 120, 0.2 },
	{ 0.06983, 0.72927, 0.03969, 60, 24, 144, 0.2 },
	{ 0.06983, 0.72927, 0.04049, 60, 24, 168, 0.2 },
	{ 0.06983, 0.72927, 0.04062, 60, 24, 180, 0.2 },
	{ 0.06983, 0.71772, 0.05986, 60, 36, 0, 0.2 },
	{ 0.06983, 0.71772, 0.05770, 60, 36, 24, 0.2 },
	{ 0.06983, 0.71772, 0.05245, 60, 36, 48, 0.2 },
	{ 0.06983, 0.71772, 0.04717, 60, 36, 72, 0.2 },
	{ 0.06983, 0.71772, 0.04445, 60, 36, 96, 0.2 },
	{ 0.06983, 0.71772, 0.04534, 60, 36, 120, 0.2 },
	{ 0.06983, 0.71772, 0.04893, 60, 36, 144, 0.2 },
	{ 0.06983, 0.71772, 0.05221, 60, 36, 168, 0.2 },
	{ 0.06983, 0.71772, 0.05272, 60, 36, 180, 0.2 },
	{ 0.06983, 0.69678, 0.07716, 60, 48, 0, 0.2 },
	{ 0.06983, 0.69678, 0.07287, 60, 48, 24, 0.2 },
	{ 0.06983, 0.69678, 0.06436, 60, 48, 48, 0.2 },
	{ 0.06983, 0.69678, 0.05646, 60, 48, 72, 0.2 },
	{ 0.06983, 0.69678, 0.05379, 60, 48, 96, 0.2 },
	{ 0.06983, 0.69678, 0.05845, 60, 48, 120, 0.2 },
	{ 0.06983, 0.69678, 0.06882, 60, 48, 144, 0.2 },
	{ 0.06983, 0.69678, 0.07806, 60, 48, 168, 0.2 },
	{ 0.06983, 0.69678, 0.07949, 60, 48, 180, 0.2 },
	{ 0.06983, 0.65734, 0.10732, 60, 60, 0, 0.2 },
	{ 0.06983, 0.65734, 0.09729, 60, 60, 24, 0.2 },
	{ 0.06983, 0.65734, 0.08434, 60, 60, 48, 0.2 },
	{ 0.06983, 0.65734, 0.07334, 60, 60, 72, 0.2 },
	{ 0.06983, 0.65734, 0.07214, 60, 60, 96, 0.2 },
	{ 0.06983, 0.65734, 0.08523, 60, 60, 120, 0.2 },
	{ 0.06983, 0.65734, 0.11095, 60, 60, 144, 0.2 },
	{ 0.06983, 0.65734, 0.13519, 60, 60, 168, 0.2 },
	{ 0.06983, 0.65734, 0.13908, 60, 60, 180, 0.2 },
	{ 0.06983, 0.62402, 0.12700, 60, 66, 0, 0.2 },
	{ 0.06983, 0.62402, 0.11646, 60, 66, 24, 0.2 },
	{ 0.06983, 0.62402, 0.10046, 60, 66, 48, 0.2 },
	{ 0.06983, 0.62402, 0.08756, 60, 66, 72, 0.2 },
	{ 0.06983, 0.62402, 0.08811, 60, 66, 96, 0.2 },
	{ 0.06983, 0.62402, 0.10883, 60, 66, 120, 0.2 },
	{ 0.06983, 0.62402, 0.14904, 60, 66, 144, 0.2 },
	{ 0.06983, 0.62402, 0.18870, 60, 66, 168, 0.2 },
	{ 0.06983, 0.62402, 0.19527, 60, 66, 180, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 0, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 24, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 48, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 72, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 96, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 120, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 144, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 168, 0.2 },
	{ 0.06983, 0.69963, 0.04295, 66, 0, 180, 0.2 },
	{ 0.06983, 0.69790, 0.04698, 66, 12, 0, 0.2 },
	{ 0.06983, 0.69790, 0.04661, 66, 12, 24, 0.2 },
	{ 0.06983, 0.69790, 0.04565, 66, 12, 48, 0.2 },
	{ 0.06983, 0.69790, 0.04455, 66, 12, 72, 0.2 },
	{ 0.06983, 0.69790, 0.04375, 66, 12, 96, 0.2 },
	{ 0.06983, 0.69790, 0.04345, 66, 12, 120, 0.2 },
	{ 0.06983, 0.69790, 0.04357, 66, 12, 144, 0.2 },
	{ 0.06983, 0.69790, 0.04377, 66, 12, 168, 0.2 },
	{ 0.06983, 0.69790, 0.04380, 66, 12, 180, 0.2 },
	{ 0.06983, 0.69230, 0.05553, 66, 24, 0, 0.2 },
	{ 0.06983, 0.69230, 0.05431, 66, 24, 24, 0.2 },
	{ 0.06983, 0.69230, 0.05142, 66, 24, 48, 0.2 },
	{ 0.06983, 0.69230, 0.04843, 66, 24, 72, 0.2 },
	{ 0.06983, 0.69230, 0.04686, 66, 24, 96, 0.2 },
	{ 0.06983, 0.69230, 0.04737, 66, 24, 120, 0.2 },
	{ 0.06983, 0.69230, 0.04929, 66, 24, 144, 0.2 },
	{ 0.06983, 0.69230, 0.05101, 66, 24, 168, 0.2 },
	{ 0.06983, 0.69230, 0.05127, 66, 24, 180, 0.2 },
	{ 0.06983, 0.68134, 0.06920, 66, 36, 0, 0.2 },
	{ 0.06983, 0.68134, 0.06667, 66, 36, 24, 0.2 },
	{ 0.06983, 0.68134, 0.06077, 66, 36, 48, 0.2 },
	{ 0.06983, 0.68134, 0.05520, 66, 36, 72, 0.2 },
	{ 0.06983, 0.68134, 0.05324, 66, 36, 96, 0.2 },
	{ 0.06983, 0.68134, 0.05630, 66, 36, 120, 0.2 },
	{ 0.06983, 0.68134, 0.06299, 66, 36, 144, 0.2 },
	{ 0.06983, 0.68134, 0.06874, 66, 36, 168, 0.2 },
	{ 0.06983, 0.68134, 0.06960, 66, 36, 180, 0.2 },
	{ 0.06983, 0.66145, 0.09000, 66, 48, 0, 0.2 },
	{ 0.06983, 0.66145, 0.08557, 66, 48, 24, 0.2 },
	{ 0.06983, 0.66145, 0.07550, 66, 48, 48, 0.2 },
	{ 0.06983, 0.66145, 0.06671, 66, 48, 72, 0.2 },
	{ 0.06983, 0.66145, 0.06516, 66, 48, 96, 0.2 },
	{ 0.06983, 0.66145, 0.07391, 66, 48, 120, 0.2 },
	{ 0.06983, 0.66145, 0.09105, 66, 48, 144, 0.2 },
	{ 0.06983, 0.66145, 0.10637, 66, 48, 168, 0.2 },
	{ 0.06983, 0.66145, 0.10881, 66, 48, 180, 0.2 },
	{ 0.06983, 0.62402, 0.12701, 66, 60, 0, 0.2 },
	{ 0.06983, 0.62402, 0.11647, 66, 60, 24, 0.2 },
	{ 0.06983, 0.62402, 0.10046, 66, 60, 48, 0.2 },
	{ 0.06983, 0.62402, 0.08756, 66, 60, 72, 0.2 },
	{ 0.06983, 0.62402, 0.08811, 66, 60, 96, 0.2 },
	{ 0.06983, 0.62402, 0.10884, 66, 60, 120, 0.2 },
	{ 0.06983, 0.62402, 0.14904, 66, 60, 144, 0.2 },
	{ 0.06983, 0.62402, 0.18871, 66, 60, 168, 0.2 },
	{ 0.06983, 0.62402, 0.19528, 66, 60, 180, 0.2 },
	{ 0.06983, 0.59238, 0.15585, 66, 66, 0, 0.2 },
	{ 0.06983, 0.59238, 0.14083, 66, 66, 24, 0.2 },
	{ 0.06983, 0.59238, 0.12068, 66, 66, 48, 0.2 },
	{ 0.06983, 0.59238, 0.10507, 66, 66, 72, 0.2 },
	{ 0.06983, 0.59238, 0.10783, 66, 66, 96, 0.2 },
	{ 0.06983, 0.59238, 0.13902, 66, 66, 120, 0.2 },
	{ 0.06983, 0.59238, 0.20085, 66, 66, 144, 0.2 },
	{ 0.06983, 0.59238, 0.26581, 66, 66, 168, 0.2 },
	{ 0.06983, 0.59238, 0.27729, 66, 66, 180, 0.2 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 0, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 24, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 48, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 72, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 96, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 120, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 144, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 168, 0.3 },
	{ 0.07823, 0.76876, 0.03237, 0, 0, 180, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 0, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 24, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 48, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 72, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 96, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 120, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 144, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 168, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 0, 12, 180, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 0, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 24, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 48, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 72, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 96, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 120, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 144, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 168, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 0, 24, 180, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 0, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 24, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 48, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 72, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 96, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 120, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 144, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 168, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 0, 36, 180, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 0, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 24, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 48, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 72, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 96, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 120, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 144, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 168, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 0, 48, 180, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 0, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 24, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 48, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 72, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 96, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 120, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 144, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 168, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 0, 60, 180, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 0, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 24, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 48, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 72, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 96, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 120, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 144, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 168, 0.3 },
	{ 0.07823, 0.61141, 0.04962, 0, 66, 180, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 0, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 24, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 48, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 72, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 96, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 120, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 144, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 168, 0.3 },
	{ 0.07823, 0.76611, 0.03090, 12, 0, 180, 0.3 },
	{ 0.07823, 0.76347, 0.03380, 12, 12, 0, 0.3 },
	{ 0.07823, 0.76347, 0.03324, 12, 12, 24, 0.3 },
	{ 0.07823, 0.76347, 0.03209, 12, 12, 48, 0.3 },
	{ 0.07823, 0.76347, 0.03116, 12, 12, 72, 0.3 },
	{ 0.07823, 0.76347, 0.03052, 12, 12, 96, 0.3 },
	{ 0.07823, 0.76347, 0.03005, 12, 12, 120, 0.3 },
	{ 0.07823, 0.76347, 0.02969, 12, 12, 144, 0.3 },
	{ 0.07823, 0.76347, 0.02951, 12, 12, 168, 0.3 },
	{ 0.07823, 0.76347, 0.02949, 12, 12, 180, 0.3 },
	{ 0.07823, 0.75491, 0.03377, 12, 24, 0, 0.3 },
	{ 0.07823, 0.75491, 0.03335, 12, 24, 24, 0.3 },
	{ 0.07823, 0.75491, 0.03257, 12, 24, 48, 0.3 },
	{ 0.07823, 0.75491, 0.03169, 12, 24, 72, 0.3 },
	{ 0.07823, 0.75491, 0.03078, 12, 24, 96, 0.3 },
	{ 0.07823, 0.75491, 0.02997, 12, 24, 120, 0.3 },
	{ 0.07823, 0.75491, 0.02938, 12, 24, 144, 0.3 },
	{ 0.07823, 0.75491, 0.02906, 12, 24, 168, 0.3 },
	{ 0.07823, 0.75491, 0.02902, 12, 24, 180, 0.3 },
	{ 0.07823, 0.73827, 0.03547, 12, 36, 0, 0.3 },
	{ 0.07823, 0.73827, 0.03517, 12, 36, 24, 0.3 },
	{ 0.07823, 0.73827, 0.03432, 12, 36, 48, 0.3 },
	{ 0.07823, 0.73827, 0.03316, 12, 36, 72, 0.3 },
	{ 0.07823, 0.73827, 0.03198, 12, 36, 96, 0.3 },
	{ 0.07823, 0.73827, 0.03098, 12, 36, 120, 0.3 },
	{ 0.07823, 0.73827, 0.03029, 12, 36, 144, 0.3 },
	{ 0.07823, 0.73827, 0.02996, 12, 36, 168, 0.3 },
	{ 0.07823, 0.73827, 0.02992, 12, 36, 180, 0.3 },
	{ 0.07823, 0.70848, 0.03908, 12, 48, 0, 0.3 },
	{ 0.07823, 0.70848, 0.03871, 12, 48, 24, 0.3 },
	{ 0.07823, 0.70848, 0.03773, 12, 48, 48, 0.3 },
	{ 0.07823, 0.70848, 0.03646, 12, 48, 72, 0.3 },
	{ 0.07823, 0.70848, 0.03527, 12, 48, 96, 0.3 },
	{ 0.07823, 0.70848, 0.03436, 12, 48, 120, 0.3 },
	{ 0.07823, 0.70848, 0.03382, 12, 48, 144, 0.3 },
	{ 0.07823, 0.70848, 0.03358, 12, 48, 168, 0.3 },
	{ 0.07823, 0.70848, 0.03355, 12, 48, 180, 0.3 },
	{ 0.07823, 0.65387, 0.04653, 12, 60, 0, 0.3 },
	{ 0.07823, 0.65387, 0.04615, 12, 60, 24, 0.3 },
	{ 0.07823, 0.65387, 0.04522, 12, 60, 48, 0.3 },
	{ 0.07823, 0.65387, 0.04411, 12, 60, 72, 0.3 },
	{ 0.07823, 0.65387, 0.04324, 12, 60, 96, 0.3 },
	{ 0.07823, 0.65387, 0.04282, 12, 60, 120, 0.3 },
	{ 0.07823, 0.65387, 0.04279, 12, 60, 144, 0.3 },
	{ 0.07823, 0.65387, 0.04286, 12, 60, 168, 0.3 },
	{ 0.07823, 0.65387, 0.04287, 12, 60, 180, 0.3 },
	{ 0.07823, 0.60930, 0.05325, 12, 66, 0, 0.3 },
	{ 0.07823, 0.60930, 0.05292, 12, 66, 24, 0.3 },
	{ 0.07823, 0.60930, 0.05207, 12, 66, 48, 0.3 },
	{ 0.07823, 0.60930, 0.05119, 12, 66, 72, 0.3 },
	{ 0.07823, 0.60930, 0.05071, 12, 66, 96, 0.3 },
	{ 0.07823, 0.60930, 0.05082, 12, 66, 120, 0.3 },
	{ 0.07823, 0.60930, 0.05132, 12, 66, 144, 0.3 },
	{ 0.07823, 0.60930, 0.05175, 12, 66, 168, 0.3 },
	{ 0.07823, 0.60930, 0.05181, 12, 66, 180, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 0, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 24, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 48, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 72, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 96, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 120, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 144, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 168, 0.3 },
	{ 0.07823, 0.75753, 0.03085, 24, 0, 180, 0.3 },
	{ 0.07823, 0.75491, 0.03377, 24, 12, 0, 0.3 },
	{ 0.07823, 0.75491, 0.03335, 24, 12, 24, 0.3 },
	{ 0.07823, 0.75491, 0.03257, 24, 12, 48, 0.3 },
	{ 0.07823, 0.75491, 0.03169, 24, 12, 72, 0.3 },
	{ 0.07823, 0.75491, 0.03078, 24, 12, 96, 0.3 },
	{ 0.07823, 0.75491, 0.02997, 24, 12, 120, 0.3 },
	{ 0.07823, 0.75491, 0.02938, 24, 12, 144, 0.3 },
	{ 0.07823, 0.75491, 0.02906, 24, 12, 168, 0.3 },
	{ 0.07823, 0.75491, 0.02902, 24, 12, 180, 0.3 },
	{ 0.07823, 0.74646, 0.03861, 24, 24, 0, 0.3 },
	{ 0.07823, 0.74646, 0.03668, 24, 24, 24, 0.3 },
	{ 0.07823, 0.74646, 0.03468, 24, 24, 48, 0.3 },
	{ 0.07823, 0.74646, 0.03297, 24, 24, 72, 0.3 },
	{ 0.07823, 0.74646, 0.03126, 24, 24, 96, 0.3 },
	{ 0.07823, 0.74646, 0.02986, 24, 24, 120, 0.3 },
	{ 0.07823, 0.74646, 0.02894, 24, 24, 144, 0.3 },
	{ 0.07823, 0.74646, 0.02851, 24, 24, 168, 0.3 },
	{ 0.07823, 0.74646, 0.02845, 24, 24, 180, 0.3 },
	{ 0.07823, 0.73000, 0.04063, 24, 36, 0, 0.3 },
	{ 0.07823, 0.73000, 0.03951, 24, 36, 24, 0.3 },
	{ 0.07823, 0.73000, 0.03753, 24, 36, 48, 0.3 },
	{ 0.07823, 0.73000, 0.03509, 24, 36, 72, 0.3 },
	{ 0.07823, 0.73000, 0.03288, 24, 36, 96, 0.3 },
	{ 0.07823, 0.73000, 0.03132, 24, 36, 120, 0.3 },
	{ 0.07823, 0.73000, 0.03045, 24, 36, 144, 0.3 },
	{ 0.07823, 0.73000, 0.03009, 24, 36, 168, 0.3 },
	{ 0.07823, 0.73000, 0.03006, 24, 36, 180, 0.3 },
	{ 0.07823, 0.70054, 0.04547, 24, 48, 0, 0.3 },
	{ 0.07823, 0.70054, 0.04450, 24, 48, 24, 0.3 },
	{ 0.07823, 0.70054, 0.04206, 24, 48, 48, 0.3 },
	{ 0.07823, 0.70054, 0.03918, 24, 48, 72, 0.3 },
	{ 0.07823, 0.70054, 0.03692, 24, 48, 96, 0.3 },
	{ 0.07823, 0.70054, 0.03572, 24, 48, 120, 0.3 },
	{ 0.07823, 0.70054, 0.03545, 24, 48, 144, 0.3 },
	{ 0.07823, 0.70054, 0.03555, 24, 48, 168, 0.3 },
	{ 0.07823, 0.70054, 0.03558, 24, 48, 180, 0.3 },
	{ 0.07823, 0.64654, 0.05453, 24, 60, 0, 0.3 },
	{ 0.07823, 0.64654, 0.05341, 24, 60, 24, 0.3 },
	{ 0.07823, 0.64654, 0.05063, 24, 60, 48, 0.3 },
	{ 0.07823, 0.64654, 0.04777, 24, 60, 72, 0.3 },
	{ 0.07823, 0.64654, 0.04615, 24, 60, 96, 0.3 },
	{ 0.07823, 0.64654, 0.04631, 24, 60, 120, 0.3 },
	{ 0.07823, 0.64654, 0.04772, 24, 60, 144, 0.3 },
	{ 0.07823, 0.64654, 0.04904, 24, 60, 168, 0.3 },
	{ 0.07823, 0.64654, 0.04923, 24, 60, 180, 0.3 },
	{ 0.07823, 0.60247, 0.06214, 24, 66, 0, 0.3 },
	{ 0.07823, 0.60247, 0.06092, 24, 66, 24, 0.3 },
	{ 0.07823, 0.60247, 0.05813, 24, 66, 48, 0.3 },
	{ 0.07823, 0.60247, 0.05547, 24, 66, 72, 0.3 },
	{ 0.07823, 0.60247, 0.05461, 24, 66, 96, 0.3 },
	{ 0.07823, 0.60247, 0.05618, 24, 66, 120, 0.3 },
	{ 0.07823, 0.60247, 0.05924, 24, 66, 144, 0.3 },
	{ 0.07823, 0.60247, 0.06173, 24, 66, 168, 0.3 },
	{ 0.07823, 0.60247, 0.06210, 24, 66, 180, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 0, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 24, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 48, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 72, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 96, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 120, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 144, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 168, 0.3 },
	{ 0.07823, 0.74083, 0.03193, 36, 0, 180, 0.3 },
	{ 0.07823, 0.73827, 0.03547, 36, 12, 0, 0.3 },
	{ 0.07823, 0.73827, 0.03517, 36, 12, 24, 0.3 },
	{ 0.07823, 0.73827, 0.03432, 36, 12, 48, 0.3 },
	{ 0.07823, 0.73827, 0.03316, 36, 12, 72, 0.3 },
	{ 0.07823, 0.73827, 0.03198, 36, 12, 96, 0.3 },
	{ 0.07823, 0.73827, 0.03098, 36, 12, 120, 0.3 },
	{ 0.07823, 0.73827, 0.03030, 36, 12, 144, 0.3 },
	{ 0.07823, 0.73827, 0.02996, 36, 12, 168, 0.3 },
	{ 0.07823, 0.73827, 0.02992, 36, 12, 180, 0.3 },
	{ 0.07823, 0.73000, 0.04063, 36, 24, 0, 0.3 },
	{ 0.07823, 0.73000, 0.03951, 36, 24, 24, 0.3 },
	{ 0.07823, 0.73000, 0.03754, 36, 24, 48, 0.3 },
	{ 0.07823, 0.73000, 0.03509, 36, 24, 72, 0.3 },
	{ 0.07823, 0.73000, 0.03288, 36, 24, 96, 0.3 },
	{ 0.07823, 0.73000, 0.03132, 36, 24, 120, 0.3 },
	{ 0.07823, 0.73000, 0.03045, 36, 24, 144, 0.3 },
	{ 0.07823, 0.73000, 0.03009, 36, 24, 168, 0.3 },
	{ 0.07823, 0.73000, 0.03006, 36, 24, 180, 0.3 },
	{ 0.07823, 0.71390, 0.04884, 36, 36, 0, 0.3 },
	{ 0.07823, 0.71390, 0.04518, 36, 36, 24, 0.3 },
	{ 0.07823, 0.71390, 0.04185, 36, 36, 48, 0.3 },
	{ 0.07823, 0.71390, 0.03820, 36, 36, 72, 0.3 },
	{ 0.07823, 0.71390, 0.03534, 36, 36, 96, 0.3 },
	{ 0.07823, 0.71390, 0.03381, 36, 36, 120, 0.3 },
	{ 0.07823, 0.71390, 0.03341, 36, 36, 144, 0.3 },
	{ 0.07823, 0.71390, 0.03352, 36, 36, 168, 0.3 },
	{ 0.07823, 0.71390, 0.03354, 36, 36, 180, 0.3 },
	{ 0.07823, 0.68510, 0.05485, 36, 48, 0, 0.3 },
	{ 0.07823, 0.68510, 0.05253, 36, 48, 24, 0.3 },
	{ 0.07823, 0.68510, 0.04824, 36, 48, 48, 0.3 },
	{ 0.07823, 0.68510, 0.04364, 36, 48, 72, 0.3 },
	{ 0.07823, 0.68510, 0.04074, 36, 48, 96, 0.3 },
	{ 0.07823, 0.68510, 0.04021, 36, 48, 120, 0.3 },
	{ 0.07823, 0.68510, 0.04149, 36, 48, 144, 0.3 },
	{ 0.07823, 0.68510, 0.04290, 36, 48, 168, 0.3 },
	{ 0.07823, 0.68510, 0.04311, 36, 48, 180, 0.3 },
	{ 0.07823, 0.63229, 0.06691, 36, 60, 0, 0.3 },
	{ 0.07823, 0.63229, 0.06463, 36, 60, 24, 0.3 },
	{ 0.07823, 0.63229, 0.05920, 36, 60, 48, 0.3 },
	{ 0.07823, 0.63229, 0.05412, 36, 60, 72, 0.3 },
	{ 0.07823, 0.63229, 0.05222, 36, 60, 96, 0.3 },
	{ 0.07823, 0.63229, 0.05460, 36, 60, 120, 0.3 },
	{ 0.07823, 0.63229, 0.05999, 36, 60, 144, 0.3 },
	{ 0.07823, 0.63229, 0.06461, 36, 60, 168, 0.3 },
	{ 0.07823, 0.63229, 0.06532, 36, 60, 180, 0.3 },
	{ 0.07823, 0.58919, 0.07686, 36, 66, 0, 0.3 },
	{ 0.07823, 0.58919, 0.07423, 36, 66, 24, 0.3 },
	{ 0.07823, 0.58919, 0.06827, 36, 66, 48, 0.3 },
	{ 0.07823, 0.58919, 0.06315, 36, 66, 72, 0.3 },
	{ 0.07823, 0.58919, 0.06245, 36, 66, 96, 0.3 },
	{ 0.07823, 0.58919, 0.06767, 36, 66, 120, 0.3 },
	{ 0.07823, 0.58919, 0.07705, 36, 66, 144, 0.3 },
	{ 0.07823, 0.58919, 0.08481, 36, 66, 168, 0.3 },
	{ 0.07823, 0.58919, 0.08596, 36, 66, 180, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 0, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 24, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 48, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 72, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 96, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 120, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 144, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 168, 0.3 },
	{ 0.07823, 0.71093, 0.03500, 48, 0, 180, 0.3 },
	{ 0.07823, 0.70848, 0.03908, 48, 12, 0, 0.3 },
	{ 0.07823, 0.70848, 0.03871, 48, 12, 24, 0.3 },
	{ 0.07823, 0.70848, 0.03773, 48, 12, 48, 0.3 },
	{ 0.07823, 0.70848, 0.03646, 48, 12, 72, 0.3 },
	{ 0.07823, 0.70848, 0.03526, 48, 12, 96, 0.3 },
	{ 0.07823, 0.70848, 0.03436, 48, 12, 120, 0.3 },
	{ 0.07823, 0.70848, 0.03381, 48, 12, 144, 0.3 },
	{ 0.07823, 0.70848, 0.03358, 48, 12, 168, 0.3 },
	{ 0.07823, 0.70848, 0.03355, 48, 12, 180, 0.3 },
	{ 0.07823, 0.70054, 0.04547, 48, 24, 0, 0.3 },
	{ 0.07823, 0.70054, 0.04450, 48, 24, 24, 0.3 },
	{ 0.07823, 0.70054, 0.04205, 48, 24, 48, 0.3 },
	{ 0.07823, 0.70054, 0.03918, 48, 24, 72, 0.3 },
	{ 0.07823, 0.70054, 0.03692, 48, 24, 96, 0.3 },
	{ 0.07823, 0.70054, 0.03572, 48, 24, 120, 0.3 },
	{ 0.07823, 0.70054, 0.03545, 48, 24, 144, 0.3 },
	{ 0.07823, 0.70054, 0.03555, 48, 24, 168, 0.3 },
	{ 0.07823, 0.70054, 0.03557, 48, 24, 180, 0.3 },
	{ 0.07823, 0.68510, 0.05484, 48, 36, 0, 0.3 },
	{ 0.07823, 0.68510, 0.05252, 48, 36, 24, 0.3 },
	{ 0.07823, 0.68510, 0.04824, 48, 36, 48, 0.3 },
	{ 0.07823, 0.68510, 0.04364, 48, 36, 72, 0.3 },
	{ 0.07823, 0.68510, 0.04073, 48, 36, 96, 0.3 },
	{ 0.07823, 0.68510, 0.04021, 48, 36, 120, 0.3 },
	{ 0.07823, 0.68510, 0.04148, 48, 36, 144, 0.3 },
	{ 0.07823, 0.68510, 0.04289, 48, 36, 168, 0.3 },
	{ 0.07823, 0.68510, 0.04311, 48, 36, 180, 0.3 },
	{ 0.07823, 0.65745, 0.07008, 48, 48, 0, 0.3 },
	{ 0.07823, 0.65745, 0.06379, 48, 48, 24, 0.3 },
	{ 0.07823, 0.65745, 0.05733, 48, 48, 48, 0.3 },
	{ 0.07823, 0.65745, 0.05112, 48, 48, 72, 0.3 },
	{ 0.07823, 0.65745, 0.04833, 48, 48, 96, 0.3 },
	{ 0.07823, 0.65745, 0.05020, 48, 48, 120, 0.3 },
	{ 0.07823, 0.65745, 0.05538, 48, 48, 144, 0.3 },
	{ 0.07823, 0.65745, 0.06001, 48, 48, 168, 0.3 },
	{ 0.07823, 0.65745, 0.06074, 48, 48, 180, 0.3 },
	{ 0.07823, 0.60677, 0.08598, 48, 60, 0, 0.3 },
	{ 0.07823, 0.60677, 0.08123, 48, 60, 24, 0.3 },
	{ 0.07823, 0.60677, 0.07238, 48, 60, 48, 0.3 },
	{ 0.07823, 0.60677, 0.06479, 48, 60, 72, 0.3 },
	{ 0.07823, 0.60677, 0.06363, 48, 60, 96, 0.3 },
	{ 0.07823, 0.60677, 0.07120, 48, 60, 120, 0.3 },
	{ 0.07823, 0.60677, 0.08554, 48, 60, 144, 0.3 },
	{ 0.07823, 0.60677, 0.09798, 48, 60, 168, 0.3 },
	{ 0.07823, 0.60677, 0.09989, 48, 60, 180, 0.3 },
	{ 0.07823, 0.56542, 0.09941, 48, 66, 0, 0.3 },
	{ 0.07823, 0.56542, 0.09473, 48, 66, 24, 0.3 },
	{ 0.07823, 0.56542, 0.08440, 48, 66, 48, 0.3 },
	{ 0.07823, 0.56542, 0.07624, 48, 66, 72, 0.3 },
	{ 0.07823, 0.56542, 0.07684, 48, 66, 96, 0.3 },
	{ 0.07823, 0.56542, 0.08971, 48, 66, 120, 0.3 },
	{ 0.07823, 0.56542, 0.11265, 48, 66, 144, 0.3 },
	{ 0.07823, 0.56542, 0.13281, 48, 66, 168, 0.3 },
	{ 0.07823, 0.56542, 0.13603, 48, 66, 180, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 0, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 24, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 48, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 72, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 96, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 120, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 144, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 168, 0.3 },
	{ 0.07823, 0.65613, 0.04251, 60, 0, 180, 0.3 },
	{ 0.07823, 0.65387, 0.04653, 60, 12, 0, 0.3 },
	{ 0.07823, 0.65387, 0.04614, 60, 12, 24, 0.3 },
	{ 0.07823, 0.65387, 0.04522, 60, 12, 48, 0.3 },
	{ 0.07823, 0.65387, 0.04411, 60, 12, 72, 0.3 },
	{ 0.07823, 0.65387, 0.04324, 60, 12, 96, 0.3 },
	{ 0.07823, 0.65387, 0.04282, 60, 12, 120, 0.3 },
	{ 0.07823, 0.65387, 0.04279, 60, 12, 144, 0.3 },
	{ 0.07823, 0.65387, 0.04285, 60, 12, 168, 0.3 },
	{ 0.07823, 0.65387, 0.04287, 60, 12, 180, 0.3 },
	{ 0.07823, 0.64654, 0.05453, 60, 24, 0, 0.3 },
	{ 0.07823, 0.64654, 0.05340, 60, 24, 24, 0.3 },
	{ 0.07823, 0.64654, 0.05063, 60, 24, 48, 0.3 },
	{ 0.07823, 0.64654, 0.04777, 60, 24, 72, 0.3 },
	{ 0.07823, 0.64654, 0.04615, 60, 24, 96, 0.3 },
	{ 0.07823, 0.64654, 0.04630, 60, 24, 120, 0.3 },
	{ 0.07823, 0.64654, 0.04771, 60, 24, 144, 0.3 },
	{ 0.07823, 0.64654, 0.04903, 60, 24, 168, 0.3 },
	{ 0.07823, 0.64654, 0.04923, 60, 24, 180, 0.3 },
	{ 0.07823, 0.63229, 0.06691, 60, 36, 0, 0.3 },
	{ 0.07823, 0.63229, 0.06462, 60, 36, 24, 0.3 },
	{ 0.07823, 0.63229, 0.05919, 60, 36, 48, 0.3 },
	{ 0.07823, 0.63229, 0.05411, 60, 36, 72, 0.3 },
	{ 0.07823, 0.63229, 0.05221, 60, 36, 96, 0.3 },
	{ 0.07823, 0.63229, 0.05459, 60, 36, 120, 0.3 },
	{ 0.07823, 0.63229, 0.05998, 60, 36, 144, 0.3 },
	{ 0.07823, 0.63229, 0.06460, 60, 36, 168, 0.3 },
	{ 0.07823, 0.63229, 0.06531, 60, 36, 180, 0.3 },
	{ 0.07823, 0.60677, 0.08598, 60, 48, 0, 0.3 },
	{ 0.07823, 0.60677, 0.08123, 60, 48, 24, 0.3 },
	{ 0.07823, 0.60677, 0.07238, 60, 48, 48, 0.3 },
	{ 0.07823, 0.60677, 0.06479, 60, 48, 72, 0.3 },
	{ 0.07823, 0.60677, 0.06364, 60, 48, 96, 0.3 },
	{ 0.07823, 0.60677, 0.07121, 60, 48, 120, 0.3 },
	{ 0.07823, 0.60677, 0.08555, 60, 48, 144, 0.3 },
	{ 0.07823, 0.60677, 0.09798, 60, 48, 168, 0.3 },
	{ 0.07823, 0.60677, 0.09989, 60, 48, 180, 0.3 },
	{ 0.07823, 0.56000, 0.11938, 60, 60, 0, 0.3 },
	{ 0.07823, 0.56000, 0.10766, 60, 60, 24, 0.3 },
	{ 0.07823, 0.56000, 0.09427, 60, 60, 48, 0.3 },
	{ 0.07823, 0.56000, 0.08397, 60, 60, 72, 0.3 },
	{ 0.07823, 0.56000, 0.08549, 60, 60, 96, 0.3 },
	{ 0.07823, 0.56000, 0.10416, 60, 60, 120, 0.3 },
	{ 0.07823, 0.56000, 0.13827, 60, 60, 144, 0.3 },
	{ 0.07823, 0.56000, 0.17011, 60, 60, 168, 0.3 },
	{ 0.07823, 0.56000, 0.17523, 60, 60, 180, 0.3 },
	{ 0.07823, 0.52183, 0.13988, 60, 66, 0, 0.3 },
	{ 0.07823, 0.52183, 0.12797, 60, 66, 24, 0.3 },
	{ 0.07823, 0.52183, 0.11157, 60, 66, 48, 0.3 },
	{ 0.07823, 0.52183, 0.09973, 60, 66, 72, 0.3 },
	{ 0.07823, 0.52183, 0.10394, 60, 66, 96, 0.3 },
	{ 0.07823, 0.52183, 0.13229, 60, 66, 120, 0.3 },
	{ 0.07823, 0.52183, 0.18466, 60, 66, 144, 0.3 },
	{ 0.07823, 0.52183, 0.23604, 60, 66, 168, 0.3 },
	{ 0.07823, 0.52183, 0.24455, 60, 66, 180, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 0, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 24, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 48, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 72, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 96, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 120, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 144, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 168, 0.3 },
	{ 0.07823, 0.61141, 0.04963, 66, 0, 180, 0.3 },
	{ 0.07823, 0.60930, 0.05326, 66, 12, 0, 0.3 },
	{ 0.07823, 0.60930, 0.05293, 66, 12, 24, 0.3 },
	{ 0.07823, 0.60930, 0.05207, 66, 12, 48, 0.3 },
	{ 0.07823, 0.60930, 0.05119, 66, 12, 72, 0.3 },
	{ 0.07823, 0.60930, 0.05072, 66, 12, 96, 0.3 },
	{ 0.07823, 0.60930, 0.05083, 66, 12, 120, 0.3 },
	{ 0.07823, 0.60930, 0.05132, 66, 12, 144, 0.3 },
	{ 0.07823, 0.60930, 0.05175, 66, 12, 168, 0.3 },
	{ 0.07823, 0.60930, 0.05182, 66, 12, 180, 0.3 },
	{ 0.07823, 0.60247, 0.06215, 66, 24, 0, 0.3 },
	{ 0.07823, 0.60247, 0.06093, 66, 24, 24, 0.3 },
	{ 0.07823, 0.60247, 0.05813, 66, 24, 48, 0.3 },
	{ 0.07823, 0.60247, 0.05548, 66, 24, 72, 0.3 },
	{ 0.07823, 0.60247, 0.05462, 66, 24, 96, 0.3 },
	{ 0.07823, 0.60247, 0.05618, 66, 24, 120, 0.3 },
	{ 0.07823, 0.60247, 0.05924, 66, 24, 144, 0.3 },
	{ 0.07823, 0.60247, 0.06174, 66, 24, 168, 0.3 },
	{ 0.07823, 0.60247, 0.06210, 66, 24, 180, 0.3 },
	{ 0.07823, 0.58919, 0.07688, 66, 36, 0, 0.3 },
	{ 0.07823, 0.58919, 0.07424, 66, 36, 24, 0.3 },
	{ 0.07823, 0.58919, 0.06828, 66, 36, 48, 0.3 },
	{ 0.07823, 0.58919, 0.06316, 66, 36, 72, 0.3 },
	{ 0.07823, 0.58919, 0.06246, 66, 36, 96, 0.3 },
	{ 0.07823, 0.58919, 0.06768, 66, 36, 120, 0.3 },
	{ 0.07823, 0.58919, 0.07705, 66, 36, 144, 0.3 },
	{ 0.07823, 0.58919, 0.08481, 66, 36, 168, 0.3 },
	{ 0.07823, 0.58919, 0.08597, 66, 36, 180, 0.3 },
	{ 0.07823, 0.56542, 0.09944, 66, 48, 0, 0.3 },
	{ 0.07823, 0.56542, 0.09476, 66, 48, 24, 0.3 },
	{ 0.07823, 0.56542, 0.08445, 66, 48, 48, 0.3 },
	{ 0.07823, 0.56542, 0.07628, 66, 48, 72, 0.3 },
	{ 0.07823, 0.56542, 0.07687, 66, 48, 96, 0.3 },
	{ 0.07823, 0.56542, 0.08973, 66, 48, 120, 0.3 },
	{ 0.07823, 0.56542, 0.11267, 66, 48, 144, 0.3 },
	{ 0.07823, 0.56542, 0.13284, 66, 48, 168, 0.3 },
	{ 0.07823, 0.56542, 0.13605, 66, 48, 180, 0.3 },
	{ 0.07823, 0.52183, 0.13992, 66, 60, 0, 0.3 },
	{ 0.07823, 0.52183, 0.12800, 66, 60, 24, 0.3 },
	{ 0.07823, 0.52183, 0.11160, 66, 60, 48, 0.3 },
	{ 0.07823, 0.52183, 0.09976, 66, 60, 72, 0.3 },
	{ 0.07823, 0.52183, 0.10397, 66, 60, 96, 0.3 },
	{ 0.07823, 0.52183, 0.13232, 66, 60, 120, 0.3 },
	{ 0.07823, 0.52183, 0.18468, 66, 60, 144, 0.3 },
	{ 0.07823, 0.52183, 0.23607, 66, 60, 168, 0.3 },
	{ 0.07823, 0.52183, 0.24458, 66, 60, 180, 0.3 },
	{ 0.07823, 0.48626, 0.17078, 66, 66, 0, 0.3 },
	{ 0.07823, 0.48626, 0.15369, 66, 66, 24, 0.3 },
	{ 0.07823, 0.48626, 0.13318, 66, 66, 48, 0.3 },
	{ 0.07823, 0.48626, 0.11904, 66, 66, 72, 0.3 },
	{ 0.07823, 0.48626, 0.12658, 66, 66, 96, 0.3 },
	{ 0.07823, 0.48626, 0.16804, 66, 66, 120, 0.3 },
	{ 0.07823, 0.48626, 0.24736, 66, 66, 144, 0.3 },
	{ 0.07823, 0.48626, 0.33057, 66, 66, 168, 0.3 },
	{ 0.07823, 0.48626, 0.34528, 66, 66, 180, 0.3 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 0, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 24, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 48, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 72, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 96, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 120, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 144, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 168, 0.4 },
	{ 0.08515, 0.71429, 0.03620, 0, 0, 180, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 0, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 24, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 48, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 72, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 96, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 120, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 144, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 168, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 0, 12, 180, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 0, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 24, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 48, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 72, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 96, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 120, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 144, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 168, 0.4 },
	{ 0.08515, 0.70087, 0.03432, 0, 24, 180, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 0, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 24, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 48, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 72, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 96, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 120, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 144, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 168, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 0, 36, 180, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 0, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 24, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 48, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 72, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 96, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 120, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 144, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 168, 0.4 },
	{ 0.08515, 0.64618, 0.03926, 0, 48, 180, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 0, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 24, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 48, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 72, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 96, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 120, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 144, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 168, 0.4 },
	{ 0.08515, 0.58391, 0.04780, 0, 60, 180, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 0, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 24, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 48, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 72, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 96, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 120, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 144, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 168, 0.4 },
	{ 0.08515, 0.53483, 0.05561, 0, 66, 180, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 0, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 24, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 48, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 72, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 96, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 120, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 144, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 168, 0.4 },
	{ 0.08515, 0.71111, 0.03438, 12, 0, 180, 0.4 },
	{ 0.08515, 0.70795, 0.03777, 12, 12, 0, 0.4 },
	{ 0.08515, 0.70795, 0.03709, 12, 12, 24, 0.4 },
	{ 0.08515, 0.70795, 0.03572, 12, 12, 48, 0.4 },
	{ 0.08515, 0.70795, 0.03464, 12, 12, 72, 0.4 },
	{ 0.08515, 0.70795, 0.03393, 12, 12, 96, 0.4 },
	{ 0.08515, 0.70795, 0.03343, 12, 12, 120, 0.4 },
	{ 0.08515, 0.70795, 0.03304, 12, 12, 144, 0.4 },
	{ 0.08515, 0.70795, 0.03285, 12, 12, 168, 0.4 },
	{ 0.08515, 0.70795, 0.03283, 12, 12, 180, 0.4 },
	{ 0.08515, 0.69776, 0.03753, 12, 24, 0, 0.4 },
	{ 0.08515, 0.69776, 0.03704, 12, 24, 24, 0.4 },
	{ 0.08515, 0.69776, 0.03618, 12, 24, 48, 0.4 },
	{ 0.08515, 0.69776, 0.03525, 12, 24, 72, 0.4 },
	{ 0.08515, 0.69776, 0.03429, 12, 24, 96, 0.4 },
	{ 0.08515, 0.69776, 0.03343, 12, 24, 120, 0.4 },
	{ 0.08515, 0.69776, 0.03282, 12, 24, 144, 0.4 },
	{ 0.08515, 0.69776, 0.03249, 12, 24, 168, 0.4 },
	{ 0.08515, 0.69776, 0.03245, 12, 24, 180, 0.4 },
	{ 0.08515, 0.67806, 0.03939, 12, 36, 0, 0.4 },
	{ 0.08515, 0.67806, 0.03907, 12, 36, 24, 0.4 },
	{ 0.08515, 0.67806, 0.03818, 12, 36, 48, 0.4 },
	{ 0.08515, 0.67806, 0.03697, 12, 36, 72, 0.4 },
	{ 0.08515, 0.67806, 0.03575, 12, 36, 96, 0.4 },
	{ 0.08515, 0.67806, 0.03475, 12, 36, 120, 0.4 },
	{ 0.08515, 0.67806, 0.03407, 12, 36, 144, 0.4 },
	{ 0.08515, 0.67806, 0.03375, 12, 36, 168, 0.4 },
	{ 0.08515, 0.67806, 0.03371, 12, 36, 180, 0.4 },
	{ 0.08515, 0.64331, 0.04343, 12, 48, 0, 0.4 },
	{ 0.08515, 0.64331, 0.04306, 12, 48, 24, 0.4 },
	{ 0.08515, 0.64331, 0.04206, 12, 48, 48, 0.4 },
	{ 0.08515, 0.64331, 0.04079, 12, 48, 72, 0.4 },
	{ 0.08515, 0.64331, 0.03964, 12, 48, 96, 0.4 },
	{ 0.08515, 0.64331, 0.03881, 12, 48, 120, 0.4 },
	{ 0.08515, 0.64331, 0.03835, 12, 48, 144, 0.4 },
	{ 0.08515, 0.64331, 0.03817, 12, 48, 168, 0.4 },
	{ 0.08515, 0.64331, 0.03815, 12, 48, 180, 0.4 },
	{ 0.08515, 0.58131, 0.05164, 12, 60, 0, 0.4 },
	{ 0.08515, 0.58131, 0.05126, 12, 60, 24, 0.4 },
	{ 0.08515, 0.58131, 0.05040, 12, 60, 48, 0.4 },
	{ 0.08515, 0.58131, 0.04941, 12, 60, 72, 0.4 },
	{ 0.08515, 0.58131, 0.04873, 12, 60, 96, 0.4 },
	{ 0.08515, 0.58131, 0.04855, 12, 60, 120, 0.4 },
	{ 0.08515, 0.58131, 0.04874, 12, 60, 144, 0.4 },
	{ 0.08515, 0.58131, 0.04895, 12, 60, 168, 0.4 },
	{ 0.08515, 0.58131, 0.04898, 12, 60, 180, 0.4 },
	{ 0.08515, 0.53246, 0.05884, 12, 66, 0, 0.4 },
	{ 0.08515, 0.53246, 0.05854, 12, 66, 24, 0.4 },
	{ 0.08515, 0.53246, 0.05779, 12, 66, 48, 0.4 },
	{ 0.08515, 0.53246, 0.05712, 12, 66, 72, 0.4 },
	{ 0.08515, 0.53246, 0.05695, 12, 66, 96, 0.4 },
	{ 0.08515, 0.53246, 0.05741, 12, 66, 120, 0.4 },
	{ 0.08515, 0.53246, 0.05825, 12, 66, 144, 0.4 },
	{ 0.08515, 0.53246, 0.05888, 12, 66, 168, 0.4 },
	{ 0.08515, 0.53246, 0.05898, 12, 66, 180, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 0, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 24, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 48, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 72, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 96, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 120, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 144, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 168, 0.4 },
	{ 0.08515, 0.70087, 0.03433, 24, 0, 180, 0.4 },
	{ 0.08515, 0.69776, 0.03753, 24, 12, 0, 0.4 },
	{ 0.08515, 0.69776, 0.03705, 24, 12, 24, 0.4 },
	{ 0.08515, 0.69776, 0.03618, 24, 12, 48, 0.4 },
	{ 0.08515, 0.69776, 0.03525, 24, 12, 72, 0.4 },
	{ 0.08515, 0.69776, 0.03429, 24, 12, 96, 0.4 },
	{ 0.08515, 0.69776, 0.03344, 24, 12, 120, 0.4 },
	{ 0.08515, 0.69776, 0.03283, 24, 12, 144, 0.4 },
	{ 0.08515, 0.69776, 0.03249, 24, 12, 168, 0.4 },
	{ 0.08515, 0.69776, 0.03245, 24, 12, 180, 0.4 },
	{ 0.08515, 0.68771, 0.04307, 24, 24, 0, 0.4 },
	{ 0.08515, 0.68771, 0.04077, 24, 24, 24, 0.4 },
	{ 0.08515, 0.68771, 0.03851, 24, 24, 48, 0.4 },
	{ 0.08515, 0.68771, 0.03670, 24, 24, 72, 0.4 },
	{ 0.08515, 0.68771, 0.03492, 24, 24, 96, 0.4 },
	{ 0.08515, 0.68771, 0.03349, 24, 24, 120, 0.4 },
	{ 0.08515, 0.68771, 0.03257, 24, 24, 144, 0.4 },
	{ 0.08515, 0.68771, 0.03215, 24, 24, 168, 0.4 },
	{ 0.08515, 0.68771, 0.03210, 24, 24, 180, 0.4 },
	{ 0.08515, 0.66830, 0.04505, 24, 36, 0, 0.4 },
	{ 0.08515, 0.66830, 0.04379, 24, 36, 24, 0.4 },
	{ 0.08515, 0.66830, 0.04169, 24, 36, 48, 0.4 },
	{ 0.08515, 0.66830, 0.03914, 24, 36, 72, 0.4 },
	{ 0.08515, 0.66830, 0.03690, 24, 36, 96, 0.4 },
	{ 0.08515, 0.66830, 0.03540, 24, 36, 120, 0.4 },
	{ 0.08515, 0.66830, 0.03463, 24, 36, 144, 0.4 },
	{ 0.08515, 0.66830, 0.03435, 24, 36, 168, 0.4 },
	{ 0.08515, 0.66830, 0.03432, 24, 36, 180, 0.4 },
	{ 0.08515, 0.63405, 0.05027, 24, 48, 0, 0.4 },
	{ 0.08515, 0.63405, 0.04925, 24, 48, 24, 0.4 },
	{ 0.08515, 0.63405, 0.04671, 24, 48, 48, 0.4 },
	{ 0.08515, 0.63405, 0.04382, 24, 48, 72, 0.4 },
	{ 0.08515, 0.63405, 0.04168, 24, 48, 96, 0.4 },
	{ 0.08515, 0.63405, 0.04075, 24, 48, 120, 0.4 },
	{ 0.08515, 0.63405, 0.04077, 24, 48, 144, 0.4 },
	{ 0.08515, 0.63405, 0.04108, 24, 48, 168, 0.4 },
	{ 0.08515, 0.63405, 0.04113, 24, 48, 180, 0.4 },
	{ 0.08515, 0.57294, 0.05999, 24, 60, 0, 0.4 },
	{ 0.08515, 0.57294, 0.05885, 24, 60, 24, 0.4 },
	{ 0.08515, 0.57294, 0.05609, 24, 60, 48, 0.4 },
	{ 0.08515, 0.57294, 0.05341, 24, 60, 72, 0.4 },
	{ 0.08515, 0.57294, 0.05222, 24, 60, 96, 0.4 },
	{ 0.08515, 0.57294, 0.05302, 24, 60, 120, 0.4 },
	{ 0.08515, 0.57294, 0.05511, 24, 60, 144, 0.4 },
	{ 0.08515, 0.57294, 0.05689, 24, 60, 168, 0.4 },
	{ 0.08515, 0.57294, 0.05715, 24, 60, 180, 0.4 },
	{ 0.08515, 0.52479, 0.06796, 24, 66, 0, 0.4 },
	{ 0.08515, 0.52479, 0.06676, 24, 66, 24, 0.4 },
	{ 0.08515, 0.52479, 0.06408, 24, 66, 48, 0.4 },
	{ 0.08515, 0.52479, 0.06176, 24, 66, 72, 0.4 },
	{ 0.08515, 0.52479, 0.06155, 24, 66, 96, 0.4 },
	{ 0.08515, 0.52479, 0.06404, 24, 66, 120, 0.4 },
	{ 0.08515, 0.52479, 0.06808, 24, 66, 144, 0.4 },
	{ 0.08515, 0.52479, 0.07124, 24, 66, 168, 0.4 },
	{ 0.08515, 0.52479, 0.07170, 24, 66, 180, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 0, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 24, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 48, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 72, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 96, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 120, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 144, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 168, 0.4 },
	{ 0.08515, 0.68109, 0.03565, 36, 0, 180, 0.4 },
	{ 0.08515, 0.67806, 0.03939, 36, 12, 0, 0.4 },
	{ 0.08515, 0.67806, 0.03908, 36, 12, 24, 0.4 },
	{ 0.08515, 0.67806, 0.03818, 36, 12, 48, 0.4 },
	{ 0.08515, 0.67806, 0.03698, 36, 12, 72, 0.4 },
	{ 0.08515, 0.67806, 0.03576, 36, 12, 96, 0.4 },
	{ 0.08515, 0.67806, 0.03476, 36, 12, 120, 0.4 },
	{ 0.08515, 0.67806, 0.03407, 36, 12, 144, 0.4 },
	{ 0.08515, 0.67806, 0.03375, 36, 12, 168, 0.4 },
	{ 0.08515, 0.67806, 0.03371, 36, 12, 180, 0.4 },
	{ 0.08515, 0.66830, 0.04505, 36, 24, 0, 0.4 },
	{ 0.08515, 0.66830, 0.04379, 36, 24, 24, 0.4 },
	{ 0.08515, 0.66830, 0.04169, 36, 24, 48, 0.4 },
	{ 0.08515, 0.66830, 0.03914, 36, 24, 72, 0.4 },
	{ 0.08515, 0.66830, 0.03690, 36, 24, 96, 0.4 },
	{ 0.08515, 0.66830, 0.03540, 36, 24, 120, 0.4 },
	{ 0.08515, 0.66830, 0.03463, 36, 24, 144, 0.4 },
	{ 0.08515, 0.66830, 0.03435, 36, 24, 168, 0.4 },
	{ 0.08515, 0.66830, 0.03432, 36, 24, 180, 0.4 },
	{ 0.08515, 0.64944, 0.05428, 36, 36, 0, 0.4 },
	{ 0.08515, 0.64944, 0.04999, 36, 36, 24, 0.4 },
	{ 0.08515, 0.64944, 0.04643, 36, 36, 48, 0.4 },
	{ 0.08515, 0.64944, 0.04267, 36, 36, 72, 0.4 },
	{ 0.08515, 0.64944, 0.03989, 36, 36, 96, 0.4 },
	{ 0.08515, 0.64944, 0.03861, 36, 36, 120, 0.4 },
	{ 0.08515, 0.64944, 0.03852, 36, 36, 144, 0.4 },
	{ 0.08515, 0.64944, 0.03885, 36, 36, 168, 0.4 },
	{ 0.08515, 0.64944, 0.03890, 36, 36, 180, 0.4 },
	{ 0.08515, 0.61615, 0.06047, 36, 48, 0, 0.4 },
	{ 0.08515, 0.61615, 0.05793, 36, 48, 24, 0.4 },
	{ 0.08515, 0.61615, 0.05345, 36, 48, 48, 0.4 },
	{ 0.08515, 0.61615, 0.04884, 36, 48, 72, 0.4 },
	{ 0.08515, 0.61615, 0.04625, 36, 48, 96, 0.4 },
	{ 0.08515, 0.61615, 0.04635, 36, 48, 120, 0.4 },
	{ 0.08515, 0.61615, 0.04838, 36, 48, 144, 0.4 },
	{ 0.08515, 0.61615, 0.05031, 36, 48, 168, 0.4 },
	{ 0.08515, 0.61615, 0.05060, 36, 48, 180, 0.4 },
	{ 0.08515, 0.55677, 0.07319, 36, 60, 0, 0.4 },
	{ 0.08515, 0.55677, 0.07082, 36, 60, 24, 0.4 },
	{ 0.08515, 0.55677, 0.06530, 36, 60, 48, 0.4 },
	{ 0.08515, 0.55677, 0.06046, 36, 60, 72, 0.4 },
	{ 0.08515, 0.55677, 0.05934, 36, 60, 96, 0.4 },
	{ 0.08515, 0.55677, 0.06305, 36, 60, 120, 0.4 },
	{ 0.08515, 0.55677, 0.07004, 36, 60, 144, 0.4 },
	{ 0.08515, 0.55677, 0.07582, 36, 60, 168, 0.4 },
	{ 0.08515, 0.55677, 0.07669, 36, 60, 180, 0.4 },
	{ 0.08515, 0.50998, 0.08349, 36, 66, 0, 0.4 },
	{ 0.08515, 0.50998, 0.08080, 36, 66, 24, 0.4 },
	{ 0.08515, 0.50998, 0.07486, 36, 66, 48, 0.4 },
	{ 0.08515, 0.50998, 0.07020, 36, 66, 72, 0.4 },
	{ 0.08515, 0.50998, 0.07063, 36, 66, 96, 0.4 },
	{ 0.08515, 0.50998, 0.07772, 36, 66, 120, 0.4 },
	{ 0.08515, 0.50998, 0.08935, 36, 66, 144, 0.4 },
	{ 0.08515, 0.50998, 0.09879, 36, 66, 168, 0.4 },
	{ 0.08515, 0.50998, 0.10018, 36, 66, 180, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 0, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 24, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 48, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 72, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 96, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 120, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 144, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 168, 0.4 },
	{ 0.08515, 0.64618, 0.03925, 48, 0, 180, 0.4 },
	{ 0.08515, 0.64331, 0.04342, 48, 12, 0, 0.4 },
	{ 0.08515, 0.64331, 0.04305, 48, 12, 24, 0.4 },
	{ 0.08515, 0.64331, 0.04205, 48, 12, 48, 0.4 },
	{ 0.08515, 0.64331, 0.04078, 48, 12, 72, 0.4 },
	{ 0.08515, 0.64331, 0.03963, 48, 12, 96, 0.4 },
	{ 0.08515, 0.64331, 0.03880, 48, 12, 120, 0.4 },
	{ 0.08515, 0.64331, 0.03834, 48, 12, 144, 0.4 },
	{ 0.08515, 0.64331, 0.03816, 48, 12, 168, 0.4 },
	{ 0.08515, 0.64331, 0.03814, 48, 12, 180, 0.4 },
	{ 0.08515, 0.63405, 0.05025, 48, 24, 0, 0.4 },
	{ 0.08515, 0.63405, 0.04924, 48, 24, 24, 0.4 },
	{ 0.08515, 0.63405, 0.04670, 48, 24, 48, 0.4 },
	{ 0.08515, 0.63405, 0.04380, 48, 24, 72, 0.4 },
	{ 0.08515, 0.63405, 0.04166, 48, 24, 96, 0.4 },
	{ 0.08515, 0.63405, 0.04073, 48, 24, 120, 0.4 },
	{ 0.08515, 0.63405, 0.04076, 48, 24, 144, 0.4 },
	{ 0.08515, 0.63405, 0.04106, 48, 24, 168, 0.4 },
	{ 0.08515, 0.63405, 0.04111, 48, 24, 180, 0.4 },
	{ 0.08515, 0.61615, 0.06044, 48, 36, 0, 0.4 },
	{ 0.08515, 0.61615, 0.05790, 48, 36, 24, 0.4 },
	{ 0.08515, 0.61615, 0.05343, 48, 36, 48, 0.4 },
	{ 0.08515, 0.61615, 0.04882, 48, 36, 72, 0.4 },
	{ 0.08515, 0.61615, 0.04622, 48, 36, 96, 0.4 },
	{ 0.08515, 0.61615, 0.04632, 48, 36, 120, 0.4 },
	{ 0.08515, 0.61615, 0.04835, 48, 36, 144, 0.4 },
	{ 0.08515, 0.61615, 0.05029, 48, 36, 168, 0.4 },
	{ 0.08515, 0.61615, 0.05058, 48, 36, 180, 0.4 },
	{ 0.08515, 0.58457, 0.07723, 48, 48, 0, 0.4 },
	{ 0.08515, 0.58457, 0.07005, 48, 48, 24, 0.4 },
	{ 0.08515, 0.58457, 0.06333, 48, 48, 48, 0.4 },
	{ 0.08515, 0.58457, 0.05721, 48, 48, 72, 0.4 },
	{ 0.08515, 0.58457, 0.05511, 48, 48, 96, 0.4 },
	{ 0.08515, 0.58457, 0.05829, 48, 48, 120, 0.4 },
	{ 0.08515, 0.58457, 0.06511, 48, 48, 144, 0.4 },
	{ 0.08515, 0.58457, 0.07096, 48, 48, 168, 0.4 },
	{ 0.08515, 0.58457, 0.07186, 48, 48, 180, 0.4 },
	{ 0.08515, 0.52823, 0.09360, 48, 60, 0, 0.4 },
	{ 0.08515, 0.52823, 0.08852, 48, 60, 24, 0.4 },
	{ 0.08515, 0.52823, 0.07947, 48, 60, 48, 0.4 },
	{ 0.08515, 0.52823, 0.07228, 48, 60, 72, 0.4 },
	{ 0.08515, 0.52823, 0.07250, 48, 60, 96, 0.4 },
	{ 0.08515, 0.52823, 0.08262, 48, 60, 120, 0.4 },
	{ 0.08515, 0.52823, 0.10033, 48, 60, 144, 0.4 },
	{ 0.08515, 0.52823, 0.11544, 48, 60, 168, 0.4 },
	{ 0.08515, 0.52823, 0.11775, 48, 60, 180, 0.4 },
	{ 0.08515, 0.48384, 0.10731, 48, 66, 0, 0.4 },
	{ 0.08515, 0.48384, 0.10248, 48, 66, 24, 0.4 },
	{ 0.08515, 0.48384, 0.09206, 48, 66, 48, 0.4 },
	{ 0.08515, 0.48384, 0.08456, 48, 66, 72, 0.4 },
	{ 0.08515, 0.48384, 0.08704, 48, 66, 96, 0.4 },
	{ 0.08515, 0.48384, 0.10337, 48, 66, 120, 0.4 },
	{ 0.08515, 0.48384, 0.13104, 48, 66, 144, 0.4 },
	{ 0.08515, 0.48384, 0.15511, 48, 66, 168, 0.4 },
	{ 0.08515, 0.48384, 0.15894, 48, 66, 180, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 0, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 24, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 48, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 72, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 96, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 120, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 144, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 168, 0.4 },
	{ 0.08515, 0.58391, 0.04779, 60, 0, 180, 0.4 },
	{ 0.08515, 0.58131, 0.05163, 60, 12, 0, 0.4 },
	{ 0.08515, 0.58131, 0.05126, 60, 12, 24, 0.4 },
	{ 0.08515, 0.58131, 0.05039, 60, 12, 48, 0.4 },
	{ 0.08515, 0.58131, 0.04940, 60, 12, 72, 0.4 },
	{ 0.08515, 0.58131, 0.04872, 60, 12, 96, 0.4 },
	{ 0.08515, 0.58131, 0.04854, 60, 12, 120, 0.4 },
	{ 0.08515, 0.58131, 0.04873, 60, 12, 144, 0.4 },
	{ 0.08515, 0.58131, 0.04893, 60, 12, 168, 0.4 },
	{ 0.08515, 0.58131, 0.04897, 60, 12, 180, 0.4 },
	{ 0.08515, 0.57294, 0.05997, 60, 24, 0, 0.4 },
	{ 0.08515, 0.57294, 0.05884, 60, 24, 24, 0.4 },
	{ 0.08515, 0.57294, 0.05607, 60, 24, 48, 0.4 },
	{ 0.08515, 0.57294, 0.05339, 60, 24, 72, 0.4 },
	{ 0.08515, 0.57294, 0.05220, 60, 24, 96, 0.4 },
	{ 0.08515, 0.57294, 0.05299, 60, 24, 120, 0.4 },
	{ 0.08515, 0.57294, 0.05508, 60, 24, 144, 0.4 },
	{ 0.08515, 0.57294, 0.05687, 60, 24, 168, 0.4 },
	{ 0.08515, 0.57294, 0.05712, 60, 24, 180, 0.4 },
	{ 0.08515, 0.55677, 0.07316, 60, 36, 0, 0.4 },
	{ 0.08515, 0.55677, 0.07079, 60, 36, 24, 0.4 },
	{ 0.08515, 0.55677, 0.06527, 60, 36, 48, 0.4 },
	{ 0.08515, 0.55677, 0.06044, 60, 36, 72, 0.4 },
	{ 0.08515, 0.55677, 0.05932, 60, 36, 96, 0.4 },
	{ 0.08515, 0.55677, 0.06302, 60, 36, 120, 0.4 },
	{ 0.08515, 0.55677, 0.07001, 60, 36, 144, 0.4 },
	{ 0.08515, 0.55677, 0.07578, 60, 36, 168, 0.4 },
	{ 0.08515, 0.55677, 0.07666, 60, 36, 180, 0.4 },
	{ 0.08515, 0.52823, 0.09361, 60, 48, 0, 0.4 },
	{ 0.08515, 0.52823, 0.08853, 60, 48, 24, 0.4 },
	{ 0.08515, 0.52823, 0.07948, 60, 48, 48, 0.4 },
	{ 0.08515, 0.52823, 0.07229, 60, 48, 72, 0.4 },
	{ 0.08515, 0.52823, 0.07251, 60, 48, 96, 0.4 },
	{ 0.08515, 0.52823, 0.08262, 60, 48, 120, 0.4 },
	{ 0.08515, 0.52823, 0.10034, 60, 48, 144, 0.4 },
	{ 0.08515, 0.52823, 0.11544, 60, 48, 168, 0.4 },
	{ 0.08515, 0.52823, 0.11775, 60, 48, 180, 0.4 },
	{ 0.08515, 0.47733, 0.12929, 60, 60, 0, 0.4 },
	{ 0.08515, 0.47733, 0.11637, 60, 60, 24, 0.4 },
	{ 0.08515, 0.47733, 0.10277, 60, 60, 48, 0.4 },
	{ 0.08515, 0.47733, 0.09323, 60, 60, 72, 0.4 },
	{ 0.08515, 0.47733, 0.09713, 60, 60, 96, 0.4 },
	{ 0.08515, 0.47733, 0.12044, 60, 60, 120, 0.4 },
	{ 0.08515, 0.47733, 0.16137, 60, 60, 144, 0.4 },
	{ 0.08515, 0.47733, 0.19926, 60, 60, 168, 0.4 },
	{ 0.08515, 0.47733, 0.20534, 60, 60, 180, 0.4 },
	{ 0.08515, 0.43721, 0.15014, 60, 66, 0, 0.4 },
	{ 0.08515, 0.43721, 0.13729, 60, 66, 24, 0.4 },
	{ 0.08515, 0.43721, 0.12077, 60, 66, 48, 0.4 },
	{ 0.08515, 0.43721, 0.11001, 60, 66, 72, 0.4 },
	{ 0.08515, 0.43721, 0.11732, 60, 66, 96, 0.4 },
	{ 0.08515, 0.43721, 0.15180, 60, 66, 120, 0.4 },
	{ 0.08515, 0.43721, 0.21365, 60, 66, 144, 0.4 },
	{ 0.08515, 0.43721, 0.27401, 60, 66, 168, 0.4 },
	{ 0.08515, 0.43721, 0.28399, 60, 66, 180, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 0, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 24, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 48, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 72, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 96, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 120, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 144, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 168, 0.4 },
	{ 0.08515, 0.53483, 0.05560, 66, 0, 180, 0.4 },
	{ 0.08515, 0.53246, 0.05883, 66, 12, 0, 0.4 },
	{ 0.08515, 0.53246, 0.05853, 66, 12, 24, 0.4 },
	{ 0.08515, 0.53246, 0.05779, 66, 12, 48, 0.4 },
	{ 0.08515, 0.53246, 0.05711, 66, 12, 72, 0.4 },
	{ 0.08515, 0.53246, 0.05694, 66, 12, 96, 0.4 },
	{ 0.08515, 0.53246, 0.05741, 66, 12, 120, 0.4 },
	{ 0.08515, 0.53246, 0.05823, 66, 12, 144, 0.4 },
	{ 0.08515, 0.53246, 0.05887, 66, 12, 168, 0.4 },
	{ 0.08515, 0.53246, 0.05897, 66, 12, 180, 0.4 },
	{ 0.08515, 0.52479, 0.06795, 66, 24, 0, 0.4 },
	{ 0.08515, 0.52479, 0.06675, 66, 24, 24, 0.4 },
	{ 0.08515, 0.52479, 0.06406, 66, 24, 48, 0.4 },
	{ 0.08515, 0.52479, 0.06174, 66, 24, 72, 0.4 },
	{ 0.08515, 0.52479, 0.06153, 66, 24, 96, 0.4 },
	{ 0.08515, 0.52479, 0.06401, 66, 24, 120, 0.4 },
	{ 0.08515, 0.52479, 0.06805, 66, 24, 144, 0.4 },
	{ 0.08515, 0.52479, 0.07121, 66, 24, 168, 0.4 },
	{ 0.08515, 0.52479, 0.07167, 66, 24, 180, 0.4 },
	{ 0.08515, 0.50998, 0.08347, 66, 36, 0, 0.4 },
	{ 0.08515, 0.50998, 0.08078, 66, 36, 24, 0.4 },
	{ 0.08515, 0.50998, 0.07484, 66, 36, 48, 0.4 },
	{ 0.08515, 0.50998, 0.07018, 66, 36, 72, 0.4 },
	{ 0.08515, 0.50998, 0.07060, 66, 36, 96, 0.4 },
	{ 0.08515, 0.50998, 0.07769, 66, 36, 120, 0.4 },
	{ 0.08515, 0.50998, 0.08931, 66, 36, 144, 0.4 },
	{ 0.08515, 0.50998, 0.09875, 66, 36, 168, 0.4 },
	{ 0.08515, 0.50998, 0.10015, 66, 36, 180, 0.4 },
	{ 0.08515, 0.48384, 0.10733, 66, 48, 0, 0.4 },
	{ 0.08515, 0.48384, 0.10250, 66, 48, 24, 0.4 },
	{ 0.08515, 0.48384, 0.09210, 66, 48, 48, 0.4 },
	{ 0.08515, 0.48384, 0.08459, 66, 48, 72, 0.4 },
	{ 0.08515, 0.48384, 0.08707, 66, 48, 96, 0.4 },
	{ 0.08515, 0.48384, 0.10338, 66, 48, 120, 0.4 },
	{ 0.08515, 0.48384, 0.13105, 66, 48, 144, 0.4 },
	{ 0.08515, 0.48384, 0.15512, 66, 48, 168, 0.4 },
	{ 0.08515, 0.48384, 0.15895, 66, 48, 180, 0.4 },
	{ 0.08515, 0.43721, 0.15016, 66, 60, 0, 0.4 },
	{ 0.08515, 0.43721, 0.13730, 66, 60, 24, 0.4 },
	{ 0.08515, 0.43721, 0.12079, 66, 60, 48, 0.4 },
	{ 0.08515, 0.43721, 0.11002, 66, 60, 72, 0.4 },
	{ 0.08515, 0.43721, 0.11733, 66, 60, 96, 0.4 },
	{ 0.08515, 0.43721, 0.15181, 66, 60, 120, 0.4 },
	{ 0.08515, 0.43721, 0.21364, 66, 60, 144, 0.4 },
	{ 0.08515, 0.43721, 0.27401, 66, 60, 168, 0.4 },
	{ 0.08515, 0.43721, 0.28400, 66, 60, 180, 0.4 },
	{ 0.08515, 0.40047, 0.18213, 66, 66, 0, 0.4 },
	{ 0.08515, 0.40047, 0.16368, 66, 66, 24, 0.4 },
	{ 0.08515, 0.40047, 0.14314, 66, 66, 48, 0.4 },
	{ 0.08515, 0.40047, 0.13042, 66, 66, 72, 0.4 },
	{ 0.08515, 0.40047, 0.14188, 66, 66, 96, 0.4 },
	{ 0.08515, 0.40047, 0.19133, 66, 66, 120, 0.4 },
	{ 0.08515, 0.40047, 0.28380, 66, 66, 144, 0.4 },
	{ 0.08515, 0.40047, 0.38043, 66, 66, 168, 0.4 },
	{ 0.08515, 0.40047, 0.39750, 66, 66, 180, 0.4 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 0, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 24, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 48, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 72, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 96, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 120, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 144, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 168, 0.5 },
	{ 0.09094, 0.66283, 0.03979, 0, 0, 180, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 0, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 24, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 48, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 72, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 96, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 120, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 144, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 168, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 0, 12, 180, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 0, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 24, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 48, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 72, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 96, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 120, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 144, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 168, 0.5 },
	{ 0.09094, 0.64762, 0.03763, 0, 24, 180, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 0, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 24, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 48, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 72, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 96, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 120, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 144, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 168, 0.5 },
	{ 0.09094, 0.62538, 0.03917, 0, 36, 180, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 0, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 24, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 48, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 72, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 96, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 120, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 144, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 168, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 0, 48, 180, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 0, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 24, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 48, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 72, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 96, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 120, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 144, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 168, 0.5 },
	{ 0.09094, 0.51955, 0.05261, 0, 60, 180, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 0, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 24, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 48, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 72, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 96, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 120, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 144, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 168, 0.5 },
	{ 0.09094, 0.46842, 0.06089, 0, 66, 180, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 0, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 24, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 48, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 72, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 96, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 120, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 144, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 168, 0.5 },
	{ 0.09094, 0.65922, 0.03768, 12, 0, 180, 0.5 },
	{ 0.09094, 0.65563, 0.04149, 12, 12, 0, 0.5 },
	{ 0.09094, 0.65563, 0.04071, 12, 12, 24, 0.5 },
	{ 0.09094, 0.65563, 0.03915, 12, 12, 48, 0.5 },
	{ 0.09094, 0.65563, 0.03794, 12, 12, 72, 0.5 },
	{ 0.09094, 0.65563, 0.03718, 12, 12, 96, 0.5 },
	{ 0.09094, 0.65563, 0.03665, 12, 12, 120, 0.5 },
	{ 0.09094, 0.65563, 0.03624, 12, 12, 144, 0.5 },
	{ 0.09094, 0.65563, 0.03604, 12, 12, 168, 0.5 },
	{ 0.09094, 0.65563, 0.03602, 12, 12, 180, 0.5 },
	{ 0.09094, 0.64410, 0.04107, 12, 24, 0, 0.5 },
	{ 0.09094, 0.64410, 0.04054, 12, 24, 24, 0.5 },
	{ 0.09094, 0.64410, 0.03960, 12, 24, 48, 0.5 },
	{ 0.09094, 0.64410, 0.03863, 12, 24, 72, 0.5 },
	{ 0.09094, 0.64410, 0.03762, 12, 24, 96, 0.5 },
	{ 0.09094, 0.64410, 0.03674, 12, 24, 120, 0.5 },
	{ 0.09094, 0.64410, 0.03611, 12, 24, 144, 0.5 },
	{ 0.09094, 0.64410, 0.03577, 12, 24, 168, 0.5 },
	{ 0.09094, 0.64410, 0.03573, 12, 24, 180, 0.5 },
	{ 0.09094, 0.62198, 0.04308, 12, 36, 0, 0.5 },
	{ 0.09094, 0.62198, 0.04275, 12, 36, 24, 0.5 },
	{ 0.09094, 0.62198, 0.04182, 12, 36, 48, 0.5 },
	{ 0.09094, 0.62198, 0.04058, 12, 36, 72, 0.5 },
	{ 0.09094, 0.62198, 0.03934, 12, 36, 96, 0.5 },
	{ 0.09094, 0.62198, 0.03834, 12, 36, 120, 0.5 },
	{ 0.09094, 0.62198, 0.03767, 12, 36, 144, 0.5 },
	{ 0.09094, 0.62198, 0.03736, 12, 36, 168, 0.5 },
	{ 0.09094, 0.62198, 0.03732, 12, 36, 180, 0.5 },
	{ 0.09094, 0.58350, 0.04748, 12, 48, 0, 0.5 },
	{ 0.09094, 0.58350, 0.04710, 12, 48, 24, 0.5 },
	{ 0.09094, 0.58350, 0.04610, 12, 48, 48, 0.5 },
	{ 0.09094, 0.58350, 0.04485, 12, 48, 72, 0.5 },
	{ 0.09094, 0.58350, 0.04375, 12, 48, 96, 0.5 },
	{ 0.09094, 0.58350, 0.04300, 12, 48, 120, 0.5 },
	{ 0.09094, 0.58350, 0.04262, 12, 48, 144, 0.5 },
	{ 0.09094, 0.58350, 0.04249, 12, 48, 168, 0.5 },
	{ 0.09094, 0.58350, 0.04248, 12, 48, 180, 0.5 },
	{ 0.09094, 0.51672, 0.05626, 12, 60, 0, 0.5 },
	{ 0.09094, 0.51672, 0.05590, 12, 60, 24, 0.5 },
	{ 0.09094, 0.51672, 0.05510, 12, 60, 48, 0.5 },
	{ 0.09094, 0.51672, 0.05423, 12, 60, 72, 0.5 },
	{ 0.09094, 0.51672, 0.05372, 12, 60, 96, 0.5 },
	{ 0.09094, 0.51672, 0.05376, 12, 60, 120, 0.5 },
	{ 0.09094, 0.51672, 0.05416, 12, 60, 144, 0.5 },
	{ 0.09094, 0.51672, 0.05448, 12, 60, 168, 0.5 },
	{ 0.09094, 0.51672, 0.05453, 12, 60, 180, 0.5 },
	{ 0.09094, 0.46587, 0.06375, 12, 66, 0, 0.5 },
	{ 0.09094, 0.46587, 0.06348, 12, 66, 24, 0.5 },
	{ 0.09094, 0.46587, 0.06284, 12, 66, 48, 0.5 },
	{ 0.09094, 0.46587, 0.06235, 12, 66, 72, 0.5 },
	{ 0.09094, 0.46587, 0.06245, 12, 66, 96, 0.5 },
	{ 0.09094, 0.46587, 0.06323, 12, 66, 120, 0.5 },
	{ 0.09094, 0.46587, 0.06435, 12, 66, 144, 0.5 },
	{ 0.09094, 0.46587, 0.06516, 12, 66, 168, 0.5 },
	{ 0.09094, 0.46587, 0.06528, 12, 66, 180, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 0, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 24, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 48, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 72, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 96, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 120, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 144, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 168, 0.5 },
	{ 0.09094, 0.64762, 0.03765, 24, 0, 180, 0.5 },
	{ 0.09094, 0.64410, 0.04109, 24, 12, 0, 0.5 },
	{ 0.09094, 0.64410, 0.04055, 24, 12, 24, 0.5 },
	{ 0.09094, 0.64410, 0.03962, 24, 12, 48, 0.5 },
	{ 0.09094, 0.64410, 0.03864, 24, 12, 72, 0.5 },
	{ 0.09094, 0.64410, 0.03764, 24, 12, 96, 0.5 },
	{ 0.09094, 0.64410, 0.03676, 24, 12, 120, 0.5 },
	{ 0.09094, 0.64410, 0.03613, 24, 12, 144, 0.5 },
	{ 0.09094, 0.64410, 0.03579, 24, 12, 168, 0.5 },
	{ 0.09094, 0.64410, 0.03574, 24, 12, 180, 0.5 },
	{ 0.09094, 0.63277, 0.04723, 24, 24, 0, 0.5 },
	{ 0.09094, 0.63277, 0.04462, 24, 24, 24, 0.5 },
	{ 0.09094, 0.63277, 0.04214, 24, 24, 48, 0.5 },
	{ 0.09094, 0.63277, 0.04025, 24, 24, 72, 0.5 },
	{ 0.09094, 0.63277, 0.03841, 24, 24, 96, 0.5 },
	{ 0.09094, 0.63277, 0.03697, 24, 24, 120, 0.5 },
	{ 0.09094, 0.63277, 0.03606, 24, 24, 144, 0.5 },
	{ 0.09094, 0.63277, 0.03566, 24, 24, 168, 0.5 },
	{ 0.09094, 0.63277, 0.03561, 24, 24, 180, 0.5 },
	{ 0.09094, 0.61103, 0.04918, 24, 36, 0, 0.5 },
	{ 0.09094, 0.61103, 0.04780, 24, 36, 24, 0.5 },
	{ 0.09094, 0.61103, 0.04560, 24, 36, 48, 0.5 },
	{ 0.09094, 0.61103, 0.04298, 24, 36, 72, 0.5 },
	{ 0.09094, 0.61103, 0.04073, 24, 36, 96, 0.5 },
	{ 0.09094, 0.61103, 0.03931, 24, 36, 120, 0.5 },
	{ 0.09094, 0.61103, 0.03865, 24, 36, 144, 0.5 },
	{ 0.09094, 0.61103, 0.03844, 24, 36, 168, 0.5 },
	{ 0.09094, 0.61103, 0.03842, 24, 36, 180, 0.5 },
	{ 0.09094, 0.57323, 0.05471, 24, 48, 0, 0.5 },
	{ 0.09094, 0.57323, 0.05366, 24, 48, 24, 0.5 },
	{ 0.09094, 0.57323, 0.05106, 24, 48, 48, 0.5 },
	{ 0.09094, 0.57323, 0.04817, 24, 48, 72, 0.5 },
	{ 0.09094, 0.57323, 0.04617, 24, 48, 96, 0.5 },
	{ 0.09094, 0.57323, 0.04549, 24, 48, 120, 0.5 },
	{ 0.09094, 0.57323, 0.04581, 24, 48, 144, 0.5 },
	{ 0.09094, 0.57323, 0.04630, 24, 48, 168, 0.5 },
	{ 0.09094, 0.57323, 0.04637, 24, 48, 180, 0.5 },
	{ 0.09094, 0.50763, 0.06492, 24, 60, 0, 0.5 },
	{ 0.09094, 0.50763, 0.06378, 24, 60, 24, 0.5 },
	{ 0.09094, 0.50763, 0.06106, 24, 60, 48, 0.5 },
	{ 0.09094, 0.50763, 0.05856, 24, 60, 72, 0.5 },
	{ 0.09094, 0.50763, 0.05776, 24, 60, 96, 0.5 },
	{ 0.09094, 0.50763, 0.05914, 24, 60, 120, 0.5 },
	{ 0.09094, 0.50763, 0.06183, 24, 60, 144, 0.5 },
	{ 0.09094, 0.50763, 0.06402, 24, 60, 168, 0.5 },
	{ 0.09094, 0.50763, 0.06434, 24, 60, 180, 0.5 },
	{ 0.09094, 0.45767, 0.07307, 24, 66, 0, 0.5 },
	{ 0.09094, 0.45767, 0.07189, 24, 66, 24, 0.5 },
	{ 0.09094, 0.45767, 0.06933, 24, 66, 48, 0.5 },
	{ 0.09094, 0.45767, 0.06733, 24, 66, 72, 0.5 },
	{ 0.09094, 0.45767, 0.06769, 24, 66, 96, 0.5 },
	{ 0.09094, 0.45767, 0.07098, 24, 66, 120, 0.5 },
	{ 0.09094, 0.45767, 0.07586, 24, 66, 144, 0.5 },
	{ 0.09094, 0.45767, 0.07958, 24, 66, 168, 0.5 },
	{ 0.09094, 0.45767, 0.08011, 24, 66, 180, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 0, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 24, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 48, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 72, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 96, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 120, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 144, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 168, 0.5 },
	{ 0.09094, 0.62538, 0.03920, 36, 0, 180, 0.5 },
	{ 0.09094, 0.62198, 0.04310, 36, 12, 0, 0.5 },
	{ 0.09094, 0.62198, 0.04277, 36, 12, 24, 0.5 },
	{ 0.09094, 0.62198, 0.04185, 36, 12, 48, 0.5 },
	{ 0.09094, 0.62198, 0.04061, 36, 12, 72, 0.5 },
	{ 0.09094, 0.62198, 0.03937, 36, 12, 96, 0.5 },
	{ 0.09094, 0.62198, 0.03837, 36, 12, 120, 0.5 },
	{ 0.09094, 0.62198, 0.03770, 36, 12, 144, 0.5 },
	{ 0.09094, 0.62198, 0.03739, 36, 12, 168, 0.5 },
	{ 0.09094, 0.62198, 0.03735, 36, 12, 180, 0.5 },
	{ 0.09094, 0.61103, 0.04918, 36, 24, 0, 0.5 },
	{ 0.09094, 0.61103, 0.04781, 36, 24, 24, 0.5 },
	{ 0.09094, 0.61103, 0.04561, 36, 24, 48, 0.5 },
	{ 0.09094, 0.61103, 0.04298, 36, 24, 72, 0.5 },
	{ 0.09094, 0.61103, 0.04073, 36, 24, 96, 0.5 },
	{ 0.09094, 0.61103, 0.03931, 36, 24, 120, 0.5 },
	{ 0.09094, 0.61103, 0.03865, 36, 24, 144, 0.5 },
	{ 0.09094, 0.61103, 0.03844, 36, 24, 168, 0.5 },
	{ 0.09094, 0.61103, 0.03842, 36, 24, 180, 0.5 },
	{ 0.09094, 0.59005, 0.05926, 36, 36, 0, 0.5 },
	{ 0.09094, 0.59005, 0.05445, 36, 36, 24, 0.5 },
	{ 0.09094, 0.59005, 0.05072, 36, 36, 48, 0.5 },
	{ 0.09094, 0.59005, 0.04689, 36, 36, 72, 0.5 },
	{ 0.09094, 0.59005, 0.04421, 36, 36, 96, 0.5 },
	{ 0.09094, 0.59005, 0.04317, 36, 36, 120, 0.5 },
	{ 0.09094, 0.59005, 0.04339, 36, 36, 144, 0.5 },
	{ 0.09094, 0.59005, 0.04392, 36, 36, 168, 0.5 },
	{ 0.09094, 0.59005, 0.04400, 36, 36, 180, 0.5 },
	{ 0.09094, 0.55354, 0.06560, 36, 48, 0, 0.5 },
	{ 0.09094, 0.55354, 0.06288, 36, 48, 24, 0.5 },
	{ 0.09094, 0.55354, 0.05828, 36, 48, 48, 0.5 },
	{ 0.09094, 0.55354, 0.05368, 36, 48, 72, 0.5 },
	{ 0.09094, 0.55354, 0.05141, 36, 48, 96, 0.5 },
	{ 0.09094, 0.55354, 0.05210, 36, 48, 120, 0.5 },
	{ 0.09094, 0.55354, 0.05481, 36, 48, 144, 0.5 },
	{ 0.09094, 0.55354, 0.05722, 36, 48, 168, 0.5 },
	{ 0.09094, 0.55354, 0.05758, 36, 48, 180, 0.5 },
	{ 0.09094, 0.49019, 0.07876, 36, 60, 0, 0.5 },
	{ 0.09094, 0.49019, 0.07634, 36, 60, 24, 0.5 },
	{ 0.09094, 0.49019, 0.07078, 36, 60, 48, 0.5 },
	{ 0.09094, 0.49019, 0.06621, 36, 60, 72, 0.5 },
	{ 0.09094, 0.49019, 0.06581, 36, 60, 96, 0.5 },
	{ 0.09094, 0.49019, 0.07069, 36, 60, 120, 0.5 },
	{ 0.09094, 0.49019, 0.07906, 36, 60, 144, 0.5 },
	{ 0.09094, 0.49019, 0.08582, 36, 60, 168, 0.5 },
	{ 0.09094, 0.49019, 0.08684, 36, 60, 180, 0.5 },
	{ 0.09094, 0.44196, 0.08919, 36, 66, 0, 0.5 },
	{ 0.09094, 0.44196, 0.08649, 36, 66, 24, 0.5 },
	{ 0.09094, 0.44196, 0.08062, 36, 66, 48, 0.5 },
	{ 0.09094, 0.44196, 0.07640, 36, 66, 72, 0.5 },
	{ 0.09094, 0.44196, 0.07782, 36, 66, 96, 0.5 },
	{ 0.09094, 0.44196, 0.08649, 36, 66, 120, 0.5 },
	{ 0.09094, 0.44196, 0.10000, 36, 66, 144, 0.5 },
	{ 0.09094, 0.44196, 0.11081, 36, 66, 168, 0.5 },
	{ 0.09094, 0.44196, 0.11240, 36, 66, 180, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 0, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 24, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 48, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 72, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 96, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 120, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 144, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 168, 0.5 },
	{ 0.09094, 0.58669, 0.04326, 48, 0, 180, 0.5 },
	{ 0.09094, 0.58350, 0.04749, 48, 12, 0, 0.5 },
	{ 0.09094, 0.58350, 0.04711, 48, 12, 24, 0.5 },
	{ 0.09094, 0.58350, 0.04610, 48, 12, 48, 0.5 },
	{ 0.09094, 0.58350, 0.04485, 48, 12, 72, 0.5 },
	{ 0.09094, 0.58350, 0.04375, 48, 12, 96, 0.5 },
	{ 0.09094, 0.58350, 0.04300, 48, 12, 120, 0.5 },
	{ 0.09094, 0.58350, 0.04262, 48, 12, 144, 0.5 },
	{ 0.09094, 0.58350, 0.04250, 48, 12, 168, 0.5 },
	{ 0.09094, 0.58350, 0.04249, 48, 12, 180, 0.5 },
	{ 0.09094, 0.57323, 0.05467, 48, 24, 0, 0.5 },
	{ 0.09094, 0.57323, 0.05362, 48, 24, 24, 0.5 },
	{ 0.09094, 0.57323, 0.05102, 48, 24, 48, 0.5 },
	{ 0.09094, 0.57323, 0.04813, 48, 24, 72, 0.5 },
	{ 0.09094, 0.57323, 0.04613, 48, 24, 96, 0.5 },
	{ 0.09094, 0.57323, 0.04545, 48, 24, 120, 0.5 },
	{ 0.09094, 0.57323, 0.04576, 48, 24, 144, 0.5 },
	{ 0.09094, 0.57323, 0.04625, 48, 24, 168, 0.5 },
	{ 0.09094, 0.57323, 0.04633, 48, 24, 180, 0.5 },
	{ 0.09094, 0.55354, 0.06554, 48, 36, 0, 0.5 },
	{ 0.09094, 0.55354, 0.06282, 48, 36, 24, 0.5 },
	{ 0.09094, 0.55354, 0.05822, 48, 36, 48, 0.5 },
	{ 0.09094, 0.55354, 0.05363, 48, 36, 72, 0.5 },
	{ 0.09094, 0.55354, 0.05136, 48, 36, 96, 0.5 },
	{ 0.09094, 0.55354, 0.05204, 48, 36, 120, 0.5 },
	{ 0.09094, 0.55354, 0.05475, 48, 36, 144, 0.5 },
	{ 0.09094, 0.55354, 0.05716, 48, 36, 168, 0.5 },
	{ 0.09094, 0.55354, 0.05752, 48, 36, 180, 0.5 },
	{ 0.09094, 0.51930, 0.08354, 48, 48, 0, 0.5 },
	{ 0.09094, 0.51930, 0.07567, 48, 48, 24, 0.5 },
	{ 0.09094, 0.51930, 0.06879, 48, 48, 48, 0.5 },
	{ 0.09094, 0.51930, 0.06280, 48, 48, 72, 0.5 },
	{ 0.09094, 0.51930, 0.06136, 48, 48, 96, 0.5 },
	{ 0.09094, 0.51930, 0.06571, 48, 48, 120, 0.5 },
	{ 0.09094, 0.51930, 0.07397, 48, 48, 144, 0.5 },
	{ 0.09094, 0.51930, 0.08088, 48, 48, 168, 0.5 },
	{ 0.09094, 0.51930, 0.08194, 48, 48, 180, 0.5 },
	{ 0.09094, 0.45987, 0.10017, 48, 60, 0, 0.5 },
	{ 0.09094, 0.45987, 0.09485, 48, 60, 24, 0.5 },
	{ 0.09094, 0.45987, 0.08572, 48, 60, 48, 0.5 },
	{ 0.09094, 0.45987, 0.07894, 48, 60, 72, 0.5 },
	{ 0.09094, 0.45987, 0.08040, 48, 60, 96, 0.5 },
	{ 0.09094, 0.45987, 0.09269, 48, 60, 120, 0.5 },
	{ 0.09094, 0.45987, 0.11323, 48, 60, 144, 0.5 },
	{ 0.09094, 0.45987, 0.13055, 48, 60, 168, 0.5 },
	{ 0.09094, 0.45987, 0.13320, 48, 60, 180, 0.5 },
	{ 0.09094, 0.41461, 0.11392, 48, 66, 0, 0.5 },
	{ 0.09094, 0.41461, 0.10900, 48, 66, 24, 0.5 },
	{ 0.09094, 0.41461, 0.09860, 48, 66, 48, 0.5 },
	{ 0.09094, 0.41461, 0.09173, 48, 66, 72, 0.5 },
	{ 0.09094, 0.41461, 0.09585, 48, 66, 96, 0.5 },
	{ 0.09094, 0.41461, 0.11502, 48, 66, 120, 0.5 },
	{ 0.09094, 0.41461, 0.14652, 48, 66, 144, 0.5 },
	{ 0.09094, 0.41461, 0.17370, 48, 66, 168, 0.5 },
	{ 0.09094, 0.41461, 0.17801, 48, 66, 180, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 0, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 24, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 48, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 72, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 96, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 120, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 144, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 168, 0.5 },
	{ 0.09094, 0.51955, 0.05262, 60, 0, 180, 0.5 },
	{ 0.09094, 0.51672, 0.05627, 60, 12, 0, 0.5 },
	{ 0.09094, 0.51672, 0.05592, 60, 12, 24, 0.5 },
	{ 0.09094, 0.51672, 0.05511, 60, 12, 48, 0.5 },
	{ 0.09094, 0.51672, 0.05424, 60, 12, 72, 0.5 },
	{ 0.09094, 0.51672, 0.05373, 60, 12, 96, 0.5 },
	{ 0.09094, 0.51672, 0.05377, 60, 12, 120, 0.5 },
	{ 0.09094, 0.51672, 0.05417, 60, 12, 144, 0.5 },
	{ 0.09094, 0.51672, 0.05449, 60, 12, 168, 0.5 },
	{ 0.09094, 0.51672, 0.05454, 60, 12, 180, 0.5 },
	{ 0.09094, 0.50763, 0.06488, 60, 24, 0, 0.5 },
	{ 0.09094, 0.50763, 0.06374, 60, 24, 24, 0.5 },
	{ 0.09094, 0.50763, 0.06101, 60, 24, 48, 0.5 },
	{ 0.09094, 0.50763, 0.05852, 60, 24, 72, 0.5 },
	{ 0.09094, 0.50763, 0.05772, 60, 24, 96, 0.5 },
	{ 0.09094, 0.50763, 0.05908, 60, 24, 120, 0.5 },
	{ 0.09094, 0.50763, 0.06178, 60, 24, 144, 0.5 },
	{ 0.09094, 0.50763, 0.06397, 60, 24, 168, 0.5 },
	{ 0.09094, 0.50763, 0.06428, 60, 24, 180, 0.5 },
	{ 0.09094, 0.49019, 0.07870, 60, 36, 0, 0.5 },
	{ 0.09094, 0.49019, 0.07628, 60, 36, 24, 0.5 },
	{ 0.09094, 0.49019, 0.07072, 60, 36, 48, 0.5 },
	{ 0.09094, 0.49019, 0.06615, 60, 36, 72, 0.5 },
	{ 0.09094, 0.49019, 0.06575, 60, 36, 96, 0.5 },
	{ 0.09094, 0.49019, 0.07062, 60, 36, 120, 0.5 },
	{ 0.09094, 0.49019, 0.07899, 60, 36, 144, 0.5 },
	{ 0.09094, 0.49019, 0.08575, 60, 36, 168, 0.5 },
	{ 0.09094, 0.49019, 0.08677, 60, 36, 180, 0.5 },
	{ 0.09094, 0.45987, 0.10018, 60, 48, 0, 0.5 },
	{ 0.09094, 0.45987, 0.09487, 60, 48, 24, 0.5 },
	{ 0.09094, 0.45987, 0.08573, 60, 48, 48, 0.5 },
	{ 0.09094, 0.45987, 0.07895, 60, 48, 72, 0.5 },
	{ 0.09094, 0.45987, 0.08042, 60, 48, 96, 0.5 },
	{ 0.09094, 0.45987, 0.09271, 60, 48, 120, 0.5 },
	{ 0.09094, 0.45987, 0.11325, 60, 48, 144, 0.5 },
	{ 0.09094, 0.45987, 0.13056, 60, 48, 168, 0.5 },
	{ 0.09094, 0.45987, 0.13321, 60, 48, 180, 0.5 },
	{ 0.09094, 0.40724, 0.13743, 60, 60, 0, 0.5 },
	{ 0.09094, 0.40724, 0.12365, 60, 60, 24, 0.5 },
	{ 0.09094, 0.40724, 0.10999, 60, 60, 48, 0.5 },
	{ 0.09094, 0.40724, 0.10119, 60, 60, 72, 0.5 },
	{ 0.09094, 0.40724, 0.10715, 60, 60, 96, 0.5 },
	{ 0.09094, 0.40724, 0.13428, 60, 60, 120, 0.5 },
	{ 0.09094, 0.40724, 0.18066, 60, 60, 144, 0.5 },
	{ 0.09094, 0.40724, 0.22332, 60, 60, 168, 0.5 },
	{ 0.09094, 0.40724, 0.23016, 60, 60, 180, 0.5 },
	{ 0.09094, 0.36716, 0.15828, 60, 66, 0, 0.5 },
	{ 0.09094, 0.36716, 0.14481, 60, 66, 24, 0.5 },
	{ 0.09094, 0.36716, 0.12835, 60, 66, 48, 0.5 },
	{ 0.09094, 0.36716, 0.11859, 60, 66, 72, 0.5 },
	{ 0.09094, 0.36716, 0.12848, 60, 66, 96, 0.5 },
	{ 0.09094, 0.36716, 0.16782, 60, 66, 120, 0.5 },
	{ 0.09094, 0.36716, 0.23699, 60, 66, 144, 0.5 },
	{ 0.09094, 0.36716, 0.30417, 60, 66, 168, 0.5 },
	{ 0.09094, 0.36716, 0.31527, 60, 66, 180, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 0, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 24, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 48, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 72, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 96, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 120, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 144, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 168, 0.5 },
	{ 0.09094, 0.46842, 0.06090, 66, 0, 180, 0.5 },
	{ 0.09094, 0.46587, 0.06377, 66, 12, 0, 0.5 },
	{ 0.09094, 0.46587, 0.06350, 66, 12, 24, 0.5 },
	{ 0.09094, 0.46587, 0.06286, 66, 12, 48, 0.5 },
	{ 0.09094, 0.46587, 0.06237, 66, 12, 72, 0.5 },
	{ 0.09094, 0.46587, 0.06247, 66, 12, 96, 0.5 },
	{ 0.09094, 0.46587, 0.06325, 66, 12, 120, 0.5 },
	{ 0.09094, 0.46587, 0.06437, 66, 12, 144, 0.5 },
	{ 0.09094, 0.46587, 0.06518, 66, 12, 168, 0.5 },
	{ 0.09094, 0.46587, 0.06530, 66, 12, 180, 0.5 },
	{ 0.09094, 0.45767, 0.07304, 66, 24, 0, 0.5 },
	{ 0.09094, 0.45767, 0.07185, 66, 24, 24, 0.5 },
	{ 0.09094, 0.45767, 0.06928, 66, 24, 48, 0.5 },
	{ 0.09094, 0.45767, 0.06728, 66, 24, 72, 0.5 },
	{ 0.09094, 0.45767, 0.06764, 66, 24, 96, 0.5 },
	{ 0.09094, 0.45767, 0.07092, 66, 24, 120, 0.5 },
	{ 0.09094, 0.45767, 0.07580, 66, 24, 144, 0.5 },
	{ 0.09094, 0.45767, 0.07952, 66, 24, 168, 0.5 },
	{ 0.09094, 0.45767, 0.08005, 66, 24, 180, 0.5 },
	{ 0.09094, 0.44196, 0.08914, 66, 36, 0, 0.5 },
	{ 0.09094, 0.44196, 0.08643, 66, 36, 24, 0.5 },
	{ 0.09094, 0.44196, 0.08056, 66, 36, 48, 0.5 },
	{ 0.09094, 0.44196, 0.07634, 66, 36, 72, 0.5 },
	{ 0.09094, 0.44196, 0.07776, 66, 36, 96, 0.5 },
	{ 0.09094, 0.44196, 0.08642, 66, 36, 120, 0.5 },
	{ 0.09094, 0.44196, 0.09992, 66, 36, 144, 0.5 },
	{ 0.09094, 0.44196, 0.11073, 66, 36, 168, 0.5 },
	{ 0.09094, 0.44196, 0.11232, 66, 36, 180, 0.5 },
	{ 0.09094, 0.41461, 0.11396, 66, 48, 0, 0.5 },
	{ 0.09094, 0.41461, 0.10904, 66, 48, 24, 0.5 },
	{ 0.09094, 0.41461, 0.09866, 66, 48, 48, 0.5 },
	{ 0.09094, 0.41461, 0.09179, 66, 48, 72, 0.5 },
	{ 0.09094, 0.41461, 0.09588, 66, 48, 96, 0.5 },
	{ 0.09094, 0.41461, 0.11504, 66, 48, 120, 0.5 },
	{ 0.09094, 0.41461, 0.14653, 66, 48, 144, 0.5 },
	{ 0.09094, 0.41461, 0.17371, 66, 48, 168, 0.5 },
	{ 0.09094, 0.41461, 0.17803, 66, 48, 180, 0.5 },
	{ 0.09094, 0.36716, 0.15831, 66, 60, 0, 0.5 },
	{ 0.09094, 0.36716, 0.14483, 66, 60, 24, 0.5 },
	{ 0.09094, 0.36716, 0.12837, 66, 60, 48, 0.5 },
	{ 0.09094, 0.36716, 0.11860, 66, 60, 72, 0.5 },
	{ 0.09094, 0.36716, 0.12849, 66, 60, 96, 0.5 },
	{ 0.09094, 0.36716, 0.16783, 66, 60, 120, 0.5 },
	{ 0.09094, 0.36716, 0.23699, 66, 60, 144, 0.5 },
	{ 0.09094, 0.36716, 0.30418, 66, 60, 168, 0.5 },
	{ 0.09094, 0.36716, 0.31529, 66, 60, 180, 0.5 },
	{ 0.09094, 0.33103, 0.19079, 66, 66, 0, 0.5 },
	{ 0.09094, 0.33103, 0.17146, 66, 66, 24, 0.5 },
	{ 0.09094, 0.33103, 0.15107, 66, 66, 48, 0.5 },
	{ 0.09094, 0.33103, 0.13966, 66, 66, 72, 0.5 },
	{ 0.09094, 0.33103, 0.15428, 66, 66, 96, 0.5 },
	{ 0.09094, 0.33103, 0.20986, 66, 66, 120, 0.5 },
	{ 0.09094, 0.33103, 0.31215, 66, 66, 144, 0.5 },
	{ 0.09094, 0.33103, 0.41861, 66, 66, 168, 0.5 },
	{ 0.09094, 0.33103, 0.43740, 66, 66, 180, 0.5 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 0, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 24, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 48, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 72, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 96, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 120, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 144, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 168, 0.6 },
	{ 0.09586, 0.61435, 0.04320, 0, 0, 180, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 0, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 24, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 48, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 72, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 96, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 120, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 144, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 168, 0.6 },
	{ 0.09586, 0.61038, 0.04085, 0, 12, 180, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 0, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 24, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 48, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 72, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 96, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 120, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 144, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 168, 0.6 },
	{ 0.09586, 0.59770, 0.04082, 0, 24, 180, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 0, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 24, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 48, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 72, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 96, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 120, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 144, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 168, 0.6 },
	{ 0.09586, 0.57356, 0.04256, 0, 36, 180, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 0, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 24, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 48, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 72, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 96, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 120, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 144, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 168, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 0, 48, 180, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 0, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 24, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 48, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 72, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 96, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 120, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 144, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 168, 0.6 },
	{ 0.09586, 0.46230, 0.05705, 0, 60, 180, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 0, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 24, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 48, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 72, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 96, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 120, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 144, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 168, 0.6 },
	{ 0.09586, 0.41084, 0.06562, 0, 66, 180, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 0, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 24, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 48, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 72, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 96, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 120, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 144, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 168, 0.6 },
	{ 0.09586, 0.61038, 0.04084, 12, 0, 180, 0.6 },
	{ 0.09586, 0.60645, 0.04502, 12, 12, 0, 0.6 },
	{ 0.09586, 0.60645, 0.04416, 12, 12, 24, 0.6 },
	{ 0.09586, 0.60645, 0.04243, 12, 12, 48, 0.6 },
	{ 0.09586, 0.60645, 0.04112, 12, 12, 72, 0.6 },
	{ 0.09586, 0.60645, 0.04030, 12, 12, 96, 0.6 },
	{ 0.09586, 0.60645, 0.03975, 12, 12, 120, 0.6 },
	{ 0.09586, 0.60645, 0.03933, 12, 12, 144, 0.6 },
	{ 0.09586, 0.60645, 0.03912, 12, 12, 168, 0.6 },
	{ 0.09586, 0.60645, 0.03910, 12, 12, 180, 0.6 },
	{ 0.09586, 0.59385, 0.04446, 12, 24, 0, 0.6 },
	{ 0.09586, 0.59385, 0.04388, 12, 24, 24, 0.6 },
	{ 0.09586, 0.59385, 0.04289, 12, 24, 48, 0.6 },
	{ 0.09586, 0.59385, 0.04187, 12, 24, 72, 0.6 },
	{ 0.09586, 0.59385, 0.04084, 12, 24, 96, 0.6 },
	{ 0.09586, 0.59385, 0.03993, 12, 24, 120, 0.6 },
	{ 0.09586, 0.59385, 0.03930, 12, 24, 144, 0.6 },
	{ 0.09586, 0.59385, 0.03894, 12, 24, 168, 0.6 },
	{ 0.09586, 0.59385, 0.03890, 12, 24, 180, 0.6 },
	{ 0.09586, 0.56987, 0.04660, 12, 36, 0, 0.6 },
	{ 0.09586, 0.56987, 0.04626, 12, 36, 24, 0.6 },
	{ 0.09586, 0.56987, 0.04531, 12, 36, 48, 0.6 },
	{ 0.09586, 0.56987, 0.04404, 12, 36, 72, 0.6 },
	{ 0.09586, 0.56987, 0.04279, 12, 36, 96, 0.6 },
	{ 0.09586, 0.56987, 0.04179, 12, 36, 120, 0.6 },
	{ 0.09586, 0.56987, 0.04114, 12, 36, 144, 0.6 },
	{ 0.09586, 0.56987, 0.04085, 12, 36, 168, 0.6 },
	{ 0.09586, 0.56987, 0.04081, 12, 36, 180, 0.6 },
	{ 0.09586, 0.52875, 0.05132, 12, 48, 0, 0.6 },
	{ 0.09586, 0.52875, 0.05094, 12, 48, 24, 0.6 },
	{ 0.09586, 0.52875, 0.04993, 12, 48, 48, 0.6 },
	{ 0.09586, 0.52875, 0.04870, 12, 48, 72, 0.6 },
	{ 0.09586, 0.52875, 0.04765, 12, 48, 96, 0.6 },
	{ 0.09586, 0.52875, 0.04698, 12, 48, 120, 0.6 },
	{ 0.09586, 0.52875, 0.04668, 12, 48, 144, 0.6 },
	{ 0.09586, 0.52875, 0.04660, 12, 48, 168, 0.6 },
	{ 0.09586, 0.52875, 0.04660, 12, 48, 180, 0.6 },
	{ 0.09586, 0.45932, 0.06052, 12, 60, 0, 0.6 },
	{ 0.09586, 0.45932, 0.06018, 12, 60, 24, 0.6 },
	{ 0.09586, 0.45932, 0.05943, 12, 60, 48, 0.6 },
	{ 0.09586, 0.45932, 0.05867, 12, 60, 72, 0.6 },
	{ 0.09586, 0.45932, 0.05832, 12, 60, 96, 0.6 },
	{ 0.09586, 0.45932, 0.05855, 12, 60, 120, 0.6 },
	{ 0.09586, 0.45932, 0.05914, 12, 60, 144, 0.6 },
	{ 0.09586, 0.45932, 0.05957, 12, 60, 168, 0.6 },
	{ 0.09586, 0.45932, 0.05963, 12, 60, 180, 0.6 },
	{ 0.09586, 0.40819, 0.06815, 12, 66, 0, 0.6 },
	{ 0.09586, 0.40819, 0.06791, 12, 66, 24, 0.6 },
	{ 0.09586, 0.40819, 0.06737, 12, 66, 48, 0.6 },
	{ 0.09586, 0.40819, 0.06704, 12, 66, 72, 0.6 },
	{ 0.09586, 0.40819, 0.06737, 12, 66, 96, 0.6 },
	{ 0.09586, 0.40819, 0.06842, 12, 66, 120, 0.6 },
	{ 0.09586, 0.40819, 0.06979, 12, 66, 144, 0.6 },
	{ 0.09586, 0.40819, 0.07075, 12, 66, 168, 0.6 },
	{ 0.09586, 0.40819, 0.07089, 12, 66, 180, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 0, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 24, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 48, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 72, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 96, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 120, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 144, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 168, 0.6 },
	{ 0.09586, 0.59770, 0.04085, 24, 0, 180, 0.6 },
	{ 0.09586, 0.59385, 0.04450, 24, 12, 0, 0.6 },
	{ 0.09586, 0.59385, 0.04392, 24, 12, 24, 0.6 },
	{ 0.09586, 0.59385, 0.04293, 24, 12, 48, 0.6 },
	{ 0.09586, 0.59385, 0.04191, 24, 12, 72, 0.6 },
	{ 0.09586, 0.59385, 0.04088, 24, 12, 96, 0.6 },
	{ 0.09586, 0.59385, 0.03997, 24, 12, 120, 0.6 },
	{ 0.09586, 0.59385, 0.03933, 24, 12, 144, 0.6 },
	{ 0.09586, 0.59385, 0.03898, 24, 12, 168, 0.6 },
	{ 0.09586, 0.59385, 0.03894, 24, 12, 180, 0.6 },
	{ 0.09586, 0.58151, 0.05115, 24, 24, 0, 0.6 },
	{ 0.09586, 0.58151, 0.04827, 24, 24, 24, 0.6 },
	{ 0.09586, 0.58151, 0.04562, 24, 24, 48, 0.6 },
	{ 0.09586, 0.58151, 0.04366, 24, 24, 72, 0.6 },
	{ 0.09586, 0.58151, 0.04179, 24, 24, 96, 0.6 },
	{ 0.09586, 0.58151, 0.04033, 24, 24, 120, 0.6 },
	{ 0.09586, 0.58151, 0.03944, 24, 24, 144, 0.6 },
	{ 0.09586, 0.58151, 0.03906, 24, 24, 168, 0.6 },
	{ 0.09586, 0.58151, 0.03901, 24, 24, 180, 0.6 },
	{ 0.09586, 0.55802, 0.05308, 24, 36, 0, 0.6 },
	{ 0.09586, 0.55802, 0.05162, 24, 36, 24, 0.6 },
	{ 0.09586, 0.55802, 0.04934, 24, 36, 48, 0.6 },
	{ 0.09586, 0.55802, 0.04666, 24, 36, 72, 0.6 },
	{ 0.09586, 0.55802, 0.04442, 24, 36, 96, 0.6 },
	{ 0.09586, 0.55802, 0.04307, 24, 36, 120, 0.6 },
	{ 0.09586, 0.55802, 0.04251, 24, 36, 144, 0.6 },
	{ 0.09586, 0.55802, 0.04236, 24, 36, 168, 0.6 },
	{ 0.09586, 0.55802, 0.04236, 24, 36, 180, 0.6 },
	{ 0.09586, 0.51777, 0.05888, 24, 48, 0, 0.6 },
	{ 0.09586, 0.51777, 0.05780, 24, 48, 24, 0.6 },
	{ 0.09586, 0.51777, 0.05516, 24, 48, 48, 0.6 },
	{ 0.09586, 0.51777, 0.05229, 24, 48, 72, 0.6 },
	{ 0.09586, 0.51777, 0.05043, 24, 48, 96, 0.6 },
	{ 0.09586, 0.51777, 0.04998, 24, 48, 120, 0.6 },
	{ 0.09586, 0.51777, 0.05056, 24, 48, 144, 0.6 },
	{ 0.09586, 0.51777, 0.05122, 24, 48, 168, 0.6 },
	{ 0.09586, 0.51777, 0.05132, 24, 48, 180, 0.6 },
	{ 0.09586, 0.44977, 0.06943, 24, 60, 0, 0.6 },
	{ 0.09586, 0.44977, 0.06829, 24, 60, 24, 0.6 },
	{ 0.09586, 0.44977, 0.06561, 24, 60, 48, 0.6 },
	{ 0.09586, 0.44977, 0.06330, 24, 60, 72, 0.6 },
	{ 0.09586, 0.44977, 0.06285, 24, 60, 96, 0.6 },
	{ 0.09586, 0.44977, 0.06473, 24, 60, 120, 0.6 },
	{ 0.09586, 0.44977, 0.06795, 24, 60, 144, 0.6 },
	{ 0.09586, 0.44977, 0.07049, 24, 60, 168, 0.6 },
	{ 0.09586, 0.44977, 0.07085, 24, 60, 180, 0.6 },
	{ 0.09586, 0.39971, 0.07763, 24, 66, 0, 0.6 },
	{ 0.09586, 0.39971, 0.07647, 24, 66, 24, 0.6 },
	{ 0.09586, 0.39971, 0.07403, 24, 66, 48, 0.6 },
	{ 0.09586, 0.39971, 0.07230, 24, 66, 72, 0.6 },
	{ 0.09586, 0.39971, 0.07316, 24, 66, 96, 0.6 },
	{ 0.09586, 0.39971, 0.07712, 24, 66, 120, 0.6 },
	{ 0.09586, 0.39971, 0.08270, 24, 66, 144, 0.6 },
	{ 0.09586, 0.39971, 0.08688, 24, 66, 168, 0.6 },
	{ 0.09586, 0.39971, 0.08748, 24, 66, 180, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 0, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 24, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 48, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 72, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 96, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 120, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 144, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 168, 0.6 },
	{ 0.09586, 0.57356, 0.04261, 36, 0, 180, 0.6 },
	{ 0.09586, 0.56987, 0.04665, 36, 12, 0, 0.6 },
	{ 0.09586, 0.56987, 0.04631, 36, 12, 24, 0.6 },
	{ 0.09586, 0.56987, 0.04536, 36, 12, 48, 0.6 },
	{ 0.09586, 0.56987, 0.04410, 36, 12, 72, 0.6 },
	{ 0.09586, 0.56987, 0.04284, 36, 12, 96, 0.6 },
	{ 0.09586, 0.56987, 0.04185, 36, 12, 120, 0.6 },
	{ 0.09586, 0.56987, 0.04119, 36, 12, 144, 0.6 },
	{ 0.09586, 0.56987, 0.04090, 36, 12, 168, 0.6 },
	{ 0.09586, 0.56987, 0.04086, 36, 12, 180, 0.6 },
	{ 0.09586, 0.55802, 0.05308, 36, 24, 0, 0.6 },
	{ 0.09586, 0.55802, 0.05162, 36, 24, 24, 0.6 },
	{ 0.09586, 0.55802, 0.04934, 36, 24, 48, 0.6 },
	{ 0.09586, 0.55802, 0.04666, 36, 24, 72, 0.6 },
	{ 0.09586, 0.55802, 0.04442, 36, 24, 96, 0.6 },
	{ 0.09586, 0.55802, 0.04308, 36, 24, 120, 0.6 },
	{ 0.09586, 0.55802, 0.04251, 36, 24, 144, 0.6 },
	{ 0.09586, 0.55802, 0.04237, 36, 24, 168, 0.6 },
	{ 0.09586, 0.55802, 0.04237, 36, 24, 180, 0.6 },
	{ 0.09586, 0.53549, 0.06388, 36, 36, 0, 0.6 },
	{ 0.09586, 0.53549, 0.05866, 36, 36, 24, 0.6 },
	{ 0.09586, 0.53549, 0.05479, 36, 36, 48, 0.6 },
	{ 0.09586, 0.53549, 0.05091, 36, 36, 72, 0.6 },
	{ 0.09586, 0.53549, 0.04833, 36, 36, 96, 0.6 },
	{ 0.09586, 0.53549, 0.04753, 36, 36, 120, 0.6 },
	{ 0.09586, 0.53549, 0.04802, 36, 36, 144, 0.6 },
	{ 0.09586, 0.53549, 0.04875, 36, 36, 168, 0.6 },
	{ 0.09586, 0.53549, 0.04886, 36, 36, 180, 0.6 },
	{ 0.09586, 0.49686, 0.07034, 36, 48, 0, 0.6 },
	{ 0.09586, 0.49686, 0.06749, 36, 48, 24, 0.6 },
	{ 0.09586, 0.49686, 0.06279, 36, 48, 48, 0.6 },
	{ 0.09586, 0.49686, 0.05824, 36, 48, 72, 0.6 },
	{ 0.09586, 0.49686, 0.05627, 36, 48, 96, 0.6 },
	{ 0.09586, 0.49686, 0.05749, 36, 48, 120, 0.6 },
	{ 0.09586, 0.49686, 0.06081, 36, 48, 144, 0.6 },
	{ 0.09586, 0.49686, 0.06364, 36, 48, 168, 0.6 },
	{ 0.09586, 0.49686, 0.06406, 36, 48, 180, 0.6 },
	{ 0.09586, 0.43161, 0.08379, 36, 60, 0, 0.6 },
	{ 0.09586, 0.43161, 0.08134, 36, 60, 24, 0.6 },
	{ 0.09586, 0.43161, 0.07578, 36, 60, 48, 0.6 },
	{ 0.09586, 0.43161, 0.07145, 36, 60, 72, 0.6 },
	{ 0.09586, 0.43161, 0.07169, 36, 60, 96, 0.6 },
	{ 0.09586, 0.43161, 0.07758, 36, 60, 120, 0.6 },
	{ 0.09586, 0.43161, 0.08712, 36, 60, 144, 0.6 },
	{ 0.09586, 0.43161, 0.09471, 36, 60, 168, 0.6 },
	{ 0.09586, 0.43161, 0.09586, 36, 60, 180, 0.6 },
	{ 0.09586, 0.38357, 0.09422, 36, 66, 0, 0.6 },
	{ 0.09586, 0.38357, 0.09150, 36, 66, 24, 0.6 },
	{ 0.09586, 0.38357, 0.08572, 36, 66, 48, 0.6 },
	{ 0.09586, 0.38357, 0.08190, 36, 66, 72, 0.6 },
	{ 0.09586, 0.38357, 0.08417, 36, 66, 96, 0.6 },
	{ 0.09586, 0.38357, 0.09415, 36, 66, 120, 0.6 },
	{ 0.09586, 0.38357, 0.10919, 36, 66, 144, 0.6 },
	{ 0.09586, 0.38357, 0.12112, 36, 66, 168, 0.6 },
	{ 0.09586, 0.38357, 0.12286, 36, 66, 180, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 0, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 24, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 48, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 72, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 96, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 120, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 144, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 168, 0.6 },
	{ 0.09586, 0.53219, 0.04706, 48, 0, 180, 0.6 },
	{ 0.09586, 0.52875, 0.05132, 48, 12, 0, 0.6 },
	{ 0.09586, 0.52875, 0.05094, 48, 12, 24, 0.6 },
	{ 0.09586, 0.52875, 0.04993, 48, 12, 48, 0.6 },
	{ 0.09586, 0.52875, 0.04871, 48, 12, 72, 0.6 },
	{ 0.09586, 0.52875, 0.04766, 48, 12, 96, 0.6 },
	{ 0.09586, 0.52875, 0.04699, 48, 12, 120, 0.6 },
	{ 0.09586, 0.52875, 0.04668, 48, 12, 144, 0.6 },
	{ 0.09586, 0.52875, 0.04660, 48, 12, 168, 0.6 },
	{ 0.09586, 0.52875, 0.04660, 48, 12, 180, 0.6 },
	{ 0.09586, 0.51777, 0.05880, 48, 24, 0, 0.6 },
	{ 0.09586, 0.51777, 0.05773, 48, 24, 24, 0.6 },
	{ 0.09586, 0.51777, 0.05508, 48, 24, 48, 0.6 },
	{ 0.09586, 0.51777, 0.05221, 48, 24, 72, 0.6 },
	{ 0.09586, 0.51777, 0.05035, 48, 24, 96, 0.6 },
	{ 0.09586, 0.51777, 0.04990, 48, 24, 120, 0.6 },
	{ 0.09586, 0.51777, 0.05047, 48, 24, 144, 0.6 },
	{ 0.09586, 0.51777, 0.05113, 48, 24, 168, 0.6 },
	{ 0.09586, 0.51777, 0.05123, 48, 24, 180, 0.6 },
	{ 0.09586, 0.49686, 0.07023, 48, 36, 0, 0.6 },
	{ 0.09586, 0.49686, 0.06738, 48, 36, 24, 0.6 },
	{ 0.09586, 0.49686, 0.06269, 48, 36, 48, 0.6 },
	{ 0.09586, 0.49686, 0.05814, 48, 36, 72, 0.6 },
	{ 0.09586, 0.49686, 0.05616, 48, 36, 96, 0.6 },
	{ 0.09586, 0.49686, 0.05738, 48, 36, 120, 0.6 },
	{ 0.09586, 0.49686, 0.06070, 48, 36, 144, 0.6 },
	{ 0.09586, 0.49686, 0.06353, 48, 36, 168, 0.6 },
	{ 0.09586, 0.49686, 0.06395, 48, 36, 180, 0.6 },
	{ 0.09586, 0.46101, 0.08920, 48, 48, 0, 0.6 },
	{ 0.09586, 0.46101, 0.08079, 48, 48, 24, 0.6 },
	{ 0.09586, 0.46101, 0.07379, 48, 48, 48, 0.6 },
	{ 0.09586, 0.46101, 0.06795, 48, 48, 72, 0.6 },
	{ 0.09586, 0.46101, 0.06711, 48, 48, 96, 0.6 },
	{ 0.09586, 0.46101, 0.07250, 48, 48, 120, 0.6 },
	{ 0.09586, 0.46101, 0.08200, 48, 48, 144, 0.6 },
	{ 0.09586, 0.46101, 0.08981, 48, 48, 168, 0.6 },
	{ 0.09586, 0.46101, 0.09101, 48, 48, 180, 0.6 },
	{ 0.09586, 0.40047, 0.10593, 48, 60, 0, 0.6 },
	{ 0.09586, 0.40047, 0.10045, 48, 60, 24, 0.6 },
	{ 0.09586, 0.40047, 0.09128, 48, 60, 48, 0.6 },
	{ 0.09586, 0.40047, 0.08489, 48, 60, 72, 0.6 },
	{ 0.09586, 0.40047, 0.08742, 48, 60, 96, 0.6 },
	{ 0.09586, 0.40047, 0.10155, 48, 60, 120, 0.6 },
	{ 0.09586, 0.40047, 0.12443, 48, 60, 144, 0.6 },
	{ 0.09586, 0.40047, 0.14357, 48, 60, 168, 0.6 },
	{ 0.09586, 0.40047, 0.14648, 48, 60, 180, 0.6 },
	{ 0.09586, 0.35589, 0.11957, 48, 66, 0, 0.6 },
	{ 0.09586, 0.35589, 0.11460, 48, 66, 24, 0.6 },
	{ 0.09586, 0.35589, 0.10427, 48, 66, 48, 0.6 },
	{ 0.09586, 0.35589, 0.09797, 48, 66, 72, 0.6 },
	{ 0.09586, 0.35589, 0.10344, 48, 66, 96, 0.6 },
	{ 0.09586, 0.35589, 0.12494, 48, 66, 120, 0.6 },
	{ 0.09586, 0.35589, 0.15948, 48, 66, 144, 0.6 },
	{ 0.09586, 0.35589, 0.18911, 48, 66, 168, 0.6 },
	{ 0.09586, 0.35589, 0.19381, 48, 66, 180, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 0, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 24, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 48, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 72, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 96, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 120, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 144, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 168, 0.6 },
	{ 0.09586, 0.46230, 0.05706, 60, 0, 180, 0.6 },
	{ 0.09586, 0.45932, 0.06054, 60, 12, 0, 0.6 },
	{ 0.09586, 0.45932, 0.06020, 60, 12, 24, 0.6 },
	{ 0.09586, 0.45932, 0.05945, 60, 12, 48, 0.6 },
	{ 0.09586, 0.45932, 0.05869, 60, 12, 72, 0.6 },
	{ 0.09586, 0.45932, 0.05834, 60, 12, 96, 0.6 },
	{ 0.09586, 0.45932, 0.05857, 60, 12, 120, 0.6 },
	{ 0.09586, 0.45932, 0.05915, 60, 12, 144, 0.6 },
	{ 0.09586, 0.45932, 0.05958, 60, 12, 168, 0.6 },
	{ 0.09586, 0.45932, 0.05965, 60, 12, 180, 0.6 },
	{ 0.09586, 0.44977, 0.06934, 60, 24, 0, 0.6 },
	{ 0.09586, 0.44977, 0.06821, 60, 24, 24, 0.6 },
	{ 0.09586, 0.44977, 0.06552, 60, 24, 48, 0.6 },
	{ 0.09586, 0.44977, 0.06321, 60, 24, 72, 0.6 },
	{ 0.09586, 0.44977, 0.06276, 60, 24, 96, 0.6 },
	{ 0.09586, 0.44977, 0.06463, 60, 24, 120, 0.6 },
	{ 0.09586, 0.44977, 0.06785, 60, 24, 144, 0.6 },
	{ 0.09586, 0.44977, 0.07039, 60, 24, 168, 0.6 },
	{ 0.09586, 0.44977, 0.07075, 60, 24, 180, 0.6 },
	{ 0.09586, 0.43161, 0.08368, 60, 36, 0, 0.6 },
	{ 0.09586, 0.43161, 0.08122, 60, 36, 24, 0.6 },
	{ 0.09586, 0.43161, 0.07566, 60, 36, 48, 0.6 },
	{ 0.09586, 0.43161, 0.07134, 60, 36, 72, 0.6 },
	{ 0.09586, 0.43161, 0.07157, 60, 36, 96, 0.6 },
	{ 0.09586, 0.43161, 0.07745, 60, 36, 120, 0.6 },
	{ 0.09586, 0.43161, 0.08699, 60, 36, 144, 0.6 },
	{ 0.09586, 0.43161, 0.09458, 60, 36, 168, 0.6 },
	{ 0.09586, 0.43161, 0.09573, 60, 36, 180, 0.6 },
	{ 0.09586, 0.40047, 0.10596, 60, 48, 0, 0.6 },
	{ 0.09586, 0.40047, 0.10047, 60, 48, 24, 0.6 },
	{ 0.09586, 0.40047, 0.09130, 60, 48, 48, 0.6 },
	{ 0.09586, 0.40047, 0.08492, 60, 48, 72, 0.6 },
	{ 0.09586, 0.40047, 0.08745, 60, 48, 96, 0.6 },
	{ 0.09586, 0.40047, 0.10157, 60, 48, 120, 0.6 },
	{ 0.09586, 0.40047, 0.12445, 60, 48, 144, 0.6 },
	{ 0.09586, 0.40047, 0.14358, 60, 48, 168, 0.6 },
	{ 0.09586, 0.40047, 0.14649, 60, 48, 180, 0.6 },
	{ 0.09586, 0.34788, 0.14426, 60, 60, 0, 0.6 },
	{ 0.09586, 0.34788, 0.12986, 60, 60, 24, 0.6 },
	{ 0.09586, 0.34788, 0.11623, 60, 60, 48, 0.6 },
	{ 0.09586, 0.34788, 0.10810, 60, 60, 72, 0.6 },
	{ 0.09586, 0.34788, 0.11576, 60, 60, 96, 0.6 },
	{ 0.09586, 0.34788, 0.14597, 60, 60, 120, 0.6 },
	{ 0.09586, 0.34788, 0.19667, 60, 60, 144, 0.6 },
	{ 0.09586, 0.34788, 0.24307, 60, 60, 168, 0.6 },
	{ 0.09586, 0.34788, 0.25049, 60, 60, 180, 0.6 },
	{ 0.09586, 0.30916, 0.16493, 60, 66, 0, 0.6 },
	{ 0.09586, 0.30916, 0.15104, 60, 66, 24, 0.6 },
	{ 0.09586, 0.30916, 0.13470, 60, 66, 48, 0.6 },
	{ 0.09586, 0.30916, 0.12582, 60, 66, 72, 0.6 },
	{ 0.09586, 0.30916, 0.13778, 60, 66, 96, 0.6 },
	{ 0.09586, 0.30916, 0.18094, 60, 66, 120, 0.6 },
	{ 0.09586, 0.30916, 0.25571, 60, 66, 144, 0.6 },
	{ 0.09586, 0.30916, 0.32803, 60, 66, 168, 0.6 },
	{ 0.09586, 0.30916, 0.33996, 60, 66, 180, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 0, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 24, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 48, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 72, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 96, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 120, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 144, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 168, 0.6 },
	{ 0.09586, 0.41084, 0.06564, 66, 0, 180, 0.6 },
	{ 0.09586, 0.40819, 0.06819, 66, 12, 0, 0.6 },
	{ 0.09586, 0.40819, 0.06795, 66, 12, 24, 0.6 },
	{ 0.09586, 0.40819, 0.06740, 66, 12, 48, 0.6 },
	{ 0.09586, 0.40819, 0.06708, 66, 12, 72, 0.6 },
	{ 0.09586, 0.40819, 0.06740, 66, 12, 96, 0.6 },
	{ 0.09586, 0.40819, 0.06845, 66, 12, 120, 0.6 },
	{ 0.09586, 0.40819, 0.06981, 66, 12, 144, 0.6 },
	{ 0.09586, 0.40819, 0.07077, 66, 12, 168, 0.6 },
	{ 0.09586, 0.40819, 0.07091, 66, 12, 180, 0.6 },
	{ 0.09586, 0.39971, 0.07756, 66, 24, 0, 0.6 },
	{ 0.09586, 0.39971, 0.07640, 66, 24, 24, 0.6 },
	{ 0.09586, 0.39971, 0.07394, 66, 24, 48, 0.6 },
	{ 0.09586, 0.39971, 0.07222, 66, 24, 72, 0.6 },
	{ 0.09586, 0.39971, 0.07307, 66, 24, 96, 0.6 },
	{ 0.09586, 0.39971, 0.07703, 66, 24, 120, 0.6 },
	{ 0.09586, 0.39971, 0.08260, 66, 24, 144, 0.6 },
	{ 0.09586, 0.39971, 0.08678, 66, 24, 168, 0.6 },
	{ 0.09586, 0.39971, 0.08738, 66, 24, 180, 0.6 },
	{ 0.09586, 0.38357, 0.09412, 66, 36, 0, 0.6 },
	{ 0.09586, 0.38357, 0.09140, 66, 36, 24, 0.6 },
	{ 0.09586, 0.38357, 0.08562, 66, 36, 48, 0.6 },
	{ 0.09586, 0.38357, 0.08180, 66, 36, 72, 0.6 },
	{ 0.09586, 0.38357, 0.08406, 66, 36, 96, 0.6 },
	{ 0.09586, 0.38357, 0.09402, 66, 36, 120, 0.6 },
	{ 0.09586, 0.38357, 0.10906, 66, 36, 144, 0.6 },
	{ 0.09586, 0.38357, 0.12098, 66, 36, 168, 0.6 },
	{ 0.09586, 0.38357, 0.12274, 66, 36, 180, 0.6 },
	{ 0.09586, 0.35589, 0.11964, 66, 48, 0, 0.6 },
	{ 0.09586, 0.35589, 0.11467, 66, 48, 24, 0.6 },
	{ 0.09586, 0.35589, 0.10435, 66, 48, 48, 0.6 },
	{ 0.09586, 0.35589, 0.09805, 66, 48, 72, 0.6 },
	{ 0.09586, 0.35589, 0.10350, 66, 48, 96, 0.6 },
	{ 0.09586, 0.35589, 0.12498, 66, 48, 120, 0.6 },
	{ 0.09586, 0.35589, 0.15951, 66, 48, 144, 0.6 },
	{ 0.09586, 0.35589, 0.18915, 66, 48, 168, 0.6 },
	{ 0.09586, 0.35589, 0.19384, 66, 48, 180, 0.6 },
	{ 0.09586, 0.30916, 0.16498, 66, 60, 0, 0.6 },
	{ 0.09586, 0.30916, 0.15108, 66, 60, 24, 0.6 },
	{ 0.09586, 0.30916, 0.13474, 66, 60, 48, 0.6 },
	{ 0.09586, 0.30916, 0.12584, 66, 60, 72, 0.6 },
	{ 0.09586, 0.30916, 0.13781, 66, 60, 96, 0.6 },
	{ 0.09586, 0.30916, 0.18096, 66, 60, 120, 0.6 },
	{ 0.09586, 0.30916, 0.25572, 66, 60, 144, 0.6 },
	{ 0.09586, 0.30916, 0.32805, 66, 60, 168, 0.6 },
	{ 0.09586, 0.30916, 0.33999, 66, 60, 180, 0.6 },
	{ 0.09586, 0.27475, 0.19759, 66, 66, 0, 0.6 },
	{ 0.09586, 0.27475, 0.17769, 66, 66, 24, 0.6 },
	{ 0.09586, 0.27475, 0.15754, 66, 66, 48, 0.6 },
	{ 0.09586, 0.27475, 0.14722, 66, 66, 72, 0.6 },
	{ 0.09586, 0.27475, 0.16433, 66, 66, 96, 0.6 },
	{ 0.09586, 0.27475, 0.22457, 66, 66, 120, 0.6 },
	{ 0.09586, 0.27475, 0.33410, 66, 66, 144, 0.6 },
	{ 0.09586, 0.27475, 0.44772, 66, 66, 168, 0.6 },
	{ 0.09586, 0.27475, 0.46773, 66, 66, 180, 0.6 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 0, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 24, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 48, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 72, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 96, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 120, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 144, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 168, 0.7 },
	{ 0.10009, 0.56876, 0.04647, 0, 0, 180, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 0, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 24, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 48, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 72, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 96, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 120, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 144, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 168, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 0, 12, 180, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 0, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 24, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 48, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 72, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 96, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 120, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 144, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 168, 0.7 },
	{ 0.10009, 0.55100, 0.04391, 0, 24, 180, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 0, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 24, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 48, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 72, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 96, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 120, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 144, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 168, 0.7 },
	{ 0.10009, 0.52548, 0.04584, 0, 36, 180, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 0, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 24, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 48, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 72, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 96, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 120, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 144, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 168, 0.7 },
	{ 0.10009, 0.48235, 0.05069, 0, 48, 180, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 0, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 24, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 48, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 72, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 96, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 120, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 144, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 168, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 0, 60, 180, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 0, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 24, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 48, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 72, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 96, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 120, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 144, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 168, 0.7 },
	{ 0.10009, 0.36089, 0.06988, 0, 66, 180, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 0, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 24, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 48, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 72, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 96, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 120, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 144, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 168, 0.7 },
	{ 0.10009, 0.56452, 0.04391, 12, 0, 180, 0.7 },
	{ 0.10009, 0.56032, 0.04839, 12, 12, 0, 0.7 },
	{ 0.10009, 0.56032, 0.04746, 12, 12, 24, 0.7 },
	{ 0.10009, 0.56032, 0.04560, 12, 12, 48, 0.7 },
	{ 0.10009, 0.56032, 0.04420, 12, 12, 72, 0.7 },
	{ 0.10009, 0.56032, 0.04334, 12, 12, 96, 0.7 },
	{ 0.10009, 0.56032, 0.04277, 12, 12, 120, 0.7 },
	{ 0.10009, 0.56032, 0.04233, 12, 12, 144, 0.7 },
	{ 0.10009, 0.56032, 0.04212, 12, 12, 168, 0.7 },
	{ 0.10009, 0.56032, 0.04209, 12, 12, 180, 0.7 },
	{ 0.10009, 0.54690, 0.04773, 12, 24, 0, 0.7 },
	{ 0.10009, 0.54690, 0.04711, 12, 24, 24, 0.7 },
	{ 0.10009, 0.54690, 0.04608, 12, 24, 48, 0.7 },
	{ 0.10009, 0.54690, 0.04502, 12, 24, 72, 0.7 },
	{ 0.10009, 0.54690, 0.04396, 12, 24, 96, 0.7 },
	{ 0.10009, 0.54690, 0.04304, 12, 24, 120, 0.7 },
	{ 0.10009, 0.54690, 0.04239, 12, 24, 144, 0.7 },
	{ 0.10009, 0.54690, 0.04203, 12, 24, 168, 0.7 },
	{ 0.10009, 0.54690, 0.04199, 12, 24, 180, 0.7 },
	{ 0.10009, 0.52156, 0.04999, 12, 36, 0, 0.7 },
	{ 0.10009, 0.52156, 0.04965, 12, 36, 24, 0.7 },
	{ 0.10009, 0.52156, 0.04867, 12, 36, 48, 0.7 },
	{ 0.10009, 0.52156, 0.04739, 12, 36, 72, 0.7 },
	{ 0.10009, 0.52156, 0.04612, 12, 36, 96, 0.7 },
	{ 0.10009, 0.52156, 0.04513, 12, 36, 120, 0.7 },
	{ 0.10009, 0.52156, 0.04449, 12, 36, 144, 0.7 },
	{ 0.10009, 0.52156, 0.04421, 12, 36, 168, 0.7 },
	{ 0.10009, 0.52156, 0.04418, 12, 36, 180, 0.7 },
	{ 0.10009, 0.47876, 0.05497, 12, 48, 0, 0.7 },
	{ 0.10009, 0.47876, 0.05459, 12, 48, 24, 0.7 },
	{ 0.10009, 0.47876, 0.05358, 12, 48, 48, 0.7 },
	{ 0.10009, 0.47876, 0.05238, 12, 48, 72, 0.7 },
	{ 0.10009, 0.47876, 0.05138, 12, 48, 96, 0.7 },
	{ 0.10009, 0.47876, 0.05078, 12, 48, 120, 0.7 },
	{ 0.10009, 0.47876, 0.05054, 12, 48, 144, 0.7 },
	{ 0.10009, 0.47876, 0.05051, 12, 48, 168, 0.7 },
	{ 0.10009, 0.47876, 0.05051, 12, 48, 180, 0.7 },
	{ 0.10009, 0.40836, 0.06447, 12, 60, 0, 0.7 },
	{ 0.10009, 0.40836, 0.06414, 12, 60, 24, 0.7 },
	{ 0.10009, 0.40836, 0.06345, 12, 60, 48, 0.7 },
	{ 0.10009, 0.40836, 0.06278, 12, 60, 72, 0.7 },
	{ 0.10009, 0.40836, 0.06258, 12, 60, 96, 0.7 },
	{ 0.10009, 0.40836, 0.06297, 12, 60, 120, 0.7 },
	{ 0.10009, 0.40836, 0.06371, 12, 60, 144, 0.7 },
	{ 0.10009, 0.40836, 0.06423, 12, 60, 168, 0.7 },
	{ 0.10009, 0.40836, 0.06431, 12, 60, 180, 0.7 },
	{ 0.10009, 0.35821, 0.07215, 12, 66, 0, 0.7 },
	{ 0.10009, 0.35821, 0.07193, 12, 66, 24, 0.7 },
	{ 0.10009, 0.35821, 0.07146, 12, 66, 48, 0.7 },
	{ 0.10009, 0.35821, 0.07128, 12, 66, 72, 0.7 },
	{ 0.10009, 0.35821, 0.07180, 12, 66, 96, 0.7 },
	{ 0.10009, 0.35821, 0.07307, 12, 66, 120, 0.7 },
	{ 0.10009, 0.35821, 0.07464, 12, 66, 144, 0.7 },
	{ 0.10009, 0.35821, 0.07572, 12, 66, 168, 0.7 },
	{ 0.10009, 0.35821, 0.07588, 12, 66, 180, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 0, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 24, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 48, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 72, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 96, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 120, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 144, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 168, 0.7 },
	{ 0.10009, 0.55100, 0.04393, 24, 0, 180, 0.7 },
	{ 0.10009, 0.54690, 0.04775, 24, 12, 0, 0.7 },
	{ 0.10009, 0.54690, 0.04714, 24, 12, 24, 0.7 },
	{ 0.10009, 0.54690, 0.04610, 24, 12, 48, 0.7 },
	{ 0.10009, 0.54690, 0.04505, 24, 12, 72, 0.7 },
	{ 0.10009, 0.54690, 0.04399, 24, 12, 96, 0.7 },
	{ 0.10009, 0.54690, 0.04306, 24, 12, 120, 0.7 },
	{ 0.10009, 0.54690, 0.04241, 24, 12, 144, 0.7 },
	{ 0.10009, 0.54690, 0.04206, 24, 12, 168, 0.7 },
	{ 0.10009, 0.54690, 0.04201, 24, 12, 180, 0.7 },
	{ 0.10009, 0.53380, 0.05484, 24, 24, 0, 0.7 },
	{ 0.10009, 0.53380, 0.05174, 24, 24, 24, 0.7 },
	{ 0.10009, 0.53380, 0.04894, 24, 24, 48, 0.7 },
	{ 0.10009, 0.53380, 0.04693, 24, 24, 72, 0.7 },
	{ 0.10009, 0.53380, 0.04502, 24, 24, 96, 0.7 },
	{ 0.10009, 0.53380, 0.04356, 24, 24, 120, 0.7 },
	{ 0.10009, 0.53380, 0.04269, 24, 24, 144, 0.7 },
	{ 0.10009, 0.53380, 0.04232, 24, 24, 168, 0.7 },
	{ 0.10009, 0.53380, 0.04228, 24, 24, 180, 0.7 },
	{ 0.10009, 0.50907, 0.05676, 24, 36, 0, 0.7 },
	{ 0.10009, 0.50907, 0.05522, 24, 36, 24, 0.7 },
	{ 0.10009, 0.50907, 0.05287, 24, 36, 48, 0.7 },
	{ 0.10009, 0.50907, 0.05016, 24, 36, 72, 0.7 },
	{ 0.10009, 0.50907, 0.04792, 24, 36, 96, 0.7 },
	{ 0.10009, 0.50907, 0.04665, 24, 36, 120, 0.7 },
	{ 0.10009, 0.50907, 0.04617, 24, 36, 144, 0.7 },
	{ 0.10009, 0.50907, 0.04609, 24, 36, 168, 0.7 },
	{ 0.10009, 0.50907, 0.04610, 24, 36, 180, 0.7 },
	{ 0.10009, 0.46729, 0.06276, 24, 48, 0, 0.7 },
	{ 0.10009, 0.46729, 0.06166, 24, 48, 24, 0.7 },
	{ 0.10009, 0.46729, 0.05899, 24, 48, 48, 0.7 },
	{ 0.10009, 0.46729, 0.05614, 24, 48, 72, 0.7 },
	{ 0.10009, 0.46729, 0.05440, 24, 48, 96, 0.7 },
	{ 0.10009, 0.46729, 0.05417, 24, 48, 120, 0.7 },
	{ 0.10009, 0.46729, 0.05497, 24, 48, 144, 0.7 },
	{ 0.10009, 0.46729, 0.05578, 24, 48, 168, 0.7 },
	{ 0.10009, 0.46729, 0.05590, 24, 48, 180, 0.7 },
	{ 0.10009, 0.39858, 0.07351, 24, 60, 0, 0.7 },
	{ 0.10009, 0.39858, 0.07238, 24, 60, 24, 0.7 },
	{ 0.10009, 0.39858, 0.06974, 24, 60, 48, 0.7 },
	{ 0.10009, 0.39858, 0.06758, 24, 60, 72, 0.7 },
	{ 0.10009, 0.39858, 0.06744, 24, 60, 96, 0.7 },
	{ 0.10009, 0.39858, 0.06975, 24, 60, 120, 0.7 },
	{ 0.10009, 0.39858, 0.07341, 24, 60, 144, 0.7 },
	{ 0.10009, 0.39858, 0.07625, 24, 60, 168, 0.7 },
	{ 0.10009, 0.39858, 0.07665, 24, 60, 180, 0.7 },
	{ 0.10009, 0.34963, 0.08166, 24, 66, 0, 0.7 },
	{ 0.10009, 0.34963, 0.08052, 24, 66, 24, 0.7 },
	{ 0.10009, 0.34963, 0.07818, 24, 66, 48, 0.7 },
	{ 0.10009, 0.34963, 0.07668, 24, 66, 72, 0.7 },
	{ 0.10009, 0.34963, 0.07795, 24, 66, 96, 0.7 },
	{ 0.10009, 0.34963, 0.08247, 24, 66, 120, 0.7 },
	{ 0.10009, 0.34963, 0.08861, 24, 66, 144, 0.7 },
	{ 0.10009, 0.34963, 0.09318, 24, 66, 168, 0.7 },
	{ 0.10009, 0.34963, 0.09383, 24, 66, 180, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 0, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 24, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 48, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 72, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 96, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 120, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 144, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 168, 0.7 },
	{ 0.10009, 0.52548, 0.04591, 36, 0, 180, 0.7 },
	{ 0.10009, 0.52156, 0.05008, 36, 12, 0, 0.7 },
	{ 0.10009, 0.52156, 0.04973, 36, 12, 24, 0.7 },
	{ 0.10009, 0.52156, 0.04876, 36, 12, 48, 0.7 },
	{ 0.10009, 0.52156, 0.04747, 36, 12, 72, 0.7 },
	{ 0.10009, 0.52156, 0.04621, 36, 12, 96, 0.7 },
	{ 0.10009, 0.52156, 0.04522, 36, 12, 120, 0.7 },
	{ 0.10009, 0.52156, 0.04458, 36, 12, 144, 0.7 },
	{ 0.10009, 0.52156, 0.04430, 36, 12, 168, 0.7 },
	{ 0.10009, 0.52156, 0.04426, 36, 12, 180, 0.7 },
	{ 0.10009, 0.50907, 0.05682, 36, 24, 0, 0.7 },
	{ 0.10009, 0.50907, 0.05528, 36, 24, 24, 0.7 },
	{ 0.10009, 0.50907, 0.05294, 36, 24, 48, 0.7 },
	{ 0.10009, 0.50907, 0.05021, 36, 24, 72, 0.7 },
	{ 0.10009, 0.50907, 0.04798, 36, 24, 96, 0.7 },
	{ 0.10009, 0.50907, 0.04671, 36, 24, 120, 0.7 },
	{ 0.10009, 0.50907, 0.04623, 36, 24, 144, 0.7 },
	{ 0.10009, 0.50907, 0.04615, 36, 24, 168, 0.7 },
	{ 0.10009, 0.50907, 0.04616, 36, 24, 180, 0.7 },
	{ 0.10009, 0.48549, 0.06823, 36, 36, 0, 0.7 },
	{ 0.10009, 0.48549, 0.06266, 36, 36, 24, 0.7 },
	{ 0.10009, 0.48549, 0.05868, 36, 36, 48, 0.7 },
	{ 0.10009, 0.48549, 0.05477, 36, 36, 72, 0.7 },
	{ 0.10009, 0.48549, 0.05228, 36, 36, 96, 0.7 },
	{ 0.10009, 0.48549, 0.05169, 36, 36, 120, 0.7 },
	{ 0.10009, 0.48549, 0.05243, 36, 36, 144, 0.7 },
	{ 0.10009, 0.48549, 0.05333, 36, 36, 168, 0.7 },
	{ 0.10009, 0.48549, 0.05346, 36, 36, 180, 0.7 },
	{ 0.10009, 0.44564, 0.07479, 36, 48, 0, 0.7 },
	{ 0.10009, 0.44564, 0.07182, 36, 48, 24, 0.7 },
	{ 0.10009, 0.44564, 0.06705, 36, 48, 48, 0.7 },
	{ 0.10009, 0.44564, 0.06255, 36, 48, 72, 0.7 },
	{ 0.10009, 0.44564, 0.06084, 36, 48, 96, 0.7 },
	{ 0.10009, 0.44564, 0.06252, 36, 48, 120, 0.7 },
	{ 0.10009, 0.44564, 0.06638, 36, 48, 144, 0.7 },
	{ 0.10009, 0.44564, 0.06958, 36, 48, 168, 0.7 },
	{ 0.10009, 0.44564, 0.07004, 36, 48, 180, 0.7 },
	{ 0.10009, 0.38012, 0.08840, 36, 60, 0, 0.7 },
	{ 0.10009, 0.38012, 0.08592, 36, 60, 24, 0.7 },
	{ 0.10009, 0.38012, 0.08037, 36, 60, 48, 0.7 },
	{ 0.10009, 0.38012, 0.07626, 36, 60, 72, 0.7 },
	{ 0.10009, 0.38012, 0.07704, 36, 60, 96, 0.7 },
	{ 0.10009, 0.38012, 0.08378, 36, 60, 120, 0.7 },
	{ 0.10009, 0.38012, 0.09430, 36, 60, 144, 0.7 },
	{ 0.10009, 0.38012, 0.10259, 36, 60, 168, 0.7 },
	{ 0.10009, 0.38012, 0.10384, 36, 60, 180, 0.7 },
	{ 0.10009, 0.33343, 0.09873, 36, 66, 0, 0.7 },
	{ 0.10009, 0.33343, 0.09601, 36, 66, 24, 0.7 },
	{ 0.10009, 0.33343, 0.09031, 36, 66, 48, 0.7 },
	{ 0.10009, 0.33343, 0.08682, 36, 66, 72, 0.7 },
	{ 0.10009, 0.33343, 0.08978, 36, 66, 96, 0.7 },
	{ 0.10009, 0.33343, 0.10083, 36, 66, 120, 0.7 },
	{ 0.10009, 0.33343, 0.11712, 36, 66, 144, 0.7 },
	{ 0.10009, 0.33343, 0.12994, 36, 66, 168, 0.7 },
	{ 0.10009, 0.33343, 0.13182, 36, 66, 180, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 0, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 24, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 48, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 72, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 96, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 120, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 144, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 168, 0.7 },
	{ 0.10009, 0.48235, 0.05068, 48, 0, 180, 0.7 },
	{ 0.10009, 0.47876, 0.05497, 48, 12, 0, 0.7 },
	{ 0.10009, 0.47876, 0.05459, 48, 12, 24, 0.7 },
	{ 0.10009, 0.47876, 0.05358, 48, 12, 48, 0.7 },
	{ 0.10009, 0.47876, 0.05237, 48, 12, 72, 0.7 },
	{ 0.10009, 0.47876, 0.05137, 48, 12, 96, 0.7 },
	{ 0.10009, 0.47876, 0.05077, 48, 12, 120, 0.7 },
	{ 0.10009, 0.47876, 0.05054, 48, 12, 144, 0.7 },
	{ 0.10009, 0.47876, 0.05050, 48, 12, 168, 0.7 },
	{ 0.10009, 0.47876, 0.05051, 48, 12, 180, 0.7 },
	{ 0.10009, 0.46729, 0.06271, 48, 24, 0, 0.7 },
	{ 0.10009, 0.46729, 0.06161, 48, 24, 24, 0.7 },
	{ 0.10009, 0.46729, 0.05893, 48, 24, 48, 0.7 },
	{ 0.10009, 0.46729, 0.05608, 48, 24, 72, 0.7 },
	{ 0.10009, 0.46729, 0.05435, 48, 24, 96, 0.7 },
	{ 0.10009, 0.46729, 0.05411, 48, 24, 120, 0.7 },
	{ 0.10009, 0.46729, 0.05491, 48, 24, 144, 0.7 },
	{ 0.10009, 0.46729, 0.05572, 48, 24, 168, 0.7 },
	{ 0.10009, 0.46729, 0.05584, 48, 24, 180, 0.7 },
	{ 0.10009, 0.44564, 0.07461, 48, 36, 0, 0.7 },
	{ 0.10009, 0.44564, 0.07165, 48, 36, 24, 0.7 },
	{ 0.10009, 0.44564, 0.06688, 48, 36, 48, 0.7 },
	{ 0.10009, 0.44564, 0.06238, 48, 36, 72, 0.7 },
	{ 0.10009, 0.44564, 0.06067, 48, 36, 96, 0.7 },
	{ 0.10009, 0.44564, 0.06235, 48, 36, 120, 0.7 },
	{ 0.10009, 0.44564, 0.06621, 48, 36, 144, 0.7 },
	{ 0.10009, 0.44564, 0.06940, 48, 36, 168, 0.7 },
	{ 0.10009, 0.44564, 0.06987, 48, 36, 180, 0.7 },
	{ 0.10009, 0.40907, 0.09436, 48, 48, 0, 0.7 },
	{ 0.10009, 0.40907, 0.08552, 48, 48, 24, 0.7 },
	{ 0.10009, 0.40907, 0.07843, 48, 48, 48, 0.7 },
	{ 0.10009, 0.40907, 0.07273, 48, 48, 72, 0.7 },
	{ 0.10009, 0.40907, 0.07240, 48, 48, 96, 0.7 },
	{ 0.10009, 0.40907, 0.07869, 48, 48, 120, 0.7 },
	{ 0.10009, 0.40907, 0.08925, 48, 48, 144, 0.7 },
	{ 0.10009, 0.40907, 0.09784, 48, 48, 168, 0.7 },
	{ 0.10009, 0.40907, 0.09915, 48, 48, 180, 0.7 },
	{ 0.10009, 0.34892, 0.11109, 48, 60, 0, 0.7 },
	{ 0.10009, 0.34892, 0.10548, 48, 60, 24, 0.7 },
	{ 0.10009, 0.34892, 0.09630, 48, 60, 48, 0.7 },
	{ 0.10009, 0.34892, 0.09026, 48, 60, 72, 0.7 },
	{ 0.10009, 0.34892, 0.09368, 48, 60, 96, 0.7 },
	{ 0.10009, 0.34892, 0.10933, 48, 60, 120, 0.7 },
	{ 0.10009, 0.34892, 0.13412, 48, 60, 144, 0.7 },
	{ 0.10009, 0.34892, 0.15473, 48, 60, 168, 0.7 },
	{ 0.10009, 0.34892, 0.15786, 48, 60, 180, 0.7 },
	{ 0.10009, 0.30607, 0.12455, 48, 66, 0, 0.7 },
	{ 0.10009, 0.30607, 0.11954, 48, 66, 24, 0.7 },
	{ 0.10009, 0.30607, 0.10928, 48, 66, 48, 0.7 },
	{ 0.10009, 0.30607, 0.10346, 48, 66, 72, 0.7 },
	{ 0.10009, 0.30607, 0.11003, 48, 66, 96, 0.7 },
	{ 0.10009, 0.30607, 0.13338, 48, 66, 120, 0.7 },
	{ 0.10009, 0.30607, 0.17033, 48, 66, 144, 0.7 },
	{ 0.10009, 0.30607, 0.20188, 48, 66, 168, 0.7 },
	{ 0.10009, 0.30607, 0.20686, 48, 66, 180, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 0, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 24, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 48, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 72, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 96, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 120, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 144, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 168, 0.7 },
	{ 0.10009, 0.41143, 0.06116, 60, 0, 180, 0.7 },
	{ 0.10009, 0.40836, 0.06448, 60, 12, 0, 0.7 },
	{ 0.10009, 0.40836, 0.06415, 60, 12, 24, 0.7 },
	{ 0.10009, 0.40836, 0.06346, 60, 12, 48, 0.7 },
	{ 0.10009, 0.40836, 0.06279, 60, 12, 72, 0.7 },
	{ 0.10009, 0.40836, 0.06258, 60, 12, 96, 0.7 },
	{ 0.10009, 0.40836, 0.06297, 60, 12, 120, 0.7 },
	{ 0.10009, 0.40836, 0.06371, 60, 12, 144, 0.7 },
	{ 0.10009, 0.40836, 0.06423, 60, 12, 168, 0.7 },
	{ 0.10009, 0.40836, 0.06431, 60, 12, 180, 0.7 },
	{ 0.10009, 0.39858, 0.07346, 60, 24, 0, 0.7 },
	{ 0.10009, 0.39858, 0.07232, 60, 24, 24, 0.7 },
	{ 0.10009, 0.39858, 0.06968, 60, 24, 48, 0.7 },
	{ 0.10009, 0.39858, 0.06752, 60, 24, 72, 0.7 },
	{ 0.10009, 0.39858, 0.06738, 60, 24, 96, 0.7 },
	{ 0.10009, 0.39858, 0.06967, 60, 24, 120, 0.7 },
	{ 0.10009, 0.39858, 0.07334, 60, 24, 144, 0.7 },
	{ 0.10009, 0.39858, 0.07617, 60, 24, 168, 0.7 },
	{ 0.10009, 0.39858, 0.07657, 60, 24, 180, 0.7 },
	{ 0.10009, 0.38012, 0.08821, 60, 36, 0, 0.7 },
	{ 0.10009, 0.38012, 0.08573, 60, 36, 24, 0.7 },
	{ 0.10009, 0.38012, 0.08017, 60, 36, 48, 0.7 },
	{ 0.10009, 0.38012, 0.07608, 60, 36, 72, 0.7 },
	{ 0.10009, 0.38012, 0.07685, 60, 36, 96, 0.7 },
	{ 0.10009, 0.38012, 0.08358, 60, 36, 120, 0.7 },
	{ 0.10009, 0.38012, 0.09409, 60, 36, 144, 0.7 },
	{ 0.10009, 0.38012, 0.10238, 60, 36, 168, 0.7 },
	{ 0.10009, 0.38012, 0.10363, 60, 36, 180, 0.7 },
	{ 0.10009, 0.34892, 0.11112, 60, 48, 0, 0.7 },
	{ 0.10009, 0.34892, 0.10551, 60, 48, 24, 0.7 },
	{ 0.10009, 0.34892, 0.09632, 60, 48, 48, 0.7 },
	{ 0.10009, 0.34892, 0.09027, 60, 48, 72, 0.7 },
	{ 0.10009, 0.34892, 0.09370, 60, 48, 96, 0.7 },
	{ 0.10009, 0.34892, 0.10934, 60, 48, 120, 0.7 },
	{ 0.10009, 0.34892, 0.13413, 60, 48, 144, 0.7 },
	{ 0.10009, 0.34892, 0.15473, 60, 48, 168, 0.7 },
	{ 0.10009, 0.34892, 0.15787, 60, 48, 180, 0.7 },
	{ 0.10009, 0.29762, 0.15013, 60, 60, 0, 0.7 },
	{ 0.10009, 0.29762, 0.13529, 60, 60, 24, 0.7 },
	{ 0.10009, 0.29762, 0.12170, 60, 60, 48, 0.7 },
	{ 0.10009, 0.29762, 0.11413, 60, 60, 72, 0.7 },
	{ 0.10009, 0.29762, 0.12318, 60, 60, 96, 0.7 },
	{ 0.10009, 0.29762, 0.15584, 60, 60, 120, 0.7 },
	{ 0.10009, 0.29762, 0.20993, 60, 60, 144, 0.7 },
	{ 0.10009, 0.29762, 0.25922, 60, 60, 168, 0.7 },
	{ 0.10009, 0.29762, 0.26709, 60, 60, 180, 0.7 },
	{ 0.10009, 0.26106, 0.17054, 60, 66, 0, 0.7 },
	{ 0.10009, 0.26106, 0.15636, 60, 66, 24, 0.7 },
	{ 0.10009, 0.26106, 0.14015, 60, 66, 48, 0.7 },
	{ 0.10009, 0.26106, 0.13197, 60, 66, 72, 0.7 },
	{ 0.10009, 0.26106, 0.14558, 60, 66, 96, 0.7 },
	{ 0.10009, 0.26106, 0.19167, 60, 66, 120, 0.7 },
	{ 0.10009, 0.26106, 0.27068, 60, 66, 144, 0.7 },
	{ 0.10009, 0.26106, 0.34683, 60, 66, 168, 0.7 },
	{ 0.10009, 0.26106, 0.35938, 60, 66, 180, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 0, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 24, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 48, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 72, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 96, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 120, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 144, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 168, 0.7 },
	{ 0.10009, 0.36089, 0.06991, 66, 0, 180, 0.7 },
	{ 0.10009, 0.35821, 0.07220, 66, 12, 0, 0.7 },
	{ 0.10009, 0.35821, 0.07198, 66, 12, 24, 0.7 },
	{ 0.10009, 0.35821, 0.07151, 66, 12, 48, 0.7 },
	{ 0.10009, 0.35821, 0.07132, 66, 12, 72, 0.7 },
	{ 0.10009, 0.35821, 0.07184, 66, 12, 96, 0.7 },
	{ 0.10009, 0.35821, 0.07310, 66, 12, 120, 0.7 },
	{ 0.10009, 0.35821, 0.07467, 66, 12, 144, 0.7 },
	{ 0.10009, 0.35821, 0.07576, 66, 12, 168, 0.7 },
	{ 0.10009, 0.35821, 0.07591, 66, 12, 180, 0.7 },
	{ 0.10009, 0.34963, 0.08165, 66, 24, 0, 0.7 },
	{ 0.10009, 0.34963, 0.08051, 66, 24, 24, 0.7 },
	{ 0.10009, 0.34963, 0.07815, 66, 24, 48, 0.7 },
	{ 0.10009, 0.34963, 0.07666, 66, 24, 72, 0.7 },
	{ 0.10009, 0.34963, 0.07792, 66, 24, 96, 0.7 },
	{ 0.10009, 0.34963, 0.08243, 66, 24, 120, 0.7 },
	{ 0.10009, 0.34963, 0.08857, 66, 24, 144, 0.7 },
	{ 0.10009, 0.34963, 0.09313, 66, 24, 168, 0.7 },
	{ 0.10009, 0.34963, 0.09379, 66, 24, 180, 0.7 },
	{ 0.10009, 0.33343, 0.09859, 66, 36, 0, 0.7 },
	{ 0.10009, 0.33343, 0.09586, 66, 36, 24, 0.7 },
	{ 0.10009, 0.33343, 0.09016, 66, 36, 48, 0.7 },
	{ 0.10009, 0.33343, 0.08666, 66, 36, 72, 0.7 },
	{ 0.10009, 0.33343, 0.08962, 66, 36, 96, 0.7 },
	{ 0.10009, 0.33343, 0.10066, 66, 36, 120, 0.7 },
	{ 0.10009, 0.33343, 0.11694, 66, 36, 144, 0.7 },
	{ 0.10009, 0.33343, 0.12975, 66, 36, 168, 0.7 },
	{ 0.10009, 0.33343, 0.13164, 66, 36, 180, 0.7 },
	{ 0.10009, 0.30607, 0.12464, 66, 48, 0, 0.7 },
	{ 0.10009, 0.30607, 0.11964, 66, 48, 24, 0.7 },
	{ 0.10009, 0.30607, 0.10939, 66, 48, 48, 0.7 },
	{ 0.10009, 0.30607, 0.10356, 66, 48, 72, 0.7 },
	{ 0.10009, 0.30607, 0.11011, 66, 48, 96, 0.7 },
	{ 0.10009, 0.30607, 0.13344, 66, 48, 120, 0.7 },
	{ 0.10009, 0.30607, 0.17039, 66, 48, 144, 0.7 },
	{ 0.10009, 0.30607, 0.20194, 66, 48, 168, 0.7 },
	{ 0.10009, 0.30607, 0.20692, 66, 48, 180, 0.7 },
	{ 0.10009, 0.26106, 0.17062, 66, 60, 0, 0.7 },
	{ 0.10009, 0.26106, 0.15644, 66, 60, 24, 0.7 },
	{ 0.10009, 0.26106, 0.14022, 66, 60, 48, 0.7 },
	{ 0.10009, 0.26106, 0.13203, 66, 60, 72, 0.7 },
	{ 0.10009, 0.26106, 0.14564, 66, 60, 96, 0.7 },
	{ 0.10009, 0.26106, 0.19173, 66, 60, 120, 0.7 },
	{ 0.10009, 0.26106, 0.27073, 66, 60, 144, 0.7 },
	{ 0.10009, 0.26106, 0.34689, 66, 60, 168, 0.7 },
	{ 0.10009, 0.26106, 0.35944, 66, 60, 180, 0.7 },
	{ 0.10009, 0.22900, 0.20320, 66, 66, 0, 0.7 },
	{ 0.10009, 0.22900, 0.18292, 66, 66, 24, 0.7 },
	{ 0.10009, 0.22900, 0.16297, 66, 66, 48, 0.7 },
	{ 0.10009, 0.22900, 0.15352, 66, 66, 72, 0.7 },
	{ 0.10009, 0.22900, 0.17255, 66, 66, 96, 0.7 },
	{ 0.10009, 0.22900, 0.23626, 66, 66, 120, 0.7 },
	{ 0.10009, 0.22900, 0.35110, 66, 66, 144, 0.7 },
	{ 0.10009, 0.22900, 0.46985, 66, 66, 168, 0.7 },
	{ 0.10009, 0.22900, 0.49075, 66, 66, 180, 0.7 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 0, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 24, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 48, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 72, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 96, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 120, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 144, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 168, 0.8 },
	{ 0.10376, 0.52598, 0.04962, 0, 0, 180, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 0, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 24, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 48, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 72, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 96, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 120, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 144, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 168, 0.8 },
	{ 0.10376, 0.52154, 0.04689, 0, 12, 180, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 0, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 24, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 48, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 72, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 96, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 120, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 144, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 168, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 0, 24, 180, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 0, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 24, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 48, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 72, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 96, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 120, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 144, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 168, 0.8 },
	{ 0.10376, 0.48094, 0.04900, 0, 36, 180, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 0, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 24, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 48, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 72, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 96, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 120, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 144, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 168, 0.8 },
	{ 0.10376, 0.43687, 0.05415, 0, 48, 180, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 0, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 24, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 48, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 72, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 96, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 120, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 144, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 168, 0.8 },
	{ 0.10376, 0.36626, 0.06496, 0, 60, 180, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 0, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 24, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 48, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 72, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 96, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 120, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 144, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 168, 0.8 },
	{ 0.10376, 0.31753, 0.07373, 0, 66, 180, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 0, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 24, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 48, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 72, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 96, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 120, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 144, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 168, 0.8 },
	{ 0.10376, 0.52154, 0.04688, 12, 0, 180, 0.8 },
	{ 0.10376, 0.51713, 0.05163, 12, 12, 0, 0.8 },
	{ 0.10376, 0.51713, 0.05064, 12, 12, 24, 0.8 },
	{ 0.10376, 0.51713, 0.04866, 12, 12, 48, 0.8 },
	{ 0.10376, 0.51713, 0.04718, 12, 12, 72, 0.8 },
	{ 0.10376, 0.51713, 0.04628, 12, 12, 96, 0.8 },
	{ 0.10376, 0.51713, 0.04569, 12, 12, 120, 0.8 },
	{ 0.10376, 0.51713, 0.04524, 12, 12, 144, 0.8 },
	{ 0.10376, 0.51713, 0.04503, 12, 12, 168, 0.8 },
	{ 0.10376, 0.51713, 0.04500, 12, 12, 180, 0.8 },
	{ 0.10376, 0.50312, 0.05088, 12, 24, 0, 0.8 },
	{ 0.10376, 0.50312, 0.05023, 12, 24, 24, 0.8 },
	{ 0.10376, 0.50312, 0.04915, 12, 24, 48, 0.8 },
	{ 0.10376, 0.50312, 0.04807, 12, 24, 72, 0.8 },
	{ 0.10376, 0.50312, 0.04698, 12, 24, 96, 0.8 },
	{ 0.10376, 0.50312, 0.04604, 12, 24, 120, 0.8 },
	{ 0.10376, 0.50312, 0.04539, 12, 24, 144, 0.8 },
	{ 0.10376, 0.50312, 0.04502, 12, 24, 168, 0.8 },
	{ 0.10376, 0.50312, 0.04498, 12, 24, 180, 0.8 },
	{ 0.10376, 0.47688, 0.05325, 12, 36, 0, 0.8 },
	{ 0.10376, 0.47688, 0.05289, 12, 36, 24, 0.8 },
	{ 0.10376, 0.47688, 0.05190, 12, 36, 48, 0.8 },
	{ 0.10376, 0.47688, 0.05060, 12, 36, 72, 0.8 },
	{ 0.10376, 0.47688, 0.04933, 12, 36, 96, 0.8 },
	{ 0.10376, 0.47688, 0.04835, 12, 36, 120, 0.8 },
	{ 0.10376, 0.47688, 0.04772, 12, 36, 144, 0.8 },
	{ 0.10376, 0.47688, 0.04745, 12, 36, 168, 0.8 },
	{ 0.10376, 0.47688, 0.04742, 12, 36, 180, 0.8 },
	{ 0.10376, 0.43318, 0.05844, 12, 48, 0, 0.8 },
	{ 0.10376, 0.43318, 0.05806, 12, 48, 24, 0.8 },
	{ 0.10376, 0.43318, 0.05705, 12, 48, 48, 0.8 },
	{ 0.10376, 0.43318, 0.05586, 12, 48, 72, 0.8 },
	{ 0.10376, 0.43318, 0.05490, 12, 48, 96, 0.8 },
	{ 0.10376, 0.43318, 0.05437, 12, 48, 120, 0.8 },
	{ 0.10376, 0.43318, 0.05419, 12, 48, 144, 0.8 },
	{ 0.10376, 0.43318, 0.05420, 12, 48, 168, 0.8 },
	{ 0.10376, 0.43318, 0.05421, 12, 48, 180, 0.8 },
	{ 0.10376, 0.36317, 0.06813, 12, 60, 0, 0.8 },
	{ 0.10376, 0.36317, 0.06781, 12, 60, 24, 0.8 },
	{ 0.10376, 0.36317, 0.06716, 12, 60, 48, 0.8 },
	{ 0.10376, 0.36317, 0.06657, 12, 60, 72, 0.8 },
	{ 0.10376, 0.36317, 0.06649, 12, 60, 96, 0.8 },
	{ 0.10376, 0.36317, 0.06702, 12, 60, 120, 0.8 },
	{ 0.10376, 0.36317, 0.06789, 12, 60, 144, 0.8 },
	{ 0.10376, 0.36317, 0.06849, 12, 60, 168, 0.8 },
	{ 0.10376, 0.36317, 0.06858, 12, 60, 180, 0.8 },
	{ 0.10376, 0.31485, 0.07577, 12, 66, 0, 0.8 },
	{ 0.10376, 0.31485, 0.07557, 12, 66, 24, 0.8 },
	{ 0.10376, 0.31485, 0.07516, 12, 66, 48, 0.8 },
	{ 0.10376, 0.31485, 0.07509, 12, 66, 72, 0.8 },
	{ 0.10376, 0.31485, 0.07577, 12, 66, 96, 0.8 },
	{ 0.10376, 0.31485, 0.07722, 12, 66, 120, 0.8 },
	{ 0.10376, 0.31485, 0.07896, 12, 66, 144, 0.8 },
	{ 0.10376, 0.31485, 0.08014, 12, 66, 168, 0.8 },
	{ 0.10376, 0.31485, 0.08031, 12, 66, 180, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 0, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 24, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 48, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 72, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 96, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 120, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 144, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 168, 0.8 },
	{ 0.10376, 0.50741, 0.04691, 24, 0, 180, 0.8 },
	{ 0.10376, 0.50312, 0.05089, 24, 12, 0, 0.8 },
	{ 0.10376, 0.50312, 0.05024, 24, 12, 24, 0.8 },
	{ 0.10376, 0.50312, 0.04916, 24, 12, 48, 0.8 },
	{ 0.10376, 0.50312, 0.04808, 24, 12, 72, 0.8 },
	{ 0.10376, 0.50312, 0.04700, 24, 12, 96, 0.8 },
	{ 0.10376, 0.50312, 0.04605, 24, 12, 120, 0.8 },
	{ 0.10376, 0.50312, 0.04540, 24, 12, 144, 0.8 },
	{ 0.10376, 0.50312, 0.04504, 24, 12, 168, 0.8 },
	{ 0.10376, 0.50312, 0.04499, 24, 12, 180, 0.8 },
	{ 0.10376, 0.48950, 0.05835, 24, 24, 0, 0.8 },
	{ 0.10376, 0.48950, 0.05507, 24, 24, 24, 0.8 },
	{ 0.10376, 0.48950, 0.05214, 24, 24, 48, 0.8 },
	{ 0.10376, 0.48950, 0.05008, 24, 24, 72, 0.8 },
	{ 0.10376, 0.48950, 0.04814, 24, 24, 96, 0.8 },
	{ 0.10376, 0.48950, 0.04668, 24, 24, 120, 0.8 },
	{ 0.10376, 0.48950, 0.04582, 24, 24, 144, 0.8 },
	{ 0.10376, 0.48950, 0.04547, 24, 24, 168, 0.8 },
	{ 0.10376, 0.48950, 0.04543, 24, 24, 180, 0.8 },
	{ 0.10376, 0.46396, 0.06027, 24, 36, 0, 0.8 },
	{ 0.10376, 0.46396, 0.05866, 24, 36, 24, 0.8 },
	{ 0.10376, 0.46396, 0.05626, 24, 36, 48, 0.8 },
	{ 0.10376, 0.46396, 0.05350, 24, 36, 72, 0.8 },
	{ 0.10376, 0.46396, 0.05128, 24, 36, 96, 0.8 },
	{ 0.10376, 0.46396, 0.05007, 24, 36, 120, 0.8 },
	{ 0.10376, 0.46396, 0.04967, 24, 36, 144, 0.8 },
	{ 0.10376, 0.46396, 0.04965, 24, 36, 168, 0.8 },
	{ 0.10376, 0.46396, 0.04967, 24, 36, 180, 0.8 },
	{ 0.10376, 0.42145, 0.06643, 24, 48, 0, 0.8 },
	{ 0.10376, 0.42145, 0.06531, 24, 48, 24, 0.8 },
	{ 0.10376, 0.42145, 0.06260, 24, 48, 48, 0.8 },
	{ 0.10376, 0.42145, 0.05978, 24, 48, 72, 0.8 },
	{ 0.10376, 0.42145, 0.05815, 24, 48, 96, 0.8 },
	{ 0.10376, 0.42145, 0.05810, 24, 48, 120, 0.8 },
	{ 0.10376, 0.42145, 0.05910, 24, 48, 144, 0.8 },
	{ 0.10376, 0.42145, 0.06004, 24, 48, 168, 0.8 },
	{ 0.10376, 0.42145, 0.06018, 24, 48, 180, 0.8 },
	{ 0.10376, 0.35333, 0.07728, 24, 60, 0, 0.8 },
	{ 0.10376, 0.35333, 0.07615, 24, 60, 24, 0.8 },
	{ 0.10376, 0.35333, 0.07355, 24, 60, 48, 0.8 },
	{ 0.10376, 0.35333, 0.07151, 24, 60, 72, 0.8 },
	{ 0.10376, 0.35333, 0.07163, 24, 60, 96, 0.8 },
	{ 0.10376, 0.35333, 0.07430, 24, 60, 120, 0.8 },
	{ 0.10376, 0.35333, 0.07834, 24, 60, 144, 0.8 },
	{ 0.10376, 0.35333, 0.08142, 24, 60, 168, 0.8 },
	{ 0.10376, 0.35333, 0.08186, 24, 60, 180, 0.8 },
	{ 0.10376, 0.30632, 0.08532, 24, 66, 0, 0.8 },
	{ 0.10376, 0.30632, 0.08420, 24, 66, 24, 0.8 },
	{ 0.10376, 0.30632, 0.08193, 24, 66, 48, 0.8 },
	{ 0.10376, 0.30632, 0.08062, 24, 66, 72, 0.8 },
	{ 0.10376, 0.30632, 0.08223, 24, 66, 96, 0.8 },
	{ 0.10376, 0.30632, 0.08720, 24, 66, 120, 0.8 },
	{ 0.10376, 0.30632, 0.09380, 24, 66, 144, 0.8 },
	{ 0.10376, 0.30632, 0.09867, 24, 66, 168, 0.8 },
	{ 0.10376, 0.30632, 0.09937, 24, 66, 180, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 0, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 24, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 48, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 72, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 96, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 120, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 144, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 168, 0.8 },
	{ 0.10376, 0.48094, 0.04899, 36, 0, 180, 0.8 },
	{ 0.10376, 0.47688, 0.05324, 36, 12, 0, 0.8 },
	{ 0.10376, 0.47688, 0.05289, 36, 12, 24, 0.8 },
	{ 0.10376, 0.47688, 0.05190, 36, 12, 48, 0.8 },
	{ 0.10376, 0.47688, 0.05059, 36, 12, 72, 0.8 },
	{ 0.10376, 0.47688, 0.04932, 36, 12, 96, 0.8 },
	{ 0.10376, 0.47688, 0.04834, 36, 12, 120, 0.8 },
	{ 0.10376, 0.47688, 0.04771, 36, 12, 144, 0.8 },
	{ 0.10376, 0.47688, 0.04745, 36, 12, 168, 0.8 },
	{ 0.10376, 0.47688, 0.04741, 36, 12, 180, 0.8 },
	{ 0.10376, 0.46396, 0.06024, 36, 24, 0, 0.8 },
	{ 0.10376, 0.46396, 0.05864, 36, 24, 24, 0.8 },
	{ 0.10376, 0.46396, 0.05623, 36, 24, 48, 0.8 },
	{ 0.10376, 0.46396, 0.05347, 36, 24, 72, 0.8 },
	{ 0.10376, 0.46396, 0.05125, 36, 24, 96, 0.8 },
	{ 0.10376, 0.46396, 0.05004, 36, 24, 120, 0.8 },
	{ 0.10376, 0.46396, 0.04965, 36, 24, 144, 0.8 },
	{ 0.10376, 0.46396, 0.04962, 36, 24, 168, 0.8 },
	{ 0.10376, 0.46396, 0.04964, 36, 24, 180, 0.8 },
	{ 0.10376, 0.43976, 0.07212, 36, 36, 0, 0.8 },
	{ 0.10376, 0.43976, 0.06627, 36, 36, 24, 0.8 },
	{ 0.10376, 0.43976, 0.06219, 36, 36, 48, 0.8 },
	{ 0.10376, 0.43976, 0.05826, 36, 36, 72, 0.8 },
	{ 0.10376, 0.43976, 0.05586, 36, 36, 96, 0.8 },
	{ 0.10376, 0.43976, 0.05546, 36, 36, 120, 0.8 },
	{ 0.10376, 0.43976, 0.05641, 36, 36, 144, 0.8 },
	{ 0.10376, 0.43976, 0.05746, 36, 36, 168, 0.8 },
	{ 0.10376, 0.43976, 0.05761, 36, 36, 180, 0.8 },
	{ 0.10376, 0.39946, 0.07871, 36, 48, 0, 0.8 },
	{ 0.10376, 0.39946, 0.07565, 36, 48, 24, 0.8 },
	{ 0.10376, 0.39946, 0.07082, 36, 48, 48, 0.8 },
	{ 0.10376, 0.39946, 0.06636, 36, 48, 72, 0.8 },
	{ 0.10376, 0.39946, 0.06489, 36, 48, 96, 0.8 },
	{ 0.10376, 0.39946, 0.06697, 36, 48, 120, 0.8 },
	{ 0.10376, 0.39946, 0.07129, 36, 48, 144, 0.8 },
	{ 0.10376, 0.39946, 0.07480, 36, 48, 168, 0.8 },
	{ 0.10376, 0.39946, 0.07531, 36, 48, 180, 0.8 },
	{ 0.10376, 0.33490, 0.09234, 36, 60, 0, 0.8 },
	{ 0.10376, 0.33490, 0.08985, 36, 60, 24, 0.8 },
	{ 0.10376, 0.33490, 0.08430, 36, 60, 48, 0.8 },
	{ 0.10376, 0.33490, 0.08038, 36, 60, 72, 0.8 },
	{ 0.10376, 0.33490, 0.08161, 36, 60, 96, 0.8 },
	{ 0.10376, 0.33490, 0.08906, 36, 60, 120, 0.8 },
	{ 0.10376, 0.33490, 0.10039, 36, 60, 144, 0.8 },
	{ 0.10376, 0.33490, 0.10926, 36, 60, 168, 0.8 },
	{ 0.10376, 0.33490, 0.11058, 36, 60, 180, 0.8 },
	{ 0.10376, 0.29034, 0.10251, 36, 66, 0, 0.8 },
	{ 0.10376, 0.29034, 0.09978, 36, 66, 24, 0.8 },
	{ 0.10376, 0.29034, 0.09415, 36, 66, 48, 0.8 },
	{ 0.10376, 0.29034, 0.09092, 36, 66, 72, 0.8 },
	{ 0.10376, 0.29034, 0.09445, 36, 66, 96, 0.8 },
	{ 0.10376, 0.29034, 0.10636, 36, 66, 120, 0.8 },
	{ 0.10376, 0.29034, 0.12364, 36, 66, 144, 0.8 },
	{ 0.10376, 0.29034, 0.13718, 36, 66, 168, 0.8 },
	{ 0.10376, 0.29034, 0.13915, 36, 66, 180, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 0, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 24, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 48, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 72, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 96, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 120, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 144, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 168, 0.8 },
	{ 0.10376, 0.43687, 0.05413, 48, 0, 180, 0.8 },
	{ 0.10376, 0.43318, 0.05844, 48, 12, 0, 0.8 },
	{ 0.10376, 0.43318, 0.05806, 48, 12, 24, 0.8 },
	{ 0.10376, 0.43318, 0.05705, 48, 12, 48, 0.8 },
	{ 0.10376, 0.43318, 0.05586, 48, 12, 72, 0.8 },
	{ 0.10376, 0.43318, 0.05490, 48, 12, 96, 0.8 },
	{ 0.10376, 0.43318, 0.05436, 48, 12, 120, 0.8 },
	{ 0.10376, 0.43318, 0.05419, 48, 12, 144, 0.8 },
	{ 0.10376, 0.43318, 0.05419, 48, 12, 168, 0.8 },
	{ 0.10376, 0.43318, 0.05420, 48, 12, 180, 0.8 },
	{ 0.10376, 0.42145, 0.06640, 48, 24, 0, 0.8 },
	{ 0.10376, 0.42145, 0.06528, 48, 24, 24, 0.8 },
	{ 0.10376, 0.42145, 0.06258, 48, 24, 48, 0.8 },
	{ 0.10376, 0.42145, 0.05975, 48, 24, 72, 0.8 },
	{ 0.10376, 0.42145, 0.05812, 48, 24, 96, 0.8 },
	{ 0.10376, 0.42145, 0.05807, 48, 24, 120, 0.8 },
	{ 0.10376, 0.42145, 0.05907, 48, 24, 144, 0.8 },
	{ 0.10376, 0.42145, 0.06001, 48, 24, 168, 0.8 },
	{ 0.10376, 0.42145, 0.06015, 48, 24, 180, 0.8 },
	{ 0.10376, 0.39946, 0.07871, 48, 36, 0, 0.8 },
	{ 0.10376, 0.39946, 0.07566, 48, 36, 24, 0.8 },
	{ 0.10376, 0.39946, 0.07083, 48, 36, 48, 0.8 },
	{ 0.10376, 0.39946, 0.06637, 48, 36, 72, 0.8 },
	{ 0.10376, 0.39946, 0.06490, 48, 36, 96, 0.8 },
	{ 0.10376, 0.39946, 0.06697, 48, 36, 120, 0.8 },
	{ 0.10376, 0.39946, 0.07129, 48, 36, 144, 0.8 },
	{ 0.10376, 0.39946, 0.07480, 48, 36, 168, 0.8 },
	{ 0.10376, 0.39946, 0.07531, 48, 36, 180, 0.8 },
	{ 0.10376, 0.36286, 0.09907, 48, 48, 0, 0.8 },
	{ 0.10376, 0.36286, 0.08990, 48, 48, 24, 0.8 },
	{ 0.10376, 0.36286, 0.08273, 48, 48, 48, 0.8 },
	{ 0.10376, 0.36286, 0.07716, 48, 48, 72, 0.8 },
	{ 0.10376, 0.36286, 0.07727, 48, 48, 96, 0.8 },
	{ 0.10376, 0.36286, 0.08432, 48, 48, 120, 0.8 },
	{ 0.10376, 0.36286, 0.09578, 48, 48, 144, 0.8 },
	{ 0.10376, 0.36286, 0.10501, 48, 48, 168, 0.8 },
	{ 0.10376, 0.36286, 0.10641, 48, 48, 180, 0.8 },
	{ 0.10376, 0.30421, 0.11576, 48, 60, 0, 0.8 },
	{ 0.10376, 0.30421, 0.11005, 48, 60, 24, 0.8 },
	{ 0.10376, 0.30421, 0.10086, 48, 60, 48, 0.8 },
	{ 0.10376, 0.30421, 0.09510, 48, 60, 72, 0.8 },
	{ 0.10376, 0.30421, 0.09926, 48, 60, 96, 0.8 },
	{ 0.10376, 0.30421, 0.11615, 48, 60, 120, 0.8 },
	{ 0.10376, 0.30421, 0.14249, 48, 60, 144, 0.8 },
	{ 0.10376, 0.30421, 0.16428, 48, 60, 168, 0.8 },
	{ 0.10376, 0.30421, 0.16759, 48, 60, 180, 0.8 },
	{ 0.10376, 0.26374, 0.12899, 48, 66, 0, 0.8 },
	{ 0.10376, 0.26374, 0.12395, 48, 66, 24, 0.8 },
	{ 0.10376, 0.26374, 0.11375, 48, 66, 48, 0.8 },
	{ 0.10376, 0.26374, 0.10830, 48, 66, 72, 0.8 },
	{ 0.10376, 0.26374, 0.11575, 48, 66, 96, 0.8 },
	{ 0.10376, 0.26374, 0.14057, 48, 66, 120, 0.8 },
	{ 0.10376, 0.26374, 0.17940, 48, 66, 144, 0.8 },
	{ 0.10376, 0.26374, 0.21243, 48, 66, 168, 0.8 },
	{ 0.10376, 0.26374, 0.21765, 48, 66, 180, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 0, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 24, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 48, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 72, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 96, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 120, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 144, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 168, 0.8 },
	{ 0.10376, 0.36626, 0.06495, 60, 0, 180, 0.8 },
	{ 0.10376, 0.36317, 0.06815, 60, 12, 0, 0.8 },
	{ 0.10376, 0.36317, 0.06783, 60, 12, 24, 0.8 },
	{ 0.10376, 0.36317, 0.06718, 60, 12, 48, 0.8 },
	{ 0.10376, 0.36317, 0.06659, 60, 12, 72, 0.8 },
	{ 0.10376, 0.36317, 0.06650, 60, 12, 96, 0.8 },
	{ 0.10376, 0.36317, 0.06703, 60, 12, 120, 0.8 },
	{ 0.10376, 0.36317, 0.06790, 60, 12, 144, 0.8 },
	{ 0.10376, 0.36317, 0.06850, 60, 12, 168, 0.8 },
	{ 0.10376, 0.36317, 0.06858, 60, 12, 180, 0.8 },
	{ 0.10376, 0.35333, 0.07728, 60, 24, 0, 0.8 },
	{ 0.10376, 0.35333, 0.07615, 60, 24, 24, 0.8 },
	{ 0.10376, 0.35333, 0.07354, 60, 24, 48, 0.8 },
	{ 0.10376, 0.35333, 0.07150, 60, 24, 72, 0.8 },
	{ 0.10376, 0.35333, 0.07162, 60, 24, 96, 0.8 },
	{ 0.10376, 0.35333, 0.07427, 60, 24, 120, 0.8 },
	{ 0.10376, 0.35333, 0.07832, 60, 24, 144, 0.8 },
	{ 0.10376, 0.35333, 0.08140, 60, 24, 168, 0.8 },
	{ 0.10376, 0.35333, 0.08183, 60, 24, 180, 0.8 },
	{ 0.10376, 0.33490, 0.09239, 60, 36, 0, 0.8 },
	{ 0.10376, 0.33490, 0.08989, 60, 36, 24, 0.8 },
	{ 0.10376, 0.33490, 0.08434, 60, 36, 48, 0.8 },
	{ 0.10376, 0.33490, 0.08042, 60, 36, 72, 0.8 },
	{ 0.10376, 0.33490, 0.08164, 60, 36, 96, 0.8 },
	{ 0.10376, 0.33490, 0.08908, 60, 36, 120, 0.8 },
	{ 0.10376, 0.33490, 0.10041, 60, 36, 144, 0.8 },
	{ 0.10376, 0.33490, 0.10927, 60, 36, 168, 0.8 },
	{ 0.10376, 0.33490, 0.11060, 60, 36, 180, 0.8 },
	{ 0.10376, 0.30421, 0.11580, 60, 48, 0, 0.8 },
	{ 0.10376, 0.30421, 0.11009, 60, 48, 24, 0.8 },
	{ 0.10376, 0.30421, 0.10089, 60, 48, 48, 0.8 },
	{ 0.10376, 0.30421, 0.09512, 60, 48, 72, 0.8 },
	{ 0.10376, 0.30421, 0.09928, 60, 48, 96, 0.8 },
	{ 0.10376, 0.30421, 0.11617, 60, 48, 120, 0.8 },
	{ 0.10376, 0.30421, 0.14251, 60, 48, 144, 0.8 },
	{ 0.10376, 0.30421, 0.16429, 60, 48, 168, 0.8 },
	{ 0.10376, 0.30421, 0.16760, 60, 48, 180, 0.8 },
	{ 0.10376, 0.25504, 0.15529, 60, 60, 0, 0.8 },
	{ 0.10376, 0.25504, 0.14013, 60, 60, 24, 0.8 },
	{ 0.10376, 0.25504, 0.12657, 60, 60, 48, 0.8 },
	{ 0.10376, 0.25504, 0.11944, 60, 60, 72, 0.8 },
	{ 0.10376, 0.25504, 0.12959, 60, 60, 96, 0.8 },
	{ 0.10376, 0.25504, 0.16419, 60, 60, 120, 0.8 },
	{ 0.10376, 0.25504, 0.22091, 60, 60, 144, 0.8 },
	{ 0.10376, 0.25504, 0.27241, 60, 60, 168, 0.8 },
	{ 0.10376, 0.25504, 0.28063, 60, 60, 180, 0.8 },
	{ 0.10376, 0.22111, 0.17541, 60, 66, 0, 0.8 },
	{ 0.10376, 0.22111, 0.16104, 60, 66, 24, 0.8 },
	{ 0.10376, 0.22111, 0.14492, 60, 66, 48, 0.8 },
	{ 0.10376, 0.22111, 0.13729, 60, 66, 72, 0.8 },
	{ 0.10376, 0.22111, 0.15216, 60, 66, 96, 0.8 },
	{ 0.10376, 0.22111, 0.20049, 60, 66, 120, 0.8 },
	{ 0.10376, 0.22111, 0.28269, 60, 66, 144, 0.8 },
	{ 0.10376, 0.22111, 0.36166, 60, 66, 168, 0.8 },
	{ 0.10376, 0.22111, 0.37466, 60, 66, 180, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 0, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 24, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 48, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 72, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 96, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 120, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 144, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 168, 0.8 },
	{ 0.10376, 0.31753, 0.07375, 66, 0, 180, 0.8 },
	{ 0.10376, 0.31485, 0.07582, 66, 12, 0, 0.8 },
	{ 0.10376, 0.31485, 0.07563, 66, 12, 24, 0.8 },
	{ 0.10376, 0.31485, 0.07521, 66, 12, 48, 0.8 },
	{ 0.10376, 0.31485, 0.07513, 66, 12, 72, 0.8 },
	{ 0.10376, 0.31485, 0.07581, 66, 12, 96, 0.8 },
	{ 0.10376, 0.31485, 0.07726, 66, 12, 120, 0.8 },
	{ 0.10376, 0.31485, 0.07899, 66, 12, 144, 0.8 },
	{ 0.10376, 0.31485, 0.08017, 66, 12, 168, 0.8 },
	{ 0.10376, 0.31485, 0.08034, 66, 12, 180, 0.8 },
	{ 0.10376, 0.30632, 0.08536, 66, 24, 0, 0.8 },
	{ 0.10376, 0.30632, 0.08423, 66, 24, 24, 0.8 },
	{ 0.10376, 0.30632, 0.08195, 66, 24, 48, 0.8 },
	{ 0.10376, 0.30632, 0.08065, 66, 24, 72, 0.8 },
	{ 0.10376, 0.30632, 0.08224, 66, 24, 96, 0.8 },
	{ 0.10376, 0.30632, 0.08720, 66, 24, 120, 0.8 },
	{ 0.10376, 0.30632, 0.09380, 66, 24, 144, 0.8 },
	{ 0.10376, 0.30632, 0.09867, 66, 24, 168, 0.8 },
	{ 0.10376, 0.30632, 0.09936, 66, 24, 180, 0.8 },
	{ 0.10376, 0.29034, 0.10260, 66, 36, 0, 0.8 },
	{ 0.10376, 0.29034, 0.09988, 66, 36, 24, 0.8 },
	{ 0.10376, 0.29034, 0.09423, 66, 36, 48, 0.8 },
	{ 0.10376, 0.29034, 0.09100, 66, 36, 72, 0.8 },
	{ 0.10376, 0.29034, 0.09452, 66, 36, 96, 0.8 },
	{ 0.10376, 0.29034, 0.10642, 66, 36, 120, 0.8 },
	{ 0.10376, 0.29034, 0.12369, 66, 36, 144, 0.8 },
	{ 0.10376, 0.29034, 0.13722, 66, 36, 168, 0.8 },
	{ 0.10376, 0.29034, 0.13921, 66, 36, 180, 0.8 },
	{ 0.10376, 0.26374, 0.12909, 66, 48, 0, 0.8 },
	{ 0.10376, 0.26374, 0.12406, 66, 48, 24, 0.8 },
	{ 0.10376, 0.26374, 0.11386, 66, 48, 48, 0.8 },
	{ 0.10376, 0.26374, 0.10840, 66, 48, 72, 0.8 },
	{ 0.10376, 0.26374, 0.11583, 66, 48, 96, 0.8 },
	{ 0.10376, 0.26374, 0.14063, 66, 48, 120, 0.8 },
	{ 0.10376, 0.26374, 0.17945, 66, 48, 144, 0.8 },
	{ 0.10376, 0.26374, 0.21249, 66, 48, 168, 0.8 },
	{ 0.10376, 0.26374, 0.21770, 66, 48, 180, 0.8 },
	{ 0.10376, 0.22111, 0.17549, 66, 60, 0, 0.8 },
	{ 0.10376, 0.22111, 0.16111, 66, 60, 24, 0.8 },
	{ 0.10376, 0.22111, 0.14498, 66, 60, 48, 0.8 },
	{ 0.10376, 0.22111, 0.13734, 66, 60, 72, 0.8 },
	{ 0.10376, 0.22111, 0.15221, 66, 60, 96, 0.8 },
	{ 0.10376, 0.22111, 0.20054, 66, 60, 120, 0.8 },
	{ 0.10376, 0.22111, 0.28272, 66, 60, 144, 0.8 },
	{ 0.10376, 0.22111, 0.36170, 66, 60, 168, 0.8 },
	{ 0.10376, 0.22111, 0.37471, 66, 60, 180, 0.8 },
	{ 0.10376, 0.19169, 0.20794, 66, 66, 0, 0.8 },
	{ 0.10376, 0.19169, 0.18741, 66, 66, 24, 0.8 },
	{ 0.10376, 0.19169, 0.16762, 66, 66, 48, 0.8 },
	{ 0.10376, 0.19169, 0.15882, 66, 66, 72, 0.8 },
	{ 0.10376, 0.19169, 0.17928, 66, 66, 96, 0.8 },
	{ 0.10376, 0.19169, 0.24557, 66, 66, 120, 0.8 },
	{ 0.10376, 0.19169, 0.36425, 66, 66, 144, 0.8 },
	{ 0.10376, 0.19169, 0.48665, 66, 66, 168, 0.8 },
	{ 0.10376, 0.19169, 0.50818, 66, 66, 180, 0.8 }};
#pragma endregion 
	int searchSolZen = 0, searchSenZen = 0, searchRelAzi = 0;
	int trueSolzen = 0, trueSenZen = 0, trueRelAzi = 0;
	int trueRow = 0;
	float minthereflectivity = 0, thereflectivity = 0;
	//int outTableCol = searchTabColCount ;    //ұ ұ87У8*7ұ40*7
	//int outTableRow = aod550Count * intervalCount;			//ұ
	//int inTableCol = searchTabColCount ;					//ұ
	//int inTableRow = aod550Count ;							//ұ
  /////////////////////////////////////////////////////////////////
	//2ұintable,outtable ,ΪµĲҵĲ
	//float** outTable = new	float*[outTableRow];
	//for (int i = 0; i < outTableRow; i++)
	//{
	//	outTable[i] = new float[outTableCol];
	//}
	//float** inTable = new	float*[inTableRow];//87
	//for (int i = 0; i < inTableRow; i++)
	//{
	//	inTable[i] = new float[inTableCol];
	//}

	//for (int i = 0; i < inTableRow; i++)
	//{
	//	for (int  j = 0; j < inTableCol; j++)
	//	{
	//		inTable[i][j] = 0.0;
	//	}

	//}
	//////////////////////////////////////////////////
	//
	for (int i = 0; i < height; i++)
	{
		for (int j = 0; j < width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				aodOptimal[i][j] = aodSumSearchTable[0][0];//ʼһ Ĭȸһֵ
				/*SearchOptimalResultFromOld(i, j, &trueRow);*/
				searchSolZen = solZenCount - 1, searchSenZen = senZenCount - 1, searchRelAzi = solAziCount -1;//Ĭֵ
				minthereflectivity = 1000000000;//minvalΪ㹻ֵ
				float devk1 = 0, devk2 = 0, devk3 = 0;
				float devkk1 = 0, devkk2, devkk3 = 0;
				for (int k = 0; k<solZenCount; k++)
					{
						if (solarzenith[i][j]<solZen[k])
						{
							searchSolZen = k;
							break;
						}
					}
				for (int k = 0; k<senZenCount; k++)
				{
					if (sensorzenith[i][j]<senZen[k])
					{
						searchSenZen = k;
						break;
					}
				}
				for (int k = 0; k<solAziCount; k++)
				{
					if ((relativeangel[i][j])<solAzi[k])
					{
						searchRelAzi = k;
						break;
					}
				}
				devk1 = solZen[searchSolZen] - solZen[searchSolZen - 1];
				devk2 = senZen[searchSenZen] - senZen[searchSenZen - 1];
				devk3 = solAzi[searchRelAzi] - solAzi[searchRelAzi - 1];
				if (solarzenith[i][j]>(solZen[searchSolZen - 1] + solZen[searchSolZen]) / 2)
				{
					devkk1 = abs (solarzenith[i][j] - solZen[searchSolZen]);
					trueSolzen = searchSolZen;
				}
				else
				{
					devkk1 = abs (solarzenith[i][j] - solZen[searchSolZen - 1]);
					trueSolzen = searchSolZen - 1;
				}
				if (sensorzenith[i][j]>(senZen[searchSenZen - 1] + senZen[searchSenZen]) / 2)
				{
					devkk2 = abs (sensorzenith[i][j] - senZen[searchSenZen]);
					trueSenZen = searchSenZen;
				}
				else
				{
					devkk2 = abs (sensorzenith[i][j] - senZen[searchSenZen - 1]);
					trueSenZen = searchSenZen - 1;
				}
				if (solarazimuth[i][j]>(solAzi[searchRelAzi - 1] + solAzi[searchRelAzi]) / 2)
				{
					devkk3 = abs (solarazimuth[i][j] - solAzi[searchRelAzi]);
					trueRelAzi = searchRelAzi;
				}
				else
				{
					devkk3 = abs (solarazimuth[i][j] - solAzi[searchRelAzi - 1]);
					trueRelAzi = searchRelAzi - 1;
				}
				//const int solZenCount = 8;
				//const int senZenCount = 7;
				//const int solAziCount = 9;
				//const int aod550Count = 6;
			
				trueRow = (senZenCount * solAziCount) * trueSolzen + (solAziCount) * trueSenZen + (1) * trueRelAzi;
#pragma region new 
	//			////intable ֵ
	//			//for (int i = 0; i < inTableRow; i++)
	//			//{
	//			//	for (int j = 0; j < inTableCol; j++)
	//			//	{
	//			//		inTable[i][j] = aodSumSearchTable[trueRow + i * solAziCount*senZenCount*solZenCount][j];
	//			//	}
	//			//}
	//			CreateNewSeachTable(inTable, outTable, inTableCol, inTableRow, outTableCol, outTableRow);
	//			aodOptimal[i][j] =SearchOptimalResultFromNew(i,j,outTable,outTableRow,outTableCol);
	//		}
	//	}
	//}



#pragma region 
#pragma region old
				double err[6] = { 0 };
				int pp = 0;
				while (trueRow<3969)
				{
					if (seasonDay > 90 && seasonDay <273)//ʹļұ
					{
						thereflectivity = aodSumSearchTable[trueRow][2] + aodSumSearchTable[trueRow][1] * suf_band_1[i][j] / (1 - aodSumSearchTable[trueRow][0] * suf_band_1[i][j]);
						 err[pp++] = fabs(thereflectivity - band_1[i][j]);
						if (fabs (thereflectivity - band_1[i][j])<fabs (minthereflectivity - band_1[i][j]))
						{
							minthereflectivity = thereflectivity;
							//aodOptimal[i][j] = aodSumSearchTable[trueRow][6];
						}
					}
					else //ұ
					{
						thereflectivity = aodWinSearchTable[trueRow][2] + aodWinSearchTable[trueRow][1] * suf_band_1[i][j] / (1 - aodWinSearchTable[trueRow][0] * suf_band_1[i][j]);
						err[pp++] = fabs(thereflectivity - band_1[i][j]);
						//if (fabs (thereflectivity - band_1[i][j])<fabs (minthereflectivity - band_1[i][j]))
						//{
						//	//minthereflectivity = thereflectivity;
						//	//aodOptimal[i][j] = aodWinSearchTable[trueRow][6];
						//}
					}
					trueRow += 441;
				}
				aodOptimal[i][j] = Mean(err, 6, aod550);
			}
		}
	}
#pragma endregion 

	//		if (seasonDay > 90 && seasonDay <273 )//ļ
	//		{
	//			//int num=omp_get_num_procs();
	//			//omp_set_num_threads(num);
	////#pragma omp parallel
	//			for ( int i=0;i<height;i++)
	//			{
	//				for ( int j=0;j<width;j++)
	//				{
	//					minthereflectivity =1000000;
	//					if (testresult[i][j]==anxiangyuan)
	//					{
	//						for (int k=0;k<3024;k++)
	//						{
	//							thereflectivity =aodSumSearchTable[k][2] + aodSumSearchTable[k][1] * suf_band_1[i][j] /(1- aodSumSearchTable[k][0] * suf_band_1[i][j]);
	//							if (fabs(thereflectivity-band_1[i][j])<fabs(minthereflectivity-band_1[i][j]))
	//							{
	//								minthereflectivity =thereflectivity;
	//								aodOptimal[i][j]=aodSumSearchTable[k][6];
	//							}
	//						}
	//					}
	//				}
	//			}
	//		}
	//		else
	//		{
	//			//int num=omp_get_num_procs();
	//			//omp_set_num_threads(num);
	//			//#pragma omp parallel
	//			for ( int i=0;i<height;i++)
	//			{
	//				for ( int j=0;j<width;j++)
	//				{
	//					minthereflectivity =1000000;
	//					if (testresult[i][j]==anxiangyuan)
	//					{
	//
	//						for (int k=0;k<3024;k++)
	//						{
	//
	//							thereflectivity =aodWinSearchTable[k][2] + aodWinSearchTable[k][1] * suf_band_1[i][j] /(1- aodWinSearchTable[k][0] * suf_band_1[i][j]);
	//							double a =fabs(thereflectivity-band_1[i][j]);
	//							double b =fabs(minthereflectivity-band_1[i][j]);
	//							if (a<b)
	//							{
	//								minthereflectivity =thereflectivity;
	//								aodOptimal[i][j]=aodWinSearchTable[k][6];
	//							}
	//						}
	//					}
	//				}
	//			}
	//
	//		}
}



void AODRectifyHeight ()
{
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				//aodOptimal[i][j] += 0.00877 * pow (0.55, -4.05) * (1 - exp (-500 / 8.5));
				aodOptimal[i][j] += 0;
			}
		}
	}
}
int ImageCut (const char* pszSrcFile, const char* pszDstFile, int iStartX, int iStartY, int iSizeX, int iSizeY,
	const char* pszFormat)
{
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *pSrcDS = (GDALDataset*)GDALOpen (pszSrcFile, GA_ReadOnly);
	GDALDataType eDT = pSrcDS->GetRasterBand (1)->GetRasterDataType ();

	int iBandCount = pSrcDS->GetRasterCount ();

	// ݲзΧȷкͼ
	int iDstWidth = iSizeX;
	int iDstHeight = iSizeY;

	double adfGeoTransform[6] = { 0 };
	pSrcDS->GetGeoTransform (adfGeoTransform);

	// кͼϽ	
	adfGeoTransform[0] = adfGeoTransform[0] + iStartX*adfGeoTransform[1] + iStartY*adfGeoTransform[2];
	adfGeoTransform[3] = adfGeoTransform[3] + iStartX*adfGeoTransform[4] + iStartY*adfGeoTransform[5];

	// ļÿռοϢ
	GDALDriver *poDriver = (GDALDriver *)GDALGetDriverByName (pszFormat);
	GDALDataset *pDstDS = poDriver->Create (pszDstFile, iDstWidth, iDstHeight, iBandCount, eDT, NULL);
	pDstDS->SetGeoTransform (adfGeoTransform);
	pDstDS->SetProjection (pSrcDS->GetProjectionRef ());

	int *pBandMap = new int[iBandCount];
	for (int i = 0; i<iBandCount; i++)
		pBandMap[i] = i + 1;

	// Ҫжϣ벻ͬ͵Ļд8bitͼʾ
	if (eDT == GDT_Float32)
	{
		// ҪĻ棬ͼ̫Ӧ÷ֿ鴦
		DT_32F *pDataBuff = new DT_32F[iDstWidth*iDstHeight*iBandCount];

		pSrcDS->RasterIO (GF_Read, iStartX, iStartY, iSizeX, iSizeY, pDataBuff, iSizeX, iSizeY, eDT, iBandCount, pBandMap, 0, 0, 0);
		pDstDS->RasterIO (GF_Write, 0, 0, iSizeX, iSizeY, pDataBuff, iSizeX, iSizeY, eDT, iBandCount, pBandMap, 0, 0, 0);

		RELEASE (pDataBuff);
	}
	else
	{
		// ͵ͼ8bitƣĻͲͬ
	}

	RELEASE (pBandMap);

	GDALClose ((GDALDatasetH)pSrcDS);
	GDALClose ((GDALDatasetH)pDstDS);
	return RE_SUCCESS;
}
/* double SortForBuf(double* buf ,int sizeOfBuf)
{
double temp ;
for (int i=0;i<sizeOfBuf;i++)
{
for (int j=i;j<sizeOfBuf;j++)
{
if (buf[i]>buf[j])
{
temp =buf[i];
buf[i]=buf[j];
buf[j]=temp;
}
}
}
temp =buf[sizeOfBuf/2];
return temp;
}*/
int cmp (const void *a, const void *b)
{
	return *(double *)a > *(double *)b ? 1 : -1;
}
int AODShow (const char* geolocDataFile, const char* midFile, const char* spapceFilerFile, const char* dstFile)
{
	if (geolocDataFile == NULL || midFile == NULL || spapceFilerFile == NULL || dstFile == NULL)
	{
		return RE_PARAMERROR;
	}
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DSData = (GDALDataset*)GDALOpen (geolocDataFile, GA_ReadOnly);
	if (DSData == NULL)
	{
		return RE_FILENOTSUPPORT;
	}
	double geoTransform[6] = { 0 };
	DSData->GetGeoTransform (geoTransform);
	//int xSize =DSData->GetRasterXSize();
	//int ySize =DSData->GetRasterYSize();
#pragma endregion 
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	GDALDataset *DSMid = Driver->Create (midFile, width, height, 1, GDT_Float32, NULL);
	DSMid->SetProjection (DSData->GetProjectionRef ());
	DSMid->SetGeoTransform (geoTransform);
#pragma region дļرݼ
	//DT_64F *pBuf = (DT_64F*)malloc(sizeof(DT_64F)* width	* height);
	DT_32F *pBuf = new DT_32F[width*height];
	int p = 0;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				pBuf[p] = aodOptimal[i][j] * 1000;
			}
			else
			{
				pBuf[p] = 0.0;
			}
			p++;

		}
	}
	//
	/*FILE *fp11;
	if (fp11 = fopen ("e:\\test\\apbufaodoptimal.txt", "wt+"))
	{
		for (int i = 0; i<height; i++)
		{
			for (int j = 0; j<width; j++)
			{

				fprintf (fp11, "%8.2lf\t", aodOptimal[i][j] * 1000);
			}
			fprintf (fp11, "\n");
		}

	}
	fclose (fp11);*/


	//FILE *fp12;
	//if (fp12 = fopen ("e:\\test\\apbufaodbuf.txt", "wt+"))
	//{
	//	for (int i = 0; i<width*height; i++)
	//	{
	//		if (i%width == 0)
	//		{
	//			fprintf (fp12, "\n");
	//		}
	//		else
	//		{
	//			fprintf (fp12, "%8.2lf\t", pBuf[i]);
	//		}
	//	}
	//}
	//fclose (fp12);

	DSMid->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, width, height, pBuf, width, height, GDT_Float32, 0, 0);
	//delete[]pBuf;
	RELEASE(pBuf);
	GDALClose (GDALDatasetH (DSData));
	GDALClose (GDALDatasetH (DSMid));

#pragma endregion 
	//ULLON='107.096';人
	// ULLAT='34.03'
	// LRLON='117.233'
	// LRLAT='27.177'



	//	ULLON='112.991';Ŀо
	//		ULLAT='43.81'
	//	LRLON='125.912'
	//	LRLAT='34.126'
	double	lonmin = 98.0083;
	double lonmax = 112.0083;
	//double latmin =34.126; //34.0708
	double latmin = 24.0068;
	double latmax = 35.0030;
	//
	//double	lonmin = 120;
	//double lonmax = 130;
	////double latmin =34.126; //34.0708
	//double latmin = 38;
	//double latmax = 47;
	double startX, startY, endX, endY;
	startX = 0; startY = 0; endX = width; endY = height;
	bool flagStartX = false, flagStartY = false, flagEndX = false, flagEndY = false;
	double lon, lat;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			lon = geoTransform[0] + geoTransform[1] * j + geoTransform[2] * i;
			lat = geoTransform[3] + geoTransform[4] * j + geoTransform[5] * i;
			/*if (flagStartX == false && lon >lonmin)
			{
				startX = j;
				flagStartX = true;
			}
			if (flagStartY == false && lat<latmax)
			{
				startY = i ;
				flagStartY = true;
			}
			if (flagEndX == false && lon>lonmax)
			{
				endX = j;
				flagEndX = true;
			}
			if (flagEndY == false && lat<latmin)
			{
				endY = i;
				flagEndY = true;
			}*/
			if (!flagStartX && lon >lonmin)
			{
				startX = j;
				flagStartX = true;
			}
			if (!flagStartY && lat<latmax)
			{
				startY = i ;
				flagStartY = true;
			}
			if (!flagEndX&& lon>lonmax)
			{
				endX = j;
				flagEndX = true;
			}
			if (!flagEndY && lat<latmin)
			{
				endY = i;
				flagEndY = true;
			}
		}
		if (flagStartX && flagStartY && flagEndX && flagEndY)
		{
			break;
		}
	}
	int imageCutResult = ImageCut (midFile, spapceFilerFile, startX, startY, endX - startX , endY - startY , "GTiff");
	if (imageCutResult != RE_SUCCESS)
	{
		return imageCutResult;
	}
	//int template3_3[9]={0,1,0,1,-4,1,0,1,0};
	GDALDataset *FilDs = (GDALDataset*)GDALOpen (spapceFilerFile, GA_ReadOnly);
	int xSize = FilDs->GetRasterXSize ();
	int ySize = FilDs->GetRasterYSize ();
	FilDs->GetGeoTransform (geoTransform);
	GDALDataset *DstDS = Driver->Create (dstFile, xSize, ySize, 1, GDT_Float32, NULL);
	DstDS->SetGeoTransform (geoTransform);
	DstDS->SetProjection (FilDs->GetProjectionRef ());

	//DT_64F *pBuf1 = (DT_64F*)malloc(sizeof(DT_64F)*xSize * ySize);
	DT_32F *pBuf1 = new DT_32F[xSize*ySize];
	FilDs->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf1, xSize, ySize, GDT_Float32, 0, 0);
	DT_32F **pBuf2, **pBuf3;
	pBuf2 = new float*[ySize];
	pBuf3 = new float*[ySize];
	for (int i = 0; i<ySize; i++)
	{
		pBuf2[i] = new float[xSize];
		pBuf3[i] = new float[xSize];
	}
	p = 0;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			pBuf2[i][j] = pBuf1[p++];
			//pBuf3[i][j]=0.0;
		}
	}

	////pBuf2鿴
	//FILE *fp;
	//if (fp=fopen("e:\\test\\apbuf2.txt","wt+"))
	//{
	//	for ( int i=0;i<ySize;i++)  
	//	{
	//		for ( int j=0;j<xSize;j++)
	//		{
	//			fprintf(fp,"%8.2lf\t",pBuf2[i][j]);
	//		}	
	//		fprintf(fp,"\n");
	//	}
	//}
	//fclose(fp);
#pragma region ֵ



	int nodataCount = 0;
	int top = 1;
	int ang = 1;
	int center = 2;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			nodataCount = 0;
			if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
			{
				pBuf3[i][j] = pBuf2[i][j];
			}
			else
			{
				if (pBuf2[i - 1][j - 1] == 0.0)nodataCount++;
				if (pBuf2[i - 1][j + 1] == 0.0)nodataCount++;
				if (pBuf2[i + 1][j - 1] == 0.0)nodataCount++;
				if (pBuf2[i + 1][j + 1] == 0.0)nodataCount++;

				if (pBuf2[i][j - 1] == 0.0)nodataCount += top;
				if (pBuf2[i][j + 1] == 0.0)nodataCount += top;
				if (pBuf2[i - 1][j] == 0.0)nodataCount += top;
				if (pBuf2[i + 1][j] == 0.0)nodataCount += top;
				if (pBuf2[i][j] == 0.0)nodataCount += top;
				int all = 4 * top + ang * 4 + center;
				if (nodataCount == 4 * top + ang * 4 + center)
				{
					pBuf3[i][j] = 0.0;
				}
				else
				{
					pBuf3[i][j] = (pBuf2[i - 1][j] * top + pBuf2[i + 1][j] * top + pBuf2[i][j - 1] * top + pBuf2[i][j + 1] * top + pBuf2[i][j] * center + pBuf2[i - 1][j - 1]*ang + pBuf2[i - 1][j + 1]*ang + pBuf2[i + 1][j - 1]*ang + pBuf2[i + 1][j + 1] *ang) / (all - nodataCount);
				}
			}
		}
	}
	//for (int i = 0; i<ySize; i++)
	//{
	//	for (int j = 0; j<xSize; j++)
	//	{
	//		nodataCount = 0;
	//		if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
	//		{
	//			pBuf2[i][j] = pBuf3[i][j];
	//		}
	//		else
	//		{
	//			if (pBuf3[i - 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf3[i - 1][j + 1] == 0.0)nodataCount++;
	//			if (pBuf3[i + 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf3[i + 1][j + 1] == 0.0)nodataCount++;

	//			if (pBuf3[i][j - 1] == 0.0)nodataCount += top;
	//			if (pBuf3[i][j + 1] == 0.0)nodataCount += top;
	//			if (pBuf3[i - 1][j] == 0.0)nodataCount += top;
	//			if (pBuf3[i + 1][j] == 0.0)nodataCount += top;
	//			if (pBuf3[i][j] == 0.0)nodataCount += center;
	//			int all = 4 * top + ang * 4 + center;
	//			if (nodataCount == 16)
	//			{
	//				pBuf2[i][j] = 0.0;
	//			}
	//			else
	//			{
	//				pBuf2[i][j] = (pBuf3[i - 1][j] * top + pBuf3[i + 1][j] * top + pBuf3[i][j - 1] * top + pBuf3[i][j + 1] * top + pBuf3[i][j] * center + pBuf3[i - 1][j - 1]*ang + pBuf3[i - 1][j + 1]*ang + pBuf2[i + 1][j - 1]*ang + pBuf2[i + 1][j + 1]* ang) / (all - nodataCount);
	//			}
	//		}
	//	}
	//}
	//for (int i = 0; i<ySize; i++)
	//{
	//	for (int j = 0; j<xSize; j++)
	//	{
	//		nodataCount = 0;
	//		if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
	//		{
	//			pBuf3[i][j] = pBuf2[i][j];
	//		}
	//		else
	//		{
	//			if (pBuf2[i - 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf2[i - 1][j + 1] == 0.0)nodataCount++;
	//			if (pBuf2[i + 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf2[i + 1][j + 1] == 0.0)nodataCount++;

	//			if (pBuf2[i][j - 1] == 0.0)nodataCount += top;
	//			if (pBuf2[i][j + 1] == 0.0)nodataCount += top;
	//			if (pBuf2[i - 1][j] == 0.0)nodataCount += top;
	//			if (pBuf2[i + 1][j] == 0.0)nodataCount += top;
	//			if (pBuf2[i][j] == 0.0)nodataCount += top;
	//			int all = 4 * top + ang * 4 + center;
	//			if (nodataCount == 4 * top + ang * 4 + center)
	//			{
	//				pBuf3[i][j] = 0.0;
	//			}
	//			else
	//			{
	//				pBuf3[i][j] = (pBuf2[i - 1][j] * top + pBuf2[i + 1][j] * top + pBuf2[i][j - 1] * top + pBuf2[i][j + 1] * top + pBuf2[i][j] * center + pBuf2[i - 1][j - 1] * ang + pBuf2[i - 1][j + 1] * ang + pBuf2[i + 1][j - 1] * ang + pBuf2[i + 1][j + 1] * ang) / (all - nodataCount);
	//			}
	//		}
	//	}
	//}

#pragma endregion
	//int avgSize =5;
	//int borderSize ;
	//double *pBuf4 =new double[avgSize*avgSize];
	//for (int i=0;i<ySize;i++)
	//{
	//	for( int j=0;j<xSize;j++)
	//	{
	//		borderSize =(int)avgSize/2;
	//		if (i<borderSize|| i>ySize-borderSize-1 || j<borderSize || j>xSize-borderSize-1)//߽粻 5*5
	//		{
	//			pBuf3[i][j]=pBuf2[i][j];
	//		}
	//		else	//ȡֵ
	//		{
	//			       p =0;
	//				for ( int ii=i-borderSize;ii<=i+borderSize;ii++)
	//				{
	//					for (int jj=j-borderSize;jj<=j+borderSize;jj++)
	//					{
	//						pBuf4[p]=pBuf2[ii][jj];
	//						p++;
	//					}
	//				}
	//			//pbuf4ȡֵ				
	//			qsort(pBuf4,avgSize*avgSize,sizeof(pBuf4[0]),cmp);
	//			pBuf3[i][j]=pBuf4[avgSize*avgSize/2];
	//		}

	//	}
	//}
	//pBuf3鿴
	/*FILE *fp3;
	if (fp3=fopen("e:\\test\\apbuf3.txt","wt+"))
	{
	for ( int i=0;i<ySize;i++)
	{
	for ( int j=0;j<xSize;j++)
	{

	fprintf(fp3,"%8.2lf\t",pBuf3[i][j]);

	}
	fprintf(fp3,"\n");
	}

	}
	fclose(fp3);*/


	//////////////////////////////////////////////////////////////////////////
	p = 0;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			if (pBuf3[i][j]<0)
				/*if(pBuf2[i][j]<0)*/
			{
				pBuf1[p] = 0.0;
			}
			else
			{
				pBuf1[p] = pBuf3[i][j];
				//pBuf1[p] =pBuf2[i][j];
			}
			p++;
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf1, xSize, ySize, GDT_Float32, 0, 0);
	GDALSetRasterNoDataValue (GDALGetRasterBand (GDALDatasetH (DstDS), 1), 0.0);
	for (int i = 0; i<ySize; i++)
	{
		RELEASE (pBuf2[i]);
		RELEASE (pBuf3[i]);
		//delete []pBuf3[i];
	}
	//		delete []pBuf4;
	//delete []pBuf1;
	RELEASE (pBuf2);
	RELEASE (pBuf3);
	RELEASE (pBuf1);
	GDALClose (GDALDatasetH (FilDs));
	GDALClose (GDALDatasetH (DstDS));
	return RE_SUCCESS;
}
int AODInversion (const char* pszSrcFile2, const char* pszSrcFile3, const char* pszDstFile, int deleteFile)
{
#pragma region 1.modis2лȡļ
	string tempFileName = string (CPLGetFilename (pszSrcFile2));
	tempFileName = tempFileName.substr (0, tempFileName.find_last_of ("hdf") - 21);
	string tempPath = string (CPLGetPath (pszSrcFile2));
	tempFileName = tempPath + "\\" + tempFileName;
	string tempCreateDataFile = tempFileName + "_data.tif";//ѧݼļ
	string tempCreateAngelFile = tempFileName + "_angel.tif";//Ƕݼļ
	string tempGeolocDataFile = tempFileName + "_geolocdata.tif";//ѧݼļ
	string tempGeolocAngelFile = tempFileName + "_geolocangel.tif";//Ƕݼļ
	string tempCloudFile = tempFileName + "_cloud.tif";//ļ
	string tempWaterFile = tempFileName + "_water.tif";//ˮļ
	string tempDarkPixelFile = tempFileName + "_darkpixel.tif";//Ԫļ
	string tempCutFile = tempFileName + "_cutimage.tif";//üָ
	//string tempImageCutFile =tempFileName + "d";//ü
	string tempSpaceFilter = tempFileName + "_spacefilter.tif";//ռ˲
#pragma endregion 		
#pragma region 2.ѧݼͽǶݼĺϳ
	//printf ("ʼѧݼͽǶݼĺϳ...\n");
	int createDataResult = AODCreateData (pszSrcFile2, pszSrcFile3, tempCreateDataFile.c_str ());//ϳɿѧݼ
	if (createDataResult != RE_SUCCESS)
	{
		return createDataResult;
	}
	int createAngelResult = AODCreateAngel (pszSrcFile2, pszSrcFile3, tempCreateAngelFile.c_str ());//ϳɵĽǶݼ
	if (createAngelResult != RE_SUCCESS)
	{
		return createAngelResult;
	}


#pragma endregion
#pragma region 3.ȡmodis3ĽϢ
	//char** geolocOptions=NULL;
	//geolocOptions = new char*[8];
	//for (int i=0;i<8;i++)
	//{
	//	geolocOptions[i]=new char[50];
	//}
	////char geolocOptions[8][50]={0};
	//int getGeolocResult =AODGetGeolocOfModis3(pszSrcFile3,&geolocOptions);
	//if (getGeolocResult!=RE_SUCCESS)
	//{
	//	return getGeolocResult;
	//}
#pragma region 3.1עݼ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS3 = (GDALDataset*)GDALOpen (pszSrcFile3, GA_ReadOnly);
	char **subdatasets = GDALGetMetadata ((GDALDatasetH)DS3, "SUBDATASETS");
#pragma endregion
#pragma region 3.2ȡγݼ͵һݼ
	string strSubDataset_1 = string (subdatasets[0]);//һݼ
	strSubDataset_1 = strSubDataset_1.substr (strSubDataset_1.find_first_of ("=") + 1);
	const char* SrcFile3_1 = strSubDataset_1.c_str ();

	string strLat = string (subdatasets[24]);//lat
	strLat = strLat.substr (strLat.find_first_of ("=") + 1);
	const char* charLat = strLat.c_str ();

	string strLon = string (subdatasets[26]);//lon
	strLon = strLon.substr (strLon.find_first_of ("=") + 1);
	const char* charLon = strLon.c_str ();
#pragma endregion 
#pragma region 3.3ȡһݼgeoloc
	GDALDataset *DS3_1 = (GDALDataset*)GDALOpen (SrcFile3_1, GA_ReadOnly);
	char **geolocOptions3 = DS3_1->GetMetadata ("GEOLOCATION");
	char **geolocOptions = geolocOptions3;
	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
	if (geolocOptions3 == NULL)
	{
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_OFFSET", "0");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_OFFSET", "0");
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "X_BAND", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "Y_BAND", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "X_DATASET", charLon);
		geolocOptions = CSLSetNameValue (geolocOptions, "Y_DATASET", charLat);
	}
	else
	{
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
	}
	GDALClose (GDALDatasetH (DS3));
#pragma endregion 	
#pragma endregion
#pragma region ѧݼͽǶݼ
	//printf ("ʼѧݼͽǶݼ...\n");
	const char* fileFormat = "GTiff";
	int geolocDataResult = ImageWarpByGeoLoc (tempCreateDataFile.c_str (), tempGeolocDataFile.c_str (), geolocOptions, GRA_NearestNeighbour, fileFormat);
	if (geolocDataResult != RE_SUCCESS)
	{
		return geolocDataResult;
	}
	int geolocAngelResult = ImageWarpByGeoLoc (tempCreateAngelFile.c_str (), tempGeolocAngelFile.c_str (), geolocOptions, GRA_NearestNeighbour, fileFormat);
	if (geolocAngelResult != RE_SUCCESS)
	{
		return geolocAngelResult;
	}
	////////////////////////////////////////////////////////////////////////////////////////////////////
		GDALClose(GDALDatasetH(DS3_1));//رݼ
#pragma endregion
#pragma region ʼ
	//printf ("ʼaodݼ...\n");
	AODInitialize (tempGeolocDataFile.c_str (), tempGeolocAngelFile.c_str ());
#pragma endregion
#pragma region ȡ
	AODGetSeason (pszSrcFile2);
#pragma endregion 
#pragma region ȥƺˮ
	AODIdentifyCloudAndWater ();
#pragma endregion
#pragma region ȷر
	AODConfirmSurfaceReflectance ();
#pragma endregion
#pragma region AODļ
	AODCalculate ();
#pragma endregion
#pragma region ߶Ƚ
	AODRectifyHeight ();
	
#pragma endregion
#pragma region AOD
	int aodShowResult = AODShow (tempGeolocDataFile.c_str (), tempCutFile.c_str (), tempSpaceFilter.c_str (), pszDstFile);
	if (aodShowResult != RE_SUCCESS)
	{
		return aodShowResult;
	}
	//ULLON='107.096';人
	// ULLAT='34.03'
	// LRLON='117.233'
	// LRLAT='27.177'
	/* double lonlat[4]= {107.096,117.233,27.177,24.03};
	int startX,startY,XSize,YSize;
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8","NO");
	GDALDataset *SrcDS =(GDALDataset*)GDALOpen(pszDstFile,)
	for (int i=0;i<height;i++)
	{
	for ( int j=0;j<width;j++)
	{
	if ()
	{
	}
	}
	}
	int aodImageCutResult =ImageCut(pszDstFile,tempImageCutFile.c_str(),startX,startY,XSize,YSize,"GTiff");
	if (aodImageCutResult!=RE_SUCCESS)
	{
	return aodImageCutResult;
	}*/
#pragma endregion
#pragma region мļɾ
	if (deleteFile == 0)
	{
		remove (tempCreateDataFile.c_str ());//ļ
		remove (tempCreateAngelFile.c_str ());//Ƕļ
		remove (tempGeolocDataFile.c_str ());//ļ
		remove (tempGeolocAngelFile.c_str ());//ĽǶļ
	}
	else if (deleteFile == 1)
	{

		AODOutputOther (tempGeolocDataFile.c_str (), tempCloudFile.c_str (), yun);
		AODOutputOther (tempGeolocDataFile.c_str (), tempWaterFile.c_str (), shui);
		AODOutputOther (tempGeolocDataFile.c_str (), tempDarkPixelFile.c_str (), anxiangyuan);
		remove (tempCreateDataFile.c_str ());//ļ
		remove (tempCreateAngelFile.c_str ());//Ƕļ
		remove (tempGeolocAngelFile.c_str ());//ĽǶļ
	}
#pragma endregion 
#pragma region ͷԴ
	AODDestroy ();
#pragma endregion
	return RE_SUCCESS;
}
void PMGetSeason (const char* SrcFile2)
{
	//"E:\\fire2\\firetest\\MOD279\\0220\\MOD021KM.A2014279.0220.006.2014283045932.hdf";
	//AOD.MYD021KM.A2014279.0535.006.TIF
	string tempFileName = string (CPLGetFilename (SrcFile2));
	tempFileName = tempFileName.substr (tempFileName.find_last_of ("tif") - 15, 3);
	seasonDay = (double)CPLScanDouble (tempFileName.c_str (), 20);
}
int PM25Inversion (const char* pszAodFile, const char* pszDstFile, double ha, double rh)
{
	//AOD.MOD021KM.A2014195.0245.006.tif
	//const char* pszTempFile ="e:\\test\01060315.tif";
	//ha,rhж
	PMGetSeason(pszAodFile);
	//seasonDay = 6;

	if (ha == -1)
	{
		if (seasonDay>90 && seasonDay <273)
		{
			ha = 0.8;
		}
		else
		{
			ha = 0.5;
		}
	}
	if (rh == -1)
	{
		rh = 63;
	}

	//ݼȡϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen (pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize ();
	int YSize = AODDS->GetRasterYSize ();
	GDALDataType dataType = AODDS->GetRasterBand (1)->GetRasterDataType ();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform (geoTransForm);
	//̬
	//float **pmkadry;
	float **pmdata;
	float **pmresult;
	//pmkadry = new double*[YSize];
	pmdata = new float*[YSize];
	pmresult = new float*[YSize];
	for (int i = 0; i<YSize; i++)
	{
		//pmkadry[i] = new double[XSize];
		pmdata[i] = new float[XSize];
		pmresult[i] = new float[XSize];
	}
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	int p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pmdata[i][j] = pBuf[p++] / 1000.0;
		}
	}
	//ϵ
	float aa = 28.981, bb = 18.1999;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			if (fabs(pmdata[i][j] -0.0) < MIN_VALUE)
			{
				pmresult[i][j] = 0.0;
			}
			else
			{
				pmresult[i][j] = (pmdata[i][j] * ha / (1 - rh / 100.0)) * aa + bb;
			}
			
		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	//
	//GDALDriver *Driver2 = (GDALDriver*)GDALGetDriverByName ("GTiff");
	//GDALDataset *tempDstDS =Driver->Create(pszTempFile,XSize,YSize,1,dataType,NULL);
	GDALDataset *DstDS = Driver->Create (pszDstFile, XSize, YSize, 1, dataType, NULL);
	DstDS->SetGeoTransform (geoTransForm);
	//
	//tempDstDS->SetGeoTransform(geoTransForm);
	//tempDstDS->SetProjection(AODDS->GetProjectionRef());
	DstDS->SetProjection (AODDS->GetProjectionRef ());
	GDALSetRasterNoDataValue (GDALGetRasterBand (GDALDatasetH (DstDS), 1), 0.0);
	//		GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(tempDstDS),1),0.0);
	p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			  pBuf[p++]=pmresult[i][j];
			//pBuf[p++] = pmkadry[i][j];
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//
	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
	RELEASE(pBuf);
	GDALClose ((GDALDatasetH)DstDS);
	GDALClose ((GDALDatasetH)AODDS);
	//GDALClose((GDALDatasetH)tempDstDS);
	for (int i = 0; i<YSize; i++)
	{
		//RELEASE(pmkadry[i]);
		RELEASE(pmdata[i]);
		RELEASE(pmresult[i]);
	}
	//RELEASE(pmkadry);
	RELEASE(pmdata);
	RELEASE(pmresult);
	return RE_SUCCESS;
}
int PM10Inversion(const char* pszAodFile, const char* pszDstFile, double ha, double rh)
{
	//AOD.MOD021KM.A2014195.0245.006.tif
	//const char* pszTempFile ="e:\\test\01060315.tif";
	//ha,rhж
	PMGetSeason(pszAodFile);
	//seasonDay = 6;

	if (ha == -1)
	{
		if (seasonDay>90 && seasonDay <273)
		{
			ha = 0.8;
		}
		else
		{
			ha = 0.5;
		}
	}
	if (rh == -1)
	{
		rh = 63;
	}

	//ݼȡϢ
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen(pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize();
	int YSize = AODDS->GetRasterYSize();
	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform(geoTransForm);
	//̬
	//float **pmkadry;
	float **pmdata;
	float **pmresult;
	//pmkadry = new double*[YSize];
	pmdata = new float*[YSize];
	pmresult = new float*[YSize];
	for (int i = 0; i<YSize; i++)
	{
		//pmkadry[i] = new double[XSize];
		pmdata[i] = new float[XSize];
		pmresult[i] = new float[XSize];
	}
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	int p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pmdata[i][j] = pBuf[p++] / 1000.0;
		}
	}
	//ϵ
	float aa = 38.686, bb = 41.294;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			if (fabs(pmdata[i][j] - 0.0) < MIN_VALUE)
			{
				pmresult[i][j] = 0.0;
			}
			else
			{
				pmresult[i][j] = (pmdata[i][j] * ha / (1 - rh / 100.0)) * aa + bb;
			}

		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
	//
	//GDALDriver *Driver2 = (GDALDriver*)GDALGetDriverByName("GTiff");
	//GDALDataset *tempDstDS =Driver->Create(pszTempFile,XSize,YSize,1,dataType,NULL);
	GDALDataset *DstDS = Driver->Create(pszDstFile, XSize, YSize, 1, dataType, NULL);
	DstDS->SetGeoTransform(geoTransForm);
	//
	//tempDstDS->SetGeoTransform(geoTransForm);
	//tempDstDS->SetProjection(AODDS->GetProjectionRef());
	DstDS->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS), 1), 0.0);
	//		GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(tempDstDS),1),0.0);
	p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pBuf[p++] = pmresult[i][j];
			//pBuf[p++] = pmkadry[i][j];
		}
	}
	DstDS->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//
	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
	RELEASE(pBuf);
	GDALClose((GDALDatasetH)DstDS);
	GDALClose((GDALDatasetH)AODDS);
	//GDALClose((GDALDatasetH)tempDstDS);
	for (int i = 0; i<YSize; i++)
	{
		//RELEASE(pmkadry[i]);
		RELEASE(pmdata[i]);
		RELEASE(pmresult[i]);
	}
	//RELEASE(pmkadry);
	RELEASE(pmdata);
	RELEASE(pmresult);
	return RE_SUCCESS;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
int Haze(const char* pszAodFile, const char* pszDstFile1 , const char* pszDstFile2)
{

	enum MySeasonType
	{
		unknow = 0,
		spring = 1,
		summer = 2,
		autumn = 3,
		winter = 4

	};
	MySeasonType myseason; 
	////////////////////////////////////////////////////////////////////////////////////////////////////
	const float chengmi_spring_a = 4.9704, chengmi_spring_b = - 0.68;
	const float chengmi_summer_a = 5.323,  chengmi_summer_b = -0.9902;
	const float chengmi_autumn_a = 4.5399, chengmi_autumn_b = -0.568;
	const float chengmi_winter_a = 2.9976, chengmi_winter_b = -0.557;

	const float biaogao_spring_a = 0.8132, biaogao_spring_b = -0.2214;
	const float biaogao_summer_a = 0.7669, biaogao_summer_b = -0.4898;
	const float biaogao_autumn_a = 0.7402, biaogao_autumn_b = -0.1166;
	const float biaogao_winter_a = 0.3682, biaogao_winter_b = -0.2144;
///////////////////////////////////////////////////////////////////////////////////////////////////////
	float chengmi_a, chengmi_b;   //a ϵ4.9704 bη //ݷabϵ
	float biaogao_a, biaogao_b; // ߷abϵa(0.8132) b0.2214
	/*
	Spring summer and autumn winter
				ݷ
	ڣ		v =4.9704 *^(-0.68)
	ڣļ		v =5.323  *^(-0.902)
	ڣ＾		v =4.5399 *^(-0.568)
	ڣ   	v =2.9976 *^(-0.557)
	*/
	
	/*
				߷
		V=3.1912*0.8132/(-0.2214)
	ļ	V=3.1912*0.7669/(-0.4898)
	＾	V=3.1912*0.7402/(-0.1166)
		V=3.1912*0.0.3682/(-0.2144)

	*/
	/*
	

	    V<=1km    RH>95%

	   1km<v<10km  RH>95%

	ϼ    v<10km    80%<RH<95%
		V<10km     RH<80%
	//////////////////////////////////////////
	΢      5.0<=v<10
	      3.0<=V<5.0
	ж      2.0<=V<3.0
	ض       V<2.0

	*/
	//PMGetSeason(pszAodFile);
	if (seasonDay >= 60 && seasonDay < 152)
	{
		myseason = spring;
		chengmi_a = chengmi_spring_a;
		chengmi_b = chengmi_spring_b;
		biaogao_a = biaogao_spring_a;
		biaogao_b = biaogao_spring_b;
	}
	else if (seasonDay >= 152 && seasonDay < 244)
	{
		myseason = summer;
		chengmi_a = chengmi_summer_a;
		chengmi_b = chengmi_summer_b;
		biaogao_a = biaogao_summer_a;
		biaogao_b = biaogao_summer_b;

	}
	else if (seasonDay >= 244 && seasonDay < 335)
	{
		myseason = autumn;
		chengmi_a = chengmi_autumn_a;
		chengmi_b = chengmi_autumn_b;
		biaogao_a = biaogao_autumn_a;
		biaogao_b = biaogao_autumn_b;
	}
	else 
	{
		myseason = winter;
		chengmi_a = chengmi_winter_a;
		chengmi_b = chengmi_winter_b;
		biaogao_a = biaogao_winter_a;
		biaogao_b = biaogao_winter_b;
	}
	//
	////////////////////////////////
	//myseason = summer; 
	//a = 5.323;
	//b = -0.902;
	//a = 0.7669;//
	//b = 0.4898;//

	
	myseason = spring;
	chengmi_a = chengmi_spring_a;
	chengmi_b = chengmi_spring_b;
	biaogao_a = biaogao_spring_a;
	biaogao_b = biaogao_spring_b;
	
	/*myseason = summer;
	chengmi_a = chengmi_summer_a;
	chengmi_b = chengmi_summer_b;
	biaogao_a = biaogao_summer_a;
	biaogao_b = biaogao_summer_b;*/
		////////////////////////////////
	//ݼȡϢ
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen(pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize();
	int YSize = AODDS->GetRasterYSize();
	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform(geoTransForm);
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	
	//߽
	/*
			V = 3.1912*0.8132 / ( - 0.2214)
		ļ	V = 3.1912*0.7669 / ( - 0.4898)
		＾	V = 3.1912*0.7402 / ( - 0.1166)
			V = 3.1912*0.0.3682 / ( - 0.2144)
		*/
	for (int i = 0; i < XSize*YSize; i++)
	{
		if (pBuf[i]< MIN_VALUE && pBuf[i] > -MIN_VALUE) //nodata
		{
			pBuf[i] = 0;
		}
		else
		{
			pBuf[i] = 3.912* biaogao_a / (pBuf[i]- biaogao_b);
			if (pBuf[i]< 0) 
			{
				pBuf[i] = 15;
			}
			else if (pBuf[i] >15)
			{
				pBuf[i] = 15;
			}
		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
	GDALDataset *DstDS1 = Driver->Create(pszDstFile1, XSize, YSize, 1, dataType, NULL);
	GDALDataset *DstDS2 = Driver->Create(pszDstFile2, XSize, YSize, 1, dataType, NULL);
	DstDS1->SetGeoTransform(geoTransForm);
	DstDS1->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS1), 1), 0.0);
	DstDS1->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);



	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//ݽ
	/*
	    ڣ		v = 4.9704 *t ^ (-0.68)
		ڣļ		v = 5.323  *t ^ (-0.902)
		ڣ＾		v = 4.5399 *t ^ (-0.568)
		ڣ   	v = 2.9976 *t ^ (-0.557)
		*/
	for (int i = 0; i < XSize*YSize; i++)
	{
		if (pBuf[i]< MIN_VALUE && pBuf[i] > -MIN_VALUE) //nodata
		{
			pBuf[i] = 0;
		}
		else
		{
			pBuf[i] = chengmi_a * pow(pBuf[i] , chengmi_b);
			if (pBuf[i]< 0) 
			{
				pBuf[i] = 15;
			}
			else if (pBuf[i] >15)
			{
				pBuf[i] = 15;
			}
		}
	}

	DstDS2->SetGeoTransform(geoTransForm);
	DstDS2->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS2), 1), 0.0);
	DstDS2->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	RELEASE(pBuf);
	GDALClose((GDALDatasetH)DstDS1);
	GDALClose((GDALDatasetH)DstDS2);
	GDALClose((GDALDatasetH)AODDS);
	return RE_SUCCESS;
}



//int FillingEmptyValue(const char* inFile, const char* outFile)
//{
//	GDALAllRegister();
//	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
//	GDALDataset *AODDS = (GDALDataset*)GDALOpen(inFile, GA_ReadOnly);
//	int XSize = AODDS->GetRasterXSize();
//	int YSize = AODDS->GetRasterYSize();
//	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
//	double geoTransForm[6] = { 0 };
//	AODDS->GetGeoTransform(geoTransForm);
//	float **pmdata;
//	float **pmresult;
//	//pmkadry = new double*[YSize];
//	pmdata = new float*[YSize];
//	pmresult = new float*[YSize];
//	for (int i = 0; i<YSize; i++)
//	{
//		//pmkadry[i] = new double[XSize];
//		pmdata[i] = new float[XSize];
//		pmresult[i] = new float[XSize];
//	}
//	float *pBuf = new float[XSize*YSize];
//	//ȡ
//	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
//	int p = 0;
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			pmdata[i][j] = pBuf[p++] / 1000.0;
//		}
//	}
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			if (fabs(pmdata[i][j] - 0.0) < MIN_VALUE)
//			{
//				//pmresult[i][j] = SearchValue(i,j)
//
//			}
//			else
//			{
//				pmresult[i][j] = pmdata[i][j];
//			}
//
//		}
//	}
//	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
//	GDALDataset *DstDS = Driver->Create(outFile, XSize, YSize, 1, dataType, NULL);
//	DstDS->SetGeoTransform(geoTransForm);
//	DstDS->SetProjection(AODDS->GetProjectionRef());
//	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS), 1), 0.0);
//	p = 0;
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			pBuf[p++] = pmresult[i][j];
//			//pBuf[p++] = pmkadry[i][j];
//		}
//	}
//	DstDS->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
//	//
//	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
//	RELEASE(pBuf);
//	GDALClose((GDALDatasetH)DstDS);
//	GDALClose((GDALDatasetH)AODDS);
//	//GDALClose((GDALDatasetH)tempDstDS);
//	for (int i = 0; i<YSize; i++)
//	{
//		//RELEASE(pmkadry[i]);
//		RELEASE(pmdata[i]);
//		RELEASE(pmresult[i]);
//	}
//	//RELEASE(pmkadry);
//	RELEASE(pmdata);
//	RELEASE(pmresult);
//	return RE_SUCCESS;
//
//}



