/***************************************************************************
*
* Time: 2013-06-27
* Project: ң㷨ʾ
* Purpose: ң㷨ʾ
* Author:  ¼
* Copyright (c) 2013, liminlu0314@163.com
* Describe: ң㷨ʾе㷨У
*           ûж·ԼļǷڽм飬
*           ĬΪеǺ
*
****************************************************************************/

#define _CRT_SECURE_NO_WARNINGS
#include "GDALAir.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include<algorithm>
#include "omp.h"
#include "gdal_alg.h"
#include <queue>
using namespace std;
#pragma region ͼǶ

/**
* @brief ͼУתṹ
*/
struct TransformChain
{
	/*! GDALתָ */
	GDALTransformerFunc GDALTransformer;
	/*! GDALת */
	void *              GDALTransformerArg;
	/*! ͼ6 */
	double              adfGeotransform[6];
	/*! ͼ6 */
	double              adfInvGeotransform[6];
};

/**
* @brief һת
*
* úڴһͼͶӰתͼк
* @sa DestroyGeoToPixelTransform
* @returns GDALתصĲ \ref GeoToPixelTransform
*/
void *CreateGeoToPixelTransform (GDALTransformerFunc GDALTransformer, void *GDALTransformerArg, double *padfGeotransform)
{
	TransformChain *pChain = new TransformChain;
	pChain->GDALTransformer = GDALTransformer;
	pChain->GDALTransformerArg = GDALTransformerArg;
	memcpy (pChain->adfGeotransform, padfGeotransform, sizeof(double)* 6);

	if (!GDALInvGeoTransform (pChain->adfGeotransform, pChain->adfInvGeotransform))
	{
		// ͼܼܽб任
		delete pChain;
		return NULL;
	}
	return (void*)pChain;
}

/**
* @brief ת
*/
void DestroyGeoToPixelTransform (void *GeoToPixelTransfomArg)
{
	delete static_cast<TransformChain *>(GeoToPixelTransfomArg);
}

/**
* @brief ת
* @sa CreateGeoToPixelTransform
*/
int GeoToPixelTransform (void *pTransformerArg, int bDstToSrc, int nPointCount,
	double *x, double *y, double *z, int *panSuccess)
{
	TransformChain *pChain = static_cast<TransformChain*>(pTransformerArg);
	if (pChain == NULL)
		return FALSE;

	if (!bDstToSrc)	//任
	{
		// ȵGDALеתתΪͼͶӰ
		if (!pChain->GDALTransformer (pChain->GDALTransformerArg, bDstToSrc, nPointCount, x, y, z, panSuccess))
			return FALSE;

		// ٴͼͶӰϵתͼк
#pragma omp parallel for
		for (int i = 0; i < nPointCount; ++i)
		{
			if (!panSuccess[i])
				continue;

			double xP = x[i];
			double yP = y[i];
			GDALApplyGeoTransform (pChain->adfInvGeotransform, xP, yP, &x[i], &y[i]);
		}
	}
	else	//任
	{
		// ȴͼкתͼͶӰϵ
#pragma omp parallel for
		for (int i = 0; i < nPointCount; ++i)
		{
			double P = x[i];
			double L = y[i];
			GDALApplyGeoTransform (pChain->adfGeotransform, P, L, &x[i], &y[i]);
		}
		// ٵGDALתͼͶӰתԭʼ
		if (!pChain->GDALTransformer (pChain->GDALTransformerArg, bDstToSrc, nPointCount, x, y, z, panSuccess))
			return FALSE;
	}

	return TRUE;
}
int ImageWarpByGeoLoc(const char * pszSrcFile, const char * pszDstFile, char **papszGeoLocOptions,
	GDALResampleAlg eResampleMethod, const char * pszFormat)
{
	// ǰҪļ·жϣﲻжֱӴ
	if (pszSrcFile == NULL || pszDstFile == NULL || papszGeoLocOptions == NULL || pszFormat == NULL)
	{
		return RE_PARAMERROR;
	}
	GDALAllRegister();

	// ԭʼͼ񲢼ͼϢ
	GDALDatasetH hSrcDS = GDALOpen(pszSrcFile, GA_ReadOnly);
	GDALDataType eDT = GDALGetRasterDataType(GDALGetRasterBand(hSrcDS, 1));	//ȡ
	int iBandCount = GDALGetRasterCount(hSrcDS);

	// Geolocתϵ
	void *hTransformArg = GDALCreateGeoLocTransformer(hSrcDS, papszGeoLocOptions, FALSE);
	if (hTransformArg == NULL)
	{
		GDALClose(hSrcDS);
		return RE_PARAMERROR;
	}

	// ʹSuggestedWarpOutputͼΧСϢ
	double adfGeoTransform[6];
	double adfExtent[4];
	int    nPixels, nLines;

	if (GDALSuggestedWarpOutput2(hSrcDS, GDALGeoLocTransform, hTransformArg,
		adfGeoTransform, &nPixels, &nLines, adfExtent, 0) != CE_None)
	{
		GDALClose(hSrcDS);
		return RE_PARAMERROR;
	}

	// ͼ
	GDALDriverH hDriver = GDALGetDriverByName(pszFormat);
	GDALDatasetH hDstDS = GDALCreate(hDriver, pszDstFile, nPixels, nLines, iBandCount, eDT, NULL);
	GDALSetProjection(hDstDS, SRS_WKT_WGS84);	//GeoLocУWGS84γϵͳ
	GDALSetGeoTransform(hDstDS, adfGeoTransform);

	// GDALWarpı任ѡ
	GDALWarpOptions *psWO = GDALCreateWarpOptions();

	psWO->papszWarpOptions = CSLDuplicate(NULL);
	psWO->eWorkingDataType = eDT;
	psWO->eResampleAlg = GRA_NearestNeighbour;

	psWO->hSrcDS = hSrcDS;
	psWO->hDstDS = hDstDS;

	psWO->pfnTransformer = GeoToPixelTransform;
	psWO->pTransformerArg = CreateGeoToPixelTransform(GDALGeoLocTransform, hTransformArg, adfGeoTransform);

	//psWO->pfnProgress = ALGTermProgress;
	//psWO->pProgressArg = pProcess;

	psWO->nBandCount = iBandCount;
	psWO->panSrcBands = (int *)CPLMalloc(psWO->nBandCount*sizeof(int));
	psWO->panDstBands = (int *)CPLMalloc(psWO->nBandCount*sizeof(int));
	/*psWO->panSrcBands = new int[psWO->nBandCount];
	psWO->panDstBands = new int[psWO->nBandCount];*/
	for (int i = 0; i < iBandCount; i++)
	{
		psWO->panSrcBands[i] = i + 1;
		psWO->panDstBands[i] = i + 1;
	}

	// GDALWarpִж󣬲ʹGDALWarpOptionsгʼ
	GDALWarpOperation oWO;
	oWO.Initialize(psWO);

	// ִд
	oWO.ChunkAndWarpImage(0, 0, nPixels, nLines);

	// ͷԴ͹رļ
	////delete []psWO->panSrcBands;
	///delete[] psWO->panDstBands;
	//delete[] psWO->panSrcBands;
	//delete[] psWO->panDstBands;
	//CPLFree(psWO->panSrcBands);
	//CPLFree(psWO->panDstBands);
	DestroyGeoToPixelTransform(psWO->pTransformerArg);
	GDALDestroyWarpOptions(psWO);
	GDALDestroyGeoLocTransformer(hTransformArg);
	GDALClose(hSrcDS);
	GDALClose(hDstDS);
	return RE_SUCCESS;
}

int RGBTrueColorSynthesisconst (const char* pszSrcFile2, const char* pszSrcFile3, const char* pszDstFile, int deleteFile)
{
	//modis3ݣȡgeolocϢ
	const char* pszFormat = "GTiff";
	//ƴĿļ·ļ
	string strfile = string (CPLGetFilename (pszSrcFile2));
	strfile = strfile.substr (0, strfile.find_last_of ("hdf") - 21);
	strfile = string (CPLGetPath (pszDstFile)) + "\\" + strfile;
	string tmpThreeMidFile = strfile + "_threemidFile.tif";
	string tmpGeolocFile = strfile + "_geolocFile.tif";
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *pSrcDataset3 = (GDALDataset*)GDALOpen (pszSrcFile3, GA_ReadOnly);
	if (pSrcDataset3 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD3;
	}
	char **papszSubDatasets3 = GDALGetMetadata ((GDALDatasetH)pSrcDataset3, "SUBDATASETS");
	string tmpstr = string (papszSubDatasets3[0]);
	tmpstr = tmpstr.substr (tmpstr.find_first_of ("=") + 1);
	const char * pszSrcFile3_1 = tmpstr.c_str ();

	string tmplat = string (papszSubDatasets3[24]);
	tmplat = tmplat.substr (tmplat.find_first_of ("=") + 1);
	const char * pszlat = tmplat.c_str ();

	string tmplon = string (papszSubDatasets3[26]);
	tmplon = tmplon.substr (tmplon.find_first_of ("=") + 1);
	const char * pszlon = tmplon.c_str ();

	GDALDataset *pSrcDS3_1 = (GDALDataset*)GDALOpen (pszSrcFile3_1, GA_ReadOnly);
	if (pSrcDS3_1 == NULL)
	{
		GDALClose ((GDALDatasetH)pSrcDataset3);
		return RE_FILENOTSUPPORT_MOD3;
	}
	//ȡdodis3Ԫgeolocation
	char **papszGeoLocOptions3 = pSrcDS3_1->GetMetadata ("GEOLOCATION");
	//GDALClose(GDALDatasetH(pSrcDataset3));

	char **papszGeoLocOptions = NULL;

	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
	if (papszGeoLocOptions3 == NULL)
	{
		//char **papszGeoLocOptions = NULL;
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_OFFSET", "0");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_OFFSET", "0");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "X_BAND", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "Y_BAND", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "X_DATASET", pszlon);
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "Y_DATASET", pszlat);
	}
	else
	{
		papszGeoLocOptions = papszGeoLocOptions3;
		//papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "PIXEL_OFFSET", "2");
		//papszGeoLocOptions= CSLSetNameValue(papszGeoLocOptions3, "LINE_OFFSET", "2");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_STEP", "1");
		/*papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "X_DATASET", pszlon);
		papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "Y_DATASET",pszlat );*/
		//HDF4_SDS:UNKNOWN:"E:\GDAL\GDALTEST\rgb\modisrgb\data\1430335\MOD03.A2015143.0235.006.2015143091841.hdf":0

	}



	GDALDataset *pSrcDataset2 = (GDALDataset*)GDALOpen (pszSrcFile2, GA_ReadOnly);
	if (pSrcDataset2 == NULL)
	{
		GDALClose (GDALDatasetH (pSrcDataset3));
		GDALClose (GDALDatasetH (pSrcDS3_1));
		return RE_FILENOTSUPPORT_MOD2;
	}
	//洢ݵ·Ϣ
	char **papszSubDatasets2 = GDALGetMetadata ((GDALDatasetH)pSrcDataset2, "SUBDATASETS");
	//GDALClose(pSrcDataset2);
	// string temp2_1 = string(vSubDSName2[28]);
	string tmpstr2 = string (papszSubDatasets2[8]);
	tmpstr2 = tmpstr2.substr (tmpstr2.find_first_of ("=") + 1);
	const char *pszSrcFile2_1 = tmpstr2.c_str ();

	string tmpstr3 = string (papszSubDatasets2[14]);
	tmpstr3 = tmpstr3.substr (tmpstr3.find_first_of ("=") + 1);
	const char *pszSrcFile2_2 = tmpstr3.c_str ();
	//ݼȡָ3Ρ

	///////////////////////////////////////////////////

	// ԭʼͼָݼͼϢ//ʱļ3εģ
	GDALDataset *pSrcDS2_1 = (GDALDataset*)GDALOpen (pszSrcFile2_1, GA_ReadOnly);
	GDALDataset *pSrcDS2_2 = (GDALDataset*)GDALOpen (pszSrcFile2_2, GA_ReadOnly);
	double adfGeoTransform2_1[6] = { 0 };
	double adfGeoTransform2_2[6] = { 0 };
	pSrcDS2_1->GetGeoTransform (adfGeoTransform2_1);
	pSrcDS2_2->GetGeoTransform (adfGeoTransform2_2);

	//modisTime =atoi(tmpstr.c_str());
	//const char* pszTempFile ="E:\\GDAL\\GDALTEST\\rgb\\modisrgb\\data\\rgbtemp.tif";
	//E:\GDAL\GDALTEST\rgb\modisrgb\data\rgb.tif
	GDALDriver *pDriver = (GDALDriver*)GDALGetDriverByName (pszFormat);
	int nPixels = pSrcDS2_1->GetRasterXSize ();
	int nLines = pSrcDS2_1->GetRasterYSize ();
	GDALDataType eDT = pSrcDS2_1->GetRasterBand (1)->GetRasterDataType ();	//ȡ
	GDALDataset *pTempDS = pDriver->Create (tmpThreeMidFile.c_str (), nPixels, nLines, 3, eDT, NULL);//3
	pTempDS->SetProjection (pSrcDS2_1->GetProjectionRef ());
	pTempDS->SetGeoTransform (adfGeoTransform2_1);
	//delete []adfGeoTransform2_1;
	//delete []adfGeoTransform2_2;
	//д
	if (eDT == GDT_UInt16)
	{
		DT_16U *pBuf = new DT_16U[nPixels*nLines];
		GDALRasterBand *pBand1 = pTempDS->GetRasterBand (1);
		GDALRasterBand *pBand2 = pTempDS->GetRasterBand (2);
		GDALRasterBand *pBand3 = pTempDS->GetRasterBand (3);
		pSrcDS2_1->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand1->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д1

		pSrcDS2_2->GetRasterBand (2)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand2->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д2

		pSrcDS2_2->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand3->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д3
		delete[]pBuf;
	}

	int iResult;
	//pszTempFile ="E:\\GDAL\\GDALTEST\\rgb\\modisrgb\\data\\rgbtemp.tif";
	GDALClose ((GDALDatasetH)pSrcDS2_2);
	GDALClose ((GDALDatasetH)pSrcDS2_1);
	GDALClose ((GDALDatasetH)pTempDS);
	GDALClose ((GDALDatasetH)pSrcDataset3);
	GDALClose ((GDALDatasetH)pSrcDataset2);
	iResult = ImageWarpByGeoLoc (tmpThreeMidFile.c_str (), pszDstFile, papszGeoLocOptions, GRA_NearestNeighbour, "GTiff");
	GDALClose (GDALDatasetH (pSrcDS3_1));
	papszGeoLocOptions3 = NULL;


	if (deleteFile == 0)
	{
		remove (tmpThreeMidFile.c_str ());//ļɾ
	}
	return iResult;

}






//ȫֱ ͼΧ
static double	       dfMinX = 0.0, dfMinY = 0.0, dfMaxX = 0.0, dfMaxY = 0.0;
//ȫֱ ͼֱ
static double	       dfXRes = 0.01000, dfYRes = 0.01000;
//ȫֱ ͼ
static int             nForcePixels = 0, nForceLines = 0;
//ȫֱ ָ
//CProcessBase* m_pProcess = NULL;		

/**
* @brief ļ
* @param papszSrcFiles			ļб
* @param pszFilename			ļ·
* @param pszFormat				ļʽ
* @param eDT					ļ
* @param iRst					صĴʹ
* @return ļľ
*/
static GDALDatasetH GDALWarpCreateOutput (char **papszSrcFiles, int count, const char *pszFilename,
	const char *pszFormat, GDALDataType eDT, int &iRst)
{
	GDALAllRegister ();
	GDALDriverH hDriver;
	GDALDatasetH hDstDS;
	GDALColorTableH hCT = NULL;
	double dfWrkMinX = 0, dfWrkMaxX = 0, dfWrkMinY = 0, dfWrkMaxY = 0;
	double dfWrkResX = 0, dfWrkResY = 0;
	int nDstBandCount = 0;
	const char *pszThisTargetSRS = NULL;
	string strThisTargetSRS;

	iRst = RE_SUCCESS;

	//ȡļ
	hDriver = GDALGetDriverByName (pszFormat);
	//GDALDriver *pDriver =GDALDriverManager().GetDriverByName(pszFormat);
	//
	//printf(" driver short name is %s\n",GDALGetDriverShortName(hDriver));
	//printf(" driver long name is %s\n",GDALGetDriverLongName(hDriver));
	if (hDriver == NULL)
	{
		iRst = RE_FILENOTSUPPORT;
		return NULL;
	}

	for (int iSrc = 0; iSrc<count; iSrc++)
	{
		GDALDatasetH hSrcDS;
		hSrcDS = GDALOpen (papszSrcFiles[iSrc], GA_ReadOnly);
		if (hSrcDS == NULL)
		{
			iRst = RE_FILENOTEXIST;
			return NULL;
		}

		//鵱ǰļǷڲ 
		if (GDALGetRasterCount (hSrcDS) == 0)
		{
			iRst = RE_FILETYPEERROR;
			return NULL;
		}

		if (eDT == GDT_Unknown)
			eDT = GDALGetRasterDataType (GDALGetRasterBand (hSrcDS, 1));

		if (pszThisTargetSRS == NULL)
		{
			pszThisTargetSRS = GDALGetProjectionRef (hSrcDS);
			strThisTargetSRS = (string)((char*)pszThisTargetSRS);
		}

		//ǵһͼôͼϢһͼ񱣳һ
		if (iSrc == 0)
		{
			nDstBandCount = GDALGetRasterCount (hSrcDS);
			hCT = GDALGetRasterColorTable (GDALGetRasterBand (hSrcDS, 1));
			if (hCT != NULL)
				hCT = GDALCloneColorTable (hCT);
		}

		double adfThisGeoTransform[6] = { 0 };
		double adfExtent[4] = { 0 };
		int    nThisPixels, nThisLines;

		nThisPixels = GDALGetRasterXSize (hSrcDS);
		nThisLines = GDALGetRasterYSize (hSrcDS);

		// 㵱ǰͼΧ
		GDALGetGeoTransform (hSrcDS, adfThisGeoTransform);
		GDALApplyGeoTransform (adfThisGeoTransform, 0, 0, adfExtent, adfExtent + 1);
		GDALApplyGeoTransform (adfThisGeoTransform, nThisPixels, nThisLines, adfExtent + 2, adfExtent + 3);

		// Χ
		if (dfWrkMaxX == 0.0 && dfWrkMinX == 0.0)
		{
			dfWrkMinX = adfExtent[0];
			dfWrkMaxX = adfExtent[2];
			dfWrkMaxY = adfExtent[1];
			dfWrkMinY = adfExtent[3];
			dfWrkResX = adfThisGeoTransform[1];
			dfWrkResY = ABS (adfThisGeoTransform[5]);
		}
		else
		{
			dfWrkMinX = MIN (dfWrkMinX, adfExtent[0]);
			dfWrkMaxX = MAX (dfWrkMaxX, adfExtent[2]);
			dfWrkMaxY = MAX (dfWrkMaxY, adfExtent[1]);
			dfWrkMinY = MIN (dfWrkMinY, adfExtent[3]);
			dfWrkResX = MIN (dfWrkResX, adfThisGeoTransform[1]);
			dfWrkResY = MIN (dfWrkResY, ABS (adfThisGeoTransform[5]));
		}

		GDALClose (hSrcDS);
	}

	// ͼΧʹС
	double adfDstGeoTransform[6];
	int nPixels, nLines;

	adfDstGeoTransform[0] = dfWrkMinX;
	adfDstGeoTransform[1] = dfWrkResX;
	adfDstGeoTransform[2] = 0.0;
	adfDstGeoTransform[3] = dfWrkMaxY;
	adfDstGeoTransform[4] = 0.0;
	adfDstGeoTransform[5] = -1 * dfWrkResY;

	nPixels = (int)((dfWrkMaxX - dfWrkMinX) / dfWrkResX + 0.5);
	nLines = (int)((dfWrkMaxY - dfWrkMinY) / dfWrkResY + 0.5);

	// ûֱָʱٶͼСе
	if (dfXRes != 0.0 && dfYRes != 0.0)
	{
		if (dfMinX == 0.0 && dfMinY == 0.0 && dfMaxX == 0.0 && dfMaxY == 0.0)
		{
			dfMinX = adfDstGeoTransform[0];
			dfMaxX = adfDstGeoTransform[0] + adfDstGeoTransform[1] * nPixels;
			dfMaxY = adfDstGeoTransform[3];
			dfMinY = adfDstGeoTransform[3] + adfDstGeoTransform[5] * nLines;
		}

		nPixels = (int)((dfMaxX - dfMinX + (dfXRes / 2.0)) / dfXRes);
		nLines = (int)((dfMaxY - dfMinY + (dfYRes / 2.0)) / dfYRes);
		adfDstGeoTransform[0] = dfMinX;
		adfDstGeoTransform[3] = dfMaxY;
		adfDstGeoTransform[1] = dfXRes;
		adfDstGeoTransform[5] = -dfYRes;
	}

	// ͼ
	hDstDS = GDALCreate (hDriver, pszFilename, nPixels, nLines, nDstBandCount, eDT, NULL);
	//hDstDS = GDALCreate( GDALDriverH(pDriver), pszFilename, nPixels, nLines, nDstBandCount, eDT, NULL );
	if (hDstDS == NULL)
		return NULL;

	// дͶӰϢϢ
	GDALSetProjection (hDstDS, strThisTargetSRS.c_str ());
	GDALSetGeoTransform (hDstDS, adfDstGeoTransform);

	return hDstDS;
}
/**
* @brief ͼǶ
* <B>עô˺֮ǰȶӰмξͬһͶӰϵͳ£ֱʿԲͬ
* ͶӰϢԼĸݵĲθһ£ֲǶ
* ͼķֱʻᰴӰĵһӰȡͶӰϢ</B>
* @param papszSrcFiles		ļԼǶ·飬ĬϵһΪοӰ񣬵һͼ²㣬
* @param pszDstFilename		ļ·
* @param eResampleMethod	زʽĬΪRM_Bilinear
* @param dResX				ӰXֱʣĬΪ0ʾյһӰΪ׼
* @param dResY				ӰYֱʣĬΪ0ʾյһӰΪ׼
* @param pszFormat			ļʽϸοGDAL֧
* @param pProcess			ָ
* @return ֵʾгֵĸִϢ
*/
int ImageMosaicing (char* papszSrcFiles_1, const char* pszDstFilename)
{


	//Ԥַתchar**
	const char* comma = ",";
	int commaCount = 0;
	for (int i = 0; papszSrcFiles_1[i] != NULL; i++)
	{
		if (papszSrcFiles_1[i] == ',')
		{
			commaCount++;

		}
	}
	char** papszSrcFiles = new char *[commaCount + 1];
	for (int i = 0; i<commaCount + 1; i++)
	{
		if (i == 0)
		{
			papszSrcFiles[i] = strtok (papszSrcFiles_1, comma);
		}
		else
		{
			papszSrcFiles[i] = strtok (NULL, comma);
		}

	}


	int eResampleMethod = GRA_Bilinear;
	double dResX = 0;
	double dResY = 0;
	const char* pszFormat = "GTiff";
	/*if(pProcess != NULL)
	pProcess->SetMessage("ִǶ...");
	*/
	//ת
	void               *hTransformArg, *hGenImgProjArg = NULL, *hApproxArg = NULL;
	double              dfErrorThreshold = 0.0;
	GDALTransformerFunc pfnTransformer = NULL;

	GDALDataType        eOutputType = GDT_Unknown, eWorkingType = GDT_Unknown;
	GDALResampleAlg     eResampleAlg = (GDALResampleAlg)eResampleMethod;

	//NODATA
	const char         *pszSrcNodata = "0 0 0";
	const char         *pszDstNodata = "0 0 0";

	GDALAllRegister ();

	dfXRes = dResX;	//÷ֱ
	dfYRes = dResY;

	//ļ
	int iResult = RE_SUCCESS;
	GDALDatasetH		hDstDS;
	hDstDS = GDALWarpCreateOutput (papszSrcFiles, commaCount + 1, pszDstFilename, pszFormat, eOutputType, iResult);

	if (iResult != RE_SUCCESS || hDstDS == NULL)
		return iResult;

	//еļдļ
	int iRev = RE_SUCCESS;
	for (int iSrc = 0; iSrc<commaCount + 1; iSrc++)
	{
		GDALDatasetH hSrcDS;
		hSrcDS = GDALOpen (papszSrcFiles[iSrc], GA_ReadOnly);

		//////////////////////////////////////////////////////////////////////////
		// printf("%s\n\n",GDALGetProjectionRef(hSrcDS));
		//printf("%s\n",GDALGetProjectionRef(hDstDS));
		//////////////////////////////////////////////////////////////////////////
		if (hSrcDS == NULL)
		{
			iRev = RE_FILENOTEXIST;
			goto CLEAN;
		}

		// ļǷ񲻴ڲ 
		if (GDALGetRasterCount (hSrcDS) == 0)
		{
			//CPLDebug ("ImageMergeCutline", "ļ %s ڲΡ\n", papszSrcFiles[iSrc]);
			iRev = RE_FILENOTSUPPORT;
			goto CLEAN;
		}

		//תԴ굽Ŀϵ
		hTransformArg = hGenImgProjArg = GDALCreateGenImgProjTransformer2 (hSrcDS, hDstDS, NULL);
		if (hTransformArg == NULL)
		{
			iRev = RE_PARAMERROR;
			goto CLEAN;
		}

		pfnTransformer = GDALGenImgProjTransform;

		if (dfErrorThreshold != 0.0)
		{
			hTransformArg = hApproxArg =
				GDALCreateApproxTransformer (GDALGenImgProjTransform, hGenImgProjArg, dfErrorThreshold);
			pfnTransformer = GDALApproxTransform;
		}

		//warpѡ
		GDALWarpOptions *psWO = GDALCreateWarpOptions ();
		psWO->eWorkingDataType = eWorkingType;
		psWO->eResampleAlg = eResampleAlg;

		psWO->hSrcDS = hSrcDS;
		psWO->hDstDS = hDstDS;

		psWO->pfnTransformer = pfnTransformer;
		psWO->pTransformerArg = hTransformArg;

		psWO->pfnProgress = ALGTermProgress;
		/*psWO->pProgressArg = pProcess;*/
		//
		psWO->nDstAlphaBand = GDALGetRasterCount (hDstDS);
		psWO->nSrcAlphaBand = GDALGetRasterCount (hSrcDS);
		//ӳϵ
		psWO->nBandCount = GDALGetRasterCount (hSrcDS);

		psWO->panSrcBands = (int *)CPLMalloc (psWO->nBandCount*sizeof(int));
		psWO->panDstBands = (int *)CPLMalloc (psWO->nBandCount*sizeof(int));

		for (int i = 0; i < psWO->nBandCount; i++)
		{
			psWO->panSrcBands[i] = i + 1;
			psWO->panDstBands[i] = i + 1;
		}

		//ʼִwarp
		GDALWarpOperation oWO;
		CPLErr CE = CE_None;
		if (oWO.Initialize (psWO) == CE_None)
			CE = oWO.ChunkAndWarpImage (0, 0, GDALGetRasterXSize (hDstDS), GDALGetRasterYSize (hDstDS));

		//Դ
		if (hApproxArg != NULL)
			GDALDestroyApproxTransformer (hApproxArg);

		if (hGenImgProjArg != NULL)
			GDALDestroyGenImgProjTransformer (hGenImgProjArg);

		GDALDestroyWarpOptions (psWO);
		GDALClose (hSrcDS);

		if (CE != CE_None)
		{
			GDALClose (hDstDS);
			CSLDestroy (papszSrcFiles);

			/*if(pProcess != NULL)
			{
			if (!pProcess->m_bIsContinue)
			{
			pProcess->SetMessage("ȡ㣡");
			return RE_USERCANCEL;
			}
			else
			{
			pProcess->SetMessage("ִʧܣ");
			return RE_FAILED;
			}
			}*/

			return RE_FAILED;
		}

		/*if(pProcess != NULL)
		pProcess->ReSetProcess();*/
	}

	//ƺ
CLEAN:

	GDALClose (hDstDS);
	//CSLDestroy( papszSrcFiles );
	for (int i = 0; i<commaCount + 1; i++)
	{
		papszSrcFiles[i] = NULL;
	}

	/*if(pProcess != NULL)
	pProcess->SetMessage("Ƕ...");
	*/
	return RE_SUCCESS;
}

#pragma endregion ͼǶ
int SieveFilter (const char* pszSrcFile, const char* pszDstFile, int nSizeThresholld, int nConnectedness, const char* pszFormat)
{
	if (pszSrcFile == NULL || pszDstFile == NULL)
	{
		return RE_PARAMERROR;
	}
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *SrcDS = (GDALDataset*)GDALOpen (pszSrcFile, GA_ReadOnly);
	if (SrcDS == NULL)
	{
		return RE_FILENOTEXIST;
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (pszFormat);
	if (Driver == NULL)
	{
		GDALClose ((GDALDatasetH)SrcDS);
		return RE_FILENOTSUPPORT;
	}
	//ȡͼϢ
	int srcBandCount = SrcDS->GetRasterCount ();
	int XSize = SrcDS->GetRasterXSize ();
	int YSize = SrcDS->GetRasterYSize ();
	GDALDataType dataType = SrcDS->GetRasterBand (1)->GetRasterDataType ();
	//ͼ
	GDALDataset *DstDS = Driver->Create (pszDstFile, XSize, YSize, srcBandCount, dataType, NULL);
	double geoTransform[6] = { 0 };
	SrcDS->GetGeoTransform (geoTransform);
	DstDS->SetGeoTransform (geoTransform);
	DstDS->SetProjection (SrcDS->GetProjectionRef ());

	for (int i = 0; i<srcBandCount; i++)
	{
		GDALRasterBandH SrcBand = (GDALRasterBandH)SrcDS->GetRasterBand (i + 1);
		GDALRasterBandH DstBand = (GDALRasterBandH)DstDS->GetRasterBand (i + 1);
		//GDALSetRasterColorTable(DstBand,GDALGetRasterColorTable(SrcBand));
		GDALSetRasterNoDataValue (DstBand, 0.0);
		if (GDALSieveFilter (SrcBand, NULL, DstBand, nSizeThresholld, nConnectedness, NULL, NULL, NULL) != CE_None)
		{
			if (DstDS != NULL)
			{
				GDALClose ((GDALDatasetH)DstDS);
				GDALClose ((GDALDatasetH)SrcDS);
			}
			return RE_PARAMERROR;
		}

		GDALClose ((GDALDatasetH)DstDS);
		GDALClose ((GDALDatasetH)SrcDS);
		return RE_SUCCESS;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

enum test_result
{
	unknow = 0,
	yun = 1,
	shui = 3,
	qianhuodian = 4,
	jueduihuodian = 5,
	nofire = 6,
	zandinghuodian = 7,
	zhenhuodian = 8,
	beijinghuodian = 9,
	beijinghuodian2 = 14,
	beijing = 10,
	buquding = 11,
	chenggongtiqu = 12,
	xujiahuodian = 13,
	youxiaobeijingxiangyuan = 15,
	anxiangyuan = 16
};
static  float maxwindowsize = 21;//󴰿ڴС
static int modisTime =0;//modisʱ
static int seasonDay=0;//modis

static int width;//
static int height;//߶admin
// float sizeofclass =width*height;
float** band_1 = NULL;
float** band_2 = NULL;
float** band_3 = NULL;
float** band_5 = NULL;
float** band_7 = NULL;
float** band_21 = NULL;
float** band_22 = NULL;
float** band_31 = NULL;
float** band_32 = NULL;
//string tmpstrSensorZenith,tmpstrSensorAzimuth,tmpstrSolarZenith,tmpstrSolarAzimuth;
float** sensorzenith = NULL;
float** sensorazimuth = NULL;
float** solarzenith = NULL;
float** solarazimuth = NULL;
float** relativeangel = NULL;
float** lansea = NULL;
test_result** testresult = NULL;
float** confidence = NULL;
float** longitute = NULL;
float** latitute = NULL;
float** temp = NULL;
float** aodndvi = NULL;
float** suf_band_1;
float** suf_band_3 = NULL;
float** aodOptimal = NULL;

#pragma region Ʋ
//Ƽ⼰ˮԪʶ޳
const float th1 = 0.9;
const float th2 = 0.7;
const float th3 = 265;
const float th4 = 285;
const float th5 = 0.15;
//Ǳڻб
const float thr = 0.3;
const float thdt4 = 310;
const float thnt4 = 305;
//ǱڻֵԲ
const float thdat4 = 340;
const float thnat4 = 320;
//Ǳڻ㱳ֵԲ
const float thdb4 = 325;
const float thdbtt = 20;
const float thnb4 = 310;
const float thnbtt = 10;

const float tht1 = 3.5;
const float tht2 = 6;
const float tht3 = 3;
const float tht4 = 4;
const float tht5 = 5;
const float thtt = 10;
//ٻȥ
const float tha1 = 2;
const float tha2 = 8;
const float tha3 = 12;
const float thar = 0.1;
const float than = 0.2;
const float thap = 0.12;
//ɳĮԵٻȥ
const float ths1 = 0.1;
const float ths2 = 4;
const float ths3 = 0.15;
const float ths4 = 345;
const float ths5 = 3;
const float ths6 = 6;
//ոѷջŶȹ㷽
const float thc1 = 310;
const float thc2 = 340;
const float thc3 = 305;
const float thc4 = 320;
const float thc5 = 3;
const float thc6 = 2.5;
const float thc7 = 6;
#pragma endregion


#pragma region  ұ
const int searchTabColCount = 7;   //ұ
const int intervalCount = 5;           //ұֵ
const int solZenCount = 6;         //̫춥Ǹ
const int senZenCount = 6;		   //춥Ǹ
const int solAziCount = 9;		   //λǸʵԷλǸ
const int aod550Count = 6;		   //aod
double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60};//̫춥
double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60 };//춥
double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
double aod550[aod550Count] = { 0.0001, 0.2, 0.4, 0.6, 0.8, 1.0 };//550nmܽѧ
#pragma endregion 
/////////////////////////////////////////////////////////////////////////////

void CopyIntToFloat (DT_16S * pBuf_16, DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = (double)pBuf_16[i];
	}
}
void CopyUIntToFloat (DT_16U * pBuf_16, DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = (double)pBuf_16[i];
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void JiSuanFanshelv (DT_32F * pBuf, double dScale, double dOffset, int iCount, int iType)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf[i] = (pBuf[i] - dOffset)*dScale;
	}
	double k1, k2;
	double ik1_21 = 3634.171501, ik1_22 = 3634.171501, ik1_31 = 1304.413871, ik1_32 = 1196.978785;
	double ik2_21 = 122461.658403, ik2_22 = 122461.658403, ik2_31 = 729.541636, ik2_32 = 474.684780;
	switch (iType)
	{
	case 21: k1 = ik1_21; k2 = ik2_21; break;
	case 22: k1 = ik1_22; k2 = ik2_22; break;
	case 31: k1 = ik1_31; k2 = ik2_31; break;
	case 32: k1 = ik1_32; k2 = ik2_32; break;
	}
	if (iType == 21 || iType == 31 || iType == 22 || iType == 32)
	{
		for (int i = 0; i<iCount; i++)
		{
			pBuf[i] = k1 / (log(abs((k2 / (pBuf[i] + MIN_VALUE) + 1) + MIN_VALUE)));
		}
	}
}
void JiSuanJiaoDu (DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = pBuf_32[i] * 0.01;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////

int  AODCreateData (const char* charSrcFile2, const char* charSrcFile3, const char* charDstFile)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS2 = (GDALDataset*)GDALOpen (charSrcFile2, GA_ReadOnly);
	if (DS2 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD2;
	}
	char** subdatasets = DS2->GetMetadata ("SUBDATASETS");
#pragma endregion
#pragma region ȡָݼ
	string sub250, sub500, sub1000;
	sub1000 = string (subdatasets[4]); //1000    //3*2-2
	sub1000 = sub1000.substr (sub1000.find_first_of ('=') + 1);
	const char* SrcFile2_1000 = sub1000.c_str ();
	sub250 = string (subdatasets[8]);//250         //5*2-2
	sub250 = sub250.substr (sub250.find_first_of ('=') + 1);
	const char* SrcFile2_250 = sub250.c_str ();
	sub500 = string (subdatasets[14]);//500        //8*2-2
	sub500 = sub500.substr (sub500.find_first_of ('=') + 1);
	const char* SrcFile2_500 = sub500.c_str ();
#pragma endregion
#pragma region ݼȡϢ
	GDALDataset *DS250 = (GDALDataset*)GDALOpen (SrcFile2_250, GA_ReadOnly);
	GDALDataset *DS500 = (GDALDataset*)GDALOpen (SrcFile2_500, GA_ReadOnly);
	GDALDataset *DS1000 = (GDALDataset*)GDALOpen (SrcFile2_1000, GA_ReadOnly);
	int xSize = DS250->GetRasterXSize ();
	int ySize = DS250->GetRasterYSize ();
	GDALDataType datatype = DS250->GetRasterBand (1)->GetRasterDataType ();
	double geoTransform[6] = { 0 };
	DS250->GetGeoTransform (geoTransform);
#pragma endregion 
#pragma region Ŀݼ
	const char* fileFormat = "GTiff";
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (fileFormat);
	//printf("%s\n",Driver->GetDescription());
	GDALDataset *DSDst = Driver->Create (charDstFile, xSize, ySize, 6, GDT_Float32, NULL);
	DSDst->SetProjection (DS250->GetProjectionRef ());
	DSDst->SetGeoTransform (geoTransform);
#pragma endregion 
#pragma region ȡȡoffsetscale
#pragma region ȡԪ
	char** subdatasets250 = DS250->GetMetadata ();
	char** subdatasets500 = DS500->GetMetadata ();
	char** subdatasets1000 = DS1000->GetMetadata ();
#pragma endregion		
#pragma region 
	double douTemp250Offset_1, douTemp250Offset_2, douTemp500Offset_3, douTemp500Offset_5, douTemp500Offset_7, douTemp1000Offset_32;//offset 
	double douTemp250Scale_1, douTemp250Scale_2, douTemp500Scale_3, douTemp500Scale_5, douTemp500Scale_7, douTemp1000Scale_32;//scale
	string strTemp250Offset, strTemp500Offset, strTemp1000Offset;//offset
	string strTemp250Scale, strTemp500Scale, strTemp1000Scale;//scale
	char *charTemp250Offset, *charTemp500Offset, *charTemp1000Offset;
	char *charTemp250Scale, *charTemp500Scale, *charTemp1000Scale;
	const char* commas = ",";
#pragma endregion	
#pragma region 250-offset-scale
	strTemp250Offset = (string)(subdatasets250[118]);
	strTemp250Offset = strTemp250Offset.substr (strTemp250Offset.find_first_of ("=") + 1);
	charTemp250Offset = strtok ((char*)strTemp250Offset.c_str (), commas);
	douTemp250Offset_1 = CPLScanDouble (charTemp250Offset, 20);
	charTemp250Offset = strtok (NULL, commas);
	douTemp250Offset_2 = CPLScanDouble (charTemp250Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp250Scale = (string)(subdatasets250[119]);
	strTemp250Scale = strTemp250Scale.substr (strTemp250Scale.find_first_of ("=") + 1);
	charTemp250Scale = strtok ((char*)strTemp250Scale.c_str (), commas);
	douTemp250Scale_1 = CPLScanDouble (charTemp250Scale, 20);
	charTemp250Scale = strtok (NULL, commas);
	douTemp250Scale_2 = CPLScanDouble (charTemp250Scale, 20);
#pragma endregion
#pragma region 500-offset-scale
	strTemp500Offset = (string)(subdatasets500[118]);
	strTemp500Offset = strTemp500Offset.substr (strTemp500Offset.find_first_of ("=") + 1);
	charTemp500Offset = strtok ((char*)strTemp500Offset.c_str (), commas);
	douTemp500Offset_3 = CPLScanDouble (charTemp500Offset, 20);
	charTemp500Offset = strtok (NULL, commas);
	charTemp500Offset = strtok (NULL, commas);
	douTemp500Offset_5 = CPLScanDouble (charTemp500Offset, 20);
	charTemp500Offset = strtok (NULL, commas);
	charTemp500Offset = strtok (NULL, commas);
	douTemp500Offset_7 = CPLScanDouble (charTemp500Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp500Scale = (string)(subdatasets500[119]);
	strTemp500Scale = strTemp500Scale.substr (strTemp500Scale.find_first_of ("=") + 1);
	charTemp500Scale = strtok ((char*)strTemp500Scale.c_str (), commas);
	douTemp500Scale_3 = CPLScanDouble (charTemp500Scale, 20);
	charTemp500Scale = strtok (NULL, commas);
	charTemp500Scale = strtok (NULL, commas);
	douTemp500Scale_5 = CPLScanDouble (charTemp500Scale, 20);
	charTemp500Scale = strtok (NULL, commas);
	charTemp500Scale = strtok (NULL, commas);
	douTemp500Scale_7 = CPLScanDouble (charTemp500Scale, 20);


#pragma endregion
#pragma region 1000-offset-scale
	strTemp1000Offset = (string)(subdatasets1000[108]);
	strTemp1000Offset = strTemp1000Offset.substr (strTemp1000Offset.find_first_of ("=") + 1);
	charTemp1000Offset = strtok ((char*)strTemp1000Offset.c_str (), commas);
	for (int i = 0; i<11; i++)
	{
		charTemp1000Offset = strtok (NULL, commas);
	}
	douTemp1000Offset_32 = CPLScanDouble (charTemp1000Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp1000Scale = (string)(subdatasets1000[109]);
	strTemp1000Scale = strTemp1000Scale.substr (strTemp1000Scale.find_first_of ("=") + 1);
	charTemp1000Scale = strtok ((char*)strTemp1000Scale.c_str (), commas);
	for (int i = 0; i<11; i++)
	{
		charTemp1000Scale = strtok (NULL, commas);
	}
	douTemp1000Scale_32 = CPLScanDouble (charTemp1000Scale, 20);
#pragma endregion
#pragma endregion 		
#pragma region д6οѧ رݼ
	if (datatype == GDT_UInt16)
	{
		DT_32F *pBuf_32 = new DT_32F[xSize*ySize];
		DT_16U *pBuf_16 = new DT_16U[xSize*ySize];
		GDALRasterBand *band1 = DSDst->GetRasterBand (1);
		GDALRasterBand *band2 = DSDst->GetRasterBand (2);
		GDALRasterBand *band3 = DSDst->GetRasterBand (3);
		GDALRasterBand *band4 = DSDst->GetRasterBand (4);
		GDALRasterBand *band5 = DSDst->GetRasterBand (5);
		GDALRasterBand *band6 = DSDst->GetRasterBand (6);
		DS250->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp250Scale_1, douTemp250Offset_1, xSize*ySize, 1);
		band1->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д1(band1-0.66)
		DS250->GetRasterBand (2)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp250Scale_2, douTemp250Offset_2, xSize*ySize, 2);
		band2->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д2(band2-0.86)
		DS500->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//2
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_3, douTemp500Offset_3, xSize*ySize, 3);
		band3->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д3(band3-0.47)
		DS500->GetRasterBand (3)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//3
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_5, douTemp500Offset_5, xSize*ySize, 5);
		band4->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д4(band5-1.24)
		DS500->GetRasterBand (5)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//4
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_7, douTemp500Offset_7, xSize*ySize, 7);
		band5->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д5(band7-2.1)
		DS1000->GetRasterBand (12)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//5
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp1000Scale_32, douTemp1000Offset_32, xSize*ySize, 32);
		band6->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д6(band32-12)
		delete[]pBuf_16;
		delete[]pBuf_32;
	}
	GDALClose (GDALDatasetH (DS250));
	GDALClose (GDALDatasetH (DS500));
	GDALClose (GDALDatasetH (DS1000));
	GDALClose (GDALDatasetH (DSDst));
	GDALClose (GDALDatasetH (DS2));
	return RE_SUCCESS;
#pragma endregion 
}
int AODCreateAngel (const char* SrcFile2, const char* SrcFile3, const char* DstFile)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS3 = (GDALDataset*)GDALOpen (SrcFile3, GA_ReadOnly);
	if (DS3 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD3;
	}
	char** subdatasets = DS3->GetMetadata ("SUBDATASETS");
#pragma endregion
#pragma region ȡָݼ
	string strSensorZenith, strSensorAzimuth, strSolarZenith, strSolarAzimuth, strLanSea;
	strSensorZenith = string (subdatasets[8]);
	strSensorZenith = strSensorZenith.substr (strSensorZenith.find_first_of ('=') + 1);
	const char* charSensorZenith = strSensorZenith.c_str ();

	strSensorAzimuth = string (subdatasets[10]);
	strSensorAzimuth = strSensorAzimuth.substr (strSensorAzimuth.find_first_of ('=') + 1);
	const char* charSensorAzimuth = strSensorAzimuth.c_str ();

	strSolarZenith = string (subdatasets[14]);
	strSolarZenith = strSolarZenith.substr (strSolarZenith.find_first_of ('=') + 1);
	const char* charSolarZenith = strSolarZenith.c_str ();

	strSolarAzimuth = string (subdatasets[16]);
	strSolarAzimuth = strSolarAzimuth.substr (strSolarAzimuth.find_first_of ('=') + 1);
	const char* charSolarAzimuth = strSolarAzimuth.c_str ();

	strLanSea = string (subdatasets[18]);
	strLanSea = strLanSea.substr (strLanSea.find_first_of ('=') + 1);
	const char* charLanSea = strLanSea.c_str ();
#pragma endregion
#pragma region ݼȡϢ
	GDALDataset *DSSensorZenith = (GDALDataset*)GDALOpen (charSensorZenith, GA_ReadOnly);
	GDALDataset *DSSensorAzimuth = (GDALDataset*)GDALOpen (charSensorAzimuth, GA_ReadOnly);
	GDALDataset *DSSolarZenith = (GDALDataset*)GDALOpen (charSolarZenith, GA_ReadOnly);
	GDALDataset *DSSolarAzimuth = (GDALDataset*)GDALOpen (charSolarAzimuth, GA_ReadOnly);
	GDALDataset *DSLanSea = (GDALDataset*)GDALOpen (charLanSea, GA_ReadOnly);
	int xSize = DSSensorZenith->GetRasterXSize ();
	int ySize = DSSensorZenith->GetRasterYSize ();
	GDALDataType datatype = DSSensorZenith->GetRasterBand (1)->GetRasterDataType ();
	double geoTransform[6] = { 0 };
	DSSensorZenith->GetGeoTransform (geoTransform);
#pragma endregion 
#pragma region Ŀݼ
	const char* fileFormat = "GTiff";
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (fileFormat);
	GDALDataset *DSDst = Driver->Create (DstFile, xSize, ySize, 5, GDT_Float32, NULL);
	DSDst->SetProjection (DSSensorZenith->GetProjectionRef ());
	DSDst->SetGeoTransform (geoTransform);
#pragma endregion 	
#pragma region д4νǶ رݼ


	if (datatype == GDT_Int16)
	{
		DT_32F *pBuf_32 = new DT_32F[xSize*ySize];
		DT_16S *pBuf_16 = new DT_16S[xSize*ySize];
		GDALRasterBand *band1 = DSDst->GetRasterBand (1);
		GDALRasterBand *band2 = DSDst->GetRasterBand (2);
		GDALRasterBand *band3 = DSDst->GetRasterBand (3);
		GDALRasterBand *band4 = DSDst->GetRasterBand (4);
		GDALRasterBand *band5 = DSDst->GetRasterBand (5);
		DSSensorZenith->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band1->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д1
		DSSensorAzimuth->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//2
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band2->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д2
		DSSolarZenith->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//3
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band3->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д3
		DSSolarAzimuth->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//4
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band4->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д4


		DSLanSea->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		band5->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0);  //д

		delete[]pBuf_16;
		delete[]pBuf_32;
	}
	GDALClose (GDALDatasetH (DSSensorZenith));
	GDALClose (GDALDatasetH (DSSensorAzimuth));
	GDALClose (GDALDatasetH (DSSolarZenith));
	GDALClose (GDALDatasetH (DSSolarAzimuth));
	GDALClose (GDALDatasetH (DSDst));
	GDALClose (GDALDatasetH (DS3));
	GDALClose (GDALDatasetH (DSLanSea));
	return RE_SUCCESS;
#pragma endregion 
}
//int AODGetGeolocOfModis3 (const char* SrcFile3, char ***geoloc)
//{
//#pragma region עݼ
//	GDALAllRegister ();
//	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
//	GDALDataset *DS3 = (GDALDataset*)GDALOpen (SrcFile3, GA_ReadOnly);
//	char **subdatasets = GDALGetMetadata ((GDALDatasetH)DS3, "SUBDATASETS");
//#pragma endregion
//#pragma region ȡγݼ͵һݼ
//	string strSubDataset_1 = string (subdatasets[0]);//һݼ
//	strSubDataset_1 = strSubDataset_1.substr (strSubDataset_1.find_first_of ("=") + 1);
//	const char* SrcFile3_1 = strSubDataset_1.c_str ();
//
//	string strLat = string (subdatasets[24]);//lat
//	strLat = strLat.substr (strLat.find_first_of ("=") + 1);
//	const char* charLat = strLat.c_str ();
//
//	string strLon = string (subdatasets[26]);//lon
//	strLon = strLon.substr (strLon.find_first_of ("=") + 1);
//	const char* charLon = strLon.c_str ();
//#pragma endregion 
//#pragma region ȡһݼgeoloc
//	GDALDataset *DS3_1 = (GDALDataset*)GDALOpen (SrcFile3_1, GA_ReadOnly);
//	char **geolocOptions3 = DS3_1->GetMetadata ("GEOLOCATION");
//	char **geolocOptions = geolocOptions3;
//	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
//	if (geolocOptions3 == NULL)
//	{
//
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_OFFSET", "0");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_OFFSET", "0");
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "X_BAND", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "Y_BAND", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "X_DATASET", charLon);
//		geolocOptions = CSLSetNameValue (geolocOptions, "Y_DATASET", charLat);
//	}
//	else
//	{
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
//	}
//	for (int i = 0; i<8; i++)
//	{
//		strcpy ((*geoloc)[i], geolocOptions[i]);
//		/*if (geolocOptions[i]!=NULL)
//		{
//		delete []geolocOptions[i];
//		}*/
//	}
//	/*if (geolocOptions!=NULL)
//	{
//	delete []geolocOptions;
//	}*/
//	GDALClose (GDALDatasetH (DS3_1));
//	GDALClose (GDALDatasetH (DS3));
//	/*char** geoloc =new char *[8] ;
//	for (int i=0;i<8;i++)
//	{
//	geoloc[i]=(char*)(strarrgeoloc[i].c_str());
//	}*/
//	return RE_SUCCESS;
//#pragma endregion 	
//}
void AODInitialize (const char* charGeolocData, const char* charGeolocAngel)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DSData = (GDALDataset*)GDALOpen (charGeolocData, GA_ReadOnly);
	GDALDataset *DSAngel = (GDALDataset*)GDALOpen (charGeolocAngel, GA_ReadOnly);
	int dataBandCount = DSData->GetRasterCount ();
	int angelBandCount = DSAngel->GetRasterCount ();
	GDALDataType dataType = DSData->GetRasterBand (1)->GetRasterDataType ();
	width = DSData->GetRasterXSize ();
	height = DSData->GetRasterYSize ();
#pragma endregion	
#pragma region  ̬Ķ
	band_1 = new float*[height];
	band_2 = new float*[height];
	band_3 = new float*[height];
	band_5 = new float*[height];
	band_7 = new float*[height];
	band_32 = new float*[height];
	aodndvi = new float*[height];//ndvi
	sensorzenith = new float*[height];//ĸǶ+ 1Էλ
	sensorazimuth = new float*[height];
	solarzenith = new float*[height];
	solarazimuth = new float*[height];
	relativeangel = new float*[height];
	lansea = new float*[height]; // ½
	suf_band_1 = new float*[height]; //ر
	suf_band_3 = new float*[height];
	aodOptimal = new float*[height]; //aod
	testresult = new test_result*[height];
	for (int i = 0; i<height; i++)
	{
		band_1[i] = new float[width];
		band_2[i] = new float[width];
		band_3[i] = new float[width];
		band_5[i] = new float[width];
		band_7[i] = new float[width];
		band_32[i] = new float[width];

		aodndvi[i] = new float[width];

		sensorzenith[i] = new float[width];
		sensorazimuth[i] = new float[width];
		solarzenith[i] = new float[width];
		solarazimuth[i] = new float[width];
		relativeangel[i] = new float[width];
		lansea[i] = new float[width];

		suf_band_1[i] = new float[width];
		suf_band_3[i] = new float[width];
		aodOptimal[i] = new float[width];
		testresult[i] = new test_result[width];
	}
#pragma endregion
#pragma region ̬ĳʼ
	//DT_64F *pBuf = (DT_64F*)malloc(sizeof(DT_64F)*width*height);
	DT_32F *pBuf = new DT_32F[width*height];
	int p = 0;
#pragma region ݲεĳʼ
	for (int i = 0; i<dataBandCount; i++)
	{
		if (dataType == GDT_Float32)
		{

			DSData->GetRasterBand (i + 1)->RasterIO (GF_Read, 0, 0, width, height, pBuf, width, height, dataType, 0, 0);
			p = 0;
			for (int j = 0; j<height; j++)
			{
				for (int k = 0; k<width; k++)
				{
					switch (i + 1)
					{
					case 1:band_1[j][k] = pBuf[p++];
						break;
					case 2:band_2[j][k] = pBuf[p++];
						break;
					case 3:band_3[j][k] = pBuf[p++];
						break;
					case 4:band_5[j][k] = pBuf[p++];
						break;
					case 5:band_7[j][k] = pBuf[p++];
						break;
					case 6:band_32[j][k] = pBuf[p++];
						break;
					}
				}
			}
		}
	}
#pragma endregion 
#pragma region ǶȲεĳʼ
	//ʼ4Ƕ
	for (int i = 0; i<angelBandCount; i++)
	{
		//DT_64F *pBuf = new DT_64F[width*height];int p=0;
		DSAngel->GetRasterBand (i + 1)->RasterIO (GF_Read, 0, 0, width, height, pBuf, width, height, dataType, 0, 0);
		int p = 0;
		for (int j = 0; j<height; j++)
		{
			for (int k = 0; k<width; k++)
			{
				switch (i + 1)
				{
				case 1:sensorzenith[j][k] = pBuf[p++];
					break;
				case 2:sensorazimuth[j][k] = pBuf[p++];
					break;
				case 3:solarzenith[j][k] = pBuf[p++];
					break;
				case 4:solarazimuth[j][k] = pBuf[p++];
					break;
				case 5:lansea[j][k] = pBuf[p++];
					break;
				}
			}
		}
	}
#pragma endregion 
	delete[]pBuf;
#pragma region ̬ĳʼ
	double senZen, senAzi, solZen, solAzi, relAng;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			testresult[i][j] = unknow;//
			aodndvi[i][j] = (band_5[i][j] - band_7[i][j]) / (band_5[i][j] + band_7[i][j]);//ndviĳʼ
			suf_band_1[i][j] = 0;
			suf_band_3[i][j] = 0;
			aodOptimal[i][j] = 0;
			//ԽǶȵĳʼ
			senZen = RAD_PER_DEG*sensorzenith[i][j];
			senAzi = RAD_PER_DEG*sensorazimuth[i][j];
			solZen = RAD_PER_DEG*solarzenith[i][j];
			solAzi = RAD_PER_DEG*solarazimuth[i][j];
			relAng = solAzi - senAzi;
			if (relAng<M_PI*(-1))
			{
				relAng += 2 * M_PI;
			}
			else if (relAng>M_PI)
			{
				relAng -= 2 * M_PI;
			}
			relAng += M_PI;//-pi~piת 0~2pi;
			//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * sin(senZen) * cos(relAng));
			//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * cos(relAng));
			relativeangel[i][j] = relAng;
		}
	}
#pragma endregion 
	GDALClose (GDALDatasetH (DSData));
	GDALClose (GDALDatasetH (DSAngel));

#pragma endregion	
}
void AODGetSeason (const char* SrcFile2)
{
	//"E:\\fire2\\firetest\\MOD279\\0220\\MOD021KM.A2014279.0220.006.2014283045932.hdf";
	string tempFileName = string (CPLGetFilename (SrcFile2));
	tempFileName = tempFileName.substr (tempFileName.find_last_of ("hdf") - 29, 3);
	seasonDay = (int)CPLScanDouble (tempFileName.c_str (), 20);
}
void AODDestroy ()
{
	for (int i = 0; i<height; i++)
	{
		RELEASE (band_1[i]);
		RELEASE (band_2[i]);
		RELEASE (band_3[i]);
		RELEASE (band_5[i]);
		RELEASE (band_7[i]);
		RELEASE (band_32[i]);
		RELEASE (aodndvi[i]);
		RELEASE (sensorzenith[i]);
		RELEASE (sensorazimuth[i]);
		RELEASE (solarzenith[i]);
		RELEASE (solarazimuth[i]);
		RELEASE (relativeangel[i]);
		RELEASE (lansea[i]);
		RELEASE (suf_band_1[i]);
		RELEASE (suf_band_3[i]);
		RELEASE (aodOptimal[i]);
		RELEASE (testresult[i]);
	}	
	RELEASE (band_1);
	RELEASE (band_2);
	RELEASE (band_3);
	RELEASE (band_5);
	RELEASE (band_7);
	RELEASE (band_32);
	RELEASE (aodndvi);
	RELEASE (sensorzenith);
	RELEASE (sensorazimuth);
	RELEASE (solarzenith);
	RELEASE (solarazimuth);
	RELEASE (relativeangel);
	RELEASE (lansea);
	RELEASE (suf_band_1);
	RELEASE (suf_band_3);
	RELEASE (aodOptimal);
	RELEASE (testresult);
}
void AODIdentifyCloudAndWater ()
{
	//pr:Ԫں첨(0.66)ı۷band1
	//pn:ԪڽⲨ(0.86)ı۷band2
	//t12:ԪȺⲨΣ12um¶band32
	//t2:Ԫ2.12umθı۷band7
	float pr, pn, t12, t2;
	float senZen, solZen;

	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (!(fabs((double)lansea[i][j] - 1.0)<MIN_VALUE) || fabs((double)lansea[i][j] - 2.0)<MIN_VALUE)//ʶˮ
			{
				testresult[i][j] = shui;
			}
		}
	}
	//ʶ
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			pr = band_1[i][j];
			pn = band_2[i][j];
			t12 = band_32[i][j];
			if (testresult[i][j] != shui)
			{
				if ((pr + pn>th1) || (t12<th3) || ((pr + pn)>th2 && t12<th4))
				{
					testresult[i][j] = yun;
				}
			}

		}
	}

	//ʶԪ
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			//if (testresult[i][j] != yun)
			if (testresult[i][j] != yun	&& testresult[i][j] != shui)//ˮĻʶԪ
			{
				t2 = band_7[i][j];
				senZen = RAD_PER_DEG*sensorzenith[i][j];
				solZen = RAD_PER_DEG*solarzenith[i][j];
				////if (t2>0.01 && t2<0.125 * (1 / cos (senZen) + 1 / (pow (cos ((double)solZen), 0.5))))//µķ
				////{
				////	testresult[i][j] = anxiangyuan;
				////}
				if (t2>0.01 && t2<0.4)
				{
				testresult[i][j]=anxiangyuan;
				}
			}
		}
	}
}
int AODOutputOther (const char* charSrcFile, const char* charDstFile, test_result res)
{
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILEAME_IS_UTF8", "NO");
	GDALDataset *SrcDS = (GDALDataset*)GDALOpen (charSrcFile, GA_ReadOnly);
	double geoTransform[6] = { 0 };
	SrcDS->GetGeoTransform (geoTransform);
	int xSize = SrcDS->GetRasterXSize ();
	int ySize = SrcDS->GetRasterYSize ();
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	GDALDataset *DstDS = Driver->Create (charDstFile, xSize, ySize, 1, GDT_Int32, NULL);
	DstDS->SetProjection (SrcDS->GetProjectionRef ());
	DstDS->SetGeoTransform (geoTransform);
	//DT_32S *pBuf = (DT_32S*)malloc(sizeof(DT_32S)*width*height);
	DT_32S *pBuf = new DT_32S[width*height];
	int p = 0;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == res)
			{
				pBuf[p] = 1;
			}
			else
			{
				pBuf[p] = 0;
			}
			p++;
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, width, height, pBuf, width, height, GDT_Int32, 0, 0);
	delete[]pBuf;
	GDALClose (GDALDatasetH (SrcDS));
	GDALClose (GDALDatasetH (DstDS));
	return RE_SUCCESS;
}
void AODConfirmSurfaceReflectance ()
{
	//senZen:۲⣨춥
	//senAzi:۲⣨Էλ
	//solZen:̫춥
	//solAzi:̫λ
	//scaAngɢ
	//relAng:Էλ
	float senZen, senAzi, solZen, solAzi, scaAng, relAng;
	float slope_066_212_scale, slope_066_212_offset;
	float slope_ndvi_066_212_scale, slope_ndvi_066_212_offset;
	float slope_047_066_scale = 0.49, slope_047_066_offset = 0.005;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				senZen = RAD_PER_DEG*sensorzenith[i][j];
				senAzi = RAD_PER_DEG*sensorazimuth[i][j];
				solZen = RAD_PER_DEG*solarzenith[i][j];
				solAzi = RAD_PER_DEG*solarazimuth[i][j];
				//relAng=solAzi-senAzi;
				//if (relAng<M_PI*(-1))
				//{
				//	relAng+=2*M_PI;
				//}
				//else if (relAng>M_PI)
				//{
				//	relAng-=2*M_PI;
				//}
				//relAng+=M_PI;//-pi~piת 0~2pi;
				scaAng = acos ((-1) * cos (solZen) * cos (senZen) + sin (solZen) * sin (senZen) * cos (relativeangel[i][j]));
				//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * cos(relAng));
				//v5.2ݷ
				if (band_7[i][j] >= 0.01 && band_7[i][j] <= 0.25)
				{
					if (aodndvi[i][j]<0.25)
					{
						slope_ndvi_066_212_scale = 0.48;
					}
					else if (aodndvi[i][j]>0.75)
					{
						slope_ndvi_066_212_scale = 0.58;
					}
					else
					{
						slope_ndvi_066_212_scale = 0.48 + 0.2*(aodndvi[i][j] - 0.25);
					}
					slope_066_212_scale = slope_ndvi_066_212_scale + 0.002* scaAng - 0.27;
					slope_066_212_offset = 0.00025 * scaAng + 0.033;
					suf_band_1[i][j] = band_7[i][j] * slope_066_212_scale + slope_066_212_offset;
					suf_band_3[i][j] = suf_band_1[i][j] * slope_047_066_scale + slope_047_066_offset;

				}
				else if (band_7[i][j]>0.25)
				{
					suf_band_1[i][j] = band_7[i][j] / 2;
					suf_band_3[i][j] = band_7[i][j] / 4;
				}

				////չԪ
				//	 suf_band_1[i][j]=band_7[i][j]/2;
				//	 suf_band_3[i][j]=band_7[i][j]/4;
				//BRDF
				// AOD ݹѵرΪʲԴ ַ˵رṹķԶԵر
				//Ӱ죮 ǵرԶԵرʵӰ죬 

			}
		}
	}
}
float Mean(double* err, int length, double* aod550)
{




#pragma region old 
	double temp = 1.0;
	double sum = 0.0;
	double k = 0;
	double min1 = 10000;
	int min1pos = -1;
	int min2pos = -1;
	double min2 = 10000;
	//ҵСֵ
	for (int i = 0; i < length; i++)
	{
		if (err[i] <min1)
		{
			min1 = err[i];
			min1pos = i;
		}
	}
	//ҵ2Сֵ
	for (int  i = 0; i < length; i++)
	{
		if ((!(fabs(err[i] - min1) < MIN_VALUE)) && err[i] < min2)
		{
			min2 = err[i];
			min2pos = i;
		}

	}
	//return (min2  *aod550[min1pos] + min1 * aod550[min2pos]) / (min1 +  min2);
	return (min2 *min2 *aod550[min1pos] + min1* min1  * aod550[min2pos]) / (min1*min1 + min2* min2);
#pragma endregion 
	//////////////////////////////////////
	//for (int i = 0; i < length; i++)
	//{
	//	temp *= err[i];
	//}
	//for (int i = 0; i < length; i++)
	//{
	//	sum += temp / err[i] * aod550[i];
	//}
	//for (int i = 0; i < length; i++)
	//{
	//	k += temp / err[i];
	//}
	//return (sum)/k;

}




//ӲұлȡǸŻкŴ0 ʼġ
//void SearchOptimalResultFromOld(int i, int j, int* trueRow)
//{
//	int searchSolZen = 0, searchSenZen = 0, searchRelAzi = 0;
//	int trueSolzen = 0, trueSenZen = 0, trueRelAzi = 0;
//	int trueRow = 0;
//	float minthereflectivity = 0, thereflectivity = 0;
//
//	searchSolZen = solZenCount - 1, searchSenZen = senZenCount - 1, searchRelAzi = solAziCount - 1;//Ĭֵ
//	minthereflectivity = 1000000000;//minvalΪ㹻ֵ
//	float devk1 = 0, devk2 = 0, devk3 = 0;
//	float devkk1 = 0, devkk2, devkk3 = 0;
//
//
//	for (int k = 0; k<solZenCount; k++)
//	{
//		if (solarzenith[i][j]<solZen[k])
//		{
//			searchSolZen = k;
//			break;
//		}
//	}
//	for (int k = 0; k<senZenCount; k++)
//	{
//		if (sensorzenith[i][j]<senZen[k])
//		{
//			searchSenZen = k;
//			break;
//		}
//	}
//	for (int k = 0; k<solAziCount; k++)
//	{
//		if ((relativeangel[i][j])<solAzi[k])
//		{
//			searchRelAzi = k;
//			break;
//		}
//	}
//	devk1 = solZen[searchSolZen] - solZen[searchSolZen - 1];
//	devk2 = senZen[searchSenZen] - senZen[searchSenZen - 1];
//	devk3 = solAzi[searchRelAzi] - solAzi[searchRelAzi - 1];
//	if (solarzenith[i][j]>(solZen[searchSolZen - 1] + solZen[searchSolZen]) / 2)
//	{
//		devkk1 = abs(solarzenith[i][j] - solZen[searchSolZen]);
//		trueSolzen = searchSolZen;
//	}
//	else
//	{
//		devkk1 = abs(solarzenith[i][j] - solZen[searchSolZen - 1]);
//		trueSolzen = searchSolZen - 1;
//	}
//	if (sensorzenith[i][j]>(senZen[searchSenZen - 1] + senZen[searchSenZen]) / 2)
//	{
//		devkk2 = abs(sensorzenith[i][j] - senZen[searchSenZen]);
//		trueSenZen = searchSenZen;
//	}
//	else
//	{
//		devkk2 = abs(sensorzenith[i][j] - senZen[searchSenZen - 1]);
//		trueSenZen = searchSenZen - 1;
//	}
//	if (solarazimuth[i][j]>(solAzi[searchRelAzi - 1] + solAzi[searchRelAzi]) / 2)
//	{
//		devkk3 = abs(solarazimuth[i][j] - solAzi[searchRelAzi]);
//		trueRelAzi = searchRelAzi;
//	}
//	else
//	{
//		devkk3 = abs(solarazimuth[i][j] - solAzi[searchRelAzi - 1]);
//		trueRelAzi = searchRelAzi - 1;
//	}
//	/*
//	const int solZenCount = 8;
//	const int senZenCount = 7;
//	const int solAziCount = 9;
//	const int aod550Count = 6;
//	*/
//	*trueRow = (senZenCount * solAziCount) * trueSolzen + (solAziCount)* trueSenZen + (1) * trueRelAzi;
//}
//
//float CalulateInterpolation(int i, int j, float** inTable , int inTableCol, int  inTableRow)
//{
//	int row = i / intervalCount;
//	int row2 = i % intervalCount;
//	float f0= inTable[row][j];
//	float f1 = inTable[row + 1][j];
//	float x = ((float)row2) / intervalCount;
//	return f0 * (1 - x) + f1 * x;
//
//
//	//int row = i / inTableRow;
//	//int col = j/ inTableCol;
//	//int row2 = i%inTableRow;
//	//int col2 = j%inTableCol;
//	//float f00 = inTable[row][col];
//	//float f10 = inTable[row + 1][col];
//	//float f01 = inTable[row][col + 1];
//	//float f11 = inTable[row + 1][col + 1];
//	//float x =((float) row2 )  / inTableRow;
//	//float y = ((float)col2)  / inTableCol;
//	////f(x, y) = f(0, 0)(1 - x)(1 - y) + f(0, 1)(1 - x)y + f(1, 1)xy + f(1, 0)x(1 - y)
//	//float fxy = f00 * (1 - x)*(1 - y ) + f01 * (1 - x) * y + f11 * x * y + f10 * x * (1 - y);
//	//return   fxy;
//}
//void CreateNewSeachTable(float** inTable, float ** outTable, int inTableCol,int  inTableRow, int outTableCol, int outTableRow)
//{
//
//	//const int searchTabColCount = 7;   //ұ
//	//const int  intervalCount = 5;           //ұֵ
//	//const int solZenCount = 8;         //̫춥Ǹ
//	//const int senZenCount = 7;		   //춥Ǹ
//	//const int solAziCount = 9;		   //λǸʵԷλǸ
//	//const int aod550Count = 6;		   //aod
//	//double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 72, 84 };//̫춥
//	//double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
//	//double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
//	//double aod550[aod550Count] = { 0.0001, 0.25, 0.5, 1.0, 1.5, 1.95 };//550nmܽѧ
//	//for (int  i = 0; i < inTableRow; i++)
//	//{
//	//	for (int  j = 0; j < inTableCol; j++)
//	//	{    
//	//		//outTable
//	//		for (int k1 = 0; k1 <intervalCount; k1++)
//	//		{
//	//			for (int k2 = 0; k2 < intervalCount; k2++)
//	//			{
//	//				outTable[i*intervalCount + k1][j*intervalCount + k2] = calculate(inTable[i][j], inTable[i][], k1, k2);
//	//			}
//	//		}
//	//		//outTable[i*intervalCount +k1]
//	//	}
//	//}
//	//for (int  i = 0; i < outTableRow; i++)
//	//{
//	//	for (int  j = 0; j < outTableCol; j++)
//	//	{
//	//		outTable[i][j] = CalulateInterpolation(i, j, inTable , inTableCol, inTableRow);
//	//	}
//	//}
//
//
//	for (int i = 0; i < outTableRow -1; i++)
//	{
//		for (int  j = 0; j < outTableCol; j++)
//		{
//			outTable[i][j] = CalulateInterpolation(i, j, inTable, inTableCol, inTableRow);
//
//		}
//	}
//
//
//
//}

//float SearchOptimalResultFromNew(int x, int y, float** outTable, int  outTableRow, int  outTableCol)
//{
//
//	for (int i = 0; i < outTableRow; i++)
//	{
//		
//		for (int  i = 0; i < outTableCol; i++)
//		{
//
//
//		}
//
//	}
//	
//}




void AODCalculate ()
{
	
	//const int searchTabColCount = 7;   //ұ
	//const int  intervalCount = 5;           //ұֵ
	//const int solZenCount = 8;         //̫춥Ǹ
	//const int senZenCount = 7;		   //춥Ǹ
	//const int solAziCount = 9;		   //λǸʵԷλǸ
	//const int aod550Count = 6;		   //aod
	//double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 72, 84 };//̫춥
	//double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
	//double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
	//double aod550[aod550Count] = { 0.0001, 0.25, 0.5, 1.0, 1.5, 1.95 };//550nmܽѧ


	
#pragma region ļұ
	float aodSumSearchTable[solZenCount * senZenCount *solAziCount *aod550Count][searchTabColCount] =
	{ { 0.04618, 0.95014, 0.01889, 0, 0, 0, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 24, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 48, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 72, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 96, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 120, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 144, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 168, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 180, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 0, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 24, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 48, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 72, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 96, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 120, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 144, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 168, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 180, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 0, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 24, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 48, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 72, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 96, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 120, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 144, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 168, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 180, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 0, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 24, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 48, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 72, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 96, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 120, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 144, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 168, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 180, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 0, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 24, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 48, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 72, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 96, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 120, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 144, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 168, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 180, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 0, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 24, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 48, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 72, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 96, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 120, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 144, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 168, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 180, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 0, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 24, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 48, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 72, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 96, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 120, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 144, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 168, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 180, 0.0001 },
	{ 0.04618, 0.94907, 0.01974, 12, 12, 0, 0.0001 },
	{ 0.04618, 0.94907, 0.01968, 12, 12, 24, 0.0001 },
	{ 0.04618, 0.94907, 0.01948, 12, 12, 48, 0.0001 },
	{ 0.04618, 0.94907, 0.01921, 12, 12, 72, 0.0001 },
	{ 0.04618, 0.94907, 0.0189, 12, 12, 96, 0.0001 },
	{ 0.04618, 0.94907, 0.0186, 12, 12, 120, 0.0001 },
	{ 0.04618, 0.94907, 0.01838, 12, 12, 144, 0.0001 },
	{ 0.04618, 0.94907, 0.01826, 12, 12, 168, 0.0001 },
	{ 0.04618, 0.94907, 0.01824, 12, 12, 180, 0.0001 },
	{ 0.04618, 0.94734, 0.02071, 12, 24, 0, 0.0001 },
	{ 0.04618, 0.94734, 0.02057, 12, 24, 24, 0.0001 },
	{ 0.04618, 0.94734, 0.02018, 12, 24, 48, 0.0001 },
	{ 0.04618, 0.94734, 0.01963, 12, 24, 72, 0.0001 },
	{ 0.04618, 0.94734, 0.01902, 12, 24, 96, 0.0001 },
	{ 0.04618, 0.94734, 0.01845, 12, 24, 120, 0.0001 },
	{ 0.04618, 0.94734, 0.01803, 12, 24, 144, 0.0001 },
	{ 0.04618, 0.94734, 0.0178, 12, 24, 168, 0.0001 },
	{ 0.04618, 0.94734, 0.01777, 12, 24, 180, 0.0001 },
	{ 0.04618, 0.94398, 0.02201, 12, 36, 0, 0.0001 },
	{ 0.04618, 0.94398, 0.0218, 12, 36, 24, 0.0001 },
	{ 0.04618, 0.94398, 0.02122, 12, 36, 48, 0.0001 },
	{ 0.04618, 0.94398, 0.0204, 12, 36, 72, 0.0001 },
	{ 0.04618, 0.94398, 0.01951, 12, 36, 96, 0.0001 },
	{ 0.04618, 0.94398, 0.01872, 12, 36, 120, 0.0001 },
	{ 0.04618, 0.94398, 0.01813, 12, 36, 144, 0.0001 },
	{ 0.04618, 0.94398, 0.01782, 12, 36, 168, 0.0001 },
	{ 0.04618, 0.94398, 0.01778, 12, 36, 180, 0.0001 },
	{ 0.04618, 0.9379, 0.02414, 12, 48, 0, 0.0001 },
	{ 0.04618, 0.9379, 0.02386, 12, 48, 24, 0.0001 },
	{ 0.04618, 0.9379, 0.02309, 12, 48, 48, 0.0001 },
	{ 0.04618, 0.9379, 0.02202, 12, 48, 72, 0.0001 },
	{ 0.04618, 0.9379, 0.02089, 12, 48, 96, 0.0001 },
	{ 0.04618, 0.9379, 0.01992, 12, 48, 120, 0.0001 },
	{ 0.04618, 0.9379, 0.01923, 12, 48, 144, 0.0001 },
	{ 0.04618, 0.9379, 0.01887, 12, 48, 168, 0.0001 },
	{ 0.04618, 0.9379, 0.01883, 12, 48, 180, 0.0001 },
	{ 0.04618, 0.92623, 0.02839, 12, 60, 0, 0.0001 },
	{ 0.04618, 0.92623, 0.02803, 12, 60, 24, 0.0001 },
	{ 0.04618, 0.92623, 0.02706, 12, 60, 48, 0.0001 },
	{ 0.04618, 0.92623, 0.02576, 12, 60, 72, 0.0001 },
	{ 0.04618, 0.92623, 0.02445, 12, 60, 96, 0.0001 },
	{ 0.04618, 0.92623, 0.02338, 12, 60, 120, 0.0001 },
	{ 0.04618, 0.92623, 0.02267, 12, 60, 144, 0.0001 },
	{ 0.04618, 0.92623, 0.02232, 12, 60, 168, 0.0001 },
	{ 0.04618, 0.92623, 0.02228, 12, 60, 180, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 0, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 24, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 48, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 72, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 96, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 120, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 144, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 168, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 180, 0.0001 },
	{ 0.04618, 0.94734, 0.02071, 24, 12, 0, 0.0001 },
	{ 0.04618, 0.94734, 0.02057, 24, 12, 24, 0.0001 },
	{ 0.04618, 0.94734, 0.02018, 24, 12, 48, 0.0001 },
	{ 0.04618, 0.94734, 0.01963, 24, 12, 72, 0.0001 },
	{ 0.04618, 0.94734, 0.01902, 24, 12, 96, 0.0001 },
	{ 0.04618, 0.94734, 0.01845, 24, 12, 120, 0.0001 },
	{ 0.04618, 0.94734, 0.01803, 24, 12, 144, 0.0001 },
	{ 0.04618, 0.94734, 0.0178, 24, 12, 168, 0.0001 },
	{ 0.04618, 0.94734, 0.01777, 24, 12, 180, 0.0001 },
	{ 0.04618, 0.94562, 0.02262, 24, 24, 0, 0.0001 },
	{ 0.04618, 0.94562, 0.02232, 24, 24, 24, 0.0001 },
	{ 0.04618, 0.94562, 0.02151, 24, 24, 48, 0.0001 },
	{ 0.04618, 0.94562, 0.02037, 24, 24, 72, 0.0001 },
	{ 0.04618, 0.94562, 0.01916, 24, 24, 96, 0.0001 },
	{ 0.04618, 0.94562, 0.0181, 24, 24, 120, 0.0001 },
	{ 0.04618, 0.94562, 0.01733, 24, 24, 144, 0.0001 },
	{ 0.04618, 0.94562, 0.01693, 24, 24, 168, 0.0001 },
	{ 0.04618, 0.94562, 0.01688, 24, 24, 180, 0.0001 },
	{ 0.04618, 0.94226, 0.025, 24, 36, 0, 0.0001 },
	{ 0.04618, 0.94226, 0.02453, 24, 36, 24, 0.0001 },
	{ 0.04618, 0.94226, 0.02326, 24, 36, 48, 0.0001 },
	{ 0.04618, 0.94226, 0.02153, 24, 36, 72, 0.0001 },
	{ 0.04618, 0.94226, 0.01977, 24, 36, 96, 0.0001 },
	{ 0.04618, 0.94226, 0.0183, 24, 36, 120, 0.0001 },
	{ 0.04618, 0.94226, 0.01729, 24, 36, 144, 0.0001 },
	{ 0.04618, 0.94226, 0.0168, 24, 36, 168, 0.0001 },
	{ 0.04618, 0.94226, 0.01674, 24, 36, 180, 0.0001 },
	{ 0.04618, 0.93619, 0.02839, 24, 48, 0, 0.0001 },
	{ 0.04618, 0.93619, 0.02772, 24, 48, 24, 0.0001 },
	{ 0.04618, 0.93619, 0.02595, 24, 48, 48, 0.0001 },
	{ 0.04618, 0.93619, 0.02363, 24, 48, 72, 0.0001 },
	{ 0.04618, 0.93619, 0.02137, 24, 48, 96, 0.0001 },
	{ 0.04618, 0.93619, 0.01963, 24, 48, 120, 0.0001 },
	{ 0.04618, 0.93619, 0.01856, 24, 48, 144, 0.0001 },
	{ 0.04618, 0.93619, 0.01807, 24, 48, 168, 0.0001 },
	{ 0.04618, 0.93619, 0.01802, 24, 48, 180, 0.0001 },
	{ 0.04618, 0.92454, 0.03426, 24, 60, 0, 0.0001 },
	{ 0.04618, 0.92454, 0.03336, 24, 60, 24, 0.0001 },
	{ 0.04618, 0.92454, 0.031, 24, 60, 48, 0.0001 },
	{ 0.04618, 0.92454, 0.02803, 24, 60, 72, 0.0001 },
	{ 0.04618, 0.92454, 0.02537, 24, 60, 96, 0.0001 },
	{ 0.04618, 0.92454, 0.02357, 24, 60, 120, 0.0001 },
	{ 0.04618, 0.92454, 0.02267, 24, 60, 144, 0.0001 },
	{ 0.04618, 0.92454, 0.02236, 24, 60, 168, 0.0001 },
	{ 0.04618, 0.92454, 0.02233, 24, 60, 180, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 0, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 24, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 48, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 72, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 96, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 120, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 144, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 168, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 180, 0.0001 },
	{ 0.04618, 0.94398, 0.02201, 36, 12, 0, 0.0001 },
	{ 0.04618, 0.94398, 0.0218, 36, 12, 24, 0.0001 },
	{ 0.04618, 0.94398, 0.02122, 36, 12, 48, 0.0001 },
	{ 0.04618, 0.94398, 0.0204, 36, 12, 72, 0.0001 },
	{ 0.04618, 0.94398, 0.01951, 36, 12, 96, 0.0001 },
	{ 0.04618, 0.94398, 0.01872, 36, 12, 120, 0.0001 },
	{ 0.04618, 0.94398, 0.01813, 36, 12, 144, 0.0001 },
	{ 0.04618, 0.94398, 0.01782, 36, 12, 168, 0.0001 },
	{ 0.04618, 0.94398, 0.01778, 36, 12, 180, 0.0001 },
	{ 0.04618, 0.94226, 0.025, 36, 24, 0, 0.0001 },
	{ 0.04618, 0.94226, 0.02453, 36, 24, 24, 0.0001 },
	{ 0.04618, 0.94226, 0.02326, 36, 24, 48, 0.0001 },
	{ 0.04618, 0.94226, 0.02153, 36, 24, 72, 0.0001 },
	{ 0.04618, 0.94226, 0.01977, 36, 24, 96, 0.0001 },
	{ 0.04618, 0.94226, 0.0183, 36, 24, 120, 0.0001 },
	{ 0.04618, 0.94226, 0.01729, 36, 24, 144, 0.0001 },
	{ 0.04618, 0.94226, 0.0168, 36, 24, 168, 0.0001 },
	{ 0.04618, 0.94226, 0.01674, 36, 24, 180, 0.0001 },
	{ 0.04618, 0.93892, 0.02877, 36, 36, 0, 0.0001 },
	{ 0.04618, 0.93892, 0.02799, 36, 36, 24, 0.0001 },
	{ 0.04618, 0.93892, 0.02592, 36, 36, 48, 0.0001 },
	{ 0.04618, 0.93892, 0.02322, 36, 36, 72, 0.0001 },
	{ 0.04618, 0.93892, 0.02063, 36, 36, 96, 0.0001 },
	{ 0.04618, 0.93892, 0.01866, 36, 36, 120, 0.0001 },
	{ 0.04618, 0.93892, 0.01746, 36, 36, 144, 0.0001 },
	{ 0.04618, 0.93892, 0.01694, 36, 36, 168, 0.0001 },
	{ 0.04618, 0.93892, 0.01688, 36, 36, 180, 0.0001 },
	{ 0.04618, 0.93287, 0.03397, 36, 48, 0, 0.0001 },
	{ 0.04618, 0.93287, 0.03282, 36, 48, 24, 0.0001 },
	{ 0.04618, 0.93287, 0.02981, 36, 48, 48, 0.0001 },
	{ 0.04618, 0.93287, 0.02605, 36, 48, 72, 0.0001 },
	{ 0.04618, 0.93287, 0.0227, 36, 48, 96, 0.0001 },
	{ 0.04618, 0.93287, 0.02048, 36, 48, 120, 0.0001 },
	{ 0.04618, 0.93287, 0.01941, 36, 48, 144, 0.0001 },
	{ 0.04618, 0.93287, 0.01907, 36, 48, 168, 0.0001 },
	{ 0.04618, 0.93287, 0.01904, 36, 48, 180, 0.0001 },
	{ 0.04618, 0.92126, 0.04246, 36, 60, 0, 0.0001 },
	{ 0.04618, 0.92126, 0.04081, 36, 60, 24, 0.0001 },
	{ 0.04618, 0.92126, 0.03659, 36, 60, 48, 0.0001 },
	{ 0.04618, 0.92126, 0.03156, 36, 60, 72, 0.0001 },
	{ 0.04618, 0.92126, 0.02755, 36, 60, 96, 0.0001 },
	{ 0.04618, 0.92126, 0.02546, 36, 60, 120, 0.0001 },
	{ 0.04618, 0.92126, 0.02502, 36, 60, 144, 0.0001 },
	{ 0.04618, 0.92126, 0.02523, 36, 60, 168, 0.0001 },
	{ 0.04618, 0.92126, 0.02528, 36, 60, 180, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 0, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 24, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 48, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 72, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 96, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 120, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 144, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 168, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 180, 0.0001 },
	{ 0.04618, 0.9379, 0.02414, 48, 12, 0, 0.0001 },
	{ 0.04618, 0.9379, 0.02386, 48, 12, 24, 0.0001 },
	{ 0.04618, 0.9379, 0.02309, 48, 12, 48, 0.0001 },
	{ 0.04618, 0.9379, 0.02202, 48, 12, 72, 0.0001 },
	{ 0.04618, 0.9379, 0.02089, 48, 12, 96, 0.0001 },
	{ 0.04618, 0.9379, 0.01992, 48, 12, 120, 0.0001 },
	{ 0.04618, 0.9379, 0.01923, 48, 12, 144, 0.0001 },
	{ 0.04618, 0.9379, 0.01887, 48, 12, 168, 0.0001 },
	{ 0.04618, 0.9379, 0.01883, 48, 12, 180, 0.0001 },
	{ 0.04618, 0.93619, 0.02839, 48, 24, 0, 0.0001 },
	{ 0.04618, 0.93619, 0.02772, 48, 24, 24, 0.0001 },
	{ 0.04618, 0.93619, 0.02595, 48, 24, 48, 0.0001 },
	{ 0.04618, 0.93619, 0.02363, 48, 24, 72, 0.0001 },
	{ 0.04618, 0.93619, 0.02137, 48, 24, 96, 0.0001 },
	{ 0.04618, 0.93619, 0.01963, 48, 24, 120, 0.0001 },
	{ 0.04618, 0.93619, 0.01856, 48, 24, 144, 0.0001 },
	{ 0.04618, 0.93619, 0.01807, 48, 24, 168, 0.0001 },
	{ 0.04618, 0.93619, 0.01802, 48, 24, 180, 0.0001 },
	{ 0.04618, 0.93287, 0.03397, 48, 36, 0, 0.0001 },
	{ 0.04618, 0.93287, 0.03282, 48, 36, 24, 0.0001 },
	{ 0.04618, 0.93287, 0.02981, 48, 36, 48, 0.0001 },
	{ 0.04618, 0.93287, 0.02605, 48, 36, 72, 0.0001 },
	{ 0.04618, 0.93287, 0.0227, 48, 36, 96, 0.0001 },
	{ 0.04618, 0.93287, 0.02048, 48, 36, 120, 0.0001 },
	{ 0.04618, 0.93287, 0.01941, 48, 36, 144, 0.0001 },
	{ 0.04618, 0.93287, 0.01907, 48, 36, 168, 0.0001 },
	{ 0.04618, 0.93287, 0.01904, 48, 36, 180, 0.0001 },
	{ 0.04618, 0.92686, 0.04176, 48, 48, 0, 0.0001 },
	{ 0.04618, 0.92686, 0.03998, 48, 48, 24, 0.0001 },
	{ 0.04618, 0.92686, 0.03542, 48, 48, 48, 0.0001 },
	{ 0.04618, 0.92686, 0.02997, 48, 48, 72, 0.0001 },
	{ 0.04618, 0.92686, 0.0256, 48, 48, 96, 0.0001 },
	{ 0.04618, 0.92686, 0.02329, 48, 48, 120, 0.0001 },
	{ 0.04618, 0.92686, 0.02277, 48, 48, 144, 0.0001 },
	{ 0.04618, 0.92686, 0.02295, 48, 48, 168, 0.0001 },
	{ 0.04618, 0.92686, 0.023, 48, 48, 180, 0.0001 },
	{ 0.04618, 0.91533, 0.05427, 48, 60, 0, 0.0001 },
	{ 0.04618, 0.91533, 0.05159, 48, 60, 24, 0.0001 },
	{ 0.04618, 0.91533, 0.04488, 48, 60, 48, 0.0001 },
	{ 0.04618, 0.91533, 0.03729, 48, 60, 72, 0.0001 },
	{ 0.04618, 0.91533, 0.03194, 48, 60, 96, 0.0001 },
	{ 0.04618, 0.91533, 0.03019, 48, 60, 120, 0.0001 },
	{ 0.04618, 0.91533, 0.03111, 48, 60, 144, 0.0001 },
	{ 0.04618, 0.91533, 0.03247, 48, 60, 168, 0.0001 },
	{ 0.04618, 0.91533, 0.03269, 48, 60, 180, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 0, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 24, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 48, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 72, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 96, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 120, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 144, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 168, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 180, 0.0001 },
	{ 0.04618, 0.92623, 0.02839, 60, 12, 0, 0.0001 },
	{ 0.04618, 0.92623, 0.02803, 60, 12, 24, 0.0001 },
	{ 0.04618, 0.92623, 0.02706, 60, 12, 48, 0.0001 },
	{ 0.04618, 0.92623, 0.02576, 60, 12, 72, 0.0001 },
	{ 0.04618, 0.92623, 0.02445, 60, 12, 96, 0.0001 },
	{ 0.04618, 0.92623, 0.02338, 60, 12, 120, 0.0001 },
	{ 0.04618, 0.92623, 0.02267, 60, 12, 144, 0.0001 },
	{ 0.04618, 0.92623, 0.02232, 60, 12, 168, 0.0001 },
	{ 0.04618, 0.92623, 0.02228, 60, 12, 180, 0.0001 },
	{ 0.04618, 0.92454, 0.03427, 60, 24, 0, 0.0001 },
	{ 0.04618, 0.92454, 0.03336, 60, 24, 24, 0.0001 },
	{ 0.04618, 0.92454, 0.031, 60, 24, 48, 0.0001 },
	{ 0.04618, 0.92454, 0.02803, 60, 24, 72, 0.0001 },
	{ 0.04618, 0.92454, 0.02537, 60, 24, 96, 0.0001 },
	{ 0.04618, 0.92454, 0.02357, 60, 24, 120, 0.0001 },
	{ 0.04618, 0.92454, 0.02267, 60, 24, 144, 0.0001 },
	{ 0.04618, 0.92454, 0.02236, 60, 24, 168, 0.0001 },
	{ 0.04618, 0.92454, 0.02233, 60, 24, 180, 0.0001 },
	{ 0.04618, 0.92126, 0.04246, 60, 36, 0, 0.0001 },
	{ 0.04618, 0.92126, 0.04081, 60, 36, 24, 0.0001 },
	{ 0.04618, 0.92126, 0.03659, 60, 36, 48, 0.0001 },
	{ 0.04618, 0.92126, 0.03156, 60, 36, 72, 0.0001 },
	{ 0.04618, 0.92126, 0.02755, 60, 36, 96, 0.0001 },
	{ 0.04618, 0.92126, 0.02546, 60, 36, 120, 0.0001 },
	{ 0.04618, 0.92126, 0.02502, 60, 36, 144, 0.0001 },
	{ 0.04618, 0.92126, 0.02523, 60, 36, 168, 0.0001 },
	{ 0.04618, 0.92126, 0.02528, 60, 36, 180, 0.0001 },
	{ 0.04618, 0.91533, 0.05427, 60, 48, 0, 0.0001 },
	{ 0.04618, 0.91533, 0.05159, 60, 48, 24, 0.0001 },
	{ 0.04618, 0.91533, 0.04489, 60, 48, 48, 0.0001 },
	{ 0.04618, 0.91533, 0.03729, 60, 48, 72, 0.0001 },
	{ 0.04618, 0.91533, 0.03194, 60, 48, 96, 0.0001 },
	{ 0.04618, 0.91533, 0.03019, 60, 48, 120, 0.0001 },
	{ 0.04618, 0.91533, 0.03111, 60, 48, 144, 0.0001 },
	{ 0.04618, 0.91533, 0.03247, 60, 48, 168, 0.0001 },
	{ 0.04618, 0.91533, 0.03269, 60, 48, 180, 0.0001 },
	{ 0.04618, 0.90394, 0.0734, 60, 60, 0, 0.0001 },
	{ 0.04618, 0.90394, 0.0692, 60, 60, 24, 0.0001 },
	{ 0.04618, 0.90394, 0.05886, 60, 60, 48, 0.0001 },
	{ 0.04618, 0.90394, 0.04773, 60, 60, 72, 0.0001 },
	{ 0.04618, 0.90394, 0.041, 60, 60, 96, 0.0001 },
	{ 0.04618, 0.90394, 0.04061, 60, 60, 120, 0.0001 },
	{ 0.04618, 0.90394, 0.04441, 60, 60, 144, 0.0001 },
	{ 0.04618, 0.90394, 0.04802, 60, 60, 168, 0.0001 },
	{ 0.04618, 0.90394, 0.04856, 60, 60, 180, 0.0001 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 0, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 24, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 48, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 72, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 96, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 120, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 144, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 168, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 180, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 0, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 24, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 48, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 72, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 96, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 120, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 144, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 168, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 180, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 0, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 24, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 48, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 72, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 96, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 120, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 144, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 168, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 180, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 0, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 24, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 48, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 72, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 96, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 120, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 144, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 168, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 180, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 0, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 24, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 48, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 72, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 96, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 120, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 144, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 168, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 180, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 0, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 24, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 48, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 72, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 96, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 120, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 144, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 168, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 180, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 0, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 24, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 48, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 72, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 96, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 120, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 144, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 168, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 180, 0.2 },
	{ 0.06707, 0.81109, 0.02934, 12, 12, 0, 0.2 },
	{ 0.06707, 0.81109, 0.02875, 12, 12, 24, 0.2 },
	{ 0.06707, 0.81109, 0.02773, 12, 12, 48, 0.2 },
	{ 0.06707, 0.81109, 0.02698, 12, 12, 72, 0.2 },
	{ 0.06707, 0.81109, 0.02647, 12, 12, 96, 0.2 },
	{ 0.06707, 0.81109, 0.02607, 12, 12, 120, 0.2 },
	{ 0.06707, 0.81109, 0.02577, 12, 12, 144, 0.2 },
	{ 0.06707, 0.81109, 0.0256, 12, 12, 168, 0.2 },
	{ 0.06707, 0.81109, 0.02558, 12, 12, 180, 0.2 },
	{ 0.06707, 0.80427, 0.02921, 12, 24, 0, 0.2 },
	{ 0.06707, 0.80427, 0.02889, 12, 24, 24, 0.2 },
	{ 0.06707, 0.80427, 0.02827, 12, 24, 48, 0.2 },
	{ 0.06707, 0.80427, 0.02751, 12, 24, 72, 0.2 },
	{ 0.06707, 0.80427, 0.02668, 12, 24, 96, 0.2 },
	{ 0.06707, 0.80427, 0.02593, 12, 24, 120, 0.2 },
	{ 0.06707, 0.80427, 0.02538, 12, 24, 144, 0.2 },
	{ 0.06707, 0.80427, 0.02509, 12, 24, 168, 0.2 },
	{ 0.06707, 0.80427, 0.02506, 12, 24, 180, 0.2 },
	{ 0.06707, 0.79096, 0.03084, 12, 36, 0, 0.2 },
	{ 0.06707, 0.79096, 0.03056, 12, 36, 24, 0.2 },
	{ 0.06707, 0.79096, 0.02977, 12, 36, 48, 0.2 },
	{ 0.06707, 0.79096, 0.02869, 12, 36, 72, 0.2 },
	{ 0.06707, 0.79096, 0.02759, 12, 36, 96, 0.2 },
	{ 0.06707, 0.79096, 0.02666, 12, 36, 120, 0.2 },
	{ 0.06707, 0.79096, 0.02601, 12, 36, 144, 0.2 },
	{ 0.06707, 0.79096, 0.02569, 12, 36, 168, 0.2 },
	{ 0.06707, 0.79096, 0.02565, 12, 36, 180, 0.2 },
	{ 0.06707, 0.76695, 0.03393, 12, 48, 0, 0.2 },
	{ 0.06707, 0.76695, 0.03358, 12, 48, 24, 0.2 },
	{ 0.06707, 0.76695, 0.03266, 12, 48, 48, 0.2 },
	{ 0.06707, 0.76695, 0.03145, 12, 48, 72, 0.2 },
	{ 0.06707, 0.76695, 0.03028, 12, 48, 96, 0.2 },
	{ 0.06707, 0.76695, 0.02937, 12, 48, 120, 0.2 },
	{ 0.06707, 0.76695, 0.02878, 12, 48, 144, 0.2 },
	{ 0.06707, 0.76695, 0.0285, 12, 48, 168, 0.2 },
	{ 0.06707, 0.76695, 0.02847, 12, 48, 180, 0.2 },
	{ 0.06707, 0.722, 0.04046, 12, 60, 0, 0.2 },
	{ 0.06707, 0.722, 0.04009, 12, 60, 24, 0.2 },
	{ 0.06707, 0.722, 0.03914, 12, 60, 48, 0.2 },
	{ 0.06707, 0.722, 0.03798, 12, 60, 72, 0.2 },
	{ 0.06707, 0.722, 0.03697, 12, 60, 96, 0.2 },
	{ 0.06707, 0.722, 0.03634, 12, 60, 120, 0.2 },
	{ 0.06707, 0.722, 0.03607, 12, 60, 144, 0.2 },
	{ 0.06707, 0.722, 0.03601, 12, 60, 168, 0.2 },
	{ 0.06707, 0.722, 0.03601, 12, 60, 180, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 0, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 24, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 48, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 72, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 96, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 120, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 144, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 168, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 180, 0.2 },
	{ 0.06707, 0.80427, 0.02921, 24, 12, 0, 0.2 },
	{ 0.06707, 0.80427, 0.02889, 24, 12, 24, 0.2 },
	{ 0.06707, 0.80427, 0.02827, 24, 12, 48, 0.2 },
	{ 0.06707, 0.80427, 0.02751, 24, 12, 72, 0.2 },
	{ 0.06707, 0.80427, 0.02668, 24, 12, 96, 0.2 },
	{ 0.06707, 0.80427, 0.02593, 24, 12, 120, 0.2 },
	{ 0.06707, 0.80427, 0.02538, 24, 12, 144, 0.2 },
	{ 0.06707, 0.80427, 0.02509, 24, 12, 168, 0.2 },
	{ 0.06707, 0.80427, 0.02506, 24, 12, 180, 0.2 },
	{ 0.06707, 0.79751, 0.03358, 24, 24, 0, 0.2 },
	{ 0.06707, 0.79751, 0.03175, 24, 24, 24, 0.2 },
	{ 0.06707, 0.79751, 0.03013, 24, 24, 48, 0.2 },
	{ 0.06707, 0.79751, 0.02859, 24, 24, 72, 0.2 },
	{ 0.06707, 0.79751, 0.027, 24, 24, 96, 0.2 },
	{ 0.06707, 0.79751, 0.0257, 24, 24, 120, 0.2 },
	{ 0.06707, 0.79751, 0.02484, 24, 24, 144, 0.2 },
	{ 0.06707, 0.79751, 0.02442, 24, 24, 168, 0.2 },
	{ 0.06707, 0.79751, 0.02437, 24, 24, 180, 0.2 },
	{ 0.06707, 0.78431, 0.03525, 24, 36, 0, 0.2 },
	{ 0.06707, 0.78431, 0.03435, 24, 36, 24, 0.2 },
	{ 0.06707, 0.78431, 0.03262, 24, 36, 48, 0.2 },
	{ 0.06707, 0.78431, 0.03034, 24, 36, 72, 0.2 },
	{ 0.06707, 0.78431, 0.02826, 24, 36, 96, 0.2 },
	{ 0.06707, 0.78431, 0.02673, 24, 36, 120, 0.2 },
	{ 0.06707, 0.78431, 0.02583, 24, 36, 144, 0.2 },
	{ 0.06707, 0.78431, 0.02544, 24, 36, 168, 0.2 },
	{ 0.06707, 0.78431, 0.02539, 24, 36, 180, 0.2 },
	{ 0.06707, 0.7605, 0.03971, 24, 48, 0, 0.2 },
	{ 0.06707, 0.7605, 0.03881, 24, 48, 24, 0.2 },
	{ 0.06707, 0.7605, 0.0365, 24, 48, 48, 0.2 },
	{ 0.06707, 0.7605, 0.03378, 24, 48, 72, 0.2 },
	{ 0.06707, 0.7605, 0.03152, 24, 48, 96, 0.2 },
	{ 0.06707, 0.7605, 0.03015, 24, 48, 120, 0.2 },
	{ 0.06707, 0.7605, 0.02961, 24, 48, 144, 0.2 },
	{ 0.06707, 0.7605, 0.02951, 24, 48, 168, 0.2 },
	{ 0.06707, 0.7605, 0.02951, 24, 48, 180, 0.2 },
	{ 0.06707, 0.71593, 0.04778, 24, 60, 0, 0.2 },
	{ 0.06707, 0.71593, 0.04669, 24, 60, 24, 0.2 },
	{ 0.06707, 0.71593, 0.04403, 24, 60, 48, 0.2 },
	{ 0.06707, 0.71593, 0.04113, 24, 60, 72, 0.2 },
	{ 0.06707, 0.71593, 0.03916, 24, 60, 96, 0.2 },
	{ 0.06707, 0.71593, 0.03865, 24, 60, 120, 0.2 },
	{ 0.06707, 0.71593, 0.03925, 24, 60, 144, 0.2 },
	{ 0.06707, 0.71593, 0.03999, 24, 60, 168, 0.2 },
	{ 0.06707, 0.71593, 0.04011, 24, 60, 180, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 0, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 24, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 48, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 72, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 96, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 120, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 144, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 168, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 180, 0.2 },
	{ 0.06707, 0.79096, 0.03085, 36, 12, 0, 0.2 },
	{ 0.06707, 0.79096, 0.03056, 36, 12, 24, 0.2 },
	{ 0.06707, 0.79096, 0.02977, 36, 12, 48, 0.2 },
	{ 0.06707, 0.79096, 0.02869, 36, 12, 72, 0.2 },
	{ 0.06707, 0.79096, 0.02759, 36, 12, 96, 0.2 },
	{ 0.06707, 0.79096, 0.02666, 36, 12, 120, 0.2 },
	{ 0.06707, 0.79096, 0.02601, 36, 12, 144, 0.2 },
	{ 0.06707, 0.79096, 0.02568, 36, 12, 168, 0.2 },
	{ 0.06707, 0.79096, 0.02564, 36, 12, 180, 0.2 },
	{ 0.06707, 0.78431, 0.03525, 36, 24, 0, 0.2 },
	{ 0.06707, 0.78431, 0.03436, 36, 24, 24, 0.2 },
	{ 0.06707, 0.78431, 0.03262, 36, 24, 48, 0.2 },
	{ 0.06707, 0.78431, 0.03034, 36, 24, 72, 0.2 },
	{ 0.06707, 0.78431, 0.02826, 36, 24, 96, 0.2 },
	{ 0.06707, 0.78431, 0.02673, 36, 24, 120, 0.2 },
	{ 0.06707, 0.78431, 0.02583, 36, 24, 144, 0.2 },
	{ 0.06707, 0.78431, 0.02543, 36, 24, 168, 0.2 },
	{ 0.06707, 0.78431, 0.02539, 36, 24, 180, 0.2 },
	{ 0.06707, 0.77133, 0.04263, 36, 36, 0, 0.2 },
	{ 0.06707, 0.77133, 0.0393, 36, 36, 24, 0.2 },
	{ 0.06707, 0.77133, 0.03638, 36, 36, 48, 0.2 },
	{ 0.06707, 0.77133, 0.03295, 36, 36, 72, 0.2 },
	{ 0.06707, 0.77133, 0.03017, 36, 36, 96, 0.2 },
	{ 0.06707, 0.77133, 0.0285, 36, 36, 120, 0.2 },
	{ 0.06707, 0.77133, 0.02784, 36, 36, 144, 0.2 },
	{ 0.06707, 0.77133, 0.02772, 36, 36, 168, 0.2 },
	{ 0.06707, 0.77133, 0.02772, 36, 36, 180, 0.2 },
	{ 0.06707, 0.74792, 0.04781, 36, 48, 0, 0.2 },
	{ 0.06707, 0.74792, 0.0459, 36, 48, 24, 0.2 },
	{ 0.06707, 0.74792, 0.04191, 36, 48, 48, 0.2 },
	{ 0.06707, 0.74792, 0.03751, 36, 48, 72, 0.2 },
	{ 0.06707, 0.74792, 0.03446, 36, 48, 96, 0.2 },
	{ 0.06707, 0.74792, 0.03336, 36, 48, 120, 0.2 },
	{ 0.06707, 0.74792, 0.03379, 36, 48, 144, 0.2 },
	{ 0.06707, 0.74792, 0.03456, 36, 48, 168, 0.2 },
	{ 0.06707, 0.74792, 0.03469, 36, 48, 180, 0.2 },
	{ 0.06707, 0.70408, 0.05894, 36, 60, 0, 0.2 },
	{ 0.06707, 0.70408, 0.05676, 36, 60, 24, 0.2 },
	{ 0.06707, 0.70408, 0.05157, 36, 60, 48, 0.2 },
	{ 0.06707, 0.70408, 0.04648, 36, 60, 72, 0.2 },
	{ 0.06707, 0.70408, 0.04385, 36, 60, 96, 0.2 },
	{ 0.06707, 0.70408, 0.04467, 36, 60, 120, 0.2 },
	{ 0.06707, 0.70408, 0.04798, 36, 60, 144, 0.2 },
	{ 0.06707, 0.70408, 0.051, 36, 60, 168, 0.2 },
	{ 0.06707, 0.70408, 0.05146, 36, 60, 180, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 0, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 24, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 48, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 72, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 96, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 120, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 144, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 168, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 180, 0.2 },
	{ 0.06707, 0.76695, 0.03394, 48, 12, 0, 0.2 },
	{ 0.06707, 0.76695, 0.03359, 48, 12, 24, 0.2 },
	{ 0.06707, 0.76695, 0.03266, 48, 12, 48, 0.2 },
	{ 0.06707, 0.76695, 0.03146, 48, 12, 72, 0.2 },
	{ 0.06707, 0.76695, 0.03028, 48, 12, 96, 0.2 },
	{ 0.06707, 0.76695, 0.02936, 48, 12, 120, 0.2 },
	{ 0.06707, 0.76695, 0.02877, 48, 12, 144, 0.2 },
	{ 0.06707, 0.76695, 0.0285, 48, 12, 168, 0.2 },
	{ 0.06707, 0.76695, 0.02846, 48, 12, 180, 0.2 },
	{ 0.06707, 0.7605, 0.03972, 48, 24, 0, 0.2 },
	{ 0.06707, 0.7605, 0.03882, 48, 24, 24, 0.2 },
	{ 0.06707, 0.7605, 0.03651, 48, 24, 48, 0.2 },
	{ 0.06707, 0.7605, 0.03378, 48, 24, 72, 0.2 },
	{ 0.06707, 0.7605, 0.03153, 48, 24, 96, 0.2 },
	{ 0.06707, 0.7605, 0.03015, 48, 24, 120, 0.2 },
	{ 0.06707, 0.7605, 0.0296, 48, 24, 144, 0.2 },
	{ 0.06707, 0.7605, 0.0295, 48, 24, 168, 0.2 },
	{ 0.06707, 0.7605, 0.0295, 48, 24, 180, 0.2 },
	{ 0.06707, 0.74792, 0.04781, 48, 36, 0, 0.2 },
	{ 0.06707, 0.74792, 0.04591, 48, 36, 24, 0.2 },
	{ 0.06707, 0.74792, 0.04191, 48, 36, 48, 0.2 },
	{ 0.06707, 0.74792, 0.03752, 48, 36, 72, 0.2 },
	{ 0.06707, 0.74792, 0.03446, 48, 36, 96, 0.2 },
	{ 0.06707, 0.74792, 0.03335, 48, 36, 120, 0.2 },
	{ 0.06707, 0.74792, 0.03378, 48, 36, 144, 0.2 },
	{ 0.06707, 0.74792, 0.03455, 48, 36, 168, 0.2 },
	{ 0.06707, 0.74792, 0.03468, 48, 36, 180, 0.2 },
	{ 0.06707, 0.72521, 0.06154, 48, 48, 0, 0.2 },
	{ 0.06707, 0.72521, 0.05585, 48, 48, 24, 0.2 },
	{ 0.06707, 0.72521, 0.04984, 48, 48, 48, 0.2 },
	{ 0.06707, 0.72521, 0.04379, 48, 48, 72, 0.2 },
	{ 0.06707, 0.72521, 0.04047, 48, 48, 96, 0.2 },
	{ 0.06707, 0.72521, 0.04083, 48, 48, 120, 0.2 },
	{ 0.06707, 0.72521, 0.04395, 48, 48, 144, 0.2 },
	{ 0.06707, 0.72521, 0.04695, 48, 48, 168, 0.2 },
	{ 0.06707, 0.72521, 0.04742, 48, 48, 180, 0.2 },
	{ 0.06707, 0.68271, 0.07568, 48, 60, 0, 0.2 },
	{ 0.06707, 0.68271, 0.07162, 48, 60, 24, 0.2 },
	{ 0.06707, 0.68271, 0.06313, 48, 60, 48, 0.2 },
	{ 0.06707, 0.68271, 0.05547, 48, 60, 72, 0.2 },
	{ 0.06707, 0.68271, 0.05284, 48, 60, 96, 0.2 },
	{ 0.06707, 0.68271, 0.0571, 48, 60, 120, 0.2 },
	{ 0.06707, 0.68271, 0.06661, 48, 60, 144, 0.2 },
	{ 0.06707, 0.68271, 0.07509, 48, 60, 168, 0.2 },
	{ 0.06707, 0.68271, 0.07641, 48, 60, 180, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 0, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 24, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 48, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 72, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 96, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 120, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 144, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 168, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 180, 0.2 },
	{ 0.06707, 0.722, 0.04047, 60, 12, 0, 0.2 },
	{ 0.06707, 0.722, 0.0401, 60, 12, 24, 0.2 },
	{ 0.06707, 0.722, 0.03915, 60, 12, 48, 0.2 },
	{ 0.06707, 0.722, 0.03798, 60, 12, 72, 0.2 },
	{ 0.06707, 0.722, 0.03697, 60, 12, 96, 0.2 },
	{ 0.06707, 0.722, 0.03634, 60, 12, 120, 0.2 },
	{ 0.06707, 0.722, 0.03607, 60, 12, 144, 0.2 },
	{ 0.06707, 0.722, 0.03601, 60, 12, 168, 0.2 },
	{ 0.06707, 0.722, 0.03601, 60, 12, 180, 0.2 },
	{ 0.06707, 0.71593, 0.04779, 60, 24, 0, 0.2 },
	{ 0.06707, 0.71593, 0.0467, 60, 24, 24, 0.2 },
	{ 0.06707, 0.71593, 0.04404, 60, 24, 48, 0.2 },
	{ 0.06707, 0.71593, 0.04114, 60, 24, 72, 0.2 },
	{ 0.06707, 0.71593, 0.03917, 60, 24, 96, 0.2 },
	{ 0.06707, 0.71593, 0.03865, 60, 24, 120, 0.2 },
	{ 0.06707, 0.71593, 0.03925, 60, 24, 144, 0.2 },
	{ 0.06707, 0.71593, 0.03999, 60, 24, 168, 0.2 },
	{ 0.06707, 0.71593, 0.0401, 60, 24, 180, 0.2 },
	{ 0.06707, 0.70408, 0.05895, 60, 36, 0, 0.2 },
	{ 0.06707, 0.70408, 0.05677, 60, 36, 24, 0.2 },
	{ 0.06707, 0.70408, 0.05158, 60, 36, 48, 0.2 },
	{ 0.06707, 0.70408, 0.04648, 60, 36, 72, 0.2 },
	{ 0.06707, 0.70408, 0.04385, 60, 36, 96, 0.2 },
	{ 0.06707, 0.70408, 0.04467, 60, 36, 120, 0.2 },
	{ 0.06707, 0.70408, 0.04797, 60, 36, 144, 0.2 },
	{ 0.06707, 0.70408, 0.051, 60, 36, 168, 0.2 },
	{ 0.06707, 0.70408, 0.05146, 60, 36, 180, 0.2 },
	{ 0.06707, 0.68271, 0.07568, 60, 48, 0, 0.2 },
	{ 0.06707, 0.68271, 0.07163, 60, 48, 24, 0.2 },
	{ 0.06707, 0.68271, 0.06314, 60, 48, 48, 0.2 },
	{ 0.06707, 0.68271, 0.05547, 60, 48, 72, 0.2 },
	{ 0.06707, 0.68271, 0.05284, 60, 48, 96, 0.2 },
	{ 0.06707, 0.68271, 0.0571, 60, 48, 120, 0.2 },
	{ 0.06707, 0.68271, 0.06661, 60, 48, 144, 0.2 },
	{ 0.06707, 0.68271, 0.07509, 60, 48, 168, 0.2 },
	{ 0.06707, 0.68271, 0.07641, 60, 48, 180, 0.2 },
	{ 0.06707, 0.64269, 0.10621, 60, 60, 0, 0.2 },
	{ 0.06707, 0.64269, 0.09543, 60, 60, 24, 0.2 },
	{ 0.06707, 0.64269, 0.08254, 60, 60, 48, 0.2 },
	{ 0.06707, 0.64269, 0.07185, 60, 60, 72, 0.2 },
	{ 0.06707, 0.64269, 0.0705, 60, 60, 96, 0.2 },
	{ 0.06707, 0.64269, 0.08244, 60, 60, 120, 0.2 },
	{ 0.06707, 0.64269, 0.10592, 60, 60, 144, 0.2 },
	{ 0.06707, 0.64269, 0.12787, 60, 60, 168, 0.2 },
	{ 0.06707, 0.64269, 0.13141, 60, 60, 180, 0.2 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 0, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 24, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 48, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 72, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 96, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 120, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 144, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 168, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 180, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 0, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 24, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 48, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 72, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 96, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 120, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 144, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 168, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 180, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 0, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 24, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 48, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 72, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 96, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 120, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 144, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 168, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 180, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 0, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 24, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 48, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 72, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 96, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 120, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 144, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 168, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 180, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 0, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 24, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 48, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 72, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 96, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 120, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 144, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 168, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 180, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 0, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 24, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 48, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 72, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 96, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 120, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 144, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 168, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 180, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 0, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 24, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 48, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 72, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 96, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 120, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 144, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 168, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 180, 0.4 },
	{ 0.08042, 0.68921, 0.03758, 12, 12, 0, 0.4 },
	{ 0.08042, 0.68921, 0.0366, 12, 12, 24, 0.4 },
	{ 0.08042, 0.68921, 0.03499, 12, 12, 48, 0.4 },
	{ 0.08042, 0.68921, 0.03389, 12, 12, 72, 0.4 },
	{ 0.08042, 0.68921, 0.03326, 12, 12, 96, 0.4 },
	{ 0.08042, 0.68921, 0.03279, 12, 12, 120, 0.4 },
	{ 0.08042, 0.68921, 0.03243, 12, 12, 144, 0.4 },
	{ 0.08042, 0.68921, 0.03224, 12, 12, 168, 0.4 },
	{ 0.08042, 0.68921, 0.03222, 12, 12, 180, 0.4 },
	{ 0.08042, 0.67878, 0.03668, 12, 24, 0, 0.4 },
	{ 0.08042, 0.67878, 0.03623, 12, 24, 24, 0.4 },
	{ 0.08042, 0.67878, 0.03545, 12, 24, 48, 0.4 },
	{ 0.08042, 0.67878, 0.03457, 12, 24, 72, 0.4 },
	{ 0.08042, 0.67878, 0.0336, 12, 24, 96, 0.4 },
	{ 0.08042, 0.67878, 0.03272, 12, 24, 120, 0.4 },
	{ 0.08042, 0.67878, 0.0321, 12, 24, 144, 0.4 },
	{ 0.08042, 0.67878, 0.03178, 12, 24, 168, 0.4 },
	{ 0.08042, 0.67878, 0.03174, 12, 24, 180, 0.4 },
	{ 0.08042, 0.6587, 0.03862, 12, 36, 0, 0.4 },
	{ 0.08042, 0.6587, 0.03828, 12, 36, 24, 0.4 },
	{ 0.08042, 0.6587, 0.03737, 12, 36, 48, 0.4 },
	{ 0.08042, 0.6587, 0.03613, 12, 36, 72, 0.4 },
	{ 0.08042, 0.6587, 0.03491, 12, 36, 96, 0.4 },
	{ 0.08042, 0.6587, 0.03393, 12, 36, 120, 0.4 },
	{ 0.08042, 0.6587, 0.03327, 12, 36, 144, 0.4 },
	{ 0.08042, 0.6587, 0.03295, 12, 36, 168, 0.4 },
	{ 0.08042, 0.6587, 0.03291, 12, 36, 180, 0.4 },
	{ 0.08042, 0.62344, 0.04245, 12, 48, 0, 0.4 },
	{ 0.08042, 0.62344, 0.04207, 12, 48, 24, 0.4 },
	{ 0.08042, 0.62344, 0.04108, 12, 48, 48, 0.4 },
	{ 0.08042, 0.62344, 0.03984, 12, 48, 72, 0.4 },
	{ 0.08042, 0.62344, 0.03871, 12, 48, 96, 0.4 },
	{ 0.08042, 0.62344, 0.0379, 12, 48, 120, 0.4 },
	{ 0.08042, 0.62344, 0.03745, 12, 48, 144, 0.4 },
	{ 0.08042, 0.62344, 0.03727, 12, 48, 168, 0.4 },
	{ 0.08042, 0.62344, 0.03725, 12, 48, 180, 0.4 },
	{ 0.08042, 0.5609, 0.05045, 12, 60, 0, 0.4 },
	{ 0.08042, 0.5609, 0.0501, 12, 60, 24, 0.4 },
	{ 0.08042, 0.5609, 0.04923, 12, 60, 48, 0.4 },
	{ 0.08042, 0.5609, 0.04826, 12, 60, 72, 0.4 },
	{ 0.08042, 0.5609, 0.04759, 12, 60, 96, 0.4 },
	{ 0.08042, 0.5609, 0.04738, 12, 60, 120, 0.4 },
	{ 0.08042, 0.5609, 0.04752, 12, 60, 144, 0.4 },
	{ 0.08042, 0.5609, 0.04772, 12, 60, 168, 0.4 },
	{ 0.08042, 0.5609, 0.04775, 12, 60, 180, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 0, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 24, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 48, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 72, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 96, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 120, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 144, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 168, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 180, 0.4 },
	{ 0.08042, 0.67878, 0.03668, 24, 12, 0, 0.4 },
	{ 0.08042, 0.67878, 0.03624, 24, 12, 24, 0.4 },
	{ 0.08042, 0.67878, 0.03545, 24, 12, 48, 0.4 },
	{ 0.08042, 0.67878, 0.03457, 24, 12, 72, 0.4 },
	{ 0.08042, 0.67878, 0.03359, 24, 12, 96, 0.4 },
	{ 0.08042, 0.67878, 0.03272, 24, 12, 120, 0.4 },
	{ 0.08042, 0.67878, 0.0321, 24, 12, 144, 0.4 },
	{ 0.08042, 0.67878, 0.03178, 24, 12, 168, 0.4 },
	{ 0.08042, 0.67878, 0.03174, 24, 12, 180, 0.4 },
	{ 0.08042, 0.66851, 0.04284, 24, 24, 0, 0.4 },
	{ 0.08042, 0.66851, 0.03993, 24, 24, 24, 0.4 },
	{ 0.08042, 0.66851, 0.03774, 24, 24, 48, 0.4 },
	{ 0.08042, 0.66851, 0.03594, 24, 24, 72, 0.4 },
	{ 0.08042, 0.66851, 0.03411, 24, 24, 96, 0.4 },
	{ 0.08042, 0.66851, 0.0327, 24, 24, 120, 0.4 },
	{ 0.08042, 0.66851, 0.03181, 24, 24, 144, 0.4 },
	{ 0.08042, 0.66851, 0.03139, 24, 24, 168, 0.4 },
	{ 0.08042, 0.66851, 0.03134, 24, 24, 180, 0.4 },
	{ 0.08042, 0.64873, 0.04404, 24, 36, 0, 0.4 },
	{ 0.08042, 0.64873, 0.04286, 24, 36, 24, 0.4 },
	{ 0.08042, 0.64873, 0.04082, 24, 36, 48, 0.4 },
	{ 0.08042, 0.64873, 0.03822, 24, 36, 72, 0.4 },
	{ 0.08042, 0.64873, 0.03599, 24, 36, 96, 0.4 },
	{ 0.08042, 0.64873, 0.03453, 24, 36, 120, 0.4 },
	{ 0.08042, 0.64873, 0.03378, 24, 36, 144, 0.4 },
	{ 0.08042, 0.64873, 0.03352, 24, 36, 168, 0.4 },
	{ 0.08042, 0.64873, 0.03349, 24, 36, 180, 0.4 },
	{ 0.08042, 0.614, 0.04925, 24, 48, 0, 0.4 },
	{ 0.08042, 0.614, 0.04822, 24, 48, 24, 0.4 },
	{ 0.08042, 0.614, 0.0456, 24, 48, 48, 0.4 },
	{ 0.08042, 0.614, 0.04272, 24, 48, 72, 0.4 },
	{ 0.08042, 0.614, 0.04063, 24, 48, 96, 0.4 },
	{ 0.08042, 0.614, 0.03971, 24, 48, 120, 0.4 },
	{ 0.08042, 0.614, 0.0397, 24, 48, 144, 0.4 },
	{ 0.08042, 0.614, 0.03997, 24, 48, 168, 0.4 },
	{ 0.08042, 0.614, 0.04002, 24, 48, 180, 0.4 },
	{ 0.08042, 0.55241, 0.0586, 24, 60, 0, 0.4 },
	{ 0.08042, 0.55241, 0.05743, 24, 60, 24, 0.4 },
	{ 0.08042, 0.55241, 0.0547, 24, 60, 48, 0.4 },
	{ 0.08042, 0.55241, 0.05206, 24, 60, 72, 0.4 },
	{ 0.08042, 0.55241, 0.05084, 24, 60, 96, 0.4 },
	{ 0.08042, 0.55241, 0.05149, 24, 60, 120, 0.4 },
	{ 0.08042, 0.55241, 0.05337, 24, 60, 144, 0.4 },
	{ 0.08042, 0.55241, 0.05497, 24, 60, 168, 0.4 },
	{ 0.08042, 0.55241, 0.05521, 24, 60, 180, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 0, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 24, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 48, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 72, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 96, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 120, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 144, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 168, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 180, 0.4 },
	{ 0.08042, 0.6587, 0.03863, 36, 12, 0, 0.4 },
	{ 0.08042, 0.6587, 0.03829, 36, 12, 24, 0.4 },
	{ 0.08042, 0.6587, 0.03738, 36, 12, 48, 0.4 },
	{ 0.08042, 0.6587, 0.03614, 36, 12, 72, 0.4 },
	{ 0.08042, 0.6587, 0.03491, 36, 12, 96, 0.4 },
	{ 0.08042, 0.6587, 0.03392, 36, 12, 120, 0.4 },
	{ 0.08042, 0.6587, 0.03327, 36, 12, 144, 0.4 },
	{ 0.08042, 0.6587, 0.03295, 36, 12, 168, 0.4 },
	{ 0.08042, 0.6587, 0.03291, 36, 12, 180, 0.4 },
	{ 0.08042, 0.64873, 0.04404, 36, 24, 0, 0.4 },
	{ 0.08042, 0.64873, 0.04286, 36, 24, 24, 0.4 },
	{ 0.08042, 0.64873, 0.04083, 36, 24, 48, 0.4 },
	{ 0.08042, 0.64873, 0.03822, 36, 24, 72, 0.4 },
	{ 0.08042, 0.64873, 0.03599, 36, 24, 96, 0.4 },
	{ 0.08042, 0.64873, 0.03453, 36, 24, 120, 0.4 },
	{ 0.08042, 0.64873, 0.03378, 36, 24, 144, 0.4 },
	{ 0.08042, 0.64873, 0.03351, 36, 24, 168, 0.4 },
	{ 0.08042, 0.64873, 0.03349, 36, 24, 180, 0.4 },
	{ 0.08042, 0.62954, 0.05392, 36, 36, 0, 0.4 },
	{ 0.08042, 0.62954, 0.04888, 36, 36, 24, 0.4 },
	{ 0.08042, 0.62954, 0.04542, 36, 36, 48, 0.4 },
	{ 0.08042, 0.62954, 0.04159, 36, 36, 72, 0.4 },
	{ 0.08042, 0.62954, 0.03884, 36, 36, 96, 0.4 },
	{ 0.08042, 0.62954, 0.03758, 36, 36, 120, 0.4 },
	{ 0.08042, 0.62954, 0.03748, 36, 36, 144, 0.4 },
	{ 0.08042, 0.62954, 0.03777, 36, 36, 168, 0.4 },
	{ 0.08042, 0.62954, 0.03783, 36, 36, 180, 0.4 },
	{ 0.08042, 0.59584, 0.05905, 36, 48, 0, 0.4 },
	{ 0.08042, 0.59584, 0.05667, 36, 48, 24, 0.4 },
	{ 0.08042, 0.59584, 0.05212, 36, 48, 48, 0.4 },
	{ 0.08042, 0.59584, 0.0475, 36, 48, 72, 0.4 },
	{ 0.08042, 0.59584, 0.04495, 36, 48, 96, 0.4 },
	{ 0.08042, 0.59584, 0.04496, 36, 48, 120, 0.4 },
	{ 0.08042, 0.59584, 0.04676, 36, 48, 144, 0.4 },
	{ 0.08042, 0.59584, 0.04851, 36, 48, 168, 0.4 },
	{ 0.08042, 0.59584, 0.04877, 36, 48, 180, 0.4 },
	{ 0.08042, 0.53607, 0.07158, 36, 60, 0, 0.4 },
	{ 0.08042, 0.53607, 0.06912, 36, 60, 24, 0.4 },
	{ 0.08042, 0.53607, 0.06353, 36, 60, 48, 0.4 },
	{ 0.08042, 0.53607, 0.05874, 36, 60, 72, 0.4 },
	{ 0.08042, 0.53607, 0.05751, 36, 60, 96, 0.4 },
	{ 0.08042, 0.53607, 0.06081, 36, 60, 120, 0.4 },
	{ 0.08042, 0.53607, 0.06712, 36, 60, 144, 0.4 },
	{ 0.08042, 0.53607, 0.07233, 36, 60, 168, 0.4 },
	{ 0.08042, 0.53607, 0.07312, 36, 60, 180, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 0, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 24, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 48, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 72, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 96, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 120, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 144, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 168, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 180, 0.4 },
	{ 0.08042, 0.62344, 0.04246, 48, 12, 0, 0.4 },
	{ 0.08042, 0.62344, 0.04208, 48, 12, 24, 0.4 },
	{ 0.08042, 0.62344, 0.04108, 48, 12, 48, 0.4 },
	{ 0.08042, 0.62344, 0.03984, 48, 12, 72, 0.4 },
	{ 0.08042, 0.62344, 0.03871, 48, 12, 96, 0.4 },
	{ 0.08042, 0.62344, 0.0379, 48, 12, 120, 0.4 },
	{ 0.08042, 0.62344, 0.03745, 48, 12, 144, 0.4 },
	{ 0.08042, 0.62344, 0.03727, 48, 12, 168, 0.4 },
	{ 0.08042, 0.62344, 0.03725, 48, 12, 180, 0.4 },
	{ 0.08042, 0.614, 0.04926, 48, 24, 0, 0.4 },
	{ 0.08042, 0.614, 0.04823, 48, 24, 24, 0.4 },
	{ 0.08042, 0.614, 0.04561, 48, 24, 48, 0.4 },
	{ 0.08042, 0.614, 0.04273, 48, 24, 72, 0.4 },
	{ 0.08042, 0.614, 0.04064, 48, 24, 96, 0.4 },
	{ 0.08042, 0.614, 0.03971, 48, 24, 120, 0.4 },
	{ 0.08042, 0.614, 0.03969, 48, 24, 144, 0.4 },
	{ 0.08042, 0.614, 0.03996, 48, 24, 168, 0.4 },
	{ 0.08042, 0.614, 0.04001, 48, 24, 180, 0.4 },
	{ 0.08042, 0.59584, 0.05905, 48, 36, 0, 0.4 },
	{ 0.08042, 0.59584, 0.05668, 48, 36, 24, 0.4 },
	{ 0.08042, 0.59584, 0.05212, 48, 36, 48, 0.4 },
	{ 0.08042, 0.59584, 0.04751, 48, 36, 72, 0.4 },
	{ 0.08042, 0.59584, 0.04495, 48, 36, 96, 0.4 },
	{ 0.08042, 0.59584, 0.04496, 48, 36, 120, 0.4 },
	{ 0.08042, 0.59584, 0.04676, 48, 36, 144, 0.4 },
	{ 0.08042, 0.59584, 0.04851, 48, 36, 168, 0.4 },
	{ 0.08042, 0.59584, 0.04877, 48, 36, 180, 0.4 },
	{ 0.08042, 0.56394, 0.07652, 48, 48, 0, 0.4 },
	{ 0.08042, 0.56394, 0.06843, 48, 48, 24, 0.4 },
	{ 0.08042, 0.56394, 0.06165, 48, 48, 48, 0.4 },
	{ 0.08042, 0.56394, 0.05553, 48, 48, 72, 0.4 },
	{ 0.08042, 0.56394, 0.0534, 48, 48, 96, 0.4 },
	{ 0.08042, 0.56394, 0.05617, 48, 48, 120, 0.4 },
	{ 0.08042, 0.56394, 0.06234, 48, 48, 144, 0.4 },
	{ 0.08042, 0.56394, 0.06762, 48, 48, 168, 0.4 },
	{ 0.08042, 0.56394, 0.06842, 48, 48, 180, 0.4 },
	{ 0.08042, 0.50737, 0.09121, 48, 60, 0, 0.4 },
	{ 0.08042, 0.50737, 0.08642, 48, 60, 24, 0.4 },
	{ 0.08042, 0.50737, 0.07715, 48, 60, 48, 0.4 },
	{ 0.08042, 0.50737, 0.07001, 48, 60, 72, 0.4 },
	{ 0.08042, 0.50737, 0.06989, 48, 60, 96, 0.4 },
	{ 0.08042, 0.50737, 0.07896, 48, 60, 120, 0.4 },
	{ 0.08042, 0.50737, 0.09491, 48, 60, 144, 0.4 },
	{ 0.08042, 0.50737, 0.10855, 48, 60, 168, 0.4 },
	{ 0.08042, 0.50737, 0.11065, 48, 60, 180, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 0, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 24, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 48, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 72, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 96, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 120, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 144, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 168, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 180, 0.4 },
	{ 0.08042, 0.5609, 0.05046, 60, 12, 0, 0.4 },
	{ 0.08042, 0.5609, 0.05011, 60, 12, 24, 0.4 },
	{ 0.08042, 0.5609, 0.04925, 60, 12, 48, 0.4 },
	{ 0.08042, 0.5609, 0.04827, 60, 12, 72, 0.4 },
	{ 0.08042, 0.5609, 0.0476, 60, 12, 96, 0.4 },
	{ 0.08042, 0.5609, 0.04739, 60, 12, 120, 0.4 },
	{ 0.08042, 0.5609, 0.04753, 60, 12, 144, 0.4 },
	{ 0.08042, 0.5609, 0.04773, 60, 12, 168, 0.4 },
	{ 0.08042, 0.5609, 0.04776, 60, 12, 180, 0.4 },
	{ 0.08042, 0.55241, 0.05861, 60, 24, 0, 0.4 },
	{ 0.08042, 0.55241, 0.05744, 60, 24, 24, 0.4 },
	{ 0.08042, 0.55241, 0.05472, 60, 24, 48, 0.4 },
	{ 0.08042, 0.55241, 0.05207, 60, 24, 72, 0.4 },
	{ 0.08042, 0.55241, 0.05085, 60, 24, 96, 0.4 },
	{ 0.08042, 0.55241, 0.0515, 60, 24, 120, 0.4 },
	{ 0.08042, 0.55241, 0.05338, 60, 24, 144, 0.4 },
	{ 0.08042, 0.55241, 0.05497, 60, 24, 168, 0.4 },
	{ 0.08042, 0.55241, 0.05521, 60, 24, 180, 0.4 },
	{ 0.08042, 0.53607, 0.07159, 60, 36, 0, 0.4 },
	{ 0.08042, 0.53607, 0.06914, 60, 36, 24, 0.4 },
	{ 0.08042, 0.53607, 0.06354, 60, 36, 48, 0.4 },
	{ 0.08042, 0.53607, 0.05875, 60, 36, 72, 0.4 },
	{ 0.08042, 0.53607, 0.05752, 60, 36, 96, 0.4 },
	{ 0.08042, 0.53607, 0.06081, 60, 36, 120, 0.4 },
	{ 0.08042, 0.53607, 0.06712, 60, 36, 144, 0.4 },
	{ 0.08042, 0.53607, 0.07234, 60, 36, 168, 0.4 },
	{ 0.08042, 0.53607, 0.07312, 60, 36, 180, 0.4 },
	{ 0.08042, 0.50737, 0.09123, 60, 48, 0, 0.4 },
	{ 0.08042, 0.50737, 0.08643, 60, 48, 24, 0.4 },
	{ 0.08042, 0.50737, 0.07716, 60, 48, 48, 0.4 },
	{ 0.08042, 0.50737, 0.07002, 60, 48, 72, 0.4 },
	{ 0.08042, 0.50737, 0.0699, 60, 48, 96, 0.4 },
	{ 0.08042, 0.50737, 0.07896, 60, 48, 120, 0.4 },
	{ 0.08042, 0.50737, 0.09491, 60, 48, 144, 0.4 },
	{ 0.08042, 0.50737, 0.10855, 60, 48, 168, 0.4 },
	{ 0.08042, 0.50737, 0.11065, 60, 48, 180, 0.4 },
	{ 0.08042, 0.45648, 0.12753, 60, 60, 0, 0.4 },
	{ 0.08042, 0.45648, 0.11332, 60, 60, 24, 0.4 },
	{ 0.08042, 0.45648, 0.09948, 60, 60, 48, 0.4 },
	{ 0.08042, 0.45648, 0.08994, 60, 60, 72, 0.4 },
	{ 0.08042, 0.45648, 0.09305, 60, 60, 96, 0.4 },
	{ 0.08042, 0.45648, 0.11396, 60, 60, 120, 0.4 },
	{ 0.08042, 0.45648, 0.15078, 60, 60, 144, 0.4 },
	{ 0.08042, 0.45648, 0.18469, 60, 60, 168, 0.4 },
	{ 0.08042, 0.45648, 0.19015, 60, 60, 180, 0.4 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 0, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 24, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 48, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 72, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 96, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 120, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 144, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 168, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 180, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 0, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 24, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 48, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 72, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 96, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 120, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 144, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 168, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 180, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 0, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 24, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 48, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 72, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 96, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 120, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 144, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 168, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 180, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 0, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 24, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 48, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 72, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 96, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 120, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 144, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 168, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 180, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 0, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 24, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 48, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 72, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 96, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 120, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 144, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 168, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 180, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 0, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 24, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 48, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 72, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 96, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 120, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 144, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 168, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 180, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 0, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 24, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 48, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 72, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 96, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 120, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 144, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 168, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 180, 0.6 },
	{ 0.0896, 0.5827, 0.04472, 12, 12, 0, 0.6 },
	{ 0.0896, 0.5827, 0.04347, 12, 12, 24, 0.6 },
	{ 0.0896, 0.5827, 0.04143, 12, 12, 48, 0.6 },
	{ 0.0896, 0.5827, 0.0401, 12, 12, 72, 0.6 },
	{ 0.0896, 0.5827, 0.03937, 12, 12, 96, 0.6 },
	{ 0.0896, 0.5827, 0.03885, 12, 12, 120, 0.6 },
	{ 0.0896, 0.5827, 0.03846, 12, 12, 144, 0.6 },
	{ 0.0896, 0.5827, 0.03825, 12, 12, 168, 0.6 },
	{ 0.0896, 0.5827, 0.03823, 12, 12, 180, 0.6 },
	{ 0.0896, 0.56996, 0.0433, 12, 24, 0, 0.6 },
	{ 0.0896, 0.56996, 0.04276, 12, 24, 24, 0.6 },
	{ 0.0896, 0.56996, 0.04187, 12, 24, 48, 0.6 },
	{ 0.0896, 0.56996, 0.0409, 12, 24, 72, 0.6 },
	{ 0.0896, 0.56996, 0.03983, 12, 24, 96, 0.6 },
	{ 0.0896, 0.56996, 0.03889, 12, 24, 120, 0.6 },
	{ 0.0896, 0.56996, 0.03822, 12, 24, 144, 0.6 },
	{ 0.0896, 0.56996, 0.03787, 12, 24, 168, 0.6 },
	{ 0.0896, 0.56996, 0.03783, 12, 24, 180, 0.6 },
	{ 0.0896, 0.54581, 0.04548, 12, 36, 0, 0.6 },
	{ 0.0896, 0.54581, 0.04512, 12, 36, 24, 0.6 },
	{ 0.0896, 0.54581, 0.04412, 12, 36, 48, 0.6 },
	{ 0.0896, 0.54581, 0.04279, 12, 36, 72, 0.6 },
	{ 0.0896, 0.54581, 0.0415, 12, 36, 96, 0.6 },
	{ 0.0896, 0.54581, 0.0405, 12, 36, 120, 0.6 },
	{ 0.0896, 0.54581, 0.03986, 12, 36, 144, 0.6 },
	{ 0.0896, 0.54581, 0.03955, 12, 36, 168, 0.6 },
	{ 0.0896, 0.54581, 0.03952, 12, 36, 180, 0.6 },
	{ 0.0896, 0.50461, 0.04985, 12, 48, 0, 0.6 },
	{ 0.0896, 0.50461, 0.04945, 12, 48, 24, 0.6 },
	{ 0.0896, 0.50461, 0.04842, 12, 48, 48, 0.6 },
	{ 0.0896, 0.50461, 0.04719, 12, 48, 72, 0.6 },
	{ 0.0896, 0.50461, 0.04613, 12, 48, 96, 0.6 },
	{ 0.0896, 0.50461, 0.04545, 12, 48, 120, 0.6 },
	{ 0.0896, 0.50461, 0.04513, 12, 48, 144, 0.6 },
	{ 0.0896, 0.50461, 0.04503, 12, 48, 168, 0.6 },
	{ 0.0896, 0.50461, 0.04502, 12, 48, 180, 0.6 },
	{ 0.0896, 0.43542, 0.05866, 12, 60, 0, 0.6 },
	{ 0.0896, 0.43542, 0.05833, 12, 60, 24, 0.6 },
	{ 0.0896, 0.43542, 0.05756, 12, 60, 48, 0.6 },
	{ 0.0896, 0.43542, 0.05677, 12, 60, 72, 0.6 },
	{ 0.0896, 0.43542, 0.05638, 12, 60, 96, 0.6 },
	{ 0.0896, 0.43542, 0.05652, 12, 60, 120, 0.6 },
	{ 0.0896, 0.43542, 0.05698, 12, 60, 144, 0.6 },
	{ 0.0896, 0.43542, 0.05739, 12, 60, 168, 0.6 },
	{ 0.0896, 0.43542, 0.05744, 12, 60, 180, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 0, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 24, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 48, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 72, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 96, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 120, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 144, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 168, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 180, 0.6 },
	{ 0.0896, 0.56996, 0.0433, 24, 12, 0, 0.6 },
	{ 0.0896, 0.56996, 0.04276, 24, 12, 24, 0.6 },
	{ 0.0896, 0.56996, 0.04187, 24, 12, 48, 0.6 },
	{ 0.0896, 0.56996, 0.0409, 24, 12, 72, 0.6 },
	{ 0.0896, 0.56996, 0.03983, 24, 12, 96, 0.6 },
	{ 0.0896, 0.56996, 0.03889, 24, 12, 120, 0.6 },
	{ 0.0896, 0.56996, 0.03822, 24, 12, 144, 0.6 },
	{ 0.0896, 0.56996, 0.03788, 24, 12, 168, 0.6 },
	{ 0.0896, 0.56996, 0.03783, 24, 12, 180, 0.6 },
	{ 0.0896, 0.5575, 0.05074, 24, 24, 0, 0.6 },
	{ 0.0896, 0.5575, 0.04708, 24, 24, 24, 0.6 },
	{ 0.0896, 0.5575, 0.04449, 24, 24, 48, 0.6 },
	{ 0.0896, 0.5575, 0.04252, 24, 24, 72, 0.6 },
	{ 0.0896, 0.5575, 0.04054, 24, 24, 96, 0.6 },
	{ 0.0896, 0.5575, 0.03907, 24, 24, 120, 0.6 },
	{ 0.0896, 0.5575, 0.03818, 24, 24, 144, 0.6 },
	{ 0.0896, 0.5575, 0.03778, 24, 24, 168, 0.6 },
	{ 0.0896, 0.5575, 0.03774, 24, 24, 180, 0.6 },
	{ 0.0896, 0.53388, 0.05163, 24, 36, 0, 0.6 },
	{ 0.0896, 0.53388, 0.05026, 24, 36, 24, 0.6 },
	{ 0.0896, 0.53388, 0.04803, 24, 36, 48, 0.6 },
	{ 0.0896, 0.53388, 0.04522, 24, 36, 72, 0.6 },
	{ 0.0896, 0.53388, 0.04294, 24, 36, 96, 0.6 },
	{ 0.0896, 0.53388, 0.04157, 24, 36, 120, 0.6 },
	{ 0.0896, 0.53388, 0.04099, 24, 36, 144, 0.6 },
	{ 0.0896, 0.53388, 0.04085, 24, 36, 168, 0.6 },
	{ 0.0896, 0.53388, 0.04084, 24, 36, 180, 0.6 },
	{ 0.0896, 0.49358, 0.05734, 24, 48, 0, 0.6 },
	{ 0.0896, 0.49358, 0.05622, 24, 48, 24, 0.6 },
	{ 0.0896, 0.49358, 0.05344, 24, 48, 48, 0.6 },
	{ 0.0896, 0.49358, 0.05051, 24, 48, 72, 0.6 },
	{ 0.0896, 0.49358, 0.04862, 24, 48, 96, 0.6 },
	{ 0.0896, 0.49358, 0.0481, 24, 48, 120, 0.6 },
	{ 0.0896, 0.49358, 0.04854, 24, 48, 144, 0.6 },
	{ 0.0896, 0.49358, 0.04912, 24, 48, 168, 0.6 },
	{ 0.0896, 0.49358, 0.04922, 24, 48, 180, 0.6 },
	{ 0.0896, 0.4259, 0.06729, 24, 60, 0, 0.6 },
	{ 0.0896, 0.4259, 0.06609, 24, 60, 24, 0.6 },
	{ 0.0896, 0.4259, 0.06339, 24, 60, 48, 0.6 },
	{ 0.0896, 0.4259, 0.06103, 24, 60, 72, 0.6 },
	{ 0.0896, 0.4259, 0.06043, 24, 60, 96, 0.6 },
	{ 0.0896, 0.4259, 0.06201, 24, 60, 120, 0.6 },
	{ 0.0896, 0.4259, 0.06486, 24, 60, 144, 0.6 },
	{ 0.0896, 0.4259, 0.0671, 24, 60, 168, 0.6 },
	{ 0.0896, 0.4259, 0.06743, 24, 60, 180, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 0, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 24, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 48, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 72, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 96, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 120, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 144, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 168, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 180, 0.6 },
	{ 0.0896, 0.54581, 0.0455, 36, 12, 0, 0.6 },
	{ 0.0896, 0.54581, 0.04513, 36, 12, 24, 0.6 },
	{ 0.0896, 0.54581, 0.04413, 36, 12, 48, 0.6 },
	{ 0.0896, 0.54581, 0.0428, 36, 12, 72, 0.6 },
	{ 0.0896, 0.54581, 0.04151, 36, 12, 96, 0.6 },
	{ 0.0896, 0.54581, 0.0405, 36, 12, 120, 0.6 },
	{ 0.0896, 0.54581, 0.03985, 36, 12, 144, 0.6 },
	{ 0.0896, 0.54581, 0.03955, 36, 12, 168, 0.6 },
	{ 0.0896, 0.54581, 0.03951, 36, 12, 180, 0.6 },
	{ 0.0896, 0.53388, 0.05164, 36, 24, 0, 0.6 },
	{ 0.0896, 0.53388, 0.05027, 36, 24, 24, 0.6 },
	{ 0.0896, 0.53388, 0.04803, 36, 24, 48, 0.6 },
	{ 0.0896, 0.53388, 0.04523, 36, 24, 72, 0.6 },
	{ 0.0896, 0.53388, 0.04294, 36, 24, 96, 0.6 },
	{ 0.0896, 0.53388, 0.04157, 36, 24, 120, 0.6 },
	{ 0.0896, 0.53388, 0.04099, 36, 24, 144, 0.6 },
	{ 0.0896, 0.53388, 0.04084, 36, 24, 168, 0.6 },
	{ 0.0896, 0.53388, 0.04083, 36, 24, 180, 0.6 },
	{ 0.0896, 0.51125, 0.06324, 36, 36, 0, 0.6 },
	{ 0.0896, 0.51125, 0.05704, 36, 36, 24, 0.6 },
	{ 0.0896, 0.51125, 0.05324, 36, 36, 48, 0.6 },
	{ 0.0896, 0.51125, 0.04919, 36, 36, 72, 0.6 },
	{ 0.0896, 0.51125, 0.04656, 36, 36, 96, 0.6 },
	{ 0.0896, 0.51125, 0.04569, 36, 36, 120, 0.6 },
	{ 0.0896, 0.51125, 0.04608, 36, 36, 144, 0.6 },
	{ 0.0896, 0.51125, 0.04671, 36, 36, 168, 0.6 },
	{ 0.0896, 0.51125, 0.04682, 36, 36, 180, 0.6 },
	{ 0.0896, 0.47266, 0.06829, 36, 48, 0, 0.6 },
	{ 0.0896, 0.47266, 0.06561, 36, 48, 24, 0.6 },
	{ 0.0896, 0.47266, 0.06074, 36, 48, 48, 0.6 },
	{ 0.0896, 0.47266, 0.05608, 36, 48, 72, 0.6 },
	{ 0.0896, 0.47266, 0.05401, 36, 48, 96, 0.6 },
	{ 0.0896, 0.47266, 0.05497, 36, 48, 120, 0.6 },
	{ 0.0896, 0.47266, 0.05787, 36, 48, 144, 0.6 },
	{ 0.0896, 0.47266, 0.06039, 36, 48, 168, 0.6 },
	{ 0.0896, 0.47266, 0.06077, 36, 48, 180, 0.6 },
	{ 0.0896, 0.40785, 0.08141, 36, 60, 0, 0.6 },
	{ 0.0896, 0.40785, 0.07881, 36, 60, 24, 0.6 },
	{ 0.0896, 0.40785, 0.07306, 36, 60, 48, 0.6 },
	{ 0.0896, 0.40785, 0.06865, 36, 60, 72, 0.6 },
	{ 0.0896, 0.40785, 0.06855, 36, 60, 96, 0.6 },
	{ 0.0896, 0.40785, 0.07372, 36, 60, 120, 0.6 },
	{ 0.0896, 0.40785, 0.08222, 36, 60, 144, 0.6 },
	{ 0.0896, 0.40785, 0.08901, 36, 60, 168, 0.6 },
	{ 0.0896, 0.40785, 0.09002, 36, 60, 180, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 0, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 24, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 48, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 72, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 96, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 120, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 144, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 168, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 180, 0.6 },
	{ 0.0896, 0.50461, 0.04986, 48, 12, 0, 0.6 },
	{ 0.0896, 0.50461, 0.04946, 48, 12, 24, 0.6 },
	{ 0.0896, 0.50461, 0.04843, 48, 12, 48, 0.6 },
	{ 0.0896, 0.50461, 0.0472, 48, 12, 72, 0.6 },
	{ 0.0896, 0.50461, 0.04614, 48, 12, 96, 0.6 },
	{ 0.0896, 0.50461, 0.04545, 48, 12, 120, 0.6 },
	{ 0.0896, 0.50461, 0.04513, 48, 12, 144, 0.6 },
	{ 0.0896, 0.50461, 0.04503, 48, 12, 168, 0.6 },
	{ 0.0896, 0.50461, 0.04502, 48, 12, 180, 0.6 },
	{ 0.0896, 0.49358, 0.05735, 48, 24, 0, 0.6 },
	{ 0.0896, 0.49358, 0.05623, 48, 24, 24, 0.6 },
	{ 0.0896, 0.49358, 0.05345, 48, 24, 48, 0.6 },
	{ 0.0896, 0.49358, 0.05052, 48, 24, 72, 0.6 },
	{ 0.0896, 0.49358, 0.04863, 48, 24, 96, 0.6 },
	{ 0.0896, 0.49358, 0.0481, 48, 24, 120, 0.6 },
	{ 0.0896, 0.49358, 0.04855, 48, 24, 144, 0.6 },
	{ 0.0896, 0.49358, 0.04913, 48, 24, 168, 0.6 },
	{ 0.0896, 0.49358, 0.04922, 48, 24, 180, 0.6 },
	{ 0.0896, 0.47266, 0.06829, 48, 36, 0, 0.6 },
	{ 0.0896, 0.47266, 0.06562, 48, 36, 24, 0.6 },
	{ 0.0896, 0.47266, 0.06074, 48, 36, 48, 0.6 },
	{ 0.0896, 0.47266, 0.05608, 48, 36, 72, 0.6 },
	{ 0.0896, 0.47266, 0.05401, 48, 36, 96, 0.6 },
	{ 0.0896, 0.47266, 0.05497, 48, 36, 120, 0.6 },
	{ 0.0896, 0.47266, 0.05787, 48, 36, 144, 0.6 },
	{ 0.0896, 0.47266, 0.06039, 48, 36, 168, 0.6 },
	{ 0.0896, 0.47266, 0.06077, 48, 36, 180, 0.6 },
	{ 0.0896, 0.43698, 0.08809, 48, 48, 0, 0.6 },
	{ 0.0896, 0.43698, 0.07851, 48, 48, 24, 0.6 },
	{ 0.0896, 0.43698, 0.07132, 48, 48, 48, 0.6 },
	{ 0.0896, 0.43698, 0.06533, 48, 48, 72, 0.6 },
	{ 0.0896, 0.43698, 0.06424, 48, 48, 96, 0.6 },
	{ 0.0896, 0.43698, 0.06889, 48, 48, 120, 0.6 },
	{ 0.0896, 0.43698, 0.07737, 48, 48, 144, 0.6 },
	{ 0.0896, 0.43698, 0.08435, 48, 48, 168, 0.6 },
	{ 0.0896, 0.43698, 0.0854, 48, 48, 180, 0.6 },
	{ 0.0896, 0.37706, 0.10272, 48, 60, 0, 0.6 },
	{ 0.0896, 0.37706, 0.09753, 48, 60, 24, 0.6 },
	{ 0.0896, 0.37706, 0.08794, 48, 60, 48, 0.6 },
	{ 0.0896, 0.37706, 0.08139, 48, 60, 72, 0.6 },
	{ 0.0896, 0.37706, 0.08321, 48, 60, 96, 0.6 },
	{ 0.0896, 0.37706, 0.09573, 48, 60, 120, 0.6 },
	{ 0.0896, 0.37706, 0.11613, 48, 60, 144, 0.6 },
	{ 0.0896, 0.37706, 0.13325, 48, 60, 168, 0.6 },
	{ 0.0896, 0.37706, 0.13588, 48, 60, 180, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 0, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 24, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 48, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 72, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 96, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 120, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 144, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 168, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 180, 0.6 },
	{ 0.0896, 0.43542, 0.05869, 60, 12, 0, 0.6 },
	{ 0.0896, 0.43542, 0.05836, 60, 12, 24, 0.6 },
	{ 0.0896, 0.43542, 0.05758, 60, 12, 48, 0.6 },
	{ 0.0896, 0.43542, 0.05679, 60, 12, 72, 0.6 },
	{ 0.0896, 0.43542, 0.05639, 60, 12, 96, 0.6 },
	{ 0.0896, 0.43542, 0.05653, 60, 12, 120, 0.6 },
	{ 0.0896, 0.43542, 0.057, 60, 12, 144, 0.6 },
	{ 0.0896, 0.43542, 0.0574, 60, 12, 168, 0.6 },
	{ 0.0896, 0.43542, 0.05746, 60, 12, 180, 0.6 },
	{ 0.0896, 0.4259, 0.06733, 60, 24, 0, 0.6 },
	{ 0.0896, 0.4259, 0.06612, 60, 24, 24, 0.6 },
	{ 0.0896, 0.4259, 0.06342, 60, 24, 48, 0.6 },
	{ 0.0896, 0.4259, 0.06105, 60, 24, 72, 0.6 },
	{ 0.0896, 0.4259, 0.06045, 60, 24, 96, 0.6 },
	{ 0.0896, 0.4259, 0.06202, 60, 24, 120, 0.6 },
	{ 0.0896, 0.4259, 0.06487, 60, 24, 144, 0.6 },
	{ 0.0896, 0.4259, 0.06711, 60, 24, 168, 0.6 },
	{ 0.0896, 0.4259, 0.06744, 60, 24, 180, 0.6 },
	{ 0.0896, 0.40785, 0.08144, 60, 36, 0, 0.6 },
	{ 0.0896, 0.40785, 0.07884, 60, 36, 24, 0.6 },
	{ 0.0896, 0.40785, 0.07309, 60, 36, 48, 0.6 },
	{ 0.0896, 0.40785, 0.06867, 60, 36, 72, 0.6 },
	{ 0.0896, 0.40785, 0.06857, 60, 36, 96, 0.6 },
	{ 0.0896, 0.40785, 0.07373, 60, 36, 120, 0.6 },
	{ 0.0896, 0.40785, 0.08223, 60, 36, 144, 0.6 },
	{ 0.0896, 0.40785, 0.08902, 60, 36, 168, 0.6 },
	{ 0.0896, 0.40785, 0.09003, 60, 36, 180, 0.6 },
	{ 0.0896, 0.37706, 0.10275, 60, 48, 0, 0.6 },
	{ 0.0896, 0.37706, 0.09755, 60, 48, 24, 0.6 },
	{ 0.0896, 0.37706, 0.08797, 60, 48, 48, 0.6 },
	{ 0.0896, 0.37706, 0.08141, 60, 48, 72, 0.6 },
	{ 0.0896, 0.37706, 0.08323, 60, 48, 96, 0.6 },
	{ 0.0896, 0.37706, 0.09574, 60, 48, 120, 0.6 },
	{ 0.0896, 0.37706, 0.11613, 60, 48, 144, 0.6 },
	{ 0.0896, 0.37706, 0.13326, 60, 48, 168, 0.6 },
	{ 0.0896, 0.37706, 0.13588, 60, 48, 180, 0.6 },
	{ 0.0896, 0.32536, 0.14178, 60, 60, 0, 0.6 },
	{ 0.0896, 0.32536, 0.12579, 60, 60, 24, 0.6 },
	{ 0.0896, 0.32536, 0.11167, 60, 60, 48, 0.6 },
	{ 0.0896, 0.32536, 0.10321, 60, 60, 72, 0.6 },
	{ 0.0896, 0.32536, 0.10952, 60, 60, 96, 0.6 },
	{ 0.0896, 0.32536, 0.13633, 60, 60, 120, 0.6 },
	{ 0.0896, 0.32536, 0.18156, 60, 60, 144, 0.6 },
	{ 0.0896, 0.32536, 0.22282, 60, 60, 168, 0.6 },
	{ 0.0896, 0.32536, 0.22946, 60, 60, 180, 0.6 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 0, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 24, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 48, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 72, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 96, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 120, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 144, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 168, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 180, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 0, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 24, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 48, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 72, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 96, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 120, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 144, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 168, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 180, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 0, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 24, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 48, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 72, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 96, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 120, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 144, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 168, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 180, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 0, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 24, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 48, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 72, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 96, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 120, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 144, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 168, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 180, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 0, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 24, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 48, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 72, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 96, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 120, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 144, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 168, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 180, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 0, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 24, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 48, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 72, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 96, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 120, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 144, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 168, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 180, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 0, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 24, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 48, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 72, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 96, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 120, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 144, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 168, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 180, 0.8 },
	{ 0.09629, 0.49046, 0.05115, 12, 12, 0, 0.8 },
	{ 0.09629, 0.49046, 0.0497, 12, 12, 24, 0.8 },
	{ 0.09629, 0.49046, 0.04736, 12, 12, 48, 0.8 },
	{ 0.09629, 0.49046, 0.04585, 12, 12, 72, 0.8 },
	{ 0.09629, 0.49046, 0.04505, 12, 12, 96, 0.8 },
	{ 0.09629, 0.49046, 0.0445, 12, 12, 120, 0.8 },
	{ 0.09629, 0.49046, 0.04409, 12, 12, 144, 0.8 },
	{ 0.09629, 0.49046, 0.04387, 12, 12, 168, 0.8 },
	{ 0.09629, 0.49046, 0.04384, 12, 12, 180, 0.8 },
	{ 0.09629, 0.47648, 0.04937, 12, 24, 0, 0.8 },
	{ 0.09629, 0.47648, 0.04877, 12, 24, 24, 0.8 },
	{ 0.09629, 0.47648, 0.04779, 12, 24, 48, 0.8 },
	{ 0.09629, 0.47648, 0.04676, 12, 24, 72, 0.8 },
	{ 0.09629, 0.47648, 0.04563, 12, 24, 96, 0.8 },
	{ 0.09629, 0.47648, 0.04463, 12, 24, 120, 0.8 },
	{ 0.09629, 0.47648, 0.04393, 12, 24, 144, 0.8 },
	{ 0.09629, 0.47648, 0.04358, 12, 24, 168, 0.8 },
	{ 0.09629, 0.47648, 0.04353, 12, 24, 180, 0.8 },
	{ 0.09629, 0.45039, 0.05176, 12, 36, 0, 0.8 },
	{ 0.09629, 0.45039, 0.05137, 12, 36, 24, 0.8 },
	{ 0.09629, 0.45039, 0.05031, 12, 36, 48, 0.8 },
	{ 0.09629, 0.45039, 0.04892, 12, 36, 72, 0.8 },
	{ 0.09629, 0.45039, 0.04758, 12, 36, 96, 0.8 },
	{ 0.09629, 0.45039, 0.04657, 12, 36, 120, 0.8 },
	{ 0.09629, 0.45039, 0.04594, 12, 36, 144, 0.8 },
	{ 0.09629, 0.45039, 0.04565, 12, 36, 168, 0.8 },
	{ 0.09629, 0.45039, 0.04561, 12, 36, 180, 0.8 },
	{ 0.09629, 0.40714, 0.05648, 12, 48, 0, 0.8 },
	{ 0.09629, 0.40714, 0.05607, 12, 48, 24, 0.8 },
	{ 0.09629, 0.40714, 0.05502, 12, 48, 48, 0.8 },
	{ 0.09629, 0.40714, 0.0538, 12, 48, 72, 0.8 },
	{ 0.09629, 0.40714, 0.05279, 12, 48, 96, 0.8 },
	{ 0.09629, 0.40714, 0.0522, 12, 48, 120, 0.8 },
	{ 0.09629, 0.40714, 0.05199, 12, 48, 144, 0.8 },
	{ 0.09629, 0.40714, 0.05195, 12, 48, 168, 0.8 },
	{ 0.09629, 0.40714, 0.05196, 12, 48, 180, 0.8 },
	{ 0.09629, 0.33826, 0.06567, 12, 60, 0, 0.8 },
	{ 0.09629, 0.33826, 0.06536, 12, 60, 24, 0.8 },
	{ 0.09629, 0.33826, 0.06465, 12, 60, 48, 0.8 },
	{ 0.09629, 0.33826, 0.06399, 12, 60, 72, 0.8 },
	{ 0.09629, 0.33826, 0.0638, 12, 60, 96, 0.8 },
	{ 0.09629, 0.33826, 0.06419, 12, 60, 120, 0.8 },
	{ 0.09629, 0.33826, 0.06489, 12, 60, 144, 0.8 },
	{ 0.09629, 0.33826, 0.06544, 12, 60, 168, 0.8 },
	{ 0.09629, 0.33826, 0.06551, 12, 60, 180, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 0, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 24, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 48, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 72, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 96, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 120, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 144, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 168, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 180, 0.8 },
	{ 0.09629, 0.47648, 0.04938, 24, 12, 0, 0.8 },
	{ 0.09629, 0.47648, 0.04878, 24, 12, 24, 0.8 },
	{ 0.09629, 0.47648, 0.0478, 24, 12, 48, 0.8 },
	{ 0.09629, 0.47648, 0.04676, 24, 12, 72, 0.8 },
	{ 0.09629, 0.47648, 0.04563, 24, 12, 96, 0.8 },
	{ 0.09629, 0.47648, 0.04463, 24, 12, 120, 0.8 },
	{ 0.09629, 0.47648, 0.04393, 24, 12, 144, 0.8 },
	{ 0.09629, 0.47648, 0.04358, 24, 12, 168, 0.8 },
	{ 0.09629, 0.47648, 0.04353, 24, 12, 180, 0.8 },
	{ 0.09629, 0.4629, 0.05776, 24, 24, 0, 0.8 },
	{ 0.09629, 0.4629, 0.05356, 24, 24, 24, 0.8 },
	{ 0.09629, 0.4629, 0.05069, 24, 24, 48, 0.8 },
	{ 0.09629, 0.4629, 0.04859, 24, 24, 72, 0.8 },
	{ 0.09629, 0.4629, 0.0465, 24, 24, 96, 0.8 },
	{ 0.09629, 0.4629, 0.04499, 24, 24, 120, 0.8 },
	{ 0.09629, 0.4629, 0.04411, 24, 24, 144, 0.8 },
	{ 0.09629, 0.4629, 0.04373, 24, 24, 168, 0.8 },
	{ 0.09629, 0.4629, 0.04369, 24, 24, 180, 0.8 },
	{ 0.09629, 0.43755, 0.05846, 24, 36, 0, 0.8 },
	{ 0.09629, 0.43755, 0.05695, 24, 36, 24, 0.8 },
	{ 0.09629, 0.43755, 0.05457, 24, 36, 48, 0.8 },
	{ 0.09629, 0.43755, 0.05163, 24, 36, 72, 0.8 },
	{ 0.09629, 0.43755, 0.04931, 24, 36, 96, 0.8 },
	{ 0.09629, 0.43755, 0.04803, 24, 36, 120, 0.8 },
	{ 0.09629, 0.43755, 0.04757, 24, 36, 144, 0.8 },
	{ 0.09629, 0.43755, 0.04753, 24, 36, 168, 0.8 },
	{ 0.09629, 0.43755, 0.04753, 24, 36, 180, 0.8 },
	{ 0.09629, 0.39553, 0.06449, 24, 48, 0, 0.8 },
	{ 0.09629, 0.39553, 0.06331, 24, 48, 24, 0.8 },
	{ 0.09629, 0.39553, 0.06041, 24, 48, 48, 0.8 },
	{ 0.09629, 0.39553, 0.05746, 24, 48, 72, 0.8 },
	{ 0.09629, 0.39553, 0.05572, 24, 48, 96, 0.8 },
	{ 0.09629, 0.39553, 0.05551, 24, 48, 120, 0.8 },
	{ 0.09629, 0.39553, 0.05631, 24, 48, 144, 0.8 },
	{ 0.09629, 0.39553, 0.05713, 24, 48, 168, 0.8 },
	{ 0.09629, 0.39553, 0.05725, 24, 48, 180, 0.8 },
	{ 0.09629, 0.32862, 0.07466, 24, 60, 0, 0.8 },
	{ 0.09629, 0.32862, 0.07344, 24, 60, 24, 0.8 },
	{ 0.09629, 0.32862, 0.07076, 24, 60, 48, 0.8 },
	{ 0.09629, 0.32862, 0.06859, 24, 60, 72, 0.8 },
	{ 0.09629, 0.32862, 0.06844, 24, 60, 96, 0.8 },
	{ 0.09629, 0.32862, 0.07067, 24, 60, 120, 0.8 },
	{ 0.09629, 0.32862, 0.07421, 24, 60, 144, 0.8 },
	{ 0.09629, 0.32862, 0.07691, 24, 60, 168, 0.8 },
	{ 0.09629, 0.32862, 0.0773, 24, 60, 180, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 0, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 24, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 48, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 72, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 96, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 120, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 144, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 168, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 180, 0.8 },
	{ 0.09629, 0.45039, 0.05178, 36, 12, 0, 0.8 },
	{ 0.09629, 0.45039, 0.05139, 36, 12, 24, 0.8 },
	{ 0.09629, 0.45039, 0.05033, 36, 12, 48, 0.8 },
	{ 0.09629, 0.45039, 0.04893, 36, 12, 72, 0.8 },
	{ 0.09629, 0.45039, 0.04759, 36, 12, 96, 0.8 },
	{ 0.09629, 0.45039, 0.04657, 36, 12, 120, 0.8 },
	{ 0.09629, 0.45039, 0.04594, 36, 12, 144, 0.8 },
	{ 0.09629, 0.45039, 0.04565, 36, 12, 168, 0.8 },
	{ 0.09629, 0.45039, 0.04561, 36, 12, 180, 0.8 },
	{ 0.09629, 0.43755, 0.05847, 36, 24, 0, 0.8 },
	{ 0.09629, 0.43755, 0.05696, 36, 24, 24, 0.8 },
	{ 0.09629, 0.43755, 0.05458, 36, 24, 48, 0.8 },
	{ 0.09629, 0.43755, 0.05164, 36, 24, 72, 0.8 },
	{ 0.09629, 0.43755, 0.04932, 36, 24, 96, 0.8 },
	{ 0.09629, 0.43755, 0.04803, 36, 24, 120, 0.8 },
	{ 0.09629, 0.43755, 0.04757, 36, 24, 144, 0.8 },
	{ 0.09629, 0.43755, 0.04752, 36, 24, 168, 0.8 },
	{ 0.09629, 0.43755, 0.04753, 36, 24, 180, 0.8 },
	{ 0.09629, 0.41359, 0.07128, 36, 36, 0, 0.8 },
	{ 0.09629, 0.41359, 0.0643, 36, 36, 24, 0.8 },
	{ 0.09629, 0.41359, 0.06026, 36, 36, 48, 0.8 },
	{ 0.09629, 0.41359, 0.05606, 36, 36, 72, 0.8 },
	{ 0.09629, 0.41359, 0.05352, 36, 36, 96, 0.8 },
	{ 0.09629, 0.41359, 0.05297, 36, 36, 120, 0.8 },
	{ 0.09629, 0.41359, 0.05374, 36, 36, 144, 0.8 },
	{ 0.09629, 0.41359, 0.05463, 36, 36, 168, 0.8 },
	{ 0.09629, 0.41359, 0.05478, 36, 36, 180, 0.8 },
	{ 0.09629, 0.37387, 0.07626, 36, 48, 0, 0.8 },
	{ 0.09629, 0.37387, 0.07339, 36, 48, 24, 0.8 },
	{ 0.09629, 0.37387, 0.06829, 36, 48, 48, 0.8 },
	{ 0.09629, 0.37387, 0.06361, 36, 48, 72, 0.8 },
	{ 0.09629, 0.37387, 0.06192, 36, 48, 96, 0.8 },
	{ 0.09629, 0.37387, 0.06359, 36, 48, 120, 0.8 },
	{ 0.09629, 0.37387, 0.06732, 36, 48, 144, 0.8 },
	{ 0.09629, 0.37387, 0.07041, 36, 48, 168, 0.8 },
	{ 0.09629, 0.37387, 0.07087, 36, 48, 180, 0.8 },
	{ 0.09629, 0.31062, 0.08957, 36, 60, 0, 0.8 },
	{ 0.09629, 0.31062, 0.08688, 36, 60, 24, 0.8 },
	{ 0.09629, 0.31062, 0.08104, 36, 60, 48, 0.8 },
	{ 0.09629, 0.31062, 0.07689, 36, 60, 72, 0.8 },
	{ 0.09629, 0.31062, 0.07759, 36, 60, 96, 0.8 },
	{ 0.09629, 0.31062, 0.08405, 36, 60, 120, 0.8 },
	{ 0.09629, 0.31062, 0.09407, 36, 60, 144, 0.8 },
	{ 0.09629, 0.31062, 0.10193, 36, 60, 168, 0.8 },
	{ 0.09629, 0.31062, 0.10309, 36, 60, 180, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 0, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 24, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 48, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 72, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 96, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 120, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 144, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 168, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 180, 0.8 },
	{ 0.09629, 0.40714, 0.0565, 48, 12, 0, 0.8 },
	{ 0.09629, 0.40714, 0.05609, 48, 12, 24, 0.8 },
	{ 0.09629, 0.40714, 0.05504, 48, 12, 48, 0.8 },
	{ 0.09629, 0.40714, 0.05381, 48, 12, 72, 0.8 },
	{ 0.09629, 0.40714, 0.0528, 48, 12, 96, 0.8 },
	{ 0.09629, 0.40714, 0.05221, 48, 12, 120, 0.8 },
	{ 0.09629, 0.40714, 0.05199, 48, 12, 144, 0.8 },
	{ 0.09629, 0.40714, 0.05196, 48, 12, 168, 0.8 },
	{ 0.09629, 0.40714, 0.05196, 48, 12, 180, 0.8 },
	{ 0.09629, 0.39553, 0.06451, 48, 24, 0, 0.8 },
	{ 0.09629, 0.39553, 0.06333, 48, 24, 24, 0.8 },
	{ 0.09629, 0.39553, 0.06043, 48, 24, 48, 0.8 },
	{ 0.09629, 0.39553, 0.05747, 48, 24, 72, 0.8 },
	{ 0.09629, 0.39553, 0.05574, 48, 24, 96, 0.8 },
	{ 0.09629, 0.39553, 0.05552, 48, 24, 120, 0.8 },
	{ 0.09629, 0.39553, 0.05632, 48, 24, 144, 0.8 },
	{ 0.09629, 0.39553, 0.05713, 48, 24, 168, 0.8 },
	{ 0.09629, 0.39553, 0.05726, 48, 24, 180, 0.8 },
	{ 0.09629, 0.37387, 0.07627, 48, 36, 0, 0.8 },
	{ 0.09629, 0.37387, 0.0734, 48, 36, 24, 0.8 },
	{ 0.09629, 0.37387, 0.0683, 48, 36, 48, 0.8 },
	{ 0.09629, 0.37387, 0.06362, 48, 36, 72, 0.8 },
	{ 0.09629, 0.37387, 0.06193, 48, 36, 96, 0.8 },
	{ 0.09629, 0.37387, 0.06359, 48, 36, 120, 0.8 },
	{ 0.09629, 0.37387, 0.06732, 48, 36, 144, 0.8 },
	{ 0.09629, 0.37387, 0.07041, 48, 36, 168, 0.8 },
	{ 0.09629, 0.37387, 0.07087, 48, 36, 180, 0.8 },
	{ 0.09629, 0.33797, 0.09754, 48, 48, 0, 0.8 },
	{ 0.09629, 0.33797, 0.08705, 48, 48, 24, 0.8 },
	{ 0.09629, 0.33797, 0.07957, 48, 48, 48, 0.8 },
	{ 0.09629, 0.33797, 0.0737, 48, 48, 72, 0.8 },
	{ 0.09629, 0.33797, 0.07336, 48, 48, 96, 0.8 },
	{ 0.09629, 0.33797, 0.07939, 48, 48, 120, 0.8 },
	{ 0.09629, 0.33797, 0.08951, 48, 48, 144, 0.8 },
	{ 0.09629, 0.33797, 0.09769, 48, 48, 168, 0.8 },
	{ 0.09629, 0.33797, 0.09893, 48, 48, 180, 0.8 },
	{ 0.09629, 0.28079, 0.11194, 48, 60, 0, 0.8 },
	{ 0.09629, 0.28079, 0.10651, 48, 60, 24, 0.8 },
	{ 0.09629, 0.28079, 0.09674, 48, 60, 48, 0.8 },
	{ 0.09629, 0.28079, 0.0906, 48, 60, 72, 0.8 },
	{ 0.09629, 0.28079, 0.09373, 48, 60, 96, 0.8 },
	{ 0.09629, 0.28079, 0.10855, 48, 60, 120, 0.8 },
	{ 0.09629, 0.28079, 0.13187, 48, 60, 144, 0.8 },
	{ 0.09629, 0.28079, 0.15125, 48, 60, 168, 0.8 },
	{ 0.09629, 0.28079, 0.15421, 48, 60, 180, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 0, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 24, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 48, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 72, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 96, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 120, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 144, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 168, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 180, 0.8 },
	{ 0.09629, 0.33826, 0.06572, 60, 12, 0, 0.8 },
	{ 0.09629, 0.33826, 0.06541, 60, 12, 24, 0.8 },
	{ 0.09629, 0.33826, 0.06469, 60, 12, 48, 0.8 },
	{ 0.09629, 0.33826, 0.06403, 60, 12, 72, 0.8 },
	{ 0.09629, 0.33826, 0.06383, 60, 12, 96, 0.8 },
	{ 0.09629, 0.33826, 0.06422, 60, 12, 120, 0.8 },
	{ 0.09629, 0.33826, 0.06492, 60, 12, 144, 0.8 },
	{ 0.09629, 0.33826, 0.06546, 60, 12, 168, 0.8 },
	{ 0.09629, 0.33826, 0.06554, 60, 12, 180, 0.8 },
	{ 0.09629, 0.32862, 0.07472, 60, 24, 0, 0.8 },
	{ 0.09629, 0.32862, 0.0735, 60, 24, 24, 0.8 },
	{ 0.09629, 0.32862, 0.07081, 60, 24, 48, 0.8 },
	{ 0.09629, 0.32862, 0.06863, 60, 24, 72, 0.8 },
	{ 0.09629, 0.32862, 0.06847, 60, 24, 96, 0.8 },
	{ 0.09629, 0.32862, 0.0707, 60, 24, 120, 0.8 },
	{ 0.09629, 0.32862, 0.07423, 60, 24, 144, 0.8 },
	{ 0.09629, 0.32862, 0.07693, 60, 24, 168, 0.8 },
	{ 0.09629, 0.32862, 0.07732, 60, 24, 180, 0.8 },
	{ 0.09629, 0.31062, 0.08962, 60, 36, 0, 0.8 },
	{ 0.09629, 0.31062, 0.08693, 60, 36, 24, 0.8 },
	{ 0.09629, 0.31062, 0.08109, 60, 36, 48, 0.8 },
	{ 0.09629, 0.31062, 0.07692, 60, 36, 72, 0.8 },
	{ 0.09629, 0.31062, 0.07761, 60, 36, 96, 0.8 },
	{ 0.09629, 0.31062, 0.08407, 60, 36, 120, 0.8 },
	{ 0.09629, 0.31062, 0.09408, 60, 36, 144, 0.8 },
	{ 0.09629, 0.31062, 0.10194, 60, 36, 168, 0.8 },
	{ 0.09629, 0.31062, 0.10311, 60, 36, 180, 0.8 },
	{ 0.09629, 0.28079, 0.11199, 60, 48, 0, 0.8 },
	{ 0.09629, 0.28079, 0.10656, 60, 48, 24, 0.8 },
	{ 0.09629, 0.28079, 0.09678, 60, 48, 48, 0.8 },
	{ 0.09629, 0.28079, 0.09063, 60, 48, 72, 0.8 },
	{ 0.09629, 0.28079, 0.09376, 60, 48, 96, 0.8 },
	{ 0.09629, 0.28079, 0.10857, 60, 48, 120, 0.8 },
	{ 0.09629, 0.28079, 0.13189, 60, 48, 144, 0.8 },
	{ 0.09629, 0.28079, 0.15126, 60, 48, 168, 0.8 },
	{ 0.09629, 0.28079, 0.15422, 60, 48, 180, 0.8 },
	{ 0.09629, 0.23329, 0.15234, 60, 60, 0, 0.8 },
	{ 0.09629, 0.23329, 0.13542, 60, 60, 24, 0.8 },
	{ 0.09629, 0.23329, 0.12115, 60, 60, 48, 0.8 },
	{ 0.09629, 0.23329, 0.11339, 60, 60, 72, 0.8 },
	{ 0.09629, 0.23329, 0.1217, 60, 60, 96, 0.8 },
	{ 0.09629, 0.23329, 0.15218, 60, 60, 120, 0.8 },
	{ 0.09629, 0.23329, 0.20249, 60, 60, 144, 0.8 },
	{ 0.09629, 0.23329, 0.24808, 60, 60, 168, 0.8 },
	{ 0.09629, 0.23329, 0.2554, 60, 60, 180, 0.8 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 0, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 24, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 48, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 72, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 96, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 120, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 144, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 168, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 180, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 0, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 24, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 48, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 72, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 96, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 120, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 144, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 168, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 180, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 0, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 24, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 48, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 72, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 96, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 120, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 144, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 168, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 180, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 0, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 24, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 48, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 72, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 96, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 120, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 144, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 168, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 180, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 0, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 24, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 48, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 72, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 96, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 120, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 144, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 168, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 180, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 0, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 24, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 48, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 72, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 96, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 120, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 144, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 168, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 180, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 0, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 24, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 48, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 72, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 96, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 120, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 144, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 168, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 180, 1 },
	{ 0.10114, 0.41127, 0.05669, 12, 12, 0, 1 },
	{ 0.10114, 0.41127, 0.05511, 12, 12, 24, 1 },
	{ 0.10114, 0.41127, 0.05254, 12, 12, 48, 1 },
	{ 0.10114, 0.41127, 0.05091, 12, 12, 72, 1 },
	{ 0.10114, 0.41127, 0.05007, 12, 12, 96, 1 },
	{ 0.10114, 0.41127, 0.04949, 12, 12, 120, 1 },
	{ 0.10114, 0.41127, 0.04907, 12, 12, 144, 1 },
	{ 0.10114, 0.41127, 0.04884, 12, 12, 168, 1 },
	{ 0.10114, 0.41127, 0.04881, 12, 12, 180, 1 },
	{ 0.10114, 0.39686, 0.05466, 12, 24, 0, 1 },
	{ 0.10114, 0.39686, 0.05402, 12, 24, 24, 1 },
	{ 0.10114, 0.39686, 0.05298, 12, 24, 48, 1 },
	{ 0.10114, 0.39686, 0.0519, 12, 24, 72, 1 },
	{ 0.10114, 0.39686, 0.05073, 12, 24, 96, 1 },
	{ 0.10114, 0.39686, 0.0497, 12, 24, 120, 1 },
	{ 0.10114, 0.39686, 0.04898, 12, 24, 144, 1 },
	{ 0.10114, 0.39686, 0.04862, 12, 24, 168, 1 },
	{ 0.10114, 0.39686, 0.04857, 12, 24, 180, 1 },
	{ 0.10114, 0.37039, 0.05719, 12, 36, 0, 1 },
	{ 0.10114, 0.37039, 0.05678, 12, 36, 24, 1 },
	{ 0.10114, 0.37039, 0.05568, 12, 36, 48, 1 },
	{ 0.10114, 0.37039, 0.05424, 12, 36, 72, 1 },
	{ 0.10114, 0.37039, 0.05288, 12, 36, 96, 1 },
	{ 0.10114, 0.37039, 0.05187, 12, 36, 120, 1 },
	{ 0.10114, 0.37039, 0.05125, 12, 36, 144, 1 },
	{ 0.10114, 0.37039, 0.05098, 12, 36, 168, 1 },
	{ 0.10114, 0.37039, 0.05094, 12, 36, 180, 1 },
	{ 0.10114, 0.32775, 0.06208, 12, 48, 0, 1 },
	{ 0.10114, 0.32775, 0.06167, 12, 48, 24, 1 },
	{ 0.10114, 0.32775, 0.06062, 12, 48, 48, 1 },
	{ 0.10114, 0.32775, 0.05941, 12, 48, 72, 1 },
	{ 0.10114, 0.32775, 0.05845, 12, 48, 96, 1 },
	{ 0.10114, 0.32775, 0.05794, 12, 48, 120, 1 },
	{ 0.10114, 0.32775, 0.05781, 12, 48, 144, 1 },
	{ 0.10114, 0.32775, 0.05783, 12, 48, 168, 1 },
	{ 0.10114, 0.32775, 0.05784, 12, 48, 180, 1 },
	{ 0.10114, 0.2632, 0.07132, 12, 60, 0, 1 },
	{ 0.10114, 0.2632, 0.07102, 12, 60, 24, 1 },
	{ 0.10114, 0.2632, 0.07036, 12, 60, 48, 1 },
	{ 0.10114, 0.2632, 0.06979, 12, 60, 72, 1 },
	{ 0.10114, 0.2632, 0.06976, 12, 60, 96, 1 },
	{ 0.10114, 0.2632, 0.07033, 12, 60, 120, 1 },
	{ 0.10114, 0.2632, 0.0712, 12, 60, 144, 1 },
	{ 0.10114, 0.2632, 0.07185, 12, 60, 168, 1 },
	{ 0.10114, 0.2632, 0.07194, 12, 60, 180, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 0, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 24, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 48, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 72, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 96, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 120, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 144, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 168, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 180, 1 },
	{ 0.10114, 0.39686, 0.05467, 24, 12, 0, 1 },
	{ 0.10114, 0.39686, 0.05402, 24, 12, 24, 1 },
	{ 0.10114, 0.39686, 0.05298, 24, 12, 48, 1 },
	{ 0.10114, 0.39686, 0.05191, 24, 12, 72, 1 },
	{ 0.10114, 0.39686, 0.05073, 24, 12, 96, 1 },
	{ 0.10114, 0.39686, 0.0497, 24, 12, 120, 1 },
	{ 0.10114, 0.39686, 0.04898, 24, 12, 144, 1 },
	{ 0.10114, 0.39686, 0.04862, 24, 12, 168, 1 },
	{ 0.10114, 0.39686, 0.04858, 24, 12, 180, 1 },
	{ 0.10114, 0.38296, 0.06371, 24, 24, 0, 1 },
	{ 0.10114, 0.38296, 0.05914, 24, 24, 24, 1 },
	{ 0.10114, 0.38296, 0.05608, 24, 24, 48, 1 },
	{ 0.10114, 0.38296, 0.05388, 24, 24, 72, 1 },
	{ 0.10114, 0.38296, 0.05173, 24, 24, 96, 1 },
	{ 0.10114, 0.38296, 0.0502, 24, 24, 120, 1 },
	{ 0.10114, 0.38296, 0.04933, 24, 24, 144, 1 },
	{ 0.10114, 0.38296, 0.04898, 24, 24, 168, 1 },
	{ 0.10114, 0.38296, 0.04894, 24, 24, 180, 1 },
	{ 0.10114, 0.35742, 0.06427, 24, 36, 0, 1 },
	{ 0.10114, 0.35742, 0.06266, 24, 36, 24, 1 },
	{ 0.10114, 0.35742, 0.06019, 24, 36, 48, 1 },
	{ 0.10114, 0.35742, 0.05716, 24, 36, 72, 1 },
	{ 0.10114, 0.35742, 0.05484, 24, 36, 96, 1 },
	{ 0.10114, 0.35742, 0.05363, 24, 36, 120, 1 },
	{ 0.10114, 0.35742, 0.05328, 24, 36, 144, 1 },
	{ 0.10114, 0.35742, 0.05332, 24, 36, 168, 1 },
	{ 0.10114, 0.35742, 0.05333, 24, 36, 180, 1 },
	{ 0.10114, 0.31627, 0.07044, 24, 48, 0, 1 },
	{ 0.10114, 0.31627, 0.06923, 24, 48, 24, 1 },
	{ 0.10114, 0.31627, 0.06625, 24, 48, 48, 1 },
	{ 0.10114, 0.31627, 0.06331, 24, 48, 72, 1 },
	{ 0.10114, 0.31627, 0.06171, 24, 48, 96, 1 },
	{ 0.10114, 0.31627, 0.06174, 24, 48, 120, 1 },
	{ 0.10114, 0.31627, 0.06282, 24, 48, 144, 1 },
	{ 0.10114, 0.31627, 0.06381, 24, 48, 168, 1 },
	{ 0.10114, 0.31627, 0.06397, 24, 48, 180, 1 },
	{ 0.10114, 0.25398, 0.08052, 24, 60, 0, 1 },
	{ 0.10114, 0.25398, 0.0793, 24, 60, 24, 1 },
	{ 0.10114, 0.25398, 0.07665, 24, 60, 48, 1 },
	{ 0.10114, 0.25398, 0.07463, 24, 60, 72, 1 },
	{ 0.10114, 0.25398, 0.07481, 24, 60, 96, 1 },
	{ 0.10114, 0.25398, 0.07751, 24, 60, 120, 1 },
	{ 0.10114, 0.25398, 0.08153, 24, 60, 144, 1 },
	{ 0.10114, 0.25398, 0.08456, 24, 60, 168, 1 },
	{ 0.10114, 0.25398, 0.08499, 24, 60, 180, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 0, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 24, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 48, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 72, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 96, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 120, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 144, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 168, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 180, 1 },
	{ 0.10114, 0.37039, 0.0572, 36, 12, 0, 1 },
	{ 0.10114, 0.37039, 0.0568, 36, 12, 24, 1 },
	{ 0.10114, 0.37039, 0.0557, 36, 12, 48, 1 },
	{ 0.10114, 0.37039, 0.05425, 36, 12, 72, 1 },
	{ 0.10114, 0.37039, 0.05289, 36, 12, 96, 1 },
	{ 0.10114, 0.37039, 0.05187, 36, 12, 120, 1 },
	{ 0.10114, 0.37039, 0.05125, 36, 12, 144, 1 },
	{ 0.10114, 0.37039, 0.05098, 36, 12, 168, 1 },
	{ 0.10114, 0.37039, 0.05094, 36, 12, 180, 1 },
	{ 0.10114, 0.35742, 0.06428, 36, 24, 0, 1 },
	{ 0.10114, 0.35742, 0.06267, 36, 24, 24, 1 },
	{ 0.10114, 0.35742, 0.0602, 36, 24, 48, 1 },
	{ 0.10114, 0.35742, 0.05717, 36, 24, 72, 1 },
	{ 0.10114, 0.35742, 0.05484, 36, 24, 96, 1 },
	{ 0.10114, 0.35742, 0.05363, 36, 24, 120, 1 },
	{ 0.10114, 0.35742, 0.05328, 36, 24, 144, 1 },
	{ 0.10114, 0.35742, 0.05331, 36, 24, 168, 1 },
	{ 0.10114, 0.35742, 0.05333, 36, 24, 180, 1 },
	{ 0.10114, 0.33358, 0.07789, 36, 36, 0, 1 },
	{ 0.10114, 0.33358, 0.07039, 36, 36, 24, 1 },
	{ 0.10114, 0.33358, 0.06619, 36, 36, 48, 1 },
	{ 0.10114, 0.33358, 0.06191, 36, 36, 72, 1 },
	{ 0.10114, 0.33358, 0.05947, 36, 36, 96, 1 },
	{ 0.10114, 0.33358, 0.05917, 36, 36, 120, 1 },
	{ 0.10114, 0.33358, 0.06024, 36, 36, 144, 1 },
	{ 0.10114, 0.33358, 0.06134, 36, 36, 168, 1 },
	{ 0.10114, 0.33358, 0.06151, 36, 36, 180, 1 },
	{ 0.10114, 0.29517, 0.08275, 36, 48, 0, 1 },
	{ 0.10114, 0.29517, 0.07975, 36, 48, 24, 1 },
	{ 0.10114, 0.29517, 0.07452, 36, 48, 48, 1 },
	{ 0.10114, 0.29517, 0.06986, 36, 48, 72, 1 },
	{ 0.10114, 0.29517, 0.06847, 36, 48, 96, 1 },
	{ 0.10114, 0.29517, 0.07068, 36, 48, 120, 1 },
	{ 0.10114, 0.29517, 0.07502, 36, 48, 144, 1 },
	{ 0.10114, 0.29517, 0.07854, 36, 48, 168, 1 },
	{ 0.10114, 0.29517, 0.07906, 36, 48, 180, 1 },
	{ 0.10114, 0.23704, 0.0959, 36, 60, 0, 1 },
	{ 0.10114, 0.23704, 0.09317, 36, 60, 24, 1 },
	{ 0.10114, 0.23704, 0.0873, 36, 60, 48, 1 },
	{ 0.10114, 0.23704, 0.08336, 36, 60, 72, 1 },
	{ 0.10114, 0.23704, 0.08463, 36, 60, 96, 1 },
	{ 0.10114, 0.23704, 0.092, 36, 60, 120, 1 },
	{ 0.10114, 0.23704, 0.10305, 36, 60, 144, 1 },
	{ 0.10114, 0.23704, 0.11164, 36, 60, 168, 1 },
	{ 0.10114, 0.23704, 0.11291, 36, 60, 180, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 0, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 24, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 48, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 72, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 96, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 120, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 144, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 168, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 180, 1 },
	{ 0.10114, 0.32775, 0.06211, 48, 12, 0, 1 },
	{ 0.10114, 0.32775, 0.06169, 48, 12, 24, 1 },
	{ 0.10114, 0.32775, 0.06064, 48, 12, 48, 1 },
	{ 0.10114, 0.32775, 0.05943, 48, 12, 72, 1 },
	{ 0.10114, 0.32775, 0.05847, 48, 12, 96, 1 },
	{ 0.10114, 0.32775, 0.05796, 48, 12, 120, 1 },
	{ 0.10114, 0.32775, 0.05782, 48, 12, 144, 1 },
	{ 0.10114, 0.32775, 0.05784, 48, 12, 168, 1 },
	{ 0.10114, 0.32775, 0.05785, 48, 12, 180, 1 },
	{ 0.10114, 0.31627, 0.07047, 48, 24, 0, 1 },
	{ 0.10114, 0.31627, 0.06925, 48, 24, 24, 1 },
	{ 0.10114, 0.31627, 0.06628, 48, 24, 48, 1 },
	{ 0.10114, 0.31627, 0.06333, 48, 24, 72, 1 },
	{ 0.10114, 0.31627, 0.06173, 48, 24, 96, 1 },
	{ 0.10114, 0.31627, 0.06176, 48, 24, 120, 1 },
	{ 0.10114, 0.31627, 0.06283, 48, 24, 144, 1 },
	{ 0.10114, 0.31627, 0.06382, 48, 24, 168, 1 },
	{ 0.10114, 0.31627, 0.06397, 48, 24, 180, 1 },
	{ 0.10114, 0.29517, 0.08277, 48, 36, 0, 1 },
	{ 0.10114, 0.29517, 0.07977, 48, 36, 24, 1 },
	{ 0.10114, 0.29517, 0.07454, 48, 36, 48, 1 },
	{ 0.10114, 0.29517, 0.06988, 48, 36, 72, 1 },
	{ 0.10114, 0.29517, 0.06848, 48, 36, 96, 1 },
	{ 0.10114, 0.29517, 0.07069, 48, 36, 120, 1 },
	{ 0.10114, 0.29517, 0.07503, 48, 36, 144, 1 },
	{ 0.10114, 0.29517, 0.07855, 48, 36, 168, 1 },
	{ 0.10114, 0.29517, 0.07907, 48, 36, 180, 1 },
	{ 0.10114, 0.26119, 0.10489, 48, 48, 0, 1 },
	{ 0.10114, 0.26119, 0.09383, 48, 48, 24, 1 },
	{ 0.10114, 0.26119, 0.0862, 48, 48, 48, 1 },
	{ 0.10114, 0.26119, 0.08045, 48, 48, 72, 1 },
	{ 0.10114, 0.26119, 0.08067, 48, 48, 96, 1 },
	{ 0.10114, 0.26119, 0.08769, 48, 48, 120, 1 },
	{ 0.10114, 0.26119, 0.09899, 48, 48, 144, 1 },
	{ 0.10114, 0.26119, 0.10801, 48, 48, 168, 1 },
	{ 0.10114, 0.26119, 0.10937, 48, 48, 180, 1 },
	{ 0.10114, 0.20975, 0.11884, 48, 60, 0, 1 },
	{ 0.10114, 0.20975, 0.11328, 48, 60, 24, 1 },
	{ 0.10114, 0.20975, 0.10344, 48, 60, 48, 1 },
	{ 0.10114, 0.20975, 0.09762, 48, 60, 72, 1 },
	{ 0.10114, 0.20975, 0.10167, 48, 60, 96, 1 },
	{ 0.10114, 0.20975, 0.11803, 48, 60, 120, 1 },
	{ 0.10114, 0.20975, 0.14325, 48, 60, 144, 1 },
	{ 0.10114, 0.20975, 0.16407, 48, 60, 168, 1 },
	{ 0.10114, 0.20975, 0.16725, 48, 60, 180, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 0, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 24, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 48, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 72, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 96, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 120, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 144, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 168, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 180, 1 },
	{ 0.10114, 0.2632, 0.07138, 60, 12, 0, 1 },
	{ 0.10114, 0.2632, 0.07108, 60, 12, 24, 1 },
	{ 0.10114, 0.2632, 0.07042, 60, 12, 48, 1 },
	{ 0.10114, 0.2632, 0.06985, 60, 12, 72, 1 },
	{ 0.10114, 0.2632, 0.06981, 60, 12, 96, 1 },
	{ 0.10114, 0.2632, 0.07038, 60, 12, 120, 1 },
	{ 0.10114, 0.2632, 0.07125, 60, 12, 144, 1 },
	{ 0.10114, 0.2632, 0.07189, 60, 12, 168, 1 },
	{ 0.10114, 0.2632, 0.07198, 60, 12, 180, 1 },
	{ 0.10114, 0.25398, 0.0806, 60, 24, 0, 1 },
	{ 0.10114, 0.25398, 0.07937, 60, 24, 24, 1 },
	{ 0.10114, 0.25398, 0.07672, 60, 24, 48, 1 },
	{ 0.10114, 0.25398, 0.07469, 60, 24, 72, 1 },
	{ 0.10114, 0.25398, 0.07486, 60, 24, 96, 1 },
	{ 0.10114, 0.25398, 0.07755, 60, 24, 120, 1 },
	{ 0.10114, 0.25398, 0.08156, 60, 24, 144, 1 },
	{ 0.10114, 0.25398, 0.08458, 60, 24, 168, 1 },
	{ 0.10114, 0.25398, 0.08502, 60, 24, 180, 1 },
	{ 0.10114, 0.23704, 0.09599, 60, 36, 0, 1 },
	{ 0.10114, 0.23704, 0.09325, 60, 36, 24, 1 },
	{ 0.10114, 0.23704, 0.08737, 60, 36, 48, 1 },
	{ 0.10114, 0.23704, 0.08342, 60, 36, 72, 1 },
	{ 0.10114, 0.23704, 0.08467, 60, 36, 96, 1 },
	{ 0.10114, 0.23704, 0.09204, 60, 36, 120, 1 },
	{ 0.10114, 0.23704, 0.10308, 60, 36, 144, 1 },
	{ 0.10114, 0.23704, 0.11167, 60, 36, 168, 1 },
	{ 0.10114, 0.23704, 0.11293, 60, 36, 180, 1 },
	{ 0.10114, 0.20975, 0.11891, 60, 48, 0, 1 },
	{ 0.10114, 0.20975, 0.11335, 60, 48, 24, 1 },
	{ 0.10114, 0.20975, 0.1035, 60, 48, 48, 1 },
	{ 0.10114, 0.20975, 0.09767, 60, 48, 72, 1 },
	{ 0.10114, 0.20975, 0.1017, 60, 48, 96, 1 },
	{ 0.10114, 0.20975, 0.11806, 60, 48, 120, 1 },
	{ 0.10114, 0.20975, 0.14327, 60, 48, 144, 1 },
	{ 0.10114, 0.20975, 0.1641, 60, 48, 168, 1 },
	{ 0.10114, 0.20975, 0.16727, 60, 48, 180, 1 },
	{ 0.10114, 0.16844, 0.1597, 60, 60, 0, 1 },
	{ 0.10114, 0.16844, 0.14229, 60, 60, 24, 1 },
	{ 0.10114, 0.16844, 0.128, 60, 60, 48, 1 },
	{ 0.10114, 0.16844, 0.12075, 60, 60, 72, 1 },
	{ 0.10114, 0.16844, 0.13036, 60, 60, 96, 1 },
	{ 0.10114, 0.16844, 0.1631, 60, 60, 120, 1 },
	{ 0.10114, 0.16844, 0.21647, 60, 60, 144, 1 },
	{ 0.10114, 0.16844, 0.26459, 60, 60, 168, 1 },
	{ 0.10114, 0.16844, 0.27231, 60, 60, 180, 1 }};
#pragma endregion 
#pragma region ұ
	float aodWinSearchTable[solZenCount * senZenCount *solAziCount *aod550Count][searchTabColCount] =
	{ { 0.04618, 0.95014, 0.01889, 0, 0, 0, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 24, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 48, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 72, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 96, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 120, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 144, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 168, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 180, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 0, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 24, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 48, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 72, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 96, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 120, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 144, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 168, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 180, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 0, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 24, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 48, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 72, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 96, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 120, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 144, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 168, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 180, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 0, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 24, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 48, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 72, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 96, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 120, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 144, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 168, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 180, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 0, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 24, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 48, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 72, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 96, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 120, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 144, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 168, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 180, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 0, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 24, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 48, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 72, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 96, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 120, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 144, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 168, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 180, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 0, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 24, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 48, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 72, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 96, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 120, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 144, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 168, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 180, 0.0001 },
	{ 0.04618, 0.94907, 0.01974, 12, 12, 0, 0.0001 },
	{ 0.04618, 0.94907, 0.01968, 12, 12, 24, 0.0001 },
	{ 0.04618, 0.94907, 0.01948, 12, 12, 48, 0.0001 },
	{ 0.04618, 0.94907, 0.01921, 12, 12, 72, 0.0001 },
	{ 0.04618, 0.94907, 0.0189, 12, 12, 96, 0.0001 },
	{ 0.04618, 0.94907, 0.0186, 12, 12, 120, 0.0001 },
	{ 0.04618, 0.94907, 0.01838, 12, 12, 144, 0.0001 },
	{ 0.04618, 0.94907, 0.01826, 12, 12, 168, 0.0001 },
	{ 0.04618, 0.94907, 0.01824, 12, 12, 180, 0.0001 },
	{ 0.04618, 0.94734, 0.02071, 12, 24, 0, 0.0001 },
	{ 0.04618, 0.94734, 0.02057, 12, 24, 24, 0.0001 },
	{ 0.04618, 0.94734, 0.02018, 12, 24, 48, 0.0001 },
	{ 0.04618, 0.94734, 0.01963, 12, 24, 72, 0.0001 },
	{ 0.04618, 0.94734, 0.01902, 12, 24, 96, 0.0001 },
	{ 0.04618, 0.94734, 0.01845, 12, 24, 120, 0.0001 },
	{ 0.04618, 0.94734, 0.01803, 12, 24, 144, 0.0001 },
	{ 0.04618, 0.94734, 0.0178, 12, 24, 168, 0.0001 },
	{ 0.04618, 0.94734, 0.01777, 12, 24, 180, 0.0001 },
	{ 0.04618, 0.94398, 0.02201, 12, 36, 0, 0.0001 },
	{ 0.04618, 0.94398, 0.0218, 12, 36, 24, 0.0001 },
	{ 0.04618, 0.94398, 0.02122, 12, 36, 48, 0.0001 },
	{ 0.04618, 0.94398, 0.0204, 12, 36, 72, 0.0001 },
	{ 0.04618, 0.94398, 0.01951, 12, 36, 96, 0.0001 },
	{ 0.04618, 0.94398, 0.01872, 12, 36, 120, 0.0001 },
	{ 0.04618, 0.94398, 0.01813, 12, 36, 144, 0.0001 },
	{ 0.04618, 0.94398, 0.01782, 12, 36, 168, 0.0001 },
	{ 0.04618, 0.94398, 0.01778, 12, 36, 180, 0.0001 },
	{ 0.04618, 0.9379, 0.02414, 12, 48, 0, 0.0001 },
	{ 0.04618, 0.9379, 0.02386, 12, 48, 24, 0.0001 },
	{ 0.04618, 0.9379, 0.02309, 12, 48, 48, 0.0001 },
	{ 0.04618, 0.9379, 0.02202, 12, 48, 72, 0.0001 },
	{ 0.04618, 0.9379, 0.02089, 12, 48, 96, 0.0001 },
	{ 0.04618, 0.9379, 0.01992, 12, 48, 120, 0.0001 },
	{ 0.04618, 0.9379, 0.01923, 12, 48, 144, 0.0001 },
	{ 0.04618, 0.9379, 0.01887, 12, 48, 168, 0.0001 },
	{ 0.04618, 0.9379, 0.01883, 12, 48, 180, 0.0001 },
	{ 0.04618, 0.92623, 0.02839, 12, 60, 0, 0.0001 },
	{ 0.04618, 0.92623, 0.02803, 12, 60, 24, 0.0001 },
	{ 0.04618, 0.92623, 0.02706, 12, 60, 48, 0.0001 },
	{ 0.04618, 0.92623, 0.02576, 12, 60, 72, 0.0001 },
	{ 0.04618, 0.92623, 0.02445, 12, 60, 96, 0.0001 },
	{ 0.04618, 0.92623, 0.02338, 12, 60, 120, 0.0001 },
	{ 0.04618, 0.92623, 0.02267, 12, 60, 144, 0.0001 },
	{ 0.04618, 0.92623, 0.02232, 12, 60, 168, 0.0001 },
	{ 0.04618, 0.92623, 0.02228, 12, 60, 180, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 0, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 24, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 48, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 72, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 96, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 120, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 144, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 168, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 180, 0.0001 },
	{ 0.04618, 0.94734, 0.02071, 24, 12, 0, 0.0001 },
	{ 0.04618, 0.94734, 0.02057, 24, 12, 24, 0.0001 },
	{ 0.04618, 0.94734, 0.02018, 24, 12, 48, 0.0001 },
	{ 0.04618, 0.94734, 0.01963, 24, 12, 72, 0.0001 },
	{ 0.04618, 0.94734, 0.01902, 24, 12, 96, 0.0001 },
	{ 0.04618, 0.94734, 0.01845, 24, 12, 120, 0.0001 },
	{ 0.04618, 0.94734, 0.01803, 24, 12, 144, 0.0001 },
	{ 0.04618, 0.94734, 0.0178, 24, 12, 168, 0.0001 },
	{ 0.04618, 0.94734, 0.01777, 24, 12, 180, 0.0001 },
	{ 0.04618, 0.94562, 0.02262, 24, 24, 0, 0.0001 },
	{ 0.04618, 0.94562, 0.02232, 24, 24, 24, 0.0001 },
	{ 0.04618, 0.94562, 0.02151, 24, 24, 48, 0.0001 },
	{ 0.04618, 0.94562, 0.02037, 24, 24, 72, 0.0001 },
	{ 0.04618, 0.94562, 0.01916, 24, 24, 96, 0.0001 },
	{ 0.04618, 0.94562, 0.0181, 24, 24, 120, 0.0001 },
	{ 0.04618, 0.94562, 0.01733, 24, 24, 144, 0.0001 },
	{ 0.04618, 0.94562, 0.01693, 24, 24, 168, 0.0001 },
	{ 0.04618, 0.94562, 0.01688, 24, 24, 180, 0.0001 },
	{ 0.04618, 0.94226, 0.025, 24, 36, 0, 0.0001 },
	{ 0.04618, 0.94226, 0.02453, 24, 36, 24, 0.0001 },
	{ 0.04618, 0.94226, 0.02326, 24, 36, 48, 0.0001 },
	{ 0.04618, 0.94226, 0.02153, 24, 36, 72, 0.0001 },
	{ 0.04618, 0.94226, 0.01977, 24, 36, 96, 0.0001 },
	{ 0.04618, 0.94226, 0.0183, 24, 36, 120, 0.0001 },
	{ 0.04618, 0.94226, 0.01729, 24, 36, 144, 0.0001 },
	{ 0.04618, 0.94226, 0.0168, 24, 36, 168, 0.0001 },
	{ 0.04618, 0.94226, 0.01674, 24, 36, 180, 0.0001 },
	{ 0.04618, 0.93619, 0.02839, 24, 48, 0, 0.0001 },
	{ 0.04618, 0.93619, 0.02772, 24, 48, 24, 0.0001 },
	{ 0.04618, 0.93619, 0.02595, 24, 48, 48, 0.0001 },
	{ 0.04618, 0.93619, 0.02363, 24, 48, 72, 0.0001 },
	{ 0.04618, 0.93619, 0.02137, 24, 48, 96, 0.0001 },
	{ 0.04618, 0.93619, 0.01963, 24, 48, 120, 0.0001 },
	{ 0.04618, 0.93619, 0.01856, 24, 48, 144, 0.0001 },
	{ 0.04618, 0.93619, 0.01807, 24, 48, 168, 0.0001 },
	{ 0.04618, 0.93619, 0.01802, 24, 48, 180, 0.0001 },
	{ 0.04618, 0.92454, 0.03426, 24, 60, 0, 0.0001 },
	{ 0.04618, 0.92454, 0.03336, 24, 60, 24, 0.0001 },
	{ 0.04618, 0.92454, 0.031, 24, 60, 48, 0.0001 },
	{ 0.04618, 0.92454, 0.02803, 24, 60, 72, 0.0001 },
	{ 0.04618, 0.92454, 0.02537, 24, 60, 96, 0.0001 },
	{ 0.04618, 0.92454, 0.02357, 24, 60, 120, 0.0001 },
	{ 0.04618, 0.92454, 0.02267, 24, 60, 144, 0.0001 },
	{ 0.04618, 0.92454, 0.02236, 24, 60, 168, 0.0001 },
	{ 0.04618, 0.92454, 0.02233, 24, 60, 180, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 0, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 24, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 48, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 72, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 96, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 120, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 144, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 168, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 180, 0.0001 },
	{ 0.04618, 0.94398, 0.02201, 36, 12, 0, 0.0001 },
	{ 0.04618, 0.94398, 0.0218, 36, 12, 24, 0.0001 },
	{ 0.04618, 0.94398, 0.02122, 36, 12, 48, 0.0001 },
	{ 0.04618, 0.94398, 0.0204, 36, 12, 72, 0.0001 },
	{ 0.04618, 0.94398, 0.01951, 36, 12, 96, 0.0001 },
	{ 0.04618, 0.94398, 0.01872, 36, 12, 120, 0.0001 },
	{ 0.04618, 0.94398, 0.01813, 36, 12, 144, 0.0001 },
	{ 0.04618, 0.94398, 0.01782, 36, 12, 168, 0.0001 },
	{ 0.04618, 0.94398, 0.01778, 36, 12, 180, 0.0001 },
	{ 0.04618, 0.94226, 0.025, 36, 24, 0, 0.0001 },
	{ 0.04618, 0.94226, 0.02453, 36, 24, 24, 0.0001 },
	{ 0.04618, 0.94226, 0.02326, 36, 24, 48, 0.0001 },
	{ 0.04618, 0.94226, 0.02153, 36, 24, 72, 0.0001 },
	{ 0.04618, 0.94226, 0.01977, 36, 24, 96, 0.0001 },
	{ 0.04618, 0.94226, 0.0183, 36, 24, 120, 0.0001 },
	{ 0.04618, 0.94226, 0.01729, 36, 24, 144, 0.0001 },
	{ 0.04618, 0.94226, 0.0168, 36, 24, 168, 0.0001 },
	{ 0.04618, 0.94226, 0.01674, 36, 24, 180, 0.0001 },
	{ 0.04618, 0.93892, 0.02877, 36, 36, 0, 0.0001 },
	{ 0.04618, 0.93892, 0.02799, 36, 36, 24, 0.0001 },
	{ 0.04618, 0.93892, 0.02592, 36, 36, 48, 0.0001 },
	{ 0.04618, 0.93892, 0.02322, 36, 36, 72, 0.0001 },
	{ 0.04618, 0.93892, 0.02063, 36, 36, 96, 0.0001 },
	{ 0.04618, 0.93892, 0.01866, 36, 36, 120, 0.0001 },
	{ 0.04618, 0.93892, 0.01746, 36, 36, 144, 0.0001 },
	{ 0.04618, 0.93892, 0.01694, 36, 36, 168, 0.0001 },
	{ 0.04618, 0.93892, 0.01688, 36, 36, 180, 0.0001 },
	{ 0.04618, 0.93287, 0.03397, 36, 48, 0, 0.0001 },
	{ 0.04618, 0.93287, 0.03282, 36, 48, 24, 0.0001 },
	{ 0.04618, 0.93287, 0.02981, 36, 48, 48, 0.0001 },
	{ 0.04618, 0.93287, 0.02605, 36, 48, 72, 0.0001 },
	{ 0.04618, 0.93287, 0.0227, 36, 48, 96, 0.0001 },
	{ 0.04618, 0.93287, 0.02048, 36, 48, 120, 0.0001 },
	{ 0.04618, 0.93287, 0.01941, 36, 48, 144, 0.0001 },
	{ 0.04618, 0.93287, 0.01907, 36, 48, 168, 0.0001 },
	{ 0.04618, 0.93287, 0.01904, 36, 48, 180, 0.0001 },
	{ 0.04618, 0.92126, 0.04246, 36, 60, 0, 0.0001 },
	{ 0.04618, 0.92126, 0.04081, 36, 60, 24, 0.0001 },
	{ 0.04618, 0.92126, 0.03659, 36, 60, 48, 0.0001 },
	{ 0.04618, 0.92126, 0.03156, 36, 60, 72, 0.0001 },
	{ 0.04618, 0.92126, 0.02755, 36, 60, 96, 0.0001 },
	{ 0.04618, 0.92126, 0.02546, 36, 60, 120, 0.0001 },
	{ 0.04618, 0.92126, 0.02502, 36, 60, 144, 0.0001 },
	{ 0.04618, 0.92126, 0.02523, 36, 60, 168, 0.0001 },
	{ 0.04618, 0.92126, 0.02528, 36, 60, 180, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 0, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 24, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 48, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 72, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 96, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 120, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 144, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 168, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 180, 0.0001 },
	{ 0.04618, 0.9379, 0.02414, 48, 12, 0, 0.0001 },
	{ 0.04618, 0.9379, 0.02386, 48, 12, 24, 0.0001 },
	{ 0.04618, 0.9379, 0.02309, 48, 12, 48, 0.0001 },
	{ 0.04618, 0.9379, 0.02202, 48, 12, 72, 0.0001 },
	{ 0.04618, 0.9379, 0.02089, 48, 12, 96, 0.0001 },
	{ 0.04618, 0.9379, 0.01992, 48, 12, 120, 0.0001 },
	{ 0.04618, 0.9379, 0.01923, 48, 12, 144, 0.0001 },
	{ 0.04618, 0.9379, 0.01887, 48, 12, 168, 0.0001 },
	{ 0.04618, 0.9379, 0.01883, 48, 12, 180, 0.0001 },
	{ 0.04618, 0.93619, 0.02839, 48, 24, 0, 0.0001 },
	{ 0.04618, 0.93619, 0.02772, 48, 24, 24, 0.0001 },
	{ 0.04618, 0.93619, 0.02595, 48, 24, 48, 0.0001 },
	{ 0.04618, 0.93619, 0.02363, 48, 24, 72, 0.0001 },
	{ 0.04618, 0.93619, 0.02137, 48, 24, 96, 0.0001 },
	{ 0.04618, 0.93619, 0.01963, 48, 24, 120, 0.0001 },
	{ 0.04618, 0.93619, 0.01856, 48, 24, 144, 0.0001 },
	{ 0.04618, 0.93619, 0.01807, 48, 24, 168, 0.0001 },
	{ 0.04618, 0.93619, 0.01802, 48, 24, 180, 0.0001 },
	{ 0.04618, 0.93287, 0.03397, 48, 36, 0, 0.0001 },
	{ 0.04618, 0.93287, 0.03282, 48, 36, 24, 0.0001 },
	{ 0.04618, 0.93287, 0.02981, 48, 36, 48, 0.0001 },
	{ 0.04618, 0.93287, 0.02605, 48, 36, 72, 0.0001 },
	{ 0.04618, 0.93287, 0.0227, 48, 36, 96, 0.0001 },
	{ 0.04618, 0.93287, 0.02048, 48, 36, 120, 0.0001 },
	{ 0.04618, 0.93287, 0.01941, 48, 36, 144, 0.0001 },
	{ 0.04618, 0.93287, 0.01907, 48, 36, 168, 0.0001 },
	{ 0.04618, 0.93287, 0.01904, 48, 36, 180, 0.0001 },
	{ 0.04618, 0.92686, 0.04176, 48, 48, 0, 0.0001 },
	{ 0.04618, 0.92686, 0.03998, 48, 48, 24, 0.0001 },
	{ 0.04618, 0.92686, 0.03542, 48, 48, 48, 0.0001 },
	{ 0.04618, 0.92686, 0.02997, 48, 48, 72, 0.0001 },
	{ 0.04618, 0.92686, 0.0256, 48, 48, 96, 0.0001 },
	{ 0.04618, 0.92686, 0.02329, 48, 48, 120, 0.0001 },
	{ 0.04618, 0.92686, 0.02277, 48, 48, 144, 0.0001 },
	{ 0.04618, 0.92686, 0.02295, 48, 48, 168, 0.0001 },
	{ 0.04618, 0.92686, 0.023, 48, 48, 180, 0.0001 },
	{ 0.04618, 0.91533, 0.05427, 48, 60, 0, 0.0001 },
	{ 0.04618, 0.91533, 0.05159, 48, 60, 24, 0.0001 },
	{ 0.04618, 0.91533, 0.04488, 48, 60, 48, 0.0001 },
	{ 0.04618, 0.91533, 0.03729, 48, 60, 72, 0.0001 },
	{ 0.04618, 0.91533, 0.03194, 48, 60, 96, 0.0001 },
	{ 0.04618, 0.91533, 0.03019, 48, 60, 120, 0.0001 },
	{ 0.04618, 0.91533, 0.03111, 48, 60, 144, 0.0001 },
	{ 0.04618, 0.91533, 0.03247, 48, 60, 168, 0.0001 },
	{ 0.04618, 0.91533, 0.03269, 48, 60, 180, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 0, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 24, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 48, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 72, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 96, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 120, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 144, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 168, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 180, 0.0001 },
	{ 0.04618, 0.92623, 0.02839, 60, 12, 0, 0.0001 },
	{ 0.04618, 0.92623, 0.02803, 60, 12, 24, 0.0001 },
	{ 0.04618, 0.92623, 0.02706, 60, 12, 48, 0.0001 },
	{ 0.04618, 0.92623, 0.02576, 60, 12, 72, 0.0001 },
	{ 0.04618, 0.92623, 0.02445, 60, 12, 96, 0.0001 },
	{ 0.04618, 0.92623, 0.02338, 60, 12, 120, 0.0001 },
	{ 0.04618, 0.92623, 0.02267, 60, 12, 144, 0.0001 },
	{ 0.04618, 0.92623, 0.02232, 60, 12, 168, 0.0001 },
	{ 0.04618, 0.92623, 0.02228, 60, 12, 180, 0.0001 },
	{ 0.04618, 0.92454, 0.03427, 60, 24, 0, 0.0001 },
	{ 0.04618, 0.92454, 0.03336, 60, 24, 24, 0.0001 },
	{ 0.04618, 0.92454, 0.031, 60, 24, 48, 0.0001 },
	{ 0.04618, 0.92454, 0.02803, 60, 24, 72, 0.0001 },
	{ 0.04618, 0.92454, 0.02537, 60, 24, 96, 0.0001 },
	{ 0.04618, 0.92454, 0.02357, 60, 24, 120, 0.0001 },
	{ 0.04618, 0.92454, 0.02267, 60, 24, 144, 0.0001 },
	{ 0.04618, 0.92454, 0.02236, 60, 24, 168, 0.0001 },
	{ 0.04618, 0.92454, 0.02233, 60, 24, 180, 0.0001 },
	{ 0.04618, 0.92126, 0.04246, 60, 36, 0, 0.0001 },
	{ 0.04618, 0.92126, 0.04081, 60, 36, 24, 0.0001 },
	{ 0.04618, 0.92126, 0.03659, 60, 36, 48, 0.0001 },
	{ 0.04618, 0.92126, 0.03156, 60, 36, 72, 0.0001 },
	{ 0.04618, 0.92126, 0.02755, 60, 36, 96, 0.0001 },
	{ 0.04618, 0.92126, 0.02546, 60, 36, 120, 0.0001 },
	{ 0.04618, 0.92126, 0.02502, 60, 36, 144, 0.0001 },
	{ 0.04618, 0.92126, 0.02523, 60, 36, 168, 0.0001 },
	{ 0.04618, 0.92126, 0.02528, 60, 36, 180, 0.0001 },
	{ 0.04618, 0.91533, 0.05427, 60, 48, 0, 0.0001 },
	{ 0.04618, 0.91533, 0.05159, 60, 48, 24, 0.0001 },
	{ 0.04618, 0.91533, 0.04489, 60, 48, 48, 0.0001 },
	{ 0.04618, 0.91533, 0.03729, 60, 48, 72, 0.0001 },
	{ 0.04618, 0.91533, 0.03194, 60, 48, 96, 0.0001 },
	{ 0.04618, 0.91533, 0.03019, 60, 48, 120, 0.0001 },
	{ 0.04618, 0.91533, 0.03111, 60, 48, 144, 0.0001 },
	{ 0.04618, 0.91533, 0.03247, 60, 48, 168, 0.0001 },
	{ 0.04618, 0.91533, 0.03269, 60, 48, 180, 0.0001 },
	{ 0.04618, 0.90394, 0.0734, 60, 60, 0, 0.0001 },
	{ 0.04618, 0.90394, 0.0692, 60, 60, 24, 0.0001 },
	{ 0.04618, 0.90394, 0.05886, 60, 60, 48, 0.0001 },
	{ 0.04618, 0.90394, 0.04773, 60, 60, 72, 0.0001 },
	{ 0.04618, 0.90394, 0.041, 60, 60, 96, 0.0001 },
	{ 0.04618, 0.90394, 0.04061, 60, 60, 120, 0.0001 },
	{ 0.04618, 0.90394, 0.04441, 60, 60, 144, 0.0001 },
	{ 0.04618, 0.90394, 0.04802, 60, 60, 168, 0.0001 },
	{ 0.04618, 0.90394, 0.04856, 60, 60, 180, 0.0001 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 0, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 24, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 48, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 72, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 96, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 120, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 144, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 168, 0.2 },
	{ 0.06707, 0.81531, 0.0281, 0, 0, 180, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 0, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 24, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 48, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 72, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 96, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 120, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 144, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 168, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 0, 12, 180, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 0, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 24, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 48, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 72, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 96, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 120, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 144, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 168, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 0, 24, 180, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 0, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 24, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 48, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 72, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 96, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 120, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 144, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 168, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 0, 36, 180, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 0, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 24, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 48, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 72, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 96, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 120, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 144, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 168, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 0, 48, 180, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 0, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 24, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 48, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 72, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 96, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 120, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 144, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 168, 0.2 },
	{ 0.06707, 0.72387, 0.03648, 0, 60, 180, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 0, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 24, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 48, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 72, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 96, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 120, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 144, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 168, 0.2 },
	{ 0.06707, 0.8132, 0.02671, 12, 0, 180, 0.2 },
	{ 0.06707, 0.81109, 0.02934, 12, 12, 0, 0.2 },
	{ 0.06707, 0.81109, 0.02875, 12, 12, 24, 0.2 },
	{ 0.06707, 0.81109, 0.02773, 12, 12, 48, 0.2 },
	{ 0.06707, 0.81109, 0.02698, 12, 12, 72, 0.2 },
	{ 0.06707, 0.81109, 0.02647, 12, 12, 96, 0.2 },
	{ 0.06707, 0.81109, 0.02607, 12, 12, 120, 0.2 },
	{ 0.06707, 0.81109, 0.02577, 12, 12, 144, 0.2 },
	{ 0.06707, 0.81109, 0.0256, 12, 12, 168, 0.2 },
	{ 0.06707, 0.81109, 0.02558, 12, 12, 180, 0.2 },
	{ 0.06707, 0.80427, 0.02921, 12, 24, 0, 0.2 },
	{ 0.06707, 0.80427, 0.02889, 12, 24, 24, 0.2 },
	{ 0.06707, 0.80427, 0.02827, 12, 24, 48, 0.2 },
	{ 0.06707, 0.80427, 0.02751, 12, 24, 72, 0.2 },
	{ 0.06707, 0.80427, 0.02668, 12, 24, 96, 0.2 },
	{ 0.06707, 0.80427, 0.02593, 12, 24, 120, 0.2 },
	{ 0.06707, 0.80427, 0.02538, 12, 24, 144, 0.2 },
	{ 0.06707, 0.80427, 0.02509, 12, 24, 168, 0.2 },
	{ 0.06707, 0.80427, 0.02506, 12, 24, 180, 0.2 },
	{ 0.06707, 0.79096, 0.03084, 12, 36, 0, 0.2 },
	{ 0.06707, 0.79096, 0.03056, 12, 36, 24, 0.2 },
	{ 0.06707, 0.79096, 0.02977, 12, 36, 48, 0.2 },
	{ 0.06707, 0.79096, 0.02869, 12, 36, 72, 0.2 },
	{ 0.06707, 0.79096, 0.02759, 12, 36, 96, 0.2 },
	{ 0.06707, 0.79096, 0.02666, 12, 36, 120, 0.2 },
	{ 0.06707, 0.79096, 0.02601, 12, 36, 144, 0.2 },
	{ 0.06707, 0.79096, 0.02569, 12, 36, 168, 0.2 },
	{ 0.06707, 0.79096, 0.02565, 12, 36, 180, 0.2 },
	{ 0.06707, 0.76695, 0.03393, 12, 48, 0, 0.2 },
	{ 0.06707, 0.76695, 0.03358, 12, 48, 24, 0.2 },
	{ 0.06707, 0.76695, 0.03266, 12, 48, 48, 0.2 },
	{ 0.06707, 0.76695, 0.03145, 12, 48, 72, 0.2 },
	{ 0.06707, 0.76695, 0.03028, 12, 48, 96, 0.2 },
	{ 0.06707, 0.76695, 0.02937, 12, 48, 120, 0.2 },
	{ 0.06707, 0.76695, 0.02878, 12, 48, 144, 0.2 },
	{ 0.06707, 0.76695, 0.0285, 12, 48, 168, 0.2 },
	{ 0.06707, 0.76695, 0.02847, 12, 48, 180, 0.2 },
	{ 0.06707, 0.722, 0.04046, 12, 60, 0, 0.2 },
	{ 0.06707, 0.722, 0.04009, 12, 60, 24, 0.2 },
	{ 0.06707, 0.722, 0.03914, 12, 60, 48, 0.2 },
	{ 0.06707, 0.722, 0.03798, 12, 60, 72, 0.2 },
	{ 0.06707, 0.722, 0.03697, 12, 60, 96, 0.2 },
	{ 0.06707, 0.722, 0.03634, 12, 60, 120, 0.2 },
	{ 0.06707, 0.722, 0.03607, 12, 60, 144, 0.2 },
	{ 0.06707, 0.722, 0.03601, 12, 60, 168, 0.2 },
	{ 0.06707, 0.722, 0.03601, 12, 60, 180, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 0, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 24, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 48, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 72, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 96, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 120, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 144, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 168, 0.2 },
	{ 0.06707, 0.80636, 0.02677, 24, 0, 180, 0.2 },
	{ 0.06707, 0.80427, 0.02921, 24, 12, 0, 0.2 },
	{ 0.06707, 0.80427, 0.02889, 24, 12, 24, 0.2 },
	{ 0.06707, 0.80427, 0.02827, 24, 12, 48, 0.2 },
	{ 0.06707, 0.80427, 0.02751, 24, 12, 72, 0.2 },
	{ 0.06707, 0.80427, 0.02668, 24, 12, 96, 0.2 },
	{ 0.06707, 0.80427, 0.02593, 24, 12, 120, 0.2 },
	{ 0.06707, 0.80427, 0.02538, 24, 12, 144, 0.2 },
	{ 0.06707, 0.80427, 0.02509, 24, 12, 168, 0.2 },
	{ 0.06707, 0.80427, 0.02506, 24, 12, 180, 0.2 },
	{ 0.06707, 0.79751, 0.03358, 24, 24, 0, 0.2 },
	{ 0.06707, 0.79751, 0.03175, 24, 24, 24, 0.2 },
	{ 0.06707, 0.79751, 0.03013, 24, 24, 48, 0.2 },
	{ 0.06707, 0.79751, 0.02859, 24, 24, 72, 0.2 },
	{ 0.06707, 0.79751, 0.027, 24, 24, 96, 0.2 },
	{ 0.06707, 0.79751, 0.0257, 24, 24, 120, 0.2 },
	{ 0.06707, 0.79751, 0.02484, 24, 24, 144, 0.2 },
	{ 0.06707, 0.79751, 0.02442, 24, 24, 168, 0.2 },
	{ 0.06707, 0.79751, 0.02437, 24, 24, 180, 0.2 },
	{ 0.06707, 0.78431, 0.03525, 24, 36, 0, 0.2 },
	{ 0.06707, 0.78431, 0.03435, 24, 36, 24, 0.2 },
	{ 0.06707, 0.78431, 0.03262, 24, 36, 48, 0.2 },
	{ 0.06707, 0.78431, 0.03034, 24, 36, 72, 0.2 },
	{ 0.06707, 0.78431, 0.02826, 24, 36, 96, 0.2 },
	{ 0.06707, 0.78431, 0.02673, 24, 36, 120, 0.2 },
	{ 0.06707, 0.78431, 0.02583, 24, 36, 144, 0.2 },
	{ 0.06707, 0.78431, 0.02544, 24, 36, 168, 0.2 },
	{ 0.06707, 0.78431, 0.02539, 24, 36, 180, 0.2 },
	{ 0.06707, 0.7605, 0.03971, 24, 48, 0, 0.2 },
	{ 0.06707, 0.7605, 0.03881, 24, 48, 24, 0.2 },
	{ 0.06707, 0.7605, 0.0365, 24, 48, 48, 0.2 },
	{ 0.06707, 0.7605, 0.03378, 24, 48, 72, 0.2 },
	{ 0.06707, 0.7605, 0.03152, 24, 48, 96, 0.2 },
	{ 0.06707, 0.7605, 0.03015, 24, 48, 120, 0.2 },
	{ 0.06707, 0.7605, 0.02961, 24, 48, 144, 0.2 },
	{ 0.06707, 0.7605, 0.02951, 24, 48, 168, 0.2 },
	{ 0.06707, 0.7605, 0.02951, 24, 48, 180, 0.2 },
	{ 0.06707, 0.71593, 0.04778, 24, 60, 0, 0.2 },
	{ 0.06707, 0.71593, 0.04669, 24, 60, 24, 0.2 },
	{ 0.06707, 0.71593, 0.04403, 24, 60, 48, 0.2 },
	{ 0.06707, 0.71593, 0.04113, 24, 60, 72, 0.2 },
	{ 0.06707, 0.71593, 0.03916, 24, 60, 96, 0.2 },
	{ 0.06707, 0.71593, 0.03865, 24, 60, 120, 0.2 },
	{ 0.06707, 0.71593, 0.03925, 24, 60, 144, 0.2 },
	{ 0.06707, 0.71593, 0.03999, 24, 60, 168, 0.2 },
	{ 0.06707, 0.71593, 0.04011, 24, 60, 180, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 0, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 24, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 48, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 72, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 96, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 120, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 144, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 168, 0.2 },
	{ 0.06707, 0.79302, 0.02761, 36, 0, 180, 0.2 },
	{ 0.06707, 0.79096, 0.03085, 36, 12, 0, 0.2 },
	{ 0.06707, 0.79096, 0.03056, 36, 12, 24, 0.2 },
	{ 0.06707, 0.79096, 0.02977, 36, 12, 48, 0.2 },
	{ 0.06707, 0.79096, 0.02869, 36, 12, 72, 0.2 },
	{ 0.06707, 0.79096, 0.02759, 36, 12, 96, 0.2 },
	{ 0.06707, 0.79096, 0.02666, 36, 12, 120, 0.2 },
	{ 0.06707, 0.79096, 0.02601, 36, 12, 144, 0.2 },
	{ 0.06707, 0.79096, 0.02568, 36, 12, 168, 0.2 },
	{ 0.06707, 0.79096, 0.02564, 36, 12, 180, 0.2 },
	{ 0.06707, 0.78431, 0.03525, 36, 24, 0, 0.2 },
	{ 0.06707, 0.78431, 0.03436, 36, 24, 24, 0.2 },
	{ 0.06707, 0.78431, 0.03262, 36, 24, 48, 0.2 },
	{ 0.06707, 0.78431, 0.03034, 36, 24, 72, 0.2 },
	{ 0.06707, 0.78431, 0.02826, 36, 24, 96, 0.2 },
	{ 0.06707, 0.78431, 0.02673, 36, 24, 120, 0.2 },
	{ 0.06707, 0.78431, 0.02583, 36, 24, 144, 0.2 },
	{ 0.06707, 0.78431, 0.02543, 36, 24, 168, 0.2 },
	{ 0.06707, 0.78431, 0.02539, 36, 24, 180, 0.2 },
	{ 0.06707, 0.77133, 0.04263, 36, 36, 0, 0.2 },
	{ 0.06707, 0.77133, 0.0393, 36, 36, 24, 0.2 },
	{ 0.06707, 0.77133, 0.03638, 36, 36, 48, 0.2 },
	{ 0.06707, 0.77133, 0.03295, 36, 36, 72, 0.2 },
	{ 0.06707, 0.77133, 0.03017, 36, 36, 96, 0.2 },
	{ 0.06707, 0.77133, 0.0285, 36, 36, 120, 0.2 },
	{ 0.06707, 0.77133, 0.02784, 36, 36, 144, 0.2 },
	{ 0.06707, 0.77133, 0.02772, 36, 36, 168, 0.2 },
	{ 0.06707, 0.77133, 0.02772, 36, 36, 180, 0.2 },
	{ 0.06707, 0.74792, 0.04781, 36, 48, 0, 0.2 },
	{ 0.06707, 0.74792, 0.0459, 36, 48, 24, 0.2 },
	{ 0.06707, 0.74792, 0.04191, 36, 48, 48, 0.2 },
	{ 0.06707, 0.74792, 0.03751, 36, 48, 72, 0.2 },
	{ 0.06707, 0.74792, 0.03446, 36, 48, 96, 0.2 },
	{ 0.06707, 0.74792, 0.03336, 36, 48, 120, 0.2 },
	{ 0.06707, 0.74792, 0.03379, 36, 48, 144, 0.2 },
	{ 0.06707, 0.74792, 0.03456, 36, 48, 168, 0.2 },
	{ 0.06707, 0.74792, 0.03469, 36, 48, 180, 0.2 },
	{ 0.06707, 0.70408, 0.05894, 36, 60, 0, 0.2 },
	{ 0.06707, 0.70408, 0.05676, 36, 60, 24, 0.2 },
	{ 0.06707, 0.70408, 0.05157, 36, 60, 48, 0.2 },
	{ 0.06707, 0.70408, 0.04648, 36, 60, 72, 0.2 },
	{ 0.06707, 0.70408, 0.04385, 36, 60, 96, 0.2 },
	{ 0.06707, 0.70408, 0.04467, 36, 60, 120, 0.2 },
	{ 0.06707, 0.70408, 0.04798, 36, 60, 144, 0.2 },
	{ 0.06707, 0.70408, 0.051, 36, 60, 168, 0.2 },
	{ 0.06707, 0.70408, 0.05146, 36, 60, 180, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 0, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 24, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 48, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 72, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 96, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 120, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 144, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 168, 0.2 },
	{ 0.06707, 0.76894, 0.03013, 48, 0, 180, 0.2 },
	{ 0.06707, 0.76695, 0.03394, 48, 12, 0, 0.2 },
	{ 0.06707, 0.76695, 0.03359, 48, 12, 24, 0.2 },
	{ 0.06707, 0.76695, 0.03266, 48, 12, 48, 0.2 },
	{ 0.06707, 0.76695, 0.03146, 48, 12, 72, 0.2 },
	{ 0.06707, 0.76695, 0.03028, 48, 12, 96, 0.2 },
	{ 0.06707, 0.76695, 0.02936, 48, 12, 120, 0.2 },
	{ 0.06707, 0.76695, 0.02877, 48, 12, 144, 0.2 },
	{ 0.06707, 0.76695, 0.0285, 48, 12, 168, 0.2 },
	{ 0.06707, 0.76695, 0.02846, 48, 12, 180, 0.2 },
	{ 0.06707, 0.7605, 0.03972, 48, 24, 0, 0.2 },
	{ 0.06707, 0.7605, 0.03882, 48, 24, 24, 0.2 },
	{ 0.06707, 0.7605, 0.03651, 48, 24, 48, 0.2 },
	{ 0.06707, 0.7605, 0.03378, 48, 24, 72, 0.2 },
	{ 0.06707, 0.7605, 0.03153, 48, 24, 96, 0.2 },
	{ 0.06707, 0.7605, 0.03015, 48, 24, 120, 0.2 },
	{ 0.06707, 0.7605, 0.0296, 48, 24, 144, 0.2 },
	{ 0.06707, 0.7605, 0.0295, 48, 24, 168, 0.2 },
	{ 0.06707, 0.7605, 0.0295, 48, 24, 180, 0.2 },
	{ 0.06707, 0.74792, 0.04781, 48, 36, 0, 0.2 },
	{ 0.06707, 0.74792, 0.04591, 48, 36, 24, 0.2 },
	{ 0.06707, 0.74792, 0.04191, 48, 36, 48, 0.2 },
	{ 0.06707, 0.74792, 0.03752, 48, 36, 72, 0.2 },
	{ 0.06707, 0.74792, 0.03446, 48, 36, 96, 0.2 },
	{ 0.06707, 0.74792, 0.03335, 48, 36, 120, 0.2 },
	{ 0.06707, 0.74792, 0.03378, 48, 36, 144, 0.2 },
	{ 0.06707, 0.74792, 0.03455, 48, 36, 168, 0.2 },
	{ 0.06707, 0.74792, 0.03468, 48, 36, 180, 0.2 },
	{ 0.06707, 0.72521, 0.06154, 48, 48, 0, 0.2 },
	{ 0.06707, 0.72521, 0.05585, 48, 48, 24, 0.2 },
	{ 0.06707, 0.72521, 0.04984, 48, 48, 48, 0.2 },
	{ 0.06707, 0.72521, 0.04379, 48, 48, 72, 0.2 },
	{ 0.06707, 0.72521, 0.04047, 48, 48, 96, 0.2 },
	{ 0.06707, 0.72521, 0.04083, 48, 48, 120, 0.2 },
	{ 0.06707, 0.72521, 0.04395, 48, 48, 144, 0.2 },
	{ 0.06707, 0.72521, 0.04695, 48, 48, 168, 0.2 },
	{ 0.06707, 0.72521, 0.04742, 48, 48, 180, 0.2 },
	{ 0.06707, 0.68271, 0.07568, 48, 60, 0, 0.2 },
	{ 0.06707, 0.68271, 0.07162, 48, 60, 24, 0.2 },
	{ 0.06707, 0.68271, 0.06313, 48, 60, 48, 0.2 },
	{ 0.06707, 0.68271, 0.05547, 48, 60, 72, 0.2 },
	{ 0.06707, 0.68271, 0.05284, 48, 60, 96, 0.2 },
	{ 0.06707, 0.68271, 0.0571, 48, 60, 120, 0.2 },
	{ 0.06707, 0.68271, 0.06661, 48, 60, 144, 0.2 },
	{ 0.06707, 0.68271, 0.07509, 48, 60, 168, 0.2 },
	{ 0.06707, 0.68271, 0.07641, 48, 60, 180, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 0, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 24, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 48, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 72, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 96, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 120, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 144, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 168, 0.2 },
	{ 0.06707, 0.72387, 0.03649, 60, 0, 180, 0.2 },
	{ 0.06707, 0.722, 0.04047, 60, 12, 0, 0.2 },
	{ 0.06707, 0.722, 0.0401, 60, 12, 24, 0.2 },
	{ 0.06707, 0.722, 0.03915, 60, 12, 48, 0.2 },
	{ 0.06707, 0.722, 0.03798, 60, 12, 72, 0.2 },
	{ 0.06707, 0.722, 0.03697, 60, 12, 96, 0.2 },
	{ 0.06707, 0.722, 0.03634, 60, 12, 120, 0.2 },
	{ 0.06707, 0.722, 0.03607, 60, 12, 144, 0.2 },
	{ 0.06707, 0.722, 0.03601, 60, 12, 168, 0.2 },
	{ 0.06707, 0.722, 0.03601, 60, 12, 180, 0.2 },
	{ 0.06707, 0.71593, 0.04779, 60, 24, 0, 0.2 },
	{ 0.06707, 0.71593, 0.0467, 60, 24, 24, 0.2 },
	{ 0.06707, 0.71593, 0.04404, 60, 24, 48, 0.2 },
	{ 0.06707, 0.71593, 0.04114, 60, 24, 72, 0.2 },
	{ 0.06707, 0.71593, 0.03917, 60, 24, 96, 0.2 },
	{ 0.06707, 0.71593, 0.03865, 60, 24, 120, 0.2 },
	{ 0.06707, 0.71593, 0.03925, 60, 24, 144, 0.2 },
	{ 0.06707, 0.71593, 0.03999, 60, 24, 168, 0.2 },
	{ 0.06707, 0.71593, 0.0401, 60, 24, 180, 0.2 },
	{ 0.06707, 0.70408, 0.05895, 60, 36, 0, 0.2 },
	{ 0.06707, 0.70408, 0.05677, 60, 36, 24, 0.2 },
	{ 0.06707, 0.70408, 0.05158, 60, 36, 48, 0.2 },
	{ 0.06707, 0.70408, 0.04648, 60, 36, 72, 0.2 },
	{ 0.06707, 0.70408, 0.04385, 60, 36, 96, 0.2 },
	{ 0.06707, 0.70408, 0.04467, 60, 36, 120, 0.2 },
	{ 0.06707, 0.70408, 0.04797, 60, 36, 144, 0.2 },
	{ 0.06707, 0.70408, 0.051, 60, 36, 168, 0.2 },
	{ 0.06707, 0.70408, 0.05146, 60, 36, 180, 0.2 },
	{ 0.06707, 0.68271, 0.07568, 60, 48, 0, 0.2 },
	{ 0.06707, 0.68271, 0.07163, 60, 48, 24, 0.2 },
	{ 0.06707, 0.68271, 0.06314, 60, 48, 48, 0.2 },
	{ 0.06707, 0.68271, 0.05547, 60, 48, 72, 0.2 },
	{ 0.06707, 0.68271, 0.05284, 60, 48, 96, 0.2 },
	{ 0.06707, 0.68271, 0.0571, 60, 48, 120, 0.2 },
	{ 0.06707, 0.68271, 0.06661, 60, 48, 144, 0.2 },
	{ 0.06707, 0.68271, 0.07509, 60, 48, 168, 0.2 },
	{ 0.06707, 0.68271, 0.07641, 60, 48, 180, 0.2 },
	{ 0.06707, 0.64269, 0.10621, 60, 60, 0, 0.2 },
	{ 0.06707, 0.64269, 0.09543, 60, 60, 24, 0.2 },
	{ 0.06707, 0.64269, 0.08254, 60, 60, 48, 0.2 },
	{ 0.06707, 0.64269, 0.07185, 60, 60, 72, 0.2 },
	{ 0.06707, 0.64269, 0.0705, 60, 60, 96, 0.2 },
	{ 0.06707, 0.64269, 0.08244, 60, 60, 120, 0.2 },
	{ 0.06707, 0.64269, 0.10592, 60, 60, 144, 0.2 },
	{ 0.06707, 0.64269, 0.12787, 60, 60, 168, 0.2 },
	{ 0.06707, 0.64269, 0.13141, 60, 60, 180, 0.2 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 0, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 24, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 48, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 72, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 96, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 120, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 144, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 168, 0.4 },
	{ 0.08042, 0.69571, 0.03603, 0, 0, 180, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 0, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 24, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 48, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 72, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 96, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 120, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 144, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 168, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 0, 12, 180, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 0, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 24, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 48, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 72, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 96, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 120, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 144, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 168, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 0, 24, 180, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 0, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 24, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 48, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 72, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 96, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 120, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 144, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 168, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 0, 36, 180, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 0, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 24, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 48, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 72, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 96, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 120, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 144, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 168, 0.4 },
	{ 0.08042, 0.62637, 0.03834, 0, 48, 180, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 0, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 24, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 48, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 72, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 96, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 120, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 144, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 168, 0.4 },
	{ 0.08042, 0.56354, 0.04672, 0, 60, 180, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 0, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 24, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 48, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 72, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 96, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 120, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 144, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 168, 0.4 },
	{ 0.08042, 0.69246, 0.03363, 12, 0, 180, 0.4 },
	{ 0.08042, 0.68921, 0.03758, 12, 12, 0, 0.4 },
	{ 0.08042, 0.68921, 0.0366, 12, 12, 24, 0.4 },
	{ 0.08042, 0.68921, 0.03499, 12, 12, 48, 0.4 },
	{ 0.08042, 0.68921, 0.03389, 12, 12, 72, 0.4 },
	{ 0.08042, 0.68921, 0.03326, 12, 12, 96, 0.4 },
	{ 0.08042, 0.68921, 0.03279, 12, 12, 120, 0.4 },
	{ 0.08042, 0.68921, 0.03243, 12, 12, 144, 0.4 },
	{ 0.08042, 0.68921, 0.03224, 12, 12, 168, 0.4 },
	{ 0.08042, 0.68921, 0.03222, 12, 12, 180, 0.4 },
	{ 0.08042, 0.67878, 0.03668, 12, 24, 0, 0.4 },
	{ 0.08042, 0.67878, 0.03623, 12, 24, 24, 0.4 },
	{ 0.08042, 0.67878, 0.03545, 12, 24, 48, 0.4 },
	{ 0.08042, 0.67878, 0.03457, 12, 24, 72, 0.4 },
	{ 0.08042, 0.67878, 0.0336, 12, 24, 96, 0.4 },
	{ 0.08042, 0.67878, 0.03272, 12, 24, 120, 0.4 },
	{ 0.08042, 0.67878, 0.0321, 12, 24, 144, 0.4 },
	{ 0.08042, 0.67878, 0.03178, 12, 24, 168, 0.4 },
	{ 0.08042, 0.67878, 0.03174, 12, 24, 180, 0.4 },
	{ 0.08042, 0.6587, 0.03862, 12, 36, 0, 0.4 },
	{ 0.08042, 0.6587, 0.03828, 12, 36, 24, 0.4 },
	{ 0.08042, 0.6587, 0.03737, 12, 36, 48, 0.4 },
	{ 0.08042, 0.6587, 0.03613, 12, 36, 72, 0.4 },
	{ 0.08042, 0.6587, 0.03491, 12, 36, 96, 0.4 },
	{ 0.08042, 0.6587, 0.03393, 12, 36, 120, 0.4 },
	{ 0.08042, 0.6587, 0.03327, 12, 36, 144, 0.4 },
	{ 0.08042, 0.6587, 0.03295, 12, 36, 168, 0.4 },
	{ 0.08042, 0.6587, 0.03291, 12, 36, 180, 0.4 },
	{ 0.08042, 0.62344, 0.04245, 12, 48, 0, 0.4 },
	{ 0.08042, 0.62344, 0.04207, 12, 48, 24, 0.4 },
	{ 0.08042, 0.62344, 0.04108, 12, 48, 48, 0.4 },
	{ 0.08042, 0.62344, 0.03984, 12, 48, 72, 0.4 },
	{ 0.08042, 0.62344, 0.03871, 12, 48, 96, 0.4 },
	{ 0.08042, 0.62344, 0.0379, 12, 48, 120, 0.4 },
	{ 0.08042, 0.62344, 0.03745, 12, 48, 144, 0.4 },
	{ 0.08042, 0.62344, 0.03727, 12, 48, 168, 0.4 },
	{ 0.08042, 0.62344, 0.03725, 12, 48, 180, 0.4 },
	{ 0.08042, 0.5609, 0.05045, 12, 60, 0, 0.4 },
	{ 0.08042, 0.5609, 0.0501, 12, 60, 24, 0.4 },
	{ 0.08042, 0.5609, 0.04923, 12, 60, 48, 0.4 },
	{ 0.08042, 0.5609, 0.04826, 12, 60, 72, 0.4 },
	{ 0.08042, 0.5609, 0.04759, 12, 60, 96, 0.4 },
	{ 0.08042, 0.5609, 0.04738, 12, 60, 120, 0.4 },
	{ 0.08042, 0.5609, 0.04752, 12, 60, 144, 0.4 },
	{ 0.08042, 0.5609, 0.04772, 12, 60, 168, 0.4 },
	{ 0.08042, 0.5609, 0.04775, 12, 60, 180, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 0, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 24, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 48, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 72, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 96, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 120, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 144, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 168, 0.4 },
	{ 0.08042, 0.68197, 0.03366, 24, 0, 180, 0.4 },
	{ 0.08042, 0.67878, 0.03668, 24, 12, 0, 0.4 },
	{ 0.08042, 0.67878, 0.03624, 24, 12, 24, 0.4 },
	{ 0.08042, 0.67878, 0.03545, 24, 12, 48, 0.4 },
	{ 0.08042, 0.67878, 0.03457, 24, 12, 72, 0.4 },
	{ 0.08042, 0.67878, 0.03359, 24, 12, 96, 0.4 },
	{ 0.08042, 0.67878, 0.03272, 24, 12, 120, 0.4 },
	{ 0.08042, 0.67878, 0.0321, 24, 12, 144, 0.4 },
	{ 0.08042, 0.67878, 0.03178, 24, 12, 168, 0.4 },
	{ 0.08042, 0.67878, 0.03174, 24, 12, 180, 0.4 },
	{ 0.08042, 0.66851, 0.04284, 24, 24, 0, 0.4 },
	{ 0.08042, 0.66851, 0.03993, 24, 24, 24, 0.4 },
	{ 0.08042, 0.66851, 0.03774, 24, 24, 48, 0.4 },
	{ 0.08042, 0.66851, 0.03594, 24, 24, 72, 0.4 },
	{ 0.08042, 0.66851, 0.03411, 24, 24, 96, 0.4 },
	{ 0.08042, 0.66851, 0.0327, 24, 24, 120, 0.4 },
	{ 0.08042, 0.66851, 0.03181, 24, 24, 144, 0.4 },
	{ 0.08042, 0.66851, 0.03139, 24, 24, 168, 0.4 },
	{ 0.08042, 0.66851, 0.03134, 24, 24, 180, 0.4 },
	{ 0.08042, 0.64873, 0.04404, 24, 36, 0, 0.4 },
	{ 0.08042, 0.64873, 0.04286, 24, 36, 24, 0.4 },
	{ 0.08042, 0.64873, 0.04082, 24, 36, 48, 0.4 },
	{ 0.08042, 0.64873, 0.03822, 24, 36, 72, 0.4 },
	{ 0.08042, 0.64873, 0.03599, 24, 36, 96, 0.4 },
	{ 0.08042, 0.64873, 0.03453, 24, 36, 120, 0.4 },
	{ 0.08042, 0.64873, 0.03378, 24, 36, 144, 0.4 },
	{ 0.08042, 0.64873, 0.03352, 24, 36, 168, 0.4 },
	{ 0.08042, 0.64873, 0.03349, 24, 36, 180, 0.4 },
	{ 0.08042, 0.614, 0.04925, 24, 48, 0, 0.4 },
	{ 0.08042, 0.614, 0.04822, 24, 48, 24, 0.4 },
	{ 0.08042, 0.614, 0.0456, 24, 48, 48, 0.4 },
	{ 0.08042, 0.614, 0.04272, 24, 48, 72, 0.4 },
	{ 0.08042, 0.614, 0.04063, 24, 48, 96, 0.4 },
	{ 0.08042, 0.614, 0.03971, 24, 48, 120, 0.4 },
	{ 0.08042, 0.614, 0.0397, 24, 48, 144, 0.4 },
	{ 0.08042, 0.614, 0.03997, 24, 48, 168, 0.4 },
	{ 0.08042, 0.614, 0.04002, 24, 48, 180, 0.4 },
	{ 0.08042, 0.55241, 0.0586, 24, 60, 0, 0.4 },
	{ 0.08042, 0.55241, 0.05743, 24, 60, 24, 0.4 },
	{ 0.08042, 0.55241, 0.0547, 24, 60, 48, 0.4 },
	{ 0.08042, 0.55241, 0.05206, 24, 60, 72, 0.4 },
	{ 0.08042, 0.55241, 0.05084, 24, 60, 96, 0.4 },
	{ 0.08042, 0.55241, 0.05149, 24, 60, 120, 0.4 },
	{ 0.08042, 0.55241, 0.05337, 24, 60, 144, 0.4 },
	{ 0.08042, 0.55241, 0.05497, 24, 60, 168, 0.4 },
	{ 0.08042, 0.55241, 0.05521, 24, 60, 180, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 0, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 24, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 48, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 72, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 96, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 120, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 144, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 168, 0.4 },
	{ 0.08042, 0.6618, 0.03485, 36, 0, 180, 0.4 },
	{ 0.08042, 0.6587, 0.03863, 36, 12, 0, 0.4 },
	{ 0.08042, 0.6587, 0.03829, 36, 12, 24, 0.4 },
	{ 0.08042, 0.6587, 0.03738, 36, 12, 48, 0.4 },
	{ 0.08042, 0.6587, 0.03614, 36, 12, 72, 0.4 },
	{ 0.08042, 0.6587, 0.03491, 36, 12, 96, 0.4 },
	{ 0.08042, 0.6587, 0.03392, 36, 12, 120, 0.4 },
	{ 0.08042, 0.6587, 0.03327, 36, 12, 144, 0.4 },
	{ 0.08042, 0.6587, 0.03295, 36, 12, 168, 0.4 },
	{ 0.08042, 0.6587, 0.03291, 36, 12, 180, 0.4 },
	{ 0.08042, 0.64873, 0.04404, 36, 24, 0, 0.4 },
	{ 0.08042, 0.64873, 0.04286, 36, 24, 24, 0.4 },
	{ 0.08042, 0.64873, 0.04083, 36, 24, 48, 0.4 },
	{ 0.08042, 0.64873, 0.03822, 36, 24, 72, 0.4 },
	{ 0.08042, 0.64873, 0.03599, 36, 24, 96, 0.4 },
	{ 0.08042, 0.64873, 0.03453, 36, 24, 120, 0.4 },
	{ 0.08042, 0.64873, 0.03378, 36, 24, 144, 0.4 },
	{ 0.08042, 0.64873, 0.03351, 36, 24, 168, 0.4 },
	{ 0.08042, 0.64873, 0.03349, 36, 24, 180, 0.4 },
	{ 0.08042, 0.62954, 0.05392, 36, 36, 0, 0.4 },
	{ 0.08042, 0.62954, 0.04888, 36, 36, 24, 0.4 },
	{ 0.08042, 0.62954, 0.04542, 36, 36, 48, 0.4 },
	{ 0.08042, 0.62954, 0.04159, 36, 36, 72, 0.4 },
	{ 0.08042, 0.62954, 0.03884, 36, 36, 96, 0.4 },
	{ 0.08042, 0.62954, 0.03758, 36, 36, 120, 0.4 },
	{ 0.08042, 0.62954, 0.03748, 36, 36, 144, 0.4 },
	{ 0.08042, 0.62954, 0.03777, 36, 36, 168, 0.4 },
	{ 0.08042, 0.62954, 0.03783, 36, 36, 180, 0.4 },
	{ 0.08042, 0.59584, 0.05905, 36, 48, 0, 0.4 },
	{ 0.08042, 0.59584, 0.05667, 36, 48, 24, 0.4 },
	{ 0.08042, 0.59584, 0.05212, 36, 48, 48, 0.4 },
	{ 0.08042, 0.59584, 0.0475, 36, 48, 72, 0.4 },
	{ 0.08042, 0.59584, 0.04495, 36, 48, 96, 0.4 },
	{ 0.08042, 0.59584, 0.04496, 36, 48, 120, 0.4 },
	{ 0.08042, 0.59584, 0.04676, 36, 48, 144, 0.4 },
	{ 0.08042, 0.59584, 0.04851, 36, 48, 168, 0.4 },
	{ 0.08042, 0.59584, 0.04877, 36, 48, 180, 0.4 },
	{ 0.08042, 0.53607, 0.07158, 36, 60, 0, 0.4 },
	{ 0.08042, 0.53607, 0.06912, 36, 60, 24, 0.4 },
	{ 0.08042, 0.53607, 0.06353, 36, 60, 48, 0.4 },
	{ 0.08042, 0.53607, 0.05874, 36, 60, 72, 0.4 },
	{ 0.08042, 0.53607, 0.05751, 36, 60, 96, 0.4 },
	{ 0.08042, 0.53607, 0.06081, 36, 60, 120, 0.4 },
	{ 0.08042, 0.53607, 0.06712, 36, 60, 144, 0.4 },
	{ 0.08042, 0.53607, 0.07233, 36, 60, 168, 0.4 },
	{ 0.08042, 0.53607, 0.07312, 36, 60, 180, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 0, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 24, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 48, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 72, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 96, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 120, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 144, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 168, 0.4 },
	{ 0.08042, 0.62637, 0.03835, 48, 0, 180, 0.4 },
	{ 0.08042, 0.62344, 0.04246, 48, 12, 0, 0.4 },
	{ 0.08042, 0.62344, 0.04208, 48, 12, 24, 0.4 },
	{ 0.08042, 0.62344, 0.04108, 48, 12, 48, 0.4 },
	{ 0.08042, 0.62344, 0.03984, 48, 12, 72, 0.4 },
	{ 0.08042, 0.62344, 0.03871, 48, 12, 96, 0.4 },
	{ 0.08042, 0.62344, 0.0379, 48, 12, 120, 0.4 },
	{ 0.08042, 0.62344, 0.03745, 48, 12, 144, 0.4 },
	{ 0.08042, 0.62344, 0.03727, 48, 12, 168, 0.4 },
	{ 0.08042, 0.62344, 0.03725, 48, 12, 180, 0.4 },
	{ 0.08042, 0.614, 0.04926, 48, 24, 0, 0.4 },
	{ 0.08042, 0.614, 0.04823, 48, 24, 24, 0.4 },
	{ 0.08042, 0.614, 0.04561, 48, 24, 48, 0.4 },
	{ 0.08042, 0.614, 0.04273, 48, 24, 72, 0.4 },
	{ 0.08042, 0.614, 0.04064, 48, 24, 96, 0.4 },
	{ 0.08042, 0.614, 0.03971, 48, 24, 120, 0.4 },
	{ 0.08042, 0.614, 0.03969, 48, 24, 144, 0.4 },
	{ 0.08042, 0.614, 0.03996, 48, 24, 168, 0.4 },
	{ 0.08042, 0.614, 0.04001, 48, 24, 180, 0.4 },
	{ 0.08042, 0.59584, 0.05905, 48, 36, 0, 0.4 },
	{ 0.08042, 0.59584, 0.05668, 48, 36, 24, 0.4 },
	{ 0.08042, 0.59584, 0.05212, 48, 36, 48, 0.4 },
	{ 0.08042, 0.59584, 0.04751, 48, 36, 72, 0.4 },
	{ 0.08042, 0.59584, 0.04495, 48, 36, 96, 0.4 },
	{ 0.08042, 0.59584, 0.04496, 48, 36, 120, 0.4 },
	{ 0.08042, 0.59584, 0.04676, 48, 36, 144, 0.4 },
	{ 0.08042, 0.59584, 0.04851, 48, 36, 168, 0.4 },
	{ 0.08042, 0.59584, 0.04877, 48, 36, 180, 0.4 },
	{ 0.08042, 0.56394, 0.07652, 48, 48, 0, 0.4 },
	{ 0.08042, 0.56394, 0.06843, 48, 48, 24, 0.4 },
	{ 0.08042, 0.56394, 0.06165, 48, 48, 48, 0.4 },
	{ 0.08042, 0.56394, 0.05553, 48, 48, 72, 0.4 },
	{ 0.08042, 0.56394, 0.0534, 48, 48, 96, 0.4 },
	{ 0.08042, 0.56394, 0.05617, 48, 48, 120, 0.4 },
	{ 0.08042, 0.56394, 0.06234, 48, 48, 144, 0.4 },
	{ 0.08042, 0.56394, 0.06762, 48, 48, 168, 0.4 },
	{ 0.08042, 0.56394, 0.06842, 48, 48, 180, 0.4 },
	{ 0.08042, 0.50737, 0.09121, 48, 60, 0, 0.4 },
	{ 0.08042, 0.50737, 0.08642, 48, 60, 24, 0.4 },
	{ 0.08042, 0.50737, 0.07715, 48, 60, 48, 0.4 },
	{ 0.08042, 0.50737, 0.07001, 48, 60, 72, 0.4 },
	{ 0.08042, 0.50737, 0.06989, 48, 60, 96, 0.4 },
	{ 0.08042, 0.50737, 0.07896, 48, 60, 120, 0.4 },
	{ 0.08042, 0.50737, 0.09491, 48, 60, 144, 0.4 },
	{ 0.08042, 0.50737, 0.10855, 48, 60, 168, 0.4 },
	{ 0.08042, 0.50737, 0.11065, 48, 60, 180, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 0, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 24, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 48, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 72, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 96, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 120, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 144, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 168, 0.4 },
	{ 0.08042, 0.56354, 0.04673, 60, 0, 180, 0.4 },
	{ 0.08042, 0.5609, 0.05046, 60, 12, 0, 0.4 },
	{ 0.08042, 0.5609, 0.05011, 60, 12, 24, 0.4 },
	{ 0.08042, 0.5609, 0.04925, 60, 12, 48, 0.4 },
	{ 0.08042, 0.5609, 0.04827, 60, 12, 72, 0.4 },
	{ 0.08042, 0.5609, 0.0476, 60, 12, 96, 0.4 },
	{ 0.08042, 0.5609, 0.04739, 60, 12, 120, 0.4 },
	{ 0.08042, 0.5609, 0.04753, 60, 12, 144, 0.4 },
	{ 0.08042, 0.5609, 0.04773, 60, 12, 168, 0.4 },
	{ 0.08042, 0.5609, 0.04776, 60, 12, 180, 0.4 },
	{ 0.08042, 0.55241, 0.05861, 60, 24, 0, 0.4 },
	{ 0.08042, 0.55241, 0.05744, 60, 24, 24, 0.4 },
	{ 0.08042, 0.55241, 0.05472, 60, 24, 48, 0.4 },
	{ 0.08042, 0.55241, 0.05207, 60, 24, 72, 0.4 },
	{ 0.08042, 0.55241, 0.05085, 60, 24, 96, 0.4 },
	{ 0.08042, 0.55241, 0.0515, 60, 24, 120, 0.4 },
	{ 0.08042, 0.55241, 0.05338, 60, 24, 144, 0.4 },
	{ 0.08042, 0.55241, 0.05497, 60, 24, 168, 0.4 },
	{ 0.08042, 0.55241, 0.05521, 60, 24, 180, 0.4 },
	{ 0.08042, 0.53607, 0.07159, 60, 36, 0, 0.4 },
	{ 0.08042, 0.53607, 0.06914, 60, 36, 24, 0.4 },
	{ 0.08042, 0.53607, 0.06354, 60, 36, 48, 0.4 },
	{ 0.08042, 0.53607, 0.05875, 60, 36, 72, 0.4 },
	{ 0.08042, 0.53607, 0.05752, 60, 36, 96, 0.4 },
	{ 0.08042, 0.53607, 0.06081, 60, 36, 120, 0.4 },
	{ 0.08042, 0.53607, 0.06712, 60, 36, 144, 0.4 },
	{ 0.08042, 0.53607, 0.07234, 60, 36, 168, 0.4 },
	{ 0.08042, 0.53607, 0.07312, 60, 36, 180, 0.4 },
	{ 0.08042, 0.50737, 0.09123, 60, 48, 0, 0.4 },
	{ 0.08042, 0.50737, 0.08643, 60, 48, 24, 0.4 },
	{ 0.08042, 0.50737, 0.07716, 60, 48, 48, 0.4 },
	{ 0.08042, 0.50737, 0.07002, 60, 48, 72, 0.4 },
	{ 0.08042, 0.50737, 0.0699, 60, 48, 96, 0.4 },
	{ 0.08042, 0.50737, 0.07896, 60, 48, 120, 0.4 },
	{ 0.08042, 0.50737, 0.09491, 60, 48, 144, 0.4 },
	{ 0.08042, 0.50737, 0.10855, 60, 48, 168, 0.4 },
	{ 0.08042, 0.50737, 0.11065, 60, 48, 180, 0.4 },
	{ 0.08042, 0.45648, 0.12753, 60, 60, 0, 0.4 },
	{ 0.08042, 0.45648, 0.11332, 60, 60, 24, 0.4 },
	{ 0.08042, 0.45648, 0.09948, 60, 60, 48, 0.4 },
	{ 0.08042, 0.45648, 0.08994, 60, 60, 72, 0.4 },
	{ 0.08042, 0.45648, 0.09305, 60, 60, 96, 0.4 },
	{ 0.08042, 0.45648, 0.11396, 60, 60, 120, 0.4 },
	{ 0.08042, 0.45648, 0.15078, 60, 60, 144, 0.4 },
	{ 0.08042, 0.45648, 0.18469, 60, 60, 168, 0.4 },
	{ 0.08042, 0.45648, 0.19015, 60, 60, 180, 0.4 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 0, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 24, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 48, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 72, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 96, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 120, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 144, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 168, 0.6 },
	{ 0.0896, 0.5907, 0.04296, 0, 0, 180, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 0, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 24, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 48, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 72, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 96, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 120, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 144, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 168, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 0, 12, 180, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 0, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 24, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 48, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 72, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 96, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 120, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 144, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 168, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 0, 24, 180, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 0, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 24, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 48, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 72, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 96, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 120, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 144, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 168, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 0, 36, 180, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 0, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 24, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 48, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 72, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 96, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 120, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 144, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 168, 0.6 },
	{ 0.0896, 0.50806, 0.04558, 0, 48, 180, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 0, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 24, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 48, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 72, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 96, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 120, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 144, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 168, 0.6 },
	{ 0.0896, 0.4384, 0.05521, 0, 60, 180, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 0, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 24, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 48, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 72, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 96, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 120, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 144, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 168, 0.6 },
	{ 0.0896, 0.58669, 0.03982, 12, 0, 180, 0.6 },
	{ 0.0896, 0.5827, 0.04472, 12, 12, 0, 0.6 },
	{ 0.0896, 0.5827, 0.04347, 12, 12, 24, 0.6 },
	{ 0.0896, 0.5827, 0.04143, 12, 12, 48, 0.6 },
	{ 0.0896, 0.5827, 0.0401, 12, 12, 72, 0.6 },
	{ 0.0896, 0.5827, 0.03937, 12, 12, 96, 0.6 },
	{ 0.0896, 0.5827, 0.03885, 12, 12, 120, 0.6 },
	{ 0.0896, 0.5827, 0.03846, 12, 12, 144, 0.6 },
	{ 0.0896, 0.5827, 0.03825, 12, 12, 168, 0.6 },
	{ 0.0896, 0.5827, 0.03823, 12, 12, 180, 0.6 },
	{ 0.0896, 0.56996, 0.0433, 12, 24, 0, 0.6 },
	{ 0.0896, 0.56996, 0.04276, 12, 24, 24, 0.6 },
	{ 0.0896, 0.56996, 0.04187, 12, 24, 48, 0.6 },
	{ 0.0896, 0.56996, 0.0409, 12, 24, 72, 0.6 },
	{ 0.0896, 0.56996, 0.03983, 12, 24, 96, 0.6 },
	{ 0.0896, 0.56996, 0.03889, 12, 24, 120, 0.6 },
	{ 0.0896, 0.56996, 0.03822, 12, 24, 144, 0.6 },
	{ 0.0896, 0.56996, 0.03787, 12, 24, 168, 0.6 },
	{ 0.0896, 0.56996, 0.03783, 12, 24, 180, 0.6 },
	{ 0.0896, 0.54581, 0.04548, 12, 36, 0, 0.6 },
	{ 0.0896, 0.54581, 0.04512, 12, 36, 24, 0.6 },
	{ 0.0896, 0.54581, 0.04412, 12, 36, 48, 0.6 },
	{ 0.0896, 0.54581, 0.04279, 12, 36, 72, 0.6 },
	{ 0.0896, 0.54581, 0.0415, 12, 36, 96, 0.6 },
	{ 0.0896, 0.54581, 0.0405, 12, 36, 120, 0.6 },
	{ 0.0896, 0.54581, 0.03986, 12, 36, 144, 0.6 },
	{ 0.0896, 0.54581, 0.03955, 12, 36, 168, 0.6 },
	{ 0.0896, 0.54581, 0.03952, 12, 36, 180, 0.6 },
	{ 0.0896, 0.50461, 0.04985, 12, 48, 0, 0.6 },
	{ 0.0896, 0.50461, 0.04945, 12, 48, 24, 0.6 },
	{ 0.0896, 0.50461, 0.04842, 12, 48, 48, 0.6 },
	{ 0.0896, 0.50461, 0.04719, 12, 48, 72, 0.6 },
	{ 0.0896, 0.50461, 0.04613, 12, 48, 96, 0.6 },
	{ 0.0896, 0.50461, 0.04545, 12, 48, 120, 0.6 },
	{ 0.0896, 0.50461, 0.04513, 12, 48, 144, 0.6 },
	{ 0.0896, 0.50461, 0.04503, 12, 48, 168, 0.6 },
	{ 0.0896, 0.50461, 0.04502, 12, 48, 180, 0.6 },
	{ 0.0896, 0.43542, 0.05866, 12, 60, 0, 0.6 },
	{ 0.0896, 0.43542, 0.05833, 12, 60, 24, 0.6 },
	{ 0.0896, 0.43542, 0.05756, 12, 60, 48, 0.6 },
	{ 0.0896, 0.43542, 0.05677, 12, 60, 72, 0.6 },
	{ 0.0896, 0.43542, 0.05638, 12, 60, 96, 0.6 },
	{ 0.0896, 0.43542, 0.05652, 12, 60, 120, 0.6 },
	{ 0.0896, 0.43542, 0.05698, 12, 60, 144, 0.6 },
	{ 0.0896, 0.43542, 0.05739, 12, 60, 168, 0.6 },
	{ 0.0896, 0.43542, 0.05744, 12, 60, 180, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 0, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 24, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 48, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 72, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 96, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 120, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 144, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 168, 0.6 },
	{ 0.0896, 0.57386, 0.03986, 24, 0, 180, 0.6 },
	{ 0.0896, 0.56996, 0.0433, 24, 12, 0, 0.6 },
	{ 0.0896, 0.56996, 0.04276, 24, 12, 24, 0.6 },
	{ 0.0896, 0.56996, 0.04187, 24, 12, 48, 0.6 },
	{ 0.0896, 0.56996, 0.0409, 24, 12, 72, 0.6 },
	{ 0.0896, 0.56996, 0.03983, 24, 12, 96, 0.6 },
	{ 0.0896, 0.56996, 0.03889, 24, 12, 120, 0.6 },
	{ 0.0896, 0.56996, 0.03822, 24, 12, 144, 0.6 },
	{ 0.0896, 0.56996, 0.03788, 24, 12, 168, 0.6 },
	{ 0.0896, 0.56996, 0.03783, 24, 12, 180, 0.6 },
	{ 0.0896, 0.5575, 0.05074, 24, 24, 0, 0.6 },
	{ 0.0896, 0.5575, 0.04708, 24, 24, 24, 0.6 },
	{ 0.0896, 0.5575, 0.04449, 24, 24, 48, 0.6 },
	{ 0.0896, 0.5575, 0.04252, 24, 24, 72, 0.6 },
	{ 0.0896, 0.5575, 0.04054, 24, 24, 96, 0.6 },
	{ 0.0896, 0.5575, 0.03907, 24, 24, 120, 0.6 },
	{ 0.0896, 0.5575, 0.03818, 24, 24, 144, 0.6 },
	{ 0.0896, 0.5575, 0.03778, 24, 24, 168, 0.6 },
	{ 0.0896, 0.5575, 0.03774, 24, 24, 180, 0.6 },
	{ 0.0896, 0.53388, 0.05163, 24, 36, 0, 0.6 },
	{ 0.0896, 0.53388, 0.05026, 24, 36, 24, 0.6 },
	{ 0.0896, 0.53388, 0.04803, 24, 36, 48, 0.6 },
	{ 0.0896, 0.53388, 0.04522, 24, 36, 72, 0.6 },
	{ 0.0896, 0.53388, 0.04294, 24, 36, 96, 0.6 },
	{ 0.0896, 0.53388, 0.04157, 24, 36, 120, 0.6 },
	{ 0.0896, 0.53388, 0.04099, 24, 36, 144, 0.6 },
	{ 0.0896, 0.53388, 0.04085, 24, 36, 168, 0.6 },
	{ 0.0896, 0.53388, 0.04084, 24, 36, 180, 0.6 },
	{ 0.0896, 0.49358, 0.05734, 24, 48, 0, 0.6 },
	{ 0.0896, 0.49358, 0.05622, 24, 48, 24, 0.6 },
	{ 0.0896, 0.49358, 0.05344, 24, 48, 48, 0.6 },
	{ 0.0896, 0.49358, 0.05051, 24, 48, 72, 0.6 },
	{ 0.0896, 0.49358, 0.04862, 24, 48, 96, 0.6 },
	{ 0.0896, 0.49358, 0.0481, 24, 48, 120, 0.6 },
	{ 0.0896, 0.49358, 0.04854, 24, 48, 144, 0.6 },
	{ 0.0896, 0.49358, 0.04912, 24, 48, 168, 0.6 },
	{ 0.0896, 0.49358, 0.04922, 24, 48, 180, 0.6 },
	{ 0.0896, 0.4259, 0.06729, 24, 60, 0, 0.6 },
	{ 0.0896, 0.4259, 0.06609, 24, 60, 24, 0.6 },
	{ 0.0896, 0.4259, 0.06339, 24, 60, 48, 0.6 },
	{ 0.0896, 0.4259, 0.06103, 24, 60, 72, 0.6 },
	{ 0.0896, 0.4259, 0.06043, 24, 60, 96, 0.6 },
	{ 0.0896, 0.4259, 0.06201, 24, 60, 120, 0.6 },
	{ 0.0896, 0.4259, 0.06486, 24, 60, 144, 0.6 },
	{ 0.0896, 0.4259, 0.0671, 24, 60, 168, 0.6 },
	{ 0.0896, 0.4259, 0.06743, 24, 60, 180, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 0, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 24, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 48, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 72, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 96, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 120, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 144, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 168, 0.6 },
	{ 0.0896, 0.54954, 0.04135, 36, 0, 180, 0.6 },
	{ 0.0896, 0.54581, 0.0455, 36, 12, 0, 0.6 },
	{ 0.0896, 0.54581, 0.04513, 36, 12, 24, 0.6 },
	{ 0.0896, 0.54581, 0.04413, 36, 12, 48, 0.6 },
	{ 0.0896, 0.54581, 0.0428, 36, 12, 72, 0.6 },
	{ 0.0896, 0.54581, 0.04151, 36, 12, 96, 0.6 },
	{ 0.0896, 0.54581, 0.0405, 36, 12, 120, 0.6 },
	{ 0.0896, 0.54581, 0.03985, 36, 12, 144, 0.6 },
	{ 0.0896, 0.54581, 0.03955, 36, 12, 168, 0.6 },
	{ 0.0896, 0.54581, 0.03951, 36, 12, 180, 0.6 },
	{ 0.0896, 0.53388, 0.05164, 36, 24, 0, 0.6 },
	{ 0.0896, 0.53388, 0.05027, 36, 24, 24, 0.6 },
	{ 0.0896, 0.53388, 0.04803, 36, 24, 48, 0.6 },
	{ 0.0896, 0.53388, 0.04523, 36, 24, 72, 0.6 },
	{ 0.0896, 0.53388, 0.04294, 36, 24, 96, 0.6 },
	{ 0.0896, 0.53388, 0.04157, 36, 24, 120, 0.6 },
	{ 0.0896, 0.53388, 0.04099, 36, 24, 144, 0.6 },
	{ 0.0896, 0.53388, 0.04084, 36, 24, 168, 0.6 },
	{ 0.0896, 0.53388, 0.04083, 36, 24, 180, 0.6 },
	{ 0.0896, 0.51125, 0.06324, 36, 36, 0, 0.6 },
	{ 0.0896, 0.51125, 0.05704, 36, 36, 24, 0.6 },
	{ 0.0896, 0.51125, 0.05324, 36, 36, 48, 0.6 },
	{ 0.0896, 0.51125, 0.04919, 36, 36, 72, 0.6 },
	{ 0.0896, 0.51125, 0.04656, 36, 36, 96, 0.6 },
	{ 0.0896, 0.51125, 0.04569, 36, 36, 120, 0.6 },
	{ 0.0896, 0.51125, 0.04608, 36, 36, 144, 0.6 },
	{ 0.0896, 0.51125, 0.04671, 36, 36, 168, 0.6 },
	{ 0.0896, 0.51125, 0.04682, 36, 36, 180, 0.6 },
	{ 0.0896, 0.47266, 0.06829, 36, 48, 0, 0.6 },
	{ 0.0896, 0.47266, 0.06561, 36, 48, 24, 0.6 },
	{ 0.0896, 0.47266, 0.06074, 36, 48, 48, 0.6 },
	{ 0.0896, 0.47266, 0.05608, 36, 48, 72, 0.6 },
	{ 0.0896, 0.47266, 0.05401, 36, 48, 96, 0.6 },
	{ 0.0896, 0.47266, 0.05497, 36, 48, 120, 0.6 },
	{ 0.0896, 0.47266, 0.05787, 36, 48, 144, 0.6 },
	{ 0.0896, 0.47266, 0.06039, 36, 48, 168, 0.6 },
	{ 0.0896, 0.47266, 0.06077, 36, 48, 180, 0.6 },
	{ 0.0896, 0.40785, 0.08141, 36, 60, 0, 0.6 },
	{ 0.0896, 0.40785, 0.07881, 36, 60, 24, 0.6 },
	{ 0.0896, 0.40785, 0.07306, 36, 60, 48, 0.6 },
	{ 0.0896, 0.40785, 0.06865, 36, 60, 72, 0.6 },
	{ 0.0896, 0.40785, 0.06855, 36, 60, 96, 0.6 },
	{ 0.0896, 0.40785, 0.07372, 36, 60, 120, 0.6 },
	{ 0.0896, 0.40785, 0.08222, 36, 60, 144, 0.6 },
	{ 0.0896, 0.40785, 0.08901, 36, 60, 168, 0.6 },
	{ 0.0896, 0.40785, 0.09002, 36, 60, 180, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 0, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 24, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 48, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 72, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 96, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 120, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 144, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 168, 0.6 },
	{ 0.0896, 0.50806, 0.04559, 48, 0, 180, 0.6 },
	{ 0.0896, 0.50461, 0.04986, 48, 12, 0, 0.6 },
	{ 0.0896, 0.50461, 0.04946, 48, 12, 24, 0.6 },
	{ 0.0896, 0.50461, 0.04843, 48, 12, 48, 0.6 },
	{ 0.0896, 0.50461, 0.0472, 48, 12, 72, 0.6 },
	{ 0.0896, 0.50461, 0.04614, 48, 12, 96, 0.6 },
	{ 0.0896, 0.50461, 0.04545, 48, 12, 120, 0.6 },
	{ 0.0896, 0.50461, 0.04513, 48, 12, 144, 0.6 },
	{ 0.0896, 0.50461, 0.04503, 48, 12, 168, 0.6 },
	{ 0.0896, 0.50461, 0.04502, 48, 12, 180, 0.6 },
	{ 0.0896, 0.49358, 0.05735, 48, 24, 0, 0.6 },
	{ 0.0896, 0.49358, 0.05623, 48, 24, 24, 0.6 },
	{ 0.0896, 0.49358, 0.05345, 48, 24, 48, 0.6 },
	{ 0.0896, 0.49358, 0.05052, 48, 24, 72, 0.6 },
	{ 0.0896, 0.49358, 0.04863, 48, 24, 96, 0.6 },
	{ 0.0896, 0.49358, 0.0481, 48, 24, 120, 0.6 },
	{ 0.0896, 0.49358, 0.04855, 48, 24, 144, 0.6 },
	{ 0.0896, 0.49358, 0.04913, 48, 24, 168, 0.6 },
	{ 0.0896, 0.49358, 0.04922, 48, 24, 180, 0.6 },
	{ 0.0896, 0.47266, 0.06829, 48, 36, 0, 0.6 },
	{ 0.0896, 0.47266, 0.06562, 48, 36, 24, 0.6 },
	{ 0.0896, 0.47266, 0.06074, 48, 36, 48, 0.6 },
	{ 0.0896, 0.47266, 0.05608, 48, 36, 72, 0.6 },
	{ 0.0896, 0.47266, 0.05401, 48, 36, 96, 0.6 },
	{ 0.0896, 0.47266, 0.05497, 48, 36, 120, 0.6 },
	{ 0.0896, 0.47266, 0.05787, 48, 36, 144, 0.6 },
	{ 0.0896, 0.47266, 0.06039, 48, 36, 168, 0.6 },
	{ 0.0896, 0.47266, 0.06077, 48, 36, 180, 0.6 },
	{ 0.0896, 0.43698, 0.08809, 48, 48, 0, 0.6 },
	{ 0.0896, 0.43698, 0.07851, 48, 48, 24, 0.6 },
	{ 0.0896, 0.43698, 0.07132, 48, 48, 48, 0.6 },
	{ 0.0896, 0.43698, 0.06533, 48, 48, 72, 0.6 },
	{ 0.0896, 0.43698, 0.06424, 48, 48, 96, 0.6 },
	{ 0.0896, 0.43698, 0.06889, 48, 48, 120, 0.6 },
	{ 0.0896, 0.43698, 0.07737, 48, 48, 144, 0.6 },
	{ 0.0896, 0.43698, 0.08435, 48, 48, 168, 0.6 },
	{ 0.0896, 0.43698, 0.0854, 48, 48, 180, 0.6 },
	{ 0.0896, 0.37706, 0.10272, 48, 60, 0, 0.6 },
	{ 0.0896, 0.37706, 0.09753, 48, 60, 24, 0.6 },
	{ 0.0896, 0.37706, 0.08794, 48, 60, 48, 0.6 },
	{ 0.0896, 0.37706, 0.08139, 48, 60, 72, 0.6 },
	{ 0.0896, 0.37706, 0.08321, 48, 60, 96, 0.6 },
	{ 0.0896, 0.37706, 0.09573, 48, 60, 120, 0.6 },
	{ 0.0896, 0.37706, 0.11613, 48, 60, 144, 0.6 },
	{ 0.0896, 0.37706, 0.13325, 48, 60, 168, 0.6 },
	{ 0.0896, 0.37706, 0.13588, 48, 60, 180, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 0, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 24, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 48, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 72, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 96, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 120, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 144, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 168, 0.6 },
	{ 0.0896, 0.4384, 0.05523, 60, 0, 180, 0.6 },
	{ 0.0896, 0.43542, 0.05869, 60, 12, 0, 0.6 },
	{ 0.0896, 0.43542, 0.05836, 60, 12, 24, 0.6 },
	{ 0.0896, 0.43542, 0.05758, 60, 12, 48, 0.6 },
	{ 0.0896, 0.43542, 0.05679, 60, 12, 72, 0.6 },
	{ 0.0896, 0.43542, 0.05639, 60, 12, 96, 0.6 },
	{ 0.0896, 0.43542, 0.05653, 60, 12, 120, 0.6 },
	{ 0.0896, 0.43542, 0.057, 60, 12, 144, 0.6 },
	{ 0.0896, 0.43542, 0.0574, 60, 12, 168, 0.6 },
	{ 0.0896, 0.43542, 0.05746, 60, 12, 180, 0.6 },
	{ 0.0896, 0.4259, 0.06733, 60, 24, 0, 0.6 },
	{ 0.0896, 0.4259, 0.06612, 60, 24, 24, 0.6 },
	{ 0.0896, 0.4259, 0.06342, 60, 24, 48, 0.6 },
	{ 0.0896, 0.4259, 0.06105, 60, 24, 72, 0.6 },
	{ 0.0896, 0.4259, 0.06045, 60, 24, 96, 0.6 },
	{ 0.0896, 0.4259, 0.06202, 60, 24, 120, 0.6 },
	{ 0.0896, 0.4259, 0.06487, 60, 24, 144, 0.6 },
	{ 0.0896, 0.4259, 0.06711, 60, 24, 168, 0.6 },
	{ 0.0896, 0.4259, 0.06744, 60, 24, 180, 0.6 },
	{ 0.0896, 0.40785, 0.08144, 60, 36, 0, 0.6 },
	{ 0.0896, 0.40785, 0.07884, 60, 36, 24, 0.6 },
	{ 0.0896, 0.40785, 0.07309, 60, 36, 48, 0.6 },
	{ 0.0896, 0.40785, 0.06867, 60, 36, 72, 0.6 },
	{ 0.0896, 0.40785, 0.06857, 60, 36, 96, 0.6 },
	{ 0.0896, 0.40785, 0.07373, 60, 36, 120, 0.6 },
	{ 0.0896, 0.40785, 0.08223, 60, 36, 144, 0.6 },
	{ 0.0896, 0.40785, 0.08902, 60, 36, 168, 0.6 },
	{ 0.0896, 0.40785, 0.09003, 60, 36, 180, 0.6 },
	{ 0.0896, 0.37706, 0.10275, 60, 48, 0, 0.6 },
	{ 0.0896, 0.37706, 0.09755, 60, 48, 24, 0.6 },
	{ 0.0896, 0.37706, 0.08797, 60, 48, 48, 0.6 },
	{ 0.0896, 0.37706, 0.08141, 60, 48, 72, 0.6 },
	{ 0.0896, 0.37706, 0.08323, 60, 48, 96, 0.6 },
	{ 0.0896, 0.37706, 0.09574, 60, 48, 120, 0.6 },
	{ 0.0896, 0.37706, 0.11613, 60, 48, 144, 0.6 },
	{ 0.0896, 0.37706, 0.13326, 60, 48, 168, 0.6 },
	{ 0.0896, 0.37706, 0.13588, 60, 48, 180, 0.6 },
	{ 0.0896, 0.32536, 0.14178, 60, 60, 0, 0.6 },
	{ 0.0896, 0.32536, 0.12579, 60, 60, 24, 0.6 },
	{ 0.0896, 0.32536, 0.11167, 60, 60, 48, 0.6 },
	{ 0.0896, 0.32536, 0.10321, 60, 60, 72, 0.6 },
	{ 0.0896, 0.32536, 0.10952, 60, 60, 96, 0.6 },
	{ 0.0896, 0.32536, 0.13633, 60, 60, 120, 0.6 },
	{ 0.0896, 0.32536, 0.18156, 60, 60, 144, 0.6 },
	{ 0.0896, 0.32536, 0.22282, 60, 60, 168, 0.6 },
	{ 0.0896, 0.32536, 0.22946, 60, 60, 180, 0.6 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 0, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 24, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 48, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 72, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 96, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 120, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 144, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 168, 0.8 },
	{ 0.09629, 0.49931, 0.04922, 0, 0, 180, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 0, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 24, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 48, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 72, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 96, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 120, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 144, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 168, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 0, 12, 180, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 0, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 24, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 48, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 72, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 96, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 120, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 144, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 168, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 0, 24, 180, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 0, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 24, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 48, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 72, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 96, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 120, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 144, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 168, 0.8 },
	{ 0.09629, 0.45443, 0.04735, 0, 36, 180, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 0, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 24, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 48, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 72, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 96, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 120, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 144, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 168, 0.8 },
	{ 0.09629, 0.4108, 0.0521, 0, 48, 180, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 0, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 24, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 48, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 72, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 96, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 120, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 144, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 168, 0.8 },
	{ 0.09629, 0.3413, 0.06242, 0, 60, 180, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 0, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 24, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 48, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 72, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 96, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 120, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 144, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 168, 0.8 },
	{ 0.09629, 0.49487, 0.04556, 12, 0, 180, 0.8 },
	{ 0.09629, 0.49046, 0.05115, 12, 12, 0, 0.8 },
	{ 0.09629, 0.49046, 0.0497, 12, 12, 24, 0.8 },
	{ 0.09629, 0.49046, 0.04736, 12, 12, 48, 0.8 },
	{ 0.09629, 0.49046, 0.04585, 12, 12, 72, 0.8 },
	{ 0.09629, 0.49046, 0.04505, 12, 12, 96, 0.8 },
	{ 0.09629, 0.49046, 0.0445, 12, 12, 120, 0.8 },
	{ 0.09629, 0.49046, 0.04409, 12, 12, 144, 0.8 },
	{ 0.09629, 0.49046, 0.04387, 12, 12, 168, 0.8 },
	{ 0.09629, 0.49046, 0.04384, 12, 12, 180, 0.8 },
	{ 0.09629, 0.47648, 0.04937, 12, 24, 0, 0.8 },
	{ 0.09629, 0.47648, 0.04877, 12, 24, 24, 0.8 },
	{ 0.09629, 0.47648, 0.04779, 12, 24, 48, 0.8 },
	{ 0.09629, 0.47648, 0.04676, 12, 24, 72, 0.8 },
	{ 0.09629, 0.47648, 0.04563, 12, 24, 96, 0.8 },
	{ 0.09629, 0.47648, 0.04463, 12, 24, 120, 0.8 },
	{ 0.09629, 0.47648, 0.04393, 12, 24, 144, 0.8 },
	{ 0.09629, 0.47648, 0.04358, 12, 24, 168, 0.8 },
	{ 0.09629, 0.47648, 0.04353, 12, 24, 180, 0.8 },
	{ 0.09629, 0.45039, 0.05176, 12, 36, 0, 0.8 },
	{ 0.09629, 0.45039, 0.05137, 12, 36, 24, 0.8 },
	{ 0.09629, 0.45039, 0.05031, 12, 36, 48, 0.8 },
	{ 0.09629, 0.45039, 0.04892, 12, 36, 72, 0.8 },
	{ 0.09629, 0.45039, 0.04758, 12, 36, 96, 0.8 },
	{ 0.09629, 0.45039, 0.04657, 12, 36, 120, 0.8 },
	{ 0.09629, 0.45039, 0.04594, 12, 36, 144, 0.8 },
	{ 0.09629, 0.45039, 0.04565, 12, 36, 168, 0.8 },
	{ 0.09629, 0.45039, 0.04561, 12, 36, 180, 0.8 },
	{ 0.09629, 0.40714, 0.05648, 12, 48, 0, 0.8 },
	{ 0.09629, 0.40714, 0.05607, 12, 48, 24, 0.8 },
	{ 0.09629, 0.40714, 0.05502, 12, 48, 48, 0.8 },
	{ 0.09629, 0.40714, 0.0538, 12, 48, 72, 0.8 },
	{ 0.09629, 0.40714, 0.05279, 12, 48, 96, 0.8 },
	{ 0.09629, 0.40714, 0.0522, 12, 48, 120, 0.8 },
	{ 0.09629, 0.40714, 0.05199, 12, 48, 144, 0.8 },
	{ 0.09629, 0.40714, 0.05195, 12, 48, 168, 0.8 },
	{ 0.09629, 0.40714, 0.05196, 12, 48, 180, 0.8 },
	{ 0.09629, 0.33826, 0.06567, 12, 60, 0, 0.8 },
	{ 0.09629, 0.33826, 0.06536, 12, 60, 24, 0.8 },
	{ 0.09629, 0.33826, 0.06465, 12, 60, 48, 0.8 },
	{ 0.09629, 0.33826, 0.06399, 12, 60, 72, 0.8 },
	{ 0.09629, 0.33826, 0.0638, 12, 60, 96, 0.8 },
	{ 0.09629, 0.33826, 0.06419, 12, 60, 120, 0.8 },
	{ 0.09629, 0.33826, 0.06489, 12, 60, 144, 0.8 },
	{ 0.09629, 0.33826, 0.06544, 12, 60, 168, 0.8 },
	{ 0.09629, 0.33826, 0.06551, 12, 60, 180, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 0, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 24, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 48, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 72, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 96, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 120, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 144, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 168, 0.8 },
	{ 0.09629, 0.48076, 0.04563, 24, 0, 180, 0.8 },
	{ 0.09629, 0.47648, 0.04938, 24, 12, 0, 0.8 },
	{ 0.09629, 0.47648, 0.04878, 24, 12, 24, 0.8 },
	{ 0.09629, 0.47648, 0.0478, 24, 12, 48, 0.8 },
	{ 0.09629, 0.47648, 0.04676, 24, 12, 72, 0.8 },
	{ 0.09629, 0.47648, 0.04563, 24, 12, 96, 0.8 },
	{ 0.09629, 0.47648, 0.04463, 24, 12, 120, 0.8 },
	{ 0.09629, 0.47648, 0.04393, 24, 12, 144, 0.8 },
	{ 0.09629, 0.47648, 0.04358, 24, 12, 168, 0.8 },
	{ 0.09629, 0.47648, 0.04353, 24, 12, 180, 0.8 },
	{ 0.09629, 0.4629, 0.05776, 24, 24, 0, 0.8 },
	{ 0.09629, 0.4629, 0.05356, 24, 24, 24, 0.8 },
	{ 0.09629, 0.4629, 0.05069, 24, 24, 48, 0.8 },
	{ 0.09629, 0.4629, 0.04859, 24, 24, 72, 0.8 },
	{ 0.09629, 0.4629, 0.0465, 24, 24, 96, 0.8 },
	{ 0.09629, 0.4629, 0.04499, 24, 24, 120, 0.8 },
	{ 0.09629, 0.4629, 0.04411, 24, 24, 144, 0.8 },
	{ 0.09629, 0.4629, 0.04373, 24, 24, 168, 0.8 },
	{ 0.09629, 0.4629, 0.04369, 24, 24, 180, 0.8 },
	{ 0.09629, 0.43755, 0.05846, 24, 36, 0, 0.8 },
	{ 0.09629, 0.43755, 0.05695, 24, 36, 24, 0.8 },
	{ 0.09629, 0.43755, 0.05457, 24, 36, 48, 0.8 },
	{ 0.09629, 0.43755, 0.05163, 24, 36, 72, 0.8 },
	{ 0.09629, 0.43755, 0.04931, 24, 36, 96, 0.8 },
	{ 0.09629, 0.43755, 0.04803, 24, 36, 120, 0.8 },
	{ 0.09629, 0.43755, 0.04757, 24, 36, 144, 0.8 },
	{ 0.09629, 0.43755, 0.04753, 24, 36, 168, 0.8 },
	{ 0.09629, 0.43755, 0.04753, 24, 36, 180, 0.8 },
	{ 0.09629, 0.39553, 0.06449, 24, 48, 0, 0.8 },
	{ 0.09629, 0.39553, 0.06331, 24, 48, 24, 0.8 },
	{ 0.09629, 0.39553, 0.06041, 24, 48, 48, 0.8 },
	{ 0.09629, 0.39553, 0.05746, 24, 48, 72, 0.8 },
	{ 0.09629, 0.39553, 0.05572, 24, 48, 96, 0.8 },
	{ 0.09629, 0.39553, 0.05551, 24, 48, 120, 0.8 },
	{ 0.09629, 0.39553, 0.05631, 24, 48, 144, 0.8 },
	{ 0.09629, 0.39553, 0.05713, 24, 48, 168, 0.8 },
	{ 0.09629, 0.39553, 0.05725, 24, 48, 180, 0.8 },
	{ 0.09629, 0.32862, 0.07466, 24, 60, 0, 0.8 },
	{ 0.09629, 0.32862, 0.07344, 24, 60, 24, 0.8 },
	{ 0.09629, 0.32862, 0.07076, 24, 60, 48, 0.8 },
	{ 0.09629, 0.32862, 0.06859, 24, 60, 72, 0.8 },
	{ 0.09629, 0.32862, 0.06844, 24, 60, 96, 0.8 },
	{ 0.09629, 0.32862, 0.07067, 24, 60, 120, 0.8 },
	{ 0.09629, 0.32862, 0.07421, 24, 60, 144, 0.8 },
	{ 0.09629, 0.32862, 0.07691, 24, 60, 168, 0.8 },
	{ 0.09629, 0.32862, 0.0773, 24, 60, 180, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 0, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 24, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 48, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 72, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 96, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 120, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 144, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 168, 0.8 },
	{ 0.09629, 0.45443, 0.04736, 36, 0, 180, 0.8 },
	{ 0.09629, 0.45039, 0.05178, 36, 12, 0, 0.8 },
	{ 0.09629, 0.45039, 0.05139, 36, 12, 24, 0.8 },
	{ 0.09629, 0.45039, 0.05033, 36, 12, 48, 0.8 },
	{ 0.09629, 0.45039, 0.04893, 36, 12, 72, 0.8 },
	{ 0.09629, 0.45039, 0.04759, 36, 12, 96, 0.8 },
	{ 0.09629, 0.45039, 0.04657, 36, 12, 120, 0.8 },
	{ 0.09629, 0.45039, 0.04594, 36, 12, 144, 0.8 },
	{ 0.09629, 0.45039, 0.04565, 36, 12, 168, 0.8 },
	{ 0.09629, 0.45039, 0.04561, 36, 12, 180, 0.8 },
	{ 0.09629, 0.43755, 0.05847, 36, 24, 0, 0.8 },
	{ 0.09629, 0.43755, 0.05696, 36, 24, 24, 0.8 },
	{ 0.09629, 0.43755, 0.05458, 36, 24, 48, 0.8 },
	{ 0.09629, 0.43755, 0.05164, 36, 24, 72, 0.8 },
	{ 0.09629, 0.43755, 0.04932, 36, 24, 96, 0.8 },
	{ 0.09629, 0.43755, 0.04803, 36, 24, 120, 0.8 },
	{ 0.09629, 0.43755, 0.04757, 36, 24, 144, 0.8 },
	{ 0.09629, 0.43755, 0.04752, 36, 24, 168, 0.8 },
	{ 0.09629, 0.43755, 0.04753, 36, 24, 180, 0.8 },
	{ 0.09629, 0.41359, 0.07128, 36, 36, 0, 0.8 },
	{ 0.09629, 0.41359, 0.0643, 36, 36, 24, 0.8 },
	{ 0.09629, 0.41359, 0.06026, 36, 36, 48, 0.8 },
	{ 0.09629, 0.41359, 0.05606, 36, 36, 72, 0.8 },
	{ 0.09629, 0.41359, 0.05352, 36, 36, 96, 0.8 },
	{ 0.09629, 0.41359, 0.05297, 36, 36, 120, 0.8 },
	{ 0.09629, 0.41359, 0.05374, 36, 36, 144, 0.8 },
	{ 0.09629, 0.41359, 0.05463, 36, 36, 168, 0.8 },
	{ 0.09629, 0.41359, 0.05478, 36, 36, 180, 0.8 },
	{ 0.09629, 0.37387, 0.07626, 36, 48, 0, 0.8 },
	{ 0.09629, 0.37387, 0.07339, 36, 48, 24, 0.8 },
	{ 0.09629, 0.37387, 0.06829, 36, 48, 48, 0.8 },
	{ 0.09629, 0.37387, 0.06361, 36, 48, 72, 0.8 },
	{ 0.09629, 0.37387, 0.06192, 36, 48, 96, 0.8 },
	{ 0.09629, 0.37387, 0.06359, 36, 48, 120, 0.8 },
	{ 0.09629, 0.37387, 0.06732, 36, 48, 144, 0.8 },
	{ 0.09629, 0.37387, 0.07041, 36, 48, 168, 0.8 },
	{ 0.09629, 0.37387, 0.07087, 36, 48, 180, 0.8 },
	{ 0.09629, 0.31062, 0.08957, 36, 60, 0, 0.8 },
	{ 0.09629, 0.31062, 0.08688, 36, 60, 24, 0.8 },
	{ 0.09629, 0.31062, 0.08104, 36, 60, 48, 0.8 },
	{ 0.09629, 0.31062, 0.07689, 36, 60, 72, 0.8 },
	{ 0.09629, 0.31062, 0.07759, 36, 60, 96, 0.8 },
	{ 0.09629, 0.31062, 0.08405, 36, 60, 120, 0.8 },
	{ 0.09629, 0.31062, 0.09407, 36, 60, 144, 0.8 },
	{ 0.09629, 0.31062, 0.10193, 36, 60, 168, 0.8 },
	{ 0.09629, 0.31062, 0.10309, 36, 60, 180, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 0, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 24, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 48, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 72, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 96, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 120, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 144, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 168, 0.8 },
	{ 0.09629, 0.4108, 0.05211, 48, 0, 180, 0.8 },
	{ 0.09629, 0.40714, 0.0565, 48, 12, 0, 0.8 },
	{ 0.09629, 0.40714, 0.05609, 48, 12, 24, 0.8 },
	{ 0.09629, 0.40714, 0.05504, 48, 12, 48, 0.8 },
	{ 0.09629, 0.40714, 0.05381, 48, 12, 72, 0.8 },
	{ 0.09629, 0.40714, 0.0528, 48, 12, 96, 0.8 },
	{ 0.09629, 0.40714, 0.05221, 48, 12, 120, 0.8 },
	{ 0.09629, 0.40714, 0.05199, 48, 12, 144, 0.8 },
	{ 0.09629, 0.40714, 0.05196, 48, 12, 168, 0.8 },
	{ 0.09629, 0.40714, 0.05196, 48, 12, 180, 0.8 },
	{ 0.09629, 0.39553, 0.06451, 48, 24, 0, 0.8 },
	{ 0.09629, 0.39553, 0.06333, 48, 24, 24, 0.8 },
	{ 0.09629, 0.39553, 0.06043, 48, 24, 48, 0.8 },
	{ 0.09629, 0.39553, 0.05747, 48, 24, 72, 0.8 },
	{ 0.09629, 0.39553, 0.05574, 48, 24, 96, 0.8 },
	{ 0.09629, 0.39553, 0.05552, 48, 24, 120, 0.8 },
	{ 0.09629, 0.39553, 0.05632, 48, 24, 144, 0.8 },
	{ 0.09629, 0.39553, 0.05713, 48, 24, 168, 0.8 },
	{ 0.09629, 0.39553, 0.05726, 48, 24, 180, 0.8 },
	{ 0.09629, 0.37387, 0.07627, 48, 36, 0, 0.8 },
	{ 0.09629, 0.37387, 0.0734, 48, 36, 24, 0.8 },
	{ 0.09629, 0.37387, 0.0683, 48, 36, 48, 0.8 },
	{ 0.09629, 0.37387, 0.06362, 48, 36, 72, 0.8 },
	{ 0.09629, 0.37387, 0.06193, 48, 36, 96, 0.8 },
	{ 0.09629, 0.37387, 0.06359, 48, 36, 120, 0.8 },
	{ 0.09629, 0.37387, 0.06732, 48, 36, 144, 0.8 },
	{ 0.09629, 0.37387, 0.07041, 48, 36, 168, 0.8 },
	{ 0.09629, 0.37387, 0.07087, 48, 36, 180, 0.8 },
	{ 0.09629, 0.33797, 0.09754, 48, 48, 0, 0.8 },
	{ 0.09629, 0.33797, 0.08705, 48, 48, 24, 0.8 },
	{ 0.09629, 0.33797, 0.07957, 48, 48, 48, 0.8 },
	{ 0.09629, 0.33797, 0.0737, 48, 48, 72, 0.8 },
	{ 0.09629, 0.33797, 0.07336, 48, 48, 96, 0.8 },
	{ 0.09629, 0.33797, 0.07939, 48, 48, 120, 0.8 },
	{ 0.09629, 0.33797, 0.08951, 48, 48, 144, 0.8 },
	{ 0.09629, 0.33797, 0.09769, 48, 48, 168, 0.8 },
	{ 0.09629, 0.33797, 0.09893, 48, 48, 180, 0.8 },
	{ 0.09629, 0.28079, 0.11194, 48, 60, 0, 0.8 },
	{ 0.09629, 0.28079, 0.10651, 48, 60, 24, 0.8 },
	{ 0.09629, 0.28079, 0.09674, 48, 60, 48, 0.8 },
	{ 0.09629, 0.28079, 0.0906, 48, 60, 72, 0.8 },
	{ 0.09629, 0.28079, 0.09373, 48, 60, 96, 0.8 },
	{ 0.09629, 0.28079, 0.10855, 48, 60, 120, 0.8 },
	{ 0.09629, 0.28079, 0.13187, 48, 60, 144, 0.8 },
	{ 0.09629, 0.28079, 0.15125, 48, 60, 168, 0.8 },
	{ 0.09629, 0.28079, 0.15421, 48, 60, 180, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 0, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 24, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 48, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 72, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 96, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 120, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 144, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 168, 0.8 },
	{ 0.09629, 0.3413, 0.06245, 60, 0, 180, 0.8 },
	{ 0.09629, 0.33826, 0.06572, 60, 12, 0, 0.8 },
	{ 0.09629, 0.33826, 0.06541, 60, 12, 24, 0.8 },
	{ 0.09629, 0.33826, 0.06469, 60, 12, 48, 0.8 },
	{ 0.09629, 0.33826, 0.06403, 60, 12, 72, 0.8 },
	{ 0.09629, 0.33826, 0.06383, 60, 12, 96, 0.8 },
	{ 0.09629, 0.33826, 0.06422, 60, 12, 120, 0.8 },
	{ 0.09629, 0.33826, 0.06492, 60, 12, 144, 0.8 },
	{ 0.09629, 0.33826, 0.06546, 60, 12, 168, 0.8 },
	{ 0.09629, 0.33826, 0.06554, 60, 12, 180, 0.8 },
	{ 0.09629, 0.32862, 0.07472, 60, 24, 0, 0.8 },
	{ 0.09629, 0.32862, 0.0735, 60, 24, 24, 0.8 },
	{ 0.09629, 0.32862, 0.07081, 60, 24, 48, 0.8 },
	{ 0.09629, 0.32862, 0.06863, 60, 24, 72, 0.8 },
	{ 0.09629, 0.32862, 0.06847, 60, 24, 96, 0.8 },
	{ 0.09629, 0.32862, 0.0707, 60, 24, 120, 0.8 },
	{ 0.09629, 0.32862, 0.07423, 60, 24, 144, 0.8 },
	{ 0.09629, 0.32862, 0.07693, 60, 24, 168, 0.8 },
	{ 0.09629, 0.32862, 0.07732, 60, 24, 180, 0.8 },
	{ 0.09629, 0.31062, 0.08962, 60, 36, 0, 0.8 },
	{ 0.09629, 0.31062, 0.08693, 60, 36, 24, 0.8 },
	{ 0.09629, 0.31062, 0.08109, 60, 36, 48, 0.8 },
	{ 0.09629, 0.31062, 0.07692, 60, 36, 72, 0.8 },
	{ 0.09629, 0.31062, 0.07761, 60, 36, 96, 0.8 },
	{ 0.09629, 0.31062, 0.08407, 60, 36, 120, 0.8 },
	{ 0.09629, 0.31062, 0.09408, 60, 36, 144, 0.8 },
	{ 0.09629, 0.31062, 0.10194, 60, 36, 168, 0.8 },
	{ 0.09629, 0.31062, 0.10311, 60, 36, 180, 0.8 },
	{ 0.09629, 0.28079, 0.11199, 60, 48, 0, 0.8 },
	{ 0.09629, 0.28079, 0.10656, 60, 48, 24, 0.8 },
	{ 0.09629, 0.28079, 0.09678, 60, 48, 48, 0.8 },
	{ 0.09629, 0.28079, 0.09063, 60, 48, 72, 0.8 },
	{ 0.09629, 0.28079, 0.09376, 60, 48, 96, 0.8 },
	{ 0.09629, 0.28079, 0.10857, 60, 48, 120, 0.8 },
	{ 0.09629, 0.28079, 0.13189, 60, 48, 144, 0.8 },
	{ 0.09629, 0.28079, 0.15126, 60, 48, 168, 0.8 },
	{ 0.09629, 0.28079, 0.15422, 60, 48, 180, 0.8 },
	{ 0.09629, 0.23329, 0.15234, 60, 60, 0, 0.8 },
	{ 0.09629, 0.23329, 0.13542, 60, 60, 24, 0.8 },
	{ 0.09629, 0.23329, 0.12115, 60, 60, 48, 0.8 },
	{ 0.09629, 0.23329, 0.11339, 60, 60, 72, 0.8 },
	{ 0.09629, 0.23329, 0.1217, 60, 60, 96, 0.8 },
	{ 0.09629, 0.23329, 0.15218, 60, 60, 120, 0.8 },
	{ 0.09629, 0.23329, 0.20249, 60, 60, 144, 0.8 },
	{ 0.09629, 0.23329, 0.24808, 60, 60, 168, 0.8 },
	{ 0.09629, 0.23329, 0.2554, 60, 60, 180, 0.8 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 0, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 24, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 48, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 72, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 96, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 120, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 144, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 168, 1 },
	{ 0.10114, 0.42045, 0.05465, 0, 0, 180, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 0, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 24, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 48, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 72, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 96, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 120, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 144, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 168, 1 },
	{ 0.10114, 0.41583, 0.05061, 0, 12, 180, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 0, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 24, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 48, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 72, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 96, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 120, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 144, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 168, 1 },
	{ 0.10114, 0.40127, 0.0507, 0, 24, 180, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 0, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 24, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 48, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 72, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 96, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 120, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 144, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 168, 1 },
	{ 0.10114, 0.37451, 0.05259, 0, 36, 180, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 0, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 24, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 48, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 72, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 96, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 120, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 144, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 168, 1 },
	{ 0.10114, 0.33139, 0.05765, 0, 48, 180, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 0, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 24, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 48, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 72, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 96, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 120, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 144, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 168, 1 },
	{ 0.10114, 0.26612, 0.06822, 0, 60, 180, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 0, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 24, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 48, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 72, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 96, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 120, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 144, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 168, 1 },
	{ 0.10114, 0.41583, 0.05061, 12, 0, 180, 1 },
	{ 0.10114, 0.41127, 0.05669, 12, 12, 0, 1 },
	{ 0.10114, 0.41127, 0.05511, 12, 12, 24, 1 },
	{ 0.10114, 0.41127, 0.05254, 12, 12, 48, 1 },
	{ 0.10114, 0.41127, 0.05091, 12, 12, 72, 1 },
	{ 0.10114, 0.41127, 0.05007, 12, 12, 96, 1 },
	{ 0.10114, 0.41127, 0.04949, 12, 12, 120, 1 },
	{ 0.10114, 0.41127, 0.04907, 12, 12, 144, 1 },
	{ 0.10114, 0.41127, 0.04884, 12, 12, 168, 1 },
	{ 0.10114, 0.41127, 0.04881, 12, 12, 180, 1 },
	{ 0.10114, 0.39686, 0.05466, 12, 24, 0, 1 },
	{ 0.10114, 0.39686, 0.05402, 12, 24, 24, 1 },
	{ 0.10114, 0.39686, 0.05298, 12, 24, 48, 1 },
	{ 0.10114, 0.39686, 0.0519, 12, 24, 72, 1 },
	{ 0.10114, 0.39686, 0.05073, 12, 24, 96, 1 },
	{ 0.10114, 0.39686, 0.0497, 12, 24, 120, 1 },
	{ 0.10114, 0.39686, 0.04898, 12, 24, 144, 1 },
	{ 0.10114, 0.39686, 0.04862, 12, 24, 168, 1 },
	{ 0.10114, 0.39686, 0.04857, 12, 24, 180, 1 },
	{ 0.10114, 0.37039, 0.05719, 12, 36, 0, 1 },
	{ 0.10114, 0.37039, 0.05678, 12, 36, 24, 1 },
	{ 0.10114, 0.37039, 0.05568, 12, 36, 48, 1 },
	{ 0.10114, 0.37039, 0.05424, 12, 36, 72, 1 },
	{ 0.10114, 0.37039, 0.05288, 12, 36, 96, 1 },
	{ 0.10114, 0.37039, 0.05187, 12, 36, 120, 1 },
	{ 0.10114, 0.37039, 0.05125, 12, 36, 144, 1 },
	{ 0.10114, 0.37039, 0.05098, 12, 36, 168, 1 },
	{ 0.10114, 0.37039, 0.05094, 12, 36, 180, 1 },
	{ 0.10114, 0.32775, 0.06208, 12, 48, 0, 1 },
	{ 0.10114, 0.32775, 0.06167, 12, 48, 24, 1 },
	{ 0.10114, 0.32775, 0.06062, 12, 48, 48, 1 },
	{ 0.10114, 0.32775, 0.05941, 12, 48, 72, 1 },
	{ 0.10114, 0.32775, 0.05845, 12, 48, 96, 1 },
	{ 0.10114, 0.32775, 0.05794, 12, 48, 120, 1 },
	{ 0.10114, 0.32775, 0.05781, 12, 48, 144, 1 },
	{ 0.10114, 0.32775, 0.05783, 12, 48, 168, 1 },
	{ 0.10114, 0.32775, 0.05784, 12, 48, 180, 1 },
	{ 0.10114, 0.2632, 0.07132, 12, 60, 0, 1 },
	{ 0.10114, 0.2632, 0.07102, 12, 60, 24, 1 },
	{ 0.10114, 0.2632, 0.07036, 12, 60, 48, 1 },
	{ 0.10114, 0.2632, 0.06979, 12, 60, 72, 1 },
	{ 0.10114, 0.2632, 0.06976, 12, 60, 96, 1 },
	{ 0.10114, 0.2632, 0.07033, 12, 60, 120, 1 },
	{ 0.10114, 0.2632, 0.0712, 12, 60, 144, 1 },
	{ 0.10114, 0.2632, 0.07185, 12, 60, 168, 1 },
	{ 0.10114, 0.2632, 0.07194, 12, 60, 180, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 0, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 24, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 48, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 72, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 96, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 120, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 144, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 168, 1 },
	{ 0.10114, 0.40127, 0.0507, 24, 0, 180, 1 },
	{ 0.10114, 0.39686, 0.05467, 24, 12, 0, 1 },
	{ 0.10114, 0.39686, 0.05402, 24, 12, 24, 1 },
	{ 0.10114, 0.39686, 0.05298, 24, 12, 48, 1 },
	{ 0.10114, 0.39686, 0.05191, 24, 12, 72, 1 },
	{ 0.10114, 0.39686, 0.05073, 24, 12, 96, 1 },
	{ 0.10114, 0.39686, 0.0497, 24, 12, 120, 1 },
	{ 0.10114, 0.39686, 0.04898, 24, 12, 144, 1 },
	{ 0.10114, 0.39686, 0.04862, 24, 12, 168, 1 },
	{ 0.10114, 0.39686, 0.04858, 24, 12, 180, 1 },
	{ 0.10114, 0.38296, 0.06371, 24, 24, 0, 1 },
	{ 0.10114, 0.38296, 0.05914, 24, 24, 24, 1 },
	{ 0.10114, 0.38296, 0.05608, 24, 24, 48, 1 },
	{ 0.10114, 0.38296, 0.05388, 24, 24, 72, 1 },
	{ 0.10114, 0.38296, 0.05173, 24, 24, 96, 1 },
	{ 0.10114, 0.38296, 0.0502, 24, 24, 120, 1 },
	{ 0.10114, 0.38296, 0.04933, 24, 24, 144, 1 },
	{ 0.10114, 0.38296, 0.04898, 24, 24, 168, 1 },
	{ 0.10114, 0.38296, 0.04894, 24, 24, 180, 1 },
	{ 0.10114, 0.35742, 0.06427, 24, 36, 0, 1 },
	{ 0.10114, 0.35742, 0.06266, 24, 36, 24, 1 },
	{ 0.10114, 0.35742, 0.06019, 24, 36, 48, 1 },
	{ 0.10114, 0.35742, 0.05716, 24, 36, 72, 1 },
	{ 0.10114, 0.35742, 0.05484, 24, 36, 96, 1 },
	{ 0.10114, 0.35742, 0.05363, 24, 36, 120, 1 },
	{ 0.10114, 0.35742, 0.05328, 24, 36, 144, 1 },
	{ 0.10114, 0.35742, 0.05332, 24, 36, 168, 1 },
	{ 0.10114, 0.35742, 0.05333, 24, 36, 180, 1 },
	{ 0.10114, 0.31627, 0.07044, 24, 48, 0, 1 },
	{ 0.10114, 0.31627, 0.06923, 24, 48, 24, 1 },
	{ 0.10114, 0.31627, 0.06625, 24, 48, 48, 1 },
	{ 0.10114, 0.31627, 0.06331, 24, 48, 72, 1 },
	{ 0.10114, 0.31627, 0.06171, 24, 48, 96, 1 },
	{ 0.10114, 0.31627, 0.06174, 24, 48, 120, 1 },
	{ 0.10114, 0.31627, 0.06282, 24, 48, 144, 1 },
	{ 0.10114, 0.31627, 0.06381, 24, 48, 168, 1 },
	{ 0.10114, 0.31627, 0.06397, 24, 48, 180, 1 },
	{ 0.10114, 0.25398, 0.08052, 24, 60, 0, 1 },
	{ 0.10114, 0.25398, 0.0793, 24, 60, 24, 1 },
	{ 0.10114, 0.25398, 0.07665, 24, 60, 48, 1 },
	{ 0.10114, 0.25398, 0.07463, 24, 60, 72, 1 },
	{ 0.10114, 0.25398, 0.07481, 24, 60, 96, 1 },
	{ 0.10114, 0.25398, 0.07751, 24, 60, 120, 1 },
	{ 0.10114, 0.25398, 0.08153, 24, 60, 144, 1 },
	{ 0.10114, 0.25398, 0.08456, 24, 60, 168, 1 },
	{ 0.10114, 0.25398, 0.08499, 24, 60, 180, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 0, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 24, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 48, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 72, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 96, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 120, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 144, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 168, 1 },
	{ 0.10114, 0.37451, 0.0526, 36, 0, 180, 1 },
	{ 0.10114, 0.37039, 0.0572, 36, 12, 0, 1 },
	{ 0.10114, 0.37039, 0.0568, 36, 12, 24, 1 },
	{ 0.10114, 0.37039, 0.0557, 36, 12, 48, 1 },
	{ 0.10114, 0.37039, 0.05425, 36, 12, 72, 1 },
	{ 0.10114, 0.37039, 0.05289, 36, 12, 96, 1 },
	{ 0.10114, 0.37039, 0.05187, 36, 12, 120, 1 },
	{ 0.10114, 0.37039, 0.05125, 36, 12, 144, 1 },
	{ 0.10114, 0.37039, 0.05098, 36, 12, 168, 1 },
	{ 0.10114, 0.37039, 0.05094, 36, 12, 180, 1 },
	{ 0.10114, 0.35742, 0.06428, 36, 24, 0, 1 },
	{ 0.10114, 0.35742, 0.06267, 36, 24, 24, 1 },
	{ 0.10114, 0.35742, 0.0602, 36, 24, 48, 1 },
	{ 0.10114, 0.35742, 0.05717, 36, 24, 72, 1 },
	{ 0.10114, 0.35742, 0.05484, 36, 24, 96, 1 },
	{ 0.10114, 0.35742, 0.05363, 36, 24, 120, 1 },
	{ 0.10114, 0.35742, 0.05328, 36, 24, 144, 1 },
	{ 0.10114, 0.35742, 0.05331, 36, 24, 168, 1 },
	{ 0.10114, 0.35742, 0.05333, 36, 24, 180, 1 },
	{ 0.10114, 0.33358, 0.07789, 36, 36, 0, 1 },
	{ 0.10114, 0.33358, 0.07039, 36, 36, 24, 1 },
	{ 0.10114, 0.33358, 0.06619, 36, 36, 48, 1 },
	{ 0.10114, 0.33358, 0.06191, 36, 36, 72, 1 },
	{ 0.10114, 0.33358, 0.05947, 36, 36, 96, 1 },
	{ 0.10114, 0.33358, 0.05917, 36, 36, 120, 1 },
	{ 0.10114, 0.33358, 0.06024, 36, 36, 144, 1 },
	{ 0.10114, 0.33358, 0.06134, 36, 36, 168, 1 },
	{ 0.10114, 0.33358, 0.06151, 36, 36, 180, 1 },
	{ 0.10114, 0.29517, 0.08275, 36, 48, 0, 1 },
	{ 0.10114, 0.29517, 0.07975, 36, 48, 24, 1 },
	{ 0.10114, 0.29517, 0.07452, 36, 48, 48, 1 },
	{ 0.10114, 0.29517, 0.06986, 36, 48, 72, 1 },
	{ 0.10114, 0.29517, 0.06847, 36, 48, 96, 1 },
	{ 0.10114, 0.29517, 0.07068, 36, 48, 120, 1 },
	{ 0.10114, 0.29517, 0.07502, 36, 48, 144, 1 },
	{ 0.10114, 0.29517, 0.07854, 36, 48, 168, 1 },
	{ 0.10114, 0.29517, 0.07906, 36, 48, 180, 1 },
	{ 0.10114, 0.23704, 0.0959, 36, 60, 0, 1 },
	{ 0.10114, 0.23704, 0.09317, 36, 60, 24, 1 },
	{ 0.10114, 0.23704, 0.0873, 36, 60, 48, 1 },
	{ 0.10114, 0.23704, 0.08336, 36, 60, 72, 1 },
	{ 0.10114, 0.23704, 0.08463, 36, 60, 96, 1 },
	{ 0.10114, 0.23704, 0.092, 36, 60, 120, 1 },
	{ 0.10114, 0.23704, 0.10305, 36, 60, 144, 1 },
	{ 0.10114, 0.23704, 0.11164, 36, 60, 168, 1 },
	{ 0.10114, 0.23704, 0.11291, 36, 60, 180, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 0, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 24, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 48, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 72, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 96, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 120, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 144, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 168, 1 },
	{ 0.10114, 0.33139, 0.05767, 48, 0, 180, 1 },
	{ 0.10114, 0.32775, 0.06211, 48, 12, 0, 1 },
	{ 0.10114, 0.32775, 0.06169, 48, 12, 24, 1 },
	{ 0.10114, 0.32775, 0.06064, 48, 12, 48, 1 },
	{ 0.10114, 0.32775, 0.05943, 48, 12, 72, 1 },
	{ 0.10114, 0.32775, 0.05847, 48, 12, 96, 1 },
	{ 0.10114, 0.32775, 0.05796, 48, 12, 120, 1 },
	{ 0.10114, 0.32775, 0.05782, 48, 12, 144, 1 },
	{ 0.10114, 0.32775, 0.05784, 48, 12, 168, 1 },
	{ 0.10114, 0.32775, 0.05785, 48, 12, 180, 1 },
	{ 0.10114, 0.31627, 0.07047, 48, 24, 0, 1 },
	{ 0.10114, 0.31627, 0.06925, 48, 24, 24, 1 },
	{ 0.10114, 0.31627, 0.06628, 48, 24, 48, 1 },
	{ 0.10114, 0.31627, 0.06333, 48, 24, 72, 1 },
	{ 0.10114, 0.31627, 0.06173, 48, 24, 96, 1 },
	{ 0.10114, 0.31627, 0.06176, 48, 24, 120, 1 },
	{ 0.10114, 0.31627, 0.06283, 48, 24, 144, 1 },
	{ 0.10114, 0.31627, 0.06382, 48, 24, 168, 1 },
	{ 0.10114, 0.31627, 0.06397, 48, 24, 180, 1 },
	{ 0.10114, 0.29517, 0.08277, 48, 36, 0, 1 },
	{ 0.10114, 0.29517, 0.07977, 48, 36, 24, 1 },
	{ 0.10114, 0.29517, 0.07454, 48, 36, 48, 1 },
	{ 0.10114, 0.29517, 0.06988, 48, 36, 72, 1 },
	{ 0.10114, 0.29517, 0.06848, 48, 36, 96, 1 },
	{ 0.10114, 0.29517, 0.07069, 48, 36, 120, 1 },
	{ 0.10114, 0.29517, 0.07503, 48, 36, 144, 1 },
	{ 0.10114, 0.29517, 0.07855, 48, 36, 168, 1 },
	{ 0.10114, 0.29517, 0.07907, 48, 36, 180, 1 },
	{ 0.10114, 0.26119, 0.10489, 48, 48, 0, 1 },
	{ 0.10114, 0.26119, 0.09383, 48, 48, 24, 1 },
	{ 0.10114, 0.26119, 0.0862, 48, 48, 48, 1 },
	{ 0.10114, 0.26119, 0.08045, 48, 48, 72, 1 },
	{ 0.10114, 0.26119, 0.08067, 48, 48, 96, 1 },
	{ 0.10114, 0.26119, 0.08769, 48, 48, 120, 1 },
	{ 0.10114, 0.26119, 0.09899, 48, 48, 144, 1 },
	{ 0.10114, 0.26119, 0.10801, 48, 48, 168, 1 },
	{ 0.10114, 0.26119, 0.10937, 48, 48, 180, 1 },
	{ 0.10114, 0.20975, 0.11884, 48, 60, 0, 1 },
	{ 0.10114, 0.20975, 0.11328, 48, 60, 24, 1 },
	{ 0.10114, 0.20975, 0.10344, 48, 60, 48, 1 },
	{ 0.10114, 0.20975, 0.09762, 48, 60, 72, 1 },
	{ 0.10114, 0.20975, 0.10167, 48, 60, 96, 1 },
	{ 0.10114, 0.20975, 0.11803, 48, 60, 120, 1 },
	{ 0.10114, 0.20975, 0.14325, 48, 60, 144, 1 },
	{ 0.10114, 0.20975, 0.16407, 48, 60, 168, 1 },
	{ 0.10114, 0.20975, 0.16725, 48, 60, 180, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 0, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 24, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 48, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 72, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 96, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 120, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 144, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 168, 1 },
	{ 0.10114, 0.26612, 0.06827, 60, 0, 180, 1 },
	{ 0.10114, 0.2632, 0.07138, 60, 12, 0, 1 },
	{ 0.10114, 0.2632, 0.07108, 60, 12, 24, 1 },
	{ 0.10114, 0.2632, 0.07042, 60, 12, 48, 1 },
	{ 0.10114, 0.2632, 0.06985, 60, 12, 72, 1 },
	{ 0.10114, 0.2632, 0.06981, 60, 12, 96, 1 },
	{ 0.10114, 0.2632, 0.07038, 60, 12, 120, 1 },
	{ 0.10114, 0.2632, 0.07125, 60, 12, 144, 1 },
	{ 0.10114, 0.2632, 0.07189, 60, 12, 168, 1 },
	{ 0.10114, 0.2632, 0.07198, 60, 12, 180, 1 },
	{ 0.10114, 0.25398, 0.0806, 60, 24, 0, 1 },
	{ 0.10114, 0.25398, 0.07937, 60, 24, 24, 1 },
	{ 0.10114, 0.25398, 0.07672, 60, 24, 48, 1 },
	{ 0.10114, 0.25398, 0.07469, 60, 24, 72, 1 },
	{ 0.10114, 0.25398, 0.07486, 60, 24, 96, 1 },
	{ 0.10114, 0.25398, 0.07755, 60, 24, 120, 1 },
	{ 0.10114, 0.25398, 0.08156, 60, 24, 144, 1 },
	{ 0.10114, 0.25398, 0.08458, 60, 24, 168, 1 },
	{ 0.10114, 0.25398, 0.08502, 60, 24, 180, 1 },
	{ 0.10114, 0.23704, 0.09599, 60, 36, 0, 1 },
	{ 0.10114, 0.23704, 0.09325, 60, 36, 24, 1 },
	{ 0.10114, 0.23704, 0.08737, 60, 36, 48, 1 },
	{ 0.10114, 0.23704, 0.08342, 60, 36, 72, 1 },
	{ 0.10114, 0.23704, 0.08467, 60, 36, 96, 1 },
	{ 0.10114, 0.23704, 0.09204, 60, 36, 120, 1 },
	{ 0.10114, 0.23704, 0.10308, 60, 36, 144, 1 },
	{ 0.10114, 0.23704, 0.11167, 60, 36, 168, 1 },
	{ 0.10114, 0.23704, 0.11293, 60, 36, 180, 1 },
	{ 0.10114, 0.20975, 0.11891, 60, 48, 0, 1 },
	{ 0.10114, 0.20975, 0.11335, 60, 48, 24, 1 },
	{ 0.10114, 0.20975, 0.1035, 60, 48, 48, 1 },
	{ 0.10114, 0.20975, 0.09767, 60, 48, 72, 1 },
	{ 0.10114, 0.20975, 0.1017, 60, 48, 96, 1 },
	{ 0.10114, 0.20975, 0.11806, 60, 48, 120, 1 },
	{ 0.10114, 0.20975, 0.14327, 60, 48, 144, 1 },
	{ 0.10114, 0.20975, 0.1641, 60, 48, 168, 1 },
	{ 0.10114, 0.20975, 0.16727, 60, 48, 180, 1 },
	{ 0.10114, 0.16844, 0.1597, 60, 60, 0, 1 },
	{ 0.10114, 0.16844, 0.14229, 60, 60, 24, 1 },
	{ 0.10114, 0.16844, 0.128, 60, 60, 48, 1 },
	{ 0.10114, 0.16844, 0.12075, 60, 60, 72, 1 },
	{ 0.10114, 0.16844, 0.13036, 60, 60, 96, 1 },
	{ 0.10114, 0.16844, 0.1631, 60, 60, 120, 1 },
	{ 0.10114, 0.16844, 0.21647, 60, 60, 144, 1 },
	{ 0.10114, 0.16844, 0.26459, 60, 60, 168, 1 },
	{ 0.10114, 0.16844, 0.27231, 60, 60, 180, 1 }};
#pragma endregion 
	int searchSolZen = 0, searchSenZen = 0, searchRelAzi = 0;
	int trueSolzen = 0, trueSenZen = 0, trueRelAzi = 0;
	int trueRow = 0;
	float minthereflectivity = 0, thereflectivity = 0;
	//int outTableCol = searchTabColCount ;    //ұ ұ87У8*7ұ40*7
	//int outTableRow = aod550Count * intervalCount;			//ұ
	//int inTableCol = searchTabColCount ;					//ұ
	//int inTableRow = aod550Count ;							//ұ
  /////////////////////////////////////////////////////////////////
	//2ұintable,outtable ,ΪµĲҵĲ
	//float** outTable = new	float*[outTableRow];
	//for (int i = 0; i < outTableRow; i++)
	//{
	//	outTable[i] = new float[outTableCol];
	//}
	//float** inTable = new	float*[inTableRow];//87
	//for (int i = 0; i < inTableRow; i++)
	//{
	//	inTable[i] = new float[inTableCol];
	//}

	//for (int i = 0; i < inTableRow; i++)
	//{
	//	for (int  j = 0; j < inTableCol; j++)
	//	{
	//		inTable[i][j] = 0.0;
	//	}

	//}
	//////////////////////////////////////////////////
	//
	for (int i = 0; i < height; i++)
	{
		for (int j = 0; j < width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				aodOptimal[i][j] = aodSumSearchTable[0][0];//ʼһ Ĭȸһֵ
				/*SearchOptimalResultFromOld(i, j, &trueRow);*/
				searchSolZen = solZenCount - 1, searchSenZen = senZenCount - 1, searchRelAzi = solAziCount -1;//Ĭֵ
				minthereflectivity = 1000000000;//minvalΪ㹻ֵ
				float devk1 = 0, devk2 = 0, devk3 = 0;
				float devkk1 = 0, devkk2, devkk3 = 0;
				for (int k = 0; k<solZenCount; k++)
					{
						if (solarzenith[i][j]<solZen[k])
						{
							searchSolZen = k;
							break;
						}
					}
				for (int k = 0; k<senZenCount; k++)
				{
					if (sensorzenith[i][j]<senZen[k])
					{
						searchSenZen = k;
						break;
					}
				}
				for (int k = 0; k<solAziCount; k++)
				{
					if ((relativeangel[i][j])<solAzi[k])
					{
						searchRelAzi = k;
						break;
					}
				}
				devk1 = solZen[searchSolZen] - solZen[searchSolZen - 1];
				devk2 = senZen[searchSenZen] - senZen[searchSenZen - 1];
				devk3 = solAzi[searchRelAzi] - solAzi[searchRelAzi - 1];
				if (solarzenith[i][j]>(solZen[searchSolZen - 1] + solZen[searchSolZen]) / 2)
				{
					devkk1 = abs (solarzenith[i][j] - solZen[searchSolZen]);
					trueSolzen = searchSolZen;
				}
				else
				{
					devkk1 = abs (solarzenith[i][j] - solZen[searchSolZen - 1]);
					trueSolzen = searchSolZen - 1;
				}
				if (sensorzenith[i][j]>(senZen[searchSenZen - 1] + senZen[searchSenZen]) / 2)
				{
					devkk2 = abs (sensorzenith[i][j] - senZen[searchSenZen]);
					trueSenZen = searchSenZen;
				}
				else
				{
					devkk2 = abs (sensorzenith[i][j] - senZen[searchSenZen - 1]);
					trueSenZen = searchSenZen - 1;
				}
				if (solarazimuth[i][j]>(solAzi[searchRelAzi - 1] + solAzi[searchRelAzi]) / 2)
				{
					devkk3 = abs (solarazimuth[i][j] - solAzi[searchRelAzi]);
					trueRelAzi = searchRelAzi;
				}
				else
				{
					devkk3 = abs (solarazimuth[i][j] - solAzi[searchRelAzi - 1]);
					trueRelAzi = searchRelAzi - 1;
				}
				//const int solZenCount = 8;
				//const int senZenCount = 7;
				//const int solAziCount = 9;
				//const int aod550Count = 6;
			
				trueRow = (senZenCount * solAziCount) * trueSolzen + (solAziCount) * trueSenZen + (1) * trueRelAzi;
#pragma region new 
	//			////intable ֵ
	//			//for (int i = 0; i < inTableRow; i++)
	//			//{
	//			//	for (int j = 0; j < inTableCol; j++)
	//			//	{
	//			//		inTable[i][j] = aodSumSearchTable[trueRow + i * solAziCount*senZenCount*solZenCount][j];
	//			//	}
	//			//}
	//			CreateNewSeachTable(inTable, outTable, inTableCol, inTableRow, outTableCol, outTableRow);
	//			aodOptimal[i][j] =SearchOptimalResultFromNew(i,j,outTable,outTableRow,outTableCol);
	//		}
	//	}
	//}



#pragma region 
#pragma region old
				double err[6] = { 0 };
				int pp = 0;
				while (trueRow<1944)
				{
					if (seasonDay > 90 && seasonDay <273)//ʹļұ
					{
						thereflectivity = aodSumSearchTable[trueRow][2] + aodSumSearchTable[trueRow][1] * suf_band_1[i][j] / (1 - aodSumSearchTable[trueRow][0] * suf_band_1[i][j]);
						 err[pp++] = fabs(thereflectivity - band_1[i][j]);
						if (fabs (thereflectivity - band_1[i][j])<fabs (minthereflectivity - band_1[i][j]))
						{
							minthereflectivity = thereflectivity;
							//aodOptimal[i][j] = aodSumSearchTable[trueRow][6];
						}
					}
					else //ұ
					{
						thereflectivity = aodWinSearchTable[trueRow][2] + aodWinSearchTable[trueRow][1] * suf_band_1[i][j] / (1 - aodWinSearchTable[trueRow][0] * suf_band_1[i][j]);
						err[pp++] = fabs(thereflectivity - band_1[i][j]);
						//if (fabs (thereflectivity - band_1[i][j])<fabs (minthereflectivity - band_1[i][j]))
						//{
						//	//minthereflectivity = thereflectivity;
						//	//aodOptimal[i][j] = aodWinSearchTable[trueRow][6];
						//}
					}
					trueRow += 324;
				}
				aodOptimal[i][j] = Mean(err, 6, aod550);
			}
		}
	}
#pragma endregion 

	//		if (seasonDay > 90 && seasonDay <273 )//ļ
	//		{
	//			//int num=omp_get_num_procs();
	//			//omp_set_num_threads(num);
	////#pragma omp parallel
	//			for ( int i=0;i<height;i++)
	//			{
	//				for ( int j=0;j<width;j++)
	//				{
	//					minthereflectivity =1000000;
	//					if (testresult[i][j]==anxiangyuan)
	//					{
	//						for (int k=0;k<3024;k++)
	//						{
	//							thereflectivity =aodSumSearchTable[k][2] + aodSumSearchTable[k][1] * suf_band_1[i][j] /(1- aodSumSearchTable[k][0] * suf_band_1[i][j]);
	//							if (fabs(thereflectivity-band_1[i][j])<fabs(minthereflectivity-band_1[i][j]))
	//							{
	//								minthereflectivity =thereflectivity;
	//								aodOptimal[i][j]=aodSumSearchTable[k][6];
	//							}
	//						}
	//					}
	//				}
	//			}
	//		}
	//		else
	//		{
	//			//int num=omp_get_num_procs();
	//			//omp_set_num_threads(num);
	//			//#pragma omp parallel
	//			for ( int i=0;i<height;i++)
	//			{
	//				for ( int j=0;j<width;j++)
	//				{
	//					minthereflectivity =1000000;
	//					if (testresult[i][j]==anxiangyuan)
	//					{
	//
	//						for (int k=0;k<3024;k++)
	//						{
	//
	//							thereflectivity =aodWinSearchTable[k][2] + aodWinSearchTable[k][1] * suf_band_1[i][j] /(1- aodWinSearchTable[k][0] * suf_band_1[i][j]);
	//							double a =fabs(thereflectivity-band_1[i][j]);
	//							double b =fabs(minthereflectivity-band_1[i][j]);
	//							if (a<b)
	//							{
	//								minthereflectivity =thereflectivity;
	//								aodOptimal[i][j]=aodWinSearchTable[k][6];
	//							}
	//						}
	//					}
	//				}
	//			}
	//
	//		}
}



void AODRectifyHeight ()
{
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				//aodOptimal[i][j] += 0.00877 * pow (0.55, -4.05) * (1 - exp (-500 / 8.5));
				aodOptimal[i][j] += 0;
			}
		}
	}
}
int ImageCut (const char* pszSrcFile, const char* pszDstFile, int iStartX, int iStartY, int iSizeX, int iSizeY,
	const char* pszFormat)
{
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *pSrcDS = (GDALDataset*)GDALOpen (pszSrcFile, GA_ReadOnly);
	GDALDataType eDT = pSrcDS->GetRasterBand (1)->GetRasterDataType ();

	int iBandCount = pSrcDS->GetRasterCount ();

	// ݲзΧȷкͼ
	int iDstWidth = iSizeX;
	int iDstHeight = iSizeY;

	double adfGeoTransform[6] = { 0 };
	pSrcDS->GetGeoTransform (adfGeoTransform);

	// кͼϽ	
	adfGeoTransform[0] = adfGeoTransform[0] + iStartX*adfGeoTransform[1] + iStartY*adfGeoTransform[2];
	adfGeoTransform[3] = adfGeoTransform[3] + iStartX*adfGeoTransform[4] + iStartY*adfGeoTransform[5];

	// ļÿռοϢ
	GDALDriver *poDriver = (GDALDriver *)GDALGetDriverByName (pszFormat);
	GDALDataset *pDstDS = poDriver->Create (pszDstFile, iDstWidth, iDstHeight, iBandCount, eDT, NULL);
	pDstDS->SetGeoTransform (adfGeoTransform);
	pDstDS->SetProjection (pSrcDS->GetProjectionRef ());

	int *pBandMap = new int[iBandCount];
	for (int i = 0; i<iBandCount; i++)
		pBandMap[i] = i + 1;

	// Ҫжϣ벻ͬ͵Ļд8bitͼʾ
	if (eDT == GDT_Float32)
	{
		// ҪĻ棬ͼ̫Ӧ÷ֿ鴦
		DT_32F *pDataBuff = new DT_32F[iDstWidth*iDstHeight*iBandCount];

		pSrcDS->RasterIO (GF_Read, iStartX, iStartY, iSizeX, iSizeY, pDataBuff, iSizeX, iSizeY, eDT, iBandCount, pBandMap, 0, 0, 0);
		pDstDS->RasterIO (GF_Write, 0, 0, iSizeX, iSizeY, pDataBuff, iSizeX, iSizeY, eDT, iBandCount, pBandMap, 0, 0, 0);

		RELEASE (pDataBuff);
	}
	else
	{
		// ͵ͼ8bitƣĻͲͬ
	}

	RELEASE (pBandMap);

	GDALClose ((GDALDatasetH)pSrcDS);
	GDALClose ((GDALDatasetH)pDstDS);
	return RE_SUCCESS;
}
/* double SortForBuf(double* buf ,int sizeOfBuf)
{
double temp ;
for (int i=0;i<sizeOfBuf;i++)
{
for (int j=i;j<sizeOfBuf;j++)
{
if (buf[i]>buf[j])
{
temp =buf[i];
buf[i]=buf[j];
buf[j]=temp;
}
}
}
temp =buf[sizeOfBuf/2];
return temp;
}*/
int cmp (const void *a, const void *b)
{
	return *(double *)a > *(double *)b ? 1 : -1;
}
int AODShow (const char* geolocDataFile, const char* midFile, const char* spapceFilerFile, const char* dstFile)
{
	if (geolocDataFile == NULL || midFile == NULL || spapceFilerFile == NULL || dstFile == NULL)
	{
		return RE_PARAMERROR;
	}
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DSData = (GDALDataset*)GDALOpen (geolocDataFile, GA_ReadOnly);
	if (DSData == NULL)
	{
		return RE_FILENOTSUPPORT;
	}
	double geoTransform[6] = { 0 };
	DSData->GetGeoTransform (geoTransform);
	//int xSize =DSData->GetRasterXSize();
	//int ySize =DSData->GetRasterYSize();
#pragma endregion 
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	GDALDataset *DSMid = Driver->Create (midFile, width, height, 1, GDT_Float32, NULL);
	DSMid->SetProjection (DSData->GetProjectionRef ());
	DSMid->SetGeoTransform (geoTransform);
#pragma region дļرݼ
	//DT_64F *pBuf = (DT_64F*)malloc(sizeof(DT_64F)* width	* height);
	DT_32F *pBuf = new DT_32F[width*height];
	int p = 0;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				pBuf[p] = aodOptimal[i][j];
			}
			else
			{
				pBuf[p] = 0.0;
			}
			p++;

		}
	}
	//
	/*FILE *fp11;
	if (fp11 = fopen ("e:\\test\\apbufaodoptimal.txt", "wt+"))
	{
		for (int i = 0; i<height; i++)
		{
			for (int j = 0; j<width; j++)
			{

				fprintf (fp11, "%8.2lf\t", aodOptimal[i][j] * 1000);
			}
			fprintf (fp11, "\n");
		}

	}
	fclose (fp11);*/


	//FILE *fp12;
	//if (fp12 = fopen ("e:\\test\\apbufaodbuf.txt", "wt+"))
	//{
	//	for (int i = 0; i<width*height; i++)
	//	{
	//		if (i%width == 0)
	//		{
	//			fprintf (fp12, "\n");
	//		}
	//		else
	//		{
	//			fprintf (fp12, "%8.2lf\t", pBuf[i]);
	//		}
	//	}
	//}
	//fclose (fp12);

	DSMid->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, width, height, pBuf, width, height, GDT_Float32, 0, 0);
	//delete[]pBuf;
	RELEASE(pBuf);
	GDALClose (GDALDatasetH (DSData));
	GDALClose (GDALDatasetH (DSMid));

#pragma endregion 
	//ULLON='107.096';人
	// ULLAT='34.03'
	// LRLON='117.233'
	// LRLAT='27.177'



	//	ULLON='112.991';Ŀо
	//		ULLAT='43.81'
	//	LRLON='125.912'
	//	LRLAT='34.126'
	double	lonmin = 98.0083;
	double lonmax = 112.0083;
	//double latmin =34.126; //34.0708
	double latmin = 24.0068;
	double latmax = 35.0030;
	//
	//double	lonmin = 120;
	//double lonmax = 130;
	////double latmin =34.126; //34.0708
	//double latmin = 38;
	//double latmax = 47;
	double startX, startY, endX, endY;
	startX = 0; startY = 0; endX = width; endY = height;
	bool flagStartX = false, flagStartY = false, flagEndX = false, flagEndY = false;
	double lon, lat;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			lon = geoTransform[0] + geoTransform[1] * j + geoTransform[2] * i;
			lat = geoTransform[3] + geoTransform[4] * j + geoTransform[5] * i;
			/*if (flagStartX == false && lon >lonmin)
			{
				startX = j;
				flagStartX = true;
			}
			if (flagStartY == false && lat<latmax)
			{
				startY = i ;
				flagStartY = true;
			}
			if (flagEndX == false && lon>lonmax)
			{
				endX = j;
				flagEndX = true;
			}
			if (flagEndY == false && lat<latmin)
			{
				endY = i;
				flagEndY = true;
			}*/
			if (!flagStartX && lon >lonmin)
			{
				startX = j;
				flagStartX = true;
			}
			if (!flagStartY && lat<latmax)
			{
				startY = i ;
				flagStartY = true;
			}
			if (!flagEndX&& lon>lonmax)
			{
				endX = j;
				flagEndX = true;
			}
			if (!flagEndY && lat<latmin)
			{
				endY = i;
				flagEndY = true;
			}
		}
		if (flagStartX && flagStartY && flagEndX && flagEndY)
		{
			break;
		}
	}
	int imageCutResult = ImageCut (midFile, spapceFilerFile, startX, startY, endX - startX , endY - startY , "GTiff");
	if (imageCutResult != RE_SUCCESS)
	{
		return imageCutResult;
	}
	//int template3_3[9]={0,1,0,1,-4,1,0,1,0};
	GDALDataset *FilDs = (GDALDataset*)GDALOpen (spapceFilerFile, GA_ReadOnly);
	int xSize = FilDs->GetRasterXSize ();
	int ySize = FilDs->GetRasterYSize ();
	FilDs->GetGeoTransform (geoTransform);
	GDALDataset *DstDS = Driver->Create (dstFile, xSize, ySize, 1, GDT_Float32, NULL);
	DstDS->SetGeoTransform (geoTransform);
	DstDS->SetProjection (FilDs->GetProjectionRef ());

	//DT_64F *pBuf1 = (DT_64F*)malloc(sizeof(DT_64F)*xSize * ySize);
	DT_32F *pBuf1 = new DT_32F[xSize*ySize];
	FilDs->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf1, xSize, ySize, GDT_Float32, 0, 0);
	DT_32F **pBuf2, **pBuf3;
	pBuf2 = new float*[ySize];
	pBuf3 = new float*[ySize];
	for (int i = 0; i<ySize; i++)
	{
		pBuf2[i] = new float[xSize];
		pBuf3[i] = new float[xSize];
	}
	p = 0;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			pBuf2[i][j] = pBuf1[p++];
			//pBuf3[i][j]=0.0;
		}
	}

	////pBuf2鿴
	//FILE *fp;
	//if (fp=fopen("e:\\test\\apbuf2.txt","wt+"))
	//{
	//	for ( int i=0;i<ySize;i++)  
	//	{
	//		for ( int j=0;j<xSize;j++)
	//		{
	//			fprintf(fp,"%8.2lf\t",pBuf2[i][j]);
	//		}	
	//		fprintf(fp,"\n");
	//	}
	//}
	//fclose(fp);
#pragma region ֵ



	int nodataCount = 0;
	int top = 1;
	int ang = 1;
	int center = 2;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			nodataCount = 0;
			if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
			{
				pBuf3[i][j] = pBuf2[i][j];
			}
			else
			{
				if (pBuf2[i - 1][j - 1] == 0.0)nodataCount++;
				if (pBuf2[i - 1][j + 1] == 0.0)nodataCount++;
				if (pBuf2[i + 1][j - 1] == 0.0)nodataCount++;
				if (pBuf2[i + 1][j + 1] == 0.0)nodataCount++;

				if (pBuf2[i][j - 1] == 0.0)nodataCount += top;
				if (pBuf2[i][j + 1] == 0.0)nodataCount += top;
				if (pBuf2[i - 1][j] == 0.0)nodataCount += top;
				if (pBuf2[i + 1][j] == 0.0)nodataCount += top;
				if (pBuf2[i][j] == 0.0)nodataCount += top;
				int all = 4 * top + ang * 4 + center;
				if (nodataCount == 4 * top + ang * 4 + center)
				{
					pBuf3[i][j] = 0.0;
				}
				else
				{
					pBuf3[i][j] = (pBuf2[i - 1][j] * top + pBuf2[i + 1][j] * top + pBuf2[i][j - 1] * top + pBuf2[i][j + 1] * top + pBuf2[i][j] * center + pBuf2[i - 1][j - 1]*ang + pBuf2[i - 1][j + 1]*ang + pBuf2[i + 1][j - 1]*ang + pBuf2[i + 1][j + 1] *ang) / (all - nodataCount);
				}
			}
		}
	}
	//for (int i = 0; i<ySize; i++)
	//{
	//	for (int j = 0; j<xSize; j++)
	//	{
	//		nodataCount = 0;
	//		if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
	//		{
	//			pBuf2[i][j] = pBuf3[i][j];
	//		}
	//		else
	//		{
	//			if (pBuf3[i - 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf3[i - 1][j + 1] == 0.0)nodataCount++;
	//			if (pBuf3[i + 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf3[i + 1][j + 1] == 0.0)nodataCount++;

	//			if (pBuf3[i][j - 1] == 0.0)nodataCount += top;
	//			if (pBuf3[i][j + 1] == 0.0)nodataCount += top;
	//			if (pBuf3[i - 1][j] == 0.0)nodataCount += top;
	//			if (pBuf3[i + 1][j] == 0.0)nodataCount += top;
	//			if (pBuf3[i][j] == 0.0)nodataCount += center;
	//			int all = 4 * top + ang * 4 + center;
	//			if (nodataCount == 16)
	//			{
	//				pBuf2[i][j] = 0.0;
	//			}
	//			else
	//			{
	//				pBuf2[i][j] = (pBuf3[i - 1][j] * top + pBuf3[i + 1][j] * top + pBuf3[i][j - 1] * top + pBuf3[i][j + 1] * top + pBuf3[i][j] * center + pBuf3[i - 1][j - 1]*ang + pBuf3[i - 1][j + 1]*ang + pBuf2[i + 1][j - 1]*ang + pBuf2[i + 1][j + 1]* ang) / (all - nodataCount);
	//			}
	//		}
	//	}
	//}
	//for (int i = 0; i<ySize; i++)
	//{
	//	for (int j = 0; j<xSize; j++)
	//	{
	//		nodataCount = 0;
	//		if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
	//		{
	//			pBuf3[i][j] = pBuf2[i][j];
	//		}
	//		else
	//		{
	//			if (pBuf2[i - 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf2[i - 1][j + 1] == 0.0)nodataCount++;
	//			if (pBuf2[i + 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf2[i + 1][j + 1] == 0.0)nodataCount++;

	//			if (pBuf2[i][j - 1] == 0.0)nodataCount += top;
	//			if (pBuf2[i][j + 1] == 0.0)nodataCount += top;
	//			if (pBuf2[i - 1][j] == 0.0)nodataCount += top;
	//			if (pBuf2[i + 1][j] == 0.0)nodataCount += top;
	//			if (pBuf2[i][j] == 0.0)nodataCount += top;
	//			int all = 4 * top + ang * 4 + center;
	//			if (nodataCount == 4 * top + ang * 4 + center)
	//			{
	//				pBuf3[i][j] = 0.0;
	//			}
	//			else
	//			{
	//				pBuf3[i][j] = (pBuf2[i - 1][j] * top + pBuf2[i + 1][j] * top + pBuf2[i][j - 1] * top + pBuf2[i][j + 1] * top + pBuf2[i][j] * center + pBuf2[i - 1][j - 1] * ang + pBuf2[i - 1][j + 1] * ang + pBuf2[i + 1][j - 1] * ang + pBuf2[i + 1][j + 1] * ang) / (all - nodataCount);
	//			}
	//		}
	//	}
	//}

#pragma endregion
	//int avgSize =5;
	//int borderSize ;
	//double *pBuf4 =new double[avgSize*avgSize];
	//for (int i=0;i<ySize;i++)
	//{
	//	for( int j=0;j<xSize;j++)
	//	{
	//		borderSize =(int)avgSize/2;
	//		if (i<borderSize|| i>ySize-borderSize-1 || j<borderSize || j>xSize-borderSize-1)//߽粻 5*5
	//		{
	//			pBuf3[i][j]=pBuf2[i][j];
	//		}
	//		else	//ȡֵ
	//		{
	//			       p =0;
	//				for ( int ii=i-borderSize;ii<=i+borderSize;ii++)
	//				{
	//					for (int jj=j-borderSize;jj<=j+borderSize;jj++)
	//					{
	//						pBuf4[p]=pBuf2[ii][jj];
	//						p++;
	//					}
	//				}
	//			//pbuf4ȡֵ				
	//			qsort(pBuf4,avgSize*avgSize,sizeof(pBuf4[0]),cmp);
	//			pBuf3[i][j]=pBuf4[avgSize*avgSize/2];
	//		}

	//	}
	//}
	//pBuf3鿴
	/*FILE *fp3;
	if (fp3=fopen("e:\\test\\apbuf3.txt","wt+"))
	{
	for ( int i=0;i<ySize;i++)
	{
	for ( int j=0;j<xSize;j++)
	{

	fprintf(fp3,"%8.2lf\t",pBuf3[i][j]);

	}
	fprintf(fp3,"\n");
	}

	}
	fclose(fp3);*/


	//////////////////////////////////////////////////////////////////////////
	p = 0;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			if (pBuf3[i][j]<0)
				/*if(pBuf2[i][j]<0)*/
			{
				pBuf1[p] = 0.0;
			}
			else
			{
				pBuf1[p] = pBuf3[i][j];
				//pBuf1[p] =pBuf2[i][j];
			}
			p++;
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf1, xSize, ySize, GDT_Float32, 0, 0);
	GDALSetRasterNoDataValue (GDALGetRasterBand (GDALDatasetH (DstDS), 1), 0.0);
	for (int i = 0; i<ySize; i++)
	{
		RELEASE (pBuf2[i]);
		RELEASE (pBuf3[i]);
		//delete []pBuf3[i];
	}
	//		delete []pBuf4;
	//delete []pBuf1;
	RELEASE (pBuf2);
	RELEASE (pBuf3);
	RELEASE (pBuf1);
	GDALClose (GDALDatasetH (FilDs));
	GDALClose (GDALDatasetH (DstDS));
	return RE_SUCCESS;
}
int AODInversion (const char* pszSrcFile2, const char* pszSrcFile3, const char* pszDstFile, int deleteFile)
{
#pragma region 1.modis2лȡļ
	string tempFileName = string (CPLGetFilename (pszSrcFile2));
	tempFileName = tempFileName.substr (0, tempFileName.find_last_of ("hdf") - 21);
	string tempPath = string (CPLGetPath (pszSrcFile2));
	tempFileName = tempPath + "\\" + tempFileName;
	string tempCreateDataFile = tempFileName + "_data.tif";//ѧݼļ
	string tempCreateAngelFile = tempFileName + "_angel.tif";//Ƕݼļ
	string tempGeolocDataFile = tempFileName + "_geolocdata.tif";//ѧݼļ
	string tempGeolocAngelFile = tempFileName + "_geolocangel.tif";//Ƕݼļ
	string tempCloudFile = tempFileName + "_cloud.tif";//ļ
	string tempWaterFile = tempFileName + "_water.tif";//ˮļ
	string tempDarkPixelFile = tempFileName + "_darkpixel.tif";//Ԫļ
	string tempCutFile = tempFileName + "_cutimage.tif";//üָ
	//string tempImageCutFile =tempFileName + "d";//ü
	string tempSpaceFilter = tempFileName + "_spacefilter.tif";//ռ˲
#pragma endregion 		
#pragma region 2.ѧݼͽǶݼĺϳ
	//printf ("ʼѧݼͽǶݼĺϳ...\n");
	int createDataResult = AODCreateData (pszSrcFile2, pszSrcFile3, tempCreateDataFile.c_str ());//ϳɿѧݼ
	if (createDataResult != RE_SUCCESS)
	{
		return createDataResult;
	}
	int createAngelResult = AODCreateAngel (pszSrcFile2, pszSrcFile3, tempCreateAngelFile.c_str ());//ϳɵĽǶݼ
	if (createAngelResult != RE_SUCCESS)
	{
		return createAngelResult;
	}


#pragma endregion
#pragma region 3.ȡmodis3ĽϢ
	//char** geolocOptions=NULL;
	//geolocOptions = new char*[8];
	//for (int i=0;i<8;i++)
	//{
	//	geolocOptions[i]=new char[50];
	//}
	////char geolocOptions[8][50]={0};
	//int getGeolocResult =AODGetGeolocOfModis3(pszSrcFile3,&geolocOptions);
	//if (getGeolocResult!=RE_SUCCESS)
	//{
	//	return getGeolocResult;
	//}
#pragma region 3.1עݼ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS3 = (GDALDataset*)GDALOpen (pszSrcFile3, GA_ReadOnly);
	char **subdatasets = GDALGetMetadata ((GDALDatasetH)DS3, "SUBDATASETS");
#pragma endregion
#pragma region 3.2ȡγݼ͵һݼ
	string strSubDataset_1 = string (subdatasets[0]);//һݼ
	strSubDataset_1 = strSubDataset_1.substr (strSubDataset_1.find_first_of ("=") + 1);
	const char* SrcFile3_1 = strSubDataset_1.c_str ();

	string strLat = string (subdatasets[24]);//lat
	strLat = strLat.substr (strLat.find_first_of ("=") + 1);
	const char* charLat = strLat.c_str ();

	string strLon = string (subdatasets[26]);//lon
	strLon = strLon.substr (strLon.find_first_of ("=") + 1);
	const char* charLon = strLon.c_str ();
#pragma endregion 
#pragma region 3.3ȡһݼgeoloc
	GDALDataset *DS3_1 = (GDALDataset*)GDALOpen (SrcFile3_1, GA_ReadOnly);
	char **geolocOptions3 = DS3_1->GetMetadata ("GEOLOCATION");
	char **geolocOptions = geolocOptions3;
	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
	if (geolocOptions3 == NULL)
	{
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_OFFSET", "0");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_OFFSET", "0");
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "X_BAND", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "Y_BAND", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "X_DATASET", charLon);
		geolocOptions = CSLSetNameValue (geolocOptions, "Y_DATASET", charLat);
	}
	else
	{
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
	}
	GDALClose (GDALDatasetH (DS3));
#pragma endregion 	
#pragma endregion
#pragma region ѧݼͽǶݼ
	//printf ("ʼѧݼͽǶݼ...\n");
	const char* fileFormat = "GTiff";
	int geolocDataResult = ImageWarpByGeoLoc (tempCreateDataFile.c_str (), tempGeolocDataFile.c_str (), geolocOptions, GRA_NearestNeighbour, fileFormat);
	if (geolocDataResult != RE_SUCCESS)
	{
		return geolocDataResult;
	}
	int geolocAngelResult = ImageWarpByGeoLoc (tempCreateAngelFile.c_str (), tempGeolocAngelFile.c_str (), geolocOptions, GRA_NearestNeighbour, fileFormat);
	if (geolocAngelResult != RE_SUCCESS)
	{
		return geolocAngelResult;
	}
	////////////////////////////////////////////////////////////////////////////////////////////////////
		GDALClose(GDALDatasetH(DS3_1));//رݼ
#pragma endregion
#pragma region ʼ
	//printf ("ʼaodݼ...\n");
	AODInitialize (tempGeolocDataFile.c_str (), tempGeolocAngelFile.c_str ());
#pragma endregion
#pragma region ȡ
	AODGetSeason (pszSrcFile2);
#pragma endregion 
#pragma region ȥƺˮ
	AODIdentifyCloudAndWater ();
#pragma endregion
#pragma region ȷر
	AODConfirmSurfaceReflectance ();
#pragma endregion
#pragma region AODļ
	AODCalculate ();
#pragma endregion
#pragma region ߶Ƚ
	AODRectifyHeight ();
	
#pragma endregion
#pragma region AOD
	int aodShowResult = AODShow (tempGeolocDataFile.c_str (), tempCutFile.c_str (), tempSpaceFilter.c_str (), pszDstFile);
	if (aodShowResult != RE_SUCCESS)
	{
		return aodShowResult;
	}
	//ULLON='107.096';人
	// ULLAT='34.03'
	// LRLON='117.233'
	// LRLAT='27.177'
	/* double lonlat[4]= {107.096,117.233,27.177,24.03};
	int startX,startY,XSize,YSize;
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8","NO");
	GDALDataset *SrcDS =(GDALDataset*)GDALOpen(pszDstFile,)
	for (int i=0;i<height;i++)
	{
	for ( int j=0;j<width;j++)
	{
	if ()
	{
	}
	}
	}
	int aodImageCutResult =ImageCut(pszDstFile,tempImageCutFile.c_str(),startX,startY,XSize,YSize,"GTiff");
	if (aodImageCutResult!=RE_SUCCESS)
	{
	return aodImageCutResult;
	}*/
#pragma endregion
#pragma region мļɾ
	if (deleteFile == 0)
	{
		remove (tempCreateDataFile.c_str ());//ļ
		remove (tempCreateAngelFile.c_str ());//Ƕļ
		remove (tempGeolocDataFile.c_str ());//ļ
		remove (tempGeolocAngelFile.c_str ());//ĽǶļ
	}
	else if (deleteFile == 1)
	{

		AODOutputOther (tempGeolocDataFile.c_str (), tempCloudFile.c_str (), yun);
		AODOutputOther (tempGeolocDataFile.c_str (), tempWaterFile.c_str (), shui);
		AODOutputOther (tempGeolocDataFile.c_str (), tempDarkPixelFile.c_str (), anxiangyuan);
		remove (tempCreateDataFile.c_str ());//ļ
		remove (tempCreateAngelFile.c_str ());//Ƕļ
		remove (tempGeolocAngelFile.c_str ());//ĽǶļ
		remove(tempGeolocDataFile.c_str());
		remove(tempCloudFile.c_str());
		remove(tempWaterFile.c_str());
		remove(tempDarkPixelFile.c_str());
		remove(tempCutFile.c_str());
		remove(tempSpaceFilter.c_str());
		
		
		//tempCutFile.c_str (), tempSpaceFilter.c_str ()

	}
#pragma endregion 
#pragma region ͷԴ
	AODDestroy ();
#pragma endregion
	return RE_SUCCESS;
}
void PMGetSeason (const char* SrcFile2)
{
	//"E:\\fire2\\firetest\\MOD279\\0220\\MOD021KM.A2014279.0220.006.2014283045932.hdf";
	//AOD.MYD021KM.A2014279.0535.006.TIF
	string tempFileName = string (CPLGetFilename (SrcFile2));
	tempFileName = tempFileName.substr (tempFileName.find_last_of ("tif") - 15, 3);
	seasonDay = (double)CPLScanDouble (tempFileName.c_str (), 20);
}
int PM25Inversion (const char* pszAodFile, const char* pszDstFile, double ha, double rh)
{
	//AOD.MOD021KM.A2014195.0245.006.tif
	//const char* pszTempFile ="e:\\test\01060315.tif";
	//ha,rhж
	PMGetSeason(pszAodFile);
	//seasonDay = 6;

	if (ha == -1)
	{
		if (seasonDay>90 && seasonDay <273)
		{
			ha = 0.8;
		}
		else
		{
			ha = 0.5;
		}
	}
	if (rh == -1)
	{
		rh = 63;
	}

	//ݼȡϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen (pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize ();
	int YSize = AODDS->GetRasterYSize ();
	GDALDataType dataType = AODDS->GetRasterBand (1)->GetRasterDataType ();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform (geoTransForm);
	//̬
	//float **pmkadry;
	float **pmdata;
	float **pmresult;
	//pmkadry = new double*[YSize];
	pmdata = new float*[YSize];
	pmresult = new float*[YSize];
	for (int i = 0; i<YSize; i++)
	{
		//pmkadry[i] = new double[XSize];
		pmdata[i] = new float[XSize];
		pmresult[i] = new float[XSize];
	}
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	int p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pmdata[i][j] = pBuf[p++] / 1000.0;
		}
	}
	//ϵ
	float aa = 28.981, bb = 18.1999;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			if (fabs(pmdata[i][j] -0.0) < MIN_VALUE)
			{
				pmresult[i][j] = 0.0;
			}
			else
			{
				pmresult[i][j] = (pmdata[i][j] * ha / (1 - rh / 100.0)) * aa + bb;
			}
			
		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	//
	//GDALDriver *Driver2 = (GDALDriver*)GDALGetDriverByName ("GTiff");
	//GDALDataset *tempDstDS =Driver->Create(pszTempFile,XSize,YSize,1,dataType,NULL);
	GDALDataset *DstDS = Driver->Create (pszDstFile, XSize, YSize, 1, dataType, NULL);
	DstDS->SetGeoTransform (geoTransForm);
	//
	//tempDstDS->SetGeoTransform(geoTransForm);
	//tempDstDS->SetProjection(AODDS->GetProjectionRef());
	DstDS->SetProjection (AODDS->GetProjectionRef ());
	GDALSetRasterNoDataValue (GDALGetRasterBand (GDALDatasetH (DstDS), 1), 0.0);
	//		GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(tempDstDS),1),0.0);
	p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			  pBuf[p++]=pmresult[i][j];
			//pBuf[p++] = pmkadry[i][j];
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//
	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
	RELEASE(pBuf);
	GDALClose ((GDALDatasetH)DstDS);
	GDALClose ((GDALDatasetH)AODDS);
	//GDALClose((GDALDatasetH)tempDstDS);
	for (int i = 0; i<YSize; i++)
	{
		//RELEASE(pmkadry[i]);
		RELEASE(pmdata[i]);
		RELEASE(pmresult[i]);
	}
	//RELEASE(pmkadry);
	RELEASE(pmdata);
	RELEASE(pmresult);
	return RE_SUCCESS;
}
int PM10Inversion(const char* pszAodFile, const char* pszDstFile, double ha, double rh)
{
	//AOD.MOD021KM.A2014195.0245.006.tif
	//const char* pszTempFile ="e:\\test\01060315.tif";
	//ha,rhж
	PMGetSeason(pszAodFile);
	//seasonDay = 6;

	if (ha == -1)
	{
		if (seasonDay>90 && seasonDay <273)
		{
			ha = 0.8;
		}
		else
		{
			ha = 0.5;
		}
	}
	if (rh == -1)
	{
		rh = 63;
	}

	//ݼȡϢ
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen(pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize();
	int YSize = AODDS->GetRasterYSize();
	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform(geoTransForm);
	//̬
	//float **pmkadry;
	float **pmdata;
	float **pmresult;
	//pmkadry = new double*[YSize];
	pmdata = new float*[YSize];
	pmresult = new float*[YSize];
	for (int i = 0; i<YSize; i++)
	{
		//pmkadry[i] = new double[XSize];
		pmdata[i] = new float[XSize];
		pmresult[i] = new float[XSize];
	}
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	int p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pmdata[i][j] = pBuf[p++] / 1000.0;
		}
	}
	//ϵ
	float aa = 38.686, bb = 41.294;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			if (fabs(pmdata[i][j] - 0.0) < MIN_VALUE)
			{
				pmresult[i][j] = 0.0;
			}
			else
			{
				pmresult[i][j] = (pmdata[i][j] * ha / (1 - rh / 100.0)) * aa + bb;
			}

		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
	//
	//GDALDriver *Driver2 = (GDALDriver*)GDALGetDriverByName("GTiff");
	//GDALDataset *tempDstDS =Driver->Create(pszTempFile,XSize,YSize,1,dataType,NULL);
	GDALDataset *DstDS = Driver->Create(pszDstFile, XSize, YSize, 1, dataType, NULL);
	DstDS->SetGeoTransform(geoTransForm);
	//
	//tempDstDS->SetGeoTransform(geoTransForm);
	//tempDstDS->SetProjection(AODDS->GetProjectionRef());
	DstDS->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS), 1), 0.0);
	//		GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(tempDstDS),1),0.0);
	p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pBuf[p++] = pmresult[i][j];
			//pBuf[p++] = pmkadry[i][j];
		}
	}
	DstDS->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//
	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
	RELEASE(pBuf);
	GDALClose((GDALDatasetH)DstDS);
	GDALClose((GDALDatasetH)AODDS);
	//GDALClose((GDALDatasetH)tempDstDS);
	for (int i = 0; i<YSize; i++)
	{
		//RELEASE(pmkadry[i]);
		RELEASE(pmdata[i]);
		RELEASE(pmresult[i]);
	}
	//RELEASE(pmkadry);
	RELEASE(pmdata);
	RELEASE(pmresult);
	return RE_SUCCESS;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
int Haze(const char* pszAodFile, const char* pszDstFile1 , const char* pszDstFile2)
{

	enum MySeasonType
	{
		unknow = 0,
		spring = 1,
		summer = 2,
		autumn = 3,
		winter = 4

	};
	MySeasonType myseason; 
	////////////////////////////////////////////////////////////////////////////////////////////////////
	const float chengmi_spring_a = 4.9704, chengmi_spring_b = - 0.68;
	const float chengmi_summer_a = 5.323,  chengmi_summer_b = -0.9902;
	const float chengmi_autumn_a = 4.5399, chengmi_autumn_b = -0.568;
	const float chengmi_winter_a = 2.9976, chengmi_winter_b = -0.557;

	const float biaogao_spring_a = 0.8132, biaogao_spring_b = -0.2214;
	const float biaogao_summer_a = 0.7669, biaogao_summer_b = -0.4898;
	const float biaogao_autumn_a = 0.7402, biaogao_autumn_b = -0.1166;
	const float biaogao_winter_a = 0.3682, biaogao_winter_b = -0.2144;
///////////////////////////////////////////////////////////////////////////////////////////////////////
	float chengmi_a, chengmi_b;   //a ϵ4.9704 bη //ݷabϵ
	float biaogao_a, biaogao_b; // ߷abϵa(0.8132) b0.2214
	/*
	Spring summer and autumn winter
				ݷ
	ڣ		v =4.9704 *^(-0.68)
	ڣļ		v =5.323  *^(-0.902)
	ڣ＾		v =4.5399 *^(-0.568)
	ڣ   	v =2.9976 *^(-0.557)
	*/
	
	/*
				߷
		V=3.1912*0.8132/(-0.2214)
	ļ	V=3.1912*0.7669/(-0.4898)
	＾	V=3.1912*0.7402/(-0.1166)
		V=3.1912*0.0.3682/(-0.2144)

	*/
	/*
	

	    V<=1km    RH>95%

	   1km<v<10km  RH>95%

	ϼ    v<10km    80%<RH<95%
		V<10km     RH<80%
	//////////////////////////////////////////
	΢      5.0<=v<10
	      3.0<=V<5.0
	ж      2.0<=V<3.0
	ض       V<2.0

	*/
	//PMGetSeason(pszAodFile);
	if (seasonDay >= 60 && seasonDay < 152)
	{
		myseason = spring;
		chengmi_a = chengmi_spring_a;
		chengmi_b = chengmi_spring_b;
		biaogao_a = biaogao_spring_a;
		biaogao_b = biaogao_spring_b;
	}
	else if (seasonDay >= 152 && seasonDay < 244)
	{
		myseason = summer;
		chengmi_a = chengmi_summer_a;
		chengmi_b = chengmi_summer_b;
		biaogao_a = biaogao_summer_a;
		biaogao_b = biaogao_summer_b;

	}
	else if (seasonDay >= 244 && seasonDay < 335)
	{
		myseason = autumn;
		chengmi_a = chengmi_autumn_a;
		chengmi_b = chengmi_autumn_b;
		biaogao_a = biaogao_autumn_a;
		biaogao_b = biaogao_autumn_b;
	}
	else 
	{
		myseason = winter;
		chengmi_a = chengmi_winter_a;
		chengmi_b = chengmi_winter_b;
		biaogao_a = biaogao_winter_a;
		biaogao_b = biaogao_winter_b;
	}
	//
	////////////////////////////////
	//myseason = summer; 
	//a = 5.323;
	//b = -0.902;
	//a = 0.7669;//
	//b = 0.4898;//

	
	myseason = spring;
	chengmi_a = chengmi_spring_a;
	chengmi_b = chengmi_spring_b;
	biaogao_a = biaogao_spring_a;
	biaogao_b = biaogao_spring_b;
	
	/*myseason = summer;
	chengmi_a = chengmi_summer_a;
	chengmi_b = chengmi_summer_b;
	biaogao_a = biaogao_summer_a;
	biaogao_b = biaogao_summer_b;*/
		////////////////////////////////
	//ݼȡϢ
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen(pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize();
	int YSize = AODDS->GetRasterYSize();
	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform(geoTransForm);
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	
	//߽
	/*
			V = 3.1912*0.8132 / ( - 0.2214)
		ļ	V = 3.1912*0.7669 / ( - 0.4898)
		＾	V = 3.1912*0.7402 / ( - 0.1166)
			V = 3.1912*0.0.3682 / ( - 0.2144)
		*/
	for (int i = 0; i < XSize*YSize; i++)
	{
		if (pBuf[i]< MIN_VALUE && pBuf[i] > -MIN_VALUE) //nodata
		{
			pBuf[i] = 0;
		}
		else
		{
			pBuf[i] = 3.912* biaogao_a / (pBuf[i]- biaogao_b);
			if (pBuf[i]< 0) 
			{
				pBuf[i] = 15;
			}
			else if (pBuf[i] >15)
			{
				pBuf[i] = 15;
			}
		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
	GDALDataset *DstDS1 = Driver->Create(pszDstFile1, XSize, YSize, 1, dataType, NULL);
	GDALDataset *DstDS2 = Driver->Create(pszDstFile2, XSize, YSize, 1, dataType, NULL);
	DstDS1->SetGeoTransform(geoTransForm);
	DstDS1->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS1), 1), 0.0);
	DstDS1->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);



	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//ݽ
	/*
	    ڣ		v = 4.9704 *t ^ (-0.68)
		ڣļ		v = 5.323  *t ^ (-0.902)
		ڣ＾		v = 4.5399 *t ^ (-0.568)
		ڣ   	v = 2.9976 *t ^ (-0.557)
		*/
	for (int i = 0; i < XSize*YSize; i++)
	{
		if (pBuf[i]< MIN_VALUE && pBuf[i] > -MIN_VALUE) //nodata
		{
			pBuf[i] = 0;
		}
		else
		{
			pBuf[i] = chengmi_a * pow(pBuf[i] , chengmi_b);
			if (pBuf[i]< 0) 
			{
				pBuf[i] = 15;
			}
			else if (pBuf[i] >15)
			{
				pBuf[i] = 15;
			}
		}
	}

	DstDS2->SetGeoTransform(geoTransForm);
	DstDS2->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS2), 1), 0.0);
	DstDS2->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	RELEASE(pBuf);
	GDALClose((GDALDatasetH)DstDS1);
	GDALClose((GDALDatasetH)DstDS2);
	GDALClose((GDALDatasetH)AODDS);
	return RE_SUCCESS;
}



//int FillingEmptyValue(const char* inFile, const char* outFile)
//{
//	GDALAllRegister();
//	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
//	GDALDataset *AODDS = (GDALDataset*)GDALOpen(inFile, GA_ReadOnly);
//	int XSize = AODDS->GetRasterXSize();
//	int YSize = AODDS->GetRasterYSize();
//	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
//	double geoTransForm[6] = { 0 };
//	AODDS->GetGeoTransform(geoTransForm);
//	float **pmdata;
//	float **pmresult;
//	//pmkadry = new double*[YSize];
//	pmdata = new float*[YSize];
//	pmresult = new float*[YSize];
//	for (int i = 0; i<YSize; i++)
//	{
//		//pmkadry[i] = new double[XSize];
//		pmdata[i] = new float[XSize];
//		pmresult[i] = new float[XSize];
//	}
//	float *pBuf = new float[XSize*YSize];
//	//ȡ
//	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
//	int p = 0;
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			pmdata[i][j] = pBuf[p++] / 1000.0;
//		}
//	}
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			if (fabs(pmdata[i][j] - 0.0) < MIN_VALUE)
//			{
//				//pmresult[i][j] = SearchValue(i,j)
//
//			}
//			else
//			{
//				pmresult[i][j] = pmdata[i][j];
//			}
//
//		}
//	}
//	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
//	GDALDataset *DstDS = Driver->Create(outFile, XSize, YSize, 1, dataType, NULL);
//	DstDS->SetGeoTransform(geoTransForm);
//	DstDS->SetProjection(AODDS->GetProjectionRef());
//	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS), 1), 0.0);
//	p = 0;
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			pBuf[p++] = pmresult[i][j];
//			//pBuf[p++] = pmkadry[i][j];
//		}
//	}
//	DstDS->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
//	//
//	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
//	RELEASE(pBuf);
//	GDALClose((GDALDatasetH)DstDS);
//	GDALClose((GDALDatasetH)AODDS);
//	//GDALClose((GDALDatasetH)tempDstDS);
//	for (int i = 0; i<YSize; i++)
//	{
//		//RELEASE(pmkadry[i]);
//		RELEASE(pmdata[i]);
//		RELEASE(pmresult[i]);
//	}
//	//RELEASE(pmkadry);
//	RELEASE(pmdata);
//	RELEASE(pmresult);
//	return RE_SUCCESS;
//
//}



