/***************************************************************************
*
* Time: 2013-06-27
* Project: ң㷨ʾ
* Purpose: ң㷨ʾ
* Author:  ¼
* Copyright (c) 2013, liminlu0314@163.com
* Describe: ң㷨ʾе㷨У
*           ûж·ԼļǷڽм飬
*           ĬΪеǺ
*
****************************************************************************/

#define _CRT_SECURE_NO_WARNINGS
#include "GDALAir.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include<algorithm>
#include "omp.h"
#include "gdal_alg.h"
#include <queue>
using namespace std;
#pragma region ͼǶ

/**
* @brief ͼУתṹ
*/
struct TransformChain
{
	/*! GDALתָ */
	GDALTransformerFunc GDALTransformer;
	/*! GDALת */
	void *              GDALTransformerArg;
	/*! ͼ6 */
	double              adfGeotransform[6];
	/*! ͼ6 */
	double              adfInvGeotransform[6];
};

/**
* @brief һת
*
* úڴһͼͶӰתͼк
* @sa DestroyGeoToPixelTransform
* @returns GDALתصĲ \ref GeoToPixelTransform
*/
void *CreateGeoToPixelTransform (GDALTransformerFunc GDALTransformer, void *GDALTransformerArg, double *padfGeotransform)
{
	TransformChain *pChain = new TransformChain;
	pChain->GDALTransformer = GDALTransformer;
	pChain->GDALTransformerArg = GDALTransformerArg;
	memcpy (pChain->adfGeotransform, padfGeotransform, sizeof(double)* 6);

	if (!GDALInvGeoTransform (pChain->adfGeotransform, pChain->adfInvGeotransform))
	{
		// ͼܼܽб任
		delete pChain;
		return NULL;
	}
	return (void*)pChain;
}

/**
* @brief ת
*/
void DestroyGeoToPixelTransform (void *GeoToPixelTransfomArg)
{
	delete static_cast<TransformChain *>(GeoToPixelTransfomArg);
}

/**
* @brief ת
* @sa CreateGeoToPixelTransform
*/
int GeoToPixelTransform (void *pTransformerArg, int bDstToSrc, int nPointCount,
	double *x, double *y, double *z, int *panSuccess)
{
	TransformChain *pChain = static_cast<TransformChain*>(pTransformerArg);
	if (pChain == NULL)
		return FALSE;

	if (!bDstToSrc)	//任
	{
		// ȵGDALеתתΪͼͶӰ
		if (!pChain->GDALTransformer (pChain->GDALTransformerArg, bDstToSrc, nPointCount, x, y, z, panSuccess))
			return FALSE;

		// ٴͼͶӰϵתͼк
#pragma omp parallel for
		for (int i = 0; i < nPointCount; ++i)
		{
			if (!panSuccess[i])
				continue;

			double xP = x[i];
			double yP = y[i];
			GDALApplyGeoTransform (pChain->adfInvGeotransform, xP, yP, &x[i], &y[i]);
		}
	}
	else	//任
	{
		// ȴͼкתͼͶӰϵ
#pragma omp parallel for
		for (int i = 0; i < nPointCount; ++i)
		{
			double P = x[i];
			double L = y[i];
			GDALApplyGeoTransform (pChain->adfGeotransform, P, L, &x[i], &y[i]);
		}
		// ٵGDALתͼͶӰתԭʼ
		if (!pChain->GDALTransformer (pChain->GDALTransformerArg, bDstToSrc, nPointCount, x, y, z, panSuccess))
			return FALSE;
	}

	return TRUE;
}
int ImageWarpByGeoLoc(const char * pszSrcFile, const char * pszDstFile, char **papszGeoLocOptions,
	GDALResampleAlg eResampleMethod, const char * pszFormat)
{
	// ǰҪļ·жϣﲻжֱӴ
	if (pszSrcFile == NULL || pszDstFile == NULL || papszGeoLocOptions == NULL || pszFormat == NULL)
	{
		return RE_PARAMERROR;
	}
	GDALAllRegister();

	// ԭʼͼ񲢼ͼϢ
	GDALDatasetH hSrcDS = GDALOpen(pszSrcFile, GA_ReadOnly);
	GDALDataType eDT = GDALGetRasterDataType(GDALGetRasterBand(hSrcDS, 1));	//ȡ
	int iBandCount = GDALGetRasterCount(hSrcDS);

	// Geolocתϵ
	void *hTransformArg = GDALCreateGeoLocTransformer(hSrcDS, papszGeoLocOptions, FALSE);
	if (hTransformArg == NULL)
	{
		GDALClose(hSrcDS);
		return RE_PARAMERROR;
	}

	// ʹSuggestedWarpOutputͼΧСϢ
	double adfGeoTransform[6];
	double adfExtent[4];
	int    nPixels, nLines;

	if (GDALSuggestedWarpOutput2(hSrcDS, GDALGeoLocTransform, hTransformArg,
		adfGeoTransform, &nPixels, &nLines, adfExtent, 0) != CE_None)
	{
		GDALClose(hSrcDS);
		return RE_PARAMERROR;
	}

	// ͼ
	GDALDriverH hDriver = GDALGetDriverByName(pszFormat);
	GDALDatasetH hDstDS = GDALCreate(hDriver, pszDstFile, nPixels, nLines, iBandCount, eDT, NULL);
	GDALSetProjection(hDstDS, SRS_WKT_WGS84);	//GeoLocУWGS84γϵͳ
	GDALSetGeoTransform(hDstDS, adfGeoTransform);

	// GDALWarpı任ѡ
	GDALWarpOptions *psWO = GDALCreateWarpOptions();

	psWO->papszWarpOptions = CSLDuplicate(NULL);
	psWO->eWorkingDataType = eDT;
	psWO->eResampleAlg = GRA_NearestNeighbour;

	psWO->hSrcDS = hSrcDS;
	psWO->hDstDS = hDstDS;

	psWO->pfnTransformer = GeoToPixelTransform;
	psWO->pTransformerArg = CreateGeoToPixelTransform(GDALGeoLocTransform, hTransformArg, adfGeoTransform);

	//psWO->pfnProgress = ALGTermProgress;
	//psWO->pProgressArg = pProcess;

	psWO->nBandCount = iBandCount;
	psWO->panSrcBands = (int *)CPLMalloc(psWO->nBandCount*sizeof(int));
	psWO->panDstBands = (int *)CPLMalloc(psWO->nBandCount*sizeof(int));
	/*psWO->panSrcBands = new int[psWO->nBandCount];
	psWO->panDstBands = new int[psWO->nBandCount];*/
	for (int i = 0; i < iBandCount; i++)
	{
		psWO->panSrcBands[i] = i + 1;
		psWO->panDstBands[i] = i + 1;
	}

	// GDALWarpִж󣬲ʹGDALWarpOptionsгʼ
	GDALWarpOperation oWO;
	oWO.Initialize(psWO);

	// ִд
	oWO.ChunkAndWarpImage(0, 0, nPixels, nLines);

	// ͷԴ͹رļ
	////delete []psWO->panSrcBands;
	///delete[] psWO->panDstBands;
	//delete[] psWO->panSrcBands;
	//delete[] psWO->panDstBands;
	//CPLFree(psWO->panSrcBands);
	//CPLFree(psWO->panDstBands);
	DestroyGeoToPixelTransform(psWO->pTransformerArg);
	GDALDestroyWarpOptions(psWO);
	GDALDestroyGeoLocTransformer(hTransformArg);
	GDALClose(hSrcDS);
	GDALClose(hDstDS);
	return RE_SUCCESS;
}

int RGBTrueColorSynthesisconst (const char* pszSrcFile2, const char* pszSrcFile3, const char* pszDstFile, int deleteFile)
{
	//modis3ݣȡgeolocϢ
	const char* pszFormat = "GTiff";
	//ƴĿļ·ļ
	string strfile = string (CPLGetFilename (pszSrcFile2));
	strfile = strfile.substr (0, strfile.find_last_of ("hdf") - 21);
	strfile = string (CPLGetPath (pszDstFile)) + "\\" + strfile;
	string tmpThreeMidFile = strfile + "_threemidFile.tif";
	string tmpGeolocFile = strfile + "_geolocFile.tif";
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *pSrcDataset3 = (GDALDataset*)GDALOpen (pszSrcFile3, GA_ReadOnly);
	if (pSrcDataset3 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD3;
	}
	char **papszSubDatasets3 = GDALGetMetadata ((GDALDatasetH)pSrcDataset3, "SUBDATASETS");
	string tmpstr = string (papszSubDatasets3[0]);
	tmpstr = tmpstr.substr (tmpstr.find_first_of ("=") + 1);
	const char * pszSrcFile3_1 = tmpstr.c_str ();

	string tmplat = string (papszSubDatasets3[24]);
	tmplat = tmplat.substr (tmplat.find_first_of ("=") + 1);
	const char * pszlat = tmplat.c_str ();

	string tmplon = string (papszSubDatasets3[26]);
	tmplon = tmplon.substr (tmplon.find_first_of ("=") + 1);
	const char * pszlon = tmplon.c_str ();

	GDALDataset *pSrcDS3_1 = (GDALDataset*)GDALOpen (pszSrcFile3_1, GA_ReadOnly);
	if (pSrcDS3_1 == NULL)
	{
		GDALClose ((GDALDatasetH)pSrcDataset3);
		return RE_FILENOTSUPPORT_MOD3;
	}
	//ȡdodis3Ԫgeolocation
	char **papszGeoLocOptions3 = pSrcDS3_1->GetMetadata ("GEOLOCATION");
	//GDALClose(GDALDatasetH(pSrcDataset3));

	char **papszGeoLocOptions = NULL;

	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
	if (papszGeoLocOptions3 == NULL)
	{
		//char **papszGeoLocOptions = NULL;
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_OFFSET", "0");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_OFFSET", "0");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "X_BAND", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "Y_BAND", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "X_DATASET", pszlon);
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "Y_DATASET", pszlat);
	}
	else
	{
		papszGeoLocOptions = papszGeoLocOptions3;
		//papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "PIXEL_OFFSET", "2");
		//papszGeoLocOptions= CSLSetNameValue(papszGeoLocOptions3, "LINE_OFFSET", "2");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "PIXEL_STEP", "1");
		papszGeoLocOptions = CSLSetNameValue (papszGeoLocOptions, "LINE_STEP", "1");
		/*papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "X_DATASET", pszlon);
		papszGeoLocOptions = CSLSetNameValue(papszGeoLocOptions3, "Y_DATASET",pszlat );*/
		//HDF4_SDS:UNKNOWN:"E:\GDAL\GDALTEST\rgb\modisrgb\data\1430335\MOD03.A2015143.0235.006.2015143091841.hdf":0

	}



	GDALDataset *pSrcDataset2 = (GDALDataset*)GDALOpen (pszSrcFile2, GA_ReadOnly);
	if (pSrcDataset2 == NULL)
	{
		GDALClose (GDALDatasetH (pSrcDataset3));
		GDALClose (GDALDatasetH (pSrcDS3_1));
		return RE_FILENOTSUPPORT_MOD2;
	}
	//洢ݵ·Ϣ
	char **papszSubDatasets2 = GDALGetMetadata ((GDALDatasetH)pSrcDataset2, "SUBDATASETS");
	//GDALClose(pSrcDataset2);
	// string temp2_1 = string(vSubDSName2[28]);
	string tmpstr2 = string (papszSubDatasets2[8]);
	tmpstr2 = tmpstr2.substr (tmpstr2.find_first_of ("=") + 1);
	const char *pszSrcFile2_1 = tmpstr2.c_str ();

	string tmpstr3 = string (papszSubDatasets2[14]);
	tmpstr3 = tmpstr3.substr (tmpstr3.find_first_of ("=") + 1);
	const char *pszSrcFile2_2 = tmpstr3.c_str ();
	//ݼȡָ3Ρ

	///////////////////////////////////////////////////

	// ԭʼͼָݼͼϢ//ʱļ3εģ
	GDALDataset *pSrcDS2_1 = (GDALDataset*)GDALOpen (pszSrcFile2_1, GA_ReadOnly);
	GDALDataset *pSrcDS2_2 = (GDALDataset*)GDALOpen (pszSrcFile2_2, GA_ReadOnly);
	double adfGeoTransform2_1[6] = { 0 };
	double adfGeoTransform2_2[6] = { 0 };
	pSrcDS2_1->GetGeoTransform (adfGeoTransform2_1);
	pSrcDS2_2->GetGeoTransform (adfGeoTransform2_2);

	//modisTime =atoi(tmpstr.c_str());
	//const char* pszTempFile ="E:\\GDAL\\GDALTEST\\rgb\\modisrgb\\data\\rgbtemp.tif";
	//E:\GDAL\GDALTEST\rgb\modisrgb\data\rgb.tif
	GDALDriver *pDriver = (GDALDriver*)GDALGetDriverByName (pszFormat);
	int nPixels = pSrcDS2_1->GetRasterXSize ();
	int nLines = pSrcDS2_1->GetRasterYSize ();
	GDALDataType eDT = pSrcDS2_1->GetRasterBand (1)->GetRasterDataType ();	//ȡ
	GDALDataset *pTempDS = pDriver->Create (tmpThreeMidFile.c_str (), nPixels, nLines, 3, eDT, NULL);//3
	pTempDS->SetProjection (pSrcDS2_1->GetProjectionRef ());
	pTempDS->SetGeoTransform (adfGeoTransform2_1);
	//delete []adfGeoTransform2_1;
	//delete []adfGeoTransform2_2;
	//д
	if (eDT == GDT_UInt16)
	{
		DT_16U *pBuf = new DT_16U[nPixels*nLines];
		GDALRasterBand *pBand1 = pTempDS->GetRasterBand (1);
		GDALRasterBand *pBand2 = pTempDS->GetRasterBand (2);
		GDALRasterBand *pBand3 = pTempDS->GetRasterBand (3);
		pSrcDS2_1->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand1->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д1

		pSrcDS2_2->GetRasterBand (2)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand2->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д2

		pSrcDS2_2->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0);
		pBand3->RasterIO (GF_Write, 0, 0, nPixels, nLines, pBuf, nPixels, nLines, GDT_UInt16, 0, 0); //д3
		delete[]pBuf;
	}

	int iResult;
	//pszTempFile ="E:\\GDAL\\GDALTEST\\rgb\\modisrgb\\data\\rgbtemp.tif";
	GDALClose ((GDALDatasetH)pSrcDS2_2);
	GDALClose ((GDALDatasetH)pSrcDS2_1);
	GDALClose ((GDALDatasetH)pTempDS);
	GDALClose ((GDALDatasetH)pSrcDataset3);
	GDALClose ((GDALDatasetH)pSrcDataset2);
	iResult = ImageWarpByGeoLoc (tmpThreeMidFile.c_str (), pszDstFile, papszGeoLocOptions, GRA_NearestNeighbour, "GTiff");
	GDALClose (GDALDatasetH (pSrcDS3_1));
	papszGeoLocOptions3 = NULL;


	if (deleteFile == 0)
	{
		remove (tmpThreeMidFile.c_str ());//ļɾ
	}
	return iResult;

}






//ȫֱ ͼΧ
static double	       dfMinX = 0.0, dfMinY = 0.0, dfMaxX = 0.0, dfMaxY = 0.0;
//ȫֱ ͼֱ
static double	       dfXRes = 0.01000, dfYRes = 0.01000;
//ȫֱ ͼ
static int             nForcePixels = 0, nForceLines = 0;
//ȫֱ ָ
//CProcessBase* m_pProcess = NULL;		

/**
* @brief ļ
* @param papszSrcFiles			ļб
* @param pszFilename			ļ·
* @param pszFormat				ļʽ
* @param eDT					ļ
* @param iRst					صĴʹ
* @return ļľ
*/
static GDALDatasetH GDALWarpCreateOutput (char **papszSrcFiles, int count, const char *pszFilename,
	const char *pszFormat, GDALDataType eDT, int &iRst)
{
	GDALAllRegister ();
	GDALDriverH hDriver;
	GDALDatasetH hDstDS;
	GDALColorTableH hCT = NULL;
	double dfWrkMinX = 0, dfWrkMaxX = 0, dfWrkMinY = 0, dfWrkMaxY = 0;
	double dfWrkResX = 0, dfWrkResY = 0;
	int nDstBandCount = 0;
	const char *pszThisTargetSRS = NULL;
	string strThisTargetSRS;

	iRst = RE_SUCCESS;

	//ȡļ
	hDriver = GDALGetDriverByName (pszFormat);
	//GDALDriver *pDriver =GDALDriverManager().GetDriverByName(pszFormat);
	//
	//printf(" driver short name is %s\n",GDALGetDriverShortName(hDriver));
	//printf(" driver long name is %s\n",GDALGetDriverLongName(hDriver));
	if (hDriver == NULL)
	{
		iRst = RE_FILENOTSUPPORT;
		return NULL;
	}

	for (int iSrc = 0; iSrc<count; iSrc++)
	{
		GDALDatasetH hSrcDS;
		hSrcDS = GDALOpen (papszSrcFiles[iSrc], GA_ReadOnly);
		if (hSrcDS == NULL)
		{
			iRst = RE_FILENOTEXIST;
			return NULL;
		}

		//鵱ǰļǷڲ 
		if (GDALGetRasterCount (hSrcDS) == 0)
		{
			iRst = RE_FILETYPEERROR;
			return NULL;
		}

		if (eDT == GDT_Unknown)
			eDT = GDALGetRasterDataType (GDALGetRasterBand (hSrcDS, 1));

		if (pszThisTargetSRS == NULL)
		{
			pszThisTargetSRS = GDALGetProjectionRef (hSrcDS);
			strThisTargetSRS = (string)((char*)pszThisTargetSRS);
		}

		//ǵһͼôͼϢһͼ񱣳һ
		if (iSrc == 0)
		{
			nDstBandCount = GDALGetRasterCount (hSrcDS);
			hCT = GDALGetRasterColorTable (GDALGetRasterBand (hSrcDS, 1));
			if (hCT != NULL)
				hCT = GDALCloneColorTable (hCT);
		}

		double adfThisGeoTransform[6] = { 0 };
		double adfExtent[4] = { 0 };
		int    nThisPixels, nThisLines;

		nThisPixels = GDALGetRasterXSize (hSrcDS);
		nThisLines = GDALGetRasterYSize (hSrcDS);

		// 㵱ǰͼΧ
		GDALGetGeoTransform (hSrcDS, adfThisGeoTransform);
		GDALApplyGeoTransform (adfThisGeoTransform, 0, 0, adfExtent, adfExtent + 1);
		GDALApplyGeoTransform (adfThisGeoTransform, nThisPixels, nThisLines, adfExtent + 2, adfExtent + 3);

		// Χ
		if (dfWrkMaxX == 0.0 && dfWrkMinX == 0.0)
		{
			dfWrkMinX = adfExtent[0];
			dfWrkMaxX = adfExtent[2];
			dfWrkMaxY = adfExtent[1];
			dfWrkMinY = adfExtent[3];
			dfWrkResX = adfThisGeoTransform[1];
			dfWrkResY = ABS (adfThisGeoTransform[5]);
		}
		else
		{
			dfWrkMinX = MIN (dfWrkMinX, adfExtent[0]);
			dfWrkMaxX = MAX (dfWrkMaxX, adfExtent[2]);
			dfWrkMaxY = MAX (dfWrkMaxY, adfExtent[1]);
			dfWrkMinY = MIN (dfWrkMinY, adfExtent[3]);
			dfWrkResX = MIN (dfWrkResX, adfThisGeoTransform[1]);
			dfWrkResY = MIN (dfWrkResY, ABS (adfThisGeoTransform[5]));
		}

		GDALClose (hSrcDS);
	}

	// ͼΧʹС
	double adfDstGeoTransform[6];
	int nPixels, nLines;

	adfDstGeoTransform[0] = dfWrkMinX;
	adfDstGeoTransform[1] = dfWrkResX;
	adfDstGeoTransform[2] = 0.0;
	adfDstGeoTransform[3] = dfWrkMaxY;
	adfDstGeoTransform[4] = 0.0;
	adfDstGeoTransform[5] = -1 * dfWrkResY;

	nPixels = (int)((dfWrkMaxX - dfWrkMinX) / dfWrkResX + 0.5);
	nLines = (int)((dfWrkMaxY - dfWrkMinY) / dfWrkResY + 0.5);

	// ûֱָʱٶͼСе
	if (dfXRes != 0.0 && dfYRes != 0.0)
	{
		if (dfMinX == 0.0 && dfMinY == 0.0 && dfMaxX == 0.0 && dfMaxY == 0.0)
		{
			dfMinX = adfDstGeoTransform[0];
			dfMaxX = adfDstGeoTransform[0] + adfDstGeoTransform[1] * nPixels;
			dfMaxY = adfDstGeoTransform[3];
			dfMinY = adfDstGeoTransform[3] + adfDstGeoTransform[5] * nLines;
		}

		nPixels = (int)((dfMaxX - dfMinX + (dfXRes / 2.0)) / dfXRes);
		nLines = (int)((dfMaxY - dfMinY + (dfYRes / 2.0)) / dfYRes);
		adfDstGeoTransform[0] = dfMinX;
		adfDstGeoTransform[3] = dfMaxY;
		adfDstGeoTransform[1] = dfXRes;
		adfDstGeoTransform[5] = -dfYRes;
	}

	// ͼ
	hDstDS = GDALCreate (hDriver, pszFilename, nPixels, nLines, nDstBandCount, eDT, NULL);
	//hDstDS = GDALCreate( GDALDriverH(pDriver), pszFilename, nPixels, nLines, nDstBandCount, eDT, NULL );
	if (hDstDS == NULL)
		return NULL;

	// дͶӰϢϢ
	GDALSetProjection (hDstDS, strThisTargetSRS.c_str ());
	GDALSetGeoTransform (hDstDS, adfDstGeoTransform);

	return hDstDS;
}
/**
* @brief ͼǶ
* <B>עô˺֮ǰȶӰмξͬһͶӰϵͳ£ֱʿԲͬ
* ͶӰϢԼĸݵĲθһ£ֲǶ
* ͼķֱʻᰴӰĵһӰȡͶӰϢ</B>
* @param papszSrcFiles		ļԼǶ·飬ĬϵһΪοӰ񣬵һͼ²㣬
* @param pszDstFilename		ļ·
* @param eResampleMethod	زʽĬΪRM_Bilinear
* @param dResX				ӰXֱʣĬΪ0ʾյһӰΪ׼
* @param dResY				ӰYֱʣĬΪ0ʾյһӰΪ׼
* @param pszFormat			ļʽϸοGDAL֧
* @param pProcess			ָ
* @return ֵʾгֵĸִϢ
*/
int ImageMosaicing (char* papszSrcFiles_1, const char* pszDstFilename)
{


	//Ԥַתchar**
	const char* comma = ",";
	int commaCount = 0;
	for (int i = 0; papszSrcFiles_1[i] != NULL; i++)
	{
		if (papszSrcFiles_1[i] == ',')
		{
			commaCount++;

		}
	}
	char** papszSrcFiles = new char *[commaCount + 1];
	for (int i = 0; i<commaCount + 1; i++)
	{
		if (i == 0)
		{
			papszSrcFiles[i] = strtok (papszSrcFiles_1, comma);
		}
		else
		{
			papszSrcFiles[i] = strtok (NULL, comma);
		}

	}


	int eResampleMethod = GRA_Bilinear;
	double dResX = 0;
	double dResY = 0;
	const char* pszFormat = "GTiff";
	/*if(pProcess != NULL)
	pProcess->SetMessage("ִǶ...");
	*/
	//ת
	void               *hTransformArg, *hGenImgProjArg = NULL, *hApproxArg = NULL;
	double              dfErrorThreshold = 0.0;
	GDALTransformerFunc pfnTransformer = NULL;

	GDALDataType        eOutputType = GDT_Unknown, eWorkingType = GDT_Unknown;
	GDALResampleAlg     eResampleAlg = (GDALResampleAlg)eResampleMethod;

	//NODATA
	const char         *pszSrcNodata = "0 0 0";
	const char         *pszDstNodata = "0 0 0";

	GDALAllRegister ();

	dfXRes = dResX;	//÷ֱ
	dfYRes = dResY;

	//ļ
	int iResult = RE_SUCCESS;
	GDALDatasetH		hDstDS;
	hDstDS = GDALWarpCreateOutput (papszSrcFiles, commaCount + 1, pszDstFilename, pszFormat, eOutputType, iResult);

	if (iResult != RE_SUCCESS || hDstDS == NULL)
		return iResult;

	//еļдļ
	int iRev = RE_SUCCESS;
	for (int iSrc = 0; iSrc<commaCount + 1; iSrc++)
	{
		GDALDatasetH hSrcDS;
		hSrcDS = GDALOpen (papszSrcFiles[iSrc], GA_ReadOnly);

		//////////////////////////////////////////////////////////////////////////
		// printf("%s\n\n",GDALGetProjectionRef(hSrcDS));
		//printf("%s\n",GDALGetProjectionRef(hDstDS));
		//////////////////////////////////////////////////////////////////////////
		if (hSrcDS == NULL)
		{
			iRev = RE_FILENOTEXIST;
			goto CLEAN;
		}

		// ļǷ񲻴ڲ 
		if (GDALGetRasterCount (hSrcDS) == 0)
		{
			//CPLDebug ("ImageMergeCutline", "ļ %s ڲΡ\n", papszSrcFiles[iSrc]);
			iRev = RE_FILENOTSUPPORT;
			goto CLEAN;
		}

		//תԴ굽Ŀϵ
		hTransformArg = hGenImgProjArg = GDALCreateGenImgProjTransformer2 (hSrcDS, hDstDS, NULL);
		if (hTransformArg == NULL)
		{
			iRev = RE_PARAMERROR;
			goto CLEAN;
		}

		pfnTransformer = GDALGenImgProjTransform;

		if (dfErrorThreshold != 0.0)
		{
			hTransformArg = hApproxArg =
				GDALCreateApproxTransformer (GDALGenImgProjTransform, hGenImgProjArg, dfErrorThreshold);
			pfnTransformer = GDALApproxTransform;
		}

		//warpѡ
		GDALWarpOptions *psWO = GDALCreateWarpOptions ();
		psWO->eWorkingDataType = eWorkingType;
		psWO->eResampleAlg = eResampleAlg;

		psWO->hSrcDS = hSrcDS;
		psWO->hDstDS = hDstDS;

		psWO->pfnTransformer = pfnTransformer;
		psWO->pTransformerArg = hTransformArg;

		psWO->pfnProgress = ALGTermProgress;
		/*psWO->pProgressArg = pProcess;*/
		//
		psWO->nDstAlphaBand = GDALGetRasterCount (hDstDS);
		psWO->nSrcAlphaBand = GDALGetRasterCount (hSrcDS);
		//ӳϵ
		psWO->nBandCount = GDALGetRasterCount (hSrcDS);

		psWO->panSrcBands = (int *)CPLMalloc (psWO->nBandCount*sizeof(int));
		psWO->panDstBands = (int *)CPLMalloc (psWO->nBandCount*sizeof(int));

		for (int i = 0; i < psWO->nBandCount; i++)
		{
			psWO->panSrcBands[i] = i + 1;
			psWO->panDstBands[i] = i + 1;
		}

		//ʼִwarp
		GDALWarpOperation oWO;
		CPLErr CE = CE_None;
		if (oWO.Initialize (psWO) == CE_None)
			CE = oWO.ChunkAndWarpImage (0, 0, GDALGetRasterXSize (hDstDS), GDALGetRasterYSize (hDstDS));

		//Դ
		if (hApproxArg != NULL)
			GDALDestroyApproxTransformer (hApproxArg);

		if (hGenImgProjArg != NULL)
			GDALDestroyGenImgProjTransformer (hGenImgProjArg);

		GDALDestroyWarpOptions (psWO);
		GDALClose (hSrcDS);

		if (CE != CE_None)
		{
			GDALClose (hDstDS);
			CSLDestroy (papszSrcFiles);

			/*if(pProcess != NULL)
			{
			if (!pProcess->m_bIsContinue)
			{
			pProcess->SetMessage("ȡ㣡");
			return RE_USERCANCEL;
			}
			else
			{
			pProcess->SetMessage("ִʧܣ");
			return RE_FAILED;
			}
			}*/

			return RE_FAILED;
		}

		/*if(pProcess != NULL)
		pProcess->ReSetProcess();*/
	}

	//ƺ
CLEAN:

	GDALClose (hDstDS);
	//CSLDestroy( papszSrcFiles );
	for (int i = 0; i<commaCount + 1; i++)
	{
		papszSrcFiles[i] = NULL;
	}

	/*if(pProcess != NULL)
	pProcess->SetMessage("Ƕ...");
	*/
	return RE_SUCCESS;
}

#pragma endregion ͼǶ
int SieveFilter (const char* pszSrcFile, const char* pszDstFile, int nSizeThresholld, int nConnectedness, const char* pszFormat)
{
	if (pszSrcFile == NULL || pszDstFile == NULL)
	{
		return RE_PARAMERROR;
	}
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *SrcDS = (GDALDataset*)GDALOpen (pszSrcFile, GA_ReadOnly);
	if (SrcDS == NULL)
	{
		return RE_FILENOTEXIST;
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (pszFormat);
	if (Driver == NULL)
	{
		GDALClose ((GDALDatasetH)SrcDS);
		return RE_FILENOTSUPPORT;
	}
	//ȡͼϢ
	int srcBandCount = SrcDS->GetRasterCount ();
	int XSize = SrcDS->GetRasterXSize ();
	int YSize = SrcDS->GetRasterYSize ();
	GDALDataType dataType = SrcDS->GetRasterBand (1)->GetRasterDataType ();
	//ͼ
	GDALDataset *DstDS = Driver->Create (pszDstFile, XSize, YSize, srcBandCount, dataType, NULL);
	double geoTransform[6] = { 0 };
	SrcDS->GetGeoTransform (geoTransform);
	DstDS->SetGeoTransform (geoTransform);
	DstDS->SetProjection (SrcDS->GetProjectionRef ());

	for (int i = 0; i<srcBandCount; i++)
	{
		GDALRasterBandH SrcBand = (GDALRasterBandH)SrcDS->GetRasterBand (i + 1);
		GDALRasterBandH DstBand = (GDALRasterBandH)DstDS->GetRasterBand (i + 1);
		//GDALSetRasterColorTable(DstBand,GDALGetRasterColorTable(SrcBand));
		GDALSetRasterNoDataValue (DstBand, 0.0);
		if (GDALSieveFilter (SrcBand, NULL, DstBand, nSizeThresholld, nConnectedness, NULL, NULL, NULL) != CE_None)
		{
			if (DstDS != NULL)
			{
				GDALClose ((GDALDatasetH)DstDS);
				GDALClose ((GDALDatasetH)SrcDS);
			}
			return RE_PARAMERROR;
		}

		GDALClose ((GDALDatasetH)DstDS);
		GDALClose ((GDALDatasetH)SrcDS);
		return RE_SUCCESS;
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

enum test_result
{
	unknow = 0,
	yun = 1,
	shui = 3,
	qianhuodian = 4,
	jueduihuodian = 5,
	nofire = 6,
	zandinghuodian = 7,
	zhenhuodian = 8,
	beijinghuodian = 9,
	beijinghuodian2 = 14,
	beijing = 10,
	buquding = 11,
	chenggongtiqu = 12,
	xujiahuodian = 13,
	youxiaobeijingxiangyuan = 15,
	anxiangyuan = 16
};
static  float maxwindowsize = 21;//󴰿ڴС
static int modisTime =0;//modisʱ
static int seasonDay=0;//modis

static int width;//
static int height;//߶admin
// float sizeofclass =width*height;
float** band_1 = NULL;
float** band_2 = NULL;
float** band_3 = NULL;
float** band_5 = NULL;
float** band_7 = NULL;
float** band_21 = NULL;
float** band_22 = NULL;
float** band_31 = NULL;
float** band_32 = NULL;
//string tmpstrSensorZenith,tmpstrSensorAzimuth,tmpstrSolarZenith,tmpstrSolarAzimuth;
float** sensorzenith = NULL;
float** sensorazimuth = NULL;
float** solarzenith = NULL;
float** solarazimuth = NULL;
float** relativeangel = NULL;
float** lansea = NULL;
test_result** testresult = NULL;
float** confidence = NULL;
float** longitute = NULL;
float** latitute = NULL;
float** temp = NULL;
float** aodndvi = NULL;
float** suf_band_1;
float** suf_band_3 = NULL;
float** aodOptimal = NULL;

#pragma region Ʋ
//Ƽ⼰ˮԪʶ޳
const float th1 = 0.9;
const float th2 = 0.7;
const float th3 = 265;
const float th4 = 285;
const float th5 = 0.15;
//Ǳڻб
const float thr = 0.3;
const float thdt4 = 310;
const float thnt4 = 305;
//ǱڻֵԲ
const float thdat4 = 340;
const float thnat4 = 320;
//Ǳڻ㱳ֵԲ
const float thdb4 = 325;
const float thdbtt = 20;
const float thnb4 = 310;
const float thnbtt = 10;

const float tht1 = 3.5;
const float tht2 = 6;
const float tht3 = 3;
const float tht4 = 4;
const float tht5 = 5;
const float thtt = 10;
//ٻȥ
const float tha1 = 2;
const float tha2 = 8;
const float tha3 = 12;
const float thar = 0.1;
const float than = 0.2;
const float thap = 0.12;
//ɳĮԵٻȥ
const float ths1 = 0.1;
const float ths2 = 4;
const float ths3 = 0.15;
const float ths4 = 345;
const float ths5 = 3;
const float ths6 = 6;
//ոѷջŶȹ㷽
const float thc1 = 310;
const float thc2 = 340;
const float thc3 = 305;
const float thc4 = 320;
const float thc5 = 3;
const float thc6 = 2.5;
const float thc7 = 6;
#pragma endregion


#pragma region  ұ
const int searchTabColCount = 7;   //ұ
const int intervalCount = 5;           //ұֵ
const int solZenCount = 8;         //̫춥Ǹ
const int senZenCount = 7;		   //춥Ǹ
const int solAziCount = 9;		   //λǸʵԷλǸ
const int aod550Count = 6;		   //aod
double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 72, 84 };//̫춥
double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
double aod550[aod550Count] = { 0.0001, 0.25, 0.5, 1.0, 1.5, 1.95 };//550nmܽѧ
#pragma endregion 
/////////////////////////////////////////////////////////////////////////////

void CopyIntToFloat (DT_16S * pBuf_16, DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = (double)pBuf_16[i];
	}
}
void CopyUIntToFloat (DT_16U * pBuf_16, DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = (double)pBuf_16[i];
	}
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void JiSuanFanshelv (DT_32F * pBuf, double dScale, double dOffset, int iCount, int iType)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf[i] = (pBuf[i] - dOffset)*dScale;
	}
	double k1, k2;
	double ik1_21 = 3634.171501, ik1_22 = 3634.171501, ik1_31 = 1304.413871, ik1_32 = 1196.978785;
	double ik2_21 = 122461.658403, ik2_22 = 122461.658403, ik2_31 = 729.541636, ik2_32 = 474.684780;
	switch (iType)
	{
	case 21: k1 = ik1_21; k2 = ik2_21; break;
	case 22: k1 = ik1_22; k2 = ik2_22; break;
	case 31: k1 = ik1_31; k2 = ik2_31; break;
	case 32: k1 = ik1_32; k2 = ik2_32; break;
	}
	if (iType == 21 || iType == 31 || iType == 22 || iType == 32)
	{
		for (int i = 0; i<iCount; i++)
		{
			pBuf[i] = k1 / (log(abs((k2 / (pBuf[i] + MIN_VALUE) + 1) + MIN_VALUE)));
		}
	}
}
void JiSuanJiaoDu (DT_32F * pBuf_32, int iCount)
{
	for (int i = 0; i<iCount; i++)
	{
		pBuf_32[i] = pBuf_32[i] * 0.01;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////

int  AODCreateData (const char* charSrcFile2, const char* charSrcFile3, const char* charDstFile)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS2 = (GDALDataset*)GDALOpen (charSrcFile2, GA_ReadOnly);
	if (DS2 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD2;
	}
	char** subdatasets = DS2->GetMetadata ("SUBDATASETS");
#pragma endregion
#pragma region ȡָݼ
	string sub250, sub500, sub1000;
	sub1000 = string (subdatasets[4]); //1000    //3*2-2
	sub1000 = sub1000.substr (sub1000.find_first_of ('=') + 1);
	const char* SrcFile2_1000 = sub1000.c_str ();
	sub250 = string (subdatasets[8]);//250         //5*2-2
	sub250 = sub250.substr (sub250.find_first_of ('=') + 1);
	const char* SrcFile2_250 = sub250.c_str ();
	sub500 = string (subdatasets[14]);//500        //8*2-2
	sub500 = sub500.substr (sub500.find_first_of ('=') + 1);
	const char* SrcFile2_500 = sub500.c_str ();
#pragma endregion
#pragma region ݼȡϢ
	GDALDataset *DS250 = (GDALDataset*)GDALOpen (SrcFile2_250, GA_ReadOnly);
	GDALDataset *DS500 = (GDALDataset*)GDALOpen (SrcFile2_500, GA_ReadOnly);
	GDALDataset *DS1000 = (GDALDataset*)GDALOpen (SrcFile2_1000, GA_ReadOnly);
	int xSize = DS250->GetRasterXSize ();
	int ySize = DS250->GetRasterYSize ();
	GDALDataType datatype = DS250->GetRasterBand (1)->GetRasterDataType ();
	double geoTransform[6] = { 0 };
	DS250->GetGeoTransform (geoTransform);
#pragma endregion 
#pragma region Ŀݼ
	const char* fileFormat = "GTiff";
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (fileFormat);
	//printf("%s\n",Driver->GetDescription());
	GDALDataset *DSDst = Driver->Create (charDstFile, xSize, ySize, 6, GDT_Float32, NULL);
	DSDst->SetProjection (DS250->GetProjectionRef ());
	DSDst->SetGeoTransform (geoTransform);
#pragma endregion 
#pragma region ȡȡoffsetscale
#pragma region ȡԪ
	char** subdatasets250 = DS250->GetMetadata ();
	char** subdatasets500 = DS500->GetMetadata ();
	char** subdatasets1000 = DS1000->GetMetadata ();
#pragma endregion		
#pragma region 
	double douTemp250Offset_1, douTemp250Offset_2, douTemp500Offset_3, douTemp500Offset_5, douTemp500Offset_7, douTemp1000Offset_32;//offset 
	double douTemp250Scale_1, douTemp250Scale_2, douTemp500Scale_3, douTemp500Scale_5, douTemp500Scale_7, douTemp1000Scale_32;//scale
	string strTemp250Offset, strTemp500Offset, strTemp1000Offset;//offset
	string strTemp250Scale, strTemp500Scale, strTemp1000Scale;//scale
	char *charTemp250Offset, *charTemp500Offset, *charTemp1000Offset;
	char *charTemp250Scale, *charTemp500Scale, *charTemp1000Scale;
	const char* commas = ",";
#pragma endregion	
#pragma region 250-offset-scale
	strTemp250Offset = (string)(subdatasets250[118]);
	strTemp250Offset = strTemp250Offset.substr (strTemp250Offset.find_first_of ("=") + 1);
	charTemp250Offset = strtok ((char*)strTemp250Offset.c_str (), commas);
	douTemp250Offset_1 = CPLScanDouble (charTemp250Offset, 20);
	charTemp250Offset = strtok (NULL, commas);
	douTemp250Offset_2 = CPLScanDouble (charTemp250Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp250Scale = (string)(subdatasets250[119]);
	strTemp250Scale = strTemp250Scale.substr (strTemp250Scale.find_first_of ("=") + 1);
	charTemp250Scale = strtok ((char*)strTemp250Scale.c_str (), commas);
	douTemp250Scale_1 = CPLScanDouble (charTemp250Scale, 20);
	charTemp250Scale = strtok (NULL, commas);
	douTemp250Scale_2 = CPLScanDouble (charTemp250Scale, 20);
#pragma endregion
#pragma region 500-offset-scale
	strTemp500Offset = (string)(subdatasets500[118]);
	strTemp500Offset = strTemp500Offset.substr (strTemp500Offset.find_first_of ("=") + 1);
	charTemp500Offset = strtok ((char*)strTemp500Offset.c_str (), commas);
	douTemp500Offset_3 = CPLScanDouble (charTemp500Offset, 20);
	charTemp500Offset = strtok (NULL, commas);
	charTemp500Offset = strtok (NULL, commas);
	douTemp500Offset_5 = CPLScanDouble (charTemp500Offset, 20);
	charTemp500Offset = strtok (NULL, commas);
	charTemp500Offset = strtok (NULL, commas);
	douTemp500Offset_7 = CPLScanDouble (charTemp500Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp500Scale = (string)(subdatasets500[119]);
	strTemp500Scale = strTemp500Scale.substr (strTemp500Scale.find_first_of ("=") + 1);
	charTemp500Scale = strtok ((char*)strTemp500Scale.c_str (), commas);
	douTemp500Scale_3 = CPLScanDouble (charTemp500Scale, 20);
	charTemp500Scale = strtok (NULL, commas);
	charTemp500Scale = strtok (NULL, commas);
	douTemp500Scale_5 = CPLScanDouble (charTemp500Scale, 20);
	charTemp500Scale = strtok (NULL, commas);
	charTemp500Scale = strtok (NULL, commas);
	douTemp500Scale_7 = CPLScanDouble (charTemp500Scale, 20);


#pragma endregion
#pragma region 1000-offset-scale
	strTemp1000Offset = (string)(subdatasets1000[108]);
	strTemp1000Offset = strTemp1000Offset.substr (strTemp1000Offset.find_first_of ("=") + 1);
	charTemp1000Offset = strtok ((char*)strTemp1000Offset.c_str (), commas);
	for (int i = 0; i<11; i++)
	{
		charTemp1000Offset = strtok (NULL, commas);
	}
	douTemp1000Offset_32 = CPLScanDouble (charTemp1000Offset, 20);
	//////////////////////////////////////////////////////////////////////////
	strTemp1000Scale = (string)(subdatasets1000[109]);
	strTemp1000Scale = strTemp1000Scale.substr (strTemp1000Scale.find_first_of ("=") + 1);
	charTemp1000Scale = strtok ((char*)strTemp1000Scale.c_str (), commas);
	for (int i = 0; i<11; i++)
	{
		charTemp1000Scale = strtok (NULL, commas);
	}
	douTemp1000Scale_32 = CPLScanDouble (charTemp1000Scale, 20);
#pragma endregion
#pragma endregion 		
#pragma region д6οѧ رݼ
	if (datatype == GDT_UInt16)
	{
		DT_32F *pBuf_32 = new DT_32F[xSize*ySize];
		DT_16U *pBuf_16 = new DT_16U[xSize*ySize];
		GDALRasterBand *band1 = DSDst->GetRasterBand (1);
		GDALRasterBand *band2 = DSDst->GetRasterBand (2);
		GDALRasterBand *band3 = DSDst->GetRasterBand (3);
		GDALRasterBand *band4 = DSDst->GetRasterBand (4);
		GDALRasterBand *band5 = DSDst->GetRasterBand (5);
		GDALRasterBand *band6 = DSDst->GetRasterBand (6);
		DS250->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp250Scale_1, douTemp250Offset_1, xSize*ySize, 1);
		band1->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д1(band1-0.66)
		DS250->GetRasterBand (2)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp250Scale_2, douTemp250Offset_2, xSize*ySize, 2);
		band2->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д2(band2-0.86)
		DS500->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//2
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_3, douTemp500Offset_3, xSize*ySize, 3);
		band3->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д3(band3-0.47)
		DS500->GetRasterBand (3)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//3
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_5, douTemp500Offset_5, xSize*ySize, 5);
		band4->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д4(band5-1.24)
		DS500->GetRasterBand (5)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//4
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp500Scale_7, douTemp500Offset_7, xSize*ySize, 7);
		band5->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д5(band7-2.1)
		DS1000->GetRasterBand (12)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//5
		CopyUIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanFanshelv (pBuf_32, douTemp1000Scale_32, douTemp1000Offset_32, xSize*ySize, 32);
		band6->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д6(band32-12)
		delete[]pBuf_16;
		delete[]pBuf_32;
	}
	GDALClose (GDALDatasetH (DS250));
	GDALClose (GDALDatasetH (DS500));
	GDALClose (GDALDatasetH (DS1000));
	GDALClose (GDALDatasetH (DSDst));
	GDALClose (GDALDatasetH (DS2));
	return RE_SUCCESS;
#pragma endregion 
}
int AODCreateAngel (const char* SrcFile2, const char* SrcFile3, const char* DstFile)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS3 = (GDALDataset*)GDALOpen (SrcFile3, GA_ReadOnly);
	if (DS3 == NULL)
	{
		return RE_FILENOTSUPPORT_MOD3;
	}
	char** subdatasets = DS3->GetMetadata ("SUBDATASETS");
#pragma endregion
#pragma region ȡָݼ
	string strSensorZenith, strSensorAzimuth, strSolarZenith, strSolarAzimuth, strLanSea;
	strSensorZenith = string (subdatasets[8]);
	strSensorZenith = strSensorZenith.substr (strSensorZenith.find_first_of ('=') + 1);
	const char* charSensorZenith = strSensorZenith.c_str ();

	strSensorAzimuth = string (subdatasets[10]);
	strSensorAzimuth = strSensorAzimuth.substr (strSensorAzimuth.find_first_of ('=') + 1);
	const char* charSensorAzimuth = strSensorAzimuth.c_str ();

	strSolarZenith = string (subdatasets[14]);
	strSolarZenith = strSolarZenith.substr (strSolarZenith.find_first_of ('=') + 1);
	const char* charSolarZenith = strSolarZenith.c_str ();

	strSolarAzimuth = string (subdatasets[16]);
	strSolarAzimuth = strSolarAzimuth.substr (strSolarAzimuth.find_first_of ('=') + 1);
	const char* charSolarAzimuth = strSolarAzimuth.c_str ();

	strLanSea = string (subdatasets[18]);
	strLanSea = strLanSea.substr (strLanSea.find_first_of ('=') + 1);
	const char* charLanSea = strLanSea.c_str ();
#pragma endregion
#pragma region ݼȡϢ
	GDALDataset *DSSensorZenith = (GDALDataset*)GDALOpen (charSensorZenith, GA_ReadOnly);
	GDALDataset *DSSensorAzimuth = (GDALDataset*)GDALOpen (charSensorAzimuth, GA_ReadOnly);
	GDALDataset *DSSolarZenith = (GDALDataset*)GDALOpen (charSolarZenith, GA_ReadOnly);
	GDALDataset *DSSolarAzimuth = (GDALDataset*)GDALOpen (charSolarAzimuth, GA_ReadOnly);
	GDALDataset *DSLanSea = (GDALDataset*)GDALOpen (charLanSea, GA_ReadOnly);
	int xSize = DSSensorZenith->GetRasterXSize ();
	int ySize = DSSensorZenith->GetRasterYSize ();
	GDALDataType datatype = DSSensorZenith->GetRasterBand (1)->GetRasterDataType ();
	double geoTransform[6] = { 0 };
	DSSensorZenith->GetGeoTransform (geoTransform);
#pragma endregion 
#pragma region Ŀݼ
	const char* fileFormat = "GTiff";
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName (fileFormat);
	GDALDataset *DSDst = Driver->Create (DstFile, xSize, ySize, 5, GDT_Float32, NULL);
	DSDst->SetProjection (DSSensorZenith->GetProjectionRef ());
	DSDst->SetGeoTransform (geoTransform);
#pragma endregion 	
#pragma region д4νǶ رݼ


	if (datatype == GDT_Int16)
	{
		DT_32F *pBuf_32 = new DT_32F[xSize*ySize];
		DT_16S *pBuf_16 = new DT_16S[xSize*ySize];
		GDALRasterBand *band1 = DSDst->GetRasterBand (1);
		GDALRasterBand *band2 = DSDst->GetRasterBand (2);
		GDALRasterBand *band3 = DSDst->GetRasterBand (3);
		GDALRasterBand *band4 = DSDst->GetRasterBand (4);
		GDALRasterBand *band5 = DSDst->GetRasterBand (5);
		DSSensorZenith->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//1
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band1->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д1
		DSSensorAzimuth->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//2
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band2->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д2
		DSSolarZenith->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//3
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band3->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д3
		DSSolarAzimuth->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);//4
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		JiSuanJiaoDu (pBuf_32, xSize*ySize);
		band4->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0); //д4


		DSLanSea->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf_16, xSize, ySize, datatype, 0, 0);
		CopyIntToFloat (pBuf_16, pBuf_32, xSize*ySize);
		band5->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf_32, xSize, ySize, GDT_Float32, 0, 0);  //д

		delete[]pBuf_16;
		delete[]pBuf_32;
	}
	GDALClose (GDALDatasetH (DSSensorZenith));
	GDALClose (GDALDatasetH (DSSensorAzimuth));
	GDALClose (GDALDatasetH (DSSolarZenith));
	GDALClose (GDALDatasetH (DSSolarAzimuth));
	GDALClose (GDALDatasetH (DSDst));
	GDALClose (GDALDatasetH (DS3));
	GDALClose (GDALDatasetH (DSLanSea));
	return RE_SUCCESS;
#pragma endregion 
}
//int AODGetGeolocOfModis3 (const char* SrcFile3, char ***geoloc)
//{
//#pragma region עݼ
//	GDALAllRegister ();
//	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
//	GDALDataset *DS3 = (GDALDataset*)GDALOpen (SrcFile3, GA_ReadOnly);
//	char **subdatasets = GDALGetMetadata ((GDALDatasetH)DS3, "SUBDATASETS");
//#pragma endregion
//#pragma region ȡγݼ͵һݼ
//	string strSubDataset_1 = string (subdatasets[0]);//һݼ
//	strSubDataset_1 = strSubDataset_1.substr (strSubDataset_1.find_first_of ("=") + 1);
//	const char* SrcFile3_1 = strSubDataset_1.c_str ();
//
//	string strLat = string (subdatasets[24]);//lat
//	strLat = strLat.substr (strLat.find_first_of ("=") + 1);
//	const char* charLat = strLat.c_str ();
//
//	string strLon = string (subdatasets[26]);//lon
//	strLon = strLon.substr (strLon.find_first_of ("=") + 1);
//	const char* charLon = strLon.c_str ();
//#pragma endregion 
//#pragma region ȡһݼgeoloc
//	GDALDataset *DS3_1 = (GDALDataset*)GDALOpen (SrcFile3_1, GA_ReadOnly);
//	char **geolocOptions3 = DS3_1->GetMetadata ("GEOLOCATION");
//	char **geolocOptions = geolocOptions3;
//	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
//	if (geolocOptions3 == NULL)
//	{
//
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_OFFSET", "0");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_OFFSET", "0");
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "X_BAND", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "Y_BAND", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "X_DATASET", charLon);
//		geolocOptions = CSLSetNameValue (geolocOptions, "Y_DATASET", charLat);
//	}
//	else
//	{
//		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
//		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
//	}
//	for (int i = 0; i<8; i++)
//	{
//		strcpy ((*geoloc)[i], geolocOptions[i]);
//		/*if (geolocOptions[i]!=NULL)
//		{
//		delete []geolocOptions[i];
//		}*/
//	}
//	/*if (geolocOptions!=NULL)
//	{
//	delete []geolocOptions;
//	}*/
//	GDALClose (GDALDatasetH (DS3_1));
//	GDALClose (GDALDatasetH (DS3));
//	/*char** geoloc =new char *[8] ;
//	for (int i=0;i<8;i++)
//	{
//	geoloc[i]=(char*)(strarrgeoloc[i].c_str());
//	}*/
//	return RE_SUCCESS;
//#pragma endregion 	
//}
void AODInitialize (const char* charGeolocData, const char* charGeolocAngel)
{
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DSData = (GDALDataset*)GDALOpen (charGeolocData, GA_ReadOnly);
	GDALDataset *DSAngel = (GDALDataset*)GDALOpen (charGeolocAngel, GA_ReadOnly);
	int dataBandCount = DSData->GetRasterCount ();
	int angelBandCount = DSAngel->GetRasterCount ();
	GDALDataType dataType = DSData->GetRasterBand (1)->GetRasterDataType ();
	width = DSData->GetRasterXSize ();
	height = DSData->GetRasterYSize ();
#pragma endregion	
#pragma region  ̬Ķ
	band_1 = new float*[height];
	band_2 = new float*[height];
	band_3 = new float*[height];
	band_5 = new float*[height];
	band_7 = new float*[height];
	band_32 = new float*[height];
	aodndvi = new float*[height];//ndvi
	sensorzenith = new float*[height];//ĸǶ+ 1Էλ
	sensorazimuth = new float*[height];
	solarzenith = new float*[height];
	solarazimuth = new float*[height];
	relativeangel = new float*[height];
	lansea = new float*[height]; // ½
	suf_band_1 = new float*[height]; //ر
	suf_band_3 = new float*[height];
	aodOptimal = new float*[height]; //aod
	testresult = new test_result*[height];
	for (int i = 0; i<height; i++)
	{
		band_1[i] = new float[width];
		band_2[i] = new float[width];
		band_3[i] = new float[width];
		band_5[i] = new float[width];
		band_7[i] = new float[width];
		band_32[i] = new float[width];

		aodndvi[i] = new float[width];

		sensorzenith[i] = new float[width];
		sensorazimuth[i] = new float[width];
		solarzenith[i] = new float[width];
		solarazimuth[i] = new float[width];
		relativeangel[i] = new float[width];
		lansea[i] = new float[width];

		suf_band_1[i] = new float[width];
		suf_band_3[i] = new float[width];
		aodOptimal[i] = new float[width];
		testresult[i] = new test_result[width];
	}
#pragma endregion
#pragma region ̬ĳʼ
	//DT_64F *pBuf = (DT_64F*)malloc(sizeof(DT_64F)*width*height);
	DT_32F *pBuf = new DT_32F[width*height];
	int p = 0;
#pragma region ݲεĳʼ
	for (int i = 0; i<dataBandCount; i++)
	{
		if (dataType == GDT_Float32)
		{

			DSData->GetRasterBand (i + 1)->RasterIO (GF_Read, 0, 0, width, height, pBuf, width, height, dataType, 0, 0);
			p = 0;
			for (int j = 0; j<height; j++)
			{
				for (int k = 0; k<width; k++)
				{
					switch (i + 1)
					{
					case 1:band_1[j][k] = pBuf[p++];
						break;
					case 2:band_2[j][k] = pBuf[p++];
						break;
					case 3:band_3[j][k] = pBuf[p++];
						break;
					case 4:band_5[j][k] = pBuf[p++];
						break;
					case 5:band_7[j][k] = pBuf[p++];
						break;
					case 6:band_32[j][k] = pBuf[p++];
						break;
					}
				}
			}
		}
	}
#pragma endregion 
#pragma region ǶȲεĳʼ
	//ʼ4Ƕ
	for (int i = 0; i<angelBandCount; i++)
	{
		//DT_64F *pBuf = new DT_64F[width*height];int p=0;
		DSAngel->GetRasterBand (i + 1)->RasterIO (GF_Read, 0, 0, width, height, pBuf, width, height, dataType, 0, 0);
		int p = 0;
		for (int j = 0; j<height; j++)
		{
			for (int k = 0; k<width; k++)
			{
				switch (i + 1)
				{
				case 1:sensorzenith[j][k] = pBuf[p++];
					break;
				case 2:sensorazimuth[j][k] = pBuf[p++];
					break;
				case 3:solarzenith[j][k] = pBuf[p++];
					break;
				case 4:solarazimuth[j][k] = pBuf[p++];
					break;
				case 5:lansea[j][k] = pBuf[p++];
					break;
				}
			}
		}
	}
#pragma endregion 
	delete[]pBuf;
#pragma region ̬ĳʼ
	double senZen, senAzi, solZen, solAzi, relAng;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			testresult[i][j] = unknow;//
			aodndvi[i][j] = (band_5[i][j] - band_7[i][j]) / (band_5[i][j] + band_7[i][j]);//ndviĳʼ
			suf_band_1[i][j] = 0;
			suf_band_3[i][j] = 0;
			aodOptimal[i][j] = 0;
			//ԽǶȵĳʼ
			senZen = RAD_PER_DEG*sensorzenith[i][j];
			senAzi = RAD_PER_DEG*sensorazimuth[i][j];
			solZen = RAD_PER_DEG*solarzenith[i][j];
			solAzi = RAD_PER_DEG*solarazimuth[i][j];
			relAng = solAzi - senAzi;
			if (relAng<M_PI*(-1))
			{
				relAng += 2 * M_PI;
			}
			else if (relAng>M_PI)
			{
				relAng -= 2 * M_PI;
			}
			relAng += M_PI;//-pi~piת 0~2pi;
			//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * sin(senZen) * cos(relAng));
			//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * cos(relAng));
			relativeangel[i][j] = relAng;
		}
	}
#pragma endregion 
	GDALClose (GDALDatasetH (DSData));
	GDALClose (GDALDatasetH (DSAngel));

#pragma endregion	
}
void AODGetSeason (const char* SrcFile2)
{
	//"E:\\fire2\\firetest\\MOD279\\0220\\MOD021KM.A2014279.0220.006.2014283045932.hdf";
	string tempFileName = string (CPLGetFilename (SrcFile2));
	tempFileName = tempFileName.substr (tempFileName.find_last_of ("hdf") - 29, 3);
	seasonDay = (int)CPLScanDouble (tempFileName.c_str (), 20);
}
void AODDestroy ()
{
	for (int i = 0; i<height; i++)
	{
		RELEASE (band_1[i]);
		RELEASE (band_2[i]);
		RELEASE (band_3[i]);
		RELEASE (band_5[i]);
		RELEASE (band_7[i]);
		RELEASE (band_32[i]);
		RELEASE (aodndvi[i]);
		RELEASE (sensorzenith[i]);
		RELEASE (sensorazimuth[i]);
		RELEASE (solarzenith[i]);
		RELEASE (solarazimuth[i]);
		RELEASE (relativeangel[i]);
		RELEASE (lansea[i]);
		RELEASE (suf_band_1[i]);
		RELEASE (suf_band_3[i]);
		RELEASE (aodOptimal[i]);
		RELEASE (testresult[i]);
	}	
	RELEASE (band_1);
	RELEASE (band_2);
	RELEASE (band_3);
	RELEASE (band_5);
	RELEASE (band_7);
	RELEASE (band_32);
	RELEASE (aodndvi);
	RELEASE (sensorzenith);
	RELEASE (sensorazimuth);
	RELEASE (solarzenith);
	RELEASE (solarazimuth);
	RELEASE (relativeangel);
	RELEASE (lansea);
	RELEASE (suf_band_1);
	RELEASE (suf_band_3);
	RELEASE (aodOptimal);
	RELEASE (testresult);
}
void AODIdentifyCloudAndWater ()
{
	//pr:Ԫں첨(0.66)ı۷band1
	//pn:ԪڽⲨ(0.86)ı۷band2
	//t12:ԪȺⲨΣ12um¶band32
	//t2:Ԫ2.12umθı۷band7
	float pr, pn, t12, t2;
	float senZen, solZen;

	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (!(fabs((double)lansea[i][j] - 1.0)<MIN_VALUE) || fabs((double)lansea[i][j] - 2.0)<MIN_VALUE)//ʶˮ
			{
				testresult[i][j] = shui;
			}
		}
	}
	//ʶ
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			pr = band_1[i][j];
			pn = band_2[i][j];
			t12 = band_32[i][j];
			if (testresult[i][j] != shui)
			{
				if ((pr + pn>th1) || (t12<th3) || ((pr + pn)>th2 && t12<th4))
				{
					testresult[i][j] = yun;
				}
			}

		}
	}

	//ʶԪ
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] != yun	&& testresult[i][j] != shui)//ˮĻʶԪ
			{
				t2 = band_7[i][j];
				senZen = RAD_PER_DEG*sensorzenith[i][j];
				solZen = RAD_PER_DEG*solarzenith[i][j];
				////if (t2>0.01 && t2<0.125 * (1 / cos (senZen) + 1 / (pow (cos ((double)solZen), 0.5))))//µķ
				////{
				////	testresult[i][j] = anxiangyuan;
				////}
				if (t2>0.01 && t2<0.4)
				{
				testresult[i][j]=anxiangyuan;
				}
			}
		}
	}
}
int AODOutputOther (const char* charSrcFile, const char* charDstFile, test_result res)
{
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILEAME_IS_UTF8", "NO");
	GDALDataset *SrcDS = (GDALDataset*)GDALOpen (charSrcFile, GA_ReadOnly);
	double geoTransform[6] = { 0 };
	SrcDS->GetGeoTransform (geoTransform);
	int xSize = SrcDS->GetRasterXSize ();
	int ySize = SrcDS->GetRasterYSize ();
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	GDALDataset *DstDS = Driver->Create (charDstFile, xSize, ySize, 1, GDT_Int32, NULL);
	DstDS->SetProjection (SrcDS->GetProjectionRef ());
	DstDS->SetGeoTransform (geoTransform);
	//DT_32S *pBuf = (DT_32S*)malloc(sizeof(DT_32S)*width*height);
	DT_32S *pBuf = new DT_32S[width*height];
	int p = 0;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == res)
			{
				pBuf[p] = 1;
			}
			else
			{
				pBuf[p] = 0;
			}
			p++;
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, width, height, pBuf, width, height, GDT_Int32, 0, 0);
	delete[]pBuf;
	GDALClose (GDALDatasetH (SrcDS));
	GDALClose (GDALDatasetH (DstDS));
	return RE_SUCCESS;
}
void AODConfirmSurfaceReflectance ()
{
	//senZen:۲⣨춥
	//senAzi:۲⣨Էλ
	//solZen:̫춥
	//solAzi:̫λ
	//scaAngɢ
	//relAng:Էλ
	float senZen, senAzi, solZen, solAzi, scaAng, relAng;
	float slope_066_212_scale, slope_066_212_offset;
	float slope_ndvi_066_212_scale, slope_ndvi_066_212_offset;
	float slope_047_066_scale = 0.49, slope_047_066_offset = 0.005;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				senZen = RAD_PER_DEG*sensorzenith[i][j];
				senAzi = RAD_PER_DEG*sensorazimuth[i][j];
				solZen = RAD_PER_DEG*solarzenith[i][j];
				solAzi = RAD_PER_DEG*solarazimuth[i][j];
				//relAng=solAzi-senAzi;
				//if (relAng<M_PI*(-1))
				//{
				//	relAng+=2*M_PI;
				//}
				//else if (relAng>M_PI)
				//{
				//	relAng-=2*M_PI;
				//}
				//relAng+=M_PI;//-pi~piת 0~2pi;
				scaAng = acos ((-1) * cos (solZen) * cos (senZen) + sin (solZen) * sin (senZen) * cos (relativeangel[i][j]));
				//scaAng=acos((-1) * cos(solZen) * cos(senZen)+sin(solZen) * cos(relAng));
				//v5.2ݷ
				if (band_7[i][j] >= 0.01 && band_7[i][j] <= 0.25)
				{
					if (aodndvi[i][j]<0.25)
					{
						slope_ndvi_066_212_scale = 0.48;
					}
					else if (aodndvi[i][j]>0.75)
					{
						slope_ndvi_066_212_scale = 0.58;
					}
					else
					{
						slope_ndvi_066_212_scale = 0.48 + 0.2*(aodndvi[i][j] - 0.25);
					}
					slope_066_212_scale = slope_ndvi_066_212_scale + 0.002* scaAng - 0.27;
					slope_066_212_offset = 0.00025 * scaAng + 0.033;
					suf_band_1[i][j] = band_7[i][j] * slope_066_212_scale + slope_066_212_offset;
					suf_band_3[i][j] = suf_band_1[i][j] * slope_047_066_scale + slope_047_066_offset;

				}
				else if (band_7[i][j]>0.25)
				{
					suf_band_1[i][j] = band_7[i][j] / 2;
					suf_band_3[i][j] = band_7[i][j] / 4;
				}

				////չԪ
				//	 suf_band_1[i][j]=band_7[i][j]/2;
				//	 suf_band_3[i][j]=band_7[i][j]/4;
				//BRDF
				// AOD ݹѵرΪʲԴ ַ˵رṹķԶԵر
				//Ӱ죮 ǵرԶԵرʵӰ죬 

			}
		}
	}
}
float Mean(double* err, int length, double* aod550)
{




#pragma region old 
	double temp = 1.0;
	double sum = 0.0;
	double k = 0;
	double min1 = 10000;
	int min1pos = -1;
	int min2pos = -1;
	double min2 = 10000;
	//ҵСֵ
	for (int i = 0; i < length; i++)
	{
		if (err[i] <min1)
		{
			min1 = err[i];
			min1pos = i;
		}
	}
	//ҵ2Сֵ
	for (int  i = 0; i < length; i++)
	{
		if ((!(fabs(err[i] - min1) < MIN_VALUE)) && err[i] < min2)
		{
			min2 = err[i];
			min2pos = i;
		}

	}
	//return (min2  *aod550[min1pos] + min1 * aod550[min2pos]) / (min1 +  min2);
	return (min2 *min2 *aod550[min1pos] + min1* min1  * aod550[min2pos]) / (min1*min1 + min2* min2);
#pragma endregion 
	//////////////////////////////////////
	//for (int i = 0; i < length; i++)
	//{
	//	temp *= err[i];
	//}
	//for (int i = 0; i < length; i++)
	//{
	//	sum += temp / err[i] * aod550[i];
	//}
	//for (int i = 0; i < length; i++)
	//{
	//	k += temp / err[i];
	//}
	//return (sum)/k;

}




//ӲұлȡǸŻкŴ0 ʼġ
//void SearchOptimalResultFromOld(int i, int j, int* trueRow)
//{
//	int searchSolZen = 0, searchSenZen = 0, searchRelAzi = 0;
//	int trueSolzen = 0, trueSenZen = 0, trueRelAzi = 0;
//	int trueRow = 0;
//	float minthereflectivity = 0, thereflectivity = 0;
//
//	searchSolZen = solZenCount - 1, searchSenZen = senZenCount - 1, searchRelAzi = solAziCount - 1;//Ĭֵ
//	minthereflectivity = 1000000000;//minvalΪ㹻ֵ
//	float devk1 = 0, devk2 = 0, devk3 = 0;
//	float devkk1 = 0, devkk2, devkk3 = 0;
//
//
//	for (int k = 0; k<solZenCount; k++)
//	{
//		if (solarzenith[i][j]<solZen[k])
//		{
//			searchSolZen = k;
//			break;
//		}
//	}
//	for (int k = 0; k<senZenCount; k++)
//	{
//		if (sensorzenith[i][j]<senZen[k])
//		{
//			searchSenZen = k;
//			break;
//		}
//	}
//	for (int k = 0; k<solAziCount; k++)
//	{
//		if ((relativeangel[i][j])<solAzi[k])
//		{
//			searchRelAzi = k;
//			break;
//		}
//	}
//	devk1 = solZen[searchSolZen] - solZen[searchSolZen - 1];
//	devk2 = senZen[searchSenZen] - senZen[searchSenZen - 1];
//	devk3 = solAzi[searchRelAzi] - solAzi[searchRelAzi - 1];
//	if (solarzenith[i][j]>(solZen[searchSolZen - 1] + solZen[searchSolZen]) / 2)
//	{
//		devkk1 = abs(solarzenith[i][j] - solZen[searchSolZen]);
//		trueSolzen = searchSolZen;
//	}
//	else
//	{
//		devkk1 = abs(solarzenith[i][j] - solZen[searchSolZen - 1]);
//		trueSolzen = searchSolZen - 1;
//	}
//	if (sensorzenith[i][j]>(senZen[searchSenZen - 1] + senZen[searchSenZen]) / 2)
//	{
//		devkk2 = abs(sensorzenith[i][j] - senZen[searchSenZen]);
//		trueSenZen = searchSenZen;
//	}
//	else
//	{
//		devkk2 = abs(sensorzenith[i][j] - senZen[searchSenZen - 1]);
//		trueSenZen = searchSenZen - 1;
//	}
//	if (solarazimuth[i][j]>(solAzi[searchRelAzi - 1] + solAzi[searchRelAzi]) / 2)
//	{
//		devkk3 = abs(solarazimuth[i][j] - solAzi[searchRelAzi]);
//		trueRelAzi = searchRelAzi;
//	}
//	else
//	{
//		devkk3 = abs(solarazimuth[i][j] - solAzi[searchRelAzi - 1]);
//		trueRelAzi = searchRelAzi - 1;
//	}
//	/*
//	const int solZenCount = 8;
//	const int senZenCount = 7;
//	const int solAziCount = 9;
//	const int aod550Count = 6;
//	*/
//	*trueRow = (senZenCount * solAziCount) * trueSolzen + (solAziCount)* trueSenZen + (1) * trueRelAzi;
//}
//
//float CalulateInterpolation(int i, int j, float** inTable , int inTableCol, int  inTableRow)
//{
//	int row = i / intervalCount;
//	int row2 = i % intervalCount;
//	float f0= inTable[row][j];
//	float f1 = inTable[row + 1][j];
//	float x = ((float)row2) / intervalCount;
//	return f0 * (1 - x) + f1 * x;
//
//
//	//int row = i / inTableRow;
//	//int col = j/ inTableCol;
//	//int row2 = i%inTableRow;
//	//int col2 = j%inTableCol;
//	//float f00 = inTable[row][col];
//	//float f10 = inTable[row + 1][col];
//	//float f01 = inTable[row][col + 1];
//	//float f11 = inTable[row + 1][col + 1];
//	//float x =((float) row2 )  / inTableRow;
//	//float y = ((float)col2)  / inTableCol;
//	////f(x, y) = f(0, 0)(1 - x)(1 - y) + f(0, 1)(1 - x)y + f(1, 1)xy + f(1, 0)x(1 - y)
//	//float fxy = f00 * (1 - x)*(1 - y ) + f01 * (1 - x) * y + f11 * x * y + f10 * x * (1 - y);
//	//return   fxy;
//}
//void CreateNewSeachTable(float** inTable, float ** outTable, int inTableCol,int  inTableRow, int outTableCol, int outTableRow)
//{
//
//	//const int searchTabColCount = 7;   //ұ
//	//const int  intervalCount = 5;           //ұֵ
//	//const int solZenCount = 8;         //̫춥Ǹ
//	//const int senZenCount = 7;		   //춥Ǹ
//	//const int solAziCount = 9;		   //λǸʵԷλǸ
//	//const int aod550Count = 6;		   //aod
//	//double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 72, 84 };//̫춥
//	//double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
//	//double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
//	//double aod550[aod550Count] = { 0.0001, 0.25, 0.5, 1.0, 1.5, 1.95 };//550nmܽѧ
//	//for (int  i = 0; i < inTableRow; i++)
//	//{
//	//	for (int  j = 0; j < inTableCol; j++)
//	//	{    
//	//		//outTable
//	//		for (int k1 = 0; k1 <intervalCount; k1++)
//	//		{
//	//			for (int k2 = 0; k2 < intervalCount; k2++)
//	//			{
//	//				outTable[i*intervalCount + k1][j*intervalCount + k2] = calculate(inTable[i][j], inTable[i][], k1, k2);
//	//			}
//	//		}
//	//		//outTable[i*intervalCount +k1]
//	//	}
//	//}
//	//for (int  i = 0; i < outTableRow; i++)
//	//{
//	//	for (int  j = 0; j < outTableCol; j++)
//	//	{
//	//		outTable[i][j] = CalulateInterpolation(i, j, inTable , inTableCol, inTableRow);
//	//	}
//	//}
//
//
//	for (int i = 0; i < outTableRow -1; i++)
//	{
//		for (int  j = 0; j < outTableCol; j++)
//		{
//			outTable[i][j] = CalulateInterpolation(i, j, inTable, inTableCol, inTableRow);
//
//		}
//	}
//
//
//
//}

//float SearchOptimalResultFromNew(int x, int y, float** outTable, int  outTableRow, int  outTableCol)
//{
//
//	for (int i = 0; i < outTableRow; i++)
//	{
//		
//		for (int  i = 0; i < outTableCol; i++)
//		{
//
//
//		}
//
//	}
//	
//}




void AODCalculate ()
{
	
	//const int searchTabColCount = 7;   //ұ
	//const int  intervalCount = 5;           //ұֵ
	//const int solZenCount = 8;         //̫춥Ǹ
	//const int senZenCount = 7;		   //춥Ǹ
	//const int solAziCount = 9;		   //λǸʵԷλǸ
	//const int aod550Count = 6;		   //aod
	//double solZen[solZenCount] = { 0, 12, 24, 36, 48, 60, 72, 84 };//̫춥
	//double senZen[senZenCount] = { 0, 12, 24, 36, 48, 60, 66 };//춥
	//double solAzi[solAziCount] = { 0, 24, 48, 72, 96, 120, 144, 168, 180 };//̫λ(ǷλΪ0ԷλΪO180)
	//double aod550[aod550Count] = { 0.0001, 0.25, 0.5, 1.0, 1.5, 1.95 };//550nmܽѧ


	
#pragma region ļұ
	float aodSumSearchTable[solZenCount * senZenCount *solAziCount *aod550Count][searchTabColCount] =
	{ { 0.04618, 0.95014, 0.01889, 0, 0, 0, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 24, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 48, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 72, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 96, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 120, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 144, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 168, 0.0001 },
	{ 0.04618, 0.95014, 0.01889, 0, 0, 180, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 0, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 24, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 48, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 72, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 96, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 120, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 144, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 168, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 0, 12, 180, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 0, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 24, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 48, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 72, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 96, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 120, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 144, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 168, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 0, 24, 180, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 0, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 24, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 48, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 72, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 96, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 120, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 144, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 168, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 0, 36, 180, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 0, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 24, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 48, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 72, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 96, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 120, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 144, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 168, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 0, 48, 180, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 0, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 24, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 48, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 72, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 96, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 120, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 144, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 168, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 0, 60, 180, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 0, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 24, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 48, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 72, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 96, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 120, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 144, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 168, 0.0001 },
	{ 0.04618, 0.91642, 0.02794, 0, 66, 180, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 0, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 24, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 48, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 72, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 96, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 120, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 144, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 168, 0.0001 },
	{ 0.04618, 0.94961, 0.01893, 12, 0, 180, 0.0001 },
	{ 0.04618, 0.94907, 0.01974, 12, 12, 0, 0.0001 },
	{ 0.04618, 0.94907, 0.01968, 12, 12, 24, 0.0001 },
	{ 0.04618, 0.94907, 0.01948, 12, 12, 48, 0.0001 },
	{ 0.04618, 0.94907, 0.01921, 12, 12, 72, 0.0001 },
	{ 0.04618, 0.94907, 0.0189, 12, 12, 96, 0.0001 },
	{ 0.04618, 0.94907, 0.0186, 12, 12, 120, 0.0001 },
	{ 0.04618, 0.94907, 0.01838, 12, 12, 144, 0.0001 },
	{ 0.04618, 0.94907, 0.01826, 12, 12, 168, 0.0001 },
	{ 0.04618, 0.94907, 0.01824, 12, 12, 180, 0.0001 },
	{ 0.04618, 0.94734, 0.02071, 12, 24, 0, 0.0001 },
	{ 0.04618, 0.94734, 0.02057, 12, 24, 24, 0.0001 },
	{ 0.04618, 0.94734, 0.02018, 12, 24, 48, 0.0001 },
	{ 0.04618, 0.94734, 0.01963, 12, 24, 72, 0.0001 },
	{ 0.04618, 0.94734, 0.01902, 12, 24, 96, 0.0001 },
	{ 0.04618, 0.94734, 0.01845, 12, 24, 120, 0.0001 },
	{ 0.04618, 0.94734, 0.01803, 12, 24, 144, 0.0001 },
	{ 0.04618, 0.94734, 0.0178, 12, 24, 168, 0.0001 },
	{ 0.04618, 0.94734, 0.01777, 12, 24, 180, 0.0001 },
	{ 0.04618, 0.94398, 0.02201, 12, 36, 0, 0.0001 },
	{ 0.04618, 0.94398, 0.0218, 12, 36, 24, 0.0001 },
	{ 0.04618, 0.94398, 0.02122, 12, 36, 48, 0.0001 },
	{ 0.04618, 0.94398, 0.0204, 12, 36, 72, 0.0001 },
	{ 0.04618, 0.94398, 0.01951, 12, 36, 96, 0.0001 },
	{ 0.04618, 0.94398, 0.01872, 12, 36, 120, 0.0001 },
	{ 0.04618, 0.94398, 0.01813, 12, 36, 144, 0.0001 },
	{ 0.04618, 0.94398, 0.01782, 12, 36, 168, 0.0001 },
	{ 0.04618, 0.94398, 0.01778, 12, 36, 180, 0.0001 },
	{ 0.04618, 0.9379, 0.02414, 12, 48, 0, 0.0001 },
	{ 0.04618, 0.9379, 0.02386, 12, 48, 24, 0.0001 },
	{ 0.04618, 0.9379, 0.02309, 12, 48, 48, 0.0001 },
	{ 0.04618, 0.9379, 0.02202, 12, 48, 72, 0.0001 },
	{ 0.04618, 0.9379, 0.02089, 12, 48, 96, 0.0001 },
	{ 0.04618, 0.9379, 0.01992, 12, 48, 120, 0.0001 },
	{ 0.04618, 0.9379, 0.01923, 12, 48, 144, 0.0001 },
	{ 0.04618, 0.9379, 0.01887, 12, 48, 168, 0.0001 },
	{ 0.04618, 0.9379, 0.01883, 12, 48, 180, 0.0001 },
	{ 0.04618, 0.92623, 0.02839, 12, 60, 0, 0.0001 },
	{ 0.04618, 0.92623, 0.02803, 12, 60, 24, 0.0001 },
	{ 0.04618, 0.92623, 0.02706, 12, 60, 48, 0.0001 },
	{ 0.04618, 0.92623, 0.02576, 12, 60, 72, 0.0001 },
	{ 0.04618, 0.92623, 0.02445, 12, 60, 96, 0.0001 },
	{ 0.04618, 0.92623, 0.02338, 12, 60, 120, 0.0001 },
	{ 0.04618, 0.92623, 0.02267, 12, 60, 144, 0.0001 },
	{ 0.04618, 0.92623, 0.02232, 12, 60, 168, 0.0001 },
	{ 0.04618, 0.92623, 0.02228, 12, 60, 180, 0.0001 },
	{ 0.04618, 0.9159, 0.03238, 12, 66, 0, 0.0001 },
	{ 0.04618, 0.9159, 0.03198, 12, 66, 24, 0.0001 },
	{ 0.04618, 0.9159, 0.0309, 12, 66, 48, 0.0001 },
	{ 0.04618, 0.9159, 0.02949, 12, 66, 72, 0.0001 },
	{ 0.04618, 0.9159, 0.0281, 12, 66, 96, 0.0001 },
	{ 0.04618, 0.9159, 0.02703, 12, 66, 120, 0.0001 },
	{ 0.04618, 0.9159, 0.02636, 12, 66, 144, 0.0001 },
	{ 0.04618, 0.9159, 0.02605, 12, 66, 168, 0.0001 },
	{ 0.04618, 0.9159, 0.02601, 12, 66, 180, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 0, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 24, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 48, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 72, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 96, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 120, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 144, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 168, 0.0001 },
	{ 0.04618, 0.94788, 0.0191, 24, 0, 180, 0.0001 },
	{ 0.04618, 0.94734, 0.02071, 24, 12, 0, 0.0001 },
	{ 0.04618, 0.94734, 0.02057, 24, 12, 24, 0.0001 },
	{ 0.04618, 0.94734, 0.02018, 24, 12, 48, 0.0001 },
	{ 0.04618, 0.94734, 0.01963, 24, 12, 72, 0.0001 },
	{ 0.04618, 0.94734, 0.01902, 24, 12, 96, 0.0001 },
	{ 0.04618, 0.94734, 0.01845, 24, 12, 120, 0.0001 },
	{ 0.04618, 0.94734, 0.01803, 24, 12, 144, 0.0001 },
	{ 0.04618, 0.94734, 0.0178, 24, 12, 168, 0.0001 },
	{ 0.04618, 0.94734, 0.01777, 24, 12, 180, 0.0001 },
	{ 0.04618, 0.94562, 0.02262, 24, 24, 0, 0.0001 },
	{ 0.04618, 0.94562, 0.02232, 24, 24, 24, 0.0001 },
	{ 0.04618, 0.94562, 0.02151, 24, 24, 48, 0.0001 },
	{ 0.04618, 0.94562, 0.02037, 24, 24, 72, 0.0001 },
	{ 0.04618, 0.94562, 0.01916, 24, 24, 96, 0.0001 },
	{ 0.04618, 0.94562, 0.0181, 24, 24, 120, 0.0001 },
	{ 0.04618, 0.94562, 0.01733, 24, 24, 144, 0.0001 },
	{ 0.04618, 0.94562, 0.01693, 24, 24, 168, 0.0001 },
	{ 0.04618, 0.94562, 0.01688, 24, 24, 180, 0.0001 },
	{ 0.04618, 0.94226, 0.025, 24, 36, 0, 0.0001 },
	{ 0.04618, 0.94226, 0.02453, 24, 36, 24, 0.0001 },
	{ 0.04618, 0.94226, 0.02326, 24, 36, 48, 0.0001 },
	{ 0.04618, 0.94226, 0.02153, 24, 36, 72, 0.0001 },
	{ 0.04618, 0.94226, 0.01977, 24, 36, 96, 0.0001 },
	{ 0.04618, 0.94226, 0.0183, 24, 36, 120, 0.0001 },
	{ 0.04618, 0.94226, 0.01729, 24, 36, 144, 0.0001 },
	{ 0.04618, 0.94226, 0.0168, 24, 36, 168, 0.0001 },
	{ 0.04618, 0.94226, 0.01674, 24, 36, 180, 0.0001 },
	{ 0.04618, 0.93619, 0.02839, 24, 48, 0, 0.0001 },
	{ 0.04618, 0.93619, 0.02772, 24, 48, 24, 0.0001 },
	{ 0.04618, 0.93619, 0.02595, 24, 48, 48, 0.0001 },
	{ 0.04618, 0.93619, 0.02363, 24, 48, 72, 0.0001 },
	{ 0.04618, 0.93619, 0.02137, 24, 48, 96, 0.0001 },
	{ 0.04618, 0.93619, 0.01963, 24, 48, 120, 0.0001 },
	{ 0.04618, 0.93619, 0.01856, 24, 48, 144, 0.0001 },
	{ 0.04618, 0.93619, 0.01807, 24, 48, 168, 0.0001 },
	{ 0.04618, 0.93619, 0.01802, 24, 48, 180, 0.0001 },
	{ 0.04618, 0.92454, 0.03426, 24, 60, 0, 0.0001 },
	{ 0.04618, 0.92454, 0.03336, 24, 60, 24, 0.0001 },
	{ 0.04618, 0.92454, 0.031, 24, 60, 48, 0.0001 },
	{ 0.04618, 0.92454, 0.02803, 24, 60, 72, 0.0001 },
	{ 0.04618, 0.92454, 0.02537, 24, 60, 96, 0.0001 },
	{ 0.04618, 0.92454, 0.02357, 24, 60, 120, 0.0001 },
	{ 0.04618, 0.92454, 0.02267, 24, 60, 144, 0.0001 },
	{ 0.04618, 0.92454, 0.02236, 24, 60, 168, 0.0001 },
	{ 0.04618, 0.92454, 0.02233, 24, 60, 180, 0.0001 },
	{ 0.04618, 0.91424, 0.03938, 24, 66, 0, 0.0001 },
	{ 0.04618, 0.91424, 0.03832, 24, 66, 24, 0.0001 },
	{ 0.04618, 0.91424, 0.03558, 24, 66, 48, 0.0001 },
	{ 0.04618, 0.91424, 0.03223, 24, 66, 72, 0.0001 },
	{ 0.04618, 0.91424, 0.02939, 24, 66, 96, 0.0001 },
	{ 0.04618, 0.91424, 0.02769, 24, 66, 120, 0.0001 },
	{ 0.04618, 0.91424, 0.02704, 24, 66, 144, 0.0001 },
	{ 0.04618, 0.91424, 0.02694, 24, 66, 168, 0.0001 },
	{ 0.04618, 0.91424, 0.02694, 24, 66, 180, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 0, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 24, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 48, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 72, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 96, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 120, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 144, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 168, 0.0001 },
	{ 0.04618, 0.94451, 0.0196, 36, 0, 180, 0.0001 },
	{ 0.04618, 0.94398, 0.02201, 36, 12, 0, 0.0001 },
	{ 0.04618, 0.94398, 0.0218, 36, 12, 24, 0.0001 },
	{ 0.04618, 0.94398, 0.02122, 36, 12, 48, 0.0001 },
	{ 0.04618, 0.94398, 0.0204, 36, 12, 72, 0.0001 },
	{ 0.04618, 0.94398, 0.01951, 36, 12, 96, 0.0001 },
	{ 0.04618, 0.94398, 0.01872, 36, 12, 120, 0.0001 },
	{ 0.04618, 0.94398, 0.01813, 36, 12, 144, 0.0001 },
	{ 0.04618, 0.94398, 0.01782, 36, 12, 168, 0.0001 },
	{ 0.04618, 0.94398, 0.01778, 36, 12, 180, 0.0001 },
	{ 0.04618, 0.94226, 0.025, 36, 24, 0, 0.0001 },
	{ 0.04618, 0.94226, 0.02453, 36, 24, 24, 0.0001 },
	{ 0.04618, 0.94226, 0.02326, 36, 24, 48, 0.0001 },
	{ 0.04618, 0.94226, 0.02153, 36, 24, 72, 0.0001 },
	{ 0.04618, 0.94226, 0.01977, 36, 24, 96, 0.0001 },
	{ 0.04618, 0.94226, 0.0183, 36, 24, 120, 0.0001 },
	{ 0.04618, 0.94226, 0.01729, 36, 24, 144, 0.0001 },
	{ 0.04618, 0.94226, 0.0168, 36, 24, 168, 0.0001 },
	{ 0.04618, 0.94226, 0.01674, 36, 24, 180, 0.0001 },
	{ 0.04618, 0.93892, 0.02877, 36, 36, 0, 0.0001 },
	{ 0.04618, 0.93892, 0.02799, 36, 36, 24, 0.0001 },
	{ 0.04618, 0.93892, 0.02592, 36, 36, 48, 0.0001 },
	{ 0.04618, 0.93892, 0.02322, 36, 36, 72, 0.0001 },
	{ 0.04618, 0.93892, 0.02063, 36, 36, 96, 0.0001 },
	{ 0.04618, 0.93892, 0.01866, 36, 36, 120, 0.0001 },
	{ 0.04618, 0.93892, 0.01746, 36, 36, 144, 0.0001 },
	{ 0.04618, 0.93892, 0.01694, 36, 36, 168, 0.0001 },
	{ 0.04618, 0.93892, 0.01688, 36, 36, 180, 0.0001 },
	{ 0.04618, 0.93287, 0.03397, 36, 48, 0, 0.0001 },
	{ 0.04618, 0.93287, 0.03282, 36, 48, 24, 0.0001 },
	{ 0.04618, 0.93287, 0.02981, 36, 48, 48, 0.0001 },
	{ 0.04618, 0.93287, 0.02605, 36, 48, 72, 0.0001 },
	{ 0.04618, 0.93287, 0.0227, 36, 48, 96, 0.0001 },
	{ 0.04618, 0.93287, 0.02048, 36, 48, 120, 0.0001 },
	{ 0.04618, 0.93287, 0.01941, 36, 48, 144, 0.0001 },
	{ 0.04618, 0.93287, 0.01907, 36, 48, 168, 0.0001 },
	{ 0.04618, 0.93287, 0.01904, 36, 48, 180, 0.0001 },
	{ 0.04618, 0.92126, 0.04246, 36, 60, 0, 0.0001 },
	{ 0.04618, 0.92126, 0.04081, 36, 60, 24, 0.0001 },
	{ 0.04618, 0.92126, 0.03659, 36, 60, 48, 0.0001 },
	{ 0.04618, 0.92126, 0.03156, 36, 60, 72, 0.0001 },
	{ 0.04618, 0.92126, 0.02755, 36, 60, 96, 0.0001 },
	{ 0.04618, 0.92126, 0.02546, 36, 60, 120, 0.0001 },
	{ 0.04618, 0.92126, 0.02502, 36, 60, 144, 0.0001 },
	{ 0.04618, 0.92126, 0.02523, 36, 60, 168, 0.0001 },
	{ 0.04618, 0.92126, 0.02528, 36, 60, 180, 0.0001 },
	{ 0.04618, 0.91099, 0.04952, 36, 66, 0, 0.0001 },
	{ 0.04618, 0.91099, 0.04752, 36, 66, 24, 0.0001 },
	{ 0.04618, 0.91099, 0.04246, 36, 66, 48, 0.0001 },
	{ 0.04618, 0.91099, 0.03662, 36, 66, 72, 0.0001 },
	{ 0.04618, 0.91099, 0.03229, 36, 66, 96, 0.0001 },
	{ 0.04618, 0.91099, 0.03052, 36, 66, 120, 0.0001 },
	{ 0.04618, 0.91099, 0.03075, 36, 66, 144, 0.0001 },
	{ 0.04618, 0.91099, 0.03148, 36, 66, 168, 0.0001 },
	{ 0.04618, 0.91099, 0.0316, 36, 66, 180, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 0, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 24, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 48, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 72, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 96, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 120, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 144, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 168, 0.0001 },
	{ 0.04618, 0.93843, 0.02095, 48, 0, 180, 0.0001 },
	{ 0.04618, 0.9379, 0.02414, 48, 12, 0, 0.0001 },
	{ 0.04618, 0.9379, 0.02386, 48, 12, 24, 0.0001 },
	{ 0.04618, 0.9379, 0.02309, 48, 12, 48, 0.0001 },
	{ 0.04618, 0.9379, 0.02202, 48, 12, 72, 0.0001 },
	{ 0.04618, 0.9379, 0.02089, 48, 12, 96, 0.0001 },
	{ 0.04618, 0.9379, 0.01992, 48, 12, 120, 0.0001 },
	{ 0.04618, 0.9379, 0.01923, 48, 12, 144, 0.0001 },
	{ 0.04618, 0.9379, 0.01887, 48, 12, 168, 0.0001 },
	{ 0.04618, 0.9379, 0.01883, 48, 12, 180, 0.0001 },
	{ 0.04618, 0.93619, 0.02839, 48, 24, 0, 0.0001 },
	{ 0.04618, 0.93619, 0.02772, 48, 24, 24, 0.0001 },
	{ 0.04618, 0.93619, 0.02595, 48, 24, 48, 0.0001 },
	{ 0.04618, 0.93619, 0.02363, 48, 24, 72, 0.0001 },
	{ 0.04618, 0.93619, 0.02137, 48, 24, 96, 0.0001 },
	{ 0.04618, 0.93619, 0.01963, 48, 24, 120, 0.0001 },
	{ 0.04618, 0.93619, 0.01856, 48, 24, 144, 0.0001 },
	{ 0.04618, 0.93619, 0.01807, 48, 24, 168, 0.0001 },
	{ 0.04618, 0.93619, 0.01802, 48, 24, 180, 0.0001 },
	{ 0.04618, 0.93287, 0.03397, 48, 36, 0, 0.0001 },
	{ 0.04618, 0.93287, 0.03282, 48, 36, 24, 0.0001 },
	{ 0.04618, 0.93287, 0.02981, 48, 36, 48, 0.0001 },
	{ 0.04618, 0.93287, 0.02605, 48, 36, 72, 0.0001 },
	{ 0.04618, 0.93287, 0.0227, 48, 36, 96, 0.0001 },
	{ 0.04618, 0.93287, 0.02048, 48, 36, 120, 0.0001 },
	{ 0.04618, 0.93287, 0.01941, 48, 36, 144, 0.0001 },
	{ 0.04618, 0.93287, 0.01907, 48, 36, 168, 0.0001 },
	{ 0.04618, 0.93287, 0.01904, 48, 36, 180, 0.0001 },
	{ 0.04618, 0.92686, 0.04176, 48, 48, 0, 0.0001 },
	{ 0.04618, 0.92686, 0.03998, 48, 48, 24, 0.0001 },
	{ 0.04618, 0.92686, 0.03542, 48, 48, 48, 0.0001 },
	{ 0.04618, 0.92686, 0.02997, 48, 48, 72, 0.0001 },
	{ 0.04618, 0.92686, 0.0256, 48, 48, 96, 0.0001 },
	{ 0.04618, 0.92686, 0.02329, 48, 48, 120, 0.0001 },
	{ 0.04618, 0.92686, 0.02277, 48, 48, 144, 0.0001 },
	{ 0.04618, 0.92686, 0.02295, 48, 48, 168, 0.0001 },
	{ 0.04618, 0.92686, 0.023, 48, 48, 180, 0.0001 },
	{ 0.04618, 0.91533, 0.05427, 48, 60, 0, 0.0001 },
	{ 0.04618, 0.91533, 0.05159, 48, 60, 24, 0.0001 },
	{ 0.04618, 0.91533, 0.04488, 48, 60, 48, 0.0001 },
	{ 0.04618, 0.91533, 0.03729, 48, 60, 72, 0.0001 },
	{ 0.04618, 0.91533, 0.03194, 48, 60, 96, 0.0001 },
	{ 0.04618, 0.91533, 0.03019, 48, 60, 120, 0.0001 },
	{ 0.04618, 0.91533, 0.03111, 48, 60, 144, 0.0001 },
	{ 0.04618, 0.91533, 0.03247, 48, 60, 168, 0.0001 },
	{ 0.04618, 0.91533, 0.03269, 48, 60, 180, 0.0001 },
	{ 0.04618, 0.90512, 0.06445, 48, 66, 0, 0.0001 },
	{ 0.04618, 0.90512, 0.06112, 48, 66, 24, 0.0001 },
	{ 0.04618, 0.90512, 0.05286, 48, 66, 48, 0.0001 },
	{ 0.04618, 0.90512, 0.0438, 48, 66, 72, 0.0001 },
	{ 0.04618, 0.90512, 0.03794, 48, 66, 96, 0.0001 },
	{ 0.04618, 0.90512, 0.03689, 48, 66, 120, 0.0001 },
	{ 0.04618, 0.90512, 0.03917, 48, 66, 144, 0.0001 },
	{ 0.04618, 0.90512, 0.04157, 48, 66, 168, 0.0001 },
	{ 0.04618, 0.90512, 0.04194, 48, 66, 180, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 0, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 24, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 48, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 72, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 96, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 120, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 144, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 168, 0.0001 },
	{ 0.04618, 0.92675, 0.0244, 60, 0, 180, 0.0001 },
	{ 0.04618, 0.92623, 0.02839, 60, 12, 0, 0.0001 },
	{ 0.04618, 0.92623, 0.02803, 60, 12, 24, 0.0001 },
	{ 0.04618, 0.92623, 0.02706, 60, 12, 48, 0.0001 },
	{ 0.04618, 0.92623, 0.02576, 60, 12, 72, 0.0001 },
	{ 0.04618, 0.92623, 0.02445, 60, 12, 96, 0.0001 },
	{ 0.04618, 0.92623, 0.02338, 60, 12, 120, 0.0001 },
	{ 0.04618, 0.92623, 0.02267, 60, 12, 144, 0.0001 },
	{ 0.04618, 0.92623, 0.02232, 60, 12, 168, 0.0001 },
	{ 0.04618, 0.92623, 0.02228, 60, 12, 180, 0.0001 },
	{ 0.04618, 0.92454, 0.03427, 60, 24, 0, 0.0001 },
	{ 0.04618, 0.92454, 0.03336, 60, 24, 24, 0.0001 },
	{ 0.04618, 0.92454, 0.031, 60, 24, 48, 0.0001 },
	{ 0.04618, 0.92454, 0.02803, 60, 24, 72, 0.0001 },
	{ 0.04618, 0.92454, 0.02537, 60, 24, 96, 0.0001 },
	{ 0.04618, 0.92454, 0.02357, 60, 24, 120, 0.0001 },
	{ 0.04618, 0.92454, 0.02267, 60, 24, 144, 0.0001 },
	{ 0.04618, 0.92454, 0.02236, 60, 24, 168, 0.0001 },
	{ 0.04618, 0.92454, 0.02233, 60, 24, 180, 0.0001 },
	{ 0.04618, 0.92126, 0.04246, 60, 36, 0, 0.0001 },
	{ 0.04618, 0.92126, 0.04081, 60, 36, 24, 0.0001 },
	{ 0.04618, 0.92126, 0.03659, 60, 36, 48, 0.0001 },
	{ 0.04618, 0.92126, 0.03156, 60, 36, 72, 0.0001 },
	{ 0.04618, 0.92126, 0.02755, 60, 36, 96, 0.0001 },
	{ 0.04618, 0.92126, 0.02546, 60, 36, 120, 0.0001 },
	{ 0.04618, 0.92126, 0.02502, 60, 36, 144, 0.0001 },
	{ 0.04618, 0.92126, 0.02523, 60, 36, 168, 0.0001 },
	{ 0.04618, 0.92126, 0.02528, 60, 36, 180, 0.0001 },
	{ 0.04618, 0.91533, 0.05427, 60, 48, 0, 0.0001 },
	{ 0.04618, 0.91533, 0.05159, 60, 48, 24, 0.0001 },
	{ 0.04618, 0.91533, 0.04489, 60, 48, 48, 0.0001 },
	{ 0.04618, 0.91533, 0.03729, 60, 48, 72, 0.0001 },
	{ 0.04618, 0.91533, 0.03194, 60, 48, 96, 0.0001 },
	{ 0.04618, 0.91533, 0.03019, 60, 48, 120, 0.0001 },
	{ 0.04618, 0.91533, 0.03111, 60, 48, 144, 0.0001 },
	{ 0.04618, 0.91533, 0.03247, 60, 48, 168, 0.0001 },
	{ 0.04618, 0.91533, 0.03269, 60, 48, 180, 0.0001 },
	{ 0.04618, 0.90394, 0.0734, 60, 60, 0, 0.0001 },
	{ 0.04618, 0.90394, 0.0692, 60, 60, 24, 0.0001 },
	{ 0.04618, 0.90394, 0.05886, 60, 60, 48, 0.0001 },
	{ 0.04618, 0.90394, 0.04773, 60, 60, 72, 0.0001 },
	{ 0.04618, 0.90394, 0.041, 60, 60, 96, 0.0001 },
	{ 0.04618, 0.90394, 0.04061, 60, 60, 120, 0.0001 },
	{ 0.04618, 0.90394, 0.04441, 60, 60, 144, 0.0001 },
	{ 0.04618, 0.90394, 0.04802, 60, 60, 168, 0.0001 },
	{ 0.04618, 0.90394, 0.04856, 60, 60, 180, 0.0001 },
	{ 0.04618, 0.89386, 0.08889, 60, 66, 0, 0.0001 },
	{ 0.04618, 0.89386, 0.08355, 60, 66, 24, 0.0001 },
	{ 0.04618, 0.89386, 0.0705, 60, 66, 48, 0.0001 },
	{ 0.04618, 0.89386, 0.05684, 60, 66, 72, 0.0001 },
	{ 0.04618, 0.89386, 0.04932, 60, 66, 96, 0.0001 },
	{ 0.04618, 0.89386, 0.05031, 60, 66, 120, 0.0001 },
	{ 0.04618, 0.89386, 0.05664, 60, 66, 144, 0.0001 },
	{ 0.04618, 0.89386, 0.06217, 60, 66, 168, 0.0001 },
	{ 0.04618, 0.89386, 0.06299, 60, 66, 180, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 0, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 24, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 48, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 72, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 96, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 120, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 144, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 168, 0.0001 },
	{ 0.04618, 0.89944, 0.03425, 72, 0, 180, 0.0001 },
	{ 0.04618, 0.89894, 0.03925, 72, 12, 0, 0.0001 },
	{ 0.04618, 0.89894, 0.03879, 72, 12, 24, 0.0001 },
	{ 0.04618, 0.89894, 0.03758, 72, 12, 48, 0.0001 },
	{ 0.04618, 0.89894, 0.03603, 72, 12, 72, 0.0001 },
	{ 0.04618, 0.89894, 0.03459, 72, 12, 96, 0.0001 },
	{ 0.04618, 0.89894, 0.03356, 72, 12, 120, 0.0001 },
	{ 0.04618, 0.89894, 0.03299, 72, 12, 144, 0.0001 },
	{ 0.04618, 0.89894, 0.03277, 72, 12, 168, 0.0001 },
	{ 0.04618, 0.89894, 0.03274, 72, 12, 180, 0.0001 },
	{ 0.04618, 0.8973, 0.04785, 72, 24, 0, 0.0001 },
	{ 0.04618, 0.8973, 0.04657, 72, 24, 24, 0.0001 },
	{ 0.04618, 0.8973, 0.04331, 72, 24, 48, 0.0001 },
	{ 0.04618, 0.8973, 0.03947, 72, 24, 72, 0.0001 },
	{ 0.04618, 0.8973, 0.03647, 72, 24, 96, 0.0001 },
	{ 0.04618, 0.8973, 0.03501, 72, 24, 120, 0.0001 },
	{ 0.04618, 0.8973, 0.03484, 72, 24, 144, 0.0001 },
	{ 0.04618, 0.8973, 0.0351, 72, 24, 168, 0.0001 },
	{ 0.04618, 0.8973, 0.03515, 72, 24, 180, 0.0001 },
	{ 0.04618, 0.89412, 0.06086, 72, 36, 0, 0.0001 },
	{ 0.04618, 0.89412, 0.05836, 72, 36, 24, 0.0001 },
	{ 0.04618, 0.89412, 0.05211, 72, 36, 48, 0.0001 },
	{ 0.04618, 0.89412, 0.04516, 72, 36, 72, 0.0001 },
	{ 0.04618, 0.89412, 0.0405, 72, 36, 96, 0.0001 },
	{ 0.04618, 0.89412, 0.03936, 72, 36, 120, 0.0001 },
	{ 0.04618, 0.89412, 0.04073, 72, 36, 144, 0.0001 },
	{ 0.04618, 0.89412, 0.04232, 72, 36, 168, 0.0001 },
	{ 0.04618, 0.89412, 0.04257, 72, 36, 180, 0.0001 },
	{ 0.04618, 0.88836, 0.08054, 72, 48, 0, 0.0001 },
	{ 0.04618, 0.88836, 0.07625, 72, 48, 24, 0.0001 },
	{ 0.04618, 0.88836, 0.06574, 72, 48, 48, 0.0001 },
	{ 0.04618, 0.88836, 0.05459, 72, 48, 72, 0.0001 },
	{ 0.04618, 0.88836, 0.04815, 72, 48, 96, 0.0001 },
	{ 0.04618, 0.88836, 0.04837, 72, 48, 120, 0.0001 },
	{ 0.04618, 0.88836, 0.05287, 72, 48, 144, 0.0001 },
	{ 0.04618, 0.88836, 0.05695, 72, 48, 168, 0.0001 },
	{ 0.04618, 0.88836, 0.05756, 72, 48, 180, 0.0001 },
	{ 0.04618, 0.8773, 0.11322, 72, 60, 0, 0.0001 },
	{ 0.04618, 0.8773, 0.10617, 72, 60, 24, 0.0001 },
	{ 0.04618, 0.8773, 0.08911, 72, 60, 48, 0.0001 },
	{ 0.04618, 0.8773, 0.07176, 72, 60, 72, 0.0001 },
	{ 0.04618, 0.8773, 0.06327, 72, 60, 96, 0.0001 },
	{ 0.04618, 0.8773, 0.06658, 72, 60, 120, 0.0001 },
	{ 0.04618, 0.8773, 0.07696, 72, 60, 144, 0.0001 },
	{ 0.04618, 0.8773, 0.08552, 72, 60, 168, 0.0001 },
	{ 0.04618, 0.8773, 0.08678, 72, 60, 180, 0.0001 },
	{ 0.04618, 0.86752, 0.13988, 72, 66, 0, 0.0001 },
	{ 0.04618, 0.86752, 0.13069, 72, 66, 24, 0.0001 },
	{ 0.04618, 0.86752, 0.10862, 72, 66, 48, 0.0001 },
	{ 0.04618, 0.86752, 0.08663, 72, 66, 72, 0.0001 },
	{ 0.04618, 0.86752, 0.07684, 72, 66, 96, 0.0001 },
	{ 0.04618, 0.86752, 0.08294, 72, 66, 120, 0.0001 },
	{ 0.04618, 0.86752, 0.09823, 72, 66, 144, 0.0001 },
	{ 0.04618, 0.86752, 0.11051, 72, 66, 168, 0.0001 },
	{ 0.04618, 0.86752, 0.1123, 72, 66, 180, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 0, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 24, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 48, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 72, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 96, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 120, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 144, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 168, 0.0001 },
	{ 0.04618, 0.78358, 0.08123, 84, 0, 180, 0.0001 },
	{ 0.04618, 0.78313, 0.08897, 84, 12, 0, 0.0001 },
	{ 0.04618, 0.78313, 0.08822, 84, 12, 24, 0.0001 },
	{ 0.04618, 0.78313, 0.08635, 84, 12, 48, 0.0001 },
	{ 0.04618, 0.78313, 0.08425, 84, 12, 72, 0.0001 },
	{ 0.04618, 0.78313, 0.08279, 84, 12, 96, 0.0001 },
	{ 0.04618, 0.78313, 0.08235, 84, 12, 120, 0.0001 },
	{ 0.04618, 0.78313, 0.08266, 84, 12, 144, 0.0001 },
	{ 0.04618, 0.78313, 0.08307, 84, 12, 168, 0.0001 },
	{ 0.04618, 0.78313, 0.08313, 84, 12, 180, 0.0001 },
	{ 0.04618, 0.78171, 0.1069, 84, 24, 0, 0.0001 },
	{ 0.04618, 0.78171, 0.10438, 84, 24, 24, 0.0001 },
	{ 0.04618, 0.78171, 0.09825, 84, 24, 48, 0.0001 },
	{ 0.04618, 0.78171, 0.09189, 84, 24, 72, 0.0001 },
	{ 0.04618, 0.78171, 0.0885, 84, 24, 96, 0.0001 },
	{ 0.04618, 0.78171, 0.08917, 84, 24, 120, 0.0001 },
	{ 0.04618, 0.78171, 0.09236, 84, 24, 144, 0.0001 },
	{ 0.04618, 0.78171, 0.0951, 84, 24, 168, 0.0001 },
	{ 0.04618, 0.78171, 0.0955, 84, 24, 180, 0.0001 },
	{ 0.04618, 0.77893, 0.13738, 84, 36, 0, 0.0001 },
	{ 0.04618, 0.77893, 0.13191, 84, 36, 24, 0.0001 },
	{ 0.04618, 0.77893, 0.11878, 84, 36, 48, 0.0001 },
	{ 0.04618, 0.77893, 0.10569, 84, 36, 72, 0.0001 },
	{ 0.04618, 0.77893, 0.09987, 84, 36, 96, 0.0001 },
	{ 0.04618, 0.77893, 0.1035, 84, 36, 120, 0.0001 },
	{ 0.04618, 0.77893, 0.1126, 84, 36, 144, 0.0001 },
	{ 0.04618, 0.77893, 0.1199, 84, 36, 168, 0.0001 },
	{ 0.04618, 0.77893, 0.12097, 84, 36, 180, 0.0001 },
	{ 0.04618, 0.77391, 0.18663, 84, 48, 0, 0.0001 },
	{ 0.04618, 0.77391, 0.1766, 84, 48, 24, 0.0001 },
	{ 0.04618, 0.77391, 0.15271, 84, 48, 48, 0.0001 },
	{ 0.04618, 0.77391, 0.12953, 84, 48, 72, 0.0001 },
	{ 0.04618, 0.77391, 0.12059, 84, 48, 96, 0.0001 },
	{ 0.04618, 0.77391, 0.12973, 84, 48, 120, 0.0001 },
	{ 0.04618, 0.77391, 0.14889, 84, 48, 144, 0.0001 },
	{ 0.04618, 0.77391, 0.16384, 84, 48, 168, 0.0001 },
	{ 0.04618, 0.77391, 0.16601, 84, 48, 180, 0.0001 },
	{ 0.04618, 0.76429, 0.27172, 84, 60, 0, 0.0001 },
	{ 0.04618, 0.76429, 0.25427, 84, 60, 24, 0.0001 },
	{ 0.04618, 0.76429, 0.21299, 84, 60, 48, 0.0001 },
	{ 0.04618, 0.76429, 0.17376, 84, 60, 72, 0.0001 },
	{ 0.04618, 0.76429, 0.16045, 84, 60, 96, 0.0001 },
	{ 0.04618, 0.76429, 0.17948, 84, 60, 120, 0.0001 },
	{ 0.04618, 0.76429, 0.21595, 84, 60, 144, 0.0001 },
	{ 0.04618, 0.76429, 0.24394, 84, 60, 168, 0.0001 },
	{ 0.04618, 0.76429, 0.24797, 84, 60, 180, 0.0001 },
	{ 0.04618, 0.75576, 0.34228, 84, 66, 0, 0.0001 },
	{ 0.04618, 0.75576, 0.31899, 84, 66, 24, 0.0001 },
	{ 0.04618, 0.75576, 0.26401, 84, 66, 48, 0.0001 },
	{ 0.04618, 0.75576, 0.21224, 84, 66, 72, 0.0001 },
	{ 0.04618, 0.75576, 0.19576, 84, 66, 96, 0.0001 },
	{ 0.04618, 0.75576, 0.22296, 84, 66, 120, 0.0001 },
	{ 0.04618, 0.75576, 0.27346, 84, 66, 144, 0.0001 },
	{ 0.04618, 0.75576, 0.31195, 84, 66, 168, 0.0001 },
	{ 0.04618, 0.75576, 0.31749, 84, 66, 180, 0.0001 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 0, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 24, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 48, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 72, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 96, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 120, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 144, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 168, 0.25 },
	{ 0.09545, 0.86427, 0.035, 0, 0, 180, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 0, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 24, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 48, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 72, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 96, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 120, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 144, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 168, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 0, 12, 180, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 0, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 24, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 48, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 72, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 96, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 120, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 144, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 168, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 0, 24, 180, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 0, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 24, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 48, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 72, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 96, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 120, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 144, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 168, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 0, 36, 180, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 0, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 24, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 48, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 72, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 96, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 120, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 144, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 168, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 0, 48, 180, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 0, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 24, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 48, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 72, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 96, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 120, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 144, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 168, 0.25 },
	{ 0.09545, 0.77949, 0.04612, 0, 60, 180, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 0, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 24, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 48, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 72, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 96, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 120, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 144, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 168, 0.25 },
	{ 0.09545, 0.74306, 0.05471, 0, 66, 180, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 0, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 24, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 48, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 72, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 96, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 120, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 144, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 168, 0.25 },
	{ 0.09545, 0.86242, 0.03243, 12, 0, 180, 0.25 },
	{ 0.09545, 0.86057, 0.03658, 12, 12, 0, 0.25 },
	{ 0.09545, 0.86057, 0.03568, 12, 12, 24, 0.25 },
	{ 0.09545, 0.86057, 0.03387, 12, 12, 48, 0.25 },
	{ 0.09545, 0.86057, 0.03266, 12, 12, 72, 0.25 },
	{ 0.09545, 0.86057, 0.03194, 12, 12, 96, 0.25 },
	{ 0.09545, 0.86057, 0.03139, 12, 12, 120, 0.25 },
	{ 0.09545, 0.86057, 0.03098, 12, 12, 144, 0.25 },
	{ 0.09545, 0.86057, 0.03077, 12, 12, 168, 0.25 },
	{ 0.09545, 0.86057, 0.03074, 12, 12, 180, 0.25 },
	{ 0.09545, 0.85454, 0.03554, 12, 24, 0, 0.25 },
	{ 0.09545, 0.85454, 0.03504, 12, 24, 24, 0.25 },
	{ 0.09545, 0.85454, 0.03415, 12, 24, 48, 0.25 },
	{ 0.09545, 0.85454, 0.03313, 12, 24, 72, 0.25 },
	{ 0.09545, 0.85454, 0.03207, 12, 24, 96, 0.25 },
	{ 0.09545, 0.85454, 0.03117, 12, 24, 120, 0.25 },
	{ 0.09545, 0.85454, 0.03054, 12, 24, 144, 0.25 },
	{ 0.09545, 0.85454, 0.03021, 12, 24, 168, 0.25 },
	{ 0.09545, 0.85454, 0.03017, 12, 24, 180, 0.25 },
	{ 0.09545, 0.84256, 0.03723, 12, 36, 0, 0.25 },
	{ 0.09545, 0.84256, 0.03686, 12, 36, 24, 0.25 },
	{ 0.09545, 0.84256, 0.03589, 12, 36, 48, 0.25 },
	{ 0.09545, 0.84256, 0.03462, 12, 36, 72, 0.25 },
	{ 0.09545, 0.84256, 0.03339, 12, 36, 96, 0.25 },
	{ 0.09545, 0.84256, 0.03241, 12, 36, 120, 0.25 },
	{ 0.09545, 0.84256, 0.03177, 12, 36, 144, 0.25 },
	{ 0.09545, 0.84256, 0.03146, 12, 36, 168, 0.25 },
	{ 0.09545, 0.84256, 0.03142, 12, 36, 180, 0.25 },
	{ 0.09545, 0.8204, 0.04114, 12, 48, 0, 0.25 },
	{ 0.09545, 0.8204, 0.04075, 12, 48, 24, 0.25 },
	{ 0.09545, 0.8204, 0.03975, 12, 48, 48, 0.25 },
	{ 0.09545, 0.8204, 0.03852, 12, 48, 72, 0.25 },
	{ 0.09545, 0.8204, 0.03741, 12, 48, 96, 0.25 },
	{ 0.09545, 0.8204, 0.03663, 12, 48, 120, 0.25 },
	{ 0.09545, 0.8204, 0.0362, 12, 48, 144, 0.25 },
	{ 0.09545, 0.8204, 0.03603, 12, 48, 168, 0.25 },
	{ 0.09545, 0.8204, 0.03601, 12, 48, 180, 0.25 },
	{ 0.09545, 0.77782, 0.04983, 12, 60, 0, 0.25 },
	{ 0.09545, 0.77782, 0.04949, 12, 60, 24, 0.25 },
	{ 0.09545, 0.77782, 0.04863, 12, 60, 48, 0.25 },
	{ 0.09545, 0.77782, 0.04769, 12, 60, 72, 0.25 },
	{ 0.09545, 0.77782, 0.04706, 12, 60, 96, 0.25 },
	{ 0.09545, 0.77782, 0.04691, 12, 60, 120, 0.25 },
	{ 0.09545, 0.77782, 0.0471, 12, 60, 144, 0.25 },
	{ 0.09545, 0.77782, 0.04733, 12, 60, 168, 0.25 },
	{ 0.09545, 0.77782, 0.04736, 12, 60, 180, 0.25 },
	{ 0.09545, 0.74147, 0.05786, 12, 66, 0, 0.25 },
	{ 0.09545, 0.74147, 0.05755, 12, 66, 24, 0.25 },
	{ 0.09545, 0.74147, 0.05686, 12, 66, 48, 0.25 },
	{ 0.09545, 0.74147, 0.05622, 12, 66, 72, 0.25 },
	{ 0.09545, 0.74147, 0.05609, 12, 66, 96, 0.25 },
	{ 0.09545, 0.74147, 0.05658, 12, 66, 120, 0.25 },
	{ 0.09545, 0.74147, 0.0574, 12, 66, 144, 0.25 },
	{ 0.09545, 0.74147, 0.05803, 12, 66, 168, 0.25 },
	{ 0.09545, 0.74147, 0.05811, 12, 66, 180, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 0, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 24, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 48, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 72, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 96, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 120, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 144, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 168, 0.25 },
	{ 0.09545, 0.85637, 0.0322, 24, 0, 180, 0.25 },
	{ 0.09545, 0.85454, 0.03554, 24, 12, 0, 0.25 },
	{ 0.09545, 0.85454, 0.03504, 24, 12, 24, 0.25 },
	{ 0.09545, 0.85454, 0.03415, 24, 12, 48, 0.25 },
	{ 0.09545, 0.85454, 0.03313, 24, 12, 72, 0.25 },
	{ 0.09545, 0.85454, 0.03207, 24, 12, 96, 0.25 },
	{ 0.09545, 0.85454, 0.03117, 24, 12, 120, 0.25 },
	{ 0.09545, 0.85454, 0.03054, 24, 12, 144, 0.25 },
	{ 0.09545, 0.85454, 0.03021, 24, 12, 168, 0.25 },
	{ 0.09545, 0.85454, 0.03017, 24, 12, 180, 0.25 },
	{ 0.09545, 0.84856, 0.042, 24, 24, 0, 0.25 },
	{ 0.09545, 0.84856, 0.03892, 24, 24, 24, 0.25 },
	{ 0.09545, 0.84856, 0.03645, 24, 24, 48, 0.25 },
	{ 0.09545, 0.84856, 0.03443, 24, 24, 72, 0.25 },
	{ 0.09545, 0.84856, 0.03256, 24, 24, 96, 0.25 },
	{ 0.09545, 0.84856, 0.03115, 24, 24, 120, 0.25 },
	{ 0.09545, 0.84856, 0.03027, 24, 24, 144, 0.25 },
	{ 0.09545, 0.84856, 0.02987, 24, 24, 168, 0.25 },
	{ 0.09545, 0.84856, 0.02982, 24, 24, 180, 0.25 },
	{ 0.09545, 0.83666, 0.04309, 24, 36, 0, 0.25 },
	{ 0.09545, 0.83666, 0.04176, 24, 36, 24, 0.25 },
	{ 0.09545, 0.83666, 0.03943, 24, 36, 48, 0.25 },
	{ 0.09545, 0.83666, 0.03673, 24, 36, 72, 0.25 },
	{ 0.09545, 0.83666, 0.03451, 24, 36, 96, 0.25 },
	{ 0.09545, 0.83666, 0.03308, 24, 36, 120, 0.25 },
	{ 0.09545, 0.83666, 0.03236, 24, 36, 144, 0.25 },
	{ 0.09545, 0.83666, 0.03212, 24, 36, 168, 0.25 },
	{ 0.09545, 0.83666, 0.03209, 24, 36, 180, 0.25 },
	{ 0.09545, 0.81465, 0.04822, 24, 48, 0, 0.25 },
	{ 0.09545, 0.81465, 0.04709, 24, 48, 24, 0.25 },
	{ 0.09545, 0.81465, 0.04437, 24, 48, 48, 0.25 },
	{ 0.09545, 0.81465, 0.04147, 24, 48, 72, 0.25 },
	{ 0.09545, 0.81465, 0.03943, 24, 48, 96, 0.25 },
	{ 0.09545, 0.81465, 0.03856, 24, 48, 120, 0.25 },
	{ 0.09545, 0.81465, 0.0386, 24, 48, 144, 0.25 },
	{ 0.09545, 0.81465, 0.03891, 24, 48, 168, 0.25 },
	{ 0.09545, 0.81465, 0.03896, 24, 48, 180, 0.25 },
	{ 0.09545, 0.77238, 0.05823, 24, 60, 0, 0.25 },
	{ 0.09545, 0.77238, 0.05703, 24, 60, 24, 0.25 },
	{ 0.09545, 0.77238, 0.05427, 24, 60, 48, 0.25 },
	{ 0.09545, 0.77238, 0.05165, 24, 60, 72, 0.25 },
	{ 0.09545, 0.77238, 0.05053, 24, 60, 96, 0.25 },
	{ 0.09545, 0.77238, 0.05134, 24, 60, 120, 0.25 },
	{ 0.09545, 0.77238, 0.05337, 24, 60, 144, 0.25 },
	{ 0.09545, 0.77238, 0.05507, 24, 60, 168, 0.25 },
	{ 0.09545, 0.77238, 0.05532, 24, 60, 180, 0.25 },
	{ 0.09545, 0.73628, 0.06698, 24, 66, 0, 0.25 },
	{ 0.09545, 0.73628, 0.06578, 24, 66, 24, 0.25 },
	{ 0.09545, 0.73628, 0.06308, 24, 66, 48, 0.25 },
	{ 0.09545, 0.73628, 0.06085, 24, 66, 72, 0.25 },
	{ 0.09545, 0.73628, 0.06071, 24, 66, 96, 0.25 },
	{ 0.09545, 0.73628, 0.06318, 24, 66, 120, 0.25 },
	{ 0.09545, 0.73628, 0.06717, 24, 66, 144, 0.25 },
	{ 0.09545, 0.73628, 0.07026, 24, 66, 168, 0.25 },
	{ 0.09545, 0.73628, 0.07071, 24, 66, 180, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 0, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 24, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 48, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 72, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 96, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 120, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 144, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 168, 0.25 },
	{ 0.09545, 0.84437, 0.03332, 36, 0, 180, 0.25 },
	{ 0.09545, 0.84256, 0.03723, 36, 12, 0, 0.25 },
	{ 0.09545, 0.84256, 0.03687, 36, 12, 24, 0.25 },
	{ 0.09545, 0.84256, 0.03589, 36, 12, 48, 0.25 },
	{ 0.09545, 0.84256, 0.03462, 36, 12, 72, 0.25 },
	{ 0.09545, 0.84256, 0.03339, 36, 12, 96, 0.25 },
	{ 0.09545, 0.84256, 0.03241, 36, 12, 120, 0.25 },
	{ 0.09545, 0.84256, 0.03176, 36, 12, 144, 0.25 },
	{ 0.09545, 0.84256, 0.03145, 36, 12, 168, 0.25 },
	{ 0.09545, 0.84256, 0.03141, 36, 12, 180, 0.25 },
	{ 0.09545, 0.83666, 0.04309, 36, 24, 0, 0.25 },
	{ 0.09545, 0.83666, 0.04177, 36, 24, 24, 0.25 },
	{ 0.09545, 0.83666, 0.03944, 36, 24, 48, 0.25 },
	{ 0.09545, 0.83666, 0.03673, 36, 24, 72, 0.25 },
	{ 0.09545, 0.83666, 0.03451, 36, 24, 96, 0.25 },
	{ 0.09545, 0.83666, 0.03308, 36, 24, 120, 0.25 },
	{ 0.09545, 0.83666, 0.03236, 36, 24, 144, 0.25 },
	{ 0.09545, 0.83666, 0.03211, 36, 24, 168, 0.25 },
	{ 0.09545, 0.83666, 0.03209, 36, 24, 180, 0.25 },
	{ 0.09545, 0.82493, 0.05357, 36, 36, 0, 0.25 },
	{ 0.09545, 0.82493, 0.04804, 36, 36, 24, 0.25 },
	{ 0.09545, 0.82493, 0.04414, 36, 36, 48, 0.25 },
	{ 0.09545, 0.82493, 0.0402, 36, 36, 72, 0.25 },
	{ 0.09545, 0.82493, 0.03749, 36, 36, 96, 0.25 },
	{ 0.09545, 0.82493, 0.0363, 36, 36, 120, 0.25 },
	{ 0.09545, 0.82493, 0.03625, 36, 36, 144, 0.25 },
	{ 0.09545, 0.82493, 0.03657, 36, 36, 168, 0.25 },
	{ 0.09545, 0.82493, 0.03663, 36, 36, 180, 0.25 },
	{ 0.09545, 0.80323, 0.05883, 36, 48, 0, 0.25 },
	{ 0.09545, 0.80323, 0.05609, 36, 48, 24, 0.25 },
	{ 0.09545, 0.80323, 0.05111, 36, 48, 48, 0.25 },
	{ 0.09545, 0.80323, 0.04645, 36, 48, 72, 0.25 },
	{ 0.09545, 0.80323, 0.04398, 36, 48, 96, 0.25 },
	{ 0.09545, 0.80323, 0.04412, 36, 48, 120, 0.25 },
	{ 0.09545, 0.80323, 0.04604, 36, 48, 144, 0.25 },
	{ 0.09545, 0.80323, 0.04786, 36, 48, 168, 0.25 },
	{ 0.09545, 0.80323, 0.04814, 36, 48, 180, 0.25 },
	{ 0.09545, 0.76154, 0.07206, 36, 60, 0, 0.25 },
	{ 0.09545, 0.76154, 0.06935, 36, 60, 24, 0.25 },
	{ 0.09545, 0.76154, 0.06353, 36, 60, 48, 0.25 },
	{ 0.09545, 0.76154, 0.05874, 36, 60, 72, 0.25 },
	{ 0.09545, 0.76154, 0.05771, 36, 60, 96, 0.25 },
	{ 0.09545, 0.76154, 0.06134, 36, 60, 120, 0.25 },
	{ 0.09545, 0.76154, 0.06807, 36, 60, 144, 0.25 },
	{ 0.09545, 0.76154, 0.0736, 36, 60, 168, 0.25 },
	{ 0.09545, 0.76154, 0.07443, 36, 60, 180, 0.25 },
	{ 0.09545, 0.72595, 0.08313, 36, 66, 0, 0.25 },
	{ 0.09545, 0.72595, 0.08019, 36, 66, 24, 0.25 },
	{ 0.09545, 0.72595, 0.07404, 36, 66, 48, 0.25 },
	{ 0.09545, 0.72595, 0.06945, 36, 66, 72, 0.25 },
	{ 0.09545, 0.72595, 0.06997, 36, 66, 96, 0.25 },
	{ 0.09545, 0.72595, 0.07699, 36, 66, 120, 0.25 },
	{ 0.09545, 0.72595, 0.08836, 36, 66, 144, 0.25 },
	{ 0.09545, 0.72595, 0.09757, 36, 66, 168, 0.25 },
	{ 0.09545, 0.72595, 0.09894, 36, 66, 180, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 0, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 24, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 48, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 72, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 96, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 120, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 144, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 168, 0.25 },
	{ 0.09545, 0.82216, 0.03701, 48, 0, 180, 0.25 },
	{ 0.09545, 0.8204, 0.04114, 48, 12, 0, 0.25 },
	{ 0.09545, 0.8204, 0.04075, 48, 12, 24, 0.25 },
	{ 0.09545, 0.8204, 0.03975, 48, 12, 48, 0.25 },
	{ 0.09545, 0.8204, 0.03852, 48, 12, 72, 0.25 },
	{ 0.09545, 0.8204, 0.03741, 48, 12, 96, 0.25 },
	{ 0.09545, 0.8204, 0.03663, 48, 12, 120, 0.25 },
	{ 0.09545, 0.8204, 0.0362, 48, 12, 144, 0.25 },
	{ 0.09545, 0.8204, 0.03603, 48, 12, 168, 0.25 },
	{ 0.09545, 0.8204, 0.03601, 48, 12, 180, 0.25 },
	{ 0.09545, 0.81465, 0.04822, 48, 24, 0, 0.25 },
	{ 0.09545, 0.81465, 0.04709, 48, 24, 24, 0.25 },
	{ 0.09545, 0.81465, 0.04437, 48, 24, 48, 0.25 },
	{ 0.09545, 0.81465, 0.04148, 48, 24, 72, 0.25 },
	{ 0.09545, 0.81465, 0.03943, 48, 24, 96, 0.25 },
	{ 0.09545, 0.81465, 0.03856, 48, 24, 120, 0.25 },
	{ 0.09545, 0.81465, 0.0386, 48, 24, 144, 0.25 },
	{ 0.09545, 0.81465, 0.0389, 48, 24, 168, 0.25 },
	{ 0.09545, 0.81465, 0.03896, 48, 24, 180, 0.25 },
	{ 0.09545, 0.80323, 0.05883, 48, 36, 0, 0.25 },
	{ 0.09545, 0.80323, 0.05609, 48, 36, 24, 0.25 },
	{ 0.09545, 0.80323, 0.05111, 48, 36, 48, 0.25 },
	{ 0.09545, 0.80323, 0.04645, 48, 36, 72, 0.25 },
	{ 0.09545, 0.80323, 0.04398, 48, 36, 96, 0.25 },
	{ 0.09545, 0.80323, 0.04412, 48, 36, 120, 0.25 },
	{ 0.09545, 0.80323, 0.04604, 48, 36, 144, 0.25 },
	{ 0.09545, 0.80323, 0.04786, 48, 36, 168, 0.25 },
	{ 0.09545, 0.80323, 0.04814, 48, 36, 180, 0.25 },
	{ 0.09545, 0.78211, 0.07777, 48, 48, 0, 0.25 },
	{ 0.09545, 0.78211, 0.06866, 48, 48, 24, 0.25 },
	{ 0.09545, 0.78211, 0.06117, 48, 48, 48, 0.25 },
	{ 0.09545, 0.78211, 0.05501, 48, 48, 72, 0.25 },
	{ 0.09545, 0.78211, 0.05304, 48, 48, 96, 0.25 },
	{ 0.09545, 0.78211, 0.0561, 48, 48, 120, 0.25 },
	{ 0.09545, 0.78211, 0.0626, 48, 48, 144, 0.25 },
	{ 0.09545, 0.78211, 0.06814, 48, 48, 168, 0.25 },
	{ 0.09545, 0.78211, 0.06899, 48, 48, 180, 0.25 },
	{ 0.09545, 0.74152, 0.0938, 48, 60, 0, 0.25 },
	{ 0.09545, 0.74152, 0.08812, 48, 60, 24, 0.25 },
	{ 0.09545, 0.74152, 0.07814, 48, 60, 48, 0.25 },
	{ 0.09545, 0.74152, 0.07094, 48, 60, 72, 0.25 },
	{ 0.09545, 0.74152, 0.07123, 48, 60, 96, 0.25 },
	{ 0.09545, 0.74152, 0.08112, 48, 60, 120, 0.25 },
	{ 0.09545, 0.74152, 0.09827, 48, 60, 144, 0.25 },
	{ 0.09545, 0.74152, 0.11293, 48, 60, 168, 0.25 },
	{ 0.09545, 0.74152, 0.11518, 48, 60, 180, 0.25 },
	{ 0.09545, 0.70686, 0.10891, 48, 66, 0, 0.25 },
	{ 0.09545, 0.70686, 0.10326, 48, 66, 24, 0.25 },
	{ 0.09545, 0.70686, 0.09194, 48, 66, 48, 0.25 },
	{ 0.09545, 0.70686, 0.08444, 48, 66, 72, 0.25 },
	{ 0.09545, 0.70686, 0.08704, 48, 66, 96, 0.25 },
	{ 0.09545, 0.70686, 0.10328, 48, 66, 120, 0.25 },
	{ 0.09545, 0.70686, 0.13055, 48, 66, 144, 0.25 },
	{ 0.09545, 0.70686, 0.15437, 48, 66, 168, 0.25 },
	{ 0.09545, 0.70686, 0.1581, 48, 66, 180, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 0, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 24, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 48, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 72, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 96, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 120, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 144, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 168, 0.25 },
	{ 0.09545, 0.77949, 0.04613, 60, 0, 180, 0.25 },
	{ 0.09545, 0.77782, 0.04984, 60, 12, 0, 0.25 },
	{ 0.09545, 0.77782, 0.04949, 60, 12, 24, 0.25 },
	{ 0.09545, 0.77782, 0.04864, 60, 12, 48, 0.25 },
	{ 0.09545, 0.77782, 0.04769, 60, 12, 72, 0.25 },
	{ 0.09545, 0.77782, 0.04706, 60, 12, 96, 0.25 },
	{ 0.09545, 0.77782, 0.04691, 60, 12, 120, 0.25 },
	{ 0.09545, 0.77782, 0.0471, 60, 12, 144, 0.25 },
	{ 0.09545, 0.77782, 0.04733, 60, 12, 168, 0.25 },
	{ 0.09545, 0.77782, 0.04736, 60, 12, 180, 0.25 },
	{ 0.09545, 0.77238, 0.05824, 60, 24, 0, 0.25 },
	{ 0.09545, 0.77238, 0.05703, 60, 24, 24, 0.25 },
	{ 0.09545, 0.77238, 0.05427, 60, 24, 48, 0.25 },
	{ 0.09545, 0.77238, 0.05165, 60, 24, 72, 0.25 },
	{ 0.09545, 0.77238, 0.05053, 60, 24, 96, 0.25 },
	{ 0.09545, 0.77238, 0.05134, 60, 24, 120, 0.25 },
	{ 0.09545, 0.77238, 0.05336, 60, 24, 144, 0.25 },
	{ 0.09545, 0.77238, 0.05507, 60, 24, 168, 0.25 },
	{ 0.09545, 0.77238, 0.05532, 60, 24, 180, 0.25 },
	{ 0.09545, 0.76154, 0.07206, 60, 36, 0, 0.25 },
	{ 0.09545, 0.76154, 0.06936, 60, 36, 24, 0.25 },
	{ 0.09545, 0.76154, 0.06353, 60, 36, 48, 0.25 },
	{ 0.09545, 0.76154, 0.05874, 60, 36, 72, 0.25 },
	{ 0.09545, 0.76154, 0.05771, 60, 36, 96, 0.25 },
	{ 0.09545, 0.76154, 0.06134, 60, 36, 120, 0.25 },
	{ 0.09545, 0.76154, 0.06807, 60, 36, 144, 0.25 },
	{ 0.09545, 0.76154, 0.0736, 60, 36, 168, 0.25 },
	{ 0.09545, 0.76154, 0.07443, 60, 36, 180, 0.25 },
	{ 0.09545, 0.74152, 0.09381, 60, 48, 0, 0.25 },
	{ 0.09545, 0.74152, 0.08812, 60, 48, 24, 0.25 },
	{ 0.09545, 0.74152, 0.07814, 60, 48, 48, 0.25 },
	{ 0.09545, 0.74152, 0.07095, 60, 48, 72, 0.25 },
	{ 0.09545, 0.74152, 0.07123, 60, 48, 96, 0.25 },
	{ 0.09545, 0.74152, 0.08112, 60, 48, 120, 0.25 },
	{ 0.09545, 0.74152, 0.09827, 60, 48, 144, 0.25 },
	{ 0.09545, 0.74152, 0.11292, 60, 48, 168, 0.25 },
	{ 0.09545, 0.74152, 0.11518, 60, 48, 180, 0.25 },
	{ 0.09545, 0.70303, 0.13476, 60, 60, 0, 0.25 },
	{ 0.09545, 0.70303, 0.11809, 60, 60, 24, 0.25 },
	{ 0.09545, 0.70303, 0.10284, 60, 60, 48, 0.25 },
	{ 0.09545, 0.70303, 0.09322, 60, 60, 72, 0.25 },
	{ 0.09545, 0.70303, 0.09727, 60, 60, 96, 0.25 },
	{ 0.09545, 0.70303, 0.1204, 60, 60, 120, 0.25 },
	{ 0.09545, 0.70303, 0.1609, 60, 60, 144, 0.25 },
	{ 0.09545, 0.70303, 0.19841, 60, 60, 168, 0.25 },
	{ 0.09545, 0.70303, 0.20448, 60, 60, 180, 0.25 },
	{ 0.09545, 0.67018, 0.15715, 60, 66, 0, 0.25 },
	{ 0.09545, 0.67018, 0.14115, 60, 66, 24, 0.25 },
	{ 0.09545, 0.67018, 0.12269, 60, 66, 48, 0.25 },
	{ 0.09545, 0.67018, 0.11179, 60, 66, 72, 0.25 },
	{ 0.09545, 0.67018, 0.11942, 60, 66, 96, 0.25 },
	{ 0.09545, 0.67018, 0.15421, 60, 66, 120, 0.25 },
	{ 0.09545, 0.67018, 0.21662, 60, 66, 144, 0.25 },
	{ 0.09545, 0.67018, 0.27769, 60, 66, 168, 0.25 },
	{ 0.09545, 0.67018, 0.28788, 60, 66, 180, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 0, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 24, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 48, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 72, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 96, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 120, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 144, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 168, 0.25 },
	{ 0.09545, 0.68763, 0.06849, 72, 0, 180, 0.25 },
	{ 0.09545, 0.68616, 0.07063, 72, 12, 0, 0.25 },
	{ 0.09545, 0.68616, 0.0704, 72, 12, 24, 0.25 },
	{ 0.09545, 0.68616, 0.06995, 72, 12, 48, 0.25 },
	{ 0.09545, 0.68616, 0.06984, 72, 12, 72, 0.25 },
	{ 0.09545, 0.68616, 0.07054, 72, 12, 96, 0.25 },
	{ 0.09545, 0.68616, 0.07209, 72, 12, 120, 0.25 },
	{ 0.09545, 0.68616, 0.07394, 72, 12, 144, 0.25 },
	{ 0.09545, 0.68616, 0.07521, 72, 12, 168, 0.25 },
	{ 0.09545, 0.68616, 0.07539, 72, 12, 180, 0.25 },
	{ 0.09545, 0.68135, 0.08072, 72, 24, 0, 0.25 },
	{ 0.09545, 0.68135, 0.0795, 72, 24, 24, 0.25 },
	{ 0.09545, 0.68135, 0.07692, 72, 24, 48, 0.25 },
	{ 0.09545, 0.68135, 0.07533, 72, 24, 72, 0.25 },
	{ 0.09545, 0.68135, 0.07682, 72, 24, 96, 0.25 },
	{ 0.09545, 0.68135, 0.08203, 72, 24, 120, 0.25 },
	{ 0.09545, 0.68135, 0.08924, 72, 24, 144, 0.25 },
	{ 0.09545, 0.68135, 0.09461, 72, 24, 168, 0.25 },
	{ 0.09545, 0.68135, 0.09539, 72, 24, 180, 0.25 },
	{ 0.09545, 0.6718, 0.09997, 72, 36, 0, 0.25 },
	{ 0.09545, 0.6718, 0.09678, 72, 36, 24, 0.25 },
	{ 0.09545, 0.6718, 0.09024, 72, 36, 48, 0.25 },
	{ 0.09545, 0.6718, 0.08606, 72, 36, 72, 0.25 },
	{ 0.09545, 0.6718, 0.08911, 72, 36, 96, 0.25 },
	{ 0.09545, 0.6718, 0.10157, 72, 36, 120, 0.25 },
	{ 0.09545, 0.6718, 0.12052, 72, 36, 144, 0.25 },
	{ 0.09545, 0.6718, 0.13586, 72, 36, 168, 0.25 },
	{ 0.09545, 0.6718, 0.13818, 72, 36, 180, 0.25 },
	{ 0.09545, 0.65413, 0.13229, 72, 48, 0, 0.25 },
	{ 0.09545, 0.65413, 0.12572, 72, 48, 24, 0.25 },
	{ 0.09545, 0.65413, 0.1128, 72, 48, 48, 0.25 },
	{ 0.09545, 0.65413, 0.10507, 72, 48, 72, 0.25 },
	{ 0.09545, 0.65413, 0.11137, 72, 48, 96, 0.25 },
	{ 0.09545, 0.65413, 0.13755, 72, 48, 120, 0.25 },
	{ 0.09545, 0.65413, 0.18125, 72, 48, 144, 0.25 },
	{ 0.09545, 0.65413, 0.22067, 72, 48, 168, 0.25 },
	{ 0.09545, 0.65413, 0.22697, 72, 48, 180, 0.25 },
	{ 0.09545, 0.62018, 0.18817, 72, 60, 0, 0.25 },
	{ 0.09545, 0.62018, 0.17489, 72, 60, 24, 0.25 },
	{ 0.09545, 0.62018, 0.15233, 72, 60, 48, 0.25 },
	{ 0.09545, 0.62018, 0.13991, 72, 60, 72, 0.25 },
	{ 0.09545, 0.62018, 0.15302, 72, 60, 96, 0.25 },
	{ 0.09545, 0.62018, 0.20564, 72, 60, 120, 0.25 },
	{ 0.09545, 0.62018, 0.30313, 72, 60, 144, 0.25 },
	{ 0.09545, 0.62018, 0.40481, 72, 60, 168, 0.25 },
	{ 0.09545, 0.62018, 0.42256, 72, 60, 180, 0.25 },
	{ 0.09545, 0.5912, 0.23826, 72, 66, 0, 0.25 },
	{ 0.09545, 0.5912, 0.21368, 72, 66, 24, 0.25 },
	{ 0.09545, 0.5912, 0.1844, 72, 66, 48, 0.25 },
	{ 0.09545, 0.5912, 0.1689, 72, 66, 72, 0.25 },
	{ 0.09545, 0.5912, 0.18786, 72, 66, 96, 0.25 },
	{ 0.09545, 0.5912, 0.26267, 72, 66, 120, 0.25 },
	{ 0.09545, 0.5912, 0.4093, 72, 66, 144, 0.25 },
	{ 0.09545, 0.5912, 0.57648, 72, 66, 168, 0.25 },
	{ 0.09545, 0.5912, 0.60747, 72, 66, 180, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 0, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 24, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 48, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 72, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 96, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 120, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 144, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 168, 0.25 },
	{ 0.09545, 0.45728, 0.13259, 84, 0, 180, 0.25 },
	{ 0.09545, 0.45631, 0.13104, 84, 12, 0, 0.25 },
	{ 0.09545, 0.45631, 0.13104, 84, 12, 24, 0.25 },
	{ 0.09545, 0.45631, 0.13147, 84, 12, 48, 0.25 },
	{ 0.09545, 0.45631, 0.13331, 84, 12, 72, 0.25 },
	{ 0.09545, 0.45631, 0.13731, 84, 12, 96, 0.25 },
	{ 0.09545, 0.45631, 0.14323, 84, 12, 120, 0.25 },
	{ 0.09545, 0.45631, 0.14947, 84, 12, 144, 0.25 },
	{ 0.09545, 0.45631, 0.15356, 84, 12, 168, 0.25 },
	{ 0.09545, 0.45631, 0.15413, 84, 12, 180, 0.25 },
	{ 0.09545, 0.45311, 0.1464, 84, 24, 0, 0.25 },
	{ 0.09545, 0.45311, 0.14485, 84, 24, 24, 0.25 },
	{ 0.09545, 0.45311, 0.14206, 84, 24, 48, 0.25 },
	{ 0.09545, 0.45311, 0.14244, 84, 24, 72, 0.25 },
	{ 0.09545, 0.45311, 0.15022, 84, 24, 96, 0.25 },
	{ 0.09545, 0.45311, 0.16672, 84, 24, 120, 0.25 },
	{ 0.09545, 0.45311, 0.18772, 84, 24, 144, 0.25 },
	{ 0.09545, 0.45311, 0.20318, 84, 24, 168, 0.25 },
	{ 0.09545, 0.45311, 0.20542, 84, 24, 180, 0.25 },
	{ 0.09545, 0.44676, 0.18054, 84, 36, 0, 0.25 },
	{ 0.09545, 0.44676, 0.17579, 84, 36, 24, 0.25 },
	{ 0.09545, 0.44676, 0.16618, 84, 36, 48, 0.25 },
	{ 0.09545, 0.44676, 0.16226, 84, 36, 72, 0.25 },
	{ 0.09545, 0.44676, 0.17458, 84, 36, 96, 0.25 },
	{ 0.09545, 0.44676, 0.20908, 84, 36, 120, 0.25 },
	{ 0.09545, 0.44676, 0.26048, 84, 36, 144, 0.25 },
	{ 0.09545, 0.44676, 0.30349, 84, 36, 168, 0.25 },
	{ 0.09545, 0.44676, 0.31013, 84, 36, 180, 0.25 },
	{ 0.09545, 0.43501, 0.24193, 84, 48, 0, 0.25 },
	{ 0.09545, 0.43501, 0.23138, 84, 48, 24, 0.25 },
	{ 0.09545, 0.43501, 0.21014, 84, 48, 48, 0.25 },
	{ 0.09545, 0.43501, 0.19887, 84, 48, 72, 0.25 },
	{ 0.09545, 0.43501, 0.21787, 84, 48, 96, 0.25 },
	{ 0.09545, 0.43501, 0.28303, 84, 48, 120, 0.25 },
	{ 0.09545, 0.43501, 0.39608, 84, 48, 144, 0.25 },
	{ 0.09545, 0.43501, 0.50746, 84, 48, 168, 0.25 },
	{ 0.09545, 0.43501, 0.52635, 84, 48, 180, 0.25 },
	{ 0.09545, 0.41243, 0.35315, 84, 60, 0, 0.25 },
	{ 0.09545, 0.41243, 0.3322, 84, 60, 24, 0.25 },
	{ 0.09545, 0.41243, 0.29104, 84, 60, 48, 0.25 },
	{ 0.09545, 0.41243, 0.26792, 84, 60, 72, 0.25 },
	{ 0.09545, 0.41243, 0.29837, 84, 60, 96, 0.25 },
	{ 0.09545, 0.41243, 0.41803, 84, 60, 120, 0.25 },
	{ 0.09545, 0.41243, 0.65921, 84, 60, 144, 0.25 },
	{ 0.09545, 0.41243, 0.95365, 84, 60, 168, 0.25 },
	{ 0.09545, 0.41243, 1.01106, 84, 60, 180, 0.25 },
	{ 0.09545, 0.39315, 0.44478, 84, 66, 0, 0.25 },
	{ 0.09545, 0.39315, 0.41565, 84, 66, 24, 0.25 },
	{ 0.09545, 0.39315, 0.3589, 84, 66, 48, 0.25 },
	{ 0.09545, 0.39315, 0.32672, 84, 66, 72, 0.25 },
	{ 0.09545, 0.39315, 0.36633, 84, 66, 96, 0.25 },
	{ 0.09545, 0.39315, 0.52982, 84, 66, 120, 0.25 },
	{ 0.09545, 0.39315, 0.88383, 84, 66, 144, 0.25 },
	{ 0.09545, 0.39315, 1.37395, 84, 66, 168, 0.25 },
	{ 0.09545, 0.39315, 1.47977, 84, 66, 180, 0.25 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 0, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 24, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 48, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 72, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 96, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 120, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 144, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 168, 0.5 },
	{ 0.13017, 0.781, 0.05019, 0, 0, 180, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 0, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 24, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 48, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 72, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 96, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 120, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 144, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 168, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 0, 12, 180, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 0, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 24, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 48, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 72, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 96, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 120, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 144, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 168, 0.5 },
	{ 0.13017, 0.76846, 0.04575, 0, 24, 180, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 0, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 24, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 48, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 72, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 96, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 120, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 144, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 168, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 0, 36, 180, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 0, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 24, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 48, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 72, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 96, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 120, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 144, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 168, 0.5 },
	{ 0.13017, 0.71602, 0.05417, 0, 48, 180, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 0, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 24, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 48, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 72, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 96, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 120, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 144, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 168, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 0, 60, 180, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 0, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 24, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 48, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 72, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 96, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 120, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 144, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 168, 0.5 },
	{ 0.13017, 0.60712, 0.08003, 0, 66, 180, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 0, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 24, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 48, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 72, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 96, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 120, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 144, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 168, 0.5 },
	{ 0.13017, 0.77805, 0.04595, 12, 0, 180, 0.5 },
	{ 0.13017, 0.77511, 0.05238, 12, 12, 0, 0.5 },
	{ 0.13017, 0.77511, 0.05092, 12, 12, 24, 0.5 },
	{ 0.13017, 0.77511, 0.04805, 12, 12, 48, 0.5 },
	{ 0.13017, 0.77511, 0.04622, 12, 12, 72, 0.5 },
	{ 0.13017, 0.77511, 0.04526, 12, 12, 96, 0.5 },
	{ 0.13017, 0.77511, 0.04456, 12, 12, 120, 0.5 },
	{ 0.13017, 0.77511, 0.04405, 12, 12, 144, 0.5 },
	{ 0.13017, 0.77511, 0.04378, 12, 12, 168, 0.5 },
	{ 0.13017, 0.77511, 0.04376, 12, 12, 180, 0.5 },
	{ 0.13017, 0.76556, 0.05027, 12, 24, 0, 0.5 },
	{ 0.13017, 0.76556, 0.04954, 12, 24, 24, 0.5 },
	{ 0.13017, 0.76556, 0.04834, 12, 24, 48, 0.5 },
	{ 0.13017, 0.76556, 0.04704, 12, 24, 72, 0.5 },
	{ 0.13017, 0.76556, 0.04574, 12, 24, 96, 0.5 },
	{ 0.13017, 0.76556, 0.04467, 12, 24, 120, 0.5 },
	{ 0.13017, 0.76556, 0.04395, 12, 24, 144, 0.5 },
	{ 0.13017, 0.76556, 0.04359, 12, 24, 168, 0.5 },
	{ 0.13017, 0.76556, 0.04354, 12, 24, 180, 0.5 },
	{ 0.13017, 0.74686, 0.05274, 12, 36, 0, 0.5 },
	{ 0.13017, 0.74686, 0.05229, 12, 36, 24, 0.5 },
	{ 0.13017, 0.74686, 0.05111, 12, 36, 48, 0.5 },
	{ 0.13017, 0.74686, 0.04963, 12, 36, 72, 0.5 },
	{ 0.13017, 0.74686, 0.04828, 12, 36, 96, 0.5 },
	{ 0.13017, 0.74686, 0.04731, 12, 36, 120, 0.5 },
	{ 0.13017, 0.74686, 0.04674, 12, 36, 144, 0.5 },
	{ 0.13017, 0.74686, 0.04649, 12, 36, 168, 0.5 },
	{ 0.13017, 0.74686, 0.04646, 12, 36, 180, 0.5 },
	{ 0.13017, 0.71332, 0.05862, 12, 48, 0, 0.5 },
	{ 0.13017, 0.71332, 0.0582, 12, 48, 24, 0.5 },
	{ 0.13017, 0.71332, 0.05716, 12, 48, 48, 0.5 },
	{ 0.13017, 0.71332, 0.056, 12, 48, 72, 0.5 },
	{ 0.13017, 0.71332, 0.05513, 12, 48, 96, 0.5 },
	{ 0.13017, 0.71332, 0.05472, 12, 48, 120, 0.5 },
	{ 0.13017, 0.71332, 0.05468, 12, 48, 144, 0.5 },
	{ 0.13017, 0.71332, 0.05475, 12, 48, 168, 0.5 },
	{ 0.13017, 0.71332, 0.05476, 12, 48, 180, 0.5 },
	{ 0.13017, 0.6527, 0.07105, 12, 60, 0, 0.5 },
	{ 0.13017, 0.6527, 0.07077, 12, 60, 24, 0.5 },
	{ 0.13017, 0.6527, 0.07019, 12, 60, 48, 0.5 },
	{ 0.13017, 0.6527, 0.06979, 12, 60, 72, 0.5 },
	{ 0.13017, 0.6527, 0.06998, 12, 60, 96, 0.5 },
	{ 0.13017, 0.6527, 0.07082, 12, 60, 120, 0.5 },
	{ 0.13017, 0.6527, 0.07194, 12, 60, 144, 0.5 },
	{ 0.13017, 0.6527, 0.07274, 12, 60, 168, 0.5 },
	{ 0.13017, 0.6527, 0.07285, 12, 60, 180, 0.5 },
	{ 0.13017, 0.60482, 0.08161, 12, 66, 0, 0.5 },
	{ 0.13017, 0.60482, 0.08146, 12, 66, 24, 0.5 },
	{ 0.13017, 0.60482, 0.08124, 12, 66, 48, 0.5 },
	{ 0.13017, 0.60482, 0.08147, 12, 66, 72, 0.5 },
	{ 0.13017, 0.60482, 0.08258, 12, 66, 96, 0.5 },
	{ 0.13017, 0.60482, 0.08452, 12, 66, 120, 0.5 },
	{ 0.13017, 0.60482, 0.08666, 12, 66, 144, 0.5 },
	{ 0.13017, 0.60482, 0.0881, 12, 66, 168, 0.5 },
	{ 0.13017, 0.60482, 0.0883, 12, 66, 180, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 0, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 24, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 48, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 72, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 96, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 120, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 144, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 168, 0.5 },
	{ 0.13017, 0.76846, 0.04576, 24, 0, 180, 0.5 },
	{ 0.13017, 0.76556, 0.05027, 24, 12, 0, 0.5 },
	{ 0.13017, 0.76556, 0.04954, 24, 12, 24, 0.5 },
	{ 0.13017, 0.76556, 0.04834, 24, 12, 48, 0.5 },
	{ 0.13017, 0.76556, 0.04704, 24, 12, 72, 0.5 },
	{ 0.13017, 0.76556, 0.04574, 24, 12, 96, 0.5 },
	{ 0.13017, 0.76556, 0.04467, 24, 12, 120, 0.5 },
	{ 0.13017, 0.76556, 0.04395, 24, 12, 144, 0.5 },
	{ 0.13017, 0.76556, 0.04359, 24, 12, 168, 0.5 },
	{ 0.13017, 0.76556, 0.04354, 24, 12, 180, 0.5 },
	{ 0.13017, 0.75612, 0.06, 24, 24, 0, 0.5 },
	{ 0.13017, 0.75612, 0.05511, 24, 24, 24, 0.5 },
	{ 0.13017, 0.75612, 0.05159, 24, 24, 48, 0.5 },
	{ 0.13017, 0.75612, 0.04908, 24, 24, 72, 0.5 },
	{ 0.13017, 0.75612, 0.04688, 24, 24, 96, 0.5 },
	{ 0.13017, 0.75612, 0.04538, 24, 24, 120, 0.5 },
	{ 0.13017, 0.75612, 0.04457, 24, 24, 144, 0.5 },
	{ 0.13017, 0.75612, 0.04425, 24, 24, 168, 0.5 },
	{ 0.13017, 0.75612, 0.04421, 24, 24, 180, 0.5 },
	{ 0.13017, 0.73765, 0.06073, 24, 36, 0, 0.5 },
	{ 0.13017, 0.73765, 0.05888, 24, 36, 24, 0.5 },
	{ 0.13017, 0.73765, 0.05595, 24, 36, 48, 0.5 },
	{ 0.13017, 0.73765, 0.05279, 24, 36, 72, 0.5 },
	{ 0.13017, 0.73765, 0.05054, 24, 36, 96, 0.5 },
	{ 0.13017, 0.73765, 0.04945, 24, 36, 120, 0.5 },
	{ 0.13017, 0.73765, 0.04921, 24, 36, 144, 0.5 },
	{ 0.13017, 0.73765, 0.04931, 24, 36, 168, 0.5 },
	{ 0.13017, 0.73765, 0.04934, 24, 36, 180, 0.5 },
	{ 0.13017, 0.70453, 0.0677, 24, 48, 0, 0.5 },
	{ 0.13017, 0.70453, 0.06633, 24, 48, 24, 0.5 },
	{ 0.13017, 0.70453, 0.0632, 24, 48, 48, 0.5 },
	{ 0.13017, 0.70453, 0.0603, 24, 48, 72, 0.5 },
	{ 0.13017, 0.70453, 0.0589, 24, 48, 96, 0.5 },
	{ 0.13017, 0.70453, 0.05919, 24, 48, 120, 0.5 },
	{ 0.13017, 0.70453, 0.06051, 24, 48, 144, 0.5 },
	{ 0.13017, 0.70453, 0.06166, 24, 48, 168, 0.5 },
	{ 0.13017, 0.70453, 0.06183, 24, 48, 180, 0.5 },
	{ 0.13017, 0.64466, 0.08101, 24, 60, 0, 0.5 },
	{ 0.13017, 0.64466, 0.07974, 24, 60, 24, 0.5 },
	{ 0.13017, 0.64466, 0.0771, 24, 60, 48, 0.5 },
	{ 0.13017, 0.64466, 0.07533, 24, 60, 72, 0.5 },
	{ 0.13017, 0.64466, 0.07602, 24, 60, 96, 0.5 },
	{ 0.13017, 0.64466, 0.07945, 24, 60, 120, 0.5 },
	{ 0.13017, 0.64466, 0.08422, 24, 60, 144, 0.5 },
	{ 0.13017, 0.64466, 0.08773, 24, 60, 168, 0.5 },
	{ 0.13017, 0.64466, 0.08824, 24, 60, 180, 0.5 },
	{ 0.13017, 0.59737, 0.09188, 24, 66, 0, 0.5 },
	{ 0.13017, 0.59737, 0.09074, 24, 66, 24, 0.5 },
	{ 0.13017, 0.59737, 0.08855, 24, 66, 48, 0.5 },
	{ 0.13017, 0.59737, 0.08775, 24, 66, 72, 0.5 },
	{ 0.13017, 0.59737, 0.09028, 24, 66, 96, 0.5 },
	{ 0.13017, 0.59737, 0.09645, 24, 66, 120, 0.5 },
	{ 0.13017, 0.59737, 0.1043, 24, 66, 144, 0.5 },
	{ 0.13017, 0.59737, 0.10994, 24, 66, 168, 0.5 },
	{ 0.13017, 0.59737, 0.11075, 24, 66, 180, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 0, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 24, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 48, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 72, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 96, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 120, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 144, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 168, 0.5 },
	{ 0.13017, 0.74969, 0.04792, 36, 0, 180, 0.5 },
	{ 0.13017, 0.74686, 0.05275, 36, 12, 0, 0.5 },
	{ 0.13017, 0.74686, 0.0523, 36, 12, 24, 0.5 },
	{ 0.13017, 0.74686, 0.05112, 36, 12, 48, 0.5 },
	{ 0.13017, 0.74686, 0.04963, 36, 12, 72, 0.5 },
	{ 0.13017, 0.74686, 0.04829, 36, 12, 96, 0.5 },
	{ 0.13017, 0.74686, 0.04731, 36, 12, 120, 0.5 },
	{ 0.13017, 0.74686, 0.04673, 36, 12, 144, 0.5 },
	{ 0.13017, 0.74686, 0.04648, 36, 12, 168, 0.5 },
	{ 0.13017, 0.74686, 0.04645, 36, 12, 180, 0.5 },
	{ 0.13017, 0.73765, 0.06073, 36, 24, 0, 0.5 },
	{ 0.13017, 0.73765, 0.05888, 36, 24, 24, 0.5 },
	{ 0.13017, 0.73765, 0.05596, 36, 24, 48, 0.5 },
	{ 0.13017, 0.73765, 0.0528, 36, 24, 72, 0.5 },
	{ 0.13017, 0.73765, 0.05054, 36, 24, 96, 0.5 },
	{ 0.13017, 0.73765, 0.04944, 36, 24, 120, 0.5 },
	{ 0.13017, 0.73765, 0.04921, 36, 24, 144, 0.5 },
	{ 0.13017, 0.73765, 0.04931, 36, 24, 168, 0.5 },
	{ 0.13017, 0.73765, 0.04933, 36, 24, 180, 0.5 },
	{ 0.13017, 0.71963, 0.07596, 36, 36, 0, 0.5 },
	{ 0.13017, 0.71963, 0.06752, 36, 36, 24, 0.5 },
	{ 0.13017, 0.71963, 0.0626, 36, 36, 48, 0.5 },
	{ 0.13017, 0.71963, 0.0582, 36, 36, 72, 0.5 },
	{ 0.13017, 0.71963, 0.05594, 36, 36, 96, 0.5 },
	{ 0.13017, 0.71963, 0.05589, 36, 36, 120, 0.5 },
	{ 0.13017, 0.71963, 0.05719, 36, 36, 144, 0.5 },
	{ 0.13017, 0.71963, 0.05844, 36, 36, 168, 0.5 },
	{ 0.13017, 0.71963, 0.05863, 36, 36, 180, 0.5 },
	{ 0.13017, 0.68732, 0.08203, 36, 48, 0, 0.5 },
	{ 0.13017, 0.68732, 0.07839, 36, 48, 24, 0.5 },
	{ 0.13017, 0.68732, 0.07248, 36, 48, 48, 0.5 },
	{ 0.13017, 0.68732, 0.06785, 36, 48, 72, 0.5 },
	{ 0.13017, 0.68732, 0.06685, 36, 48, 96, 0.5 },
	{ 0.13017, 0.68732, 0.06964, 36, 48, 120, 0.5 },
	{ 0.13017, 0.68732, 0.07459, 36, 48, 144, 0.5 },
	{ 0.13017, 0.68732, 0.07851, 36, 48, 168, 0.5 },
	{ 0.13017, 0.68732, 0.07909, 36, 48, 180, 0.5 },
	{ 0.13017, 0.62891, 0.09875, 36, 60, 0, 0.5 },
	{ 0.13017, 0.62891, 0.09559, 36, 60, 24, 0.5 },
	{ 0.13017, 0.62891, 0.08936, 36, 60, 48, 0.5 },
	{ 0.13017, 0.62891, 0.08573, 36, 60, 72, 0.5 },
	{ 0.13017, 0.62891, 0.08801, 36, 60, 96, 0.5 },
	{ 0.13017, 0.62891, 0.09701, 36, 60, 120, 0.5 },
	{ 0.13017, 0.62891, 0.10996, 36, 60, 144, 0.5 },
	{ 0.13017, 0.62891, 0.11992, 36, 60, 168, 0.5 },
	{ 0.13017, 0.62891, 0.12139, 36, 60, 180, 0.5 },
	{ 0.13017, 0.58278, 0.11193, 36, 66, 0, 0.5 },
	{ 0.13017, 0.58278, 0.10871, 36, 66, 24, 0.5 },
	{ 0.13017, 0.58278, 0.10266, 36, 66, 48, 0.5 },
	{ 0.13017, 0.58278, 0.10006, 36, 66, 72, 0.5 },
	{ 0.13017, 0.58278, 0.10522, 36, 66, 96, 0.5 },
	{ 0.13017, 0.58278, 0.11961, 36, 66, 120, 0.5 },
	{ 0.13017, 0.58278, 0.13965, 36, 66, 144, 0.5 },
	{ 0.13017, 0.58278, 0.15517, 36, 66, 168, 0.5 },
	{ 0.13017, 0.58278, 0.15746, 36, 66, 180, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 0, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 24, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 48, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 72, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 96, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 120, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 144, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 168, 0.5 },
	{ 0.13017, 0.71602, 0.05418, 48, 0, 180, 0.5 },
	{ 0.13017, 0.71332, 0.05863, 48, 12, 0, 0.5 },
	{ 0.13017, 0.71332, 0.05821, 48, 12, 24, 0.5 },
	{ 0.13017, 0.71332, 0.05717, 48, 12, 48, 0.5 },
	{ 0.13017, 0.71332, 0.05601, 48, 12, 72, 0.5 },
	{ 0.13017, 0.71332, 0.05513, 48, 12, 96, 0.5 },
	{ 0.13017, 0.71332, 0.05472, 48, 12, 120, 0.5 },
	{ 0.13017, 0.71332, 0.05467, 48, 12, 144, 0.5 },
	{ 0.13017, 0.71332, 0.05475, 48, 12, 168, 0.5 },
	{ 0.13017, 0.71332, 0.05476, 48, 12, 180, 0.5 },
	{ 0.13017, 0.70453, 0.0677, 48, 24, 0, 0.5 },
	{ 0.13017, 0.70453, 0.06634, 48, 24, 24, 0.5 },
	{ 0.13017, 0.70453, 0.06321, 48, 24, 48, 0.5 },
	{ 0.13017, 0.70453, 0.0603, 48, 24, 72, 0.5 },
	{ 0.13017, 0.70453, 0.0589, 48, 24, 96, 0.5 },
	{ 0.13017, 0.70453, 0.05919, 48, 24, 120, 0.5 },
	{ 0.13017, 0.70453, 0.06051, 48, 24, 144, 0.5 },
	{ 0.13017, 0.70453, 0.06166, 48, 24, 168, 0.5 },
	{ 0.13017, 0.70453, 0.06183, 48, 24, 180, 0.5 },
	{ 0.13017, 0.68732, 0.08203, 48, 36, 0, 0.5 },
	{ 0.13017, 0.68732, 0.07839, 48, 36, 24, 0.5 },
	{ 0.13017, 0.68732, 0.07249, 48, 36, 48, 0.5 },
	{ 0.13017, 0.68732, 0.06785, 48, 36, 72, 0.5 },
	{ 0.13017, 0.68732, 0.06685, 48, 36, 96, 0.5 },
	{ 0.13017, 0.68732, 0.06964, 48, 36, 120, 0.5 },
	{ 0.13017, 0.68732, 0.07459, 48, 36, 144, 0.5 },
	{ 0.13017, 0.68732, 0.07851, 48, 36, 168, 0.5 },
	{ 0.13017, 0.68732, 0.07909, 48, 36, 180, 0.5 },
	{ 0.13017, 0.65645, 0.10836, 48, 48, 0, 0.5 },
	{ 0.13017, 0.65645, 0.0952, 48, 48, 24, 0.5 },
	{ 0.13017, 0.65645, 0.08641, 48, 48, 48, 0.5 },
	{ 0.13017, 0.65645, 0.08077, 48, 48, 72, 0.5 },
	{ 0.13017, 0.65645, 0.08182, 48, 48, 96, 0.5 },
	{ 0.13017, 0.65645, 0.09023, 48, 48, 120, 0.5 },
	{ 0.13017, 0.65645, 0.10314, 48, 48, 144, 0.5 },
	{ 0.13017, 0.65645, 0.11336, 48, 48, 168, 0.5 },
	{ 0.13017, 0.65645, 0.11489, 48, 48, 180, 0.5 },
	{ 0.13017, 0.60067, 0.12713, 48, 60, 0, 0.5 },
	{ 0.13017, 0.60067, 0.12003, 48, 60, 24, 0.5 },
	{ 0.13017, 0.60067, 0.10899, 48, 60, 48, 0.5 },
	{ 0.13017, 0.60067, 0.10359, 48, 60, 72, 0.5 },
	{ 0.13017, 0.60067, 0.10964, 48, 60, 96, 0.5 },
	{ 0.13017, 0.60067, 0.12964, 48, 60, 120, 0.5 },
	{ 0.13017, 0.60067, 0.15969, 48, 60, 144, 0.5 },
	{ 0.13017, 0.60067, 0.18439, 48, 60, 168, 0.5 },
	{ 0.13017, 0.60067, 0.18816, 48, 60, 180, 0.5 },
	{ 0.13017, 0.55661, 0.1446, 48, 66, 0, 0.5 },
	{ 0.13017, 0.55661, 0.13803, 48, 66, 24, 0.5 },
	{ 0.13017, 0.55661, 0.12614, 48, 66, 48, 0.5 },
	{ 0.13017, 0.55661, 0.12146, 48, 66, 72, 0.5 },
	{ 0.13017, 0.55661, 0.13177, 48, 66, 96, 0.5 },
	{ 0.13017, 0.55661, 0.16156, 48, 66, 120, 0.5 },
	{ 0.13017, 0.55661, 0.20676, 48, 66, 144, 0.5 },
	{ 0.13017, 0.55661, 0.2451, 48, 66, 168, 0.5 },
	{ 0.13017, 0.55661, 0.25105, 48, 66, 180, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 0, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 24, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 48, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 72, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 96, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 120, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 144, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 168, 0.5 },
	{ 0.13017, 0.65517, 0.06812, 60, 0, 180, 0.5 },
	{ 0.13017, 0.6527, 0.07106, 60, 12, 0, 0.5 },
	{ 0.13017, 0.6527, 0.07079, 60, 12, 24, 0.5 },
	{ 0.13017, 0.6527, 0.0702, 60, 12, 48, 0.5 },
	{ 0.13017, 0.6527, 0.06979, 60, 12, 72, 0.5 },
	{ 0.13017, 0.6527, 0.06999, 60, 12, 96, 0.5 },
	{ 0.13017, 0.6527, 0.07083, 60, 12, 120, 0.5 },
	{ 0.13017, 0.6527, 0.07194, 60, 12, 144, 0.5 },
	{ 0.13017, 0.6527, 0.07274, 60, 12, 168, 0.5 },
	{ 0.13017, 0.6527, 0.07285, 60, 12, 180, 0.5 },
	{ 0.13017, 0.64466, 0.08102, 60, 24, 0, 0.5 },
	{ 0.13017, 0.64466, 0.07975, 60, 24, 24, 0.5 },
	{ 0.13017, 0.64466, 0.07711, 60, 24, 48, 0.5 },
	{ 0.13017, 0.64466, 0.07533, 60, 24, 72, 0.5 },
	{ 0.13017, 0.64466, 0.07603, 60, 24, 96, 0.5 },
	{ 0.13017, 0.64466, 0.07945, 60, 24, 120, 0.5 },
	{ 0.13017, 0.64466, 0.08422, 60, 24, 144, 0.5 },
	{ 0.13017, 0.64466, 0.08773, 60, 24, 168, 0.5 },
	{ 0.13017, 0.64466, 0.08823, 60, 24, 180, 0.5 },
	{ 0.13017, 0.62891, 0.09876, 60, 36, 0, 0.5 },
	{ 0.13017, 0.62891, 0.09561, 60, 36, 24, 0.5 },
	{ 0.13017, 0.62891, 0.08937, 60, 36, 48, 0.5 },
	{ 0.13017, 0.62891, 0.08574, 60, 36, 72, 0.5 },
	{ 0.13017, 0.62891, 0.08801, 60, 36, 96, 0.5 },
	{ 0.13017, 0.62891, 0.09701, 60, 36, 120, 0.5 },
	{ 0.13017, 0.62891, 0.10996, 60, 36, 144, 0.5 },
	{ 0.13017, 0.62891, 0.11991, 60, 36, 168, 0.5 },
	{ 0.13017, 0.62891, 0.12138, 60, 36, 180, 0.5 },
	{ 0.13017, 0.60067, 0.12715, 60, 48, 0, 0.5 },
	{ 0.13017, 0.60067, 0.12004, 60, 48, 24, 0.5 },
	{ 0.13017, 0.60067, 0.109, 60, 48, 48, 0.5 },
	{ 0.13017, 0.60067, 0.1036, 60, 48, 72, 0.5 },
	{ 0.13017, 0.60067, 0.10964, 60, 48, 96, 0.5 },
	{ 0.13017, 0.60067, 0.12964, 60, 48, 120, 0.5 },
	{ 0.13017, 0.60067, 0.15969, 60, 48, 144, 0.5 },
	{ 0.13017, 0.60067, 0.18439, 60, 48, 168, 0.5 },
	{ 0.13017, 0.60067, 0.18816, 60, 48, 180, 0.5 },
	{ 0.13017, 0.54962, 0.18001, 60, 60, 0, 0.5 },
	{ 0.13017, 0.54962, 0.15768, 60, 60, 24, 0.5 },
	{ 0.13017, 0.54962, 0.14111, 60, 60, 48, 0.5 },
	{ 0.13017, 0.54962, 0.13473, 60, 60, 72, 0.5 },
	{ 0.13017, 0.54962, 0.14857, 60, 60, 96, 0.5 },
	{ 0.13017, 0.54962, 0.18989, 60, 60, 120, 0.5 },
	{ 0.13017, 0.54962, 0.25612, 60, 60, 144, 0.5 },
	{ 0.13017, 0.54962, 0.31586, 60, 60, 168, 0.5 },
	{ 0.13017, 0.54962, 0.32546, 60, 60, 180, 0.5 },
	{ 0.13017, 0.5093, 0.2052, 60, 66, 0, 0.5 },
	{ 0.13017, 0.5093, 0.18486, 60, 66, 24, 0.5 },
	{ 0.13017, 0.5093, 0.16533, 60, 66, 48, 0.5 },
	{ 0.13017, 0.5093, 0.15886, 60, 66, 72, 0.5 },
	{ 0.13017, 0.5093, 0.17907, 60, 66, 96, 0.5 },
	{ 0.13017, 0.5093, 0.23776, 60, 66, 120, 0.5 },
	{ 0.13017, 0.5093, 0.33576, 60, 66, 144, 0.5 },
	{ 0.13017, 0.5093, 0.42954, 60, 66, 168, 0.5 },
	{ 0.13017, 0.5093, 0.44509, 60, 66, 180, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 0, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 24, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 48, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 72, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 96, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 120, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 144, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 168, 0.5 },
	{ 0.13017, 0.54065, 0.09716, 72, 0, 180, 0.5 },
	{ 0.13017, 0.53861, 0.0968, 72, 12, 0, 0.5 },
	{ 0.13017, 0.53861, 0.0968, 72, 12, 24, 0.5 },
	{ 0.13017, 0.53861, 0.09706, 72, 12, 48, 0.5 },
	{ 0.13017, 0.53861, 0.0982, 72, 12, 72, 0.5 },
	{ 0.13017, 0.53861, 0.10062, 72, 12, 96, 0.5 },
	{ 0.13017, 0.53861, 0.10416, 72, 12, 120, 0.5 },
	{ 0.13017, 0.53861, 0.10782, 72, 12, 144, 0.5 },
	{ 0.13017, 0.53861, 0.11019, 72, 12, 168, 0.5 },
	{ 0.13017, 0.53861, 0.11052, 72, 12, 180, 0.5 },
	{ 0.13017, 0.53197, 0.10745, 72, 24, 0, 0.5 },
	{ 0.13017, 0.53197, 0.10646, 72, 24, 24, 0.5 },
	{ 0.13017, 0.53197, 0.10482, 72, 24, 48, 0.5 },
	{ 0.13017, 0.53197, 0.10537, 72, 24, 72, 0.5 },
	{ 0.13017, 0.53197, 0.11051, 72, 24, 96, 0.5 },
	{ 0.13017, 0.53197, 0.12068, 72, 24, 120, 0.5 },
	{ 0.13017, 0.53197, 0.13309, 72, 24, 144, 0.5 },
	{ 0.13017, 0.53197, 0.14193, 72, 24, 168, 0.5 },
	{ 0.13017, 0.53197, 0.1432, 72, 24, 180, 0.5 },
	{ 0.13017, 0.51897, 0.13033, 72, 36, 0, 0.5 },
	{ 0.13017, 0.51897, 0.1271, 72, 36, 24, 0.5 },
	{ 0.13017, 0.51897, 0.12131, 72, 36, 48, 0.5 },
	{ 0.13017, 0.51897, 0.12011, 72, 36, 72, 0.5 },
	{ 0.13017, 0.51897, 0.12934, 72, 36, 96, 0.5 },
	{ 0.13017, 0.51897, 0.1515, 72, 36, 120, 0.5 },
	{ 0.13017, 0.51897, 0.18209, 72, 36, 144, 0.5 },
	{ 0.13017, 0.51897, 0.20611, 72, 36, 168, 0.5 },
	{ 0.13017, 0.51897, 0.2097, 72, 36, 180, 0.5 },
	{ 0.13017, 0.49567, 0.16979, 72, 48, 0, 0.5 },
	{ 0.13017, 0.49567, 0.16258, 72, 48, 24, 0.5 },
	{ 0.13017, 0.49567, 0.14986, 72, 48, 48, 0.5 },
	{ 0.13017, 0.49567, 0.1462, 72, 48, 72, 0.5 },
	{ 0.13017, 0.49567, 0.16243, 72, 48, 96, 0.5 },
	{ 0.13017, 0.49567, 0.20611, 72, 48, 120, 0.5 },
	{ 0.13017, 0.49567, 0.27382, 72, 48, 144, 0.5 },
	{ 0.13017, 0.49567, 0.33355, 72, 48, 168, 0.5 },
	{ 0.13017, 0.49567, 0.34303, 72, 48, 180, 0.5 },
	{ 0.13017, 0.45355, 0.23684, 72, 60, 0, 0.5 },
	{ 0.13017, 0.45355, 0.2216, 72, 60, 24, 0.5 },
	{ 0.13017, 0.45355, 0.1987, 72, 60, 48, 0.5 },
	{ 0.13017, 0.45355, 0.19223, 72, 60, 72, 0.5 },
	{ 0.13017, 0.45355, 0.221, 72, 60, 96, 0.5 },
	{ 0.13017, 0.45355, 0.3039, 72, 60, 120, 0.5 },
	{ 0.13017, 0.45355, 0.44886, 72, 60, 144, 0.5 },
	{ 0.13017, 0.45355, 0.59723, 72, 60, 168, 0.5 },
	{ 0.13017, 0.45355, 0.62297, 72, 60, 180, 0.5 },
	{ 0.13017, 0.42028, 0.29535, 72, 66, 0, 0.5 },
	{ 0.13017, 0.42028, 0.26593, 72, 66, 24, 0.5 },
	{ 0.13017, 0.42028, 0.23634, 72, 66, 48, 0.5 },
	{ 0.13017, 0.42028, 0.22826, 72, 66, 72, 0.5 },
	{ 0.13017, 0.42028, 0.26673, 72, 66, 96, 0.5 },
	{ 0.13017, 0.42028, 0.38051, 72, 66, 120, 0.5 },
	{ 0.13017, 0.42028, 0.59245, 72, 66, 144, 0.5 },
	{ 0.13017, 0.42028, 0.82975, 72, 66, 168, 0.5 },
	{ 0.13017, 0.42028, 0.87342, 72, 66, 180, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 0, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 24, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 48, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 72, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 96, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 120, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 144, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 168, 0.5 },
	{ 0.13017, 0.34624, 0.1514, 84, 0, 180, 0.5 },
	{ 0.13017, 0.34493, 0.14688, 84, 12, 0, 0.5 },
	{ 0.13017, 0.34493, 0.14716, 84, 12, 24, 0.5 },
	{ 0.13017, 0.34493, 0.14841, 84, 12, 48, 0.5 },
	{ 0.13017, 0.34493, 0.15157, 84, 12, 72, 0.5 },
	{ 0.13017, 0.34493, 0.15728, 84, 12, 96, 0.5 },
	{ 0.13017, 0.34493, 0.1651, 84, 12, 120, 0.5 },
	{ 0.13017, 0.34493, 0.17302, 84, 12, 144, 0.5 },
	{ 0.13017, 0.34493, 0.17812, 84, 12, 168, 0.5 },
	{ 0.13017, 0.34493, 0.17882, 84, 12, 180, 0.5 },
	{ 0.13017, 0.34068, 0.16124, 84, 24, 0, 0.5 },
	{ 0.13017, 0.34068, 0.16015, 84, 24, 24, 0.5 },
	{ 0.13017, 0.34068, 0.1588, 84, 24, 48, 0.5 },
	{ 0.13017, 0.34068, 0.16167, 84, 24, 72, 0.5 },
	{ 0.13017, 0.34068, 0.17305, 84, 24, 96, 0.5 },
	{ 0.13017, 0.34068, 0.1941, 84, 24, 120, 0.5 },
	{ 0.13017, 0.34068, 0.21984, 84, 24, 144, 0.5 },
	{ 0.13017, 0.34068, 0.23851, 84, 24, 168, 0.5 },
	{ 0.13017, 0.34068, 0.24121, 84, 24, 180, 0.5 },
	{ 0.13017, 0.33236, 0.1961, 84, 36, 0, 0.5 },
	{ 0.13017, 0.33236, 0.19195, 84, 36, 24, 0.5 },
	{ 0.13017, 0.33236, 0.18437, 84, 36, 48, 0.5 },
	{ 0.13017, 0.33236, 0.18423, 84, 36, 72, 0.5 },
	{ 0.13017, 0.33236, 0.20255, 84, 36, 96, 0.5 },
	{ 0.13017, 0.33236, 0.24572, 84, 36, 120, 0.5 },
	{ 0.13017, 0.33236, 0.30778, 84, 36, 144, 0.5 },
	{ 0.13017, 0.33236, 0.35922, 84, 36, 168, 0.5 },
	{ 0.13017, 0.33236, 0.36715, 84, 36, 180, 0.5 },
	{ 0.13017, 0.31744, 0.26014, 84, 48, 0, 0.5 },
	{ 0.13017, 0.31744, 0.25026, 84, 48, 24, 0.5 },
	{ 0.13017, 0.31744, 0.23169, 84, 48, 48, 0.5 },
	{ 0.13017, 0.31744, 0.22596, 84, 48, 72, 0.5 },
	{ 0.13017, 0.31744, 0.25438, 84, 48, 96, 0.5 },
	{ 0.13017, 0.31744, 0.33489, 84, 48, 120, 0.5 },
	{ 0.13017, 0.31744, 0.47037, 84, 48, 144, 0.5 },
	{ 0.13017, 0.31744, 0.60293, 84, 48, 168, 0.5 },
	{ 0.13017, 0.31744, 0.62537, 84, 48, 180, 0.5 },
	{ 0.13017, 0.29046, 0.37585, 84, 60, 0, 0.5 },
	{ 0.13017, 0.29046, 0.35553, 84, 60, 24, 0.5 },
	{ 0.13017, 0.29046, 0.31798, 84, 60, 48, 0.5 },
	{ 0.13017, 0.29046, 0.30314, 84, 60, 72, 0.5 },
	{ 0.13017, 0.29046, 0.34829, 84, 60, 96, 0.5 },
	{ 0.13017, 0.29046, 0.49435, 84, 60, 120, 0.5 },
	{ 0.13017, 0.29046, 0.78109, 84, 60, 144, 0.5 },
	{ 0.13017, 0.29046, 1.12883, 84, 60, 168, 0.5 },
	{ 0.13017, 0.29046, 1.19646, 84, 60, 180, 0.5 },
	{ 0.13017, 0.26915, 0.46937, 84, 66, 0, 0.5 },
	{ 0.13017, 0.26915, 0.44093, 84, 66, 24, 0.5 },
	{ 0.13017, 0.26915, 0.3886, 84, 66, 48, 0.5 },
	{ 0.13017, 0.26915, 0.36678, 84, 66, 72, 0.5 },
	{ 0.13017, 0.26915, 0.4248, 84, 66, 96, 0.5 },
	{ 0.13017, 0.26915, 0.62254, 84, 66, 120, 0.5 },
	{ 0.13017, 0.26915, 1.04058, 84, 66, 144, 0.5 },
	{ 0.13017, 0.26915, 1.61546, 84, 66, 168, 0.5 },
	{ 0.13017, 0.26915, 1.73919, 84, 66, 180, 0.5 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 0, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 24, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 48, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 72, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 96, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 120, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 144, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 168, 1 },
	{ 0.17876, 0.62689, 0.07915, 0, 0, 180, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 0, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 24, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 48, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 72, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 96, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 120, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 144, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 168, 1 },
	{ 0.17876, 0.62248, 0.07325, 0, 12, 180, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 0, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 24, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 48, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 72, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 96, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 120, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 144, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 168, 1 },
	{ 0.17876, 0.60839, 0.07373, 0, 24, 180, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 0, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 24, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 48, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 72, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 96, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 120, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 144, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 168, 1 },
	{ 0.17876, 0.58179, 0.07815, 0, 36, 180, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 0, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 24, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 48, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 72, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 96, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 120, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 144, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 168, 1 },
	{ 0.17876, 0.53717, 0.08857, 0, 48, 180, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 0, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 24, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 48, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 72, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 96, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 120, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 144, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 168, 1 },
	{ 0.17876, 0.46555, 0.10809, 0, 60, 180, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 0, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 24, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 48, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 72, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 96, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 120, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 144, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 168, 1 },
	{ 0.17876, 0.41638, 0.12211, 0, 66, 180, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 0, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 24, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 48, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 72, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 96, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 120, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 144, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 168, 1 },
	{ 0.17876, 0.62248, 0.07325, 12, 0, 180, 1 },
	{ 0.17876, 0.6181, 0.08233, 12, 12, 0, 1 },
	{ 0.17876, 0.6181, 0.08025, 12, 12, 24, 1 },
	{ 0.17876, 0.6181, 0.07621, 12, 12, 48, 1 },
	{ 0.17876, 0.6181, 0.07376, 12, 12, 72, 1 },
	{ 0.17876, 0.6181, 0.07256, 12, 12, 96, 1 },
	{ 0.17876, 0.6181, 0.07173, 12, 12, 120, 1 },
	{ 0.17876, 0.6181, 0.07114, 12, 12, 144, 1 },
	{ 0.17876, 0.6181, 0.07086, 12, 12, 168, 1 },
	{ 0.17876, 0.6181, 0.07081, 12, 12, 180, 1 },
	{ 0.17876, 0.60411, 0.07959, 12, 24, 0, 1 },
	{ 0.17876, 0.60411, 0.07863, 12, 24, 24, 1 },
	{ 0.17876, 0.60411, 0.07712, 12, 24, 48, 1 },
	{ 0.17876, 0.60411, 0.07559, 12, 24, 72, 1 },
	{ 0.17876, 0.60411, 0.07412, 12, 24, 96, 1 },
	{ 0.17876, 0.60411, 0.07296, 12, 24, 120, 1 },
	{ 0.17876, 0.60411, 0.07222, 12, 24, 144, 1 },
	{ 0.17876, 0.60411, 0.07188, 12, 24, 168, 1 },
	{ 0.17876, 0.60411, 0.07184, 12, 24, 180, 1 },
	{ 0.17876, 0.5777, 0.08393, 12, 36, 0, 1 },
	{ 0.17876, 0.5777, 0.08341, 12, 36, 24, 1 },
	{ 0.17876, 0.5777, 0.08208, 12, 36, 48, 1 },
	{ 0.17876, 0.5777, 0.08049, 12, 36, 72, 1 },
	{ 0.17876, 0.5777, 0.07919, 12, 36, 96, 1 },
	{ 0.17876, 0.5777, 0.07839, 12, 36, 120, 1 },
	{ 0.17876, 0.5777, 0.07805, 12, 36, 144, 1 },
	{ 0.17876, 0.5777, 0.07795, 12, 36, 168, 1 },
	{ 0.17876, 0.5777, 0.07795, 12, 36, 180, 1 },
	{ 0.17876, 0.5334, 0.09309, 12, 48, 0, 1 },
	{ 0.17876, 0.5334, 0.09269, 12, 48, 24, 1 },
	{ 0.17876, 0.5334, 0.09175, 12, 48, 48, 1 },
	{ 0.17876, 0.5334, 0.09089, 12, 48, 72, 1 },
	{ 0.17876, 0.5334, 0.09057, 12, 48, 96, 1 },
	{ 0.17876, 0.5334, 0.09087, 12, 48, 120, 1 },
	{ 0.17876, 0.5334, 0.0915, 12, 48, 144, 1 },
	{ 0.17876, 0.5334, 0.09199, 12, 48, 168, 1 },
	{ 0.17876, 0.5334, 0.09206, 12, 48, 180, 1 },
	{ 0.17876, 0.46228, 0.10973, 12, 60, 0, 1 },
	{ 0.17876, 0.46228, 0.1096, 12, 60, 24, 1 },
	{ 0.17876, 0.46228, 0.1095, 12, 60, 48, 1 },
	{ 0.17876, 0.46228, 0.10997, 12, 60, 72, 1 },
	{ 0.17876, 0.46228, 0.11142, 12, 60, 96, 1 },
	{ 0.17876, 0.46228, 0.11371, 12, 60, 120, 1 },
	{ 0.17876, 0.46228, 0.11613, 12, 60, 144, 1 },
	{ 0.17876, 0.46228, 0.11772, 12, 60, 168, 1 },
	{ 0.17876, 0.46228, 0.11793, 12, 60, 180, 1 },
	{ 0.17876, 0.41345, 0.12167, 12, 66, 0, 1 },
	{ 0.17876, 0.41345, 0.12173, 12, 66, 24, 1 },
	{ 0.17876, 0.41345, 0.12218, 12, 66, 48, 1 },
	{ 0.17876, 0.41345, 0.12358, 12, 66, 72, 1 },
	{ 0.17876, 0.41345, 0.12631, 12, 66, 96, 1 },
	{ 0.17876, 0.41345, 0.13008, 12, 66, 120, 1 },
	{ 0.17876, 0.41345, 0.13386, 12, 66, 144, 1 },
	{ 0.17876, 0.41345, 0.13628, 12, 66, 168, 1 },
	{ 0.17876, 0.41345, 0.13661, 12, 66, 180, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 0, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 24, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 48, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 72, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 96, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 120, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 144, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 168, 1 },
	{ 0.17876, 0.60839, 0.07373, 24, 0, 180, 1 },
	{ 0.17876, 0.60411, 0.07959, 24, 12, 0, 1 },
	{ 0.17876, 0.60411, 0.07863, 24, 12, 24, 1 },
	{ 0.17876, 0.60411, 0.07713, 24, 12, 48, 1 },
	{ 0.17876, 0.60411, 0.07559, 24, 12, 72, 1 },
	{ 0.17876, 0.60411, 0.07411, 24, 12, 96, 1 },
	{ 0.17876, 0.60411, 0.07296, 24, 12, 120, 1 },
	{ 0.17876, 0.60411, 0.07222, 24, 12, 144, 1 },
	{ 0.17876, 0.60411, 0.07188, 24, 12, 168, 1 },
	{ 0.17876, 0.60411, 0.07183, 24, 12, 180, 1 },
	{ 0.17876, 0.59044, 0.09344, 24, 24, 0, 1 },
	{ 0.17876, 0.59044, 0.08666, 24, 24, 24, 1 },
	{ 0.17876, 0.59044, 0.08207, 24, 24, 48, 1 },
	{ 0.17876, 0.59044, 0.07914, 24, 24, 72, 1 },
	{ 0.17876, 0.59044, 0.07677, 24, 24, 96, 1 },
	{ 0.17876, 0.59044, 0.07541, 24, 24, 120, 1 },
	{ 0.17876, 0.59044, 0.07487, 24, 24, 144, 1 },
	{ 0.17876, 0.59044, 0.07476, 24, 24, 168, 1 },
	{ 0.17876, 0.59044, 0.07475, 24, 24, 180, 1 },
	{ 0.17876, 0.56463, 0.09478, 24, 36, 0, 1 },
	{ 0.17876, 0.56463, 0.09241, 24, 36, 24, 1 },
	{ 0.17876, 0.56463, 0.08898, 24, 36, 48, 1 },
	{ 0.17876, 0.56463, 0.08558, 24, 36, 72, 1 },
	{ 0.17876, 0.56463, 0.08365, 24, 36, 96, 1 },
	{ 0.17876, 0.56463, 0.08337, 24, 36, 120, 1 },
	{ 0.17876, 0.56463, 0.08407, 24, 36, 144, 1 },
	{ 0.17876, 0.56463, 0.08479, 24, 36, 168, 1 },
	{ 0.17876, 0.56463, 0.0849, 24, 36, 180, 1 },
	{ 0.17876, 0.52132, 0.10476, 24, 48, 0, 1 },
	{ 0.17876, 0.52132, 0.10323, 24, 48, 24, 1 },
	{ 0.17876, 0.52132, 0.09993, 24, 48, 48, 1 },
	{ 0.17876, 0.52132, 0.09746, 24, 48, 72, 1 },
	{ 0.17876, 0.52132, 0.09739, 24, 48, 96, 1 },
	{ 0.17876, 0.52132, 0.09966, 24, 48, 120, 1 },
	{ 0.17876, 0.52132, 0.10301, 24, 48, 144, 1 },
	{ 0.17876, 0.52132, 0.10546, 24, 48, 168, 1 },
	{ 0.17876, 0.52132, 0.10581, 24, 48, 180, 1 },
	{ 0.17876, 0.45181, 0.12161, 24, 60, 0, 1 },
	{ 0.17876, 0.45181, 0.12041, 24, 60, 24, 1 },
	{ 0.17876, 0.45181, 0.11828, 24, 60, 48, 1 },
	{ 0.17876, 0.45181, 0.11801, 24, 60, 72, 1 },
	{ 0.17876, 0.45181, 0.12141, 24, 60, 96, 1 },
	{ 0.17876, 0.45181, 0.12847, 24, 60, 120, 1 },
	{ 0.17876, 0.45181, 0.13688, 24, 60, 144, 1 },
	{ 0.17876, 0.45181, 0.14274, 24, 60, 168, 1 },
	{ 0.17876, 0.45181, 0.14357, 24, 60, 180, 1 },
	{ 0.17876, 0.40409, 0.13335, 24, 66, 0, 1 },
	{ 0.17876, 0.40409, 0.13243, 24, 66, 24, 1 },
	{ 0.17876, 0.40409, 0.13112, 24, 66, 48, 1 },
	{ 0.17876, 0.40409, 0.13237, 24, 66, 72, 1 },
	{ 0.17876, 0.40409, 0.13833, 24, 66, 96, 1 },
	{ 0.17876, 0.40409, 0.14898, 24, 66, 120, 1 },
	{ 0.17876, 0.40409, 0.16133, 24, 66, 144, 1 },
	{ 0.17876, 0.40409, 0.16989, 24, 66, 168, 1 },
	{ 0.17876, 0.40409, 0.1711, 24, 66, 180, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 0, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 24, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 48, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 72, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 96, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 120, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 144, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 168, 1 },
	{ 0.17876, 0.58179, 0.07815, 36, 0, 180, 1 },
	{ 0.17876, 0.5777, 0.08395, 36, 12, 0, 1 },
	{ 0.17876, 0.5777, 0.08343, 36, 12, 24, 1 },
	{ 0.17876, 0.5777, 0.08209, 36, 12, 48, 1 },
	{ 0.17876, 0.5777, 0.0805, 36, 12, 72, 1 },
	{ 0.17876, 0.5777, 0.07919, 36, 12, 96, 1 },
	{ 0.17876, 0.5777, 0.07839, 36, 12, 120, 1 },
	{ 0.17876, 0.5777, 0.07804, 36, 12, 144, 1 },
	{ 0.17876, 0.5777, 0.07794, 36, 12, 168, 1 },
	{ 0.17876, 0.5777, 0.07794, 36, 12, 180, 1 },
	{ 0.17876, 0.56463, 0.09478, 36, 24, 0, 1 },
	{ 0.17876, 0.56463, 0.09242, 36, 24, 24, 1 },
	{ 0.17876, 0.56463, 0.08899, 36, 24, 48, 1 },
	{ 0.17876, 0.56463, 0.08559, 36, 24, 72, 1 },
	{ 0.17876, 0.56463, 0.08365, 36, 24, 96, 1 },
	{ 0.17876, 0.56463, 0.08337, 36, 24, 120, 1 },
	{ 0.17876, 0.56463, 0.08406, 36, 24, 144, 1 },
	{ 0.17876, 0.56463, 0.08478, 36, 24, 168, 1 },
	{ 0.17876, 0.56463, 0.0849, 36, 24, 180, 1 },
	{ 0.17876, 0.53995, 0.11585, 36, 36, 0, 1 },
	{ 0.17876, 0.53995, 0.1046, 36, 36, 24, 1 },
	{ 0.17876, 0.53995, 0.09884, 36, 36, 48, 1 },
	{ 0.17876, 0.53995, 0.09439, 36, 36, 72, 1 },
	{ 0.17876, 0.53995, 0.09328, 36, 36, 96, 1 },
	{ 0.17876, 0.53995, 0.09529, 36, 36, 120, 1 },
	{ 0.17876, 0.53995, 0.09882, 36, 36, 144, 1 },
	{ 0.17876, 0.53995, 0.10157, 36, 36, 168, 1 },
	{ 0.17876, 0.53995, 0.10196, 36, 36, 180, 1 },
	{ 0.17876, 0.49853, 0.12395, 36, 48, 0, 1 },
	{ 0.17876, 0.49853, 0.11955, 36, 48, 24, 1 },
	{ 0.17876, 0.49853, 0.11308, 36, 48, 48, 1 },
	{ 0.17876, 0.49853, 0.10921, 36, 48, 72, 1 },
	{ 0.17876, 0.49853, 0.11084, 36, 48, 96, 1 },
	{ 0.17876, 0.49853, 0.11774, 36, 48, 120, 1 },
	{ 0.17876, 0.49853, 0.12712, 36, 48, 144, 1 },
	{ 0.17876, 0.49853, 0.13402, 36, 48, 168, 1 },
	{ 0.17876, 0.49853, 0.13502, 36, 48, 180, 1 },
	{ 0.17876, 0.43206, 0.14421, 36, 60, 0, 1 },
	{ 0.17876, 0.43206, 0.14082, 36, 60, 24, 1 },
	{ 0.17876, 0.43206, 0.13481, 36, 60, 48, 1 },
	{ 0.17876, 0.43206, 0.13332, 36, 60, 72, 1 },
	{ 0.17876, 0.43206, 0.14033, 36, 60, 96, 1 },
	{ 0.17876, 0.43206, 0.15635, 36, 60, 120, 1 },
	{ 0.17876, 0.43206, 0.17701, 36, 60, 144, 1 },
	{ 0.17876, 0.43206, 0.19228, 36, 60, 168, 1 },
	{ 0.17876, 0.43206, 0.1945, 36, 60, 180, 1 },
	{ 0.17876, 0.38643, 0.15802, 36, 66, 0, 1 },
	{ 0.17876, 0.38643, 0.15477, 36, 66, 24, 1 },
	{ 0.17876, 0.38643, 0.14949, 36, 66, 48, 1 },
	{ 0.17876, 0.38643, 0.1498, 36, 66, 72, 1 },
	{ 0.17876, 0.38643, 0.16075, 36, 66, 96, 1 },
	{ 0.17876, 0.38643, 0.18365, 36, 66, 120, 1 },
	{ 0.17876, 0.38643, 0.21316, 36, 66, 144, 1 },
	{ 0.17876, 0.38643, 0.23532, 36, 66, 168, 1 },
	{ 0.17876, 0.38643, 0.23856, 36, 66, 180, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 0, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 24, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 48, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 72, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 96, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 120, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 144, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 168, 1 },
	{ 0.17876, 0.53717, 0.08858, 48, 0, 180, 1 },
	{ 0.17876, 0.5334, 0.09311, 48, 12, 0, 1 },
	{ 0.17876, 0.5334, 0.0927, 48, 12, 24, 1 },
	{ 0.17876, 0.5334, 0.09176, 48, 12, 48, 1 },
	{ 0.17876, 0.5334, 0.0909, 48, 12, 72, 1 },
	{ 0.17876, 0.5334, 0.09058, 48, 12, 96, 1 },
	{ 0.17876, 0.5334, 0.09088, 48, 12, 120, 1 },
	{ 0.17876, 0.5334, 0.0915, 48, 12, 144, 1 },
	{ 0.17876, 0.5334, 0.09199, 48, 12, 168, 1 },
	{ 0.17876, 0.5334, 0.09206, 48, 12, 180, 1 },
	{ 0.17876, 0.52132, 0.10477, 48, 24, 0, 1 },
	{ 0.17876, 0.52132, 0.10324, 48, 24, 24, 1 },
	{ 0.17876, 0.52132, 0.09994, 48, 24, 48, 1 },
	{ 0.17876, 0.52132, 0.09748, 48, 24, 72, 1 },
	{ 0.17876, 0.52132, 0.09739, 48, 24, 96, 1 },
	{ 0.17876, 0.52132, 0.09966, 48, 24, 120, 1 },
	{ 0.17876, 0.52132, 0.103, 48, 24, 144, 1 },
	{ 0.17876, 0.52132, 0.10546, 48, 24, 168, 1 },
	{ 0.17876, 0.52132, 0.10581, 48, 24, 180, 1 },
	{ 0.17876, 0.49853, 0.12396, 48, 36, 0, 1 },
	{ 0.17876, 0.49853, 0.11956, 48, 36, 24, 1 },
	{ 0.17876, 0.49853, 0.11309, 48, 36, 48, 1 },
	{ 0.17876, 0.49853, 0.10922, 48, 36, 72, 1 },
	{ 0.17876, 0.49853, 0.11085, 48, 36, 96, 1 },
	{ 0.17876, 0.49853, 0.11774, 48, 36, 120, 1 },
	{ 0.17876, 0.49853, 0.12712, 48, 36, 144, 1 },
	{ 0.17876, 0.49853, 0.13401, 48, 36, 168, 1 },
	{ 0.17876, 0.49853, 0.13501, 48, 36, 180, 1 },
	{ 0.17876, 0.4603, 0.15843, 48, 48, 0, 1 },
	{ 0.17876, 0.4603, 0.14188, 48, 48, 24, 1 },
	{ 0.17876, 0.4603, 0.13242, 48, 48, 48, 1 },
	{ 0.17876, 0.4603, 0.1284, 48, 48, 72, 1 },
	{ 0.17876, 0.4603, 0.13418, 48, 48, 96, 1 },
	{ 0.17876, 0.4603, 0.15006, 48, 48, 120, 1 },
	{ 0.17876, 0.4603, 0.17144, 48, 48, 144, 1 },
	{ 0.17876, 0.4603, 0.18762, 48, 48, 168, 1 },
	{ 0.17876, 0.4603, 0.19, 48, 48, 180, 1 },
	{ 0.17876, 0.39893, 0.17999, 48, 60, 0, 1 },
	{ 0.17876, 0.39893, 0.17196, 48, 60, 24, 1 },
	{ 0.17876, 0.39893, 0.16084, 48, 60, 48, 1 },
	{ 0.17876, 0.39893, 0.15863, 48, 60, 72, 1 },
	{ 0.17876, 0.39893, 0.17229, 48, 60, 96, 1 },
	{ 0.17876, 0.39893, 0.20446, 48, 60, 120, 1 },
	{ 0.17876, 0.39893, 0.24905, 48, 60, 144, 1 },
	{ 0.17876, 0.39893, 0.28457, 48, 60, 168, 1 },
	{ 0.17876, 0.39893, 0.28994, 48, 60, 180, 1 },
	{ 0.17876, 0.35679, 0.198, 48, 66, 0, 1 },
	{ 0.17876, 0.35679, 0.19102, 48, 66, 24, 1 },
	{ 0.17876, 0.35679, 0.17965, 48, 66, 48, 1 },
	{ 0.17876, 0.35679, 0.17906, 48, 66, 72, 1 },
	{ 0.17876, 0.35679, 0.19842, 48, 66, 96, 1 },
	{ 0.17876, 0.35679, 0.24272, 48, 66, 120, 1 },
	{ 0.17876, 0.35679, 0.30575, 48, 66, 144, 1 },
	{ 0.17876, 0.35679, 0.35779, 48, 66, 168, 1 },
	{ 0.17876, 0.35679, 0.3658, 48, 66, 180, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 0, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 24, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 48, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 72, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 96, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 120, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 144, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 168, 1 },
	{ 0.17876, 0.46555, 0.10812, 60, 0, 180, 1 },
	{ 0.17876, 0.46228, 0.10977, 60, 12, 0, 1 },
	{ 0.17876, 0.46228, 0.10964, 60, 12, 24, 1 },
	{ 0.17876, 0.46228, 0.10954, 60, 12, 48, 1 },
	{ 0.17876, 0.46228, 0.11, 60, 12, 72, 1 },
	{ 0.17876, 0.46228, 0.11144, 60, 12, 96, 1 },
	{ 0.17876, 0.46228, 0.11373, 60, 12, 120, 1 },
	{ 0.17876, 0.46228, 0.11615, 60, 12, 144, 1 },
	{ 0.17876, 0.46228, 0.11772, 60, 12, 168, 1 },
	{ 0.17876, 0.46228, 0.11794, 60, 12, 180, 1 },
	{ 0.17876, 0.45181, 0.12167, 60, 24, 0, 1 },
	{ 0.17876, 0.45181, 0.12046, 60, 24, 24, 1 },
	{ 0.17876, 0.45181, 0.11833, 60, 24, 48, 1 },
	{ 0.17876, 0.45181, 0.11804, 60, 24, 72, 1 },
	{ 0.17876, 0.45181, 0.12143, 60, 24, 96, 1 },
	{ 0.17876, 0.45181, 0.12848, 60, 24, 120, 1 },
	{ 0.17876, 0.45181, 0.13689, 60, 24, 144, 1 },
	{ 0.17876, 0.45181, 0.14274, 60, 24, 168, 1 },
	{ 0.17876, 0.45181, 0.14357, 60, 24, 180, 1 },
	{ 0.17876, 0.43206, 0.14427, 60, 36, 0, 1 },
	{ 0.17876, 0.43206, 0.14088, 60, 36, 24, 1 },
	{ 0.17876, 0.43206, 0.13485, 60, 36, 48, 1 },
	{ 0.17876, 0.43206, 0.13336, 60, 36, 72, 1 },
	{ 0.17876, 0.43206, 0.14035, 60, 36, 96, 1 },
	{ 0.17876, 0.43206, 0.15635, 60, 36, 120, 1 },
	{ 0.17876, 0.43206, 0.17701, 60, 36, 144, 1 },
	{ 0.17876, 0.43206, 0.19227, 60, 36, 168, 1 },
	{ 0.17876, 0.43206, 0.1945, 60, 36, 180, 1 },
	{ 0.17876, 0.39893, 0.18005, 60, 48, 0, 1 },
	{ 0.17876, 0.39893, 0.17201, 60, 48, 24, 1 },
	{ 0.17876, 0.39893, 0.16088, 60, 48, 48, 1 },
	{ 0.17876, 0.39893, 0.15867, 60, 48, 72, 1 },
	{ 0.17876, 0.39893, 0.17231, 60, 48, 96, 1 },
	{ 0.17876, 0.39893, 0.20446, 60, 48, 120, 1 },
	{ 0.17876, 0.39893, 0.24905, 60, 48, 144, 1 },
	{ 0.17876, 0.39893, 0.28457, 60, 48, 168, 1 },
	{ 0.17876, 0.39893, 0.28994, 60, 48, 180, 1 },
	{ 0.17876, 0.34574, 0.24244, 60, 60, 0, 1 },
	{ 0.17876, 0.34574, 0.21657, 60, 60, 24, 1 },
	{ 0.17876, 0.34574, 0.20015, 60, 60, 48, 1 },
	{ 0.17876, 0.34574, 0.19862, 60, 60, 72, 1 },
	{ 0.17876, 0.34574, 0.22384, 60, 60, 96, 1 },
	{ 0.17876, 0.34574, 0.28427, 60, 60, 120, 1 },
	{ 0.17876, 0.34574, 0.37538, 60, 60, 144, 1 },
	{ 0.17876, 0.34574, 0.45537, 60, 60, 168, 1 },
	{ 0.17876, 0.34574, 0.4681, 60, 60, 180, 1 },
	{ 0.17876, 0.30922, 0.26805, 60, 66, 0, 1 },
	{ 0.17876, 0.30922, 0.24544, 60, 66, 24, 1 },
	{ 0.17876, 0.30922, 0.22651, 60, 66, 48, 1 },
	{ 0.17876, 0.30922, 0.22588, 60, 66, 72, 1 },
	{ 0.17876, 0.30922, 0.25925, 60, 66, 96, 1 },
	{ 0.17876, 0.30922, 0.34046, 60, 66, 120, 1 },
	{ 0.17876, 0.30922, 0.46896, 60, 66, 144, 1 },
	{ 0.17876, 0.30922, 0.58894, 60, 66, 168, 1 },
	{ 0.17876, 0.30922, 0.60868, 60, 66, 180, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 0, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 24, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 48, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 72, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 96, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 120, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 144, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 168, 1 },
	{ 0.17876, 0.35809, 0.13889, 72, 0, 180, 1 },
	{ 0.17876, 0.35557, 0.13599, 72, 12, 0, 1 },
	{ 0.17876, 0.35557, 0.13626, 72, 12, 24, 1 },
	{ 0.17876, 0.35557, 0.13732, 72, 12, 48, 1 },
	{ 0.17876, 0.35557, 0.1398, 72, 12, 72, 1 },
	{ 0.17876, 0.35557, 0.14406, 72, 12, 96, 1 },
	{ 0.17876, 0.35557, 0.14964, 72, 12, 120, 1 },
	{ 0.17876, 0.35557, 0.15513, 72, 12, 144, 1 },
	{ 0.17876, 0.35557, 0.1586, 72, 12, 168, 1 },
	{ 0.17876, 0.35557, 0.15907, 72, 12, 180, 1 },
	{ 0.17876, 0.34753, 0.14756, 72, 24, 0, 1 },
	{ 0.17876, 0.34753, 0.14689, 72, 24, 24, 1 },
	{ 0.17876, 0.34753, 0.14642, 72, 24, 48, 1 },
	{ 0.17876, 0.34753, 0.14938, 72, 24, 72, 1 },
	{ 0.17876, 0.34753, 0.15836, 72, 24, 96, 1 },
	{ 0.17876, 0.34753, 0.17348, 72, 24, 120, 1 },
	{ 0.17876, 0.34753, 0.19089, 72, 24, 144, 1 },
	{ 0.17876, 0.34753, 0.20298, 72, 24, 168, 1 },
	{ 0.17876, 0.34753, 0.2047, 72, 24, 180, 1 },
	{ 0.17876, 0.33234, 0.17452, 72, 36, 0, 1 },
	{ 0.17876, 0.33234, 0.17149, 72, 36, 24, 1 },
	{ 0.17876, 0.33234, 0.16695, 72, 36, 48, 1 },
	{ 0.17876, 0.33234, 0.16919, 72, 36, 72, 1 },
	{ 0.17876, 0.33234, 0.1848, 72, 36, 96, 1 },
	{ 0.17876, 0.33234, 0.21626, 72, 36, 120, 1 },
	{ 0.17876, 0.33234, 0.25733, 72, 36, 144, 1 },
	{ 0.17876, 0.33234, 0.28885, 72, 36, 168, 1 },
	{ 0.17876, 0.33234, 0.29352, 72, 36, 180, 1 },
	{ 0.17876, 0.30685, 0.22092, 72, 48, 0, 1 },
	{ 0.17876, 0.30685, 0.21361, 72, 48, 24, 1 },
	{ 0.17876, 0.30685, 0.20208, 72, 48, 48, 1 },
	{ 0.17876, 0.30685, 0.20316, 72, 48, 72, 1 },
	{ 0.17876, 0.30685, 0.22916, 72, 48, 96, 1 },
	{ 0.17876, 0.30685, 0.28852, 72, 48, 120, 1 },
	{ 0.17876, 0.30685, 0.37602, 72, 48, 144, 1 },
	{ 0.17876, 0.30685, 0.45152, 72, 48, 168, 1 },
	{ 0.17876, 0.30685, 0.46341, 72, 48, 180, 1 },
	{ 0.17876, 0.26593, 0.29605, 72, 60, 0, 1 },
	{ 0.17876, 0.26593, 0.2802, 72, 60, 24, 1 },
	{ 0.17876, 0.26593, 0.25861, 72, 60, 48, 1 },
	{ 0.17876, 0.26593, 0.25867, 72, 60, 72, 1 },
	{ 0.17876, 0.26593, 0.30149, 72, 60, 96, 1 },
	{ 0.17876, 0.26593, 0.40849, 72, 60, 120, 1 },
	{ 0.17876, 0.26593, 0.58751, 72, 60, 144, 1 },
	{ 0.17876, 0.26593, 0.76674, 72, 60, 168, 1 },
	{ 0.17876, 0.26593, 0.79758, 72, 60, 180, 1 },
	{ 0.17876, 0.23785, 0.35772, 72, 66, 0, 1 },
	{ 0.17876, 0.23785, 0.32665, 72, 66, 24, 1 },
	{ 0.17876, 0.23785, 0.29865, 72, 66, 48, 1 },
	{ 0.17876, 0.23785, 0.29814, 72, 66, 72, 1 },
	{ 0.17876, 0.23785, 0.35264, 72, 66, 96, 1 },
	{ 0.17876, 0.23785, 0.49465, 72, 66, 120, 1 },
	{ 0.17876, 0.23785, 0.74863, 72, 66, 144, 1 },
	{ 0.17876, 0.23785, 1.02706, 72, 66, 168, 1 },
	{ 0.17876, 0.23785, 1.0779, 72, 66, 180, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 0, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 24, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 48, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 72, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 96, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 120, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 144, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 168, 1 },
	{ 0.17876, 0.23866, 0.174, 84, 0, 180, 1 },
	{ 0.17876, 0.23698, 0.1684, 84, 12, 0, 1 },
	{ 0.17876, 0.23698, 0.16882, 84, 12, 24, 1 },
	{ 0.17876, 0.23698, 0.17048, 84, 12, 48, 1 },
	{ 0.17876, 0.23698, 0.1743, 84, 12, 72, 1 },
	{ 0.17876, 0.23698, 0.18087, 84, 12, 96, 1 },
	{ 0.17876, 0.23698, 0.1896, 84, 12, 120, 1 },
	{ 0.17876, 0.23698, 0.19832, 84, 12, 144, 1 },
	{ 0.17876, 0.23698, 0.20389, 84, 12, 168, 1 },
	{ 0.17876, 0.23698, 0.20466, 84, 12, 180, 1 },
	{ 0.17876, 0.23162, 0.18341, 84, 24, 0, 1 },
	{ 0.17876, 0.23162, 0.18255, 84, 24, 24, 1 },
	{ 0.17876, 0.23162, 0.18195, 84, 24, 48, 1 },
	{ 0.17876, 0.23162, 0.18609, 84, 24, 72, 1 },
	{ 0.17876, 0.23162, 0.19928, 84, 24, 96, 1 },
	{ 0.17876, 0.23162, 0.22253, 84, 24, 120, 1 },
	{ 0.17876, 0.23162, 0.25043, 84, 24, 144, 1 },
	{ 0.17876, 0.23162, 0.27051, 84, 24, 168, 1 },
	{ 0.17876, 0.23162, 0.27341, 84, 24, 180, 1 },
	{ 0.17876, 0.22149, 0.22057, 84, 36, 0, 1 },
	{ 0.17876, 0.22149, 0.21672, 84, 36, 24, 1 },
	{ 0.17876, 0.22149, 0.2102, 84, 36, 48, 1 },
	{ 0.17876, 0.22149, 0.21206, 84, 36, 72, 1 },
	{ 0.17876, 0.22149, 0.23345, 84, 36, 96, 1 },
	{ 0.17876, 0.22149, 0.28076, 84, 36, 120, 1 },
	{ 0.17876, 0.22149, 0.34745, 84, 36, 144, 1 },
	{ 0.17876, 0.22149, 0.40229, 84, 36, 168, 1 },
	{ 0.17876, 0.22149, 0.41071, 84, 36, 180, 1 },
	{ 0.17876, 0.20451, 0.28845, 84, 48, 0, 1 },
	{ 0.17876, 0.20451, 0.27896, 84, 48, 24, 1 },
	{ 0.17876, 0.20451, 0.26184, 84, 48, 48, 1 },
	{ 0.17876, 0.20451, 0.25907, 84, 48, 72, 1 },
	{ 0.17876, 0.20451, 0.29236, 84, 48, 96, 1 },
	{ 0.17876, 0.20451, 0.38006, 84, 48, 120, 1 },
	{ 0.17876, 0.20451, 0.52467, 84, 48, 144, 1 },
	{ 0.17876, 0.20451, 0.66498, 84, 48, 168, 1 },
	{ 0.17876, 0.20451, 0.68865, 84, 48, 180, 1 },
	{ 0.17876, 0.17724, 0.40849, 84, 60, 0, 1 },
	{ 0.17876, 0.17724, 0.38864, 84, 60, 24, 1 },
	{ 0.17876, 0.17724, 0.35313, 84, 60, 48, 1 },
	{ 0.17876, 0.17724, 0.34264, 84, 60, 72, 1 },
	{ 0.17876, 0.17724, 0.39517, 84, 60, 96, 1 },
	{ 0.17876, 0.17724, 0.55294, 84, 60, 120, 1 },
	{ 0.17876, 0.17724, 0.85686, 84, 60, 144, 1 },
	{ 0.17876, 0.17724, 1.22211, 84, 60, 168, 1 },
	{ 0.17876, 0.17724, 1.29288, 84, 60, 180, 1 },
	{ 0.17876, 0.15852, 0.50286, 84, 66, 0, 1 },
	{ 0.17876, 0.15852, 0.47496, 84, 66, 24, 1 },
	{ 0.17876, 0.15852, 0.42509, 84, 66, 48, 1 },
	{ 0.17876, 0.15852, 0.4085, 84, 66, 72, 1 },
	{ 0.17876, 0.15852, 0.47537, 84, 66, 96, 1 },
	{ 0.17876, 0.15852, 0.68761, 84, 66, 120, 1 },
	{ 0.17876, 0.15852, 1.12847, 84, 66, 144, 1 },
	{ 0.17876, 0.15852, 1.72965, 84, 66, 168, 1 },
	{ 0.17876, 0.15852, 1.8585, 84, 66, 180, 1 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 0, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 24, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 48, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 72, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 96, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 120, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 144, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 168, 1.5 },
	{ 0.21053, 0.49562, 0.10476, 0, 0, 180, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 0, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 24, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 48, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 72, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 96, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 120, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 144, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 168, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 0, 12, 180, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 0, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 24, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 48, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 72, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 96, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 120, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 144, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 168, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 0, 24, 180, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 0, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 24, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 48, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 72, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 96, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 120, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 144, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 168, 1.5 },
	{ 0.21053, 0.44626, 0.10547, 0, 36, 180, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 0, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 24, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 48, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 72, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 96, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 120, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 144, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 168, 1.5 },
	{ 0.21053, 0.401, 0.11802, 0, 48, 180, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 0, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 24, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 48, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 72, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 96, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 120, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 144, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 168, 1.5 },
	{ 0.21053, 0.33533, 0.13852, 0, 60, 180, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 0, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 24, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 48, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 72, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 96, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 120, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 144, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 168, 1.5 },
	{ 0.21053, 0.29498, 0.15125, 0, 66, 180, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 0, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 24, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 48, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 72, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 96, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 120, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 144, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 168, 1.5 },
	{ 0.21053, 0.49062, 0.09823, 12, 0, 180, 1.5 },
	{ 0.21053, 0.48567, 0.10855, 12, 12, 0, 1.5 },
	{ 0.21053, 0.48567, 0.10621, 12, 12, 24, 1.5 },
	{ 0.21053, 0.48567, 0.10166, 12, 12, 48, 1.5 },
	{ 0.21053, 0.48567, 0.09896, 12, 12, 72, 1.5 },
	{ 0.21053, 0.48567, 0.0977, 12, 12, 96, 1.5 },
	{ 0.21053, 0.48567, 0.09686, 12, 12, 120, 1.5 },
	{ 0.21053, 0.48567, 0.09628, 12, 12, 144, 1.5 },
	{ 0.21053, 0.48567, 0.09601, 12, 12, 168, 1.5 },
	{ 0.21053, 0.48567, 0.09596, 12, 12, 180, 1.5 },
	{ 0.21053, 0.47012, 0.10583, 12, 24, 0, 1.5 },
	{ 0.21053, 0.47012, 0.10478, 12, 24, 24, 1.5 },
	{ 0.21053, 0.47012, 0.1032, 12, 24, 48, 1.5 },
	{ 0.21053, 0.47012, 0.10165, 12, 24, 72, 1.5 },
	{ 0.21053, 0.47012, 0.10021, 12, 24, 96, 1.5 },
	{ 0.21053, 0.47012, 0.09912, 12, 24, 120, 1.5 },
	{ 0.21053, 0.47012, 0.09848, 12, 24, 144, 1.5 },
	{ 0.21053, 0.47012, 0.09819, 12, 24, 168, 1.5 },
	{ 0.21053, 0.47012, 0.09816, 12, 24, 180, 1.5 },
	{ 0.21053, 0.44176, 0.1115, 12, 36, 0, 1.5 },
	{ 0.21053, 0.44176, 0.11098, 12, 36, 24, 1.5 },
	{ 0.21053, 0.44176, 0.10967, 12, 36, 48, 1.5 },
	{ 0.21053, 0.44176, 0.10817, 12, 36, 72, 1.5 },
	{ 0.21053, 0.44176, 0.10705, 12, 36, 96, 1.5 },
	{ 0.21053, 0.44176, 0.10651, 12, 36, 120, 1.5 },
	{ 0.21053, 0.44176, 0.10641, 12, 36, 144, 1.5 },
	{ 0.21053, 0.44176, 0.10647, 12, 36, 168, 1.5 },
	{ 0.21053, 0.44176, 0.10648, 12, 36, 180, 1.5 },
	{ 0.21053, 0.39696, 0.12222, 12, 48, 0, 1.5 },
	{ 0.21053, 0.39696, 0.12187, 12, 48, 24, 1.5 },
	{ 0.21053, 0.39696, 0.12111, 12, 48, 48, 1.5 },
	{ 0.21053, 0.39696, 0.12059, 12, 48, 72, 1.5 },
	{ 0.21053, 0.39696, 0.12075, 12, 48, 96, 1.5 },
	{ 0.21053, 0.39696, 0.12162, 12, 48, 120, 1.5 },
	{ 0.21053, 0.39696, 0.12274, 12, 48, 144, 1.5 },
	{ 0.21053, 0.39696, 0.12353, 12, 48, 168, 1.5 },
	{ 0.21053, 0.39696, 0.12364, 12, 48, 180, 1.5 },
	{ 0.21053, 0.33195, 0.13919, 12, 60, 0, 1.5 },
	{ 0.21053, 0.33195, 0.13917, 12, 60, 24, 1.5 },
	{ 0.21053, 0.33195, 0.13943, 12, 60, 48, 1.5 },
	{ 0.21053, 0.33195, 0.14049, 12, 60, 72, 1.5 },
	{ 0.21053, 0.33195, 0.14273, 12, 60, 96, 1.5 },
	{ 0.21053, 0.33195, 0.14588, 12, 60, 120, 1.5 },
	{ 0.21053, 0.33195, 0.14905, 12, 60, 144, 1.5 },
	{ 0.21053, 0.33195, 0.15108, 12, 60, 168, 1.5 },
	{ 0.21053, 0.33195, 0.15135, 12, 60, 180, 1.5 },
	{ 0.21053, 0.29201, 0.14963, 12, 66, 0, 1.5 },
	{ 0.21053, 0.29201, 0.14982, 12, 66, 24, 1.5 },
	{ 0.21053, 0.29201, 0.15068, 12, 66, 48, 1.5 },
	{ 0.21053, 0.29201, 0.15274, 12, 66, 72, 1.5 },
	{ 0.21053, 0.29201, 0.15633, 12, 66, 96, 1.5 },
	{ 0.21053, 0.29201, 0.16103, 12, 66, 120, 1.5 },
	{ 0.21053, 0.29201, 0.16561, 12, 66, 144, 1.5 },
	{ 0.21053, 0.29201, 0.1685, 12, 66, 168, 1.5 },
	{ 0.21053, 0.29201, 0.16889, 12, 66, 180, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 0, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 24, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 48, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 72, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 96, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 120, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 144, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 168, 1.5 },
	{ 0.21053, 0.47491, 0.09944, 24, 0, 180, 1.5 },
	{ 0.21053, 0.47012, 0.10584, 24, 12, 0, 1.5 },
	{ 0.21053, 0.47012, 0.10479, 24, 12, 24, 1.5 },
	{ 0.21053, 0.47012, 0.10321, 24, 12, 48, 1.5 },
	{ 0.21053, 0.47012, 0.10165, 24, 12, 72, 1.5 },
	{ 0.21053, 0.47012, 0.10021, 24, 12, 96, 1.5 },
	{ 0.21053, 0.47012, 0.09912, 24, 12, 120, 1.5 },
	{ 0.21053, 0.47012, 0.09848, 24, 12, 144, 1.5 },
	{ 0.21053, 0.47012, 0.09819, 24, 12, 168, 1.5 },
	{ 0.21053, 0.47012, 0.09816, 24, 12, 180, 1.5 },
	{ 0.21053, 0.45507, 0.12179, 24, 24, 0, 1.5 },
	{ 0.21053, 0.45507, 0.11421, 24, 24, 24, 1.5 },
	{ 0.21053, 0.45507, 0.10926, 24, 24, 48, 1.5 },
	{ 0.21053, 0.45507, 0.10631, 24, 24, 72, 1.5 },
	{ 0.21053, 0.45507, 0.10409, 24, 24, 96, 1.5 },
	{ 0.21053, 0.45507, 0.10302, 24, 24, 120, 1.5 },
	{ 0.21053, 0.45507, 0.10281, 24, 24, 144, 1.5 },
	{ 0.21053, 0.45507, 0.10291, 24, 24, 168, 1.5 },
	{ 0.21053, 0.45507, 0.10294, 24, 24, 180, 1.5 },
	{ 0.21053, 0.42761, 0.12379, 24, 36, 0, 1.5 },
	{ 0.21053, 0.42761, 0.12126, 24, 36, 24, 1.5 },
	{ 0.21053, 0.42761, 0.11778, 24, 36, 48, 1.5 },
	{ 0.21053, 0.42761, 0.11455, 24, 36, 72, 1.5 },
	{ 0.21053, 0.42761, 0.11313, 24, 36, 96, 1.5 },
	{ 0.21053, 0.42761, 0.11358, 24, 36, 120, 1.5 },
	{ 0.21053, 0.42761, 0.11502, 24, 36, 144, 1.5 },
	{ 0.21053, 0.42761, 0.11622, 24, 36, 168, 1.5 },
	{ 0.21053, 0.42761, 0.11639, 24, 36, 180, 1.5 },
	{ 0.21053, 0.38425, 0.13505, 24, 48, 0, 1.5 },
	{ 0.21053, 0.38425, 0.13353, 24, 48, 24, 1.5 },
	{ 0.21053, 0.38425, 0.13042, 24, 48, 48, 1.5 },
	{ 0.21053, 0.38425, 0.12856, 24, 48, 72, 1.5 },
	{ 0.21053, 0.38425, 0.12957, 24, 48, 96, 1.5 },
	{ 0.21053, 0.38425, 0.13323, 24, 48, 120, 1.5 },
	{ 0.21053, 0.38425, 0.13791, 24, 48, 144, 1.5 },
	{ 0.21053, 0.38425, 0.14119, 24, 48, 168, 1.5 },
	{ 0.21053, 0.38425, 0.14165, 24, 48, 180, 1.5 },
	{ 0.21053, 0.32132, 0.15176, 24, 60, 0, 1.5 },
	{ 0.21053, 0.32132, 0.1507, 24, 60, 24, 1.5 },
	{ 0.21053, 0.32132, 0.1491, 24, 60, 48, 1.5 },
	{ 0.21053, 0.32132, 0.14991, 24, 60, 72, 1.5 },
	{ 0.21053, 0.32132, 0.15497, 24, 60, 96, 1.5 },
	{ 0.21053, 0.32132, 0.16406, 24, 60, 120, 1.5 },
	{ 0.21053, 0.32132, 0.1744, 24, 60, 144, 1.5 },
	{ 0.21053, 0.32132, 0.18146, 24, 60, 168, 1.5 },
	{ 0.21053, 0.32132, 0.18244, 24, 60, 180, 1.5 },
	{ 0.21053, 0.28266, 0.16174, 24, 66, 0, 1.5 },
	{ 0.21053, 0.28266, 0.161, 24, 66, 24, 1.5 },
	{ 0.21053, 0.28266, 0.16035, 24, 66, 48, 1.5 },
	{ 0.21053, 0.28266, 0.16283, 24, 66, 72, 1.5 },
	{ 0.21053, 0.28266, 0.17058, 24, 66, 96, 1.5 },
	{ 0.21053, 0.28266, 0.18338, 24, 66, 120, 1.5 },
	{ 0.21053, 0.28266, 0.19778, 24, 66, 144, 1.5 },
	{ 0.21053, 0.28266, 0.20761, 24, 66, 168, 1.5 },
	{ 0.21053, 0.28266, 0.209, 24, 66, 180, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 0, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 24, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 48, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 72, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 96, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 120, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 144, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 168, 1.5 },
	{ 0.21053, 0.44626, 0.10548, 36, 0, 180, 1.5 },
	{ 0.21053, 0.44176, 0.11152, 36, 12, 0, 1.5 },
	{ 0.21053, 0.44176, 0.111, 36, 12, 24, 1.5 },
	{ 0.21053, 0.44176, 0.10969, 36, 12, 48, 1.5 },
	{ 0.21053, 0.44176, 0.10819, 36, 12, 72, 1.5 },
	{ 0.21053, 0.44176, 0.10706, 36, 12, 96, 1.5 },
	{ 0.21053, 0.44176, 0.10652, 36, 12, 120, 1.5 },
	{ 0.21053, 0.44176, 0.10641, 36, 12, 144, 1.5 },
	{ 0.21053, 0.44176, 0.10646, 36, 12, 168, 1.5 },
	{ 0.21053, 0.44176, 0.10648, 36, 12, 180, 1.5 },
	{ 0.21053, 0.42761, 0.1238, 36, 24, 0, 1.5 },
	{ 0.21053, 0.42761, 0.12128, 36, 24, 24, 1.5 },
	{ 0.21053, 0.42761, 0.11779, 36, 24, 48, 1.5 },
	{ 0.21053, 0.42761, 0.11456, 36, 24, 72, 1.5 },
	{ 0.21053, 0.42761, 0.11313, 36, 24, 96, 1.5 },
	{ 0.21053, 0.42761, 0.11359, 36, 24, 120, 1.5 },
	{ 0.21053, 0.42761, 0.11502, 36, 24, 144, 1.5 },
	{ 0.21053, 0.42761, 0.11621, 36, 24, 168, 1.5 },
	{ 0.21053, 0.42761, 0.11639, 36, 24, 180, 1.5 },
	{ 0.21053, 0.40181, 0.14762, 36, 36, 0, 1.5 },
	{ 0.21053, 0.40181, 0.13531, 36, 36, 24, 1.5 },
	{ 0.21053, 0.40181, 0.12946, 36, 36, 48, 1.5 },
	{ 0.21053, 0.40181, 0.12547, 36, 36, 72, 1.5 },
	{ 0.21053, 0.40181, 0.12542, 36, 36, 96, 1.5 },
	{ 0.21053, 0.40181, 0.12896, 36, 36, 120, 1.5 },
	{ 0.21053, 0.40181, 0.13403, 36, 36, 144, 1.5 },
	{ 0.21053, 0.40181, 0.13774, 36, 36, 168, 1.5 },
	{ 0.21053, 0.40181, 0.13829, 36, 36, 180, 1.5 },
	{ 0.21053, 0.36107, 0.15645, 36, 48, 0, 1.5 },
	{ 0.21053, 0.36107, 0.15189, 36, 48, 24, 1.5 },
	{ 0.21053, 0.36107, 0.14559, 36, 48, 48, 1.5 },
	{ 0.21053, 0.36107, 0.14268, 36, 48, 72, 1.5 },
	{ 0.21053, 0.36107, 0.14624, 36, 48, 96, 1.5 },
	{ 0.21053, 0.36107, 0.15573, 36, 48, 120, 1.5 },
	{ 0.21053, 0.36107, 0.16772, 36, 48, 144, 1.5 },
	{ 0.21053, 0.36107, 0.1763, 36, 48, 168, 1.5 },
	{ 0.21053, 0.36107, 0.17753, 36, 48, 180, 1.5 },
	{ 0.21053, 0.30193, 0.17628, 36, 60, 0, 1.5 },
	{ 0.21053, 0.30193, 0.17299, 36, 60, 24, 1.5 },
	{ 0.21053, 0.30193, 0.16758, 36, 60, 48, 1.5 },
	{ 0.21053, 0.30193, 0.1677, 36, 60, 72, 1.5 },
	{ 0.21053, 0.30193, 0.17744, 36, 60, 96, 1.5 },
	{ 0.21053, 0.30193, 0.19708, 36, 60, 120, 1.5 },
	{ 0.21053, 0.30193, 0.22146, 36, 60, 144, 1.5 },
	{ 0.21053, 0.30193, 0.23918, 36, 60, 168, 1.5 },
	{ 0.21053, 0.30193, 0.24175, 36, 60, 180, 1.5 },
	{ 0.21053, 0.2656, 0.18804, 36, 66, 0, 1.5 },
	{ 0.21053, 0.2656, 0.18498, 36, 66, 24, 1.5 },
	{ 0.21053, 0.2656, 0.18051, 36, 66, 48, 1.5 },
	{ 0.21053, 0.2656, 0.18262, 36, 66, 72, 1.5 },
	{ 0.21053, 0.2656, 0.19649, 36, 66, 96, 1.5 },
	{ 0.21053, 0.2656, 0.2232, 36, 66, 120, 1.5 },
	{ 0.21053, 0.2656, 0.25664, 36, 66, 144, 1.5 },
	{ 0.21053, 0.2656, 0.28145, 36, 66, 168, 1.5 },
	{ 0.21053, 0.2656, 0.28506, 36, 66, 180, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 0, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 24, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 48, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 72, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 96, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 120, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 144, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 168, 1.5 },
	{ 0.21053, 0.401, 0.11804, 48, 0, 180, 1.5 },
	{ 0.21053, 0.39696, 0.12225, 48, 12, 0, 1.5 },
	{ 0.21053, 0.39696, 0.1219, 48, 12, 24, 1.5 },
	{ 0.21053, 0.39696, 0.12114, 48, 12, 48, 1.5 },
	{ 0.21053, 0.39696, 0.12061, 48, 12, 72, 1.5 },
	{ 0.21053, 0.39696, 0.12077, 48, 12, 96, 1.5 },
	{ 0.21053, 0.39696, 0.12163, 48, 12, 120, 1.5 },
	{ 0.21053, 0.39696, 0.12275, 48, 12, 144, 1.5 },
	{ 0.21053, 0.39696, 0.12354, 48, 12, 168, 1.5 },
	{ 0.21053, 0.39696, 0.12365, 48, 12, 180, 1.5 },
	{ 0.21053, 0.38425, 0.13508, 48, 24, 0, 1.5 },
	{ 0.21053, 0.38425, 0.13357, 48, 24, 24, 1.5 },
	{ 0.21053, 0.38425, 0.13045, 48, 24, 48, 1.5 },
	{ 0.21053, 0.38425, 0.12859, 48, 24, 72, 1.5 },
	{ 0.21053, 0.38425, 0.12959, 48, 24, 96, 1.5 },
	{ 0.21053, 0.38425, 0.13324, 48, 24, 120, 1.5 },
	{ 0.21053, 0.38425, 0.13792, 48, 24, 144, 1.5 },
	{ 0.21053, 0.38425, 0.1412, 48, 24, 168, 1.5 },
	{ 0.21053, 0.38425, 0.14166, 48, 24, 180, 1.5 },
	{ 0.21053, 0.36107, 0.15647, 48, 36, 0, 1.5 },
	{ 0.21053, 0.36107, 0.15191, 48, 36, 24, 1.5 },
	{ 0.21053, 0.36107, 0.14561, 48, 36, 48, 1.5 },
	{ 0.21053, 0.36107, 0.1427, 48, 36, 72, 1.5 },
	{ 0.21053, 0.36107, 0.14625, 48, 36, 96, 1.5 },
	{ 0.21053, 0.36107, 0.15574, 48, 36, 120, 1.5 },
	{ 0.21053, 0.36107, 0.16773, 48, 36, 144, 1.5 },
	{ 0.21053, 0.36107, 0.17631, 48, 36, 168, 1.5 },
	{ 0.21053, 0.36107, 0.17754, 48, 36, 180, 1.5 },
	{ 0.21053, 0.32445, 0.19377, 48, 48, 0, 1.5 },
	{ 0.21053, 0.32445, 0.17623, 48, 48, 24, 1.5 },
	{ 0.21053, 0.32445, 0.1671, 48, 48, 48, 1.5 },
	{ 0.21053, 0.32445, 0.16461, 48, 48, 72, 1.5 },
	{ 0.21053, 0.32445, 0.17342, 48, 48, 96, 1.5 },
	{ 0.21053, 0.32445, 0.19345, 48, 48, 120, 1.5 },
	{ 0.21053, 0.32445, 0.21922, 48, 48, 144, 1.5 },
	{ 0.21053, 0.32445, 0.23835, 48, 48, 168, 1.5 },
	{ 0.21053, 0.32445, 0.24117, 48, 48, 180, 1.5 },
	{ 0.21053, 0.27132, 0.21431, 48, 60, 0, 1.5 },
	{ 0.21053, 0.27132, 0.20626, 48, 60, 24, 1.5 },
	{ 0.21053, 0.27132, 0.19586, 48, 60, 48, 1.5 },
	{ 0.21053, 0.27132, 0.19592, 48, 60, 72, 1.5 },
	{ 0.21053, 0.27132, 0.2136, 48, 60, 96, 1.5 },
	{ 0.21053, 0.27132, 0.25143, 48, 60, 120, 1.5 },
	{ 0.21053, 0.27132, 0.30224, 48, 60, 144, 1.5 },
	{ 0.21053, 0.27132, 0.34217, 48, 60, 168, 1.5 },
	{ 0.21053, 0.27132, 0.34817, 48, 60, 180, 1.5 },
	{ 0.21053, 0.23867, 0.22997, 48, 66, 0, 1.5 },
	{ 0.21053, 0.23867, 0.22316, 48, 66, 24, 1.5 },
	{ 0.21053, 0.23867, 0.21279, 48, 66, 48, 1.5 },
	{ 0.21053, 0.23867, 0.21468, 48, 66, 72, 1.5 },
	{ 0.21053, 0.23867, 0.23828, 48, 66, 96, 1.5 },
	{ 0.21053, 0.23867, 0.28848, 48, 66, 120, 1.5 },
	{ 0.21053, 0.23867, 0.35814, 48, 66, 144, 1.5 },
	{ 0.21053, 0.23867, 0.41502, 48, 66, 168, 1.5 },
	{ 0.21053, 0.23867, 0.42374, 48, 66, 180, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 0, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 24, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 48, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 72, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 96, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 120, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 144, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 168, 1.5 },
	{ 0.21053, 0.33533, 0.13859, 60, 0, 180, 1.5 },
	{ 0.21053, 0.33195, 0.13927, 60, 12, 0, 1.5 },
	{ 0.21053, 0.33195, 0.13926, 60, 12, 24, 1.5 },
	{ 0.21053, 0.33195, 0.13951, 60, 12, 48, 1.5 },
	{ 0.21053, 0.33195, 0.14057, 60, 12, 72, 1.5 },
	{ 0.21053, 0.33195, 0.1428, 60, 12, 96, 1.5 },
	{ 0.21053, 0.33195, 0.14594, 60, 12, 120, 1.5 },
	{ 0.21053, 0.33195, 0.14911, 60, 12, 144, 1.5 },
	{ 0.21053, 0.33195, 0.15113, 60, 12, 168, 1.5 },
	{ 0.21053, 0.33195, 0.15141, 60, 12, 180, 1.5 },
	{ 0.21053, 0.32132, 0.15186, 60, 24, 0, 1.5 },
	{ 0.21053, 0.32132, 0.1508, 60, 24, 24, 1.5 },
	{ 0.21053, 0.32132, 0.14919, 60, 24, 48, 1.5 },
	{ 0.21053, 0.32132, 0.14998, 60, 24, 72, 1.5 },
	{ 0.21053, 0.32132, 0.15505, 60, 24, 96, 1.5 },
	{ 0.21053, 0.32132, 0.16412, 60, 24, 120, 1.5 },
	{ 0.21053, 0.32132, 0.17446, 60, 24, 144, 1.5 },
	{ 0.21053, 0.32132, 0.18151, 60, 24, 168, 1.5 },
	{ 0.21053, 0.32132, 0.1825, 60, 24, 180, 1.5 },
	{ 0.21053, 0.30193, 0.17638, 60, 36, 0, 1.5 },
	{ 0.21053, 0.30193, 0.17309, 60, 36, 24, 1.5 },
	{ 0.21053, 0.30193, 0.16767, 60, 36, 48, 1.5 },
	{ 0.21053, 0.30193, 0.16777, 60, 36, 72, 1.5 },
	{ 0.21053, 0.30193, 0.17751, 60, 36, 96, 1.5 },
	{ 0.21053, 0.30193, 0.19715, 60, 36, 120, 1.5 },
	{ 0.21053, 0.30193, 0.22152, 60, 36, 144, 1.5 },
	{ 0.21053, 0.30193, 0.23925, 60, 36, 168, 1.5 },
	{ 0.21053, 0.30193, 0.24182, 60, 36, 180, 1.5 },
	{ 0.21053, 0.27132, 0.21441, 60, 48, 0, 1.5 },
	{ 0.21053, 0.27132, 0.20635, 60, 48, 24, 1.5 },
	{ 0.21053, 0.27132, 0.19594, 60, 48, 48, 1.5 },
	{ 0.21053, 0.27132, 0.19599, 60, 48, 72, 1.5 },
	{ 0.21053, 0.27132, 0.21367, 60, 48, 96, 1.5 },
	{ 0.21053, 0.27132, 0.25149, 60, 48, 120, 1.5 },
	{ 0.21053, 0.27132, 0.30231, 60, 48, 144, 1.5 },
	{ 0.21053, 0.27132, 0.34224, 60, 48, 168, 1.5 },
	{ 0.21053, 0.27132, 0.34824, 60, 48, 180, 1.5 },
	{ 0.21053, 0.22688, 0.27744, 60, 60, 0, 1.5 },
	{ 0.21053, 0.22688, 0.25098, 60, 60, 24, 1.5 },
	{ 0.21053, 0.22688, 0.23563, 60, 60, 48, 1.5 },
	{ 0.21053, 0.22688, 0.23709, 60, 60, 72, 1.5 },
	{ 0.21053, 0.22688, 0.26753, 60, 60, 96, 1.5 },
	{ 0.21053, 0.22688, 0.33554, 60, 60, 120, 1.5 },
	{ 0.21053, 0.22688, 0.43558, 60, 60, 144, 1.5 },
	{ 0.21053, 0.22688, 0.52244, 60, 60, 168, 1.5 },
	{ 0.21053, 0.22688, 0.53623, 60, 60, 180, 1.5 },
	{ 0.21053, 0.19958, 0.30034, 60, 66, 0, 1.5 },
	{ 0.21053, 0.19958, 0.27763, 60, 66, 24, 1.5 },
	{ 0.21053, 0.19958, 0.25997, 60, 66, 48, 1.5 },
	{ 0.21053, 0.19958, 0.26263, 60, 66, 72, 1.5 },
	{ 0.21053, 0.19958, 0.30142, 60, 66, 96, 1.5 },
	{ 0.21053, 0.19958, 0.39058, 60, 66, 120, 1.5 },
	{ 0.21053, 0.19958, 0.52874, 60, 66, 144, 1.5 },
	{ 0.21053, 0.19958, 0.65657, 60, 66, 168, 1.5 },
	{ 0.21053, 0.19958, 0.67749, 60, 66, 180, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 0, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 24, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 48, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 72, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 96, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 120, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 144, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 168, 1.5 },
	{ 0.21053, 0.25186, 0.16454, 72, 0, 180, 1.5 },
	{ 0.21053, 0.24932, 0.16047, 72, 12, 0, 1.5 },
	{ 0.21053, 0.24932, 0.16086, 72, 12, 24, 1.5 },
	{ 0.21053, 0.24932, 0.16232, 72, 12, 48, 1.5 },
	{ 0.21053, 0.24932, 0.16545, 72, 12, 72, 1.5 },
	{ 0.21053, 0.24932, 0.17052, 72, 12, 96, 1.5 },
	{ 0.21053, 0.24932, 0.17698, 72, 12, 120, 1.5 },
	{ 0.21053, 0.24932, 0.18321, 72, 12, 144, 1.5 },
	{ 0.21053, 0.24932, 0.18712, 72, 12, 168, 1.5 },
	{ 0.21053, 0.24932, 0.18765, 72, 12, 180, 1.5 },
	{ 0.21053, 0.24134, 0.17223, 72, 24, 0, 1.5 },
	{ 0.21053, 0.24134, 0.17178, 72, 24, 24, 1.5 },
	{ 0.21053, 0.24134, 0.172, 72, 24, 48, 1.5 },
	{ 0.21053, 0.24134, 0.17616, 72, 24, 72, 1.5 },
	{ 0.21053, 0.24134, 0.18685, 72, 24, 96, 1.5 },
	{ 0.21053, 0.24134, 0.20397, 72, 24, 120, 1.5 },
	{ 0.21053, 0.24134, 0.22326, 72, 24, 144, 1.5 },
	{ 0.21053, 0.24134, 0.23654, 72, 24, 168, 1.5 },
	{ 0.21053, 0.24134, 0.23842, 72, 24, 180, 1.5 },
	{ 0.21053, 0.22678, 0.20042, 72, 36, 0, 1.5 },
	{ 0.21053, 0.22678, 0.19765, 72, 36, 24, 1.5 },
	{ 0.21053, 0.22678, 0.19404, 72, 36, 48, 1.5 },
	{ 0.21053, 0.22678, 0.19809, 72, 36, 72, 1.5 },
	{ 0.21053, 0.22678, 0.21645, 72, 36, 96, 1.5 },
	{ 0.21053, 0.22678, 0.25142, 72, 36, 120, 1.5 },
	{ 0.21053, 0.22678, 0.29614, 72, 36, 144, 1.5 },
	{ 0.21053, 0.22678, 0.33014, 72, 36, 168, 1.5 },
	{ 0.21053, 0.22678, 0.33517, 72, 36, 180, 1.5 },
	{ 0.21053, 0.20378, 0.24832, 72, 48, 0, 1.5 },
	{ 0.21053, 0.20378, 0.24129, 72, 48, 24, 1.5 },
	{ 0.21053, 0.20378, 0.23095, 72, 48, 48, 1.5 },
	{ 0.21053, 0.20378, 0.23455, 72, 48, 72, 1.5 },
	{ 0.21053, 0.20378, 0.26454, 72, 48, 96, 1.5 },
	{ 0.21053, 0.20378, 0.32935, 72, 48, 120, 1.5 },
	{ 0.21053, 0.20378, 0.42309, 72, 48, 144, 1.5 },
	{ 0.21053, 0.20378, 0.50329, 72, 48, 168, 1.5 },
	{ 0.21053, 0.20378, 0.51588, 72, 48, 180, 1.5 },
	{ 0.21053, 0.17041, 0.32305, 72, 60, 0, 1.5 },
	{ 0.21053, 0.17041, 0.30758, 72, 60, 24, 1.5 },
	{ 0.21053, 0.17041, 0.28752, 72, 60, 48, 1.5 },
	{ 0.21053, 0.17041, 0.29092, 72, 60, 72, 1.5 },
	{ 0.21053, 0.17041, 0.33891, 72, 60, 96, 1.5 },
	{ 0.21053, 0.17041, 0.45334, 72, 60, 120, 1.5 },
	{ 0.21053, 0.17041, 0.64182, 72, 60, 144, 1.5 },
	{ 0.21053, 0.17041, 0.82923, 72, 60, 168, 1.5 },
	{ 0.21053, 0.17041, 0.8614, 72, 60, 180, 1.5 },
	{ 0.21053, 0.1499, 0.38247, 72, 66, 0, 1.5 },
	{ 0.21053, 0.1499, 0.35175, 72, 66, 24, 1.5 },
	{ 0.21053, 0.1499, 0.32542, 72, 66, 48, 1.5 },
	{ 0.21053, 0.1499, 0.32867, 72, 66, 72, 1.5 },
	{ 0.21053, 0.1499, 0.38869, 72, 66, 96, 1.5 },
	{ 0.21053, 0.1499, 0.53868, 72, 66, 120, 1.5 },
	{ 0.21053, 0.1499, 0.8036, 72, 66, 144, 1.5 },
	{ 0.21053, 0.1499, 1.09235, 72, 66, 168, 1.5 },
	{ 0.21053, 0.1499, 1.14502, 72, 66, 180, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 0, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 24, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 48, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 72, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 96, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 120, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 144, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 168, 1.5 },
	{ 0.21053, 0.17307, 0.18788, 84, 0, 180, 1.5 },
	{ 0.21053, 0.17133, 0.18137, 84, 12, 0, 1.5 },
	{ 0.21053, 0.17133, 0.18189, 84, 12, 24, 1.5 },
	{ 0.21053, 0.17133, 0.18386, 84, 12, 48, 1.5 },
	{ 0.21053, 0.17133, 0.18813, 84, 12, 72, 1.5 },
	{ 0.21053, 0.17133, 0.19524, 84, 12, 96, 1.5 },
	{ 0.21053, 0.17133, 0.20453, 84, 12, 120, 1.5 },
	{ 0.21053, 0.17133, 0.21372, 84, 12, 144, 1.5 },
	{ 0.21053, 0.17133, 0.21956, 84, 12, 168, 1.5 },
	{ 0.21053, 0.17133, 0.22037, 84, 12, 180, 1.5 },
	{ 0.21053, 0.16584, 0.19608, 84, 24, 0, 1.5 },
	{ 0.21053, 0.16584, 0.19544, 84, 24, 24, 1.5 },
	{ 0.21053, 0.16584, 0.19545, 84, 24, 48, 1.5 },
	{ 0.21053, 0.16584, 0.20052, 84, 24, 72, 1.5 },
	{ 0.21053, 0.16584, 0.21488, 84, 24, 96, 1.5 },
	{ 0.21053, 0.16584, 0.23941, 84, 24, 120, 1.5 },
	{ 0.21053, 0.16584, 0.26854, 84, 24, 144, 1.5 },
	{ 0.21053, 0.16584, 0.28942, 84, 24, 168, 1.5 },
	{ 0.21053, 0.16584, 0.29243, 84, 24, 180, 1.5 },
	{ 0.21053, 0.15584, 0.23323, 84, 36, 0, 1.5 },
	{ 0.21053, 0.15584, 0.22974, 84, 36, 24, 1.5 },
	{ 0.21053, 0.15584, 0.22423, 84, 36, 48, 1.5 },
	{ 0.21053, 0.15584, 0.22763, 84, 36, 72, 1.5 },
	{ 0.21053, 0.15584, 0.25097, 84, 36, 96, 1.5 },
	{ 0.21053, 0.15584, 0.30062, 84, 36, 120, 1.5 },
	{ 0.21053, 0.15584, 0.36994, 84, 36, 144, 1.5 },
	{ 0.21053, 0.15584, 0.4268, 84, 36, 168, 1.5 },
	{ 0.21053, 0.15584, 0.43553, 84, 36, 180, 1.5 },
	{ 0.21053, 0.14003, 0.30078, 84, 48, 0, 1.5 },
	{ 0.21053, 0.14003, 0.2918, 84, 48, 24, 1.5 },
	{ 0.21053, 0.14003, 0.27624, 84, 48, 48, 1.5 },
	{ 0.21053, 0.14003, 0.27585, 84, 48, 72, 1.5 },
	{ 0.21053, 0.14003, 0.31214, 84, 48, 96, 1.5 },
	{ 0.21053, 0.14003, 0.4038, 84, 48, 120, 1.5 },
	{ 0.21053, 0.14003, 0.55381, 84, 48, 144, 1.5 },
	{ 0.21053, 0.14003, 0.69926, 84, 48, 168, 1.5 },
	{ 0.21053, 0.14003, 0.7238, 84, 48, 180, 1.5 },
	{ 0.21053, 0.1171, 0.41829, 84, 60, 0, 1.5 },
	{ 0.21053, 0.1171, 0.39918, 84, 60, 24, 1.5 },
	{ 0.21053, 0.1171, 0.36601, 84, 60, 48, 1.5 },
	{ 0.21053, 0.1171, 0.3591, 84, 60, 72, 1.5 },
	{ 0.21053, 0.1171, 0.4161, 84, 60, 96, 1.5 },
	{ 0.21053, 0.1171, 0.58032, 84, 60, 120, 1.5 },
	{ 0.21053, 0.1171, 0.89525, 84, 60, 144, 1.5 },
	{ 0.21053, 0.1171, 1.27416, 84, 60, 168, 1.5 },
	{ 0.21053, 0.1171, 1.34763, 84, 60, 180, 1.5 },
	{ 0.21053, 0.10301, 0.50911, 84, 66, 0, 1.5 },
	{ 0.21053, 0.10301, 0.4821, 84, 66, 24, 1.5 },
	{ 0.21053, 0.10301, 0.43514, 84, 66, 48, 1.5 },
	{ 0.21053, 0.10301, 0.42297, 84, 66, 72, 1.5 },
	{ 0.21053, 0.10301, 0.49523, 84, 66, 96, 1.5 },
	{ 0.21053, 0.10301, 0.71566, 84, 66, 120, 1.5 },
	{ 0.21053, 0.10301, 1.17234, 84, 66, 144, 1.5 },
	{ 0.21053, 0.10301, 1.79649, 84, 66, 168, 1.5 },
	{ 0.21053, 0.10301, 1.93041, 84, 66, 180, 1.5 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 0, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 24, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 48, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 72, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 96, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 120, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 144, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 168, 1.95 },
	{ 0.23066, 0.39704, 0.12496, 0, 0, 180, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 0, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 24, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 48, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 72, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 96, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 120, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 144, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 168, 1.95 },
	{ 0.23066, 0.39204, 0.11819, 0, 12, 180, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 0, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 24, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 48, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 72, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 96, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 120, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 144, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 168, 1.95 },
	{ 0.23066, 0.37654, 0.11984, 0, 24, 180, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 0, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 24, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 48, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 72, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 96, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 120, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 144, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 168, 1.95 },
	{ 0.23066, 0.34906, 0.1266, 0, 36, 180, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 0, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 24, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 48, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 72, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 96, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 120, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 144, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 168, 1.95 },
	{ 0.23066, 0.30769, 0.13962, 0, 48, 180, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 0, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 24, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 48, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 72, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 96, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 120, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 144, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 168, 1.95 },
	{ 0.23066, 0.25203, 0.15891, 0, 60, 180, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 0, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 24, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 48, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 72, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 96, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 120, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 144, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 168, 1.95 },
	{ 0.23066, 0.22035, 0.16966, 0, 66, 180, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 0, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 24, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 48, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 72, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 96, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 120, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 144, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 168, 1.95 },
	{ 0.23066, 0.39204, 0.1182, 12, 0, 180, 1.95 },
	{ 0.23066, 0.38711, 0.12905, 12, 12, 0, 1.95 },
	{ 0.23066, 0.38711, 0.12659, 12, 12, 24, 1.95 },
	{ 0.23066, 0.38711, 0.12184, 12, 12, 48, 1.95 },
	{ 0.23066, 0.38711, 0.11905, 12, 12, 72, 1.95 },
	{ 0.23066, 0.38711, 0.1178, 12, 12, 96, 1.95 },
	{ 0.23066, 0.38711, 0.11699, 12, 12, 120, 1.95 },
	{ 0.23066, 0.38711, 0.11643, 12, 12, 144, 1.95 },
	{ 0.23066, 0.38711, 0.11618, 12, 12, 168, 1.95 },
	{ 0.23066, 0.38711, 0.11614, 12, 12, 180, 1.95 },
	{ 0.23066, 0.3718, 0.1264, 12, 24, 0, 1.95 },
	{ 0.23066, 0.3718, 0.12532, 12, 24, 24, 1.95 },
	{ 0.23066, 0.3718, 0.12374, 12, 24, 48, 1.95 },
	{ 0.23066, 0.3718, 0.12223, 12, 24, 72, 1.95 },
	{ 0.23066, 0.3718, 0.12086, 12, 24, 96, 1.95 },
	{ 0.23066, 0.3718, 0.11986, 12, 24, 120, 1.95 },
	{ 0.23066, 0.3718, 0.1193, 12, 24, 144, 1.95 },
	{ 0.23066, 0.3718, 0.11907, 12, 24, 168, 1.95 },
	{ 0.23066, 0.3718, 0.11904, 12, 24, 180, 1.95 },
	{ 0.23066, 0.34467, 0.13261, 12, 36, 0, 1.95 },
	{ 0.23066, 0.34467, 0.13211, 12, 36, 24, 1.95 },
	{ 0.23066, 0.34467, 0.13085, 12, 36, 48, 1.95 },
	{ 0.23066, 0.34467, 0.12947, 12, 36, 72, 1.95 },
	{ 0.23066, 0.34467, 0.12851, 12, 36, 96, 1.95 },
	{ 0.23066, 0.34467, 0.12816, 12, 36, 120, 1.95 },
	{ 0.23066, 0.34467, 0.12824, 12, 36, 144, 1.95 },
	{ 0.23066, 0.34467, 0.1284, 12, 36, 168, 1.95 },
	{ 0.23066, 0.34467, 0.12842, 12, 36, 180, 1.95 },
	{ 0.23066, 0.30382, 0.1435, 12, 48, 0, 1.95 },
	{ 0.23066, 0.30382, 0.14319, 12, 48, 24, 1.95 },
	{ 0.23066, 0.30382, 0.14257, 12, 48, 48, 1.95 },
	{ 0.23066, 0.30382, 0.14228, 12, 48, 72, 1.95 },
	{ 0.23066, 0.30382, 0.14277, 12, 48, 96, 1.95 },
	{ 0.23066, 0.30382, 0.14397, 12, 48, 120, 1.95 },
	{ 0.23066, 0.30382, 0.14539, 12, 48, 144, 1.95 },
	{ 0.23066, 0.30382, 0.14634, 12, 48, 168, 1.95 },
	{ 0.23066, 0.30382, 0.14647, 12, 48, 180, 1.95 },
	{ 0.23066, 0.24886, 0.159, 12, 60, 0, 1.95 },
	{ 0.23066, 0.24886, 0.15905, 12, 60, 24, 1.95 },
	{ 0.23066, 0.24886, 0.1595, 12, 60, 48, 1.95 },
	{ 0.23066, 0.24886, 0.1609, 12, 60, 72, 1.95 },
	{ 0.23066, 0.24886, 0.16355, 12, 60, 96, 1.95 },
	{ 0.23066, 0.24886, 0.16713, 12, 60, 120, 1.95 },
	{ 0.23066, 0.24886, 0.17068, 12, 60, 144, 1.95 },
	{ 0.23066, 0.24886, 0.17292, 12, 60, 168, 1.95 },
	{ 0.23066, 0.24886, 0.17322, 12, 60, 180, 1.95 },
	{ 0.23066, 0.21758, 0.16742, 12, 66, 0, 1.95 },
	{ 0.23066, 0.21758, 0.16768, 12, 66, 24, 1.95 },
	{ 0.23066, 0.21758, 0.16875, 12, 66, 48, 1.95 },
	{ 0.23066, 0.21758, 0.17114, 12, 66, 72, 1.95 },
	{ 0.23066, 0.21758, 0.17514, 12, 66, 96, 1.95 },
	{ 0.23066, 0.21758, 0.18027, 12, 66, 120, 1.95 },
	{ 0.23066, 0.21758, 0.18521, 12, 66, 144, 1.95 },
	{ 0.23066, 0.21758, 0.18831, 12, 66, 168, 1.95 },
	{ 0.23066, 0.21758, 0.18873, 12, 66, 180, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 0, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 24, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 48, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 72, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 96, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 120, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 144, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 168, 1.95 },
	{ 0.23066, 0.37654, 0.11985, 24, 0, 180, 1.95 },
	{ 0.23066, 0.3718, 0.12641, 24, 12, 0, 1.95 },
	{ 0.23066, 0.3718, 0.12533, 24, 12, 24, 1.95 },
	{ 0.23066, 0.3718, 0.12375, 24, 12, 48, 1.95 },
	{ 0.23066, 0.3718, 0.12223, 24, 12, 72, 1.95 },
	{ 0.23066, 0.3718, 0.12086, 24, 12, 96, 1.95 },
	{ 0.23066, 0.3718, 0.11986, 24, 12, 120, 1.95 },
	{ 0.23066, 0.3718, 0.1193, 24, 12, 144, 1.95 },
	{ 0.23066, 0.3718, 0.11906, 24, 12, 168, 1.95 },
	{ 0.23066, 0.3718, 0.11904, 24, 12, 180, 1.95 },
	{ 0.23066, 0.3571, 0.14325, 24, 24, 0, 1.95 },
	{ 0.23066, 0.3571, 0.13536, 24, 24, 24, 1.95 },
	{ 0.23066, 0.3571, 0.13032, 24, 24, 48, 1.95 },
	{ 0.23066, 0.3571, 0.12746, 24, 24, 72, 1.95 },
	{ 0.23066, 0.3571, 0.12542, 24, 24, 96, 1.95 },
	{ 0.23066, 0.3571, 0.1246, 24, 24, 120, 1.95 },
	{ 0.23066, 0.3571, 0.12463, 24, 24, 144, 1.95 },
	{ 0.23066, 0.3571, 0.12489, 24, 24, 168, 1.95 },
	{ 0.23066, 0.3571, 0.12495, 24, 24, 180, 1.95 },
	{ 0.23066, 0.33104, 0.14547, 24, 36, 0, 1.95 },
	{ 0.23066, 0.33104, 0.14291, 24, 36, 24, 1.95 },
	{ 0.23066, 0.33104, 0.13949, 24, 36, 48, 1.95 },
	{ 0.23066, 0.33104, 0.13648, 24, 36, 72, 1.95 },
	{ 0.23066, 0.33104, 0.13544, 24, 36, 96, 1.95 },
	{ 0.23066, 0.33104, 0.13639, 24, 36, 120, 1.95 },
	{ 0.23066, 0.33104, 0.13829, 24, 36, 144, 1.95 },
	{ 0.23066, 0.33104, 0.13977, 24, 36, 168, 1.95 },
	{ 0.23066, 0.33104, 0.13998, 24, 36, 180, 1.95 },
	{ 0.23066, 0.2918, 0.1567, 24, 48, 0, 1.95 },
	{ 0.23066, 0.2918, 0.15524, 24, 48, 24, 1.95 },
	{ 0.23066, 0.2918, 0.15233, 24, 48, 48, 1.95 },
	{ 0.23066, 0.2918, 0.1509, 24, 48, 72, 1.95 },
	{ 0.23066, 0.2918, 0.15258, 24, 48, 96, 1.95 },
	{ 0.23066, 0.2918, 0.15703, 24, 48, 120, 1.95 },
	{ 0.23066, 0.2918, 0.16244, 24, 48, 144, 1.95 },
	{ 0.23066, 0.2918, 0.16616, 24, 48, 168, 1.95 },
	{ 0.23066, 0.2918, 0.16668, 24, 48, 180, 1.95 },
	{ 0.23066, 0.23902, 0.17169, 24, 60, 0, 1.95 },
	{ 0.23066, 0.23902, 0.17073, 24, 60, 24, 1.95 },
	{ 0.23066, 0.23902, 0.16947, 24, 60, 48, 1.95 },
	{ 0.23066, 0.23902, 0.17089, 24, 60, 72, 1.95 },
	{ 0.23066, 0.23902, 0.17682, 24, 60, 96, 1.95 },
	{ 0.23066, 0.23902, 0.18688, 24, 60, 120, 1.95 },
	{ 0.23066, 0.23902, 0.19812, 24, 60, 144, 1.95 },
	{ 0.23066, 0.23902, 0.20572, 24, 60, 168, 1.95 },
	{ 0.23066, 0.23902, 0.20678, 24, 60, 180, 1.95 },
	{ 0.23066, 0.20897, 0.17953, 24, 66, 0, 1.95 },
	{ 0.23066, 0.20897, 0.17892, 24, 66, 24, 1.95 },
	{ 0.23066, 0.20897, 0.17863, 24, 66, 48, 1.95 },
	{ 0.23066, 0.20897, 0.18174, 24, 66, 72, 1.95 },
	{ 0.23066, 0.20897, 0.19034, 24, 66, 96, 1.95 },
	{ 0.23066, 0.20897, 0.2041, 24, 66, 120, 1.95 },
	{ 0.23066, 0.20897, 0.21935, 24, 66, 144, 1.95 },
	{ 0.23066, 0.20897, 0.22971, 24, 66, 168, 1.95 },
	{ 0.23066, 0.20897, 0.23116, 24, 66, 180, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 0, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 24, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 48, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 72, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 96, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 120, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 144, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 168, 1.95 },
	{ 0.23066, 0.34906, 0.12662, 36, 0, 180, 1.95 },
	{ 0.23066, 0.34467, 0.13264, 36, 12, 0, 1.95 },
	{ 0.23066, 0.34467, 0.13213, 36, 12, 24, 1.95 },
	{ 0.23066, 0.34467, 0.13088, 36, 12, 48, 1.95 },
	{ 0.23066, 0.34467, 0.12949, 36, 12, 72, 1.95 },
	{ 0.23066, 0.34467, 0.12853, 36, 12, 96, 1.95 },
	{ 0.23066, 0.34467, 0.12818, 36, 12, 120, 1.95 },
	{ 0.23066, 0.34467, 0.12824, 36, 12, 144, 1.95 },
	{ 0.23066, 0.34467, 0.1284, 36, 12, 168, 1.95 },
	{ 0.23066, 0.34467, 0.12843, 36, 12, 180, 1.95 },
	{ 0.23066, 0.33104, 0.14549, 36, 24, 0, 1.95 },
	{ 0.23066, 0.33104, 0.14293, 36, 24, 24, 1.95 },
	{ 0.23066, 0.33104, 0.13951, 36, 24, 48, 1.95 },
	{ 0.23066, 0.33104, 0.1365, 36, 24, 72, 1.95 },
	{ 0.23066, 0.33104, 0.13545, 36, 24, 96, 1.95 },
	{ 0.23066, 0.33104, 0.13639, 36, 24, 120, 1.95 },
	{ 0.23066, 0.33104, 0.13829, 36, 24, 144, 1.95 },
	{ 0.23066, 0.33104, 0.13976, 36, 24, 168, 1.95 },
	{ 0.23066, 0.33104, 0.13998, 36, 24, 180, 1.95 },
	{ 0.23066, 0.30687, 0.17028, 36, 36, 0, 1.95 },
	{ 0.23066, 0.30687, 0.1576, 36, 36, 24, 1.95 },
	{ 0.23066, 0.30687, 0.15186, 36, 36, 48, 1.95 },
	{ 0.23066, 0.30687, 0.14827, 36, 36, 72, 1.95 },
	{ 0.23066, 0.30687, 0.14894, 36, 36, 96, 1.95 },
	{ 0.23066, 0.30687, 0.15338, 36, 36, 120, 1.95 },
	{ 0.23066, 0.30687, 0.1593, 36, 36, 144, 1.95 },
	{ 0.23066, 0.30687, 0.16357, 36, 36, 168, 1.95 },
	{ 0.23066, 0.30687, 0.16417, 36, 36, 180, 1.95 },
	{ 0.23066, 0.27051, 0.17877, 36, 48, 0, 1.95 },
	{ 0.23066, 0.27051, 0.17423, 36, 48, 24, 1.95 },
	{ 0.23066, 0.27051, 0.16819, 36, 48, 48, 1.95 },
	{ 0.23066, 0.27051, 0.16595, 36, 48, 72, 1.95 },
	{ 0.23066, 0.27051, 0.17061, 36, 48, 96, 1.95 },
	{ 0.23066, 0.27051, 0.18148, 36, 48, 120, 1.95 },
	{ 0.23066, 0.27051, 0.19478, 36, 48, 144, 1.95 },
	{ 0.23066, 0.27051, 0.20419, 36, 48, 168, 1.95 },
	{ 0.23066, 0.27051, 0.20554, 36, 48, 180, 1.95 },
	{ 0.23066, 0.22157, 0.19667, 36, 60, 0, 1.95 },
	{ 0.23066, 0.22157, 0.19349, 36, 60, 24, 1.95 },
	{ 0.23066, 0.22157, 0.18853, 36, 60, 48, 1.95 },
	{ 0.23066, 0.22157, 0.18956, 36, 60, 72, 1.95 },
	{ 0.23066, 0.22157, 0.20066, 36, 60, 96, 1.95 },
	{ 0.23066, 0.22157, 0.22197, 36, 60, 120, 1.95 },
	{ 0.23066, 0.22157, 0.24795, 36, 60, 144, 1.95 },
	{ 0.23066, 0.22157, 0.2667, 36, 60, 168, 1.95 },
	{ 0.23066, 0.22157, 0.26941, 36, 60, 180, 1.95 },
	{ 0.23066, 0.19372, 0.20613, 36, 66, 0, 1.95 },
	{ 0.23066, 0.19372, 0.20322, 36, 66, 24, 1.95 },
	{ 0.23066, 0.19372, 0.19927, 36, 66, 48, 1.95 },
	{ 0.23066, 0.19372, 0.20232, 36, 66, 72, 1.95 },
	{ 0.23066, 0.19372, 0.21753, 36, 66, 96, 1.95 },
	{ 0.23066, 0.19372, 0.24583, 36, 66, 120, 1.95 },
	{ 0.23066, 0.19372, 0.28083, 36, 66, 144, 1.95 },
	{ 0.23066, 0.19372, 0.30664, 36, 66, 168, 1.95 },
	{ 0.23066, 0.19372, 0.31039, 36, 66, 180, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 0, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 24, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 48, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 72, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 96, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 120, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 144, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 168, 1.95 },
	{ 0.23066, 0.30769, 0.13967, 48, 0, 180, 1.95 },
	{ 0.23066, 0.30382, 0.14356, 48, 12, 0, 1.95 },
	{ 0.23066, 0.30382, 0.14325, 48, 12, 24, 1.95 },
	{ 0.23066, 0.30382, 0.14263, 48, 12, 48, 1.95 },
	{ 0.23066, 0.30382, 0.14234, 48, 12, 72, 1.95 },
	{ 0.23066, 0.30382, 0.14281, 48, 12, 96, 1.95 },
	{ 0.23066, 0.30382, 0.14401, 48, 12, 120, 1.95 },
	{ 0.23066, 0.30382, 0.14542, 48, 12, 144, 1.95 },
	{ 0.23066, 0.30382, 0.14638, 48, 12, 168, 1.95 },
	{ 0.23066, 0.30382, 0.14651, 48, 12, 180, 1.95 },
	{ 0.23066, 0.2918, 0.15676, 48, 24, 0, 1.95 },
	{ 0.23066, 0.2918, 0.15529, 48, 24, 24, 1.95 },
	{ 0.23066, 0.2918, 0.15238, 48, 24, 48, 1.95 },
	{ 0.23066, 0.2918, 0.15095, 48, 24, 72, 1.95 },
	{ 0.23066, 0.2918, 0.15262, 48, 24, 96, 1.95 },
	{ 0.23066, 0.2918, 0.15707, 48, 24, 120, 1.95 },
	{ 0.23066, 0.2918, 0.16247, 48, 24, 144, 1.95 },
	{ 0.23066, 0.2918, 0.1662, 48, 24, 168, 1.95 },
	{ 0.23066, 0.2918, 0.16672, 48, 24, 180, 1.95 },
	{ 0.23066, 0.27051, 0.17882, 48, 36, 0, 1.95 },
	{ 0.23066, 0.27051, 0.17427, 48, 36, 24, 1.95 },
	{ 0.23066, 0.27051, 0.16823, 48, 36, 48, 1.95 },
	{ 0.23066, 0.27051, 0.16599, 48, 36, 72, 1.95 },
	{ 0.23066, 0.27051, 0.17065, 48, 36, 96, 1.95 },
	{ 0.23066, 0.27051, 0.18151, 48, 36, 120, 1.95 },
	{ 0.23066, 0.27051, 0.19482, 48, 36, 144, 1.95 },
	{ 0.23066, 0.27051, 0.20423, 48, 36, 168, 1.95 },
	{ 0.23066, 0.27051, 0.20558, 48, 36, 180, 1.95 },
	{ 0.23066, 0.23845, 0.21648, 48, 48, 0, 1.95 },
	{ 0.23066, 0.23845, 0.19868, 48, 48, 24, 1.95 },
	{ 0.23066, 0.23845, 0.18995, 48, 48, 48, 1.95 },
	{ 0.23066, 0.23845, 0.18842, 48, 48, 72, 1.95 },
	{ 0.23066, 0.23845, 0.19881, 48, 48, 96, 1.95 },
	{ 0.23066, 0.23845, 0.22086, 48, 48, 120, 1.95 },
	{ 0.23066, 0.23845, 0.24862, 48, 48, 144, 1.95 },
	{ 0.23066, 0.23845, 0.26907, 48, 48, 168, 1.95 },
	{ 0.23066, 0.23845, 0.27207, 48, 48, 180, 1.95 },
	{ 0.23066, 0.19531, 0.23476, 48, 60, 0, 1.95 },
	{ 0.23066, 0.19531, 0.22682, 48, 60, 24, 1.95 },
	{ 0.23066, 0.19531, 0.217, 48, 60, 48, 1.95 },
	{ 0.23066, 0.19531, 0.21829, 48, 60, 72, 1.95 },
	{ 0.23066, 0.19531, 0.23787, 48, 60, 96, 1.95 },
	{ 0.23066, 0.19531, 0.27807, 48, 60, 120, 1.95 },
	{ 0.23066, 0.19531, 0.33137, 48, 60, 144, 1.95 },
	{ 0.23066, 0.19531, 0.37298, 48, 60, 168, 1.95 },
	{ 0.23066, 0.19531, 0.37923, 48, 60, 180, 1.95 },
	{ 0.23066, 0.17076, 0.24797, 48, 66, 0, 1.95 },
	{ 0.23066, 0.17076, 0.24134, 48, 66, 24, 1.95 },
	{ 0.23066, 0.17076, 0.23164, 48, 66, 48, 1.95 },
	{ 0.23066, 0.17076, 0.23481, 48, 66, 72, 1.95 },
	{ 0.23066, 0.17076, 0.26027, 48, 66, 96, 1.95 },
	{ 0.23066, 0.17076, 0.31278, 48, 66, 120, 1.95 },
	{ 0.23066, 0.17076, 0.38487, 48, 66, 144, 1.95 },
	{ 0.23066, 0.17076, 0.44346, 48, 66, 168, 1.95 },
	{ 0.23066, 0.17076, 0.45243, 48, 66, 180, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 0, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 24, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 48, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 72, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 96, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 120, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 144, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 168, 1.95 },
	{ 0.23066, 0.25203, 0.15906, 60, 0, 180, 1.95 },
	{ 0.23066, 0.24886, 0.15915, 60, 12, 0, 1.95 },
	{ 0.23066, 0.24886, 0.1592, 60, 12, 24, 1.95 },
	{ 0.23066, 0.24886, 0.15966, 60, 12, 48, 1.95 },
	{ 0.23066, 0.24886, 0.16104, 60, 12, 72, 1.95 },
	{ 0.23066, 0.24886, 0.16369, 60, 12, 96, 1.95 },
	{ 0.23066, 0.24886, 0.16728, 60, 12, 120, 1.95 },
	{ 0.23066, 0.24886, 0.17082, 60, 12, 144, 1.95 },
	{ 0.23066, 0.24886, 0.17306, 60, 12, 168, 1.95 },
	{ 0.23066, 0.24886, 0.17336, 60, 12, 180, 1.95 },
	{ 0.23066, 0.23902, 0.17186, 60, 24, 0, 1.95 },
	{ 0.23066, 0.23902, 0.1709, 60, 24, 24, 1.95 },
	{ 0.23066, 0.23902, 0.16963, 60, 24, 48, 1.95 },
	{ 0.23066, 0.23902, 0.17104, 60, 24, 72, 1.95 },
	{ 0.23066, 0.23902, 0.17697, 60, 24, 96, 1.95 },
	{ 0.23066, 0.23902, 0.18704, 60, 24, 120, 1.95 },
	{ 0.23066, 0.23902, 0.19827, 60, 24, 144, 1.95 },
	{ 0.23066, 0.23902, 0.20588, 60, 24, 168, 1.95 },
	{ 0.23066, 0.23902, 0.20694, 60, 24, 180, 1.95 },
	{ 0.23066, 0.22157, 0.19683, 60, 36, 0, 1.95 },
	{ 0.23066, 0.22157, 0.19366, 60, 36, 24, 1.95 },
	{ 0.23066, 0.22157, 0.18869, 60, 36, 48, 1.95 },
	{ 0.23066, 0.22157, 0.18971, 60, 36, 72, 1.95 },
	{ 0.23066, 0.22157, 0.20082, 60, 36, 96, 1.95 },
	{ 0.23066, 0.22157, 0.22213, 60, 36, 120, 1.95 },
	{ 0.23066, 0.22157, 0.24813, 60, 36, 144, 1.95 },
	{ 0.23066, 0.22157, 0.26689, 60, 36, 168, 1.95 },
	{ 0.23066, 0.22157, 0.2696, 60, 36, 180, 1.95 },
	{ 0.23066, 0.19531, 0.2349, 60, 48, 0, 1.95 },
	{ 0.23066, 0.19531, 0.22697, 60, 48, 24, 1.95 },
	{ 0.23066, 0.19531, 0.21714, 60, 48, 48, 1.95 },
	{ 0.23066, 0.19531, 0.21841, 60, 48, 72, 1.95 },
	{ 0.23066, 0.19531, 0.23801, 60, 48, 96, 1.95 },
	{ 0.23066, 0.19531, 0.27823, 60, 48, 120, 1.95 },
	{ 0.23066, 0.19531, 0.33154, 60, 48, 144, 1.95 },
	{ 0.23066, 0.19531, 0.37318, 60, 48, 168, 1.95 },
	{ 0.23066, 0.19531, 0.37942, 60, 48, 180, 1.95 },
	{ 0.23066, 0.15998, 0.29619, 60, 60, 0, 1.95 },
	{ 0.23066, 0.15998, 0.26971, 60, 60, 24, 1.95 },
	{ 0.23066, 0.15998, 0.25509, 60, 60, 48, 1.95 },
	{ 0.23066, 0.15998, 0.25811, 60, 60, 72, 1.95 },
	{ 0.23066, 0.15998, 0.29077, 60, 60, 96, 1.95 },
	{ 0.23066, 0.15998, 0.3617, 60, 60, 120, 1.95 },
	{ 0.23066, 0.15998, 0.46494, 60, 60, 144, 1.95 },
	{ 0.23066, 0.15998, 0.55421, 60, 60, 168, 1.95 },
	{ 0.23066, 0.15998, 0.56833, 60, 60, 180, 1.95 },
	{ 0.23066, 0.13987, 0.31645, 60, 66, 0, 1.95 },
	{ 0.23066, 0.13987, 0.294, 60, 66, 24, 1.95 },
	{ 0.23066, 0.13987, 0.27716, 60, 66, 48, 1.95 },
	{ 0.23066, 0.13987, 0.28135, 60, 66, 72, 1.95 },
	{ 0.23066, 0.13987, 0.32252, 60, 66, 96, 1.95 },
	{ 0.23066, 0.13987, 0.41447, 60, 66, 120, 1.95 },
	{ 0.23066, 0.13987, 0.55597, 60, 66, 144, 1.95 },
	{ 0.23066, 0.13987, 0.6865, 60, 66, 168, 1.95 },
	{ 0.23066, 0.13987, 0.70782, 60, 66, 180, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 0, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 24, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 48, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 72, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 96, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 120, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 144, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 168, 1.95 },
	{ 0.23066, 0.18838, 0.18005, 72, 0, 180, 1.95 },
	{ 0.23066, 0.18601, 0.17539, 72, 12, 0, 1.95 },
	{ 0.23066, 0.18601, 0.17586, 72, 12, 24, 1.95 },
	{ 0.23066, 0.18601, 0.17751, 72, 12, 48, 1.95 },
	{ 0.23066, 0.18601, 0.18094, 72, 12, 72, 1.95 },
	{ 0.23066, 0.18601, 0.18638, 72, 12, 96, 1.95 },
	{ 0.23066, 0.18601, 0.19322, 72, 12, 120, 1.95 },
	{ 0.23066, 0.18601, 0.19976, 72, 12, 144, 1.95 },
	{ 0.23066, 0.18601, 0.20386, 72, 12, 168, 1.95 },
	{ 0.23066, 0.18601, 0.20441, 72, 12, 180, 1.95 },
	{ 0.23066, 0.17866, 0.18706, 72, 24, 0, 1.95 },
	{ 0.23066, 0.17866, 0.18674, 72, 24, 24, 1.95 },
	{ 0.23066, 0.17866, 0.18732, 72, 24, 48, 1.95 },
	{ 0.23066, 0.17866, 0.19208, 72, 24, 72, 1.95 },
	{ 0.23066, 0.17866, 0.20353, 72, 24, 96, 1.95 },
	{ 0.23066, 0.17866, 0.2215, 72, 24, 120, 1.95 },
	{ 0.23066, 0.17866, 0.24154, 72, 24, 144, 1.95 },
	{ 0.23066, 0.17866, 0.25528, 72, 24, 168, 1.95 },
	{ 0.23066, 0.17866, 0.25722, 72, 24, 180, 1.95 },
	{ 0.23066, 0.16562, 0.21536, 72, 36, 0, 1.95 },
	{ 0.23066, 0.16562, 0.21277, 72, 36, 24, 1.95 },
	{ 0.23066, 0.16562, 0.2097, 72, 36, 48, 1.95 },
	{ 0.23066, 0.16562, 0.21467, 72, 36, 72, 1.95 },
	{ 0.23066, 0.16562, 0.23424, 72, 36, 96, 1.95 },
	{ 0.23066, 0.16562, 0.27063, 72, 36, 120, 1.95 },
	{ 0.23066, 0.16562, 0.31674, 72, 36, 144, 1.95 },
	{ 0.23066, 0.16562, 0.35166, 72, 36, 168, 1.95 },
	{ 0.23066, 0.16562, 0.35682, 72, 36, 180, 1.95 },
	{ 0.23066, 0.14599, 0.26296, 72, 48, 0, 1.95 },
	{ 0.23066, 0.14599, 0.25615, 72, 48, 24, 1.95 },
	{ 0.23066, 0.14599, 0.24656, 72, 48, 48, 1.95 },
	{ 0.23066, 0.14599, 0.25143, 72, 48, 72, 1.95 },
	{ 0.23066, 0.14599, 0.28314, 72, 48, 96, 1.95 },
	{ 0.23066, 0.14599, 0.35006, 72, 48, 120, 1.95 },
	{ 0.23066, 0.14599, 0.44609, 72, 48, 144, 1.95 },
	{ 0.23066, 0.14599, 0.528, 72, 48, 168, 1.95 },
	{ 0.23066, 0.14599, 0.54086, 72, 48, 180, 1.95 },
	{ 0.23066, 0.11958, 0.33556, 72, 60, 0, 1.95 },
	{ 0.23066, 0.11958, 0.32045, 72, 60, 24, 1.95 },
	{ 0.23066, 0.11958, 0.30143, 72, 60, 48, 1.95 },
	{ 0.23066, 0.11958, 0.30642, 72, 60, 72, 1.95 },
	{ 0.23066, 0.11958, 0.35659, 72, 60, 96, 1.95 },
	{ 0.23066, 0.11958, 0.4738, 72, 60, 120, 1.95 },
	{ 0.23066, 0.11958, 0.66578, 72, 60, 144, 1.95 },
	{ 0.23066, 0.11958, 0.85637, 72, 60, 168, 1.95 },
	{ 0.23066, 0.11958, 0.88901, 72, 60, 180, 1.95 },
	{ 0.23066, 0.10455, 0.39243, 72, 66, 0, 1.95 },
	{ 0.23066, 0.10455, 0.36228, 72, 66, 24, 1.95 },
	{ 0.23066, 0.10455, 0.33733, 72, 66, 48, 1.95 },
	{ 0.23066, 0.10455, 0.34215, 72, 66, 72, 1.95 },
	{ 0.23066, 0.10455, 0.40448, 72, 66, 96, 1.95 },
	{ 0.23066, 0.10455, 0.55752, 72, 66, 120, 1.95 },
	{ 0.23066, 0.10455, 0.8267, 72, 66, 144, 1.95 },
	{ 0.23066, 0.10455, 1.11996, 72, 66, 168, 1.95 },
	{ 0.23066, 0.10455, 1.1732, 72, 66, 180, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 0, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 24, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 48, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 72, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 96, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 120, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 144, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 168, 1.95 },
	{ 0.23066, 0.1313, 0.19735, 84, 0, 180, 1.95 },
	{ 0.23066, 0.12965, 0.1901, 84, 12, 0, 1.95 },
	{ 0.23066, 0.12965, 0.1907, 84, 12, 24, 1.95 },
	{ 0.23066, 0.12965, 0.19288, 84, 12, 48, 1.95 },
	{ 0.23066, 0.12965, 0.19748, 84, 12, 72, 1.95 },
	{ 0.23066, 0.12965, 0.20498, 84, 12, 96, 1.95 },
	{ 0.23066, 0.12965, 0.21467, 84, 12, 120, 1.95 },
	{ 0.23066, 0.12965, 0.2242, 84, 12, 144, 1.95 },
	{ 0.23066, 0.12965, 0.23025, 84, 12, 168, 1.95 },
	{ 0.23066, 0.12965, 0.23108, 84, 12, 180, 1.95 },
	{ 0.23066, 0.12452, 0.20429, 84, 24, 0, 1.95 },
	{ 0.23066, 0.12452, 0.20381, 84, 24, 24, 1.95 },
	{ 0.23066, 0.12452, 0.20427, 84, 24, 48, 1.95 },
	{ 0.23066, 0.12452, 0.21003, 84, 24, 72, 1.95 },
	{ 0.23066, 0.12452, 0.22521, 84, 24, 96, 1.95 },
	{ 0.23066, 0.12452, 0.25066, 84, 24, 120, 1.95 },
	{ 0.23066, 0.12452, 0.28068, 84, 24, 144, 1.95 },
	{ 0.23066, 0.12452, 0.30215, 84, 24, 168, 1.95 },
	{ 0.23066, 0.12452, 0.30524, 84, 24, 180, 1.95 },
	{ 0.23066, 0.11543, 0.24085, 84, 36, 0, 1.95 },
	{ 0.23066, 0.11543, 0.23763, 84, 36, 24, 1.95 },
	{ 0.23066, 0.11543, 0.23287, 84, 36, 48, 1.95 },
	{ 0.23066, 0.11543, 0.23739, 84, 36, 72, 1.95 },
	{ 0.23066, 0.11543, 0.2621, 84, 36, 96, 1.95 },
	{ 0.23066, 0.11543, 0.31342, 84, 36, 120, 1.95 },
	{ 0.23066, 0.11543, 0.38467, 84, 36, 144, 1.95 },
	{ 0.23066, 0.11543, 0.44307, 84, 36, 168, 1.95 },
	{ 0.23066, 0.11543, 0.45203, 84, 36, 180, 1.95 },
	{ 0.23066, 0.10175, 0.30719, 84, 48, 0, 1.95 },
	{ 0.23066, 0.10175, 0.2986, 84, 48, 24, 1.95 },
	{ 0.23066, 0.10175, 0.28419, 84, 48, 48, 1.95 },
	{ 0.23066, 0.10175, 0.2855, 84, 48, 72, 1.95 },
	{ 0.23066, 0.10175, 0.32389, 84, 48, 96, 1.95 },
	{ 0.23066, 0.10175, 0.41838, 84, 48, 120, 1.95 },
	{ 0.23066, 0.10175, 0.57246, 84, 48, 144, 1.95 },
	{ 0.23066, 0.10175, 0.72194, 84, 48, 168, 1.95 },
	{ 0.23066, 0.10175, 0.74717, 84, 48, 180, 1.95 },
	{ 0.23066, 0.08335, 0.42156, 84, 60, 0, 1.95 },
	{ 0.23066, 0.08335, 0.40299, 84, 60, 24, 1.95 },
	{ 0.23066, 0.08335, 0.37153, 84, 60, 48, 1.95 },
	{ 0.23066, 0.08335, 0.36719, 84, 60, 72, 1.95 },
	{ 0.23066, 0.08335, 0.42733, 84, 60, 96, 1.95 },
	{ 0.23066, 0.08335, 0.59626, 84, 60, 120, 1.95 },
	{ 0.23066, 0.08335, 0.91974, 84, 60, 144, 1.95 },
	{ 0.23066, 0.08335, 1.30969, 84, 60, 168, 1.95 },
	{ 0.23066, 0.08335, 1.38537, 84, 60, 180, 1.95 },
	{ 0.23066, 0.07287, 0.50922, 84, 66, 0, 1.95 },
	{ 0.23066, 0.07287, 0.48288, 84, 66, 24, 1.95 },
	{ 0.23066, 0.07287, 0.43805, 84, 66, 48, 1.95 },
	{ 0.23066, 0.07287, 0.42907, 84, 66, 72, 1.95 },
	{ 0.23066, 0.07287, 0.50519, 84, 66, 96, 1.95 },
	{ 0.23066, 0.07287, 0.73171, 84, 66, 120, 1.95 },
	{ 0.23066, 0.07287, 1.20092, 84, 66, 144, 1.95 },
	{ 0.23066, 0.07287, 1.84385, 84, 66, 168, 1.95 },
	{ 0.23066, 0.07287, 1.98194, 84, 66, 180, 1.95 } };
#pragma endregion 
#pragma region ұ
	float aodWinSearchTable[solZenCount * senZenCount *solAziCount *aod550Count][searchTabColCount] =
	{ { 0.04628, 0.95003, 0.01894, 0, 0, 0, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 24, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 48, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 72, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 96, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 120, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 144, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 168, 0.0001 },
	{ 0.04628, 0.95003, 0.01894, 0, 0, 180, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 0, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 24, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 48, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 72, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 96, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 120, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 144, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 168, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 0, 12, 180, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 0, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 24, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 48, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 72, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 96, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 120, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 144, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 168, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 0, 24, 180, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 0, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 24, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 48, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 72, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 96, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 120, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 144, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 168, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 0, 36, 180, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 0, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 24, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 48, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 72, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 96, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 120, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 144, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 168, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 0, 48, 180, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 0, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 24, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 48, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 72, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 96, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 120, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 144, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 168, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 0, 60, 180, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 0, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 24, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 48, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 72, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 96, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 120, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 144, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 168, 0.0001 },
	{ 0.04628, 0.91624, 0.02801, 0, 66, 180, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 0, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 24, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 48, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 72, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 96, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 120, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 144, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 168, 0.0001 },
	{ 0.04628, 0.9495, 0.01897, 12, 0, 180, 0.0001 },
	{ 0.04628, 0.94896, 0.01979, 12, 12, 0, 0.0001 },
	{ 0.04628, 0.94896, 0.01972, 12, 12, 24, 0.0001 },
	{ 0.04628, 0.94896, 0.01953, 12, 12, 48, 0.0001 },
	{ 0.04628, 0.94896, 0.01925, 12, 12, 72, 0.0001 },
	{ 0.04628, 0.94896, 0.01894, 12, 12, 96, 0.0001 },
	{ 0.04628, 0.94896, 0.01865, 12, 12, 120, 0.0001 },
	{ 0.04628, 0.94896, 0.01842, 12, 12, 144, 0.0001 },
	{ 0.04628, 0.94896, 0.0183, 12, 12, 168, 0.0001 },
	{ 0.04628, 0.94896, 0.01828, 12, 12, 180, 0.0001 },
	{ 0.04628, 0.94723, 0.02076, 12, 24, 0, 0.0001 },
	{ 0.04628, 0.94723, 0.02062, 12, 24, 24, 0.0001 },
	{ 0.04628, 0.94723, 0.02023, 12, 24, 48, 0.0001 },
	{ 0.04628, 0.94723, 0.01968, 12, 24, 72, 0.0001 },
	{ 0.04628, 0.94723, 0.01906, 12, 24, 96, 0.0001 },
	{ 0.04628, 0.94723, 0.0185, 12, 24, 120, 0.0001 },
	{ 0.04628, 0.94723, 0.01807, 12, 24, 144, 0.0001 },
	{ 0.04628, 0.94723, 0.01784, 12, 24, 168, 0.0001 },
	{ 0.04628, 0.94723, 0.01781, 12, 24, 180, 0.0001 },
	{ 0.04628, 0.94386, 0.02206, 12, 36, 0, 0.0001 },
	{ 0.04628, 0.94386, 0.02185, 12, 36, 24, 0.0001 },
	{ 0.04628, 0.94386, 0.02127, 12, 36, 48, 0.0001 },
	{ 0.04628, 0.94386, 0.02045, 12, 36, 72, 0.0001 },
	{ 0.04628, 0.94386, 0.01956, 12, 36, 96, 0.0001 },
	{ 0.04628, 0.94386, 0.01876, 12, 36, 120, 0.0001 },
	{ 0.04628, 0.94386, 0.01817, 12, 36, 144, 0.0001 },
	{ 0.04628, 0.94386, 0.01786, 12, 36, 168, 0.0001 },
	{ 0.04628, 0.94386, 0.01783, 12, 36, 180, 0.0001 },
	{ 0.04628, 0.93776, 0.0242, 12, 48, 0, 0.0001 },
	{ 0.04628, 0.93776, 0.02391, 12, 48, 24, 0.0001 },
	{ 0.04628, 0.93776, 0.02314, 12, 48, 48, 0.0001 },
	{ 0.04628, 0.93776, 0.02207, 12, 48, 72, 0.0001 },
	{ 0.04628, 0.93776, 0.02094, 12, 48, 96, 0.0001 },
	{ 0.04628, 0.93776, 0.01997, 12, 48, 120, 0.0001 },
	{ 0.04628, 0.93776, 0.01927, 12, 48, 144, 0.0001 },
	{ 0.04628, 0.93776, 0.01892, 12, 48, 168, 0.0001 },
	{ 0.04628, 0.93776, 0.01887, 12, 48, 180, 0.0001 },
	{ 0.04628, 0.92607, 0.02846, 12, 60, 0, 0.0001 },
	{ 0.04628, 0.92607, 0.0281, 12, 60, 24, 0.0001 },
	{ 0.04628, 0.92607, 0.02713, 12, 60, 48, 0.0001 },
	{ 0.04628, 0.92607, 0.02582, 12, 60, 72, 0.0001 },
	{ 0.04628, 0.92607, 0.02451, 12, 60, 96, 0.0001 },
	{ 0.04628, 0.92607, 0.02343, 12, 60, 120, 0.0001 },
	{ 0.04628, 0.92607, 0.02272, 12, 60, 144, 0.0001 },
	{ 0.04628, 0.92607, 0.02237, 12, 60, 168, 0.0001 },
	{ 0.04628, 0.92607, 0.02233, 12, 60, 180, 0.0001 },
	{ 0.04628, 0.91572, 0.03246, 12, 66, 0, 0.0001 },
	{ 0.04628, 0.91572, 0.03206, 12, 66, 24, 0.0001 },
	{ 0.04628, 0.91572, 0.03098, 12, 66, 48, 0.0001 },
	{ 0.04628, 0.91572, 0.02955, 12, 66, 72, 0.0001 },
	{ 0.04628, 0.91572, 0.02817, 12, 66, 96, 0.0001 },
	{ 0.04628, 0.91572, 0.02709, 12, 66, 120, 0.0001 },
	{ 0.04628, 0.91572, 0.02642, 12, 66, 144, 0.0001 },
	{ 0.04628, 0.91572, 0.02611, 12, 66, 168, 0.0001 },
	{ 0.04628, 0.91572, 0.02607, 12, 66, 180, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 0, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 24, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 48, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 72, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 96, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 120, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 144, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 168, 0.0001 },
	{ 0.04628, 0.94776, 0.01914, 24, 0, 180, 0.0001 },
	{ 0.04628, 0.94723, 0.02076, 24, 12, 0, 0.0001 },
	{ 0.04628, 0.94723, 0.02062, 24, 12, 24, 0.0001 },
	{ 0.04628, 0.94723, 0.02023, 24, 12, 48, 0.0001 },
	{ 0.04628, 0.94723, 0.01968, 24, 12, 72, 0.0001 },
	{ 0.04628, 0.94723, 0.01906, 24, 12, 96, 0.0001 },
	{ 0.04628, 0.94723, 0.0185, 24, 12, 120, 0.0001 },
	{ 0.04628, 0.94723, 0.01807, 24, 12, 144, 0.0001 },
	{ 0.04628, 0.94723, 0.01784, 24, 12, 168, 0.0001 },
	{ 0.04628, 0.94723, 0.01781, 24, 12, 180, 0.0001 },
	{ 0.04628, 0.9455, 0.02267, 24, 24, 0, 0.0001 },
	{ 0.04628, 0.9455, 0.02237, 24, 24, 24, 0.0001 },
	{ 0.04628, 0.9455, 0.02156, 24, 24, 48, 0.0001 },
	{ 0.04628, 0.9455, 0.02042, 24, 24, 72, 0.0001 },
	{ 0.04628, 0.9455, 0.01921, 24, 24, 96, 0.0001 },
	{ 0.04628, 0.9455, 0.01814, 24, 24, 120, 0.0001 },
	{ 0.04628, 0.9455, 0.01737, 24, 24, 144, 0.0001 },
	{ 0.04628, 0.9455, 0.01697, 24, 24, 168, 0.0001 },
	{ 0.04628, 0.9455, 0.01692, 24, 24, 180, 0.0001 },
	{ 0.04628, 0.94213, 0.02505, 24, 36, 0, 0.0001 },
	{ 0.04628, 0.94213, 0.02458, 24, 36, 24, 0.0001 },
	{ 0.04628, 0.94213, 0.02331, 24, 36, 48, 0.0001 },
	{ 0.04628, 0.94213, 0.02158, 24, 36, 72, 0.0001 },
	{ 0.04628, 0.94213, 0.01981, 24, 36, 96, 0.0001 },
	{ 0.04628, 0.94213, 0.01834, 24, 36, 120, 0.0001 },
	{ 0.04628, 0.94213, 0.01734, 24, 36, 144, 0.0001 },
	{ 0.04628, 0.94213, 0.01684, 24, 36, 168, 0.0001 },
	{ 0.04628, 0.94213, 0.01678, 24, 36, 180, 0.0001 },
	{ 0.04628, 0.93605, 0.02845, 24, 48, 0, 0.0001 },
	{ 0.04628, 0.93605, 0.02779, 24, 48, 24, 0.0001 },
	{ 0.04628, 0.93605, 0.02601, 24, 48, 48, 0.0001 },
	{ 0.04628, 0.93605, 0.02368, 24, 48, 72, 0.0001 },
	{ 0.04628, 0.93605, 0.02142, 24, 48, 96, 0.0001 },
	{ 0.04628, 0.93605, 0.01968, 24, 48, 120, 0.0001 },
	{ 0.04628, 0.93605, 0.0186, 24, 48, 144, 0.0001 },
	{ 0.04628, 0.93605, 0.01812, 24, 48, 168, 0.0001 },
	{ 0.04628, 0.93605, 0.01806, 24, 48, 180, 0.0001 },
	{ 0.04628, 0.92438, 0.03434, 24, 60, 0, 0.0001 },
	{ 0.04628, 0.92438, 0.03344, 24, 60, 24, 0.0001 },
	{ 0.04628, 0.92438, 0.03108, 24, 60, 48, 0.0001 },
	{ 0.04628, 0.92438, 0.0281, 24, 60, 72, 0.0001 },
	{ 0.04628, 0.92438, 0.02543, 24, 60, 96, 0.0001 },
	{ 0.04628, 0.92438, 0.02362, 24, 60, 120, 0.0001 },
	{ 0.04628, 0.92438, 0.02272, 24, 60, 144, 0.0001 },
	{ 0.04628, 0.92438, 0.02242, 24, 60, 168, 0.0001 },
	{ 0.04628, 0.92438, 0.02239, 24, 60, 180, 0.0001 },
	{ 0.04628, 0.91405, 0.03947, 24, 66, 0, 0.0001 },
	{ 0.04628, 0.91405, 0.03841, 24, 66, 24, 0.0001 },
	{ 0.04628, 0.91405, 0.03567, 24, 66, 48, 0.0001 },
	{ 0.04628, 0.91405, 0.03231, 24, 66, 72, 0.0001 },
	{ 0.04628, 0.91405, 0.02946, 24, 66, 96, 0.0001 },
	{ 0.04628, 0.91405, 0.02775, 24, 66, 120, 0.0001 },
	{ 0.04628, 0.91405, 0.0271, 24, 66, 144, 0.0001 },
	{ 0.04628, 0.91405, 0.02701, 24, 66, 168, 0.0001 },
	{ 0.04628, 0.91405, 0.02701, 24, 66, 180, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 0, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 24, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 48, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 72, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 96, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 120, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 144, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 168, 0.0001 },
	{ 0.04628, 0.94439, 0.01965, 36, 0, 180, 0.0001 },
	{ 0.04628, 0.94386, 0.02206, 36, 12, 0, 0.0001 },
	{ 0.04628, 0.94386, 0.02185, 36, 12, 24, 0.0001 },
	{ 0.04628, 0.94386, 0.02127, 36, 12, 48, 0.0001 },
	{ 0.04628, 0.94386, 0.02045, 36, 12, 72, 0.0001 },
	{ 0.04628, 0.94386, 0.01956, 36, 12, 96, 0.0001 },
	{ 0.04628, 0.94386, 0.01876, 36, 12, 120, 0.0001 },
	{ 0.04628, 0.94386, 0.01817, 36, 12, 144, 0.0001 },
	{ 0.04628, 0.94386, 0.01786, 36, 12, 168, 0.0001 },
	{ 0.04628, 0.94386, 0.01783, 36, 12, 180, 0.0001 },
	{ 0.04628, 0.94213, 0.02505, 36, 24, 0, 0.0001 },
	{ 0.04628, 0.94213, 0.02458, 36, 24, 24, 0.0001 },
	{ 0.04628, 0.94213, 0.02331, 36, 24, 48, 0.0001 },
	{ 0.04628, 0.94213, 0.02158, 36, 24, 72, 0.0001 },
	{ 0.04628, 0.94213, 0.01981, 36, 24, 96, 0.0001 },
	{ 0.04628, 0.94213, 0.01834, 36, 24, 120, 0.0001 },
	{ 0.04628, 0.94213, 0.01734, 36, 24, 144, 0.0001 },
	{ 0.04628, 0.94213, 0.01684, 36, 24, 168, 0.0001 },
	{ 0.04628, 0.94213, 0.01678, 36, 24, 180, 0.0001 },
	{ 0.04628, 0.93878, 0.02883, 36, 36, 0, 0.0001 },
	{ 0.04628, 0.93878, 0.02805, 36, 36, 24, 0.0001 },
	{ 0.04628, 0.93878, 0.02598, 36, 36, 48, 0.0001 },
	{ 0.04628, 0.93878, 0.02327, 36, 36, 72, 0.0001 },
	{ 0.04628, 0.93878, 0.02067, 36, 36, 96, 0.0001 },
	{ 0.04628, 0.93878, 0.0187, 36, 36, 120, 0.0001 },
	{ 0.04628, 0.93878, 0.0175, 36, 36, 144, 0.0001 },
	{ 0.04628, 0.93878, 0.01698, 36, 36, 168, 0.0001 },
	{ 0.04628, 0.93878, 0.01692, 36, 36, 180, 0.0001 },
	{ 0.04628, 0.93272, 0.03405, 36, 48, 0, 0.0001 },
	{ 0.04628, 0.93272, 0.03289, 36, 48, 24, 0.0001 },
	{ 0.04628, 0.93272, 0.02988, 36, 48, 48, 0.0001 },
	{ 0.04628, 0.93272, 0.02611, 36, 48, 72, 0.0001 },
	{ 0.04628, 0.93272, 0.02275, 36, 48, 96, 0.0001 },
	{ 0.04628, 0.93272, 0.02053, 36, 48, 120, 0.0001 },
	{ 0.04628, 0.93272, 0.01945, 36, 48, 144, 0.0001 },
	{ 0.04628, 0.93272, 0.01911, 36, 48, 168, 0.0001 },
	{ 0.04628, 0.93272, 0.01908, 36, 48, 180, 0.0001 },
	{ 0.04628, 0.92109, 0.04256, 36, 60, 0, 0.0001 },
	{ 0.04628, 0.92109, 0.0409, 36, 60, 24, 0.0001 },
	{ 0.04628, 0.92109, 0.03667, 36, 60, 48, 0.0001 },
	{ 0.04628, 0.92109, 0.03164, 36, 60, 72, 0.0001 },
	{ 0.04628, 0.92109, 0.02761, 36, 60, 96, 0.0001 },
	{ 0.04628, 0.92109, 0.02552, 36, 60, 120, 0.0001 },
	{ 0.04628, 0.92109, 0.02508, 36, 60, 144, 0.0001 },
	{ 0.04628, 0.92109, 0.02529, 36, 60, 168, 0.0001 },
	{ 0.04628, 0.92109, 0.02534, 36, 60, 180, 0.0001 },
	{ 0.04628, 0.9108, 0.04963, 36, 66, 0, 0.0001 },
	{ 0.04628, 0.9108, 0.04762, 36, 66, 24, 0.0001 },
	{ 0.04628, 0.9108, 0.04256, 36, 66, 48, 0.0001 },
	{ 0.04628, 0.9108, 0.03671, 36, 66, 72, 0.0001 },
	{ 0.04628, 0.9108, 0.03237, 36, 66, 96, 0.0001 },
	{ 0.04628, 0.9108, 0.03059, 36, 66, 120, 0.0001 },
	{ 0.04628, 0.9108, 0.03082, 36, 66, 144, 0.0001 },
	{ 0.04628, 0.9108, 0.03155, 36, 66, 168, 0.0001 },
	{ 0.04628, 0.9108, 0.03167, 36, 66, 180, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 0, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 24, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 48, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 72, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 96, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 120, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 144, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 168, 0.0001 },
	{ 0.04628, 0.93829, 0.021, 48, 0, 180, 0.0001 },
	{ 0.04628, 0.93776, 0.0242, 48, 12, 0, 0.0001 },
	{ 0.04628, 0.93776, 0.02391, 48, 12, 24, 0.0001 },
	{ 0.04628, 0.93776, 0.02314, 48, 12, 48, 0.0001 },
	{ 0.04628, 0.93776, 0.02207, 48, 12, 72, 0.0001 },
	{ 0.04628, 0.93776, 0.02094, 48, 12, 96, 0.0001 },
	{ 0.04628, 0.93776, 0.01997, 48, 12, 120, 0.0001 },
	{ 0.04628, 0.93776, 0.01927, 48, 12, 144, 0.0001 },
	{ 0.04628, 0.93776, 0.01892, 48, 12, 168, 0.0001 },
	{ 0.04628, 0.93776, 0.01887, 48, 12, 180, 0.0001 },
	{ 0.04628, 0.93605, 0.02845, 48, 24, 0, 0.0001 },
	{ 0.04628, 0.93605, 0.02779, 48, 24, 24, 0.0001 },
	{ 0.04628, 0.93605, 0.02601, 48, 24, 48, 0.0001 },
	{ 0.04628, 0.93605, 0.02368, 48, 24, 72, 0.0001 },
	{ 0.04628, 0.93605, 0.02142, 48, 24, 96, 0.0001 },
	{ 0.04628, 0.93605, 0.01968, 48, 24, 120, 0.0001 },
	{ 0.04628, 0.93605, 0.0186, 48, 24, 144, 0.0001 },
	{ 0.04628, 0.93605, 0.01812, 48, 24, 168, 0.0001 },
	{ 0.04628, 0.93605, 0.01806, 48, 24, 180, 0.0001 },
	{ 0.04628, 0.93272, 0.03405, 48, 36, 0, 0.0001 },
	{ 0.04628, 0.93272, 0.03289, 48, 36, 24, 0.0001 },
	{ 0.04628, 0.93272, 0.02988, 48, 36, 48, 0.0001 },
	{ 0.04628, 0.93272, 0.02611, 48, 36, 72, 0.0001 },
	{ 0.04628, 0.93272, 0.02275, 48, 36, 96, 0.0001 },
	{ 0.04628, 0.93272, 0.02053, 48, 36, 120, 0.0001 },
	{ 0.04628, 0.93272, 0.01945, 48, 36, 144, 0.0001 },
	{ 0.04628, 0.93272, 0.01911, 48, 36, 168, 0.0001 },
	{ 0.04628, 0.93272, 0.01908, 48, 36, 180, 0.0001 },
	{ 0.04628, 0.9267, 0.04186, 48, 48, 0, 0.0001 },
	{ 0.04628, 0.9267, 0.04007, 48, 48, 24, 0.0001 },
	{ 0.04628, 0.9267, 0.0355, 48, 48, 48, 0.0001 },
	{ 0.04628, 0.9267, 0.03004, 48, 48, 72, 0.0001 },
	{ 0.04628, 0.9267, 0.02566, 48, 48, 96, 0.0001 },
	{ 0.04628, 0.9267, 0.02335, 48, 48, 120, 0.0001 },
	{ 0.04628, 0.9267, 0.02282, 48, 48, 144, 0.0001 },
	{ 0.04628, 0.9267, 0.02301, 48, 48, 168, 0.0001 },
	{ 0.04628, 0.9267, 0.02306, 48, 48, 180, 0.0001 },
	{ 0.04628, 0.91514, 0.05439, 48, 60, 0, 0.0001 },
	{ 0.04628, 0.91514, 0.05171, 48, 60, 24, 0.0001 },
	{ 0.04628, 0.91514, 0.04499, 48, 60, 48, 0.0001 },
	{ 0.04628, 0.91514, 0.03738, 48, 60, 72, 0.0001 },
	{ 0.04628, 0.91514, 0.03201, 48, 60, 96, 0.0001 },
	{ 0.04628, 0.91514, 0.03026, 48, 60, 120, 0.0001 },
	{ 0.04628, 0.91514, 0.03119, 48, 60, 144, 0.0001 },
	{ 0.04628, 0.91514, 0.03254, 48, 60, 168, 0.0001 },
	{ 0.04628, 0.91514, 0.03276, 48, 60, 180, 0.0001 },
	{ 0.04628, 0.90492, 0.06459, 48, 66, 0, 0.0001 },
	{ 0.04628, 0.90492, 0.06126, 48, 66, 24, 0.0001 },
	{ 0.04628, 0.90492, 0.05298, 48, 66, 48, 0.0001 },
	{ 0.04628, 0.90492, 0.0439, 48, 66, 72, 0.0001 },
	{ 0.04628, 0.90492, 0.03803, 48, 66, 96, 0.0001 },
	{ 0.04628, 0.90492, 0.03698, 48, 66, 120, 0.0001 },
	{ 0.04628, 0.90492, 0.03926, 48, 66, 144, 0.0001 },
	{ 0.04628, 0.90492, 0.04167, 48, 66, 168, 0.0001 },
	{ 0.04628, 0.90492, 0.04204, 48, 66, 180, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 0, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 24, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 48, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 72, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 96, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 120, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 144, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 168, 0.0001 },
	{ 0.04628, 0.92659, 0.02446, 60, 0, 180, 0.0001 },
	{ 0.04628, 0.92607, 0.02846, 60, 12, 0, 0.0001 },
	{ 0.04628, 0.92607, 0.0281, 60, 12, 24, 0.0001 },
	{ 0.04628, 0.92607, 0.02713, 60, 12, 48, 0.0001 },
	{ 0.04628, 0.92607, 0.02582, 60, 12, 72, 0.0001 },
	{ 0.04628, 0.92607, 0.02451, 60, 12, 96, 0.0001 },
	{ 0.04628, 0.92607, 0.02343, 60, 12, 120, 0.0001 },
	{ 0.04628, 0.92607, 0.02272, 60, 12, 144, 0.0001 },
	{ 0.04628, 0.92607, 0.02237, 60, 12, 168, 0.0001 },
	{ 0.04628, 0.92607, 0.02233, 60, 12, 180, 0.0001 },
	{ 0.04628, 0.92438, 0.03434, 60, 24, 0, 0.0001 },
	{ 0.04628, 0.92438, 0.03344, 60, 24, 24, 0.0001 },
	{ 0.04628, 0.92438, 0.03108, 60, 24, 48, 0.0001 },
	{ 0.04628, 0.92438, 0.0281, 60, 24, 72, 0.0001 },
	{ 0.04628, 0.92438, 0.02543, 60, 24, 96, 0.0001 },
	{ 0.04628, 0.92438, 0.02362, 60, 24, 120, 0.0001 },
	{ 0.04628, 0.92438, 0.02272, 60, 24, 144, 0.0001 },
	{ 0.04628, 0.92438, 0.02242, 60, 24, 168, 0.0001 },
	{ 0.04628, 0.92438, 0.02239, 60, 24, 180, 0.0001 },
	{ 0.04628, 0.92109, 0.04256, 60, 36, 0, 0.0001 },
	{ 0.04628, 0.92109, 0.0409, 60, 36, 24, 0.0001 },
	{ 0.04628, 0.92109, 0.03667, 60, 36, 48, 0.0001 },
	{ 0.04628, 0.92109, 0.03164, 60, 36, 72, 0.0001 },
	{ 0.04628, 0.92109, 0.02761, 60, 36, 96, 0.0001 },
	{ 0.04628, 0.92109, 0.02552, 60, 36, 120, 0.0001 },
	{ 0.04628, 0.92109, 0.02508, 60, 36, 144, 0.0001 },
	{ 0.04628, 0.92109, 0.02529, 60, 36, 168, 0.0001 },
	{ 0.04628, 0.92109, 0.02534, 60, 36, 180, 0.0001 },
	{ 0.04628, 0.91514, 0.05439, 60, 48, 0, 0.0001 },
	{ 0.04628, 0.91514, 0.05171, 60, 48, 24, 0.0001 },
	{ 0.04628, 0.91514, 0.04499, 60, 48, 48, 0.0001 },
	{ 0.04628, 0.91514, 0.03738, 60, 48, 72, 0.0001 },
	{ 0.04628, 0.91514, 0.03201, 60, 48, 96, 0.0001 },
	{ 0.04628, 0.91514, 0.03026, 60, 48, 120, 0.0001 },
	{ 0.04628, 0.91514, 0.03119, 60, 48, 144, 0.0001 },
	{ 0.04628, 0.91514, 0.03254, 60, 48, 168, 0.0001 },
	{ 0.04628, 0.91514, 0.03276, 60, 48, 180, 0.0001 },
	{ 0.04628, 0.90373, 0.07356, 60, 60, 0, 0.0001 },
	{ 0.04628, 0.90373, 0.06936, 60, 60, 24, 0.0001 },
	{ 0.04628, 0.90373, 0.05899, 60, 60, 48, 0.0001 },
	{ 0.04628, 0.90373, 0.04784, 60, 60, 72, 0.0001 },
	{ 0.04628, 0.90373, 0.0411, 60, 60, 96, 0.0001 },
	{ 0.04628, 0.90373, 0.0407, 60, 60, 120, 0.0001 },
	{ 0.04628, 0.90373, 0.04451, 60, 60, 144, 0.0001 },
	{ 0.04628, 0.90373, 0.04813, 60, 60, 168, 0.0001 },
	{ 0.04628, 0.90373, 0.04868, 60, 60, 180, 0.0001 },
	{ 0.04628, 0.89363, 0.08909, 60, 66, 0, 0.0001 },
	{ 0.04628, 0.89363, 0.08373, 60, 66, 24, 0.0001 },
	{ 0.04628, 0.89363, 0.07066, 60, 66, 48, 0.0001 },
	{ 0.04628, 0.89363, 0.05697, 60, 66, 72, 0.0001 },
	{ 0.04628, 0.89363, 0.04944, 60, 66, 96, 0.0001 },
	{ 0.04628, 0.89363, 0.05043, 60, 66, 120, 0.0001 },
	{ 0.04628, 0.89363, 0.05677, 60, 66, 144, 0.0001 },
	{ 0.04628, 0.89363, 0.06232, 60, 66, 168, 0.0001 },
	{ 0.04628, 0.89363, 0.06314, 60, 66, 180, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 0, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 24, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 48, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 72, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 96, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 120, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 144, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 168, 0.0001 },
	{ 0.04628, 0.89923, 0.03433, 72, 0, 180, 0.0001 },
	{ 0.04628, 0.89872, 0.03934, 72, 12, 0, 0.0001 },
	{ 0.04628, 0.89872, 0.03888, 72, 12, 24, 0.0001 },
	{ 0.04628, 0.89872, 0.03766, 72, 12, 48, 0.0001 },
	{ 0.04628, 0.89872, 0.03611, 72, 12, 72, 0.0001 },
	{ 0.04628, 0.89872, 0.03467, 72, 12, 96, 0.0001 },
	{ 0.04628, 0.89872, 0.03364, 72, 12, 120, 0.0001 },
	{ 0.04628, 0.89872, 0.03307, 72, 12, 144, 0.0001 },
	{ 0.04628, 0.89872, 0.03284, 72, 12, 168, 0.0001 },
	{ 0.04628, 0.89872, 0.03282, 72, 12, 180, 0.0001 },
	{ 0.04628, 0.89708, 0.04796, 72, 24, 0, 0.0001 },
	{ 0.04628, 0.89708, 0.04668, 72, 24, 24, 0.0001 },
	{ 0.04628, 0.89708, 0.04341, 72, 24, 48, 0.0001 },
	{ 0.04628, 0.89708, 0.03956, 72, 24, 72, 0.0001 },
	{ 0.04628, 0.89708, 0.03656, 72, 24, 96, 0.0001 },
	{ 0.04628, 0.89708, 0.0351, 72, 24, 120, 0.0001 },
	{ 0.04628, 0.89708, 0.03492, 72, 24, 144, 0.0001 },
	{ 0.04628, 0.89708, 0.03518, 72, 24, 168, 0.0001 },
	{ 0.04628, 0.89708, 0.03523, 72, 24, 180, 0.0001 },
	{ 0.04628, 0.89389, 0.061, 72, 36, 0, 0.0001 },
	{ 0.04628, 0.89389, 0.05849, 72, 36, 24, 0.0001 },
	{ 0.04628, 0.89389, 0.05223, 72, 36, 48, 0.0001 },
	{ 0.04628, 0.89389, 0.04527, 72, 36, 72, 0.0001 },
	{ 0.04628, 0.89389, 0.0406, 72, 36, 96, 0.0001 },
	{ 0.04628, 0.89389, 0.03946, 72, 36, 120, 0.0001 },
	{ 0.04628, 0.89389, 0.04083, 72, 36, 144, 0.0001 },
	{ 0.04628, 0.89389, 0.04242, 72, 36, 168, 0.0001 },
	{ 0.04628, 0.89389, 0.04267, 72, 36, 180, 0.0001 },
	{ 0.04628, 0.88812, 0.08072, 72, 48, 0, 0.0001 },
	{ 0.04628, 0.88812, 0.07642, 72, 48, 24, 0.0001 },
	{ 0.04628, 0.88812, 0.06589, 72, 48, 48, 0.0001 },
	{ 0.04628, 0.88812, 0.05471, 72, 48, 72, 0.0001 },
	{ 0.04628, 0.88812, 0.04826, 72, 48, 96, 0.0001 },
	{ 0.04628, 0.88812, 0.04848, 72, 48, 120, 0.0001 },
	{ 0.04628, 0.88812, 0.053, 72, 48, 144, 0.0001 },
	{ 0.04628, 0.88812, 0.05708, 72, 48, 168, 0.0001 },
	{ 0.04628, 0.88812, 0.05769, 72, 48, 180, 0.0001 },
	{ 0.04628, 0.87705, 0.11347, 72, 60, 0, 0.0001 },
	{ 0.04628, 0.87705, 0.1064, 72, 60, 24, 0.0001 },
	{ 0.04628, 0.87705, 0.08931, 72, 60, 48, 0.0001 },
	{ 0.04628, 0.87705, 0.07192, 72, 60, 72, 0.0001 },
	{ 0.04628, 0.87705, 0.06341, 72, 60, 96, 0.0001 },
	{ 0.04628, 0.87705, 0.06674, 72, 60, 120, 0.0001 },
	{ 0.04628, 0.87705, 0.07713, 72, 60, 144, 0.0001 },
	{ 0.04628, 0.87705, 0.08572, 72, 60, 168, 0.0001 },
	{ 0.04628, 0.87705, 0.08697, 72, 60, 180, 0.0001 },
	{ 0.04628, 0.86724, 0.14018, 72, 66, 0, 0.0001 },
	{ 0.04628, 0.86724, 0.13098, 72, 66, 24, 0.0001 },
	{ 0.04628, 0.86724, 0.10886, 72, 66, 48, 0.0001 },
	{ 0.04628, 0.86724, 0.08682, 72, 66, 72, 0.0001 },
	{ 0.04628, 0.86724, 0.07701, 72, 66, 96, 0.0001 },
	{ 0.04628, 0.86724, 0.08313, 72, 66, 120, 0.0001 },
	{ 0.04628, 0.86724, 0.09845, 72, 66, 144, 0.0001 },
	{ 0.04628, 0.86724, 0.11076, 72, 66, 168, 0.0001 },
	{ 0.04628, 0.86724, 0.11255, 72, 66, 180, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 0, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 24, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 48, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 72, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 96, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 120, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 144, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 168, 0.0001 },
	{ 0.04628, 0.78318, 0.08139, 84, 0, 180, 0.0001 },
	{ 0.04628, 0.78274, 0.08914, 84, 12, 0, 0.0001 },
	{ 0.04628, 0.78274, 0.08839, 84, 12, 24, 0.0001 },
	{ 0.04628, 0.78274, 0.08652, 84, 12, 48, 0.0001 },
	{ 0.04628, 0.78274, 0.08441, 84, 12, 72, 0.0001 },
	{ 0.04628, 0.78274, 0.08295, 84, 12, 96, 0.0001 },
	{ 0.04628, 0.78274, 0.08251, 84, 12, 120, 0.0001 },
	{ 0.04628, 0.78274, 0.08282, 84, 12, 144, 0.0001 },
	{ 0.04628, 0.78274, 0.08323, 84, 12, 168, 0.0001 },
	{ 0.04628, 0.78274, 0.08329, 84, 12, 180, 0.0001 },
	{ 0.04628, 0.78131, 0.1071, 84, 24, 0, 0.0001 },
	{ 0.04628, 0.78131, 0.10458, 84, 24, 24, 0.0001 },
	{ 0.04628, 0.78131, 0.09844, 84, 24, 48, 0.0001 },
	{ 0.04628, 0.78131, 0.09207, 84, 24, 72, 0.0001 },
	{ 0.04628, 0.78131, 0.08867, 84, 24, 96, 0.0001 },
	{ 0.04628, 0.78131, 0.08934, 84, 24, 120, 0.0001 },
	{ 0.04628, 0.78131, 0.09254, 84, 24, 144, 0.0001 },
	{ 0.04628, 0.78131, 0.09528, 84, 24, 168, 0.0001 },
	{ 0.04628, 0.78131, 0.09568, 84, 24, 180, 0.0001 },
	{ 0.04628, 0.77853, 0.13764, 84, 36, 0, 0.0001 },
	{ 0.04628, 0.77853, 0.13217, 84, 36, 24, 0.0001 },
	{ 0.04628, 0.77853, 0.11901, 84, 36, 48, 0.0001 },
	{ 0.04628, 0.77853, 0.1059, 84, 36, 72, 0.0001 },
	{ 0.04628, 0.77853, 0.10007, 84, 36, 96, 0.0001 },
	{ 0.04628, 0.77853, 0.10371, 84, 36, 120, 0.0001 },
	{ 0.04628, 0.77853, 0.11282, 84, 36, 144, 0.0001 },
	{ 0.04628, 0.77853, 0.12014, 84, 36, 168, 0.0001 },
	{ 0.04628, 0.77853, 0.12121, 84, 36, 180, 0.0001 },
	{ 0.04628, 0.7735, 0.18698, 84, 48, 0, 0.0001 },
	{ 0.04628, 0.7735, 0.17693, 84, 48, 24, 0.0001 },
	{ 0.04628, 0.7735, 0.153, 84, 48, 48, 0.0001 },
	{ 0.04628, 0.7735, 0.12978, 84, 48, 72, 0.0001 },
	{ 0.04628, 0.7735, 0.12083, 84, 48, 96, 0.0001 },
	{ 0.04628, 0.7735, 0.12998, 84, 48, 120, 0.0001 },
	{ 0.04628, 0.7735, 0.14917, 84, 48, 144, 0.0001 },
	{ 0.04628, 0.7735, 0.16416, 84, 48, 168, 0.0001 },
	{ 0.04628, 0.7735, 0.16632, 84, 48, 180, 0.0001 },
	{ 0.04628, 0.76386, 0.27222, 84, 60, 0, 0.0001 },
	{ 0.04628, 0.76386, 0.25475, 84, 60, 24, 0.0001 },
	{ 0.04628, 0.76386, 0.21339, 84, 60, 48, 0.0001 },
	{ 0.04628, 0.76386, 0.17409, 84, 60, 72, 0.0001 },
	{ 0.04628, 0.76386, 0.16077, 84, 60, 96, 0.0001 },
	{ 0.04628, 0.76386, 0.17983, 84, 60, 120, 0.0001 },
	{ 0.04628, 0.76386, 0.21636, 84, 60, 144, 0.0001 },
	{ 0.04628, 0.76386, 0.24439, 84, 60, 168, 0.0001 },
	{ 0.04628, 0.76386, 0.24843, 84, 60, 180, 0.0001 },
	{ 0.04628, 0.75532, 0.34291, 84, 66, 0, 0.0001 },
	{ 0.04628, 0.75532, 0.31958, 84, 66, 24, 0.0001 },
	{ 0.04628, 0.75532, 0.26451, 84, 66, 48, 0.0001 },
	{ 0.04628, 0.75532, 0.21265, 84, 66, 72, 0.0001 },
	{ 0.04628, 0.75532, 0.19614, 84, 66, 96, 0.0001 },
	{ 0.04628, 0.75532, 0.22339, 84, 66, 120, 0.0001 },
	{ 0.04628, 0.75532, 0.27397, 84, 66, 144, 0.0001 },
	{ 0.04628, 0.75532, 0.31254, 84, 66, 168, 0.0001 },
	{ 0.04628, 0.75532, 0.31808, 84, 66, 180, 0.0001 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 0, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 24, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 48, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 72, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 96, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 120, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 144, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 168, 0.25 },
	{ 0.09552, 0.86416, 0.03505, 0, 0, 180, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 0, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 24, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 48, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 72, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 96, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 120, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 144, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 168, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 0, 12, 180, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 0, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 24, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 48, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 72, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 96, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 120, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 144, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 168, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 0, 24, 180, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 0, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 24, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 48, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 72, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 96, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 120, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 144, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 168, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 0, 36, 180, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 0, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 24, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 48, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 72, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 96, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 120, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 144, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 168, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 0, 48, 180, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 0, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 24, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 48, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 72, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 96, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 120, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 144, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 168, 0.25 },
	{ 0.09552, 0.77936, 0.04618, 0, 60, 180, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 0, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 24, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 48, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 72, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 96, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 120, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 144, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 168, 0.25 },
	{ 0.09552, 0.74292, 0.05478, 0, 66, 180, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 0, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 24, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 48, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 72, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 96, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 120, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 144, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 168, 0.25 },
	{ 0.09552, 0.86231, 0.03248, 12, 0, 180, 0.25 },
	{ 0.09552, 0.86046, 0.03663, 12, 12, 0, 0.25 },
	{ 0.09552, 0.86046, 0.03572, 12, 12, 24, 0.25 },
	{ 0.09552, 0.86046, 0.03392, 12, 12, 48, 0.25 },
	{ 0.09552, 0.86046, 0.0327, 12, 12, 72, 0.25 },
	{ 0.09552, 0.86046, 0.03199, 12, 12, 96, 0.25 },
	{ 0.09552, 0.86046, 0.03143, 12, 12, 120, 0.25 },
	{ 0.09552, 0.86046, 0.03103, 12, 12, 144, 0.25 },
	{ 0.09552, 0.86046, 0.03081, 12, 12, 168, 0.25 },
	{ 0.09552, 0.86046, 0.03079, 12, 12, 180, 0.25 },
	{ 0.09552, 0.85443, 0.03559, 12, 24, 0, 0.25 },
	{ 0.09552, 0.85443, 0.03509, 12, 24, 24, 0.25 },
	{ 0.09552, 0.85443, 0.0342, 12, 24, 48, 0.25 },
	{ 0.09552, 0.85443, 0.03317, 12, 24, 72, 0.25 },
	{ 0.09552, 0.85443, 0.03212, 12, 24, 96, 0.25 },
	{ 0.09552, 0.85443, 0.03121, 12, 24, 120, 0.25 },
	{ 0.09552, 0.85443, 0.03058, 12, 24, 144, 0.25 },
	{ 0.09552, 0.85443, 0.03025, 12, 24, 168, 0.25 },
	{ 0.09552, 0.85443, 0.03021, 12, 24, 180, 0.25 },
	{ 0.09552, 0.84244, 0.03728, 12, 36, 0, 0.25 },
	{ 0.09552, 0.84244, 0.03691, 12, 36, 24, 0.25 },
	{ 0.09552, 0.84244, 0.03594, 12, 36, 48, 0.25 },
	{ 0.09552, 0.84244, 0.03467, 12, 36, 72, 0.25 },
	{ 0.09552, 0.84244, 0.03344, 12, 36, 96, 0.25 },
	{ 0.09552, 0.84244, 0.03246, 12, 36, 120, 0.25 },
	{ 0.09552, 0.84244, 0.03181, 12, 36, 144, 0.25 },
	{ 0.09552, 0.84244, 0.0315, 12, 36, 168, 0.25 },
	{ 0.09552, 0.84244, 0.03146, 12, 36, 180, 0.25 },
	{ 0.09552, 0.82028, 0.04119, 12, 48, 0, 0.25 },
	{ 0.09552, 0.82028, 0.0408, 12, 48, 24, 0.25 },
	{ 0.09552, 0.82028, 0.0398, 12, 48, 48, 0.25 },
	{ 0.09552, 0.82028, 0.03857, 12, 48, 72, 0.25 },
	{ 0.09552, 0.82028, 0.03746, 12, 48, 96, 0.25 },
	{ 0.09552, 0.82028, 0.03668, 12, 48, 120, 0.25 },
	{ 0.09552, 0.82028, 0.03625, 12, 48, 144, 0.25 },
	{ 0.09552, 0.82028, 0.03608, 12, 48, 168, 0.25 },
	{ 0.09552, 0.82028, 0.03606, 12, 48, 180, 0.25 },
	{ 0.09552, 0.77769, 0.0499, 12, 60, 0, 0.25 },
	{ 0.09552, 0.77769, 0.04955, 12, 60, 24, 0.25 },
	{ 0.09552, 0.77769, 0.0487, 12, 60, 48, 0.25 },
	{ 0.09552, 0.77769, 0.04775, 12, 60, 72, 0.25 },
	{ 0.09552, 0.77769, 0.04712, 12, 60, 96, 0.25 },
	{ 0.09552, 0.77769, 0.04696, 12, 60, 120, 0.25 },
	{ 0.09552, 0.77769, 0.04715, 12, 60, 144, 0.25 },
	{ 0.09552, 0.77769, 0.04738, 12, 60, 168, 0.25 },
	{ 0.09552, 0.77769, 0.04742, 12, 60, 180, 0.25 },
	{ 0.09552, 0.74133, 0.05793, 12, 66, 0, 0.25 },
	{ 0.09552, 0.74133, 0.05763, 12, 66, 24, 0.25 },
	{ 0.09552, 0.74133, 0.05693, 12, 66, 48, 0.25 },
	{ 0.09552, 0.74133, 0.05629, 12, 66, 72, 0.25 },
	{ 0.09552, 0.74133, 0.05616, 12, 66, 96, 0.25 },
	{ 0.09552, 0.74133, 0.05665, 12, 66, 120, 0.25 },
	{ 0.09552, 0.74133, 0.05746, 12, 66, 144, 0.25 },
	{ 0.09552, 0.74133, 0.05809, 12, 66, 168, 0.25 },
	{ 0.09552, 0.74133, 0.05817, 12, 66, 180, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 0, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 24, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 48, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 72, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 96, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 120, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 144, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 168, 0.25 },
	{ 0.09552, 0.85626, 0.03224, 24, 0, 180, 0.25 },
	{ 0.09552, 0.85443, 0.03559, 24, 12, 0, 0.25 },
	{ 0.09552, 0.85443, 0.03509, 24, 12, 24, 0.25 },
	{ 0.09552, 0.85443, 0.0342, 24, 12, 48, 0.25 },
	{ 0.09552, 0.85443, 0.03317, 24, 12, 72, 0.25 },
	{ 0.09552, 0.85443, 0.03212, 24, 12, 96, 0.25 },
	{ 0.09552, 0.85443, 0.03121, 24, 12, 120, 0.25 },
	{ 0.09552, 0.85443, 0.03058, 24, 12, 144, 0.25 },
	{ 0.09552, 0.85443, 0.03025, 24, 12, 168, 0.25 },
	{ 0.09552, 0.85443, 0.03021, 24, 12, 180, 0.25 },
	{ 0.09552, 0.84844, 0.04205, 24, 24, 0, 0.25 },
	{ 0.09552, 0.84844, 0.03897, 24, 24, 24, 0.25 },
	{ 0.09552, 0.84844, 0.0365, 24, 24, 48, 0.25 },
	{ 0.09552, 0.84844, 0.03448, 24, 24, 72, 0.25 },
	{ 0.09552, 0.84844, 0.0326, 24, 24, 96, 0.25 },
	{ 0.09552, 0.84844, 0.03119, 24, 24, 120, 0.25 },
	{ 0.09552, 0.84844, 0.03031, 24, 24, 144, 0.25 },
	{ 0.09552, 0.84844, 0.02991, 24, 24, 168, 0.25 },
	{ 0.09552, 0.84844, 0.02986, 24, 24, 180, 0.25 },
	{ 0.09552, 0.83654, 0.04315, 24, 36, 0, 0.25 },
	{ 0.09552, 0.83654, 0.04182, 24, 36, 24, 0.25 },
	{ 0.09552, 0.83654, 0.03949, 24, 36, 48, 0.25 },
	{ 0.09552, 0.83654, 0.03678, 24, 36, 72, 0.25 },
	{ 0.09552, 0.83654, 0.03456, 24, 36, 96, 0.25 },
	{ 0.09552, 0.83654, 0.03312, 24, 36, 120, 0.25 },
	{ 0.09552, 0.83654, 0.03241, 24, 36, 144, 0.25 },
	{ 0.09552, 0.83654, 0.03216, 24, 36, 168, 0.25 },
	{ 0.09552, 0.83654, 0.03214, 24, 36, 180, 0.25 },
	{ 0.09552, 0.81453, 0.04828, 24, 48, 0, 0.25 },
	{ 0.09552, 0.81453, 0.04715, 24, 48, 24, 0.25 },
	{ 0.09552, 0.81453, 0.04443, 24, 48, 48, 0.25 },
	{ 0.09552, 0.81453, 0.04153, 24, 48, 72, 0.25 },
	{ 0.09552, 0.81453, 0.03948, 24, 48, 96, 0.25 },
	{ 0.09552, 0.81453, 0.03861, 24, 48, 120, 0.25 },
	{ 0.09552, 0.81453, 0.03865, 24, 48, 144, 0.25 },
	{ 0.09552, 0.81453, 0.03895, 24, 48, 168, 0.25 },
	{ 0.09552, 0.81453, 0.03901, 24, 48, 180, 0.25 },
	{ 0.09552, 0.77224, 0.05831, 24, 60, 0, 0.25 },
	{ 0.09552, 0.77224, 0.0571, 24, 60, 24, 0.25 },
	{ 0.09552, 0.77224, 0.05434, 24, 60, 48, 0.25 },
	{ 0.09552, 0.77224, 0.05172, 24, 60, 72, 0.25 },
	{ 0.09552, 0.77224, 0.05059, 24, 60, 96, 0.25 },
	{ 0.09552, 0.77224, 0.05139, 24, 60, 120, 0.25 },
	{ 0.09552, 0.77224, 0.05342, 24, 60, 144, 0.25 },
	{ 0.09552, 0.77224, 0.05512, 24, 60, 168, 0.25 },
	{ 0.09552, 0.77224, 0.05537, 24, 60, 180, 0.25 },
	{ 0.09552, 0.73613, 0.06707, 24, 66, 0, 0.25 },
	{ 0.09552, 0.73613, 0.06587, 24, 66, 24, 0.25 },
	{ 0.09552, 0.73613, 0.06317, 24, 66, 48, 0.25 },
	{ 0.09552, 0.73613, 0.06092, 24, 66, 72, 0.25 },
	{ 0.09552, 0.73613, 0.06078, 24, 66, 96, 0.25 },
	{ 0.09552, 0.73613, 0.06325, 24, 66, 120, 0.25 },
	{ 0.09552, 0.73613, 0.06724, 24, 66, 144, 0.25 },
	{ 0.09552, 0.73613, 0.07032, 24, 66, 168, 0.25 },
	{ 0.09552, 0.73613, 0.07077, 24, 66, 180, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 0, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 24, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 48, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 72, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 96, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 120, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 144, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 168, 0.25 },
	{ 0.09552, 0.84425, 0.03337, 36, 0, 180, 0.25 },
	{ 0.09552, 0.84244, 0.03729, 36, 12, 0, 0.25 },
	{ 0.09552, 0.84244, 0.03692, 36, 12, 24, 0.25 },
	{ 0.09552, 0.84244, 0.03595, 36, 12, 48, 0.25 },
	{ 0.09552, 0.84244, 0.03467, 36, 12, 72, 0.25 },
	{ 0.09552, 0.84244, 0.03344, 36, 12, 96, 0.25 },
	{ 0.09552, 0.84244, 0.03246, 36, 12, 120, 0.25 },
	{ 0.09552, 0.84244, 0.03181, 36, 12, 144, 0.25 },
	{ 0.09552, 0.84244, 0.03149, 36, 12, 168, 0.25 },
	{ 0.09552, 0.84244, 0.03146, 36, 12, 180, 0.25 },
	{ 0.09552, 0.83654, 0.04315, 36, 24, 0, 0.25 },
	{ 0.09552, 0.83654, 0.04182, 36, 24, 24, 0.25 },
	{ 0.09552, 0.83654, 0.03949, 36, 24, 48, 0.25 },
	{ 0.09552, 0.83654, 0.03679, 36, 24, 72, 0.25 },
	{ 0.09552, 0.83654, 0.03456, 36, 24, 96, 0.25 },
	{ 0.09552, 0.83654, 0.03312, 36, 24, 120, 0.25 },
	{ 0.09552, 0.83654, 0.0324, 36, 24, 144, 0.25 },
	{ 0.09552, 0.83654, 0.03216, 36, 24, 168, 0.25 },
	{ 0.09552, 0.83654, 0.03213, 36, 24, 180, 0.25 },
	{ 0.09552, 0.8248, 0.05364, 36, 36, 0, 0.25 },
	{ 0.09552, 0.8248, 0.04811, 36, 36, 24, 0.25 },
	{ 0.09552, 0.8248, 0.0442, 36, 36, 48, 0.25 },
	{ 0.09552, 0.8248, 0.04026, 36, 36, 72, 0.25 },
	{ 0.09552, 0.8248, 0.03754, 36, 36, 96, 0.25 },
	{ 0.09552, 0.8248, 0.03635, 36, 36, 120, 0.25 },
	{ 0.09552, 0.8248, 0.03629, 36, 36, 144, 0.25 },
	{ 0.09552, 0.8248, 0.03661, 36, 36, 168, 0.25 },
	{ 0.09552, 0.8248, 0.03667, 36, 36, 180, 0.25 },
	{ 0.09552, 0.8031, 0.05891, 36, 48, 0, 0.25 },
	{ 0.09552, 0.8031, 0.05616, 36, 48, 24, 0.25 },
	{ 0.09552, 0.8031, 0.05118, 36, 48, 48, 0.25 },
	{ 0.09552, 0.8031, 0.04652, 36, 48, 72, 0.25 },
	{ 0.09552, 0.8031, 0.04404, 36, 48, 96, 0.25 },
	{ 0.09552, 0.8031, 0.04417, 36, 48, 120, 0.25 },
	{ 0.09552, 0.8031, 0.04609, 36, 48, 144, 0.25 },
	{ 0.09552, 0.8031, 0.04791, 36, 48, 168, 0.25 },
	{ 0.09552, 0.8031, 0.04819, 36, 48, 180, 0.25 },
	{ 0.09552, 0.7614, 0.07215, 36, 60, 0, 0.25 },
	{ 0.09552, 0.7614, 0.06945, 36, 60, 24, 0.25 },
	{ 0.09552, 0.7614, 0.06361, 36, 60, 48, 0.25 },
	{ 0.09552, 0.7614, 0.05882, 36, 60, 72, 0.25 },
	{ 0.09552, 0.7614, 0.05777, 36, 60, 96, 0.25 },
	{ 0.09552, 0.7614, 0.06141, 36, 60, 120, 0.25 },
	{ 0.09552, 0.7614, 0.06813, 36, 60, 144, 0.25 },
	{ 0.09552, 0.7614, 0.07366, 36, 60, 168, 0.25 },
	{ 0.09552, 0.7614, 0.07449, 36, 60, 180, 0.25 },
	{ 0.09552, 0.72581, 0.08324, 36, 66, 0, 0.25 },
	{ 0.09552, 0.72581, 0.0803, 36, 66, 24, 0.25 },
	{ 0.09552, 0.72581, 0.07414, 36, 66, 48, 0.25 },
	{ 0.09552, 0.72581, 0.06954, 36, 66, 72, 0.25 },
	{ 0.09552, 0.72581, 0.07004, 36, 66, 96, 0.25 },
	{ 0.09552, 0.72581, 0.07706, 36, 66, 120, 0.25 },
	{ 0.09552, 0.72581, 0.08842, 36, 66, 144, 0.25 },
	{ 0.09552, 0.72581, 0.09763, 36, 66, 168, 0.25 },
	{ 0.09552, 0.72581, 0.09901, 36, 66, 180, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 0, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 24, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 48, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 72, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 96, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 120, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 144, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 168, 0.25 },
	{ 0.09552, 0.82204, 0.03706, 48, 0, 180, 0.25 },
	{ 0.09552, 0.82028, 0.0412, 48, 12, 0, 0.25 },
	{ 0.09552, 0.82028, 0.04081, 48, 12, 24, 0.25 },
	{ 0.09552, 0.82028, 0.03981, 48, 12, 48, 0.25 },
	{ 0.09552, 0.82028, 0.03857, 48, 12, 72, 0.25 },
	{ 0.09552, 0.82028, 0.03746, 48, 12, 96, 0.25 },
	{ 0.09552, 0.82028, 0.03667, 48, 12, 120, 0.25 },
	{ 0.09552, 0.82028, 0.03624, 48, 12, 144, 0.25 },
	{ 0.09552, 0.82028, 0.03607, 48, 12, 168, 0.25 },
	{ 0.09552, 0.82028, 0.03605, 48, 12, 180, 0.25 },
	{ 0.09552, 0.81453, 0.04829, 48, 24, 0, 0.25 },
	{ 0.09552, 0.81453, 0.04716, 48, 24, 24, 0.25 },
	{ 0.09552, 0.81453, 0.04444, 48, 24, 48, 0.25 },
	{ 0.09552, 0.81453, 0.04153, 48, 24, 72, 0.25 },
	{ 0.09552, 0.81453, 0.03948, 48, 24, 96, 0.25 },
	{ 0.09552, 0.81453, 0.03861, 48, 24, 120, 0.25 },
	{ 0.09552, 0.81453, 0.03865, 48, 24, 144, 0.25 },
	{ 0.09552, 0.81453, 0.03895, 48, 24, 168, 0.25 },
	{ 0.09552, 0.81453, 0.039, 48, 24, 180, 0.25 },
	{ 0.09552, 0.8031, 0.05891, 48, 36, 0, 0.25 },
	{ 0.09552, 0.8031, 0.05616, 48, 36, 24, 0.25 },
	{ 0.09552, 0.8031, 0.05118, 48, 36, 48, 0.25 },
	{ 0.09552, 0.8031, 0.04652, 48, 36, 72, 0.25 },
	{ 0.09552, 0.8031, 0.04404, 48, 36, 96, 0.25 },
	{ 0.09552, 0.8031, 0.04417, 48, 36, 120, 0.25 },
	{ 0.09552, 0.8031, 0.04609, 48, 36, 144, 0.25 },
	{ 0.09552, 0.8031, 0.04791, 48, 36, 168, 0.25 },
	{ 0.09552, 0.8031, 0.04819, 48, 36, 180, 0.25 },
	{ 0.09552, 0.78197, 0.07787, 48, 48, 0, 0.25 },
	{ 0.09552, 0.78197, 0.06875, 48, 48, 24, 0.25 },
	{ 0.09552, 0.78197, 0.06125, 48, 48, 48, 0.25 },
	{ 0.09552, 0.78197, 0.05508, 48, 48, 72, 0.25 },
	{ 0.09552, 0.78197, 0.0531, 48, 48, 96, 0.25 },
	{ 0.09552, 0.78197, 0.05615, 48, 48, 120, 0.25 },
	{ 0.09552, 0.78197, 0.06265, 48, 48, 144, 0.25 },
	{ 0.09552, 0.78197, 0.0682, 48, 48, 168, 0.25 },
	{ 0.09552, 0.78197, 0.06904, 48, 48, 180, 0.25 },
	{ 0.09552, 0.74137, 0.09393, 48, 60, 0, 0.25 },
	{ 0.09552, 0.74137, 0.08824, 48, 60, 24, 0.25 },
	{ 0.09552, 0.74137, 0.07824, 48, 60, 48, 0.25 },
	{ 0.09552, 0.74137, 0.07103, 48, 60, 72, 0.25 },
	{ 0.09552, 0.74137, 0.0713, 48, 60, 96, 0.25 },
	{ 0.09552, 0.74137, 0.08119, 48, 60, 120, 0.25 },
	{ 0.09552, 0.74137, 0.09833, 48, 60, 144, 0.25 },
	{ 0.09552, 0.74137, 0.11299, 48, 60, 168, 0.25 },
	{ 0.09552, 0.74137, 0.11525, 48, 60, 180, 0.25 },
	{ 0.09552, 0.70671, 0.10905, 48, 66, 0, 0.25 },
	{ 0.09552, 0.70671, 0.10339, 48, 66, 24, 0.25 },
	{ 0.09552, 0.70671, 0.09207, 48, 66, 48, 0.25 },
	{ 0.09552, 0.70671, 0.08455, 48, 66, 72, 0.25 },
	{ 0.09552, 0.70671, 0.08713, 48, 66, 96, 0.25 },
	{ 0.09552, 0.70671, 0.10336, 48, 66, 120, 0.25 },
	{ 0.09552, 0.70671, 0.13062, 48, 66, 144, 0.25 },
	{ 0.09552, 0.70671, 0.15444, 48, 66, 168, 0.25 },
	{ 0.09552, 0.70671, 0.15818, 48, 66, 180, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 0, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 24, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 48, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 72, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 96, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 120, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 144, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 168, 0.25 },
	{ 0.09552, 0.77936, 0.04619, 60, 0, 180, 0.25 },
	{ 0.09552, 0.77769, 0.04991, 60, 12, 0, 0.25 },
	{ 0.09552, 0.77769, 0.04956, 60, 12, 24, 0.25 },
	{ 0.09552, 0.77769, 0.0487, 60, 12, 48, 0.25 },
	{ 0.09552, 0.77769, 0.04776, 60, 12, 72, 0.25 },
	{ 0.09552, 0.77769, 0.04712, 60, 12, 96, 0.25 },
	{ 0.09552, 0.77769, 0.04697, 60, 12, 120, 0.25 },
	{ 0.09552, 0.77769, 0.04715, 60, 12, 144, 0.25 },
	{ 0.09552, 0.77769, 0.04738, 60, 12, 168, 0.25 },
	{ 0.09552, 0.77769, 0.04742, 60, 12, 180, 0.25 },
	{ 0.09552, 0.77224, 0.05832, 60, 24, 0, 0.25 },
	{ 0.09552, 0.77224, 0.05711, 60, 24, 24, 0.25 },
	{ 0.09552, 0.77224, 0.05435, 60, 24, 48, 0.25 },
	{ 0.09552, 0.77224, 0.05172, 60, 24, 72, 0.25 },
	{ 0.09552, 0.77224, 0.05059, 60, 24, 96, 0.25 },
	{ 0.09552, 0.77224, 0.05139, 60, 24, 120, 0.25 },
	{ 0.09552, 0.77224, 0.05342, 60, 24, 144, 0.25 },
	{ 0.09552, 0.77224, 0.05512, 60, 24, 168, 0.25 },
	{ 0.09552, 0.77224, 0.05537, 60, 24, 180, 0.25 },
	{ 0.09552, 0.7614, 0.07216, 60, 36, 0, 0.25 },
	{ 0.09552, 0.7614, 0.06945, 60, 36, 24, 0.25 },
	{ 0.09552, 0.7614, 0.06362, 60, 36, 48, 0.25 },
	{ 0.09552, 0.7614, 0.05882, 60, 36, 72, 0.25 },
	{ 0.09552, 0.7614, 0.05778, 60, 36, 96, 0.25 },
	{ 0.09552, 0.7614, 0.0614, 60, 36, 120, 0.25 },
	{ 0.09552, 0.7614, 0.06813, 60, 36, 144, 0.25 },
	{ 0.09552, 0.7614, 0.07366, 60, 36, 168, 0.25 },
	{ 0.09552, 0.7614, 0.07449, 60, 36, 180, 0.25 },
	{ 0.09552, 0.74137, 0.09393, 60, 48, 0, 0.25 },
	{ 0.09552, 0.74137, 0.08824, 60, 48, 24, 0.25 },
	{ 0.09552, 0.74137, 0.07824, 60, 48, 48, 0.25 },
	{ 0.09552, 0.74137, 0.07104, 60, 48, 72, 0.25 },
	{ 0.09552, 0.74137, 0.0713, 60, 48, 96, 0.25 },
	{ 0.09552, 0.74137, 0.08119, 60, 48, 120, 0.25 },
	{ 0.09552, 0.74137, 0.09833, 60, 48, 144, 0.25 },
	{ 0.09552, 0.74137, 0.11299, 60, 48, 168, 0.25 },
	{ 0.09552, 0.74137, 0.11525, 60, 48, 180, 0.25 },
	{ 0.09552, 0.70288, 0.13492, 60, 60, 0, 0.25 },
	{ 0.09552, 0.70288, 0.11824, 60, 60, 24, 0.25 },
	{ 0.09552, 0.70288, 0.10298, 60, 60, 48, 0.25 },
	{ 0.09552, 0.70288, 0.09334, 60, 60, 72, 0.25 },
	{ 0.09552, 0.70288, 0.09737, 60, 60, 96, 0.25 },
	{ 0.09552, 0.70288, 0.12048, 60, 60, 120, 0.25 },
	{ 0.09552, 0.70288, 0.16098, 60, 60, 144, 0.25 },
	{ 0.09552, 0.70288, 0.19849, 60, 60, 168, 0.25 },
	{ 0.09552, 0.70288, 0.20455, 60, 60, 180, 0.25 },
	{ 0.09552, 0.67002, 0.15734, 60, 66, 0, 0.25 },
	{ 0.09552, 0.67002, 0.14133, 60, 66, 24, 0.25 },
	{ 0.09552, 0.67002, 0.12285, 60, 66, 48, 0.25 },
	{ 0.09552, 0.67002, 0.11192, 60, 66, 72, 0.25 },
	{ 0.09552, 0.67002, 0.11953, 60, 66, 96, 0.25 },
	{ 0.09552, 0.67002, 0.15431, 60, 66, 120, 0.25 },
	{ 0.09552, 0.67002, 0.2167, 60, 66, 144, 0.25 },
	{ 0.09552, 0.67002, 0.27776, 60, 66, 168, 0.25 },
	{ 0.09552, 0.67002, 0.28795, 60, 66, 180, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 0, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 24, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 48, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 72, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 96, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 120, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 144, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 168, 0.25 },
	{ 0.09552, 0.68749, 0.06857, 72, 0, 180, 0.25 },
	{ 0.09552, 0.68601, 0.07072, 72, 12, 0, 0.25 },
	{ 0.09552, 0.68601, 0.07049, 72, 12, 24, 0.25 },
	{ 0.09552, 0.68601, 0.07004, 72, 12, 48, 0.25 },
	{ 0.09552, 0.68601, 0.06993, 72, 12, 72, 0.25 },
	{ 0.09552, 0.68601, 0.07062, 72, 12, 96, 0.25 },
	{ 0.09552, 0.68601, 0.07216, 72, 12, 120, 0.25 },
	{ 0.09552, 0.68601, 0.07401, 72, 12, 144, 0.25 },
	{ 0.09552, 0.68601, 0.07529, 72, 12, 168, 0.25 },
	{ 0.09552, 0.68601, 0.07546, 72, 12, 180, 0.25 },
	{ 0.09552, 0.68121, 0.08082, 72, 24, 0, 0.25 },
	{ 0.09552, 0.68121, 0.0796, 72, 24, 24, 0.25 },
	{ 0.09552, 0.68121, 0.07702, 72, 24, 48, 0.25 },
	{ 0.09552, 0.68121, 0.07542, 72, 24, 72, 0.25 },
	{ 0.09552, 0.68121, 0.0769, 72, 24, 96, 0.25 },
	{ 0.09552, 0.68121, 0.08211, 72, 24, 120, 0.25 },
	{ 0.09552, 0.68121, 0.08932, 72, 24, 144, 0.25 },
	{ 0.09552, 0.68121, 0.09468, 72, 24, 168, 0.25 },
	{ 0.09552, 0.68121, 0.09546, 72, 24, 180, 0.25 },
	{ 0.09552, 0.67165, 0.1001, 72, 36, 0, 0.25 },
	{ 0.09552, 0.67165, 0.09691, 72, 36, 24, 0.25 },
	{ 0.09552, 0.67165, 0.09036, 72, 36, 48, 0.25 },
	{ 0.09552, 0.67165, 0.08617, 72, 36, 72, 0.25 },
	{ 0.09552, 0.67165, 0.0892, 72, 36, 96, 0.25 },
	{ 0.09552, 0.67165, 0.10165, 72, 36, 120, 0.25 },
	{ 0.09552, 0.67165, 0.1206, 72, 36, 144, 0.25 },
	{ 0.09552, 0.67165, 0.13594, 72, 36, 168, 0.25 },
	{ 0.09552, 0.67165, 0.13825, 72, 36, 180, 0.25 },
	{ 0.09552, 0.65398, 0.13246, 72, 48, 0, 0.25 },
	{ 0.09552, 0.65398, 0.12589, 72, 48, 24, 0.25 },
	{ 0.09552, 0.65398, 0.11295, 72, 48, 48, 0.25 },
	{ 0.09552, 0.65398, 0.10519, 72, 48, 72, 0.25 },
	{ 0.09552, 0.65398, 0.11148, 72, 48, 96, 0.25 },
	{ 0.09552, 0.65398, 0.13765, 72, 48, 120, 0.25 },
	{ 0.09552, 0.65398, 0.18134, 72, 48, 144, 0.25 },
	{ 0.09552, 0.65398, 0.22075, 72, 48, 168, 0.25 },
	{ 0.09552, 0.65398, 0.22705, 72, 48, 180, 0.25 },
	{ 0.09552, 0.62002, 0.18841, 72, 60, 0, 0.25 },
	{ 0.09552, 0.62002, 0.17512, 72, 60, 24, 0.25 },
	{ 0.09552, 0.62002, 0.15253, 72, 60, 48, 0.25 },
	{ 0.09552, 0.62002, 0.14007, 72, 60, 72, 0.25 },
	{ 0.09552, 0.62002, 0.15315, 72, 60, 96, 0.25 },
	{ 0.09552, 0.62002, 0.20576, 72, 60, 120, 0.25 },
	{ 0.09552, 0.62002, 0.30322, 72, 60, 144, 0.25 },
	{ 0.09552, 0.62002, 0.40487, 72, 60, 168, 0.25 },
	{ 0.09552, 0.62002, 0.42262, 72, 60, 180, 0.25 },
	{ 0.09552, 0.59103, 0.23854, 72, 66, 0, 0.25 },
	{ 0.09552, 0.59103, 0.21395, 72, 66, 24, 0.25 },
	{ 0.09552, 0.59103, 0.18463, 72, 66, 48, 0.25 },
	{ 0.09552, 0.59103, 0.16909, 72, 66, 72, 0.25 },
	{ 0.09552, 0.59103, 0.18801, 72, 66, 96, 0.25 },
	{ 0.09552, 0.59103, 0.26279, 72, 66, 120, 0.25 },
	{ 0.09552, 0.59103, 0.40939, 72, 66, 144, 0.25 },
	{ 0.09552, 0.59103, 0.57651, 72, 66, 168, 0.25 },
	{ 0.09552, 0.59103, 0.60748, 72, 66, 180, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 0, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 24, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 48, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 72, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 96, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 120, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 144, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 168, 0.25 },
	{ 0.09552, 0.45719, 0.13271, 84, 0, 180, 0.25 },
	{ 0.09552, 0.45621, 0.13117, 84, 12, 0, 0.25 },
	{ 0.09552, 0.45621, 0.13118, 84, 12, 24, 0.25 },
	{ 0.09552, 0.45621, 0.1316, 84, 12, 48, 0.25 },
	{ 0.09552, 0.45621, 0.13343, 84, 12, 72, 0.25 },
	{ 0.09552, 0.45621, 0.13742, 84, 12, 96, 0.25 },
	{ 0.09552, 0.45621, 0.14334, 84, 12, 120, 0.25 },
	{ 0.09552, 0.45621, 0.14958, 84, 12, 144, 0.25 },
	{ 0.09552, 0.45621, 0.15366, 84, 12, 168, 0.25 },
	{ 0.09552, 0.45621, 0.15423, 84, 12, 180, 0.25 },
	{ 0.09552, 0.45301, 0.14657, 84, 24, 0, 0.25 },
	{ 0.09552, 0.45301, 0.14501, 84, 24, 24, 0.25 },
	{ 0.09552, 0.45301, 0.14222, 84, 24, 48, 0.25 },
	{ 0.09552, 0.45301, 0.14258, 84, 24, 72, 0.25 },
	{ 0.09552, 0.45301, 0.15034, 84, 24, 96, 0.25 },
	{ 0.09552, 0.45301, 0.16683, 84, 24, 120, 0.25 },
	{ 0.09552, 0.45301, 0.18782, 84, 24, 144, 0.25 },
	{ 0.09552, 0.45301, 0.20327, 84, 24, 168, 0.25 },
	{ 0.09552, 0.45301, 0.20551, 84, 24, 180, 0.25 },
	{ 0.09552, 0.44666, 0.18076, 84, 36, 0, 0.25 },
	{ 0.09552, 0.44666, 0.176, 84, 36, 24, 0.25 },
	{ 0.09552, 0.44666, 0.16637, 84, 36, 48, 0.25 },
	{ 0.09552, 0.44666, 0.16242, 84, 36, 72, 0.25 },
	{ 0.09552, 0.44666, 0.17471, 84, 36, 96, 0.25 },
	{ 0.09552, 0.44666, 0.20919, 84, 36, 120, 0.25 },
	{ 0.09552, 0.44666, 0.26056, 84, 36, 144, 0.25 },
	{ 0.09552, 0.44666, 0.30356, 84, 36, 168, 0.25 },
	{ 0.09552, 0.44666, 0.31019, 84, 36, 180, 0.25 },
	{ 0.09552, 0.43491, 0.24222, 84, 48, 0, 0.25 },
	{ 0.09552, 0.43491, 0.23166, 84, 48, 24, 0.25 },
	{ 0.09552, 0.43491, 0.21038, 84, 48, 48, 0.25 },
	{ 0.09552, 0.43491, 0.19907, 84, 48, 72, 0.25 },
	{ 0.09552, 0.43491, 0.21803, 84, 48, 96, 0.25 },
	{ 0.09552, 0.43491, 0.28314, 84, 48, 120, 0.25 },
	{ 0.09552, 0.43491, 0.39614, 84, 48, 144, 0.25 },
	{ 0.09552, 0.43491, 0.50744, 84, 48, 168, 0.25 },
	{ 0.09552, 0.43491, 0.52633, 84, 48, 180, 0.25 },
	{ 0.09552, 0.41233, 0.35357, 84, 60, 0, 0.25 },
	{ 0.09552, 0.41233, 0.3326, 84, 60, 24, 0.25 },
	{ 0.09552, 0.41233, 0.29138, 84, 60, 48, 0.25 },
	{ 0.09552, 0.41233, 0.26818, 84, 60, 72, 0.25 },
	{ 0.09552, 0.41233, 0.29857, 84, 60, 96, 0.25 },
	{ 0.09552, 0.41233, 0.41815, 84, 60, 120, 0.25 },
	{ 0.09552, 0.41233, 0.65919, 84, 60, 144, 0.25 },
	{ 0.09552, 0.41233, 0.9534, 84, 60, 168, 0.25 },
	{ 0.09552, 0.41233, 1.01076, 84, 60, 180, 0.25 },
	{ 0.09552, 0.39305, 0.44529, 84, 66, 0, 0.25 },
	{ 0.09552, 0.39305, 0.41614, 84, 66, 24, 0.25 },
	{ 0.09552, 0.39305, 0.35931, 84, 66, 48, 0.25 },
	{ 0.09552, 0.39305, 0.32704, 84, 66, 72, 0.25 },
	{ 0.09552, 0.39305, 0.36656, 84, 66, 96, 0.25 },
	{ 0.09552, 0.39305, 0.52995, 84, 66, 120, 0.25 },
	{ 0.09552, 0.39305, 0.88372, 84, 66, 144, 0.25 },
	{ 0.09552, 0.39305, 1.37344, 84, 66, 168, 0.25 },
	{ 0.09552, 0.39305, 1.47917, 84, 66, 180, 0.25 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 0, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 24, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 48, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 72, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 96, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 120, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 144, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 168, 0.5 },
	{ 0.13023, 0.7809, 0.05023, 0, 0, 180, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 0, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 24, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 48, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 72, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 96, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 120, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 144, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 168, 0.5 },
	{ 0.13023, 0.77795, 0.046, 0, 12, 180, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 0, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 24, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 48, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 72, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 96, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 120, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 144, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 168, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 0, 24, 180, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 0, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 24, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 48, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 72, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 96, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 120, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 144, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 168, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 0, 36, 180, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 0, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 24, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 48, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 72, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 96, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 120, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 144, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 168, 0.5 },
	{ 0.13023, 0.71592, 0.05422, 0, 48, 180, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 0, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 24, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 48, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 72, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 96, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 120, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 144, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 168, 0.5 },
	{ 0.13023, 0.65507, 0.06817, 0, 60, 180, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 0, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 24, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 48, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 72, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 96, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 120, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 144, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 168, 0.5 },
	{ 0.13023, 0.60701, 0.08009, 0, 66, 180, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 0, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 24, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 48, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 72, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 96, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 120, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 144, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 168, 0.5 },
	{ 0.13023, 0.77795, 0.046, 12, 0, 180, 0.5 },
	{ 0.13023, 0.77501, 0.05242, 12, 12, 0, 0.5 },
	{ 0.13023, 0.77501, 0.05097, 12, 12, 24, 0.5 },
	{ 0.13023, 0.77501, 0.04809, 12, 12, 48, 0.5 },
	{ 0.13023, 0.77501, 0.04627, 12, 12, 72, 0.5 },
	{ 0.13023, 0.77501, 0.0453, 12, 12, 96, 0.5 },
	{ 0.13023, 0.77501, 0.0446, 12, 12, 120, 0.5 },
	{ 0.13023, 0.77501, 0.04409, 12, 12, 144, 0.5 },
	{ 0.13023, 0.77501, 0.04383, 12, 12, 168, 0.5 },
	{ 0.13023, 0.77501, 0.0438, 12, 12, 180, 0.5 },
	{ 0.13023, 0.76546, 0.05031, 12, 24, 0, 0.5 },
	{ 0.13023, 0.76546, 0.04959, 12, 24, 24, 0.5 },
	{ 0.13023, 0.76546, 0.04839, 12, 24, 48, 0.5 },
	{ 0.13023, 0.76546, 0.04708, 12, 24, 72, 0.5 },
	{ 0.13023, 0.76546, 0.04579, 12, 24, 96, 0.5 },
	{ 0.13023, 0.76546, 0.04471, 12, 24, 120, 0.5 },
	{ 0.13023, 0.76546, 0.04399, 12, 24, 144, 0.5 },
	{ 0.13023, 0.76546, 0.04363, 12, 24, 168, 0.5 },
	{ 0.13023, 0.76546, 0.04359, 12, 24, 180, 0.5 },
	{ 0.13023, 0.74675, 0.05279, 12, 36, 0, 0.5 },
	{ 0.13023, 0.74675, 0.05234, 12, 36, 24, 0.5 },
	{ 0.13023, 0.74675, 0.05116, 12, 36, 48, 0.5 },
	{ 0.13023, 0.74675, 0.04968, 12, 36, 72, 0.5 },
	{ 0.13023, 0.74675, 0.04833, 12, 36, 96, 0.5 },
	{ 0.13023, 0.74675, 0.04736, 12, 36, 120, 0.5 },
	{ 0.13023, 0.74675, 0.04678, 12, 36, 144, 0.5 },
	{ 0.13023, 0.74675, 0.04653, 12, 36, 168, 0.5 },
	{ 0.13023, 0.74675, 0.0465, 12, 36, 180, 0.5 },
	{ 0.13023, 0.71321, 0.05868, 12, 48, 0, 0.5 },
	{ 0.13023, 0.71321, 0.05826, 12, 48, 24, 0.5 },
	{ 0.13023, 0.71321, 0.05722, 12, 48, 48, 0.5 },
	{ 0.13023, 0.71321, 0.05605, 12, 48, 72, 0.5 },
	{ 0.13023, 0.71321, 0.05518, 12, 48, 96, 0.5 },
	{ 0.13023, 0.71321, 0.05477, 12, 48, 120, 0.5 },
	{ 0.13023, 0.71321, 0.05472, 12, 48, 144, 0.5 },
	{ 0.13023, 0.71321, 0.05479, 12, 48, 168, 0.5 },
	{ 0.13023, 0.71321, 0.05481, 12, 48, 180, 0.5 },
	{ 0.13023, 0.65259, 0.07111, 12, 60, 0, 0.5 },
	{ 0.13023, 0.65259, 0.07084, 12, 60, 24, 0.5 },
	{ 0.13023, 0.65259, 0.07025, 12, 60, 48, 0.5 },
	{ 0.13023, 0.65259, 0.06985, 12, 60, 72, 0.5 },
	{ 0.13023, 0.65259, 0.07004, 12, 60, 96, 0.5 },
	{ 0.13023, 0.65259, 0.07088, 12, 60, 120, 0.5 },
	{ 0.13023, 0.65259, 0.07199, 12, 60, 144, 0.5 },
	{ 0.13023, 0.65259, 0.07279, 12, 60, 168, 0.5 },
	{ 0.13023, 0.65259, 0.0729, 12, 60, 180, 0.5 },
	{ 0.13023, 0.60471, 0.08168, 12, 66, 0, 0.5 },
	{ 0.13023, 0.60471, 0.08153, 12, 66, 24, 0.5 },
	{ 0.13023, 0.60471, 0.0813, 12, 66, 48, 0.5 },
	{ 0.13023, 0.60471, 0.08153, 12, 66, 72, 0.5 },
	{ 0.13023, 0.60471, 0.08264, 12, 66, 96, 0.5 },
	{ 0.13023, 0.60471, 0.08458, 12, 66, 120, 0.5 },
	{ 0.13023, 0.60471, 0.08672, 12, 66, 144, 0.5 },
	{ 0.13023, 0.60471, 0.08816, 12, 66, 168, 0.5 },
	{ 0.13023, 0.60471, 0.08835, 12, 66, 180, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 0, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 24, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 48, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 72, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 96, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 120, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 144, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 168, 0.5 },
	{ 0.13023, 0.76836, 0.0458, 24, 0, 180, 0.5 },
	{ 0.13023, 0.76546, 0.05031, 24, 12, 0, 0.5 },
	{ 0.13023, 0.76546, 0.04959, 24, 12, 24, 0.5 },
	{ 0.13023, 0.76546, 0.04839, 24, 12, 48, 0.5 },
	{ 0.13023, 0.76546, 0.04708, 24, 12, 72, 0.5 },
	{ 0.13023, 0.76546, 0.04579, 24, 12, 96, 0.5 },
	{ 0.13023, 0.76546, 0.04471, 24, 12, 120, 0.5 },
	{ 0.13023, 0.76546, 0.04399, 24, 12, 144, 0.5 },
	{ 0.13023, 0.76546, 0.04363, 24, 12, 168, 0.5 },
	{ 0.13023, 0.76546, 0.04358, 24, 12, 180, 0.5 },
	{ 0.13023, 0.75602, 0.06005, 24, 24, 0, 0.5 },
	{ 0.13023, 0.75602, 0.05516, 24, 24, 24, 0.5 },
	{ 0.13023, 0.75602, 0.05164, 24, 24, 48, 0.5 },
	{ 0.13023, 0.75602, 0.04912, 24, 24, 72, 0.5 },
	{ 0.13023, 0.75602, 0.04692, 24, 24, 96, 0.5 },
	{ 0.13023, 0.75602, 0.04543, 24, 24, 120, 0.5 },
	{ 0.13023, 0.75602, 0.04462, 24, 24, 144, 0.5 },
	{ 0.13023, 0.75602, 0.04429, 24, 24, 168, 0.5 },
	{ 0.13023, 0.75602, 0.04425, 24, 24, 180, 0.5 },
	{ 0.13023, 0.73755, 0.06079, 24, 36, 0, 0.5 },
	{ 0.13023, 0.73755, 0.05893, 24, 36, 24, 0.5 },
	{ 0.13023, 0.73755, 0.05601, 24, 36, 48, 0.5 },
	{ 0.13023, 0.73755, 0.05285, 24, 36, 72, 0.5 },
	{ 0.13023, 0.73755, 0.05058, 24, 36, 96, 0.5 },
	{ 0.13023, 0.73755, 0.04949, 24, 36, 120, 0.5 },
	{ 0.13023, 0.73755, 0.04926, 24, 36, 144, 0.5 },
	{ 0.13023, 0.73755, 0.04935, 24, 36, 168, 0.5 },
	{ 0.13023, 0.73755, 0.04938, 24, 36, 180, 0.5 },
	{ 0.13023, 0.70442, 0.06776, 24, 48, 0, 0.5 },
	{ 0.13023, 0.70442, 0.0664, 24, 48, 24, 0.5 },
	{ 0.13023, 0.70442, 0.06326, 24, 48, 48, 0.5 },
	{ 0.13023, 0.70442, 0.06035, 24, 48, 72, 0.5 },
	{ 0.13023, 0.70442, 0.05895, 24, 48, 96, 0.5 },
	{ 0.13023, 0.70442, 0.05924, 24, 48, 120, 0.5 },
	{ 0.13023, 0.70442, 0.06055, 24, 48, 144, 0.5 },
	{ 0.13023, 0.70442, 0.0617, 24, 48, 168, 0.5 },
	{ 0.13023, 0.70442, 0.06187, 24, 48, 180, 0.5 },
	{ 0.13023, 0.64455, 0.08108, 24, 60, 0, 0.5 },
	{ 0.13023, 0.64455, 0.07981, 24, 60, 24, 0.5 },
	{ 0.13023, 0.64455, 0.07717, 24, 60, 48, 0.5 },
	{ 0.13023, 0.64455, 0.07539, 24, 60, 72, 0.5 },
	{ 0.13023, 0.64455, 0.07608, 24, 60, 96, 0.5 },
	{ 0.13023, 0.64455, 0.0795, 24, 60, 120, 0.5 },
	{ 0.13023, 0.64455, 0.08427, 24, 60, 144, 0.5 },
	{ 0.13023, 0.64455, 0.08778, 24, 60, 168, 0.5 },
	{ 0.13023, 0.64455, 0.08828, 24, 60, 180, 0.5 },
	{ 0.13023, 0.59726, 0.09196, 24, 66, 0, 0.5 },
	{ 0.13023, 0.59726, 0.09083, 24, 66, 24, 0.5 },
	{ 0.13023, 0.59726, 0.08863, 24, 66, 48, 0.5 },
	{ 0.13023, 0.59726, 0.08782, 24, 66, 72, 0.5 },
	{ 0.13023, 0.59726, 0.09035, 24, 66, 96, 0.5 },
	{ 0.13023, 0.59726, 0.09651, 24, 66, 120, 0.5 },
	{ 0.13023, 0.59726, 0.10435, 24, 66, 144, 0.5 },
	{ 0.13023, 0.59726, 0.11, 24, 66, 168, 0.5 },
	{ 0.13023, 0.59726, 0.1108, 24, 66, 180, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 0, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 24, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 48, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 72, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 96, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 120, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 144, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 168, 0.5 },
	{ 0.13023, 0.74959, 0.04797, 36, 0, 180, 0.5 },
	{ 0.13023, 0.74675, 0.0528, 36, 12, 0, 0.5 },
	{ 0.13023, 0.74675, 0.05235, 36, 12, 24, 0.5 },
	{ 0.13023, 0.74675, 0.05117, 36, 12, 48, 0.5 },
	{ 0.13023, 0.74675, 0.04968, 36, 12, 72, 0.5 },
	{ 0.13023, 0.74675, 0.04833, 36, 12, 96, 0.5 },
	{ 0.13023, 0.74675, 0.04735, 36, 12, 120, 0.5 },
	{ 0.13023, 0.74675, 0.04677, 36, 12, 144, 0.5 },
	{ 0.13023, 0.74675, 0.04652, 36, 12, 168, 0.5 },
	{ 0.13023, 0.74675, 0.04649, 36, 12, 180, 0.5 },
	{ 0.13023, 0.73755, 0.06079, 36, 24, 0, 0.5 },
	{ 0.13023, 0.73755, 0.05894, 36, 24, 24, 0.5 },
	{ 0.13023, 0.73755, 0.05601, 36, 24, 48, 0.5 },
	{ 0.13023, 0.73755, 0.05285, 36, 24, 72, 0.5 },
	{ 0.13023, 0.73755, 0.05058, 36, 24, 96, 0.5 },
	{ 0.13023, 0.73755, 0.04949, 36, 24, 120, 0.5 },
	{ 0.13023, 0.73755, 0.04925, 36, 24, 144, 0.5 },
	{ 0.13023, 0.73755, 0.04935, 36, 24, 168, 0.5 },
	{ 0.13023, 0.73755, 0.04937, 36, 24, 180, 0.5 },
	{ 0.13023, 0.71953, 0.07602, 36, 36, 0, 0.5 },
	{ 0.13023, 0.71953, 0.06759, 36, 36, 24, 0.5 },
	{ 0.13023, 0.71953, 0.06266, 36, 36, 48, 0.5 },
	{ 0.13023, 0.71953, 0.05825, 36, 36, 72, 0.5 },
	{ 0.13023, 0.71953, 0.05599, 36, 36, 96, 0.5 },
	{ 0.13023, 0.71953, 0.05594, 36, 36, 120, 0.5 },
	{ 0.13023, 0.71953, 0.05723, 36, 36, 144, 0.5 },
	{ 0.13023, 0.71953, 0.05848, 36, 36, 168, 0.5 },
	{ 0.13023, 0.71953, 0.05867, 36, 36, 180, 0.5 },
	{ 0.13023, 0.68721, 0.0821, 36, 48, 0, 0.5 },
	{ 0.13023, 0.68721, 0.07846, 36, 48, 24, 0.5 },
	{ 0.13023, 0.68721, 0.07255, 36, 48, 48, 0.5 },
	{ 0.13023, 0.68721, 0.06791, 36, 48, 72, 0.5 },
	{ 0.13023, 0.68721, 0.06691, 36, 48, 96, 0.5 },
	{ 0.13023, 0.68721, 0.06969, 36, 48, 120, 0.5 },
	{ 0.13023, 0.68721, 0.07464, 36, 48, 144, 0.5 },
	{ 0.13023, 0.68721, 0.07855, 36, 48, 168, 0.5 },
	{ 0.13023, 0.68721, 0.07913, 36, 48, 180, 0.5 },
	{ 0.13023, 0.6288, 0.09884, 36, 60, 0, 0.5 },
	{ 0.13023, 0.6288, 0.09568, 36, 60, 24, 0.5 },
	{ 0.13023, 0.6288, 0.08945, 36, 60, 48, 0.5 },
	{ 0.13023, 0.6288, 0.0858, 36, 60, 72, 0.5 },
	{ 0.13023, 0.6288, 0.08807, 36, 60, 96, 0.5 },
	{ 0.13023, 0.6288, 0.09707, 36, 60, 120, 0.5 },
	{ 0.13023, 0.6288, 0.11001, 36, 60, 144, 0.5 },
	{ 0.13023, 0.6288, 0.11997, 36, 60, 168, 0.5 },
	{ 0.13023, 0.6288, 0.12144, 36, 60, 180, 0.5 },
	{ 0.13023, 0.58267, 0.11204, 36, 66, 0, 0.5 },
	{ 0.13023, 0.58267, 0.10881, 36, 66, 24, 0.5 },
	{ 0.13023, 0.58267, 0.10276, 36, 66, 48, 0.5 },
	{ 0.13023, 0.58267, 0.10014, 36, 66, 72, 0.5 },
	{ 0.13023, 0.58267, 0.10529, 36, 66, 96, 0.5 },
	{ 0.13023, 0.58267, 0.11967, 36, 66, 120, 0.5 },
	{ 0.13023, 0.58267, 0.1397, 36, 66, 144, 0.5 },
	{ 0.13023, 0.58267, 0.15522, 36, 66, 168, 0.5 },
	{ 0.13023, 0.58267, 0.15752, 36, 66, 180, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 0, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 24, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 48, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 72, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 96, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 120, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 144, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 168, 0.5 },
	{ 0.13023, 0.71592, 0.05423, 48, 0, 180, 0.5 },
	{ 0.13023, 0.71321, 0.05869, 48, 12, 0, 0.5 },
	{ 0.13023, 0.71321, 0.05826, 48, 12, 24, 0.5 },
	{ 0.13023, 0.71321, 0.05722, 48, 12, 48, 0.5 },
	{ 0.13023, 0.71321, 0.05606, 48, 12, 72, 0.5 },
	{ 0.13023, 0.71321, 0.05518, 48, 12, 96, 0.5 },
	{ 0.13023, 0.71321, 0.05477, 48, 12, 120, 0.5 },
	{ 0.13023, 0.71321, 0.05472, 48, 12, 144, 0.5 },
	{ 0.13023, 0.71321, 0.05479, 48, 12, 168, 0.5 },
	{ 0.13023, 0.71321, 0.05481, 48, 12, 180, 0.5 },
	{ 0.13023, 0.70442, 0.06777, 48, 24, 0, 0.5 },
	{ 0.13023, 0.70442, 0.0664, 48, 24, 24, 0.5 },
	{ 0.13023, 0.70442, 0.06327, 48, 24, 48, 0.5 },
	{ 0.13023, 0.70442, 0.06036, 48, 24, 72, 0.5 },
	{ 0.13023, 0.70442, 0.05895, 48, 24, 96, 0.5 },
	{ 0.13023, 0.70442, 0.05924, 48, 24, 120, 0.5 },
	{ 0.13023, 0.70442, 0.06055, 48, 24, 144, 0.5 },
	{ 0.13023, 0.70442, 0.0617, 48, 24, 168, 0.5 },
	{ 0.13023, 0.70442, 0.06187, 48, 24, 180, 0.5 },
	{ 0.13023, 0.68721, 0.08211, 48, 36, 0, 0.5 },
	{ 0.13023, 0.68721, 0.07847, 48, 36, 24, 0.5 },
	{ 0.13023, 0.68721, 0.07256, 48, 36, 48, 0.5 },
	{ 0.13023, 0.68721, 0.06792, 48, 36, 72, 0.5 },
	{ 0.13023, 0.68721, 0.06691, 48, 36, 96, 0.5 },
	{ 0.13023, 0.68721, 0.06969, 48, 36, 120, 0.5 },
	{ 0.13023, 0.68721, 0.07464, 48, 36, 144, 0.5 },
	{ 0.13023, 0.68721, 0.07855, 48, 36, 168, 0.5 },
	{ 0.13023, 0.68721, 0.07913, 48, 36, 180, 0.5 },
	{ 0.13023, 0.65634, 0.10845, 48, 48, 0, 0.5 },
	{ 0.13023, 0.65634, 0.09529, 48, 48, 24, 0.5 },
	{ 0.13023, 0.65634, 0.08649, 48, 48, 48, 0.5 },
	{ 0.13023, 0.65634, 0.08084, 48, 48, 72, 0.5 },
	{ 0.13023, 0.65634, 0.08188, 48, 48, 96, 0.5 },
	{ 0.13023, 0.65634, 0.09028, 48, 48, 120, 0.5 },
	{ 0.13023, 0.65634, 0.10319, 48, 48, 144, 0.5 },
	{ 0.13023, 0.65634, 0.11341, 48, 48, 168, 0.5 },
	{ 0.13023, 0.65634, 0.11494, 48, 48, 180, 0.5 },
	{ 0.13023, 0.60055, 0.12725, 48, 60, 0, 0.5 },
	{ 0.13023, 0.60055, 0.12014, 48, 60, 24, 0.5 },
	{ 0.13023, 0.60055, 0.10909, 48, 60, 48, 0.5 },
	{ 0.13023, 0.60055, 0.10368, 48, 60, 72, 0.5 },
	{ 0.13023, 0.60055, 0.10971, 48, 60, 96, 0.5 },
	{ 0.13023, 0.60055, 0.1297, 48, 60, 120, 0.5 },
	{ 0.13023, 0.60055, 0.15974, 48, 60, 144, 0.5 },
	{ 0.13023, 0.60055, 0.18444, 48, 60, 168, 0.5 },
	{ 0.13023, 0.60055, 0.18821, 48, 60, 180, 0.5 },
	{ 0.13023, 0.5565, 0.14473, 48, 66, 0, 0.5 },
	{ 0.13023, 0.5565, 0.13816, 48, 66, 24, 0.5 },
	{ 0.13023, 0.5565, 0.12626, 48, 66, 48, 0.5 },
	{ 0.13023, 0.5565, 0.12155, 48, 66, 72, 0.5 },
	{ 0.13023, 0.5565, 0.13185, 48, 66, 96, 0.5 },
	{ 0.13023, 0.5565, 0.16163, 48, 66, 120, 0.5 },
	{ 0.13023, 0.5565, 0.20681, 48, 66, 144, 0.5 },
	{ 0.13023, 0.5565, 0.24514, 48, 66, 168, 0.5 },
	{ 0.13023, 0.5565, 0.2511, 48, 66, 180, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 0, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 24, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 48, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 72, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 96, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 120, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 144, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 168, 0.5 },
	{ 0.13023, 0.65507, 0.06818, 60, 0, 180, 0.5 },
	{ 0.13023, 0.65259, 0.07113, 60, 12, 0, 0.5 },
	{ 0.13023, 0.65259, 0.07085, 60, 12, 24, 0.5 },
	{ 0.13023, 0.65259, 0.07027, 60, 12, 48, 0.5 },
	{ 0.13023, 0.65259, 0.06985, 60, 12, 72, 0.5 },
	{ 0.13023, 0.65259, 0.07004, 60, 12, 96, 0.5 },
	{ 0.13023, 0.65259, 0.07088, 60, 12, 120, 0.5 },
	{ 0.13023, 0.65259, 0.072, 60, 12, 144, 0.5 },
	{ 0.13023, 0.65259, 0.07279, 60, 12, 168, 0.5 },
	{ 0.13023, 0.65259, 0.0729, 60, 12, 180, 0.5 },
	{ 0.13023, 0.64455, 0.0811, 60, 24, 0, 0.5 },
	{ 0.13023, 0.64455, 0.07983, 60, 24, 24, 0.5 },
	{ 0.13023, 0.64455, 0.07718, 60, 24, 48, 0.5 },
	{ 0.13023, 0.64455, 0.0754, 60, 24, 72, 0.5 },
	{ 0.13023, 0.64455, 0.07609, 60, 24, 96, 0.5 },
	{ 0.13023, 0.64455, 0.07951, 60, 24, 120, 0.5 },
	{ 0.13023, 0.64455, 0.08427, 60, 24, 144, 0.5 },
	{ 0.13023, 0.64455, 0.08778, 60, 24, 168, 0.5 },
	{ 0.13023, 0.64455, 0.08828, 60, 24, 180, 0.5 },
	{ 0.13023, 0.6288, 0.09886, 60, 36, 0, 0.5 },
	{ 0.13023, 0.6288, 0.0957, 60, 36, 24, 0.5 },
	{ 0.13023, 0.6288, 0.08946, 60, 36, 48, 0.5 },
	{ 0.13023, 0.6288, 0.08581, 60, 36, 72, 0.5 },
	{ 0.13023, 0.6288, 0.08808, 60, 36, 96, 0.5 },
	{ 0.13023, 0.6288, 0.09707, 60, 36, 120, 0.5 },
	{ 0.13023, 0.6288, 0.11001, 60, 36, 144, 0.5 },
	{ 0.13023, 0.6288, 0.11996, 60, 36, 168, 0.5 },
	{ 0.13023, 0.6288, 0.12143, 60, 36, 180, 0.5 },
	{ 0.13023, 0.60055, 0.12727, 60, 48, 0, 0.5 },
	{ 0.13023, 0.60055, 0.12015, 60, 48, 24, 0.5 },
	{ 0.13023, 0.60055, 0.1091, 60, 48, 48, 0.5 },
	{ 0.13023, 0.60055, 0.10368, 60, 48, 72, 0.5 },
	{ 0.13023, 0.60055, 0.10971, 60, 48, 96, 0.5 },
	{ 0.13023, 0.60055, 0.1297, 60, 48, 120, 0.5 },
	{ 0.13023, 0.60055, 0.15974, 60, 48, 144, 0.5 },
	{ 0.13023, 0.60055, 0.18444, 60, 48, 168, 0.5 },
	{ 0.13023, 0.60055, 0.1882, 60, 48, 180, 0.5 },
	{ 0.13023, 0.54951, 0.18015, 60, 60, 0, 0.5 },
	{ 0.13023, 0.54951, 0.15783, 60, 60, 24, 0.5 },
	{ 0.13023, 0.54951, 0.14124, 60, 60, 48, 0.5 },
	{ 0.13023, 0.54951, 0.13483, 60, 60, 72, 0.5 },
	{ 0.13023, 0.54951, 0.14865, 60, 60, 96, 0.5 },
	{ 0.13023, 0.54951, 0.18996, 60, 60, 120, 0.5 },
	{ 0.13023, 0.54951, 0.25617, 60, 60, 144, 0.5 },
	{ 0.13023, 0.54951, 0.3159, 60, 60, 168, 0.5 },
	{ 0.13023, 0.54951, 0.3255, 60, 60, 180, 0.5 },
	{ 0.13023, 0.50919, 0.20537, 60, 66, 0, 0.5 },
	{ 0.13023, 0.50919, 0.18503, 60, 66, 24, 0.5 },
	{ 0.13023, 0.50919, 0.16548, 60, 66, 48, 0.5 },
	{ 0.13023, 0.50919, 0.15898, 60, 66, 72, 0.5 },
	{ 0.13023, 0.50919, 0.17916, 60, 66, 96, 0.5 },
	{ 0.13023, 0.50919, 0.23783, 60, 66, 120, 0.5 },
	{ 0.13023, 0.50919, 0.3358, 60, 66, 144, 0.5 },
	{ 0.13023, 0.50919, 0.42956, 60, 66, 168, 0.5 },
	{ 0.13023, 0.50919, 0.44511, 60, 66, 180, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 0, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 24, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 48, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 72, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 96, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 120, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 144, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 168, 0.5 },
	{ 0.13023, 0.54055, 0.09723, 72, 0, 180, 0.5 },
	{ 0.13023, 0.53851, 0.09688, 72, 12, 0, 0.5 },
	{ 0.13023, 0.53851, 0.09688, 72, 12, 24, 0.5 },
	{ 0.13023, 0.53851, 0.09714, 72, 12, 48, 0.5 },
	{ 0.13023, 0.53851, 0.09827, 72, 12, 72, 0.5 },
	{ 0.13023, 0.53851, 0.10069, 72, 12, 96, 0.5 },
	{ 0.13023, 0.53851, 0.10422, 72, 12, 120, 0.5 },
	{ 0.13023, 0.53851, 0.10788, 72, 12, 144, 0.5 },
	{ 0.13023, 0.53851, 0.11026, 72, 12, 168, 0.5 },
	{ 0.13023, 0.53851, 0.11058, 72, 12, 180, 0.5 },
	{ 0.13023, 0.53187, 0.10755, 72, 24, 0, 0.5 },
	{ 0.13023, 0.53187, 0.10656, 72, 24, 24, 0.5 },
	{ 0.13023, 0.53187, 0.10491, 72, 24, 48, 0.5 },
	{ 0.13023, 0.53187, 0.10545, 72, 24, 72, 0.5 },
	{ 0.13023, 0.53187, 0.11059, 72, 24, 96, 0.5 },
	{ 0.13023, 0.53187, 0.12074, 72, 24, 120, 0.5 },
	{ 0.13023, 0.53187, 0.13315, 72, 24, 144, 0.5 },
	{ 0.13023, 0.53187, 0.14199, 72, 24, 168, 0.5 },
	{ 0.13023, 0.53187, 0.14326, 72, 24, 180, 0.5 },
	{ 0.13023, 0.51887, 0.13045, 72, 36, 0, 0.5 },
	{ 0.13023, 0.51887, 0.12722, 72, 36, 24, 0.5 },
	{ 0.13023, 0.51887, 0.12142, 72, 36, 48, 0.5 },
	{ 0.13023, 0.51887, 0.12021, 72, 36, 72, 0.5 },
	{ 0.13023, 0.51887, 0.12942, 72, 36, 96, 0.5 },
	{ 0.13023, 0.51887, 0.15157, 72, 36, 120, 0.5 },
	{ 0.13023, 0.51887, 0.18215, 72, 36, 144, 0.5 },
	{ 0.13023, 0.51887, 0.20616, 72, 36, 168, 0.5 },
	{ 0.13023, 0.51887, 0.20975, 72, 36, 180, 0.5 },
	{ 0.13023, 0.49557, 0.16995, 72, 48, 0, 0.5 },
	{ 0.13023, 0.49557, 0.16273, 72, 48, 24, 0.5 },
	{ 0.13023, 0.49557, 0.14999, 72, 48, 48, 0.5 },
	{ 0.13023, 0.49557, 0.14631, 72, 48, 72, 0.5 },
	{ 0.13023, 0.49557, 0.16252, 72, 48, 96, 0.5 },
	{ 0.13023, 0.49557, 0.20618, 72, 48, 120, 0.5 },
	{ 0.13023, 0.49557, 0.27387, 72, 48, 144, 0.5 },
	{ 0.13023, 0.49557, 0.33358, 72, 48, 168, 0.5 },
	{ 0.13023, 0.49557, 0.34306, 72, 48, 180, 0.5 },
	{ 0.13023, 0.45344, 0.23705, 72, 60, 0, 0.5 },
	{ 0.13023, 0.45344, 0.2218, 72, 60, 24, 0.5 },
	{ 0.13023, 0.45344, 0.19887, 72, 60, 48, 0.5 },
	{ 0.13023, 0.45344, 0.19237, 72, 60, 72, 0.5 },
	{ 0.13023, 0.45344, 0.22111, 72, 60, 96, 0.5 },
	{ 0.13023, 0.45344, 0.30397, 72, 60, 120, 0.5 },
	{ 0.13023, 0.45344, 0.44889, 72, 60, 144, 0.5 },
	{ 0.13023, 0.45344, 0.59721, 72, 60, 168, 0.5 },
	{ 0.13023, 0.45344, 0.62294, 72, 60, 180, 0.5 },
	{ 0.13023, 0.42018, 0.2956, 72, 66, 0, 0.5 },
	{ 0.13023, 0.42018, 0.26618, 72, 66, 24, 0.5 },
	{ 0.13023, 0.42018, 0.23655, 72, 66, 48, 0.5 },
	{ 0.13023, 0.42018, 0.22842, 72, 66, 72, 0.5 },
	{ 0.13023, 0.42018, 0.26685, 72, 66, 96, 0.5 },
	{ 0.13023, 0.42018, 0.38058, 72, 66, 120, 0.5 },
	{ 0.13023, 0.42018, 0.59245, 72, 66, 144, 0.5 },
	{ 0.13023, 0.42018, 0.82966, 72, 66, 168, 0.5 },
	{ 0.13023, 0.42018, 0.87331, 72, 66, 180, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 0, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 24, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 48, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 72, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 96, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 120, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 144, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 168, 0.5 },
	{ 0.13023, 0.34621, 0.15149, 84, 0, 180, 0.5 },
	{ 0.13023, 0.3449, 0.147, 84, 12, 0, 0.5 },
	{ 0.13023, 0.3449, 0.14728, 84, 12, 24, 0.5 },
	{ 0.13023, 0.3449, 0.14852, 84, 12, 48, 0.5 },
	{ 0.13023, 0.3449, 0.15167, 84, 12, 72, 0.5 },
	{ 0.13023, 0.3449, 0.15738, 84, 12, 96, 0.5 },
	{ 0.13023, 0.3449, 0.16519, 84, 12, 120, 0.5 },
	{ 0.13023, 0.3449, 0.1731, 84, 12, 144, 0.5 },
	{ 0.13023, 0.3449, 0.1782, 84, 12, 168, 0.5 },
	{ 0.13023, 0.3449, 0.1789, 84, 12, 180, 0.5 },
	{ 0.13023, 0.34065, 0.16138, 84, 24, 0, 0.5 },
	{ 0.13023, 0.34065, 0.16029, 84, 24, 24, 0.5 },
	{ 0.13023, 0.34065, 0.15893, 84, 24, 48, 0.5 },
	{ 0.13023, 0.34065, 0.16179, 84, 24, 72, 0.5 },
	{ 0.13023, 0.34065, 0.17315, 84, 24, 96, 0.5 },
	{ 0.13023, 0.34065, 0.19419, 84, 24, 120, 0.5 },
	{ 0.13023, 0.34065, 0.21991, 84, 24, 144, 0.5 },
	{ 0.13023, 0.34065, 0.23857, 84, 24, 168, 0.5 },
	{ 0.13023, 0.34065, 0.24127, 84, 24, 180, 0.5 },
	{ 0.13023, 0.33232, 0.19629, 84, 36, 0, 0.5 },
	{ 0.13023, 0.33232, 0.19213, 84, 36, 24, 0.5 },
	{ 0.13023, 0.33232, 0.18454, 84, 36, 48, 0.5 },
	{ 0.13023, 0.33232, 0.18437, 84, 36, 72, 0.5 },
	{ 0.13023, 0.33232, 0.20266, 84, 36, 96, 0.5 },
	{ 0.13023, 0.33232, 0.2458, 84, 36, 120, 0.5 },
	{ 0.13023, 0.33232, 0.30783, 84, 36, 144, 0.5 },
	{ 0.13023, 0.33232, 0.35925, 84, 36, 168, 0.5 },
	{ 0.13023, 0.33232, 0.36717, 84, 36, 180, 0.5 },
	{ 0.13023, 0.3174, 0.2604, 84, 48, 0, 0.5 },
	{ 0.13023, 0.3174, 0.25051, 84, 48, 24, 0.5 },
	{ 0.13023, 0.3174, 0.23191, 84, 48, 48, 0.5 },
	{ 0.13023, 0.3174, 0.22613, 84, 48, 72, 0.5 },
	{ 0.13023, 0.3174, 0.25451, 84, 48, 96, 0.5 },
	{ 0.13023, 0.3174, 0.33497, 84, 48, 120, 0.5 },
	{ 0.13023, 0.3174, 0.47037, 84, 48, 144, 0.5 },
	{ 0.13023, 0.3174, 0.60285, 84, 48, 168, 0.5 },
	{ 0.13023, 0.3174, 0.62528, 84, 48, 180, 0.5 },
	{ 0.13023, 0.29042, 0.37622, 84, 60, 0, 0.5 },
	{ 0.13023, 0.29042, 0.35588, 84, 60, 24, 0.5 },
	{ 0.13023, 0.29042, 0.31828, 84, 60, 48, 0.5 },
	{ 0.13023, 0.29042, 0.30336, 84, 60, 72, 0.5 },
	{ 0.13023, 0.29042, 0.34844, 84, 60, 96, 0.5 },
	{ 0.13023, 0.29042, 0.49441, 84, 60, 120, 0.5 },
	{ 0.13023, 0.29042, 0.78098, 84, 60, 144, 0.5 },
	{ 0.13023, 0.29042, 1.12848, 84, 60, 168, 0.5 },
	{ 0.13023, 0.29042, 1.19606, 84, 60, 180, 0.5 },
	{ 0.13023, 0.26911, 0.46983, 84, 66, 0, 0.5 },
	{ 0.13023, 0.26911, 0.44136, 84, 66, 24, 0.5 },
	{ 0.13023, 0.26911, 0.38896, 84, 66, 48, 0.5 },
	{ 0.13023, 0.26911, 0.36705, 84, 66, 72, 0.5 },
	{ 0.13023, 0.26911, 0.42498, 84, 66, 96, 0.5 },
	{ 0.13023, 0.26911, 0.62259, 84, 66, 120, 0.5 },
	{ 0.13023, 0.26911, 1.04037, 84, 66, 144, 0.5 },
	{ 0.13023, 0.26911, 1.61482, 84, 66, 168, 0.5 },
	{ 0.13023, 0.26911, 1.73846, 84, 66, 180, 0.5 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 0, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 24, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 48, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 72, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 96, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 120, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 144, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 168, 1 },
	{ 0.1788, 0.62681, 0.07919, 0, 0, 180, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 0, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 24, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 48, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 72, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 96, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 120, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 144, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 168, 1 },
	{ 0.1788, 0.6224, 0.07329, 0, 12, 180, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 0, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 24, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 48, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 72, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 96, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 120, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 144, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 168, 1 },
	{ 0.1788, 0.60831, 0.07377, 0, 24, 180, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 0, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 24, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 48, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 72, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 96, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 120, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 144, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 168, 1 },
	{ 0.1788, 0.58172, 0.07819, 0, 36, 180, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 0, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 24, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 48, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 72, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 96, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 120, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 144, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 168, 1 },
	{ 0.1788, 0.5371, 0.08861, 0, 48, 180, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 0, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 24, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 48, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 72, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 96, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 120, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 144, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 168, 1 },
	{ 0.1788, 0.46548, 0.10814, 0, 60, 180, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 0, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 24, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 48, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 72, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 96, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 120, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 144, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 168, 1 },
	{ 0.1788, 0.41632, 0.12216, 0, 66, 180, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 0, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 24, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 48, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 72, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 96, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 120, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 144, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 168, 1 },
	{ 0.1788, 0.6224, 0.07329, 12, 0, 180, 1 },
	{ 0.1788, 0.61802, 0.08237, 12, 12, 0, 1 },
	{ 0.1788, 0.61802, 0.08029, 12, 12, 24, 1 },
	{ 0.1788, 0.61802, 0.07625, 12, 12, 48, 1 },
	{ 0.1788, 0.61802, 0.0738, 12, 12, 72, 1 },
	{ 0.1788, 0.61802, 0.0726, 12, 12, 96, 1 },
	{ 0.1788, 0.61802, 0.07177, 12, 12, 120, 1 },
	{ 0.1788, 0.61802, 0.07118, 12, 12, 144, 1 },
	{ 0.1788, 0.61802, 0.0709, 12, 12, 168, 1 },
	{ 0.1788, 0.61802, 0.07085, 12, 12, 180, 1 },
	{ 0.1788, 0.60403, 0.07963, 12, 24, 0, 1 },
	{ 0.1788, 0.60403, 0.07867, 12, 24, 24, 1 },
	{ 0.1788, 0.60403, 0.07716, 12, 24, 48, 1 },
	{ 0.1788, 0.60403, 0.07563, 12, 24, 72, 1 },
	{ 0.1788, 0.60403, 0.07416, 12, 24, 96, 1 },
	{ 0.1788, 0.60403, 0.07299, 12, 24, 120, 1 },
	{ 0.1788, 0.60403, 0.07226, 12, 24, 144, 1 },
	{ 0.1788, 0.60403, 0.07191, 12, 24, 168, 1 },
	{ 0.1788, 0.60403, 0.07187, 12, 24, 180, 1 },
	{ 0.1788, 0.57763, 0.08397, 12, 36, 0, 1 },
	{ 0.1788, 0.57763, 0.08345, 12, 36, 24, 1 },
	{ 0.1788, 0.57763, 0.08212, 12, 36, 48, 1 },
	{ 0.1788, 0.57763, 0.08053, 12, 36, 72, 1 },
	{ 0.1788, 0.57763, 0.07923, 12, 36, 96, 1 },
	{ 0.1788, 0.57763, 0.07843, 12, 36, 120, 1 },
	{ 0.1788, 0.57763, 0.07809, 12, 36, 144, 1 },
	{ 0.1788, 0.57763, 0.07799, 12, 36, 168, 1 },
	{ 0.1788, 0.57763, 0.07798, 12, 36, 180, 1 },
	{ 0.1788, 0.53332, 0.09314, 12, 48, 0, 1 },
	{ 0.1788, 0.53332, 0.09273, 12, 48, 24, 1 },
	{ 0.1788, 0.53332, 0.0918, 12, 48, 48, 1 },
	{ 0.1788, 0.53332, 0.09094, 12, 48, 72, 1 },
	{ 0.1788, 0.53332, 0.09061, 12, 48, 96, 1 },
	{ 0.1788, 0.53332, 0.09091, 12, 48, 120, 1 },
	{ 0.1788, 0.53332, 0.09154, 12, 48, 144, 1 },
	{ 0.1788, 0.53332, 0.09203, 12, 48, 168, 1 },
	{ 0.1788, 0.53332, 0.0921, 12, 48, 180, 1 },
	{ 0.1788, 0.46221, 0.10978, 12, 60, 0, 1 },
	{ 0.1788, 0.46221, 0.10965, 12, 60, 24, 1 },
	{ 0.1788, 0.46221, 0.10955, 12, 60, 48, 1 },
	{ 0.1788, 0.46221, 0.11002, 12, 60, 72, 1 },
	{ 0.1788, 0.46221, 0.11146, 12, 60, 96, 1 },
	{ 0.1788, 0.46221, 0.11375, 12, 60, 120, 1 },
	{ 0.1788, 0.46221, 0.11617, 12, 60, 144, 1 },
	{ 0.1788, 0.46221, 0.11776, 12, 60, 168, 1 },
	{ 0.1788, 0.46221, 0.11797, 12, 60, 180, 1 },
	{ 0.1788, 0.41339, 0.12173, 12, 66, 0, 1 },
	{ 0.1788, 0.41339, 0.12178, 12, 66, 24, 1 },
	{ 0.1788, 0.41339, 0.12223, 12, 66, 48, 1 },
	{ 0.1788, 0.41339, 0.12363, 12, 66, 72, 1 },
	{ 0.1788, 0.41339, 0.12635, 12, 66, 96, 1 },
	{ 0.1788, 0.41339, 0.13012, 12, 66, 120, 1 },
	{ 0.1788, 0.41339, 0.1339, 12, 66, 144, 1 },
	{ 0.1788, 0.41339, 0.13632, 12, 66, 168, 1 },
	{ 0.1788, 0.41339, 0.13665, 12, 66, 180, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 0, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 24, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 48, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 72, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 96, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 120, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 144, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 168, 1 },
	{ 0.1788, 0.60831, 0.07377, 24, 0, 180, 1 },
	{ 0.1788, 0.60403, 0.07963, 24, 12, 0, 1 },
	{ 0.1788, 0.60403, 0.07867, 24, 12, 24, 1 },
	{ 0.1788, 0.60403, 0.07717, 24, 12, 48, 1 },
	{ 0.1788, 0.60403, 0.07563, 24, 12, 72, 1 },
	{ 0.1788, 0.60403, 0.07415, 24, 12, 96, 1 },
	{ 0.1788, 0.60403, 0.07299, 24, 12, 120, 1 },
	{ 0.1788, 0.60403, 0.07226, 24, 12, 144, 1 },
	{ 0.1788, 0.60403, 0.07191, 24, 12, 168, 1 },
	{ 0.1788, 0.60403, 0.07187, 24, 12, 180, 1 },
	{ 0.1788, 0.59036, 0.09349, 24, 24, 0, 1 },
	{ 0.1788, 0.59036, 0.0867, 24, 24, 24, 1 },
	{ 0.1788, 0.59036, 0.08212, 24, 24, 48, 1 },
	{ 0.1788, 0.59036, 0.07918, 24, 24, 72, 1 },
	{ 0.1788, 0.59036, 0.07681, 24, 24, 96, 1 },
	{ 0.1788, 0.59036, 0.07544, 24, 24, 120, 1 },
	{ 0.1788, 0.59036, 0.07491, 24, 24, 144, 1 },
	{ 0.1788, 0.59036, 0.0748, 24, 24, 168, 1 },
	{ 0.1788, 0.59036, 0.07479, 24, 24, 180, 1 },
	{ 0.1788, 0.56455, 0.09483, 24, 36, 0, 1 },
	{ 0.1788, 0.56455, 0.09246, 24, 36, 24, 1 },
	{ 0.1788, 0.56455, 0.08903, 24, 36, 48, 1 },
	{ 0.1788, 0.56455, 0.08563, 24, 36, 72, 1 },
	{ 0.1788, 0.56455, 0.08369, 24, 36, 96, 1 },
	{ 0.1788, 0.56455, 0.08341, 24, 36, 120, 1 },
	{ 0.1788, 0.56455, 0.0841, 24, 36, 144, 1 },
	{ 0.1788, 0.56455, 0.08482, 24, 36, 168, 1 },
	{ 0.1788, 0.56455, 0.08493, 24, 36, 180, 1 },
	{ 0.1788, 0.52125, 0.10481, 24, 48, 0, 1 },
	{ 0.1788, 0.52125, 0.10328, 24, 48, 24, 1 },
	{ 0.1788, 0.52125, 0.09998, 24, 48, 48, 1 },
	{ 0.1788, 0.52125, 0.09751, 24, 48, 72, 1 },
	{ 0.1788, 0.52125, 0.09743, 24, 48, 96, 1 },
	{ 0.1788, 0.52125, 0.0997, 24, 48, 120, 1 },
	{ 0.1788, 0.52125, 0.10304, 24, 48, 144, 1 },
	{ 0.1788, 0.52125, 0.1055, 24, 48, 168, 1 },
	{ 0.1788, 0.52125, 0.10585, 24, 48, 180, 1 },
	{ 0.1788, 0.45174, 0.12168, 24, 60, 0, 1 },
	{ 0.1788, 0.45174, 0.12047, 24, 60, 24, 1 },
	{ 0.1788, 0.45174, 0.11834, 24, 60, 48, 1 },
	{ 0.1788, 0.45174, 0.11806, 24, 60, 72, 1 },
	{ 0.1788, 0.45174, 0.12146, 24, 60, 96, 1 },
	{ 0.1788, 0.45174, 0.12851, 24, 60, 120, 1 },
	{ 0.1788, 0.45174, 0.13692, 24, 60, 144, 1 },
	{ 0.1788, 0.45174, 0.14278, 24, 60, 168, 1 },
	{ 0.1788, 0.45174, 0.14361, 24, 60, 180, 1 },
	{ 0.1788, 0.40403, 0.13342, 24, 66, 0, 1 },
	{ 0.1788, 0.40403, 0.1325, 24, 66, 24, 1 },
	{ 0.1788, 0.40403, 0.13118, 24, 66, 48, 1 },
	{ 0.1788, 0.40403, 0.13243, 24, 66, 72, 1 },
	{ 0.1788, 0.40403, 0.13838, 24, 66, 96, 1 },
	{ 0.1788, 0.40403, 0.14902, 24, 66, 120, 1 },
	{ 0.1788, 0.40403, 0.16137, 24, 66, 144, 1 },
	{ 0.1788, 0.40403, 0.16992, 24, 66, 168, 1 },
	{ 0.1788, 0.40403, 0.17113, 24, 66, 180, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 0, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 24, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 48, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 72, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 96, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 120, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 144, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 168, 1 },
	{ 0.1788, 0.58172, 0.07819, 36, 0, 180, 1 },
	{ 0.1788, 0.57763, 0.08399, 36, 12, 0, 1 },
	{ 0.1788, 0.57763, 0.08347, 36, 12, 24, 1 },
	{ 0.1788, 0.57763, 0.08213, 36, 12, 48, 1 },
	{ 0.1788, 0.57763, 0.08054, 36, 12, 72, 1 },
	{ 0.1788, 0.57763, 0.07923, 36, 12, 96, 1 },
	{ 0.1788, 0.57763, 0.07843, 36, 12, 120, 1 },
	{ 0.1788, 0.57763, 0.07808, 36, 12, 144, 1 },
	{ 0.1788, 0.57763, 0.07798, 36, 12, 168, 1 },
	{ 0.1788, 0.57763, 0.07797, 36, 12, 180, 1 },
	{ 0.1788, 0.56455, 0.09483, 36, 24, 0, 1 },
	{ 0.1788, 0.56455, 0.09247, 36, 24, 24, 1 },
	{ 0.1788, 0.56455, 0.08903, 36, 24, 48, 1 },
	{ 0.1788, 0.56455, 0.08563, 36, 24, 72, 1 },
	{ 0.1788, 0.56455, 0.08369, 36, 24, 96, 1 },
	{ 0.1788, 0.56455, 0.08341, 36, 24, 120, 1 },
	{ 0.1788, 0.56455, 0.0841, 36, 24, 144, 1 },
	{ 0.1788, 0.56455, 0.08482, 36, 24, 168, 1 },
	{ 0.1788, 0.56455, 0.08493, 36, 24, 180, 1 },
	{ 0.1788, 0.53987, 0.1159, 36, 36, 0, 1 },
	{ 0.1788, 0.53987, 0.10465, 36, 36, 24, 1 },
	{ 0.1788, 0.53987, 0.09889, 36, 36, 48, 1 },
	{ 0.1788, 0.53987, 0.09444, 36, 36, 72, 1 },
	{ 0.1788, 0.53987, 0.09332, 36, 36, 96, 1 },
	{ 0.1788, 0.53987, 0.09533, 36, 36, 120, 1 },
	{ 0.1788, 0.53987, 0.09886, 36, 36, 144, 1 },
	{ 0.1788, 0.53987, 0.1016, 36, 36, 168, 1 },
	{ 0.1788, 0.53987, 0.102, 36, 36, 180, 1 },
	{ 0.1788, 0.49846, 0.12401, 36, 48, 0, 1 },
	{ 0.1788, 0.49846, 0.11961, 36, 48, 24, 1 },
	{ 0.1788, 0.49846, 0.11314, 36, 48, 48, 1 },
	{ 0.1788, 0.49846, 0.10927, 36, 48, 72, 1 },
	{ 0.1788, 0.49846, 0.11089, 36, 48, 96, 1 },
	{ 0.1788, 0.49846, 0.11778, 36, 48, 120, 1 },
	{ 0.1788, 0.49846, 0.12716, 36, 48, 144, 1 },
	{ 0.1788, 0.49846, 0.13405, 36, 48, 168, 1 },
	{ 0.1788, 0.49846, 0.13505, 36, 48, 180, 1 },
	{ 0.1788, 0.43199, 0.14428, 36, 60, 0, 1 },
	{ 0.1788, 0.43199, 0.14089, 36, 60, 24, 1 },
	{ 0.1788, 0.43199, 0.13487, 36, 60, 48, 1 },
	{ 0.1788, 0.43199, 0.13338, 36, 60, 72, 1 },
	{ 0.1788, 0.43199, 0.14038, 36, 60, 96, 1 },
	{ 0.1788, 0.43199, 0.15639, 36, 60, 120, 1 },
	{ 0.1788, 0.43199, 0.17704, 36, 60, 144, 1 },
	{ 0.1788, 0.43199, 0.19231, 36, 60, 168, 1 },
	{ 0.1788, 0.43199, 0.19453, 36, 60, 180, 1 },
	{ 0.1788, 0.38637, 0.15811, 36, 66, 0, 1 },
	{ 0.1788, 0.38637, 0.15485, 36, 66, 24, 1 },
	{ 0.1788, 0.38637, 0.14956, 36, 66, 48, 1 },
	{ 0.1788, 0.38637, 0.14986, 36, 66, 72, 1 },
	{ 0.1788, 0.38637, 0.16081, 36, 66, 96, 1 },
	{ 0.1788, 0.38637, 0.18369, 36, 66, 120, 1 },
	{ 0.1788, 0.38637, 0.21319, 36, 66, 144, 1 },
	{ 0.1788, 0.38637, 0.23535, 36, 66, 168, 1 },
	{ 0.1788, 0.38637, 0.23859, 36, 66, 180, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 0, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 24, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 48, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 72, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 96, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 120, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 144, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 168, 1 },
	{ 0.1788, 0.5371, 0.08862, 48, 0, 180, 1 },
	{ 0.1788, 0.53332, 0.09316, 48, 12, 0, 1 },
	{ 0.1788, 0.53332, 0.09275, 48, 12, 24, 1 },
	{ 0.1788, 0.53332, 0.09181, 48, 12, 48, 1 },
	{ 0.1788, 0.53332, 0.09095, 48, 12, 72, 1 },
	{ 0.1788, 0.53332, 0.09062, 48, 12, 96, 1 },
	{ 0.1788, 0.53332, 0.09092, 48, 12, 120, 1 },
	{ 0.1788, 0.53332, 0.09154, 48, 12, 144, 1 },
	{ 0.1788, 0.53332, 0.09203, 48, 12, 168, 1 },
	{ 0.1788, 0.53332, 0.0921, 48, 12, 180, 1 },
	{ 0.1788, 0.52125, 0.10483, 48, 24, 0, 1 },
	{ 0.1788, 0.52125, 0.10329, 48, 24, 24, 1 },
	{ 0.1788, 0.52125, 0.09999, 48, 24, 48, 1 },
	{ 0.1788, 0.52125, 0.09752, 48, 24, 72, 1 },
	{ 0.1788, 0.52125, 0.09743, 48, 24, 96, 1 },
	{ 0.1788, 0.52125, 0.0997, 48, 24, 120, 1 },
	{ 0.1788, 0.52125, 0.10304, 48, 24, 144, 1 },
	{ 0.1788, 0.52125, 0.10549, 48, 24, 168, 1 },
	{ 0.1788, 0.52125, 0.10584, 48, 24, 180, 1 },
	{ 0.1788, 0.49846, 0.12403, 48, 36, 0, 1 },
	{ 0.1788, 0.49846, 0.11963, 48, 36, 24, 1 },
	{ 0.1788, 0.49846, 0.11315, 48, 36, 48, 1 },
	{ 0.1788, 0.49846, 0.10927, 48, 36, 72, 1 },
	{ 0.1788, 0.49846, 0.11089, 48, 36, 96, 1 },
	{ 0.1788, 0.49846, 0.11778, 48, 36, 120, 1 },
	{ 0.1788, 0.49846, 0.12715, 48, 36, 144, 1 },
	{ 0.1788, 0.49846, 0.13405, 48, 36, 168, 1 },
	{ 0.1788, 0.49846, 0.13504, 48, 36, 180, 1 },
	{ 0.1788, 0.46023, 0.1585, 48, 48, 0, 1 },
	{ 0.1788, 0.46023, 0.14195, 48, 48, 24, 1 },
	{ 0.1788, 0.46023, 0.13249, 48, 48, 48, 1 },
	{ 0.1788, 0.46023, 0.12846, 48, 48, 72, 1 },
	{ 0.1788, 0.46023, 0.13423, 48, 48, 96, 1 },
	{ 0.1788, 0.46023, 0.1501, 48, 48, 120, 1 },
	{ 0.1788, 0.46023, 0.17147, 48, 48, 144, 1 },
	{ 0.1788, 0.46023, 0.18765, 48, 48, 168, 1 },
	{ 0.1788, 0.46023, 0.19003, 48, 48, 180, 1 },
	{ 0.1788, 0.39886, 0.18008, 48, 60, 0, 1 },
	{ 0.1788, 0.39886, 0.17205, 48, 60, 24, 1 },
	{ 0.1788, 0.39886, 0.16092, 48, 60, 48, 1 },
	{ 0.1788, 0.39886, 0.1587, 48, 60, 72, 1 },
	{ 0.1788, 0.39886, 0.17234, 48, 60, 96, 1 },
	{ 0.1788, 0.39886, 0.2045, 48, 60, 120, 1 },
	{ 0.1788, 0.39886, 0.24908, 48, 60, 144, 1 },
	{ 0.1788, 0.39886, 0.2846, 48, 60, 168, 1 },
	{ 0.1788, 0.39886, 0.28996, 48, 60, 180, 1 },
	{ 0.1788, 0.35673, 0.1981, 48, 66, 0, 1 },
	{ 0.1788, 0.35673, 0.19112, 48, 66, 24, 1 },
	{ 0.1788, 0.35673, 0.17974, 48, 66, 48, 1 },
	{ 0.1788, 0.35673, 0.17913, 48, 66, 72, 1 },
	{ 0.1788, 0.35673, 0.19848, 48, 66, 96, 1 },
	{ 0.1788, 0.35673, 0.24276, 48, 66, 120, 1 },
	{ 0.1788, 0.35673, 0.30577, 48, 66, 144, 1 },
	{ 0.1788, 0.35673, 0.35781, 48, 66, 168, 1 },
	{ 0.1788, 0.35673, 0.36582, 48, 66, 180, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 0, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 24, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 48, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 72, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 96, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 120, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 144, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 168, 1 },
	{ 0.1788, 0.46548, 0.10816, 60, 0, 180, 1 },
	{ 0.1788, 0.46221, 0.10982, 60, 12, 0, 1 },
	{ 0.1788, 0.46221, 0.10969, 60, 12, 24, 1 },
	{ 0.1788, 0.46221, 0.10959, 60, 12, 48, 1 },
	{ 0.1788, 0.46221, 0.11005, 60, 12, 72, 1 },
	{ 0.1788, 0.46221, 0.11149, 60, 12, 96, 1 },
	{ 0.1788, 0.46221, 0.11377, 60, 12, 120, 1 },
	{ 0.1788, 0.46221, 0.11619, 60, 12, 144, 1 },
	{ 0.1788, 0.46221, 0.11776, 60, 12, 168, 1 },
	{ 0.1788, 0.46221, 0.11798, 60, 12, 180, 1 },
	{ 0.1788, 0.45174, 0.12173, 60, 24, 0, 1 },
	{ 0.1788, 0.45174, 0.12052, 60, 24, 24, 1 },
	{ 0.1788, 0.45174, 0.11838, 60, 24, 48, 1 },
	{ 0.1788, 0.45174, 0.11809, 60, 24, 72, 1 },
	{ 0.1788, 0.45174, 0.12148, 60, 24, 96, 1 },
	{ 0.1788, 0.45174, 0.12852, 60, 24, 120, 1 },
	{ 0.1788, 0.45174, 0.13692, 60, 24, 144, 1 },
	{ 0.1788, 0.45174, 0.14278, 60, 24, 168, 1 },
	{ 0.1788, 0.45174, 0.1436, 60, 24, 180, 1 },
	{ 0.1788, 0.43199, 0.14434, 60, 36, 0, 1 },
	{ 0.1788, 0.43199, 0.14095, 60, 36, 24, 1 },
	{ 0.1788, 0.43199, 0.13492, 60, 36, 48, 1 },
	{ 0.1788, 0.43199, 0.13341, 60, 36, 72, 1 },
	{ 0.1788, 0.43199, 0.1404, 60, 36, 96, 1 },
	{ 0.1788, 0.43199, 0.1564, 60, 36, 120, 1 },
	{ 0.1788, 0.43199, 0.17704, 60, 36, 144, 1 },
	{ 0.1788, 0.43199, 0.1923, 60, 36, 168, 1 },
	{ 0.1788, 0.43199, 0.19453, 60, 36, 180, 1 },
	{ 0.1788, 0.39886, 0.18014, 60, 48, 0, 1 },
	{ 0.1788, 0.39886, 0.1721, 60, 48, 24, 1 },
	{ 0.1788, 0.39886, 0.16096, 60, 48, 48, 1 },
	{ 0.1788, 0.39886, 0.15873, 60, 48, 72, 1 },
	{ 0.1788, 0.39886, 0.17236, 60, 48, 96, 1 },
	{ 0.1788, 0.39886, 0.20451, 60, 48, 120, 1 },
	{ 0.1788, 0.39886, 0.24908, 60, 48, 144, 1 },
	{ 0.1788, 0.39886, 0.28459, 60, 48, 168, 1 },
	{ 0.1788, 0.39886, 0.28996, 60, 48, 180, 1 },
	{ 0.1788, 0.34568, 0.24256, 60, 60, 0, 1 },
	{ 0.1788, 0.34568, 0.21669, 60, 60, 24, 1 },
	{ 0.1788, 0.34568, 0.20025, 60, 60, 48, 1 },
	{ 0.1788, 0.34568, 0.1987, 60, 60, 72, 1 },
	{ 0.1788, 0.34568, 0.2239, 60, 60, 96, 1 },
	{ 0.1788, 0.34568, 0.28431, 60, 60, 120, 1 },
	{ 0.1788, 0.34568, 0.3754, 60, 60, 144, 1 },
	{ 0.1788, 0.34568, 0.45537, 60, 60, 168, 1 },
	{ 0.1788, 0.34568, 0.4681, 60, 60, 180, 1 },
	{ 0.1788, 0.30917, 0.26818, 60, 66, 0, 1 },
	{ 0.1788, 0.30917, 0.24557, 60, 66, 24, 1 },
	{ 0.1788, 0.30917, 0.22663, 60, 66, 48, 1 },
	{ 0.1788, 0.30917, 0.22597, 60, 66, 72, 1 },
	{ 0.1788, 0.30917, 0.25932, 60, 66, 96, 1 },
	{ 0.1788, 0.30917, 0.3405, 60, 66, 120, 1 },
	{ 0.1788, 0.30917, 0.46897, 60, 66, 144, 1 },
	{ 0.1788, 0.30917, 0.58892, 60, 66, 168, 1 },
	{ 0.1788, 0.30917, 0.60866, 60, 66, 180, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 0, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 24, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 48, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 72, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 96, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 120, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 144, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 168, 1 },
	{ 0.1788, 0.35804, 0.13894, 72, 0, 180, 1 },
	{ 0.1788, 0.35552, 0.13606, 72, 12, 0, 1 },
	{ 0.1788, 0.35552, 0.13632, 72, 12, 24, 1 },
	{ 0.1788, 0.35552, 0.13738, 72, 12, 48, 1 },
	{ 0.1788, 0.35552, 0.13986, 72, 12, 72, 1 },
	{ 0.1788, 0.35552, 0.14411, 72, 12, 96, 1 },
	{ 0.1788, 0.35552, 0.14969, 72, 12, 120, 1 },
	{ 0.1788, 0.35552, 0.15517, 72, 12, 144, 1 },
	{ 0.1788, 0.35552, 0.15865, 72, 12, 168, 1 },
	{ 0.1788, 0.35552, 0.15912, 72, 12, 180, 1 },
	{ 0.1788, 0.34748, 0.14763, 72, 24, 0, 1 },
	{ 0.1788, 0.34748, 0.14696, 72, 24, 24, 1 },
	{ 0.1788, 0.34748, 0.14649, 72, 24, 48, 1 },
	{ 0.1788, 0.34748, 0.14944, 72, 24, 72, 1 },
	{ 0.1788, 0.34748, 0.15841, 72, 24, 96, 1 },
	{ 0.1788, 0.34748, 0.17353, 72, 24, 120, 1 },
	{ 0.1788, 0.34748, 0.19093, 72, 24, 144, 1 },
	{ 0.1788, 0.34748, 0.20302, 72, 24, 168, 1 },
	{ 0.1788, 0.34748, 0.20474, 72, 24, 180, 1 },
	{ 0.1788, 0.33228, 0.17461, 72, 36, 0, 1 },
	{ 0.1788, 0.33228, 0.17158, 72, 36, 24, 1 },
	{ 0.1788, 0.33228, 0.16703, 72, 36, 48, 1 },
	{ 0.1788, 0.33228, 0.16926, 72, 36, 72, 1 },
	{ 0.1788, 0.33228, 0.18486, 72, 36, 96, 1 },
	{ 0.1788, 0.33228, 0.2163, 72, 36, 120, 1 },
	{ 0.1788, 0.33228, 0.25736, 72, 36, 144, 1 },
	{ 0.1788, 0.33228, 0.28887, 72, 36, 168, 1 },
	{ 0.1788, 0.33228, 0.29355, 72, 36, 180, 1 },
	{ 0.1788, 0.3068, 0.22104, 72, 48, 0, 1 },
	{ 0.1788, 0.3068, 0.21372, 72, 48, 24, 1 },
	{ 0.1788, 0.3068, 0.20218, 72, 48, 48, 1 },
	{ 0.1788, 0.3068, 0.20324, 72, 48, 72, 1 },
	{ 0.1788, 0.3068, 0.22922, 72, 48, 96, 1 },
	{ 0.1788, 0.3068, 0.28856, 72, 48, 120, 1 },
	{ 0.1788, 0.3068, 0.37604, 72, 48, 144, 1 },
	{ 0.1788, 0.3068, 0.45152, 72, 48, 168, 1 },
	{ 0.1788, 0.3068, 0.46341, 72, 48, 180, 1 },
	{ 0.1788, 0.26589, 0.29621, 72, 60, 0, 1 },
	{ 0.1788, 0.26589, 0.28035, 72, 60, 24, 1 },
	{ 0.1788, 0.26589, 0.25875, 72, 60, 48, 1 },
	{ 0.1788, 0.26589, 0.25877, 72, 60, 72, 1 },
	{ 0.1788, 0.26589, 0.30156, 72, 60, 96, 1 },
	{ 0.1788, 0.26589, 0.40852, 72, 60, 120, 1 },
	{ 0.1788, 0.26589, 0.58749, 72, 60, 144, 1 },
	{ 0.1788, 0.26589, 0.76668, 72, 60, 168, 1 },
	{ 0.1788, 0.26589, 0.79751, 72, 60, 180, 1 },
	{ 0.1788, 0.23781, 0.35791, 72, 66, 0, 1 },
	{ 0.1788, 0.23781, 0.32683, 72, 66, 24, 1 },
	{ 0.1788, 0.23781, 0.29881, 72, 66, 48, 1 },
	{ 0.1788, 0.23781, 0.29825, 72, 66, 72, 1 },
	{ 0.1788, 0.23781, 0.35272, 72, 66, 96, 1 },
	{ 0.1788, 0.23781, 0.49468, 72, 66, 120, 1 },
	{ 0.1788, 0.23781, 0.74858, 72, 66, 144, 1 },
	{ 0.1788, 0.23781, 1.02693, 72, 66, 168, 1 },
	{ 0.1788, 0.23781, 1.07776, 72, 66, 180, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 0, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 24, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 48, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 72, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 96, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 120, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 144, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 168, 1 },
	{ 0.1788, 0.23864, 0.17407, 84, 0, 180, 1 },
	{ 0.1788, 0.23696, 0.16848, 84, 12, 0, 1 },
	{ 0.1788, 0.23696, 0.1689, 84, 12, 24, 1 },
	{ 0.1788, 0.23696, 0.17056, 84, 12, 48, 1 },
	{ 0.1788, 0.23696, 0.17438, 84, 12, 72, 1 },
	{ 0.1788, 0.23696, 0.18093, 84, 12, 96, 1 },
	{ 0.1788, 0.23696, 0.18966, 84, 12, 120, 1 },
	{ 0.1788, 0.23696, 0.19838, 84, 12, 144, 1 },
	{ 0.1788, 0.23696, 0.20394, 84, 12, 168, 1 },
	{ 0.1788, 0.23696, 0.20471, 84, 12, 180, 1 },
	{ 0.1788, 0.2316, 0.18351, 84, 24, 0, 1 },
	{ 0.1788, 0.2316, 0.18266, 84, 24, 24, 1 },
	{ 0.1788, 0.2316, 0.18204, 84, 24, 48, 1 },
	{ 0.1788, 0.2316, 0.18617, 84, 24, 72, 1 },
	{ 0.1788, 0.2316, 0.19935, 84, 24, 96, 1 },
	{ 0.1788, 0.2316, 0.22258, 84, 24, 120, 1 },
	{ 0.1788, 0.2316, 0.25047, 84, 24, 144, 1 },
	{ 0.1788, 0.2316, 0.27055, 84, 24, 168, 1 },
	{ 0.1788, 0.2316, 0.27344, 84, 24, 180, 1 },
	{ 0.1788, 0.22147, 0.2207, 84, 36, 0, 1 },
	{ 0.1788, 0.22147, 0.21686, 84, 36, 24, 1 },
	{ 0.1788, 0.22147, 0.21032, 84, 36, 48, 1 },
	{ 0.1788, 0.22147, 0.21216, 84, 36, 72, 1 },
	{ 0.1788, 0.22147, 0.23353, 84, 36, 96, 1 },
	{ 0.1788, 0.22147, 0.28082, 84, 36, 120, 1 },
	{ 0.1788, 0.22147, 0.34748, 84, 36, 144, 1 },
	{ 0.1788, 0.22147, 0.40229, 84, 36, 168, 1 },
	{ 0.1788, 0.22147, 0.41071, 84, 36, 180, 1 },
	{ 0.1788, 0.20449, 0.28864, 84, 48, 0, 1 },
	{ 0.1788, 0.20449, 0.27913, 84, 48, 24, 1 },
	{ 0.1788, 0.20449, 0.26199, 84, 48, 48, 1 },
	{ 0.1788, 0.20449, 0.25919, 84, 48, 72, 1 },
	{ 0.1788, 0.20449, 0.29244, 84, 48, 96, 1 },
	{ 0.1788, 0.20449, 0.3801, 84, 48, 120, 1 },
	{ 0.1788, 0.20449, 0.52466, 84, 48, 144, 1 },
	{ 0.1788, 0.20449, 0.66491, 84, 48, 168, 1 },
	{ 0.1788, 0.20449, 0.68858, 84, 48, 180, 1 },
	{ 0.1788, 0.17722, 0.40875, 84, 60, 0, 1 },
	{ 0.1788, 0.17722, 0.38889, 84, 60, 24, 1 },
	{ 0.1788, 0.17722, 0.35334, 84, 60, 48, 1 },
	{ 0.1788, 0.17722, 0.3428, 84, 60, 72, 1 },
	{ 0.1788, 0.17722, 0.39528, 84, 60, 96, 1 },
	{ 0.1788, 0.17722, 0.55297, 84, 60, 120, 1 },
	{ 0.1788, 0.17722, 0.85676, 84, 60, 144, 1 },
	{ 0.1788, 0.17722, 1.22185, 84, 60, 168, 1 },
	{ 0.1788, 0.17722, 1.29259, 84, 60, 180, 1 },
	{ 0.1788, 0.1585, 0.50318, 84, 66, 0, 1 },
	{ 0.1788, 0.1585, 0.47526, 84, 66, 24, 1 },
	{ 0.1788, 0.1585, 0.42535, 84, 66, 48, 1 },
	{ 0.1788, 0.1585, 0.40869, 84, 66, 72, 1 },
	{ 0.1788, 0.1585, 0.47549, 84, 66, 96, 1 },
	{ 0.1788, 0.1585, 0.68763, 84, 66, 120, 1 },
	{ 0.1788, 0.1585, 1.1283, 84, 66, 144, 1 },
	{ 0.1788, 0.1585, 1.72918, 84, 66, 168, 1 },
	{ 0.1788, 0.1585, 1.85796, 84, 66, 180, 1 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 0, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 24, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 48, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 72, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 96, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 120, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 144, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 168, 1.5 },
	{ 0.21056, 0.49555, 0.1048, 0, 0, 180, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 0, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 24, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 48, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 72, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 96, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 120, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 144, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 168, 1.5 },
	{ 0.21056, 0.49056, 0.09826, 0, 12, 180, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 0, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 24, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 48, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 72, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 96, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 120, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 144, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 168, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 0, 24, 180, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 0, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 24, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 48, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 72, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 96, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 120, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 144, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 168, 1.5 },
	{ 0.21056, 0.4462, 0.10551, 0, 36, 180, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 0, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 24, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 48, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 72, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 96, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 120, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 144, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 168, 1.5 },
	{ 0.21056, 0.40095, 0.11806, 0, 48, 180, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 0, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 24, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 48, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 72, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 96, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 120, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 144, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 168, 1.5 },
	{ 0.21056, 0.33528, 0.13856, 0, 60, 180, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 0, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 24, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 48, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 72, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 96, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 120, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 144, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 168, 1.5 },
	{ 0.21056, 0.29494, 0.1513, 0, 66, 180, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 0, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 24, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 48, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 72, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 96, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 120, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 144, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 168, 1.5 },
	{ 0.21056, 0.49056, 0.09827, 12, 0, 180, 1.5 },
	{ 0.21056, 0.48561, 0.10859, 12, 12, 0, 1.5 },
	{ 0.21056, 0.48561, 0.10625, 12, 12, 24, 1.5 },
	{ 0.21056, 0.48561, 0.1017, 12, 12, 48, 1.5 },
	{ 0.21056, 0.48561, 0.099, 12, 12, 72, 1.5 },
	{ 0.21056, 0.48561, 0.09774, 12, 12, 96, 1.5 },
	{ 0.21056, 0.48561, 0.0969, 12, 12, 120, 1.5 },
	{ 0.21056, 0.48561, 0.09632, 12, 12, 144, 1.5 },
	{ 0.21056, 0.48561, 0.09605, 12, 12, 168, 1.5 },
	{ 0.21056, 0.48561, 0.096, 12, 12, 180, 1.5 },
	{ 0.21056, 0.47006, 0.10588, 12, 24, 0, 1.5 },
	{ 0.21056, 0.47006, 0.10483, 12, 24, 24, 1.5 },
	{ 0.21056, 0.47006, 0.10324, 12, 24, 48, 1.5 },
	{ 0.21056, 0.47006, 0.10169, 12, 24, 72, 1.5 },
	{ 0.21056, 0.47006, 0.10025, 12, 24, 96, 1.5 },
	{ 0.21056, 0.47006, 0.09916, 12, 24, 120, 1.5 },
	{ 0.21056, 0.47006, 0.09851, 12, 24, 144, 1.5 },
	{ 0.21056, 0.47006, 0.09823, 12, 24, 168, 1.5 },
	{ 0.21056, 0.47006, 0.09819, 12, 24, 180, 1.5 },
	{ 0.21056, 0.4417, 0.11155, 12, 36, 0, 1.5 },
	{ 0.21056, 0.4417, 0.11102, 12, 36, 24, 1.5 },
	{ 0.21056, 0.4417, 0.10971, 12, 36, 48, 1.5 },
	{ 0.21056, 0.4417, 0.10821, 12, 36, 72, 1.5 },
	{ 0.21056, 0.4417, 0.10709, 12, 36, 96, 1.5 },
	{ 0.21056, 0.4417, 0.10655, 12, 36, 120, 1.5 },
	{ 0.21056, 0.4417, 0.10645, 12, 36, 144, 1.5 },
	{ 0.21056, 0.4417, 0.10651, 12, 36, 168, 1.5 },
	{ 0.21056, 0.4417, 0.10652, 12, 36, 180, 1.5 },
	{ 0.21056, 0.39691, 0.12227, 12, 48, 0, 1.5 },
	{ 0.21056, 0.39691, 0.12191, 12, 48, 24, 1.5 },
	{ 0.21056, 0.39691, 0.12115, 12, 48, 48, 1.5 },
	{ 0.21056, 0.39691, 0.12063, 12, 48, 72, 1.5 },
	{ 0.21056, 0.39691, 0.1208, 12, 48, 96, 1.5 },
	{ 0.21056, 0.39691, 0.12166, 12, 48, 120, 1.5 },
	{ 0.21056, 0.39691, 0.12278, 12, 48, 144, 1.5 },
	{ 0.21056, 0.39691, 0.12356, 12, 48, 168, 1.5 },
	{ 0.21056, 0.39691, 0.12368, 12, 48, 180, 1.5 },
	{ 0.21056, 0.3319, 0.13924, 12, 60, 0, 1.5 },
	{ 0.21056, 0.3319, 0.13922, 12, 60, 24, 1.5 },
	{ 0.21056, 0.3319, 0.13948, 12, 60, 48, 1.5 },
	{ 0.21056, 0.3319, 0.14054, 12, 60, 72, 1.5 },
	{ 0.21056, 0.3319, 0.14277, 12, 60, 96, 1.5 },
	{ 0.21056, 0.3319, 0.14592, 12, 60, 120, 1.5 },
	{ 0.21056, 0.3319, 0.14909, 12, 60, 144, 1.5 },
	{ 0.21056, 0.3319, 0.15111, 12, 60, 168, 1.5 },
	{ 0.21056, 0.3319, 0.15139, 12, 60, 180, 1.5 },
	{ 0.21056, 0.29197, 0.14968, 12, 66, 0, 1.5 },
	{ 0.21056, 0.29197, 0.14987, 12, 66, 24, 1.5 },
	{ 0.21056, 0.29197, 0.15073, 12, 66, 48, 1.5 },
	{ 0.21056, 0.29197, 0.15279, 12, 66, 72, 1.5 },
	{ 0.21056, 0.29197, 0.15637, 12, 66, 96, 1.5 },
	{ 0.21056, 0.29197, 0.16107, 12, 66, 120, 1.5 },
	{ 0.21056, 0.29197, 0.16565, 12, 66, 144, 1.5 },
	{ 0.21056, 0.29197, 0.16854, 12, 66, 168, 1.5 },
	{ 0.21056, 0.29197, 0.16893, 12, 66, 180, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 0, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 24, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 48, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 72, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 96, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 120, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 144, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 168, 1.5 },
	{ 0.21056, 0.47485, 0.09948, 24, 0, 180, 1.5 },
	{ 0.21056, 0.47006, 0.10588, 24, 12, 0, 1.5 },
	{ 0.21056, 0.47006, 0.10483, 24, 12, 24, 1.5 },
	{ 0.21056, 0.47006, 0.10325, 24, 12, 48, 1.5 },
	{ 0.21056, 0.47006, 0.10169, 24, 12, 72, 1.5 },
	{ 0.21056, 0.47006, 0.10025, 24, 12, 96, 1.5 },
	{ 0.21056, 0.47006, 0.09916, 24, 12, 120, 1.5 },
	{ 0.21056, 0.47006, 0.09851, 24, 12, 144, 1.5 },
	{ 0.21056, 0.47006, 0.09823, 24, 12, 168, 1.5 },
	{ 0.21056, 0.47006, 0.09819, 24, 12, 180, 1.5 },
	{ 0.21056, 0.455, 0.12183, 24, 24, 0, 1.5 },
	{ 0.21056, 0.455, 0.11425, 24, 24, 24, 1.5 },
	{ 0.21056, 0.455, 0.1093, 24, 24, 48, 1.5 },
	{ 0.21056, 0.455, 0.10635, 24, 24, 72, 1.5 },
	{ 0.21056, 0.455, 0.10413, 24, 24, 96, 1.5 },
	{ 0.21056, 0.455, 0.10305, 24, 24, 120, 1.5 },
	{ 0.21056, 0.455, 0.10284, 24, 24, 144, 1.5 },
	{ 0.21056, 0.455, 0.10295, 24, 24, 168, 1.5 },
	{ 0.21056, 0.455, 0.10298, 24, 24, 180, 1.5 },
	{ 0.21056, 0.42755, 0.12384, 24, 36, 0, 1.5 },
	{ 0.21056, 0.42755, 0.12131, 24, 36, 24, 1.5 },
	{ 0.21056, 0.42755, 0.11782, 24, 36, 48, 1.5 },
	{ 0.21056, 0.42755, 0.1146, 24, 36, 72, 1.5 },
	{ 0.21056, 0.42755, 0.11317, 24, 36, 96, 1.5 },
	{ 0.21056, 0.42755, 0.11362, 24, 36, 120, 1.5 },
	{ 0.21056, 0.42755, 0.11506, 24, 36, 144, 1.5 },
	{ 0.21056, 0.42755, 0.11625, 24, 36, 168, 1.5 },
	{ 0.21056, 0.42755, 0.11642, 24, 36, 180, 1.5 },
	{ 0.21056, 0.38419, 0.1351, 24, 48, 0, 1.5 },
	{ 0.21056, 0.38419, 0.13359, 24, 48, 24, 1.5 },
	{ 0.21056, 0.38419, 0.13047, 24, 48, 48, 1.5 },
	{ 0.21056, 0.38419, 0.12861, 24, 48, 72, 1.5 },
	{ 0.21056, 0.38419, 0.12961, 24, 48, 96, 1.5 },
	{ 0.21056, 0.38419, 0.13327, 24, 48, 120, 1.5 },
	{ 0.21056, 0.38419, 0.13794, 24, 48, 144, 1.5 },
	{ 0.21056, 0.38419, 0.14123, 24, 48, 168, 1.5 },
	{ 0.21056, 0.38419, 0.14169, 24, 48, 180, 1.5 },
	{ 0.21056, 0.32127, 0.15182, 24, 60, 0, 1.5 },
	{ 0.21056, 0.32127, 0.15076, 24, 60, 24, 1.5 },
	{ 0.21056, 0.32127, 0.14916, 24, 60, 48, 1.5 },
	{ 0.21056, 0.32127, 0.14996, 24, 60, 72, 1.5 },
	{ 0.21056, 0.32127, 0.15502, 24, 60, 96, 1.5 },
	{ 0.21056, 0.32127, 0.16409, 24, 60, 120, 1.5 },
	{ 0.21056, 0.32127, 0.17443, 24, 60, 144, 1.5 },
	{ 0.21056, 0.32127, 0.18149, 24, 60, 168, 1.5 },
	{ 0.21056, 0.32127, 0.18247, 24, 60, 180, 1.5 },
	{ 0.21056, 0.28262, 0.1618, 24, 66, 0, 1.5 },
	{ 0.21056, 0.28262, 0.16107, 24, 66, 24, 1.5 },
	{ 0.21056, 0.28262, 0.16041, 24, 66, 48, 1.5 },
	{ 0.21056, 0.28262, 0.16288, 24, 66, 72, 1.5 },
	{ 0.21056, 0.28262, 0.17062, 24, 66, 96, 1.5 },
	{ 0.21056, 0.28262, 0.18342, 24, 66, 120, 1.5 },
	{ 0.21056, 0.28262, 0.19781, 24, 66, 144, 1.5 },
	{ 0.21056, 0.28262, 0.20765, 24, 66, 168, 1.5 },
	{ 0.21056, 0.28262, 0.20903, 24, 66, 180, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 0, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 24, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 48, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 72, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 96, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 120, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 144, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 168, 1.5 },
	{ 0.21056, 0.4462, 0.10552, 36, 0, 180, 1.5 },
	{ 0.21056, 0.4417, 0.11157, 36, 12, 0, 1.5 },
	{ 0.21056, 0.4417, 0.11105, 36, 12, 24, 1.5 },
	{ 0.21056, 0.4417, 0.10973, 36, 12, 48, 1.5 },
	{ 0.21056, 0.4417, 0.10823, 36, 12, 72, 1.5 },
	{ 0.21056, 0.4417, 0.1071, 36, 12, 96, 1.5 },
	{ 0.21056, 0.4417, 0.10655, 36, 12, 120, 1.5 },
	{ 0.21056, 0.4417, 0.10645, 36, 12, 144, 1.5 },
	{ 0.21056, 0.4417, 0.1065, 36, 12, 168, 1.5 },
	{ 0.21056, 0.4417, 0.10651, 36, 12, 180, 1.5 },
	{ 0.21056, 0.42755, 0.12385, 36, 24, 0, 1.5 },
	{ 0.21056, 0.42755, 0.12133, 36, 24, 24, 1.5 },
	{ 0.21056, 0.42755, 0.11784, 36, 24, 48, 1.5 },
	{ 0.21056, 0.42755, 0.1146, 36, 24, 72, 1.5 },
	{ 0.21056, 0.42755, 0.11317, 36, 24, 96, 1.5 },
	{ 0.21056, 0.42755, 0.11362, 36, 24, 120, 1.5 },
	{ 0.21056, 0.42755, 0.11506, 36, 24, 144, 1.5 },
	{ 0.21056, 0.42755, 0.11624, 36, 24, 168, 1.5 },
	{ 0.21056, 0.42755, 0.11642, 36, 24, 180, 1.5 },
	{ 0.21056, 0.40176, 0.14767, 36, 36, 0, 1.5 },
	{ 0.21056, 0.40176, 0.13536, 36, 36, 24, 1.5 },
	{ 0.21056, 0.40176, 0.12951, 36, 36, 48, 1.5 },
	{ 0.21056, 0.40176, 0.12551, 36, 36, 72, 1.5 },
	{ 0.21056, 0.40176, 0.12546, 36, 36, 96, 1.5 },
	{ 0.21056, 0.40176, 0.129, 36, 36, 120, 1.5 },
	{ 0.21056, 0.40176, 0.13407, 36, 36, 144, 1.5 },
	{ 0.21056, 0.40176, 0.13777, 36, 36, 168, 1.5 },
	{ 0.21056, 0.40176, 0.13832, 36, 36, 180, 1.5 },
	{ 0.21056, 0.36101, 0.15651, 36, 48, 0, 1.5 },
	{ 0.21056, 0.36101, 0.15195, 36, 48, 24, 1.5 },
	{ 0.21056, 0.36101, 0.14565, 36, 48, 48, 1.5 },
	{ 0.21056, 0.36101, 0.14273, 36, 48, 72, 1.5 },
	{ 0.21056, 0.36101, 0.14628, 36, 48, 96, 1.5 },
	{ 0.21056, 0.36101, 0.15576, 36, 48, 120, 1.5 },
	{ 0.21056, 0.36101, 0.16775, 36, 48, 144, 1.5 },
	{ 0.21056, 0.36101, 0.17633, 36, 48, 168, 1.5 },
	{ 0.21056, 0.36101, 0.17756, 36, 48, 180, 1.5 },
	{ 0.21056, 0.30189, 0.17635, 36, 60, 0, 1.5 },
	{ 0.21056, 0.30189, 0.17306, 36, 60, 24, 1.5 },
	{ 0.21056, 0.30189, 0.16764, 36, 60, 48, 1.5 },
	{ 0.21056, 0.30189, 0.16775, 36, 60, 72, 1.5 },
	{ 0.21056, 0.30189, 0.17748, 36, 60, 96, 1.5 },
	{ 0.21056, 0.30189, 0.19712, 36, 60, 120, 1.5 },
	{ 0.21056, 0.30189, 0.22148, 36, 60, 144, 1.5 },
	{ 0.21056, 0.30189, 0.2392, 36, 60, 168, 1.5 },
	{ 0.21056, 0.30189, 0.24177, 36, 60, 180, 1.5 },
	{ 0.21056, 0.26556, 0.18812, 36, 66, 0, 1.5 },
	{ 0.21056, 0.26556, 0.18506, 36, 66, 24, 1.5 },
	{ 0.21056, 0.26556, 0.18058, 36, 66, 48, 1.5 },
	{ 0.21056, 0.26556, 0.18268, 36, 66, 72, 1.5 },
	{ 0.21056, 0.26556, 0.19654, 36, 66, 96, 1.5 },
	{ 0.21056, 0.26556, 0.22324, 36, 66, 120, 1.5 },
	{ 0.21056, 0.26556, 0.25667, 36, 66, 144, 1.5 },
	{ 0.21056, 0.26556, 0.28147, 36, 66, 168, 1.5 },
	{ 0.21056, 0.26556, 0.28508, 36, 66, 180, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 0, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 24, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 48, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 72, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 96, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 120, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 144, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 168, 1.5 },
	{ 0.21056, 0.40095, 0.11808, 48, 0, 180, 1.5 },
	{ 0.21056, 0.39691, 0.1223, 48, 12, 0, 1.5 },
	{ 0.21056, 0.39691, 0.12194, 48, 12, 24, 1.5 },
	{ 0.21056, 0.39691, 0.12118, 48, 12, 48, 1.5 },
	{ 0.21056, 0.39691, 0.12066, 48, 12, 72, 1.5 },
	{ 0.21056, 0.39691, 0.12081, 48, 12, 96, 1.5 },
	{ 0.21056, 0.39691, 0.12167, 48, 12, 120, 1.5 },
	{ 0.21056, 0.39691, 0.12279, 48, 12, 144, 1.5 },
	{ 0.21056, 0.39691, 0.12358, 48, 12, 168, 1.5 },
	{ 0.21056, 0.39691, 0.12368, 48, 12, 180, 1.5 },
	{ 0.21056, 0.38419, 0.13513, 48, 24, 0, 1.5 },
	{ 0.21056, 0.38419, 0.13362, 48, 24, 24, 1.5 },
	{ 0.21056, 0.38419, 0.1305, 48, 24, 48, 1.5 },
	{ 0.21056, 0.38419, 0.12864, 48, 24, 72, 1.5 },
	{ 0.21056, 0.38419, 0.12963, 48, 24, 96, 1.5 },
	{ 0.21056, 0.38419, 0.13328, 48, 24, 120, 1.5 },
	{ 0.21056, 0.38419, 0.13795, 48, 24, 144, 1.5 },
	{ 0.21056, 0.38419, 0.14123, 48, 24, 168, 1.5 },
	{ 0.21056, 0.38419, 0.1417, 48, 24, 180, 1.5 },
	{ 0.21056, 0.36101, 0.15653, 48, 36, 0, 1.5 },
	{ 0.21056, 0.36101, 0.15197, 48, 36, 24, 1.5 },
	{ 0.21056, 0.36101, 0.14567, 48, 36, 48, 1.5 },
	{ 0.21056, 0.36101, 0.14275, 48, 36, 72, 1.5 },
	{ 0.21056, 0.36101, 0.14629, 48, 36, 96, 1.5 },
	{ 0.21056, 0.36101, 0.15578, 48, 36, 120, 1.5 },
	{ 0.21056, 0.36101, 0.16776, 48, 36, 144, 1.5 },
	{ 0.21056, 0.36101, 0.17634, 48, 36, 168, 1.5 },
	{ 0.21056, 0.36101, 0.17757, 48, 36, 180, 1.5 },
	{ 0.21056, 0.3244, 0.19384, 48, 48, 0, 1.5 },
	{ 0.21056, 0.3244, 0.1763, 48, 48, 24, 1.5 },
	{ 0.21056, 0.3244, 0.16717, 48, 48, 48, 1.5 },
	{ 0.21056, 0.3244, 0.16467, 48, 48, 72, 1.5 },
	{ 0.21056, 0.3244, 0.17346, 48, 48, 96, 1.5 },
	{ 0.21056, 0.3244, 0.19348, 48, 48, 120, 1.5 },
	{ 0.21056, 0.3244, 0.21924, 48, 48, 144, 1.5 },
	{ 0.21056, 0.3244, 0.23837, 48, 48, 168, 1.5 },
	{ 0.21056, 0.3244, 0.24119, 48, 48, 180, 1.5 },
	{ 0.21056, 0.27127, 0.21441, 48, 60, 0, 1.5 },
	{ 0.21056, 0.27127, 0.20635, 48, 60, 24, 1.5 },
	{ 0.21056, 0.27127, 0.19594, 48, 60, 48, 1.5 },
	{ 0.21056, 0.27127, 0.19598, 48, 60, 72, 1.5 },
	{ 0.21056, 0.27127, 0.21365, 48, 60, 96, 1.5 },
	{ 0.21056, 0.27127, 0.25146, 48, 60, 120, 1.5 },
	{ 0.21056, 0.27127, 0.30226, 48, 60, 144, 1.5 },
	{ 0.21056, 0.27127, 0.34218, 48, 60, 168, 1.5 },
	{ 0.21056, 0.27127, 0.34818, 48, 60, 180, 1.5 },
	{ 0.21056, 0.23863, 0.23007, 48, 66, 0, 1.5 },
	{ 0.21056, 0.23863, 0.22326, 48, 66, 24, 1.5 },
	{ 0.21056, 0.23863, 0.21287, 48, 66, 48, 1.5 },
	{ 0.21056, 0.23863, 0.21475, 48, 66, 72, 1.5 },
	{ 0.21056, 0.23863, 0.23833, 48, 66, 96, 1.5 },
	{ 0.21056, 0.23863, 0.28851, 48, 66, 120, 1.5 },
	{ 0.21056, 0.23863, 0.35816, 48, 66, 144, 1.5 },
	{ 0.21056, 0.23863, 0.41502, 48, 66, 168, 1.5 },
	{ 0.21056, 0.23863, 0.42374, 48, 66, 180, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 0, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 24, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 48, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 72, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 96, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 120, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 144, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 168, 1.5 },
	{ 0.21056, 0.33528, 0.13863, 60, 0, 180, 1.5 },
	{ 0.21056, 0.3319, 0.13932, 60, 12, 0, 1.5 },
	{ 0.21056, 0.3319, 0.13931, 60, 12, 24, 1.5 },
	{ 0.21056, 0.3319, 0.13956, 60, 12, 48, 1.5 },
	{ 0.21056, 0.3319, 0.14061, 60, 12, 72, 1.5 },
	{ 0.21056, 0.3319, 0.14284, 60, 12, 96, 1.5 },
	{ 0.21056, 0.3319, 0.14598, 60, 12, 120, 1.5 },
	{ 0.21056, 0.3319, 0.14915, 60, 12, 144, 1.5 },
	{ 0.21056, 0.3319, 0.15117, 60, 12, 168, 1.5 },
	{ 0.21056, 0.3319, 0.15144, 60, 12, 180, 1.5 },
	{ 0.21056, 0.32127, 0.15192, 60, 24, 0, 1.5 },
	{ 0.21056, 0.32127, 0.15086, 60, 24, 24, 1.5 },
	{ 0.21056, 0.32127, 0.14924, 60, 24, 48, 1.5 },
	{ 0.21056, 0.32127, 0.15003, 60, 24, 72, 1.5 },
	{ 0.21056, 0.32127, 0.15509, 60, 24, 96, 1.5 },
	{ 0.21056, 0.32127, 0.16416, 60, 24, 120, 1.5 },
	{ 0.21056, 0.32127, 0.17449, 60, 24, 144, 1.5 },
	{ 0.21056, 0.32127, 0.18155, 60, 24, 168, 1.5 },
	{ 0.21056, 0.32127, 0.18253, 60, 24, 180, 1.5 },
	{ 0.21056, 0.30189, 0.17646, 60, 36, 0, 1.5 },
	{ 0.21056, 0.30189, 0.17316, 60, 36, 24, 1.5 },
	{ 0.21056, 0.30189, 0.16774, 60, 36, 48, 1.5 },
	{ 0.21056, 0.30189, 0.16783, 60, 36, 72, 1.5 },
	{ 0.21056, 0.30189, 0.17756, 60, 36, 96, 1.5 },
	{ 0.21056, 0.30189, 0.19719, 60, 36, 120, 1.5 },
	{ 0.21056, 0.30189, 0.22155, 60, 36, 144, 1.5 },
	{ 0.21056, 0.30189, 0.23928, 60, 36, 168, 1.5 },
	{ 0.21056, 0.30189, 0.24184, 60, 36, 180, 1.5 },
	{ 0.21056, 0.27127, 0.2145, 60, 48, 0, 1.5 },
	{ 0.21056, 0.27127, 0.20644, 60, 48, 24, 1.5 },
	{ 0.21056, 0.27127, 0.19602, 60, 48, 48, 1.5 },
	{ 0.21056, 0.27127, 0.19605, 60, 48, 72, 1.5 },
	{ 0.21056, 0.27127, 0.21371, 60, 48, 96, 1.5 },
	{ 0.21056, 0.27127, 0.25153, 60, 48, 120, 1.5 },
	{ 0.21056, 0.27127, 0.30233, 60, 48, 144, 1.5 },
	{ 0.21056, 0.27127, 0.34225, 60, 48, 168, 1.5 },
	{ 0.21056, 0.27127, 0.34825, 60, 48, 180, 1.5 },
	{ 0.21056, 0.22685, 0.27756, 60, 60, 0, 1.5 },
	{ 0.21056, 0.22685, 0.2511, 60, 60, 24, 1.5 },
	{ 0.21056, 0.22685, 0.23573, 60, 60, 48, 1.5 },
	{ 0.21056, 0.22685, 0.23716, 60, 60, 72, 1.5 },
	{ 0.21056, 0.22685, 0.26758, 60, 60, 96, 1.5 },
	{ 0.21056, 0.22685, 0.33557, 60, 60, 120, 1.5 },
	{ 0.21056, 0.22685, 0.43559, 60, 60, 144, 1.5 },
	{ 0.21056, 0.22685, 0.52243, 60, 60, 168, 1.5 },
	{ 0.21056, 0.22685, 0.53621, 60, 60, 180, 1.5 },
	{ 0.21056, 0.19955, 0.30047, 60, 66, 0, 1.5 },
	{ 0.21056, 0.19955, 0.27776, 60, 66, 24, 1.5 },
	{ 0.21056, 0.19955, 0.26008, 60, 66, 48, 1.5 },
	{ 0.21056, 0.19955, 0.26272, 60, 66, 72, 1.5 },
	{ 0.21056, 0.19955, 0.30147, 60, 66, 96, 1.5 },
	{ 0.21056, 0.19955, 0.3906, 60, 66, 120, 1.5 },
	{ 0.21056, 0.19955, 0.52874, 60, 66, 144, 1.5 },
	{ 0.21056, 0.19955, 0.65653, 60, 66, 168, 1.5 },
	{ 0.21056, 0.19955, 0.67744, 60, 66, 180, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 0, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 24, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 48, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 72, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 96, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 120, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 144, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 168, 1.5 },
	{ 0.21056, 0.25183, 0.16459, 72, 0, 180, 1.5 },
	{ 0.21056, 0.24929, 0.16053, 72, 12, 0, 1.5 },
	{ 0.21056, 0.24929, 0.16092, 72, 12, 24, 1.5 },
	{ 0.21056, 0.24929, 0.16238, 72, 12, 48, 1.5 },
	{ 0.21056, 0.24929, 0.1655, 72, 12, 72, 1.5 },
	{ 0.21056, 0.24929, 0.17057, 72, 12, 96, 1.5 },
	{ 0.21056, 0.24929, 0.17702, 72, 12, 120, 1.5 },
	{ 0.21056, 0.24929, 0.18325, 72, 12, 144, 1.5 },
	{ 0.21056, 0.24929, 0.18716, 72, 12, 168, 1.5 },
	{ 0.21056, 0.24929, 0.18769, 72, 12, 180, 1.5 },
	{ 0.21056, 0.2413, 0.17231, 72, 24, 0, 1.5 },
	{ 0.21056, 0.2413, 0.17185, 72, 24, 24, 1.5 },
	{ 0.21056, 0.2413, 0.17207, 72, 24, 48, 1.5 },
	{ 0.21056, 0.2413, 0.17622, 72, 24, 72, 1.5 },
	{ 0.21056, 0.2413, 0.1869, 72, 24, 96, 1.5 },
	{ 0.21056, 0.2413, 0.20401, 72, 24, 120, 1.5 },
	{ 0.21056, 0.2413, 0.2233, 72, 24, 144, 1.5 },
	{ 0.21056, 0.2413, 0.23657, 72, 24, 168, 1.5 },
	{ 0.21056, 0.2413, 0.23845, 72, 24, 180, 1.5 },
	{ 0.21056, 0.22674, 0.20051, 72, 36, 0, 1.5 },
	{ 0.21056, 0.22674, 0.19775, 72, 36, 24, 1.5 },
	{ 0.21056, 0.22674, 0.19412, 72, 36, 48, 1.5 },
	{ 0.21056, 0.22674, 0.19816, 72, 36, 72, 1.5 },
	{ 0.21056, 0.22674, 0.2165, 72, 36, 96, 1.5 },
	{ 0.21056, 0.22674, 0.25146, 72, 36, 120, 1.5 },
	{ 0.21056, 0.22674, 0.29617, 72, 36, 144, 1.5 },
	{ 0.21056, 0.22674, 0.33015, 72, 36, 168, 1.5 },
	{ 0.21056, 0.22674, 0.33518, 72, 36, 180, 1.5 },
	{ 0.21056, 0.20375, 0.24844, 72, 48, 0, 1.5 },
	{ 0.21056, 0.20375, 0.2414, 72, 48, 24, 1.5 },
	{ 0.21056, 0.20375, 0.23105, 72, 48, 48, 1.5 },
	{ 0.21056, 0.20375, 0.23463, 72, 48, 72, 1.5 },
	{ 0.21056, 0.20375, 0.26459, 72, 48, 96, 1.5 },
	{ 0.21056, 0.20375, 0.32938, 72, 48, 120, 1.5 },
	{ 0.21056, 0.20375, 0.42309, 72, 48, 144, 1.5 },
	{ 0.21056, 0.20375, 0.50327, 72, 48, 168, 1.5 },
	{ 0.21056, 0.20375, 0.51587, 72, 48, 180, 1.5 },
	{ 0.21056, 0.17038, 0.32321, 72, 60, 0, 1.5 },
	{ 0.21056, 0.17038, 0.30773, 72, 60, 24, 1.5 },
	{ 0.21056, 0.17038, 0.28765, 72, 60, 48, 1.5 },
	{ 0.21056, 0.17038, 0.29102, 72, 60, 72, 1.5 },
	{ 0.21056, 0.17038, 0.33897, 72, 60, 96, 1.5 },
	{ 0.21056, 0.17038, 0.45336, 72, 60, 120, 1.5 },
	{ 0.21056, 0.17038, 0.64179, 72, 60, 144, 1.5 },
	{ 0.21056, 0.17038, 0.82915, 72, 60, 168, 1.5 },
	{ 0.21056, 0.17038, 0.8613, 72, 60, 180, 1.5 },
	{ 0.21056, 0.14988, 0.38266, 72, 66, 0, 1.5 },
	{ 0.21056, 0.14988, 0.35193, 72, 66, 24, 1.5 },
	{ 0.21056, 0.14988, 0.32558, 72, 66, 48, 1.5 },
	{ 0.21056, 0.14988, 0.32879, 72, 66, 72, 1.5 },
	{ 0.21056, 0.14988, 0.38876, 72, 66, 96, 1.5 },
	{ 0.21056, 0.14988, 0.5387, 72, 66, 120, 1.5 },
	{ 0.21056, 0.14988, 0.80353, 72, 66, 144, 1.5 },
	{ 0.21056, 0.14988, 1.0922, 72, 66, 168, 1.5 },
	{ 0.21056, 0.14988, 1.14485, 72, 66, 180, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 0, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 24, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 48, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 72, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 96, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 120, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 144, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 168, 1.5 },
	{ 0.21056, 0.17306, 0.18795, 84, 0, 180, 1.5 },
	{ 0.21056, 0.17132, 0.18146, 84, 12, 0, 1.5 },
	{ 0.21056, 0.17132, 0.18198, 84, 12, 24, 1.5 },
	{ 0.21056, 0.17132, 0.18394, 84, 12, 48, 1.5 },
	{ 0.21056, 0.17132, 0.18821, 84, 12, 72, 1.5 },
	{ 0.21056, 0.17132, 0.19531, 84, 12, 96, 1.5 },
	{ 0.21056, 0.17132, 0.20459, 84, 12, 120, 1.5 },
	{ 0.21056, 0.17132, 0.21378, 84, 12, 144, 1.5 },
	{ 0.21056, 0.17132, 0.21962, 84, 12, 168, 1.5 },
	{ 0.21056, 0.17132, 0.22043, 84, 12, 180, 1.5 },
	{ 0.21056, 0.16583, 0.19619, 84, 24, 0, 1.5 },
	{ 0.21056, 0.16583, 0.19555, 84, 24, 24, 1.5 },
	{ 0.21056, 0.16583, 0.19555, 84, 24, 48, 1.5 },
	{ 0.21056, 0.16583, 0.20061, 84, 24, 72, 1.5 },
	{ 0.21056, 0.16583, 0.21496, 84, 24, 96, 1.5 },
	{ 0.21056, 0.16583, 0.23947, 84, 24, 120, 1.5 },
	{ 0.21056, 0.16583, 0.26858, 84, 24, 144, 1.5 },
	{ 0.21056, 0.16583, 0.28946, 84, 24, 168, 1.5 },
	{ 0.21056, 0.16583, 0.29247, 84, 24, 180, 1.5 },
	{ 0.21056, 0.15583, 0.23338, 84, 36, 0, 1.5 },
	{ 0.21056, 0.15583, 0.22988, 84, 36, 24, 1.5 },
	{ 0.21056, 0.15583, 0.22436, 84, 36, 48, 1.5 },
	{ 0.21056, 0.15583, 0.22774, 84, 36, 72, 1.5 },
	{ 0.21056, 0.15583, 0.25105, 84, 36, 96, 1.5 },
	{ 0.21056, 0.15583, 0.30068, 84, 36, 120, 1.5 },
	{ 0.21056, 0.15583, 0.36996, 84, 36, 144, 1.5 },
	{ 0.21056, 0.15583, 0.4268, 84, 36, 168, 1.5 },
	{ 0.21056, 0.15583, 0.43553, 84, 36, 180, 1.5 },
	{ 0.21056, 0.14002, 0.30098, 84, 48, 0, 1.5 },
	{ 0.21056, 0.14002, 0.292, 84, 48, 24, 1.5 },
	{ 0.21056, 0.14002, 0.27641, 84, 48, 48, 1.5 },
	{ 0.21056, 0.14002, 0.27598, 84, 48, 72, 1.5 },
	{ 0.21056, 0.14002, 0.31223, 84, 48, 96, 1.5 },
	{ 0.21056, 0.14002, 0.40384, 84, 48, 120, 1.5 },
	{ 0.21056, 0.14002, 0.55379, 84, 48, 144, 1.5 },
	{ 0.21056, 0.14002, 0.69917, 84, 48, 168, 1.5 },
	{ 0.21056, 0.14002, 0.72371, 84, 48, 180, 1.5 },
	{ 0.21056, 0.11709, 0.41859, 84, 60, 0, 1.5 },
	{ 0.21056, 0.11709, 0.39946, 84, 60, 24, 1.5 },
	{ 0.21056, 0.11709, 0.36624, 84, 60, 48, 1.5 },
	{ 0.21056, 0.11709, 0.35927, 84, 60, 72, 1.5 },
	{ 0.21056, 0.11709, 0.41621, 84, 60, 96, 1.5 },
	{ 0.21056, 0.11709, 0.58036, 84, 60, 120, 1.5 },
	{ 0.21056, 0.11709, 0.89514, 84, 60, 144, 1.5 },
	{ 0.21056, 0.11709, 1.27385, 84, 60, 168, 1.5 },
	{ 0.21056, 0.11709, 1.34729, 84, 60, 180, 1.5 },
	{ 0.21056, 0.103, 0.50947, 84, 66, 0, 1.5 },
	{ 0.21056, 0.103, 0.48244, 84, 66, 24, 1.5 },
	{ 0.21056, 0.103, 0.43543, 84, 66, 48, 1.5 },
	{ 0.21056, 0.103, 0.42317, 84, 66, 72, 1.5 },
	{ 0.21056, 0.103, 0.49536, 84, 66, 96, 1.5 },
	{ 0.21056, 0.103, 0.71568, 84, 66, 120, 1.5 },
	{ 0.21056, 0.103, 1.17214, 84, 66, 144, 1.5 },
	{ 0.21056, 0.103, 1.79595, 84, 66, 168, 1.5 },
	{ 0.21056, 0.103, 1.92979, 84, 66, 180, 1.5 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 0, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 24, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 48, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 72, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 96, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 120, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 144, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 168, 1.95 },
	{ 0.23069, 0.39699, 0.12499, 0, 0, 180, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 0, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 24, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 48, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 72, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 96, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 120, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 144, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 168, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 0, 12, 180, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 0, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 24, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 48, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 72, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 96, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 120, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 144, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 168, 1.95 },
	{ 0.23069, 0.37649, 0.11988, 0, 24, 180, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 0, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 24, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 48, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 72, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 96, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 120, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 144, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 168, 1.95 },
	{ 0.23069, 0.34901, 0.12664, 0, 36, 180, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 0, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 24, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 48, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 72, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 96, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 120, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 144, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 168, 1.95 },
	{ 0.23069, 0.30765, 0.13966, 0, 48, 180, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 0, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 24, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 48, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 72, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 96, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 120, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 144, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 168, 1.95 },
	{ 0.23069, 0.252, 0.15896, 0, 60, 180, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 0, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 24, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 48, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 72, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 96, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 120, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 144, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 168, 1.95 },
	{ 0.23069, 0.22032, 0.16971, 0, 66, 180, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 0, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 24, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 48, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 72, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 96, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 120, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 144, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 168, 1.95 },
	{ 0.23069, 0.39199, 0.11823, 12, 0, 180, 1.95 },
	{ 0.23069, 0.38706, 0.12909, 12, 12, 0, 1.95 },
	{ 0.23069, 0.38706, 0.12663, 12, 12, 24, 1.95 },
	{ 0.23069, 0.38706, 0.12188, 12, 12, 48, 1.95 },
	{ 0.23069, 0.38706, 0.11909, 12, 12, 72, 1.95 },
	{ 0.23069, 0.38706, 0.11784, 12, 12, 96, 1.95 },
	{ 0.23069, 0.38706, 0.11702, 12, 12, 120, 1.95 },
	{ 0.23069, 0.38706, 0.11647, 12, 12, 144, 1.95 },
	{ 0.23069, 0.38706, 0.11622, 12, 12, 168, 1.95 },
	{ 0.23069, 0.38706, 0.11617, 12, 12, 180, 1.95 },
	{ 0.23069, 0.37175, 0.12644, 12, 24, 0, 1.95 },
	{ 0.23069, 0.37175, 0.12536, 12, 24, 24, 1.95 },
	{ 0.23069, 0.37175, 0.12378, 12, 24, 48, 1.95 },
	{ 0.23069, 0.37175, 0.12226, 12, 24, 72, 1.95 },
	{ 0.23069, 0.37175, 0.1209, 12, 24, 96, 1.95 },
	{ 0.23069, 0.37175, 0.1199, 12, 24, 120, 1.95 },
	{ 0.23069, 0.37175, 0.11934, 12, 24, 144, 1.95 },
	{ 0.23069, 0.37175, 0.1191, 12, 24, 168, 1.95 },
	{ 0.23069, 0.37175, 0.11908, 12, 24, 180, 1.95 },
	{ 0.23069, 0.34462, 0.13266, 12, 36, 0, 1.95 },
	{ 0.23069, 0.34462, 0.13215, 12, 36, 24, 1.95 },
	{ 0.23069, 0.34462, 0.13089, 12, 36, 48, 1.95 },
	{ 0.23069, 0.34462, 0.12951, 12, 36, 72, 1.95 },
	{ 0.23069, 0.34462, 0.12855, 12, 36, 96, 1.95 },
	{ 0.23069, 0.34462, 0.1282, 12, 36, 120, 1.95 },
	{ 0.23069, 0.34462, 0.12827, 12, 36, 144, 1.95 },
	{ 0.23069, 0.34462, 0.12843, 12, 36, 168, 1.95 },
	{ 0.23069, 0.34462, 0.12846, 12, 36, 180, 1.95 },
	{ 0.23069, 0.30378, 0.14355, 12, 48, 0, 1.95 },
	{ 0.23069, 0.30378, 0.14324, 12, 48, 24, 1.95 },
	{ 0.23069, 0.30378, 0.14262, 12, 48, 48, 1.95 },
	{ 0.23069, 0.30378, 0.14233, 12, 48, 72, 1.95 },
	{ 0.23069, 0.30378, 0.1428, 12, 48, 96, 1.95 },
	{ 0.23069, 0.30378, 0.14401, 12, 48, 120, 1.95 },
	{ 0.23069, 0.30378, 0.14542, 12, 48, 144, 1.95 },
	{ 0.23069, 0.30378, 0.14638, 12, 48, 168, 1.95 },
	{ 0.23069, 0.30378, 0.14651, 12, 48, 180, 1.95 },
	{ 0.23069, 0.24883, 0.15905, 12, 60, 0, 1.95 },
	{ 0.23069, 0.24883, 0.1591, 12, 60, 24, 1.95 },
	{ 0.23069, 0.24883, 0.15955, 12, 60, 48, 1.95 },
	{ 0.23069, 0.24883, 0.16094, 12, 60, 72, 1.95 },
	{ 0.23069, 0.24883, 0.16359, 12, 60, 96, 1.95 },
	{ 0.23069, 0.24883, 0.16717, 12, 60, 120, 1.95 },
	{ 0.23069, 0.24883, 0.17072, 12, 60, 144, 1.95 },
	{ 0.23069, 0.24883, 0.17295, 12, 60, 168, 1.95 },
	{ 0.23069, 0.24883, 0.17326, 12, 60, 180, 1.95 },
	{ 0.23069, 0.21755, 0.16747, 12, 66, 0, 1.95 },
	{ 0.23069, 0.21755, 0.16773, 12, 66, 24, 1.95 },
	{ 0.23069, 0.21755, 0.1688, 12, 66, 48, 1.95 },
	{ 0.23069, 0.21755, 0.17119, 12, 66, 72, 1.95 },
	{ 0.23069, 0.21755, 0.17518, 12, 66, 96, 1.95 },
	{ 0.23069, 0.21755, 0.18031, 12, 66, 120, 1.95 },
	{ 0.23069, 0.21755, 0.18525, 12, 66, 144, 1.95 },
	{ 0.23069, 0.21755, 0.18835, 12, 66, 168, 1.95 },
	{ 0.23069, 0.21755, 0.18877, 12, 66, 180, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 0, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 24, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 48, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 72, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 96, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 120, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 144, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 168, 1.95 },
	{ 0.23069, 0.37649, 0.11989, 24, 0, 180, 1.95 },
	{ 0.23069, 0.37175, 0.12645, 24, 12, 0, 1.95 },
	{ 0.23069, 0.37175, 0.12537, 24, 12, 24, 1.95 },
	{ 0.23069, 0.37175, 0.12379, 24, 12, 48, 1.95 },
	{ 0.23069, 0.37175, 0.12227, 24, 12, 72, 1.95 },
	{ 0.23069, 0.37175, 0.1209, 24, 12, 96, 1.95 },
	{ 0.23069, 0.37175, 0.1199, 24, 12, 120, 1.95 },
	{ 0.23069, 0.37175, 0.11934, 24, 12, 144, 1.95 },
	{ 0.23069, 0.37175, 0.1191, 24, 12, 168, 1.95 },
	{ 0.23069, 0.37175, 0.11908, 24, 12, 180, 1.95 },
	{ 0.23069, 0.35705, 0.14329, 24, 24, 0, 1.95 },
	{ 0.23069, 0.35705, 0.1354, 24, 24, 24, 1.95 },
	{ 0.23069, 0.35705, 0.13036, 24, 24, 48, 1.95 },
	{ 0.23069, 0.35705, 0.1275, 24, 24, 72, 1.95 },
	{ 0.23069, 0.35705, 0.12546, 24, 24, 96, 1.95 },
	{ 0.23069, 0.35705, 0.12463, 24, 24, 120, 1.95 },
	{ 0.23069, 0.35705, 0.12466, 24, 24, 144, 1.95 },
	{ 0.23069, 0.35705, 0.12492, 24, 24, 168, 1.95 },
	{ 0.23069, 0.35705, 0.12498, 24, 24, 180, 1.95 },
	{ 0.23069, 0.33099, 0.14551, 24, 36, 0, 1.95 },
	{ 0.23069, 0.33099, 0.14295, 24, 36, 24, 1.95 },
	{ 0.23069, 0.33099, 0.13954, 24, 36, 48, 1.95 },
	{ 0.23069, 0.33099, 0.13652, 24, 36, 72, 1.95 },
	{ 0.23069, 0.33099, 0.13548, 24, 36, 96, 1.95 },
	{ 0.23069, 0.33099, 0.13643, 24, 36, 120, 1.95 },
	{ 0.23069, 0.33099, 0.13832, 24, 36, 144, 1.95 },
	{ 0.23069, 0.33099, 0.1398, 24, 36, 168, 1.95 },
	{ 0.23069, 0.33099, 0.14001, 24, 36, 180, 1.95 },
	{ 0.23069, 0.29176, 0.15675, 24, 48, 0, 1.95 },
	{ 0.23069, 0.29176, 0.15529, 24, 48, 24, 1.95 },
	{ 0.23069, 0.29176, 0.15238, 24, 48, 48, 1.95 },
	{ 0.23069, 0.29176, 0.15095, 24, 48, 72, 1.95 },
	{ 0.23069, 0.29176, 0.15262, 24, 48, 96, 1.95 },
	{ 0.23069, 0.29176, 0.15707, 24, 48, 120, 1.95 },
	{ 0.23069, 0.29176, 0.16247, 24, 48, 144, 1.95 },
	{ 0.23069, 0.29176, 0.16619, 24, 48, 168, 1.95 },
	{ 0.23069, 0.29176, 0.16671, 24, 48, 180, 1.95 },
	{ 0.23069, 0.23898, 0.17175, 24, 60, 0, 1.95 },
	{ 0.23069, 0.23898, 0.17079, 24, 60, 24, 1.95 },
	{ 0.23069, 0.23898, 0.16952, 24, 60, 48, 1.95 },
	{ 0.23069, 0.23898, 0.17094, 24, 60, 72, 1.95 },
	{ 0.23069, 0.23898, 0.17686, 24, 60, 96, 1.95 },
	{ 0.23069, 0.23898, 0.18692, 24, 60, 120, 1.95 },
	{ 0.23069, 0.23898, 0.19815, 24, 60, 144, 1.95 },
	{ 0.23069, 0.23898, 0.20575, 24, 60, 168, 1.95 },
	{ 0.23069, 0.23898, 0.20681, 24, 60, 180, 1.95 },
	{ 0.23069, 0.20895, 0.1796, 24, 66, 0, 1.95 },
	{ 0.23069, 0.20895, 0.17898, 24, 66, 24, 1.95 },
	{ 0.23069, 0.20895, 0.17869, 24, 66, 48, 1.95 },
	{ 0.23069, 0.20895, 0.18179, 24, 66, 72, 1.95 },
	{ 0.23069, 0.20895, 0.19038, 24, 66, 96, 1.95 },
	{ 0.23069, 0.20895, 0.20413, 24, 66, 120, 1.95 },
	{ 0.23069, 0.20895, 0.21938, 24, 66, 144, 1.95 },
	{ 0.23069, 0.20895, 0.22974, 24, 66, 168, 1.95 },
	{ 0.23069, 0.20895, 0.23119, 24, 66, 180, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 0, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 24, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 48, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 72, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 96, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 120, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 144, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 168, 1.95 },
	{ 0.23069, 0.34901, 0.12666, 36, 0, 180, 1.95 },
	{ 0.23069, 0.34462, 0.13268, 36, 12, 0, 1.95 },
	{ 0.23069, 0.34462, 0.13218, 36, 12, 24, 1.95 },
	{ 0.23069, 0.34462, 0.13092, 36, 12, 48, 1.95 },
	{ 0.23069, 0.34462, 0.12953, 36, 12, 72, 1.95 },
	{ 0.23069, 0.34462, 0.12856, 36, 12, 96, 1.95 },
	{ 0.23069, 0.34462, 0.12821, 36, 12, 120, 1.95 },
	{ 0.23069, 0.34462, 0.12828, 36, 12, 144, 1.95 },
	{ 0.23069, 0.34462, 0.12844, 36, 12, 168, 1.95 },
	{ 0.23069, 0.34462, 0.12846, 36, 12, 180, 1.95 },
	{ 0.23069, 0.33099, 0.14554, 36, 24, 0, 1.95 },
	{ 0.23069, 0.33099, 0.14298, 36, 24, 24, 1.95 },
	{ 0.23069, 0.33099, 0.13956, 36, 24, 48, 1.95 },
	{ 0.23069, 0.33099, 0.13654, 36, 24, 72, 1.95 },
	{ 0.23069, 0.33099, 0.13549, 36, 24, 96, 1.95 },
	{ 0.23069, 0.33099, 0.13643, 36, 24, 120, 1.95 },
	{ 0.23069, 0.33099, 0.13832, 36, 24, 144, 1.95 },
	{ 0.23069, 0.33099, 0.1398, 36, 24, 168, 1.95 },
	{ 0.23069, 0.33099, 0.14001, 36, 24, 180, 1.95 },
	{ 0.23069, 0.30683, 0.17033, 36, 36, 0, 1.95 },
	{ 0.23069, 0.30683, 0.15765, 36, 36, 24, 1.95 },
	{ 0.23069, 0.30683, 0.1519, 36, 36, 48, 1.95 },
	{ 0.23069, 0.30683, 0.14831, 36, 36, 72, 1.95 },
	{ 0.23069, 0.30683, 0.14898, 36, 36, 96, 1.95 },
	{ 0.23069, 0.30683, 0.15341, 36, 36, 120, 1.95 },
	{ 0.23069, 0.30683, 0.15933, 36, 36, 144, 1.95 },
	{ 0.23069, 0.30683, 0.16359, 36, 36, 168, 1.95 },
	{ 0.23069, 0.30683, 0.1642, 36, 36, 180, 1.95 },
	{ 0.23069, 0.27047, 0.17883, 36, 48, 0, 1.95 },
	{ 0.23069, 0.27047, 0.17429, 36, 48, 24, 1.95 },
	{ 0.23069, 0.27047, 0.16825, 36, 48, 48, 1.95 },
	{ 0.23069, 0.27047, 0.166, 36, 48, 72, 1.95 },
	{ 0.23069, 0.27047, 0.17065, 36, 48, 96, 1.95 },
	{ 0.23069, 0.27047, 0.18151, 36, 48, 120, 1.95 },
	{ 0.23069, 0.27047, 0.19481, 36, 48, 144, 1.95 },
	{ 0.23069, 0.27047, 0.20422, 36, 48, 168, 1.95 },
	{ 0.23069, 0.27047, 0.20556, 36, 48, 180, 1.95 },
	{ 0.23069, 0.22154, 0.19674, 36, 60, 0, 1.95 },
	{ 0.23069, 0.22154, 0.19356, 36, 60, 24, 1.95 },
	{ 0.23069, 0.22154, 0.18859, 36, 60, 48, 1.95 },
	{ 0.23069, 0.22154, 0.18961, 36, 60, 72, 1.95 },
	{ 0.23069, 0.22154, 0.20071, 36, 60, 96, 1.95 },
	{ 0.23069, 0.22154, 0.222, 36, 60, 120, 1.95 },
	{ 0.23069, 0.22154, 0.24797, 36, 60, 144, 1.95 },
	{ 0.23069, 0.22154, 0.26672, 36, 60, 168, 1.95 },
	{ 0.23069, 0.22154, 0.26943, 36, 60, 180, 1.95 },
	{ 0.23069, 0.19369, 0.20622, 36, 66, 0, 1.95 },
	{ 0.23069, 0.19369, 0.2033, 36, 66, 24, 1.95 },
	{ 0.23069, 0.19369, 0.19934, 36, 66, 48, 1.95 },
	{ 0.23069, 0.19369, 0.20238, 36, 66, 72, 1.95 },
	{ 0.23069, 0.19369, 0.21757, 36, 66, 96, 1.95 },
	{ 0.23069, 0.19369, 0.24586, 36, 66, 120, 1.95 },
	{ 0.23069, 0.19369, 0.28085, 36, 66, 144, 1.95 },
	{ 0.23069, 0.19369, 0.30665, 36, 66, 168, 1.95 },
	{ 0.23069, 0.19369, 0.31041, 36, 66, 180, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 0, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 24, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 48, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 72, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 96, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 120, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 144, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 168, 1.95 },
	{ 0.23069, 0.30765, 0.13971, 48, 0, 180, 1.95 },
	{ 0.23069, 0.30378, 0.14361, 48, 12, 0, 1.95 },
	{ 0.23069, 0.30378, 0.1433, 48, 12, 24, 1.95 },
	{ 0.23069, 0.30378, 0.14267, 48, 12, 48, 1.95 },
	{ 0.23069, 0.30378, 0.14238, 48, 12, 72, 1.95 },
	{ 0.23069, 0.30378, 0.14285, 48, 12, 96, 1.95 },
	{ 0.23069, 0.30378, 0.14404, 48, 12, 120, 1.95 },
	{ 0.23069, 0.30378, 0.14546, 48, 12, 144, 1.95 },
	{ 0.23069, 0.30378, 0.14641, 48, 12, 168, 1.95 },
	{ 0.23069, 0.30378, 0.14654, 48, 12, 180, 1.95 },
	{ 0.23069, 0.29176, 0.15681, 48, 24, 0, 1.95 },
	{ 0.23069, 0.29176, 0.15534, 48, 24, 24, 1.95 },
	{ 0.23069, 0.29176, 0.15243, 48, 24, 48, 1.95 },
	{ 0.23069, 0.29176, 0.151, 48, 24, 72, 1.95 },
	{ 0.23069, 0.29176, 0.15266, 48, 24, 96, 1.95 },
	{ 0.23069, 0.29176, 0.1571, 48, 24, 120, 1.95 },
	{ 0.23069, 0.29176, 0.16251, 48, 24, 144, 1.95 },
	{ 0.23069, 0.29176, 0.16623, 48, 24, 168, 1.95 },
	{ 0.23069, 0.29176, 0.16675, 48, 24, 180, 1.95 },
	{ 0.23069, 0.27047, 0.17888, 48, 36, 0, 1.95 },
	{ 0.23069, 0.27047, 0.17433, 48, 36, 24, 1.95 },
	{ 0.23069, 0.27047, 0.16828, 48, 36, 48, 1.95 },
	{ 0.23069, 0.27047, 0.16604, 48, 36, 72, 1.95 },
	{ 0.23069, 0.27047, 0.17069, 48, 36, 96, 1.95 },
	{ 0.23069, 0.27047, 0.18155, 48, 36, 120, 1.95 },
	{ 0.23069, 0.27047, 0.19485, 48, 36, 144, 1.95 },
	{ 0.23069, 0.27047, 0.20426, 48, 36, 168, 1.95 },
	{ 0.23069, 0.27047, 0.2056, 48, 36, 180, 1.95 },
	{ 0.23069, 0.23841, 0.21655, 48, 48, 0, 1.95 },
	{ 0.23069, 0.23841, 0.19875, 48, 48, 24, 1.95 },
	{ 0.23069, 0.23841, 0.19001, 48, 48, 48, 1.95 },
	{ 0.23069, 0.23841, 0.18848, 48, 48, 72, 1.95 },
	{ 0.23069, 0.23841, 0.19886, 48, 48, 96, 1.95 },
	{ 0.23069, 0.23841, 0.22089, 48, 48, 120, 1.95 },
	{ 0.23069, 0.23841, 0.24865, 48, 48, 144, 1.95 },
	{ 0.23069, 0.23841, 0.26909, 48, 48, 168, 1.95 },
	{ 0.23069, 0.23841, 0.27208, 48, 48, 180, 1.95 },
	{ 0.23069, 0.19528, 0.23484, 48, 60, 0, 1.95 },
	{ 0.23069, 0.19528, 0.22691, 48, 60, 24, 1.95 },
	{ 0.23069, 0.19528, 0.21707, 48, 60, 48, 1.95 },
	{ 0.23069, 0.19528, 0.21835, 48, 60, 72, 1.95 },
	{ 0.23069, 0.19528, 0.23791, 48, 60, 96, 1.95 },
	{ 0.23069, 0.19528, 0.2781, 48, 60, 120, 1.95 },
	{ 0.23069, 0.19528, 0.33139, 48, 60, 144, 1.95 },
	{ 0.23069, 0.19528, 0.37298, 48, 60, 168, 1.95 },
	{ 0.23069, 0.19528, 0.37923, 48, 60, 180, 1.95 },
	{ 0.23069, 0.17074, 0.24807, 48, 66, 0, 1.95 },
	{ 0.23069, 0.17074, 0.24144, 48, 66, 24, 1.95 },
	{ 0.23069, 0.17074, 0.23172, 48, 66, 48, 1.95 },
	{ 0.23069, 0.17074, 0.23488, 48, 66, 72, 1.95 },
	{ 0.23069, 0.17074, 0.26032, 48, 66, 96, 1.95 },
	{ 0.23069, 0.17074, 0.31281, 48, 66, 120, 1.95 },
	{ 0.23069, 0.17074, 0.38488, 48, 66, 144, 1.95 },
	{ 0.23069, 0.17074, 0.44346, 48, 66, 168, 1.95 },
	{ 0.23069, 0.17074, 0.45242, 48, 66, 180, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 0, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 24, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 48, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 72, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 96, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 120, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 144, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 168, 1.95 },
	{ 0.23069, 0.252, 0.1591, 60, 0, 180, 1.95 },
	{ 0.23069, 0.24883, 0.1592, 60, 12, 0, 1.95 },
	{ 0.23069, 0.24883, 0.15925, 60, 12, 24, 1.95 },
	{ 0.23069, 0.24883, 0.15971, 60, 12, 48, 1.95 },
	{ 0.23069, 0.24883, 0.16109, 60, 12, 72, 1.95 },
	{ 0.23069, 0.24883, 0.16373, 60, 12, 96, 1.95 },
	{ 0.23069, 0.24883, 0.16732, 60, 12, 120, 1.95 },
	{ 0.23069, 0.24883, 0.17086, 60, 12, 144, 1.95 },
	{ 0.23069, 0.24883, 0.1731, 60, 12, 168, 1.95 },
	{ 0.23069, 0.24883, 0.1734, 60, 12, 180, 1.95 },
	{ 0.23069, 0.23898, 0.17192, 60, 24, 0, 1.95 },
	{ 0.23069, 0.23898, 0.17095, 60, 24, 24, 1.95 },
	{ 0.23069, 0.23898, 0.16968, 60, 24, 48, 1.95 },
	{ 0.23069, 0.23898, 0.17109, 60, 24, 72, 1.95 },
	{ 0.23069, 0.23898, 0.17701, 60, 24, 96, 1.95 },
	{ 0.23069, 0.23898, 0.18707, 60, 24, 120, 1.95 },
	{ 0.23069, 0.23898, 0.19831, 60, 24, 144, 1.95 },
	{ 0.23069, 0.23898, 0.20591, 60, 24, 168, 1.95 },
	{ 0.23069, 0.23898, 0.20697, 60, 24, 180, 1.95 },
	{ 0.23069, 0.22154, 0.19691, 60, 36, 0, 1.95 },
	{ 0.23069, 0.22154, 0.19373, 60, 36, 24, 1.95 },
	{ 0.23069, 0.22154, 0.18875, 60, 36, 48, 1.95 },
	{ 0.23069, 0.22154, 0.18976, 60, 36, 72, 1.95 },
	{ 0.23069, 0.22154, 0.20086, 60, 36, 96, 1.95 },
	{ 0.23069, 0.22154, 0.22216, 60, 36, 120, 1.95 },
	{ 0.23069, 0.22154, 0.24815, 60, 36, 144, 1.95 },
	{ 0.23069, 0.22154, 0.26691, 60, 36, 168, 1.95 },
	{ 0.23069, 0.22154, 0.26962, 60, 36, 180, 1.95 },
	{ 0.23069, 0.19528, 0.23498, 60, 48, 0, 1.95 },
	{ 0.23069, 0.19528, 0.22706, 60, 48, 24, 1.95 },
	{ 0.23069, 0.19528, 0.21721, 60, 48, 48, 1.95 },
	{ 0.23069, 0.19528, 0.21847, 60, 48, 72, 1.95 },
	{ 0.23069, 0.19528, 0.23805, 60, 48, 96, 1.95 },
	{ 0.23069, 0.19528, 0.27826, 60, 48, 120, 1.95 },
	{ 0.23069, 0.19528, 0.33155, 60, 48, 144, 1.95 },
	{ 0.23069, 0.19528, 0.37318, 60, 48, 168, 1.95 },
	{ 0.23069, 0.19528, 0.37942, 60, 48, 180, 1.95 },
	{ 0.23069, 0.15996, 0.2963, 60, 60, 0, 1.95 },
	{ 0.23069, 0.15996, 0.26982, 60, 60, 24, 1.95 },
	{ 0.23069, 0.15996, 0.25518, 60, 60, 48, 1.95 },
	{ 0.23069, 0.15996, 0.25818, 60, 60, 72, 1.95 },
	{ 0.23069, 0.15996, 0.29082, 60, 60, 96, 1.95 },
	{ 0.23069, 0.15996, 0.36172, 60, 60, 120, 1.95 },
	{ 0.23069, 0.15996, 0.46494, 60, 60, 144, 1.95 },
	{ 0.23069, 0.15996, 0.55419, 60, 60, 168, 1.95 },
	{ 0.23069, 0.15996, 0.56831, 60, 60, 180, 1.95 },
	{ 0.23069, 0.13985, 0.31658, 60, 66, 0, 1.95 },
	{ 0.23069, 0.13985, 0.29413, 60, 66, 24, 1.95 },
	{ 0.23069, 0.13985, 0.27727, 60, 66, 48, 1.95 },
	{ 0.23069, 0.13985, 0.28143, 60, 66, 72, 1.95 },
	{ 0.23069, 0.13985, 0.32257, 60, 66, 96, 1.95 },
	{ 0.23069, 0.13985, 0.41449, 60, 66, 120, 1.95 },
	{ 0.23069, 0.13985, 0.55596, 60, 66, 144, 1.95 },
	{ 0.23069, 0.13985, 0.68645, 60, 66, 168, 1.95 },
	{ 0.23069, 0.13985, 0.70776, 60, 66, 180, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 0, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 24, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 48, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 72, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 96, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 120, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 144, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 168, 1.95 },
	{ 0.23069, 0.18836, 0.1801, 72, 0, 180, 1.95 },
	{ 0.23069, 0.18599, 0.17545, 72, 12, 0, 1.95 },
	{ 0.23069, 0.18599, 0.17591, 72, 12, 24, 1.95 },
	{ 0.23069, 0.18599, 0.17757, 72, 12, 48, 1.95 },
	{ 0.23069, 0.18599, 0.18099, 72, 12, 72, 1.95 },
	{ 0.23069, 0.18599, 0.18643, 72, 12, 96, 1.95 },
	{ 0.23069, 0.18599, 0.19326, 72, 12, 120, 1.95 },
	{ 0.23069, 0.18599, 0.19981, 72, 12, 144, 1.95 },
	{ 0.23069, 0.18599, 0.20389, 72, 12, 168, 1.95 },
	{ 0.23069, 0.18599, 0.20445, 72, 12, 180, 1.95 },
	{ 0.23069, 0.17863, 0.18714, 72, 24, 0, 1.95 },
	{ 0.23069, 0.17863, 0.18681, 72, 24, 24, 1.95 },
	{ 0.23069, 0.17863, 0.18739, 72, 24, 48, 1.95 },
	{ 0.23069, 0.17863, 0.19214, 72, 24, 72, 1.95 },
	{ 0.23069, 0.17863, 0.20358, 72, 24, 96, 1.95 },
	{ 0.23069, 0.17863, 0.22154, 72, 24, 120, 1.95 },
	{ 0.23069, 0.17863, 0.24158, 72, 24, 144, 1.95 },
	{ 0.23069, 0.17863, 0.25531, 72, 24, 168, 1.95 },
	{ 0.23069, 0.17863, 0.25725, 72, 24, 180, 1.95 },
	{ 0.23069, 0.1656, 0.21545, 72, 36, 0, 1.95 },
	{ 0.23069, 0.1656, 0.21286, 72, 36, 24, 1.95 },
	{ 0.23069, 0.1656, 0.20978, 72, 36, 48, 1.95 },
	{ 0.23069, 0.1656, 0.21473, 72, 36, 72, 1.95 },
	{ 0.23069, 0.1656, 0.23429, 72, 36, 96, 1.95 },
	{ 0.23069, 0.1656, 0.27067, 72, 36, 120, 1.95 },
	{ 0.23069, 0.1656, 0.31676, 72, 36, 144, 1.95 },
	{ 0.23069, 0.1656, 0.35167, 72, 36, 168, 1.95 },
	{ 0.23069, 0.1656, 0.35683, 72, 36, 180, 1.95 },
	{ 0.23069, 0.14597, 0.26308, 72, 48, 0, 1.95 },
	{ 0.23069, 0.14597, 0.25627, 72, 48, 24, 1.95 },
	{ 0.23069, 0.14597, 0.24666, 72, 48, 48, 1.95 },
	{ 0.23069, 0.14597, 0.2515, 72, 48, 72, 1.95 },
	{ 0.23069, 0.14597, 0.28319, 72, 48, 96, 1.95 },
	{ 0.23069, 0.14597, 0.35009, 72, 48, 120, 1.95 },
	{ 0.23069, 0.14597, 0.44609, 72, 48, 144, 1.95 },
	{ 0.23069, 0.14597, 0.52798, 72, 48, 168, 1.95 },
	{ 0.23069, 0.14597, 0.54083, 72, 48, 180, 1.95 },
	{ 0.23069, 0.11957, 0.33572, 72, 60, 0, 1.95 },
	{ 0.23069, 0.11957, 0.3206, 72, 60, 24, 1.95 },
	{ 0.23069, 0.11957, 0.30156, 72, 60, 48, 1.95 },
	{ 0.23069, 0.11957, 0.30652, 72, 60, 72, 1.95 },
	{ 0.23069, 0.11957, 0.35665, 72, 60, 96, 1.95 },
	{ 0.23069, 0.11957, 0.47382, 72, 60, 120, 1.95 },
	{ 0.23069, 0.11957, 0.66575, 72, 60, 144, 1.95 },
	{ 0.23069, 0.11957, 0.85627, 72, 60, 168, 1.95 },
	{ 0.23069, 0.11957, 0.88891, 72, 60, 180, 1.95 },
	{ 0.23069, 0.10454, 0.39262, 72, 66, 0, 1.95 },
	{ 0.23069, 0.10454, 0.36247, 72, 66, 24, 1.95 },
	{ 0.23069, 0.10454, 0.33748, 72, 66, 48, 1.95 },
	{ 0.23069, 0.10454, 0.34227, 72, 66, 72, 1.95 },
	{ 0.23069, 0.10454, 0.40455, 72, 66, 96, 1.95 },
	{ 0.23069, 0.10454, 0.55753, 72, 66, 120, 1.95 },
	{ 0.23069, 0.10454, 0.82662, 72, 66, 144, 1.95 },
	{ 0.23069, 0.10454, 1.11979, 72, 66, 168, 1.95 },
	{ 0.23069, 0.10454, 1.17301, 72, 66, 180, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 0, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 24, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 48, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 72, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 96, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 120, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 144, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 168, 1.95 },
	{ 0.23069, 0.1313, 0.19743, 84, 0, 180, 1.95 },
	{ 0.23069, 0.12964, 0.1902, 84, 12, 0, 1.95 },
	{ 0.23069, 0.12964, 0.1908, 84, 12, 24, 1.95 },
	{ 0.23069, 0.12964, 0.19297, 84, 12, 48, 1.95 },
	{ 0.23069, 0.12964, 0.19756, 84, 12, 72, 1.95 },
	{ 0.23069, 0.12964, 0.20506, 84, 12, 96, 1.95 },
	{ 0.23069, 0.12964, 0.21474, 84, 12, 120, 1.95 },
	{ 0.23069, 0.12964, 0.22427, 84, 12, 144, 1.95 },
	{ 0.23069, 0.12964, 0.23031, 84, 12, 168, 1.95 },
	{ 0.23069, 0.12964, 0.23114, 84, 12, 180, 1.95 },
	{ 0.23069, 0.12452, 0.20441, 84, 24, 0, 1.95 },
	{ 0.23069, 0.12452, 0.20392, 84, 24, 24, 1.95 },
	{ 0.23069, 0.12452, 0.20438, 84, 24, 48, 1.95 },
	{ 0.23069, 0.12452, 0.21012, 84, 24, 72, 1.95 },
	{ 0.23069, 0.12452, 0.22529, 84, 24, 96, 1.95 },
	{ 0.23069, 0.12452, 0.25073, 84, 24, 120, 1.95 },
	{ 0.23069, 0.12452, 0.28072, 84, 24, 144, 1.95 },
	{ 0.23069, 0.12452, 0.30219, 84, 24, 168, 1.95 },
	{ 0.23069, 0.12452, 0.30528, 84, 24, 180, 1.95 },
	{ 0.23069, 0.11543, 0.24101, 84, 36, 0, 1.95 },
	{ 0.23069, 0.11543, 0.23778, 84, 36, 24, 1.95 },
	{ 0.23069, 0.11543, 0.23301, 84, 36, 48, 1.95 },
	{ 0.23069, 0.11543, 0.2375, 84, 36, 72, 1.95 },
	{ 0.23069, 0.11543, 0.26218, 84, 36, 96, 1.95 },
	{ 0.23069, 0.11543, 0.31348, 84, 36, 120, 1.95 },
	{ 0.23069, 0.11543, 0.38469, 84, 36, 144, 1.95 },
	{ 0.23069, 0.11543, 0.44307, 84, 36, 168, 1.95 },
	{ 0.23069, 0.11543, 0.45203, 84, 36, 180, 1.95 },
	{ 0.23069, 0.10175, 0.3074, 84, 48, 0, 1.95 },
	{ 0.23069, 0.10175, 0.29881, 84, 48, 24, 1.95 },
	{ 0.23069, 0.10175, 0.28437, 84, 48, 48, 1.95 },
	{ 0.23069, 0.10175, 0.28564, 84, 48, 72, 1.95 },
	{ 0.23069, 0.10175, 0.32399, 84, 48, 96, 1.95 },
	{ 0.23069, 0.10175, 0.41843, 84, 48, 120, 1.95 },
	{ 0.23069, 0.10175, 0.57244, 84, 48, 144, 1.95 },
	{ 0.23069, 0.10175, 0.72184, 84, 48, 168, 1.95 },
	{ 0.23069, 0.10175, 0.74706, 84, 48, 180, 1.95 },
	{ 0.23069, 0.08334, 0.42187, 84, 60, 0, 1.95 },
	{ 0.23069, 0.08334, 0.40329, 84, 60, 24, 1.95 },
	{ 0.23069, 0.08334, 0.37178, 84, 60, 48, 1.95 },
	{ 0.23069, 0.08334, 0.36737, 84, 60, 72, 1.95 },
	{ 0.23069, 0.08334, 0.42745, 84, 60, 96, 1.95 },
	{ 0.23069, 0.08334, 0.59629, 84, 60, 120, 1.95 },
	{ 0.23069, 0.08334, 0.91961, 84, 60, 144, 1.95 },
	{ 0.23069, 0.08334, 1.30934, 84, 60, 168, 1.95 },
	{ 0.23069, 0.08334, 1.38498, 84, 60, 180, 1.95 },
	{ 0.23069, 0.07287, 0.50961, 84, 66, 0, 1.95 },
	{ 0.23069, 0.07287, 0.48324, 84, 66, 24, 1.95 },
	{ 0.23069, 0.07287, 0.43835, 84, 66, 48, 1.95 },
	{ 0.23069, 0.07287, 0.42929, 84, 66, 72, 1.95 },
	{ 0.23069, 0.07287, 0.50533, 84, 66, 96, 1.95 },
	{ 0.23069, 0.07287, 0.73173, 84, 66, 120, 1.95 },
	{ 0.23069, 0.07287, 1.2007, 84, 66, 144, 1.95 },
	{ 0.23069, 0.07287, 1.84325, 84, 66, 168, 1.95 },
	{ 0.23069, 0.07287, 1.98126, 84, 66, 180, 1.95 } };
#pragma endregion 
	int searchSolZen = 0, searchSenZen = 0, searchRelAzi = 0;
	int trueSolzen = 0, trueSenZen = 0, trueRelAzi = 0;
	int trueRow = 0;
	float minthereflectivity = 0, thereflectivity = 0;
	//int outTableCol = searchTabColCount ;    //ұ ұ87У8*7ұ40*7
	//int outTableRow = aod550Count * intervalCount;			//ұ
	//int inTableCol = searchTabColCount ;					//ұ
	//int inTableRow = aod550Count ;							//ұ
  /////////////////////////////////////////////////////////////////
	//2ұintable,outtable ,ΪµĲҵĲ
	//float** outTable = new	float*[outTableRow];
	//for (int i = 0; i < outTableRow; i++)
	//{
	//	outTable[i] = new float[outTableCol];
	//}
	//float** inTable = new	float*[inTableRow];//87
	//for (int i = 0; i < inTableRow; i++)
	//{
	//	inTable[i] = new float[inTableCol];
	//}

	//for (int i = 0; i < inTableRow; i++)
	//{
	//	for (int  j = 0; j < inTableCol; j++)
	//	{
	//		inTable[i][j] = 0.0;
	//	}

	//}
	//////////////////////////////////////////////////
	//
	for (int i = 0; i < height; i++)
	{
		for (int j = 0; j < width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				aodOptimal[i][j] = aodSumSearchTable[0][0];//ʼһ Ĭȸһֵ
				/*SearchOptimalResultFromOld(i, j, &trueRow);*/
				searchSolZen = solZenCount - 1, searchSenZen = senZenCount - 1, searchRelAzi = solAziCount -1;//Ĭֵ
				minthereflectivity = 1000000000;//minvalΪ㹻ֵ
				float devk1 = 0, devk2 = 0, devk3 = 0;
				float devkk1 = 0, devkk2, devkk3 = 0;
				for (int k = 0; k<solZenCount; k++)
				{
					if (solarzenith[i][j]<solZen[k])
					{
						searchSolZen = k;
						break;
					}
				}
				for (int k = 0; k<senZenCount; k++)
				{
					if (sensorzenith[i][j]<senZen[k])
					{
						searchSenZen = k;
						break;
					}
				}
				for (int k = 0; k<solAziCount; k++)
				{
					if ((relativeangel[i][j])<solAzi[k])
					{
						searchRelAzi = k;
						break;
					}
				}
				devk1 = solZen[searchSolZen] - solZen[searchSolZen - 1];
				devk2 = senZen[searchSenZen] - senZen[searchSenZen - 1];
				devk3 = solAzi[searchRelAzi] - solAzi[searchRelAzi - 1];
				if (solarzenith[i][j]>(solZen[searchSolZen - 1] + solZen[searchSolZen]) / 2)
				{
					devkk1 = abs (solarzenith[i][j] - solZen[searchSolZen]);
					trueSolzen = searchSolZen;
				}
				else
				{
					devkk1 = abs (solarzenith[i][j] - solZen[searchSolZen - 1]);
					trueSolzen = searchSolZen - 1;
				}
				if (sensorzenith[i][j]>(senZen[searchSenZen - 1] + senZen[searchSenZen]) / 2)
				{
					devkk2 = abs (sensorzenith[i][j] - senZen[searchSenZen]);
					trueSenZen = searchSenZen;
				}
				else
				{
					devkk2 = abs (sensorzenith[i][j] - senZen[searchSenZen - 1]);
					trueSenZen = searchSenZen - 1;
				}
				if (solarazimuth[i][j]>(solAzi[searchRelAzi - 1] + solAzi[searchRelAzi]) / 2)
				{
					devkk3 = abs (solarazimuth[i][j] - solAzi[searchRelAzi]);
					trueRelAzi = searchRelAzi;
				}
				else
				{
					devkk3 = abs (solarazimuth[i][j] - solAzi[searchRelAzi - 1]);
					trueRelAzi = searchRelAzi - 1;
				}
				//const int solZenCount = 8;
				//const int senZenCount = 7;
				//const int solAziCount = 9;
				//const int aod550Count = 6;
			
				trueRow = (senZenCount * solAziCount) * trueSolzen + (solAziCount) * trueSenZen + (1) * trueRelAzi;
#pragma region new 
	//			////intable ֵ
	//			//for (int i = 0; i < inTableRow; i++)
	//			//{
	//			//	for (int j = 0; j < inTableCol; j++)
	//			//	{
	//			//		inTable[i][j] = aodSumSearchTable[trueRow + i * solAziCount*senZenCount*solZenCount][j];
	//			//	}
	//			//}
	//			CreateNewSeachTable(inTable, outTable, inTableCol, inTableRow, outTableCol, outTableRow);
	//			aodOptimal[i][j] =SearchOptimalResultFromNew(i,j,outTable,outTableRow,outTableCol);
	//		}
	//	}
	//}



#pragma region 
#pragma region old
				double err[6] = { 0 };
				int pp = 0;
				while (trueRow<3024)
				{
					if (seasonDay > 90 && seasonDay <273)//ʹļұ
					{
						thereflectivity = aodSumSearchTable[trueRow][2] + aodSumSearchTable[trueRow][1] * suf_band_1[i][j] / (1 - aodSumSearchTable[trueRow][0] * suf_band_1[i][j]);
						 err[pp++] = fabs(thereflectivity - band_1[i][j]);
						if (fabs (thereflectivity - band_1[i][j])<fabs (minthereflectivity - band_1[i][j]))
						{
							minthereflectivity = thereflectivity;
							//aodOptimal[i][j] = aodSumSearchTable[trueRow][6];
						}
					}
					else //ұ
					{
						thereflectivity = aodWinSearchTable[trueRow][2] + aodWinSearchTable[trueRow][1] * suf_band_1[i][j] / (1 - aodWinSearchTable[trueRow][0] * suf_band_1[i][j]);
						err[pp++] = fabs(thereflectivity - band_1[i][j]);
						//if (fabs (thereflectivity - band_1[i][j])<fabs (minthereflectivity - band_1[i][j]))
						//{
						//	//minthereflectivity = thereflectivity;
						//	//aodOptimal[i][j] = aodWinSearchTable[trueRow][6];
						//}
					}
					trueRow += 504;
				}
				aodOptimal[i][j] = Mean(err, 6, aod550);
			}
		}
	}
#pragma endregion 

	//		if (seasonDay > 90 && seasonDay <273 )//ļ
	//		{
	//			//int num=omp_get_num_procs();
	//			//omp_set_num_threads(num);
	////#pragma omp parallel
	//			for ( int i=0;i<height;i++)
	//			{
	//				for ( int j=0;j<width;j++)
	//				{
	//					minthereflectivity =1000000;
	//					if (testresult[i][j]==anxiangyuan)
	//					{
	//						for (int k=0;k<3024;k++)
	//						{
	//							thereflectivity =aodSumSearchTable[k][2] + aodSumSearchTable[k][1] * suf_band_1[i][j] /(1- aodSumSearchTable[k][0] * suf_band_1[i][j]);
	//							if (fabs(thereflectivity-band_1[i][j])<fabs(minthereflectivity-band_1[i][j]))
	//							{
	//								minthereflectivity =thereflectivity;
	//								aodOptimal[i][j]=aodSumSearchTable[k][6];
	//							}
	//						}
	//					}
	//				}
	//			}
	//		}
	//		else
	//		{
	//			//int num=omp_get_num_procs();
	//			//omp_set_num_threads(num);
	//			//#pragma omp parallel
	//			for ( int i=0;i<height;i++)
	//			{
	//				for ( int j=0;j<width;j++)
	//				{
	//					minthereflectivity =1000000;
	//					if (testresult[i][j]==anxiangyuan)
	//					{
	//
	//						for (int k=0;k<3024;k++)
	//						{
	//
	//							thereflectivity =aodWinSearchTable[k][2] + aodWinSearchTable[k][1] * suf_band_1[i][j] /(1- aodWinSearchTable[k][0] * suf_band_1[i][j]);
	//							double a =fabs(thereflectivity-band_1[i][j]);
	//							double b =fabs(minthereflectivity-band_1[i][j]);
	//							if (a<b)
	//							{
	//								minthereflectivity =thereflectivity;
	//								aodOptimal[i][j]=aodWinSearchTable[k][6];
	//							}
	//						}
	//					}
	//				}
	//			}
	//
	//		}
}



void AODRectifyHeight ()
{
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				//aodOptimal[i][j] += 0.00877 * pow (0.55, -4.05) * (1 - exp (-500 / 8.5));
				aodOptimal[i][j] += 0;
			}
		}
	}
}
int ImageCut (const char* pszSrcFile, const char* pszDstFile, int iStartX, int iStartY, int iSizeX, int iSizeY,
	const char* pszFormat)
{
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *pSrcDS = (GDALDataset*)GDALOpen (pszSrcFile, GA_ReadOnly);
	GDALDataType eDT = pSrcDS->GetRasterBand (1)->GetRasterDataType ();

	int iBandCount = pSrcDS->GetRasterCount ();

	// ݲзΧȷкͼ
	int iDstWidth = iSizeX;
	int iDstHeight = iSizeY;

	double adfGeoTransform[6] = { 0 };
	pSrcDS->GetGeoTransform (adfGeoTransform);

	// кͼϽ	
	adfGeoTransform[0] = adfGeoTransform[0] + iStartX*adfGeoTransform[1] + iStartY*adfGeoTransform[2];
	adfGeoTransform[3] = adfGeoTransform[3] + iStartX*adfGeoTransform[4] + iStartY*adfGeoTransform[5];

	// ļÿռοϢ
	GDALDriver *poDriver = (GDALDriver *)GDALGetDriverByName (pszFormat);
	GDALDataset *pDstDS = poDriver->Create (pszDstFile, iDstWidth, iDstHeight, iBandCount, eDT, NULL);
	pDstDS->SetGeoTransform (adfGeoTransform);
	pDstDS->SetProjection (pSrcDS->GetProjectionRef ());

	int *pBandMap = new int[iBandCount];
	for (int i = 0; i<iBandCount; i++)
		pBandMap[i] = i + 1;

	// Ҫжϣ벻ͬ͵Ļд8bitͼʾ
	if (eDT == GDT_Float32)
	{
		// ҪĻ棬ͼ̫Ӧ÷ֿ鴦
		DT_32F *pDataBuff = new DT_32F[iDstWidth*iDstHeight*iBandCount];

		pSrcDS->RasterIO (GF_Read, iStartX, iStartY, iSizeX, iSizeY, pDataBuff, iSizeX, iSizeY, eDT, iBandCount, pBandMap, 0, 0, 0);
		pDstDS->RasterIO (GF_Write, 0, 0, iSizeX, iSizeY, pDataBuff, iSizeX, iSizeY, eDT, iBandCount, pBandMap, 0, 0, 0);

		RELEASE (pDataBuff);
	}
	else
	{
		// ͵ͼ8bitƣĻͲͬ
	}

	RELEASE (pBandMap);

	GDALClose ((GDALDatasetH)pSrcDS);
	GDALClose ((GDALDatasetH)pDstDS);
	return RE_SUCCESS;
}
/* double SortForBuf(double* buf ,int sizeOfBuf)
{
double temp ;
for (int i=0;i<sizeOfBuf;i++)
{
for (int j=i;j<sizeOfBuf;j++)
{
if (buf[i]>buf[j])
{
temp =buf[i];
buf[i]=buf[j];
buf[j]=temp;
}
}
}
temp =buf[sizeOfBuf/2];
return temp;
}*/
int cmp (const void *a, const void *b)
{
	return *(double *)a > *(double *)b ? 1 : -1;
}
int AODShow (const char* geolocDataFile, const char* midFile, const char* spapceFilerFile, const char* dstFile)
{
	if (geolocDataFile == NULL || midFile == NULL || spapceFilerFile == NULL || dstFile == NULL)
	{
		return RE_PARAMERROR;
	}
#pragma region ȡݼϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DSData = (GDALDataset*)GDALOpen (geolocDataFile, GA_ReadOnly);
	if (DSData == NULL)
	{
		return RE_FILENOTSUPPORT;
	}
	double geoTransform[6] = { 0 };
	DSData->GetGeoTransform (geoTransform);
	//int xSize =DSData->GetRasterXSize();
	//int ySize =DSData->GetRasterYSize();
#pragma endregion 
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	GDALDataset *DSMid = Driver->Create (midFile, width, height, 1, GDT_Float32, NULL);
	DSMid->SetProjection (DSData->GetProjectionRef ());
	DSMid->SetGeoTransform (geoTransform);
#pragma region дļرݼ
	//DT_64F *pBuf = (DT_64F*)malloc(sizeof(DT_64F)* width	* height);
	DT_32F *pBuf = new DT_32F[width*height];
	int p = 0;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			if (testresult[i][j] == anxiangyuan)
			{
				//pBuf[p] = aodOptimal[i][j] * 1000;
				pBuf[p] = aodOptimal[i][j];
			}
			else
			{
				pBuf[p] = 0.0;
			}
			p++;

		}
	}
	//
	/*FILE *fp11;
	if (fp11 = fopen ("e:\\test\\apbufaodoptimal.txt", "wt+"))
	{
		for (int i = 0; i<height; i++)
		{
			for (int j = 0; j<width; j++)
			{

				fprintf (fp11, "%8.2lf\t", aodOptimal[i][j] * 1000);
			}
			fprintf (fp11, "\n");
		}

	}
	fclose (fp11);*/


	//FILE *fp12;
	//if (fp12 = fopen ("e:\\test\\apbufaodbuf.txt", "wt+"))
	//{
	//	for (int i = 0; i<width*height; i++)
	//	{
	//		if (i%width == 0)
	//		{
	//			fprintf (fp12, "\n");
	//		}
	//		else
	//		{
	//			fprintf (fp12, "%8.2lf\t", pBuf[i]);
	//		}
	//	}
	//}
	//fclose (fp12);

	DSMid->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, width, height, pBuf, width, height, GDT_Float32, 0, 0);
	//delete[]pBuf;
	RELEASE(pBuf);
	GDALClose (GDALDatasetH (DSData));
	GDALClose (GDALDatasetH (DSMid));

#pragma endregion 
	//ULLON='107.096';人
	// ULLAT='34.03'
	// LRLON='117.233'
	// LRLAT='27.177'



	//	ULLON='112.991';Ŀо
	//		ULLAT='43.81'
	//	LRLON='125.912'
	//	LRLAT='34.126'
	double	lonmin = 98.0083; 
		double lonmax = 112.0083;
	//double latmin =34.126; //34.0708
	double latmin = 24.0068;
	double latmax = 35.0030;
	//
	//double	lonmin = 120;
	//double lonmax = 130;
	////double latmin =34.126; //34.0708
	//double latmin = 38;
	//double latmax = 47;
	double startX, startY, endX, endY;
	startX = 0; startY = 0; endX = width; endY = height;
	bool flagStartX = false, flagStartY = false, flagEndX = false, flagEndY = false;
	double lon, lat;
	for (int i = 0; i<height; i++)
	{
		for (int j = 0; j<width; j++)
		{
			lon = geoTransform[0] + geoTransform[1] * j + geoTransform[2] * i;
			lat = geoTransform[3] + geoTransform[4] * j + geoTransform[5] * i;
			/*if (flagStartX == false && lon >lonmin)
			{
				startX = j;
				flagStartX = true;
			}
			if (flagStartY == false && lat<latmax)
			{
				startY = i ;
				flagStartY = true;
			}
			if (flagEndX == false && lon>lonmax)
			{
				endX = j;
				flagEndX = true;
			}
			if (flagEndY == false && lat<latmin)
			{
				endY = i;
				flagEndY = true;
			}*/
			if (!flagStartX && lon >lonmin)
			{
				startX = j;
				flagStartX = true;
			}
			if (!flagStartY && lat<latmax)
			{
				startY = i ;
				flagStartY = true;
			}
			if (!flagEndX&& lon>lonmax)
			{
				endX = j;
				flagEndX = true;
			}
			if (!flagEndY && lat<latmin)
			{
				endY = i;
				flagEndY = true;
			}
		}
		if (flagStartX && flagStartY && flagEndX && flagEndY)
		{
			break;
		}
	}
	int imageCutResult = ImageCut (midFile, spapceFilerFile, startX, startY, endX - startX , endY - startY , "GTiff");
	if (imageCutResult != RE_SUCCESS)
	{
		return imageCutResult;
	}
	//int template3_3[9]={0,1,0,1,-4,1,0,1,0};
	GDALDataset *FilDs = (GDALDataset*)GDALOpen (spapceFilerFile, GA_ReadOnly);
	int xSize = FilDs->GetRasterXSize ();
	int ySize = FilDs->GetRasterYSize ();
	FilDs->GetGeoTransform (geoTransform);
	GDALDataset *DstDS = Driver->Create (dstFile, xSize, ySize, 1, GDT_Float32, NULL);
	DstDS->SetGeoTransform (geoTransform);
	DstDS->SetProjection (FilDs->GetProjectionRef ());

	//DT_64F *pBuf1 = (DT_64F*)malloc(sizeof(DT_64F)*xSize * ySize);
	DT_32F *pBuf1 = new DT_32F[xSize*ySize];
	FilDs->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, xSize, ySize, pBuf1, xSize, ySize, GDT_Float32, 0, 0);
	DT_32F **pBuf2, **pBuf3;
	pBuf2 = new float*[ySize];
	pBuf3 = new float*[ySize];
	for (int i = 0; i<ySize; i++)
	{
		pBuf2[i] = new float[xSize];
		pBuf3[i] = new float[xSize];
	}
	p = 0;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			pBuf2[i][j] = pBuf1[p++];
			//pBuf3[i][j]=0.0;
		}
	}

	////pBuf2鿴
	//FILE *fp;
	//if (fp=fopen("e:\\test\\apbuf2.txt","wt+"))
	//{
	//	for ( int i=0;i<ySize;i++)  
	//	{
	//		for ( int j=0;j<xSize;j++)
	//		{
	//			fprintf(fp,"%8.2lf\t",pBuf2[i][j]);
	//		}	
	//		fprintf(fp,"\n");
	//	}
	//}
	//fclose(fp);
#pragma region ֵ



	int nodataCount = 0;
	int top = 1;
	int ang = 1;
	int center = 2;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			nodataCount = 0;
			if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
			{
				pBuf3[i][j] = pBuf2[i][j];
			}
			else
			{
				if (pBuf2[i - 1][j - 1] == 0.0)nodataCount++;
				if (pBuf2[i - 1][j + 1] == 0.0)nodataCount++;
				if (pBuf2[i + 1][j - 1] == 0.0)nodataCount++;
				if (pBuf2[i + 1][j + 1] == 0.0)nodataCount++;

				if (pBuf2[i][j - 1] == 0.0)nodataCount += top;
				if (pBuf2[i][j + 1] == 0.0)nodataCount += top;
				if (pBuf2[i - 1][j] == 0.0)nodataCount += top;
				if (pBuf2[i + 1][j] == 0.0)nodataCount += top;
				if (pBuf2[i][j] == 0.0)nodataCount += top;
				int all = 4 * top + ang * 4 + center;
				if (nodataCount == 4 * top + ang * 4 + center)
				{
					pBuf3[i][j] = 0.0;
				}
				else
				{
					pBuf3[i][j] = (pBuf2[i - 1][j] * top + pBuf2[i + 1][j] * top + pBuf2[i][j - 1] * top + pBuf2[i][j + 1] * top + pBuf2[i][j] * center + pBuf2[i - 1][j - 1]*ang + pBuf2[i - 1][j + 1]*ang + pBuf2[i + 1][j - 1]*ang + pBuf2[i + 1][j + 1] *ang) / (all - nodataCount);
				}
			}
		}
	}
	//for (int i = 0; i<ySize; i++)
	//{
	//	for (int j = 0; j<xSize; j++)
	//	{
	//		nodataCount = 0;
	//		if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
	//		{
	//			pBuf2[i][j] = pBuf3[i][j];
	//		}
	//		else
	//		{
	//			if (pBuf3[i - 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf3[i - 1][j + 1] == 0.0)nodataCount++;
	//			if (pBuf3[i + 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf3[i + 1][j + 1] == 0.0)nodataCount++;

	//			if (pBuf3[i][j - 1] == 0.0)nodataCount += top;
	//			if (pBuf3[i][j + 1] == 0.0)nodataCount += top;
	//			if (pBuf3[i - 1][j] == 0.0)nodataCount += top;
	//			if (pBuf3[i + 1][j] == 0.0)nodataCount += top;
	//			if (pBuf3[i][j] == 0.0)nodataCount += center;
	//			int all = 4 * top + ang * 4 + center;
	//			if (nodataCount == 16)
	//			{
	//				pBuf2[i][j] = 0.0;
	//			}
	//			else
	//			{
	//				pBuf2[i][j] = (pBuf3[i - 1][j] * top + pBuf3[i + 1][j] * top + pBuf3[i][j - 1] * top + pBuf3[i][j + 1] * top + pBuf3[i][j] * center + pBuf3[i - 1][j - 1]*ang + pBuf3[i - 1][j + 1]*ang + pBuf2[i + 1][j - 1]*ang + pBuf2[i + 1][j + 1]* ang) / (all - nodataCount);
	//			}
	//		}
	//	}
	//}
	//for (int i = 0; i<ySize; i++)
	//{
	//	for (int j = 0; j<xSize; j++)
	//	{
	//		nodataCount = 0;
	//		if (i == 0 || i == ySize - 1 || j == 0 || j == xSize - 1)//߽粻
	//		{
	//			pBuf3[i][j] = pBuf2[i][j];
	//		}
	//		else
	//		{
	//			if (pBuf2[i - 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf2[i - 1][j + 1] == 0.0)nodataCount++;
	//			if (pBuf2[i + 1][j - 1] == 0.0)nodataCount++;
	//			if (pBuf2[i + 1][j + 1] == 0.0)nodataCount++;

	//			if (pBuf2[i][j - 1] == 0.0)nodataCount += top;
	//			if (pBuf2[i][j + 1] == 0.0)nodataCount += top;
	//			if (pBuf2[i - 1][j] == 0.0)nodataCount += top;
	//			if (pBuf2[i + 1][j] == 0.0)nodataCount += top;
	//			if (pBuf2[i][j] == 0.0)nodataCount += top;
	//			int all = 4 * top + ang * 4 + center;
	//			if (nodataCount == 4 * top + ang * 4 + center)
	//			{
	//				pBuf3[i][j] = 0.0;
	//			}
	//			else
	//			{
	//				pBuf3[i][j] = (pBuf2[i - 1][j] * top + pBuf2[i + 1][j] * top + pBuf2[i][j - 1] * top + pBuf2[i][j + 1] * top + pBuf2[i][j] * center + pBuf2[i - 1][j - 1] * ang + pBuf2[i - 1][j + 1] * ang + pBuf2[i + 1][j - 1] * ang + pBuf2[i + 1][j + 1] * ang) / (all - nodataCount);
	//			}
	//		}
	//	}
	//}

#pragma endregion
	//int avgSize =5;
	//int borderSize ;
	//double *pBuf4 =new double[avgSize*avgSize];
	//for (int i=0;i<ySize;i++)
	//{
	//	for( int j=0;j<xSize;j++)
	//	{
	//		borderSize =(int)avgSize/2;
	//		if (i<borderSize|| i>ySize-borderSize-1 || j<borderSize || j>xSize-borderSize-1)//߽粻 5*5
	//		{
	//			pBuf3[i][j]=pBuf2[i][j];
	//		}
	//		else	//ȡֵ
	//		{
	//			       p =0;
	//				for ( int ii=i-borderSize;ii<=i+borderSize;ii++)
	//				{
	//					for (int jj=j-borderSize;jj<=j+borderSize;jj++)
	//					{
	//						pBuf4[p]=pBuf2[ii][jj];
	//						p++;
	//					}
	//				}
	//			//pbuf4ȡֵ				
	//			qsort(pBuf4,avgSize*avgSize,sizeof(pBuf4[0]),cmp);
	//			pBuf3[i][j]=pBuf4[avgSize*avgSize/2];
	//		}

	//	}
	//}
	//pBuf3鿴
	/*FILE *fp3;
	if (fp3=fopen("e:\\test\\apbuf3.txt","wt+"))
	{
	for ( int i=0;i<ySize;i++)
	{
	for ( int j=0;j<xSize;j++)
	{

	fprintf(fp3,"%8.2lf\t",pBuf3[i][j]);

	}
	fprintf(fp3,"\n");
	}

	}
	fclose(fp3);*/


	//////////////////////////////////////////////////////////////////////////
	p = 0;
	for (int i = 0; i<ySize; i++)
	{
		for (int j = 0; j<xSize; j++)
		{
			if (pBuf3[i][j]<0)
				/*if(pBuf2[i][j]<0)*/
			{
				pBuf1[p] = 0.0;
			}
			else
			{
				pBuf1[p] = pBuf3[i][j];
				//pBuf1[p] =pBuf2[i][j];
			}
			p++;
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, xSize, ySize, pBuf1, xSize, ySize, GDT_Float32, 0, 0);
	GDALSetRasterNoDataValue (GDALGetRasterBand (GDALDatasetH (DstDS), 1), 0.0);
	for (int i = 0; i<ySize; i++)
	{
		RELEASE (pBuf2[i]);
		RELEASE (pBuf3[i]);
		//delete []pBuf3[i];
	}
	//		delete []pBuf4;
	//delete []pBuf1;
	RELEASE (pBuf2);
	RELEASE (pBuf3);
	RELEASE (pBuf1);
	GDALClose (GDALDatasetH (FilDs));
	GDALClose (GDALDatasetH (DstDS));
	return RE_SUCCESS;
}
int AODInversion (const char* pszSrcFile2, const char* pszSrcFile3, const char* pszDstFile, int deleteFile)
{
#pragma region 1.modis2лȡļ
	string tempFileName = string (CPLGetFilename (pszSrcFile2));
	tempFileName = tempFileName.substr (0, tempFileName.find_last_of ("hdf") - 21);
	string tempPath = string (CPLGetPath (pszSrcFile2));
	tempFileName = tempPath + "\\" + tempFileName;
	string tempCreateDataFile = tempFileName + "_data.tif";//ѧݼļ
	string tempCreateAngelFile = tempFileName + "_angel.tif";//Ƕݼļ
	string tempGeolocDataFile = tempFileName + "_geolocdata.tif";//ѧݼļ
	string tempGeolocAngelFile = tempFileName + "_geolocangel.tif";//Ƕݼļ
	string tempCloudFile = tempFileName + "_cloud.tif";//ļ
	string tempWaterFile = tempFileName + "_water.tif";//ˮļ
	string tempDarkPixelFile = tempFileName + "_darkpixel.tif";//Ԫļ
	string tempCutFile = tempFileName + "_cutimage.tif";//üָ
	//string tempImageCutFile =tempFileName + "d";//ü
	string tempSpaceFilter = tempFileName + "_spacefilter.tif";//ռ˲
#pragma endregion 		
#pragma region 2.ѧݼͽǶݼĺϳ
	//printf ("ʼѧݼͽǶݼĺϳ...\n");
	int createDataResult = AODCreateData (pszSrcFile2, pszSrcFile3, tempCreateDataFile.c_str ());//ϳɿѧݼ
	if (createDataResult != RE_SUCCESS)
	{
		return createDataResult;
	}
	int createAngelResult = AODCreateAngel (pszSrcFile2, pszSrcFile3, tempCreateAngelFile.c_str ());//ϳɵĽǶݼ
	if (createAngelResult != RE_SUCCESS)
	{
		return createAngelResult;
	}


#pragma endregion
#pragma region 3.ȡmodis3ĽϢ
	//char** geolocOptions=NULL;
	//geolocOptions = new char*[8];
	//for (int i=0;i<8;i++)
	//{
	//	geolocOptions[i]=new char[50];
	//}
	////char geolocOptions[8][50]={0};
	//int getGeolocResult =AODGetGeolocOfModis3(pszSrcFile3,&geolocOptions);
	//if (getGeolocResult!=RE_SUCCESS)
	//{
	//	return getGeolocResult;
	//}
#pragma region 3.1עݼ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *DS3 = (GDALDataset*)GDALOpen (pszSrcFile3, GA_ReadOnly);
	char **subdatasets = GDALGetMetadata ((GDALDatasetH)DS3, "SUBDATASETS");
#pragma endregion
#pragma region 3.2ȡγݼ͵һݼ
	string strSubDataset_1 = string (subdatasets[0]);//һݼ
	strSubDataset_1 = strSubDataset_1.substr (strSubDataset_1.find_first_of ("=") + 1);
	const char* SrcFile3_1 = strSubDataset_1.c_str ();

	string strLat = string (subdatasets[24]);//lat
	strLat = strLat.substr (strLat.find_first_of ("=") + 1);
	const char* charLat = strLat.c_str ();

	string strLon = string (subdatasets[26]);//lon
	strLon = strLon.substr (strLon.find_first_of ("=") + 1);
	const char* charLon = strLon.c_str ();
#pragma endregion 
#pragma region 3.3ȡһݼgeoloc
	GDALDataset *DS3_1 = (GDALDataset*)GDALOpen (SrcFile3_1, GA_ReadOnly);
	char **geolocOptions3 = DS3_1->GetMetadata ("GEOLOCATION");
	char **geolocOptions = geolocOptions3;
	// ݼûGEOLOCATIONԪݣôҪʹĴ˹ָ
	if (geolocOptions3 == NULL)
	{
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_OFFSET", "0");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_OFFSET", "0");
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "X_BAND", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "Y_BAND", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "X_DATASET", charLon);
		geolocOptions = CSLSetNameValue (geolocOptions, "Y_DATASET", charLat);
	}
	else
	{
		geolocOptions = CSLSetNameValue (geolocOptions, "PIXEL_STEP", "1");
		geolocOptions = CSLSetNameValue (geolocOptions, "LINE_STEP", "1");
	}
	GDALClose (GDALDatasetH (DS3));
#pragma endregion 	
#pragma endregion
#pragma region ѧݼͽǶݼ
	//printf ("ʼѧݼͽǶݼ...\n");
	const char* fileFormat = "GTiff";
	int geolocDataResult = ImageWarpByGeoLoc (tempCreateDataFile.c_str (), tempGeolocDataFile.c_str (), geolocOptions, GRA_NearestNeighbour, fileFormat);
	if (geolocDataResult != RE_SUCCESS)
	{
		return geolocDataResult;
	}
	int geolocAngelResult = ImageWarpByGeoLoc (tempCreateAngelFile.c_str (), tempGeolocAngelFile.c_str (), geolocOptions, GRA_NearestNeighbour, fileFormat);
	if (geolocAngelResult != RE_SUCCESS)
	{
		return geolocAngelResult;
	}
	////////////////////////////////////////////////////////////////////////////////////////////////////
		GDALClose(GDALDatasetH(DS3_1));//رݼ
#pragma endregion
#pragma region ʼ
	//printf ("ʼaodݼ...\n");
	AODInitialize (tempGeolocDataFile.c_str (), tempGeolocAngelFile.c_str ());
#pragma endregion
#pragma region ȡ
	AODGetSeason (pszSrcFile2);
#pragma endregion 
#pragma region ȥƺˮ
	AODIdentifyCloudAndWater ();
#pragma endregion
#pragma region ȷر
	AODConfirmSurfaceReflectance ();
#pragma endregion
#pragma region AODļ
	AODCalculate ();
#pragma endregion
#pragma region ߶Ƚ
	AODRectifyHeight ();
	
#pragma endregion
#pragma region AOD
	int aodShowResult = AODShow (tempGeolocDataFile.c_str (), tempCutFile.c_str (), tempSpaceFilter.c_str (), pszDstFile);
	if (aodShowResult != RE_SUCCESS)
	{
		return aodShowResult;
	}
	//ULLON='107.096';人
	// ULLAT='34.03'
	// LRLON='117.233'
	// LRLAT='27.177'
	/* double lonlat[4]= {107.096,117.233,27.177,24.03};
	int startX,startY,XSize,YSize;
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8","NO");
	GDALDataset *SrcDS =(GDALDataset*)GDALOpen(pszDstFile,)
	for (int i=0;i<height;i++)
	{
	for ( int j=0;j<width;j++)
	{
	if ()
	{
	}
	}
	}
	int aodImageCutResult =ImageCut(pszDstFile,tempImageCutFile.c_str(),startX,startY,XSize,YSize,"GTiff");
	if (aodImageCutResult!=RE_SUCCESS)
	{
	return aodImageCutResult;
	}*/
#pragma endregion
#pragma region мļɾ
	if (deleteFile == 0)
	{
		remove (tempCreateDataFile.c_str ());//ļ
		remove (tempCreateAngelFile.c_str ());//Ƕļ
		remove (tempGeolocDataFile.c_str ());//ļ
		remove (tempGeolocAngelFile.c_str ());//ĽǶļ
	}
	else if (deleteFile == 1)
	{

		AODOutputOther (tempGeolocDataFile.c_str (), tempCloudFile.c_str (), yun);
		AODOutputOther (tempGeolocDataFile.c_str (), tempWaterFile.c_str (), shui);
		AODOutputOther (tempGeolocDataFile.c_str (), tempDarkPixelFile.c_str (), anxiangyuan);
		remove (tempCreateDataFile.c_str ());//ļ
		remove (tempCreateAngelFile.c_str ());//Ƕļ
		remove (tempGeolocAngelFile.c_str ());//ĽǶļ
		remove(tempGeolocDataFile.c_str());
		remove(tempCloudFile.c_str());
		remove(tempWaterFile.c_str());
		remove(tempDarkPixelFile.c_str());
		remove(tempCutFile.c_str());
		remove(tempSpaceFilter.c_str());
	}
#pragma endregion 
#pragma region ͷԴ
	AODDestroy ();
#pragma endregion
	return RE_SUCCESS;
}
void PMGetSeason (const char* SrcFile2)
{
	//"E:\\fire2\\firetest\\MOD279\\0220\\MOD021KM.A2014279.0220.006.2014283045932.hdf";
	//AOD.MYD021KM.A2014279.0535.006.TIF
	string tempFileName = string (CPLGetFilename (SrcFile2));
	tempFileName = tempFileName.substr (tempFileName.find_last_of ("tif") - 15, 3);
	seasonDay = (double)CPLScanDouble (tempFileName.c_str (), 20);
}
int PM25Inversion (const char* pszAodFile, const char* pszDstFile, double ha, double rh)
{
	//AOD.MOD021KM.A2014195.0245.006.tif
	//const char* pszTempFile ="e:\\test\01060315.tif";
	//ha,rhж
	PMGetSeason(pszAodFile);
	//seasonDay = 6;

	if (ha == -1)
	{
		if (seasonDay>90 && seasonDay <273)
		{
			ha = 0.8;
		}
		else
		{
			ha = 0.5;
		}
	}
	if (rh == -1)
	{
		rh = 63;
	}

	//ݼȡϢ
	GDALAllRegister ();
	CPLSetConfigOption ("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen (pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize ();
	int YSize = AODDS->GetRasterYSize ();
	GDALDataType dataType = AODDS->GetRasterBand (1)->GetRasterDataType ();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform (geoTransForm);
	//̬
	//float **pmkadry;
	float **pmdata;
	float **pmresult;
	//pmkadry = new double*[YSize];
	pmdata = new float*[YSize];
	pmresult = new float*[YSize];
	for (int i = 0; i<YSize; i++)
	{
		//pmkadry[i] = new double[XSize];
		pmdata[i] = new float[XSize];
		pmresult[i] = new float[XSize];
	}
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand (1)->RasterIO (GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	int p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pmdata[i][j] = pBuf[p++] / 1000.0;
		}
	}
	//ϵ
	float aa = 28.981, bb = 18.1999;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			if (fabs(pmdata[i][j] -0.0) < MIN_VALUE)
			{
				pmresult[i][j] = 0.0;
			}
			else
			{
				pmresult[i][j] = (pmdata[i][j] * ha / (1 - rh / 100.0)) * aa + bb;
			}
			
		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName ("GTiff");
	//
	//GDALDriver *Driver2 = (GDALDriver*)GDALGetDriverByName ("GTiff");
	//GDALDataset *tempDstDS =Driver->Create(pszTempFile,XSize,YSize,1,dataType,NULL);
	GDALDataset *DstDS = Driver->Create (pszDstFile, XSize, YSize, 1, dataType, NULL);
	DstDS->SetGeoTransform (geoTransForm);
	//
	//tempDstDS->SetGeoTransform(geoTransForm);
	//tempDstDS->SetProjection(AODDS->GetProjectionRef());
	DstDS->SetProjection (AODDS->GetProjectionRef ());
	GDALSetRasterNoDataValue (GDALGetRasterBand (GDALDatasetH (DstDS), 1), 0.0);
	//		GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(tempDstDS),1),0.0);
	p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			  pBuf[p++]=pmresult[i][j];
			//pBuf[p++] = pmkadry[i][j];
		}
	}
	DstDS->GetRasterBand (1)->RasterIO (GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//
	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
	RELEASE(pBuf);
	GDALClose ((GDALDatasetH)DstDS);
	GDALClose ((GDALDatasetH)AODDS);
	//GDALClose((GDALDatasetH)tempDstDS);
	for (int i = 0; i<YSize; i++)
	{
		//RELEASE(pmkadry[i]);
		RELEASE(pmdata[i]);
		RELEASE(pmresult[i]);
	}
	//RELEASE(pmkadry);
	RELEASE(pmdata);
	RELEASE(pmresult);
	return RE_SUCCESS;
}
int PM10Inversion(const char* pszAodFile, const char* pszDstFile, double ha, double rh)
{
	//AOD.MOD021KM.A2014195.0245.006.tif
	//const char* pszTempFile ="e:\\test\01060315.tif";
	//ha,rhж
	PMGetSeason(pszAodFile);
	//seasonDay = 6;

	if (ha == -1)
	{
		if (seasonDay>90 && seasonDay <273)
		{
			ha = 0.8;
		}
		else
		{
			ha = 0.5;
		}
	}
	if (rh == -1)
	{
		rh = 63;
	}

	//ݼȡϢ
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen(pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize();
	int YSize = AODDS->GetRasterYSize();
	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform(geoTransForm);
	//̬
	//float **pmkadry;
	float **pmdata;
	float **pmresult;
	//pmkadry = new double*[YSize];
	pmdata = new float*[YSize];
	pmresult = new float*[YSize];
	for (int i = 0; i<YSize; i++)
	{
		//pmkadry[i] = new double[XSize];
		pmdata[i] = new float[XSize];
		pmresult[i] = new float[XSize];
	}
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	int p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pmdata[i][j] = pBuf[p++] / 1000.0;
		}
	}
	//ϵ
	float aa = 38.686, bb = 41.294;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			if (fabs(pmdata[i][j] - 0.0) < MIN_VALUE)
			{
				pmresult[i][j] = 0.0;
			}
			else
			{
				pmresult[i][j] = (pmdata[i][j] * ha / (1 - rh / 100.0)) * aa + bb;
			}

		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
	//
	//GDALDriver *Driver2 = (GDALDriver*)GDALGetDriverByName("GTiff");
	//GDALDataset *tempDstDS =Driver->Create(pszTempFile,XSize,YSize,1,dataType,NULL);
	GDALDataset *DstDS = Driver->Create(pszDstFile, XSize, YSize, 1, dataType, NULL);
	DstDS->SetGeoTransform(geoTransForm);
	//
	//tempDstDS->SetGeoTransform(geoTransForm);
	//tempDstDS->SetProjection(AODDS->GetProjectionRef());
	DstDS->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS), 1), 0.0);
	//		GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(tempDstDS),1),0.0);
	p = 0;
	for (int i = 0; i<YSize; i++)
	{
		for (int j = 0; j<XSize; j++)
		{
			pBuf[p++] = pmresult[i][j];
			//pBuf[p++] = pmkadry[i][j];
		}
	}
	DstDS->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//
	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
	RELEASE(pBuf);
	GDALClose((GDALDatasetH)DstDS);
	GDALClose((GDALDatasetH)AODDS);
	//GDALClose((GDALDatasetH)tempDstDS);
	for (int i = 0; i<YSize; i++)
	{
		//RELEASE(pmkadry[i]);
		RELEASE(pmdata[i]);
		RELEASE(pmresult[i]);
	}
	//RELEASE(pmkadry);
	RELEASE(pmdata);
	RELEASE(pmresult);
	return RE_SUCCESS;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
int Haze(const char* pszAodFile, const char* pszDstFile1 , const char* pszDstFile2)
{

	enum MySeasonType
	{
		unknow = 0,
		spring = 1,
		summer = 2,
		autumn = 3,
		winter = 4

	};
	MySeasonType myseason; 
	////////////////////////////////////////////////////////////////////////////////////////////////////
	const float chengmi_spring_a = 4.9704, chengmi_spring_b = - 0.68;
	const float chengmi_summer_a = 5.323,  chengmi_summer_b = -0.9902;
	const float chengmi_autumn_a = 4.5399, chengmi_autumn_b = -0.568;
	const float chengmi_winter_a = 2.9976, chengmi_winter_b = -0.557;

	const float biaogao_spring_a = 0.8132, biaogao_spring_b = -0.2214;
	const float biaogao_summer_a = 0.7669, biaogao_summer_b = -0.4898;
	const float biaogao_autumn_a = 0.7402, biaogao_autumn_b = -0.1166;
	const float biaogao_winter_a = 0.3682, biaogao_winter_b = -0.2144;
///////////////////////////////////////////////////////////////////////////////////////////////////////
	float chengmi_a, chengmi_b;   //a ϵ4.9704 bη //ݷabϵ
	float biaogao_a, biaogao_b; // ߷abϵa(0.8132) b0.2214
	/*
	Spring summer and autumn winter
				ݷ
	ڣ		v =4.9704 *^(-0.68)
	ڣļ		v =5.323  *^(-0.902)
	ڣ＾		v =4.5399 *^(-0.568)
	ڣ   	v =2.9976 *^(-0.557)
	*/
	
	/*
				߷
		V=3.1912*0.8132/(-0.2214)
	ļ	V=3.1912*0.7669/(-0.4898)
	＾	V=3.1912*0.7402/(-0.1166)
		V=3.1912*0.0.3682/(-0.2144)

	*/
	/*
	

	    V<=1km    RH>95%

	   1km<v<10km  RH>95%

	ϼ    v<10km    80%<RH<95%
		V<10km     RH<80%
	//////////////////////////////////////////
	΢      5.0<=v<10
	      3.0<=V<5.0
	ж      2.0<=V<3.0
	ض       V<2.0

	*/
	//PMGetSeason(pszAodFile);
	if (seasonDay >= 60 && seasonDay < 152)
	{
		myseason = spring;
		chengmi_a = chengmi_spring_a;
		chengmi_b = chengmi_spring_b;
		biaogao_a = biaogao_spring_a;
		biaogao_b = biaogao_spring_b;
	}
	else if (seasonDay >= 152 && seasonDay < 244)
	{
		myseason = summer;
		chengmi_a = chengmi_summer_a;
		chengmi_b = chengmi_summer_b;
		biaogao_a = biaogao_summer_a;
		biaogao_b = biaogao_summer_b;

	}
	else if (seasonDay >= 244 && seasonDay < 335)
	{
		myseason = autumn;
		chengmi_a = chengmi_autumn_a;
		chengmi_b = chengmi_autumn_b;
		biaogao_a = biaogao_autumn_a;
		biaogao_b = biaogao_autumn_b;
	}
	else 
	{
		myseason = winter;
		chengmi_a = chengmi_winter_a;
		chengmi_b = chengmi_winter_b;
		biaogao_a = biaogao_winter_a;
		biaogao_b = biaogao_winter_b;
	}
	//
	////////////////////////////////
	//myseason = summer; 
	//a = 5.323;
	//b = -0.902;
	//a = 0.7669;//
	//b = 0.4898;//

	
	myseason = spring;
	chengmi_a = chengmi_spring_a;
	chengmi_b = chengmi_spring_b;
	biaogao_a = biaogao_spring_a;
	biaogao_b = biaogao_spring_b;
	
	/*myseason = summer;
	chengmi_a = chengmi_summer_a;
	chengmi_b = chengmi_summer_b;
	biaogao_a = biaogao_summer_a;
	biaogao_b = biaogao_summer_b;*/
		////////////////////////////////
	//ݼȡϢ
	GDALAllRegister();
	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
	GDALDataset *AODDS = (GDALDataset*)GDALOpen(pszAodFile, GA_ReadOnly);
	int XSize = AODDS->GetRasterXSize();
	int YSize = AODDS->GetRasterYSize();
	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
	double geoTransForm[6] = { 0 };
	AODDS->GetGeoTransform(geoTransForm);
	float *pBuf = new float[XSize*YSize];
	//ȡ
	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	
	//߽
	/*
			V = 3.1912*0.8132 / ( - 0.2214)
		ļ	V = 3.1912*0.7669 / ( - 0.4898)
		＾	V = 3.1912*0.7402 / ( - 0.1166)
			V = 3.1912*0.0.3682 / ( - 0.2144)
		*/
	for (int i = 0; i < XSize*YSize; i++)
	{
		if (pBuf[i]< MIN_VALUE && pBuf[i] > -MIN_VALUE) //nodata
		{
			pBuf[i] = 0;
		}
		else
		{
			pBuf[i] = 3.912* biaogao_a / (pBuf[i]- biaogao_b);
			if (pBuf[i]< 0) 
			{
				pBuf[i] = 15;
			}
			else if (pBuf[i] >15)
			{
				pBuf[i] = 15;
			}
		}
	}
	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
	GDALDataset *DstDS1 = Driver->Create(pszDstFile1, XSize, YSize, 1, dataType, NULL);
	GDALDataset *DstDS2 = Driver->Create(pszDstFile2, XSize, YSize, 1, dataType, NULL);
	DstDS1->SetGeoTransform(geoTransForm);
	DstDS1->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS1), 1), 0.0);
	DstDS1->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);



	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	//ݽ
	/*
	    ڣ		v = 4.9704 *t ^ (-0.68)
		ڣļ		v = 5.323  *t ^ (-0.902)
		ڣ＾		v = 4.5399 *t ^ (-0.568)
		ڣ   	v = 2.9976 *t ^ (-0.557)
		*/
	for (int i = 0; i < XSize*YSize; i++)
	{
		if (pBuf[i]< MIN_VALUE && pBuf[i] > -MIN_VALUE) //nodata
		{
			pBuf[i] = 0;
		}
		else
		{
			pBuf[i] = chengmi_a * pow(pBuf[i] , chengmi_b);
			if (pBuf[i]< 0) 
			{
				pBuf[i] = 15;
			}
			else if (pBuf[i] >15)
			{
				pBuf[i] = 15;
			}
		}
	}

	DstDS2->SetGeoTransform(geoTransForm);
	DstDS2->SetProjection(AODDS->GetProjectionRef());
	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS2), 1), 0.0);
	DstDS2->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
	RELEASE(pBuf);
	GDALClose((GDALDatasetH)DstDS1);
	GDALClose((GDALDatasetH)DstDS2);
	GDALClose((GDALDatasetH)AODDS);
	return RE_SUCCESS;
}



//int FillingEmptyValue(const char* inFile, const char* outFile)
//{
//	GDALAllRegister();
//	CPLSetConfigOption("GDAL_FILENAME_IS_UTF8", "NO");
//	GDALDataset *AODDS = (GDALDataset*)GDALOpen(inFile, GA_ReadOnly);
//	int XSize = AODDS->GetRasterXSize();
//	int YSize = AODDS->GetRasterYSize();
//	GDALDataType dataType = AODDS->GetRasterBand(1)->GetRasterDataType();
//	double geoTransForm[6] = { 0 };
//	AODDS->GetGeoTransform(geoTransForm);
//	float **pmdata;
//	float **pmresult;
//	//pmkadry = new double*[YSize];
//	pmdata = new float*[YSize];
//	pmresult = new float*[YSize];
//	for (int i = 0; i<YSize; i++)
//	{
//		//pmkadry[i] = new double[XSize];
//		pmdata[i] = new float[XSize];
//		pmresult[i] = new float[XSize];
//	}
//	float *pBuf = new float[XSize*YSize];
//	//ȡ
//	AODDS->GetRasterBand(1)->RasterIO(GF_Read, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
//	int p = 0;
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			pmdata[i][j] = pBuf[p++] / 1000.0;
//		}
//	}
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			if (fabs(pmdata[i][j] - 0.0) < MIN_VALUE)
//			{
//				//pmresult[i][j] = SearchValue(i,j)
//
//			}
//			else
//			{
//				pmresult[i][j] = pmdata[i][j];
//			}
//
//		}
//	}
//	GDALDriver *Driver = (GDALDriver*)GDALGetDriverByName("GTiff");
//	GDALDataset *DstDS = Driver->Create(outFile, XSize, YSize, 1, dataType, NULL);
//	DstDS->SetGeoTransform(geoTransForm);
//	DstDS->SetProjection(AODDS->GetProjectionRef());
//	GDALSetRasterNoDataValue(GDALGetRasterBand(GDALDatasetH(DstDS), 1), 0.0);
//	p = 0;
//	for (int i = 0; i<YSize; i++)
//	{
//		for (int j = 0; j<XSize; j++)
//		{
//			pBuf[p++] = pmresult[i][j];
//			//pBuf[p++] = pmkadry[i][j];
//		}
//	}
//	DstDS->GetRasterBand(1)->RasterIO(GF_Write, 0, 0, XSize, YSize, pBuf, XSize, YSize, dataType, 0, 0);
//	//
//	//tempDstDS->GetRasterBand(1)->RasterIO(GF_Write,0,0,XSize,YSize,pBuf,XSize,YSize,dataType,0,0);
//	RELEASE(pBuf);
//	GDALClose((GDALDatasetH)DstDS);
//	GDALClose((GDALDatasetH)AODDS);
//	//GDALClose((GDALDatasetH)tempDstDS);
//	for (int i = 0; i<YSize; i++)
//	{
//		//RELEASE(pmkadry[i]);
//		RELEASE(pmdata[i]);
//		RELEASE(pmresult[i]);
//	}
//	//RELEASE(pmkadry);
//	RELEASE(pmdata);
//	RELEASE(pmresult);
//	return RE_SUCCESS;
//
//}



