clear all
close all

load PressVess

Position=[200 200 900 600];
TitleSz=24; LblSz=20; AxSz=16;
MkFig=0; % Set to 1 to save JPEG figures
Res='-r600';
NL=sprintf('\n');

aa=find(IsSolid==1); bb=find(IsSolid==0);
TimeFct=mean(TimeFct');

del=1.10;
axismat=[(del*min(X0(:,1))) (del*max(X0(:,1))) (del*min(X0(:,2))) (del*max(X0(:,2)))];

ha=figure(1);
set(gcf,'Position',Position)
set(0,'DefaultAxesFontSize',AxSz,'DefaultAxesFontWeight','b')
plot(X0(aa,1),X0(aa,2),'*',X0(bb,1),X0(bb,2),'o','Linewidth',2)
axis(axismat);
%legend('Hertz','SPAM','Location','Best');
title('Before Simulation','fontsize',LblSz,'fontweight','b');
ylabel('Y (m)','fontsize',LblSz,'fontweight','b')
xlabel('X (m)','fontsize',LblSz,'fontweight','b');
if MkFig==1
    print(ha,'-djpeg','Start.jpeg',Res)
    close all
end

ha=figure(2);
set(gcf,'Position',Position)
set(0,'DefaultAxesFontSize',AxSz,'DefaultAxesFontWeight','b')
plot(Xdat(end,aa),Ydat(end,aa),'*',Xdat(end,bb),Ydat(end,bb),'o','Linewidth',2)
axis(axismat);
%legend('Hertz','SPAM','Location','Best');
title('After Simulation','fontsize',LblSz,'fontweight','b');
ylabel('Y (m)','fontsize',LblSz,'fontweight','b')
xlabel('X (m)','fontsize',LblSz,'fontweight','b');
if MkFig==1
    print(ha,'-djpeg','Final.jpeg',Res)
    close all
end

Xr2=Xr;
for ii=1:length(Xr2)
    Xr2(:,ii)=Xr(:,ii)-Xr(1,ii);
end

ha=figure(3);
set(gcf,'Position',Position)
set(0,'DefaultAxesFontSize',AxSz,'DefaultAxesFontWeight','b')
plot(TimeFct*(1e6),-Xr2(:,bb)*(1e9),'Linewidth',2)
title('Radial Displacement - Liquid','fontsize',LblSz,'fontweight','b');
ylabel(['\delta'  'R (nm)'],'fontsize',LblSz,'fontweight','b')
xlabel(['Time (' '{\mu}' 's)'],'fontsize',LblSz,'fontweight','b');
if MkFig==1
    print(ha,'-djpeg','Rfct_Liquid.jpeg',Res)
    close all
end

ha=figure(4);
set(gcf,'Position',Position)
set(0,'DefaultAxesFontSize',AxSz,'DefaultAxesFontWeight','b')
plot(TimeFct*(1e6),-Xr2(:,aa)*(1e9),'Linewidth',2)
title('Radial Displacement - Solid','fontsize',LblSz,'fontweight','b');
ylabel(['\delta'  'R (nm)'],'fontsize',LblSz,'fontweight','b')
xlabel(['Time (' '{\mu}' 's)'],'fontsize',LblSz,'fontweight','b');
if MkFig==1
    print(ha,'-djpeg','Rfct_Solid.jpeg',Res)
    close all
end

